# Temario

## Programación multiproceso:
 -	Ejecutables. Procesos. Servicios.
 -	Estados de un proceso.
 -	Hilos.
 -	Programación concurrente.
 -	Programación paralela y distribuida.
 -	Comunicación entre procesos.
 -	Gestión de procesos.
 -	Sincronización entre procesos.
 -	Programación de aplicaciones multiproceso.

# Posibles proyectos final de ciclo

- Automatizar la Cadena de valor de una empresa
- Reconocimiento de matrículas

# Enunciado del proyecto de la asignatura

- Realizar un proyecto sobre la temática que más interese al alumno teniendo en cuenta:
  - Procesos
  - Programación concurrente, multihilo en conexiones simultaneas
  - Login (hash)
  - Sockets seguros (certificado)
  - Seguridad

# Situaciones
- Projects https://www.jesusninoc.com/projects/
- Send information between server and clients (read web, encrypt and create HTML)
https://www.jesusninoc.com/2014/04/16/send-information-between-server-and-clients-read-web-encrypt-and-create-html/
- Crear una web sencilla en Chrome mediante datos URIs desde PowerShell
https://www.jesusninoc.com/2018/08/17/crear-una-web-sencilla-en-chrome-mediante-datos-uris-desde-powershell/
- Crear una web sencilla en Chrome mediante datos URIs codificados en Base64 desde PowerShell
https://www.jesusninoc.com/2018/07/18/crear-una-web-sencilla-en-chrome-mediante-datos-uris-codificados-en-base64-desde-powershell/
- Convertir el fichero XML con la lista de series y películas de Netflix en un fichero JSON utilizando PHP desde PowerShell
https://www.jesusninoc.com/2018/07/19/convertir-el-fichero-xml-con-la-lista-de-series-y-peliculas-de-netflix-en-un-fichero-json-utilizando-php-desde-powershell/
- Mostrar y generar en tiempo real una tabla HTML con el valor nutricional (azúcares) de todos los fabricantes de un producto encontrado en la tienda online de un supermercado en PowerShell
https://www.jesusninoc.com/2018/07/18/mostrar-y-generar-en-tiempo-real-una-tabla-html-con-el-valor-nutricional-azucares-de-todos-los-fabricantes-de-un-producto-encontrado-en-la-tienda-online-de-un-supermercado-en-powershell/

-----------------------
-----------------------

# Introducción a PSP

## Repaso de conceptos para manejar las shells (instalar Ubuntu Server)
   - Compilar y ejecutar
   - Path y Classpath https://docs.oracle.com/javase/tutorial/essential/environment/paths.html
   - PowerShell
   - Rutas
   - Pipe
   - Ejecutar dos comandos
   - Almacenar la ejecución de un comando

# Ejemplos repaso introducción
## Lanzar un programa en Java
```Java
import java.io.IOException;

public class P2
{
	public static void main(String[] args) throws IOException
	{
		ProcessBuilder pb = new ProcessBuilder(args);
		pb.start();
	}
}
```
### Compilar y ejecutar
```CMD
javac P2.java
java -cp . P2 notepad
```

## Lanzar un programa creado en Java desde Java
```Java
import java.io.IOException;

public class proceso{
	public static void main(String[] args)
	{
		ProcessBuilder pb = new ProcessBuilder("cmd", "/C", "java -cp . ThreadA > hola.txt");
		try
		{
			pb.start();
			}
		catch (IOException e)
		{
			System.out.println(e.getMessage());
			}
		}
	}
```

## Lanzar un programa desde PowerShell utilizando C#
```PowerShell
$CodigoC = @”
 
public class Proceso
{
public static void Main()
{
System.Diagnostics.Process.Start( @"C:\Windows\System32\Notepad.exe" );
}
}
 
“@
 
Add-Type -TypeDefinition $CodigoC -ErrorAction SilentlyContinue
 
[Proceso]::Main()
```

## Pasar parámetros en scripts (PowerShell y Bash)
### PowerShell
* https://www.jesusninoc.com/02/17/pasar-parametros-en-scripts-de-powershell/
### Bash
* https://www.jesusninoc.com/02/17/pasar-parametros-en-scripts-de-bash/

# Monitorización de aplicaciones Java con VisualVM
https://www.jesusninoc.com/08/21/monitorizacion-de-aplicaciones-java-con-visualvm/

# Crear, compilar y ejecutar una clase de Java que ejecuta un cmdlet de PowerShell utilizando Runtime
https://www.jesusninoc.com/02/08/crear-compilar-y-ejecutar-una-clase-de-java-que-ejecuta-un-cmdlet-de-powershell-utilizando-runtime/

# Crear, compilar, generar y ejecutar un JAR de Java que ejecuta un cmdlet de PowerShell utilizando Runtime
https://www.jesusninoc.com/02/09/crear-compilar-generar-y-ejecutar-un-jar-de-java-que-ejecuta-un-cmdlet-de-powershell-utilizando-runtime/
