# Generación de servicios en red:
 -	Protocolos estándar de comunicación en red a nivel de aplicación (telnet, ftp, http, pop3, smtp, entre otros).
 -	Librerías de clases y componentes.
 -	Utilización de objetos predefinidos.
 -	Establecimiento y finalización de conexiones.
 -	Transmisión de información.
 -	Programación de aplicaciones cliente.
 - Programación de servidores.
 -	Implementación de comunicaciones simultáneas.

# POP3
## Conectarse a un servidor POP3 local
```Java
import java.util.Properties;
import javax.mail.*;
import javax.mail.internet.*;

public class JavaMailPop3Reader {

  public static void main(String args[]) throws Exception {

    // mail server connection parameters
    String host = "pop.mail.yahoo.com";
    String user = "USERNAME";
    String password = "PASSWORD";

    // connect to my pop3 inbox
    Properties properties = System.getProperties();
    Session session = Session.getDefaultInstance(properties);
    Store store = session.getStore("pop3");
    store.connect(host, user, password);
    Folder inbox = store.getFolder("Inbox");
    inbox.open(Folder.READ_ONLY);

    // get the list of inbox messages
    Message[] messages = inbox.getMessages();

    if (messages.length == 0) System.out.println("No messages found.");

    for (int i = 0; i < messages.length; i++) {
      // stop after listing ten messages
      if (i > 10) {
        System.exit(0);
        inbox.close(true);
        store.close();
      }

      System.out.println("Message " + (i + 1));
      System.out.println("From : " + messages[i].getFrom()[0]);
      System.out.println("Subject : " + messages[i].getSubject());
      System.out.println("Sent Date : " + messages[i].getSentDate());
      System.out.println();
    }

    inbox.close(true);
    store.close();
  }
}
```

# SSH
## Instalar servidor SSH
https://www.cyberciti.biz/faq/ubuntu-linux-install-openssh-server/
## Conectar vía SSH con Java
http://programacion.net/articulo/conectar_via_ssh_con_java_1163

--------------------

# Utilización de técnicas de programación segura:
 -	Prácticas de programación segura.
 -	Criptografía de clave pública y clave privada.
 -	Principales aplicaciones de la criptografía.
 -	Protocolos criptográficos.
 -	Política de seguridad.
 -	Programación de mecanismos de control de acceso.
 -	Encriptación de información.
 -	Protocolos seguros de comunicaciones.
 -	Programación de aplicaciones con comunicaciones seguras.

# Codificar

## Base64
### Codificar en Base64 paso a paso con PowerShell
https://www.jesusninoc.com/2017/01/13/codificar-en-base64-paso-a-paso-con-powershell/
### Codificar un string en Base64
https://www.jesusninoc.com/2016/09/22/codificar-un-string-en-base64/
### Ejecutar en Java un cmdlet de PowerShell en Base64
https://www.jesusninoc.com/2018/02/10/ejecutar-en-java-un-cmdlet-de-powershell-en-base64/
### Datos URIs
https://developer.mozilla.org/es/docs/Web/HTTP/Basics_of_HTTP/Datos_URIs
### Bash Bunny Phishing Attack With Hamsters - Hak5 2306
https://www.youtube.com/watch?v=TYR2a2XoK3A
### Realizar una redirección con JavaScript utilizando Start-Process y Google Chrome
https://www.jesusninoc.com/2017/02/06/realizar-una-redireccion-con-javascript-utilizando-start-process-y-google-chrome-2/

# The Security Manager
https://docs.oracle.com/javase/tutorial/essential/environment/security.html

## Mostrar propiedades (java.class.path", "java.home", "java.vendor", "java.version", "os.name", "os.version", "user.dir", "user.home", "user.name") sin utilizar el gestor de seguridad
```Java
public class Ejemplo1 {
	public static void main(String[] args) {	
		String t[] = { "java.class.path", "java.home", "java.vendor",
				 "java.version", "os.name", "os.version",
				"user.dir", "user.home", "user.name" };
        
		for (int i = 0; i < t.length; i++) {
			System.out.print("Propiedad:" + t[i]);
			try {
				String s = System.getProperty(t[i]);
				System.out.println("\t==> " + s);
			} catch (Exception e) {
				System.err.println("\n\tExcepción " + e.toString());
			}
		}// for
	}
}//..Ejemplo1
```
## Ejecutar desde JVM "The Security Manager"
```CMD
java -Djava.security.manager Ejemplo1
```

## Mostrar propiedades teniendo en cuenta "The Security Manager"
```Java
public class Ejemplo1SM {
	public static void main(String[] args) {	
		String t[] = { "java.class.path", "java.home", "java.vendor",
				 "java.version", "os.name", "os.version",
				"user.dir", "user.home", "user.name" };
		
		System.setSecurityManager(new SecurityManager()); 
		
		for (int i = 0; i < t.length; i++) {
			System.out.print("Propiedad:" + t[i]);
			try {
				String s = System.getProperty(t[i]);
				System.out.println("\t==> " + s);
			} catch (Exception e) {
				System.err.println("\n\tExcepción " + e.toString());
			}
		}// for
	}
}//..Ejemplo1
//java -Djava.security.policy=Politica1.policy Ejemplo1
```

## Ejemplo de conexión Servidor con "The Security Manager"
```Java
import java.io.*;
import java.net.*;

public class ejemplo1Servidor {
	public static void main(String[] arg) throws IOException {
		int numeroPuerto = 6000;// Puerto
		ServerSocket servidor = null;
        System.setSecurityManager(new SecurityManager());
		try {
		servidor = new ServerSocket(numeroPuerto);

		
		Socket clienteConectado = null;
		System.out.println("Esperando al cliente....."+servidor.getLocalPort());
		System.out.println("Esperando al cliente....."+servidor.getLocalSocketAddress());
		clienteConectado = servidor.accept();
	    System.out.println("Adios al cliente....."+clienteConectado.getPort());
	    System.out.println("Adios al cliente2....."+clienteConectado.getLocalPort());
		
		clienteConectado.close();
		servidor.close();
		} catch (Exception e) {
				System.err.println("ERROR=> " + e.toString());
			}

	}// main
}// fin
```

# Ficheros de políticas en Java
## Ejemplo crear un fichero
```Java
import java.io.*;
public class Ejemplo2 {
   public static void main(String[] args) {
   System.setSecurityManager(new SecurityManager());
	try {
		//escritura en fichero		
		BufferedWriter fichero = new BufferedWriter
		   (new FileWriter("D://Ficheros//Fichero.txt"));
		fichero.write("Escritura de una linea en fichero.");
		fichero.newLine(); // escribe un salto de línea
		fichero.close();
		System.out.println("Final proceso de escritura...");

		//lectura en fichero
		BufferedReader fichero2 = new BufferedReader
              (new FileReader("D://Ficheros//Fichero.txt"));
		String linea = fichero2.readLine();
		System.out.println("Contenido del fichero: ");
		System.out.println("\t" + linea);
		fichero2.close();
		System.out.println("Final proceso de lectura...");
			
	} catch (FileNotFoundException fn) {
		System.out.println("No se encuentra el fichero");
	} catch (IOException io) {
		System.out.println("Error de E/S ");
	} catch ( Exception e) {		
	    System.out.println("ERROR => " + e.toString());			
	}

   }// main
}//..Ejemplo2
```
### Fichero Politica2.policy
```Java
grant {
  permission java.io.FilePermission "<<ALL FILES>>", "read, write, delete";
}; 
```
## Ejemplo para aplicar permisos a sockets
```Java
import java.net.*;
public class Ejemplo3Servidor {
	public static void main(String[] arg) {
		int numeroPuerto = 6000;// Puerto
		ServerSocket servidor = null;
		
		//System.setProperty ("java.security.policy", 	"D:\\CAPIT5\\Politica4.policy");
        System.setSecurityManager(new SecurityManager());
		
		try {
		  servidor = new ServerSocket(numeroPuerto);		
		  System.out.println("Esperando al cliente.....");
		  Socket clienteConectado = servidor.accept();	    
	      System.out.println("Cliente conectado.");		
		  clienteConectado.close();
		  System.out.println("Cliente desconectado.");
		  servidor.close();
		} catch (Exception e) {
				System.err.println("ERROR=> " + e.toString());
		}
	}// main
}//..Ejemplo3Servidor
```
### Fichero Politica2.policy
```Java
grant {
  permission java.net.SocketPermission "localhost", "accept";
};
```
