# Utilización de técnicas de programación segura:
 -	Prácticas de programación segura.
 -	Criptografía de clave pública y clave privada.
 -	Principales aplicaciones de la criptografía.
 -	Protocolos criptográficos.
 -	Política de seguridad.
 -	Programación de mecanismos de control de acceso.
 -	Encriptación de información.
 -	Protocolos seguros de comunicaciones.
 -	Programación de aplicaciones con comunicaciones seguras.

# Introducción a hash

## Realizar hashes parciales sobre un fichero
https://github.com/jesusninoc/PowerShell/blob/master/Seguridad/Realizar%20hashes%20parciales%20sobre%20un%20fichero.ps1

## Realizar una función de hash sobre varios ficheros
https://www.jesusninoc.com/2018/02/04/realizar-una-funcion-de-hash-sobre-varios-ficheros/

## Fuzzy hashing API and fuzzy hashing tool 
https://github.com/ssdeep-project/ssdeep

## Generar un resumen de un texto plano MD5
```Java
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.*;

public class Ejemplo04
{

    public static void main(String[] args)
    {
        MessageDigest md;
        try
        {
            md = MessageDigest.getInstance("MD5", Security.getProvider("SUN"));      //funcionaria si  lo quitamos
            //md = MessageDigest.getInstance("MD5");   
            String texto = "Esto es un texto plano.";   //string a capturar
            byte dataBytes[] = texto.getBytes();        //obtenemos los bytes
            md.update(dataBytes);                       //actualizamos el mesagediges
            byte resume[] = md.digest();                //Calcula el resumen
            // Información
            System.out.println("Original: " + texto);
            System.out.println("Número de Bytes: " + md.getDigestLength());
            System.out.println("Algoritmo: " + md.getAlgorithm());
            System.out.println("Mensaje resumen: " + new String(resume));
            System.out.println("Hexadecimal: " + Hexadecimal(resume));
            System.out.println(MessageDigest.isEqual(dataBytes, ("esto es un texto plano.").getBytes()));

            // Proveedor
            Provider proveedor = md.getProvider();
            System.out.println("Proveedor: " + proveedor.toString());
        } catch (NoSuchAlgorithmException e)
        {
            e.printStackTrace();
        }
    }

    static String Hexadecimal(byte[] resumen)
    {
        String hex = "";
        for (int i = 0; i < resumen.length; i++)
        {
            String h = Integer.toHexString(resumen[i] & 0xFF);
            if (h.length() == 1)
            {
                hex += "0";
            }
            hex += h;
        }
        return hex.toUpperCase();
    }
}
```

## Hash a password with SHA-512 in Java
```Java
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public String get_SHA_512_SecurePassword(String passwordToHash, String   salt){
String generatedPassword = null;
    try {
         MessageDigest md = MessageDigest.getInstance("SHA-512");
         md.update(salt.getBytes(StandardCharsets.UTF_8));
         byte[] bytes = md.digest(passwordToHash.getBytes(StandardCharsets.UTF_8));
         StringBuilder sb = new StringBuilder();
         for(int i=0; i< bytes.length ;i++){
            sb.append(Integer.toString((bytes[i] & 0xff) + 0x100, 16).substring(1));
         }
         generatedPassword = sb.toString();
        } 
       catch (NoSuchAlgorithmException e){
        e.printStackTrace();
       }
    return generatedPassword;
}
```

## HMAC
En la criptografía, un código de autentificación de mensajes en clave-hash (HMAC) es una construcción específica para calcular un código de autentificación de mensaje (MAC) que implica una función hash criptográfica en combinación con una llave criptográfica secreta. Como cualquier MAC, puede ser utilizado para verificar simultáneamente la integridad de los datos y la autentificación de un mensaje. Cualquier función hash criptográfica, tales como MD5 o SHA-1, puede ser utilizada para el cálculo de un HMAC; el algoritmo MAC resultante se denomina HMAC-MD5 o HMAC-SHA1 en consecuencia. La fuerza criptográfica del HMAC depende de la potencia criptográfica de la función de hash subyacente, el tamaño de su salida de hash y el tamaño y calidad de la llave.

## Generar HMAC-SHA256 con PowerShell
https://www.jesusninoc.com/2018/02/18/generar-hmac-sha256-con-powershell/

## CCN-STIC-807 – Criptografía de empleo en el ENS
|Tipo de Algoritmo| Acreditados por el CCN|
|--|--
|Cifrado Simétrico|TDEA (Triple Data Encryption Algorithm)
||AES (Advanced Encryption Standard)
|Algoritmos Asimétricos|DSA (Digital Signature Algorithm)
||ECDSA (Elliptic Curve Digital Signature Algorithm)
||RSA (Criptosistema RSA)
||ECIES (Elliptic Curve Integrated Encryption Scheme)
|Intercambio de Clave|DH o DHKA (Diffie-Hellman Key Agreement)
||MQV (Menezes-Qu-Vanstone Key Agreement)
||ECDH (Elliptic Curve Diffie-Hellman)
||ECMQV (Elliptic Curve Menezes-Qu-Vanstone)
|Funciones resumen (Hash)|SHA-2 (Secure Hash Algorithm)
||HMAC (Hash Message Authentication Code )

## HASHES GENERATOR
https://www.onlinehashcrack.com/hash-generator.php

## Crack hashes in seconds
https://github.com/s0md3v/Hash-Buster

## Reverse hash (MD5/SHA1)
https://www.jesusninoc.com/2016/02/02/reverse-hash-md5-sha1/

## PoC para detectar colisión en SHA1 con PowerShell
http://www.jesusninoc.com/2017/02/24/poc-para-detectar-colision-en-sha1-con-powershell/

## Practical collision attack against SHA-1
https://isc.sans.edu/forums/diary/Practical+collision+attack+against+SHA1/22109/

## Cracking de contraseñas con hashcat
https://www.securityartwork.es/2017/02/15/cracking-contrasenas-hashcat/
