# Utilización de técnicas de programación segura:
 -	Prácticas de programación segura.
 -	Criptografía de clave pública y clave privada.
 -	Principales aplicaciones de la criptografía.
 -	Protocolos criptográficos.
 -	Política de seguridad.
 -	Programación de mecanismos de control de acceso.
 -	Encriptación de información.
 -	Protocolos seguros de comunicaciones.
 -	Programación de aplicaciones con comunicaciones seguras.

----------------------

# Ejemplos libro capítulo 6
https://drive.google.com/file/d/11ID2FiuFgByP_xFEBnDnD6v6XZtwag1Q/view

----------------------

# Introducción a la criptografía
https://www.jesusninoc.com/2017/02/01/criptografia-en-powershell/

# Píldora formativa 2: ¿Qué es la criptografía?
# Píldora formativa 5: ¿Qué es la tríada CIA?

----------------------

# Introducción a la criptografía
https://www.jesusninoc.com/2017/02/01/criptografia-en-powershell/

# Píldora formativa 2: ¿Qué es la criptografía?
# Píldora formativa 5: ¿Qué es la tríada CIA?
# Píldora formativa 6: ¿Ciframos, codificamos o encriptamos?

----------------------

# Fallos de seguridad con Java

## OWASP
https://www.owasp.org/index.php/Category:Java

## Lanzar un programa del sistema operativo como argumento desde la línea de comandos
https://www.jesusninoc.com/08/28/lanzar-un-programa-del-sistema-operativo-como-argumento-desde-la-linea-de-comandos/

## java.lang.Runtime.exec() Payload Workarounds
http://jackson.thuraisamy.me/runtime-exec-payloads.html

## A proof-of-concept tool for generating payloads that exploit unsafe Java object deserialization
* http://frohoff.github.io/appseccali-marshalling-pickles/
* https://github.com/frohoff/ysoserial/

----------------------

# The Security Manager
https://docs.oracle.com/javase/tutorial/essential/environment/security.html

## Mostrar propiedades (java.class.path", "java.home", "java.vendor", "java.version", "os.name", "os.version", "user.dir", "user.home", "user.name")
```Java
public class Ejemplo1 {
	public static void main(String[] args) {	
		String t[] = { "java.class.path", "java.home", "java.vendor",
				 "java.version", "os.name", "os.version",
				"user.dir", "user.home", "user.name" };
        
		for (int i = 0; i < t.length; i++) {
			System.out.print("Propiedad:" + t[i]);
			try {
				String s = System.getProperty(t[i]);
				System.out.println("\t==> " + s);
			} catch (Exception e) {
				System.err.println("\n\tExcepción " + e.toString());
			}
		}// for
	}
}//..Ejemplo1
//java -Djava.security.policy=Politica1.policy Ejemplo1
```

## Mostrar propiedades teniendo en cuenta "The Security Manager"
```Java
public class Ejemplo1SM {
	public static void main(String[] args) {	
		String t[] = { "java.class.path", "java.home", "java.vendor",
				 "java.version", "os.name", "os.version",
				"user.dir", "user.home", "user.name" };
		
		System.setSecurityManager(new SecurityManager()); 
		
		for (int i = 0; i < t.length; i++) {
			System.out.print("Propiedad:" + t[i]);
			try {
				String s = System.getProperty(t[i]);
				System.out.println("\t==> " + s);
			} catch (Exception e) {
				System.err.println("\n\tExcepción " + e.toString());
			}
		}// for
	}
}//..Ejemplo1
//java -Djava.security.policy=Politica1.policy Ejemplo1
```

## Ejemplo de conexión Servidor con "The Security Manager"
```Java
import java.io.*;
import java.net.*;

public class ejemplo1Servidor {
	public static void main(String[] arg) throws IOException {
		int numeroPuerto = 6000;// Puerto
		ServerSocket servidor = null;
        System.setSecurityManager(new SecurityManager());
		try {
		servidor = new ServerSocket(numeroPuerto);

		
		Socket clienteConectado = null;
		System.out.println("Esperando al cliente....."+servidor.getLocalPort());
		System.out.println("Esperando al cliente....."+servidor.getLocalSocketAddress());
		clienteConectado = servidor.accept();
	    System.out.println("Adios al cliente....."+clienteConectado.getPort());
	    System.out.println("Adios al cliente2....."+clienteConectado.getLocalPort());
		
		clienteConectado.close();
		servidor.close();
		} catch (Exception e) {
				System.err.println("ERROR=> " + e.toString());
			}

	}// main
}// fin
```

----------------------

# Ficheros de políticas en Java
## Ejemplo crear un fichero
```Java
import java.io.*;
public class Ejemplo2 {
   public static void main(String[] args) {
   System.setSecurityManager(new SecurityManager());
	try {
		//escritura en fichero		
		BufferedWriter fichero = new BufferedWriter
		   (new FileWriter("D://Ficheros//Fichero.txt"));
		fichero.write("Escritura de una linea en fichero.");
		fichero.newLine(); // escribe un salto de línea
		fichero.close();
		System.out.println("Final proceso de escritura...");

		//lectura en fichero
		BufferedReader fichero2 = new BufferedReader
              (new FileReader("D://Ficheros//Fichero.txt"));
		String linea = fichero2.readLine();
		System.out.println("Contenido del fichero: ");
		System.out.println("\t" + linea);
		fichero2.close();
		System.out.println("Final proceso de lectura...");
			
	} catch (FileNotFoundException fn) {
		System.out.println("No se encuentra el fichero");
	} catch (IOException io) {
		System.out.println("Error de E/S ");
	} catch ( Exception e) {		
	    System.out.println("ERROR => " + e.toString());			
	}

   }// main
}//..Ejemplo2
```
### Fichero Politica2.policy
```Java
grant codeBase "file:D:/CAPIT5/"{ 
    permission java.io.FilePermission "D:\\Ficheros\\*", "read,write";
}; 
```
## Ejemplo para aplicar permisos a sockets
```Java
import java.net.*;
public class Ejemplo3Servidor {
	public static void main(String[] arg) {
		int numeroPuerto = 6000;// Puerto
		ServerSocket servidor = null;
		
		//System.setProperty ("java.security.policy", 	"D:\\CAPIT5\\Politica4.policy");
        System.setSecurityManager(new SecurityManager());
		
		try {
		  servidor = new ServerSocket(numeroPuerto);		
		  System.out.println("Esperando al cliente.....");
		  Socket clienteConectado = servidor.accept();	    
	      System.out.println("Cliente conectado.");		
		  clienteConectado.close();
		  System.out.println("Cliente desconectado.");
		  servidor.close();
		} catch (Exception e) {
				System.err.println("ERROR=> " + e.toString());
		}
	}// main
}//..Ejemplo3Servidor
```
### Fichero Politica2.policy
```Java
grant codeBase "file:D:/CAPIT5/" {
  permission java.net.SocketPermission "localhost:6000", "connect";
};
```

----------------------

# Codificar
## Base64
### Codificar en Base64 paso a paso con PowerShell
https://www.jesusninoc.com/2017/01/13/codificar-en-base64-paso-a-paso-con-powershell/
### Codificar un string en Base64
https://www.jesusninoc.com/2016/09/22/codificar-un-string-en-base64/
### Ejecutar en Java un cmdlet de PowerShell en Base64
https://www.jesusninoc.com/2018/02/10/ejecutar-en-java-un-cmdlet-de-powershell-en-base64/
### Datos URIs
https://developer.mozilla.org/es/docs/Web/HTTP/Basics_of_HTTP/Datos_URIs
### Bash Bunny Phishing Attack With Hamsters - Hak5 2306
https://www.youtube.com/watch?v=TYR2a2XoK3A
### Realizar una redirección con JavaScript utilizando Start-Process y Google Chrome
https://www.jesusninoc.com/2017/02/06/realizar-una-redireccion-con-javascript-utilizando-start-process-y-google-chrome-2/

----------------------

# Introducción a hash

## Realizar hashes parciales sobre un fichero
https://github.com/jesusninoc/PowerShell/blob/master/Seguridad/Realizar%20hashes%20parciales%20sobre%20un%20fichero.ps1

## Realizar una función de hash sobre varios ficheros
https://www.jesusninoc.com/2018/02/04/realizar-una-funcion-de-hash-sobre-varios-ficheros/

## Fuzzy hashing API and fuzzy hashing tool 
https://github.com/ssdeep-project/ssdeep

## Hash a password with SHA-512 in Java
```Java
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public String get_SHA_512_SecurePassword(String passwordToHash, String   salt){
String generatedPassword = null;
    try {
         MessageDigest md = MessageDigest.getInstance("SHA-512");
         md.update(salt.getBytes(StandardCharsets.UTF_8));
         byte[] bytes = md.digest(passwordToHash.getBytes(StandardCharsets.UTF_8));
         StringBuilder sb = new StringBuilder();
         for(int i=0; i< bytes.length ;i++){
            sb.append(Integer.toString((bytes[i] & 0xff) + 0x100, 16).substring(1));
         }
         generatedPassword = sb.toString();
        } 
       catch (NoSuchAlgorithmException e){
        e.printStackTrace();
       }
    return generatedPassword;
}
```
## HASHES GENERATOR
https://www.onlinehashcrack.com/hash-generator.php

## Crack hashes in seconds
https://github.com/s0md3v/Hash-Buster

----------------------

# Analizar class
- JD-GUI
https://www.jesusninoc.com/02/10/jd-gui/
- .JAR and .Class to Java decompiler
http://www.javadecompilers.com/
# Analizar apk y buscar datos en los ficheros
- Infected Android Games Spread Adware to More Than 4.5 Million Users
https://www.bleepingcomputer.com/news/security/infected-android-games-spread-adware-to-more-than-4-5-million-users/
- Descargar apk
https://apkpure.com/es/search?q=com.example
- Cómo utilizar Apktool
https://www.jesusninoc.com/2016/02/25/como-utilizar-apktool/
- Analizar permisos de un .apk
https://www.jesusninoc.com/2015/12/08/analizar-permisos-de-un-apk/
- ReverseAPK - Quickly Analyze And Reverse Engineer Android Packages
https://www.kitploit.com/2018/05/reverseapk-quickly-analyze-and-reverse.html

## Buscar información en los ficheros generados al utilizar Apktool
### Buscar la cadena "php"
```PowerShell
Get-ChildItem *.* -Recurse | % {gc $_ | Select-String "php"}
```
### Buscar direcciones IP
```PowerShell
Get-ChildItem *.* -Recurse | % {gc $_ | Select-String "\b\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}\b"}
```
### Buscar rutas HTTP, FTP
```PowerShell
Get-ChildItem *.* -Recurse | % {gc $_ | Select-String "\b(ht|f)tp(s?)[^ ]*\.[^ ]*(\/[^ ]*)*\b"}
```

----------------------

# HMAC
En la criptografía, un código de autentificación de mensajes en clave-hash (HMAC) es una construcción específica para calcular un código de autentificación de mensaje (MAC) que implica una función hash criptográfica en combinación con una llave criptográfica secreta. Como cualquier MAC, puede ser utilizado para verificar simultáneamente la integridad de los datos y la autentificación de un mensaje. Cualquier función hash criptográfica, tales como MD5 o SHA-1, puede ser utilizada para el cálculo de un HMAC; el algoritmo MAC resultante se denomina HMAC-MD5 o HMAC-SHA1 en consecuencia. La fuerza criptográfica del HMAC depende de la potencia criptográfica de la función de hash subyacente, el tamaño de su salida de hash y el tamaño y calidad de la llave.

## Generar HMAC-SHA256 con PowerShell
https://www.jesusninoc.com/2018/02/18/generar-hmac-sha256-con-powershell/

# CCN-STIC-807 – Criptografía de empleo en el ENS
|Tipo de Algoritmo| Acreditados por el CCN|
|--|--
|Cifrado Simétrico|TDEA (Triple Data Encryption Algorithm)
||AES (Advanced Encryption Standard)
|Algoritmos Asimétricos|DSA (Digital Signature Algorithm)
||ECDSA (Elliptic Curve Digital Signature Algorithm)
||RSA (Criptosistema RSA)
||ECIES (Elliptic Curve Integrated Encryption Scheme)
|Intercambio de Clave|DH o DHKA (Diffie-Hellman Key Agreement)
||MQV (Menezes-Qu-Vanstone Key Agreement)
||ECDH (Elliptic Curve Diffie-Hellman)
||ECMQV (Elliptic Curve Menezes-Qu-Vanstone)
|Funciones resumen (Hash)|SHA-2 (Secure Hash Algorithm)
||HMAC (Hash Message Authentication Code )

# Reverse hash (MD5/SHA1)
https://www.jesusninoc.com/2016/02/02/reverse-hash-md5-sha1/

# PoC para detectar colisión en SHA1 con PowerShell
http://www.jesusninoc.com/2017/02/24/poc-para-detectar-colision-en-sha1-con-powershell/

# Practical collision attack against SHA-1
https://isc.sans.edu/forums/diary/Practical+collision+attack+against+SHA1/22109/

# Cracking de contraseñas con hashcat
https://www.securityartwork.es/2017/02/15/cracking-contrasenas-hashcat/

----------------------

# Cifrado simétrico
- TDEA (Triple Data Encryption Algorithm)
- AES (Advanced Encryption Standard)

```Java
/* Con clave aleatoria */

import javax.crypto.*;    
import java.security.*;  

public class Java {

	private static SecretKey key = null;         
	private static Cipher cipher = null; 

	public static void main(String[] args) throws Exception
	{
		KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
		keyGenerator.init(128);
		SecretKey secretKey = keyGenerator.generateKey();
		cipher = Cipher.getInstance("AES");

		String clearText = "hola";
		byte[] clearTextBytes = clearText.getBytes("UTF8");
		System.out.println("Texto en claro: " + clearText);
		System.out.println("Texto en Bytes claro: " + clearTextBytes);

		cipher.init(Cipher.ENCRYPT_MODE, secretKey);
		byte[] cipherBytes = cipher.doFinal(clearTextBytes);
		String cipherText = new String(cipherBytes, "UTF8");
		System.out.println("Texto cifrado: " + cipherText);
		System.out.println("Texto en Bytes cifrado: " + cipherBytes);

		cipher.init(Cipher.DECRYPT_MODE, secretKey);
		byte[] decryptedBytes = cipher.doFinal(cipherBytes);
		String decryptedText = new String(decryptedBytes, "UTF8");
		System.out.println("Texto descifrado: " + decryptedText);
		System.out.println("Texto en Bytes cifrado: " + decryptedBytes);
	}
}
```

```Java
/* Con clave añadida*/

import javax.crypto.*;
import javax.crypto.spec.SecretKeySpec;
import java.security.*;
import java.util.Base64;

public class Java {

	private static Cipher cipher = null; 

	public static void main(String[] args) throws Exception{
		// Clave -> Clave en base 64
		// 1234567891234567 -> MTIzNDU2Nzg5MTIzNDU2Nw==
		// decode the base64 encoded string
		byte[] decodedKey = Base64.getDecoder().decode("MTIzNDU2Nzg5MTIzNDU2Nw==");
		
		// rebuild key using SecretKeySpec
		SecretKey originalKey = new SecretKeySpec(decodedKey, 0, decodedKey.length, "AES");
		System.out.println("originalKey: " + decodedKey);
		
		cipher = Cipher.getInstance("AES");

		String clearText = "hola";
		byte[] clearTextBytes = clearText.getBytes("UTF8");
		System.out.println("Texto en claro: " + clearText);

		cipher.init(Cipher.ENCRYPT_MODE, originalKey);
		byte[] cipherBytes = cipher.doFinal(clearTextBytes);
		String cipherText = new String(cipherBytes, "UTF8");
		System.out.println("Texto cifrado: " + cipherText);

		cipher.init(Cipher.DECRYPT_MODE, originalKey);
		byte[] decryptedBytes = cipher.doFinal(cipherBytes);
		String decryptedText = new String(decryptedBytes, "UTF8");
		System.out.println("Texto descifrado: " + decryptedText);
	}
}
```

----------------------

# Algoritmos asimétricos
- DSA (Digital Signature Algorithm)
- ECDSA (Elliptic Curve Digital Signature Algorithm)
- RSA (Criptosistema RSA)

```Java
import javax.crypto.*;
import java.security.*;
public class ExampleRSA {

	public static void main(String[] args) {
		try {
			KeyPairGenerator keygen = KeyPairGenerator.getInstance("RSA");
			KeyPair keypair = keygen.generateKeyPair();
			
			Cipher rsaCipher = Cipher.getInstance("RSA");
			
			String mensaje = "Mensajeo";
			
			rsaCipher.init(Cipher.ENCRYPT_MODE, keypair.getPrivate());
			byte[] mensajeCifrado = rsaCipher.doFinal(mensaje.getBytes("UTF8"));
			System.out.println(mensajeCifrado);
			
			rsaCipher.init(Cipher.DECRYPT_MODE, keypair.getPublic());
			byte[] mensajeDescifrado = rsaCipher.doFinal(mensajeCifrado);
			String mensajeDescifrado2 = new String(mensajeDescifrado, "UTF8");
			System.out.println(mensajeDescifrado2);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
```

- ECIES (Elliptic Curve Integrated Encryption Scheme)

----------------------

# Técnicas simples
- Transposición
- Sustitución

----------------------

# Análisis de frecuencias
## Código de Java - Contar las veces que aparece una palabra en un texto
```Java
import java.util.StringTokenizer;
import java.util.Scanner;
 
class PalabrasRepetidas {
 
	public static void main(String[] args) {
 
		//Creamos un objeto de la clase Scanner para leer por teclado
		Scanner miScanner = new Scanner(System.in);
 
		System.out.println("Introduce una frase: ");
 
		//Se almacena el texto introducido en la variable frase y pasa el
		//texto todo a minúsculas
		String frase = miScanner.nextLine().toLowerCase();
 
		//Se crea el objeto tok de la clase StringTokenizer
		StringTokenizer tok = new StringTokenizer(frase);
 
		//Variable que almacenará la palabra que queramos bucar
		String palabraBuscar;
 
		//Variable que almacena el número de veces que aparece la palabra
		int contador = 0;
 
		System.out.print("Introduce la palabra a contar: ");
 
		//Se introduce la palabra a buscar pasándola toda a minúscula
		palabraBuscar = miScanner.nextLine().toLowerCase();
 
		/*
		Bucle while que se repetirá mientras que existan tokens. Dentro del
		bucle se crea un condicional if que compara si el elemento es igual a
		la palabra a buscar. En caso de que así se el contador aumentará en uno
		*/
		while(tok.hasMoreTokens()) {
			if(tok.nextElement().equals(palabraBuscar)) {
				contador++;
			}
		}
 
		System.out.println("La frase '" + frase + "'\ncontine " + contador + " veces la palabra '" + palabraBuscar + "'");
 
	}
 
}
```

----------------------

## PowerShell
### Criptografía en PowerShell
https://www.jesusninoc.com/2017/02/01/criptografia-en-powershell/
- Análisis de frecuencias de letras en un texto con PowerShell (parte 1)
- Análisis de frecuencias de letras en un texto con PowerShell (parte 2)
- Análisis de frecuencias de letras en un texto con PowerShell (parte 3)
- Análisis de frecuencias de palabras en un texto con PowerShell (parte 4)
- Análisis de frecuencias de palabras en el libro „El ingenioso hidalgo Don Quijote de la Mancha“ con PowerShell (parte 5)
- Análisis de frecuencias de letras en el libro “El ingenioso hidalgo Don Quijote de la Mancha” con PowerShell (parte 6)
- Análisis de frecuencias de letras en el libro “El Principito” con PowerShell (parte 6)
- Análisis de frecuencias de letras en el libro “The Comedy of Errors” con PowerShell (parte 6)
- Análisis y representación de frecuencias de letras en el libro “El ingenioso hidalgo Don Quijote de la Mancha” con PowerShell (parte 7)
- Cifrar de forma sencilla el libro “El ingenioso hidalgo Don Quijote de la Mancha” con PowerShell (parte 8)
- Análisis y representación de frecuencias de letras en el libro “El ingenioso hidalgo Don Quijote de la Mancha” cifrado y sin cifrar con PowerShell (parte 9)
- Cifrar de forma compleja el libro “El ingenioso hidalgo Don Quijote de la Mancha” con PowerShell (parte 10)

###  Aproximación al cifrado y descifrado en PowerShell
https://www.jesusninoc.com/2017/02/23/aproximacion-al-cifrado-y-descifrado-en-powershell/

----------------------

# Criptoanálisis
- Criptoanálisis básico con PowerShell (parte 1)
- Criptoanálisis básico con PowerShell (parte 2)

----------------------

# 3DES is Officially Being Retired
https://www.cryptomathic.com/news-events/blog/3des-is-officially-being-retired

----------------------

# Certificates

## Creates a new self-signed certificate
https://www.jesusninoc.com/2017/11/06/creates-a-new-self-signed-certificate/

## Encrypts content by using the Cryptographic Message Syntax format
https://www.jesusninoc.com/2017/11/10/encrypts-content-by-using-the-cryptographic-message-syntax-format/

## Decrypts content that has been encrypted by using the Cryptographic Message Syntax format
https://www.jesusninoc.com/2017/11/12/decrypts-content-that-has-been-encrypted-by-using-the-cryptographic-message-syntax-format/

## Exports a certificate to a Personal Information Exchange (PFX) file
https://www.jesusninoc.com/2017/11/18/exports-a-certificate-to-a-personal-information-exchange-pfx-file/

## Imports certificates and private keys from a Personal Information Exchange (PFX) file to the destination store
https://www.jesusninoc.com/2017/11/20/imports-certificates-and-private-keys-from-a-personal-information-exchange-pfx-file-to-the-destination-store/

## Proof of concept framework for transferring a file over x509 extension covert channel
https://github.com/fideliscyber/x509

## SSL Server Test
https://www.ssllabs.com/ssltest/analyze.html?d=www.jesusninoc.com

## Install Let's Encrypt to Create SSL Certificates
https://linode.com/docs/security/ssl/install-lets-encrypt-to-create-ssl-certificates/

## Automatically Renew SSL Certificates (Optional)
https://linode.com/docs/security/ssl/install-lets-encrypt-to-create-ssl-certificates/#automatically-renew-ssl-certificates-optional

## The Illustrated TLS Connection
https://tls.ulfheim.net/

----------------------

# Socket SSL
## To Use keytool to Create a Server Certificate
https://docs.oracle.com/cd/E19798-01/821-1841/gjrgy/index.html
## Socket SSL con Java 
http://chuwiki.chuidiang.org/index.php?title=Socket_SSL_con_Java
## SSL/TLS for dummies part 3 – Understanding Certificate Authority
https://www.wst.space/ssl-part-3-certificate-authority/

----------------------

# Formularios en Google Docs

## Utilizar JSON con nombres y apellidos aleatorios
https://www.jesusninoc.com/2018/02/04/utilizar-json-con-nombres-y-apellidos-aleatorios/

## Enviar datos a un formulario de Google Docs desde PowerShell
https://www.jesusninoc.com/2017/03/11/enviar-datos-a-un-formulario-de-google-docs-desde-powershell/

## Enviar datos a un formulario de Google Docs desde PowerShell (deducir los parámetros que se envían por POST)
https://www.jesusninoc.com/2017/04/30/enviar-datos-a-un-formulario-de-google-docs-desde-powershell-deducir-los-parametros-que-se-envian-por-post/

## Acceder a los datos publicados en un formulario de Google desde PowerShell
https://www.jesusninoc.com/2017/05/01/acceder-a-los-datos-publicados-en-un-formulario-de-google-desde-powershell/
