# Programación multihilo:
 -	Recursos compartidos por los hilos.
 -	Estados de un hilo. Cambios de estado.
 -	Elementos relacionados con la programación de hilos. Librerías y clases.
 -	Gestión de hilos.
 -	Sincronización de hilos.
 -	Compartición de información entre hilos.
 -	Programación de aplicaciones multihilo.

# Estado de hilo
* https://github.com/mememiguelo/PSP/blob/master/JAVA/MultiHilos/HiloEjemplo1_V2.java
* https://github.com/mememiguelo/PSP/blob/master/JAVA/MultiHilos/UsaHiloEjemplo1_V2.java

# Pausar hilo
* https://github.com/mememiguelo/PSP/blob/master/JAVA/MultiHilos/UsaHilo_Sleep.java

# Join
* https://github.com/mememiguelo/PSP/blob/master/JAVA/MultiHilos/HiloEjemplo_Alive.java
* https://github.com/mememiguelo/PSP/blob/master/JAVA/MultiHilos/UsaHilo_Alive.java
* https://www.journaldev.com/1024/java-thread-join-example

# Prioridad con hilos
* https://github.com/mememiguelo/PSP/blob/master/EjemploHiloPrioridad1.java
```Java
/*
Prioridad entero entre 1 y 10
1 mínima -->MIN_PRIORITY
5 medio --> NORM_PRIORITY
10 máxima --> MAX_PRIORITY
2 hilos igual prioridad round-robbin
*/

class HiloPrioridad1 extends Thread {
	//propiedades	
	private int c=0; //vble contador
	private boolean stopHilo=false; //boolean parar contador hilo

public int getContador(){
	return c;
	}

public void pararHilo(){
	stopHilo=true;
	}
public void run(){
	while (!stopHilo) c++;
	}

}
```

# Interrupting a Thread
* http://www.javatpoint.com/interrupting-a-thread
* https://compiler.javatpoint.com/opr/test.jsp?filename=TestInterruptingThread1

## Interrupción de un hilo
```Java
public class HiloEjemploInterrup extends Thread {

  public void run() {
    try {
      while (!isInterrupted()) {
        System.out.println("En el hilo");
        Thread.sleep(100);
      }
    } catch (InterruptedException e) {
      System.out.println("Ha ocurrido una excepción");
    }
    System.out.println("Fin de hilo");
  }

  public void interrumpir() {
    interrupt();
  }

  public static void main(String[] args) {
    	HiloEjemploInterrup h = new HiloEjemploInterrup();
    	h.start();
    	for(int i=0;i<1000000;i++){}
    	h.interrumpir();
  }
}
```
