# Programación multiproceso:
 -	Ejecutables. Procesos. Servicios.
 -	Estados de un proceso.
 -	Hilos.
 -	Programación concurrente.
 -	Programación paralela y distribuida.
 -	Comunicación entre procesos.
 -	Gestión de procesos.
 -	Sincronización entre procesos.
 -	Programación de aplicaciones multiproceso.

# Conceptos:
 - Pipes
   - Sin nombre
     - https://www.jesusninoc.com/2018/08/03/c-programming-in-linux-tutorial-037-pipe-function/
   - Con nombre
     - https://github.com/mememiguelo/PSP/blob/master/C/Otros/Fifo.c
     - https://github.com/mememiguelo/PSP/blob/master/C/Otros/fifocrea.c
     - https://github.com/mememiguelo/PSP/blob/master/C/Otros/fifoescribe.c
 - Sincronizar procesos
 - Señales
 - Creación procesos Java
 - Programación concurrente
 - Condiciones de Bernstein
 - Programación paralela
 - Memorias compartidas
 - Semáforos
 - Programación distribuida
 
---------------------

# Descriptores
|Valor|entero|Nombre
|---|---|---
|0|Entrada estándar|stdin
|1|Salida estándar|stdout
|2|Error estándar|stderr

# Pipes
## Sin nombre
### Cuando el flujo de información va del hijo hacia el padre:
- El padre debe cerrar el descriptor de escritura fd[1].
- El hijo debe cerrar el descriptor de lectura fd[0].
### El proceso hijo envía al proceso padre mediante el uso de pipes el mensaje "Hola papi"
```C
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

void main(){

     int fd[2];
     char buffer[30];
     pid_t pid;

     //#include<unistd.h>
     // int pipe(int fd[2]);
     // fd[0] contiene el descriptor para lectura

     pipe(fd); // Se crea el PIPE
     pid = fork();

     switch(pid){
     
          case -1: // Error
                printf("No se ha podido crear un hijo \n");
                exit(-1);
                break;
          case 0: // Hijo
                close(fd[0]); // Cierra el descriptor que no va a usar. El de lectura
                printf("El hijo escribe en el PIPE... \n");
                write(fd[1], "Hola papi", 10);
                break;
          default: // Padre
                close(fd[1]); // Cierra el descriptor de escritura
                wait(NULL); // Espera a que finalice el hijo
                printf("El padre lee el PIPE \n");
                read(fd[0], buffer, 10);
                printf("\t Mensaje leido: %s \n", buffer);
     }
}
```
### Cuando el flujo de información va del padre hacia el hijo:
- El padre debe cerrar el descriptor de lectura fd[0].
- El hijo debe cerrar el descriptor de escritura fd[1].
### El proceso padre envía al proceso hijo mediante el uso de pipes el mensaje "Buenos dias hijo"
```C
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include<string.h>

int main(void)
{
	int fd[2];
	pid_t pid;

	char saludoPadre []="\n MENSAJE=> Buenos dias hijo.";
	char buffer[80];

	pipe(fd); //creo pipe

	pid =fork(); //creo proceso

	switch(pid)
	{
		case -1 : //ERROR
			printf("NO SE HA PODIDO CREAR HIJO ... ");
			exit(-1);
		case 0://HIJO RECIBE
			close(fd[1]);//cierra el descriptor de escritura
			read(fd[0],buffer,sizeof(buffer)); //leo el pipe 
			printf("El HIJO recibe algo del pipe: %s\n",buffer);
			break;
		default ://PADRE ENVIA
			close(fd[0]);
			write(fd[1], saludoPadre,strlen(saludoPadre));//escribo en pipe
			printf("El PADRE ENVIA MENSAJE AL HIJO ...\n");
			wait(NULL); //espero al proceso hijo
			break;
	}

	return 0;
}
```
* https://github.com/mememiguelo/PSP/blob/master/C/Otros/comunicacionPadreHijo.c
* https://github.com/mememiguelo/PSP/blob/master/C/Otros/comunicacionPadreHijo2.c
* https://www.jesusninoc.com/2018/08/03/c-programming-in-linux-tutorial-037-pipe-function/
## Con nombre
### mknod
http://man7.org/linux/man-pages/man2/mknod.2.html
### mknod (Bash)
```Bash
mknod FIFO p
l -l FIFO
cat FIFO
l > FIFO
```
### mknod (C)
```C
#include <unistd.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>

mknod("FIFO1",S_IFIFO|0660,0);
```
* https://github.com/mememiguelo/PSP/blob/master/C/Otros/fifocrea.c
* https://github.com/mememiguelo/PSP/blob/master/C/Otros/fifoescribe.c

---------------------

# Memorias compartidas
## Uso de las funciones ftok(), shmget(), shmat() y shmctl()
https://github.com/jesusninoc/ClasesPSP/blob/master/2017-10-24.md

## Programación de memorias compartidas en Linux
https://www.jesusninoc.com/2015/07/10/programacion-de-memorias-compartidas-en-linux/

## Utilizar zonas de memoria compartida en Linux mediante WSL desde PowerShell
https://www.jesusninoc.com/2018/06/25/utilizar-zonas-de-memoria-compartida-en-linux-mediante-wsl-desde-powershell/

## Relación con memoria
https://github.com/jesusninoc/ClasesPSP/blob/master/2017-10-12.md

## Volcado de memoria
https://github.com/jesusninoc/ClasesPSP/blob/master/2017-10-19.md

---------------------

# Ensamblador
## SPIM: A MIPS32 Simulator
https://github.com/jesusninoc/ClasesPSP/blob/master/2017-10-26.md

## Suma de números en ensamblador
https://github.com/jesusninoc/ClasesPSP/blob/master/2017-10-05.md

## Analizar con Cheat Engine un payload de ejecución de comandos arbitrarios para ejecutar PowerShell
https://www.jesusninoc.com/2017/03/20/analizar-con-cheat-engine-un-payload-de-ejecucion-de-comandos-arbitrarios-para-ejecutar-powershell/

---------------------

# Ktmutil
## Starts the Kernel Transaction Manager utility. If used without parameters, ktmutil displays available subcommands
```PowerShell
Ktmutil tm list
Ktmutil tm info
Ktmutil tx list
Ktmutil tx info
ktmutil tm info {f5a10f48-72be-11e5-8250-40167e1612ab}
Ktmutil list tms
```
