# Programación multiproceso:
 -	Ejecutables. Procesos. Servicios.
 -	Estados de un proceso.
 -	Hilos.
 -	Programación concurrente.
 -	Programación paralela y distribuida.
 -	Comunicación entre procesos.
 -	Gestión de procesos.
 -	Sincronización entre procesos.
 -	Programación de aplicaciones multiproceso.

# Conceptos:
 - Comunicación entre procesos
 - Pipes
   - Sin nombre
     - https://www.jesusninoc.com/2018/08/03/c-programming-in-linux-tutorial-037-pipe-function/
     - https://www.geeksforgeeks.org/pipe-system-call/
   - Con nombre
     - https://github.com/mememiguelo/PSP/blob/master/C/Otros/Fifo.c
     - https://github.com/mememiguelo/PSP/blob/master/C/Otros/fifocrea.c
     - https://github.com/mememiguelo/PSP/blob/master/C/Otros/fifoescribe.c
 - Sincronizar procesos
 - Señales
 - Creación procesos Java
 - Programación concurrente
 - Condiciones de Bernstein
 - Programación paralela
 - Memorias compartidas
 - Semáforos
 - Programación distribuida

---------------------

# Procesos en Linux

## Programación de procesos en Linux
https://www.jesusninoc.com/2015/01/02/programacion-de-procesos/

## Crear un proceso hijo mediante la función fork de Linux (en Bash y en PowerShell mediante WSL)
https://www.jesusninoc.com/2018/07/04/crear-un-proceso-hijo-mediante-la-funcion-fork-de-linux-en-bash-y-en-powershell-mediante-wsl/

## Crear un hijo
https://github.com/mememiguelo/PSP/blob/master/C/Otros/PadreHijo.c

## Crear un proceso en el que el padre resta un valor y el hijo suma un valor
```PowerShell
$codigo = '#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>

int main(int argc, char *argv[]){
    pid_t pid1;
    int status1;
    int numero=6;

    if ( (pid1=fork()) == 0 ){ /* hijo */
        numero +=5;
        printf(\"Soy el hijo Valor variable %d \\n\",numero);
    }else{ /* padre */
        numero -=5;
        printf(\"Soy el padre Valor variable %d \\n\",numero);
    }
    return 0;
}'

wsl echo $codigo > hola.c
bash -c "iconv hola.c -f UTF-16 -t UTF-8 > holas.c"
wsl gcc holas.c
wsl "./a.out"
```

## Crear dos hijos
https://github.com/mememiguelo/PSP/blob/master/C/Otros/Padrehijo2.c

## Crear un hijo y un hijo del hijo
https://github.com/mememiguelo/PSP/blob/master/C/Otros/Padrehijonieto.c

---------------------

# Llamadas al sistema
## Llamadas al sistema en UNIX
https://github.com/jesusninoc/ClasesPSP/blob/master/2017-10-25.md
## ptrace - rastreo de un proceso
* http://manpages.ubuntu.com/manpages/trusty/es/man2/ptrace.2.html
* https://www.linuxjournal.com/article/6100
## Linux Commands For Shared Library Management & Debugging Problem
https://www.cyberciti.biz/tips/linux-shared-library-management.html
## wait, waitpid, waitid - wait for process to change state
http://man7.org/linux/man-pages/man2/waitpid.2.html
