# Introducción a PSP

## Repaso de conceptos para manejar las shells (instalar Ubuntu Server)
   - SSH, conexión de red que permita acceder
   - Instalar compilador GCC
   - Compilar y ejecutar
   - Path y Classpath https://docs.oracle.com/javase/tutorial/essential/environment/paths.html
   - PowerShell
   - Rutas
   - Pipe
   - Ejecutar dos comandos
   - Almacenar la ejecución de un comando

-----------------

# Programación multiproceso:
 -	Ejecutables. Procesos. Servicios.
 -	Estados de un proceso.
 -	Hilos.
 -	Programación concurrente.
 -	Programación paralela y distribuida.
 -	Comunicación entre procesos.
 -	Gestión de procesos.
 -	Sincronización entre procesos.
 -	Programación de aplicaciones multiproceso.

# Conceptos:
 - Multiproceso
 - BCP

# Función main en C
## Convert the char in command line argument into int type
https://www.jesusninoc.com/2015/10/08/convert-the-char-in-command-line-argument-into-int-type/


# Función main en Java
```Java
public class Test{
    public static void main(String[] args) {
        String[] x = {"1","2","3"};
        System.out.print("3".equals(x[2]));
        System.out.print("3".equals(args[2]));
    }
}
```

## How do I compare strings in Java?
https://stackoverflow.com/questions/513832/how-do-i-compare-strings-in-java

```Java
public class Test{
    public static void main(String[] args) {
        "test".equals("test")
    }
}
```

## Java – Convert String to int
https://www.mkyong.com/java/java-convert-string-to-int/

## Command-Line Arguments
https://docs.oracle.com/javase/tutorial/essential/environment/cmdLineArgs.html

## Strings In Java
https://androidexample.com/Strings_In_Java/index.php?view=article_discription&aid=149&aaid=163

# Kotlin

## Función main en Kotlin

```Kotlin
/**
 * Line 13 demonstrates string templates and array access.
 * See this pages for details:
 * http://kotlinlang.org/docs/reference/basic-types.html#strings
 * http://kotlinlang.org/docs/reference/basic-types.html#arrays
 */

fun main(args: Array<String>) {
    if (args.size == 0) {
        println("Please provide a name as a command-line argument")
        return
    }
    println("Hello, ${args[0]}!")
}
```

## Creating Collections In Kotlin
https://try.kotlinlang.org/#/Kotlin%20in%20Action/Chapter%203/3.1/3.1_2_CreatingCollectionsInKotlin1.kt
```Kotlin
fun main(args: Array<String>) {
    val strings = listOf("first", "second", "fourteenth")
    println(strings.last())
    val numbers = setOf(1, 14, 2)
    println(numbers.max())
}
```

## Get location android Kotlin
https://stackoverflow.com/questions/45958226/get-location-android-kotlin

---------------------

# Programación multiproceso:
 -	Ejecutables. Procesos. Servicios.
 -	Estados de un proceso.
 -	Hilos.
 -	Programación concurrente.
 -	Programación paralela y distribuida.
 -	Comunicación entre procesos.
 -	Gestión de procesos.
 -	Sincronización entre procesos.
 -	Programación de aplicaciones multiproceso.

# Conceptos:
 - Multiproceso
 - BCP
 - Process status
 - Estados de un proceso
 - System
 - Funciones
 - Función main
 - Creación y ejecución de procesos
 - Padre crear hijo
 - Comunicación entre procesos
 - Pipes
   - Sin nombre
     - https://www.jesusninoc.com/2018/08/03/c-programming-in-linux-tutorial-037-pipe-function/
   - Con nombre
     - https://github.com/mememiguelo/PSP/blob/master/C/Otros/Fifo.c
     - https://github.com/mememiguelo/PSP/blob/master/C/Otros/fifocrea.c
     - https://github.com/mememiguelo/PSP/blob/master/C/Otros/fifoescribe.c
 - Sincronizar procesos
 - Señales
 - Creación procesos Java
 - Programación concurrente
 - Condiciones de Bernstein
 - Programación paralela
 - Memorias compartidas
 - Semáforos
 - Programación distribuida
 
 ---------------
 
# Repaso
## Lanzar programa que ejecute ping
* https://www.jesusninoc.com/02/17/ejercicios-de-java-lanzar-programa-que-ejecute-ping/

## Lanzar programa que ejecute un ping dos veces
* https://www.jesusninoc.com/02/17/ejercicios-de-java-lanzar-programa-que-ejecute-un-ping-dos-veces/

### Ejecutar y compilar en Java
-cp <ruta de acceso de búsqueda de clases de los directorios y los archivos zip/jar>

-classpath <ruta de acceso de búsqueda de clases de los directorios y los archivos zip/jar>
```CMD
javac proceso2.java
java -cp . proceso2
```

# Enlace interesante
## Living Off The Land Binaries And Scripts - (LOLBins and LOLScripts)
https://github.com/api0cradle/LOLBAS

# Procesos en Java

## Crear un proceso en Java mirando el API
https://www.jesusninoc.com/2012/08/25/crear-un-proceso-utilizando-processbuilder/

## Java con ejemplos
https://www.jesusninoc.com/2017/12/01/curso-de-java-con-ejemplos/
