# Introducción a PSP

## Repaso de conceptos para manejar las shells (instalar Ubuntu Server)
   - Compilar y ejecutar
   - Path y Classpath https://docs.oracle.com/javase/tutorial/essential/environment/paths.html
   - PowerShell
   - Rutas
   - Pipe
   - Ejecutar dos comandos
   - Almacenar la ejecución de un comando

# Ejemplos repaso introducción
## Lanzar un programa en Java
```Java
import java.io.IOException;

public class P2
{
	public static void main(String[] args) throws IOException
	{
		ProcessBuilder pb = new ProcessBuilder(args);
		pb.start();
	}
}
```
### Compilar y ejecutar
```CMD
javac P2.java
java -cp . P2 notepad
```

## Lanzar un programa creado en Java desde Java
```Java
import java.io.IOException;

public class proceso{
	public static void main(String[] args)
	{
		ProcessBuilder pb = new ProcessBuilder("cmd", "/C", "java -cp . ThreadA > hola.txt");
		try
		{
			pb.start();
			}
		catch (IOException e)
		{
			System.out.println(e.getMessage());
			}
		}
	}
```

## Lanzar un programa desde PowerShell utilizando C#
```PowerShell
$CodigoC = @”
 
public class Proceso
{
public static void Main()
{
System.Diagnostics.Process.Start( @"C:\Windows\System32\Notepad.exe" );
}
}
 
“@
 
Add-Type -TypeDefinition $CodigoC -ErrorAction SilentlyContinue
 
[Proceso]::Main()
```

# Monitorización de aplicaciones Java con VisualVM
https://www.jesusninoc.com/08/21/monitorizacion-de-aplicaciones-java-con-visualvm/

# Crear, compilar y ejecutar una clase de Java que ejecuta un cmdlet de PowerShell utilizando Runtime
https://www.jesusninoc.com/02/08/crear-compilar-y-ejecutar-una-clase-de-java-que-ejecuta-un-cmdlet-de-powershell-utilizando-runtime/

# Crear, compilar, generar y ejecutar un JAR de Java que ejecuta un cmdlet de PowerShell utilizando Runtime
https://www.jesusninoc.com/02/09/crear-compilar-generar-y-ejecutar-un-jar-de-java-que-ejecuta-un-cmdlet-de-powershell-utilizando-runtime/

-----------------

# Programación multiproceso:
 -	Ejecutables. Procesos. Servicios.
 -	Estados de un proceso.
 -	Hilos.
 -	Programación concurrente.
 -	Programación paralela y distribuida.
 -	Comunicación entre procesos.
 -	Gestión de procesos.
 -	Sincronización entre procesos.
 -	Programación de aplicaciones multiproceso.

# Conceptos:
 - Multiproceso
 - BCP

# Función main en C
## Convert the char in command line argument into int type
https://www.jesusninoc.com/2015/10/08/convert-the-char-in-command-line-argument-into-int-type/


# Función main en Java
```Java
public class Test{
    public static void main(String[] args) {
        String[] x = {"1","2","3"};
        System.out.print("3".equals(x[2]));
        System.out.print("3".equals(args[2]));
    }
}
```

## How do I compare strings in Java?
https://stackoverflow.com/questions/513832/how-do-i-compare-strings-in-java

```Java
public class Test{
    public static void main(String[] args) {
        "test".equals("test")
    }
}
```

## Java – Convert String to int
https://www.mkyong.com/java/java-convert-string-to-int/

## Command-Line Arguments
https://docs.oracle.com/javase/tutorial/essential/environment/cmdLineArgs.html

## Strings In Java
https://androidexample.com/Strings_In_Java/index.php?view=article_discription&aid=149&aaid=163

# Kotlin

## Función main en Kotlin

```Kotlin
/**
 * Line 13 demonstrates string templates and array access.
 * See this pages for details:
 * http://kotlinlang.org/docs/reference/basic-types.html#strings
 * http://kotlinlang.org/docs/reference/basic-types.html#arrays
 */

fun main(args: Array<String>) {
    if (args.size == 0) {
        println("Please provide a name as a command-line argument")
        return
    }
    println("Hello, ${args[0]}!")
}
```

## Creating Collections In Kotlin
https://try.kotlinlang.org/#/Kotlin%20in%20Action/Chapter%203/3.1/3.1_2_CreatingCollectionsInKotlin1.kt
```Kotlin
fun main(args: Array<String>) {
    val strings = listOf("first", "second", "fourteenth")
    println(strings.last())
    val numbers = setOf(1, 14, 2)
    println(numbers.max())
}
```

## Get location android Kotlin
https://stackoverflow.com/questions/45958226/get-location-android-kotlin
