# Utilización de técnicas de programación segura:
 -	Prácticas de programación segura.
 -	Criptografía de clave pública y clave privada.
 -	Principales aplicaciones de la criptografía.
 -	Protocolos criptográficos.
 -	Política de seguridad.
 -	Programación de mecanismos de control de acceso.
 -	Encriptación de información.
 -	Protocolos seguros de comunicaciones.
 -	Programación de aplicaciones con comunicaciones seguras.

# Criptoanálisis
## Criptografía en PowerShell
https://www.jesusninoc.com/2017/02/01/criptografia-en-powershell/
- Análisis de frecuencias de letras en un texto con PowerShell (parte 1)
- Análisis de frecuencias de letras en un texto con PowerShell (parte 2)
- Análisis de frecuencias de letras en un texto con PowerShell (parte 3)
- Análisis de frecuencias de palabras en un texto con PowerShell (parte 4)
- Análisis de frecuencias de palabras en el libro „El ingenioso hidalgo Don Quijote de la Mancha“ con PowerShell (parte 5)
- Análisis de frecuencias de letras en el libro “El ingenioso hidalgo Don Quijote de la Mancha” con PowerShell (parte 6)
- Análisis de frecuencias de letras en el libro “El Principito” con PowerShell (parte 6)
- Análisis de frecuencias de letras en el libro “The Comedy of Errors” con PowerShell (parte 6)
- Análisis y representación de frecuencias de letras en el libro “El ingenioso hidalgo Don Quijote de la Mancha” con PowerShell (parte 7)
- Cifrar de forma sencilla el libro “El ingenioso hidalgo Don Quijote de la Mancha” con PowerShell (parte 8)
- Análisis y representación de frecuencias de letras en el libro “El ingenioso hidalgo Don Quijote de la Mancha” cifrado y sin cifrar con PowerShell (parte 9)
- Cifrar de forma compleja el libro “El ingenioso hidalgo Don Quijote de la Mancha” con PowerShell (parte 10)

##  Aproximación al cifrado y descifrado en PowerShell
https://www.jesusninoc.com/2017/02/23/aproximacion-al-cifrado-y-descifrado-en-powershell/

## Análisis de frecuencias
### Código de Java - Contar las veces que aparece una palabra en un texto
```Java
import java.util.StringTokenizer;
import java.util.Scanner;
 
class PalabrasRepetidas {
 
	public static void main(String[] args) {
 
		//Creamos un objeto de la clase Scanner para leer por teclado
		Scanner miScanner = new Scanner(System.in);
 
		System.out.println("Introduce una frase: ");
 
		//Se almacena el texto introducido en la variable frase y pasa el
		//texto todo a minúsculas
		String frase = miScanner.nextLine().toLowerCase();
 
		//Se crea el objeto tok de la clase StringTokenizer
		StringTokenizer tok = new StringTokenizer(frase);
 
		//Variable que almacenará la palabra que queramos bucar
		String palabraBuscar;
 
		//Variable que almacena el número de veces que aparece la palabra
		int contador = 0;
 
		System.out.print("Introduce la palabra a contar: ");
 
		//Se introduce la palabra a buscar pasándola toda a minúscula
		palabraBuscar = miScanner.nextLine().toLowerCase();
 
		/*
		Bucle while que se repetirá mientras que existan tokens. Dentro del
		bucle se crea un condicional if que compara si el elemento es igual a
		la palabra a buscar. En caso de que así se el contador aumentará en uno
		*/
		while(tok.hasMoreTokens()) {
			if(tok.nextElement().equals(palabraBuscar)) {
				contador++;
			}
		}
 
		System.out.println("La frase '" + frase + "'\ncontine " + contador + " veces la palabra '" + palabraBuscar + "'");
 
	}
 
}
```
## Ejercicio ver cómo se cifra en bloques un archivo PDF, comparar con el original
### Crear PDF
* https://www.jesusninoc.com/08/17/crear-un-pdf-utilizando-powershell/
### Cifrar PDF
* https://github.com/jesusninoc/ClasesPSP/blob/master/2019-03-06.md#utilizar-la-clave-secreta-almacenada-en-un-fichero-para-cifrar-un-documento-pdf-de-nombre-ficheropdf

-----------------

# Microsoft SDL - Security Development Lifecycle
* https://seguridadit.blogspot.com/2012/01/microsoft-sdl-security-development.html
El ciclo de vida de desarrollo de seguridad (SDL) es un proceso de control de seguridad orientado al desarrollo de software. Siendo una iniciativa corporativa y una directiva obligatoria desde el año 2004, SDL ha desempeñado un papel muy importante en la integración de la seguridad y de la privacidad en el software y la cultura de Microsoft. Con un enfoque tanto holístico como práctico, SDL tiene como objetivo reducir el número y la gravedad de las vulnerabilidades en el software.
