# Utilización de técnicas de programación segura:
 -	Prácticas de programación segura.
 -	Criptografía de clave pública y clave privada.
 -	Principales aplicaciones de la criptografía.
 -	Protocolos criptográficos.
 -	Política de seguridad.
 -	Programación de mecanismos de control de acceso.
 -	Encriptación de información.
 -	Protocolos seguros de comunicaciones.
 -	Programación de aplicaciones con comunicaciones seguras.

# Firma

## Firmar un mensaje con clave privada DSA (Digital Signature Algorithm)
* https://github.com/jesusninoc/PSP-2/blob/master/Ejemplos/src/seguridad/Ejemplo7.java
## Almacenar la clave pública y privada en disco en los ficheros Clave.publica y Clave.privada
* https://github.com/jesusninoc/PSP-2/blob/master/Ejemplos/src/seguridad/Ejemplo7Almacenar.java
## Generar una firma en un fichero a partir de la clave privada almacenada en un fichero. La firma se almacena en el fichero fichero.firma
* https://github.com/jesusninoc/PSP-2/blob/master/Ejemplos/src/seguridad/Ejemplo8.java
## Verificar la firma de un fichero con la clave pública
* https://github.com/jesusninoc/PSP-2/blob/master/Ejemplos/src/seguridad/Ejemplo9.java
## keytool - Key and Certificate Management Tool
https://docs.oracle.com/javase/7/docs/technotes/tools/solaris/keytool.html

----------------------

# Pasos para firmar un JAR y verificar que el fichero está firmado

```
# Crear fichero JAR que contiene el documento a firmar utilizando la herramienta jar
jar cvf DATOS.jar DATOS.DAT
# Generar las claves pública y privada (si no existen), utilizando el comando keytool -genkey
keytool -genkey -alias FirmaContrato -keystore AlmacenClaves -keyalg rsa -storepass 1234567
keytool -list -keystore AlmacenClaves
# Firmar el fichero JAR, usando la herramienta jarsigner y la clave privada generada en el paso anterior
jarsigner.exe -keystore AlmacenClaves -signedjar DATOSfirmados.jar DATOS.jar firmaContrato
# Exportar el certificado de clave pública para que el receptor del documento autentique la firma del emisor, utilizando el comando keytool -export
keytool.exe -export -keystore AlmacenClaves -alias firmacontrato -file reta.cer
# Importar el certificado del clave
keytool.exe -import -alias reta -file reta.cer -keystore AlmacenReceptor
# Por último suministrar el fichero JAR firmado y el certificado al receptor
jarsigner.exe -verify -verbose -certs -keystore AlmacenReceptor DATOSfirmados.jar
```
