# Generación de servicios en red:
 -	Protocolos estándar de comunicación en red a nivel de aplicación (telnet, ftp, http, pop3, smtp, entre otros).
 -	Librerías de clases y componentes.
 -	Utilización de objetos predefinidos.
 -	Establecimiento y finalización de conexiones.
 -	Transmisión de información.
 -	Programación de aplicaciones cliente.
 - Programación de servidores.
 -	Implementación de comunicaciones simultáneas.

--------------------

# Servicios Web SOAP
Estructura de un mensaje SOAP (originalmente las siglas de Simple Object Access Protocol) es un protocolo estándar que define cómo dos objetos en diferentes procesos pueden comunicarse por medio de intercambio de datos XML.
## Como ejemplo se muestra la forma en que un cliente solicitaría información de un producto a un proveedor de servicios Web
https://es.wikipedia.org/w/index.php?title=Simple_Object_Access_Protocol&action=edit&section=6
# Servicios REST
REST es cualquier interfaz entre sistemas que use HTTP para obtener datos o generar operaciones sobre esos datos en todos los formatos posibles, como XML y JSON. Es una alternativa en auge a otros protocolos estándar de intercambio de datos como SOAP (Simple Object Access Protocol), que disponen de una gran capacidad pero también mucha complejidad. A veces es preferible una solución más sencilla de manipulación de datos como REST.
## REST API 
https://www.jesusninoc.com/rest-api/
### Falcon Heavy (SpaceX Data REST API)
https://www.jesusninoc.com/02/07/falcon-heavy-spacex-data-rest-api/

--------------------

# Scraping
## Puppeteer is a Node library which provides a high-level API to control Chrome or Chromium over the DevTools Protocol
https://pptr.dev/

## Ejemplo básico
https://www.jesusninoc.com/08/28/html-parsing-get-information-from-a-website-bbc-news-version-28-08-2016/

## Tweep - An Advanced Twitter Scraping Tool
https://www.kitploit.com/2017/10/tweep-advanced-twitter-scraping-tool.html

## Generación de diccionario de usuarios tipo jmolina@ gracias a linkedin scraping.
http://kinomakino.blogspot.com/2018/06/generacion-de-diccionario-de-usuarios.html

## Scraping en Java (JSoup), con ejemplos
https://jarroba.com/scraping-java-jsoup-ejemplos/

## Ejemplo scraping BBC con JSoup
```Java
package scratp;


import java.io.IOException;

import org.jsoup.Connection.Response;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class ScrapingAllPost {
	
    public static final String url = "http://localhost:89/bbc/";
    public static final int maxPages = 20;
	
	
    public static void main (String args[]) {
		
        for (int i=1; i<maxPages; i++){
			
            String urlPage = String.format(url, i);
            System.out.println("Comprobando entradas de: "+urlPage);
			
            // Compruebo si me da un 200 al hacer la petición
            if (getStatusConnectionCode(urlPage) == 200) {
				
                // Obtengo el HTML de la web en un objeto Document2
                Document document = getHtmlDocument(urlPage);
				
                // Busco todas las historias de meneame que estan dentro de: 
                Elements entradas = document.select("div.media__content");
				
                // Paseo cada una de las entradas
                for (Element elem : entradas) {
                    String titulo = elem.getElementsByClass("media__link").text();
                    String autor = elem.getElementsByClass("media__summary").text();
                    //String fecha = elem.getElementsByClass("fecha").text();
                	System.out.println(titulo);
                  	System.out.println(autor);
                    //System.out.println(titulo+"\n"+autor+"\n"+fecha+"\n");
					
                }
		
            }else{
                System.out.println("El Status Code no es OK es: "+getStatusConnectionCode(urlPage));
                break;
            }
        }
    }
	
	
    /**
     * Con esta método compruebo el Status code de la respuesta que recibo al hacer la petición
     * EJM:
     * 		200 OK			300 Multiple Choices
     * 		301 Moved Permanently	305 Use Proxy
     * 		400 Bad Request		403 Forbidden
     * 		404 Not Found		500 Internal Server Error
     * 		502 Bad Gateway		503 Service Unavailable
     * @param url
     * @return Status Code
     */
    public static int getStatusConnectionCode(String url) {
		
        Response response = null;
		
        try {
            response = Jsoup.connect(url).userAgent("Mozilla/5.0").timeout(100000).ignoreHttpErrors(true).execute();
        } catch (IOException ex) {
            System.out.println("Excepción al obtener el Status Code: " + ex.getMessage());
        }
        return response.statusCode();
    }
	
	
    /**
     * Con este método devuelvo un objeto de la clase Document con el contenido del
     * HTML de la web que me permitirá parsearlo con los métodos de la librelia JSoup
     * @param url
     * @return Documento con el HTML
     */
    public static Document getHtmlDocument(String url) {

        Document doc = null;

        try {
            doc = Jsoup.connect(url).userAgent("Mozilla/5.0").timeout(100000).get();
        } catch (IOException ex) {
            System.out.println("Excepción al obtener el HTML de la página" + ex.getMessage());
        }

        return doc;

    }
}	
```

## Programación Movistar+ con PowerShell
https://www.jesusninoc.com/2017/10/12/programacion-movistar-con-powershell/

## Node.JS para parsear un fichero JSON
```JavaScript
var http = require('https');

var url = 'https://www.jesusninoc.com/s/movistar.php';
 
 http.get(url, function(res) {
      var body = '';
 
      res.on('data', function(chunk) {
         body += chunk;
      });
 
      res.on('end', function() {
        var jsonData = JSON.parse(body)
        for (var i = 0; i < jsonData.length; ++i) {
          console.log(jsonData[i].Nombre);
          console.log(jsonData[i].Pases[0].Titulo);
          console.log("----------------------------------");
        }
      });
    }).on('error', function(e) {
      console.log("Error: " + e.message);
 });
```

## JavaScript + jQuery 1.11.0 (parsear un fichero JSON)
http://jsfiddle.net/vLft56mg/355/

## JavaScript + jQuery 2.1.3 (parsear un fichero JSON)
https://jsfiddle.net/96psd4xw/17/

## Parsear contenido de API
* https://www.nutritionix.com/
* https://www.themealdb.com/api/json/v1/1/search.php?s=Arrabiata
* https://www.themealdb.com/api.php
* https://igdb.github.io/api/
* https://freemusicarchive.org/api

--------------------

# Utilización de técnicas de programación segura:
 -	Prácticas de programación segura.
 -	Criptografía de clave pública y clave privada.
 -	Principales aplicaciones de la criptografía.
 -	Protocolos criptográficos.
 -	Política de seguridad.
 -	Programación de mecanismos de control de acceso.
 -	Encriptación de información.
 -	Protocolos seguros de comunicaciones.
 -	Programación de aplicaciones con comunicaciones seguras.

--------------------

# PowerShell
## Creates a new self-signed certificate
https://www.jesusninoc.com/2017/11/06/creates-a-new-self-signed-certificate/
## Encrypts content by using the Cryptographic Message Syntax format
https://www.jesusninoc.com/2017/11/10/encrypts-content-by-using-the-cryptographic-message-syntax-format/
## Decrypts content that has been encrypted by using the Cryptographic Message Syntax format
https://www.jesusninoc.com/2017/11/12/decrypts-content-that-has-been-encrypted-by-using-the-cryptographic-message-syntax-format/
## Exports a certificate to a Personal Information Exchange (PFX) file
https://www.jesusninoc.com/2017/11/18/exports-a-certificate-to-a-personal-information-exchange-pfx-file/
## Imports certificates and private keys from a Personal Information Exchange (PFX) file to the destination store
https://www.jesusninoc.com/2017/11/20/imports-certificates-and-private-keys-from-a-personal-information-exchange-pfx-file-to-the-destination-store/

--------------------

# Java
## Guardar un String junto con el resumen
* https://github.com/jesusninoc/PSP-2/blob/master/Ejemplos/src/seguridad/Ejemplo5.java
## Comprobar que el String no se ha dañado o manipulado
* https://github.com/jesusninoc/PSP-2/blob/master/Ejemplos/src/seguridad/Ejemplo6.java
## Firmar un mensaje con clave privada DSA (Digital Signature Algorithm)
* https://github.com/jesusninoc/PSP-2/blob/master/Ejemplos/src/seguridad/Ejemplo7.java
## Almacenar la clave pública y privada en disco en los ficheros Clave.publica y Clave.privada
* https://github.com/jesusninoc/PSP-2/blob/master/Ejemplos/src/seguridad/Ejemplo7Almacenar.java
## Generar una firma en un fichero a partir de la clave privada almacenada en un fichero. La firma se almacena en el fichero fichero.firma
* https://github.com/jesusninoc/PSP-2/blob/master/Ejemplos/src/seguridad/Ejemplo8.java
## Verificar la firma de un fichero con la clave pública
* https://github.com/jesusninoc/PSP-2/blob/master/Ejemplos/src/seguridad/Ejemplo9.java
## keytool - Key and Certificate Management Tool
https://docs.oracle.com/javase/7/docs/technotes/tools/solaris/keytool.html
