# Generación de servicios en red:
 -	Protocolos estándar de comunicación en red a nivel de aplicación (telnet, ftp, http, pop3, smtp, entre otros).
 -	Librerías de clases y componentes.
 -	Utilización de objetos predefinidos.
 -	Establecimiento y finalización de conexiones.
 -	Transmisión de información.
 -	Programación de aplicaciones cliente.
 - Programación de servidores.
 -	Implementación de comunicaciones simultáneas.

# SSH
## Instalar servidor SSH
https://www.cyberciti.biz/faq/ubuntu-linux-install-openssh-server/
## Conectar vía SSH con Java
http://programacion.net/articulo/conectar_via_ssh_con_java_1163

--------------------

# Utilización de técnicas de programación segura:
 -	Prácticas de programación segura.
 -	Criptografía de clave pública y clave privada.
 -	Principales aplicaciones de la criptografía.
 -	Protocolos criptográficos.
 -	Política de seguridad.
 -	Programación de mecanismos de control de acceso.
 -	Encriptación de información.
 -	Protocolos seguros de comunicaciones.
 -	Programación de aplicaciones con comunicaciones seguras.

# Ficheros de políticas en Java
## Ejemplo crear un fichero
```Java
import java.io.*;
public class Ejemplo2 {
   public static void main(String[] args) {
   System.setSecurityManager(new SecurityManager());
	try {
		//escritura en fichero		
		BufferedWriter fichero = new BufferedWriter
		   (new FileWriter("D://Ficheros//Fichero.txt"));
		fichero.write("Escritura de una linea en fichero.");
		fichero.newLine(); // escribe un salto de línea
		fichero.close();
		System.out.println("Final proceso de escritura...");

		//lectura en fichero
		BufferedReader fichero2 = new BufferedReader
              (new FileReader("D://Ficheros//Fichero.txt"));
		String linea = fichero2.readLine();
		System.out.println("Contenido del fichero: ");
		System.out.println("\t" + linea);
		fichero2.close();
		System.out.println("Final proceso de lectura...");
			
	} catch (FileNotFoundException fn) {
		System.out.println("No se encuentra el fichero");
	} catch (IOException io) {
		System.out.println("Error de E/S ");
	} catch ( Exception e) {		
	    System.out.println("ERROR => " + e.toString());			
	}

   }// main
}//..Ejemplo2
```
### Fichero Politica2.policy
```Java
grant codeBase "file:D:/CAPIT5/"{ 
    permission java.io.FilePermission "D:\\Ficheros\\*", "read,write";
}; 
```
## Ejemplo para aplicar permisos a sockets
```Java
import java.net.*;
public class Ejemplo3Servidor {
	public static void main(String[] arg) {
		int numeroPuerto = 6000;// Puerto
		ServerSocket servidor = null;
		
		//System.setProperty ("java.security.policy", 	"D:\\CAPIT5\\Politica4.policy");
        System.setSecurityManager(new SecurityManager());
		
		try {
		  servidor = new ServerSocket(numeroPuerto);		
		  System.out.println("Esperando al cliente.....");
		  Socket clienteConectado = servidor.accept();	    
	      System.out.println("Cliente conectado.");		
		  clienteConectado.close();
		  System.out.println("Cliente desconectado.");
		  servidor.close();
		} catch (Exception e) {
				System.err.println("ERROR=> " + e.toString());
		}
	}// main
}//..Ejemplo3Servidor
```
### Fichero Politica2.policy
```Java
grant codeBase "file:D:/CAPIT5/" {
  permission java.net.SocketPermission "localhost", "accept";
};
```
