# Generación de servicios en red:
 -	Protocolos estándar de comunicación en red a nivel de aplicación (telnet, ftp, http, pop3, smtp, entre otros).
 -	Librerías de clases y componentes.
 -	Utilización de objetos predefinidos.
 -	Establecimiento y finalización de conexiones.
 -	Transmisión de información.
 -	Programación de aplicaciones cliente.
 - Programación de servidores.
 -	Implementación de comunicaciones simultáneas.

# SMTP
## Configurar Mercury de Xampp para enviar correos desde localhost
http://www.medisoft.cl/configurar-mercury-xampp-para-enviar-correos-desde-localhost/
## TLS
```Java
package Ejemplos;

import java.io.IOException;
import java.io.Writer;
import java.security.InvalidKeyException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.spec.InvalidKeySpecException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import org.apache.commons.net.smtp.*;

public class ClienteSMTP3 {
	public static void main(String[] args) throws NoSuchAlgorithmException, UnrecoverableKeyException,
			KeyStoreException, InvalidKeyException, InvalidKeySpecException {

		// se crea cliente SMTP seguro
		AuthenticatingSMTPClient client = new AuthenticatingSMTPClient();

		// datos del usuario y del servidor
		String server = "smtp.gmail.com";
		String username = "correo@gmail.com";
		String password = "claveusuario";
		int puerto = 587;
		String remitente = "correo@gmail.com";

		try {
			int respuesta;

			// Creación de la clave para establecer un canal seguro
			KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
			kmf.init(null, null);
			KeyManager km = kmf.getKeyManagers()[0];

			// nos conectamos al servidor SMTP
			client.connect(server, puerto);
			System.out.println("1 - " + client.getReplyString());
			// se establece la clave para la comunicación segura
			client.setKeyManager(km);

			respuesta = client.getReplyCode();
			if (!SMTPReply.isPositiveCompletion(respuesta)) {
				client.disconnect();
				System.err.println("CONEXIÓN RECHAZADA.");
				System.exit(1);
			}

			// se envía el commando EHLO
			client.ehlo(server);// necesario
			System.out.println("2 - " + client.getReplyString());

			// NECESITA NEGOCIACIÓN TLS - MODO NO IMPLICITO
			// Se ejecuta el comando STARTTLS y se comprueba si es true
			if (client.execTLS()) {
				System.out.println("3 - " + client.getReplyString());

				// se realiza la autenticación con el servidor
			 {
					System.out.println("4 - " + client.getReplyString());
					String destino1 = "correo@gmail.com";
					String asunto = "Prueba de SMTPClient con GMAIL";
					String mensaje = "Hola. \nEnviando saludos.\nUsando  GMAIL.\nChao.";
					// se crea la cabecera
					SimpleSMTPHeader cabecera = new SimpleSMTPHeader(remitente, destino1, asunto);

					// el nombre de usuario y el email de origen coinciden
					client.setSender(remitente);
					client.addRecipient(destino1);
					System.out.println("5 - " + client.getReplyString());

					// se envia DATA
					Writer writer = client.sendMessageData();
					if (writer == null) { // fallo
						System.out.println("FALLO AL ENVIAR DATA.");
						System.exit(1);
					}

					writer.write(cabecera.toString()); // cabecera
					writer.write(mensaje);// luego mensaje
					writer.close();
					System.out.println("6 - " + client.getReplyString());

					boolean exito = client.completePendingCommand();
					System.out.println("7 - " + client.getReplyString());

					if (!exito) { // fallo
						System.out.println("FALLO AL FINALIZAR TRANSACCIÓN.");
						System.exit(1);
					} else
						System.out.println("MENSAJE ENVIADO CON EXITO......");

				} else
					System.out.println("USUARIO NO AUTENTICADO.");
			} else
				System.out.println("FALLO AL EJECUTAR  STARTTLS.");

		} catch (IOException e) {
			System.err.println("Could not connect to server.");
			e.printStackTrace();
			System.exit(1);
		}
		try {
			client.disconnect();
		} catch (IOException f) {
			f.printStackTrace();
		}

		System.out.println("Fin de envío.");
		System.exit(0);
	}// main
}// ..ClienteSMTP3
```
## NOTLS
* https://drive.google.com/file/d/1bniOY-APLVMTajioRAgVikbf1B3AjkTL/view

# Recorrer FTP
#telegram #osint #recon #pentest #IoT #indexer #crawler #web #ftp 
* https://t.me/ohl7AeGah5uo8cho4nae9Eemaeyae3 … 
* https://t.me/xai7poozengee2Aen3poMookohthaZ … Common
* https://t.me/gohquooFee3duaNaeNuthushoh8di2 … HTTP
* https://t.me/aiWeipeighah7vufoHa0ieToipooYe … FTP
* https://t.me/ohl7AeGah5uo8cho4nae9Eemaeyae3 … Gopher
## TheDorks I : FTP PASSWORD
* https://r3dbird.blogspot.com/2019/01/thedorks-i-ftp-hacking-infoleak-y.html

--------------------

# Utilización de técnicas de programación segura:
 -	Prácticas de programación segura.
 -	Criptografía de clave pública y clave privada.
 -	Principales aplicaciones de la criptografía.
 -	Protocolos criptográficos.
 -	Política de seguridad.
 -	Programación de mecanismos de control de acceso.
 -	Encriptación de información.
 -	Protocolos seguros de comunicaciones.
 -	Programación de aplicaciones con comunicaciones seguras.

# The Security Manager
https://docs.oracle.com/javase/tutorial/essential/environment/security.html

## Mostrar propiedades (java.class.path", "java.home", "java.vendor", "java.version", "os.name", "os.version", "user.dir", "user.home", "user.name") sin utilizar el gestor de seguridad
```Java
public class Ejemplo1 {
	public static void main(String[] args) {	
		String t[] = { "java.class.path", "java.home", "java.vendor",
				 "java.version", "os.name", "os.version",
				"user.dir", "user.home", "user.name" };
        
		for (int i = 0; i < t.length; i++) {
			System.out.print("Propiedad:" + t[i]);
			try {
				String s = System.getProperty(t[i]);
				System.out.println("\t==> " + s);
			} catch (Exception e) {
				System.err.println("\n\tExcepción " + e.toString());
			}
		}// for
	}
}//..Ejemplo1
```
## Ejecutar desde JVM "The Security Manager"
```CMD
java -Djava.security.manager Ejemplo1
```

## Mostrar propiedades teniendo en cuenta "The Security Manager"
```Java
public class Ejemplo1SM {
	public static void main(String[] args) {	
		String t[] = { "java.class.path", "java.home", "java.vendor",
				 "java.version", "os.name", "os.version",
				"user.dir", "user.home", "user.name" };
		
		System.setSecurityManager(new SecurityManager()); 
		
		for (int i = 0; i < t.length; i++) {
			System.out.print("Propiedad:" + t[i]);
			try {
				String s = System.getProperty(t[i]);
				System.out.println("\t==> " + s);
			} catch (Exception e) {
				System.err.println("\n\tExcepción " + e.toString());
			}
		}// for
	}
}//..Ejemplo1
//java -Djava.security.policy=Politica1.policy Ejemplo1
```

## Ejemplo de conexión Servidor con "The Security Manager"
```Java
import java.io.*;
import java.net.*;

public class ejemplo1Servidor {
	public static void main(String[] arg) throws IOException {
		int numeroPuerto = 6000;// Puerto
		ServerSocket servidor = null;
        System.setSecurityManager(new SecurityManager());
		try {
		servidor = new ServerSocket(numeroPuerto);

		
		Socket clienteConectado = null;
		System.out.println("Esperando al cliente....."+servidor.getLocalPort());
		System.out.println("Esperando al cliente....."+servidor.getLocalSocketAddress());
		clienteConectado = servidor.accept();
	    System.out.println("Adios al cliente....."+clienteConectado.getPort());
	    System.out.println("Adios al cliente2....."+clienteConectado.getLocalPort());
		
		clienteConectado.close();
		servidor.close();
		} catch (Exception e) {
				System.err.println("ERROR=> " + e.toString());
			}

	}// main
}// fin
```

--------------------

# Micrófonos
https://github.com/jesusninoc/ClasesPSP/blob/master/2019-01-24.md#c%C3%B3mo-encontrar-c%C3%A1maras-ocultas-y-equipo-de-esp%C3%ADas-como-un-profesional-la-gu%C3%ADa-definitiva
