# Programación de comunicaciones en red:
 -	Comunicación entre aplicaciones.
 -	Roles cliente y servidor.
 -	Elementos de programación de aplicaciones en red. Librerías.
 -	Sockets.
 -	Creación de sockets.
 -	Enlazado y establecimiento de conexiones.
 -	Utilización de sockets para la transmisión y recepción de información.
 -	Programación de aplicaciones cliente y servidor.
 -	Utilización de hilos en la programación de aplicaciones en red.

## URL
### Ver datos de una petición a una página web con URL
https://github.com/javierinformatica/PSP/blob/master/Ejemplos/src/Red/Ejemplo5.java
### Conectar con una URL en Java
https://www.jesusninoc.com/2012/09/21/conectar-con-una-url-en-java/
### Conectar con una URL en Java cambiando el User-Agent
https://www.jesusninoc.com/2012/10/01/conectar-con-una-url-en-java-cambiando-el-user-agent/

## Enviar datos desde Java
### Forma simple
https://github.com/javierinformatica/PSP/blob/master/Ejemplos/src/Red/Ejemplo4.java

### Petición POST en Java
```Java
import java.net.*;
import java.io.*;
import java.util.*;

public class ejemplo5 {
	public static void main(String[] args){
	try
	{
		String data = "nombre=Hello+World!&edad=23";
		URL url = new URL("http://localhost:89/getypost/examplepost.php");
		HttpURLConnection con = (HttpURLConnection) url.openConnection();
		con.setRequestMethod("POST");
		con.setDoOutput(true);
		con.getOutputStream().write(data.getBytes("UTF-8"));
		
		BufferedReader reader = new BufferedReader(new InputStreamReader(con.getInputStream()));
		String linea;
		while ((linea = reader.readLine()) != null) {
			System.out.println(linea);
		}
		reader.close();// cerrar flujo

		} catch (MalformedURLException me) {
			System.err.println("MalformedURLException: " + me);
		} catch (IOException ioe) {
			System.err.println("IOException:  " + ioe);
		}
	}
}
```
