# Programación multiproceso:
 -	Ejecutables. Procesos. Servicios.
 -	Estados de un proceso.
 -	Hilos.
 -	Programación concurrente.
 -	Programación paralela y distribuida.
 -	Comunicación entre procesos.
 -	Gestión de procesos.
 -	Sincronización entre procesos.
 -	Programación de aplicaciones multiproceso.

# Conceptos:
 - Multiproceso
 - BCP
 - Process status
 - Estados de un proceso
 - System
 - Funciones
 - Función main
 - Creación y ejecución de procesos
 - Padre crear hijo
 - Comunicación entre procesos
 - Descriptores
 - Ficheros
 - Pipes
   - Sin nombre
     - https://www.jesusninoc.com/2018/08/03/c-programming-in-linux-tutorial-037-pipe-function/
   - Con nombre
     - https://github.com/mememiguelo/PSP/blob/master/C/Otros/Fifo.c
     - https://github.com/mememiguelo/PSP/blob/master/C/Otros/fifocrea.c
     - https://github.com/mememiguelo/PSP/blob/master/C/Otros/fifoescribe.c
 - Sincronizar procesos
 - Señales
 - Creación procesos Java
 - Programación concurrente
 - Condiciones de Bernstein
 - Programación paralela
 - Memorias compartidas
 - Semáforos
 - Programación distribuida
 
# Descriptores
|Valor|entero|Nombre
|---|---|---
|0|Entrada estándar|stdin
|1|Salida estándar|stdout
|2|Error estándar|stderr

# Ficheros
### El programa abre el fichero para escritura, escribe un saludo y después cierra el fichero
```C
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

void main (void)
{
	char saludo[]="Un saludo\n";
	char buffer [10];

	int fd, bytesleidos;

	fd = open("texto.txt", 1); //fichero se abre solo para escritura

	if( fd == -1 )
	{
		printf("ERROR AL ABRIR EL FICHERO ... \n");
		exit (-1);
	}

	printf("Escribo el saludo ... \n");

	write(fd, saludo, strlen(saludo));

	close(fd); //cierro el fichero
	
	fd = open("texto.txt", 0); //el fichero se abre solo para lectura
	
	printf("Contenido del Fichero: \n");

	//leo bytes de uno en uno y lo guardo en buffer
	bytesleidos= read(fd, buffer, 1);

	while (bytesleidos != 0) 
	{
		printf("%c", buffer[0]); // pinto el byte leido
		// leo otro byte
		bytesleidos=read(fd, buffer, 1);
	}
	close(fd);
}
```

# Pipes
## Sin nombre
### Cuando el flujo de información va del padre hacia el hijo:
- El padre debe cerrar el descriptor de lectura fd[0].
- El hijo debe cerrar el descriptor de escritura fd[1].
### Cuando el flujo de información va del hijo hacia el padre ocurre lo contrario:
- El padre debe cerrar el descriptor de escritura fd[1].
- El hijo debe cerrar el descriptor de lectura fd[0].

# Memorias compartidas
## Uso de las funciones ftok(), shmget(), shmat() y shmctl()
https://github.com/jesusninoc/ClasesPSP/blob/master/2017-10-24.md

## Programación de memorias compartidas en Linux
https://www.jesusninoc.com/2015/07/10/programacion-de-memorias-compartidas-en-linux/

## Utilizar zonas de memoria compartida en Linux mediante WSL desde PowerShell
https://www.jesusninoc.com/2018/06/25/utilizar-zonas-de-memoria-compartida-en-linux-mediante-wsl-desde-powershell/

## Relación con memoria
https://github.com/jesusninoc/ClasesPSP/blob/master/2017-10-12.md

## Volcado de memoria
https://github.com/jesusninoc/ClasesPSP/blob/master/2017-10-19.md

# Ensamblador
## SPIM: A MIPS32 Simulator
https://github.com/jesusninoc/ClasesPSP/blob/master/2017-10-26.md

## Suma de números en ensamblador
https://github.com/jesusninoc/ClasesPSP/blob/master/2017-10-05.md

## Analizar con Cheat Engine un payload de ejecución de comandos arbitrarios para ejecutar PowerShell
https://www.jesusninoc.com/2017/03/20/analizar-con-cheat-engine-un-payload-de-ejecucion-de-comandos-arbitrarios-para-ejecutar-powershell/

# Ktmutil
## Starts the Kernel Transaction Manager utility. If used without parameters, ktmutil displays available subcommands
```PowerShell
Ktmutil tm list
Ktmutil tm info
Ktmutil tx list
Ktmutil tx info
ktmutil tm info {f5a10f48-72be-11e5-8250-40167e1612ab}
Ktmutil list tms
```
