
# Programación multiproceso:
 -	Ejecutables. Procesos. Servicios.
 -	Estados de un proceso.
 -	Hilos.
 -	Programación concurrente.
 -	Programación paralela y distribuida.
 -	Comunicación entre procesos.
 -	Gestión de procesos.
 -	Sincronización entre procesos.
 -	Programación de aplicaciones multiproceso.

# Conceptos:
 - Multiproceso
 - BCP
 - Process status
 - Estados de un proceso
 - System
 - Funciones
 - Función main
 - Creación y ejecución de procesos
 - Padre crear hijo
 - Comunicación entre procesos
 - Pipes
   - Sin nombre
     - https://www.jesusninoc.com/2018/08/03/c-programming-in-linux-tutorial-037-pipe-function/
   - Con nombre
     - https://github.com/mememiguelo/PSP/blob/master/C/Otros/Fifo.c
     - https://github.com/mememiguelo/PSP/blob/master/C/Otros/fifocrea.c
     - https://github.com/mememiguelo/PSP/blob/master/C/Otros/fifoescribe.c
 - Sincronizar procesos
 - Señales
 - Creación procesos Java
 - Programación concurrente
 - Condiciones de Bernstein
 - Programación paralela
 - Memorias compartidas
 - Semáforos
 - Programación distribuida

# Repaso
## Lanzar programa que ejecute ping

```Java
import java.io.IOException;

public class proceso2{
	public static void main(String[] args)
	{
		ProcessBuilder pb = new ProcessBuilder("cmd", "/C", "ping localhost > resultado.txt");
		try
		{
			pb.start();
			}
		catch (IOException e)
		{
			System.out.println(e.getMessage());
			}
		}
	}
```
## Lanzar programa que ejecute un ping dos veces
```Java
import java.io.IOException;

public class proceso2{
	public static void main(String[] args)
	{
		ProcessBuilder pb = new ProcessBuilder("cmd", "/C", "ping localhost > resultado.txt && ping 192.168.1.16 > resultado2.txt");
		try
		{
			pb.start();
			}
		catch (IOException e)
		{
			System.out.println(e.getMessage());
			}
		}
	}
```

### Ejecutar y compilar en Java
-cp <ruta de acceso de búsqueda de clases de los directorios y los archivos zip/jar>

-classpath <ruta de acceso de búsqueda de clases de los directorios y los archivos zip/jar>
```CMD
javac proceso2.java
java -cp . proceso2
```

# Enlace interesante
## Living Off The Land Binaries And Scripts - (LOLBins and LOLScripts)
https://github.com/api0cradle/LOLBAS

# Procesos en Java

## Crear un proceso en Java mirando el API
https://www.jesusninoc.com/2012/08/25/crear-un-proceso-utilizando-processbuilder/

## Java con ejemplos
https://www.jesusninoc.com/2017/12/01/curso-de-java-con-ejemplos/
