# Cifrado simétrico
- TDEA (Triple Data Encryption Algorithm)
- AES (Advanced Encryption Standard)

```Java
/* Con clave aleatoria */

import javax.crypto.*;    
import java.security.*;  

public class Java {

	private static SecretKey key = null;         
	private static Cipher cipher = null; 

	public static void main(String[] args) throws Exception
	{
		KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
		keyGenerator.init(128);
		SecretKey secretKey = keyGenerator.generateKey();
		cipher = Cipher.getInstance("AES");

		String clearText = "hola";
		byte[] clearTextBytes = clearText.getBytes("UTF8");
		System.out.println("Texto en claro: " + clearText);
		System.out.println("Texto en Bytes claro: " + clearTextBytes);

		cipher.init(Cipher.ENCRYPT_MODE, secretKey);
		byte[] cipherBytes = cipher.doFinal(clearTextBytes);
		String cipherText = new String(cipherBytes, "UTF8");
		System.out.println("Texto cifrado: " + cipherText);
		System.out.println("Texto en Bytes cifrado: " + cipherBytes);

		cipher.init(Cipher.DECRYPT_MODE, secretKey);
		byte[] decryptedBytes = cipher.doFinal(cipherBytes);
		String decryptedText = new String(decryptedBytes, "UTF8");
		System.out.println("Texto descifrado: " + decryptedText);
		System.out.println("Texto en Bytes cifrado: " + decryptedBytes);
	}
}
```

```Java
/* Con clave añadida*/

import javax.crypto.*;
import javax.crypto.spec.SecretKeySpec;
import java.security.*;
import java.util.Base64;

public class Java {

	private static Cipher cipher = null; 

	public static void main(String[] args) throws Exception{
		// Clave -> Clave en base 64
		// 1234567891234567 -> MTIzNDU2Nzg5MTIzNDU2Nw==
		// decode the base64 encoded string
		byte[] decodedKey = Base64.getDecoder().decode("MTIzNDU2Nzg5MTIzNDU2Nw==");
		
		// rebuild key using SecretKeySpec
		SecretKey originalKey = new SecretKeySpec(decodedKey, 0, decodedKey.length, "AES");
		System.out.println("originalKey: " + decodedKey);
		
		cipher = Cipher.getInstance("AES");

		String clearText = "hola";
		byte[] clearTextBytes = clearText.getBytes("UTF8");
		System.out.println("Texto en claro: " + clearText);

		cipher.init(Cipher.ENCRYPT_MODE, originalKey);
		byte[] cipherBytes = cipher.doFinal(clearTextBytes);
		String cipherText = new String(cipherBytes, "UTF8");
		System.out.println("Texto cifrado: " + cipherText);

		cipher.init(Cipher.DECRYPT_MODE, originalKey);
		byte[] decryptedBytes = cipher.doFinal(cipherBytes);
		String decryptedText = new String(decryptedBytes, "UTF8");
		System.out.println("Texto descifrado: " + decryptedText);
	}
}
```

# Algoritmos asimétricos
- DSA (Digital Signature Algorithm)
- ECDSA (Elliptic Curve Digital Signature Algorithm)
- RSA (Criptosistema RSA)

```Java
import javax.crypto.*;
import java.security.*;
public class ExampleRSA {

	public static void main(String[] args) {
		try {
			KeyPairGenerator keygen = KeyPairGenerator.getInstance("RSA");
			KeyPair keypair = keygen.generateKeyPair();
			
			Cipher rsaCipher = Cipher.getInstance("RSA");
			
			String mensaje = "Mensajeo";
			
			rsaCipher.init(Cipher.ENCRYPT_MODE, keypair.getPrivate());
			byte[] mensajeCifrado = rsaCipher.doFinal(mensaje.getBytes("UTF8"));
			System.out.println(mensajeCifrado);
			
			rsaCipher.init(Cipher.DECRYPT_MODE, keypair.getPublic());
			byte[] mensajeDescifrado = rsaCipher.doFinal(mensajeCifrado);
			String mensajeDescifrado2 = new String(mensajeDescifrado, "UTF8");
			System.out.println(mensajeDescifrado2);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
```

- ECIES (Elliptic Curve Integrated Encryption Scheme)

# Técnicas simples
- Transposición
- Sustitución

# Análisis de frecuencias
https://www.jesusninoc.com/2017/02/01/criptografia-en-powershell/
- Análisis de frecuencias de letras en un texto con PowerShell (parte 1)
- Análisis de frecuencias de letras en un texto con PowerShell (parte 2)
- Análisis de frecuencias de letras en un texto con PowerShell (parte 3)
- Análisis de frecuencias de palabras en un texto con PowerShell (parte 4)
- Análisis de frecuencias de palabras en el libro „El ingenioso hidalgo Don Quijote de la Mancha“ con PowerShell (parte 5)
- Análisis de frecuencias de letras en el libro “El ingenioso hidalgo Don Quijote de la Mancha” con PowerShell (parte 6)
- Análisis de frecuencias de letras en el libro “El Principito” con PowerShell (parte 6)
- Análisis de frecuencias de letras en el libro “The Comedy of Errors” con PowerShell (parte 6)
- Análisis y representación de frecuencias de letras en el libro “El ingenioso hidalgo Don Quijote de la Mancha” con PowerShell (parte 7)
- Cifrar de forma sencilla el libro “El ingenioso hidalgo Don Quijote de la Mancha” con PowerShell (parte 8)
- Análisis y representación de frecuencias de letras en el libro “El ingenioso hidalgo Don Quijote de la Mancha” cifrado y sin cifrar con PowerShell (parte 9)
- Cifrar de forma compleja el libro “El ingenioso hidalgo Don Quijote de la Mancha” con PowerShell (parte 10)

# Criptoanálisis
- Criptoanálisis básico con PowerShell (parte 1)
- Criptoanálisis básico con PowerShell (parte 2)

# 3DES is Officially Being Retired
https://www.cryptomathic.com/news-events/blog/3des-is-officially-being-retired
