# HMAC
En la criptografía, un código de autentificación de mensajes en clave-hash (HMAC) es una construcción específica para calcular un código de autentificación de mensaje (MAC) que implica una función hash criptográfica en combinación con una llave criptográfica secreta. Como cualquier MAC, puede ser utilizado para verificar simultáneamente la integridad de los datos y la autentificación de un mensaje. Cualquier función hash criptográfica, tales como MD5 o SHA-1, puede ser utilizada para el cálculo de un HMAC; el algoritmo MAC resultante se denomina HMAC-MD5 o HMAC-SHA1 en consecuencia. La fuerza criptográfica del HMAC depende de la potencia criptográfica de la función de hash subyacente, el tamaño de su salida de hash y el tamaño y calidad de la llave.

## Generar HMAC-SHA256 con PowerShell
https://www.jesusninoc.com/2018/02/18/generar-hmac-sha256-con-powershell/

# CCN-STIC-807 – Criptografía de empleo en el ENS
|Tipo de Algoritmo| Acreditados por el CCN|
|--|--
|Cifrado Simétrico|TDEA (Triple Data Encryption Algorithm)
||AES (Advanced Encryption Standard)
|Algoritmos Asimétricos|DSA (Digital Signature Algorithm)
||ECDSA (Elliptic Curve Digital Signature Algorithm)
||RSA (Criptosistema RSA)
||ECIES (Elliptic Curve Integrated Encryption Scheme)
|Intercambio de Clave|DH o DHKA (Diffie-Hellman Key Agreement)
||MQV (Menezes-Qu-Vanstone Key Agreement)
||ECDH (Elliptic Curve Diffie-Hellman)
||ECMQV (Elliptic Curve Menezes-Qu-Vanstone)
|Funciones resumen (Hash)|SHA-2 (Secure Hash Algorithm)
||HMAC (Hash Message Authentication Code )

# Reverse hash (MD5/SHA1)
https://www.jesusninoc.com/2016/02/02/reverse-hash-md5-sha1/

# PoC para detectar colisión en SHA1 con PowerShell
http://www.jesusninoc.com/2017/02/24/poc-para-detectar-colision-en-sha1-con-powershell/

# Practical collision attack against SHA-1
https://isc.sans.edu/forums/diary/Practical+collision+attack+against+SHA1/22109/

# Cracking de contraseñas con hashcat
https://www.securityartwork.es/2017/02/15/cracking-contrasenas-hashcat/

# Formularios en Google Docs

## Utilizar JSON con nombres y apellidos aleatorios
https://www.jesusninoc.com/2018/02/04/utilizar-json-con-nombres-y-apellidos-aleatorios/

## Enviar datos a un formulario de Google Docs desde PowerShell
https://www.jesusninoc.com/2017/03/11/enviar-datos-a-un-formulario-de-google-docs-desde-powershell/

## Enviar datos a un formulario de Google Docs desde PowerShell (deducir los parámetros que se envían por POST)
https://www.jesusninoc.com/2017/04/30/enviar-datos-a-un-formulario-de-google-docs-desde-powershell-deducir-los-parametros-que-se-envian-por-post/

## Acceder a los datos publicados en un formulario de Google desde PowerShell
https://www.jesusninoc.com/2017/05/01/acceder-a-los-datos-publicados-en-un-formulario-de-google-desde-powershell/

# Aproximación al cifrado y descifrado en PowerShell
https://www.jesusninoc.com/2017/02/23/aproximacion-al-cifrado-y-descifrado-en-powershell/

# Certificates

## Creates a new self-signed certificate
https://www.jesusninoc.com/2017/11/06/creates-a-new-self-signed-certificate/

## Encrypts content by using the Cryptographic Message Syntax format
https://www.jesusninoc.com/2017/11/10/encrypts-content-by-using-the-cryptographic-message-syntax-format/

## Decrypts content that has been encrypted by using the Cryptographic Message Syntax format
https://www.jesusninoc.com/2017/11/12/decrypts-content-that-has-been-encrypted-by-using-the-cryptographic-message-syntax-format/

## Exports a certificate to a Personal Information Exchange (PFX) file
https://www.jesusninoc.com/2017/11/18/exports-a-certificate-to-a-personal-information-exchange-pfx-file/

## Imports certificates and private keys from a Personal Information Exchange (PFX) file to the destination store
https://www.jesusninoc.com/2017/11/20/imports-certificates-and-private-keys-from-a-personal-information-exchange-pfx-file-to-the-destination-store/
