# Nuxt PWA Element UI Starter

[![CircleCI Build Status](https://badgen.net/circleci/github/jefrydco/nuxt-pwa-element-ui-starter/master)](https://circleci.com/gh/jefrydco/nuxt-pwa-element-ui-starter)
[![Azure Build Status](https://dev.azure.com/jefrydco/jefrydco/_apis/build/status/jefrydco.nuxt-pwa-element-ui-starter)](https://dev.azure.com/jefrydco/jefrydco/_build?definitionId=1)
[![Coverage Status](https://badgen.net/codecov/c/github/jefrydco/nuxt-pwa-element-ui-starter/master)](https://codecov.io/gh/jefrydco/nuxt-pwa-element-ui-starter)

> Nuxt.js + PWA + Element UI starter project

## Features

This starter project includes official Nuxt.js modules for best PWA project:

- [Axios](https://github.com/nuxt-community/axios-module)
- [Component-cache](https://github.com/nuxt-community/modules/tree/master/packages/component-cache)
- [Dotenv](https://github.com/nuxt-community/dotenv-module)
- [Google-analytics](https://github.com/nuxt-community/analytics-module)
- [PWA](https://github.com/nuxt-community/pwa-module)
- [Sentry](https://github.com/nuxt-community/sentry-module)
- [Sitemap](https://github.com/nuxt-community/sitemap-module)

It is also enriched with the best Vue's UI framework:

- [Element UI](https://element.eleme.io)

## Setup

```bash
# install dependencies
$ yarn # Or npm install

# serve with hot reload at localhost:3000
$ yarn dev

# build for production and launch server
$ yarn build
$ yarn start

# generate static project
$ yarn generate

# Run unit test
$ yarn test

# Run e2e test
$ yarn dev
$ yarn test:e2e
```

## Getting Started

Don't forget to change your sentry dsn and google analytics id in `.env.example` file.

For detailed explanation on how things work, check out the [Nuxt.js](https://github.com/nuxt/nuxt.js) and [Element UI](https://element.eleme.io) documentation.

## License

[MIT License](./license.md)

Copyright (c) Jefry Dewangga (@jefrydco)
