import {Store} from './store';

export const UltimaInformatica: Store = {
  currency: '€',
  labels: {
    inStock: {
      container:
        '#add-to-cart-or-refresh > div.product_header_container.pt-3 > div.product-prices > div:nth-child(2) > div > div.p-add-to-cart > div.product-add-to-cart > div > div.col.col-12.col-sm-auto.addMobileFixed > div > button',
      text: ['Añadir al carrito'],
    },
    maxPrice: {
      container:
        '#add-to-cart-or-refresh > div.product_header_container.pt-3 > div.product-prices > div:nth-child(2) > div > span',
      euroFormat: true,
    },
    outOfStock: {
      container:
        '#add-to-cart-or-refresh > div.product_header_container.pt-3 > div.product-prices > div:nth-child(2) > div > div.p-add-to-cart > div.product-add-to-cart > div > div.col.col-12.col-sm-auto.addMobileFixed > div > button',
      text: ['Avísame cuando esté disponible de nuevo'],
    },
  },
  links: [
    {
      brand: 'test:brand',
      model: 'test:model',
      series: 'test:series',
      url: 'https://ultimainformatica.com/tarjetas-graficas/33826-zotac-geforce-gt-730-2gb-nvidia-gddr3-4895173605109.html',
    },
    // 3090
    {
      brand: 'pny',
      model: 'xlr8 revel',
      series: '3090',
      url: 'https://ultimainformatica.com/tarjetas-graficas/96357-pny-vcg309024tfxppb-tarjeta-grafica-nvidia-geforce-rtx-3090-24-gb-gddr6x-0751492639543.html',
    },
    {
      brand: 'pny',
      model: 'xlr8 gaming uprising epic x',
      series: '3090',
      url: 'https://ultimainformatica.com/tarjetas-graficas/90878-pny-vcg309024tfxmpb-tarjeta-grafica-nvidia-geforce-rtx-3090-24-gb-gddr6x-0751492639536.html',
    },
    {
      brand: 'palit',
      model: 'gamerock oc',
      series: '3090',
      url: 'https://ultimainformatica.com/tarjetas-graficas/85501-palit-rtx3090-game-rock-oc-nvidia-geforce-rtx-3090-24-gb-gddr6x-4710562242065.html',
    },
    {
      brand: 'palit',
      model: 'gaming oc pro',
      series: '3090',
      url: 'https://ultimainformatica.com/tarjetas-graficas/84986-palit-ned3090s19sb-132ba-tarjeta-grafica-nvidia-geforce-rtx-3090-24-gb-gddr6x-4710562242027.html',
    },
    {
      brand: 'palit',
      model: 'gaming pro',
      series: '3090',
      url: 'https://ultimainformatica.com/tarjetas-graficas/86580-palit-ned3090019sb-132ba-tarjeta-grafica-nvidia-geforce-rtx-3090-24-gb-gddr6x-4710562241969.html',
    },
    {
      brand: 'palit',
      model: 'gamerock',
      series: '3090',
      url: 'https://ultimainformatica.com/tarjetas-graficas/85502-palit-geforce-rtx-3090-gamerock-nvidia-geforce-rtx-3090-24-gb-gddr6x-4710562242041.html',
    },
    {
      brand: 'gainward',
      model: 'phoenix',
      series: '3090',
      url: 'https://ultimainformatica.com/tarjetas-graficas/86579-gainward-471056224-1976-nvidia-geforce-rtx-3090-24-gb-gddr6x-4710562241976.html',
    },
    {
      brand: 'zotac',
      model: 'trinity',
      series: '3090',
      url: 'https://ultimainformatica.com/tarjetas-graficas/82858-zotac-zt-a30900d-10p-tarjeta-grafica-nvidia-geforce-rtx-3090-24-gb-gddr6x-4895173622427.html',
    },
    {
      brand: 'zotac',
      model: 'trinity oc',
      series: '3090',
      url: 'https://ultimainformatica.com/tarjetas-graficas/87480-zotac-gaming-geforce-rtx-3090-trinity-oc-nvidia-24-gb-gddr6x-4895173622861.html',
    },
    {
      brand: 'gigabyte',
      model: 'gaming oc',
      series: '3090',
      url: 'https://ultimainformatica.com/tarjetas-graficas/87425-gigabyte-gv-n3090gaming-oc-24gd-tarjeta-grafica-nvidia-geforce-rtx-3090-24-gb-gddr6x-4719331307547.html',
    },
    {
      brand: 'gigabyte',
      model: 'vision',
      series: '3090',
      url: 'https://ultimainformatica.com/tarjetas-graficas/84734-gigabyte-geforce-rtx-3090-vision-oc-24g-nvidia-24-gb-gddr6x-4719331307585.html',
    },
    {
      brand: 'asus',
      model: 'tuf',
      series: '3090',
      url: 'https://ultimainformatica.com/tarjetas-graficas/88963-asus-tuf-gaming-tuf-rtx3090-24g-gaming-nvidia-geforce-rtx-3090-24-gb-gddr6x-4718017909297.html',
    },
    {
      brand: 'asus',
      model: 'tuf oc',
      series: '3090',
      url: 'https://ultimainformatica.com/tarjetas-graficas/84886-asus-tuf-gaming-tuf-rtx3090-o24g-gaming-nvidia-geforce-rtx-3090-24-gb-gddr6x-4718017922814.html',
    },
    {
      brand: 'asus',
      model: 'ekwb',
      series: '3090',
      url: 'https://ultimainformatica.com/tarjetas-graficas/86864-asus-rtx3090-24g-ek-nvidia-geforce-rtx-3090-24-gb-gddr6x-4718017990844.html',
    },
    {
      brand: 'gigabyte',
      model: 'turbo',
      series: '3090',
      url: 'https://ultimainformatica.com/tarjetas-graficas/85589-gigabyte-gv-n3090turbo-24gd-tarjeta-grafica-nvidia-geforce-rtx-3090-24-gb-gddr6x-4719331307714.html',
    },
    {
      brand: 'msi',
      model: 'gaming x trio',
      series: '3090',
      url: 'https://ultimainformatica.com/tarjetas-graficas/82811-msi-rtx-3090-gaming-x-trio-24g-tarjeta-grafica-nvidia-geforce-rtx-3090-24-gb-gddr6x-4719072762506.html',
    },
    {
      brand: 'msi',
      model: 'suprim',
      series: '3090',
      url: 'https://ultimainformatica.com/tarjetas-graficas/86917-msi-geforce-rtx-3090-suprim-x-24g-nvidia-24-gb-gddr6x-4719072762490.html',
    },
    {
      brand: 'gigabyte',
      model: 'aorus xtreme',
      series: '3090',
      url: 'https://ultimainformatica.com/tarjetas-graficas/85590-gigabyte-aorus-gv-n3090aorus-x-24gd-tarjeta-grafica-nvidia-geforce-rtx-3090-24-gb-gddr6x-4719331307660.html',
    },
    {
      brand: 'gigabyte',
      model: 'aorus box',
      series: '3090',
      url: 'https://ultimainformatica.com/tarjetas-graficas/86295-gigabyte-aorus-rtx-3090-gaming-box-nvidia-geforce-rtx-3090-24-gb-gddr6x-4719331308247.html',
    },
    {
      brand: 'gigabyte',
      model: 'aorus master',
      series: '3090',
      url: 'https://ultimainformatica.com/tarjetas-graficas/83421-gigabyte-aorus-gv-n3090aorus-m-24gd-tarjeta-grafica-nvidia-geforce-rtx-3090-24-gb-gddr6x-4719331307615.html',
    },
    {
      brand: 'asus',
      model: 'turbo',
      series: '3090',
      url: 'https://ultimainformatica.com/tarjetas-graficas/86145-asus-turbo-rtx3090-24g-nvidia-geforce-rtx-3090-24-gb-gddr6x-4718017993524.html',
    },
    {
      brand: 'asus',
      model: 'strix white',
      series: '3090',
      url: 'https://ultimainformatica.com/tarjetas-graficas/87407-asus-rog-strix-rtx3090-24g-white-nvidia-geforce-rtx-3090-24-gb-gddr6x-4711081002529.html',
    },
    {
      brand: 'asus',
      model: 'strix oc white',
      series: '3090',
      url: 'https://ultimainformatica.com/tarjetas-graficas/87113-asus-rog-strix-rtx3090-o24g-white-nvidia-geforce-rtx-3090-24-gb-gddr6x-4711081002635.html',
    },
    {
      brand: 'asus',
      model: 'strix',
      series: '3090',
      url: 'https://ultimainformatica.com/tarjetas-graficas/89268-asus-rog-strix-rtx3090-24g-gaming-nvidia-geforce-rtx-3090-24-gb-gddr6x-4718017908955.html',
    },
    {
      brand: 'asus',
      model: 'strix',
      series: '3090',
      url: 'https://ultimainformatica.com/tarjetas-graficas/84885-asus-rog-strix-rtx3090-o24g-gaming-nvidia-geforce-rtx-3090-24-gb-gddr6x-4718017928618.html',
    },
    {
      brand: 'evga',
      model: 'ftw3 ultra',
      series: '3090',
      url: 'https://ultimainformatica.com/tarjetas-graficas/93161-evga-24g-p5-3987-kr-tarjeta-grafica-nvidia-geforce-rtx-3090-24-gb-gddr6x-4250812438171.html',
    },
    {
      brand: 'gigabyte',
      model: 'aorus box',
      series: '3090',
      url: 'https://ultimainformatica.com/tarjetas-graficas/86124-gigabyte-aorus-rtx-3080-gaming-box-nvidia-geforce-rtx-3080-10-gb-gddr6x-4719331308230.html',
    },
    {
      brand: 'gigabyte',
      model: 'turbo',
      series: '3090',
      url: 'https://ultimainformatica.com/tarjetas-graficas/90356-gigabyte-gv-n3080turbo-10gd-tarjeta-grafica-nvidia-geforce-rtx-3080-10-gb-gddr6x-4719331308315.html',
    },
    {
      brand: 'gigabyte',
      model: 'aorus xtreme waterforce wb',
      series: '3090',
      url: 'https://ultimainformatica.com/tarjetas-graficas/86841-gigabyte-aorus-geforce-rtx-3090-xtreme-waterforce-wb-24g-nvidia-24-gb-gddr6x-4719331307608.html',
    },
    {
      brand: 'gigabyte',
      model: 'aorus xtreme waterforce',
      series: '3090',
      url: 'https://ultimainformatica.com/tarjetas-graficas/86831-gigabyte-aorus-geforce-rtx-3090-xtreme-waterforce-24g-nvidia-24-gb-gddr6x-4719331307646.html',
    },
    {
      brand: 'gigabyte',
      model: 'eagle oc',
      series: '3090',
      url: 'https://ultimainformatica.com/tarjetas-graficas/82825-gigabyte-gv-n3090eagle-oc-24gd-tarjeta-grafica-nvidia-geforce-rtx-3090-24-gb-gddr6x-4719331307578.html',
    },
    {
      brand: 'gigabyte',
      model: 'eagle',
      series: '3090',
      url: 'https://ultimainformatica.com/tarjetas-graficas/84775-gigabyte-geforce-rtx-3090-eagle-24g-nvidia-24-gb-gddr6x-4719331307806.html',
    },
    {
      brand: 'msi',
      model: 'ventus 3x oc',
      series: '3090',
      url: 'https://ultimainformatica.com/tarjetas-graficas/82812-msi-geforce-rtx-3090-ventus-3x-24g-oc-nvidia-24-gb-gddr6x-4719072762476.html',
    },
    // 3080ti
    {
      brand: 'asus',
      model: 'strix lc',
      series: '3080ti',
      url: 'https://ultimainformatica.com/tarjetas-graficas/98325-asus-rog-strix-lc-rtx3080ti-12g-gaming-nvidia-geforce-rtx-3080-ti-12-gb-gddr6x-222558-222559-222560-222561-222562-4711081220855.html',
    },
    {
      brand: 'asus',
      model: 'strix oc lc',
      series: '3080ti',
      url: 'https://ultimainformatica.com/tarjetas-graficas/98324-asus-rog-strix-lc-rtx3080ti-o12g-gaming-nvidia-geforce-rtx-3080-ti-12-gb-gddr6x-222553-222554-222555-222556-222557-4711081220824.html',
    },
    {
      brand: 'asus',
      model: 'strix',
      series: '3080ti',
      url: 'https://ultimainformatica.com/tarjetas-graficas/98322-asus-rog-strix-rtx3080ti-12g-gaming-nvidia-geforce-rtx-3080-ti-12-gb-gddr6x-222543-222544-222545-222546-222547-4711081171225.html',
    },
    {
      brand: 'asus',
      model: 'strix oc',
      series: '3080ti',
      url: 'https://ultimainformatica.com/tarjetas-graficas/98323-asus-rog-strix-rtx3080ti-o12g-gaming-nvidia-geforce-rtx-3080-ti-12-gb-gddr6x-222548-222549-222550-222551-222552-4711081169765.html',
    },
    {
      brand: 'asus',
      model: 'tuf oc',
      series: '3080ti',
      url: 'https://ultimainformatica.com/tarjetas-graficas/98328-asus-tuf-gaming-tuf-rtx3080ti-o12g-gaming-nvidia-geforce-rtx-3080-ti-12-gb-gddr6x-222568-222569-222570-222571-222572-4711081169802.html',
    },
    {
      brand: 'asus',
      model: 'tuf',
      series: '3080ti',
      url: 'https://ultimainformatica.com/tarjetas-graficas/98327-asus-tuf-rtx3080ti-12g-gaming-nvidia-geforce-rtx-3080-ti-12-gb-gddr6x-222563-222564-222565-222566-222567-4711081169864.html',
    },
    {
      brand: 'gigabyte',
      model: 'aorus master',
      series: '3080ti',
      url: 'https://ultimainformatica.com/tarjetas-graficas/99483-gigabyte-aorus-geforce-rtx-3080-ti-master-12g-nvidia-12-gb-gddr6x-4719331308865.html',
    },
    {
      brand: 'gigabyte',
      model: 'eagle',
      series: '3080ti',
      url: 'https://ultimainformatica.com/tarjetas-graficas/99488-gigabyte-eagle-12g-nvidia-geforce-rtx-3080-ti-12-gb-gddr6x-4719331308834.html',
    },
    {
      brand: 'msi',
      model: 'gaming x trio',
      series: '3080ti',
      url: 'https://ultimainformatica.com/tarjetas-graficas/98362-msi-geforce-rtx-3080-ti-gaming-x-trio-12g-nvidia-12-gb-gddr6x-222613-222614-222615-222616-222617-4719072824969.html',
    },
    {
      brand: 'msi',
      model: 'suprim x',
      series: '3080ti',
      url: 'https://ultimainformatica.com/tarjetas-graficas/99499-msi-geforce-rtx-3080-ti-suprim-x-12g-nvidia-12-gb-gddr6x-4719072813390.html',
    },
    {
      brand: 'msi',
      model: 'ventus 3x oc',
      series: '3080ti',
      url: 'https://ultimainformatica.com/tarjetas-graficas/98995-msi-geforce-rtx-3080-ti-ventus-3x-12g-oc-tarjeta-grafica-nvidia-12-gb-gddr6x-224033-224034-224035-224036-224037-4719072821364.html',
    },
    {
      brand: 'pny',
      model: 'xlr8 revel',
      series: '3080ti',
      url: 'https://ultimainformatica.com/tarjetas-graficas/98427-pny-vcg3080t12tfxppb-tarjeta-grafica-nvidia-geforce-rtx-3080-ti-12-gb-gddr6x-222753-222754-222755-222756-222757-0751492645360.html',
    },
    {
      brand: 'zotac',
      model: 'trinity',
      series: '3080ti',
      url: 'https://ultimainformatica.com/tarjetas-graficas/99498-zotac-zt-a30810d-10p-tarjeta-grafica-nvidia-geforce-rtx-3080-ti-12-gb-gddr6x-4895173623189.html',
    },
    {
      brand: 'zotac',
      model: 'amp holo',
      series: '3080ti',
      url: 'https://ultimainformatica.com/tarjetas-graficas/99497-zotac-zt-a30810f-10p-tarjeta-grafica-nvidia-geforce-rtx-3080-ti-12-gb-gddr6x-4895173623196.html',
    },
    {
      brand: 'zotac',
      model: 'trinity oc',
      series: '3080ti',
      url: 'https://ultimainformatica.com/tarjetas-graficas/99496-zotac-zt-a30810j-10p-tarjeta-grafica-nvidia-geforce-rtx-3080-ti-12-gb-gddr6x-4895173623202.html',
    },
    // 3080
    {
      brand: 'gigabyte',
      model: 'eagle',
      series: '3080',
      url: 'https://ultimainformatica.com/tarjetas-graficas/87183-gigabyte-geforce-rtx-3080-eagle-10g-nvidia-10-gb-gddr6x-4719331307851.html',
    },
    {
      brand: 'gigabyte',
      model: 'eagle oc',
      series: '3080',
      url: 'https://ultimainformatica.com/tarjetas-graficas/82612-gigabyte-gv-n3080eagle-oc-10gd-tarjeta-grafica-nvidia-geforce-rtx-3080-10-gb-gddr6x-4719331307554.html',
    },
    {
      brand: 'msi',
      model: 'ventus 3x oc',
      series: '3080',
      url: 'https://ultimainformatica.com/tarjetas-graficas/82611-msi-geforce-rtx-3080-ventus-3x-10g-oc-nvidia-10-gb-gddr6x-4719072762520.html',
    },
    {
      brand: 'gigabyte',
      model: 'gaming oc',
      series: '3080',
      url: 'https://ultimainformatica.com/tarjetas-graficas/82613-gigabyte-gv-n3080gaming-oc-10gd-tarjeta-grafica-nvidia-geforce-rtx-3080-10-gb-gddr6x-4719331307530.html',
    },
    {
      brand: 'msi',
      model: 'gaming x trio',
      series: '3080',
      url: 'https://ultimainformatica.com/tarjetas-graficas/82665-msi-rtx-3080-gaming-x-trio-10g-tarjeta-grafica-nvidia-geforce-rtx-3080-10-gb-gddr6x-4719072762544.html',
    },
    {
      brand: 'msi',
      model: 'gaming z trio',
      series: '3080',
      url: 'https://ultimainformatica.com/tarjetas-graficas/93079-msi-rtx-3080-gaming-z-trio-10g-tarjeta-grafica-nvidia-geforce-rtx-3080-10-gb-gddr6x-4719072800703.html',
    },
    {
      brand: 'msi',
      model: 'suprim',
      series: '3080',
      url: 'https://ultimainformatica.com/tarjetas-graficas/85531-msi-geforce-rtx-3080-suprim-x-10g-nvidia-10-gb-gddr6x-4719072762537.html',
    },
    {
      brand: 'asus',
      model: 'tuf oc',
      series: '3080',
      url: 'https://ultimainformatica.com/tarjetas-graficas/81972-asus-tuf-gaming-tuf-rtx3080-o10g-gaming-nvidia-geforce-rtx-3080-10-gb-gddr6x-4718017922760.html',
    },
    {
      brand: 'asus',
      model: 'tuf',
      series: '3080',
      url: 'https://ultimainformatica.com/tarjetas-graficas/81969-asus-tuf-gaming-tuf-rtx3080-10g-gaming-nvidia-geforce-rtx-3080-10-gb-gddr6x-4718017909327.html',
    },
    {
      brand: 'asus',
      model: 'turbo',
      series: '3080',
      url: 'https://ultimainformatica.com/tarjetas-graficas/88509-asus-turbo-rtx3080-10g-nvidia-geforce-rtx-3080-10-gb-gddr6x-4711081076070.html',
    },
    {
      brand: 'asus',
      model: 'strix oc',
      series: '3080',
      url: 'https://www.pccomponentes.com/asus-rog-strix-geforce-rtx-3080-10g-gaming-oc-10gb-gddr6x',
    },
    {
      brand: 'asus',
      model: 'strix oc white',
      series: '3080',
      url: 'https://ultimainformatica.com/tarjetas-graficas/86865-asus-rog-strix-rtx3080-o10g-white-nvidia-geforce-rtx-3080-10-gb-gddr6x-4711081002925.html',
    },
    {
      brand: 'zotac',
      model: 'amp holo',
      series: '3080',
      url: 'https://ultimainformatica.com/tarjetas-graficas/85293-zotac-zt-a30800f-10p-tarjeta-grafica-nvidia-geforce-rtx-3080-10-gb-gddr6x-4895173622465.html',
    },
    {
      brand: 'asus',
      model: 'strix',
      series: '3080',
      url: 'https://ultimainformatica.com/tarjetas-graficas/87949-asus-rog-strix-rtx3080-10g-gaming-nvidia-geforce-rtx-3080-10-gb-gddr6x-4718017909150.html',
    },
    {
      brand: 'asus',
      model: 'strix white',
      series: '3080',
      url: 'https://ultimainformatica.com/tarjetas-graficas/90330-asus-rog-strix-rtx3080-10g-white-nvidia-geforce-rtx-3080-10-gb-gddr6x-4711081002802.html',
    },
    {
      brand: 'zotac',
      model: 'trinity',
      series: '3080',
      url: 'https://ultimainformatica.com/tarjetas-graficas/85297-zotac-zt-a30800d-10p-tarjeta-grafica-nvidia-geforce-rtx-3080-10-gb-gddr6x-4895173622403.html',
    },
    {
      brand: 'zotac',
      model: 'trinity oc',
      series: '3080',
      url: 'https://ultimainformatica.com/tarjetas-graficas/85591-zotac-zt-a30800j-10p-tarjeta-grafica-nvidia-geforce-rtx-3080-10-gb-gddr6x-4895173622496.html',
    },
    {
      brand: 'gigabyte',
      model: 'vision oc',
      series: '3080',
      url: 'https://ultimainformatica.com/tarjetas-graficas/84295-gigabyte-geforce-rtx-3080-vision-oc-10g-nvidia-10-gb-gddr6x-4719331307561.html',
    },
    {
      brand: 'evga',
      model: 'ftw3 ultra',
      series: '3080',
      url: 'https://ultimainformatica.com/tarjetas-graficas/92288-evga-10g-p5-3897-kr-tarjeta-grafica-nvidia-geforce-rtx-3080-10-gb-gddr6x-4250812438287.html',
    },
    {
      brand: 'gigabyte',
      model: 'aorus master',
      series: '3080',
      url: 'https://ultimainformatica.com/tarjetas-graficas/82988-gigabyte-aorus-gv-n3080aorus-m-10gd-tarjeta-grafica-nvidia-geforce-rtx-3080-10-gb-gddr6x-4719331307639.html',
    },
    {
      brand: 'gigabyte',
      model: 'aorus xtreme',
      series: '3080',
      url: 'https://ultimainformatica.com/tarjetas-graficas/85588-gigabyte-aorus-gv-n3080aorus-x-10gd-tarjeta-grafica-nvidia-geforce-rtx-3080-10-gb-gddr6x-4719331307783.html',
    },
    {
      brand: 'gigabyte',
      model: 'aorus xtreme waterforce wb',
      series: '3080',
      url: 'https://ultimainformatica.com/tarjetas-graficas/85592-gigabyte-aorus-geforce-rtx-3080-xtreme-waterforce-wb-10g-nvidia-10-gb-gddr6x-4719331307592.html',
    },
    {
      brand: 'gigabyte',
      model: 'aorus xtreme waterforce',
      series: '3080',
      url: 'https://ultimainformatica.com/tarjetas-graficas/85551-gigabyte-aorus-geforce-rtx-3080-xtreme-waterforce-10g-nvidia-10-gb-gddr6x-4719331307622.html',
    },
    // 3070
    {
      brand: 'zotac',
      model: 'twin edge',
      series: '3070',
      url: 'https://ultimainformatica.com/tarjetas-graficas/84334-zotac-zt-a30700e-10p-tarjeta-grafica-nvidia-geforce-rtx-3070-8-gb-gddr6-4895173622472.html',
    },
    {
      brand: 'zotac',
      model: 'twin edge oc white',
      series: '3070',
      url: 'https://ultimainformatica.com/tarjetas-graficas/85896-zotac-gaming-geforce-rtx-3070-twin-edge-oc-white-edition-nvidia-8-gb-gddr6-4895173622632.html',
    },
    {
      brand: 'zotac',
      model: 'twin edge oc',
      series: '3070',
      url: 'https://ultimainformatica.com/tarjetas-graficas/84814-zotac-gaming-geforce-rtx-3070-twin-edge-oc-nvidia-8-gb-gddr6-4895173622489.html',
    },
    {
      brand: 'zotac',
      model: 'amp holo',
      series: '3070',
      url: 'https://ultimainformatica.com/tarjetas-graficas/86776-zotac-geforce-rtx-3070-amp-holo-nvidia-8-gb-gddr6-4895173622700.html',
    },
    {
      brand: 'msi',
      model: 'gaming x trio',
      series: '3070',
      url: 'https://ultimainformatica.com/tarjetas-graficas/84282-msi-geforce-rtx-3070-gaming-x-trio-nvidia-8-gb-gddr6-4719072763053.html',
    },
    {
      brand: 'gigabyte',
      model: 'gaming oc',
      series: '3070',
      url: 'https://ultimainformatica.com/tarjetas-graficas/84201-gigabyte-geforce-rtx-3070-gaming-oc-8g-nvidia-8-gb-gddr6-4719331307691.html',
    },
    {
      brand: 'msi',
      model: 'ventus 2x',
      series: '3070',
      url: 'https://ultimainformatica.com/tarjetas-graficas/84284-msi-geforce-rtx-3070-ventus-2x-oc-nvidia-8-gb-gddr6-4719072763091.html',
    },
    {
      brand: 'msi',
      model: 'ventus 3x oc',
      series: '3070',
      url: 'https://ultimainformatica.com/tarjetas-graficas/84283-msi-geforce-rtx-3070-ventus-3x-oc-nvidia-8-gb-gddr6-4719072763084.html',
    },
    {
      brand: 'msi',
      model: 'suprim x',
      series: '3070',
      url: 'https://ultimainformatica.com/tarjetas-graficas/85530-msi-geforce-rtx-3070-suprim-x-8g-nvidia-8-gb-gddr6-4719072763046.html',
    },
    {
      brand: 'asus',
      model: 'tuf oc',
      series: '3070',
      url: 'https://ultimainformatica.com/tarjetas-graficas/85296-asus-tuf-gaming-tuf-rtx3070-o8g-gaming-nvidia-geforce-rtx-3070-8-gb-gddr6-4718017948678.html',
    },
    {
      brand: 'asus',
      model: 'tuf',
      series: '3070',
      url: 'https://ultimainformatica.com/tarjetas-graficas/86867-asus-tuf-gaming-tuf-rtx3070-8g-gaming-nvidia-geforce-rtx-3070-8-gb-gddr6-4718017968881.html',
    },
    {
      brand: 'asus',
      model: 'ekwb',
      series: '3070',
      url: 'https://ultimainformatica.com/tarjetas-graficas/85657-asus-rtx3070-8g-ek-nvidia-geforce-rtx-3070-8-gb-gddr6-4718017994002.html',
    },
    {
      brand: 'asus',
      model: 'turbo',
      series: '3070',
      url: 'https://ultimainformatica.com/tarjetas-graficas/87112-asus-turbo-rtx3070-8g-nvidia-geforce-rtx-3070-8-gb-gddr6-4718017998161.html',
    },
    {
      brand: 'evga',
      model: 'xc3 ultra',
      series: '3070',
      url: 'https://ultimainformatica.com/tarjetas-graficas/90988-evga-geforce-rtx-3070-xc3-ultra-gaming-nvidia-8-gb-gddr6-4250812438492.html',
    },
    {
      brand: 'evga',
      model: 'xc3',
      series: '3070',
      url: 'https://ultimainformatica.com/tarjetas-graficas/92345-evga-geforce-rtx-3070-xc3-gaming-nvidia-8-gb-gddr6-4250812438515.html',
    },
    {
      brand: 'gigabyte',
      model: 'eagle',
      series: '3070',
      url: 'https://ultimainformatica.com/tarjetas-graficas/84768-gigabyte-gv-n3070eagle-8gd-tarjeta-grafica-nvidia-geforce-rtx-3070-8-gb-gddr6-4719331307738.html',
    },
    {
      brand: 'gigabyte',
      model: 'eagle oc',
      series: '3070',
      url: 'https://ultimainformatica.com/tarjetas-graficas/83953-gigabyte-geforce-rtx-3070-eagle-oc-8g-nvidia-8-gb-gddr6-4719331307677.html',
    },
    {
      brand: 'asus',
      model: 'dual oc',
      series: '3070',
      url: 'https://ultimainformatica.com/tarjetas-graficas/87512-asus-dual-rtx3070-o8g-nvidia-geforce-rtx-3070-8-gb-gddr6-4718017927864.html',
    },
    {
      brand: 'asus',
      model: 'dual',
      series: '3070',
      url: 'https://ultimainformatica.com/tarjetas-graficas/84134-asus-dual-rtx3070-8g-nvidia-geforce-rtx-3070-8-gb-gddr6-4718017927901.html',
    },
    {
      brand: 'asus',
      model: 'strix oc',
      series: '3070',
      url: 'https://ultimainformatica.com/tarjetas-graficas/84530-asus-rog-strix-rtx3070-o8g-gaming-nvidia-geforce-rtx-3070-8-gb-gddr6-4718017938150.html',
    },
    {
      brand: 'gigabyte',
      model: 'vision oc',
      series: '3070',
      url: 'https://ultimainformatica.com/tarjetas-graficas/84202-gigabyte-geforce-rtx-3070-vision-oc-8g-nvidia-8-gb-gddr6-4719331307790.html',
    },
    {
      brand: 'gigabyte',
      model: 'aorus master',
      series: '3070',
      url: 'https://ultimainformatica.com/tarjetas-graficas/84391-gigabyte-aorus-geforce-rtx-3070-master-8g-nvidia-8-gb-gddr6-4719331307844.html',
    },
    {
      brand: 'evga',
      model: 'ftw3 ultra',
      series: '3070',
      url: 'https://ultimainformatica.com/tarjetas-graficas/92289-evga-geforce-rtx-3070-ftw3-ultra-gaming-nvidia-8-gb-gddr6-4250812438478.html',
    },
    {
      brand: 'asus',
      model: 'strix',
      series: '3070',
      url: 'https://ultimainformatica.com/tarjetas-graficas/84822-asus-rog-strix-rtx3070-8g-gaming-nvidia-geforce-rtx-3070-8-gb-gddr6-4718017909174.html',
    },
    {
      brand: 'asus',
      model: 'strix white',
      series: '3070',
      url: 'https://ultimainformatica.com/tarjetas-graficas/86031-asus-rog-strix-rtx3070-8g-white-nvidia-geforce-rtx-3070-8-gb-gddr6-4711081014652.html',
    },
    // 3060ti
    {
      brand: 'msi',
      model: 'ventus 2x',
      series: '3060ti',
      url: 'https://ultimainformatica.com/tarjetas-graficas/87470-msi-geforce-rtx-3060-ti-ventus-2x-ocv1-nvidia-8-gb-gddr6-4719072780784.html',
    },
    {
      brand: 'msi',
      model: 'ventus 2x oc',
      series: '3060ti',
      url: 'https://ultimainformatica.com/tarjetas-graficas/85672-msi-geforce-rtx-3060-ti-ventus-2x-oc-nvidia-8-gb-gddr6-4719072763121.html',
    },
    {
      brand: 'gigabyte',
      model: 'eagle',
      series: '3060ti',
      url: 'https://ultimainformatica.com/tarjetas-graficas/85669-gigabyte-geforce-rtx-3060-ti-eagle-8g-nvidia-8-gb-gddr6-4719331307776.html',
    },
    {
      brand: 'gigabyte',
      model: 'eagle oc',
      series: '3060ti',
      url: 'https://ultimainformatica.com/tarjetas-graficas/85667-gigabyte-geforce-rtx-3060-ti-eagle-oc-8g-nvidia-8-gb-gddr6-4719331307769.html',
    },
    {
      brand: 'gigabyte',
      model: 'vision oc',
      series: '3060ti',
      url: 'https://ultimainformatica.com/tarjetas-graficas/87586-gigabyte-geforce-rtx-3060-ti-vision-oc-8g-nvidia-8-gb-gddr6-4719331308513.html',
    },
    {
      brand: 'asus',
      model: 'dual',
      series: '3060ti',
      url: 'https://ultimainformatica.com/tarjetas-graficas/86861-asus-dual-rtx3060ti-8g-nvidia-geforce-rtx-3060-ti-8-gb-gddr6-4718017962995.html',
    },
    {
      brand: 'asus',
      model: 'dual oc',
      series: '3060ti',
      url: 'https://ultimainformatica.com/tarjetas-graficas/86118-asus-dual-rtx3060ti-o8g-nvidia-geforce-rtx-3060-ti-8-gb-gddr6-4718017963046.html',
    },
    {
      brand: 'asus',
      model: 'dual mini',
      series: '3060ti',
      url: 'https://ultimainformatica.com/tarjetas-graficas/86995-asus-dual-rtx3060ti-8g-mini-nvidia-geforce-rtx-3060-ti-8-gb-gddr6-4711081004769.html',
    },
    {
      brand: 'asus',
      model: 'dual mini oc',
      series: '3060ti',
      url: 'https://ultimainformatica.com/tarjetas-graficas/86996-asus-dual-rtx3060ti-o8g-mini-nvidia-geforce-rtx-3060-ti-8-gb-gddr6-4711081004691.html',
    },
    {
      brand: 'gigabyte',
      model: 'gaming oc pro',
      series: '3060ti',
      url: 'https://ultimainformatica.com/tarjetas-graficas/89358-gigabyte-geforce-rtx-3060-ti-gaming-oc-pro-8g-rev-20-nvidia-8-gb-gddr6-4719331308551.html',
    },
    {
      brand: 'gigabyte',
      model: 'gaming oc pro',
      series: '3060ti',
      url: 'https://ultimainformatica.com/tarjetas-graficas/85670-gigabyte-geforce-rtx-3060-ti-gaming-oc-pro-8g-nvidia-8-gb-gddr6-4719331307943.html',
    },
    {
      brand: 'gigabyte',
      model: 'gaming oc',
      series: '3060ti',
      url: 'https://ultimainformatica.com/tarjetas-graficas/85668-gigabyte-geforce-rtx-3060-ti-gaming-oc-8g-nvidia-8-gb-gddr6-4719331307752.html',
    },
    {
      brand: 'msi',
      model: 'gaming x',
      series: '3060ti',
      url: 'https://ultimainformatica.com/tarjetas-graficas/89537-msi-rtx-3060-ti-gaming-x-tarjeta-grafica-nvidia-geforce-rtx-3060-ti-8-gb-gddr6-4719072781767.html',
    },
    {
      brand: 'msi',
      model: 'ventus 3x oc',
      series: '3060ti',
      url: 'https://ultimainformatica.com/tarjetas-graficas/86316-msi-geforce-rtx-3060-ti-ventus-3x-oc-nvidia-8-gb-gddr6-4719072763152.html',
    },
    {
      brand: 'zotac',
      model: 'twin edge',
      series: '3060ti',
      url: 'https://ultimainformatica.com/tarjetas-graficas/87948-zotac-zt-a30610e-10m-tarjeta-grafica-nvidia-geforce-rtx-3060-ti-8-gb-gddr6-4895173622502.html',
    },
    {
      brand: 'zotac',
      model: 'twin edge oc',
      series: '3060ti',
      url: 'https://ultimainformatica.com/tarjetas-graficas/87947-zotac-zt-a30610h-10m-tarjeta-grafica-nvidia-geforce-rtx-3060-ti-8-gb-gddr6-4895173622519.html',
    },
    {
      brand: 'asus',
      model: 'strix',
      series: '3060ti',
      url: 'https://ultimainformatica.com/tarjetas-graficas/86863-asus-rog-strix-rtx3060ti-8g-gaming-nvidia-geforce-rtx-3060-ti-8-gb-gddr6-4718017952880.html',
    },
    {
      brand: 'asus',
      model: 'strix oc',
      series: '3060ti',
      url: 'https://ultimainformatica.com/tarjetas-graficas/87166-asus-rog-strix-rtx3060ti-o8g-gaming-nvidia-geforce-rtx-3060-ti-8-gb-gddr6-4718017953085.html',
    },
    {
      brand: 'asus',
      model: 'tuf oc',
      series: '3060ti',
      url: 'https://ultimainformatica.com/tarjetas-graficas/87362-asus-tuf-gaming-tuf-rtx3060ti-o8g-gaming-nvidia-geforce-rtx-3060-ti-8-gb-gddr6-4718017953221.html',
    },
    {
      brand: 'asus',
      model: 'tuf',
      series: '3060ti',
      url: 'https://ultimainformatica.com/tarjetas-graficas/86862-asus-tuf-gaming-tuf-rtx3060ti-8g-gaming-nvidia-geforce-rtx-3060-ti-8-gb-gddr6-4718017953184.html',
    },
    {
      brand: 'msi',
      model: 'gaming x trio',
      series: '3060ti',
      url: 'https://ultimainformatica.com/tarjetas-graficas/85671-msi-geforce-rtx-3060-ti-gaming-x-trio-nvidia-8-gb-gddr6-4719072763145.html',
    },
    {
      brand: 'evga',
      model: 'xc gaming',
      series: '3060ti',
      url: 'https://ultimainformatica.com/tarjetas-graficas/92816-evga-geforce-rtx-3060-ti-xc-gaming-nvidia-8-gb-gddr6-4250812439208.html',
    },
    {
      brand: 'gigabyte',
      model: 'aorus master',
      series: '3060ti',
      url: 'https://ultimainformatica.com/tarjetas-graficas/85666-gigabyte-aorus-geforce-rtx-3060-ti-master-8g-nvidia-8-gb-gddr6-4719331307967.html',
    },
  ],
  name: 'ultimainformatica',
};
