import {Store} from './store';

export const Siabyte: Store = {
  currency: '€',
  labels: {
    inStock: {
      container: '#availability_value',
      text: ['Disponibilidad inmediata', 'Disponibilidad estimada'],
    },
    maxPrice: {
      container: '#our_price_display',
      euroFormat: true,
    },
    outOfStock: {
      container: '#availability_value',
      text: ['Este producto ya no está disponible'],
    },
  },
  links: [
    {
      brand: 'test:brand',
      model: 'test:model',
      series: 'test:series',
      url: 'https://siabyte.com/fuentes-alimentacion/973-corsair-cx750-750w-80-plus-bronze.html',
    },
    {
      brand: 'test:brand',
      model: 'test:model',
      series: 'test:series',
      url: 'https://siabyte.com/tarjetas-graficas/981-evga-geforce-rtx-3080-ti-ftw3-ultra-12gb-gddr6x.html',
    },
    {
      brand: 'asus',
      model: 'gaming',
      series: '3090',
      url: 'https://siabyte.com/tarjetas-graficas/887-asus-rog-strix-geforce-rtx-3090-gaming-24gb-gddr6x.html',
    },
    {
      brand: 'asus',
      model: 'tuf',
      series: '3090',
      url: 'https://siabyte.com/tarjetas-graficas/889-asus-tuf-geforce-rtx-3090-gaming-24gb-gddr6x.html',
    },
    {
      brand: 'evga',
      model: 'ftw3 ultra',
      series: '3090',
      url: 'https://siabyte.com/tarjetas-graficas/842-evga-geforce-rtx-3090-ftw3-ultra-gaming-24gb-gddr6x.html',
    },
    {
      brand: 'evga',
      model: 'xc3 ultra',
      series: '3090',
      url: 'https://siabyte.com/tarjetas-graficas/855-evga-geforce-rtx-3090-xc3-ultra-gaming-24gb-gddr6x.html',
    },
    {
      brand: 'gigabyte',
      model: 'gaming oc',
      series: '3090',
      url: 'https://siabyte.com/tarjetas-graficas/863-gigabyte-geforce-rtx-3090-gaming-oc-24g-24gb-gddr6x.html',
    },
    {
      brand: 'gigabyte',
      model: 'aorus master',
      series: '3090',
      url: 'https://siabyte.com/tarjetas-graficas/864-gigabyte-aorus-geforce-rtx-3090-master-24gb-gddr6x.html',
    },
    {
      brand: 'gigabyte',
      model: 'turbo',
      series: '3090',
      url: 'https://siabyte.com/tarjetas-graficas/953-gigabyte-geforce-rtx-3090-turbo-24gb-gddr6x.html',
    },
    {
      brand: 'gigabyte',
      model: 'aorus xtreme',
      series: '3090',
      url: 'https://siabyte.com/tarjetas-graficas/955-gigabyte-aorus-geforce-rtx-3090-xtreme-24gb-gddrx6.html',
    },
    {
      brand: 'msi',
      model: 'ventus 3x oc',
      series: '3090',
      url: 'https://siabyte.com/tarjetas-graficas/922-msi-geforce-rtx-3090-ventus-3x-oc-24gb-gddr6x.html',
    },
    {
      brand: 'palit',
      model: 'gaming pro oc',
      series: '3090',
      url: 'https://siabyte.com/tarjetas-graficas/880-palit-geforce-rtx-3090-gaming-pro-oc-24gb-gddr6x.html',
    },
    {
      brand: 'palit',
      model: 'gaming pro',
      series: '3090',
      url: 'https://siabyte.com/tarjetas-graficas/893-palit-geforce-rtx-3090-gaming-pro-24gb-gddr6x.html',
    },
    {
      brand: 'palit',
      model: 'gamerock oc',
      series: '3090',
      url: 'https://siabyte.com/tarjetas-graficas/894-palit-geforce-rtx-3090-gamerock-oc-24gb-gddr6x.html',
    },
    {
      brand: 'palit',
      model: 'gamerock',
      series: '3090',
      url: 'https://siabyte.com/tarjetas-graficas/895-palit-geforce-rtx-3090-gamerock-24gb-gddr6x.html',
    },
    {
      brand: 'palit',
      model: 'trinity oc',
      series: '3090',
      url: 'https://siabyte.com/tarjetas-graficas/938-zotac-gaming-geforce-rtx-3090-trinity-oc-24gb-gddr6x.html',
    },
    // 3080 ti
    {
      brand: 'evga',
      model: 'ftw3 ultra',
      series: '3080ti',
      url: 'https://siabyte.com/tarjetas-graficas/981-evga-geforce-rtx-3080-ti-ftw3-ultra-12gb-gddr6x.html',
    },
    {
      brand: 'msi',
      model: 'suprim x',
      series: '3080ti',
      url: 'https://siabyte.com/rtx-3080/979-msi-geforce-rtx-3080-ti-suprim-x-12gb-gddr6x.html',
    },
    {
      brand: 'zotac',
      model: 'amp holo',
      series: '3080ti',
      url: 'https://siabyte.com/tarjetas-graficas/980-zotac-gaming-geforce-rtx-3080-ti-amp-holo-12gb-gddr6x.html',
    },
    // 3080
    {
      brand: 'asus',
      model: 'tuf oc',
      series: '3080',
      url: 'https://siabyte.com/tarjetas-graficas/920-asus-tuf-geforce-rtx-3080-oc-10gb-gddr6x.html',
    },
    {
      brand: 'asus',
      model: 'strix oc',
      series: '3080',
      url: 'https://siabyte.com/tarjetas-graficas/923-asus-rog-strix-geforce-rtx-3080-10g-gaming-oc-10gb-gddr6x.html',
    },
    {
      brand: 'asus',
      model: 'strix oc white',
      series: '3080',
      url: 'https://siabyte.com/tarjetas-graficas/928-asus-rog-strix-geforce-rtx-3080-oc-10gb-gddr6x.html',
    },
    {
      brand: 'evga',
      model: 'xc3 ultra',
      series: '3080',
      url: 'https://siabyte.com/tarjetas-graficas/838-evga-geforce-rtx-3080-xc3-ultra-gaming-10gb-gddr6x.html',
    },
    {
      brand: 'evga',
      model: 'ftw3 ultra',
      series: '3080',
      url: 'https://siabyte.com/tarjetas-graficas/839-evga-geforce-rtx-3080-ftw3-ultra-gaming-10gb-gddr6x.html',
    },
    {
      brand: 'evga',
      model: 'xc3 black',
      series: '3080',
      url: 'https://siabyte.com/tarjetas-graficas/848-evga-geforce-rtx-3080-xc3-black-gaming-10gb-gddr6x.html',
    },
    {
      brand: 'evga',
      model: 'xc3 ultra hybrid',
      series: '3080',
      url: 'https://siabyte.com/tarjetas-graficas/901-evga-geforce-rtx-3080-xc3-ultra-hybrid-gaming-10gb-gddr6x.html',
    },
    {
      brand: 'gigabyte',
      model: 'aorus master',
      series: '3080',
      url: 'https://siabyte.com/tarjetas-graficas/849-gigabyte-aorus-geforce-rtx-3080-master-10gb-gddr6x.html',
    },
    {
      brand: 'gigabyte',
      model: 'aorus xtreme',
      series: '3080',
      url: 'https://siabyte.com/tarjetas-graficas/852-gigabyte-aorus-geforce-rtx-3080-xtreme-10gb-gddr6x.html',
    },
    {
      brand: 'gigabyte',
      model: 'vision oc',
      series: '3080',
      url: 'https://siabyte.com/tarjetas-graficas/860-gigabyte-geforce-rtx-3080-vision-oc-10gb-gddr6x.html',
    },
    {
      brand: 'gigabyte',
      model: 'gaming oc',
      series: '3080',
      url: 'https://siabyte.com/tarjetas-graficas/861-gigabyte-geforce-rtx-3080-gaming-oc-10g-10gb-gddr6x.html',
    },
    {
      brand: 'gigabyte',
      model: 'eagle oc',
      series: '3080',
      url: 'https://siabyte.com/tarjetas-graficas/865-gigabyte-geforce-rtx-3080-eagle-oc-10g-10gb-gddr6x.html',
    },
    {
      brand: 'gigabyte',
      model: 'aorus xtreme waterforce wb',
      series: '3080',
      url: 'https://siabyte.com/tarjetas-graficas/941-gigabyte-aorus-geforce-rtx-3080-xtreme-waterforce-wb-10gb-gddr6x.html',
    },
    {
      brand: 'msi',
      model: 'suprim x',
      series: '3080',
      url: 'https://siabyte.com/tarjetas-graficas/924-msi-geforce-rtx-3080-suprim-x-10gb-gddr6x.html',
    },
    // 3070ti
    // 3070
    {
      brand: 'asus',
      model: 'tuf oc',
      series: '3070',
      url: 'https://siabyte.com/tarjetas-graficas/912-asus-tuf-gaming-geforce-rtx-3070-oc-8gb-gddr6.html',
    },
    {
      brand: 'asus',
      model: 'tuf',
      series: '3070',
      url: 'https://siabyte.com/tarjetas-graficas/930-asus-tuf-rtx-3070-gaming-8gb-gddr6.html',
    },
    {
      brand: 'asus',
      model: 'ekwb',
      series: '3070',
      url: 'https://siabyte.com/tarjetas-graficas/959-asus-ekwb-geforce-rtx-3070-8gb-gddr6.html',
    },
    {
      brand: 'evga',
      model: 'xc3 black',
      series: '3070',
      url: 'https://siabyte.com/tarjetas-graficas/853-evga-geforce-rtx-3070-xc3-black-gaming-8gb-gddr6.html',
    },
    {
      brand: 'evga',
      model: 'ftw3 ultra',
      series: '3070',
      url: 'https://siabyte.com/tarjetas-graficas/854-evga-geforce-rtx-3070-ftw3-ultra-gaming-8gb-gddr6.html',
    },
    {
      brand: 'evga',
      model: 'xc3 ultra',
      series: '3070',
      url: 'https://siabyte.com/tarjetas-graficas/883-evga-geforce-rtx-3070-xc3-ultra-gaming-8gb-gddr6.html',
    },
    {
      brand: 'gigabyte',
      model: 'gaming oc',
      series: '3070',
      url: 'https://siabyte.com/tarjetas-graficas/847-gigabyte-geforce-rtx-3070-gaming-oc-8gb-gddr6.html',
    },
    {
      brand: 'gigabyte',
      model: 'eagle oc',
      series: '3070',
      url: 'https://siabyte.com/tarjetas-graficas/857-gigabyte-geforce-rtx-3070-eagle-oc-8gb-gddr6.html',
    },
    {
      brand: 'gigabyte',
      model: 'vision oc',
      series: '3070',
      url: 'https://siabyte.com/tarjetas-graficas/862-gigabyte-geforce-rtx-3070-vision-oc-8gb-gddr6.html',
    },
    {
      brand: 'gigabyte',
      model: 'aorus master',
      series: '3070',
      url: 'https://siabyte.com/tarjetas-graficas/881-gigabyte-aorus-geforce-rtx-3070-master-8gb-gddr6.html',
    },
    {
      brand: 'gigabyte',
      model: 'eagle',
      series: '3070',
      url: 'https://siabyte.com/tarjetas-graficas/926-gigabyte-geforce-rtx-3070-eagle-8gb-gddr6.html',
    },
    {
      brand: 'msi',
      model: 'ventus 2x oc',
      series: '3070',
      url: 'https://siabyte.com/tarjetas-graficas/921-msi-geforce-rtx-3070-ventus-2x-oc-8gb-gddr6.html',
    },
    {
      brand: 'msi',
      model: 'suprim x',
      series: '3070',
      url: 'https://siabyte.com/tarjetas-graficas/972-msi-geforce-rtx-3070-suprim-x-8gb-gddr6.html',
    },
    {
      brand: 'palit',
      model: 'gaming pro',
      series: '3070',
      url: 'https://siabyte.com/tarjetas-graficas/879-palit-geforce-rtx-3070-gaming-pro-8gb-gddr6.html',
    },
    {
      brand: 'palit',
      model: 'jetstream',
      series: '3070',
      url: 'https://siabyte.com/tarjetas-graficas/906-palit-rtx-3070-jet-stream-8gb-gddr6.html',
    },
    {
      brand: 'palit',
      model: 'jetstream oc',
      series: '3070',
      url: 'https://siabyte.com/tarjetas-graficas/909-palit-geforce-rtx-3070-jet-stream-oc-8gb-gddr6.html',
    },
    {
      brand: 'palit',
      model: 'gamerock oc',
      series: '3070',
      url: 'https://siabyte.com/tarjetas-graficas/910-palit-geforce-rtx-3070-gamerock-oc-8gb-gddr6.html',
    },
    {
      brand: 'palit',
      model: 'gamerock',
      series: '3070',
      url: 'https://siabyte.com/tarjetas-graficas/911-palit-geforce-rtx-3070-gamerock-8gb-gddr6.html',
    },
    {
      brand: 'zotac',
      model: 'twin edge oc white',
      series: '3070',
      url: 'https://siabyte.com/tarjetas-graficas/917-zotac-gaming-geforce-rtx-3070-twin-edge-oc-white-edition-8gb-gddr6.html',
    },
  ],
  name: 'siabyte',
};
