import {Store} from './store';

export const ProshopDE: Store = {
  currency: '€',
  labels: {
    inStock: {
      container: 'button[data-form-action="addToBasket"]',
      text: ['bestellen'],
    },
    maxPrice: {
      container:
        '.site-currency-wrapper > span[class="site-currency-attention"]',
      euroFormat: true,
    },
    outOfStock: {
      container: '.site-currency-attention',
      text: ['Die Ware ist leider nicht mehr verfügbar.'],
    },
  },
  links: [
    {
      brand: 'test:brand',
      model: 'test:model',
      series: 'test:series',
      url: 'https://www.proshop.de/2797958',
    },
    {
      brand: 'asus',
      model: 'strix',
      series: '3070',
      url: 'https://www.proshop.de/2876843',
    },
    {
      brand: 'asus',
      model: 'strix oc',
      series: '3070',
      url: 'https://www.proshop.de/2876845',
    },
    {
      brand: 'asus',
      model: 'dual',
      series: '3070',
      url: 'https://www.proshop.de/2876851',
    },
    {
      brand: 'asus',
      model: 'dual oc',
      series: '3070',
      url: 'https://www.proshop.de/2876853',
    },
    {
      brand: 'asus',
      model: 'tuf',
      series: '3070',
      url: 'https://www.proshop.de/2876854',
    },
    {
      brand: 'asus',
      model: 'tuf oc',
      series: '3070',
      url: 'https://www.proshop.de/2876856',
    },
    {
      brand: 'gigabyte',
      model: 'eagle',
      series: '3070',
      url: 'https://www.proshop.de/2878385',
    },
    {
      brand: 'gigabyte',
      model: 'eagle oc',
      series: '3070',
      url: 'https://www.proshop.de/2878386',
    },
    {
      brand: 'gigabyte',
      model: 'gaming oc',
      series: '3070',
      url: 'https://www.proshop.de/2878390',
    },
    {
      brand: 'gigabyte',
      model: 'vision oc',
      series: '3070',
      url: 'https://www.proshop.de/2878390',
    },
    {
      brand: 'inno3d',
      model: 'ichill x2',
      series: '3070',
      url: 'https://www.proshop.de/2883916',
    },
    {
      brand: 'inno3d',
      model: 'twin x2 oc',
      series: '3070',
      url: 'https://www.proshop.de/2883917',
    },
    {
      brand: 'inno3d',
      model: 'ichill x3',
      series: '3070',
      url: 'https://www.proshop.de/2883918',
    },
    {
      brand: 'inno3d',
      model: 'ichill x4',
      series: '3070',
      url: 'https://www.proshop.de/2883919',
    },
    {
      brand: 'msi',
      model: 'gaming x trio',
      series: '3070',
      url: 'https://www.proshop.de/2876871',
    },
    {
      brand: 'msi',
      model: 'ventus 2x oc',
      series: '3070',
      url: 'https://www.proshop.de/2876873',
    },
    {
      brand: 'msi',
      model: 'ventus 3x oc',
      series: '3070',
      url: 'https://www.proshop.de/2876875',
    },
    {
      brand: 'asus',
      model: 'strix',
      series: '3080',
      url: 'https://www.proshop.de/2876857',
    },
    {
      brand: 'asus',
      model: 'strix oc',
      series: '3080',
      url: 'https://www.proshop.de/2876859',
    },
    {
      brand: 'asus',
      model: 'tuf',
      series: '3080',
      url: 'https://www.proshop.de/2876763',
    },
    {
      brand: 'asus',
      model: 'tuf oc',
      series: '3080',
      url: 'https://www.proshop.de/2876861',
    },
    {
      brand: 'gigabyte',
      model: 'aorus master',
      series: '3080',
      url: 'https://www.proshop.de/2876835',
    },
    {
      brand: 'gigabyte',
      model: 'eagle oc',
      series: '3080',
      url: 'https://www.proshop.de/2876837',
    },
    {
      brand: 'gigabyte',
      model: 'gaming oc',
      series: '3080',
      url: 'https://www.proshop.de/2876838',
    },
    {
      brand: 'gigabyte',
      model: 'vision oc',
      series: '3080',
      url: 'https://www.proshop.de/2878401',
    },
    {
      brand: 'inno3d',
      model: 'ichill x3',
      series: '3080',
      url: 'https://www.proshop.de/2878969',
    },
    {
      brand: 'inno3d',
      model: 'ichill x4',
      series: '3080',
      url: 'https://www.proshop.de/2878971',
    },
    {
      brand: 'inno3d',
      model: 'twin x2 oc',
      series: '3080',
      url: 'https://www.proshop.de/2878968',
    },
    {
      brand: 'msi',
      model: 'gaming x trio',
      series: '3080',
      url: 'https://www.proshop.de/2876877',
    },
    {
      brand: 'msi',
      model: 'ventus 3x',
      series: '3080',
      url: 'https://www.proshop.de/2876878',
    },
    {
      brand: 'msi',
      model: 'ventus 3x oc',
      series: '3080',
      url: 'https://www.proshop.de/2876879',
    },
    {
      brand: 'asus',
      model: 'strix',
      series: '3090',
      url: 'https://www.proshop.de/2876865',
    },
    {
      brand: 'asus',
      model: 'strix oc',
      series: '3090',
      url: 'https://www.proshop.de/2876867',
    },
    {
      brand: 'asus',
      model: 'tuf',
      series: '3090',
      url: 'https://www.proshop.de/2876764',
    },
    {
      brand: 'asus',
      model: 'tuf oc',
      series: '3090',
      url: 'https://www.proshop.de/2876869',
    },
    {
      brand: 'gigabyte',
      model: 'aorus master',
      series: '3090',
      url: 'https://www.proshop.de/2876840',
    },
    {
      brand: 'gigabyte',
      model: 'aorus xtreme',
      series: '3090',
      url: 'https://www.proshop.de/2876839',
    },
    {
      brand: 'gigabyte',
      model: 'turbo',
      series: '3090',
      url: 'https://www.proshop.de/2878410',
    },
    {
      brand: 'msi',
      model: 'gaming x trio',
      series: '3090',
      url: 'https://www.proshop.de/2876881',
    },
    {
      brand: 'asus',
      model: 'amd reference',
      series: 'rx6700xt',
      url: 'https://www.proshop.de/2931749',
    },
    {
      brand: 'asus',
      model: 'dual',
      series: 'rx6700xt',
      url: 'https://www.proshop.de/2931751',
    },
    {
      brand: 'asus',
      model: 'tuf oc',
      series: 'rx6700xt',
      url: 'https://www.proshop.de/2928902',
    },
    {
      brand: 'asus',
      model: 'strix oc',
      series: 'rx6700xt',
      url: 'https://www.proshop.de/2928906',
    },
    {
      brand: 'gigabyte',
      model: 'amd reference',
      series: 'rx6700xt',
      url: 'https://www.proshop.de/2931754',
    },
    {
      brand: 'gigabyte',
      model: 'eagle',
      series: 'rx6700xt',
      url: 'https://www.proshop.de/2929320',
    },
    {
      brand: 'gigabyte',
      model: 'eagle oc',
      series: 'rx6700xt',
      url: 'https://www.proshop.de/2929323',
    },
    {
      brand: 'gigabyte',
      model: 'aorus elite',
      series: 'rx6700xt',
      url: 'https://www.proshop.de/2929319',
    },
    {
      brand: 'msi',
      model: 'mech 2x',
      series: 'rx6700xt',
      url: 'https://www.proshop.de/2929317',
    },
    {
      brand: 'msi',
      model: 'mech 2x oc',
      series: 'rx6700xt',
      url: 'https://www.proshop.de/2929318',
    },
    {
      brand: 'msi',
      model: 'gaming x',
      series: 'rx6700xt',
      url: 'https://www.proshop.de/2929316',
    },
    {
      brand: 'powercolor',
      model: 'amd reference',
      series: 'rx6700xt',
      url: 'https://www.proshop.de/2931748',
    },
    {
      brand: 'powercolor',
      model: 'fighter',
      series: 'rx6700xt',
      url: 'https://www.proshop.de/2930939',
    },
    {
      brand: 'powercolor',
      model: 'hellhound',
      series: 'rx6700xt',
      url: 'https://www.proshop.de/2930940',
    },
    {
      brand: 'powercolor',
      model: 'red devil',
      series: 'rx6700xt',
      url: 'https://www.proshop.de/2930941',
    },
    {
      brand: 'sapphire',
      model: 'pulse',
      series: 'rx6700xt',
      url: 'https://www.proshop.de/2935127',
    },
    {
      brand: 'sapphire',
      model: 'pulse',
      series: 'rx6700xt',
      url: 'https://www.proshop.de/2987327',
    },
    {
      brand: 'sapphire',
      model: 'nitro+',
      series: 'rx6700xt',
      url: 'https://www.proshop.de/2935128',
    },
    {
      brand: 'xfx',
      model: 'merc',
      series: 'rx6700xt',
      url: 'https://www.proshop.de/2934180',
    },
    {
      brand: 'xfx',
      model: 'qick ultra',
      series: 'rx6700xt',
      url: 'https://www.proshop.de/2934182',
    },
    {
      brand: 'xfx',
      model: 'qick',
      series: 'rx6700xt',
      url: 'https://www.proshop.de/2954595',
    },
    {
      brand: 'amd',
      model: '5600x',
      series: 'ryzen5600',
      url: 'https://www.proshop.de/2884168',
    },
    {
      brand: 'amd',
      model: '5800x',
      series: 'ryzen5800',
      url: 'https://www.proshop.de/2884171',
    },
    {
      brand: 'amd',
      model: '5900x',
      series: 'ryzen5900',
      url: 'https://www.proshop.de/2884173',
    },
    {
      brand: 'amd',
      model: '5950x',
      series: 'ryzen5950',
      url: 'https://www.proshop.de/2884175',
    },
  ],
  name: 'proshop-de',
};
