import {Store} from './store';

export const PCDiga: Store = {
  currency: '€',
  labels: {
    inStock: {
      container: '#product-addtocart-button > span',
      text: ['Adicionar ao carrinho'],
    },
    outOfStock: {
      container: 'div[id="skrey_estimate_date_product_page_wrapper"]',
      text: ['Sem stock'],
    },
    maxPrice: {
      container: '.price-container.price-final_price > .price-wrapper > span',
      euroFormat: true,
    },
  },
  links: [
    {
      brand: 'test:brand',
      model: 'test:model',
      series: 'test:series',
      url: 'https://www.pcdiga.com/placa-grafica-asus-ekwb-geforce-rtx-3080-10gb-gddr6x-90yv0f60-m0nm00',
    },
    {
      brand: 'asus',
      model: 'ekwb',
      series: '3080',
      url: 'https://www.pcdiga.com/placa-grafica-asus-ekwb-geforce-rtx-3080-10gb-gddr6x-90yv0f60-m0nm00',
    },
    {
      brand: 'msi',
      model: 'ventus 3x',
      series: '3080',
      url: 'https://www.pcdiga.com/placa-grafica-msi-geforce-rtx-3080-ventus-3x-10g-oc-912-v389-001',
    },
    {
      brand: 'msi',
      model: 'gaming x trio',
      series: '3080',
      url: 'https://www.pcdiga.com/placa-grafica-msi-geforce-rtx-3080-gaming-x-trio-10g-912-v389-005',
    },
    {
      brand: 'zotac',
      model: 'trinity',
      series: '3080',
      url: 'https://www.pcdiga.com/placa-grafica-zotac-gaming-geforce-rtx-3080-10gb-gddr6x-trinity-zt-a30800d-10p',
    },
    {
      brand: 'asus',
      model: 'strix',
      series: '3080',
      url: 'https://www.pcdiga.com/placa-grafica-asus-rog-strix-geforce-rtx-3080-10gb-gddr6x-90yv0fa0-m0nm00',
    },
    {
      brand: 'asus',
      model: 'tuf',
      series: '3080',
      url: 'https://www.pcdiga.com/placa-grafica-asus-tuf-gaming-geforce-rtx-3080-10gb-gddr6x-90yv0fb0-m0nm00',
    },
    {
      brand: 'gigabyte',
      model: 'aorus xtreme',
      series: '3080',
      url: 'https://www.pcdiga.com/placa-grafica-gigabyte-geforce-rtx-3080-aorus-xtreme-10gb-gddr6x-gv-n3080aorus-x-10gd',
    },
    {
      brand: 'msi',
      model: 'suprim x',
      series: '3080',
      url: 'https://www.pcdiga.com/placa-grafica-msi-geforce-rtx-3080-suprim-x-10g-912-v389-006',
    },
    {
      brand: 'gigabyte',
      model: 'aorus master',
      series: '3080',
      url: 'https://www.pcdiga.com/placa-grafica-gigabyte-geforce-rtx-3080-aorus-master-10gb-gddr6x-gvn3080am-00-10',
    },
    {
      brand: 'gigabyte',
      model: 'aorus',
      series: '3080',
      url: 'https://www.pcdiga.com/placa-grafica-gigabyte-rtx-3080-aorus-gaming-box-10gb-gv-n3080ixeb-10gd',
    },
    {
      brand: 'pny',
      model: 'xlr8 epic x',
      series: '3080',
      url: 'https://www.pcdiga.com/placa-grafica-pny-geforce-rtx-3080-10gb-gddr6x-xlr8-gaming-epic-x-rgb-triple-fan-vcg308010tfxppb',
    },
    {
      brand: 'pny',
      model: 'xlr8 epic x',
      series: '3080',
      url: 'https://www.pcdiga.com/placa-grafica-pny-geforce-rtx-3080-10gb-gddr6x-xlr8-gaming-epic-x-rgb-triple-fan-vcg308010tfxmpb',
    },
    {
      brand: 'zotac',
      model: 'trinity oc',
      series: '3080',
      url: 'https://www.pcdiga.com/placa-grafica-zotac-gaming-geforce-rtx-3080-10gb-gddr6x-trinity-oc-zt-a30800j-10p',
    },
    {
      brand: 'zotac',
      model: 'amp holo',
      series: '3080',
      url: 'https://www.pcdiga.com/placa-grafica-zotac-gaming-geforce-rtx-3080-10gb-gddr6x-amp-holo-zt-a30800f-10p',
    },
    {
      brand: 'gigabyte',
      model: 'vision',
      series: '3080',
      url: 'https://www.pcdiga.com/placa-grafica-gigabyte-geforce-rtx-3080-vision-10gb-gddr6x-oc-edition-gv-n3080vision-oc-10',
    },
    {
      brand: 'asus',
      model: 'strix',
      series: '3080',
      url: 'https://www.pcdiga.com/placa-grafica-asus-rog-strix-geforce-rtx-3080-10gb-gddr6x-oc-edition-90yv0fa1-m0nm00',
    },
    {
      brand: 'asus',
      model: 'tuf oc',
      series: '3080',
      url: 'https://www.pcdiga.com/placa-grafica-asus-tuf-gaming-geforce-rtx-3080-10gb-gddr6x-oc-edition-90yv0fb1-m0nm00',
    },
    {
      brand: 'gigabyte',
      model: 'eagle oc',
      series: '3080',
      url: 'https://www.pcdiga.com/placa-grafica-gigabyte-geforce-rtx-3080-eagle-10gb-gddr6x-oc-edition-gvn3080eo-00-10',
    },
    {
      brand: 'gigabyte',
      model: 'gaming oc',
      series: '3080',
      url: 'https://www.pcdiga.com/placa-grafica-gigabyte-geforce-rtx-3080-gaming-10gb-gddr6x-oc-edition-gvn3080go-00-10',
    },
    {
      brand: 'asus',
      model: 'strix oc white',
      series: '3080',
      url: 'https://www.pcdiga.com/placa-grafica-asus-rog-strix-geforce-rtx-3080-10gb-gddr6x-oc-white-edition-90yv0fa5-m0nm00',
    },
    {
      brand: 'gigabyte',
      model: 'aorus',
      series: '3090',
      url: 'https://www.pcdiga.com/placa-grafica-gigabyte-geforce-rtx-3090-aorus-gaming-box-24gb-gv-n3090ixeb-24gd-1-0',
    },
    {
      brand: 'gigabyte',
      model: 'aorus master',
      series: '3090',
      url: 'https://www.pcdiga.com/placa-grafica-gigabyte-geforce-rtx-3090-aorus-master-24gb-gv-n3090aorus-m-24gd',
    },
    {
      brand: 'zotac',
      model: 'trinity',
      series: '3090',
      url: 'https://www.pcdiga.com/placa-grafica-zotac-gaming-geforce-rtx-3090-24gb-gddr6x-trinity-zt-a30900d-10p',
    },
    {
      brand: 'asus',
      model: 'strix',
      series: '3090',
      url: 'https://www.pcdiga.com/placa-grafica-asus-rog-strix-geforce-rtx-3090-24gb-gddr6x-90yv0f90-m0nm00',
    },
    {
      brand: 'asus',
      model: 'tuf',
      series: '3090',
      url: 'https://www.pcdiga.com/placa-grafica-asus-tuf-gaming-geforce-rtx-3090-24gb-gddr6x-90yv0fd0-m0nm00',
    },
    {
      brand: 'msi',
      model: 'ventus 3x oc',
      series: '3090',
      url: 'https://www.pcdiga.com/placa-grafica-msi-geforce-rtx-3090-ventus-3x-24g-oc-912-v388-002',
    },
    {
      brand: 'msi',
      model: 'gaming x trio',
      series: '3090',
      url: 'https://www.pcdiga.com/placa-grafica-msi-geforce-rtx-3090-gaming-x-trio-24g-912-v388-011',
    },
    {
      brand: 'msi',
      model: 'suprim x',
      series: '3090',
      url: 'https://www.pcdiga.com/placa-grafica-msi-geforce-rtx-3090-suprim-x-24g-912-v388-010',
    },
    {
      brand: 'gigabyte',
      model: 'vision oc',
      series: '3090',
      url: 'https://www.pcdiga.com/placa-grafica-gigabyte-geforce-rtx-3090-vision-oc-24gb-gvn3090vo-00-g',
    },
    {
      brand: 'gigabyte',
      model: 'aorus xtreme',
      series: '3090',
      url: 'https://www.pcdiga.com/placa-grafica-gigabyte-geforce-rtx-3090-aorus-xtreme-24gb-gvn3090ax-00-10',
    },
    {
      brand: 'asus',
      model: 'ekwb',
      series: '3090',
      url: 'https://www.pcdiga.com/placa-grafica-asus-ekwb-geforce-rtx-3090-24gb-gddr6x-90yv0f80-m0nm00',
    },
    {
      brand: 'pny',
      model: 'xlr8 epic x',
      series: '3090',
      url: 'https://www.pcdiga.com/placa-grafica-pny-geforce-rtx-3090-24gb-gddr6x-xlr8-gaming-epic-x-rgb-triple-fan-vcg309024tfxppb',
    },
    {
      brand: 'pny',
      model: 'xlr8 epic x',
      series: '3090',
      url: 'https://www.pcdiga.com/placa-grafica-pny-geforce-rtx-3090-24gb-gddr6x-xlr8-gaming-epic-x-rgb-triple-fan-vcg309024tfxmpb',
    },
    {
      brand: 'asus',
      model: 'strix oc',
      series: '3090',
      url: 'https://www.pcdiga.com/placa-grafica-asus-rog-strix-geforce-rtx-3090-24gb-gddr6x-oc-edition-90yv0f93-m0nm00',
    },
    {
      brand: 'asus',
      model: 'tuf oc',
      series: '3090',
      url: 'https://www.pcdiga.com/placa-grafica-asus-tuf-gaming-geforce-rtx-3090-24gb-gddr6x-oc-edition-90yv0fd1-m0nm00',
    },
    {
      brand: 'gigabyte',
      model: 'eagle oc',
      series: '3090',
      url: 'https://www.pcdiga.com/placa-grafica-gigabyte-geforce-rtx-3090-eagle-24gb-gddr6x-oc-edition-gvn3090eo-00-10',
    },
    {
      brand: 'gigabyte',
      model: 'gaming oc',
      series: '3090',
      url: 'https://www.pcdiga.com/placa-grafica-gigabyte-geforce-rtx-3090-gaming-24gb-gddr6x-oc-edition-gvn3090go-00-10',
    },
    {
      brand: 'zotac',
      model: 'trinity oc',
      series: '3090',
      url: 'https://www.pcdiga.com/placa-grafica-zotac-gaming-geforce-rtx-3090-24gb-gddr6x-trinity-oc-zt-a30900j-10p',
    },
    {
      brand: 'asus',
      model: 'strix oc white',
      series: '3090',
      url: 'https://www.pcdiga.com/placa-grafica-asus-rog-strix-gaming-geforce-rtx-3090-24gb-gddr6x-oc-white-edition-90yv0f96-m0nm00',
    },
    {
      brand: 'gigabyte',
      model: 'eagle',
      series: '3070',
      url: 'https://www.pcdiga.com/componentes/placas-graficas/placas-graficas-nvidia/placa-grafica-gigabyte-geforce-rtx-3070-eagle-8gb-gddr6-gv-n3070eagle-8gd',
    },
    {
      brand: 'gigabyte',
      model: 'gaming oc',
      series: '3070',
      url: 'https://www.pcdiga.com/componentes/placas-graficas/placas-graficas-nvidia/placa-grafica-gigabyte-geforce-rtx-3070-gaming-oc-8g-gv-n3070gaming-oc-8gd',
    },
    {
      brand: 'zotac',
      model: 'twin edge oc',
      series: '3070',
      url: 'https://www.pcdiga.com/componentes/placas-graficas/placas-graficas-nvidia/placa-grafica-zotac-gaming-geforce-rtx-3070-8gb-gddr6-twin-edge-oc-zt-a30700h-10p',
    },
    {
      brand: 'zotac',
      model: 'twin edge',
      series: '3070',
      url: 'https://www.pcdiga.com/componentes/placas-graficas/placas-graficas-nvidia/placa-grafica-zotac-gaming-geforce-rtx-3070-8gb-gddr6-twin-edge-zt-a30700e-10p',
    },
    {
      brand: 'msi',
      model: 'ventus 2x',
      series: '3070',
      url: 'https://www.pcdiga.com/componentes/placas-graficas/placas-graficas-nvidia/placa-grafica-msi-geforce-rtx-3070-ventus-2x-8g-oc-912-v390-008',
    },
    {
      brand: 'pny',
      model: 'xlr8 epic x',
      series: '3070',
      url: 'https://www.pcdiga.com/componentes/placas-graficas/placas-graficas-nvidia/placa-grafica-pny-geforce-rtx-3070-8gb-gddr6-xlr8-gaming-epic-x-rgb-triple-fan-vcg30708tfxppb',
    },
    {
      brand: 'pny',
      model: 'dual fan',
      series: '3070',
      url: 'https://www.pcdiga.com/componentes/placas-graficas/placas-graficas-nvidia/placa-grafica-pny-geforce-rtx-3070-8gb-gddr6-dual-fan-vcg30708dfmpb',
    },
    {
      brand: 'gigabyte',
      model: 'aorus master',
      series: '3070',
      url: 'https://www.pcdiga.com/componentes/placas-graficas/placas-graficas-nvidia/placa-grafica-gigabyte-geforce-rtx-3070-aorus-master-8gb-gddr6-gv-n3070aorus-m-8gd',
    },
    {
      brand: 'gigabyte',
      model: 'vision oc',
      series: '3070',
      url: 'https://www.pcdiga.com/componentes/placas-graficas/placas-graficas-nvidia/placa-grafica-gigabyte-geforce-rtx-3070-vision-oc-8gb-gddr6-gv-n3070vision-oc-8gd',
    },
    {
      brand: 'gigabyte',
      model: 'eagle oc',
      series: '3070',
      url: 'https://www.pcdiga.com/componentes/placas-graficas/placas-graficas-nvidia/placa-grafica-gigabyte-geforce-rtx-3070-eagle-8gb-gddr6-oc-edition-gv-n3070eagle-oc-8gd',
    },
    {
      brand: 'asus',
      model: 'dual oc',
      series: '3070',
      url: 'https://www.pcdiga.com/componentes/placas-graficas/placas-graficas-nvidia/placa-grafica-asus-dual-geforce-rtx-3070-8gb-gddr6-oc-editon-90yv0fq0-m0na00',
    },
    {
      brand: 'asus',
      model: 'dual',
      series: '3070',
      url: 'https://www.pcdiga.com/componentes/placas-graficas/placas-graficas-nvidia/placa-grafica-asus-dual-geforce-rtx-3070-8gb-gddr6-90yv0fq1-m0na00',
    },
    {
      brand: 'asus',
      model: 'strix oc',
      series: '3070',
      url: 'https://www.pcdiga.com/componentes/placas-graficas/placas-graficas-nvidia/placa-grafica-asus-rog-strix-geforce-rtx-3070-8gb-gddr6-oc-editon-90yv0fr1-m0na00',
    },
    {
      brand: 'asus',
      model: 'strix',
      series: '3070',
      url: 'https://www.pcdiga.com/componentes/placas-graficas/placas-graficas-nvidia/placa-grafica-asus-rog-strix-geforce-rtx-3070-8gb-gddr6-90yv0fr0-m0na00',
    },
    {
      brand: 'asus',
      model: 'tuf oc',
      series: '3070',
      url: 'https://www.pcdiga.com/componentes/placas-graficas/placas-graficas-nvidia/placa-grafica-asus-tuf-gaming-geforce-rtx-3070-8gb-gddr6-oc-edition-90yv0fq6-m0na00',
    },
    {
      brand: 'zotac',
      model: 'amp holo',
      series: '3070',
      url: 'https://www.pcdiga.com/componentes/placas-graficas/placas-graficas-nvidia/placa-grafica-zotac-gaming-geforce-rtx-3070-8gb-gddr6-amp-holo-zt-a30700f-10p',
    },
    {
      brand: 'zotac',
      model: 'twin edge oc',
      series: '3070',
      url: 'https://www.pcdiga.com/componentes/placas-graficas/placas-graficas-nvidia/placa-grafica-zotac-gaming-geforce-rtx-3070-8gb-gddr6-twin-edge-oc-white-edition-zt-a30700j-10p',
    },
    {
      brand: 'msi',
      model: 'suprim x',
      series: '3070',
      url: 'https://www.pcdiga.com/componentes/placas-graficas/placas-graficas-nvidia/placa-grafica-msi-geforce-rtx-3070-suprim-x-8g-912-v390-005',
    },
    {
      brand: 'asus',
      model: 'dual',
      series: '3060ti',
      url: 'https://www.pcdiga.com/componentes/placas-graficas/placas-graficas-nvidia/placa-grafica-asus-dual-geforce-rtx-3060-ti-8gb-gddr6-90yv0g13-m0na00',
    },
    {
      brand: 'asus',
      model: 'dual oc',
      series: '3060ti',
      url: 'https://www.pcdiga.com/componentes/placas-graficas/placas-graficas-nvidia/placa-grafica-asus-dual-geforce-rtx-3060-ti-8gb-gddr6-oc-90yv0g12-m0na00',
    },
    {
      brand: 'asus',
      model: 'strix',
      series: '3060ti',
      url: 'https://www.pcdiga.com/componentes/placas-graficas/placas-graficas-nvidia/placa-grafica-asus-rog-strix-geforce-rtx-3060-ti-8gb-gddr6-90yv0g00-m0na00',
    },
    {
      brand: 'asus',
      model: 'strix oc',
      series: '3060ti',
      url: 'https://www.pcdiga.com/componentes/placas-graficas/placas-graficas-nvidia/placa-grafica-asus-rog-strix-geforce-rtx-3060-ti-8gb-gddr6-oc-90yv0g02-m0na00',
    },
    {
      brand: 'asus',
      model: 'tuf',
      series: '3060ti',
      url: 'https://www.pcdiga.com/componentes/placas-graficas/placas-graficas-nvidia/placa-grafica-asus-tuf-gaming-rtx-3060-ti-8gb-gddr6-90yv0g11-m0na00',
    },
    {
      brand: 'asus',
      model: 'tuf oc',
      series: '3060ti',
      url: 'https://www.pcdiga.com/componentes/placas-graficas/placas-graficas-nvidia/placa-grafica-asus-tuf-gaming-rtx-3060-ti-8gb-gddr6-oc-90yv0g10-m0na00',
    },
    {
      brand: 'gigabyte',
      model: 'aorus master',
      series: '3060ti',
      url: 'https://www.pcdiga.com/componentes/placas-graficas/placas-graficas-nvidia/placa-grafica-gigabyte-geforce-rtx-3060-ti-aorus-master-8gb-gddr6-gvn306tam-00-10',
    },
    {
      brand: 'gigabyte',
      model: 'eagle',
      series: '3060ti',
      url: 'https://www.pcdiga.com/componentes/placas-graficas/placas-graficas-nvidia/placa-grafica-gigabyte-geforce-rtx-3060-ti-eagle-8gb-gddr6-gvn306teo-00-g',
    },
    {
      brand: 'gigabyte',
      model: 'eagle oc',
      series: '3060ti',
      url: 'https://www.pcdiga.com/componentes/placas-graficas/placas-graficas-nvidia/placa-grafica-gigabyte-geforce-rtx-3060-ti-eagle-oc-8gb-gddr6-gvn306teo-00-10',
    },
    {
      brand: 'gigabyte',
      model: 'gaming oc',
      series: '3060ti',
      url: 'https://www.pcdiga.com/componentes/placas-graficas/placas-graficas-nvidia/placa-grafica-gigabyte-geforce-rtx-3060-ti-gaming-oc-8gb-gddr6-gvn306tgo-00-10',
    },
    {
      brand: 'gigabyte',
      model: 'gaming oc pro',
      series: '3060ti',
      url: 'https://www.pcdiga.com/componentes/placas-graficas/placas-graficas-nvidia/placa-grafica-gigabyte-geforce-rtx-3060-ti-gaming-oc-pro-8gb-gddr6-gvn306tgop-00-10',
    },
    {
      brand: 'msi',
      model: 'gaming',
      series: '3060ti',
      url: 'https://www.pcdiga.com/componentes/placas-graficas/placas-graficas-nvidia/placa-grafica-msi-geforce-rtx-3060-ti-gaming-x-8gb-gddr6-912-v397-042',
    },
    {
      brand: 'msi',
      model: 'gaming trio',
      series: '3060ti',
      url: 'https://www.pcdiga.com/componentes/placas-graficas/placas-graficas-nvidia/placa-grafica-msi-geforce-rtx-3060-ti-gaming-x-trio-8gb-gddr6-912-v390-053',
    },
    {
      brand: 'msi',
      model: 'ventus 2x',
      series: '3060ti',
      url: 'https://www.pcdiga.com/componentes/placas-graficas/placas-graficas-nvidia/placa-grafica-msi-geforce-rtx-3060-ti-ventus-2x-8gb-gddr6-oc-912-v390-009',
    },
    {
      brand: 'msi',
      model: 'ventus 2x',
      series: '3060ti',
      url: 'https://www.pcdiga.com/componentes/placas-graficas/placas-graficas-nvidia/placa-grafica-msi-geforce-rtx-3060-ti-ventus-2x-ocv1-8gb-gddr6-oc-912-v397-003',
    },
    {
      brand: 'msi',
      model: 'ventus 3x',
      series: '3060ti',
      url: 'https://www.pcdiga.com/componentes/placas-graficas/placas-graficas-nvidia/placa-grafica-msi-geforce-rtx-3060-ti-ventus-3x-8gb-gddr6-oc-912-v397-001',
    },
    {
      brand: 'pny',
      model: 'dual fan',
      series: '3060ti',
      url: 'https://www.pcdiga.com/componentes/placas-graficas/placas-graficas-nvidia/placa-grafica-pny-geforce-rtx-3060-ti-8gb-gddr6-uprising-dual-fan-vcg3060t8dfmpb',
    },
    {
      brand: 'pny',
      model: 'xlr8 epic x',
      series: '3060ti',
      url: 'https://www.pcdiga.com/componentes/placas-graficas/placas-graficas-nvidia/placa-grafica-pny-geforce-rtx-3060-ti-8gb-gddr6-xlr8-revel-epic-x-dual-fan-vcg3060t8dfxppb',
    },
    {
      brand: 'zotac',
      model: 'twin edge oc',
      series: '3060ti',
      url: 'https://www.pcdiga.com/componentes/placas-graficas/placas-graficas-nvidia/placa-grafica-zotac-gaming-geforce-rtx-3060-ti-8gb-gddr6-twin-edge-oc-zt-a30610h-10m',
    },
    {
      brand: 'zotac',
      model: 'twin edge',
      series: '3060ti',
      url: 'https://www.pcdiga.com/componentes/placas-graficas/placas-graficas-nvidia/placa-grafica-zotac-gaming-geforce-rtx-3060-ti-8gb-gddr6-twin-edge-zt-a30610e-10m',
    },
  ],
  name: 'pcdiga',
  waitUntil: 'domcontentloaded',
};
