import {Store} from './store';

export const Materiel: Store = {
  currency: '€',
  labels: {
    inStock: {
      container: '.product-availability',
      text: ['EN STOCK'],
    },
    maxPrice: {
      container: '.o-product__price',
      euroFormat: true,
    },
    outOfStock: {
      container: '.product-availability',
      text: ['RUPTURE'],
    },
  },
  links: [
    {
      brand: 'asus',
      model: 'dual',
      series: '3060ti',
      url: 'https://www.materiel.net/produit/202011060098.html',
    },
    {
      brand: 'asus',
      model: 'dual mini',
      series: '3060ti',
      url: 'https://www.materiel.net/produit/202012210010.html',
    },
    {
      brand: 'asus',
      model: 'dual mini oc',
      series: '3060ti',
      url: 'https://www.materiel.net/produit/202012210009.html',
    },
    {
      brand: 'asus',
      model: 'dual oc',
      series: '3060ti',
      url: 'https://www.materiel.net/produit/202011040097.html',
    },
    {
      brand: 'asus',
      model: 'strix oc',
      series: '3060ti',
      url: 'https://www.materiel.net/produit/202011040047.html',
    },
    {
      brand: 'asus',
      model: 'tuf',
      series: '3060ti',
      url: 'https://www.materiel.net/produit/202011060096.html',
    },
    {
      brand: 'asus',
      model: 'tuf oc',
      series: '3060ti',
      url: 'https://www.materiel.net/produit/202011040046.html',
    },
    {
      brand: 'evga',
      model: 'ftw3 ultra',
      series: '3060ti',
      url: 'https://www.materiel.net/produit/202011240231.html',
    },
    {
      brand: 'evga',
      model: 'xc3',
      series: '3060ti',
      url: 'https://www.materiel.net/produit/202012070100.html',
    },
    {
      brand: 'gainward',
      model: 'ghost',
      series: '3060ti',
      url: 'https://www.materiel.net/produit/202011090107.html',
    },
    {
      brand: 'gainward',
      model: 'ghost oc',
      series: '3060ti',
      url: 'https://www.materiel.net/produit/202011090108.html',
    },
    {
      brand: 'gainward',
      model: 'phoenix',
      series: '3060ti',
      url: 'https://www.materiel.net/produit/202011090110.html',
    },
    {
      brand: 'gigabyte',
      model: 'aorus master',
      series: '3060ti',
      url: 'https://www.materiel.net/produit/202011180019.html',
    },
    {
      brand: 'gigabyte',
      model: 'eagle',
      series: '3060ti',
      url: 'https://www.materiel.net/produit/202101050071.html',
    },
    {
      brand: 'gigabyte',
      model: 'eagle oc',
      series: '3060ti',
      url: 'https://www.materiel.net/produit/202011180025.html',
    },
    {
      brand: 'gigabyte',
      model: 'gaming oc',
      series: '3060ti',
      url: 'https://www.materiel.net/produit/202011180027.html',
    },
    {
      brand: 'gigabyte',
      model: 'gaming oc pro',
      series: '3060ti',
      url: 'https://www.materiel.net/produit/202011180031.html',
    },
    {
      brand: 'gigabyte',
      model: 'vision oc',
      series: '3060ti',
      url: 'https://www.materiel.net/produit/202102010018.html',
    },
    {
      brand: 'inno3d',
      model: 'ichill x3',
      series: '3060ti',
      url: 'https://www.materiel.net/produit/202011160037.html',
    },
    {
      brand: 'inno3d',
      model: 'twin x2',
      series: '3060ti',
      url: 'https://www.materiel.net/produit/202011300117.html',
    },
    {
      brand: 'inno3d',
      model: 'twin x2 oc',
      series: '3060ti',
      url: 'https://www.materiel.net/produit/202011160036.html',
    },
    {
      brand: 'inno3d',
      model: 'twin x2',
      series: '3050',
      url: 'https://www.materiel.net/produit/202201170090.html',
    },
    {
      brand: 'kfa2',
      model: 'sg oc',
      series: '3060ti',
      url: 'https://www.materiel.net/produit/202011040084.html',
    },
    {
      brand: 'msi',
      model: 'gaming x trio',
      series: '3060ti',
      url: 'https://www.materiel.net/produit/202101190017.html',
    },
    {
      brand: 'msi',
      model: 'ventus 2x oc',
      series: '3060ti',
      url: 'https://www.materiel.net/produit/202012020119.html',
    },
    {
      brand: 'msi',
      model: 'ventus 2x',
      series: '3060ti',
      url: 'https://www.materiel.net/produit/202102220080.html',
    },
    {
      brand: 'msi',
      model: 'ventus 3x oc',
      series: '3060ti',
      url: 'https://www.materiel.net/produit/202011200140.html',
    },
    {
      brand: 'palit',
      model: 'dual',
      series: '3060ti',
      url: 'https://www.materiel.net/produit/202011090106.html',
    },
    {
      brand: 'palit',
      model: 'dual oc',
      series: '3060ti',
      url: 'https://www.materiel.net/produit/202011090105.html',
    },
    {
      brand: 'palit',
      model: 'gaming pro',
      series: '3060ti',
      url: 'https://www.materiel.net/produit/202011090099.html',
    },
    {
      brand: 'palit',
      model: 'gaming pro oc',
      series: '3060ti',
      url: 'https://www.materiel.net/produit/202011090098.html',
    },
    {
      brand: 'pny',
      model: 'uprising',
      series: '3060ti',
      url: 'https://www.materiel.net/produit/202011090114.html',
    },
    {
      brand: 'pny',
      model: 'xlr8 revel',
      series: '3060ti',
      url: 'https://www.materiel.net/produit/202011090113.html',
    },
    {
      brand: 'zotac',
      model: 'twin edge',
      series: '3060ti',
      url: 'https://www.materiel.net/produit/202011060034.html',
    },
    {
      brand: 'zotac',
      model: 'twin edge oc',
      series: '3060ti',
      url: 'https://www.materiel.net/produit/202011060033.html',
    },
    {
      brand: 'asus',
      model: 'dual',
      series: '3070',
      url: 'https://www.materiel.net/produit/202009220022.html',
    },
    {
      brand: 'asus',
      model: 'dual oc',
      series: '3070',
      url: 'https://www.materiel.net/produit/202009220023.html',
    },
    {
      brand: 'asus',
      model: 'strix',
      series: '3070',
      url: 'https://www.materiel.net/produit/202009170013.html',
    },
    {
      brand: 'asus',
      model: 'strix oc',
      series: '3070',
      url: 'https://www.materiel.net/produit/202009170012.html',
    },
    {
      brand: 'asus',
      model: 'strix oc white',
      series: '3070',
      url: 'https://www.materiel.net/produit/202101130115.html',
    },
    {
      brand: 'asus',
      model: 'tuf oc',
      series: '3070',
      url: 'https://www.materiel.net/produit/202009290076.html',
    },
    {
      brand: 'evga',
      model: 'ftw3',
      series: '3070',
      url: 'https://www.materiel.net/produit/202010210030.html',
    },
    {
      brand: 'evga',
      model: 'ftw3 ultra',
      series: '3070',
      url: 'https://www.materiel.net/produit/202010210031.html',
    },
    {
      brand: 'evga',
      model: 'xc3 black',
      series: '3070',
      url: 'https://www.materiel.net/produit/202010210023.html',
    },
    {
      brand: 'evga',
      model: 'xc3',
      series: '3070',
      url: 'https://www.materiel.net/produit/202010210026.html',
    },
    {
      brand: 'evga',
      model: 'xc3 ultra',
      series: '3070',
      url: 'https://www.materiel.net/produit/202010210027.html',
    },
    {
      brand: 'gainward',
      model: 'phantom',
      series: '3070',
      url: 'https://www.materiel.net/produit/202010090025.html',
    },
    {
      brand: 'gainward',
      model: 'phantom gs',
      series: '3070',
      url: 'https://www.materiel.net/produit/202010090024.html',
    },
    {
      brand: 'gainward',
      model: 'phoenix',
      series: '3070',
      url: 'https://www.materiel.net/produit/202010090028.html',
    },
    {
      brand: 'gainward',
      model: 'phoenix gs',
      series: '3070',
      url: 'https://www.materiel.net/produit/202010090027.html',
    },
    {
      brand: 'gigabyte',
      model: 'master',
      series: '3070',
      url: 'https://www.materiel.net/produit/202010200076.html',
    },
    {
      brand: 'gigabyte',
      model: 'eagle',
      series: '3070',
      url: 'https://www.materiel.net/produit/202101050074.html',
    },
    {
      brand: 'gigabyte',
      model: 'eagle oc',
      series: '3070',
      url: 'https://www.materiel.net/produit/202009290086.html',
    },
    {
      brand: 'gigabyte',
      model: 'gaming oc',
      series: '3070',
      url: 'https://www.materiel.net/produit/202009290085.html',
    },
    {
      brand: 'gigabyte',
      model: 'vision oc',
      series: '3070',
      url: 'https://www.materiel.net/produit/202010200077.html',
    },
    {
      brand: 'inno3d',
      model: 'ichill x3',
      series: '3070',
      url: 'https://www.materiel.net/produit/202010050072.html',
    },
    {
      brand: 'inno3d',
      model: 'ichill x4',
      series: '3070',
      url: 'https://www.materiel.net/produit/202010050071.html',
    },
    {
      brand: 'inno3d',
      model: 'twin x2 oc',
      series: '3070',
      url: 'https://www.materiel.net/produit/202010050078.html',
    },
    {
      brand: 'kfa2',
      model: 'oc',
      series: '3070',
      url: 'https://www.materiel.net/produit/202011160124.html',
    },
    {
      brand: 'kfa2',
      model: 'ex oc',
      series: '3070',
      url: 'https://www.materiel.net/produit/202011160123.html',
    },
    {
      brand: 'kfa2',
      model: 'sg',
      series: '3070',
      url: 'https://www.materiel.net/produit/202009220060.html',
    },
    {
      brand: 'msi',
      model: 'gaming trio',
      series: '3070',
      url: 'https://www.materiel.net/produit/202102220081.html',
    },
    {
      brand: 'msi',
      model: 'gaming x trio',
      series: '3070',
      url: 'https://www.materiel.net/produit/202010010052.html',
    },
    {
      brand: 'msi',
      model: 'suprim',
      series: '3070',
      url: 'https://www.materiel.net/produit/202012070074.html',
    },
    {
      brand: 'msi',
      model: 'suprim x',
      series: '3070',
      url: 'https://www.materiel.net/produit/202011030097.html',
    },
    {
      brand: 'msi',
      model: 'ventus 2x',
      series: '3070',
      url: 'https://www.materiel.net/produit/202102240027.html',
    },
    {
      brand: 'msi',
      model: 'ventus 2x oc',
      series: '3070',
      url: 'https://www.materiel.net/produit/202010010051.html',
    },
    {
      brand: 'msi',
      model: 'ventus 3x',
      series: '3070',
      url: 'https://www.materiel.net/produit/202102220079.html',
    },
    {
      brand: 'msi',
      model: 'ventus 3x oc',
      series: '3070',
      url: 'https://www.materiel.net/produit/202010010050.html',
    },
    {
      brand: 'palit',
      model: 'gamerock',
      series: '3070',
      url: 'https://www.materiel.net/produit/202010090017.html',
    },
    {
      brand: 'palit',
      model: 'gamerock oc',
      series: '3070',
      url: 'https://www.materiel.net/produit/202010090016.html',
    },
    {
      brand: 'palit',
      model: 'gaming pro',
      series: '3070',
      url: 'https://www.materiel.net/produit/202010090023.html',
    },
    {
      brand: 'palit',
      model: 'gaming pro oc',
      series: '3070',
      url: 'https://www.materiel.net/produit/202010090022.html',
    },
    {
      brand: 'palit',
      model: 'jetstream',
      series: '3070',
      url: 'https://www.materiel.net/produit/202010090021.html',
    },
    {
      brand: 'palit',
      model: 'jetstream oc',
      series: '3070',
      url: 'https://www.materiel.net/produit/202010090019.html',
    },
    {
      brand: 'pny',
      model: 'uprising',
      series: '3070',
      url: 'https://www.materiel.net/produit/202009070042.html',
    },
    {
      brand: 'pny',
      model: 'xlr8 epic x',
      series: '3070',
      url: 'https://www.materiel.net/produit/202009070043.html',
    },
    {
      brand: 'zotac',
      model: 'amp holo',
      series: '3070',
      url: 'https://www.materiel.net/produit/202101120117.html',
    },
    {
      brand: 'zotac',
      model: 'twin edge oc',
      series: '3070',
      url: 'https://www.materiel.net/produit/202009180082.html',
    },
    {
      brand: 'zotac',
      model: 'twin edge oc white',
      series: '3070',
      url: 'https://www.materiel.net/produit/202012220093.html',
    },
    {
      brand: 'asus',
      model: 'strix',
      series: '3080',
      url: 'https://www.materiel.net/produit/202010140550.html',
    },
    {
      brand: 'asus',
      model: 'strix oc',
      series: '3080',
      url: 'https://www.materiel.net/produit/202009090076.html',
    },
    {
      brand: 'asus',
      model: 'tuf',
      series: '3080',
      url: 'https://www.materiel.net/produit/202009010057.html',
    },
    {
      brand: 'asus',
      model: 'tuf oc',
      series: '3080',
      url: 'https://www.materiel.net/produit/202009030080.html',
    },
    {
      brand: 'evga',
      model: 'ftw3',
      series: '3080',
      url: 'https://www.materiel.net/produit/202009090100.html',
    },
    {
      brand: 'evga',
      model: 'ftw3 ultra',
      series: '3080',
      url: 'https://www.materiel.net/produit/202009090101.html',
    },
    {
      brand: 'evga',
      model: 'ftw3 ultra hybrid',
      series: '3080',
      url: 'https://www.materiel.net/produit/202012070098.html',
    },
    {
      brand: 'evga',
      model: 'xc3 black',
      series: '3080',
      url: 'https://www.materiel.net/produit/202009090098.html',
    },
    {
      brand: 'evga',
      model: 'xc3',
      series: '3080',
      url: 'https://www.materiel.net/produit/202009090099.html',
    },
    {
      brand: 'evga',
      model: 'xc3 ultra',
      series: '3080',
      url: 'https://www.materiel.net/produit/202009100088.html',
    },
    {
      brand: 'evga',
      model: 'xc3 ultra hybrid',
      series: '3080',
      url: 'https://www.materiel.net/produit/202012070099.html',
    },
    {
      brand: 'gainward',
      model: 'phantom',
      series: '3080',
      url: 'https://www.materiel.net/produit/202010260052.html',
    },
    {
      brand: 'gainward',
      model: 'phantom gs',
      series: '3080',
      url: 'https://www.materiel.net/produit/202011090017.html',
    },
    {
      brand: 'gainward',
      model: 'phoenix',
      series: '3080',
      url: 'https://www.materiel.net/produit/202009080104.html',
    },
    {
      brand: 'gainward',
      model: 'phoenix gs',
      series: '3080',
      url: 'https://www.materiel.net/produit/202009080103.html',
    },
    {
      brand: 'gigabyte',
      model: 'master',
      series: '3080',
      url: 'https://www.materiel.net/produit/202009290084.html',
    },
    {
      brand: 'gigabyte',
      model: 'xtreme',
      series: '3080',
      url: 'https://www.materiel.net/produit/202011060056.html',
    },
    {
      brand: 'gigabyte',
      model: 'eagle',
      series: '3080',
      url: 'https://www.materiel.net/produit/202101050079.html',
    },
    {
      brand: 'gigabyte',
      model: 'eagle oc',
      series: '3080',
      url: 'https://www.materiel.net/produit/202009080086.html',
    },
    {
      brand: 'gigabyte',
      model: 'gaming oc',
      series: '3080',
      url: 'https://www.materiel.net/produit/202009080083.html',
    },
    {
      brand: 'gigabyte',
      model: 'vision oc',
      series: '3080',
      url: 'https://www.materiel.net/produit/202009300085.html',
    },
    {
      brand: 'inno3d',
      model: 'ichill x3',
      series: '3080',
      url: 'https://www.materiel.net/produit/202009030073.html',
    },
    {
      brand: 'inno3d',
      model: 'ichill x4',
      series: '3080',
      url: 'https://www.materiel.net/produit/202009030072.html',
    },
    {
      brand: 'inno3d',
      model: 'twin x2 oc',
      series: '3080',
      url: 'https://www.materiel.net/produit/202009030079.html',
    },
    {
      brand: 'kfa2',
      model: 'ex gamer',
      series: '3080',
      url: 'https://www.materiel.net/produit/202012080025.html',
    },
    {
      brand: 'kfa2',
      model: 'sg',
      series: '3080',
      url: 'https://www.materiel.net/produit/202009080052.html',
    },
    {
      brand: 'msi',
      model: 'x trio',
      series: '3080',
      url: 'https://www.materiel.net/produit/202009070052.html',
    },
    {
      brand: 'msi',
      model: 'suprim x',
      series: '3080',
      url: 'https://www.materiel.net/produit/202010220025.html',
    },
    {
      brand: 'msi',
      model: 'ventus 3x',
      series: '3080',
      url: 'https://www.materiel.net/produit/202009070053.html',
    },
    {
      brand: 'palit',
      model: 'gamerock',
      series: '3080',
      url: 'https://www.materiel.net/produit/202010260054.html',
    },
    {
      brand: 'palit',
      model: 'gamerock oc',
      series: '3080',
      url: 'https://www.materiel.net/produit/202010260053.html',
    },
    {
      brand: 'palit',
      model: 'gaming pro',
      series: '3080',
      url: 'https://www.materiel.net/produit/202009080100.html',
    },
    {
      brand: 'palit',
      model: 'gaming pro oc',
      series: '3080',
      url: 'https://www.materiel.net/produit/202009080099.html',
    },
    {
      brand: 'pny',
      model: 'epic x',
      series: '3080',
      url: 'https://www.materiel.net/produit/202009070040.html',
    },
    {
      brand: 'pny',
      model: 'epic x',
      series: '3080',
      url: 'https://www.materiel.net/produit/202009070041.html',
    },
    {
      brand: 'zotac',
      model: 'amp holo',
      series: '3080',
      url: 'https://www.materiel.net/produit/202009180077.html',
    },
    {
      brand: 'zotac',
      model: 'trinity',
      series: '3080',
      url: 'https://www.materiel.net/produit/202009030021.html',
    },
    {
      brand: 'zotac',
      model: 'trinity oc',
      series: '3080',
      url: 'https://www.materiel.net/produit/202009180078.html',
    },
  ],
  name: 'materiel',
};
