import {Store} from './store';

export const LdlcEs: Store = {
  currency: '€',
  labels: {
    inStock: {
      container: '#product-page-stock > div > div.content > div > span',
      text: ['stock'],
    },
    maxPrice: {
      container:
        '#activeOffer > div.product-info > div.wrap-aside > aside > div.price > div',
      euroFormat: true,
    },
    outOfStock: {
      container: '#product-page-stock > div > div.content > div > span',
      text: ['agotado'],
    },
  },
  links: [
    {
      brand: 'test:brand',
      model: 'test:model',
      series: 'test:series',
      url: 'https://www.ldlc.com/es-es/ficha/PB00223568.html',
    },
    // 3090
    {
      brand: 'asus',
      model: 'tuf',
      series: '3090',
      url: 'https://www.ldlc.com/es-es/ficha/PB00369842.html',
    },
    {
      brand: 'asus',
      model: 'tuf oc',
      series: '3090',
      url: 'https://www.ldlc.com/es-es/ficha/PB00374911.html',
    },
    {
      brand: 'asus',
      model: 'gaming oc',
      series: '3090',
      url: 'https://www.ldlc.com/es-es/ficha/PB00369849.html',
    },
    {
      brand: 'evga',
      model: 'ftw3 ultra',
      series: '3090',
      url: 'https://www.ldlc.com/es-es/ficha/PB00374837.html',
    },
    {
      brand: 'evga',
      model: 'ftw3',
      series: '3090',
      url: 'https://www.ldlc.com/es-es/ficha/PB00374838.html',
    },
    {
      brand: 'evga',
      model: 'ftw3 ultra hybrid',
      series: '3090',
      url: 'https://www.ldlc.com/es-es/ficha/PB00398037.html',
    },
    {
      brand: 'evga',
      model: 'kngpn hybrid',
      series: '3090',
      url: 'https://www.ldlc.com/es-es/ficha/PB00398044.html',
    },
    {
      brand: 'evga',
      model: 'xc3 black',
      series: '3090',
      url: 'https://www.ldlc.com/es-es/ficha/PB00374629.html',
    },
    {
      brand: 'evga',
      model: 'xc3',
      series: '3090',
      url: 'https://www.ldlc.com/es-es/ficha/PB00374628.html',
    },
    {
      brand: 'evga',
      model: 'xc3 ultra',
      series: '3090',
      url: 'https://www.ldlc.com/es-es/ficha/PB00374631.html',
    },
    {
      brand: 'evga',
      model: 'xc3 ultra hybrid',
      series: '3090',
      url: 'https://www.ldlc.com/es-es/ficha/PB00398039.html',
    },
    {
      brand: 'gainward',
      model: 'phantom',
      series: '3090',
      url: 'https://www.ldlc.com/es-es/ficha/PB00390729.html',
    },
    {
      brand: 'gainward',
      model: 'phantom gs',
      series: '3090',
      url: 'https://www.ldlc.com/es-es/ficha/PB00390227.html',
    },
    {
      brand: 'gainward',
      model: 'phoenix',
      series: '3090',
      url: 'https://www.ldlc.com/es-es/ficha/PB00370903.html',
    },
    {
      brand: 'gainward',
      model: 'phoenix gs',
      series: '3090',
      url: 'https://www.ldlc.com/es-es/ficha/PB00370913.html',
    },
    {
      brand: 'gigabyte',
      model: 'aorus master',
      series: '3090',
      url: 'https://www.ldlc.com/es-es/ficha/PB00376302.html',
    },
    {
      brand: 'gigabyte',
      model: 'aorus xtreme',
      series: '3090',
      url: 'https://www.ldlc.com/es-es/ficha/PB00390730.html',
    },
    {
      brand: 'gigabyte',
      model: 'aorus xtreme waterforce wb',
      series: '3090',
      url: 'https://www.ldlc.com/es-es/ficha/PB00400756.html',
    },
    {
      brand: 'gigabyte',
      model: 'eagle oc',
      series: '3090',
      url: 'https://www.ldlc.com/es-es/ficha/PB00371132.html',
    },
    {
      brand: 'gigabyte',
      model: 'gaming oc',
      series: '3090',
      url: 'https://www.ldlc.com/es-es/ficha/PB00371131.html',
    },
    {
      brand: 'gigabyte',
      model: 'turbo',
      series: '3090',
      url: 'https://www.ldlc.com/es-es/ficha/PB00391621.html',
    },
    {
      brand: 'gigabyte',
      model: 'vision oc',
      series: '3090',
      url: 'https://www.ldlc.com/es-es/ficha/PB00386908.html',
    },
    {
      brand: 'inno3d',
      model: 'ichill x4',
      series: '3090',
      url: 'https://www.ldlc.com/es-es/ficha/PB00374614.html',
    },
    {
      brand: 'inno3d',
      model: 'gaming x3',
      series: '3090',
      url: 'https://www.ldlc.com/es-es/ficha/PB00371280.html',
    },
    {
      brand: 'inno3d',
      model: 'ichill frostbite',
      series: '3090',
      url: 'https://www.ldlc.com/es-es/ficha/PB00391541.html',
    },
    {
      brand: 'inno3d',
      model: 'ichill x3',
      series: '3090',
      url: 'https://www.ldlc.com/es-es/ficha/PB00374606.html',
    },
    {
      brand: 'kfa2',
      model: 'sg',
      series: '3090',
      url: 'https://www.ldlc.com/es-es/ficha/PB00371133.html',
    },
    {
      brand: 'msi',
      model: 'suprim x',
      series: '3090',
      url: 'https://www.ldlc.com/es-es/ficha/PB00391683.html',
    },
    {
      brand: 'msi',
      model: 'gaming x trio',
      series: '3090',
      url: 'https://www.ldlc.com/es-es/ficha/PB00370065.html',
    },
    {
      brand: 'msi',
      model: 'ventus 3x oc',
      series: '3090',
      url: 'https://www.ldlc.com/es-es/ficha/PB00370057.html',
    },
    {
      brand: 'palit',
      model: 'gamerock',
      series: '3090',
      url: 'https://www.ldlc.com/es-es/ficha/PB00389189.html',
    },
    {
      brand: 'palit',
      model: 'gamerock oc',
      series: '3090',
      url: 'https://www.ldlc.com/es-es/ficha/PB00391625.html',
    },
    {
      brand: 'palit',
      model: 'gaming pro',
      series: '3090',
      url: 'https://www.ldlc.com/es-es/ficha/PB00374912.html',
    },
    {
      brand: 'palit',
      model: 'gaming pro oc',
      series: '3090',
      url: 'https://www.ldlc.com/es-es/ficha/PB00374914.html',
    },
    {
      brand: 'zotac',
      model: 'amp holo',
      series: '3090',
      url: 'https://www.ldlc.com/es-es/ficha/PB00431614.html',
    },
    {
      brand: 'zotac',
      model: 'trinity oc',
      series: '3090',
      url: 'https://www.ldlc.com/es-es/ficha/PB00401472.html',
    },
    {
      brand: 'zotac',
      model: 'trinity',
      series: '3090',
      url: 'https://www.ldlc.com/es-es/ficha/PB00370250.html',
    },
    // 3080ti
    {
      brand: 'asus',
      model: 'strix',
      series: '3080ti',
      url: 'https://www.ldlc.com/es-es/ficha/PB00438231.html',
    },
    {
      brand: 'asus',
      model: 'tuf oc',
      series: '3080ti',
      url: 'https://www.ldlc.com/es-es/ficha/PB00438230.html',
    },
    {
      brand: 'asus',
      model: 'tuf',
      series: '3080ti',
      url: 'https://www.ldlc.com/es-es/ficha/PB00438229.html',
    },
    {
      brand: 'evga',
      model: 'ftw3 ultra',
      series: '3080ti',
      url: 'https://www.ldlc.com/es-es/ficha/PB00438264.html',
    },
    {
      brand: 'evga',
      model: 'ftw3',
      series: '3080ti',
      url: 'https://www.ldlc.com/es-es/ficha/PB00438537.html',
    },
    {
      brand: 'evga',
      model: 'xc3 ultra',
      series: '3080ti',
      url: 'https://www.ldlc.com/es-es/ficha/PB00438539.html',
    },
    {
      brand: 'evga',
      model: 'xc3 black',
      series: '3080ti',
      url: 'https://www.ldlc.com/es-es/ficha/PB00438543.html',
    },
    {
      brand: 'evga',
      model: 'ftw3 ultra hybrid',
      series: '3080ti',
      url: 'https://www.ldlc.com/es-es/ficha/PB00440781.html',
    },
    {
      brand: 'evga',
      model: 'xc3',
      series: '3080ti',
      url: 'https://www.ldlc.com/es-es/ficha/PB00438542.html',
    },
    {
      brand: 'gainward',
      model: 'phoenix',
      series: '3080ti',
      url: 'https://www.ldlc.com/es-es/ficha/PB00438243.html',
    },
    {
      brand: 'gigabyte',
      model: 'gaming oc',
      series: '3080ti',
      url: 'https://www.ldlc.com/es-es/ficha/PB00438260.html',
    },
    {
      brand: 'gigabyte',
      model: 'vision oc',
      series: '3080ti',
      url: 'https://www.ldlc.com/es-es/ficha/PB00438262.html',
    },
    {
      brand: 'gigabyte',
      model: 'aorus xtreme',
      series: '3080ti',
      url: 'https://www.ldlc.com/es-es/ficha/PB00438269.html',
    },
    {
      brand: 'gigabyte',
      model: 'eagle',
      series: '3080ti',
      url: 'https://www.ldlc.com/es-es/ficha/PB00438258.html',
    },
    {
      brand: 'gigabyte',
      model: 'aorus master',
      series: '3080ti',
      url: 'https://www.ldlc.com/es-es/ficha/PB00438279.html',
    },
    {
      brand: 'gigabyte',
      model: 'eagle oc',
      series: '3080ti',
      url: 'https://www.ldlc.com/es-es/ficha/PB00438259.html',
    },
    {
      brand: 'inno3d',
      model: 'ichill frostbite',
      series: '3080ti',
      url: 'https://www.ldlc.com/es-es/ficha/PB00438516.html',
    },
    {
      brand: 'inno3d',
      model: 'x3 oc',
      series: '3080ti',
      url: 'https://www.ldlc.com/es-es/ficha/PB00438517.html',
    },
    {
      brand: 'inno3d',
      model: 'ichill x3',
      series: '3080ti',
      url: 'https://www.ldlc.com/es-es/ficha/PB00438292.html',
    },
    {
      brand: 'inno3d',
      model: 'ichill x4',
      series: '3080ti',
      url: 'https://www.ldlc.com/es-es/ficha/PB00438564.html',
    },
    {
      brand: 'kfa2',
      model: 'sg oc',
      series: '3080ti',
      url: 'https://www.ldlc.com/es-es/ficha/PB00438228.html',
    },
    {
      brand: 'msi',
      model: 'gaming x trio',
      series: '3080ti',
      url: 'https://www.ldlc.com/es-es/ficha/PB00438240.html',
    },
    {
      brand: 'msi',
      model: 'suprim x',
      series: '3080ti',
      url: 'https://www.ldlc.com/es-es/ficha/PB00438242.html  ',
    },
    {
      brand: 'msi',
      model: 'ventus 3x oc',
      series: '3080ti',
      url: 'https://www.ldlc.com/es-es/ficha/PB00438520.html',
    },
    {
      brand: 'palit',
      model: 'gamerock oc',
      series: '3080ti',
      url: 'https://www.ldlc.com/es-es/ficha/PB00438238.html',
    },
    {
      brand: 'palit',
      model: 'gaming pro',
      series: '3080ti',
      url: 'https://www.ldlc.com/es-es/ficha/PB00438241.html',
    },
    {
      brand: 'palit',
      model: 'gamerock',
      series: '3080ti',
      url: 'https://www.ldlc.com/es-es/ficha/PB00438263.html',
    },
    {
      brand: 'zotac',
      model: 'amp holo',
      series: '3080ti',
      url: 'https://www.ldlc.com/es-es/ficha/PB00438234.html',
    },
    {
      brand: 'zotac',
      model: 'trinity',
      series: '3080ti',
      url: 'https://www.ldlc.com/es-es/ficha/PB00438232.html',
    },
    {
      brand: 'zotac',
      model: 'trinity oc',
      series: '3080ti',
      url: 'https://www.ldlc.com/es-es/ficha/PB00438233.html',
    },
    // 3080
    {
      brand: 'gigabyte',
      model: 'eagle',
      series: '3080',
      url: 'https://www.ldlc.com/es-es/ficha/PB00400753.html',
    },
    {
      brand: 'gigabyte',
      model: 'eagle',
      series: '3080',
      url: 'https://www.ldlc.com/es-es/ficha/PB00400753.html',
    },
    {
      brand: 'gigabyte',
      model: 'eagle oc',
      series: '3080',
      url: 'https://www.ldlc.com/es-es/ficha/PB00369072.html',
    },
    {
      brand: 'zotac',
      model: 'trinity',
      series: '3080',
      url: 'https://www.ldlc.com/es-es/ficha/PB00368579.html',
    },
    {
      brand: 'zotac',
      model: 'trinity oc',
      series: '3080',
      url: 'https://www.ldlc.com/es-es/ficha/PB00375644.html',
    },
    {
      brand: 'asus',
      model: 'tuf',
      series: '3080',
      url: 'https://www.ldlc.com/es-es/ficha/PB00368789.html',
    },
    {
      brand: 'asus',
      model: 'tuf oc',
      series: '3080',
      url: 'https://www.ldlc.com/es-es/ficha/PB00368844.html',
    },
    {
      brand: 'gainward',
      model: 'phoenix gs',
      series: '3080',
      url: 'https://www.ldlc.com/es-es/ficha/PB00369158.html',
    },
    {
      brand: 'palit',
      model: 'gamerock oc',
      series: '3080',
      url: 'https://www.ldlc.com/es-es/ficha/PB00386332.html',
    },
    {
      brand: 'palit',
      model: 'gaming pro oc',
      series: '3080',
      url: 'https://www.ldlc.com/es-es/ficha/PB00375448.html',
    },
    {
      brand: 'evga',
      model: 'xc3',
      series: '3080',
      url: 'https://www.ldlc.com/es-es/ficha/PB00369268.html',
    },
    {
      brand: 'evga',
      model: 'xc3 black',
      series: '3080',
      url: 'https://www.ldlc.com/es-es/ficha/PB00369298.html',
    },
    {
      brand: 'kfa2',
      model: 'sg',
      series: '3080',
      url: 'https://www.ldlc.com/es-es/ficha/PB00368931.html',
    },
    {
      brand: 'inno3d',
      model: 'twin x2 oc',
      series: '3080',
      url: 'https://www.ldlc.com/es-es/ficha/PB00368690.html',
    },
    {
      brand: 'msi',
      model: 'ventus 3x oc',
      series: '3080',
      url: 'https://www.ldlc.com/es-es/ficha/PB00368506.html',
    },
    {
      brand: 'gigabyte',
      model: 'vision oc',
      series: '3080',
      url: 'https://www.ldlc.com/es-es/ficha/PB00376207.html',
    },
    {
      brand: 'evga',
      model: 'xc3 ultra hybrid',
      series: '3080',
      url: 'https://www.ldlc.com/es-es/ficha/PB00398045.html',
    },
    {
      brand: 'evga',
      model: 'xc3 ultra hybrid',
      series: '3080',
      url: 'https://www.ldlc.com/es-es/ficha/PB00398045.html',
    },
    {
      brand: 'evga',
      model: 'xc3 ultra',
      series: '3080',
      url: 'https://www.ldlc.com/es-es/ficha/PB00369303.html',
    },
    {
      brand: 'evga',
      model: 'ftw3',
      series: '3080',
      url: 'https://www.ldlc.com/es-es/ficha/PB00369265.html',
    },
    {
      brand: 'gigabyte',
      model: 'gaming oc',
      series: '3080',
      url: 'https://www.ldlc.com/es-es/ficha/PB00368968.html',
    },
    {
      brand: 'evga',
      model: 'ftw3 ultra',
      series: '3080',
      url: 'https://www.ldlc.com/es-es/ficha/PB00369299.html',
    },
    {
      brand: 'evga',
      model: 'ftw3 ultra hybrid',
      series: '3080',
      url: 'https://www.ldlc.com/es-es/ficha/PB00398046.html',
    },
    {
      brand: 'asus',
      model: 'strix',
      series: '3080',
      url: 'https://www.ldlc.com/es-es/ficha/PB00385535.html',
    },
    {
      brand: 'asus',
      model: 'strix oc',
      series: '3080',
      url: 'https://www.ldlc.com/es-es/ficha/PB00375431.html',
    },
    {
      brand: 'inno3d',
      model: 'ichill x4',
      series: '3080',
      url: 'https://www.ldlc.com/es-es/ficha/PB00368692.html',
    },
    {
      brand: 'inno3d',
      model: 'ichill x3',
      series: '3080',
      url: 'https://www.ldlc.com/es-es/ficha/PB00368691.html',
    },
    {
      brand: 'inno3d',
      model: 'ichill frostbite',
      series: '3080',
      url: 'https://www.ldlc.com/es-es/ficha/PB00391624.html',
    },
    {
      brand: 'zotac',
      model: 'amp holo',
      series: '3080',
      url: 'https://www.ldlc.com/es-es/ficha/PB00375625.html',
    },
    {
      brand: 'gigabyte',
      model: 'aorus master',
      series: '3080',
      url: 'https://www.ldlc.com/es-es/ficha/PB00376208.html',
    },
    {
      brand: 'msi',
      model: 'gaming x trio',
      series: '3080',
      url: 'https://www.ldlc.com/es-es/ficha/PB00368574.html',
    },
    {
      brand: 'gainward',
      model: 'phantom',
      series: '3080',
      url: 'https://www.ldlc.com/es-es/ficha/PB00386063.html',
    },
    {
      brand: 'msi',
      model: 'suprim x',
      series: '3080',
      url: 'https://www.ldlc.com/es-es/ficha/PB00391682.html',
    },
    {
      brand: 'gigabyte',
      model: 'aorus xtreme',
      series: '3080',
      url: 'https://www.ldlc.com/es-es/ficha/PB00390466.html',
    },
    {
      brand: 'palit',
      model: 'gaming pro',
      series: '3080',
      url: 'https://www.ldlc.com/es-es/ficha/PB00369094.html',
    },
    {
      brand: 'msi',
      model: 'gaming z trio',
      series: '3080',
      url: 'https://www.ldlc.com/es-es/ficha/PB00423532.html',
    },
    {
      brand: 'gainward',
      model: 'phoenix',
      series: '3080',
      url: 'https://www.ldlc.com/es-es/ficha/PB00369150.html',
    },
    {
      brand: 'palit',
      model: 'gamerock',
      series: '3080',
      url: 'https://www.ldlc.com/es-es/ficha/PB00386334.html',
    },
    {
      brand: 'gainward',
      model: 'phantom gs',
      series: '3080',
      url: 'https://www.ldlc.com/es-es/ficha/PB00390727.html',
    },
    // 3070ti
    {
      brand: 'inno3d',
      model: 'ichill x3',
      series: '3080',
      url: 'https://www.ldlc.com/es-es/ficha/PB00438868.html',
    },
    // 3070
    {
      brand: 'asus',
      model: 'gaming',
      series: '3070',
      url: 'https://www.ldlc.com/es-es/ficha/PB00386907.html',
    },
    {
      brand: 'asus',
      model: 'gaming oc',
      series: '3070',
      url: 'https://www.ldlc.com/es-es/ficha/PB00386904.html',
    },
    {
      brand: 'asus',
      model: 'dual oc',
      series: '3070',
      url: 'https://www.ldlc.com/es-es/ficha/PB00384225.html',
    },
    {
      brand: 'asus',
      model: 'tuf oc',
      series: '3070',
      url: 'https://www.ldlc.com/es-es/ficha/PB00384232.html',
    },
    {
      brand: 'evga',
      model: 'ftw3',
      series: '3070',
      url: 'https://www.ldlc.com/es-es/ficha/PB00386926.html',
    },
    {
      brand: 'evga',
      model: 'ftw3 ultra',
      series: '3070',
      url: 'https://www.ldlc.com/es-es/ficha/PB00386925.html',
    },
    {
      brand: 'evga',
      model: 'xc3 black',
      series: '3070',
      url: 'https://www.ldlc.com/es-es/ficha/PB00386030.html',
    },
    {
      brand: 'evga',
      model: 'xc3',
      series: '3070',
      url: 'https://www.ldlc.com/es-es/ficha/PB00386928.html',
    },
    {
      brand: 'evga',
      model: 'xc3 ultra',
      series: '3070',
      url: 'https://www.ldlc.com/es-es/ficha/PB00386927.html',
    },
    {
      brand: 'gainward',
      model: 'phantom',
      series: '3070',
      url: 'https://www.ldlc.com/es-es/ficha/PB00385465.html',
    },
    {
      brand: 'gainward',
      model: 'phantom gs',
      series: '3070',
      url: 'https://www.ldlc.com/es-es/ficha/PB00385466.html',
    },
    {
      brand: 'gainward',
      model: 'phoenix',
      series: '3070',
      url: 'https://www.ldlc.com/es-es/ficha/PB00385462.html',
    },
    {
      brand: 'gainward',
      model: 'phoenix gs',
      series: '3070',
      url: 'https://www.ldlc.com/es-es/ficha/PB00385463.html',
    },
    {
      brand: 'gigabyte',
      model: 'aorus master',
      series: '3070',
      url: 'https://www.ldlc.com/es-es/ficha/PB00385044.html',
    },
    {
      brand: 'gigabyte',
      model: 'eagle',
      series: '3070',
      url: 'https://www.ldlc.com/es-es/ficha/PB00400752.html',
    },
    {
      brand: 'gigabyte',
      model: 'eagle oc',
      series: '3070',
      url: 'https://www.ldlc.com/es-es/ficha/PB00383549.html',
    },
    {
      brand: 'gigabyte',
      model: 'gaming oc',
      series: '3070',
      url: 'https://www.ldlc.com/es-es/ficha/PB00384189.html',
    },
    {
      brand: 'gigabyte',
      model: 'vision oc',
      series: '3070',
      url: 'https://www.ldlc.com/es-es/ficha/PB00385043.html',
    },
    {
      brand: 'inno3d',
      model: 'ichill x3',
      series: '3070',
      url: 'https://www.ldlc.com/es-es/ficha/PB00386014.html',
    },
    {
      brand: 'inno3d',
      model: 'ichill x4',
      series: '3070',
      url: 'https://www.ldlc.com/es-es/ficha/PB00386023.html',
    },
    {
      brand: 'inno3d',
      model: 'twin x2',
      series: '3070',
      url: 'https://www.ldlc.com/es-es/ficha/PB00385663.html',
    },
    {
      brand: 'kfa2',
      model: 'ex',
      series: '3070',
      url: 'https://www.ldlc.com/es-es/ficha/PB00393364.html',
    },
    {
      brand: 'kfa2',
      model: 'ex',
      series: '3070',
      url: 'https://www.ldlc.com/es-es/ficha/PB00393363.html',
    },
    {
      brand: 'msi',
      model: 'gaming trio',
      series: '3070',
      url: 'https://www.ldlc.com/es-es/ficha/PB00408781.html',
    },
    {
      brand: 'msi',
      model: 'gaming x trio',
      series: '3070',
      url: 'https://www.ldlc.com/es-es/ficha/PB00385048.html',
    },
    {
      brand: 'msi',
      model: 'suprim',
      series: '3070',
      url: 'https://www.ldlc.com/es-es/ficha/PB00395874.html',
    },
    {
      brand: 'msi',
      model: 'ventus 2x',
      series: '3070',
      url: 'https://www.ldlc.com/es-es/ficha/PB00385046.html',
    },
    {
      brand: 'msi',
      model: 'ventus 3x',
      series: '3070',
      url: 'https://www.ldlc.com/es-es/ficha/PB00408780.html',
    },
    {
      brand: 'msi',
      model: 'ventus 3x oc',
      series: '3070',
      url: 'https://www.ldlc.com/es-es/ficha/PB00385045.html',
    },
    {
      brand: 'palit',
      model: 'gamerock',
      series: '3070',
      url: 'https://www.ldlc.com/es-es/ficha/PB00385128.html',
    },
    {
      brand: 'palit',
      model: 'gamerock oc',
      series: '3070',
      url: 'https://www.ldlc.com/es-es/ficha/PB00385129.html',
    },
    {
      brand: 'palit',
      model: 'gaming pro',
      series: '3070',
      url: 'https://www.ldlc.com/es-es/ficha/PB00385126.html',
    },
    {
      brand: 'palit',
      model: 'gaming pro oc',
      series: '3070',
      url: 'https://www.ldlc.com/es-es/ficha/PB00385127.html',
    },
    {
      brand: 'palit',
      model: 'jetstream',
      series: '3070',
      url: 'https://www.ldlc.com/es-es/ficha/PB00385131.html',
    },
    {
      brand: 'palit',
      model: 'jetstream oc',
      series: '3070',
      url: 'https://www.ldlc.com/es-es/ficha/PB00385132.html',
    },
    {
      brand: 'zotac',
      model: 'amp holo',
      series: '3070',
      url: 'https://www.ldlc.com/es-es/ficha/PB00401469.html',
    },
    {
      brand: 'zotac',
      model: 'twin edge oc',
      series: '3070',
      url: 'https://www.ldlc.com/es-es/ficha/PB00383541.html',
    },
  ],
  name: 'ldlc-es',
};
