import {Store} from './store';

export const Drako: Store = {
  currency: '€',
  labels: {
    inStock: [
      {
        container: '#bottom_left_panel > div:nth-child(9) > div:nth-child(2)',
        text: ['ordinabile'],
      },
    ],
    maxPrice: {
      container: '.price',
      euroFormat: true,
    },
  },
  links: [
    {
      brand: 'test:brand',
      cartUrl:
        'http://www.drako.it/drako_catalog/product_info.php?products_id=22674&action=add_product',
      model: 'test:model',
      series: 'test:series',
      url: 'http://www.drako.it/drako_catalog/product_info.php?products_id=22674',
    },
    {
      brand: 'kfa2',
      cartUrl:
        'http://www.drako.it/drako_catalog/product_info.php?products_id=24303&action=add_product',
      model: 'sg',
      series: '3090',
      url: 'http://www.drako.it/drako_catalog/product_info.php?products_id=24303',
    },
    {
      brand: 'asus',
      cartUrl:
        'http://www.drako.it/drako_catalog/product_info.php?products_id=24286&action=add_product',
      model: 'gaming oc',
      series: '3090',
      url: 'http://www.drako.it/drako_catalog/product_info.php?products_id=24286',
    },
    {
      brand: 'asus',
      cartUrl:
        'http://www.drako.it/drako_catalog/product_info.php?products_id=24722&action=add_product',
      model: 'strix oc',
      series: '3090',
      url: 'http://www.drako.it/drako_catalog/product_info.php?products_id=24722',
    },
    {
      brand: 'asus',
      cartUrl:
        'http://www.drako.it/drako_catalog/product_info.php?products_id=24288&action=add_product',
      model: 'strix',
      series: '3090',
      url: 'http://www.drako.it/drako_catalog/product_info.php?products_id=24288',
    },
    {
      brand: 'asus',
      cartUrl:
        'http://www.drako.it/drako_catalog/product_info.php?products_id=24291&action=add_product',
      model: 'tuf oc',
      series: '3090',
      url: 'http://www.drako.it/drako_catalog/product_info.php?products_id=24291',
    },
    {
      brand: 'asus',
      cartUrl:
        'http://www.drako.it/drako_catalog/product_info.php?products_id=24680&action=add_product',
      model: 'ekwb',
      series: '3090',
      url: 'http://www.drako.it/drako_catalog/product_info.php?products_id=24680',
    },
    {
      brand: 'asus',
      cartUrl:
        'http://www.drako.it/drako_catalog/product_info.php?products_id=24290&action=add_product',
      model: 'tuf',
      series: '3090',
      url: 'http://www.drako.it/drako_catalog/product_info.php?products_id=24290',
    },
    {
      brand: 'asus',
      cartUrl:
        'http://www.drako.it/drako_catalog/product_info.php?products_id=24666&action=add_product',
      model: 'ekwb',
      series: '3080',
      url: 'http://www.drako.it/drako_catalog/product_info.php?products_id=24666',
    },
    {
      brand: 'asus',
      cartUrl:
        'http://www.drako.it/drako_catalog/product_info.php?products_id=24289&action=add_product',
      model: 'strix oc',
      series: '3080',
      url: 'http://www.drako.it/drako_catalog/product_info.php?products_id=24289',
    },
    {
      brand: 'asus',
      cartUrl:
        'http://www.drako.it/drako_catalog/product_info.php?products_id=24723&action=add_product',
      model: 'strix white',
      series: '3080',
      url: 'http://www.drako.it/drako_catalog/product_info.php?products_id=24723',
    },
    {
      brand: 'asus',
      cartUrl:
        'http://www.drako.it/drako_catalog/product_info.php?products_id=24287&action=add_product',
      model: 'strix',
      series: '3080',
      url: 'http://www.drako.it/drako_catalog/product_info.php?products_id=24287',
    },
    {
      brand: 'asus',
      cartUrl:
        'http://www.drako.it/drako_catalog/product_info.php?products_id=24293&action=add_product',
      model: 'tuf oc',
      series: '3080',
      url: 'http://www.drako.it/drako_catalog/product_info.php?products_id=24293',
    },
    {
      brand: 'asus',
      cartUrl:
        'http://www.drako.it/drako_catalog/product_info.php?products_id=24292&action=add_product',
      model: 'tuf',
      series: '3080',
      url: 'http://www.drako.it/drako_catalog/product_info.php?products_id=24292',
    },
    {
      brand: 'asus',
      cartUrl:
        'http://www.drako.it/drako_catalog/product_info.php?products_id=24420&action=add_product',
      model: 'dual',
      series: '3070',
      url: 'http://www.drako.it/drako_catalog/product_info.php?products_id=24420',
    },
    {
      brand: 'asus',
      cartUrl:
        'http://www.drako.it/drako_catalog/product_info.php?products_id=24422&action=add_product',
      model: 'strix',
      series: '3070',
      url: 'http://www.drako.it/drako_catalog/product_info.php?products_id=24422',
    },
    {
      brand: 'asus',
      cartUrl:
        'http://www.drako.it/drako_catalog/product_info.php?products_id=24721&action=add_product',
      model: 'tuf',
      series: '3070',
      url: 'http://www.drako.it/drako_catalog/product_info.php?products_id=24721',
    },
    {
      brand: 'asus',
      cartUrl:
        'http://www.drako.it/drako_catalog/product_info.php?products_id=24421&action=add_product',
      model: 'tuf oc',
      series: '3070',
      url: 'http://www.drako.it/drako_catalog/product_info.php?products_id=24421',
    },
    {
      brand: 'gigabyte',
      cartUrl:
        'http://www.drako.it/drako_catalog/product_info.php?products_id=24426&action=add_product',
      model: 'aorus master',
      series: '3070',
      url: 'http://www.drako.it/drako_catalog/product_info.php?products_id=24426',
    },
    {
      brand: 'gigabyte',
      cartUrl:
        'http://www.drako.it/drako_catalog/product_info.php?products_id=24423&action=add_product',
      model: 'eagle oc',
      series: '3070',
      url: 'http://www.drako.it/drako_catalog/product_info.php?products_id=24423',
    },
    {
      brand: 'gigabyte',
      cartUrl:
        'http://www.drako.it/drako_catalog/product_info.php?products_id=24425&action=add_product',
      model: 'gaming oc',
      series: '3070',
      url: 'http://www.drako.it/drako_catalog/product_info.php?products_id=24425',
    },
    {
      brand: 'gigabyte',
      cartUrl:
        'http://www.drako.it/drako_catalog/product_info.php?products_id=24424&action=add_product',
      model: 'eagle',
      series: '3070',
      url: 'http://www.drako.it/drako_catalog/product_info.php?products_id=24424',
    },
    {
      brand: 'kfa2',
      cartUrl:
        'http://www.drako.it/drako_catalog/product_info.php?products_id=24292&action=add_product',
      model: 'sg',
      series: '3070',
      url: 'http://www.drako.it/drako_catalog/product_info.php?products_id=24475',
    },
    {
      brand: 'asus',
      cartUrl:
        'http://www.drako.it/drako_catalog/product_info.php?products_id=24604&action=add_product',
      model: 'strix',
      series: 'rx6800',
      url: 'http://www.drako.it/drako_catalog/product_info.php?products_id=24604',
    },
    {
      brand: 'asus',
      cartUrl:
        'http://www.drako.it/drako_catalog/product_info.php?products_id=24605&action=add_product',
      model: 'tuf',
      series: 'rx6800',
      url: 'http://www.drako.it/drako_catalog/product_info.php?products_id=24605',
    },
    {
      brand: 'asus',
      cartUrl:
        'http://www.drako.it/drako_catalog/product_info.php?products_id=24606&action=add_product',
      model: 'tuf oc',
      series: 'rx6800',
      url: 'http://www.drako.it/drako_catalog/product_info.php?products_id=24606',
    },
    {
      brand: 'gigabyte',
      cartUrl:
        'http://www.drako.it/drako_catalog/product_info.php?products_id=24606&action=add_product',
      model: 'amd reference',
      series: 'rx6800',
      url: 'http://www.drako.it/drako_catalog/product_info.php?products_id=24606',
    },
    {
      brand: 'amd',
      cartUrl:
        'http://www.drako.it/drako_catalog/product_info.php?products_id=24456&action=add_product',
      model: '5600x',
      series: 'ryzen5600',
      url: 'http://www.drako.it/drako_catalog/product_info.php?products_id=24456',
    },
  ],
  name: 'drako',
  successStatusCodes: [[0, 399], 404],
};
