import {Store} from './store';

export const Computeruniverse: Store = {
  backoffStatusCodes: [503],
  currency: '€',
  labels: {
    inStock: {
      container: '.availability',
      text: [
        'bestellartikel',
        'auf lager und sofort lieferbar',
        'kurzfristig verfügbar',
      ],
    },
    maxPrice: {
      container: '.product-price',
      euroFormat: true,
    },
    outOfStock: {
      container: '.availability',
      text: ['nicht verfügbar', 'liefertermin hat erhebliche schwankungen'],
    },
  },
  links: [
    {
      brand: 'test:brand',
      model: 'test:model',
      series: 'test:series',
      url: 'https://www.computeruniverse.net/de/gainward-geforce-gtx-1660-super-ghost-6-gb-high-end-grafikkarte',
    },
    {
      brand: 'asus',
      model: 'dual',
      series: '3060ti',
      url: 'https://www.computeruniverse.net/de/asus-geforce-rtx3060-ti-dual-8-gb',
    },
    {
      brand: 'palit',
      model: 'dual',
      series: '3060ti',
      url: 'https://www.computeruniverse.net/de/palit-geforce-rtx3060-ti-dual-8-gb',
    },
    {
      brand: 'inno3d',
      model: 'ichill x3',
      series: '3060ti',
      url: 'https://www.computeruniverse.net/de/inno3d-geforce-rtx-3060-ti-ichill-x3-8-gb-oc',
    },
    {
      brand: 'msi',
      model: 'ventus 2x oc',
      series: '3060ti',
      url: 'https://www.computeruniverse.net/de/msi-geforce-rtx3060-ti-ventus-2x-oc-8-gb-oc',
    },
    {
      brand: 'msi',
      model: 'gaming x trio',
      series: '3060ti',
      url: 'https://www.computeruniverse.net/de/msi-geforce-rtx3060-ti-gaming-x-trio-8-gb-oc',
    },
    {
      brand: 'gigabyte',
      model: 'gaming oc',
      series: '3060ti',
      url: 'https://www.computeruniverse.net/de/gigabyte-geforce-rtx-3060-ti-gaming-oc-8-gb-oc',
    },
    {
      brand: 'gigabyte',
      model: 'eagle oc',
      series: '3060ti',
      url: 'https://www.computeruniverse.net/de/gigabyte-geforce-rtx3060-ti-eagle-oc-8-gb-oc',
    },
    {
      brand: 'evga',
      model: 'xc gaming',
      series: '3060ti',
      url: 'https://www.computeruniverse.net/de/evga-geforce-rtx3060-ti-xc-gaming-8-gb',
    },
    {
      brand: 'gainward',
      model: 'phoenix',
      series: '3060ti',
      url: 'https://www.computeruniverse.net/de/gainward-geforce-rtx3060-ti-phoenix-8-gb',
    },
    {
      brand: 'inno3d',
      model: 'twin x2 oc',
      series: '3060ti',
      url: 'https://www.computeruniverse.net/de/inno3d-geforce-rtx-3060-ti-twin-x2-oc-8-gb-oc',
    },
    {
      brand: 'gainward',
      model: 'ghost oc',
      series: '3060ti',
      url: 'https://www.computeruniverse.net/de/gainward-geforce-rtx-3060-ti-ghost-oc-8-gb-oc',
    },
    {
      brand: 'palit',
      model: 'dual oc',
      series: '3060ti',
      url: 'https://www.computeruniverse.net/de/palit-geforce-rtx-3060-ti-dual-oc-8-gb-oc',
    },
    {
      brand: 'zotac',
      model: 'twin edge oc',
      series: '3060ti',
      url: 'https://www.computeruniverse.net/de/zotac-gaming-geforce-rtx-3060-ti-twin-edge-oc-8-gb-oc',
    },
    {
      brand: 'zotac',
      model: 'twin edge',
      series: '3060ti',
      url: 'https://www.computeruniverse.net/de/zotac-gaming-geforce-rtx3060-ti-twin-edge-8-gb',
    },
    {
      brand: 'evga',
      model: 'ftw3 ultra',
      series: '3060ti',
      url: 'https://www.computeruniverse.net/de/evga-geforce-rtx3060-ti-ftw3-ultra-gaming-8-gb-oc',
    },
    {
      brand: 'gainward',
      model: 'phantom gs',
      series: '3060ti',
      url: 'https://www.computeruniverse.net/de/gainward-geforce-rtx3060-ti-phoenix-gs-8-gb-oc',
    },
    {
      brand: 'pny',
      model: 'uprising',
      series: '3060ti',
      url: 'https://www.computeruniverse.net/de/pny-geforce-rtx3060-ti-uprising-x8g-8-gb',
    },
    {
      brand: 'asus',
      model: 'strix oc',
      series: '3060ti',
      url: 'https://www.computeruniverse.net/de/asus-rog-strix-geforce-rtx3060-ti-gaming-oc-8-gb-oc',
    },
    {
      brand: 'gigabyte',
      model: 'eagle',
      series: '3060ti',
      url: 'https://www.computeruniverse.net/de/gigabyte-geforce-rtx3060-ti-eagle-8-gb',
    },
    {
      brand: 'gigabyte',
      model: 'gaming oc pro',
      series: '3060ti',
      url: 'https://www.computeruniverse.net/de/gigabyte-geforce-rtx3060-ti-gaming-oc-pro-8-gb-oc',
    },
    {
      brand: 'inno3d',
      model: 'twin x2',
      series: '3060ti',
      url: 'https://www.computeruniverse.net/de/inno3d-geforce-rtx-3060-ti-twin-x2-8-gb',
    },
    {
      brand: 'asus',
      model: 'tuf oc',
      series: '3060ti',
      url: 'https://www.computeruniverse.net/de/asus-tuf-geforce-rtx3060-ti-gaming-oc-tuf-o8g-gaming-8-gb',
    },
    {
      brand: 'asus',
      model: 'dual oc',
      series: '3060ti',
      url: 'https://www.computeruniverse.net/de/asus-geforce-rtx3060-ti-dual-oc-o8g-dual-o8g-8-gb',
    },
    {
      brand: 'msi',
      model: 'ventus 3x oc',
      series: '3060ti',
      url: 'https://www.computeruniverse.net/de/msi-geforce-rtx3060-ti-ventus-3x-oc-8-gb-oc',
    },
    {
      brand: 'gigabyte',
      model: 'aorus master',
      series: '3060ti',
      url: 'https://www.computeruniverse.net/de/gigabyte-aorus-geforce-rtx3060-ti-master-8-gb',
    },
    {
      brand: 'pny',
      model: 'xlr8 gaming',
      series: '3060ti',
      url: 'https://www.computeruniverse.net/de/pny-geforce-rtx3060-ti-xlr8-gaming-8-gb',
    },
    {
      brand: 'evga',
      model: 'xc black',
      series: '3060ti',
      url: 'https://www.computeruniverse.net/de/evga-geforce-rtx3060-ti-xc-black-gaming-8-gb',
    },
    {
      brand: 'evga',
      model: 'ftw3',
      series: '3060ti',
      url: 'https://www.computeruniverse.net/de/evga-geforce-rtx3060-ti-ftw3-gaming-8-gb',
    },
    {
      brand: 'evga',
      model: 'ftw3 black',
      series: '3060ti',
      url: 'https://www.computeruniverse.net/de/evga-geforce-rtx3060-ti-ftw3-black-gaming-8-gb',
    },
    {
      brand: 'asus',
      model: 'dual',
      series: '3070',
      url: 'https://www.computeruniverse.net/de/asus-geforce-rtx3070-dual-rtx3070-8g-8-gb-enthusiast-grafikkarte',
    },
    {
      brand: 'asus',
      model: 'dual oc',
      series: '3070',
      url: 'https://www.computeruniverse.net/de/asus-geforce-rtx3070-dual-oc-dual-rtx3070-o8g-8-gb-oc-enthusiast-grafikkarte',
    },
    {
      brand: 'asus',
      model: 'strix',
      series: '3070',
      url: 'https://www.computeruniverse.net/de/asus-rog-strix-geforce-rtx3070-gaming-8-gb-enthusiast-grafikkarte',
    },
    {
      brand: 'asus',
      model: 'strix oc',
      series: '3070',
      url: 'https://www.computeruniverse.net/de/asus-rog-strix-geforce-rtx3070-gaming-oc-8-gb-oc-enthusiast-grafikkarte',
    },
    {
      brand: 'evga',
      model: 'xc3 black',
      series: '3070',
      url: 'https://www.computeruniverse.net/de/evga-geforce-rtx3070-xc3-black',
    },
    {
      brand: 'gainward',
      model: 'phoenix',
      series: '3070',
      url: 'https://www.computeruniverse.net/de/gainward-geforce-rtx3070-phoenix-8-gb-enthusiast-grafikkarte',
    },
    {
      brand: 'gainward',
      model: 'phoenix gs',
      series: '3070',
      url: 'https://www.computeruniverse.net/de/gainward-geforce-rtx3070-phoenix-gs-8-gb-enthusiast-grafikkarte',
    },
    {
      brand: 'gigabyte',
      model: 'eagle',
      series: '3070',
      url: 'https://www.computeruniverse.net/de/gigabyte-geforce-rtx3070-eagle-8-gb-enthusiast-grafikkarte',
    },
    {
      brand: 'gigabyte',
      model: 'eagle oc',
      series: '3070',
      url: 'https://www.computeruniverse.net/de/gigabyte-geforce-rtx3070-eagle-oc-8-gb-enthusiast-grafikkarte',
    },
    {
      brand: 'gigabyte',
      model: 'gaming oc',
      series: '3070',
      url: 'https://www.computeruniverse.net/de/gigabyte-geforce-rtx3070-gaming-oc-8-gb-oc-enthusiast-grafikkarte',
    },
    {
      brand: 'inno3d',
      model: 'ichill x3',
      series: '3070',
      url: 'https://www.computeruniverse.net/de/inno3d-geforce-rtx3070-ichill-x3',
    },
    {
      brand: 'inno3d',
      model: 'ichill x4',
      series: '3070',
      url: 'https://www.computeruniverse.net/de/inno3d-geforce-rtx3070-ichill-x4',
    },
    {
      brand: 'msi',
      model: 'gaming x trio',
      series: '3070',
      url: 'https://www.computeruniverse.net/de/msi-geforce-rtx3070-gaming-x-trio-8-gb-enthusiast-grafikkarte',
    },
    {
      brand: 'msi',
      model: 'ventus 2x oc',
      series: '3070',
      url: 'https://www.computeruniverse.net/de/msi-geforce-rtx3070-ventus-2x-oc-8-gb-oc-enthusiast-grafikkarte',
    },
    {
      brand: 'msi',
      model: 'ventus 3x oc',
      series: '3070',
      url: 'https://www.computeruniverse.net/de/msi-geforce-rtx3070-ventus-3x-oc-8-gb-oc-enthusiast-grafikkarte',
    },
    {
      brand: 'palit',
      model: 'gaming pro',
      series: '3070',
      url: 'https://www.computeruniverse.net/de/palit-geforce-rtx3070-gaming-pro-8-gb',
    },
    {
      brand: 'pny',
      model: 'dual fan',
      series: '3070',
      url: 'https://www.computeruniverse.net/de/pny-geforce-rtx3070-m-dual-8-gb',
    },
    {
      brand: 'pny',
      model: 'xlr8 revel',
      series: '3070',
      url: 'https://www.computeruniverse.net/de/pny-geforce-rtx3070-xlr8-gaming-epic-x-rgb-p-8-gb-enthusiast-grafikkarte',
    },
    {
      brand: 'zotac',
      model: 'twin edge oc',
      series: '3070',
      url: 'https://www.computeruniverse.net/de/zotac-gaming-geforce-rtx3070-twin-edge-oc-8-gb-oc',
    },
    {
      brand: 'asus',
      model: 'strix',
      series: '3080',
      url: 'https://www.computeruniverse.net/de/asus-rog-strix-geforce-rtx3080-gaming-10-gb-enthusiast-grafikkarte',
    },
    {
      brand: 'asus',
      model: 'strix oc',
      series: '3080',
      url: 'https://www.computeruniverse.net/de/asus-rog-strix-geforce-rtx3080-gaming-oc-10-gb-oc-enthusiast-grafikkarte',
    },
    {
      brand: 'asus',
      model: 'tuf',
      series: '3080',
      url: 'https://www.computeruniverse.net/de/asus-tuf-geforce-rtx3080-gaming-tuf-rtx3080-10g-gaming-10-gb-enthusiast-grafikkarte',
    },
    {
      brand: 'asus',
      model: 'tuf oc',
      series: '3080',
      url: 'https://www.computeruniverse.net/de/asus-tuf-geforce-rtx3080-gaming-oc-tuf-rtx3080-o10g-gaming-10-gb-oc-enthusiast-grafikkarte',
    },
    {
      brand: 'evga',
      model: 'ftw3',
      series: '3080',
      url: 'https://www.computeruniverse.net/de/evga-geforce-rtx3080-ftw3-10-gb-high-end-grafikkarte',
    },
    {
      brand: 'evga',
      model: 'ftw3 ultra',
      series: '3080',
      url: 'https://www.computeruniverse.net/de/evga-geforce-rtx3080-ultra-ftw3-10-gb-oc-enthusiast-grafikkarte',
    },
    {
      brand: 'evga',
      model: 'xc3',
      series: '3080',
      url: 'https://www.computeruniverse.net/de/evga-geforce-rtx3080-xc3-10-gb-enthusiast-grafikkarte',
    },
    {
      brand: 'evga',
      model: 'xc3 black',
      series: '3080',
      url: 'https://www.computeruniverse.net/de/evga-geforce-rtx3080-xc3-black-10-gb-enthusiast-grafikkarte',
    },
    {
      brand: 'evga',
      model: 'xc3 ultra',
      series: '3080',
      url: 'https://www.computeruniverse.net/de/evga-geforce-rtx3080-xc3-ultra-10-gb-enthusiast-grafikkarte',
    },
    {
      brand: 'gainward',
      model: 'phoenix',
      series: '3080',
      url: 'https://www.computeruniverse.net/de/gainward-geforce-rtx3080-phoenix-10-gb-enthusiast-grafikkarte',
    },
    {
      brand: 'gainward',
      model: 'phoenix gs',
      series: '3080',
      url: 'https://www.computeruniverse.net/de/gainward-geforce-rtx3080-phoenix-gs-10-gb-enthusiast-grafikkarte',
    },
    {
      brand: 'gigabyte',
      model: 'aorus master',
      series: '3080',
      url: 'https://www.computeruniverse.net/de/gigabyte-aorus-geforce-rtx3080-master-10-gb-oc-enthusiast-grafikkarte',
    },
    {
      brand: 'gigabyte',
      model: 'eagle oc',
      series: '3080',
      url: 'https://www.computeruniverse.net/de/gigabyte-geforce-rtx3080-eagle-oc-10-gb-oc-enthusiast-grafikkarte',
    },
    {
      brand: 'gigabyte',
      model: 'gaming oc',
      series: '3080',
      url: 'https://www.computeruniverse.net/de/gigabyte-geforce-rtx3080-gaming-oc-10-gb-enthusiast-grafikkarte',
    },
    {
      brand: 'gigabyte',
      model: 'vision oc',
      series: '3080',
      url: 'https://www.computeruniverse.net/de/gigabyte-geforce-rtx3080-vision-oc-10-gb-oc-enthusiast-grafikkarte',
    },
    {
      brand: 'inno3d',
      model: 'ichill x3',
      series: '3080',
      url: 'https://www.computeruniverse.net/de/inno3d-geforce-rtx3080-ichill-x3-10-gb-enthusiast-grafikkarte',
    },
    {
      brand: 'inno3d',
      model: 'ichill x4',
      series: '3080',
      url: 'https://www.computeruniverse.net/de/inno3d-geforce-rtx3080-ichill-x4-10-gb-enthusiast-grafikkarte',
    },
    {
      brand: 'inno3d',
      model: 'twin x2 oc',
      series: '3080',
      url: 'https://www.computeruniverse.net/de/inno3d-geforce-rtx3080-twin-x2-oc-10-gb-enthusiast-grafikkarte',
    },
    {
      brand: 'kfa2',
      model: 'sg oc',
      series: '3080',
      url: 'https://www.computeruniverse.net/de/kfa-geforce-rtx3080-sg-oc-10-gb-oc-enthusiast-grafikkarte',
    },
    {
      brand: 'msi',
      model: 'gaming x trio',
      series: '3080',
      url: 'https://www.computeruniverse.net/de/msi-geforce-rtx3080-gaming-x-trio-10-gb-enthusiast-grafikkarte',
    },
    {
      brand: 'msi',
      model: 'ventus 3x oc',
      series: '3080',
      url: 'https://www.computeruniverse.net/de/msi-geforce-rtx3080-ventus-3x-oc-10-gb-enthusiast-grafikkarte',
    },
    {
      brand: 'palit',
      model: 'gaming pro',
      series: '3080',
      url: 'https://www.computeruniverse.net/de/palit-geforce-rtx3080-gamingpro-10-gb-enthusiast-grafikkarte',
    },
    {
      brand: 'palit',
      model: 'gaming pro oc',
      series: '3080',
      url: 'https://www.computeruniverse.net/de/palit-geforce-rtx3080-gamingpro-oc-10-gb-oc-enthusiast-grafikkarte',
    },
    {
      brand: 'pny',
      model: 'xlr8 revel',
      series: '3080',
      url: 'https://www.computeruniverse.net/de/pny-geforce-rtx-3080-xlr8-gaming-epic-x-rgb-p-10-gb-enthusiast-grafikkarte',
    },
    {
      brand: 'pny',
      model: 'xlr8 revel',
      series: '3080',
      url: 'https://www.computeruniverse.net/de/pny-geforce-rtx3080-xlr8-gaming-epic-x-rgb-m-10-gb-enthusiast-grafikkarte',
    },
    {
      brand: 'zotac',
      model: 'amp holo',
      series: '3080',
      url: 'https://www.computeruniverse.net/de/zotac-geforce-rtx3080-amp-holo-10-gb-enthusiast-grafikkarte',
    },
    {
      brand: 'zotac',
      model: 'amp extreme holo',
      series: '3080',
      url: 'https://www.computeruniverse.net/de/zotac-geforce-rtx3080-amp-extreme-holo-10-gb-enthusiast-grafikkarte',
    },
    {
      brand: 'zotac',
      model: 'trinity',
      series: '3080',
      url: 'https://www.computeruniverse.net/de/zotac-gaming-geforce-rtx3080-trinity-10-gb-enthusiast-grafikkarte',
    },
    {
      brand: 'zotac',
      model: 'trinity oc',
      series: '3080',
      url: 'https://www.computeruniverse.net/de/zotac-gaming-geforce-rtx3080-trinity-oc-10-gb-enthusiast-grafikkarte',
    },
    {
      brand: 'asus',
      model: 'strix',
      series: '3090',
      url: 'https://www.computeruniverse.net/de/asus-rog-strix-geforce-rtx3090-gaming-24-gb-enthusiast-grafikkarte',
    },
    {
      brand: 'asus',
      model: 'strix oc',
      series: '3090',
      url: 'https://www.computeruniverse.net/de/asus-rog-strix-geforce-rtx3090-gaming-oc-24-gb-oc-enthusiast-grafikkarte',
    },
    {
      brand: 'asus',
      model: 'tuf',
      series: '3090',
      url: 'https://www.computeruniverse.net/de/asus-tuf-geforce-rtx3090-gaming-tuf-rtx3090-24g-gaming-24-gb-enthusiast-grafikkarte',
    },
    {
      brand: 'asus',
      model: 'tuf oc',
      series: '3090',
      url: 'https://www.computeruniverse.net/de/asus-tuf-geforce-rtx3090-gaming-oc-tuf-rtx3090-o24g-gaming-24-gb-oc-enthusiast-grafikkarte',
    },
    {
      brand: 'evga',
      model: 'ftw3',
      series: '3090',
      url: 'https://www.computeruniverse.net/de/evga-geforce-rtx3090-ftw3-gaming-24-gb-enthusiast-grafikkarte',
    },
    {
      brand: 'evga',
      model: 'ftw3 ultra',
      series: '3090',
      url: 'https://www.computeruniverse.net/de/evga-geforce-rtx3090-ftw3-ultra-gaming-24-gb-enthusiast-grafikkarte',
    },
    {
      brand: 'evga',
      model: 'xc3',
      series: '3090',
      url: 'https://www.computeruniverse.net/de/evga-geforce-rtx3090-xc3-gaming-24-gb-enthusiast-grafikkarte',
    },
    {
      brand: 'evga',
      model: 'xc3 black',
      series: '3090',
      url: 'https://www.computeruniverse.net/de/evga-geforce-rtx3090-xc3-black-gaming-24-gb-enthusiast-grafikkarte',
    },
    {
      brand: 'evga',
      model: 'xc3 ultra',
      series: '3090',
      url: 'https://www.computeruniverse.net/de/evga-geforce-rtx3090-xc3-ultra-gaming-24-gb-enthusiast-grafikkarte',
    },
    {
      brand: 'gainward',
      model: 'phoenix',
      series: '3090',
      url: 'https://www.computeruniverse.net/de/gainward-geforce-rtx3090-phoenix-24-gb-enthusiast-grafikkarte',
    },
    {
      brand: 'gainward',
      model: 'phoenix gs oc',
      series: '3090',
      url: 'https://www.computeruniverse.net/de/gainward-geforce-rtx3090-phoenix-gs-24-gb-oc-enthusiast-grafikkarte',
    },
    {
      brand: 'gigabyte',
      model: 'aorus master',
      series: '3090',
      url: 'https://www.computeruniverse.net/de/gigabyte-aorus-geforce-rtx3090-master-24gb',
    },
    {
      brand: 'gigabyte',
      model: 'eagle oc',
      series: '3090',
      url: 'https://www.computeruniverse.net/de/gigabyte-geforce-rtx3090-eagle-oc-24-gb-oc-enthusiast-grafikkarte',
    },
    {
      brand: 'gigabyte',
      model: 'gaming oc',
      series: '3090',
      url: 'https://www.computeruniverse.net/de/gigabyte-geforce-rtx3090-gaming-oc-24-gb-oc',
    },
    {
      brand: 'inno3d',
      model: 'ichill x3',
      series: '3090',
      url: 'https://www.computeruniverse.net/de/inno3d-geforce-rtx3090-ichill-x3-24-gb-enthusiast-grafikkarte',
    },
    {
      brand: 'inno3d',
      model: 'ichill x4',
      series: '3090',
      url: 'https://www.computeruniverse.net/de/inno3d-geforce-rtx3090-ichill-x4-24-gb-enthusiast-grafikkarte',
    },
    {
      brand: 'kfa2',
      model: 'sg oc',
      series: '3090',
      url: 'https://www.computeruniverse.net/de/kfa-geforce-rtx3090-sg-oc-24-gb-oc-enthusiast-grafikkarte',
    },
    {
      brand: 'msi',
      model: 'gaming x trio',
      series: '3090',
      url: 'https://www.computeruniverse.net/de/msi-geforce-rtx3090-gaming-x-trio-24-gb-enthusiast-grafikkarte',
    },
    {
      brand: 'msi',
      model: 'ventus 3x oc',
      series: '3090',
      url: 'https://www.computeruniverse.net/de/msi-geforce-rtx3090-ventus-3x-oc-24-gb-oc-enthusiast-grafikkarte',
    },
    {
      brand: 'palit',
      model: 'gaming pro',
      series: '3090',
      url: 'https://www.computeruniverse.net/de/palit-geforce-rtx3090-gamingpro-24-gb-enthusiast-grafikkarte',
    },
    {
      brand: 'palit',
      model: 'gaming pro oc',
      series: '3090',
      url: 'https://www.computeruniverse.net/de/palit-geforce-rtx3090-gamingpro-oc-24-gb-oc-enthusiast-grafikkarte',
    },
    {
      brand: 'pny',
      model: 'xlr8 revel',
      series: '3090',
      url: 'https://www.computeruniverse.net/de/pny-geforce-rtx3090-xlr8-gaming-epic-x-rgb-m-24-gb-enthusiast-grafikkarte',
    },
    {
      brand: 'pny',
      model: 'xlr8 revel',
      series: '3090',
      url: 'https://www.computeruniverse.net/de/pny-geforce-rtx3090-xlr8-gaming-epic-x-rgb-p-24-gb-enthusiast-grafikkarte',
    },
    {
      brand: 'zotac',
      model: 'trinity',
      series: '3090',
      url: 'https://www.computeruniverse.net/de/zotac-gaming-geforce-rtx-3090-trinity-24-gb-enthusiast-grafikkarte',
    },
    {
      brand: 'asrock',
      model: 'challenger oc',
      series: 'rx6700xt',
      url: 'https://www.computeruniverse.net/de/p/90829010',
    },
    {
      brand: 'asrock',
      model: 'challenger pro oc',
      series: 'rx6700xt',
      url: 'https://www.computeruniverse.net/de/p/90829011',
    },
    {
      brand: 'asus',
      model: 'tuf oc',
      series: 'rx6700xt',
      url: 'https://www.computeruniverse.net/de/p/90828759',
    },
    {
      brand: 'gigabyte',
      model: 'aorus elite',
      series: 'rx6700xt',
      url: 'https://www.computeruniverse.net/de/p/90829454',
    },
    {
      brand: 'xfx',
      model: 'swft',
      series: 'rx6700xt',
      url: 'https://www.computeruniverse.net/de/p/90829019',
    },
    {
      brand: 'amd',
      model: '5600x',
      series: 'ryzen5600',
      url: 'https://www.computeruniverse.net/de/amd-ryzen-5-5600x-boxed-mit-wraith-stealth-kuehler',
    },
    {
      brand: 'amd',
      model: '5800x',
      series: 'ryzen5800',
      url: 'https://www.computeruniverse.net/de/amd-ryzen-7-5800x-box-ohne-kuehler',
    },
    {
      brand: 'amd',
      model: '5900x',
      series: 'ryzen5900',
      url: 'https://www.computeruniverse.net/de/amd-ryzen-9-5900x-box-ohne-kuehler',
    },
    {
      brand: 'amd',
      model: '5950x',
      series: 'ryzen5950',
      url: 'https://www.computeruniverse.net/de/amd-ryzen-9-5950x-box-ohne-kuehler',
    },
    {
      brand: 'sony',
      model: 'ps5 console',
      series: 'sonyps5c',
      url: 'https://www.computeruniverse.net/de/sony-playstation-5-weiss-schwarz-825gb-ssd',
    },
    {
      brand: 'sony',
      model: 'ps5 digital',
      series: 'sonyps5de',
      url: 'https://www.computeruniverse.net/de/sony-playstation-5-digital-edition-weiss-schwarz-825gb-ssd',
    },
  ],
  name: 'computeruniverse',
};
