import {Store} from './store';

export const Azerty: Store = {
  currency: '€',
  labels: {
    inStock: {
      container: '.orderdelay',
      text: ['Volgende werkdag in huis', '1 werkdag', '2-3 werkdagen'],
    },
    maxPrice: {
      container: '.mod_article .price',
      euroFormat: true,
    },
    outOfStock: {
      container: '.orderdelay',
      text: ['Onbekend', 'meer dan 10 werkdagen', 'Pre-order'],
    },
  },
  links: [
    {
      brand: 'test:brand',
      model: 'test:model',
      series: 'test:series',
      url: 'https://azerty.nl/product/gigabyte/3756757/geforce-rtx-2060-oc-6g-grafische-kaart-geforce-rtx-2060',
    },
    {
      brand: 'gigabyte',
      model: 'aorus xtreme',
      series: '3080',
      url: 'https://azerty.nl/product/gigabyte/4349658/aorus-geforce-rtx-3080-xtreme-10g-grafische-kaart-gf-rtx-3080',
    },
    {
      brand: 'msi',
      model: 'ventus 3x oc',
      series: '3080',
      url: 'https://azerty.nl/product/msi/4346262/geforce-rtx-3080-ventus-3x-10g-oc-grafische-kaart-rtx-3080',
    },
    {
      brand: 'asus',
      model: 'tuf',
      series: '3080',
      url: 'https://azerty.nl/product/asus/4346679/tuf-gaming-geforce-rtx-3080-grafische-kaart-gf-rtx-3080',
    },
    {
      brand: 'msi',
      model: 'gaming x trio',
      series: '3080',
      url: 'https://azerty.nl/product/msi/4346263/geforce-rtx-3080-gaming-x-trio-10g-grafische-kaart-rtx-3080',
    },
    {
      brand: 'asus',
      model: 'tuf oc',
      series: '3080',
      url: 'https://azerty.nl/product/asus/4348176/tuf-gaming-geforce-rtx-3080-oc-grafische-kaart-gf-rtx-3080',
    },
    {
      brand: 'asus',
      model: 'strix oc',
      series: '3080',
      url: 'https://azerty.nl/product/asus/4348174/rog-strix-geforce-rtx-3080-oc-grafische-kaart-gf-rtx-3080',
    },
    {
      brand: 'zotac',
      model: 'trinity',
      series: '3080',
      url: 'https://azerty.nl/product/zotac/4352301/gaming-geforce-rtx-3080-trinity-oc-grafische-kaart-gf-rtx-3080',
    },
    {
      brand: 'gigabyte',
      model: 'aorus master',
      series: '3080',
      url: 'https://azerty.nl/product/gigabyte/4349651/aorus-geforce-rtx-3080-master-10g-grafische-kaart-gf-rtx-3080',
    },
    {
      brand: 'pny',
      model: 'xlr8 revel',
      series: '3080',
      url: 'https://azerty.nl/product/pny/4342269/geforce-rtx-3080-xlr8-gaming-revel-epic-x-rgb-triple-fan-gaming-edition-grafische-kaart-gf-rtx-3080',
    },
    {
      brand: 'asus',
      model: 'strix oc',
      series: '3070',
      url: 'https://azerty.nl/product/asus/4363892/rog-strix-gaming-geforce-rtx-3070-o8g-videokaart-8-gb-gddr6',
    },
    {
      brand: 'asus',
      model: 'strix',
      series: '3070',
      url: 'https://azerty.nl/product/asus/4373096/rog-strix-gaming-geforce-rtx-3070-8g-videokaart-8-gb-gddr6',
    },
    {
      brand: 'asus',
      model: 'tuf oc',
      series: '3070',
      url: 'https://azerty.nl/product/asus/4363910/tuf-gaming-geforce-rtx-3070-oc-videokaart-8-gb-gddr6',
    },
    {
      brand: 'asus',
      model: 'tuf',
      series: '3070',
      url: 'https://azerty.nl/product/asus/4373099/tuf-gaming-geforce-rtx-3070-videokaart-8-gb-gddr6',
    },
    {
      brand: 'inno3d',
      model: 'ichill x4',
      series: '3070',
      url: 'https://azerty.nl/product/inno3d/4369725/geforce-rtx-3070-ichill-x4-videokaart-8-gb-ddr6',
    },
    {
      brand: 'inno3d',
      model: 'ichill x3',
      series: '3070',
      url: 'https://azerty.nl/product/inno3d/4369726/geforce-rtx-3070-ichill-x3-videokaart-8-gb-ddr6',
    },
    {
      brand: 'msi',
      model: 'ventus 3x oc',
      series: '3070',
      url: 'https://azerty.nl/product/msi/4374747/geforce-rtx-3070-ventus-3x-oc-videokaart-8-gb-gddr6',
    },
    {
      brand: 'msi',
      model: 'gaming x trio',
      series: '3070',
      url: 'https://azerty.nl/product/msi/4365398/geforce-rtx-3070-gaming-x-trio-videokaart-8-gb-gddr6',
    },
    {
      brand: 'pny',
      model: 'dual fan',
      series: '3070',
      url: 'https://azerty.nl/product/pny/4342270/uprising-dual-fan-geforce-rtx-3070',
    },
    {
      brand: 'pny',
      model: 'xlr8 revel',
      series: '3070',
      url: 'https://azerty.nl/product/pny/4342271/epic-x-rgb-geforce-rtx-3070-triple-fan-gaming-edition-xlr8--videokaart-8-gb-gddr6x',
    },
    {
      brand: 'evga',
      model: 'ftw3',
      series: '3070',
      url: 'https://azerty.nl/product/evga/4377247/geforce-rtx-3070-ftw3-videokaart-8-gb-gddr6',
    },
    {
      brand: 'evga',
      model: 'xc3',
      series: '3070',
      url: 'https://azerty.nl/product/evga/4377248/xc3-geforce-rtx-3070-xc3-videokaart-8-gb-gddr6',
    },
    {
      brand: 'evga',
      model: 'ftw3 ultra',
      series: '3070',
      url: 'https://azerty.nl/product/evga/4377250/ftw3-ultra-geforce-rtx-3070-videokaart-8-gb-gddr6',
    },
    {
      brand: 'evga',
      model: 'xc3 black',
      series: '3070',
      url: 'https://azerty.nl/product/evga/4377252/xc3-black-geforce-rtx-3070-videokaart-8-gb-gddr6',
    },
    {
      brand: 'amd',
      model: '5600x',
      series: 'ryzen5600',
      url: 'https://azerty.nl/product/amd/4368019/ryzen-5-5600x-processor-3-7-ghz-4-6-ghz-',
    },
    {
      brand: 'amd',
      model: '5800x',
      series: 'ryzen5800',
      url: 'https://azerty.nl/product/amd/4368018/ryzen-7-5800x-processor-3-8-ghz-4-7-ghz-',
    },
    {
      brand: 'amd',
      model: '5900x',
      series: 'ryzen5900',
      url: 'https://azerty.nl/product/amd/4368017/ryzen-9-5900x-processor-3-7-ghz-4-8-ghz-',
    },
    {
      brand: 'amd',
      model: '5950x',
      series: 'ryzen5950',
      url: 'https://azerty.nl/product/amd/4368016/ryzen-9-5950x-processor-3-4-ghz-4-9-ghz-',
    },
  ],
  name: 'azerty',
};
