import {Store} from './store';

export const AlternateNL: Store = {
  currency: '€',
  labels: {
    inStock: {
      container: '.stockStatus',
      text: ['Direct leverbaar'],
    },
    maxPrice: {
      container: 'div.price > span',
      euroFormat: true,
    },
    outOfStock: {
      container: '.stockStatus',
      text: ['Levertermijn onbekend', 'pre-order'],
    },
  },
  links: [
    {
      brand: 'test:brand',
      model: 'test:model',
      series: 'test:series',
      url: 'https://www.alternate.nl/product/1516616',
    },
    {
      brand: 'gigabyte',
      model: 'eagle oc',
      series: '3080',
      url: 'https://www.alternate.nl/product/1672756',
    },
    {
      brand: 'msi',
      model: 'ventus 3x oc',
      series: '3080',
      url: 'https://www.alternate.nl/product/1672345',
    },
    {
      brand: 'asus',
      model: 'tuf',
      series: '3080',
      url: 'https://www.alternate.nl/product/1672251',
    },
    {
      brand: 'gigabyte',
      model: 'gaming oc',
      series: '3080',
      url: 'https://www.alternate.nl/product/1672753',
    },
    {
      brand: 'msi',
      model: 'gaming x trio',
      series: '3080',
      url: 'https://www.alternate.nl/product/1672343',
    },
    {
      brand: 'asus',
      model: 'tuf oc',
      series: '3080',
      url: 'https://www.alternate.nl/product/1672634',
    },
    {
      brand: 'asus',
      model: 'strix oc',
      series: '3080',
      url: 'https://www.alternate.nl/product/1672867',
    },
    {
      brand: 'evga',
      model: 'xc3 black',
      series: '3080',
      url: 'https://www.alternate.nl/product/1673512',
    },
    {
      brand: 'zotac',
      model: 'trinity',
      series: '3080',
      url: 'https://www.alternate.nl/product/1672612',
    },
    {
      brand: 'evga',
      model: 'xc3 ultra',
      series: '3080',
      url: 'https://www.alternate.nl/product/1674164',
    },
    {
      brand: 'asus',
      model: 'strix',
      series: '3080',
      url: 'https://www.alternate.nl/product/1672868',
    },
    {
      brand: 'palit',
      model: 'gaming pro oc',
      series: '3080',
      url: 'https://www.alternate.nl/product/1673431',
    },
    {
      brand: 'zotac',
      model: 'trinity oc',
      series: '3080',
      url: 'https://www.alternate.nl/product/1677989',
    },
    {
      brand: 'gigabyte',
      model: 'vision oc',
      series: '3080',
      url: 'https://www.alternate.nl/product/1681134',
    },
    {
      brand: 'evga',
      model: 'xc3',
      series: '3080',
      url: 'https://www.alternate.nl/product/1673520',
    },
    {
      brand: 'gainward',
      model: 'phoenix gs',
      series: '3080',
      url: 'https://www.alternate.nl/product/1673442',
    },
    {
      brand: 'inno3d',
      model: 'ichill x3',
      series: '3080',
      url: 'https://www.alternate.nl/product/1673136',
    },
    {
      brand: 'evga',
      model: 'ftw3 ultra',
      series: '3080',
      url: 'https://www.alternate.nl/product/1673524',
    },
    {
      brand: 'gigabyte',
      model: 'aorus master',
      series: '3080',
      url: 'https://www.alternate.nl/product/1680168',
    },
    {
      brand: 'evga',
      model: 'ftw3',
      series: '3080',
      url: 'https://www.alternate.nl/product/1673517',
    },
    {
      brand: 'zotac',
      model: 'amp holo',
      series: '3080',
      url: 'https://www.alternate.nl/product/1677985',
    },
    {
      brand: 'zotac',
      model: 'amp extreme holo',
      series: '3080',
      url: 'https://www.alternate.nl/product/1677982',
    },
    {
      brand: 'inno3d',
      model: 'twin x2 oc',
      series: '3080',
      url: 'https://www.alternate.nl/product/1673137',
    },
    {
      brand: 'inno3d',
      model: 'ichill x4',
      series: '3080',
      url: 'https://www.alternate.nl/product/1673134',
    },
  ],
  name: 'alternate-nl',
};
