/*
 Navicat Premium Data Transfer

 Source Server         : localhost
 Source Server Type    : SQL Server
 Source Server Version : 14001000
 Source Host           : localhost:1433
 Source Catalog        : thymelte
 Source Schema         : dbo

 Target Server Type    : SQL Server
 Target Server Version : 14001000
 File Encoding         : 65001

 Date: 05/08/2019 16:16:03
*/


-- ----------------------------
-- Table structure for logging_event
-- ----------------------------
IF EXISTS (SELECT * FROM sys.all_objects WHERE object_id = OBJECT_ID(N'[dbo].[logging_event]') AND type IN ('U'))
	DROP TABLE [dbo].[logging_event]
GO

CREATE TABLE [dbo].[logging_event] (
  [timestmp] bigint  NOT NULL,
  [formatted_message] nvarchar(max) COLLATE Chinese_PRC_CI_AS  NOT NULL,
  [logger_name] nvarchar(254) COLLATE Chinese_PRC_CI_AS  NOT NULL,
  [level_string] nvarchar(254) COLLATE Chinese_PRC_CI_AS  NOT NULL,
  [thread_name] nvarchar(254) COLLATE Chinese_PRC_CI_AS  NULL,
  [reference_flag] smallint  NULL,
  [arg0] nvarchar(254) COLLATE Chinese_PRC_CI_AS  NULL,
  [arg1] nvarchar(254) COLLATE Chinese_PRC_CI_AS  NULL,
  [arg2] nvarchar(254) COLLATE Chinese_PRC_CI_AS  NULL,
  [arg3] nvarchar(254) COLLATE Chinese_PRC_CI_AS  NULL,
  [caller_filename] nvarchar(254) COLLATE Chinese_PRC_CI_AS  NOT NULL,
  [caller_class] nvarchar(254) COLLATE Chinese_PRC_CI_AS  NOT NULL,
  [caller_method] nvarchar(254) COLLATE Chinese_PRC_CI_AS  NOT NULL,
  [caller_line] nchar(4) COLLATE Chinese_PRC_CI_AS  NOT NULL,
  [event_id] bigint  NOT NULL
)
GO

ALTER TABLE [dbo].[logging_event] SET (LOCK_ESCALATION = TABLE)
GO


-- ----------------------------
-- Table structure for logging_event_exception
-- ----------------------------
IF EXISTS (SELECT * FROM sys.all_objects WHERE object_id = OBJECT_ID(N'[dbo].[logging_event_exception]') AND type IN ('U'))
	DROP TABLE [dbo].[logging_event_exception]
GO

CREATE TABLE [dbo].[logging_event_exception] (
  [event_id] bigint  NOT NULL,
  [i] smallint  NOT NULL,
  [trace_line] nvarchar(254) COLLATE Chinese_PRC_CI_AS  NOT NULL
)
GO

ALTER TABLE [dbo].[logging_event_exception] SET (LOCK_ESCALATION = TABLE)
GO


-- ----------------------------
-- Table structure for logging_event_property
-- ----------------------------
IF EXISTS (SELECT * FROM sys.all_objects WHERE object_id = OBJECT_ID(N'[dbo].[logging_event_property]') AND type IN ('U'))
	DROP TABLE [dbo].[logging_event_property]
GO

CREATE TABLE [dbo].[logging_event_property] (
  [event_id] bigint  NOT NULL,
  [mapped_key] nvarchar(36) COLLATE Chinese_PRC_CI_AS  NOT NULL,
  [mapped_value] nvarchar(max) COLLATE Chinese_PRC_CI_AS  NULL
)
GO

ALTER TABLE [dbo].[logging_event_property] SET (LOCK_ESCALATION = TABLE)
GO


-- ----------------------------
-- Table structure for oauth_access_token
-- ----------------------------
IF EXISTS (SELECT * FROM sys.all_objects WHERE object_id = OBJECT_ID(N'[dbo].[oauth_access_token]') AND type IN ('U'))
	DROP TABLE [dbo].[oauth_access_token]
GO

CREATE TABLE [dbo].[oauth_access_token] (
  [token_id] nvarchar(36) COLLATE Chinese_PRC_CI_AS  NULL,
  [token] varbinary(max)  NULL,
  [authentication_id] nvarchar(36) COLLATE Chinese_PRC_CI_AS  NULL,
  [user_name] nvarchar(255) COLLATE Chinese_PRC_CI_AS  NULL,
  [client_id] nvarchar(36) COLLATE Chinese_PRC_CI_AS  NULL,
  [authentication] varbinary(max)  NULL,
  [refresh_token] nvarchar(255) COLLATE Chinese_PRC_CI_AS  NULL
)
GO

ALTER TABLE [dbo].[oauth_access_token] SET (LOCK_ESCALATION = TABLE)
GO


-- ----------------------------
-- Table structure for oauth_client_details
-- ----------------------------
IF EXISTS (SELECT * FROM sys.all_objects WHERE object_id = OBJECT_ID(N'[dbo].[oauth_client_details]') AND type IN ('U'))
	DROP TABLE [dbo].[oauth_client_details]
GO

CREATE TABLE [dbo].[oauth_client_details] (
  [client_id] nvarchar(36) COLLATE Chinese_PRC_CI_AS  NOT NULL,
  [resource_ids] nvarchar(255) COLLATE Chinese_PRC_CI_AS  NULL,
  [client_secret] nvarchar(255) COLLATE Chinese_PRC_CI_AS  NULL,
  [scope] nvarchar(255) COLLATE Chinese_PRC_CI_AS  NULL,
  [authorized_grant_types] nvarchar(255) COLLATE Chinese_PRC_CI_AS  NULL,
  [web_server_redirect_uri] nvarchar(255) COLLATE Chinese_PRC_CI_AS  NULL,
  [authorities] nvarchar(255) COLLATE Chinese_PRC_CI_AS  NULL,
  [access_token_validity] int  NULL,
  [refresh_token_validity] int  NULL,
  [additional_information] nvarchar(max) COLLATE Chinese_PRC_CI_AS  NULL,
  [autoapprove] nvarchar(255) COLLATE Chinese_PRC_CI_AS  NULL
)
GO

ALTER TABLE [dbo].[oauth_client_details] SET (LOCK_ESCALATION = TABLE)
GO


-- ----------------------------
-- Table structure for oauth_client_token
-- ----------------------------
IF EXISTS (SELECT * FROM sys.all_objects WHERE object_id = OBJECT_ID(N'[dbo].[oauth_client_token]') AND type IN ('U'))
	DROP TABLE [dbo].[oauth_client_token]
GO

CREATE TABLE [dbo].[oauth_client_token] (
  [token_id] nvarchar(36) COLLATE Chinese_PRC_CI_AS  NULL,
  [token] varbinary(max)  NULL,
  [authentication_id] nvarchar(36) COLLATE Chinese_PRC_CI_AS  NULL,
  [user_name] nvarchar(255) COLLATE Chinese_PRC_CI_AS  NULL,
  [client_id] nvarchar(36) COLLATE Chinese_PRC_CI_AS  NULL
)
GO

ALTER TABLE [dbo].[oauth_client_token] SET (LOCK_ESCALATION = TABLE)
GO


-- ----------------------------
-- Table structure for oauth_code
-- ----------------------------
IF EXISTS (SELECT * FROM sys.all_objects WHERE object_id = OBJECT_ID(N'[dbo].[oauth_code]') AND type IN ('U'))
	DROP TABLE [dbo].[oauth_code]
GO

CREATE TABLE [dbo].[oauth_code] (
  [code] nvarchar(255) COLLATE Chinese_PRC_CI_AS  NULL,
  [authentication] varbinary(max)  NULL
)
GO

ALTER TABLE [dbo].[oauth_code] SET (LOCK_ESCALATION = TABLE)
GO


-- ----------------------------
-- Table structure for oauth_refresh_token
-- ----------------------------
IF EXISTS (SELECT * FROM sys.all_objects WHERE object_id = OBJECT_ID(N'[dbo].[oauth_refresh_token]') AND type IN ('U'))
	DROP TABLE [dbo].[oauth_refresh_token]
GO

CREATE TABLE [dbo].[oauth_refresh_token] (
  [token_id] nvarchar(36) COLLATE Chinese_PRC_CI_AS  NULL,
  [token] varbinary(max)  NULL,
  [authentication] varbinary(max)  NULL
)
GO

ALTER TABLE [dbo].[oauth_refresh_token] SET (LOCK_ESCALATION = TABLE)
GO


-- ----------------------------
-- Table structure for t_account_bind
-- ----------------------------
IF EXISTS (SELECT * FROM sys.all_objects WHERE object_id = OBJECT_ID(N'[dbo].[t_account_bind]') AND type IN ('U'))
	DROP TABLE [dbo].[t_account_bind]
GO

CREATE TABLE [dbo].[t_account_bind] (
  [id] bigint  NOT NULL,
  [create_by] bigint  NULL,
  [create_date] datetime2(0)  NULL,
  [update_by] bigint  NULL,
  [update_date] datetime2(0)  NULL,
  [user_id] bigint  NULL,
  [account_type] int  NULL,
  [account_no] nvarchar(50) COLLATE Chinese_PRC_CI_AS  NULL,
  [password] nvarchar(50) COLLATE Chinese_PRC_CI_AS  NULL,
  [secret_key] nvarchar(50) COLLATE Chinese_PRC_CI_AS  NULL,
  [is_bind] tinyint  NULL,
  [overdue_time] datetime2(0)  NULL,
  [status] nvarchar(32) COLLATE Chinese_PRC_CI_AS  NULL
)
GO

ALTER TABLE [dbo].[t_account_bind] SET (LOCK_ESCALATION = TABLE)
GO

EXEC sp_addextendedproperty
'MS_Description', N'id',
'SCHEMA', N'dbo',
'TABLE', N't_account_bind',
'COLUMN', N'id'
GO

EXEC sp_addextendedproperty
'MS_Description', N'创建人id',
'SCHEMA', N'dbo',
'TABLE', N't_account_bind',
'COLUMN', N'create_by'
GO

EXEC sp_addextendedproperty
'MS_Description', N'创建时间',
'SCHEMA', N'dbo',
'TABLE', N't_account_bind',
'COLUMN', N'create_date'
GO

EXEC sp_addextendedproperty
'MS_Description', N'更新人id',
'SCHEMA', N'dbo',
'TABLE', N't_account_bind',
'COLUMN', N'update_by'
GO

EXEC sp_addextendedproperty
'MS_Description', N'更新时间',
'SCHEMA', N'dbo',
'TABLE', N't_account_bind',
'COLUMN', N'update_date'
GO

EXEC sp_addextendedproperty
'MS_Description', N'用户id',
'SCHEMA', N'dbo',
'TABLE', N't_account_bind',
'COLUMN', N'user_id'
GO

EXEC sp_addextendedproperty
'MS_Description', N'账号类型',
'SCHEMA', N'dbo',
'TABLE', N't_account_bind',
'COLUMN', N'account_type'
GO

EXEC sp_addextendedproperty
'MS_Description', N'账号',
'SCHEMA', N'dbo',
'TABLE', N't_account_bind',
'COLUMN', N'account_no'
GO

EXEC sp_addextendedproperty
'MS_Description', N'密码',
'SCHEMA', N'dbo',
'TABLE', N't_account_bind',
'COLUMN', N'password'
GO

EXEC sp_addextendedproperty
'MS_Description', N'绑定密钥',
'SCHEMA', N'dbo',
'TABLE', N't_account_bind',
'COLUMN', N'secret_key'
GO

EXEC sp_addextendedproperty
'MS_Description', N'是否绑定',
'SCHEMA', N'dbo',
'TABLE', N't_account_bind',
'COLUMN', N'is_bind'
GO

EXEC sp_addextendedproperty
'MS_Description', N'绑定过期时间',
'SCHEMA', N'dbo',
'TABLE', N't_account_bind',
'COLUMN', N'overdue_time'
GO

EXEC sp_addextendedproperty
'MS_Description', N'状态',
'SCHEMA', N'dbo',
'TABLE', N't_account_bind',
'COLUMN', N'status'
GO

EXEC sp_addextendedproperty
'MS_Description', N'账号绑定',
'SCHEMA', N'dbo',
'TABLE', N't_account_bind'
GO


-- ----------------------------
-- Table structure for t_authorities
-- ----------------------------
IF EXISTS (SELECT * FROM sys.all_objects WHERE object_id = OBJECT_ID(N'[dbo].[t_authorities]') AND type IN ('U'))
	DROP TABLE [dbo].[t_authorities]
GO

CREATE TABLE [dbo].[t_authorities] (
  [id] bigint  NOT NULL,
  [create_by] bigint  NULL,
  [create_date] datetime2(0)  NULL,
  [update_by] bigint  NULL,
  [update_date] datetime2(0)  NULL,
  [user_id] bigint  NOT NULL,
  [authority] nvarchar(50) COLLATE Chinese_PRC_CI_AS  NOT NULL
)
GO

ALTER TABLE [dbo].[t_authorities] SET (LOCK_ESCALATION = TABLE)
GO

EXEC sp_addextendedproperty
'MS_Description', N'id',
'SCHEMA', N'dbo',
'TABLE', N't_authorities',
'COLUMN', N'id'
GO

EXEC sp_addextendedproperty
'MS_Description', N'创建人id',
'SCHEMA', N'dbo',
'TABLE', N't_authorities',
'COLUMN', N'create_by'
GO

EXEC sp_addextendedproperty
'MS_Description', N'创建时间',
'SCHEMA', N'dbo',
'TABLE', N't_authorities',
'COLUMN', N'create_date'
GO

EXEC sp_addextendedproperty
'MS_Description', N'更新人id',
'SCHEMA', N'dbo',
'TABLE', N't_authorities',
'COLUMN', N'update_by'
GO

EXEC sp_addextendedproperty
'MS_Description', N'更新时间',
'SCHEMA', N'dbo',
'TABLE', N't_authorities',
'COLUMN', N'update_date'
GO

EXEC sp_addextendedproperty
'MS_Description', N'用户id',
'SCHEMA', N'dbo',
'TABLE', N't_authorities',
'COLUMN', N'user_id'
GO

EXEC sp_addextendedproperty
'MS_Description', N'权限',
'SCHEMA', N'dbo',
'TABLE', N't_authorities',
'COLUMN', N'authority'
GO

EXEC sp_addextendedproperty
'MS_Description', N'权限表',
'SCHEMA', N'dbo',
'TABLE', N't_authorities'
GO


-- ----------------------------
-- Records of t_authorities
-- ----------------------------
INSERT INTO [dbo].[t_authorities] VALUES (N'1', NULL, NULL, NULL, NULL, N'1000000000', N'ROLE_ADMIN')
GO

INSERT INTO [dbo].[t_authorities] VALUES (N'2', NULL, NULL, NULL, NULL, N'1000000000', N'ROLE_SU')
GO

INSERT INTO [dbo].[t_authorities] VALUES (N'5', NULL, NULL, NULL, NULL, N'1000000000', N'ROLE_USER')
GO

INSERT INTO [dbo].[t_authorities] VALUES (N'152236789137018880', NULL, NULL, NULL, NULL, N'1000000005', N'ROLE_USER')
GO

INSERT INTO [dbo].[t_authorities] VALUES (N'153212753320869888', NULL, N'2019-04-26 17:05:45', NULL, NULL, N'1000000005', N'ROLE_ADMIN')
GO

INSERT INTO [dbo].[t_authorities] VALUES (N'153212753320869889', NULL, N'2019-04-26 17:05:45', NULL, NULL, N'1000000005', N'ROLE_SU')
GO

INSERT INTO [dbo].[t_authorities] VALUES (N'153213727645106186', NULL, NULL, NULL, NULL, N'1000000019', N'ROLE_USER')
GO

INSERT INTO [dbo].[t_authorities] VALUES (N'153213727645106187', NULL, NULL, NULL, NULL, N'1000000001', N'ROLE_USER')
GO


-- ----------------------------
-- Table structure for t_bill
-- ----------------------------
IF EXISTS (SELECT * FROM sys.all_objects WHERE object_id = OBJECT_ID(N'[dbo].[t_bill]') AND type IN ('U'))
	DROP TABLE [dbo].[t_bill]
GO

CREATE TABLE [dbo].[t_bill] (
  [id] bigint  NOT NULL,
  [create_by] bigint  NULL,
  [create_date] datetime2(0)  NULL,
  [update_by] bigint  NULL,
  [update_date] datetime2(0)  NULL,
  [bill_type] nvarchar(50) COLLATE Chinese_PRC_CI_AS  NULL,
  [bill_status] nvarchar(50) COLLATE Chinese_PRC_CI_AS  NULL,
  [bill_desc] nvarchar(100) COLLATE Chinese_PRC_CI_AS  NULL,
  [receiving_address] nvarchar(100) COLLATE Chinese_PRC_CI_AS  NULL,
  [logistics_info] nvarchar(50) COLLATE Chinese_PRC_CI_AS  NULL,
  [logistics_no] nvarchar(50) COLLATE Chinese_PRC_CI_AS  NULL,
  [logistics_status] nvarchar(50) COLLATE Chinese_PRC_CI_AS  NULL,
  [bill_date] datetime2(0)  NULL,
  [total_amount] float(53)  NULL,
  [quantity] int  NULL,
  [out_trade_no] nvarchar(50) COLLATE Chinese_PRC_CI_AS  NULL,
  [to_member_name] nvarchar(50) COLLATE Chinese_PRC_CI_AS  NULL,
  [to_member_id] nvarchar(50) COLLATE Chinese_PRC_CI_AS  NULL,
  [payment_type] nvarchar(50) COLLATE Chinese_PRC_CI_AS  NULL,
  [payment_account_no] nvarchar(50) COLLATE Chinese_PRC_CI_AS  NULL,
  [reason] nvarchar(255) COLLATE Chinese_PRC_CI_AS  NULL,
  [integral_reward] int  NULL,
  [remark] nvarchar(255) COLLATE Chinese_PRC_CI_AS  NULL,
  [bill_context] nvarchar(255) COLLATE Chinese_PRC_CI_AS  NULL,
  [user_id] bigint  NULL
)
GO

ALTER TABLE [dbo].[t_bill] SET (LOCK_ESCALATION = TABLE)
GO

EXEC sp_addextendedproperty
'MS_Description', N'id',
'SCHEMA', N'dbo',
'TABLE', N't_bill',
'COLUMN', N'id'
GO

EXEC sp_addextendedproperty
'MS_Description', N'创建人id',
'SCHEMA', N'dbo',
'TABLE', N't_bill',
'COLUMN', N'create_by'
GO

EXEC sp_addextendedproperty
'MS_Description', N'创建时间',
'SCHEMA', N'dbo',
'TABLE', N't_bill',
'COLUMN', N'create_date'
GO

EXEC sp_addextendedproperty
'MS_Description', N'更新人id',
'SCHEMA', N'dbo',
'TABLE', N't_bill',
'COLUMN', N'update_by'
GO

EXEC sp_addextendedproperty
'MS_Description', N'更新时间',
'SCHEMA', N'dbo',
'TABLE', N't_bill',
'COLUMN', N'update_date'
GO

EXEC sp_addextendedproperty
'MS_Description', N'账单分类',
'SCHEMA', N'dbo',
'TABLE', N't_bill',
'COLUMN', N'bill_type'
GO

EXEC sp_addextendedproperty
'MS_Description', N'账单状态',
'SCHEMA', N'dbo',
'TABLE', N't_bill',
'COLUMN', N'bill_status'
GO

EXEC sp_addextendedproperty
'MS_Description', N'账单描述',
'SCHEMA', N'dbo',
'TABLE', N't_bill',
'COLUMN', N'bill_desc'
GO

EXEC sp_addextendedproperty
'MS_Description', N'收货地址',
'SCHEMA', N'dbo',
'TABLE', N't_bill',
'COLUMN', N'receiving_address'
GO

EXEC sp_addextendedproperty
'MS_Description', N'物流信息',
'SCHEMA', N'dbo',
'TABLE', N't_bill',
'COLUMN', N'logistics_info'
GO

EXEC sp_addextendedproperty
'MS_Description', N'物流号',
'SCHEMA', N'dbo',
'TABLE', N't_bill',
'COLUMN', N'logistics_no'
GO

EXEC sp_addextendedproperty
'MS_Description', N'物流状况',
'SCHEMA', N'dbo',
'TABLE', N't_bill',
'COLUMN', N'logistics_status'
GO

EXEC sp_addextendedproperty
'MS_Description', N'账单日期',
'SCHEMA', N'dbo',
'TABLE', N't_bill',
'COLUMN', N'bill_date'
GO

EXEC sp_addextendedproperty
'MS_Description', N'付款金额',
'SCHEMA', N'dbo',
'TABLE', N't_bill',
'COLUMN', N'total_amount'
GO

EXEC sp_addextendedproperty
'MS_Description', N'数量',
'SCHEMA', N'dbo',
'TABLE', N't_bill',
'COLUMN', N'quantity'
GO

EXEC sp_addextendedproperty
'MS_Description', N'商户订单号',
'SCHEMA', N'dbo',
'TABLE', N't_bill',
'COLUMN', N'out_trade_no'
GO

EXEC sp_addextendedproperty
'MS_Description', N'对方账号名称',
'SCHEMA', N'dbo',
'TABLE', N't_bill',
'COLUMN', N'to_member_name'
GO

EXEC sp_addextendedproperty
'MS_Description', N'对方账号',
'SCHEMA', N'dbo',
'TABLE', N't_bill',
'COLUMN', N'to_member_id'
GO

EXEC sp_addextendedproperty
'MS_Description', N'付款方式',
'SCHEMA', N'dbo',
'TABLE', N't_bill',
'COLUMN', N'payment_type'
GO

EXEC sp_addextendedproperty
'MS_Description', N'付款账号',
'SCHEMA', N'dbo',
'TABLE', N't_bill',
'COLUMN', N'payment_account_no'
GO

EXEC sp_addextendedproperty
'MS_Description', N'理由',
'SCHEMA', N'dbo',
'TABLE', N't_bill',
'COLUMN', N'reason'
GO

EXEC sp_addextendedproperty
'MS_Description', N'积分奖励',
'SCHEMA', N'dbo',
'TABLE', N't_bill',
'COLUMN', N'integral_reward'
GO

EXEC sp_addextendedproperty
'MS_Description', N'备注',
'SCHEMA', N'dbo',
'TABLE', N't_bill',
'COLUMN', N'remark'
GO

EXEC sp_addextendedproperty
'MS_Description', N'订单内容',
'SCHEMA', N'dbo',
'TABLE', N't_bill',
'COLUMN', N'bill_context'
GO

EXEC sp_addextendedproperty
'MS_Description', N'用户id',
'SCHEMA', N'dbo',
'TABLE', N't_bill',
'COLUMN', N'user_id'
GO

EXEC sp_addextendedproperty
'MS_Description', N'订单',
'SCHEMA', N'dbo',
'TABLE', N't_bill'
GO


-- ----------------------------
-- Records of t_bill
-- ----------------------------
INSERT INTO [dbo].[t_bill] VALUES (N'96425796905865216', NULL, N'2018-11-23 14:58:30', NULL, NULL, NULL, N'1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, N'1')
GO

INSERT INTO [dbo].[t_bill] VALUES (N'96426847977476096', NULL, N'2018-11-23 14:58:34', NULL, NULL, N'1', N'1', N'app下单测试', NULL, NULL, NULL, NULL, NULL, N'0.01', N'1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, N'订单内容', N'2')
GO

INSERT INTO [dbo].[t_bill] VALUES (N'96427201976733696', NULL, NULL, NULL, NULL, N'1', N'1', N'app下单测试', NULL, NULL, NULL, NULL, NULL, N'0.01', N'1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, N'订单内容', N'3')
GO

INSERT INTO [dbo].[t_bill] VALUES (N'96427228090470400', NULL, NULL, NULL, NULL, N'1', N'1', N'web下单测试', NULL, NULL, NULL, NULL, NULL, N'0.01', N'1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, N'订单内容', N'88603625256910848')
GO

INSERT INTO [dbo].[t_bill] VALUES (N'96429136997912576', NULL, NULL, NULL, NULL, N'1', N'1', N'web下单测试', NULL, NULL, NULL, NULL, NULL, N'1', N'1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, N'订单内容', N'88612918546923520')
GO

INSERT INTO [dbo].[t_bill] VALUES (N'96430026467184640', NULL, NULL, NULL, NULL, N'1', N'1', N'web下单测试', NULL, NULL, NULL, NULL, NULL, N'1', N'1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, N'订单内容', N'88612918546923520')
GO

INSERT INTO [dbo].[t_bill] VALUES (N'96430832113291264', NULL, NULL, NULL, NULL, N'1', N'1', N'web下单测试', NULL, NULL, NULL, NULL, NULL, N'1', N'1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, N'订单内容', N'1')
GO

INSERT INTO [dbo].[t_bill] VALUES (N'96437935628488704', NULL, NULL, NULL, NULL, N'1', N'1', N'web下单测试', NULL, NULL, NULL, NULL, NULL, N'0.01', N'1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, N'订单内容', N'88612918546923520')
GO

INSERT INTO [dbo].[t_bill] VALUES (N'96439030799011840', NULL, NULL, NULL, NULL, N'1', N'1', N'web下单测试', NULL, NULL, NULL, NULL, NULL, N'0.01', N'1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, N'订单内容', N'3')
GO

INSERT INTO [dbo].[t_bill] VALUES (N'96562854160896000', NULL, NULL, NULL, NULL, N'1', N'1', N'web下单测试', NULL, NULL, NULL, NULL, NULL, N'0.01', N'1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, N'订单内容', N'88612918546923520')
GO

INSERT INTO [dbo].[t_bill] VALUES (N'96565841943990272', NULL, NULL, NULL, NULL, N'1', N'1', N'web下单测试', NULL, NULL, NULL, NULL, NULL, N'0.01', N'1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, N'订单内容', N'2')
GO

INSERT INTO [dbo].[t_bill] VALUES (N'96567083948707840', NULL, NULL, NULL, NULL, N'1', N'1', N'web下单测试', NULL, NULL, NULL, NULL, NULL, N'0.01', N'1', N'38893725107093504', NULL, NULL, NULL, NULL, NULL, NULL, NULL, N'订单内容', N'1')
GO

INSERT INTO [dbo].[t_bill] VALUES (N'96567979038347264', NULL, NULL, NULL, NULL, N'1', N'1', N'web下单测试', NULL, NULL, NULL, NULL, NULL, N'0.01', N'1', N'38894620511305728', NULL, NULL, NULL, NULL, NULL, NULL, NULL, N'订单内容', N'1')
GO

INSERT INTO [dbo].[t_bill] VALUES (N'96597624597123072', NULL, NULL, NULL, NULL, N'0', N'1', N'测试统一下单', NULL, NULL, NULL, NULL, NULL, N'0.01', N'1', N'38924265185083392', NULL, NULL, NULL, NULL, NULL, NULL, NULL, N'付款详情页的订单信息', N'1')
GO

INSERT INTO [dbo].[t_bill] VALUES (N'96598706656251904', NULL, NULL, NULL, NULL, N'0', N'1', N'测试统一下单', NULL, NULL, NULL, NULL, NULL, N'0.01', N'1', N'38925347969826816', NULL, NULL, NULL, NULL, NULL, NULL, NULL, N'付款详情页的订单信息', N'1')
GO

INSERT INTO [dbo].[t_bill] VALUES (N'99550831044595712', NULL, NULL, NULL, NULL, N'0', N'1', N'测试统一下单', NULL, NULL, NULL, NULL, NULL, N'0.01', N'1', N'41877472341393408', NULL, NULL, NULL, NULL, NULL, NULL, NULL, N'付款详情页的订单信息', NULL)
GO


-- ----------------------------
-- Table structure for t_dict_type
-- ----------------------------
IF EXISTS (SELECT * FROM sys.all_objects WHERE object_id = OBJECT_ID(N'[dbo].[t_dict_type]') AND type IN ('U'))
	DROP TABLE [dbo].[t_dict_type]
GO

CREATE TABLE [dbo].[t_dict_type] (
  [id] bigint  NOT NULL,
  [create_by] bigint  NULL,
  [create_date] datetime2(0)  NULL,
  [update_by] bigint  NULL,
  [update_date] datetime2(0)  NULL,
  [type_code] nvarchar(255) COLLATE Chinese_PRC_CI_AS  NOT NULL,
  [type_group_id] bigint  NOT NULL,
  [type_group_code] nvarchar(255) COLLATE Chinese_PRC_CI_AS  NOT NULL,
  [order_num] int  NULL
)
GO

ALTER TABLE [dbo].[t_dict_type] SET (LOCK_ESCALATION = TABLE)
GO

EXEC sp_addextendedproperty
'MS_Description', N'id',
'SCHEMA', N'dbo',
'TABLE', N't_dict_type',
'COLUMN', N'id'
GO

EXEC sp_addextendedproperty
'MS_Description', N'创建人id',
'SCHEMA', N'dbo',
'TABLE', N't_dict_type',
'COLUMN', N'create_by'
GO

EXEC sp_addextendedproperty
'MS_Description', N'创建时间',
'SCHEMA', N'dbo',
'TABLE', N't_dict_type',
'COLUMN', N'create_date'
GO

EXEC sp_addextendedproperty
'MS_Description', N'更新人id',
'SCHEMA', N'dbo',
'TABLE', N't_dict_type',
'COLUMN', N'update_by'
GO

EXEC sp_addextendedproperty
'MS_Description', N'更新时间',
'SCHEMA', N'dbo',
'TABLE', N't_dict_type',
'COLUMN', N'update_date'
GO

EXEC sp_addextendedproperty
'MS_Description', N'字典编码',
'SCHEMA', N'dbo',
'TABLE', N't_dict_type',
'COLUMN', N'type_code'
GO

EXEC sp_addextendedproperty
'MS_Description', N'字典组id',
'SCHEMA', N'dbo',
'TABLE', N't_dict_type',
'COLUMN', N'type_group_id'
GO

EXEC sp_addextendedproperty
'MS_Description', N'字典组编码',
'SCHEMA', N'dbo',
'TABLE', N't_dict_type',
'COLUMN', N'type_group_code'
GO

EXEC sp_addextendedproperty
'MS_Description', N'排序',
'SCHEMA', N'dbo',
'TABLE', N't_dict_type',
'COLUMN', N'order_num'
GO

EXEC sp_addextendedproperty
'MS_Description', N'字典',
'SCHEMA', N'dbo',
'TABLE', N't_dict_type'
GO


-- ----------------------------
-- Records of t_dict_type
-- ----------------------------
INSERT INTO [dbo].[t_dict_type] VALUES (N'100000001', N'1000000005', N'2019-05-05 01:11:33', N'1000000005', N'2019-05-05 01:11:33', N'0', N'1', N'login_type', N'1')
GO

INSERT INTO [dbo].[t_dict_type] VALUES (N'100000002', N'1000000005', N'2019-05-05 01:11:33', N'1000000005', N'2019-05-05 01:11:33', N'1', N'1', N'login_type', N'2')
GO

INSERT INTO [dbo].[t_dict_type] VALUES (N'100000003', N'1000000005', N'2019-05-05 01:11:33', N'1000000005', N'2019-05-05 01:11:33', N'0', N'2', N'status', N'0')
GO

INSERT INTO [dbo].[t_dict_type] VALUES (N'100000004', N'1000000005', N'2019-05-05 01:11:33', N'1000000005', N'2019-05-05 01:11:33', N'1', N'2', N'status', N'1')
GO

INSERT INTO [dbo].[t_dict_type] VALUES (N'100000005', N'1000000005', N'2019-05-05 01:11:33', N'1000000005', N'2019-05-05 01:11:33', N'ROLE_USER', N'3', N'role_type', N'2')
GO

INSERT INTO [dbo].[t_dict_type] VALUES (N'100000006', N'1000000005', N'2019-05-05 01:11:33', N'1000000005', N'2019-05-05 01:11:33', N'ROLE_ADMIN', N'3', N'role_type', N'1')
GO

INSERT INTO [dbo].[t_dict_type] VALUES (N'100000007', N'1000000005', N'2019-05-05 01:11:33', N'1000000005', N'2019-05-05 01:11:33', N'ROLE_SU', N'3', N'role_type', N'0')
GO

INSERT INTO [dbo].[t_dict_type] VALUES (N'100000008', N'1000000005', N'2019-05-05 01:11:33', N'1000000005', N'2019-05-05 01:11:33', N'true', N'4', N'sex_type', N'1')
GO

INSERT INTO [dbo].[t_dict_type] VALUES (N'100000009', N'1000000005', N'2019-05-05 01:11:33', N'1000000005', N'2019-05-05 01:11:33', N'false', N'4', N'sex_type', N'2')
GO

INSERT INTO [dbo].[t_dict_type] VALUES (N'100000010', N'1000000005', N'2019-05-05 01:11:33', N'1000000005', N'2019-05-05 01:11:33', N'0', N'5', N'login_status', N'1')
GO

INSERT INTO [dbo].[t_dict_type] VALUES (N'100000011', N'1000000005', N'2019-05-05 01:11:33', N'1000000005', N'2019-05-05 01:11:33', N'1', N'5', N'login_status', N'2')
GO

INSERT INTO [dbo].[t_dict_type] VALUES (N'100000012', N'1000000005', N'2019-05-05 01:11:33', N'1000000005', N'2019-05-05 01:11:33', N'0', N'6', N'alarm_clock_status', N'1')
GO

INSERT INTO [dbo].[t_dict_type] VALUES (N'100000013', N'1000000005', N'2019-05-05 01:11:33', N'1000000005', N'2019-05-05 01:11:33', N'1', N'6', N'alarm_clock_status', N'2')
GO

INSERT INTO [dbo].[t_dict_type] VALUES (N'100000014', N'1000000005', N'2019-05-05 01:11:33', N'1000000005', N'2019-05-05 01:11:33', N'1', N'7', N'menu_type', N'1')
GO

INSERT INTO [dbo].[t_dict_type] VALUES (N'100000015', N'1000000005', N'2019-05-05 01:11:33', N'1000000005', N'2019-05-05 01:11:33', N'2', N'7', N'menu_type', N'2')
GO

INSERT INTO [dbo].[t_dict_type] VALUES (N'95854276256989184', N'1000000005', N'2019-05-05 01:11:33', N'1000000005', N'2019-05-05 01:11:33', N'2', N'5', N'login_status', N'3')
GO

INSERT INTO [dbo].[t_dict_type] VALUES (N'96958562013544448', N'1000000005', N'2019-05-05 01:11:33', N'1000000005', N'2019-05-05 01:11:33', N'1', N'96950073392365568', N'bill_status', N'1')
GO

INSERT INTO [dbo].[t_dict_type] VALUES (N'96959193222742016', N'1000000005', N'2019-05-05 01:11:33', N'1000000005', N'2019-05-05 01:11:33', N'2', N'96950073392365568', N'bill_status', N'2')
GO

INSERT INTO [dbo].[t_dict_type] VALUES (N'96961451628953600', N'1000000005', N'2019-05-05 01:11:33', N'1000000005', N'2019-05-05 01:11:33', N'3', N'96950073392365568', N'bill_status', N'3')
GO

INSERT INTO [dbo].[t_dict_type] VALUES (N'96962768984342528', N'1000000005', N'2019-05-05 01:11:33', N'1000000005', N'2019-05-05 01:11:33', N'4', N'96950073392365568', N'bill_status', N'4')
GO

INSERT INTO [dbo].[t_dict_type] VALUES (N'96963159130112000', N'1000000005', N'2019-05-05 01:11:33', N'1000000005', N'2019-05-05 01:11:33', N'5', N'96950073392365568', N'bill_status', N'5')
GO

INSERT INTO [dbo].[t_dict_type] VALUES (N'96963562651516928', N'1000000005', N'2019-05-05 01:11:33', N'1000000005', N'2019-05-05 01:11:33', N'6', N'96950073392365568', N'bill_status', N'6')
GO

INSERT INTO [dbo].[t_dict_type] VALUES (N'96964537789448192', N'1000000005', N'2019-05-05 01:11:33', N'1000000005', N'2019-05-05 01:11:33', N'43', N'95684503049076736', N'test', N'1')
GO

INSERT INTO [dbo].[t_dict_type] VALUES (N'96965184324632576', N'1000000005', N'2019-05-05 01:11:33', N'1000000005', N'2019-05-05 01:11:33', N'3', N'95684503049076736', N'test', N'1')
GO

INSERT INTO [dbo].[t_dict_type] VALUES (N'96965451875090432', N'1000000005', N'2019-05-05 01:11:33', N'1000000005', N'2019-05-05 01:11:33', N'44', N'95684503049076736', N'test', N'1')
GO

INSERT INTO [dbo].[t_dict_type] VALUES (N'97354533956485120', N'1000000005', N'2019-05-05 01:11:33', N'1000000005', N'2019-05-05 01:11:33', N'3', N'95684503049076736', N'test', N'3')
GO

INSERT INTO [dbo].[t_dict_type] VALUES (N'97357187684237312', N'1000000005', N'2019-05-05 01:11:33', N'1000000005', N'2019-05-05 01:11:33', N'1', N'97356870024429568', N'bill_type', N'1')
GO

INSERT INTO [dbo].[t_dict_type] VALUES (N'97366040169676800', N'1000000005', N'2019-05-05 01:11:33', N'1000000005', N'2019-05-05 01:11:33', N'alipay', N'97365554750291968', N'payment_type', N'1')
GO

INSERT INTO [dbo].[t_dict_type] VALUES (N'97366110180999168', N'1000000005', N'2019-05-05 01:11:33', N'1000000005', N'2019-05-05 01:11:33', N'wxpay', N'97365554750291968', N'payment_type', N'2')
GO

INSERT INTO [dbo].[t_dict_type] VALUES (N'97536125287006208', N'1000000005', N'2019-05-05 01:11:33', N'1000000005', N'2019-05-05 01:11:33', N'1', N'97535843673047040', N'msg_type', N'1')
GO

INSERT INTO [dbo].[t_dict_type] VALUES (N'97536221990879232', N'1000000005', N'2019-05-05 01:11:33', N'1000000005', N'2019-05-05 01:11:33', N'2', N'97535843673047040', N'msg_type', N'2')
GO

INSERT INTO [dbo].[t_dict_type] VALUES (N'97536285903683584', N'1000000005', N'2019-05-05 01:11:33', N'1000000005', N'2019-05-05 01:11:33', N'3', N'97535843673047040', N'msg_type', N'3')
GO

INSERT INTO [dbo].[t_dict_type] VALUES (N'97536343411785728', N'1000000005', N'2019-05-05 01:11:33', N'1000000005', N'2019-05-05 01:11:33', N'4', N'97535843673047040', N'msg_type', N'4')
GO

INSERT INTO [dbo].[t_dict_type] VALUES (N'97536415625117696', N'1000000005', N'2019-05-05 01:11:33', N'1000000005', N'2019-05-05 01:11:33', N'5', N'97535843673047040', N'msg_type', N'5')
GO

INSERT INTO [dbo].[t_dict_type] VALUES (N'97536494998126592', N'1000000005', N'2019-05-05 01:11:33', N'1000000005', N'2019-05-05 01:11:33', N'6', N'97535843673047040', N'msg_type', N'6')
GO

INSERT INTO [dbo].[t_dict_type] VALUES (N'99136468701675520', N'1000000005', N'2019-05-05 01:11:33', N'1000000005', N'2019-05-05 01:11:33', N'1', N'99135515659337728', N'news_type', N'1')
GO

INSERT INTO [dbo].[t_dict_type] VALUES (N'108265713587716096', N'1000000005', N'2019-05-05 01:11:33', N'1000000005', N'2019-05-05 01:11:33', N'1', N'108265224984854528', N'job_status', N'1')
GO

INSERT INTO [dbo].[t_dict_type] VALUES (N'108265787696873472', N'1000000005', N'2019-05-05 01:11:33', N'1000000005', N'2019-05-05 01:11:33', N'0', N'108265224984854528', N'job_status', N'2')
GO

INSERT INTO [dbo].[t_dict_type] VALUES (N'113787304258043904', N'1000000005', N'2019-05-05 01:11:33', N'1000000005', N'2019-05-05 01:11:33', N'1', N'113787027396231168', N'news_status', N'1')
GO

INSERT INTO [dbo].[t_dict_type] VALUES (N'113787421593698304', N'1000000005', N'2019-05-05 01:11:33', N'1000000005', N'2019-05-05 01:11:33', N'2', N'113787027396231168', N'news_status', N'2')
GO

INSERT INTO [dbo].[t_dict_type] VALUES (N'119131930154237952', N'1000000005', N'2019-05-05 01:11:33', N'1000000005', N'2019-05-05 01:11:33', N'true', N'113787027396231169', N'enabled_status', N'1')
GO

INSERT INTO [dbo].[t_dict_type] VALUES (N'119132047645081600', N'1000000005', N'2019-05-05 01:11:33', N'1000000005', N'2019-05-05 01:11:33', N'false', N'113787027396231169', N'enabled_status', N'2')
GO

INSERT INTO [dbo].[t_dict_type] VALUES (N'155565261192167424', N'1000000005', N'2019-05-05 01:11:33', N'1000000005', N'2019-05-05 01:11:33', N'Input', N'155564655257845760', N'element_component', N'1')
GO

INSERT INTO [dbo].[t_dict_type] VALUES (N'155565360102244352', N'1000000005', N'2019-05-05 01:11:33', N'1000000005', N'2019-05-05 01:11:33', N'Radio', N'155564655257845760', N'element_component', N'2')
GO

INSERT INTO [dbo].[t_dict_type] VALUES (N'155565420294701056', N'1000000005', N'2019-05-05 01:11:33', N'1000000005', N'2019-05-05 01:11:33', N'Checkbox', N'155564655257845760', N'element_component', N'3')
GO

INSERT INTO [dbo].[t_dict_type] VALUES (N'155565698930704384', N'1000000005', N'2019-05-05 01:11:33', N'1000000005', N'2019-05-05 01:11:33', N'InputNumber', N'155564655257845760', N'element_component', N'4')
GO

INSERT INTO [dbo].[t_dict_type] VALUES (N'155565797303910400', N'1000000005', N'2019-05-05 01:11:33', N'1000000005', N'2019-05-05 01:11:33', N'Select', N'155564655257845760', N'element_component', N'5')
GO

INSERT INTO [dbo].[t_dict_type] VALUES (N'155565909979693056', N'1000000005', N'2019-05-05 01:11:33', N'1000000005', N'2019-05-05 01:11:33', N'Cascader', N'155564655257845760', N'element_component', N'6')
GO

INSERT INTO [dbo].[t_dict_type] VALUES (N'155565960655273984', N'1000000005', N'2019-05-05 01:11:33', N'1000000005', N'2019-05-05 01:11:33', N'Switch', N'155564655257845760', N'element_component', N'7')
GO

INSERT INTO [dbo].[t_dict_type] VALUES (N'155566025453076480', N'1000000005', N'2019-05-05 01:11:33', N'1000000005', N'2019-05-05 01:11:33', N'Slider', N'155564655257845760', N'element_component', N'8')
GO

INSERT INTO [dbo].[t_dict_type] VALUES (N'155566122928701440', N'1000000005', N'2019-05-05 01:11:33', N'1000000005', N'2019-05-05 01:11:33', N'TimePicker', N'155564655257845760', N'element_component', N'9')
GO

INSERT INTO [dbo].[t_dict_type] VALUES (N'155566122928701441', NULL, N'2019-06-04 17:21:11', NULL, NULL, N'DateTimePicker', N'155564655257845760', N'element_component', N'10')
GO

INSERT INTO [dbo].[t_dict_type] VALUES (N'155566223822684160', N'1000000005', N'2019-05-05 01:11:33', N'1000000005', N'2019-05-05 01:11:33', N'DatePicker', N'155564655257845760', N'element_component', N'10')
GO

INSERT INTO [dbo].[t_dict_type] VALUES (N'155566295306207232', N'1000000005', N'2019-05-05 01:11:33', N'1000000005', N'2019-05-05 01:11:33', N'Upload', N'155564655257845760', N'element_component', N'11')
GO

INSERT INTO [dbo].[t_dict_type] VALUES (N'155566354039046144', N'1000000005', N'2019-05-05 01:11:33', N'1000000005', N'2019-05-05 01:11:33', N'Rate', N'155564655257845760', N'element_component', N'12')
GO

INSERT INTO [dbo].[t_dict_type] VALUES (N'155566444615041024', N'1000000005', N'2019-05-05 01:11:33', N'1000000005', N'2019-05-05 01:11:33', N'ColorPicker', N'155564655257845760', N'element_component', N'13')
GO

INSERT INTO [dbo].[t_dict_type] VALUES (N'155566528442400768', N'1000000005', N'2019-05-05 01:11:33', N'1000000005', N'2019-05-05 01:11:33', N'Transfer', N'155564655257845760', N'element_component', N'14')
GO

INSERT INTO [dbo].[t_dict_type] VALUES (N'155566528442400770', NULL, NULL, NULL, NULL, N'neditor', N'155564655257845760', N'element_component', N'15')
GO


-- ----------------------------
-- Table structure for t_dict_type_group
-- ----------------------------
IF EXISTS (SELECT * FROM sys.all_objects WHERE object_id = OBJECT_ID(N'[dbo].[t_dict_type_group]') AND type IN ('U'))
	DROP TABLE [dbo].[t_dict_type_group]
GO

CREATE TABLE [dbo].[t_dict_type_group] (
  [id] bigint  NOT NULL,
  [create_by] bigint  NULL,
  [create_date] datetime2(0)  NULL,
  [update_by] bigint  NULL,
  [update_date] datetime2(0)  NULL,
  [type_group_code] nvarchar(255) COLLATE Chinese_PRC_CI_AS  NOT NULL
)
GO

ALTER TABLE [dbo].[t_dict_type_group] SET (LOCK_ESCALATION = TABLE)
GO

EXEC sp_addextendedproperty
'MS_Description', N'id',
'SCHEMA', N'dbo',
'TABLE', N't_dict_type_group',
'COLUMN', N'id'
GO

EXEC sp_addextendedproperty
'MS_Description', N'创建人id',
'SCHEMA', N'dbo',
'TABLE', N't_dict_type_group',
'COLUMN', N'create_by'
GO

EXEC sp_addextendedproperty
'MS_Description', N'创建时间',
'SCHEMA', N'dbo',
'TABLE', N't_dict_type_group',
'COLUMN', N'create_date'
GO

EXEC sp_addextendedproperty
'MS_Description', N'更新人id',
'SCHEMA', N'dbo',
'TABLE', N't_dict_type_group',
'COLUMN', N'update_by'
GO

EXEC sp_addextendedproperty
'MS_Description', N'更新时间',
'SCHEMA', N'dbo',
'TABLE', N't_dict_type_group',
'COLUMN', N'update_date'
GO

EXEC sp_addextendedproperty
'MS_Description', N'字典组编码',
'SCHEMA', N'dbo',
'TABLE', N't_dict_type_group',
'COLUMN', N'type_group_code'
GO

EXEC sp_addextendedproperty
'MS_Description', N'字典组',
'SCHEMA', N'dbo',
'TABLE', N't_dict_type_group'
GO


-- ----------------------------
-- Records of t_dict_type_group
-- ----------------------------
INSERT INTO [dbo].[t_dict_type_group] VALUES (N'1', N'1000000005', N'2019-05-05 01:11:53', N'1000000005', N'2019-05-05 01:11:53', N'login_type')
GO

INSERT INTO [dbo].[t_dict_type_group] VALUES (N'2', N'1000000005', N'2019-05-05 01:11:53', N'1000000005', N'2019-05-05 01:11:53', N'status')
GO

INSERT INTO [dbo].[t_dict_type_group] VALUES (N'3', N'1000000005', N'2019-05-05 01:11:53', N'1000000005', N'2019-05-05 01:11:53', N'role_type')
GO

INSERT INTO [dbo].[t_dict_type_group] VALUES (N'4', N'1000000005', N'2019-05-05 01:11:53', N'1000000005', N'2019-05-05 01:11:53', N'sex_type')
GO

INSERT INTO [dbo].[t_dict_type_group] VALUES (N'5', N'1000000005', N'2019-05-05 01:11:53', N'1000000005', N'2019-05-05 01:11:53', N'login_status')
GO

INSERT INTO [dbo].[t_dict_type_group] VALUES (N'6', N'1000000005', N'2019-05-05 01:11:53', N'1000000005', N'2019-05-05 01:11:53', N'alarm_clock_status')
GO

INSERT INTO [dbo].[t_dict_type_group] VALUES (N'7', N'1000000005', N'2019-05-05 01:11:53', N'1000000005', N'2019-05-05 01:11:53', N'menu_type')
GO

INSERT INTO [dbo].[t_dict_type_group] VALUES (N'96950073392365568', N'1000000005', N'2019-05-05 01:11:53', N'1000000005', N'2019-05-05 01:11:53', N'bill_status')
GO

INSERT INTO [dbo].[t_dict_type_group] VALUES (N'97356870024429568', N'1000000005', N'2019-05-05 01:11:53', N'1000000005', N'2019-05-05 01:11:53', N'bill_type')
GO

INSERT INTO [dbo].[t_dict_type_group] VALUES (N'97365554750291968', N'1000000005', N'2019-05-05 01:11:53', N'1000000005', N'2019-05-05 01:11:53', N'payment_type')
GO

INSERT INTO [dbo].[t_dict_type_group] VALUES (N'97535843673047040', N'1000000005', N'2019-05-05 01:11:53', N'1000000005', N'2019-05-05 01:11:53', N'msg_type')
GO

INSERT INTO [dbo].[t_dict_type_group] VALUES (N'99135515659337728', N'1000000005', N'2019-05-05 01:11:53', N'1000000005', N'2019-05-05 01:11:53', N'news_type')
GO

INSERT INTO [dbo].[t_dict_type_group] VALUES (N'108265224984854528', N'1000000005', N'2019-05-05 01:11:53', N'1000000005', N'2019-05-05 01:11:53', N'job_status')
GO

INSERT INTO [dbo].[t_dict_type_group] VALUES (N'113787027396231168', N'1000000005', N'2019-05-05 01:11:53', N'1000000005', N'2019-05-05 01:11:53', N'news_status')
GO

INSERT INTO [dbo].[t_dict_type_group] VALUES (N'113787027396231169', N'1000000005', N'2019-05-05 01:11:53', N'1000000005', N'2019-05-05 01:11:53', N'enabled_status')
GO

INSERT INTO [dbo].[t_dict_type_group] VALUES (N'155564655257845760', N'1000000005', N'2019-05-05 01:11:53', N'1000000005', N'2019-05-05 01:11:53', N'element_component')
GO


-- ----------------------------
-- Table structure for t_news_info
-- ----------------------------
IF EXISTS (SELECT * FROM sys.all_objects WHERE object_id = OBJECT_ID(N'[dbo].[t_news_info]') AND type IN ('U'))
	DROP TABLE [dbo].[t_news_info]
GO

CREATE TABLE [dbo].[t_news_info] (
  [id] bigint  NOT NULL,
  [create_by] bigint  NULL,
  [create_date] datetime2(0)  NULL,
  [update_by] bigint  NULL,
  [update_date] datetime2(0)  NULL,
  [title] nvarchar(255) COLLATE Chinese_PRC_CI_AS  NULL,
  [user_id] bigint  NULL,
  [news_status] int  NULL,
  [content] nvarchar(max) COLLATE Chinese_PRC_CI_AS  NULL,
  [image_url] nvarchar(255) COLLATE Chinese_PRC_CI_AS  NULL,
  [publish_date] datetime2(0)  NULL,
  [tags] nvarchar(255) COLLATE Chinese_PRC_CI_AS  NULL,
  [news_type] int  NULL
)
GO

ALTER TABLE [dbo].[t_news_info] SET (LOCK_ESCALATION = TABLE)
GO

EXEC sp_addextendedproperty
'MS_Description', N'创建人id',
'SCHEMA', N'dbo',
'TABLE', N't_news_info',
'COLUMN', N'create_by'
GO

EXEC sp_addextendedproperty
'MS_Description', N'创建时间',
'SCHEMA', N'dbo',
'TABLE', N't_news_info',
'COLUMN', N'create_date'
GO

EXEC sp_addextendedproperty
'MS_Description', N'更新人id',
'SCHEMA', N'dbo',
'TABLE', N't_news_info',
'COLUMN', N'update_by'
GO

EXEC sp_addextendedproperty
'MS_Description', N'更新时间',
'SCHEMA', N'dbo',
'TABLE', N't_news_info',
'COLUMN', N'update_date'
GO

EXEC sp_addextendedproperty
'MS_Description', N'标题',
'SCHEMA', N'dbo',
'TABLE', N't_news_info',
'COLUMN', N'title'
GO

EXEC sp_addextendedproperty
'MS_Description', N'用户id',
'SCHEMA', N'dbo',
'TABLE', N't_news_info',
'COLUMN', N'user_id'
GO

EXEC sp_addextendedproperty
'MS_Description', N'新闻内容',
'SCHEMA', N'dbo',
'TABLE', N't_news_info',
'COLUMN', N'content'
GO

EXEC sp_addextendedproperty
'MS_Description', N'缩略图',
'SCHEMA', N'dbo',
'TABLE', N't_news_info',
'COLUMN', N'image_url'
GO

EXEC sp_addextendedproperty
'MS_Description', N'发布时间',
'SCHEMA', N'dbo',
'TABLE', N't_news_info',
'COLUMN', N'publish_date'
GO

EXEC sp_addextendedproperty
'MS_Description', N'标签',
'SCHEMA', N'dbo',
'TABLE', N't_news_info',
'COLUMN', N'tags'
GO

EXEC sp_addextendedproperty
'MS_Description', N'新闻类型',
'SCHEMA', N'dbo',
'TABLE', N't_news_info',
'COLUMN', N'news_type'
GO

EXEC sp_addextendedproperty
'MS_Description', N'新闻',
'SCHEMA', N'dbo',
'TABLE', N't_news_info'
GO


-- ----------------------------
-- Records of t_news_info
-- ----------------------------
INSERT INTO [dbo].[t_news_info] VALUES (N'114746419348377600', N'1000000005', N'2019-05-05 01:12:14', N'1000000005', N'2019-05-05 01:12:14', N'测试', N'1000000000', N'1', N'<p>1</p>', NULL, N'2019-01-10 13:34:12', N'1', N'1')
GO

INSERT INTO [dbo].[t_news_info] VALUES (N'117693842005823488', N'1000000005', N'2019-05-05 01:12:14', N'1000000005', N'2019-05-05 01:12:14', N'测试', N'1000000000', N'2', N'', NULL, N'2019-01-18 16:58:34', N'1', N'1')
GO


-- ----------------------------
-- Table structure for t_news_tag
-- ----------------------------
IF EXISTS (SELECT * FROM sys.all_objects WHERE object_id = OBJECT_ID(N'[dbo].[t_news_tag]') AND type IN ('U'))
	DROP TABLE [dbo].[t_news_tag]
GO

CREATE TABLE [dbo].[t_news_tag] (
  [id] bigint  NOT NULL,
  [create_by] bigint  NULL,
  [create_date] datetime2(0)  NULL,
  [update_by] bigint  NULL,
  [update_date] datetime2(0)  NULL,
  [news_info_id] bigint  NULL,
  [tag_id] bigint  NULL
)
GO

ALTER TABLE [dbo].[t_news_tag] SET (LOCK_ESCALATION = TABLE)
GO

EXEC sp_addextendedproperty
'MS_Description', N'创建人id',
'SCHEMA', N'dbo',
'TABLE', N't_news_tag',
'COLUMN', N'create_by'
GO

EXEC sp_addextendedproperty
'MS_Description', N'创建时间',
'SCHEMA', N'dbo',
'TABLE', N't_news_tag',
'COLUMN', N'create_date'
GO

EXEC sp_addextendedproperty
'MS_Description', N'更新人id',
'SCHEMA', N'dbo',
'TABLE', N't_news_tag',
'COLUMN', N'update_by'
GO

EXEC sp_addextendedproperty
'MS_Description', N'更新时间',
'SCHEMA', N'dbo',
'TABLE', N't_news_tag',
'COLUMN', N'update_date'
GO


-- ----------------------------
-- Table structure for t_notice_msg
-- ----------------------------
IF EXISTS (SELECT * FROM sys.all_objects WHERE object_id = OBJECT_ID(N'[dbo].[t_notice_msg]') AND type IN ('U'))
	DROP TABLE [dbo].[t_notice_msg]
GO

CREATE TABLE [dbo].[t_notice_msg] (
  [id] bigint  NOT NULL,
  [create_by] bigint  NULL,
  [create_date] datetime2(0)  NULL,
  [update_by] bigint  NULL,
  [update_date] datetime2(0)  NULL,
  [user_id] bigint  NULL,
  [msg_type] int  NULL,
  [content] nvarchar(max) COLLATE Chinese_PRC_CI_AS  NULL,
  [is_read] tinyint  NOT NULL
)
GO

ALTER TABLE [dbo].[t_notice_msg] SET (LOCK_ESCALATION = TABLE)
GO

EXEC sp_addextendedproperty
'MS_Description', N'id',
'SCHEMA', N'dbo',
'TABLE', N't_notice_msg',
'COLUMN', N'id'
GO

EXEC sp_addextendedproperty
'MS_Description', N'创建人id',
'SCHEMA', N'dbo',
'TABLE', N't_notice_msg',
'COLUMN', N'create_by'
GO

EXEC sp_addextendedproperty
'MS_Description', N'创建时间',
'SCHEMA', N'dbo',
'TABLE', N't_notice_msg',
'COLUMN', N'create_date'
GO

EXEC sp_addextendedproperty
'MS_Description', N'更新人id',
'SCHEMA', N'dbo',
'TABLE', N't_notice_msg',
'COLUMN', N'update_by'
GO

EXEC sp_addextendedproperty
'MS_Description', N'更新时间',
'SCHEMA', N'dbo',
'TABLE', N't_notice_msg',
'COLUMN', N'update_date'
GO

EXEC sp_addextendedproperty
'MS_Description', N'用户id',
'SCHEMA', N'dbo',
'TABLE', N't_notice_msg',
'COLUMN', N'user_id'
GO

EXEC sp_addextendedproperty
'MS_Description', N'消息类型',
'SCHEMA', N'dbo',
'TABLE', N't_notice_msg',
'COLUMN', N'msg_type'
GO

EXEC sp_addextendedproperty
'MS_Description', N'消息内容',
'SCHEMA', N'dbo',
'TABLE', N't_notice_msg',
'COLUMN', N'content'
GO

EXEC sp_addextendedproperty
'MS_Description', N'是否已读',
'SCHEMA', N'dbo',
'TABLE', N't_notice_msg',
'COLUMN', N'is_read'
GO

EXEC sp_addextendedproperty
'MS_Description', N'通知消息',
'SCHEMA', N'dbo',
'TABLE', N't_notice_msg'
GO


-- ----------------------------
-- Table structure for t_reset_pwd_info
-- ----------------------------
IF EXISTS (SELECT * FROM sys.all_objects WHERE object_id = OBJECT_ID(N'[dbo].[t_reset_pwd_info]') AND type IN ('U'))
	DROP TABLE [dbo].[t_reset_pwd_info]
GO

CREATE TABLE [dbo].[t_reset_pwd_info] (
  [id] bigint  NOT NULL,
  [create_by] bigint  NULL,
  [create_date] datetime2(0)  NULL,
  [update_by] bigint  NULL,
  [update_date] datetime2(0)  NULL,
  [expires_in] datetime2(0)  NULL,
  [secret_key] nvarchar(255) COLLATE Chinese_PRC_CI_AS  NULL,
  [user_id] bigint  NULL,
  [valid] tinyint  NOT NULL
)
GO

ALTER TABLE [dbo].[t_reset_pwd_info] SET (LOCK_ESCALATION = TABLE)
GO

EXEC sp_addextendedproperty
'MS_Description', N'创建人id',
'SCHEMA', N'dbo',
'TABLE', N't_reset_pwd_info',
'COLUMN', N'create_by'
GO

EXEC sp_addextendedproperty
'MS_Description', N'创建时间',
'SCHEMA', N'dbo',
'TABLE', N't_reset_pwd_info',
'COLUMN', N'create_date'
GO

EXEC sp_addextendedproperty
'MS_Description', N'更新人id',
'SCHEMA', N'dbo',
'TABLE', N't_reset_pwd_info',
'COLUMN', N'update_by'
GO

EXEC sp_addextendedproperty
'MS_Description', N'更新时间',
'SCHEMA', N'dbo',
'TABLE', N't_reset_pwd_info',
'COLUMN', N'update_date'
GO


-- ----------------------------
-- Table structure for t_s_city
-- ----------------------------
IF EXISTS (SELECT * FROM sys.all_objects WHERE object_id = OBJECT_ID(N'[dbo].[t_s_city]') AND type IN ('U'))
	DROP TABLE [dbo].[t_s_city]
GO

CREATE TABLE [dbo].[t_s_city] (
  [id] int  NOT NULL,
  [name] nvarchar(64) COLLATE Chinese_PRC_CI_AS  NULL,
  [city_id] nvarchar(12) COLLATE Chinese_PRC_CI_AS  NULL,
  [province_id] nvarchar(12) COLLATE Chinese_PRC_CI_AS  NULL
)
GO

ALTER TABLE [dbo].[t_s_city] SET (LOCK_ESCALATION = TABLE)
GO


-- ----------------------------
-- Records of t_s_city
-- ----------------------------
INSERT INTO [dbo].[t_s_city] VALUES (N'1', N'市辖区', N'110100000000', N'110000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'2', N'市辖区', N'120100000000', N'120000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'3', N'石家庄市', N'130100000000', N'130000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'4', N'唐山市', N'130200000000', N'130000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'5', N'秦皇岛市', N'130300000000', N'130000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'6', N'邯郸市', N'130400000000', N'130000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'7', N'邢台市', N'130500000000', N'130000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'8', N'保定市', N'130600000000', N'130000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'9', N'张家口市', N'130700000000', N'130000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'10', N'承德市', N'130800000000', N'130000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'11', N'沧州市', N'130900000000', N'130000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'12', N'廊坊市', N'131000000000', N'130000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'13', N'衡水市', N'131100000000', N'130000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'14', N'太原市', N'140100000000', N'140000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'15', N'大同市', N'140200000000', N'140000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'16', N'阳泉市', N'140300000000', N'140000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'17', N'长治市', N'140400000000', N'140000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'18', N'晋城市', N'140500000000', N'140000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'19', N'朔州市', N'140600000000', N'140000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'20', N'晋中市', N'140700000000', N'140000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'21', N'运城市', N'140800000000', N'140000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'22', N'忻州市', N'140900000000', N'140000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'23', N'临汾市', N'141000000000', N'140000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'24', N'吕梁市', N'141100000000', N'140000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'25', N'呼和浩特市', N'150100000000', N'150000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'26', N'包头市', N'150200000000', N'150000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'27', N'乌海市', N'150300000000', N'150000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'28', N'赤峰市', N'150400000000', N'150000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'29', N'通辽市', N'150500000000', N'150000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'30', N'鄂尔多斯市', N'150600000000', N'150000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'31', N'呼伦贝尔市', N'150700000000', N'150000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'32', N'巴彦淖尔市', N'150800000000', N'150000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'33', N'乌兰察布市', N'150900000000', N'150000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'34', N'兴安盟', N'152200000000', N'150000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'35', N'锡林郭勒盟', N'152500000000', N'150000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'36', N'阿拉善盟', N'152900000000', N'150000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'37', N'沈阳市', N'210100000000', N'210000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'38', N'大连市', N'210200000000', N'210000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'39', N'鞍山市', N'210300000000', N'210000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'40', N'抚顺市', N'210400000000', N'210000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'41', N'本溪市', N'210500000000', N'210000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'42', N'丹东市', N'210600000000', N'210000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'43', N'锦州市', N'210700000000', N'210000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'44', N'营口市', N'210800000000', N'210000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'45', N'阜新市', N'210900000000', N'210000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'46', N'辽阳市', N'211000000000', N'210000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'47', N'盘锦市', N'211100000000', N'210000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'48', N'铁岭市', N'211200000000', N'210000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'49', N'朝阳市', N'211300000000', N'210000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'50', N'葫芦岛市', N'211400000000', N'210000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'51', N'长春市', N'220100000000', N'220000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'52', N'吉林市', N'220200000000', N'220000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'53', N'四平市', N'220300000000', N'220000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'54', N'辽源市', N'220400000000', N'220000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'55', N'通化市', N'220500000000', N'220000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'56', N'白山市', N'220600000000', N'220000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'57', N'松原市', N'220700000000', N'220000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'58', N'白城市', N'220800000000', N'220000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'59', N'延边朝鲜族自治州', N'222400000000', N'220000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'60', N'哈尔滨市', N'230100000000', N'230000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'61', N'齐齐哈尔市', N'230200000000', N'230000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'62', N'鸡西市', N'230300000000', N'230000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'63', N'鹤岗市', N'230400000000', N'230000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'64', N'双鸭山市', N'230500000000', N'230000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'65', N'大庆市', N'230600000000', N'230000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'66', N'伊春市', N'230700000000', N'230000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'67', N'佳木斯市', N'230800000000', N'230000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'68', N'七台河市', N'230900000000', N'230000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'69', N'牡丹江市', N'231000000000', N'230000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'70', N'黑河市', N'231100000000', N'230000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'71', N'绥化市', N'231200000000', N'230000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'72', N'大兴安岭地区', N'232700000000', N'230000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'73', N'市辖区', N'310100000000', N'310000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'74', N'南京市', N'320100000000', N'320000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'75', N'无锡市', N'320200000000', N'320000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'76', N'徐州市', N'320300000000', N'320000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'77', N'常州市', N'320400000000', N'320000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'78', N'苏州市', N'320500000000', N'320000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'79', N'南通市', N'320600000000', N'320000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'80', N'连云港市', N'320700000000', N'320000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'81', N'淮安市', N'320800000000', N'320000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'82', N'盐城市', N'320900000000', N'320000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'83', N'扬州市', N'321000000000', N'320000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'84', N'镇江市', N'321100000000', N'320000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'85', N'泰州市', N'321200000000', N'320000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'86', N'宿迁市', N'321300000000', N'320000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'87', N'杭州市', N'330100000000', N'330000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'88', N'宁波市', N'330200000000', N'330000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'89', N'温州市', N'330300000000', N'330000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'90', N'嘉兴市', N'330400000000', N'330000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'91', N'湖州市', N'330500000000', N'330000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'92', N'绍兴市', N'330600000000', N'330000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'93', N'金华市', N'330700000000', N'330000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'94', N'衢州市', N'330800000000', N'330000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'95', N'舟山市', N'330900000000', N'330000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'96', N'台州市', N'331000000000', N'330000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'97', N'丽水市', N'331100000000', N'330000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'98', N'合肥市', N'340100000000', N'340000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'99', N'芜湖市', N'340200000000', N'340000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'100', N'蚌埠市', N'340300000000', N'340000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'101', N'淮南市', N'340400000000', N'340000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'102', N'马鞍山市', N'340500000000', N'340000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'103', N'淮北市', N'340600000000', N'340000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'104', N'铜陵市', N'340700000000', N'340000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'105', N'安庆市', N'340800000000', N'340000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'106', N'黄山市', N'341000000000', N'340000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'107', N'滁州市', N'341100000000', N'340000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'108', N'阜阳市', N'341200000000', N'340000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'109', N'宿州市', N'341300000000', N'340000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'110', N'六安市', N'341500000000', N'340000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'111', N'亳州市', N'341600000000', N'340000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'112', N'池州市', N'341700000000', N'340000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'113', N'宣城市', N'341800000000', N'340000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'114', N'福州市', N'350100000000', N'350000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'115', N'厦门市', N'350200000000', N'350000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'116', N'莆田市', N'350300000000', N'350000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'117', N'三明市', N'350400000000', N'350000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'118', N'泉州市', N'350500000000', N'350000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'119', N'漳州市', N'350600000000', N'350000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'120', N'南平市', N'350700000000', N'350000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'121', N'龙岩市', N'350800000000', N'350000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'122', N'宁德市', N'350900000000', N'350000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'123', N'南昌市', N'360100000000', N'360000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'124', N'景德镇市', N'360200000000', N'360000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'125', N'萍乡市', N'360300000000', N'360000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'126', N'九江市', N'360400000000', N'360000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'127', N'新余市', N'360500000000', N'360000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'128', N'鹰潭市', N'360600000000', N'360000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'129', N'赣州市', N'360700000000', N'360000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'130', N'吉安市', N'360800000000', N'360000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'131', N'宜春市', N'360900000000', N'360000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'132', N'抚州市', N'361000000000', N'360000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'133', N'上饶市', N'361100000000', N'360000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'134', N'济南市', N'370100000000', N'370000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'135', N'青岛市', N'370200000000', N'370000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'136', N'淄博市', N'370300000000', N'370000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'137', N'枣庄市', N'370400000000', N'370000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'138', N'东营市', N'370500000000', N'370000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'139', N'烟台市', N'370600000000', N'370000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'140', N'潍坊市', N'370700000000', N'370000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'141', N'济宁市', N'370800000000', N'370000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'142', N'泰安市', N'370900000000', N'370000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'143', N'威海市', N'371000000000', N'370000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'144', N'日照市', N'371100000000', N'370000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'145', N'莱芜市', N'371200000000', N'370000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'146', N'临沂市', N'371300000000', N'370000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'147', N'德州市', N'371400000000', N'370000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'148', N'聊城市', N'371500000000', N'370000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'149', N'滨州市', N'371600000000', N'370000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'150', N'菏泽市', N'371700000000', N'370000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'151', N'郑州市', N'410100000000', N'410000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'152', N'开封市', N'410200000000', N'410000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'153', N'洛阳市', N'410300000000', N'410000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'154', N'平顶山市', N'410400000000', N'410000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'155', N'安阳市', N'410500000000', N'410000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'156', N'鹤壁市', N'410600000000', N'410000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'157', N'新乡市', N'410700000000', N'410000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'158', N'焦作市', N'410800000000', N'410000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'159', N'濮阳市', N'410900000000', N'410000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'160', N'许昌市', N'411000000000', N'410000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'161', N'漯河市', N'411100000000', N'410000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'162', N'三门峡市', N'411200000000', N'410000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'163', N'南阳市', N'411300000000', N'410000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'164', N'商丘市', N'411400000000', N'410000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'165', N'信阳市', N'411500000000', N'410000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'166', N'周口市', N'411600000000', N'410000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'167', N'驻马店市', N'411700000000', N'410000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'168', N'省直辖县级行政区划', N'419000000000', N'410000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'169', N'武汉市', N'420100000000', N'420000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'170', N'黄石市', N'420200000000', N'420000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'171', N'十堰市', N'420300000000', N'420000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'172', N'宜昌市', N'420500000000', N'420000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'173', N'襄阳市', N'420600000000', N'420000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'174', N'鄂州市', N'420700000000', N'420000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'175', N'荆门市', N'420800000000', N'420000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'176', N'孝感市', N'420900000000', N'420000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'177', N'荆州市', N'421000000000', N'420000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'178', N'黄冈市', N'421100000000', N'420000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'179', N'咸宁市', N'421200000000', N'420000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'180', N'随州市', N'421300000000', N'420000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'181', N'恩施土家族苗族自治州', N'422800000000', N'420000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'182', N'省直辖县级行政区划', N'429000000000', N'420000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'183', N'长沙市', N'430100000000', N'430000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'184', N'株洲市', N'430200000000', N'430000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'185', N'湘潭市', N'430300000000', N'430000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'186', N'衡阳市', N'430400000000', N'430000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'187', N'邵阳市', N'430500000000', N'430000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'188', N'岳阳市', N'430600000000', N'430000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'189', N'常德市', N'430700000000', N'430000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'190', N'张家界市', N'430800000000', N'430000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'191', N'益阳市', N'430900000000', N'430000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'192', N'郴州市', N'431000000000', N'430000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'193', N'永州市', N'431100000000', N'430000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'194', N'怀化市', N'431200000000', N'430000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'195', N'娄底市', N'431300000000', N'430000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'196', N'湘西土家族苗族自治州', N'433100000000', N'430000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'197', N'广州市', N'440100000000', N'440000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'198', N'韶关市', N'440200000000', N'440000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'199', N'深圳市', N'440300000000', N'440000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'200', N'珠海市', N'440400000000', N'440000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'201', N'汕头市', N'440500000000', N'440000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'202', N'佛山市', N'440600000000', N'440000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'203', N'江门市', N'440700000000', N'440000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'204', N'湛江市', N'440800000000', N'440000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'205', N'茂名市', N'440900000000', N'440000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'206', N'肇庆市', N'441200000000', N'440000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'207', N'惠州市', N'441300000000', N'440000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'208', N'梅州市', N'441400000000', N'440000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'209', N'汕尾市', N'441500000000', N'440000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'210', N'河源市', N'441600000000', N'440000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'211', N'阳江市', N'441700000000', N'440000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'212', N'清远市', N'441800000000', N'440000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'213', N'东莞市', N'441900000000', N'440000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'214', N'中山市', N'442000000000', N'440000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'215', N'潮州市', N'445100000000', N'440000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'216', N'揭阳市', N'445200000000', N'440000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'217', N'云浮市', N'445300000000', N'440000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'218', N'南宁市', N'450100000000', N'450000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'219', N'柳州市', N'450200000000', N'450000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'220', N'桂林市', N'450300000000', N'450000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'221', N'梧州市', N'450400000000', N'450000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'222', N'北海市', N'450500000000', N'450000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'223', N'防城港市', N'450600000000', N'450000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'224', N'钦州市', N'450700000000', N'450000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'225', N'贵港市', N'450800000000', N'450000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'226', N'玉林市', N'450900000000', N'450000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'227', N'百色市', N'451000000000', N'450000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'228', N'贺州市', N'451100000000', N'450000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'229', N'河池市', N'451200000000', N'450000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'230', N'来宾市', N'451300000000', N'450000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'231', N'崇左市', N'451400000000', N'450000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'232', N'海口市', N'460100000000', N'460000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'233', N'三亚市', N'460200000000', N'460000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'234', N'三沙市', N'460300000000', N'460000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'235', N'儋州市', N'460400000000', N'460000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'236', N'省直辖县级行政区划', N'469000000000', N'460000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'237', N'市辖区', N'500100000000', N'500000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'238', N'县', N'500200000000', N'500000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'239', N'成都市', N'510100000000', N'510000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'240', N'自贡市', N'510300000000', N'510000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'241', N'攀枝花市', N'510400000000', N'510000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'242', N'泸州市', N'510500000000', N'510000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'243', N'德阳市', N'510600000000', N'510000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'244', N'绵阳市', N'510700000000', N'510000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'245', N'广元市', N'510800000000', N'510000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'246', N'遂宁市', N'510900000000', N'510000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'247', N'内江市', N'511000000000', N'510000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'248', N'乐山市', N'511100000000', N'510000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'249', N'南充市', N'511300000000', N'510000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'250', N'眉山市', N'511400000000', N'510000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'251', N'宜宾市', N'511500000000', N'510000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'252', N'广安市', N'511600000000', N'510000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'253', N'达州市', N'511700000000', N'510000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'254', N'雅安市', N'511800000000', N'510000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'255', N'巴中市', N'511900000000', N'510000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'256', N'资阳市', N'512000000000', N'510000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'257', N'阿坝藏族羌族自治州', N'513200000000', N'510000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'258', N'甘孜藏族自治州', N'513300000000', N'510000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'259', N'凉山彝族自治州', N'513400000000', N'510000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'260', N'贵阳市', N'520100000000', N'520000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'261', N'六盘水市', N'520200000000', N'520000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'262', N'遵义市', N'520300000000', N'520000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'263', N'安顺市', N'520400000000', N'520000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'264', N'毕节市', N'520500000000', N'520000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'265', N'铜仁市', N'520600000000', N'520000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'266', N'黔西南布依族苗族自治州', N'522300000000', N'520000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'267', N'黔东南苗族侗族自治州', N'522600000000', N'520000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'268', N'黔南布依族苗族自治州', N'522700000000', N'520000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'269', N'昆明市', N'530100000000', N'530000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'270', N'曲靖市', N'530300000000', N'530000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'271', N'玉溪市', N'530400000000', N'530000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'272', N'保山市', N'530500000000', N'530000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'273', N'昭通市', N'530600000000', N'530000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'274', N'丽江市', N'530700000000', N'530000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'275', N'普洱市', N'530800000000', N'530000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'276', N'临沧市', N'530900000000', N'530000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'277', N'楚雄彝族自治州', N'532300000000', N'530000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'278', N'红河哈尼族彝族自治州', N'532500000000', N'530000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'279', N'文山壮族苗族自治州', N'532600000000', N'530000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'280', N'西双版纳傣族自治州', N'532800000000', N'530000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'281', N'大理白族自治州', N'532900000000', N'530000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'282', N'德宏傣族景颇族自治州', N'533100000000', N'530000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'283', N'怒江傈僳族自治州', N'533300000000', N'530000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'284', N'迪庆藏族自治州', N'533400000000', N'530000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'285', N'拉萨市', N'540100000000', N'540000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'286', N'日喀则市', N'540200000000', N'540000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'287', N'昌都市', N'540300000000', N'540000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'288', N'林芝市', N'540400000000', N'540000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'289', N'山南市', N'540500000000', N'540000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'290', N'那曲市', N'540600000000', N'540000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'291', N'阿里地区', N'542500000000', N'540000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'292', N'西安市', N'610100000000', N'610000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'293', N'铜川市', N'610200000000', N'610000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'294', N'宝鸡市', N'610300000000', N'610000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'295', N'咸阳市', N'610400000000', N'610000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'296', N'渭南市', N'610500000000', N'610000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'297', N'延安市', N'610600000000', N'610000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'298', N'汉中市', N'610700000000', N'610000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'299', N'榆林市', N'610800000000', N'610000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'300', N'安康市', N'610900000000', N'610000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'301', N'商洛市', N'611000000000', N'610000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'302', N'兰州市', N'620100000000', N'620000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'303', N'嘉峪关市', N'620200000000', N'620000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'304', N'金昌市', N'620300000000', N'620000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'305', N'白银市', N'620400000000', N'620000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'306', N'天水市', N'620500000000', N'620000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'307', N'武威市', N'620600000000', N'620000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'308', N'张掖市', N'620700000000', N'620000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'309', N'平凉市', N'620800000000', N'620000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'310', N'酒泉市', N'620900000000', N'620000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'311', N'庆阳市', N'621000000000', N'620000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'312', N'定西市', N'621100000000', N'620000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'313', N'陇南市', N'621200000000', N'620000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'314', N'临夏回族自治州', N'622900000000', N'620000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'315', N'甘南藏族自治州', N'623000000000', N'620000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'316', N'西宁市', N'630100000000', N'630000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'317', N'海东市', N'630200000000', N'630000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'318', N'海北藏族自治州', N'632200000000', N'630000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'319', N'黄南藏族自治州', N'632300000000', N'630000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'320', N'海南藏族自治州', N'632500000000', N'630000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'321', N'果洛藏族自治州', N'632600000000', N'630000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'322', N'玉树藏族自治州', N'632700000000', N'630000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'323', N'海西蒙古族藏族自治州', N'632800000000', N'630000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'324', N'银川市', N'640100000000', N'640000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'325', N'石嘴山市', N'640200000000', N'640000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'326', N'吴忠市', N'640300000000', N'640000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'327', N'固原市', N'640400000000', N'640000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'328', N'中卫市', N'640500000000', N'640000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'329', N'乌鲁木齐市', N'650100000000', N'650000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'330', N'克拉玛依市', N'650200000000', N'650000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'331', N'吐鲁番市', N'650400000000', N'650000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'332', N'哈密市', N'650500000000', N'650000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'333', N'昌吉回族自治州', N'652300000000', N'650000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'334', N'博尔塔拉蒙古自治州', N'652700000000', N'650000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'335', N'巴音郭楞蒙古自治州', N'652800000000', N'650000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'336', N'阿克苏地区', N'652900000000', N'650000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'337', N'克孜勒苏柯尔克孜自治州', N'653000000000', N'650000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'338', N'喀什地区', N'653100000000', N'650000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'339', N'和田地区', N'653200000000', N'650000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'340', N'伊犁哈萨克自治州', N'654000000000', N'650000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'341', N'塔城地区', N'654200000000', N'650000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'342', N'阿勒泰地区', N'654300000000', N'650000000000')
GO

INSERT INTO [dbo].[t_s_city] VALUES (N'343', N'自治区直辖县级行政区划', N'659000000000', N'650000000000')
GO


-- ----------------------------
-- Table structure for t_s_column_ui
-- ----------------------------
IF EXISTS (SELECT * FROM sys.all_objects WHERE object_id = OBJECT_ID(N'[dbo].[t_s_column_ui]') AND type IN ('U'))
	DROP TABLE [dbo].[t_s_column_ui]
GO

CREATE TABLE [dbo].[t_s_column_ui] (
  [id] bigint  NOT NULL,
  [table_name] nvarchar(50) COLLATE Chinese_PRC_CI_AS  NOT NULL,
  [name] nvarchar(50) COLLATE Chinese_PRC_CI_AS  NOT NULL,
  [ui_type] nvarchar(50) COLLATE Chinese_PRC_CI_AS  NOT NULL,
  [extra_info] nvarchar(50) COLLATE Chinese_PRC_CI_AS  NULL,
  [allow_search] tinyint  NULL,
  [hidden] tinyint  NULL,
  [allow_input] tinyint  NULL
)
GO

ALTER TABLE [dbo].[t_s_column_ui] SET (LOCK_ESCALATION = TABLE)
GO

EXEC sp_addextendedproperty
'MS_Description', N'表名',
'SCHEMA', N'dbo',
'TABLE', N't_s_column_ui',
'COLUMN', N'table_name'
GO

EXEC sp_addextendedproperty
'MS_Description', N'属性名',
'SCHEMA', N'dbo',
'TABLE', N't_s_column_ui',
'COLUMN', N'name'
GO

EXEC sp_addextendedproperty
'MS_Description', N'属性UI类型',
'SCHEMA', N'dbo',
'TABLE', N't_s_column_ui',
'COLUMN', N'ui_type'
GO

EXEC sp_addextendedproperty
'MS_Description', N'补充信息',
'SCHEMA', N'dbo',
'TABLE', N't_s_column_ui',
'COLUMN', N'extra_info'
GO

EXEC sp_addextendedproperty
'MS_Description', N'允许搜索',
'SCHEMA', N'dbo',
'TABLE', N't_s_column_ui',
'COLUMN', N'allow_search'
GO

EXEC sp_addextendedproperty
'MS_Description', N'是否隐藏',
'SCHEMA', N'dbo',
'TABLE', N't_s_column_ui',
'COLUMN', N'hidden'
GO

EXEC sp_addextendedproperty
'MS_Description', N'允许输入',
'SCHEMA', N'dbo',
'TABLE', N't_s_column_ui',
'COLUMN', N'allow_input'
GO

EXEC sp_addextendedproperty
'MS_Description', N'属性UI',
'SCHEMA', N'dbo',
'TABLE', N't_s_column_ui'
GO


-- ----------------------------
-- Records of t_s_column_ui
-- ----------------------------
INSERT INTO [dbo].[t_s_column_ui] VALUES (N'77', N't_s_column_ui', N'id', N'Input', NULL, N'0', N'0', N'1')
GO

INSERT INTO [dbo].[t_s_column_ui] VALUES (N'78', N't_s_column_ui', N'tableName', N'Select', NULL, N'0', N'0', N'1')
GO

INSERT INTO [dbo].[t_s_column_ui] VALUES (N'79', N't_s_column_ui', N'name', N'Input', NULL, N'0', N'0', N'1')
GO

INSERT INTO [dbo].[t_s_column_ui] VALUES (N'80', N't_s_column_ui', N'uiType', N'Input', NULL, N'0', N'0', N'1')
GO

INSERT INTO [dbo].[t_s_column_ui] VALUES (N'81', N't_bill', N'id', N'Input', NULL, N'0', N'0', N'1')
GO

INSERT INTO [dbo].[t_s_column_ui] VALUES (N'82', N't_bill', N'createBy', N'Input', NULL, N'0', N'0', N'1')
GO

INSERT INTO [dbo].[t_s_column_ui] VALUES (N'83', N't_bill', N'createDate', N'DatePicker', NULL, N'0', N'0', N'1')
GO

INSERT INTO [dbo].[t_s_column_ui] VALUES (N'84', N't_bill', N'updateBy', N'Input', NULL, N'0', N'0', N'1')
GO

INSERT INTO [dbo].[t_s_column_ui] VALUES (N'85', N't_bill', N'updateDate', N'DatePicker', NULL, N'0', N'0', N'1')
GO

INSERT INTO [dbo].[t_s_column_ui] VALUES (N'86', N't_bill', N'billType', N'Input', NULL, N'0', N'0', N'1')
GO

INSERT INTO [dbo].[t_s_column_ui] VALUES (N'87', N't_bill', N'billStatus', N'Input', NULL, N'0', N'0', N'1')
GO

INSERT INTO [dbo].[t_s_column_ui] VALUES (N'88', N't_bill', N'billDesc', N'Input', NULL, N'0', N'0', N'1')
GO

INSERT INTO [dbo].[t_s_column_ui] VALUES (N'89', N't_bill', N'receivingAddress', N'Input', NULL, N'0', N'0', N'1')
GO

INSERT INTO [dbo].[t_s_column_ui] VALUES (N'90', N't_bill', N'logisticsInfo', N'Input', NULL, N'0', N'0', N'1')
GO

INSERT INTO [dbo].[t_s_column_ui] VALUES (N'91', N't_bill', N'logisticsNo', N'Input', NULL, N'0', N'0', N'1')
GO

INSERT INTO [dbo].[t_s_column_ui] VALUES (N'92', N't_bill', N'logisticsStatus', N'Input', NULL, N'0', N'0', N'1')
GO

INSERT INTO [dbo].[t_s_column_ui] VALUES (N'93', N't_bill', N'billDate', N'DatePicker', NULL, N'0', N'0', N'1')
GO

INSERT INTO [dbo].[t_s_column_ui] VALUES (N'94', N't_bill', N'totalAmount', N'Input', NULL, N'0', N'0', N'1')
GO

INSERT INTO [dbo].[t_s_column_ui] VALUES (N'95', N't_bill', N'quantity', N'Input', NULL, N'0', N'0', N'1')
GO

INSERT INTO [dbo].[t_s_column_ui] VALUES (N'96', N't_bill', N'outTradeNo', N'Input', NULL, N'0', N'0', N'1')
GO

INSERT INTO [dbo].[t_s_column_ui] VALUES (N'97', N't_bill', N'toMemberName', N'Input', NULL, N'0', N'0', N'1')
GO

INSERT INTO [dbo].[t_s_column_ui] VALUES (N'98', N't_bill', N'toMemberId', N'Input', NULL, N'0', N'0', N'1')
GO

INSERT INTO [dbo].[t_s_column_ui] VALUES (N'99', N't_bill', N'paymentType', N'Input', NULL, N'0', N'0', N'1')
GO

INSERT INTO [dbo].[t_s_column_ui] VALUES (N'100', N't_bill', N'paymentAccountNo', N'Input', NULL, N'0', N'0', N'1')
GO

INSERT INTO [dbo].[t_s_column_ui] VALUES (N'101', N't_bill', N'reason', N'Input', NULL, N'0', N'0', N'1')
GO

INSERT INTO [dbo].[t_s_column_ui] VALUES (N'102', N't_bill', N'integralReward', N'Input', NULL, N'0', N'0', N'1')
GO

INSERT INTO [dbo].[t_s_column_ui] VALUES (N'103', N't_bill', N'remark', N'Input', NULL, N'0', N'0', N'1')
GO

INSERT INTO [dbo].[t_s_column_ui] VALUES (N'104', N't_bill', N'billContext', N'Input', NULL, N'0', N'0', N'1')
GO

INSERT INTO [dbo].[t_s_column_ui] VALUES (N'105', N't_bill', N'userId', N'Input', NULL, N'0', N'0', N'1')
GO

INSERT INTO [dbo].[t_s_column_ui] VALUES (N'106', N't_news_info', N'id', N'Input', NULL, N'0', N'0', N'1')
GO

INSERT INTO [dbo].[t_s_column_ui] VALUES (N'107', N't_news_info', N'createBy', N'Input', NULL, N'0', N'0', N'1')
GO

INSERT INTO [dbo].[t_s_column_ui] VALUES (N'108', N't_news_info', N'createDate', N'DatePicker', NULL, N'0', N'0', N'1')
GO

INSERT INTO [dbo].[t_s_column_ui] VALUES (N'109', N't_news_info', N'updateBy', N'Input', NULL, N'0', N'0', N'1')
GO

INSERT INTO [dbo].[t_s_column_ui] VALUES (N'110', N't_news_info', N'updateDate', N'DatePicker', NULL, N'0', N'0', N'1')
GO

INSERT INTO [dbo].[t_s_column_ui] VALUES (N'111', N't_news_info', N'title', N'Input', NULL, N'0', N'0', N'1')
GO

INSERT INTO [dbo].[t_s_column_ui] VALUES (N'112', N't_news_info', N'userId', N'Input', NULL, N'0', N'0', N'1')
GO

INSERT INTO [dbo].[t_s_column_ui] VALUES (N'113', N't_news_info', N'status', N'Input', NULL, N'0', N'0', N'1')
GO

INSERT INTO [dbo].[t_s_column_ui] VALUES (N'114', N't_news_info', N'content', N'Input', NULL, N'0', N'0', N'1')
GO

INSERT INTO [dbo].[t_s_column_ui] VALUES (N'115', N't_news_info', N'imageUrl', N'Input', NULL, N'0', N'0', N'1')
GO

INSERT INTO [dbo].[t_s_column_ui] VALUES (N'116', N't_news_info', N'publishDate', N'DatePicker', NULL, N'0', N'0', N'1')
GO

INSERT INTO [dbo].[t_s_column_ui] VALUES (N'117', N't_news_info', N'tags', N'Input', NULL, N'0', N'0', N'1')
GO

INSERT INTO [dbo].[t_s_column_ui] VALUES (N'118', N't_news_info', N'newsType', N'Input', NULL, N'0', N'0', N'1')
GO

INSERT INTO [dbo].[t_s_column_ui] VALUES (N'133', N't_s_quartz_job', N'id', N'Input', NULL, N'0', N'0', N'1')
GO

INSERT INTO [dbo].[t_s_column_ui] VALUES (N'134', N't_s_quartz_job', N'createBy', N'Input', NULL, N'0', N'0', N'1')
GO

INSERT INTO [dbo].[t_s_column_ui] VALUES (N'135', N't_s_quartz_job', N'createDate', N'DatePicker', NULL, N'0', N'0', N'1')
GO

INSERT INTO [dbo].[t_s_column_ui] VALUES (N'136', N't_s_quartz_job', N'updateBy', N'Input', NULL, N'0', N'0', N'1')
GO

INSERT INTO [dbo].[t_s_column_ui] VALUES (N'137', N't_s_quartz_job', N'updateDate', N'DatePicker', NULL, N'0', N'0', N'1')
GO

INSERT INTO [dbo].[t_s_column_ui] VALUES (N'138', N't_s_quartz_job', N'cronExpression', N'Input', NULL, N'0', N'0', N'1')
GO

INSERT INTO [dbo].[t_s_column_ui] VALUES (N'139', N't_s_quartz_job', N'methodName', N'Input', NULL, N'0', N'0', N'1')
GO

INSERT INTO [dbo].[t_s_column_ui] VALUES (N'140', N't_s_quartz_job', N'isConcurrent', N'Input', NULL, N'0', N'0', N'1')
GO

INSERT INTO [dbo].[t_s_column_ui] VALUES (N'141', N't_s_quartz_job', N'description', N'Input', NULL, N'0', N'0', N'1')
GO

INSERT INTO [dbo].[t_s_column_ui] VALUES (N'142', N't_s_quartz_job', N'beanName', N'Input', NULL, N'0', N'0', N'1')
GO

INSERT INTO [dbo].[t_s_column_ui] VALUES (N'143', N't_s_quartz_job', N'triggerName', N'Input', NULL, N'0', N'0', N'1')
GO

INSERT INTO [dbo].[t_s_column_ui] VALUES (N'144', N't_s_quartz_job', N'jobStatus', N'Input', NULL, N'0', N'0', N'1')
GO

INSERT INTO [dbo].[t_s_column_ui] VALUES (N'145', N't_s_quartz_job', N'springBean', N'Input', NULL, N'0', N'0', N'1')
GO

INSERT INTO [dbo].[t_s_column_ui] VALUES (N'146', N't_s_quartz_job', N'jobName', N'Input', NULL, N'0', N'0', N'1')
GO


-- ----------------------------
-- Table structure for t_s_country
-- ----------------------------
IF EXISTS (SELECT * FROM sys.all_objects WHERE object_id = OBJECT_ID(N'[dbo].[t_s_country]') AND type IN ('U'))
	DROP TABLE [dbo].[t_s_country]
GO

CREATE TABLE [dbo].[t_s_country] (
  [_id] int  NOT NULL,
  [name] nvarchar(64) COLLATE Chinese_PRC_CI_AS  NULL,
  [country_id] nvarchar(12) COLLATE Chinese_PRC_CI_AS  NULL,
  [city_id] nvarchar(12) COLLATE Chinese_PRC_CI_AS  NULL
)
GO

ALTER TABLE [dbo].[t_s_country] SET (LOCK_ESCALATION = TABLE)
GO


-- ----------------------------
-- Records of t_s_country
-- ----------------------------
INSERT INTO [dbo].[t_s_country] VALUES (N'1', N'东城区', N'110101000000', N'110100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2', N'西城区', N'110102000000', N'110100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3', N'朝阳区', N'110105000000', N'110100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'4', N'丰台区', N'110106000000', N'110100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'5', N'石景山区', N'110107000000', N'110100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'6', N'海淀区', N'110108000000', N'110100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'7', N'门头沟区', N'110109000000', N'110100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'8', N'房山区', N'110111000000', N'110100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'9', N'通州区', N'110112000000', N'110100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'10', N'顺义区', N'110113000000', N'110100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'11', N'昌平区', N'110114000000', N'110100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'12', N'大兴区', N'110115000000', N'110100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'13', N'怀柔区', N'110116000000', N'110100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'14', N'平谷区', N'110117000000', N'110100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'15', N'密云区', N'110118000000', N'110100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'16', N'延庆区', N'110119000000', N'110100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'17', N'和平区', N'120101000000', N'120100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'18', N'河东区', N'120102000000', N'120100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'19', N'河西区', N'120103000000', N'120100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'20', N'南开区', N'120104000000', N'120100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'21', N'河北区', N'120105000000', N'120100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'22', N'红桥区', N'120106000000', N'120100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'23', N'东丽区', N'120110000000', N'120100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'24', N'西青区', N'120111000000', N'120100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'25', N'津南区', N'120112000000', N'120100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'26', N'北辰区', N'120113000000', N'120100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'27', N'武清区', N'120114000000', N'120100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'28', N'宝坻区', N'120115000000', N'120100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'29', N'滨海新区', N'120116000000', N'120100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'30', N'宁河区', N'120117000000', N'120100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'31', N'静海区', N'120118000000', N'120100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'32', N'蓟州区', N'120119000000', N'120100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'33', N'市辖区', N'130101000000', N'130100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'34', N'长安区', N'130102000000', N'130100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'35', N'桥西区', N'130104000000', N'130100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'36', N'新华区', N'130105000000', N'130100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'37', N'井陉矿区', N'130107000000', N'130100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'38', N'裕华区', N'130108000000', N'130100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'39', N'藁城区', N'130109000000', N'130100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'40', N'鹿泉区', N'130110000000', N'130100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'41', N'栾城区', N'130111000000', N'130100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'42', N'井陉县', N'130121000000', N'130100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'43', N'正定县', N'130123000000', N'130100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'44', N'行唐县', N'130125000000', N'130100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'45', N'灵寿县', N'130126000000', N'130100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'46', N'高邑县', N'130127000000', N'130100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'47', N'深泽县', N'130128000000', N'130100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'48', N'赞皇县', N'130129000000', N'130100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'49', N'无极县', N'130130000000', N'130100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'50', N'平山县', N'130131000000', N'130100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'51', N'元氏县', N'130132000000', N'130100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'52', N'赵县', N'130133000000', N'130100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'53', N'石家庄高新技术产业开发区', N'130171000000', N'130100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'54', N'石家庄循环化工园区', N'130172000000', N'130100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'55', N'辛集市', N'130181000000', N'130100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'56', N'晋州市', N'130183000000', N'130100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'57', N'新乐市', N'130184000000', N'130100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'58', N'市辖区', N'130201000000', N'130200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'59', N'路南区', N'130202000000', N'130200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'60', N'路北区', N'130203000000', N'130200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'61', N'古冶区', N'130204000000', N'130200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'62', N'开平区', N'130205000000', N'130200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'63', N'丰南区', N'130207000000', N'130200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'64', N'丰润区', N'130208000000', N'130200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'65', N'曹妃甸区', N'130209000000', N'130200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'66', N'滦南县', N'130224000000', N'130200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'67', N'乐亭县', N'130225000000', N'130200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'68', N'迁西县', N'130227000000', N'130200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'69', N'玉田县', N'130229000000', N'130200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'70', N'唐山市芦台经济技术开发区', N'130271000000', N'130200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'71', N'唐山市汉沽管理区', N'130272000000', N'130200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'72', N'唐山高新技术产业开发区', N'130273000000', N'130200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'73', N'河北唐山海港经济开发区', N'130274000000', N'130200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'74', N'遵化市', N'130281000000', N'130200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'75', N'迁安市', N'130283000000', N'130200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'76', N'滦州市', N'130284000000', N'130200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'77', N'市辖区', N'130301000000', N'130300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'78', N'海港区', N'130302000000', N'130300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'79', N'山海关区', N'130303000000', N'130300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'80', N'北戴河区', N'130304000000', N'130300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'81', N'抚宁区', N'130306000000', N'130300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'82', N'青龙满族自治县', N'130321000000', N'130300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'83', N'昌黎县', N'130322000000', N'130300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'84', N'卢龙县', N'130324000000', N'130300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'85', N'秦皇岛市经济技术开发区', N'130371000000', N'130300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'86', N'北戴河新区', N'130372000000', N'130300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'87', N'市辖区', N'130401000000', N'130400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'88', N'邯山区', N'130402000000', N'130400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'89', N'丛台区', N'130403000000', N'130400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'90', N'复兴区', N'130404000000', N'130400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'91', N'峰峰矿区', N'130406000000', N'130400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'92', N'肥乡区', N'130407000000', N'130400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'93', N'永年区', N'130408000000', N'130400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'94', N'临漳县', N'130423000000', N'130400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'95', N'成安县', N'130424000000', N'130400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'96', N'大名县', N'130425000000', N'130400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'97', N'涉县', N'130426000000', N'130400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'98', N'磁县', N'130427000000', N'130400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'99', N'邱县', N'130430000000', N'130400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'100', N'鸡泽县', N'130431000000', N'130400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'101', N'广平县', N'130432000000', N'130400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'102', N'馆陶县', N'130433000000', N'130400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'103', N'魏县', N'130434000000', N'130400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'104', N'曲周县', N'130435000000', N'130400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'105', N'邯郸经济技术开发区', N'130471000000', N'130400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'106', N'邯郸冀南新区', N'130473000000', N'130400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'107', N'武安市', N'130481000000', N'130400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'108', N'市辖区', N'130501000000', N'130500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'109', N'桥东区', N'130502000000', N'130500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'110', N'桥西区', N'130503000000', N'130500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'111', N'邢台县', N'130521000000', N'130500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'112', N'临城县', N'130522000000', N'130500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'113', N'内丘县', N'130523000000', N'130500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'114', N'柏乡县', N'130524000000', N'130500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'115', N'隆尧县', N'130525000000', N'130500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'116', N'任县', N'130526000000', N'130500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'117', N'南和县', N'130527000000', N'130500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'118', N'宁晋县', N'130528000000', N'130500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'119', N'巨鹿县', N'130529000000', N'130500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'120', N'新河县', N'130530000000', N'130500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'121', N'广宗县', N'130531000000', N'130500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'122', N'平乡县', N'130532000000', N'130500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'123', N'威县', N'130533000000', N'130500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'124', N'清河县', N'130534000000', N'130500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'125', N'临西县', N'130535000000', N'130500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'126', N'河北邢台经济开发区', N'130571000000', N'130500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'127', N'南宫市', N'130581000000', N'130500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'128', N'沙河市', N'130582000000', N'130500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'129', N'市辖区', N'130601000000', N'130600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'130', N'竞秀区', N'130602000000', N'130600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'131', N'莲池区', N'130606000000', N'130600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'132', N'满城区', N'130607000000', N'130600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'133', N'清苑区', N'130608000000', N'130600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'134', N'徐水区', N'130609000000', N'130600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'135', N'涞水县', N'130623000000', N'130600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'136', N'阜平县', N'130624000000', N'130600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'137', N'定兴县', N'130626000000', N'130600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'138', N'唐县', N'130627000000', N'130600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'139', N'高阳县', N'130628000000', N'130600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'140', N'容城县', N'130629000000', N'130600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'141', N'涞源县', N'130630000000', N'130600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'142', N'望都县', N'130631000000', N'130600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'143', N'安新县', N'130632000000', N'130600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'144', N'易县', N'130633000000', N'130600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'145', N'曲阳县', N'130634000000', N'130600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'146', N'蠡县', N'130635000000', N'130600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'147', N'顺平县', N'130636000000', N'130600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'148', N'博野县', N'130637000000', N'130600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'149', N'雄县', N'130638000000', N'130600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'150', N'保定高新技术产业开发区', N'130671000000', N'130600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'151', N'保定白沟新城', N'130672000000', N'130600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'152', N'涿州市', N'130681000000', N'130600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'153', N'定州市', N'130682000000', N'130600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'154', N'安国市', N'130683000000', N'130600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'155', N'高碑店市', N'130684000000', N'130600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'156', N'市辖区', N'130701000000', N'130700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'157', N'桥东区', N'130702000000', N'130700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'158', N'桥西区', N'130703000000', N'130700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'159', N'宣化区', N'130705000000', N'130700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'160', N'下花园区', N'130706000000', N'130700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'161', N'万全区', N'130708000000', N'130700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'162', N'崇礼区', N'130709000000', N'130700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'163', N'张北县', N'130722000000', N'130700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'164', N'康保县', N'130723000000', N'130700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'165', N'沽源县', N'130724000000', N'130700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'166', N'尚义县', N'130725000000', N'130700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'167', N'蔚县', N'130726000000', N'130700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'168', N'阳原县', N'130727000000', N'130700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'169', N'怀安县', N'130728000000', N'130700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'170', N'怀来县', N'130730000000', N'130700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'171', N'涿鹿县', N'130731000000', N'130700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'172', N'赤城县', N'130732000000', N'130700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'173', N'张家口市高新技术产业开发区', N'130771000000', N'130700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'174', N'张家口市察北管理区', N'130772000000', N'130700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'175', N'张家口市塞北管理区', N'130773000000', N'130700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'176', N'市辖区', N'130801000000', N'130800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'177', N'双桥区', N'130802000000', N'130800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'178', N'双滦区', N'130803000000', N'130800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'179', N'鹰手营子矿区', N'130804000000', N'130800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'180', N'承德县', N'130821000000', N'130800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'181', N'兴隆县', N'130822000000', N'130800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'182', N'滦平县', N'130824000000', N'130800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'183', N'隆化县', N'130825000000', N'130800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'184', N'丰宁满族自治县', N'130826000000', N'130800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'185', N'宽城满族自治县', N'130827000000', N'130800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'186', N'围场满族蒙古族自治县', N'130828000000', N'130800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'187', N'承德高新技术产业开发区', N'130871000000', N'130800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'188', N'平泉市', N'130881000000', N'130800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'189', N'市辖区', N'130901000000', N'130900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'190', N'新华区', N'130902000000', N'130900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'191', N'运河区', N'130903000000', N'130900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'192', N'沧县', N'130921000000', N'130900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'193', N'青县', N'130922000000', N'130900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'194', N'东光县', N'130923000000', N'130900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'195', N'海兴县', N'130924000000', N'130900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'196', N'盐山县', N'130925000000', N'130900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'197', N'肃宁县', N'130926000000', N'130900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'198', N'南皮县', N'130927000000', N'130900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'199', N'吴桥县', N'130928000000', N'130900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'200', N'献县', N'130929000000', N'130900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'201', N'孟村回族自治县', N'130930000000', N'130900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'202', N'河北沧州经济开发区', N'130971000000', N'130900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'203', N'沧州高新技术产业开发区', N'130972000000', N'130900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'204', N'沧州渤海新区', N'130973000000', N'130900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'205', N'泊头市', N'130981000000', N'130900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'206', N'任丘市', N'130982000000', N'130900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'207', N'黄骅市', N'130983000000', N'130900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'208', N'河间市', N'130984000000', N'130900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'209', N'市辖区', N'131001000000', N'131000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'210', N'安次区', N'131002000000', N'131000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'211', N'广阳区', N'131003000000', N'131000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'212', N'固安县', N'131022000000', N'131000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'213', N'永清县', N'131023000000', N'131000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'214', N'香河县', N'131024000000', N'131000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'215', N'大城县', N'131025000000', N'131000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'216', N'文安县', N'131026000000', N'131000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'217', N'大厂回族自治县', N'131028000000', N'131000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'218', N'廊坊经济技术开发区', N'131071000000', N'131000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'219', N'霸州市', N'131081000000', N'131000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'220', N'三河市', N'131082000000', N'131000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'221', N'市辖区', N'131101000000', N'131100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'222', N'桃城区', N'131102000000', N'131100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'223', N'冀州区', N'131103000000', N'131100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'224', N'枣强县', N'131121000000', N'131100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'225', N'武邑县', N'131122000000', N'131100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'226', N'武强县', N'131123000000', N'131100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'227', N'饶阳县', N'131124000000', N'131100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'228', N'安平县', N'131125000000', N'131100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'229', N'故城县', N'131126000000', N'131100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'230', N'景县', N'131127000000', N'131100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'231', N'阜城县', N'131128000000', N'131100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'232', N'河北衡水高新技术产业开发区', N'131171000000', N'131100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'233', N'衡水滨湖新区', N'131172000000', N'131100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'234', N'深州市', N'131182000000', N'131100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'235', N'市辖区', N'140101000000', N'140100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'236', N'小店区', N'140105000000', N'140100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'237', N'迎泽区', N'140106000000', N'140100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'238', N'杏花岭区', N'140107000000', N'140100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'239', N'尖草坪区', N'140108000000', N'140100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'240', N'万柏林区', N'140109000000', N'140100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'241', N'晋源区', N'140110000000', N'140100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'242', N'清徐县', N'140121000000', N'140100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'243', N'阳曲县', N'140122000000', N'140100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'244', N'娄烦县', N'140123000000', N'140100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'245', N'山西转型综合改革示范区', N'140171000000', N'140100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'246', N'古交市', N'140181000000', N'140100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'247', N'市辖区', N'140201000000', N'140200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'248', N'新荣区', N'140212000000', N'140200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'249', N'平城区', N'140213000000', N'140200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'250', N'云冈区', N'140214000000', N'140200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'251', N'云州区', N'140215000000', N'140200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'252', N'阳高县', N'140221000000', N'140200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'253', N'天镇县', N'140222000000', N'140200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'254', N'广灵县', N'140223000000', N'140200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'255', N'灵丘县', N'140224000000', N'140200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'256', N'浑源县', N'140225000000', N'140200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'257', N'左云县', N'140226000000', N'140200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'258', N'山西大同经济开发区', N'140271000000', N'140200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'259', N'市辖区', N'140301000000', N'140300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'260', N'城区', N'140302000000', N'140300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'261', N'矿区', N'140303000000', N'140300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'262', N'郊区', N'140311000000', N'140300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'263', N'平定县', N'140321000000', N'140300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'264', N'盂县', N'140322000000', N'140300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'265', N'市辖区', N'140401000000', N'140400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'266', N'潞州区', N'140412000000', N'140400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'267', N'上党区', N'140413000000', N'140400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'268', N'屯留区', N'140414000000', N'140400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'269', N'潞城区', N'140415000000', N'140400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'270', N'襄垣县', N'140423000000', N'140400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'271', N'平顺县', N'140425000000', N'140400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'272', N'黎城县', N'140426000000', N'140400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'273', N'壶关县', N'140427000000', N'140400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'274', N'长子县', N'140428000000', N'140400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'275', N'武乡县', N'140429000000', N'140400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'276', N'沁县', N'140430000000', N'140400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'277', N'沁源县', N'140431000000', N'140400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'278', N'山西长治高新技术产业园区', N'140471000000', N'140400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'279', N'市辖区', N'140501000000', N'140500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'280', N'城区', N'140502000000', N'140500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'281', N'沁水县', N'140521000000', N'140500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'282', N'阳城县', N'140522000000', N'140500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'283', N'陵川县', N'140524000000', N'140500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'284', N'泽州县', N'140525000000', N'140500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'285', N'高平市', N'140581000000', N'140500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'286', N'市辖区', N'140601000000', N'140600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'287', N'朔城区', N'140602000000', N'140600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'288', N'平鲁区', N'140603000000', N'140600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'289', N'山阴县', N'140621000000', N'140600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'290', N'应县', N'140622000000', N'140600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'291', N'右玉县', N'140623000000', N'140600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'292', N'山西朔州经济开发区', N'140671000000', N'140600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'293', N'怀仁市', N'140681000000', N'140600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'294', N'市辖区', N'140701000000', N'140700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'295', N'榆次区', N'140702000000', N'140700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'296', N'榆社县', N'140721000000', N'140700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'297', N'左权县', N'140722000000', N'140700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'298', N'和顺县', N'140723000000', N'140700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'299', N'昔阳县', N'140724000000', N'140700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'300', N'寿阳县', N'140725000000', N'140700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'301', N'太谷县', N'140726000000', N'140700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'302', N'祁县', N'140727000000', N'140700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'303', N'平遥县', N'140728000000', N'140700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'304', N'灵石县', N'140729000000', N'140700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'305', N'介休市', N'140781000000', N'140700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'306', N'市辖区', N'140801000000', N'140800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'307', N'盐湖区', N'140802000000', N'140800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'308', N'临猗县', N'140821000000', N'140800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'309', N'万荣县', N'140822000000', N'140800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'310', N'闻喜县', N'140823000000', N'140800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'311', N'稷山县', N'140824000000', N'140800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'312', N'新绛县', N'140825000000', N'140800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'313', N'绛县', N'140826000000', N'140800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'314', N'垣曲县', N'140827000000', N'140800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'315', N'夏县', N'140828000000', N'140800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'316', N'平陆县', N'140829000000', N'140800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'317', N'芮城县', N'140830000000', N'140800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'318', N'永济市', N'140881000000', N'140800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'319', N'河津市', N'140882000000', N'140800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'320', N'市辖区', N'140901000000', N'140900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'321', N'忻府区', N'140902000000', N'140900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'322', N'定襄县', N'140921000000', N'140900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'323', N'五台县', N'140922000000', N'140900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'324', N'代县', N'140923000000', N'140900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'325', N'繁峙县', N'140924000000', N'140900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'326', N'宁武县', N'140925000000', N'140900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'327', N'静乐县', N'140926000000', N'140900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'328', N'神池县', N'140927000000', N'140900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'329', N'五寨县', N'140928000000', N'140900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'330', N'岢岚县', N'140929000000', N'140900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'331', N'河曲县', N'140930000000', N'140900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'332', N'保德县', N'140931000000', N'140900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'333', N'偏关县', N'140932000000', N'140900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'334', N'五台山风景名胜区', N'140971000000', N'140900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'335', N'原平市', N'140981000000', N'140900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'336', N'市辖区', N'141001000000', N'141000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'337', N'尧都区', N'141002000000', N'141000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'338', N'曲沃县', N'141021000000', N'141000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'339', N'翼城县', N'141022000000', N'141000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'340', N'襄汾县', N'141023000000', N'141000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'341', N'洪洞县', N'141024000000', N'141000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'342', N'古县', N'141025000000', N'141000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'343', N'安泽县', N'141026000000', N'141000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'344', N'浮山县', N'141027000000', N'141000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'345', N'吉县', N'141028000000', N'141000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'346', N'乡宁县', N'141029000000', N'141000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'347', N'大宁县', N'141030000000', N'141000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'348', N'隰县', N'141031000000', N'141000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'349', N'永和县', N'141032000000', N'141000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'350', N'蒲县', N'141033000000', N'141000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'351', N'汾西县', N'141034000000', N'141000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'352', N'侯马市', N'141081000000', N'141000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'353', N'霍州市', N'141082000000', N'141000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'354', N'市辖区', N'141101000000', N'141100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'355', N'离石区', N'141102000000', N'141100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'356', N'文水县', N'141121000000', N'141100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'357', N'交城县', N'141122000000', N'141100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'358', N'兴县', N'141123000000', N'141100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'359', N'临县', N'141124000000', N'141100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'360', N'柳林县', N'141125000000', N'141100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'361', N'石楼县', N'141126000000', N'141100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'362', N'岚县', N'141127000000', N'141100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'363', N'方山县', N'141128000000', N'141100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'364', N'中阳县', N'141129000000', N'141100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'365', N'交口县', N'141130000000', N'141100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'366', N'孝义市', N'141181000000', N'141100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'367', N'汾阳市', N'141182000000', N'141100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'368', N'市辖区', N'150101000000', N'150100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'369', N'新城区', N'150102000000', N'150100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'370', N'回民区', N'150103000000', N'150100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'371', N'玉泉区', N'150104000000', N'150100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'372', N'赛罕区', N'150105000000', N'150100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'373', N'土默特左旗', N'150121000000', N'150100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'374', N'托克托县', N'150122000000', N'150100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'375', N'和林格尔县', N'150123000000', N'150100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'376', N'清水河县', N'150124000000', N'150100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'377', N'武川县', N'150125000000', N'150100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'378', N'呼和浩特金海工业园区', N'150171000000', N'150100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'379', N'呼和浩特经济技术开发区', N'150172000000', N'150100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'380', N'市辖区', N'150201000000', N'150200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'381', N'东河区', N'150202000000', N'150200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'382', N'昆都仑区', N'150203000000', N'150200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'383', N'青山区', N'150204000000', N'150200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'384', N'石拐区', N'150205000000', N'150200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'385', N'白云鄂博矿区', N'150206000000', N'150200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'386', N'九原区', N'150207000000', N'150200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'387', N'土默特右旗', N'150221000000', N'150200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'388', N'固阳县', N'150222000000', N'150200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'389', N'达尔罕茂明安联合旗', N'150223000000', N'150200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'390', N'包头稀土高新技术产业开发区', N'150271000000', N'150200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'391', N'市辖区', N'150301000000', N'150300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'392', N'海勃湾区', N'150302000000', N'150300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'393', N'海南区', N'150303000000', N'150300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'394', N'乌达区', N'150304000000', N'150300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'395', N'市辖区', N'150401000000', N'150400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'396', N'红山区', N'150402000000', N'150400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'397', N'元宝山区', N'150403000000', N'150400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'398', N'松山区', N'150404000000', N'150400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'399', N'阿鲁科尔沁旗', N'150421000000', N'150400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'400', N'巴林左旗', N'150422000000', N'150400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'401', N'巴林右旗', N'150423000000', N'150400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'402', N'林西县', N'150424000000', N'150400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'403', N'克什克腾旗', N'150425000000', N'150400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'404', N'翁牛特旗', N'150426000000', N'150400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'405', N'喀喇沁旗', N'150428000000', N'150400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'406', N'宁城县', N'150429000000', N'150400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'407', N'敖汉旗', N'150430000000', N'150400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'408', N'市辖区', N'150501000000', N'150500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'409', N'科尔沁区', N'150502000000', N'150500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'410', N'科尔沁左翼中旗', N'150521000000', N'150500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'411', N'科尔沁左翼后旗', N'150522000000', N'150500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'412', N'开鲁县', N'150523000000', N'150500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'413', N'库伦旗', N'150524000000', N'150500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'414', N'奈曼旗', N'150525000000', N'150500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'415', N'扎鲁特旗', N'150526000000', N'150500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'416', N'通辽经济技术开发区', N'150571000000', N'150500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'417', N'霍林郭勒市', N'150581000000', N'150500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'418', N'市辖区', N'150601000000', N'150600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'419', N'东胜区', N'150602000000', N'150600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'420', N'康巴什区', N'150603000000', N'150600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'421', N'达拉特旗', N'150621000000', N'150600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'422', N'准格尔旗', N'150622000000', N'150600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'423', N'鄂托克前旗', N'150623000000', N'150600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'424', N'鄂托克旗', N'150624000000', N'150600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'425', N'杭锦旗', N'150625000000', N'150600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'426', N'乌审旗', N'150626000000', N'150600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'427', N'伊金霍洛旗', N'150627000000', N'150600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'428', N'市辖区', N'150701000000', N'150700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'429', N'海拉尔区', N'150702000000', N'150700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'430', N'扎赉诺尔区', N'150703000000', N'150700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'431', N'阿荣旗', N'150721000000', N'150700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'432', N'莫力达瓦达斡尔族自治旗', N'150722000000', N'150700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'433', N'鄂伦春自治旗', N'150723000000', N'150700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'434', N'鄂温克族自治旗', N'150724000000', N'150700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'435', N'陈巴尔虎旗', N'150725000000', N'150700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'436', N'新巴尔虎左旗', N'150726000000', N'150700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'437', N'新巴尔虎右旗', N'150727000000', N'150700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'438', N'满洲里市', N'150781000000', N'150700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'439', N'牙克石市', N'150782000000', N'150700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'440', N'扎兰屯市', N'150783000000', N'150700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'441', N'额尔古纳市', N'150784000000', N'150700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'442', N'根河市', N'150785000000', N'150700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'443', N'市辖区', N'150801000000', N'150800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'444', N'临河区', N'150802000000', N'150800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'445', N'五原县', N'150821000000', N'150800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'446', N'磴口县', N'150822000000', N'150800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'447', N'乌拉特前旗', N'150823000000', N'150800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'448', N'乌拉特中旗', N'150824000000', N'150800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'449', N'乌拉特后旗', N'150825000000', N'150800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'450', N'杭锦后旗', N'150826000000', N'150800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'451', N'市辖区', N'150901000000', N'150900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'452', N'集宁区', N'150902000000', N'150900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'453', N'卓资县', N'150921000000', N'150900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'454', N'化德县', N'150922000000', N'150900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'455', N'商都县', N'150923000000', N'150900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'456', N'兴和县', N'150924000000', N'150900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'457', N'凉城县', N'150925000000', N'150900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'458', N'察哈尔右翼前旗', N'150926000000', N'150900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'459', N'察哈尔右翼中旗', N'150927000000', N'150900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'460', N'察哈尔右翼后旗', N'150928000000', N'150900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'461', N'四子王旗', N'150929000000', N'150900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'462', N'丰镇市', N'150981000000', N'150900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'463', N'乌兰浩特市', N'152201000000', N'152200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'464', N'阿尔山市', N'152202000000', N'152200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'465', N'科尔沁右翼前旗', N'152221000000', N'152200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'466', N'科尔沁右翼中旗', N'152222000000', N'152200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'467', N'扎赉特旗', N'152223000000', N'152200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'468', N'突泉县', N'152224000000', N'152200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'469', N'二连浩特市', N'152501000000', N'152500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'470', N'锡林浩特市', N'152502000000', N'152500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'471', N'阿巴嘎旗', N'152522000000', N'152500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'472', N'苏尼特左旗', N'152523000000', N'152500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'473', N'苏尼特右旗', N'152524000000', N'152500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'474', N'东乌珠穆沁旗', N'152525000000', N'152500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'475', N'西乌珠穆沁旗', N'152526000000', N'152500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'476', N'太仆寺旗', N'152527000000', N'152500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'477', N'镶黄旗', N'152528000000', N'152500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'478', N'正镶白旗', N'152529000000', N'152500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'479', N'正蓝旗', N'152530000000', N'152500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'480', N'多伦县', N'152531000000', N'152500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'481', N'乌拉盖管委会', N'152571000000', N'152500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'482', N'阿拉善左旗', N'152921000000', N'152900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'483', N'阿拉善右旗', N'152922000000', N'152900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'484', N'额济纳旗', N'152923000000', N'152900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'485', N'内蒙古阿拉善经济开发区', N'152971000000', N'152900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'486', N'市辖区', N'210101000000', N'210100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'487', N'和平区', N'210102000000', N'210100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'488', N'沈河区', N'210103000000', N'210100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'489', N'大东区', N'210104000000', N'210100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'490', N'皇姑区', N'210105000000', N'210100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'491', N'铁西区', N'210106000000', N'210100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'492', N'苏家屯区', N'210111000000', N'210100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'493', N'浑南区', N'210112000000', N'210100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'494', N'沈北新区', N'210113000000', N'210100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'495', N'于洪区', N'210114000000', N'210100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'496', N'辽中区', N'210115000000', N'210100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'497', N'康平县', N'210123000000', N'210100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'498', N'法库县', N'210124000000', N'210100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'499', N'新民市', N'210181000000', N'210100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'500', N'市辖区', N'210201000000', N'210200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'501', N'中山区', N'210202000000', N'210200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'502', N'西岗区', N'210203000000', N'210200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'503', N'沙河口区', N'210204000000', N'210200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'504', N'甘井子区', N'210211000000', N'210200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'505', N'旅顺口区', N'210212000000', N'210200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'506', N'金州区', N'210213000000', N'210200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'507', N'普兰店区', N'210214000000', N'210200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'508', N'长海县', N'210224000000', N'210200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'509', N'瓦房店市', N'210281000000', N'210200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'510', N'庄河市', N'210283000000', N'210200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'511', N'市辖区', N'210301000000', N'210300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'512', N'铁东区', N'210302000000', N'210300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'513', N'铁西区', N'210303000000', N'210300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'514', N'立山区', N'210304000000', N'210300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'515', N'千山区', N'210311000000', N'210300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'516', N'台安县', N'210321000000', N'210300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'517', N'岫岩满族自治县', N'210323000000', N'210300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'518', N'海城市', N'210381000000', N'210300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'519', N'市辖区', N'210401000000', N'210400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'520', N'新抚区', N'210402000000', N'210400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'521', N'东洲区', N'210403000000', N'210400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'522', N'望花区', N'210404000000', N'210400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'523', N'顺城区', N'210411000000', N'210400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'524', N'抚顺县', N'210421000000', N'210400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'525', N'新宾满族自治县', N'210422000000', N'210400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'526', N'清原满族自治县', N'210423000000', N'210400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'527', N'市辖区', N'210501000000', N'210500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'528', N'平山区', N'210502000000', N'210500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'529', N'溪湖区', N'210503000000', N'210500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'530', N'明山区', N'210504000000', N'210500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'531', N'南芬区', N'210505000000', N'210500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'532', N'本溪满族自治县', N'210521000000', N'210500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'533', N'桓仁满族自治县', N'210522000000', N'210500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'534', N'市辖区', N'210601000000', N'210600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'535', N'元宝区', N'210602000000', N'210600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'536', N'振兴区', N'210603000000', N'210600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'537', N'振安区', N'210604000000', N'210600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'538', N'宽甸满族自治县', N'210624000000', N'210600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'539', N'东港市', N'210681000000', N'210600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'540', N'凤城市', N'210682000000', N'210600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'541', N'市辖区', N'210701000000', N'210700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'542', N'古塔区', N'210702000000', N'210700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'543', N'凌河区', N'210703000000', N'210700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'544', N'太和区', N'210711000000', N'210700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'545', N'黑山县', N'210726000000', N'210700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'546', N'义县', N'210727000000', N'210700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'547', N'凌海市', N'210781000000', N'210700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'548', N'北镇市', N'210782000000', N'210700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'549', N'市辖区', N'210801000000', N'210800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'550', N'站前区', N'210802000000', N'210800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'551', N'西市区', N'210803000000', N'210800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'552', N'鲅鱼圈区', N'210804000000', N'210800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'553', N'老边区', N'210811000000', N'210800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'554', N'盖州市', N'210881000000', N'210800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'555', N'大石桥市', N'210882000000', N'210800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'556', N'市辖区', N'210901000000', N'210900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'557', N'海州区', N'210902000000', N'210900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'558', N'新邱区', N'210903000000', N'210900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'559', N'太平区', N'210904000000', N'210900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'560', N'清河门区', N'210905000000', N'210900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'561', N'细河区', N'210911000000', N'210900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'562', N'阜新蒙古族自治县', N'210921000000', N'210900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'563', N'彰武县', N'210922000000', N'210900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'564', N'市辖区', N'211001000000', N'211000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'565', N'白塔区', N'211002000000', N'211000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'566', N'文圣区', N'211003000000', N'211000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'567', N'宏伟区', N'211004000000', N'211000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'568', N'弓长岭区', N'211005000000', N'211000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'569', N'太子河区', N'211011000000', N'211000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'570', N'辽阳县', N'211021000000', N'211000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'571', N'灯塔市', N'211081000000', N'211000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'572', N'市辖区', N'211101000000', N'211100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'573', N'双台子区', N'211102000000', N'211100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'574', N'兴隆台区', N'211103000000', N'211100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'575', N'大洼区', N'211104000000', N'211100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'576', N'盘山县', N'211122000000', N'211100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'577', N'市辖区', N'211201000000', N'211200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'578', N'银州区', N'211202000000', N'211200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'579', N'清河区', N'211204000000', N'211200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'580', N'铁岭县', N'211221000000', N'211200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'581', N'西丰县', N'211223000000', N'211200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'582', N'昌图县', N'211224000000', N'211200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'583', N'调兵山市', N'211281000000', N'211200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'584', N'开原市', N'211282000000', N'211200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'585', N'市辖区', N'211301000000', N'211300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'586', N'双塔区', N'211302000000', N'211300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'587', N'龙城区', N'211303000000', N'211300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'588', N'朝阳县', N'211321000000', N'211300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'589', N'建平县', N'211322000000', N'211300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'590', N'喀喇沁左翼蒙古族自治县', N'211324000000', N'211300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'591', N'北票市', N'211381000000', N'211300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'592', N'凌源市', N'211382000000', N'211300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'593', N'市辖区', N'211401000000', N'211400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'594', N'连山区', N'211402000000', N'211400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'595', N'龙港区', N'211403000000', N'211400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'596', N'南票区', N'211404000000', N'211400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'597', N'绥中县', N'211421000000', N'211400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'598', N'建昌县', N'211422000000', N'211400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'599', N'兴城市', N'211481000000', N'211400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'600', N'市辖区', N'220101000000', N'220100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'601', N'南关区', N'220102000000', N'220100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'602', N'宽城区', N'220103000000', N'220100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'603', N'朝阳区', N'220104000000', N'220100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'604', N'二道区', N'220105000000', N'220100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'605', N'绿园区', N'220106000000', N'220100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'606', N'双阳区', N'220112000000', N'220100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'607', N'九台区', N'220113000000', N'220100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'608', N'农安县', N'220122000000', N'220100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'609', N'长春经济技术开发区', N'220171000000', N'220100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'610', N'长春净月高新技术产业开发区', N'220172000000', N'220100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'611', N'长春高新技术产业开发区', N'220173000000', N'220100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'612', N'长春汽车经济技术开发区', N'220174000000', N'220100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'613', N'榆树市', N'220182000000', N'220100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'614', N'德惠市', N'220183000000', N'220100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'615', N'市辖区', N'220201000000', N'220200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'616', N'昌邑区', N'220202000000', N'220200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'617', N'龙潭区', N'220203000000', N'220200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'618', N'船营区', N'220204000000', N'220200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'619', N'丰满区', N'220211000000', N'220200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'620', N'永吉县', N'220221000000', N'220200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'621', N'吉林经济开发区', N'220271000000', N'220200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'622', N'吉林高新技术产业开发区', N'220272000000', N'220200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'623', N'吉林中国新加坡食品区', N'220273000000', N'220200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'624', N'蛟河市', N'220281000000', N'220200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'625', N'桦甸市', N'220282000000', N'220200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'626', N'舒兰市', N'220283000000', N'220200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'627', N'磐石市', N'220284000000', N'220200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'628', N'市辖区', N'220301000000', N'220300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'629', N'铁西区', N'220302000000', N'220300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'630', N'铁东区', N'220303000000', N'220300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'631', N'梨树县', N'220322000000', N'220300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'632', N'伊通满族自治县', N'220323000000', N'220300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'633', N'公主岭市', N'220381000000', N'220300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'634', N'双辽市', N'220382000000', N'220300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'635', N'市辖区', N'220401000000', N'220400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'636', N'龙山区', N'220402000000', N'220400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'637', N'西安区', N'220403000000', N'220400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'638', N'东丰县', N'220421000000', N'220400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'639', N'东辽县', N'220422000000', N'220400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'640', N'市辖区', N'220501000000', N'220500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'641', N'东昌区', N'220502000000', N'220500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'642', N'二道江区', N'220503000000', N'220500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'643', N'通化县', N'220521000000', N'220500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'644', N'辉南县', N'220523000000', N'220500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'645', N'柳河县', N'220524000000', N'220500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'646', N'梅河口市', N'220581000000', N'220500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'647', N'集安市', N'220582000000', N'220500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'648', N'市辖区', N'220601000000', N'220600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'649', N'浑江区', N'220602000000', N'220600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'650', N'江源区', N'220605000000', N'220600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'651', N'抚松县', N'220621000000', N'220600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'652', N'靖宇县', N'220622000000', N'220600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'653', N'长白朝鲜族自治县', N'220623000000', N'220600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'654', N'临江市', N'220681000000', N'220600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'655', N'市辖区', N'220701000000', N'220700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'656', N'宁江区', N'220702000000', N'220700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'657', N'前郭尔罗斯蒙古族自治县', N'220721000000', N'220700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'658', N'长岭县', N'220722000000', N'220700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'659', N'乾安县', N'220723000000', N'220700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'660', N'吉林松原经济开发区', N'220771000000', N'220700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'661', N'扶余市', N'220781000000', N'220700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'662', N'市辖区', N'220801000000', N'220800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'663', N'洮北区', N'220802000000', N'220800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'664', N'镇赉县', N'220821000000', N'220800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'665', N'通榆县', N'220822000000', N'220800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'666', N'吉林白城经济开发区', N'220871000000', N'220800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'667', N'洮南市', N'220881000000', N'220800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'668', N'大安市', N'220882000000', N'220800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'669', N'延吉市', N'222401000000', N'222400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'670', N'图们市', N'222402000000', N'222400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'671', N'敦化市', N'222403000000', N'222400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'672', N'珲春市', N'222404000000', N'222400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'673', N'龙井市', N'222405000000', N'222400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'674', N'和龙市', N'222406000000', N'222400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'675', N'汪清县', N'222424000000', N'222400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'676', N'安图县', N'222426000000', N'222400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'677', N'市辖区', N'230101000000', N'230100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'678', N'道里区', N'230102000000', N'230100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'679', N'南岗区', N'230103000000', N'230100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'680', N'道外区', N'230104000000', N'230100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'681', N'平房区', N'230108000000', N'230100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'682', N'松北区', N'230109000000', N'230100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'683', N'香坊区', N'230110000000', N'230100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'684', N'呼兰区', N'230111000000', N'230100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'685', N'阿城区', N'230112000000', N'230100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'686', N'双城区', N'230113000000', N'230100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'687', N'依兰县', N'230123000000', N'230100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'688', N'方正县', N'230124000000', N'230100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'689', N'宾县', N'230125000000', N'230100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'690', N'巴彦县', N'230126000000', N'230100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'691', N'木兰县', N'230127000000', N'230100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'692', N'通河县', N'230128000000', N'230100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'693', N'延寿县', N'230129000000', N'230100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'694', N'尚志市', N'230183000000', N'230100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'695', N'五常市', N'230184000000', N'230100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'696', N'市辖区', N'230201000000', N'230200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'697', N'龙沙区', N'230202000000', N'230200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'698', N'建华区', N'230203000000', N'230200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'699', N'铁锋区', N'230204000000', N'230200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'700', N'昂昂溪区', N'230205000000', N'230200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'701', N'富拉尔基区', N'230206000000', N'230200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'702', N'碾子山区', N'230207000000', N'230200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'703', N'梅里斯达斡尔族区', N'230208000000', N'230200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'704', N'龙江县', N'230221000000', N'230200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'705', N'依安县', N'230223000000', N'230200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'706', N'泰来县', N'230224000000', N'230200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'707', N'甘南县', N'230225000000', N'230200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'708', N'富裕县', N'230227000000', N'230200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'709', N'克山县', N'230229000000', N'230200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'710', N'克东县', N'230230000000', N'230200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'711', N'拜泉县', N'230231000000', N'230200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'712', N'讷河市', N'230281000000', N'230200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'713', N'市辖区', N'230301000000', N'230300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'714', N'鸡冠区', N'230302000000', N'230300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'715', N'恒山区', N'230303000000', N'230300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'716', N'滴道区', N'230304000000', N'230300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'717', N'梨树区', N'230305000000', N'230300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'718', N'城子河区', N'230306000000', N'230300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'719', N'麻山区', N'230307000000', N'230300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'720', N'鸡东县', N'230321000000', N'230300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'721', N'虎林市', N'230381000000', N'230300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'722', N'密山市', N'230382000000', N'230300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'723', N'市辖区', N'230401000000', N'230400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'724', N'向阳区', N'230402000000', N'230400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'725', N'工农区', N'230403000000', N'230400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'726', N'南山区', N'230404000000', N'230400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'727', N'兴安区', N'230405000000', N'230400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'728', N'东山区', N'230406000000', N'230400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'729', N'兴山区', N'230407000000', N'230400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'730', N'萝北县', N'230421000000', N'230400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'731', N'绥滨县', N'230422000000', N'230400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'732', N'市辖区', N'230501000000', N'230500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'733', N'尖山区', N'230502000000', N'230500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'734', N'岭东区', N'230503000000', N'230500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'735', N'四方台区', N'230505000000', N'230500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'736', N'宝山区', N'230506000000', N'230500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'737', N'集贤县', N'230521000000', N'230500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'738', N'友谊县', N'230522000000', N'230500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'739', N'宝清县', N'230523000000', N'230500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'740', N'饶河县', N'230524000000', N'230500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'741', N'市辖区', N'230601000000', N'230600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'742', N'萨尔图区', N'230602000000', N'230600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'743', N'龙凤区', N'230603000000', N'230600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'744', N'让胡路区', N'230604000000', N'230600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'745', N'红岗区', N'230605000000', N'230600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'746', N'大同区', N'230606000000', N'230600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'747', N'肇州县', N'230621000000', N'230600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'748', N'肇源县', N'230622000000', N'230600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'749', N'林甸县', N'230623000000', N'230600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'750', N'杜尔伯特蒙古族自治县', N'230624000000', N'230600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'751', N'大庆高新技术产业开发区', N'230671000000', N'230600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'752', N'市辖区', N'230701000000', N'230700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'753', N'伊春区', N'230702000000', N'230700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'754', N'南岔区', N'230703000000', N'230700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'755', N'友好区', N'230704000000', N'230700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'756', N'西林区', N'230705000000', N'230700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'757', N'翠峦区', N'230706000000', N'230700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'758', N'新青区', N'230707000000', N'230700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'759', N'美溪区', N'230708000000', N'230700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'760', N'金山屯区', N'230709000000', N'230700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'761', N'五营区', N'230710000000', N'230700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'762', N'乌马河区', N'230711000000', N'230700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'763', N'汤旺河区', N'230712000000', N'230700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'764', N'带岭区', N'230713000000', N'230700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'765', N'乌伊岭区', N'230714000000', N'230700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'766', N'红星区', N'230715000000', N'230700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'767', N'上甘岭区', N'230716000000', N'230700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'768', N'嘉荫县', N'230722000000', N'230700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'769', N'铁力市', N'230781000000', N'230700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'770', N'市辖区', N'230801000000', N'230800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'771', N'向阳区', N'230803000000', N'230800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'772', N'前进区', N'230804000000', N'230800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'773', N'东风区', N'230805000000', N'230800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'774', N'郊区', N'230811000000', N'230800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'775', N'桦南县', N'230822000000', N'230800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'776', N'桦川县', N'230826000000', N'230800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'777', N'汤原县', N'230828000000', N'230800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'778', N'同江市', N'230881000000', N'230800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'779', N'富锦市', N'230882000000', N'230800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'780', N'抚远市', N'230883000000', N'230800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'781', N'市辖区', N'230901000000', N'230900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'782', N'新兴区', N'230902000000', N'230900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'783', N'桃山区', N'230903000000', N'230900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'784', N'茄子河区', N'230904000000', N'230900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'785', N'勃利县', N'230921000000', N'230900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'786', N'市辖区', N'231001000000', N'231000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'787', N'东安区', N'231002000000', N'231000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'788', N'阳明区', N'231003000000', N'231000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'789', N'爱民区', N'231004000000', N'231000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'790', N'西安区', N'231005000000', N'231000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'791', N'林口县', N'231025000000', N'231000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'792', N'牡丹江经济技术开发区', N'231071000000', N'231000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'793', N'绥芬河市', N'231081000000', N'231000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'794', N'海林市', N'231083000000', N'231000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'795', N'宁安市', N'231084000000', N'231000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'796', N'穆棱市', N'231085000000', N'231000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'797', N'东宁市', N'231086000000', N'231000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'798', N'市辖区', N'231101000000', N'231100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'799', N'爱辉区', N'231102000000', N'231100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'800', N'嫩江县', N'231121000000', N'231100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'801', N'逊克县', N'231123000000', N'231100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'802', N'孙吴县', N'231124000000', N'231100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'803', N'北安市', N'231181000000', N'231100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'804', N'五大连池市', N'231182000000', N'231100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'805', N'市辖区', N'231201000000', N'231200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'806', N'北林区', N'231202000000', N'231200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'807', N'望奎县', N'231221000000', N'231200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'808', N'兰西县', N'231222000000', N'231200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'809', N'青冈县', N'231223000000', N'231200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'810', N'庆安县', N'231224000000', N'231200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'811', N'明水县', N'231225000000', N'231200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'812', N'绥棱县', N'231226000000', N'231200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'813', N'安达市', N'231281000000', N'231200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'814', N'肇东市', N'231282000000', N'231200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'815', N'海伦市', N'231283000000', N'231200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'816', N'漠河市', N'232701000000', N'232700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'817', N'呼玛县', N'232721000000', N'232700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'818', N'塔河县', N'232722000000', N'232700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'819', N'加格达奇区', N'232761000000', N'232700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'820', N'松岭区', N'232762000000', N'232700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'821', N'新林区', N'232763000000', N'232700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'822', N'呼中区', N'232764000000', N'232700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'823', N'黄浦区', N'310101000000', N'310100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'824', N'徐汇区', N'310104000000', N'310100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'825', N'长宁区', N'310105000000', N'310100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'826', N'静安区', N'310106000000', N'310100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'827', N'普陀区', N'310107000000', N'310100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'828', N'虹口区', N'310109000000', N'310100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'829', N'杨浦区', N'310110000000', N'310100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'830', N'闵行区', N'310112000000', N'310100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'831', N'宝山区', N'310113000000', N'310100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'832', N'嘉定区', N'310114000000', N'310100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'833', N'浦东新区', N'310115000000', N'310100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'834', N'金山区', N'310116000000', N'310100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'835', N'松江区', N'310117000000', N'310100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'836', N'青浦区', N'310118000000', N'310100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'837', N'奉贤区', N'310120000000', N'310100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'838', N'崇明区', N'310151000000', N'310100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'839', N'市辖区', N'320101000000', N'320100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'840', N'玄武区', N'320102000000', N'320100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'841', N'秦淮区', N'320104000000', N'320100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'842', N'建邺区', N'320105000000', N'320100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'843', N'鼓楼区', N'320106000000', N'320100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'844', N'浦口区', N'320111000000', N'320100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'845', N'栖霞区', N'320113000000', N'320100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'846', N'雨花台区', N'320114000000', N'320100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'847', N'江宁区', N'320115000000', N'320100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'848', N'六合区', N'320116000000', N'320100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'849', N'溧水区', N'320117000000', N'320100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'850', N'高淳区', N'320118000000', N'320100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'851', N'市辖区', N'320201000000', N'320200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'852', N'锡山区', N'320205000000', N'320200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'853', N'惠山区', N'320206000000', N'320200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'854', N'滨湖区', N'320211000000', N'320200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'855', N'梁溪区', N'320213000000', N'320200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'856', N'新吴区', N'320214000000', N'320200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'857', N'江阴市', N'320281000000', N'320200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'858', N'宜兴市', N'320282000000', N'320200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'859', N'市辖区', N'320301000000', N'320300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'860', N'鼓楼区', N'320302000000', N'320300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'861', N'云龙区', N'320303000000', N'320300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'862', N'贾汪区', N'320305000000', N'320300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'863', N'泉山区', N'320311000000', N'320300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'864', N'铜山区', N'320312000000', N'320300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'865', N'丰县', N'320321000000', N'320300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'866', N'沛县', N'320322000000', N'320300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'867', N'睢宁县', N'320324000000', N'320300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'868', N'徐州经济技术开发区', N'320371000000', N'320300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'869', N'新沂市', N'320381000000', N'320300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'870', N'邳州市', N'320382000000', N'320300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'871', N'市辖区', N'320401000000', N'320400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'872', N'天宁区', N'320402000000', N'320400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'873', N'钟楼区', N'320404000000', N'320400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'874', N'新北区', N'320411000000', N'320400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'875', N'武进区', N'320412000000', N'320400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'876', N'金坛区', N'320413000000', N'320400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'877', N'溧阳市', N'320481000000', N'320400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'878', N'市辖区', N'320501000000', N'320500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'879', N'虎丘区', N'320505000000', N'320500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'880', N'吴中区', N'320506000000', N'320500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'881', N'相城区', N'320507000000', N'320500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'882', N'姑苏区', N'320508000000', N'320500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'883', N'吴江区', N'320509000000', N'320500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'884', N'苏州工业园区', N'320571000000', N'320500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'885', N'常熟市', N'320581000000', N'320500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'886', N'张家港市', N'320582000000', N'320500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'887', N'昆山市', N'320583000000', N'320500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'888', N'太仓市', N'320585000000', N'320500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'889', N'市辖区', N'320601000000', N'320600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'890', N'崇川区', N'320602000000', N'320600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'891', N'港闸区', N'320611000000', N'320600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'892', N'通州区', N'320612000000', N'320600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'893', N'如东县', N'320623000000', N'320600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'894', N'南通经济技术开发区', N'320671000000', N'320600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'895', N'启东市', N'320681000000', N'320600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'896', N'如皋市', N'320682000000', N'320600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'897', N'海门市', N'320684000000', N'320600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'898', N'海安市', N'320685000000', N'320600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'899', N'市辖区', N'320701000000', N'320700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'900', N'连云区', N'320703000000', N'320700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'901', N'海州区', N'320706000000', N'320700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'902', N'赣榆区', N'320707000000', N'320700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'903', N'东海县', N'320722000000', N'320700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'904', N'灌云县', N'320723000000', N'320700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'905', N'灌南县', N'320724000000', N'320700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'906', N'连云港经济技术开发区', N'320771000000', N'320700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'907', N'连云港高新技术产业开发区', N'320772000000', N'320700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'908', N'市辖区', N'320801000000', N'320800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'909', N'淮安区', N'320803000000', N'320800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'910', N'淮阴区', N'320804000000', N'320800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'911', N'清江浦区', N'320812000000', N'320800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'912', N'洪泽区', N'320813000000', N'320800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'913', N'涟水县', N'320826000000', N'320800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'914', N'盱眙县', N'320830000000', N'320800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'915', N'金湖县', N'320831000000', N'320800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'916', N'淮安经济技术开发区', N'320871000000', N'320800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'917', N'市辖区', N'320901000000', N'320900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'918', N'亭湖区', N'320902000000', N'320900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'919', N'盐都区', N'320903000000', N'320900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'920', N'大丰区', N'320904000000', N'320900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'921', N'响水县', N'320921000000', N'320900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'922', N'滨海县', N'320922000000', N'320900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'923', N'阜宁县', N'320923000000', N'320900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'924', N'射阳县', N'320924000000', N'320900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'925', N'建湖县', N'320925000000', N'320900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'926', N'盐城经济技术开发区', N'320971000000', N'320900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'927', N'东台市', N'320981000000', N'320900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'928', N'市辖区', N'321001000000', N'321000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'929', N'广陵区', N'321002000000', N'321000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'930', N'邗江区', N'321003000000', N'321000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'931', N'江都区', N'321012000000', N'321000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'932', N'宝应县', N'321023000000', N'321000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'933', N'扬州经济技术开发区', N'321071000000', N'321000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'934', N'仪征市', N'321081000000', N'321000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'935', N'高邮市', N'321084000000', N'321000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'936', N'市辖区', N'321101000000', N'321100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'937', N'京口区', N'321102000000', N'321100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'938', N'润州区', N'321111000000', N'321100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'939', N'丹徒区', N'321112000000', N'321100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'940', N'镇江新区', N'321171000000', N'321100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'941', N'丹阳市', N'321181000000', N'321100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'942', N'扬中市', N'321182000000', N'321100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'943', N'句容市', N'321183000000', N'321100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'944', N'市辖区', N'321201000000', N'321200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'945', N'海陵区', N'321202000000', N'321200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'946', N'高港区', N'321203000000', N'321200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'947', N'姜堰区', N'321204000000', N'321200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'948', N'泰州医药高新技术产业开发区', N'321271000000', N'321200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'949', N'兴化市', N'321281000000', N'321200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'950', N'靖江市', N'321282000000', N'321200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'951', N'泰兴市', N'321283000000', N'321200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'952', N'市辖区', N'321301000000', N'321300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'953', N'宿城区', N'321302000000', N'321300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'954', N'宿豫区', N'321311000000', N'321300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'955', N'沭阳县', N'321322000000', N'321300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'956', N'泗阳县', N'321323000000', N'321300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'957', N'泗洪县', N'321324000000', N'321300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'958', N'宿迁经济技术开发区', N'321371000000', N'321300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'959', N'市辖区', N'330101000000', N'330100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'960', N'上城区', N'330102000000', N'330100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'961', N'下城区', N'330103000000', N'330100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'962', N'江干区', N'330104000000', N'330100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'963', N'拱墅区', N'330105000000', N'330100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'964', N'西湖区', N'330106000000', N'330100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'965', N'滨江区', N'330108000000', N'330100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'966', N'萧山区', N'330109000000', N'330100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'967', N'余杭区', N'330110000000', N'330100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'968', N'富阳区', N'330111000000', N'330100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'969', N'临安区', N'330112000000', N'330100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'970', N'桐庐县', N'330122000000', N'330100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'971', N'淳安县', N'330127000000', N'330100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'972', N'建德市', N'330182000000', N'330100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'973', N'市辖区', N'330201000000', N'330200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'974', N'海曙区', N'330203000000', N'330200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'975', N'江北区', N'330205000000', N'330200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'976', N'北仑区', N'330206000000', N'330200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'977', N'镇海区', N'330211000000', N'330200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'978', N'鄞州区', N'330212000000', N'330200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'979', N'奉化区', N'330213000000', N'330200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'980', N'象山县', N'330225000000', N'330200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'981', N'宁海县', N'330226000000', N'330200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'982', N'余姚市', N'330281000000', N'330200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'983', N'慈溪市', N'330282000000', N'330200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'984', N'市辖区', N'330301000000', N'330300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'985', N'鹿城区', N'330302000000', N'330300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'986', N'龙湾区', N'330303000000', N'330300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'987', N'瓯海区', N'330304000000', N'330300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'988', N'洞头区', N'330305000000', N'330300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'989', N'永嘉县', N'330324000000', N'330300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'990', N'平阳县', N'330326000000', N'330300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'991', N'苍南县', N'330327000000', N'330300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'992', N'文成县', N'330328000000', N'330300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'993', N'泰顺县', N'330329000000', N'330300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'994', N'温州经济技术开发区', N'330371000000', N'330300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'995', N'瑞安市', N'330381000000', N'330300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'996', N'乐清市', N'330382000000', N'330300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'997', N'市辖区', N'330401000000', N'330400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'998', N'南湖区', N'330402000000', N'330400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'999', N'秀洲区', N'330411000000', N'330400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1000', N'嘉善县', N'330421000000', N'330400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1001', N'海盐县', N'330424000000', N'330400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1002', N'海宁市', N'330481000000', N'330400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1003', N'平湖市', N'330482000000', N'330400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1004', N'桐乡市', N'330483000000', N'330400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1005', N'市辖区', N'330501000000', N'330500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1006', N'吴兴区', N'330502000000', N'330500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1007', N'南浔区', N'330503000000', N'330500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1008', N'德清县', N'330521000000', N'330500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1009', N'长兴县', N'330522000000', N'330500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1010', N'安吉县', N'330523000000', N'330500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1011', N'市辖区', N'330601000000', N'330600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1012', N'越城区', N'330602000000', N'330600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1013', N'柯桥区', N'330603000000', N'330600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1014', N'上虞区', N'330604000000', N'330600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1015', N'新昌县', N'330624000000', N'330600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1016', N'诸暨市', N'330681000000', N'330600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1017', N'嵊州市', N'330683000000', N'330600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1018', N'市辖区', N'330701000000', N'330700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1019', N'婺城区', N'330702000000', N'330700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1020', N'金东区', N'330703000000', N'330700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1021', N'武义县', N'330723000000', N'330700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1022', N'浦江县', N'330726000000', N'330700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1023', N'磐安县', N'330727000000', N'330700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1024', N'兰溪市', N'330781000000', N'330700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1025', N'义乌市', N'330782000000', N'330700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1026', N'东阳市', N'330783000000', N'330700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1027', N'永康市', N'330784000000', N'330700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1028', N'市辖区', N'330801000000', N'330800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1029', N'柯城区', N'330802000000', N'330800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1030', N'衢江区', N'330803000000', N'330800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1031', N'常山县', N'330822000000', N'330800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1032', N'开化县', N'330824000000', N'330800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1033', N'龙游县', N'330825000000', N'330800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1034', N'江山市', N'330881000000', N'330800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1035', N'市辖区', N'330901000000', N'330900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1036', N'定海区', N'330902000000', N'330900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1037', N'普陀区', N'330903000000', N'330900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1038', N'岱山县', N'330921000000', N'330900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1039', N'嵊泗县', N'330922000000', N'330900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1040', N'市辖区', N'331001000000', N'331000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1041', N'椒江区', N'331002000000', N'331000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1042', N'黄岩区', N'331003000000', N'331000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1043', N'路桥区', N'331004000000', N'331000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1044', N'三门县', N'331022000000', N'331000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1045', N'天台县', N'331023000000', N'331000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1046', N'仙居县', N'331024000000', N'331000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1047', N'温岭市', N'331081000000', N'331000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1048', N'临海市', N'331082000000', N'331000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1049', N'玉环市', N'331083000000', N'331000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1050', N'市辖区', N'331101000000', N'331100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1051', N'莲都区', N'331102000000', N'331100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1052', N'青田县', N'331121000000', N'331100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1053', N'缙云县', N'331122000000', N'331100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1054', N'遂昌县', N'331123000000', N'331100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1055', N'松阳县', N'331124000000', N'331100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1056', N'云和县', N'331125000000', N'331100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1057', N'庆元县', N'331126000000', N'331100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1058', N'景宁畲族自治县', N'331127000000', N'331100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1059', N'龙泉市', N'331181000000', N'331100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1060', N'市辖区', N'340101000000', N'340100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1061', N'瑶海区', N'340102000000', N'340100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1062', N'庐阳区', N'340103000000', N'340100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1063', N'蜀山区', N'340104000000', N'340100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1064', N'包河区', N'340111000000', N'340100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1065', N'长丰县', N'340121000000', N'340100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1066', N'肥东县', N'340122000000', N'340100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1067', N'肥西县', N'340123000000', N'340100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1068', N'庐江县', N'340124000000', N'340100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1069', N'合肥高新技术产业开发区', N'340171000000', N'340100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1070', N'合肥经济技术开发区', N'340172000000', N'340100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1071', N'合肥新站高新技术产业开发区', N'340173000000', N'340100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1072', N'巢湖市', N'340181000000', N'340100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1073', N'市辖区', N'340201000000', N'340200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1074', N'镜湖区', N'340202000000', N'340200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1075', N'弋江区', N'340203000000', N'340200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1076', N'鸠江区', N'340207000000', N'340200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1077', N'三山区', N'340208000000', N'340200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1078', N'芜湖县', N'340221000000', N'340200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1079', N'繁昌县', N'340222000000', N'340200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1080', N'南陵县', N'340223000000', N'340200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1081', N'无为县', N'340225000000', N'340200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1082', N'芜湖经济技术开发区', N'340271000000', N'340200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1083', N'安徽芜湖长江大桥经济开发区', N'340272000000', N'340200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1084', N'市辖区', N'340301000000', N'340300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1085', N'龙子湖区', N'340302000000', N'340300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1086', N'蚌山区', N'340303000000', N'340300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1087', N'禹会区', N'340304000000', N'340300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1088', N'淮上区', N'340311000000', N'340300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1089', N'怀远县', N'340321000000', N'340300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1090', N'五河县', N'340322000000', N'340300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1091', N'固镇县', N'340323000000', N'340300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1092', N'蚌埠市高新技术开发区', N'340371000000', N'340300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1093', N'蚌埠市经济开发区', N'340372000000', N'340300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1094', N'市辖区', N'340401000000', N'340400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1095', N'大通区', N'340402000000', N'340400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1096', N'田家庵区', N'340403000000', N'340400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1097', N'谢家集区', N'340404000000', N'340400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1098', N'八公山区', N'340405000000', N'340400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1099', N'潘集区', N'340406000000', N'340400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1100', N'凤台县', N'340421000000', N'340400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1101', N'寿县', N'340422000000', N'340400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1102', N'市辖区', N'340501000000', N'340500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1103', N'花山区', N'340503000000', N'340500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1104', N'雨山区', N'340504000000', N'340500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1105', N'博望区', N'340506000000', N'340500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1106', N'当涂县', N'340521000000', N'340500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1107', N'含山县', N'340522000000', N'340500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1108', N'和县', N'340523000000', N'340500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1109', N'市辖区', N'340601000000', N'340600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1110', N'杜集区', N'340602000000', N'340600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1111', N'相山区', N'340603000000', N'340600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1112', N'烈山区', N'340604000000', N'340600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1113', N'濉溪县', N'340621000000', N'340600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1114', N'市辖区', N'340701000000', N'340700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1115', N'铜官区', N'340705000000', N'340700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1116', N'义安区', N'340706000000', N'340700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1117', N'郊区', N'340711000000', N'340700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1118', N'枞阳县', N'340722000000', N'340700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1119', N'市辖区', N'340801000000', N'340800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1120', N'迎江区', N'340802000000', N'340800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1121', N'大观区', N'340803000000', N'340800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1122', N'宜秀区', N'340811000000', N'340800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1123', N'怀宁县', N'340822000000', N'340800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1124', N'太湖县', N'340825000000', N'340800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1125', N'宿松县', N'340826000000', N'340800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1126', N'望江县', N'340827000000', N'340800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1127', N'岳西县', N'340828000000', N'340800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1128', N'安徽安庆经济开发区', N'340871000000', N'340800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1129', N'桐城市', N'340881000000', N'340800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1130', N'潜山市', N'340882000000', N'340800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1131', N'市辖区', N'341001000000', N'341000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1132', N'屯溪区', N'341002000000', N'341000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1133', N'黄山区', N'341003000000', N'341000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1134', N'徽州区', N'341004000000', N'341000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1135', N'歙县', N'341021000000', N'341000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1136', N'休宁县', N'341022000000', N'341000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1137', N'黟县', N'341023000000', N'341000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1138', N'祁门县', N'341024000000', N'341000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1139', N'市辖区', N'341101000000', N'341100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1140', N'琅琊区', N'341102000000', N'341100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1141', N'南谯区', N'341103000000', N'341100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1142', N'来安县', N'341122000000', N'341100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1143', N'全椒县', N'341124000000', N'341100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1144', N'定远县', N'341125000000', N'341100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1145', N'凤阳县', N'341126000000', N'341100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1146', N'苏滁现代产业园', N'341171000000', N'341100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1147', N'滁州经济技术开发区', N'341172000000', N'341100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1148', N'天长市', N'341181000000', N'341100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1149', N'明光市', N'341182000000', N'341100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1150', N'市辖区', N'341201000000', N'341200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1151', N'颍州区', N'341202000000', N'341200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1152', N'颍东区', N'341203000000', N'341200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1153', N'颍泉区', N'341204000000', N'341200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1154', N'临泉县', N'341221000000', N'341200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1155', N'太和县', N'341222000000', N'341200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1156', N'阜南县', N'341225000000', N'341200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1157', N'颍上县', N'341226000000', N'341200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1158', N'阜阳合肥现代产业园区', N'341271000000', N'341200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1159', N'阜阳经济技术开发区', N'341272000000', N'341200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1160', N'界首市', N'341282000000', N'341200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1161', N'市辖区', N'341301000000', N'341300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1162', N'埇桥区', N'341302000000', N'341300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1163', N'砀山县', N'341321000000', N'341300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1164', N'萧县', N'341322000000', N'341300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1165', N'灵璧县', N'341323000000', N'341300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1166', N'泗县', N'341324000000', N'341300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1167', N'宿州马鞍山现代产业园区', N'341371000000', N'341300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1168', N'宿州经济技术开发区', N'341372000000', N'341300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1169', N'市辖区', N'341501000000', N'341500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1170', N'金安区', N'341502000000', N'341500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1171', N'裕安区', N'341503000000', N'341500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1172', N'叶集区', N'341504000000', N'341500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1173', N'霍邱县', N'341522000000', N'341500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1174', N'舒城县', N'341523000000', N'341500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1175', N'金寨县', N'341524000000', N'341500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1176', N'霍山县', N'341525000000', N'341500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1177', N'市辖区', N'341601000000', N'341600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1178', N'谯城区', N'341602000000', N'341600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1179', N'涡阳县', N'341621000000', N'341600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1180', N'蒙城县', N'341622000000', N'341600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1181', N'利辛县', N'341623000000', N'341600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1182', N'市辖区', N'341701000000', N'341700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1183', N'贵池区', N'341702000000', N'341700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1184', N'东至县', N'341721000000', N'341700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1185', N'石台县', N'341722000000', N'341700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1186', N'青阳县', N'341723000000', N'341700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1187', N'市辖区', N'341801000000', N'341800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1188', N'宣州区', N'341802000000', N'341800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1189', N'郎溪县', N'341821000000', N'341800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1190', N'广德县', N'341822000000', N'341800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1191', N'泾县', N'341823000000', N'341800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1192', N'绩溪县', N'341824000000', N'341800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1193', N'旌德县', N'341825000000', N'341800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1194', N'宣城市经济开发区', N'341871000000', N'341800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1195', N'宁国市', N'341881000000', N'341800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1196', N'市辖区', N'350101000000', N'350100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1197', N'鼓楼区', N'350102000000', N'350100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1198', N'台江区', N'350103000000', N'350100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1199', N'仓山区', N'350104000000', N'350100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1200', N'马尾区', N'350105000000', N'350100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1201', N'晋安区', N'350111000000', N'350100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1202', N'长乐区', N'350112000000', N'350100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1203', N'闽侯县', N'350121000000', N'350100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1204', N'连江县', N'350122000000', N'350100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1205', N'罗源县', N'350123000000', N'350100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1206', N'闽清县', N'350124000000', N'350100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1207', N'永泰县', N'350125000000', N'350100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1208', N'平潭县', N'350128000000', N'350100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1209', N'福清市', N'350181000000', N'350100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1210', N'市辖区', N'350201000000', N'350200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1211', N'思明区', N'350203000000', N'350200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1212', N'海沧区', N'350205000000', N'350200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1213', N'湖里区', N'350206000000', N'350200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1214', N'集美区', N'350211000000', N'350200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1215', N'同安区', N'350212000000', N'350200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1216', N'翔安区', N'350213000000', N'350200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1217', N'市辖区', N'350301000000', N'350300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1218', N'城厢区', N'350302000000', N'350300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1219', N'涵江区', N'350303000000', N'350300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1220', N'荔城区', N'350304000000', N'350300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1221', N'秀屿区', N'350305000000', N'350300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1222', N'仙游县', N'350322000000', N'350300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1223', N'市辖区', N'350401000000', N'350400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1224', N'梅列区', N'350402000000', N'350400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1225', N'三元区', N'350403000000', N'350400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1226', N'明溪县', N'350421000000', N'350400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1227', N'清流县', N'350423000000', N'350400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1228', N'宁化县', N'350424000000', N'350400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1229', N'大田县', N'350425000000', N'350400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1230', N'尤溪县', N'350426000000', N'350400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1231', N'沙县', N'350427000000', N'350400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1232', N'将乐县', N'350428000000', N'350400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1233', N'泰宁县', N'350429000000', N'350400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1234', N'建宁县', N'350430000000', N'350400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1235', N'永安市', N'350481000000', N'350400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1236', N'市辖区', N'350501000000', N'350500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1237', N'鲤城区', N'350502000000', N'350500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1238', N'丰泽区', N'350503000000', N'350500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1239', N'洛江区', N'350504000000', N'350500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1240', N'泉港区', N'350505000000', N'350500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1241', N'惠安县', N'350521000000', N'350500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1242', N'安溪县', N'350524000000', N'350500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1243', N'永春县', N'350525000000', N'350500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1244', N'德化县', N'350526000000', N'350500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1245', N'金门县', N'350527000000', N'350500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1246', N'石狮市', N'350581000000', N'350500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1247', N'晋江市', N'350582000000', N'350500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1248', N'南安市', N'350583000000', N'350500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1249', N'市辖区', N'350601000000', N'350600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1250', N'芗城区', N'350602000000', N'350600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1251', N'龙文区', N'350603000000', N'350600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1252', N'云霄县', N'350622000000', N'350600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1253', N'漳浦县', N'350623000000', N'350600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1254', N'诏安县', N'350624000000', N'350600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1255', N'长泰县', N'350625000000', N'350600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1256', N'东山县', N'350626000000', N'350600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1257', N'南靖县', N'350627000000', N'350600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1258', N'平和县', N'350628000000', N'350600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1259', N'华安县', N'350629000000', N'350600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1260', N'龙海市', N'350681000000', N'350600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1261', N'市辖区', N'350701000000', N'350700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1262', N'延平区', N'350702000000', N'350700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1263', N'建阳区', N'350703000000', N'350700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1264', N'顺昌县', N'350721000000', N'350700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1265', N'浦城县', N'350722000000', N'350700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1266', N'光泽县', N'350723000000', N'350700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1267', N'松溪县', N'350724000000', N'350700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1268', N'政和县', N'350725000000', N'350700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1269', N'邵武市', N'350781000000', N'350700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1270', N'武夷山市', N'350782000000', N'350700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1271', N'建瓯市', N'350783000000', N'350700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1272', N'市辖区', N'350801000000', N'350800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1273', N'新罗区', N'350802000000', N'350800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1274', N'永定区', N'350803000000', N'350800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1275', N'长汀县', N'350821000000', N'350800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1276', N'上杭县', N'350823000000', N'350800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1277', N'武平县', N'350824000000', N'350800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1278', N'连城县', N'350825000000', N'350800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1279', N'漳平市', N'350881000000', N'350800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1280', N'市辖区', N'350901000000', N'350900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1281', N'蕉城区', N'350902000000', N'350900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1282', N'霞浦县', N'350921000000', N'350900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1283', N'古田县', N'350922000000', N'350900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1284', N'屏南县', N'350923000000', N'350900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1285', N'寿宁县', N'350924000000', N'350900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1286', N'周宁县', N'350925000000', N'350900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1287', N'柘荣县', N'350926000000', N'350900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1288', N'福安市', N'350981000000', N'350900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1289', N'福鼎市', N'350982000000', N'350900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1290', N'市辖区', N'360101000000', N'360100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1291', N'东湖区', N'360102000000', N'360100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1292', N'西湖区', N'360103000000', N'360100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1293', N'青云谱区', N'360104000000', N'360100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1294', N'湾里区', N'360105000000', N'360100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1295', N'青山湖区', N'360111000000', N'360100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1296', N'新建区', N'360112000000', N'360100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1297', N'南昌县', N'360121000000', N'360100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1298', N'安义县', N'360123000000', N'360100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1299', N'进贤县', N'360124000000', N'360100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1300', N'市辖区', N'360201000000', N'360200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1301', N'昌江区', N'360202000000', N'360200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1302', N'珠山区', N'360203000000', N'360200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1303', N'浮梁县', N'360222000000', N'360200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1304', N'乐平市', N'360281000000', N'360200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1305', N'市辖区', N'360301000000', N'360300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1306', N'安源区', N'360302000000', N'360300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1307', N'湘东区', N'360313000000', N'360300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1308', N'莲花县', N'360321000000', N'360300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1309', N'上栗县', N'360322000000', N'360300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1310', N'芦溪县', N'360323000000', N'360300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1311', N'市辖区', N'360401000000', N'360400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1312', N'濂溪区', N'360402000000', N'360400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1313', N'浔阳区', N'360403000000', N'360400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1314', N'柴桑区', N'360404000000', N'360400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1315', N'武宁县', N'360423000000', N'360400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1316', N'修水县', N'360424000000', N'360400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1317', N'永修县', N'360425000000', N'360400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1318', N'德安县', N'360426000000', N'360400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1319', N'都昌县', N'360428000000', N'360400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1320', N'湖口县', N'360429000000', N'360400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1321', N'彭泽县', N'360430000000', N'360400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1322', N'瑞昌市', N'360481000000', N'360400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1323', N'共青城市', N'360482000000', N'360400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1324', N'庐山市', N'360483000000', N'360400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1325', N'市辖区', N'360501000000', N'360500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1326', N'渝水区', N'360502000000', N'360500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1327', N'分宜县', N'360521000000', N'360500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1328', N'市辖区', N'360601000000', N'360600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1329', N'月湖区', N'360602000000', N'360600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1330', N'余江区', N'360603000000', N'360600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1331', N'贵溪市', N'360681000000', N'360600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1332', N'市辖区', N'360701000000', N'360700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1333', N'章贡区', N'360702000000', N'360700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1334', N'南康区', N'360703000000', N'360700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1335', N'赣县区', N'360704000000', N'360700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1336', N'信丰县', N'360722000000', N'360700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1337', N'大余县', N'360723000000', N'360700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1338', N'上犹县', N'360724000000', N'360700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1339', N'崇义县', N'360725000000', N'360700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1340', N'安远县', N'360726000000', N'360700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1341', N'龙南县', N'360727000000', N'360700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1342', N'定南县', N'360728000000', N'360700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1343', N'全南县', N'360729000000', N'360700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1344', N'宁都县', N'360730000000', N'360700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1345', N'于都县', N'360731000000', N'360700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1346', N'兴国县', N'360732000000', N'360700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1347', N'会昌县', N'360733000000', N'360700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1348', N'寻乌县', N'360734000000', N'360700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1349', N'石城县', N'360735000000', N'360700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1350', N'瑞金市', N'360781000000', N'360700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1351', N'市辖区', N'360801000000', N'360800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1352', N'吉州区', N'360802000000', N'360800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1353', N'青原区', N'360803000000', N'360800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1354', N'吉安县', N'360821000000', N'360800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1355', N'吉水县', N'360822000000', N'360800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1356', N'峡江县', N'360823000000', N'360800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1357', N'新干县', N'360824000000', N'360800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1358', N'永丰县', N'360825000000', N'360800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1359', N'泰和县', N'360826000000', N'360800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1360', N'遂川县', N'360827000000', N'360800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1361', N'万安县', N'360828000000', N'360800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1362', N'安福县', N'360829000000', N'360800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1363', N'永新县', N'360830000000', N'360800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1364', N'井冈山市', N'360881000000', N'360800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1365', N'市辖区', N'360901000000', N'360900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1366', N'袁州区', N'360902000000', N'360900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1367', N'奉新县', N'360921000000', N'360900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1368', N'万载县', N'360922000000', N'360900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1369', N'上高县', N'360923000000', N'360900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1370', N'宜丰县', N'360924000000', N'360900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1371', N'靖安县', N'360925000000', N'360900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1372', N'铜鼓县', N'360926000000', N'360900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1373', N'丰城市', N'360981000000', N'360900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1374', N'樟树市', N'360982000000', N'360900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1375', N'高安市', N'360983000000', N'360900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1376', N'市辖区', N'361001000000', N'361000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1377', N'临川区', N'361002000000', N'361000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1378', N'东乡区', N'361003000000', N'361000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1379', N'南城县', N'361021000000', N'361000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1380', N'黎川县', N'361022000000', N'361000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1381', N'南丰县', N'361023000000', N'361000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1382', N'崇仁县', N'361024000000', N'361000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1383', N'乐安县', N'361025000000', N'361000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1384', N'宜黄县', N'361026000000', N'361000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1385', N'金溪县', N'361027000000', N'361000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1386', N'资溪县', N'361028000000', N'361000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1387', N'广昌县', N'361030000000', N'361000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1388', N'市辖区', N'361101000000', N'361100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1389', N'信州区', N'361102000000', N'361100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1390', N'广丰区', N'361103000000', N'361100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1391', N'上饶县', N'361121000000', N'361100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1392', N'玉山县', N'361123000000', N'361100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1393', N'铅山县', N'361124000000', N'361100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1394', N'横峰县', N'361125000000', N'361100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1395', N'弋阳县', N'361126000000', N'361100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1396', N'余干县', N'361127000000', N'361100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1397', N'鄱阳县', N'361128000000', N'361100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1398', N'万年县', N'361129000000', N'361100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1399', N'婺源县', N'361130000000', N'361100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1400', N'德兴市', N'361181000000', N'361100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1401', N'市辖区', N'370101000000', N'370100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1402', N'历下区', N'370102000000', N'370100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1403', N'市中区', N'370103000000', N'370100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1404', N'槐荫区', N'370104000000', N'370100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1405', N'天桥区', N'370105000000', N'370100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1406', N'历城区', N'370112000000', N'370100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1407', N'长清区', N'370113000000', N'370100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1408', N'章丘区', N'370114000000', N'370100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1409', N'济阳区', N'370115000000', N'370100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1410', N'平阴县', N'370124000000', N'370100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1411', N'商河县', N'370126000000', N'370100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1412', N'济南高新技术产业开发区', N'370171000000', N'370100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1413', N'市辖区', N'370201000000', N'370200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1414', N'市南区', N'370202000000', N'370200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1415', N'市北区', N'370203000000', N'370200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1416', N'黄岛区', N'370211000000', N'370200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1417', N'崂山区', N'370212000000', N'370200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1418', N'李沧区', N'370213000000', N'370200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1419', N'城阳区', N'370214000000', N'370200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1420', N'即墨区', N'370215000000', N'370200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1421', N'青岛高新技术产业开发区', N'370271000000', N'370200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1422', N'胶州市', N'370281000000', N'370200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1423', N'平度市', N'370283000000', N'370200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1424', N'莱西市', N'370285000000', N'370200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1425', N'市辖区', N'370301000000', N'370300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1426', N'淄川区', N'370302000000', N'370300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1427', N'张店区', N'370303000000', N'370300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1428', N'博山区', N'370304000000', N'370300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1429', N'临淄区', N'370305000000', N'370300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1430', N'周村区', N'370306000000', N'370300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1431', N'桓台县', N'370321000000', N'370300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1432', N'高青县', N'370322000000', N'370300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1433', N'沂源县', N'370323000000', N'370300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1434', N'市辖区', N'370401000000', N'370400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1435', N'市中区', N'370402000000', N'370400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1436', N'薛城区', N'370403000000', N'370400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1437', N'峄城区', N'370404000000', N'370400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1438', N'台儿庄区', N'370405000000', N'370400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1439', N'山亭区', N'370406000000', N'370400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1440', N'滕州市', N'370481000000', N'370400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1441', N'市辖区', N'370501000000', N'370500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1442', N'东营区', N'370502000000', N'370500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1443', N'河口区', N'370503000000', N'370500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1444', N'垦利区', N'370505000000', N'370500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1445', N'利津县', N'370522000000', N'370500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1446', N'广饶县', N'370523000000', N'370500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1447', N'东营经济技术开发区', N'370571000000', N'370500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1448', N'东营港经济开发区', N'370572000000', N'370500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1449', N'市辖区', N'370601000000', N'370600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1450', N'芝罘区', N'370602000000', N'370600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1451', N'福山区', N'370611000000', N'370600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1452', N'牟平区', N'370612000000', N'370600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1453', N'莱山区', N'370613000000', N'370600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1454', N'长岛县', N'370634000000', N'370600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1455', N'烟台高新技术产业开发区', N'370671000000', N'370600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1456', N'烟台经济技术开发区', N'370672000000', N'370600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1457', N'龙口市', N'370681000000', N'370600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1458', N'莱阳市', N'370682000000', N'370600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1459', N'莱州市', N'370683000000', N'370600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1460', N'蓬莱市', N'370684000000', N'370600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1461', N'招远市', N'370685000000', N'370600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1462', N'栖霞市', N'370686000000', N'370600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1463', N'海阳市', N'370687000000', N'370600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1464', N'市辖区', N'370701000000', N'370700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1465', N'潍城区', N'370702000000', N'370700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1466', N'寒亭区', N'370703000000', N'370700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1467', N'坊子区', N'370704000000', N'370700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1468', N'奎文区', N'370705000000', N'370700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1469', N'临朐县', N'370724000000', N'370700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1470', N'昌乐县', N'370725000000', N'370700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1471', N'潍坊滨海经济技术开发区', N'370772000000', N'370700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1472', N'青州市', N'370781000000', N'370700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1473', N'诸城市', N'370782000000', N'370700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1474', N'寿光市', N'370783000000', N'370700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1475', N'安丘市', N'370784000000', N'370700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1476', N'高密市', N'370785000000', N'370700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1477', N'昌邑市', N'370786000000', N'370700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1478', N'市辖区', N'370801000000', N'370800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1479', N'任城区', N'370811000000', N'370800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1480', N'兖州区', N'370812000000', N'370800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1481', N'微山县', N'370826000000', N'370800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1482', N'鱼台县', N'370827000000', N'370800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1483', N'金乡县', N'370828000000', N'370800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1484', N'嘉祥县', N'370829000000', N'370800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1485', N'汶上县', N'370830000000', N'370800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1486', N'泗水县', N'370831000000', N'370800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1487', N'梁山县', N'370832000000', N'370800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1488', N'济宁高新技术产业开发区', N'370871000000', N'370800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1489', N'曲阜市', N'370881000000', N'370800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1490', N'邹城市', N'370883000000', N'370800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1491', N'市辖区', N'370901000000', N'370900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1492', N'泰山区', N'370902000000', N'370900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1493', N'岱岳区', N'370911000000', N'370900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1494', N'宁阳县', N'370921000000', N'370900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1495', N'东平县', N'370923000000', N'370900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1496', N'新泰市', N'370982000000', N'370900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1497', N'肥城市', N'370983000000', N'370900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1498', N'市辖区', N'371001000000', N'371000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1499', N'环翠区', N'371002000000', N'371000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1500', N'文登区', N'371003000000', N'371000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1501', N'威海火炬高技术产业开发区', N'371071000000', N'371000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1502', N'威海经济技术开发区', N'371072000000', N'371000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1503', N'威海临港经济技术开发区', N'371073000000', N'371000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1504', N'荣成市', N'371082000000', N'371000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1505', N'乳山市', N'371083000000', N'371000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1506', N'市辖区', N'371101000000', N'371100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1507', N'东港区', N'371102000000', N'371100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1508', N'岚山区', N'371103000000', N'371100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1509', N'五莲县', N'371121000000', N'371100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1510', N'莒县', N'371122000000', N'371100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1511', N'日照经济技术开发区', N'371171000000', N'371100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1512', N'市辖区', N'371201000000', N'371200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1513', N'莱城区', N'371202000000', N'371200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1514', N'钢城区', N'371203000000', N'371200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1515', N'市辖区', N'371301000000', N'371300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1516', N'兰山区', N'371302000000', N'371300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1517', N'罗庄区', N'371311000000', N'371300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1518', N'河东区', N'371312000000', N'371300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1519', N'沂南县', N'371321000000', N'371300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1520', N'郯城县', N'371322000000', N'371300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1521', N'沂水县', N'371323000000', N'371300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1522', N'兰陵县', N'371324000000', N'371300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1523', N'费县', N'371325000000', N'371300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1524', N'平邑县', N'371326000000', N'371300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1525', N'莒南县', N'371327000000', N'371300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1526', N'蒙阴县', N'371328000000', N'371300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1527', N'临沭县', N'371329000000', N'371300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1528', N'临沂高新技术产业开发区', N'371371000000', N'371300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1529', N'临沂经济技术开发区', N'371372000000', N'371300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1530', N'临沂临港经济开发区', N'371373000000', N'371300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1531', N'市辖区', N'371401000000', N'371400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1532', N'德城区', N'371402000000', N'371400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1533', N'陵城区', N'371403000000', N'371400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1534', N'宁津县', N'371422000000', N'371400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1535', N'庆云县', N'371423000000', N'371400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1536', N'临邑县', N'371424000000', N'371400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1537', N'齐河县', N'371425000000', N'371400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1538', N'平原县', N'371426000000', N'371400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1539', N'夏津县', N'371427000000', N'371400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1540', N'武城县', N'371428000000', N'371400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1541', N'德州经济技术开发区', N'371471000000', N'371400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1542', N'德州运河经济开发区', N'371472000000', N'371400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1543', N'乐陵市', N'371481000000', N'371400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1544', N'禹城市', N'371482000000', N'371400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1545', N'市辖区', N'371501000000', N'371500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1546', N'东昌府区', N'371502000000', N'371500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1547', N'阳谷县', N'371521000000', N'371500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1548', N'莘县', N'371522000000', N'371500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1549', N'茌平县', N'371523000000', N'371500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1550', N'东阿县', N'371524000000', N'371500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1551', N'冠县', N'371525000000', N'371500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1552', N'高唐县', N'371526000000', N'371500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1553', N'临清市', N'371581000000', N'371500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1554', N'市辖区', N'371601000000', N'371600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1555', N'滨城区', N'371602000000', N'371600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1556', N'沾化区', N'371603000000', N'371600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1557', N'惠民县', N'371621000000', N'371600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1558', N'阳信县', N'371622000000', N'371600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1559', N'无棣县', N'371623000000', N'371600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1560', N'博兴县', N'371625000000', N'371600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1561', N'邹平市', N'371681000000', N'371600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1562', N'市辖区', N'371701000000', N'371700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1563', N'牡丹区', N'371702000000', N'371700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1564', N'定陶区', N'371703000000', N'371700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1565', N'曹县', N'371721000000', N'371700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1566', N'单县', N'371722000000', N'371700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1567', N'成武县', N'371723000000', N'371700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1568', N'巨野县', N'371724000000', N'371700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1569', N'郓城县', N'371725000000', N'371700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1570', N'鄄城县', N'371726000000', N'371700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1571', N'东明县', N'371728000000', N'371700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1572', N'菏泽经济技术开发区', N'371771000000', N'371700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1573', N'菏泽高新技术开发区', N'371772000000', N'371700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1574', N'市辖区', N'410101000000', N'410100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1575', N'中原区', N'410102000000', N'410100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1576', N'二七区', N'410103000000', N'410100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1577', N'管城回族区', N'410104000000', N'410100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1578', N'金水区', N'410105000000', N'410100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1579', N'上街区', N'410106000000', N'410100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1580', N'惠济区', N'410108000000', N'410100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1581', N'中牟县', N'410122000000', N'410100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1582', N'郑州经济技术开发区', N'410171000000', N'410100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1583', N'郑州高新技术产业开发区', N'410172000000', N'410100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1584', N'郑州航空港经济综合实验区', N'410173000000', N'410100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1585', N'巩义市', N'410181000000', N'410100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1586', N'荥阳市', N'410182000000', N'410100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1587', N'新密市', N'410183000000', N'410100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1588', N'新郑市', N'410184000000', N'410100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1589', N'登封市', N'410185000000', N'410100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1590', N'市辖区', N'410201000000', N'410200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1591', N'龙亭区', N'410202000000', N'410200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1592', N'顺河回族区', N'410203000000', N'410200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1593', N'鼓楼区', N'410204000000', N'410200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1594', N'禹王台区', N'410205000000', N'410200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1595', N'祥符区', N'410212000000', N'410200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1596', N'杞县', N'410221000000', N'410200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1597', N'通许县', N'410222000000', N'410200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1598', N'尉氏县', N'410223000000', N'410200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1599', N'兰考县', N'410225000000', N'410200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1600', N'市辖区', N'410301000000', N'410300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1601', N'老城区', N'410302000000', N'410300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1602', N'西工区', N'410303000000', N'410300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1603', N'瀍河回族区', N'410304000000', N'410300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1604', N'涧西区', N'410305000000', N'410300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1605', N'吉利区', N'410306000000', N'410300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1606', N'洛龙区', N'410311000000', N'410300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1607', N'孟津县', N'410322000000', N'410300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1608', N'新安县', N'410323000000', N'410300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1609', N'栾川县', N'410324000000', N'410300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1610', N'嵩县', N'410325000000', N'410300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1611', N'汝阳县', N'410326000000', N'410300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1612', N'宜阳县', N'410327000000', N'410300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1613', N'洛宁县', N'410328000000', N'410300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1614', N'伊川县', N'410329000000', N'410300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1615', N'洛阳高新技术产业开发区', N'410371000000', N'410300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1616', N'偃师市', N'410381000000', N'410300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1617', N'市辖区', N'410401000000', N'410400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1618', N'新华区', N'410402000000', N'410400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1619', N'卫东区', N'410403000000', N'410400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1620', N'石龙区', N'410404000000', N'410400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1621', N'湛河区', N'410411000000', N'410400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1622', N'宝丰县', N'410421000000', N'410400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1623', N'叶县', N'410422000000', N'410400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1624', N'鲁山县', N'410423000000', N'410400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1625', N'郏县', N'410425000000', N'410400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1626', N'平顶山高新技术产业开发区', N'410471000000', N'410400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1627', N'平顶山市新城区', N'410472000000', N'410400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1628', N'舞钢市', N'410481000000', N'410400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1629', N'汝州市', N'410482000000', N'410400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1630', N'市辖区', N'410501000000', N'410500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1631', N'文峰区', N'410502000000', N'410500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1632', N'北关区', N'410503000000', N'410500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1633', N'殷都区', N'410505000000', N'410500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1634', N'龙安区', N'410506000000', N'410500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1635', N'安阳县', N'410522000000', N'410500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1636', N'汤阴县', N'410523000000', N'410500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1637', N'滑县', N'410526000000', N'410500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1638', N'内黄县', N'410527000000', N'410500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1639', N'安阳高新技术产业开发区', N'410571000000', N'410500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1640', N'林州市', N'410581000000', N'410500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1641', N'市辖区', N'410601000000', N'410600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1642', N'鹤山区', N'410602000000', N'410600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1643', N'山城区', N'410603000000', N'410600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1644', N'淇滨区', N'410611000000', N'410600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1645', N'浚县', N'410621000000', N'410600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1646', N'淇县', N'410622000000', N'410600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1647', N'鹤壁经济技术开发区', N'410671000000', N'410600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1648', N'市辖区', N'410701000000', N'410700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1649', N'红旗区', N'410702000000', N'410700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1650', N'卫滨区', N'410703000000', N'410700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1651', N'凤泉区', N'410704000000', N'410700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1652', N'牧野区', N'410711000000', N'410700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1653', N'新乡县', N'410721000000', N'410700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1654', N'获嘉县', N'410724000000', N'410700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1655', N'原阳县', N'410725000000', N'410700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1656', N'延津县', N'410726000000', N'410700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1657', N'封丘县', N'410727000000', N'410700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1658', N'长垣县', N'410728000000', N'410700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1659', N'新乡高新技术产业开发区', N'410771000000', N'410700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1660', N'新乡经济技术开发区', N'410772000000', N'410700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1661', N'新乡市平原城乡一体化示范区', N'410773000000', N'410700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1662', N'卫辉市', N'410781000000', N'410700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1663', N'辉县市', N'410782000000', N'410700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1664', N'市辖区', N'410801000000', N'410800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1665', N'解放区', N'410802000000', N'410800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1666', N'中站区', N'410803000000', N'410800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1667', N'马村区', N'410804000000', N'410800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1668', N'山阳区', N'410811000000', N'410800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1669', N'修武县', N'410821000000', N'410800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1670', N'博爱县', N'410822000000', N'410800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1671', N'武陟县', N'410823000000', N'410800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1672', N'温县', N'410825000000', N'410800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1673', N'焦作城乡一体化示范区', N'410871000000', N'410800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1674', N'沁阳市', N'410882000000', N'410800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1675', N'孟州市', N'410883000000', N'410800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1676', N'市辖区', N'410901000000', N'410900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1677', N'华龙区', N'410902000000', N'410900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1678', N'清丰县', N'410922000000', N'410900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1679', N'南乐县', N'410923000000', N'410900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1680', N'范县', N'410926000000', N'410900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1681', N'台前县', N'410927000000', N'410900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1682', N'濮阳县', N'410928000000', N'410900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1683', N'河南濮阳工业园区', N'410971000000', N'410900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1684', N'濮阳经济技术开发区', N'410972000000', N'410900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1685', N'市辖区', N'411001000000', N'411000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1686', N'魏都区', N'411002000000', N'411000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1687', N'建安区', N'411003000000', N'411000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1688', N'鄢陵县', N'411024000000', N'411000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1689', N'襄城县', N'411025000000', N'411000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1690', N'许昌经济技术开发区', N'411071000000', N'411000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1691', N'禹州市', N'411081000000', N'411000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1692', N'长葛市', N'411082000000', N'411000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1693', N'市辖区', N'411101000000', N'411100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1694', N'源汇区', N'411102000000', N'411100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1695', N'郾城区', N'411103000000', N'411100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1696', N'召陵区', N'411104000000', N'411100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1697', N'舞阳县', N'411121000000', N'411100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1698', N'临颍县', N'411122000000', N'411100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1699', N'漯河经济技术开发区', N'411171000000', N'411100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1700', N'市辖区', N'411201000000', N'411200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1701', N'湖滨区', N'411202000000', N'411200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1702', N'陕州区', N'411203000000', N'411200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1703', N'渑池县', N'411221000000', N'411200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1704', N'卢氏县', N'411224000000', N'411200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1705', N'河南三门峡经济开发区', N'411271000000', N'411200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1706', N'义马市', N'411281000000', N'411200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1707', N'灵宝市', N'411282000000', N'411200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1708', N'市辖区', N'411301000000', N'411300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1709', N'宛城区', N'411302000000', N'411300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1710', N'卧龙区', N'411303000000', N'411300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1711', N'南召县', N'411321000000', N'411300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1712', N'方城县', N'411322000000', N'411300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1713', N'西峡县', N'411323000000', N'411300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1714', N'镇平县', N'411324000000', N'411300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1715', N'内乡县', N'411325000000', N'411300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1716', N'淅川县', N'411326000000', N'411300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1717', N'社旗县', N'411327000000', N'411300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1718', N'唐河县', N'411328000000', N'411300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1719', N'新野县', N'411329000000', N'411300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1720', N'桐柏县', N'411330000000', N'411300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1721', N'南阳高新技术产业开发区', N'411371000000', N'411300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1722', N'南阳市城乡一体化示范区', N'411372000000', N'411300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1723', N'邓州市', N'411381000000', N'411300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1724', N'市辖区', N'411401000000', N'411400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1725', N'梁园区', N'411402000000', N'411400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1726', N'睢阳区', N'411403000000', N'411400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1727', N'民权县', N'411421000000', N'411400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1728', N'睢县', N'411422000000', N'411400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1729', N'宁陵县', N'411423000000', N'411400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1730', N'柘城县', N'411424000000', N'411400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1731', N'虞城县', N'411425000000', N'411400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1732', N'夏邑县', N'411426000000', N'411400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1733', N'豫东综合物流产业聚集区', N'411471000000', N'411400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1734', N'河南商丘经济开发区', N'411472000000', N'411400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1735', N'永城市', N'411481000000', N'411400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1736', N'市辖区', N'411501000000', N'411500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1737', N'浉河区', N'411502000000', N'411500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1738', N'平桥区', N'411503000000', N'411500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1739', N'罗山县', N'411521000000', N'411500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1740', N'光山县', N'411522000000', N'411500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1741', N'新县', N'411523000000', N'411500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1742', N'商城县', N'411524000000', N'411500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1743', N'固始县', N'411525000000', N'411500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1744', N'潢川县', N'411526000000', N'411500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1745', N'淮滨县', N'411527000000', N'411500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1746', N'息县', N'411528000000', N'411500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1747', N'信阳高新技术产业开发区', N'411571000000', N'411500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1748', N'市辖区', N'411601000000', N'411600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1749', N'川汇区', N'411602000000', N'411600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1750', N'扶沟县', N'411621000000', N'411600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1751', N'西华县', N'411622000000', N'411600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1752', N'商水县', N'411623000000', N'411600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1753', N'沈丘县', N'411624000000', N'411600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1754', N'郸城县', N'411625000000', N'411600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1755', N'淮阳县', N'411626000000', N'411600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1756', N'太康县', N'411627000000', N'411600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1757', N'鹿邑县', N'411628000000', N'411600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1758', N'河南周口经济开发区', N'411671000000', N'411600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1759', N'项城市', N'411681000000', N'411600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1760', N'市辖区', N'411701000000', N'411700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1761', N'驿城区', N'411702000000', N'411700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1762', N'西平县', N'411721000000', N'411700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1763', N'上蔡县', N'411722000000', N'411700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1764', N'平舆县', N'411723000000', N'411700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1765', N'正阳县', N'411724000000', N'411700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1766', N'确山县', N'411725000000', N'411700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1767', N'泌阳县', N'411726000000', N'411700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1768', N'汝南县', N'411727000000', N'411700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1769', N'遂平县', N'411728000000', N'411700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1770', N'新蔡县', N'411729000000', N'411700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1771', N'河南驻马店经济开发区', N'411771000000', N'411700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1772', N'济源市', N'419001000000', N'419000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1773', N'市辖区', N'420101000000', N'420100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1774', N'江岸区', N'420102000000', N'420100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1775', N'江汉区', N'420103000000', N'420100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1776', N'硚口区', N'420104000000', N'420100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1777', N'汉阳区', N'420105000000', N'420100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1778', N'武昌区', N'420106000000', N'420100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1779', N'青山区', N'420107000000', N'420100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1780', N'洪山区', N'420111000000', N'420100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1781', N'东西湖区', N'420112000000', N'420100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1782', N'汉南区', N'420113000000', N'420100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1783', N'蔡甸区', N'420114000000', N'420100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1784', N'江夏区', N'420115000000', N'420100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1785', N'黄陂区', N'420116000000', N'420100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1786', N'新洲区', N'420117000000', N'420100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1787', N'市辖区', N'420201000000', N'420200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1788', N'黄石港区', N'420202000000', N'420200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1789', N'西塞山区', N'420203000000', N'420200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1790', N'下陆区', N'420204000000', N'420200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1791', N'铁山区', N'420205000000', N'420200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1792', N'阳新县', N'420222000000', N'420200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1793', N'大冶市', N'420281000000', N'420200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1794', N'市辖区', N'420301000000', N'420300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1795', N'茅箭区', N'420302000000', N'420300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1796', N'张湾区', N'420303000000', N'420300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1797', N'郧阳区', N'420304000000', N'420300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1798', N'郧西县', N'420322000000', N'420300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1799', N'竹山县', N'420323000000', N'420300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1800', N'竹溪县', N'420324000000', N'420300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1801', N'房县', N'420325000000', N'420300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1802', N'丹江口市', N'420381000000', N'420300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1803', N'市辖区', N'420501000000', N'420500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1804', N'西陵区', N'420502000000', N'420500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1805', N'伍家岗区', N'420503000000', N'420500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1806', N'点军区', N'420504000000', N'420500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1807', N'猇亭区', N'420505000000', N'420500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1808', N'夷陵区', N'420506000000', N'420500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1809', N'远安县', N'420525000000', N'420500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1810', N'兴山县', N'420526000000', N'420500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1811', N'秭归县', N'420527000000', N'420500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1812', N'长阳土家族自治县', N'420528000000', N'420500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1813', N'五峰土家族自治县', N'420529000000', N'420500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1814', N'宜都市', N'420581000000', N'420500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1815', N'当阳市', N'420582000000', N'420500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1816', N'枝江市', N'420583000000', N'420500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1817', N'市辖区', N'420601000000', N'420600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1818', N'襄城区', N'420602000000', N'420600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1819', N'樊城区', N'420606000000', N'420600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1820', N'襄州区', N'420607000000', N'420600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1821', N'南漳县', N'420624000000', N'420600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1822', N'谷城县', N'420625000000', N'420600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1823', N'保康县', N'420626000000', N'420600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1824', N'老河口市', N'420682000000', N'420600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1825', N'枣阳市', N'420683000000', N'420600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1826', N'宜城市', N'420684000000', N'420600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1827', N'市辖区', N'420701000000', N'420700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1828', N'梁子湖区', N'420702000000', N'420700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1829', N'华容区', N'420703000000', N'420700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1830', N'鄂城区', N'420704000000', N'420700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1831', N'市辖区', N'420801000000', N'420800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1832', N'东宝区', N'420802000000', N'420800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1833', N'掇刀区', N'420804000000', N'420800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1834', N'沙洋县', N'420822000000', N'420800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1835', N'钟祥市', N'420881000000', N'420800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1836', N'京山市', N'420882000000', N'420800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1837', N'市辖区', N'420901000000', N'420900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1838', N'孝南区', N'420902000000', N'420900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1839', N'孝昌县', N'420921000000', N'420900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1840', N'大悟县', N'420922000000', N'420900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1841', N'云梦县', N'420923000000', N'420900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1842', N'应城市', N'420981000000', N'420900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1843', N'安陆市', N'420982000000', N'420900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1844', N'汉川市', N'420984000000', N'420900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1845', N'市辖区', N'421001000000', N'421000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1846', N'沙市区', N'421002000000', N'421000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1847', N'荆州区', N'421003000000', N'421000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1848', N'公安县', N'421022000000', N'421000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1849', N'监利县', N'421023000000', N'421000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1850', N'江陵县', N'421024000000', N'421000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1851', N'荆州经济技术开发区', N'421071000000', N'421000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1852', N'石首市', N'421081000000', N'421000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1853', N'洪湖市', N'421083000000', N'421000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1854', N'松滋市', N'421087000000', N'421000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1855', N'市辖区', N'421101000000', N'421100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1856', N'黄州区', N'421102000000', N'421100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1857', N'团风县', N'421121000000', N'421100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1858', N'红安县', N'421122000000', N'421100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1859', N'罗田县', N'421123000000', N'421100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1860', N'英山县', N'421124000000', N'421100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1861', N'浠水县', N'421125000000', N'421100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1862', N'蕲春县', N'421126000000', N'421100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1863', N'黄梅县', N'421127000000', N'421100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1864', N'龙感湖管理区', N'421171000000', N'421100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1865', N'麻城市', N'421181000000', N'421100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1866', N'武穴市', N'421182000000', N'421100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1867', N'市辖区', N'421201000000', N'421200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1868', N'咸安区', N'421202000000', N'421200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1869', N'嘉鱼县', N'421221000000', N'421200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1870', N'通城县', N'421222000000', N'421200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1871', N'崇阳县', N'421223000000', N'421200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1872', N'通山县', N'421224000000', N'421200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1873', N'赤壁市', N'421281000000', N'421200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1874', N'市辖区', N'421301000000', N'421300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1875', N'曾都区', N'421303000000', N'421300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1876', N'随县', N'421321000000', N'421300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1877', N'广水市', N'421381000000', N'421300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1878', N'恩施市', N'422801000000', N'422800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1879', N'利川市', N'422802000000', N'422800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1880', N'建始县', N'422822000000', N'422800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1881', N'巴东县', N'422823000000', N'422800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1882', N'宣恩县', N'422825000000', N'422800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1883', N'咸丰县', N'422826000000', N'422800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1884', N'来凤县', N'422827000000', N'422800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1885', N'鹤峰县', N'422828000000', N'422800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1886', N'仙桃市', N'429004000000', N'429000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1887', N'潜江市', N'429005000000', N'429000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1888', N'天门市', N'429006000000', N'429000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1889', N'神农架林区', N'429021000000', N'429000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1890', N'市辖区', N'430101000000', N'430100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1891', N'芙蓉区', N'430102000000', N'430100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1892', N'天心区', N'430103000000', N'430100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1893', N'岳麓区', N'430104000000', N'430100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1894', N'开福区', N'430105000000', N'430100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1895', N'雨花区', N'430111000000', N'430100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1896', N'望城区', N'430112000000', N'430100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1897', N'长沙县', N'430121000000', N'430100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1898', N'浏阳市', N'430181000000', N'430100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1899', N'宁乡市', N'430182000000', N'430100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1900', N'市辖区', N'430201000000', N'430200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1901', N'荷塘区', N'430202000000', N'430200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1902', N'芦淞区', N'430203000000', N'430200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1903', N'石峰区', N'430204000000', N'430200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1904', N'天元区', N'430211000000', N'430200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1905', N'渌口区', N'430212000000', N'430200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1906', N'攸县', N'430223000000', N'430200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1907', N'茶陵县', N'430224000000', N'430200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1908', N'炎陵县', N'430225000000', N'430200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1909', N'云龙示范区', N'430271000000', N'430200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1910', N'醴陵市', N'430281000000', N'430200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1911', N'市辖区', N'430301000000', N'430300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1912', N'雨湖区', N'430302000000', N'430300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1913', N'岳塘区', N'430304000000', N'430300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1914', N'湘潭县', N'430321000000', N'430300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1915', N'湖南湘潭高新技术产业园区', N'430371000000', N'430300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1916', N'湘潭昭山示范区', N'430372000000', N'430300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1917', N'湘潭九华示范区', N'430373000000', N'430300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1918', N'湘乡市', N'430381000000', N'430300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1919', N'韶山市', N'430382000000', N'430300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1920', N'市辖区', N'430401000000', N'430400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1921', N'珠晖区', N'430405000000', N'430400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1922', N'雁峰区', N'430406000000', N'430400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1923', N'石鼓区', N'430407000000', N'430400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1924', N'蒸湘区', N'430408000000', N'430400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1925', N'南岳区', N'430412000000', N'430400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1926', N'衡阳县', N'430421000000', N'430400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1927', N'衡南县', N'430422000000', N'430400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1928', N'衡山县', N'430423000000', N'430400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1929', N'衡东县', N'430424000000', N'430400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1930', N'祁东县', N'430426000000', N'430400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1931', N'衡阳综合保税区', N'430471000000', N'430400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1932', N'湖南衡阳高新技术产业园区', N'430472000000', N'430400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1933', N'湖南衡阳松木经济开发区', N'430473000000', N'430400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1934', N'耒阳市', N'430481000000', N'430400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1935', N'常宁市', N'430482000000', N'430400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1936', N'市辖区', N'430501000000', N'430500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1937', N'双清区', N'430502000000', N'430500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1938', N'大祥区', N'430503000000', N'430500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1939', N'北塔区', N'430511000000', N'430500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1940', N'邵东县', N'430521000000', N'430500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1941', N'新邵县', N'430522000000', N'430500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1942', N'邵阳县', N'430523000000', N'430500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1943', N'隆回县', N'430524000000', N'430500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1944', N'洞口县', N'430525000000', N'430500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1945', N'绥宁县', N'430527000000', N'430500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1946', N'新宁县', N'430528000000', N'430500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1947', N'城步苗族自治县', N'430529000000', N'430500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1948', N'武冈市', N'430581000000', N'430500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1949', N'市辖区', N'430601000000', N'430600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1950', N'岳阳楼区', N'430602000000', N'430600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1951', N'云溪区', N'430603000000', N'430600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1952', N'君山区', N'430611000000', N'430600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1953', N'岳阳县', N'430621000000', N'430600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1954', N'华容县', N'430623000000', N'430600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1955', N'湘阴县', N'430624000000', N'430600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1956', N'平江县', N'430626000000', N'430600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1957', N'岳阳市屈原管理区', N'430671000000', N'430600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1958', N'汨罗市', N'430681000000', N'430600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1959', N'临湘市', N'430682000000', N'430600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1960', N'市辖区', N'430701000000', N'430700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1961', N'武陵区', N'430702000000', N'430700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1962', N'鼎城区', N'430703000000', N'430700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1963', N'安乡县', N'430721000000', N'430700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1964', N'汉寿县', N'430722000000', N'430700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1965', N'澧县', N'430723000000', N'430700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1966', N'临澧县', N'430724000000', N'430700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1967', N'桃源县', N'430725000000', N'430700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1968', N'石门县', N'430726000000', N'430700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1969', N'常德市西洞庭管理区', N'430771000000', N'430700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1970', N'津市市', N'430781000000', N'430700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1971', N'市辖区', N'430801000000', N'430800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1972', N'永定区', N'430802000000', N'430800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1973', N'武陵源区', N'430811000000', N'430800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1974', N'慈利县', N'430821000000', N'430800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1975', N'桑植县', N'430822000000', N'430800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1976', N'市辖区', N'430901000000', N'430900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1977', N'资阳区', N'430902000000', N'430900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1978', N'赫山区', N'430903000000', N'430900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1979', N'南县', N'430921000000', N'430900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1980', N'桃江县', N'430922000000', N'430900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1981', N'安化县', N'430923000000', N'430900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1982', N'益阳市大通湖管理区', N'430971000000', N'430900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1983', N'湖南益阳高新技术产业园区', N'430972000000', N'430900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1984', N'沅江市', N'430981000000', N'430900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1985', N'市辖区', N'431001000000', N'431000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1986', N'北湖区', N'431002000000', N'431000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1987', N'苏仙区', N'431003000000', N'431000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1988', N'桂阳县', N'431021000000', N'431000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1989', N'宜章县', N'431022000000', N'431000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1990', N'永兴县', N'431023000000', N'431000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1991', N'嘉禾县', N'431024000000', N'431000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1992', N'临武县', N'431025000000', N'431000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1993', N'汝城县', N'431026000000', N'431000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1994', N'桂东县', N'431027000000', N'431000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1995', N'安仁县', N'431028000000', N'431000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1996', N'资兴市', N'431081000000', N'431000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1997', N'市辖区', N'431101000000', N'431100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1998', N'零陵区', N'431102000000', N'431100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'1999', N'冷水滩区', N'431103000000', N'431100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2000', N'祁阳县', N'431121000000', N'431100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2001', N'东安县', N'431122000000', N'431100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2002', N'双牌县', N'431123000000', N'431100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2003', N'道县', N'431124000000', N'431100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2004', N'江永县', N'431125000000', N'431100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2005', N'宁远县', N'431126000000', N'431100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2006', N'蓝山县', N'431127000000', N'431100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2007', N'新田县', N'431128000000', N'431100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2008', N'江华瑶族自治县', N'431129000000', N'431100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2009', N'永州经济技术开发区', N'431171000000', N'431100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2010', N'永州市金洞管理区', N'431172000000', N'431100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2011', N'永州市回龙圩管理区', N'431173000000', N'431100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2012', N'市辖区', N'431201000000', N'431200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2013', N'鹤城区', N'431202000000', N'431200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2014', N'中方县', N'431221000000', N'431200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2015', N'沅陵县', N'431222000000', N'431200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2016', N'辰溪县', N'431223000000', N'431200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2017', N'溆浦县', N'431224000000', N'431200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2018', N'会同县', N'431225000000', N'431200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2019', N'麻阳苗族自治县', N'431226000000', N'431200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2020', N'新晃侗族自治县', N'431227000000', N'431200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2021', N'芷江侗族自治县', N'431228000000', N'431200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2022', N'靖州苗族侗族自治县', N'431229000000', N'431200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2023', N'通道侗族自治县', N'431230000000', N'431200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2024', N'怀化市洪江管理区', N'431271000000', N'431200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2025', N'洪江市', N'431281000000', N'431200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2026', N'市辖区', N'431301000000', N'431300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2027', N'娄星区', N'431302000000', N'431300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2028', N'双峰县', N'431321000000', N'431300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2029', N'新化县', N'431322000000', N'431300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2030', N'冷水江市', N'431381000000', N'431300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2031', N'涟源市', N'431382000000', N'431300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2032', N'吉首市', N'433101000000', N'433100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2033', N'泸溪县', N'433122000000', N'433100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2034', N'凤凰县', N'433123000000', N'433100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2035', N'花垣县', N'433124000000', N'433100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2036', N'保靖县', N'433125000000', N'433100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2037', N'古丈县', N'433126000000', N'433100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2038', N'永顺县', N'433127000000', N'433100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2039', N'龙山县', N'433130000000', N'433100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2040', N'湖南吉首经济开发区', N'433172000000', N'433100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2041', N'湖南永顺经济开发区', N'433173000000', N'433100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2042', N'市辖区', N'440101000000', N'440100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2043', N'荔湾区', N'440103000000', N'440100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2044', N'越秀区', N'440104000000', N'440100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2045', N'海珠区', N'440105000000', N'440100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2046', N'天河区', N'440106000000', N'440100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2047', N'白云区', N'440111000000', N'440100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2048', N'黄埔区', N'440112000000', N'440100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2049', N'番禺区', N'440113000000', N'440100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2050', N'花都区', N'440114000000', N'440100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2051', N'南沙区', N'440115000000', N'440100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2052', N'从化区', N'440117000000', N'440100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2053', N'增城区', N'440118000000', N'440100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2054', N'市辖区', N'440201000000', N'440200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2055', N'武江区', N'440203000000', N'440200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2056', N'浈江区', N'440204000000', N'440200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2057', N'曲江区', N'440205000000', N'440200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2058', N'始兴县', N'440222000000', N'440200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2059', N'仁化县', N'440224000000', N'440200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2060', N'翁源县', N'440229000000', N'440200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2061', N'乳源瑶族自治县', N'440232000000', N'440200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2062', N'新丰县', N'440233000000', N'440200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2063', N'乐昌市', N'440281000000', N'440200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2064', N'南雄市', N'440282000000', N'440200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2065', N'市辖区', N'440301000000', N'440300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2066', N'罗湖区', N'440303000000', N'440300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2067', N'福田区', N'440304000000', N'440300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2068', N'南山区', N'440305000000', N'440300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2069', N'宝安区', N'440306000000', N'440300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2070', N'龙岗区', N'440307000000', N'440300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2071', N'盐田区', N'440308000000', N'440300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2072', N'龙华区', N'440309000000', N'440300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2073', N'坪山区', N'440310000000', N'440300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2074', N'光明区', N'440311000000', N'440300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2075', N'市辖区', N'440401000000', N'440400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2076', N'香洲区', N'440402000000', N'440400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2077', N'斗门区', N'440403000000', N'440400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2078', N'金湾区', N'440404000000', N'440400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2079', N'市辖区', N'440501000000', N'440500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2080', N'龙湖区', N'440507000000', N'440500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2081', N'金平区', N'440511000000', N'440500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2082', N'濠江区', N'440512000000', N'440500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2083', N'潮阳区', N'440513000000', N'440500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2084', N'潮南区', N'440514000000', N'440500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2085', N'澄海区', N'440515000000', N'440500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2086', N'南澳县', N'440523000000', N'440500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2087', N'市辖区', N'440601000000', N'440600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2088', N'禅城区', N'440604000000', N'440600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2089', N'南海区', N'440605000000', N'440600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2090', N'顺德区', N'440606000000', N'440600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2091', N'三水区', N'440607000000', N'440600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2092', N'高明区', N'440608000000', N'440600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2093', N'市辖区', N'440701000000', N'440700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2094', N'蓬江区', N'440703000000', N'440700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2095', N'江海区', N'440704000000', N'440700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2096', N'新会区', N'440705000000', N'440700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2097', N'台山市', N'440781000000', N'440700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2098', N'开平市', N'440783000000', N'440700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2099', N'鹤山市', N'440784000000', N'440700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2100', N'恩平市', N'440785000000', N'440700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2101', N'市辖区', N'440801000000', N'440800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2102', N'赤坎区', N'440802000000', N'440800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2103', N'霞山区', N'440803000000', N'440800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2104', N'坡头区', N'440804000000', N'440800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2105', N'麻章区', N'440811000000', N'440800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2106', N'遂溪县', N'440823000000', N'440800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2107', N'徐闻县', N'440825000000', N'440800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2108', N'廉江市', N'440881000000', N'440800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2109', N'雷州市', N'440882000000', N'440800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2110', N'吴川市', N'440883000000', N'440800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2111', N'市辖区', N'440901000000', N'440900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2112', N'茂南区', N'440902000000', N'440900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2113', N'电白区', N'440904000000', N'440900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2114', N'高州市', N'440981000000', N'440900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2115', N'化州市', N'440982000000', N'440900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2116', N'信宜市', N'440983000000', N'440900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2117', N'市辖区', N'441201000000', N'441200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2118', N'端州区', N'441202000000', N'441200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2119', N'鼎湖区', N'441203000000', N'441200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2120', N'高要区', N'441204000000', N'441200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2121', N'广宁县', N'441223000000', N'441200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2122', N'怀集县', N'441224000000', N'441200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2123', N'封开县', N'441225000000', N'441200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2124', N'德庆县', N'441226000000', N'441200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2125', N'四会市', N'441284000000', N'441200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2126', N'市辖区', N'441301000000', N'441300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2127', N'惠城区', N'441302000000', N'441300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2128', N'惠阳区', N'441303000000', N'441300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2129', N'博罗县', N'441322000000', N'441300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2130', N'惠东县', N'441323000000', N'441300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2131', N'龙门县', N'441324000000', N'441300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2132', N'市辖区', N'441401000000', N'441400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2133', N'梅江区', N'441402000000', N'441400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2134', N'梅县区', N'441403000000', N'441400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2135', N'大埔县', N'441422000000', N'441400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2136', N'丰顺县', N'441423000000', N'441400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2137', N'五华县', N'441424000000', N'441400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2138', N'平远县', N'441426000000', N'441400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2139', N'蕉岭县', N'441427000000', N'441400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2140', N'兴宁市', N'441481000000', N'441400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2141', N'市辖区', N'441501000000', N'441500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2142', N'城区', N'441502000000', N'441500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2143', N'海丰县', N'441521000000', N'441500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2144', N'陆河县', N'441523000000', N'441500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2145', N'陆丰市', N'441581000000', N'441500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2146', N'市辖区', N'441601000000', N'441600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2147', N'源城区', N'441602000000', N'441600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2148', N'紫金县', N'441621000000', N'441600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2149', N'龙川县', N'441622000000', N'441600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2150', N'连平县', N'441623000000', N'441600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2151', N'和平县', N'441624000000', N'441600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2152', N'东源县', N'441625000000', N'441600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2153', N'市辖区', N'441701000000', N'441700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2154', N'江城区', N'441702000000', N'441700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2155', N'阳东区', N'441704000000', N'441700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2156', N'阳西县', N'441721000000', N'441700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2157', N'阳春市', N'441781000000', N'441700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2158', N'市辖区', N'441801000000', N'441800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2159', N'清城区', N'441802000000', N'441800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2160', N'清新区', N'441803000000', N'441800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2161', N'佛冈县', N'441821000000', N'441800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2162', N'阳山县', N'441823000000', N'441800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2163', N'连山壮族瑶族自治县', N'441825000000', N'441800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2164', N'连南瑶族自治县', N'441826000000', N'441800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2165', N'英德市', N'441881000000', N'441800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2166', N'连州市', N'441882000000', N'441800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2167', N'市辖区', N'445101000000', N'445100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2168', N'湘桥区', N'445102000000', N'445100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2169', N'潮安区', N'445103000000', N'445100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2170', N'饶平县', N'445122000000', N'445100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2171', N'市辖区', N'445201000000', N'445200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2172', N'榕城区', N'445202000000', N'445200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2173', N'揭东区', N'445203000000', N'445200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2174', N'揭西县', N'445222000000', N'445200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2175', N'惠来县', N'445224000000', N'445200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2176', N'普宁市', N'445281000000', N'445200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2177', N'市辖区', N'445301000000', N'445300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2178', N'云城区', N'445302000000', N'445300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2179', N'云安区', N'445303000000', N'445300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2180', N'新兴县', N'445321000000', N'445300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2181', N'郁南县', N'445322000000', N'445300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2182', N'罗定市', N'445381000000', N'445300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2183', N'市辖区', N'450101000000', N'450100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2184', N'兴宁区', N'450102000000', N'450100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2185', N'青秀区', N'450103000000', N'450100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2186', N'江南区', N'450105000000', N'450100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2187', N'西乡塘区', N'450107000000', N'450100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2188', N'良庆区', N'450108000000', N'450100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2189', N'邕宁区', N'450109000000', N'450100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2190', N'武鸣区', N'450110000000', N'450100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2191', N'隆安县', N'450123000000', N'450100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2192', N'马山县', N'450124000000', N'450100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2193', N'上林县', N'450125000000', N'450100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2194', N'宾阳县', N'450126000000', N'450100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2195', N'横县', N'450127000000', N'450100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2196', N'市辖区', N'450201000000', N'450200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2197', N'城中区', N'450202000000', N'450200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2198', N'鱼峰区', N'450203000000', N'450200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2199', N'柳南区', N'450204000000', N'450200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2200', N'柳北区', N'450205000000', N'450200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2201', N'柳江区', N'450206000000', N'450200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2202', N'柳城县', N'450222000000', N'450200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2203', N'鹿寨县', N'450223000000', N'450200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2204', N'融安县', N'450224000000', N'450200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2205', N'融水苗族自治县', N'450225000000', N'450200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2206', N'三江侗族自治县', N'450226000000', N'450200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2207', N'市辖区', N'450301000000', N'450300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2208', N'秀峰区', N'450302000000', N'450300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2209', N'叠彩区', N'450303000000', N'450300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2210', N'象山区', N'450304000000', N'450300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2211', N'七星区', N'450305000000', N'450300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2212', N'雁山区', N'450311000000', N'450300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2213', N'临桂区', N'450312000000', N'450300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2214', N'阳朔县', N'450321000000', N'450300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2215', N'灵川县', N'450323000000', N'450300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2216', N'全州县', N'450324000000', N'450300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2217', N'兴安县', N'450325000000', N'450300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2218', N'永福县', N'450326000000', N'450300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2219', N'灌阳县', N'450327000000', N'450300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2220', N'龙胜各族自治县', N'450328000000', N'450300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2221', N'资源县', N'450329000000', N'450300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2222', N'平乐县', N'450330000000', N'450300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2223', N'恭城瑶族自治县', N'450332000000', N'450300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2224', N'荔浦市', N'450381000000', N'450300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2225', N'市辖区', N'450401000000', N'450400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2226', N'万秀区', N'450403000000', N'450400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2227', N'长洲区', N'450405000000', N'450400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2228', N'龙圩区', N'450406000000', N'450400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2229', N'苍梧县', N'450421000000', N'450400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2230', N'藤县', N'450422000000', N'450400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2231', N'蒙山县', N'450423000000', N'450400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2232', N'岑溪市', N'450481000000', N'450400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2233', N'市辖区', N'450501000000', N'450500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2234', N'海城区', N'450502000000', N'450500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2235', N'银海区', N'450503000000', N'450500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2236', N'铁山港区', N'450512000000', N'450500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2237', N'合浦县', N'450521000000', N'450500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2238', N'市辖区', N'450601000000', N'450600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2239', N'港口区', N'450602000000', N'450600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2240', N'防城区', N'450603000000', N'450600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2241', N'上思县', N'450621000000', N'450600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2242', N'东兴市', N'450681000000', N'450600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2243', N'市辖区', N'450701000000', N'450700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2244', N'钦南区', N'450702000000', N'450700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2245', N'钦北区', N'450703000000', N'450700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2246', N'灵山县', N'450721000000', N'450700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2247', N'浦北县', N'450722000000', N'450700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2248', N'市辖区', N'450801000000', N'450800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2249', N'港北区', N'450802000000', N'450800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2250', N'港南区', N'450803000000', N'450800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2251', N'覃塘区', N'450804000000', N'450800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2252', N'平南县', N'450821000000', N'450800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2253', N'桂平市', N'450881000000', N'450800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2254', N'市辖区', N'450901000000', N'450900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2255', N'玉州区', N'450902000000', N'450900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2256', N'福绵区', N'450903000000', N'450900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2257', N'容县', N'450921000000', N'450900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2258', N'陆川县', N'450922000000', N'450900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2259', N'博白县', N'450923000000', N'450900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2260', N'兴业县', N'450924000000', N'450900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2261', N'北流市', N'450981000000', N'450900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2262', N'市辖区', N'451001000000', N'451000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2263', N'右江区', N'451002000000', N'451000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2264', N'田阳县', N'451021000000', N'451000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2265', N'田东县', N'451022000000', N'451000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2266', N'平果县', N'451023000000', N'451000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2267', N'德保县', N'451024000000', N'451000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2268', N'那坡县', N'451026000000', N'451000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2269', N'凌云县', N'451027000000', N'451000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2270', N'乐业县', N'451028000000', N'451000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2271', N'田林县', N'451029000000', N'451000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2272', N'西林县', N'451030000000', N'451000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2273', N'隆林各族自治县', N'451031000000', N'451000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2274', N'靖西市', N'451081000000', N'451000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2275', N'市辖区', N'451101000000', N'451100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2276', N'八步区', N'451102000000', N'451100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2277', N'平桂区', N'451103000000', N'451100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2278', N'昭平县', N'451121000000', N'451100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2279', N'钟山县', N'451122000000', N'451100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2280', N'富川瑶族自治县', N'451123000000', N'451100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2281', N'市辖区', N'451201000000', N'451200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2282', N'金城江区', N'451202000000', N'451200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2283', N'宜州区', N'451203000000', N'451200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2284', N'南丹县', N'451221000000', N'451200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2285', N'天峨县', N'451222000000', N'451200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2286', N'凤山县', N'451223000000', N'451200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2287', N'东兰县', N'451224000000', N'451200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2288', N'罗城仫佬族自治县', N'451225000000', N'451200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2289', N'环江毛南族自治县', N'451226000000', N'451200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2290', N'巴马瑶族自治县', N'451227000000', N'451200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2291', N'都安瑶族自治县', N'451228000000', N'451200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2292', N'大化瑶族自治县', N'451229000000', N'451200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2293', N'市辖区', N'451301000000', N'451300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2294', N'兴宾区', N'451302000000', N'451300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2295', N'忻城县', N'451321000000', N'451300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2296', N'象州县', N'451322000000', N'451300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2297', N'武宣县', N'451323000000', N'451300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2298', N'金秀瑶族自治县', N'451324000000', N'451300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2299', N'合山市', N'451381000000', N'451300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2300', N'市辖区', N'451401000000', N'451400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2301', N'江州区', N'451402000000', N'451400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2302', N'扶绥县', N'451421000000', N'451400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2303', N'宁明县', N'451422000000', N'451400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2304', N'龙州县', N'451423000000', N'451400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2305', N'大新县', N'451424000000', N'451400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2306', N'天等县', N'451425000000', N'451400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2307', N'凭祥市', N'451481000000', N'451400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2308', N'市辖区', N'460101000000', N'460100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2309', N'秀英区', N'460105000000', N'460100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2310', N'龙华区', N'460106000000', N'460100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2311', N'琼山区', N'460107000000', N'460100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2312', N'美兰区', N'460108000000', N'460100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2313', N'市辖区', N'460201000000', N'460200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2314', N'海棠区', N'460202000000', N'460200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2315', N'吉阳区', N'460203000000', N'460200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2316', N'天涯区', N'460204000000', N'460200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2317', N'崖州区', N'460205000000', N'460200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2318', N'西沙群岛', N'460321000000', N'460300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2319', N'南沙群岛', N'460322000000', N'460300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2320', N'中沙群岛的岛礁及其海域', N'460323000000', N'460300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2321', N'五指山市', N'469001000000', N'469000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2322', N'琼海市', N'469002000000', N'469000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2323', N'文昌市', N'469005000000', N'469000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2324', N'万宁市', N'469006000000', N'469000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2325', N'东方市', N'469007000000', N'469000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2326', N'定安县', N'469021000000', N'469000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2327', N'屯昌县', N'469022000000', N'469000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2328', N'澄迈县', N'469023000000', N'469000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2329', N'临高县', N'469024000000', N'469000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2330', N'白沙黎族自治县', N'469025000000', N'469000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2331', N'昌江黎族自治县', N'469026000000', N'469000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2332', N'乐东黎族自治县', N'469027000000', N'469000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2333', N'陵水黎族自治县', N'469028000000', N'469000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2334', N'保亭黎族苗族自治县', N'469029000000', N'469000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2335', N'琼中黎族苗族自治县', N'469030000000', N'469000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2336', N'万州区', N'500101000000', N'500100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2337', N'涪陵区', N'500102000000', N'500100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2338', N'渝中区', N'500103000000', N'500100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2339', N'大渡口区', N'500104000000', N'500100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2340', N'江北区', N'500105000000', N'500100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2341', N'沙坪坝区', N'500106000000', N'500100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2342', N'九龙坡区', N'500107000000', N'500100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2343', N'南岸区', N'500108000000', N'500100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2344', N'北碚区', N'500109000000', N'500100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2345', N'綦江区', N'500110000000', N'500100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2346', N'大足区', N'500111000000', N'500100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2347', N'渝北区', N'500112000000', N'500100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2348', N'巴南区', N'500113000000', N'500100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2349', N'黔江区', N'500114000000', N'500100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2350', N'长寿区', N'500115000000', N'500100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2351', N'江津区', N'500116000000', N'500100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2352', N'合川区', N'500117000000', N'500100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2353', N'永川区', N'500118000000', N'500100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2354', N'南川区', N'500119000000', N'500100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2355', N'璧山区', N'500120000000', N'500100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2356', N'铜梁区', N'500151000000', N'500100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2357', N'潼南区', N'500152000000', N'500100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2358', N'荣昌区', N'500153000000', N'500100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2359', N'开州区', N'500154000000', N'500100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2360', N'梁平区', N'500155000000', N'500100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2361', N'武隆区', N'500156000000', N'500100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2362', N'城口县', N'500229000000', N'500200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2363', N'丰都县', N'500230000000', N'500200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2364', N'垫江县', N'500231000000', N'500200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2365', N'忠县', N'500233000000', N'500200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2366', N'云阳县', N'500235000000', N'500200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2367', N'奉节县', N'500236000000', N'500200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2368', N'巫山县', N'500237000000', N'500200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2369', N'巫溪县', N'500238000000', N'500200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2370', N'石柱土家族自治县', N'500240000000', N'500200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2371', N'秀山土家族苗族自治县', N'500241000000', N'500200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2372', N'酉阳土家族苗族自治县', N'500242000000', N'500200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2373', N'彭水苗族土家族自治县', N'500243000000', N'500200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2374', N'市辖区', N'510101000000', N'510100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2375', N'锦江区', N'510104000000', N'510100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2376', N'青羊区', N'510105000000', N'510100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2377', N'金牛区', N'510106000000', N'510100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2378', N'武侯区', N'510107000000', N'510100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2379', N'成华区', N'510108000000', N'510100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2380', N'龙泉驿区', N'510112000000', N'510100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2381', N'青白江区', N'510113000000', N'510100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2382', N'新都区', N'510114000000', N'510100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2383', N'温江区', N'510115000000', N'510100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2384', N'双流区', N'510116000000', N'510100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2385', N'郫都区', N'510117000000', N'510100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2386', N'金堂县', N'510121000000', N'510100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2387', N'大邑县', N'510129000000', N'510100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2388', N'蒲江县', N'510131000000', N'510100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2389', N'新津县', N'510132000000', N'510100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2390', N'都江堰市', N'510181000000', N'510100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2391', N'彭州市', N'510182000000', N'510100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2392', N'邛崃市', N'510183000000', N'510100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2393', N'崇州市', N'510184000000', N'510100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2394', N'简阳市', N'510185000000', N'510100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2395', N'市辖区', N'510301000000', N'510300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2396', N'自流井区', N'510302000000', N'510300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2397', N'贡井区', N'510303000000', N'510300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2398', N'大安区', N'510304000000', N'510300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2399', N'沿滩区', N'510311000000', N'510300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2400', N'荣县', N'510321000000', N'510300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2401', N'富顺县', N'510322000000', N'510300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2402', N'市辖区', N'510401000000', N'510400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2403', N'东区', N'510402000000', N'510400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2404', N'西区', N'510403000000', N'510400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2405', N'仁和区', N'510411000000', N'510400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2406', N'米易县', N'510421000000', N'510400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2407', N'盐边县', N'510422000000', N'510400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2408', N'市辖区', N'510501000000', N'510500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2409', N'江阳区', N'510502000000', N'510500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2410', N'纳溪区', N'510503000000', N'510500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2411', N'龙马潭区', N'510504000000', N'510500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2412', N'泸县', N'510521000000', N'510500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2413', N'合江县', N'510522000000', N'510500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2414', N'叙永县', N'510524000000', N'510500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2415', N'古蔺县', N'510525000000', N'510500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2416', N'市辖区', N'510601000000', N'510600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2417', N'旌阳区', N'510603000000', N'510600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2418', N'罗江区', N'510604000000', N'510600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2419', N'中江县', N'510623000000', N'510600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2420', N'广汉市', N'510681000000', N'510600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2421', N'什邡市', N'510682000000', N'510600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2422', N'绵竹市', N'510683000000', N'510600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2423', N'市辖区', N'510701000000', N'510700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2424', N'涪城区', N'510703000000', N'510700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2425', N'游仙区', N'510704000000', N'510700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2426', N'安州区', N'510705000000', N'510700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2427', N'三台县', N'510722000000', N'510700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2428', N'盐亭县', N'510723000000', N'510700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2429', N'梓潼县', N'510725000000', N'510700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2430', N'北川羌族自治县', N'510726000000', N'510700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2431', N'平武县', N'510727000000', N'510700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2432', N'江油市', N'510781000000', N'510700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2433', N'市辖区', N'510801000000', N'510800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2434', N'利州区', N'510802000000', N'510800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2435', N'昭化区', N'510811000000', N'510800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2436', N'朝天区', N'510812000000', N'510800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2437', N'旺苍县', N'510821000000', N'510800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2438', N'青川县', N'510822000000', N'510800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2439', N'剑阁县', N'510823000000', N'510800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2440', N'苍溪县', N'510824000000', N'510800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2441', N'市辖区', N'510901000000', N'510900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2442', N'船山区', N'510903000000', N'510900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2443', N'安居区', N'510904000000', N'510900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2444', N'蓬溪县', N'510921000000', N'510900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2445', N'射洪县', N'510922000000', N'510900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2446', N'大英县', N'510923000000', N'510900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2447', N'市辖区', N'511001000000', N'511000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2448', N'市中区', N'511002000000', N'511000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2449', N'东兴区', N'511011000000', N'511000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2450', N'威远县', N'511024000000', N'511000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2451', N'资中县', N'511025000000', N'511000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2452', N'内江经济开发区', N'511071000000', N'511000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2453', N'隆昌市', N'511083000000', N'511000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2454', N'市辖区', N'511101000000', N'511100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2455', N'市中区', N'511102000000', N'511100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2456', N'沙湾区', N'511111000000', N'511100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2457', N'五通桥区', N'511112000000', N'511100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2458', N'金口河区', N'511113000000', N'511100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2459', N'犍为县', N'511123000000', N'511100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2460', N'井研县', N'511124000000', N'511100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2461', N'夹江县', N'511126000000', N'511100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2462', N'沐川县', N'511129000000', N'511100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2463', N'峨边彝族自治县', N'511132000000', N'511100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2464', N'马边彝族自治县', N'511133000000', N'511100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2465', N'峨眉山市', N'511181000000', N'511100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2466', N'市辖区', N'511301000000', N'511300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2467', N'顺庆区', N'511302000000', N'511300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2468', N'高坪区', N'511303000000', N'511300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2469', N'嘉陵区', N'511304000000', N'511300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2470', N'南部县', N'511321000000', N'511300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2471', N'营山县', N'511322000000', N'511300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2472', N'蓬安县', N'511323000000', N'511300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2473', N'仪陇县', N'511324000000', N'511300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2474', N'西充县', N'511325000000', N'511300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2475', N'阆中市', N'511381000000', N'511300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2476', N'市辖区', N'511401000000', N'511400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2477', N'东坡区', N'511402000000', N'511400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2478', N'彭山区', N'511403000000', N'511400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2479', N'仁寿县', N'511421000000', N'511400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2480', N'洪雅县', N'511423000000', N'511400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2481', N'丹棱县', N'511424000000', N'511400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2482', N'青神县', N'511425000000', N'511400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2483', N'市辖区', N'511501000000', N'511500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2484', N'翠屏区', N'511502000000', N'511500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2485', N'南溪区', N'511503000000', N'511500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2486', N'叙州区', N'511504000000', N'511500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2487', N'江安县', N'511523000000', N'511500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2488', N'长宁县', N'511524000000', N'511500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2489', N'高县', N'511525000000', N'511500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2490', N'珙县', N'511526000000', N'511500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2491', N'筠连县', N'511527000000', N'511500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2492', N'兴文县', N'511528000000', N'511500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2493', N'屏山县', N'511529000000', N'511500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2494', N'市辖区', N'511601000000', N'511600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2495', N'广安区', N'511602000000', N'511600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2496', N'前锋区', N'511603000000', N'511600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2497', N'岳池县', N'511621000000', N'511600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2498', N'武胜县', N'511622000000', N'511600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2499', N'邻水县', N'511623000000', N'511600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2500', N'华蓥市', N'511681000000', N'511600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2501', N'市辖区', N'511701000000', N'511700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2502', N'通川区', N'511702000000', N'511700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2503', N'达川区', N'511703000000', N'511700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2504', N'宣汉县', N'511722000000', N'511700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2505', N'开江县', N'511723000000', N'511700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2506', N'大竹县', N'511724000000', N'511700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2507', N'渠县', N'511725000000', N'511700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2508', N'达州经济开发区', N'511771000000', N'511700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2509', N'万源市', N'511781000000', N'511700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2510', N'市辖区', N'511801000000', N'511800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2511', N'雨城区', N'511802000000', N'511800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2512', N'名山区', N'511803000000', N'511800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2513', N'荥经县', N'511822000000', N'511800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2514', N'汉源县', N'511823000000', N'511800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2515', N'石棉县', N'511824000000', N'511800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2516', N'天全县', N'511825000000', N'511800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2517', N'芦山县', N'511826000000', N'511800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2518', N'宝兴县', N'511827000000', N'511800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2519', N'市辖区', N'511901000000', N'511900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2520', N'巴州区', N'511902000000', N'511900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2521', N'恩阳区', N'511903000000', N'511900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2522', N'通江县', N'511921000000', N'511900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2523', N'南江县', N'511922000000', N'511900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2524', N'平昌县', N'511923000000', N'511900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2525', N'巴中经济开发区', N'511971000000', N'511900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2526', N'市辖区', N'512001000000', N'512000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2527', N'雁江区', N'512002000000', N'512000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2528', N'安岳县', N'512021000000', N'512000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2529', N'乐至县', N'512022000000', N'512000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2530', N'马尔康市', N'513201000000', N'513200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2531', N'汶川县', N'513221000000', N'513200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2532', N'理县', N'513222000000', N'513200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2533', N'茂县', N'513223000000', N'513200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2534', N'松潘县', N'513224000000', N'513200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2535', N'九寨沟县', N'513225000000', N'513200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2536', N'金川县', N'513226000000', N'513200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2537', N'小金县', N'513227000000', N'513200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2538', N'黑水县', N'513228000000', N'513200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2539', N'壤塘县', N'513230000000', N'513200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2540', N'阿坝县', N'513231000000', N'513200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2541', N'若尔盖县', N'513232000000', N'513200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2542', N'红原县', N'513233000000', N'513200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2543', N'康定市', N'513301000000', N'513300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2544', N'泸定县', N'513322000000', N'513300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2545', N'丹巴县', N'513323000000', N'513300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2546', N'九龙县', N'513324000000', N'513300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2547', N'雅江县', N'513325000000', N'513300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2548', N'道孚县', N'513326000000', N'513300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2549', N'炉霍县', N'513327000000', N'513300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2550', N'甘孜县', N'513328000000', N'513300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2551', N'新龙县', N'513329000000', N'513300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2552', N'德格县', N'513330000000', N'513300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2553', N'白玉县', N'513331000000', N'513300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2554', N'石渠县', N'513332000000', N'513300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2555', N'色达县', N'513333000000', N'513300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2556', N'理塘县', N'513334000000', N'513300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2557', N'巴塘县', N'513335000000', N'513300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2558', N'乡城县', N'513336000000', N'513300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2559', N'稻城县', N'513337000000', N'513300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2560', N'得荣县', N'513338000000', N'513300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2561', N'西昌市', N'513401000000', N'513400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2562', N'木里藏族自治县', N'513422000000', N'513400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2563', N'盐源县', N'513423000000', N'513400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2564', N'德昌县', N'513424000000', N'513400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2565', N'会理县', N'513425000000', N'513400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2566', N'会东县', N'513426000000', N'513400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2567', N'宁南县', N'513427000000', N'513400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2568', N'普格县', N'513428000000', N'513400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2569', N'布拖县', N'513429000000', N'513400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2570', N'金阳县', N'513430000000', N'513400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2571', N'昭觉县', N'513431000000', N'513400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2572', N'喜德县', N'513432000000', N'513400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2573', N'冕宁县', N'513433000000', N'513400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2574', N'越西县', N'513434000000', N'513400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2575', N'甘洛县', N'513435000000', N'513400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2576', N'美姑县', N'513436000000', N'513400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2577', N'雷波县', N'513437000000', N'513400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2578', N'市辖区', N'520101000000', N'520100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2579', N'南明区', N'520102000000', N'520100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2580', N'云岩区', N'520103000000', N'520100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2581', N'花溪区', N'520111000000', N'520100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2582', N'乌当区', N'520112000000', N'520100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2583', N'白云区', N'520113000000', N'520100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2584', N'观山湖区', N'520115000000', N'520100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2585', N'开阳县', N'520121000000', N'520100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2586', N'息烽县', N'520122000000', N'520100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2587', N'修文县', N'520123000000', N'520100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2588', N'清镇市', N'520181000000', N'520100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2589', N'钟山区', N'520201000000', N'520200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2590', N'六枝特区', N'520203000000', N'520200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2591', N'水城县', N'520221000000', N'520200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2592', N'盘州市', N'520281000000', N'520200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2593', N'市辖区', N'520301000000', N'520300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2594', N'红花岗区', N'520302000000', N'520300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2595', N'汇川区', N'520303000000', N'520300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2596', N'播州区', N'520304000000', N'520300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2597', N'桐梓县', N'520322000000', N'520300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2598', N'绥阳县', N'520323000000', N'520300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2599', N'正安县', N'520324000000', N'520300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2600', N'道真仡佬族苗族自治县', N'520325000000', N'520300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2601', N'务川仡佬族苗族自治县', N'520326000000', N'520300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2602', N'凤冈县', N'520327000000', N'520300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2603', N'湄潭县', N'520328000000', N'520300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2604', N'余庆县', N'520329000000', N'520300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2605', N'习水县', N'520330000000', N'520300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2606', N'赤水市', N'520381000000', N'520300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2607', N'仁怀市', N'520382000000', N'520300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2608', N'市辖区', N'520401000000', N'520400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2609', N'西秀区', N'520402000000', N'520400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2610', N'平坝区', N'520403000000', N'520400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2611', N'普定县', N'520422000000', N'520400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2612', N'镇宁布依族苗族自治县', N'520423000000', N'520400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2613', N'关岭布依族苗族自治县', N'520424000000', N'520400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2614', N'紫云苗族布依族自治县', N'520425000000', N'520400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2615', N'市辖区', N'520501000000', N'520500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2616', N'七星关区', N'520502000000', N'520500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2617', N'大方县', N'520521000000', N'520500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2618', N'黔西县', N'520522000000', N'520500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2619', N'金沙县', N'520523000000', N'520500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2620', N'织金县', N'520524000000', N'520500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2621', N'纳雍县', N'520525000000', N'520500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2622', N'威宁彝族回族苗族自治县', N'520526000000', N'520500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2623', N'赫章县', N'520527000000', N'520500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2624', N'市辖区', N'520601000000', N'520600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2625', N'碧江区', N'520602000000', N'520600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2626', N'万山区', N'520603000000', N'520600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2627', N'江口县', N'520621000000', N'520600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2628', N'玉屏侗族自治县', N'520622000000', N'520600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2629', N'石阡县', N'520623000000', N'520600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2630', N'思南县', N'520624000000', N'520600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2631', N'印江土家族苗族自治县', N'520625000000', N'520600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2632', N'德江县', N'520626000000', N'520600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2633', N'沿河土家族自治县', N'520627000000', N'520600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2634', N'松桃苗族自治县', N'520628000000', N'520600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2635', N'兴义市', N'522301000000', N'522300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2636', N'兴仁市', N'522302000000', N'522300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2637', N'普安县', N'522323000000', N'522300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2638', N'晴隆县', N'522324000000', N'522300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2639', N'贞丰县', N'522325000000', N'522300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2640', N'望谟县', N'522326000000', N'522300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2641', N'册亨县', N'522327000000', N'522300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2642', N'安龙县', N'522328000000', N'522300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2643', N'凯里市', N'522601000000', N'522600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2644', N'黄平县', N'522622000000', N'522600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2645', N'施秉县', N'522623000000', N'522600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2646', N'三穗县', N'522624000000', N'522600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2647', N'镇远县', N'522625000000', N'522600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2648', N'岑巩县', N'522626000000', N'522600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2649', N'天柱县', N'522627000000', N'522600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2650', N'锦屏县', N'522628000000', N'522600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2651', N'剑河县', N'522629000000', N'522600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2652', N'台江县', N'522630000000', N'522600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2653', N'黎平县', N'522631000000', N'522600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2654', N'榕江县', N'522632000000', N'522600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2655', N'从江县', N'522633000000', N'522600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2656', N'雷山县', N'522634000000', N'522600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2657', N'麻江县', N'522635000000', N'522600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2658', N'丹寨县', N'522636000000', N'522600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2659', N'都匀市', N'522701000000', N'522700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2660', N'福泉市', N'522702000000', N'522700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2661', N'荔波县', N'522722000000', N'522700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2662', N'贵定县', N'522723000000', N'522700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2663', N'瓮安县', N'522725000000', N'522700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2664', N'独山县', N'522726000000', N'522700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2665', N'平塘县', N'522727000000', N'522700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2666', N'罗甸县', N'522728000000', N'522700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2667', N'长顺县', N'522729000000', N'522700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2668', N'龙里县', N'522730000000', N'522700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2669', N'惠水县', N'522731000000', N'522700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2670', N'三都水族自治县', N'522732000000', N'522700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2671', N'市辖区', N'530101000000', N'530100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2672', N'五华区', N'530102000000', N'530100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2673', N'盘龙区', N'530103000000', N'530100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2674', N'官渡区', N'530111000000', N'530100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2675', N'西山区', N'530112000000', N'530100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2676', N'东川区', N'530113000000', N'530100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2677', N'呈贡区', N'530114000000', N'530100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2678', N'晋宁区', N'530115000000', N'530100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2679', N'富民县', N'530124000000', N'530100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2680', N'宜良县', N'530125000000', N'530100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2681', N'石林彝族自治县', N'530126000000', N'530100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2682', N'嵩明县', N'530127000000', N'530100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2683', N'禄劝彝族苗族自治县', N'530128000000', N'530100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2684', N'寻甸回族彝族自治县', N'530129000000', N'530100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2685', N'安宁市', N'530181000000', N'530100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2686', N'市辖区', N'530301000000', N'530300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2687', N'麒麟区', N'530302000000', N'530300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2688', N'沾益区', N'530303000000', N'530300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2689', N'马龙区', N'530304000000', N'530300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2690', N'陆良县', N'530322000000', N'530300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2691', N'师宗县', N'530323000000', N'530300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2692', N'罗平县', N'530324000000', N'530300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2693', N'富源县', N'530325000000', N'530300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2694', N'会泽县', N'530326000000', N'530300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2695', N'宣威市', N'530381000000', N'530300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2696', N'市辖区', N'530401000000', N'530400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2697', N'红塔区', N'530402000000', N'530400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2698', N'江川区', N'530403000000', N'530400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2699', N'澄江县', N'530422000000', N'530400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2700', N'通海县', N'530423000000', N'530400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2701', N'华宁县', N'530424000000', N'530400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2702', N'易门县', N'530425000000', N'530400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2703', N'峨山彝族自治县', N'530426000000', N'530400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2704', N'新平彝族傣族自治县', N'530427000000', N'530400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2705', N'元江哈尼族彝族傣族自治县', N'530428000000', N'530400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2706', N'市辖区', N'530501000000', N'530500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2707', N'隆阳区', N'530502000000', N'530500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2708', N'施甸县', N'530521000000', N'530500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2709', N'龙陵县', N'530523000000', N'530500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2710', N'昌宁县', N'530524000000', N'530500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2711', N'腾冲市', N'530581000000', N'530500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2712', N'市辖区', N'530601000000', N'530600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2713', N'昭阳区', N'530602000000', N'530600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2714', N'鲁甸县', N'530621000000', N'530600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2715', N'巧家县', N'530622000000', N'530600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2716', N'盐津县', N'530623000000', N'530600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2717', N'大关县', N'530624000000', N'530600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2718', N'永善县', N'530625000000', N'530600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2719', N'绥江县', N'530626000000', N'530600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2720', N'镇雄县', N'530627000000', N'530600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2721', N'彝良县', N'530628000000', N'530600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2722', N'威信县', N'530629000000', N'530600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2723', N'水富市', N'530681000000', N'530600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2724', N'市辖区', N'530701000000', N'530700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2725', N'古城区', N'530702000000', N'530700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2726', N'玉龙纳西族自治县', N'530721000000', N'530700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2727', N'永胜县', N'530722000000', N'530700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2728', N'华坪县', N'530723000000', N'530700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2729', N'宁蒗彝族自治县', N'530724000000', N'530700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2730', N'市辖区', N'530801000000', N'530800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2731', N'思茅区', N'530802000000', N'530800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2732', N'宁洱哈尼族彝族自治县', N'530821000000', N'530800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2733', N'墨江哈尼族自治县', N'530822000000', N'530800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2734', N'景东彝族自治县', N'530823000000', N'530800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2735', N'景谷傣族彝族自治县', N'530824000000', N'530800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2736', N'镇沅彝族哈尼族拉祜族自治县', N'530825000000', N'530800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2737', N'江城哈尼族彝族自治县', N'530826000000', N'530800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2738', N'孟连傣族拉祜族佤族自治县', N'530827000000', N'530800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2739', N'澜沧拉祜族自治县', N'530828000000', N'530800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2740', N'西盟佤族自治县', N'530829000000', N'530800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2741', N'市辖区', N'530901000000', N'530900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2742', N'临翔区', N'530902000000', N'530900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2743', N'凤庆县', N'530921000000', N'530900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2744', N'云县', N'530922000000', N'530900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2745', N'永德县', N'530923000000', N'530900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2746', N'镇康县', N'530924000000', N'530900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2747', N'双江拉祜族佤族布朗族傣族自治县', N'530925000000', N'530900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2748', N'耿马傣族佤族自治县', N'530926000000', N'530900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2749', N'沧源佤族自治县', N'530927000000', N'530900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2750', N'楚雄市', N'532301000000', N'532300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2751', N'双柏县', N'532322000000', N'532300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2752', N'牟定县', N'532323000000', N'532300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2753', N'南华县', N'532324000000', N'532300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2754', N'姚安县', N'532325000000', N'532300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2755', N'大姚县', N'532326000000', N'532300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2756', N'永仁县', N'532327000000', N'532300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2757', N'元谋县', N'532328000000', N'532300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2758', N'武定县', N'532329000000', N'532300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2759', N'禄丰县', N'532331000000', N'532300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2760', N'个旧市', N'532501000000', N'532500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2761', N'开远市', N'532502000000', N'532500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2762', N'蒙自市', N'532503000000', N'532500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2763', N'弥勒市', N'532504000000', N'532500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2764', N'屏边苗族自治县', N'532523000000', N'532500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2765', N'建水县', N'532524000000', N'532500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2766', N'石屏县', N'532525000000', N'532500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2767', N'泸西县', N'532527000000', N'532500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2768', N'元阳县', N'532528000000', N'532500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2769', N'红河县', N'532529000000', N'532500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2770', N'金平苗族瑶族傣族自治县', N'532530000000', N'532500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2771', N'绿春县', N'532531000000', N'532500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2772', N'河口瑶族自治县', N'532532000000', N'532500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2773', N'文山市', N'532601000000', N'532600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2774', N'砚山县', N'532622000000', N'532600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2775', N'西畴县', N'532623000000', N'532600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2776', N'麻栗坡县', N'532624000000', N'532600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2777', N'马关县', N'532625000000', N'532600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2778', N'丘北县', N'532626000000', N'532600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2779', N'广南县', N'532627000000', N'532600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2780', N'富宁县', N'532628000000', N'532600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2781', N'景洪市', N'532801000000', N'532800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2782', N'勐海县', N'532822000000', N'532800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2783', N'勐腊县', N'532823000000', N'532800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2784', N'大理市', N'532901000000', N'532900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2785', N'漾濞彝族自治县', N'532922000000', N'532900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2786', N'祥云县', N'532923000000', N'532900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2787', N'宾川县', N'532924000000', N'532900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2788', N'弥渡县', N'532925000000', N'532900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2789', N'南涧彝族自治县', N'532926000000', N'532900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2790', N'巍山彝族回族自治县', N'532927000000', N'532900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2791', N'永平县', N'532928000000', N'532900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2792', N'云龙县', N'532929000000', N'532900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2793', N'洱源县', N'532930000000', N'532900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2794', N'剑川县', N'532931000000', N'532900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2795', N'鹤庆县', N'532932000000', N'532900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2796', N'瑞丽市', N'533102000000', N'533100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2797', N'芒市', N'533103000000', N'533100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2798', N'梁河县', N'533122000000', N'533100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2799', N'盈江县', N'533123000000', N'533100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2800', N'陇川县', N'533124000000', N'533100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2801', N'泸水市', N'533301000000', N'533300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2802', N'福贡县', N'533323000000', N'533300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2803', N'贡山独龙族怒族自治县', N'533324000000', N'533300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2804', N'兰坪白族普米族自治县', N'533325000000', N'533300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2805', N'香格里拉市', N'533401000000', N'533400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2806', N'德钦县', N'533422000000', N'533400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2807', N'维西傈僳族自治县', N'533423000000', N'533400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2808', N'市辖区', N'540101000000', N'540100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2809', N'城关区', N'540102000000', N'540100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2810', N'堆龙德庆区', N'540103000000', N'540100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2811', N'达孜区', N'540104000000', N'540100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2812', N'林周县', N'540121000000', N'540100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2813', N'当雄县', N'540122000000', N'540100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2814', N'尼木县', N'540123000000', N'540100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2815', N'曲水县', N'540124000000', N'540100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2816', N'墨竹工卡县', N'540127000000', N'540100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2817', N'格尔木藏青工业园区', N'540171000000', N'540100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2818', N'拉萨经济技术开发区', N'540172000000', N'540100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2819', N'西藏文化旅游创意园区', N'540173000000', N'540100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2820', N'达孜工业园区', N'540174000000', N'540100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2821', N'桑珠孜区', N'540202000000', N'540200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2822', N'南木林县', N'540221000000', N'540200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2823', N'江孜县', N'540222000000', N'540200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2824', N'定日县', N'540223000000', N'540200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2825', N'萨迦县', N'540224000000', N'540200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2826', N'拉孜县', N'540225000000', N'540200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2827', N'昂仁县', N'540226000000', N'540200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2828', N'谢通门县', N'540227000000', N'540200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2829', N'白朗县', N'540228000000', N'540200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2830', N'仁布县', N'540229000000', N'540200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2831', N'康马县', N'540230000000', N'540200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2832', N'定结县', N'540231000000', N'540200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2833', N'仲巴县', N'540232000000', N'540200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2834', N'亚东县', N'540233000000', N'540200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2835', N'吉隆县', N'540234000000', N'540200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2836', N'聂拉木县', N'540235000000', N'540200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2837', N'萨嘎县', N'540236000000', N'540200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2838', N'岗巴县', N'540237000000', N'540200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2839', N'卡若区', N'540302000000', N'540300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2840', N'江达县', N'540321000000', N'540300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2841', N'贡觉县', N'540322000000', N'540300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2842', N'类乌齐县', N'540323000000', N'540300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2843', N'丁青县', N'540324000000', N'540300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2844', N'察雅县', N'540325000000', N'540300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2845', N'八宿县', N'540326000000', N'540300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2846', N'左贡县', N'540327000000', N'540300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2847', N'芒康县', N'540328000000', N'540300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2848', N'洛隆县', N'540329000000', N'540300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2849', N'边坝县', N'540330000000', N'540300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2850', N'巴宜区', N'540402000000', N'540400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2851', N'工布江达县', N'540421000000', N'540400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2852', N'米林县', N'540422000000', N'540400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2853', N'墨脱县', N'540423000000', N'540400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2854', N'波密县', N'540424000000', N'540400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2855', N'察隅县', N'540425000000', N'540400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2856', N'朗县', N'540426000000', N'540400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2857', N'市辖区', N'540501000000', N'540500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2858', N'乃东区', N'540502000000', N'540500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2859', N'扎囊县', N'540521000000', N'540500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2860', N'贡嘎县', N'540522000000', N'540500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2861', N'桑日县', N'540523000000', N'540500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2862', N'琼结县', N'540524000000', N'540500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2863', N'曲松县', N'540525000000', N'540500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2864', N'措美县', N'540526000000', N'540500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2865', N'洛扎县', N'540527000000', N'540500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2866', N'加查县', N'540528000000', N'540500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2867', N'隆子县', N'540529000000', N'540500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2868', N'错那县', N'540530000000', N'540500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2869', N'浪卡子县', N'540531000000', N'540500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2870', N'色尼区', N'540602000000', N'540600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2871', N'嘉黎县', N'540621000000', N'540600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2872', N'比如县', N'540622000000', N'540600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2873', N'聂荣县', N'540623000000', N'540600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2874', N'安多县', N'540624000000', N'540600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2875', N'申扎县', N'540625000000', N'540600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2876', N'索县', N'540626000000', N'540600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2877', N'班戈县', N'540627000000', N'540600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2878', N'巴青县', N'540628000000', N'540600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2879', N'尼玛县', N'540629000000', N'540600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2880', N'双湖县', N'540630000000', N'540600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2881', N'普兰县', N'542521000000', N'542500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2882', N'札达县', N'542522000000', N'542500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2883', N'噶尔县', N'542523000000', N'542500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2884', N'日土县', N'542524000000', N'542500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2885', N'革吉县', N'542525000000', N'542500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2886', N'改则县', N'542526000000', N'542500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2887', N'措勤县', N'542527000000', N'542500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2888', N'市辖区', N'610101000000', N'610100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2889', N'新城区', N'610102000000', N'610100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2890', N'碑林区', N'610103000000', N'610100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2891', N'莲湖区', N'610104000000', N'610100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2892', N'灞桥区', N'610111000000', N'610100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2893', N'未央区', N'610112000000', N'610100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2894', N'雁塔区', N'610113000000', N'610100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2895', N'阎良区', N'610114000000', N'610100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2896', N'临潼区', N'610115000000', N'610100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2897', N'长安区', N'610116000000', N'610100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2898', N'高陵区', N'610117000000', N'610100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2899', N'鄠邑区', N'610118000000', N'610100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2900', N'蓝田县', N'610122000000', N'610100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2901', N'周至县', N'610124000000', N'610100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2902', N'市辖区', N'610201000000', N'610200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2903', N'王益区', N'610202000000', N'610200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2904', N'印台区', N'610203000000', N'610200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2905', N'耀州区', N'610204000000', N'610200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2906', N'宜君县', N'610222000000', N'610200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2907', N'市辖区', N'610301000000', N'610300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2908', N'渭滨区', N'610302000000', N'610300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2909', N'金台区', N'610303000000', N'610300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2910', N'陈仓区', N'610304000000', N'610300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2911', N'凤翔县', N'610322000000', N'610300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2912', N'岐山县', N'610323000000', N'610300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2913', N'扶风县', N'610324000000', N'610300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2914', N'眉县', N'610326000000', N'610300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2915', N'陇县', N'610327000000', N'610300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2916', N'千阳县', N'610328000000', N'610300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2917', N'麟游县', N'610329000000', N'610300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2918', N'凤县', N'610330000000', N'610300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2919', N'太白县', N'610331000000', N'610300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2920', N'市辖区', N'610401000000', N'610400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2921', N'秦都区', N'610402000000', N'610400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2922', N'杨陵区', N'610403000000', N'610400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2923', N'渭城区', N'610404000000', N'610400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2924', N'三原县', N'610422000000', N'610400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2925', N'泾阳县', N'610423000000', N'610400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2926', N'乾县', N'610424000000', N'610400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2927', N'礼泉县', N'610425000000', N'610400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2928', N'永寿县', N'610426000000', N'610400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2929', N'长武县', N'610428000000', N'610400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2930', N'旬邑县', N'610429000000', N'610400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2931', N'淳化县', N'610430000000', N'610400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2932', N'武功县', N'610431000000', N'610400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2933', N'兴平市', N'610481000000', N'610400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2934', N'彬州市', N'610482000000', N'610400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2935', N'市辖区', N'610501000000', N'610500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2936', N'临渭区', N'610502000000', N'610500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2937', N'华州区', N'610503000000', N'610500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2938', N'潼关县', N'610522000000', N'610500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2939', N'大荔县', N'610523000000', N'610500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2940', N'合阳县', N'610524000000', N'610500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2941', N'澄城县', N'610525000000', N'610500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2942', N'蒲城县', N'610526000000', N'610500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2943', N'白水县', N'610527000000', N'610500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2944', N'富平县', N'610528000000', N'610500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2945', N'韩城市', N'610581000000', N'610500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2946', N'华阴市', N'610582000000', N'610500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2947', N'市辖区', N'610601000000', N'610600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2948', N'宝塔区', N'610602000000', N'610600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2949', N'安塞区', N'610603000000', N'610600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2950', N'延长县', N'610621000000', N'610600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2951', N'延川县', N'610622000000', N'610600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2952', N'子长县', N'610623000000', N'610600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2953', N'志丹县', N'610625000000', N'610600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2954', N'吴起县', N'610626000000', N'610600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2955', N'甘泉县', N'610627000000', N'610600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2956', N'富县', N'610628000000', N'610600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2957', N'洛川县', N'610629000000', N'610600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2958', N'宜川县', N'610630000000', N'610600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2959', N'黄龙县', N'610631000000', N'610600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2960', N'黄陵县', N'610632000000', N'610600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2961', N'市辖区', N'610701000000', N'610700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2962', N'汉台区', N'610702000000', N'610700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2963', N'南郑区', N'610703000000', N'610700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2964', N'城固县', N'610722000000', N'610700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2965', N'洋县', N'610723000000', N'610700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2966', N'西乡县', N'610724000000', N'610700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2967', N'勉县', N'610725000000', N'610700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2968', N'宁强县', N'610726000000', N'610700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2969', N'略阳县', N'610727000000', N'610700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2970', N'镇巴县', N'610728000000', N'610700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2971', N'留坝县', N'610729000000', N'610700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2972', N'佛坪县', N'610730000000', N'610700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2973', N'市辖区', N'610801000000', N'610800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2974', N'榆阳区', N'610802000000', N'610800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2975', N'横山区', N'610803000000', N'610800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2976', N'府谷县', N'610822000000', N'610800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2977', N'靖边县', N'610824000000', N'610800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2978', N'定边县', N'610825000000', N'610800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2979', N'绥德县', N'610826000000', N'610800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2980', N'米脂县', N'610827000000', N'610800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2981', N'佳县', N'610828000000', N'610800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2982', N'吴堡县', N'610829000000', N'610800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2983', N'清涧县', N'610830000000', N'610800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2984', N'子洲县', N'610831000000', N'610800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2985', N'神木市', N'610881000000', N'610800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2986', N'市辖区', N'610901000000', N'610900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2987', N'汉滨区', N'610902000000', N'610900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2988', N'汉阴县', N'610921000000', N'610900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2989', N'石泉县', N'610922000000', N'610900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2990', N'宁陕县', N'610923000000', N'610900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2991', N'紫阳县', N'610924000000', N'610900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2992', N'岚皋县', N'610925000000', N'610900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2993', N'平利县', N'610926000000', N'610900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2994', N'镇坪县', N'610927000000', N'610900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2995', N'旬阳县', N'610928000000', N'610900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2996', N'白河县', N'610929000000', N'610900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2997', N'市辖区', N'611001000000', N'611000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2998', N'商州区', N'611002000000', N'611000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'2999', N'洛南县', N'611021000000', N'611000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3000', N'丹凤县', N'611022000000', N'611000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3001', N'商南县', N'611023000000', N'611000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3002', N'山阳县', N'611024000000', N'611000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3003', N'镇安县', N'611025000000', N'611000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3004', N'柞水县', N'611026000000', N'611000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3005', N'市辖区', N'620101000000', N'620100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3006', N'城关区', N'620102000000', N'620100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3007', N'七里河区', N'620103000000', N'620100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3008', N'西固区', N'620104000000', N'620100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3009', N'安宁区', N'620105000000', N'620100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3010', N'红古区', N'620111000000', N'620100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3011', N'永登县', N'620121000000', N'620100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3012', N'皋兰县', N'620122000000', N'620100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3013', N'榆中县', N'620123000000', N'620100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3014', N'兰州新区', N'620171000000', N'620100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3015', N'市辖区', N'620201000000', N'620200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3016', N'市辖区', N'620301000000', N'620300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3017', N'金川区', N'620302000000', N'620300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3018', N'永昌县', N'620321000000', N'620300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3019', N'市辖区', N'620401000000', N'620400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3020', N'白银区', N'620402000000', N'620400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3021', N'平川区', N'620403000000', N'620400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3022', N'靖远县', N'620421000000', N'620400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3023', N'会宁县', N'620422000000', N'620400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3024', N'景泰县', N'620423000000', N'620400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3025', N'市辖区', N'620501000000', N'620500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3026', N'秦州区', N'620502000000', N'620500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3027', N'麦积区', N'620503000000', N'620500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3028', N'清水县', N'620521000000', N'620500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3029', N'秦安县', N'620522000000', N'620500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3030', N'甘谷县', N'620523000000', N'620500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3031', N'武山县', N'620524000000', N'620500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3032', N'张家川回族自治县', N'620525000000', N'620500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3033', N'市辖区', N'620601000000', N'620600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3034', N'凉州区', N'620602000000', N'620600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3035', N'民勤县', N'620621000000', N'620600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3036', N'古浪县', N'620622000000', N'620600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3037', N'天祝藏族自治县', N'620623000000', N'620600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3038', N'市辖区', N'620701000000', N'620700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3039', N'甘州区', N'620702000000', N'620700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3040', N'肃南裕固族自治县', N'620721000000', N'620700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3041', N'民乐县', N'620722000000', N'620700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3042', N'临泽县', N'620723000000', N'620700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3043', N'高台县', N'620724000000', N'620700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3044', N'山丹县', N'620725000000', N'620700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3045', N'市辖区', N'620801000000', N'620800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3046', N'崆峒区', N'620802000000', N'620800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3047', N'泾川县', N'620821000000', N'620800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3048', N'灵台县', N'620822000000', N'620800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3049', N'崇信县', N'620823000000', N'620800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3050', N'庄浪县', N'620825000000', N'620800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3051', N'静宁县', N'620826000000', N'620800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3052', N'华亭市', N'620881000000', N'620800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3053', N'市辖区', N'620901000000', N'620900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3054', N'肃州区', N'620902000000', N'620900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3055', N'金塔县', N'620921000000', N'620900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3056', N'瓜州县', N'620922000000', N'620900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3057', N'肃北蒙古族自治县', N'620923000000', N'620900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3058', N'阿克塞哈萨克族自治县', N'620924000000', N'620900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3059', N'玉门市', N'620981000000', N'620900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3060', N'敦煌市', N'620982000000', N'620900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3061', N'市辖区', N'621001000000', N'621000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3062', N'西峰区', N'621002000000', N'621000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3063', N'庆城县', N'621021000000', N'621000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3064', N'环县', N'621022000000', N'621000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3065', N'华池县', N'621023000000', N'621000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3066', N'合水县', N'621024000000', N'621000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3067', N'正宁县', N'621025000000', N'621000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3068', N'宁县', N'621026000000', N'621000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3069', N'镇原县', N'621027000000', N'621000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3070', N'市辖区', N'621101000000', N'621100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3071', N'安定区', N'621102000000', N'621100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3072', N'通渭县', N'621121000000', N'621100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3073', N'陇西县', N'621122000000', N'621100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3074', N'渭源县', N'621123000000', N'621100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3075', N'临洮县', N'621124000000', N'621100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3076', N'漳县', N'621125000000', N'621100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3077', N'岷县', N'621126000000', N'621100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3078', N'市辖区', N'621201000000', N'621200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3079', N'武都区', N'621202000000', N'621200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3080', N'成县', N'621221000000', N'621200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3081', N'文县', N'621222000000', N'621200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3082', N'宕昌县', N'621223000000', N'621200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3083', N'康县', N'621224000000', N'621200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3084', N'西和县', N'621225000000', N'621200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3085', N'礼县', N'621226000000', N'621200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3086', N'徽县', N'621227000000', N'621200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3087', N'两当县', N'621228000000', N'621200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3088', N'临夏市', N'622901000000', N'622900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3089', N'临夏县', N'622921000000', N'622900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3090', N'康乐县', N'622922000000', N'622900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3091', N'永靖县', N'622923000000', N'622900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3092', N'广河县', N'622924000000', N'622900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3093', N'和政县', N'622925000000', N'622900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3094', N'东乡族自治县', N'622926000000', N'622900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3095', N'积石山保安族东乡族撒拉族自治县', N'622927000000', N'622900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3096', N'合作市', N'623001000000', N'623000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3097', N'临潭县', N'623021000000', N'623000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3098', N'卓尼县', N'623022000000', N'623000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3099', N'舟曲县', N'623023000000', N'623000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3100', N'迭部县', N'623024000000', N'623000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3101', N'玛曲县', N'623025000000', N'623000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3102', N'碌曲县', N'623026000000', N'623000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3103', N'夏河县', N'623027000000', N'623000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3104', N'市辖区', N'630101000000', N'630100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3105', N'城东区', N'630102000000', N'630100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3106', N'城中区', N'630103000000', N'630100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3107', N'城西区', N'630104000000', N'630100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3108', N'城北区', N'630105000000', N'630100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3109', N'大通回族土族自治县', N'630121000000', N'630100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3110', N'湟中县', N'630122000000', N'630100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3111', N'湟源县', N'630123000000', N'630100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3112', N'乐都区', N'630202000000', N'630200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3113', N'平安区', N'630203000000', N'630200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3114', N'民和回族土族自治县', N'630222000000', N'630200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3115', N'互助土族自治县', N'630223000000', N'630200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3116', N'化隆回族自治县', N'630224000000', N'630200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3117', N'循化撒拉族自治县', N'630225000000', N'630200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3118', N'门源回族自治县', N'632221000000', N'632200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3119', N'祁连县', N'632222000000', N'632200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3120', N'海晏县', N'632223000000', N'632200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3121', N'刚察县', N'632224000000', N'632200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3122', N'同仁县', N'632321000000', N'632300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3123', N'尖扎县', N'632322000000', N'632300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3124', N'泽库县', N'632323000000', N'632300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3125', N'河南蒙古族自治县', N'632324000000', N'632300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3126', N'共和县', N'632521000000', N'632500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3127', N'同德县', N'632522000000', N'632500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3128', N'贵德县', N'632523000000', N'632500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3129', N'兴海县', N'632524000000', N'632500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3130', N'贵南县', N'632525000000', N'632500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3131', N'玛沁县', N'632621000000', N'632600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3132', N'班玛县', N'632622000000', N'632600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3133', N'甘德县', N'632623000000', N'632600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3134', N'达日县', N'632624000000', N'632600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3135', N'久治县', N'632625000000', N'632600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3136', N'玛多县', N'632626000000', N'632600000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3137', N'玉树市', N'632701000000', N'632700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3138', N'杂多县', N'632722000000', N'632700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3139', N'称多县', N'632723000000', N'632700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3140', N'治多县', N'632724000000', N'632700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3141', N'囊谦县', N'632725000000', N'632700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3142', N'曲麻莱县', N'632726000000', N'632700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3143', N'格尔木市', N'632801000000', N'632800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3144', N'德令哈市', N'632802000000', N'632800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3145', N'茫崖市', N'632803000000', N'632800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3146', N'乌兰县', N'632821000000', N'632800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3147', N'都兰县', N'632822000000', N'632800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3148', N'天峻县', N'632823000000', N'632800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3149', N'大柴旦行政委员会', N'632857000000', N'632800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3150', N'市辖区', N'640101000000', N'640100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3151', N'兴庆区', N'640104000000', N'640100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3152', N'西夏区', N'640105000000', N'640100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3153', N'金凤区', N'640106000000', N'640100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3154', N'永宁县', N'640121000000', N'640100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3155', N'贺兰县', N'640122000000', N'640100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3156', N'灵武市', N'640181000000', N'640100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3157', N'市辖区', N'640201000000', N'640200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3158', N'大武口区', N'640202000000', N'640200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3159', N'惠农区', N'640205000000', N'640200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3160', N'平罗县', N'640221000000', N'640200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3161', N'市辖区', N'640301000000', N'640300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3162', N'利通区', N'640302000000', N'640300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3163', N'红寺堡区', N'640303000000', N'640300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3164', N'盐池县', N'640323000000', N'640300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3165', N'同心县', N'640324000000', N'640300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3166', N'青铜峡市', N'640381000000', N'640300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3167', N'市辖区', N'640401000000', N'640400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3168', N'原州区', N'640402000000', N'640400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3169', N'西吉县', N'640422000000', N'640400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3170', N'隆德县', N'640423000000', N'640400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3171', N'泾源县', N'640424000000', N'640400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3172', N'彭阳县', N'640425000000', N'640400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3173', N'市辖区', N'640501000000', N'640500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3174', N'沙坡头区', N'640502000000', N'640500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3175', N'中宁县', N'640521000000', N'640500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3176', N'海原县', N'640522000000', N'640500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3177', N'市辖区', N'650101000000', N'650100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3178', N'天山区', N'650102000000', N'650100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3179', N'沙依巴克区', N'650103000000', N'650100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3180', N'新市区', N'650104000000', N'650100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3181', N'水磨沟区', N'650105000000', N'650100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3182', N'头屯河区', N'650106000000', N'650100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3183', N'达坂城区', N'650107000000', N'650100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3184', N'米东区', N'650109000000', N'650100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3185', N'乌鲁木齐县', N'650121000000', N'650100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3186', N'乌鲁木齐经济技术开发区', N'650171000000', N'650100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3187', N'乌鲁木齐高新技术产业开发区', N'650172000000', N'650100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3188', N'市辖区', N'650201000000', N'650200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3189', N'独山子区', N'650202000000', N'650200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3190', N'克拉玛依区', N'650203000000', N'650200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3191', N'白碱滩区', N'650204000000', N'650200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3192', N'乌尔禾区', N'650205000000', N'650200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3193', N'高昌区', N'650402000000', N'650400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3194', N'鄯善县', N'650421000000', N'650400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3195', N'托克逊县', N'650422000000', N'650400000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3196', N'伊州区', N'650502000000', N'650500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3197', N'巴里坤哈萨克自治县', N'650521000000', N'650500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3198', N'伊吾县', N'650522000000', N'650500000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3199', N'昌吉市', N'652301000000', N'652300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3200', N'阜康市', N'652302000000', N'652300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3201', N'呼图壁县', N'652323000000', N'652300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3202', N'玛纳斯县', N'652324000000', N'652300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3203', N'奇台县', N'652325000000', N'652300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3204', N'吉木萨尔县', N'652327000000', N'652300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3205', N'木垒哈萨克自治县', N'652328000000', N'652300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3206', N'博乐市', N'652701000000', N'652700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3207', N'阿拉山口市', N'652702000000', N'652700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3208', N'精河县', N'652722000000', N'652700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3209', N'温泉县', N'652723000000', N'652700000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3210', N'库尔勒市', N'652801000000', N'652800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3211', N'轮台县', N'652822000000', N'652800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3212', N'尉犁县', N'652823000000', N'652800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3213', N'若羌县', N'652824000000', N'652800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3214', N'且末县', N'652825000000', N'652800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3215', N'焉耆回族自治县', N'652826000000', N'652800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3216', N'和静县', N'652827000000', N'652800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3217', N'和硕县', N'652828000000', N'652800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3218', N'博湖县', N'652829000000', N'652800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3219', N'库尔勒经济技术开发区', N'652871000000', N'652800000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3220', N'阿克苏市', N'652901000000', N'652900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3221', N'温宿县', N'652922000000', N'652900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3222', N'库车县', N'652923000000', N'652900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3223', N'沙雅县', N'652924000000', N'652900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3224', N'新和县', N'652925000000', N'652900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3225', N'拜城县', N'652926000000', N'652900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3226', N'乌什县', N'652927000000', N'652900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3227', N'阿瓦提县', N'652928000000', N'652900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3228', N'柯坪县', N'652929000000', N'652900000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3229', N'阿图什市', N'653001000000', N'653000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3230', N'阿克陶县', N'653022000000', N'653000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3231', N'阿合奇县', N'653023000000', N'653000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3232', N'乌恰县', N'653024000000', N'653000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3233', N'喀什市', N'653101000000', N'653100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3234', N'疏附县', N'653121000000', N'653100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3235', N'疏勒县', N'653122000000', N'653100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3236', N'英吉沙县', N'653123000000', N'653100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3237', N'泽普县', N'653124000000', N'653100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3238', N'莎车县', N'653125000000', N'653100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3239', N'叶城县', N'653126000000', N'653100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3240', N'麦盖提县', N'653127000000', N'653100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3241', N'岳普湖县', N'653128000000', N'653100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3242', N'伽师县', N'653129000000', N'653100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3243', N'巴楚县', N'653130000000', N'653100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3244', N'塔什库尔干塔吉克自治县', N'653131000000', N'653100000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3245', N'和田市', N'653201000000', N'653200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3246', N'和田县', N'653221000000', N'653200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3247', N'墨玉县', N'653222000000', N'653200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3248', N'皮山县', N'653223000000', N'653200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3249', N'洛浦县', N'653224000000', N'653200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3250', N'策勒县', N'653225000000', N'653200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3251', N'于田县', N'653226000000', N'653200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3252', N'民丰县', N'653227000000', N'653200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3253', N'伊宁市', N'654002000000', N'654000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3254', N'奎屯市', N'654003000000', N'654000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3255', N'霍尔果斯市', N'654004000000', N'654000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3256', N'伊宁县', N'654021000000', N'654000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3257', N'察布查尔锡伯自治县', N'654022000000', N'654000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3258', N'霍城县', N'654023000000', N'654000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3259', N'巩留县', N'654024000000', N'654000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3260', N'新源县', N'654025000000', N'654000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3261', N'昭苏县', N'654026000000', N'654000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3262', N'特克斯县', N'654027000000', N'654000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3263', N'尼勒克县', N'654028000000', N'654000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3264', N'塔城市', N'654201000000', N'654200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3265', N'乌苏市', N'654202000000', N'654200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3266', N'额敏县', N'654221000000', N'654200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3267', N'沙湾县', N'654223000000', N'654200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3268', N'托里县', N'654224000000', N'654200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3269', N'裕民县', N'654225000000', N'654200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3270', N'和布克赛尔蒙古自治县', N'654226000000', N'654200000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3271', N'阿勒泰市', N'654301000000', N'654300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3272', N'布尔津县', N'654321000000', N'654300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3273', N'富蕴县', N'654322000000', N'654300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3274', N'福海县', N'654323000000', N'654300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3275', N'哈巴河县', N'654324000000', N'654300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3276', N'青河县', N'654325000000', N'654300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3277', N'吉木乃县', N'654326000000', N'654300000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3278', N'石河子市', N'659001000000', N'659000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3279', N'阿拉尔市', N'659002000000', N'659000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3280', N'图木舒克市', N'659003000000', N'659000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3281', N'五家渠市', N'659004000000', N'659000000000')
GO

INSERT INTO [dbo].[t_s_country] VALUES (N'3282', N'铁门关市', N'659006000000', N'659000000000')
GO


-- ----------------------------
-- Table structure for t_s_dt_multi_languages
-- ----------------------------
IF EXISTS (SELECT * FROM sys.all_objects WHERE object_id = OBJECT_ID(N'[dbo].[t_s_dt_multi_languages]') AND type IN ('U'))
	DROP TABLE [dbo].[t_s_dt_multi_languages]
GO

CREATE TABLE [dbo].[t_s_dt_multi_languages] (
  [id] bigint  NOT NULL,
  [create_by] bigint  NULL,
  [create_date] datetime2(0)  NULL,
  [update_by] bigint  NULL,
  [update_date] datetime2(0)  NULL,
  [dict_type_id] bigint  NOT NULL,
  [name] nvarchar(255) COLLATE Chinese_PRC_CI_AS  NULL,
  [language] nvarchar(25) COLLATE Chinese_PRC_CI_AS  NOT NULL
)
GO

ALTER TABLE [dbo].[t_s_dt_multi_languages] SET (LOCK_ESCALATION = TABLE)
GO

EXEC sp_addextendedproperty
'MS_Description', N'id',
'SCHEMA', N'dbo',
'TABLE', N't_s_dt_multi_languages',
'COLUMN', N'id'
GO

EXEC sp_addextendedproperty
'MS_Description', N'创建人id',
'SCHEMA', N'dbo',
'TABLE', N't_s_dt_multi_languages',
'COLUMN', N'create_by'
GO

EXEC sp_addextendedproperty
'MS_Description', N'创建时间',
'SCHEMA', N'dbo',
'TABLE', N't_s_dt_multi_languages',
'COLUMN', N'create_date'
GO

EXEC sp_addextendedproperty
'MS_Description', N'更新人id',
'SCHEMA', N'dbo',
'TABLE', N't_s_dt_multi_languages',
'COLUMN', N'update_by'
GO

EXEC sp_addextendedproperty
'MS_Description', N'更新时间',
'SCHEMA', N'dbo',
'TABLE', N't_s_dt_multi_languages',
'COLUMN', N'update_date'
GO

EXEC sp_addextendedproperty
'MS_Description', N'字典id',
'SCHEMA', N'dbo',
'TABLE', N't_s_dt_multi_languages',
'COLUMN', N'dict_type_id'
GO

EXEC sp_addextendedproperty
'MS_Description', N'字典名称',
'SCHEMA', N'dbo',
'TABLE', N't_s_dt_multi_languages',
'COLUMN', N'name'
GO

EXEC sp_addextendedproperty
'MS_Description', N'语言',
'SCHEMA', N'dbo',
'TABLE', N't_s_dt_multi_languages',
'COLUMN', N'language'
GO

EXEC sp_addextendedproperty
'MS_Description', N'字典多语言',
'SCHEMA', N'dbo',
'TABLE', N't_s_dt_multi_languages'
GO


-- ----------------------------
-- Records of t_s_dt_multi_languages
-- ----------------------------
INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'1', NULL, NULL, NULL, NULL, N'100000001', N'phone', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'2', NULL, NULL, NULL, NULL, N'100000002', N'web', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'3', NULL, NULL, NULL, NULL, N'100000003', N'不可用', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'4', NULL, NULL, NULL, NULL, N'100000004', N'可用', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'5', NULL, NULL, NULL, NULL, N'100000005', N'普通用户', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'6', NULL, NULL, NULL, NULL, N'100000006', N'管理员', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'7', NULL, NULL, NULL, NULL, N'100000007', N'超管', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'8', NULL, NULL, NULL, NULL, N'100000008', N'男', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'9', NULL, NULL, NULL, NULL, N'100000009', N'女', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'10', NULL, NULL, NULL, NULL, N'100000010', N'离线', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'11', NULL, NULL, NULL, NULL, N'100000011', N'在线', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'12', NULL, NULL, NULL, NULL, N'100000012', N'关闭', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'13', NULL, NULL, NULL, NULL, N'100000013', N'启用', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'14', NULL, NULL, NULL, NULL, N'100000014', N'一级菜单', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'15', NULL, NULL, NULL, NULL, N'100000015', N'二级菜单', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'16', NULL, NULL, NULL, NULL, N'95854276256989184', N'勿扰', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'17', NULL, NULL, NULL, NULL, N'96958562013544448', N'待付款', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'18', NULL, NULL, NULL, NULL, N'96959193222742016', N'已付款，待发货', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'19', NULL, NULL, NULL, NULL, N'96961451628953600', N'已发货，待收货', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'20', NULL, NULL, NULL, NULL, N'96962768984342528', N'交易成功', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'21', NULL, NULL, NULL, NULL, N'96963159130112000', N'交易关闭', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'22', NULL, NULL, NULL, NULL, N'96963562651516928', N'退款中', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'23', NULL, NULL, NULL, NULL, N'97357187684237312', N'充值', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'28', NULL, NULL, NULL, NULL, N'97366040169676800', N'支付宝', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'29', NULL, NULL, NULL, NULL, N'97366110180999168', N'微信', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'30', NULL, NULL, NULL, NULL, N'97536125287006208', N'产品消息', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'31', NULL, NULL, NULL, NULL, N'97536221990879232', N'安全消息', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'32', NULL, NULL, NULL, NULL, N'97536285903683584', N'服务消息', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'33', NULL, NULL, NULL, NULL, N'97536343411785728', N'活动消息', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'34', NULL, NULL, NULL, NULL, N'97536415625117696', N'历史消息', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'35', NULL, NULL, NULL, NULL, N'97536494998126592', N'故障消息', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'36', NULL, NULL, NULL, NULL, N'99136468701675520', N'banner', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'37', NULL, NULL, NULL, NULL, N'155566528442400769', N'富文本', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'38', NULL, NULL, NULL, NULL, N'155566528442400768', N'穿梭框', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'39', NULL, NULL, NULL, NULL, N'155566444615041024', N'颜色选择器', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'40', NULL, NULL, NULL, NULL, N'155566354039046144', N'评分', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'41', NULL, NULL, NULL, NULL, N'155566295306207232', N'上传', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'42', NULL, NULL, NULL, NULL, N'155566223822684160', N'日期选择器', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'43', NULL, NULL, NULL, NULL, N'155566122928701440', N'时间选择器', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'44', NULL, NULL, NULL, NULL, N'155566025453076480', N'滑块', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'45', NULL, NULL, NULL, NULL, N'155565960655273984', N'开关', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'46', NULL, NULL, NULL, NULL, N'155565909979693056', N'级联选择器', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'47', NULL, NULL, NULL, NULL, N'155565797303910400', N'选择器', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'48', NULL, NULL, NULL, NULL, N'155565698930704384', N'计数器', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'49', NULL, NULL, NULL, NULL, N'155565420294701056', N'多选框', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'50', NULL, NULL, NULL, NULL, N'155565360102244352', N'单选框', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'51', NULL, NULL, NULL, NULL, N'155565261192167424', N'输入框', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'52', NULL, NULL, NULL, NULL, N'108265713587716096', N'on', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'53', NULL, NULL, NULL, NULL, N'108265787696873472', N'off', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'54', NULL, NULL, NULL, NULL, N'113787304258043904', N'草稿', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'55', NULL, NULL, NULL, NULL, N'113787421593698304', N'发布', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'56', NULL, NULL, NULL, NULL, N'119131930154237952', N'激活', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'57', NULL, NULL, NULL, NULL, N'119132047645081600', N'禁用', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'58', NULL, NULL, NULL, NULL, N'100000001', N'phone', N'en_US')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'59', NULL, NULL, NULL, NULL, N'100000002', N'web', N'en_US')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'60', NULL, NULL, NULL, NULL, N'100000003', N'disabled', N'en_US')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'61', NULL, NULL, NULL, NULL, N'100000004', N'enabled', N'en_US')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'62', NULL, NULL, NULL, NULL, N'100000005', N'user', N'en_US')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'63', NULL, NULL, NULL, NULL, N'100000006', N'admin', N'en_US')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'64', NULL, NULL, NULL, NULL, N'100000007', N'su', N'en_US')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'65', NULL, NULL, NULL, NULL, N'100000008', N'male', N'en_US')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'66', NULL, NULL, NULL, NULL, N'100000009', N'female', N'en_US')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'67', NULL, NULL, NULL, NULL, N'100000010', N'offline', N'en_US')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'68', NULL, NULL, NULL, NULL, N'100000011', N'online', N'en_US')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'69', NULL, NULL, NULL, NULL, N'100000012', N'closed', N'en_US')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'70', NULL, NULL, NULL, NULL, N'100000013', N'opened', N'en_US')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'71', NULL, NULL, NULL, NULL, N'100000014', N'level 1', N'en_US')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'72', NULL, NULL, NULL, NULL, N'100000015', N'level 2', N'en_US')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'73', NULL, NULL, NULL, NULL, N'95854276256989184', N'do not disturb', N'en_US')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'74', NULL, NULL, NULL, NULL, N'96958562013544448', N'wait pay', N'en_US')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'75', NULL, NULL, NULL, NULL, N'96959193222742016', N'payed', N'en_US')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'76', NULL, NULL, NULL, NULL, N'96961451628953600', N'shipped', N'en_US')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'77', NULL, NULL, NULL, NULL, N'96962768984342528', N'done', N'en_US')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'78', NULL, NULL, NULL, NULL, N'96963159130112000', N'closed', N'en_US')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'79', NULL, NULL, NULL, NULL, N'96963562651516928', N'refunding', N'en_US')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'80', NULL, NULL, NULL, NULL, N'97357187684237312', N'recharge', N'en_US')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'85', NULL, NULL, NULL, NULL, N'97366040169676800', N'ali pay', N'en_US')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'86', NULL, NULL, NULL, NULL, N'97366110180999168', N'wechat pay', N'en_US')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'87', NULL, NULL, NULL, NULL, N'97536125287006208', N'product', N'en_US')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'88', NULL, NULL, NULL, NULL, N'97536221990879232', N'safe', N'en_US')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'89', NULL, NULL, NULL, NULL, N'97536285903683584', N'service', N'en_US')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'90', NULL, NULL, NULL, NULL, N'97536343411785728', N'activity', N'en_US')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'91', NULL, NULL, NULL, NULL, N'97536415625117696', N'history', N'en_US')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'92', NULL, NULL, NULL, NULL, N'97536494998126592', N'fault', N'en_US')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'93', NULL, NULL, NULL, NULL, N'99136468701675520', N'banner', N'en_US')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'94', NULL, NULL, NULL, NULL, N'155566528442400769', N'Rich Text', N'en_US')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'95', NULL, NULL, NULL, NULL, N'155566528442400768', N'Transfer', N'en_US')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'96', NULL, NULL, NULL, NULL, N'155566444615041024', N'ColorPicker', N'en_US')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'97', NULL, NULL, NULL, NULL, N'155566354039046144', N'Rate', N'en_US')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'98', NULL, NULL, NULL, NULL, N'155566295306207232', N'Upload', N'en_US')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'99', NULL, NULL, NULL, NULL, N'155566223822684160', N'DatePicker', N'en_US')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'100', NULL, NULL, NULL, NULL, N'155566122928701440', N'TimePicker', N'en_US')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'101', NULL, NULL, NULL, NULL, N'155566025453076480', N'Slider', N'en_US')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'102', NULL, NULL, NULL, NULL, N'155565960655273984', N'Switch', N'en_US')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'103', NULL, NULL, NULL, NULL, N'155565909979693056', N'Cascader', N'en_US')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'104', NULL, NULL, NULL, NULL, N'155565797303910400', N'Select', N'en_US')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'105', NULL, NULL, NULL, NULL, N'155565698930704384', N'InputNumber', N'en_US')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'106', NULL, NULL, NULL, NULL, N'155565420294701056', N'Checkbox', N'en_US')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'107', NULL, NULL, NULL, NULL, N'155565360102244352', N'Radio', N'en_US')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'108', NULL, NULL, NULL, NULL, N'155565261192167424', N'input', N'en_US')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'109', NULL, NULL, NULL, NULL, N'108265713587716096', N'on', N'en_US')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'110', NULL, NULL, NULL, NULL, N'108265787696873472', N'off', N'en_US')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'111', NULL, NULL, NULL, NULL, N'113787304258043904', N'draft', N'en_US')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'112', NULL, NULL, NULL, NULL, N'113787421593698304', N'published', N'en_US')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'113', NULL, NULL, NULL, NULL, N'119131930154237952', N'enabled', N'en_US')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'114', NULL, NULL, NULL, NULL, N'119132047645081600', N'disabled', N'en_US')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'115', NULL, NULL, NULL, NULL, N'155566122928701441', N'DateTimePicker', N'en_US')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'116', NULL, NULL, NULL, NULL, N'155566122928701441', N'日期时间选择器', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dt_multi_languages] VALUES (N'167346041576751104', NULL, NULL, NULL, NULL, N'167346041534808064', N'demo1', N'en_US')
GO


-- ----------------------------
-- Table structure for t_s_dtg_multi_languages
-- ----------------------------
IF EXISTS (SELECT * FROM sys.all_objects WHERE object_id = OBJECT_ID(N'[dbo].[t_s_dtg_multi_languages]') AND type IN ('U'))
	DROP TABLE [dbo].[t_s_dtg_multi_languages]
GO

CREATE TABLE [dbo].[t_s_dtg_multi_languages] (
  [id] bigint  NOT NULL,
  [create_by] bigint  NULL,
  [create_date] datetime2(0)  NULL,
  [update_by] bigint  NULL,
  [update_date] datetime2(0)  NULL,
  [dict_type_group_id] bigint  NOT NULL,
  [name] nvarchar(255) COLLATE Chinese_PRC_CI_AS  NULL,
  [language] nvarchar(25) COLLATE Chinese_PRC_CI_AS  NOT NULL
)
GO

ALTER TABLE [dbo].[t_s_dtg_multi_languages] SET (LOCK_ESCALATION = TABLE)
GO

EXEC sp_addextendedproperty
'MS_Description', N'id',
'SCHEMA', N'dbo',
'TABLE', N't_s_dtg_multi_languages',
'COLUMN', N'id'
GO

EXEC sp_addextendedproperty
'MS_Description', N'创建人id',
'SCHEMA', N'dbo',
'TABLE', N't_s_dtg_multi_languages',
'COLUMN', N'create_by'
GO

EXEC sp_addextendedproperty
'MS_Description', N'创建时间',
'SCHEMA', N'dbo',
'TABLE', N't_s_dtg_multi_languages',
'COLUMN', N'create_date'
GO

EXEC sp_addextendedproperty
'MS_Description', N'更新人id',
'SCHEMA', N'dbo',
'TABLE', N't_s_dtg_multi_languages',
'COLUMN', N'update_by'
GO

EXEC sp_addextendedproperty
'MS_Description', N'更新时间',
'SCHEMA', N'dbo',
'TABLE', N't_s_dtg_multi_languages',
'COLUMN', N'update_date'
GO

EXEC sp_addextendedproperty
'MS_Description', N'字典组id',
'SCHEMA', N'dbo',
'TABLE', N't_s_dtg_multi_languages',
'COLUMN', N'dict_type_group_id'
GO

EXEC sp_addextendedproperty
'MS_Description', N'字典组名称',
'SCHEMA', N'dbo',
'TABLE', N't_s_dtg_multi_languages',
'COLUMN', N'name'
GO

EXEC sp_addextendedproperty
'MS_Description', N'语言',
'SCHEMA', N'dbo',
'TABLE', N't_s_dtg_multi_languages',
'COLUMN', N'language'
GO

EXEC sp_addextendedproperty
'MS_Description', N'字典组多语言',
'SCHEMA', N'dbo',
'TABLE', N't_s_dtg_multi_languages'
GO


-- ----------------------------
-- Records of t_s_dtg_multi_languages
-- ----------------------------
INSERT INTO [dbo].[t_s_dtg_multi_languages] VALUES (N'1', NULL, NULL, NULL, NULL, N'1', N'登录方式', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dtg_multi_languages] VALUES (N'2', NULL, NULL, NULL, NULL, N'2', N'状态', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dtg_multi_languages] VALUES (N'3', NULL, NULL, NULL, NULL, N'3', N'角色种类', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dtg_multi_languages] VALUES (N'4', NULL, NULL, NULL, NULL, N'4', N'性别', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dtg_multi_languages] VALUES (N'5', NULL, NULL, NULL, NULL, N'5', N'登录状态', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dtg_multi_languages] VALUES (N'6', NULL, NULL, NULL, NULL, N'6', N'闹钟状态', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dtg_multi_languages] VALUES (N'7', NULL, NULL, NULL, NULL, N'7', N'菜单类型', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dtg_multi_languages] VALUES (N'8', NULL, NULL, NULL, NULL, N'96950073392365568', N'订单状态', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dtg_multi_languages] VALUES (N'9', NULL, NULL, NULL, NULL, N'97356870024429568', N'账单类型', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dtg_multi_languages] VALUES (N'10', NULL, NULL, NULL, NULL, N'97365554750291968', N'支付方式', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dtg_multi_languages] VALUES (N'11', NULL, NULL, NULL, NULL, N'97535843673047040', N'消息类型', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dtg_multi_languages] VALUES (N'12', NULL, NULL, NULL, NULL, N'99135515659337728', N'新闻类型', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dtg_multi_languages] VALUES (N'13', NULL, NULL, NULL, NULL, N'155564655257845760', N'饿了么Element组件', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dtg_multi_languages] VALUES (N'14', NULL, NULL, NULL, NULL, N'108265224984854528', N'job状态', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dtg_multi_languages] VALUES (N'15', NULL, NULL, NULL, NULL, N'113787027396231168', N'新闻状态', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dtg_multi_languages] VALUES (N'16', NULL, NULL, NULL, NULL, N'113787027396231169', N'有效状态', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_dtg_multi_languages] VALUES (N'17', NULL, NULL, NULL, NULL, N'1', N'login type', N'en_US')
GO

INSERT INTO [dbo].[t_s_dtg_multi_languages] VALUES (N'18', NULL, NULL, NULL, NULL, N'2', N'status', N'en_US')
GO

INSERT INTO [dbo].[t_s_dtg_multi_languages] VALUES (N'19', NULL, NULL, NULL, NULL, N'3', N'role type', N'en_US')
GO

INSERT INTO [dbo].[t_s_dtg_multi_languages] VALUES (N'20', NULL, NULL, NULL, NULL, N'4', N'sex type', N'en_US')
GO

INSERT INTO [dbo].[t_s_dtg_multi_languages] VALUES (N'21', NULL, NULL, NULL, NULL, N'5', N'login status', N'en_US')
GO

INSERT INTO [dbo].[t_s_dtg_multi_languages] VALUES (N'22', NULL, NULL, NULL, NULL, N'6', N'alarm clock status', N'en_US')
GO

INSERT INTO [dbo].[t_s_dtg_multi_languages] VALUES (N'23', NULL, NULL, NULL, NULL, N'7', N'menu type', N'en_US')
GO

INSERT INTO [dbo].[t_s_dtg_multi_languages] VALUES (N'24', NULL, NULL, NULL, NULL, N'96950073392365568', N'bill status', N'en_US')
GO

INSERT INTO [dbo].[t_s_dtg_multi_languages] VALUES (N'25', NULL, NULL, NULL, NULL, N'97356870024429568', N'bill type', N'en_US')
GO

INSERT INTO [dbo].[t_s_dtg_multi_languages] VALUES (N'26', NULL, NULL, NULL, NULL, N'97365554750291968', N'payment type', N'en_US')
GO

INSERT INTO [dbo].[t_s_dtg_multi_languages] VALUES (N'27', NULL, NULL, NULL, NULL, N'97535843673047040', N'message type', N'en_US')
GO

INSERT INTO [dbo].[t_s_dtg_multi_languages] VALUES (N'28', NULL, NULL, NULL, NULL, N'99135515659337728', N'news type', N'en_US')
GO

INSERT INTO [dbo].[t_s_dtg_multi_languages] VALUES (N'29', NULL, NULL, NULL, NULL, N'155564655257845760', N'Element component', N'en_US')
GO

INSERT INTO [dbo].[t_s_dtg_multi_languages] VALUES (N'30', NULL, NULL, NULL, NULL, N'108265224984854528', N'job status', N'en_US')
GO

INSERT INTO [dbo].[t_s_dtg_multi_languages] VALUES (N'31', NULL, NULL, NULL, NULL, N'113787027396231168', N'news status', N'en_US')
GO

INSERT INTO [dbo].[t_s_dtg_multi_languages] VALUES (N'32', NULL, NULL, NULL, NULL, N'113787027396231169', N'enabled status', N'en_US')
GO

INSERT INTO [dbo].[t_s_dtg_multi_languages] VALUES (N'167345989231837184', NULL, NULL, NULL, NULL, N'167345989147951104', N'demo', N'en_US')
GO


-- ----------------------------
-- Table structure for t_s_font_awesome
-- ----------------------------
IF EXISTS (SELECT * FROM sys.all_objects WHERE object_id = OBJECT_ID(N'[dbo].[t_s_font_awesome]') AND type IN ('U'))
	DROP TABLE [dbo].[t_s_font_awesome]
GO

CREATE TABLE [dbo].[t_s_font_awesome] (
  [id] int  NOT NULL,
  [create_by] bigint  NULL,
  [create_date] datetime2(0)  NULL,
  [update_by] bigint  NULL,
  [update_date] datetime2(0)  NULL,
  [icon_class] nvarchar(50) COLLATE Chinese_PRC_CI_AS  NOT NULL,
  [label_en_us] nvarchar(50) COLLATE Chinese_PRC_CI_AS  NOT NULL,
  [label_zh_cn] nvarchar(50) COLLATE Chinese_PRC_CI_AS  NOT NULL,
  [order_num] int  NULL,
  [status] int  NULL
)
GO

ALTER TABLE [dbo].[t_s_font_awesome] SET (LOCK_ESCALATION = TABLE)
GO

EXEC sp_addextendedproperty
'MS_Description', N'id',
'SCHEMA', N'dbo',
'TABLE', N't_s_font_awesome',
'COLUMN', N'id'
GO

EXEC sp_addextendedproperty
'MS_Description', N'创建人id',
'SCHEMA', N'dbo',
'TABLE', N't_s_font_awesome',
'COLUMN', N'create_by'
GO

EXEC sp_addextendedproperty
'MS_Description', N'创建时间',
'SCHEMA', N'dbo',
'TABLE', N't_s_font_awesome',
'COLUMN', N'create_date'
GO

EXEC sp_addextendedproperty
'MS_Description', N'更新人id',
'SCHEMA', N'dbo',
'TABLE', N't_s_font_awesome',
'COLUMN', N'update_by'
GO

EXEC sp_addextendedproperty
'MS_Description', N'更新时间',
'SCHEMA', N'dbo',
'TABLE', N't_s_font_awesome',
'COLUMN', N'update_date'
GO

EXEC sp_addextendedproperty
'MS_Description', N'图标class',
'SCHEMA', N'dbo',
'TABLE', N't_s_font_awesome',
'COLUMN', N'icon_class'
GO

EXEC sp_addextendedproperty
'MS_Description', N'排序',
'SCHEMA', N'dbo',
'TABLE', N't_s_font_awesome',
'COLUMN', N'order_num'
GO

EXEC sp_addextendedproperty
'MS_Description', N'状态',
'SCHEMA', N'dbo',
'TABLE', N't_s_font_awesome',
'COLUMN', N'status'
GO

EXEC sp_addextendedproperty
'MS_Description', N'Font Awesome字体图标',
'SCHEMA', N'dbo',
'TABLE', N't_s_font_awesome'
GO


-- ----------------------------
-- Records of t_s_font_awesome
-- ----------------------------
INSERT INTO [dbo].[t_s_font_awesome] VALUES (N'2', N'1000000005', N'2019-05-05 01:13:35', N'1000000005', N'2019-05-05 01:13:35', N'fas fa-user', N'user', N'用户', N'1', N'1')
GO

INSERT INTO [dbo].[t_s_font_awesome] VALUES (N'3', N'1000000005', N'2019-05-05 01:13:35', N'1000000005', N'2019-05-05 01:13:35', N'fas fa-user-circle', N'user-circle', N'用户，圆形用户', N'1', N'1')
GO

INSERT INTO [dbo].[t_s_font_awesome] VALUES (N'4', N'1000000005', N'2019-05-05 01:13:35', N'1000000005', N'2019-05-05 01:13:35', N'fas fa-tasks', N'tasks', N'任务', N'1', N'1')
GO

INSERT INTO [dbo].[t_s_font_awesome] VALUES (N'5', N'1000000005', N'2019-05-05 01:13:35', N'1000000005', N'2019-05-05 01:13:35', N'fas fa-cog', N'cog', N'设置', N'1', N'1')
GO

INSERT INTO [dbo].[t_s_font_awesome] VALUES (N'6', N'1000000005', N'2019-05-05 01:13:35', N'1000000005', N'2019-05-05 01:13:35', N'fas fa-cogs', N'cogs', N'设置', N'1', N'1')
GO

INSERT INTO [dbo].[t_s_font_awesome] VALUES (N'7', N'1000000005', N'2019-05-05 01:13:35', N'1000000005', N'2019-05-05 01:13:35', N'fas fa-tools', N'tools', N'工具，设置', N'1', N'1')
GO

INSERT INTO [dbo].[t_s_font_awesome] VALUES (N'8', N'1000000005', N'2019-05-05 01:13:35', N'1000000005', N'2019-05-05 01:13:35', N'fas fa-list-ol', N'list-ol', N'列表，有序列表', N'1', N'1')
GO

INSERT INTO [dbo].[t_s_font_awesome] VALUES (N'9', N'1000000005', N'2019-05-05 01:13:35', N'1000000005', N'2019-05-05 01:13:35', N'fas fa-list-ul', N'list-ul', N'列表，无序列表', N'1', N'1')
GO

INSERT INTO [dbo].[t_s_font_awesome] VALUES (N'10', N'1000000005', N'2019-05-05 01:13:35', N'1000000005', N'2019-05-05 01:13:35', N'fas fa-bell', N'bell', N'铃，钟，提示，消息，信息', N'1', N'1')
GO

INSERT INTO [dbo].[t_s_font_awesome] VALUES (N'11', N'1000000005', N'2019-05-05 01:13:35', N'1000000005', N'2019-05-05 01:13:35', N'fas fa-exclamation-circle', N'exclamation-circle', N'感叹号，提示，消息，圆形', N'1', N'1')
GO

INSERT INTO [dbo].[t_s_font_awesome] VALUES (N'12', N'1000000005', N'2019-05-05 01:13:35', N'1000000005', N'2019-05-05 01:13:35', N'fas fa-exclamation-triangle', N'exclamation-triangle', N'感叹号，提示，消息，三角形', N'1', N'1')
GO

INSERT INTO [dbo].[t_s_font_awesome] VALUES (N'13', N'1000000005', N'2019-05-05 01:13:35', N'1000000005', N'2019-05-05 01:13:35', N'fas fa-address-book', N'address-book', N'通讯录，用户', N'1', N'1')
GO

INSERT INTO [dbo].[t_s_font_awesome] VALUES (N'14', N'1000000005', N'2019-05-05 01:13:35', N'1000000005', N'2019-05-05 01:13:35', N'fas fa-address-card', N'address-card', N'地址卡，用户', N'1', N'1')
GO

INSERT INTO [dbo].[t_s_font_awesome] VALUES (N'15', N'1000000005', N'2019-05-05 01:13:35', N'1000000005', N'2019-05-05 01:13:35', N'fas fa-book', N'book', N'书，书籍，字典，数据，数据字典', N'1', N'1')
GO

INSERT INTO [dbo].[t_s_font_awesome] VALUES (N'16', N'1000000005', N'2019-05-05 01:13:35', N'1000000005', N'2019-05-05 01:13:35', N'fas fa-calendar', N'calendar', N'日历', N'1', N'1')
GO

INSERT INTO [dbo].[t_s_font_awesome] VALUES (N'17', N'1000000005', N'2019-05-05 01:13:35', N'1000000005', N'2019-05-05 01:13:35', N'fas fa-calendar-alt', N'calendar-alt', N'日历', N'1', N'1')
GO

INSERT INTO [dbo].[t_s_font_awesome] VALUES (N'18', N'1000000005', N'2019-05-05 01:13:35', N'1000000005', N'2019-05-05 01:13:35', N'fas fa-chart-area', N'chart-area', N'图表', N'1', N'1')
GO

INSERT INTO [dbo].[t_s_font_awesome] VALUES (N'19', N'1000000005', N'2019-05-05 01:13:35', N'1000000005', N'2019-05-05 01:13:35', N'fas fa-chart-bar', N'chart-bar', N'图表', N'1', N'1')
GO

INSERT INTO [dbo].[t_s_font_awesome] VALUES (N'20', N'1000000005', N'2019-05-05 01:13:35', N'1000000005', N'2019-05-05 01:13:35', N'fas fa-chart-line', N'chart-line', N'图表', N'1', N'1')
GO

INSERT INTO [dbo].[t_s_font_awesome] VALUES (N'21', N'1000000005', N'2019-05-05 01:13:35', N'1000000005', N'2019-05-05 01:13:35', N'fas fa-chart-pie', N'chart-pie', N'图表', N'1', N'1')
GO

INSERT INTO [dbo].[t_s_font_awesome] VALUES (N'22', N'1000000005', N'2019-05-05 01:13:35', N'1000000005', N'2019-05-05 01:13:35', N'fas fa-coffee', N'coffee', N'咖啡', N'1', N'1')
GO

INSERT INTO [dbo].[t_s_font_awesome] VALUES (N'23', N'1000000005', N'2019-05-05 01:13:35', N'1000000005', N'2019-05-05 01:13:35', N'fas fa-compass', N'compass', N'指南针，罗盘，消息', N'1', N'1')
GO

INSERT INTO [dbo].[t_s_font_awesome] VALUES (N'24', N'1000000005', N'2019-05-05 01:13:35', N'1000000005', N'2019-05-05 01:13:35', N'fas fa-leaf', N'leaf', N'树叶', N'1', N'1')
GO

INSERT INTO [dbo].[t_s_font_awesome] VALUES (N'25', N'1000000005', N'2019-05-05 01:13:35', N'1000000005', N'2019-05-05 01:13:35', N'fas fa-comment-dots', N'comment-dots', N'评论，聊天', N'1', N'1')
GO

INSERT INTO [dbo].[t_s_font_awesome] VALUES (N'26', N'1000000005', N'2019-05-05 01:13:35', N'1000000005', N'2019-05-05 01:13:35', N'fas fa-comment', N'comment', N'评论，聊天', N'1', N'1')
GO

INSERT INTO [dbo].[t_s_font_awesome] VALUES (N'27', N'1000000005', N'2019-05-05 01:13:35', N'1000000005', N'2019-05-05 01:13:35', N'fas fa-comment-alt', N'comment-alt', N'评论，聊天', N'1', N'1')
GO

INSERT INTO [dbo].[t_s_font_awesome] VALUES (N'28', N'1000000005', N'2019-05-05 01:13:35', N'1000000005', N'2019-05-05 01:13:35', N'fas fa-comments', N'comments', N'评论，聊天', N'1', N'1')
GO

INSERT INTO [dbo].[t_s_font_awesome] VALUES (N'29', N'1000000005', N'2019-05-05 01:13:35', N'1000000005', N'2019-05-05 01:13:35', N'fas fa-code', N'code', N'代码，编码', N'1', N'1')
GO

INSERT INTO [dbo].[t_s_font_awesome] VALUES (N'30', N'1000000005', N'2019-05-05 01:13:35', N'1000000005', N'2019-05-05 01:13:35', N'fas fa-bug', N'bug', N'bug，日志，调试，代码，编码', N'1', N'1')
GO

INSERT INTO [dbo].[t_s_font_awesome] VALUES (N'31', N'1000000005', N'2019-05-05 01:13:35', N'1000000005', N'2019-05-05 01:13:35', N'fas fa-archive', N'archive', N'档案，存档，文件', N'1', N'1')
GO

INSERT INTO [dbo].[t_s_font_awesome] VALUES (N'32', N'1000000005', N'2019-05-05 01:13:35', N'1000000005', N'2019-05-05 01:13:35', N'fas fa-file', N'file', N'文件，文档', N'1', N'1')
GO

INSERT INTO [dbo].[t_s_font_awesome] VALUES (N'33', N'1000000005', N'2019-05-05 01:13:35', N'1000000005', N'2019-05-05 01:13:35', N'fas fa-file-alt', N'file-alt', N'文件', N'1', N'1')
GO

INSERT INTO [dbo].[t_s_font_awesome] VALUES (N'34', N'1000000005', N'2019-05-05 01:13:35', N'1000000005', N'2019-05-05 01:13:35', N'fas fa-envelope', N'envelope', N'信封，收件箱，消息', N'1', N'1')
GO

INSERT INTO [dbo].[t_s_font_awesome] VALUES (N'35', N'1000000005', N'2019-05-05 01:13:35', N'1000000005', N'2019-05-05 01:13:35', N'fas fa-database', N'database', N'数据库', N'1', N'1')
GO

INSERT INTO [dbo].[t_s_font_awesome] VALUES (N'36', N'1000000005', N'2019-05-05 01:13:35', N'1000000005', N'2019-05-05 01:13:35', N'fas fa-desktop', N'desktop', N'桌面，台式机，电脑', N'1', N'1')
GO

INSERT INTO [dbo].[t_s_font_awesome] VALUES (N'37', N'1000000005', N'2019-05-05 01:13:35', N'1000000005', N'2019-05-05 01:13:35', N'fas fa-clock', N'clock', N'时钟，任务', N'1', N'1')
GO

INSERT INTO [dbo].[t_s_font_awesome] VALUES (N'38', N'1000000005', N'2019-05-05 01:13:35', N'1000000005', N'2019-05-05 01:13:35', N'fas fa-ban', N'ban', N'禁止，黑名单', N'1', N'1')
GO

INSERT INTO [dbo].[t_s_font_awesome] VALUES (N'39', N'1000000005', N'2019-05-05 01:13:35', N'1000000005', N'2019-05-05 01:13:35', N'fas fa-lock', N'lock', N'锁，权限', N'1', N'1')
GO

INSERT INTO [dbo].[t_s_font_awesome] VALUES (N'40', N'1000000005', N'2019-05-05 01:13:35', N'1000000005', N'2019-05-05 01:13:35', N'fas fa-tshirt', N'tshirt', N'T恤，换肤，皮肤', N'1', N'1')
GO

INSERT INTO [dbo].[t_s_font_awesome] VALUES (N'41', N'1000000005', N'2019-05-05 01:13:35', N'1000000005', N'2019-05-05 01:13:35', N'fas fa-heart', N'heart', N'心，喜欢，收藏', N'1', N'1')
GO

INSERT INTO [dbo].[t_s_font_awesome] VALUES (N'42', N'1000000005', N'2019-05-05 01:13:35', N'1000000005', N'2019-05-05 01:13:35', N'fas fa-home', N'home', N'主页', N'1', N'1')
GO

INSERT INTO [dbo].[t_s_font_awesome] VALUES (N'43', N'1000000005', N'2019-05-05 01:13:35', N'1000000005', N'2019-05-05 01:13:35', N'fas fa-dollar-sign', N'dollar-sign', N'美元', N'1', N'1')
GO

INSERT INTO [dbo].[t_s_font_awesome] VALUES (N'44', N'1000000005', N'2019-05-05 01:13:35', N'1000000005', N'2019-05-05 01:13:35', N'fas fa-wallet', N'wallet', N'钱包', N'1', N'1')
GO

INSERT INTO [dbo].[t_s_font_awesome] VALUES (N'45', N'1000000000', N'2019-05-21 14:58:07', NULL, NULL, N'fas fa-save', N'save', N'保存', N'1', N'1')
GO

INSERT INTO [dbo].[t_s_font_awesome] VALUES (N'46', N'1000000000', N'2019-05-24 09:43:16', NULL, NULL, N'fas fa-play-circle', N'play-circle', N'播放，开始', N'1', N'1')
GO

INSERT INTO [dbo].[t_s_font_awesome] VALUES (N'47', N'1000000000', N'2019-05-24 09:44:00', NULL, NULL, N'fas fa-stop-circle', N'stop-circle', N'停止，结束', N'1', N'1')
GO

INSERT INTO [dbo].[t_s_font_awesome] VALUES (N'48', N'1000000000', N'2019-05-24 09:47:36', NULL, NULL, N'fas fa-trash-alt', N'trash-alt', N'删除', N'1', N'1')
GO

INSERT INTO [dbo].[t_s_font_awesome] VALUES (N'49', N'1000000000', N'2019-05-24 09:48:22', NULL, NULL, N'fas fa-edit', N'edit', N'编辑，修改', N'1', N'1')
GO

INSERT INTO [dbo].[t_s_font_awesome] VALUES (N'50', N'1000000000', N'2019-05-24 09:49:52', NULL, NULL, N'fas fa-play', N'play', N'播放，开始', N'1', N'1')
GO

INSERT INTO [dbo].[t_s_font_awesome] VALUES (N'51', N'1000000000', N'2019-05-24 09:50:34', N'1000000000', N'2019-05-24 09:51:29', N'fas fa-stop', N'stop', N'停止，结束', N'1', N'1')
GO

INSERT INTO [dbo].[t_s_font_awesome] VALUES (N'52', N'1000000000', N'2019-05-24 09:50:56', NULL, NULL, N'fas fa-pause', N'pause', N'暂停', N'1', N'1')
GO

INSERT INTO [dbo].[t_s_font_awesome] VALUES (N'53', N'1000000000', N'2019-05-24 09:51:08', NULL, NULL, N'fas fa-pause-circle', N'pause-circle', N'暂停', N'1', N'1')
GO

INSERT INTO [dbo].[t_s_font_awesome] VALUES (N'54', N'1000000000', N'2019-05-27 09:56:57', NULL, NULL, N'fas fa-language', N'language', N'语言，翻译', N'1', N'1')
GO


-- ----------------------------
-- Table structure for t_s_province
-- ----------------------------
IF EXISTS (SELECT * FROM sys.all_objects WHERE object_id = OBJECT_ID(N'[dbo].[t_s_province]') AND type IN ('U'))
	DROP TABLE [dbo].[t_s_province]
GO

CREATE TABLE [dbo].[t_s_province] (
  [id] int  NOT NULL,
  [name] nvarchar(64) COLLATE Chinese_PRC_CI_AS  NULL,
  [province_id] nvarchar(12) COLLATE Chinese_PRC_CI_AS  NULL
)
GO

ALTER TABLE [dbo].[t_s_province] SET (LOCK_ESCALATION = TABLE)
GO


-- ----------------------------
-- Records of t_s_province
-- ----------------------------
INSERT INTO [dbo].[t_s_province] VALUES (N'1', N'北京市', N'110000000000')
GO

INSERT INTO [dbo].[t_s_province] VALUES (N'2', N'天津市', N'120000000000')
GO

INSERT INTO [dbo].[t_s_province] VALUES (N'3', N'河北省', N'130000000000')
GO

INSERT INTO [dbo].[t_s_province] VALUES (N'4', N'山西省', N'140000000000')
GO

INSERT INTO [dbo].[t_s_province] VALUES (N'5', N'内蒙古自治区', N'150000000000')
GO

INSERT INTO [dbo].[t_s_province] VALUES (N'6', N'辽宁省', N'210000000000')
GO

INSERT INTO [dbo].[t_s_province] VALUES (N'7', N'吉林省', N'220000000000')
GO

INSERT INTO [dbo].[t_s_province] VALUES (N'8', N'黑龙江省', N'230000000000')
GO

INSERT INTO [dbo].[t_s_province] VALUES (N'9', N'上海市', N'310000000000')
GO

INSERT INTO [dbo].[t_s_province] VALUES (N'10', N'江苏省', N'320000000000')
GO

INSERT INTO [dbo].[t_s_province] VALUES (N'11', N'浙江省', N'330000000000')
GO

INSERT INTO [dbo].[t_s_province] VALUES (N'12', N'安徽省', N'340000000000')
GO

INSERT INTO [dbo].[t_s_province] VALUES (N'13', N'福建省', N'350000000000')
GO

INSERT INTO [dbo].[t_s_province] VALUES (N'14', N'江西省', N'360000000000')
GO

INSERT INTO [dbo].[t_s_province] VALUES (N'15', N'山东省', N'370000000000')
GO

INSERT INTO [dbo].[t_s_province] VALUES (N'16', N'河南省', N'410000000000')
GO

INSERT INTO [dbo].[t_s_province] VALUES (N'17', N'湖北省', N'420000000000')
GO

INSERT INTO [dbo].[t_s_province] VALUES (N'18', N'湖南省', N'430000000000')
GO

INSERT INTO [dbo].[t_s_province] VALUES (N'19', N'广东省', N'440000000000')
GO

INSERT INTO [dbo].[t_s_province] VALUES (N'20', N'广西壮族自治区', N'450000000000')
GO

INSERT INTO [dbo].[t_s_province] VALUES (N'21', N'海南省', N'460000000000')
GO

INSERT INTO [dbo].[t_s_province] VALUES (N'22', N'重庆市', N'500000000000')
GO

INSERT INTO [dbo].[t_s_province] VALUES (N'23', N'四川省', N'510000000000')
GO

INSERT INTO [dbo].[t_s_province] VALUES (N'24', N'贵州省', N'520000000000')
GO

INSERT INTO [dbo].[t_s_province] VALUES (N'25', N'云南省', N'530000000000')
GO

INSERT INTO [dbo].[t_s_province] VALUES (N'26', N'西藏自治区', N'540000000000')
GO

INSERT INTO [dbo].[t_s_province] VALUES (N'27', N'陕西省', N'610000000000')
GO

INSERT INTO [dbo].[t_s_province] VALUES (N'28', N'甘肃省', N'620000000000')
GO

INSERT INTO [dbo].[t_s_province] VALUES (N'29', N'青海省', N'630000000000')
GO

INSERT INTO [dbo].[t_s_province] VALUES (N'30', N'宁夏回族自治区', N'640000000000')
GO

INSERT INTO [dbo].[t_s_province] VALUES (N'31', N'新疆维吾尔自治区', N'650000000000')
GO


-- ----------------------------
-- Table structure for t_s_quartz_job
-- ----------------------------
IF EXISTS (SELECT * FROM sys.all_objects WHERE object_id = OBJECT_ID(N'[dbo].[t_s_quartz_job]') AND type IN ('U'))
	DROP TABLE [dbo].[t_s_quartz_job]
GO

CREATE TABLE [dbo].[t_s_quartz_job] (
  [id] bigint  NOT NULL,
  [create_by] bigint  NULL,
  [create_date] datetime2(0)  NULL,
  [update_by] bigint  NULL,
  [update_date] datetime2(0)  NULL,
  [cron_expression] nvarchar(50) COLLATE Chinese_PRC_CI_AS  NULL,
  [method_name] nvarchar(255) COLLATE Chinese_PRC_CI_AS  NULL,
  [is_concurrent] int  NULL,
  [description] nvarchar(255) COLLATE Chinese_PRC_CI_AS  NULL,
  [bean_name] nvarchar(255) COLLATE Chinese_PRC_CI_AS  NULL,
  [trigger_name] nvarchar(255) COLLATE Chinese_PRC_CI_AS  NULL,
  [job_status] int  NULL,
  [spring_bean] nvarchar(255) COLLATE Chinese_PRC_CI_AS  NULL,
  [job_name] nvarchar(255) COLLATE Chinese_PRC_CI_AS  NULL
)
GO

ALTER TABLE [dbo].[t_s_quartz_job] SET (LOCK_ESCALATION = TABLE)
GO

EXEC sp_addextendedproperty
'MS_Description', N'id',
'SCHEMA', N'dbo',
'TABLE', N't_s_quartz_job',
'COLUMN', N'id'
GO

EXEC sp_addextendedproperty
'MS_Description', N'创建人id',
'SCHEMA', N'dbo',
'TABLE', N't_s_quartz_job',
'COLUMN', N'create_by'
GO

EXEC sp_addextendedproperty
'MS_Description', N'创建时间',
'SCHEMA', N'dbo',
'TABLE', N't_s_quartz_job',
'COLUMN', N'create_date'
GO

EXEC sp_addextendedproperty
'MS_Description', N'更新人id',
'SCHEMA', N'dbo',
'TABLE', N't_s_quartz_job',
'COLUMN', N'update_by'
GO

EXEC sp_addextendedproperty
'MS_Description', N'更新时间',
'SCHEMA', N'dbo',
'TABLE', N't_s_quartz_job',
'COLUMN', N'update_date'
GO

EXEC sp_addextendedproperty
'MS_Description', N'cron表达式',
'SCHEMA', N'dbo',
'TABLE', N't_s_quartz_job',
'COLUMN', N'cron_expression'
GO

EXEC sp_addextendedproperty
'MS_Description', N'任务调用的方法名',
'SCHEMA', N'dbo',
'TABLE', N't_s_quartz_job',
'COLUMN', N'method_name'
GO

EXEC sp_addextendedproperty
'MS_Description', N'任务是否有状态',
'SCHEMA', N'dbo',
'TABLE', N't_s_quartz_job',
'COLUMN', N'is_concurrent'
GO

EXEC sp_addextendedproperty
'MS_Description', N'描述',
'SCHEMA', N'dbo',
'TABLE', N't_s_quartz_job',
'COLUMN', N'description'
GO

EXEC sp_addextendedproperty
'MS_Description', N'任务执行时调用哪个类的方法 包名+类名，完全限定名',
'SCHEMA', N'dbo',
'TABLE', N't_s_quartz_job',
'COLUMN', N'bean_name'
GO

EXEC sp_addextendedproperty
'MS_Description', N'触发器名称',
'SCHEMA', N'dbo',
'TABLE', N't_s_quartz_job',
'COLUMN', N'trigger_name'
GO

EXEC sp_addextendedproperty
'MS_Description', N'任务状态',
'SCHEMA', N'dbo',
'TABLE', N't_s_quartz_job',
'COLUMN', N'job_status'
GO

EXEC sp_addextendedproperty
'MS_Description', N'任务名',
'SCHEMA', N'dbo',
'TABLE', N't_s_quartz_job',
'COLUMN', N'job_name'
GO

EXEC sp_addextendedproperty
'MS_Description', N'quartz任务',
'SCHEMA', N'dbo',
'TABLE', N't_s_quartz_job'
GO


-- ----------------------------
-- Records of t_s_quartz_job
-- ----------------------------
INSERT INTO [dbo].[t_s_quartz_job] VALUES (N'1', N'1', N'2018-12-21 22:21:26', N'1000000000', N'2019-01-25 14:25:43', N'*/5 * * * * ?', N'execute', N'0', N'测试', N'com.simon.task.SampleTask', N'org.quartz.CronTrigger', N'0', N'com.simon.task.SampleTask', N'com.simon.task.SampleTask')
GO


-- ----------------------------
-- Table structure for t_s_side_menu_multi_languages
-- ----------------------------
IF EXISTS (SELECT * FROM sys.all_objects WHERE object_id = OBJECT_ID(N'[dbo].[t_s_side_menu_multi_languages]') AND type IN ('U'))
	DROP TABLE [dbo].[t_s_side_menu_multi_languages]
GO

CREATE TABLE [dbo].[t_s_side_menu_multi_languages] (
  [id] bigint  NOT NULL,
  [create_by] bigint  NULL,
  [create_date] datetime2(0)  NULL,
  [update_by] bigint  NULL,
  [update_date] datetime2(0)  NULL,
  [side_menu_id] bigint  NOT NULL,
  [name] nvarchar(255) COLLATE Chinese_PRC_CI_AS  NULL,
  [language] nvarchar(25) COLLATE Chinese_PRC_CI_AS  NOT NULL
)
GO

ALTER TABLE [dbo].[t_s_side_menu_multi_languages] SET (LOCK_ESCALATION = TABLE)
GO

EXEC sp_addextendedproperty
'MS_Description', N'id',
'SCHEMA', N'dbo',
'TABLE', N't_s_side_menu_multi_languages',
'COLUMN', N'id'
GO

EXEC sp_addextendedproperty
'MS_Description', N'创建人id',
'SCHEMA', N'dbo',
'TABLE', N't_s_side_menu_multi_languages',
'COLUMN', N'create_by'
GO

EXEC sp_addextendedproperty
'MS_Description', N'创建时间',
'SCHEMA', N'dbo',
'TABLE', N't_s_side_menu_multi_languages',
'COLUMN', N'create_date'
GO

EXEC sp_addextendedproperty
'MS_Description', N'更新人id',
'SCHEMA', N'dbo',
'TABLE', N't_s_side_menu_multi_languages',
'COLUMN', N'update_by'
GO

EXEC sp_addextendedproperty
'MS_Description', N'更新时间',
'SCHEMA', N'dbo',
'TABLE', N't_s_side_menu_multi_languages',
'COLUMN', N'update_date'
GO

EXEC sp_addextendedproperty
'MS_Description', N'侧边栏菜单id',
'SCHEMA', N'dbo',
'TABLE', N't_s_side_menu_multi_languages',
'COLUMN', N'side_menu_id'
GO

EXEC sp_addextendedproperty
'MS_Description', N'侧边栏菜单名称',
'SCHEMA', N'dbo',
'TABLE', N't_s_side_menu_multi_languages',
'COLUMN', N'name'
GO

EXEC sp_addextendedproperty
'MS_Description', N'语言',
'SCHEMA', N'dbo',
'TABLE', N't_s_side_menu_multi_languages',
'COLUMN', N'language'
GO

EXEC sp_addextendedproperty
'MS_Description', N'侧边栏菜单多语言',
'SCHEMA', N'dbo',
'TABLE', N't_s_side_menu_multi_languages'
GO


-- ----------------------------
-- Records of t_s_side_menu_multi_languages
-- ----------------------------
INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'1', NULL, NULL, NULL, NULL, N'119869773617172480', N'删除', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'2', NULL, NULL, NULL, NULL, N'12', N'权限管理', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'3', NULL, NULL, NULL, NULL, N'3', N'数据字典', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'4', NULL, NULL, NULL, NULL, N'90997036798705664', N'druid', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'5', NULL, NULL, NULL, NULL, N'8', N'菜单管理', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'6', NULL, NULL, NULL, NULL, N'94108390556434432', N'了解OauthServer', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'7', NULL, NULL, NULL, NULL, N'1', N'系统管理', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'8', NULL, NULL, NULL, NULL, N'93126997827387392', N'日志管理', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'9', NULL, NULL, NULL, NULL, N'119869773600395264', N'修改', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'10', NULL, NULL, NULL, NULL, N'80832133433655296', N'代码生成', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'11', NULL, NULL, NULL, NULL, N'90995059306004480', N'系统工具', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'12', NULL, NULL, NULL, NULL, N'90995810619097088', N'swagger', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'13', NULL, NULL, NULL, NULL, N'94105929343041536', N'主页', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'14', NULL, NULL, NULL, NULL, N'119869773587812352', N'新增', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'15', NULL, NULL, NULL, NULL, N'118471356282179584', N'删除', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'16', NULL, NULL, NULL, NULL, N'118471356265402368', N'修改', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'17', NULL, NULL, NULL, NULL, N'118471356248625152', N'新增', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'18', NULL, NULL, NULL, NULL, N'118471356227653632', N'查看', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'19', NULL, NULL, NULL, NULL, N'118471356118601728', N'新闻管理', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'20', NULL, NULL, NULL, NULL, N'107876685461848070', N'角色管理', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'21', NULL, NULL, NULL, NULL, N'107876685461848071', N'订单管理', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'22', NULL, NULL, NULL, NULL, N'119869773415845888', N'任务管理', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'23', NULL, NULL, NULL, NULL, N'119494224726069248', N'删除', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'24', NULL, NULL, NULL, NULL, N'119869773566840832', N'查看', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'25', NULL, NULL, NULL, NULL, N'119494224713486336', N'修改', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'26', NULL, NULL, NULL, NULL, N'119494224361164800', N'用户管理', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'27', NULL, NULL, NULL, NULL, N'119494224675737600', N'查看', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'28', NULL, NULL, NULL, NULL, N'119494224700903424', N'新增', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'29', NULL, NULL, NULL, NULL, N'155328152225185792', N'组件管理', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'30', NULL, NULL, NULL, NULL, N'154250076045316096', N'图标管理', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'31', NULL, NULL, NULL, NULL, N'154250076150173696', N'查看', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'32', NULL, NULL, NULL, NULL, N'154250076171145216', N'新增', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'33', NULL, NULL, NULL, NULL, N'154250076196311040', N'修改', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'34', NULL, NULL, NULL, NULL, N'154250076221476864', N'删除', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'35', NULL, NULL, NULL, NULL, N'155328152225185793', N'删除', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'36', NULL, NULL, NULL, NULL, N'155328152225185794', N'修改', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'37', NULL, NULL, NULL, NULL, N'155328152225185795', N'新增', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'38', NULL, NULL, NULL, NULL, N'155328152225185796', N'查看', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'39', NULL, NULL, NULL, NULL, N'155328152225185797', N'删除', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'40', NULL, NULL, NULL, NULL, N'155328152225185798', N'修改', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'41', NULL, NULL, NULL, NULL, N'155328152225185799', N'新增', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'42', NULL, NULL, NULL, NULL, N'155328152225185800', N'查看', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'43', NULL, NULL, NULL, NULL, N'155328152225185801', N'删除', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'44', NULL, NULL, NULL, NULL, N'155328152225185802', N'修改', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'45', NULL, NULL, NULL, NULL, N'155328152225185803', N'新增', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'46', NULL, NULL, NULL, NULL, N'155328152225185804', N'查看', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'47', NULL, NULL, NULL, NULL, N'163710764928991232', N'富文本', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'48', NULL, NULL, NULL, NULL, N'164071030476767232', N'个人中心', N'zh_CN')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'49', NULL, NULL, NULL, NULL, N'119869773617172480', N'delete', N'en_US')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'50', NULL, NULL, NULL, NULL, N'12', N'authorities', N'en_US')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'51', NULL, NULL, NULL, NULL, N'3', N'dictonary', N'en_US')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'52', NULL, NULL, NULL, NULL, N'90997036798705664', N'druid', N'en_US')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'53', NULL, NULL, NULL, NULL, N'8', N'menus', N'en_US')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'54', NULL, NULL, NULL, NULL, N'94108390556434432', N'know OauthServer', N'en_US')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'55', NULL, NULL, NULL, NULL, N'1', N'system', N'en_US')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'56', NULL, NULL, NULL, NULL, N'93126997827387392', N'log', N'en_US')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'57', NULL, NULL, NULL, NULL, N'119869773600395264', N'edit', N'en_US')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'58', NULL, NULL, NULL, NULL, N'80832133433655296', N'code generator', N'en_US')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'59', NULL, NULL, NULL, NULL, N'90995059306004480', N'tools', N'en_US')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'60', NULL, NULL, NULL, NULL, N'90995810619097088', N'swagger', N'en_US')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'61', NULL, NULL, NULL, NULL, N'94105929343041536', N'home', N'en_US')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'62', NULL, NULL, NULL, NULL, N'119869773587812352', N'add', N'en_US')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'63', NULL, NULL, NULL, NULL, N'118471356282179584', N'delete', N'en_US')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'64', NULL, NULL, NULL, NULL, N'118471356265402368', N'edit', N'en_US')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'65', NULL, NULL, NULL, NULL, N'118471356248625152', N'add', N'en_US')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'66', NULL, NULL, NULL, NULL, N'118471356227653632', N'view', N'en_US')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'67', NULL, NULL, NULL, NULL, N'118471356118601728', N'news', N'en_US')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'68', NULL, NULL, NULL, NULL, N'107876685461848070', N'roles', N'en_US')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'69', NULL, NULL, NULL, NULL, N'107876685461848071', N'bill', N'en_US')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'70', NULL, NULL, NULL, NULL, N'119869773415845888', N'jobs', N'en_US')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'71', NULL, NULL, NULL, NULL, N'119494224726069248', N'delete', N'en_US')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'72', NULL, NULL, NULL, NULL, N'119869773566840832', N'view', N'en_US')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'73', NULL, NULL, NULL, NULL, N'119494224713486336', N'edit', N'en_US')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'74', NULL, NULL, NULL, NULL, N'119494224361164800', N'users', N'en_US')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'75', NULL, NULL, NULL, NULL, N'119494224675737600', N'view', N'en_US')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'76', NULL, NULL, NULL, NULL, N'119494224700903424', N'add', N'en_US')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'77', NULL, NULL, NULL, NULL, N'155328152225185792', N'components', N'en_US')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'78', NULL, NULL, NULL, NULL, N'154250076045316096', N'icons', N'en_US')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'79', NULL, NULL, NULL, NULL, N'154250076150173696', N'view', N'en_US')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'80', NULL, NULL, NULL, NULL, N'154250076171145216', N'add', N'en_US')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'81', NULL, NULL, NULL, NULL, N'154250076196311040', N'edit', N'en_US')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'82', NULL, NULL, NULL, NULL, N'154250076221476864', N'delete', N'en_US')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'83', NULL, NULL, NULL, NULL, N'155328152225185793', N'delete', N'en_US')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'84', NULL, NULL, NULL, NULL, N'155328152225185794', N'edit', N'en_US')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'85', NULL, NULL, NULL, NULL, N'155328152225185795', N'add', N'en_US')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'86', NULL, NULL, NULL, NULL, N'155328152225185796', N'view', N'en_US')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'87', NULL, NULL, NULL, NULL, N'155328152225185797', N'delete', N'en_US')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'88', NULL, NULL, NULL, NULL, N'155328152225185798', N'edit', N'en_US')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'89', NULL, NULL, NULL, NULL, N'155328152225185799', N'add', N'en_US')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'90', NULL, NULL, NULL, NULL, N'155328152225185800', N'view', N'en_US')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'91', NULL, NULL, NULL, NULL, N'155328152225185801', N'delete', N'en_US')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'92', NULL, NULL, NULL, NULL, N'155328152225185802', N'edit', N'en_US')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'93', NULL, NULL, NULL, NULL, N'155328152225185803', N'add', N'en_US')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'94', NULL, NULL, NULL, NULL, N'155328152225185804', N'view', N'en_US')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'95', NULL, NULL, NULL, NULL, N'163710764928991232', N'rich text', N'en_US')
GO

INSERT INTO [dbo].[t_s_side_menu_multi_languages] VALUES (N'96', NULL, NULL, NULL, NULL, N'164071030476767232', N'user center', N'en_US')
GO


-- ----------------------------
-- Table structure for t_s_town
-- ----------------------------
IF EXISTS (SELECT * FROM sys.all_objects WHERE object_id = OBJECT_ID(N'[dbo].[t_s_town]') AND type IN ('U'))
	DROP TABLE [dbo].[t_s_town]
GO

CREATE TABLE [dbo].[t_s_town] (
  [id] int  NOT NULL,
  [name] nvarchar(64) COLLATE Chinese_PRC_CI_AS  NULL,
  [town_id] nvarchar(12) COLLATE Chinese_PRC_CI_AS  NULL,
  [country_id] nvarchar(12) COLLATE Chinese_PRC_CI_AS  NULL
)
GO

ALTER TABLE [dbo].[t_s_town] SET (LOCK_ESCALATION = TABLE)
GO


-- ----------------------------
-- Records of t_s_town
-- ----------------------------
INSERT INTO [dbo].[t_s_town] VALUES (N'1', N'东华门街道办事处', N'110101001000', N'110101000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2', N'景山街道办事处', N'110101002000', N'110101000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3', N'交道口街道办事处', N'110101003000', N'110101000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4', N'安定门街道办事处', N'110101004000', N'110101000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5', N'北新桥街道办事处', N'110101005000', N'110101000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'6', N'东四街道办事处', N'110101006000', N'110101000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'7', N'朝阳门街道办事处', N'110101007000', N'110101000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'8', N'建国门街道办事处', N'110101008000', N'110101000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'9', N'东直门街道办事处', N'110101009000', N'110101000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'10', N'和平里街道办事处', N'110101010000', N'110101000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'11', N'前门街道办事处', N'110101011000', N'110101000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'12', N'崇文门外街道办事处', N'110101012000', N'110101000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'13', N'东花市街道办事处', N'110101013000', N'110101000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'14', N'龙潭街道办事处', N'110101014000', N'110101000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'15', N'体育馆路街道办事处', N'110101015000', N'110101000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'16', N'天坛街道办事处', N'110101016000', N'110101000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'17', N'永定门外街道办事处', N'110101017000', N'110101000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'18', N'西长安街街道办事处', N'110102001000', N'110102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'19', N'新街口街道办事处', N'110102003000', N'110102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'20', N'月坛街道办事处', N'110102007000', N'110102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'21', N'展览路街道办事处', N'110102009000', N'110102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'22', N'德胜街道办事处', N'110102010000', N'110102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'23', N'金融街街道办事处', N'110102011000', N'110102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'24', N'什刹海街道办事处', N'110102012000', N'110102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'25', N'大栅栏街道办事处', N'110102013000', N'110102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'26', N'天桥街道办事处', N'110102014000', N'110102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'27', N'椿树街道办事处', N'110102015000', N'110102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'28', N'陶然亭街道办事处', N'110102016000', N'110102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'29', N'广安门内街道办事处', N'110102017000', N'110102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'30', N'牛街街道办事处', N'110102018000', N'110102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'31', N'白纸坊街道办事处', N'110102019000', N'110102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'32', N'广安门外街道办事处', N'110102020000', N'110102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'33', N'建外街道办事处', N'110105001000', N'110105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'34', N'朝外街道办事处', N'110105002000', N'110105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'35', N'呼家楼街道办事处', N'110105003000', N'110105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'36', N'三里屯街道办事处', N'110105004000', N'110105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'37', N'左家庄街道办事处', N'110105005000', N'110105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'38', N'香河园街道办事处', N'110105006000', N'110105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'39', N'和平街街道办事处', N'110105007000', N'110105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'40', N'安贞街道办事处', N'110105008000', N'110105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'41', N'亚运村街道办事处', N'110105009000', N'110105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'42', N'小关街道办事处', N'110105010000', N'110105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'43', N'酒仙桥街道办事处', N'110105011000', N'110105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'44', N'麦子店街道办事处', N'110105012000', N'110105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'45', N'团结湖街道办事处', N'110105013000', N'110105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'46', N'六里屯街道办事处', N'110105014000', N'110105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'47', N'八里庄街道办事处', N'110105015000', N'110105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'48', N'双井街道办事处', N'110105016000', N'110105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'49', N'劲松街道办事处', N'110105017000', N'110105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'50', N'潘家园街道办事处', N'110105018000', N'110105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'51', N'垡头街道办事处', N'110105019000', N'110105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'52', N'南磨房地区办事处', N'110105021000', N'110105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'53', N'高碑店地区办事处', N'110105022000', N'110105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'54', N'将台地区办事处', N'110105023000', N'110105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'55', N'太阳宫地区办事处', N'110105024000', N'110105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'56', N'大屯街道办事处', N'110105025000', N'110105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'57', N'望京街道办事处', N'110105026000', N'110105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'58', N'小红门地区办事处', N'110105027000', N'110105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'59', N'十八里店地区办事处', N'110105028000', N'110105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'60', N'平房地区办事处', N'110105029000', N'110105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'61', N'东风地区办事处', N'110105030000', N'110105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'62', N'奥运村街道办事处', N'110105031000', N'110105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'63', N'来广营地区办事处', N'110105032000', N'110105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'64', N'常营地区办事处', N'110105033000', N'110105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'65', N'三间房地区办事处', N'110105034000', N'110105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'66', N'管庄地区办事处', N'110105035000', N'110105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'67', N'金盏地区办事处', N'110105036000', N'110105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'68', N'孙河地区办事处', N'110105037000', N'110105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'69', N'崔各庄地区办事处', N'110105038000', N'110105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'70', N'东坝地区办事处', N'110105039000', N'110105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'71', N'黑庄户地区办事处', N'110105040000', N'110105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'72', N'豆各庄地区办事处', N'110105041000', N'110105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'73', N'王四营地区办事处', N'110105042000', N'110105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'74', N'东湖街道办事处', N'110105043000', N'110105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'75', N'首都机场街道办事处', N'110105400000', N'110105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'76', N'右安门街道办事处', N'110106001000', N'110106000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'77', N'太平桥街道办事处', N'110106002000', N'110106000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'78', N'西罗园街道办事处', N'110106003000', N'110106000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'79', N'大红门街道办事处', N'110106004000', N'110106000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'80', N'南苑街道办事处', N'110106005000', N'110106000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'81', N'东高地街道办事处', N'110106006000', N'110106000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'82', N'东铁匠营街道办事处', N'110106007000', N'110106000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'83', N'卢沟桥街道办事处', N'110106008000', N'110106000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'84', N'丰台街道办事处', N'110106009000', N'110106000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'85', N'新村街道办事处', N'110106010000', N'110106000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'86', N'长辛店街道办事处', N'110106011000', N'110106000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'87', N'云岗街道办事处', N'110106012000', N'110106000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'88', N'方庄地区办事处', N'110106013000', N'110106000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'89', N'宛平城地区办事处', N'110106014000', N'110106000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'90', N'马家堡街道办事处', N'110106015000', N'110106000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'91', N'和义街道办事处', N'110106016000', N'110106000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'92', N'卢沟桥地区办事处', N'110106017000', N'110106000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'93', N'花乡地区办事处', N'110106018000', N'110106000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'94', N'南苑地区办事处', N'110106019000', N'110106000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'95', N'长辛店镇', N'110106100000', N'110106000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'96', N'王佐镇', N'110106101000', N'110106000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'97', N'八宝山街道办事处', N'110107001000', N'110107000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'98', N'老山街道办事处', N'110107002000', N'110107000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'99', N'八角街道办事处', N'110107003000', N'110107000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'100', N'古城街道办事处', N'110107004000', N'110107000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'101', N'苹果园街道办事处', N'110107005000', N'110107000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'102', N'金顶街街道办事处', N'110107006000', N'110107000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'103', N'广宁街道办事处', N'110107009000', N'110107000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'104', N'五里坨街道办事处', N'110107010000', N'110107000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'105', N'鲁谷街道办事处', N'110107011000', N'110107000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'106', N'万寿路街道办事处', N'110108001000', N'110108000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'107', N'永定路街道办事处', N'110108002000', N'110108000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'108', N'羊坊店街道办事处', N'110108003000', N'110108000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'109', N'甘家口街道办事处', N'110108004000', N'110108000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'110', N'八里庄街道办事处', N'110108005000', N'110108000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'111', N'紫竹院街道办事处', N'110108006000', N'110108000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'112', N'北下关街道办事处', N'110108007000', N'110108000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'113', N'北太平庄街道办事处', N'110108008000', N'110108000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'114', N'学院路街道办事处', N'110108010000', N'110108000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'115', N'中关村街道办事处', N'110108011000', N'110108000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'116', N'海淀街道办事处', N'110108012000', N'110108000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'117', N'青龙桥街道办事处', N'110108013000', N'110108000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'118', N'清华园街道办事处', N'110108014000', N'110108000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'119', N'燕园街道办事处', N'110108015000', N'110108000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'120', N'香山街道办事处', N'110108016000', N'110108000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'121', N'清河街道办事处', N'110108017000', N'110108000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'122', N'花园路街道办事处', N'110108018000', N'110108000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'123', N'西三旗街道办事处', N'110108019000', N'110108000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'124', N'马连洼街道办事处', N'110108020000', N'110108000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'125', N'田村路街道办事处', N'110108021000', N'110108000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'126', N'上地街道办事处', N'110108022000', N'110108000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'127', N'万柳地区办事处', N'110108023000', N'110108000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'128', N'东升地区办事处', N'110108024000', N'110108000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'129', N'曙光街道办事处', N'110108025000', N'110108000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'130', N'温泉地区办事处', N'110108026000', N'110108000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'131', N'四季青地区办事处', N'110108027000', N'110108000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'132', N'西北旺地区办事处', N'110108028000', N'110108000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'133', N'苏家坨地区办事处', N'110108029000', N'110108000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'134', N'上庄地区办事处', N'110108030000', N'110108000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'135', N'大峪街道办事处', N'110109001000', N'110109000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'136', N'城子街道办事处', N'110109002000', N'110109000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'137', N'东辛房街道办事处', N'110109003000', N'110109000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'138', N'大台街道办事处', N'110109004000', N'110109000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'139', N'王平地区办事处', N'110109005000', N'110109000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'140', N'永定地区办事处', N'110109006000', N'110109000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'141', N'龙泉地区办事处', N'110109007000', N'110109000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'142', N'潭柘寺镇', N'110109101000', N'110109000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'143', N'军庄镇', N'110109104000', N'110109000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'144', N'雁翅镇', N'110109105000', N'110109000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'145', N'斋堂镇', N'110109106000', N'110109000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'146', N'清水镇', N'110109107000', N'110109000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'147', N'妙峰山镇', N'110109108000', N'110109000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'148', N'城关街道办事处', N'110111001000', N'110111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'149', N'新镇街道办事处', N'110111002000', N'110111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'150', N'向阳街道办事处', N'110111004000', N'110111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'151', N'东风街道办事处', N'110111005000', N'110111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'152', N'迎风街道办事处', N'110111006000', N'110111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'153', N'星城街道办事处', N'110111007000', N'110111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'154', N'良乡地区办事处', N'110111008000', N'110111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'155', N'周口店地区办事处', N'110111009000', N'110111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'156', N'琉璃河地区办事处', N'110111010000', N'110111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'157', N'拱辰街道办事处', N'110111011000', N'110111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'158', N'西潞街道办事处', N'110111012000', N'110111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'159', N'阎村镇', N'110111101000', N'110111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'160', N'窦店镇', N'110111103000', N'110111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'161', N'石楼镇', N'110111104000', N'110111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'162', N'长阳镇', N'110111105000', N'110111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'163', N'河北镇', N'110111107000', N'110111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'164', N'长沟镇', N'110111108000', N'110111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'165', N'大石窝镇', N'110111109000', N'110111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'166', N'张坊镇', N'110111110000', N'110111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'167', N'十渡镇', N'110111111000', N'110111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'168', N'青龙湖镇', N'110111112000', N'110111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'169', N'韩村河镇', N'110111115000', N'110111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'170', N'霞云岭乡', N'110111208000', N'110111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'171', N'南窖乡', N'110111209000', N'110111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'172', N'佛子庄乡', N'110111210000', N'110111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'173', N'大安山乡', N'110111211000', N'110111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'174', N'史家营乡', N'110111212000', N'110111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'175', N'蒲洼乡', N'110111213000', N'110111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'176', N'中仓街道办事处', N'110112001000', N'110112000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'177', N'新华街道办事处', N'110112002000', N'110112000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'178', N'北苑街道办事处', N'110112003000', N'110112000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'179', N'玉桥街道办事处', N'110112004000', N'110112000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'180', N'永顺地区办事处', N'110112005000', N'110112000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'181', N'梨园地区办事处', N'110112006000', N'110112000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'182', N'宋庄镇', N'110112104000', N'110112000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'183', N'张家湾镇', N'110112105000', N'110112000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'184', N'漷县镇', N'110112106000', N'110112000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'185', N'马驹桥镇', N'110112109000', N'110112000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'186', N'西集镇', N'110112110000', N'110112000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'187', N'台湖镇', N'110112114000', N'110112000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'188', N'永乐店镇', N'110112117000', N'110112000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'189', N'潞城镇', N'110112119000', N'110112000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'190', N'于家务回族乡', N'110112209000', N'110112000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'191', N'胜利街道办事处', N'110113001000', N'110113000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'192', N'光明街道办事处', N'110113002000', N'110113000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'193', N'仁和地区办事处', N'110113003000', N'110113000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'194', N'后沙峪地区办事处', N'110113004000', N'110113000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'195', N'天竺地区办事处', N'110113005000', N'110113000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'196', N'杨镇地区办事处', N'110113006000', N'110113000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'197', N'牛栏山地区办事处', N'110113007000', N'110113000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'198', N'南法信地区办事处', N'110113008000', N'110113000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'199', N'马坡地区办事处', N'110113009000', N'110113000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'200', N'石园街道办事处', N'110113010000', N'110113000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'201', N'空港街道办事处', N'110113011000', N'110113000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'202', N'双丰街道办事处', N'110113012000', N'110113000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'203', N'旺泉街道办事处', N'110113013000', N'110113000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'204', N'高丽营镇', N'110113101000', N'110113000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'205', N'李桥镇', N'110113104000', N'110113000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'206', N'李遂镇', N'110113105000', N'110113000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'207', N'南彩镇', N'110113106000', N'110113000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'208', N'北务镇', N'110113108000', N'110113000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'209', N'大孙各庄镇', N'110113109000', N'110113000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'210', N'张镇', N'110113110000', N'110113000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'211', N'龙湾屯镇', N'110113111000', N'110113000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'212', N'木林镇', N'110113112000', N'110113000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'213', N'北小营镇', N'110113113000', N'110113000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'214', N'北石槽镇', N'110113115000', N'110113000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'215', N'赵全营镇', N'110113116000', N'110113000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'216', N'城北街道办事处', N'110114001000', N'110114000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'217', N'南口地区办事处', N'110114002000', N'110114000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'218', N'马池口地区办事处', N'110114003000', N'110114000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'219', N'沙河地区办事处', N'110114004000', N'110114000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'220', N'城南街道办事处', N'110114005000', N'110114000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'221', N'东小口地区办事处', N'110114007000', N'110114000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'222', N'天通苑北街道办事处', N'110114008000', N'110114000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'223', N'天通苑南街道办事处', N'110114009000', N'110114000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'224', N'霍营街道办事处', N'110114010000', N'110114000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'225', N'回龙观街道办事处', N'110114011000', N'110114000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'226', N'龙泽园街道办事处', N'110114012000', N'110114000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'227', N'史各庄街道办事处', N'110114013000', N'110114000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'228', N'阳坊镇', N'110114104000', N'110114000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'229', N'小汤山镇', N'110114110000', N'110114000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'230', N'南邵镇', N'110114111000', N'110114000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'231', N'崔村镇', N'110114112000', N'110114000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'232', N'百善镇', N'110114113000', N'110114000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'233', N'北七家镇', N'110114115000', N'110114000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'234', N'兴寿镇', N'110114116000', N'110114000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'235', N'流村镇', N'110114118000', N'110114000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'236', N'十三陵镇', N'110114119000', N'110114000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'237', N'延寿镇', N'110114120000', N'110114000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'238', N'兴丰街道办事处', N'110115001000', N'110115000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'239', N'林校路街道办事处', N'110115002000', N'110115000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'240', N'清源街道办事处', N'110115003000', N'110115000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'241', N'亦庄地区办事处', N'110115004000', N'110115000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'242', N'黄村地区办事处', N'110115005000', N'110115000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'243', N'旧宫地区办事处', N'110115006000', N'110115000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'244', N'西红门地区办事处', N'110115007000', N'110115000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'245', N'瀛海地区办事处', N'110115008000', N'110115000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'246', N'观音寺街道办事处', N'110115009000', N'110115000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'247', N'天宫院街道办事处', N'110115010000', N'110115000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'248', N'高米店街道办事处', N'110115011000', N'110115000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'249', N'荣华街道办事处', N'110115012000', N'110115000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'250', N'博兴街道办事处', N'110115013000', N'110115000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'251', N'青云店镇', N'110115103000', N'110115000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'252', N'采育镇', N'110115104000', N'110115000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'253', N'安定镇', N'110115105000', N'110115000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'254', N'礼贤镇', N'110115106000', N'110115000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'255', N'榆垡镇', N'110115107000', N'110115000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'256', N'庞各庄镇', N'110115108000', N'110115000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'257', N'北臧村镇', N'110115109000', N'110115000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'258', N'魏善庄镇', N'110115110000', N'110115000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'259', N'长子营镇', N'110115111000', N'110115000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'260', N'北京经济技术开发区', N'110115403000', N'110115000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'261', N'中关村国家自主创新示范区大兴生物医药产业基地', N'110115404000', N'110115000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'262', N'国家新媒体产业基地', N'110115405000', N'110115000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'263', N'泉河街道办事处', N'110116001000', N'110116000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'264', N'龙山街道办事处', N'110116002000', N'110116000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'265', N'怀柔地区办事处', N'110116003000', N'110116000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'266', N'雁栖地区办事处', N'110116004000', N'110116000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'267', N'庙城地区办事处', N'110116005000', N'110116000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'268', N'北房镇', N'110116102000', N'110116000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'269', N'杨宋镇', N'110116103000', N'110116000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'270', N'桥梓镇', N'110116105000', N'110116000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'271', N'怀北镇', N'110116106000', N'110116000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'272', N'汤河口镇', N'110116107000', N'110116000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'273', N'渤海镇', N'110116108000', N'110116000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'274', N'九渡河镇', N'110116109000', N'110116000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'275', N'琉璃庙镇', N'110116110000', N'110116000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'276', N'宝山镇', N'110116111000', N'110116000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'277', N'长哨营满族乡', N'110116211000', N'110116000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'278', N'喇叭沟门满族乡', N'110116213000', N'110116000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'279', N'北京雁栖经济开发区', N'110116400000', N'110116000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'280', N'滨河街道办事处', N'110117001000', N'110117000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'281', N'兴谷街道办事处', N'110117002000', N'110117000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'282', N'渔阳地区办事处', N'110117003000', N'110117000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'283', N'峪口地区办事处', N'110117004000', N'110117000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'284', N'马坊地区办事处', N'110117005000', N'110117000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'285', N'金海湖地区办事处', N'110117006000', N'110117000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'286', N'东高村镇', N'110117101000', N'110117000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'287', N'山东庄镇', N'110117102000', N'110117000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'288', N'南独乐河镇', N'110117104000', N'110117000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'289', N'大华山镇', N'110117105000', N'110117000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'290', N'夏各庄镇', N'110117106000', N'110117000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'291', N'马昌营镇', N'110117108000', N'110117000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'292', N'王辛庄镇', N'110117110000', N'110117000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'293', N'大兴庄镇', N'110117111000', N'110117000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'294', N'刘家店镇', N'110117112000', N'110117000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'295', N'镇罗营镇', N'110117114000', N'110117000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'296', N'黄松峪乡', N'110117213000', N'110117000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'297', N'熊儿寨乡', N'110117214000', N'110117000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'298', N'鼓楼街道办事处', N'110118001000', N'110118000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'299', N'果园街道办事处', N'110118002000', N'110118000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'300', N'檀营地区办事处', N'110118003000', N'110118000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'301', N'密云镇', N'110118100000', N'110118000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'302', N'溪翁庄镇', N'110118101000', N'110118000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'303', N'西田各庄镇', N'110118102000', N'110118000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'304', N'十里堡镇', N'110118103000', N'110118000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'305', N'河南寨镇', N'110118104000', N'110118000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'306', N'巨各庄镇', N'110118105000', N'110118000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'307', N'穆家峪镇', N'110118106000', N'110118000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'308', N'太师屯镇', N'110118107000', N'110118000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'309', N'高岭镇', N'110118108000', N'110118000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'310', N'不老屯镇', N'110118109000', N'110118000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'311', N'冯家峪镇', N'110118110000', N'110118000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'312', N'古北口镇', N'110118111000', N'110118000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'313', N'大城子镇', N'110118112000', N'110118000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'314', N'东邵渠镇', N'110118113000', N'110118000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'315', N'北庄镇', N'110118114000', N'110118000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'316', N'新城子镇', N'110118115000', N'110118000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'317', N'石城镇', N'110118116000', N'110118000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'318', N'北京密云经济开发区', N'110118400000', N'110118000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'319', N'百泉街道办事处', N'110119001000', N'110119000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'320', N'香水园街道办事处', N'110119002000', N'110119000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'321', N'儒林街道办事处', N'110119003000', N'110119000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'322', N'延庆镇', N'110119100000', N'110119000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'323', N'康庄镇', N'110119101000', N'110119000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'324', N'八达岭镇', N'110119102000', N'110119000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'325', N'永宁镇', N'110119103000', N'110119000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'326', N'旧县镇', N'110119104000', N'110119000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'327', N'张山营镇', N'110119105000', N'110119000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'328', N'四海镇', N'110119106000', N'110119000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'329', N'千家店镇', N'110119107000', N'110119000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'330', N'沈家营镇', N'110119108000', N'110119000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'331', N'大榆树镇', N'110119109000', N'110119000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'332', N'井庄镇', N'110119110000', N'110119000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'333', N'大庄科乡', N'110119200000', N'110119000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'334', N'刘斌堡乡', N'110119201000', N'110119000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'335', N'香营乡', N'110119202000', N'110119000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'336', N'珍珠泉乡', N'110119203000', N'110119000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'337', N'劝业场街道', N'120101001000', N'120101000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'338', N'小白楼街道', N'120101002000', N'120101000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'339', N'五大道街道', N'120101003000', N'120101000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'340', N'新兴街道', N'120101004000', N'120101000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'341', N'南营门街道', N'120101005000', N'120101000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'342', N'南市街道', N'120101006000', N'120101000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'343', N'大王庄街道', N'120102001000', N'120102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'344', N'大直沽街道', N'120102002000', N'120102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'345', N'中山门街道', N'120102003000', N'120102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'346', N'富民路街道', N'120102004000', N'120102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'347', N'二号桥街道', N'120102005000', N'120102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'348', N'春华街道', N'120102006000', N'120102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'349', N'唐家口街道', N'120102007000', N'120102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'350', N'向阳楼街道', N'120102008000', N'120102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'351', N'常州道街道', N'120102009000', N'120102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'352', N'上杭路街道', N'120102010000', N'120102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'353', N'东新街道', N'120102011000', N'120102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'354', N'鲁山道街道', N'120102012000', N'120102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'355', N'天津铁厂街道', N'120102013000', N'120102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'356', N'大营门街道', N'120103001000', N'120103000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'357', N'下瓦房街道', N'120103002000', N'120103000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'358', N'桃园街道', N'120103003000', N'120103000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'359', N'挂甲寺街道', N'120103004000', N'120103000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'360', N'马场街道', N'120103005000', N'120103000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'361', N'越秀路街道', N'120103006000', N'120103000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'362', N'友谊路街道', N'120103007000', N'120103000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'363', N'天塔街道', N'120103008000', N'120103000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'364', N'尖山街道', N'120103009000', N'120103000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'365', N'陈塘庄街道', N'120103010000', N'120103000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'366', N'柳林街道', N'120103011000', N'120103000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'367', N'东海街道', N'120103012000', N'120103000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'368', N'梅江街道', N'120103013000', N'120103000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'369', N'太湖路街道', N'120103014000', N'120103000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'370', N'长虹街道', N'120104001000', N'120104000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'371', N'鼓楼街道', N'120104002000', N'120104000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'372', N'兴南街道', N'120104003000', N'120104000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'373', N'广开街道', N'120104004000', N'120104000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'374', N'万兴街道', N'120104005000', N'120104000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'375', N'学府街道', N'120104006000', N'120104000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'376', N'向阳路街道', N'120104007000', N'120104000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'377', N'嘉陵道街道', N'120104008000', N'120104000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'378', N'王顶堤街道', N'120104009000', N'120104000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'379', N'水上公园街道', N'120104010000', N'120104000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'380', N'体育中心街道', N'120104011000', N'120104000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'381', N'华苑街道', N'120104012000', N'120104000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'382', N'光复道街道', N'120105001000', N'120105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'383', N'望海楼街道', N'120105002000', N'120105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'384', N'鸿顺里街道', N'120105003000', N'120105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'385', N'新开河街道', N'120105004000', N'120105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'386', N'铁东路街道', N'120105005000', N'120105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'387', N'建昌道街道', N'120105006000', N'120105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'388', N'宁园街道', N'120105007000', N'120105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'389', N'王串场街道', N'120105008000', N'120105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'390', N'江都路街道', N'120105009000', N'120105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'391', N'月牙河街道', N'120105010000', N'120105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'392', N'西于庄街道', N'120106001000', N'120106000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'393', N'双环村街道', N'120106002000', N'120106000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'394', N'咸阳北路街道', N'120106003000', N'120106000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'395', N'丁字沽街道', N'120106004000', N'120106000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'396', N'西沽街道', N'120106005000', N'120106000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'397', N'三条石街道', N'120106006000', N'120106000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'398', N'邵公庄街道', N'120106008000', N'120106000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'399', N'芥园街道', N'120106009000', N'120106000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'400', N'铃铛阁街道', N'120106010000', N'120106000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'401', N'大胡同街道', N'120106011000', N'120106000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'402', N'和苑街道办事处', N'120106012000', N'120106000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'403', N'张贵庄街道', N'120110001000', N'120110000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'404', N'丰年村街道', N'120110002000', N'120110000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'405', N'万新街道', N'120110003000', N'120110000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'406', N'无瑕街道', N'120110004000', N'120110000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'407', N'新立街道', N'120110005000', N'120110000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'408', N'华明街道', N'120110006000', N'120110000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'409', N'金钟街道', N'120110007000', N'120110000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'410', N'军粮城街道', N'120110008000', N'120110000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'411', N'金桥街道', N'120110009000', N'120110000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'412', N'华新街道', N'120110010000', N'120110000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'413', N'东丽湖街道', N'120110011000', N'120110000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'414', N'天津开发区西区', N'120110400000', N'120110000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'415', N'天津航空物流区', N'120110401000', N'120110000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'416', N'天津空港经济区', N'120110402000', N'120110000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'417', N'东丽区经济技术开发区', N'120110403000', N'120110000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'418', N'综合保税区', N'120110405000', N'120110000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'419', N'航空新城', N'120110406000', N'120110000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'420', N'服务滨海新区建设管理委员会', N'120110407000', N'120110000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'421', N'西营门街道', N'120111001000', N'120111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'422', N'李七庄街道', N'120111002000', N'120111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'423', N'赤龙南街道', N'120111003000', N'120111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'424', N'中北镇', N'120111100000', N'120111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'425', N'杨柳青镇', N'120111101000', N'120111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'426', N'辛口镇', N'120111102000', N'120111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'427', N'张家窝镇', N'120111103000', N'120111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'428', N'精武镇', N'120111104000', N'120111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'429', N'大寺镇', N'120111105000', N'120111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'430', N'王稳庄镇', N'120111106000', N'120111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'431', N'天津开发区微电子小区', N'120111400000', N'120111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'432', N'新技术产业园区', N'120111401000', N'120111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'433', N'西青高校区', N'120111402000', N'120111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'434', N'西青区开发区', N'120111450000', N'120111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'435', N'双新街道办事处', N'120112001000', N'120112000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'436', N'双林街道办事处', N'120112002000', N'120112000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'437', N'咸水沽镇', N'120112100000', N'120112000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'438', N'葛沽镇', N'120112101000', N'120112000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'439', N'小站镇', N'120112102000', N'120112000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'440', N'双港镇', N'120112103000', N'120112000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'441', N'辛庄镇', N'120112104000', N'120112000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'442', N'双桥河镇', N'120112106000', N'120112000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'443', N'八里台镇', N'120112107000', N'120112000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'444', N'北闸口镇', N'120112108000', N'120112000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'445', N'铁路十八局', N'120112401000', N'120112000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'446', N'长青办事处', N'120112403000', N'120112000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'447', N'津南开发区东区', N'120112404000', N'120112000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'448', N'津南开发区西区', N'120112405000', N'120112000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'449', N'海河教育园区', N'120112407000', N'120112000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'450', N'双林农场', N'120112500000', N'120112000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'451', N'津南国家农业园区', N'120112501000', N'120112000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'452', N'果园新村街道', N'120113001000', N'120113000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'453', N'集贤里街道', N'120113002000', N'120113000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'454', N'普东街道', N'120113003000', N'120113000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'455', N'瑞景街道', N'120113004000', N'120113000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'456', N'佳荣里街道', N'120113005000', N'120113000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'457', N'青源街道', N'120113006000', N'120113000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'458', N'广源街道', N'120113007000', N'120113000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'459', N'天穆镇', N'120113100000', N'120113000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'460', N'北仓镇', N'120113101000', N'120113000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'461', N'双街镇', N'120113102000', N'120113000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'462', N'双口镇', N'120113103000', N'120113000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'463', N'青光镇', N'120113104000', N'120113000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'464', N'宜兴埠镇', N'120113106000', N'120113000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'465', N'小淀镇', N'120113107000', N'120113000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'466', N'大张庄镇', N'120113108000', N'120113000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'467', N'西堤头镇', N'120113111000', N'120113000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'468', N'科技园区北区', N'120113400000', N'120113000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'469', N'科技园区南区', N'120113401000', N'120113000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'470', N'天津医药医疗器械工业园', N'120113402000', N'120113000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'471', N'天津陆路港物流装备产业园', N'120113403000', N'120113000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'472', N'天津风电产业园', N'120113404000', N'120113000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'473', N'红旗农场', N'120113500000', N'120113000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'474', N'曙光农场', N'120113501000', N'120113000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'475', N'杨村街道', N'120114001000', N'120114000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'476', N'下朱庄街道', N'120114002000', N'120114000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'477', N'东蒲洼街道', N'120114003000', N'120114000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'478', N'黄庄街道', N'120114004000', N'120114000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'479', N'徐官屯街道', N'120114005000', N'120114000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'480', N'运河西街道', N'120114006000', N'120114000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'481', N'梅厂镇', N'120114101000', N'120114000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'482', N'大碱厂镇', N'120114102000', N'120114000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'483', N'崔黄口镇', N'120114103000', N'120114000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'484', N'大良镇', N'120114104000', N'120114000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'485', N'下伍旗镇', N'120114105000', N'120114000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'486', N'南蔡村镇', N'120114106000', N'120114000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'487', N'大孟庄镇', N'120114107000', N'120114000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'488', N'泗村店镇', N'120114108000', N'120114000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'489', N'河西务镇', N'120114109000', N'120114000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'490', N'城关镇', N'120114110000', N'120114000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'491', N'东马圈镇', N'120114111000', N'120114000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'492', N'黄花店镇', N'120114112000', N'120114000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'493', N'石各庄镇', N'120114113000', N'120114000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'494', N'王庆坨镇', N'120114114000', N'120114000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'495', N'汊沽港镇', N'120114115000', N'120114000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'496', N'河北屯镇', N'120114116000', N'120114000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'497', N'上马台镇', N'120114117000', N'120114000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'498', N'大王古庄镇', N'120114118000', N'120114000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'499', N'陈咀镇', N'120114119000', N'120114000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'500', N'豆张庄镇', N'120114120000', N'120114000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'501', N'曹子里镇', N'120114121000', N'120114000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'502', N'大黄堡镇', N'120114122000', N'120114000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'503', N'高村镇', N'120114123000', N'120114000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'504', N'白古屯镇', N'120114124000', N'120114000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'505', N'天津开发区逸仙科学工业园', N'120114400000', N'120114000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'506', N'武清经济技术开发区', N'120114401000', N'120114000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'507', N'天津武清商务区', N'120114402000', N'120114000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'508', N'天津京滨工业园', N'120114403000', N'120114000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'509', N'天津京津电子商务产业园', N'120114404000', N'120114000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'510', N'天津武清汽车产业园', N'120114405000', N'120114000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'511', N'天津京津科技谷', N'120114406000', N'120114000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'512', N'京津高村科技创新园', N'120114407000', N'120114000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'513', N'武清农场', N'120114500000', N'120114000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'514', N'海滨街道', N'120115001000', N'120115000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'515', N'宝平街道', N'120115002000', N'120115000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'516', N'钰华街道', N'120115003000', N'120115000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'517', N'大白街道', N'120115004000', N'120115000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'518', N'口东街道', N'120115005000', N'120115000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'519', N'周良街道', N'120115006000', N'120115000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'520', N'潮阳街道', N'120115007000', N'120115000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'521', N'朝霞街道', N'120115008000', N'120115000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'522', N'大口屯镇', N'120115101000', N'120115000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'523', N'王卜庄镇', N'120115103000', N'120115000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'524', N'方家庄镇', N'120115104000', N'120115000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'525', N'林亭口镇', N'120115105000', N'120115000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'526', N'八门城镇', N'120115106000', N'120115000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'527', N'大钟庄镇', N'120115107000', N'120115000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'528', N'新安镇', N'120115108000', N'120115000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'529', N'霍各庄镇', N'120115111000', N'120115000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'530', N'新开口镇', N'120115113000', N'120115000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'531', N'大唐庄镇', N'120115115000', N'120115000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'532', N'牛道口镇', N'120115119000', N'120115000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'533', N'史各庄镇', N'120115120000', N'120115000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'534', N'郝各庄镇', N'120115121000', N'120115000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'535', N'牛家牌镇', N'120115123000', N'120115000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'536', N'尔王庄镇', N'120115124000', N'120115000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'537', N'黄庄镇', N'120115125000', N'120115000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'538', N'天宝工业园区', N'120115453000', N'120115000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'539', N'九园工业园区', N'120115454000', N'120115000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'540', N'京津新城', N'120115455000', N'120115000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'541', N'里自沽农场', N'120115500000', N'120115000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'542', N'黄庄农场', N'120115501000', N'120115000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'543', N'大钟农场', N'120115502000', N'120115000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'544', N'塘沽街道', N'120116001000', N'120116000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'545', N'杭州道街道', N'120116005000', N'120116000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'546', N'新河街道', N'120116006000', N'120116000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'547', N'大沽街道', N'120116007000', N'120116000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'548', N'新北街道', N'120116008000', N'120116000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'549', N'北塘街道', N'120116009000', N'120116000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'550', N'胡家园街道', N'120116011000', N'120116000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'551', N'新港街道', N'120116012000', N'120116000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'552', N'新村街道', N'120116013000', N'120116000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'553', N'泰达街道（天津经济技术开发区东区）', N'120116014000', N'120116000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'554', N'汉沽街道', N'120116031000', N'120116000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'555', N'寨上街道', N'120116032000', N'120116000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'556', N'茶淀街道', N'120116033000', N'120116000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'557', N'大港街道', N'120116051000', N'120116000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'558', N'古林街道', N'120116053000', N'120116000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'559', N'海滨街道', N'120116054000', N'120116000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'560', N'新城镇', N'120116100000', N'120116000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'561', N'杨家泊镇', N'120116135000', N'120116000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'562', N'太平镇', N'120116156000', N'120116000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'563', N'小王庄镇', N'120116157000', N'120116000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'564', N'中塘镇', N'120116158000', N'120116000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'565', N'天津经济技术开发区（其他片区）', N'120116400000', N'120116000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'566', N'天津港保税区', N'120116401000', N'120116000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'567', N'天津滨海新区高新技术产业开发区', N'120116402000', N'120116000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'568', N'东疆保税港区', N'120116403000', N'120116000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'569', N'中新天津生态城', N'120116406000', N'120116000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'570', N'天津滨海中关村科技园', N'120116415000', N'120116000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'571', N'芦台镇', N'120117100000', N'120117000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'572', N'宁河镇', N'120117102000', N'120117000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'573', N'苗庄镇', N'120117103000', N'120117000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'574', N'丰台镇', N'120117104000', N'120117000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'575', N'岳龙镇', N'120117105000', N'120117000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'576', N'板桥镇', N'120117106000', N'120117000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'577', N'潘庄镇', N'120117107000', N'120117000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'578', N'造甲城镇', N'120117109000', N'120117000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'579', N'七里海镇', N'120117110000', N'120117000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'580', N'大北涧沽镇', N'120117111000', N'120117000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'581', N'东棘坨镇', N'120117112000', N'120117000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'582', N'北淮淀镇', N'120117113000', N'120117000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'583', N'俵口镇', N'120117114000', N'120117000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'584', N'廉庄镇', N'120117115000', N'120117000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'585', N'宁河区贸易开发区', N'120117400000', N'120117000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'586', N'宁河区经济开发区', N'120117401000', N'120117000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'587', N'天津未来科技城开发区片区', N'120117402000', N'120117000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'588', N'天津未来科技城滨海高新区片区', N'120117403000', N'120117000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'589', N'天津未来科技城宁河片区现代产业区组团', N'120117451000', N'120117000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'590', N'天津未来科技城宁河片区潘庄工业区组团', N'120117452000', N'120117000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'591', N'天津未来科技城宁河片区北淮淀组团', N'120117453000', N'120117000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'592', N'潘庄农场', N'120117500000', N'120117000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'593', N'华康街道办事处', N'120118001000', N'120118000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'594', N'静海镇', N'120118100000', N'120118000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'595', N'唐官屯镇', N'120118101000', N'120118000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'596', N'独流镇', N'120118102000', N'120118000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'597', N'王口镇', N'120118103000', N'120118000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'598', N'台头镇', N'120118104000', N'120118000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'599', N'子牙镇', N'120118105000', N'120118000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'600', N'陈官屯镇', N'120118106000', N'120118000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'601', N'中旺镇', N'120118107000', N'120118000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'602', N'大邱庄镇', N'120118108000', N'120118000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'603', N'蔡公庄镇', N'120118109000', N'120118000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'604', N'梁头镇', N'120118110000', N'120118000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'605', N'团泊镇', N'120118111000', N'120118000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'606', N'双塘镇', N'120118112000', N'120118000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'607', N'大丰堆镇', N'120118113000', N'120118000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'608', N'沿庄镇', N'120118114000', N'120118000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'609', N'西翟庄镇', N'120118115000', N'120118000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'610', N'良王庄乡', N'120118200000', N'120118000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'611', N'杨成庄乡', N'120118201000', N'120118000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'612', N'天津静海经济开发区', N'120118400000', N'120118000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'613', N'天津子牙循环经济产业区', N'120118402000', N'120118000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'614', N'团泊新城', N'120118403000', N'120118000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'615', N'文昌街道办事处', N'120119001000', N'120119000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'616', N'渔阳镇', N'120119100000', N'120119000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'617', N'洇溜镇', N'120119101000', N'120119000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'618', N'官庄镇', N'120119102000', N'120119000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'619', N'马伸桥镇', N'120119103000', N'120119000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'620', N'下营镇', N'120119104000', N'120119000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'621', N'邦均镇', N'120119105000', N'120119000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'622', N'别山镇', N'120119106000', N'120119000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'623', N'尤古庄镇', N'120119108000', N'120119000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'624', N'上仓镇', N'120119109000', N'120119000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'625', N'下仓镇', N'120119111000', N'120119000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'626', N'罗庄子镇', N'120119112000', N'120119000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'627', N'白涧镇', N'120119113000', N'120119000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'628', N'五百户镇', N'120119114000', N'120119000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'629', N'侯家营镇', N'120119115000', N'120119000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'630', N'桑梓镇', N'120119116000', N'120119000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'631', N'东施古镇', N'120119117000', N'120119000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'632', N'下窝头镇', N'120119118000', N'120119000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'633', N'杨津庄镇', N'120119119000', N'120119000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'634', N'出头岭镇', N'120119120000', N'120119000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'635', N'西龙虎峪镇', N'120119121000', N'120119000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'636', N'穿芳峪镇', N'120119122000', N'120119000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'637', N'东二营镇', N'120119123000', N'120119000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'638', N'许家台镇', N'120119124000', N'120119000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'639', N'礼明庄镇', N'120119125000', N'120119000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'640', N'东赵各庄镇', N'120119126000', N'120119000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'641', N'孙各庄乡', N'120119203000', N'120119000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'642', N'蓟县新城建设管理委员会', N'120119400000', N'120119000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'643', N'建北街道办事处', N'130102001000', N'130102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'644', N'青园街道办事处', N'130102002000', N'130102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'645', N'广安街道办事处', N'130102003000', N'130102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'646', N'育才街道办事处', N'130102004000', N'130102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'647', N'跃进街道办事处', N'130102005000', N'130102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'648', N'河东街道办事处', N'130102007000', N'130102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'649', N'长丰街道办事处', N'130102010000', N'130102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'650', N'谈固街道办事处', N'130102011000', N'130102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'651', N'中山东路街道办事处', N'130102012000', N'130102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'652', N'阜康街道办事处', N'130102013000', N'130102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'653', N'建安街道办事处', N'130102014000', N'130102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'654', N'胜利北街道办事处', N'130102015000', N'130102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'655', N'西兆通镇', N'130102100000', N'130102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'656', N'南村镇', N'130102101000', N'130102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'657', N'高营镇', N'130102102000', N'130102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'658', N'桃园镇', N'130102103000', N'130102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'659', N'东里街道办事处', N'130104001000', N'130104000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'660', N'中山街道办事处', N'130104002000', N'130104000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'661', N'南长街道办事处', N'130104004000', N'130104000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'662', N'维明街道办事处', N'130104005000', N'130104000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'663', N'友谊街道办事处', N'130104007000', N'130104000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'664', N'红旗街道办事处', N'130104008000', N'130104000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'665', N'新石街道办事处', N'130104009000', N'130104000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'666', N'苑东街道办事处', N'130104010000', N'130104000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'667', N'西里街道办事处', N'130104011000', N'130104000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'668', N'振头街道办事处', N'130104012000', N'130104000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'669', N'留营街道办事处', N'130104013000', N'130104000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'670', N'长兴街道办事处', N'130104014000', N'130104000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'671', N'彭后街道办事处', N'130104015000', N'130104000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'672', N'东风街道办事处', N'130104016000', N'130104000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'673', N'东华街道办事处', N'130104017000', N'130104000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'674', N'休门街道办事处', N'130104018000', N'130104000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'675', N'汇通街道办事处', N'130104019000', N'130104000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'676', N'革新街街道办事处', N'130105001000', N'130105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'677', N'新华路街道办事处', N'130105003000', N'130105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'678', N'宁安街道办事处', N'130105004000', N'130105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'679', N'东焦街道办事处', N'130105005000', N'130105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'680', N'西苑街道办事处', N'130105006000', N'130105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'681', N'合作路街道办事处', N'130105007000', N'130105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'682', N'联盟街道办事处', N'130105008000', N'130105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'683', N'石岗街道办事处', N'130105009000', N'130105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'684', N'天苑街道办事处', N'130105011000', N'130105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'685', N'北苑街道办事处', N'130105012000', N'130105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'686', N'赵陵铺路街道办事处', N'130105013000', N'130105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'687', N'西三庄街道办事处', N'130105014000', N'130105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'688', N'大郭街道办事处', N'130105015000', N'130105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'689', N'杜北街道办事处', N'130105016000', N'130105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'690', N'赵佗路街道办事处', N'130105017000', N'130105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'691', N'矿市街道办事处', N'130107001000', N'130107000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'692', N'四微街道办事处', N'130107002000', N'130107000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'693', N'贾庄镇', N'130107100000', N'130107000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'694', N'凤山镇', N'130107101000', N'130107000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'695', N'横涧乡', N'130107200000', N'130107000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'696', N'裕兴街道办事处', N'130108001000', N'130108000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'697', N'裕强街道办事处', N'130108002000', N'130108000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'698', N'东苑街道办事处', N'130108003000', N'130108000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'699', N'建通街道办事处', N'130108004000', N'130108000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'700', N'槐底街道办事处', N'130108005000', N'130108000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'701', N'裕华路街道办事处', N'130108006000', N'130108000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'702', N'裕东街道办事处', N'130108007000', N'130108000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'703', N'裕翔街道办事处', N'130108008000', N'130108000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'704', N'建华南街道办事处', N'130108009000', N'130108000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'705', N'方村镇', N'130108101000', N'130108000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'706', N'廉州镇', N'130109100000', N'130109000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'707', N'兴安镇', N'130109101000', N'130109000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'708', N'贾市庄镇', N'130109102000', N'130109000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'709', N'南营镇', N'130109103000', N'130109000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'710', N'梅花镇', N'130109104000', N'130109000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'711', N'岗上镇', N'130109105000', N'130109000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'712', N'南董镇', N'130109107000', N'130109000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'713', N'张家庄镇', N'130109108000', N'130109000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'714', N'南孟镇', N'130109109000', N'130109000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'715', N'增村镇', N'130109110000', N'130109000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'716', N'常安镇', N'130109111000', N'130109000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'717', N'西关镇', N'130109112000', N'130109000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'718', N'九门回族乡', N'130109200000', N'130109000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'719', N'石家庄经济技术开发区', N'130109500000', N'130109000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'720', N'获鹿镇', N'130110100000', N'130110000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'721', N'铜冶镇', N'130110101000', N'130110000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'722', N'寺家庄镇', N'130110102000', N'130110000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'723', N'上庄镇', N'130110103000', N'130110000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'724', N'李村镇', N'130110104000', N'130110000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'725', N'宜安镇', N'130110105000', N'130110000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'726', N'黄壁庄镇', N'130110106000', N'130110000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'727', N'大河镇', N'130110107000', N'130110000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'728', N'山尹村镇', N'130110108000', N'130110000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'729', N'石井乡', N'130110200000', N'130110000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'730', N'白鹿泉乡', N'130110201000', N'130110000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'731', N'上寨乡', N'130110202000', N'130110000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'732', N'河北鹿泉经济开发区', N'130110500000', N'130110000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'733', N'栾城镇', N'130111100000', N'130111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'734', N'冶河镇', N'130111103000', N'130111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'735', N'窦妪镇', N'130111104000', N'130111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'736', N'楼底镇', N'130111105000', N'130111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'737', N'南高乡', N'130111200000', N'130111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'738', N'柳林屯乡', N'130111201000', N'130111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'739', N'西营乡', N'130111202000', N'130111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'740', N'微水镇', N'130121100000', N'130121000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'741', N'上安镇', N'130121101000', N'130121000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'742', N'天长镇', N'130121102000', N'130121000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'743', N'秀林镇', N'130121103000', N'130121000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'744', N'南峪镇', N'130121104000', N'130121000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'745', N'威州镇', N'130121105000', N'130121000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'746', N'小作镇', N'130121106000', N'130121000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'747', N'南障城镇', N'130121107000', N'130121000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'748', N'苍岩山镇', N'130121108000', N'130121000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'749', N'测鱼镇', N'130121109000', N'130121000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'750', N'吴家窑乡', N'130121200000', N'130121000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'751', N'北正乡', N'130121201000', N'130121000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'752', N'于家乡', N'130121202000', N'130121000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'753', N'孙庄乡', N'130121203000', N'130121000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'754', N'南陉乡', N'130121204000', N'130121000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'755', N'辛庄乡', N'130121205000', N'130121000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'756', N'南王庄乡', N'130121206000', N'130121000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'757', N'诸福屯街道办事处', N'130123001000', N'130123000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'758', N'三里屯街道办事处', N'130123002000', N'130123000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'759', N'正定镇', N'130123100000', N'130123000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'760', N'新城铺镇', N'130123102000', N'130123000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'761', N'新安镇', N'130123103000', N'130123000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'762', N'南牛乡', N'130123200000', N'130123000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'763', N'南楼乡', N'130123201000', N'130123000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'764', N'西平乐乡', N'130123202000', N'130123000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'765', N'北早现乡', N'130123203000', N'130123000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'766', N'曲阳桥乡', N'130123204000', N'130123000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'767', N'龙州镇', N'130125100000', N'130125000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'768', N'南桥镇', N'130125101000', N'130125000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'769', N'上碑镇', N'130125102000', N'130125000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'770', N'口头镇', N'130125103000', N'130125000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'771', N'独羊岗乡', N'130125200000', N'130125000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'772', N'安香乡', N'130125201000', N'130125000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'773', N'只里乡', N'130125202000', N'130125000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'774', N'市同乡', N'130125203000', N'130125000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'775', N'翟营乡', N'130125204000', N'130125000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'776', N'城寨乡', N'130125205000', N'130125000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'777', N'上方乡', N'130125206000', N'130125000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'778', N'玉亭乡', N'130125207000', N'130125000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'779', N'北河乡', N'130125208000', N'130125000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'780', N'上闫庄乡', N'130125209000', N'130125000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'781', N'九口子乡', N'130125210000', N'130125000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'782', N'开发区', N'130125400000', N'130125000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'783', N'灵寿镇', N'130126100000', N'130126000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'784', N'青同镇', N'130126101000', N'130126000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'785', N'塔上镇', N'130126102000', N'130126000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'786', N'陈庄镇', N'130126103000', N'130126000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'787', N'慈峪镇', N'130126104000', N'130126000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'788', N'岔头镇', N'130126105000', N'130126000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'789', N'三圣院乡', N'130126200000', N'130126000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'790', N'北洼乡', N'130126201000', N'130126000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'791', N'牛城乡', N'130126202000', N'130126000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'792', N'狗台乡', N'130126203000', N'130126000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'793', N'南寨乡', N'130126204000', N'130126000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'794', N'南燕川乡', N'130126205000', N'130126000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'795', N'北谭庄乡', N'130126206000', N'130126000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'796', N'寨头乡', N'130126207000', N'130126000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'797', N'南营乡', N'130126208000', N'130126000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'798', N'高邑镇', N'130127100000', N'130127000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'799', N'大营镇', N'130127101000', N'130127000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'800', N'富村镇', N'130127102000', N'130127000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'801', N'万城镇', N'130127103000', N'130127000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'802', N'中韩乡', N'130127201000', N'130127000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'803', N'深泽镇', N'130128100000', N'130128000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'804', N'铁杆镇', N'130128101000', N'130128000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'805', N'赵八镇', N'130128102000', N'130128000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'806', N'白庄乡', N'130128200000', N'130128000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'807', N'留村乡', N'130128201000', N'130128000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'808', N'桥头乡', N'130128203000', N'130128000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'809', N'赞皇镇', N'130129100000', N'130129000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'810', N'院头镇', N'130129101000', N'130129000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'811', N'南邢郭镇', N'130129102000', N'130129000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'812', N'嶂石岩镇', N'130129103000', N'130129000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'813', N'西龙门乡', N'130129200000', N'130129000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'814', N'南清河乡', N'130129202000', N'130129000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'815', N'西阳泽乡', N'130129203000', N'130129000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'816', N'土门乡', N'130129204000', N'130129000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'817', N'黄北坪乡', N'130129205000', N'130129000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'818', N'许亭乡', N'130129207000', N'130129000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'819', N'张楞乡', N'130129208000', N'130129000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'820', N'无极镇', N'130130100000', N'130130000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'821', N'七汲镇', N'130130101000', N'130130000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'822', N'张段固镇', N'130130102000', N'130130000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'823', N'北苏镇', N'130130103000', N'130130000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'824', N'郭庄镇', N'130130104000', N'130130000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'825', N'大陈镇', N'130130105000', N'130130000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'826', N'高头回族乡', N'130130200000', N'130130000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'827', N'郝庄乡', N'130130201000', N'130130000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'828', N'东侯坊乡', N'130130202000', N'130130000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'829', N'里城道乡', N'130130203000', N'130130000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'830', N'南流乡', N'130130204000', N'130130000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'831', N'平山镇', N'130131100000', N'130131000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'832', N'东回舍镇', N'130131101000', N'130131000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'833', N'温塘镇', N'130131102000', N'130131000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'834', N'南甸镇', N'130131103000', N'130131000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'835', N'岗南镇', N'130131104000', N'130131000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'836', N'古月镇', N'130131105000', N'130131000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'837', N'下槐镇', N'130131106000', N'130131000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'838', N'孟家庄镇', N'130131107000', N'130131000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'839', N'小觉镇', N'130131108000', N'130131000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'840', N'蛟潭庄镇', N'130131109000', N'130131000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'841', N'西柏坡镇', N'130131110000', N'130131000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'842', N'下口镇', N'130131111000', N'130131000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'843', N'西大吾乡', N'130131200000', N'130131000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'844', N'上三汲乡', N'130131201000', N'130131000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'845', N'两河乡', N'130131202000', N'130131000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'846', N'东王坡乡', N'130131203000', N'130131000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'847', N'苏家庄乡', N'130131204000', N'130131000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'848', N'宅北乡', N'130131205000', N'130131000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'849', N'北冶乡', N'130131207000', N'130131000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'850', N'上观音堂乡', N'130131209000', N'130131000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'851', N'杨家桥乡', N'130131210000', N'130131000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'852', N'营里乡', N'130131211000', N'130131000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'853', N'合河口乡', N'130131212000', N'130131000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'854', N'城区街道办事处', N'130132001000', N'130132000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'855', N'槐阳镇', N'130132100000', N'130132000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'856', N'殷村镇', N'130132101000', N'130132000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'857', N'南佐镇', N'130132102000', N'130132000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'858', N'宋曹镇', N'130132103000', N'130132000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'859', N'南因镇', N'130132104000', N'130132000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'860', N'姬村镇', N'130132105000', N'130132000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'861', N'北褚镇', N'130132106000', N'130132000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'862', N'马村镇', N'130132107000', N'130132000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'863', N'东张乡', N'130132201000', N'130132000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'864', N'赵同乡', N'130132202000', N'130132000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'865', N'苏村乡', N'130132204000', N'130132000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'866', N'苏阳乡', N'130132205000', N'130132000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'867', N'北正乡', N'130132206000', N'130132000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'868', N'前仙乡', N'130132207000', N'130132000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'869', N'黑水河乡', N'130132208000', N'130132000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'870', N'赵州镇', N'130133100000', N'130133000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'871', N'范庄镇', N'130133101000', N'130133000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'872', N'北王里镇', N'130133102000', N'130133000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'873', N'新寨店镇', N'130133103000', N'130133000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'874', N'韩村镇', N'130133104000', N'130133000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'875', N'南柏舍镇', N'130133105000', N'130133000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'876', N'沙河店镇', N'130133106000', N'130133000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'877', N'前大章乡', N'130133200000', N'130133000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'878', N'谢庄乡', N'130133201000', N'130133000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'879', N'高村乡', N'130133202000', N'130133000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'880', N'王西章乡', N'130133203000', N'130133000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'881', N'长江街道办事处', N'130171010000', N'130171000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'882', N'太行街道办事处', N'130171011000', N'130171000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'883', N'宋营镇', N'130171100000', N'130171000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'884', N'郄马镇', N'130171101000', N'130171000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'885', N'丘头镇', N'130172100000', N'130172000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'886', N'辛集镇', N'130181100000', N'130181000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'887', N'旧城镇', N'130181101000', N'130181000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'888', N'张古庄镇', N'130181102000', N'130181000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'889', N'位伯镇', N'130181103000', N'130181000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'890', N'新垒头镇', N'130181104000', N'130181000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'891', N'新城镇', N'130181105000', N'130181000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'892', N'南智邱镇', N'130181106000', N'130181000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'893', N'王口镇', N'130181107000', N'130181000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'894', N'天宫营乡', N'130181200000', N'130181000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'895', N'前营乡', N'130181201000', N'130181000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'896', N'马庄乡', N'130181202000', N'130181000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'897', N'和睦井乡', N'130181203000', N'130181000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'898', N'田家庄乡', N'130181204000', N'130181000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'899', N'中里厢乡', N'130181205000', N'130181000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'900', N'小辛庄乡', N'130181206000', N'130181000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'901', N'辛集经济开发区', N'130181500000', N'130181000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'902', N'晋州镇', N'130183100000', N'130183000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'903', N'总十庄镇', N'130183101000', N'130183000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'904', N'营里镇', N'130183102000', N'130183000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'905', N'桃园镇', N'130183103000', N'130183000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'906', N'东卓宿镇', N'130183104000', N'130183000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'907', N'马于镇', N'130183105000', N'130183000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'908', N'小樵镇', N'130183106000', N'130183000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'909', N'槐树镇', N'130183107000', N'130183000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'910', N'东里庄镇', N'130183108000', N'130183000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'911', N'周家庄乡', N'130183201000', N'130183000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'912', N'长寿街道办事处', N'130184001000', N'130184000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'913', N'化皮镇', N'130184101000', N'130184000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'914', N'承安镇', N'130184102000', N'130184000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'915', N'正莫镇', N'130184103000', N'130184000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'916', N'南大岳镇', N'130184104000', N'130184000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'917', N'杜固镇', N'130184105000', N'130184000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'918', N'邯邰镇', N'130184106000', N'130184000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'919', N'东王镇', N'130184107000', N'130184000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'920', N'马头铺镇', N'130184108000', N'130184000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'921', N'协神乡', N'130184200000', N'130184000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'922', N'木村乡', N'130184201000', N'130184000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'923', N'彭家庄回族乡', N'130184202000', N'130184000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'924', N'学院南路街道办事处', N'130202001000', N'130202000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'925', N'友谊街道办事处', N'130202002000', N'130202000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'926', N'广场街道办事处', N'130202003000', N'130202000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'927', N'永红桥街道办事处', N'130202004000', N'130202000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'928', N'小山街道办事处', N'130202005000', N'130202000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'929', N'文北街道办事处', N'130202006000', N'130202000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'930', N'钱营街道办事处', N'130202007000', N'130202000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'931', N'惠民道街道办事处', N'130202008000', N'130202000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'932', N'梁家屯路街道办事处', N'130202009000', N'130202000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'933', N'稻地镇', N'130202102000', N'130202000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'934', N'女织寨乡', N'130202200000', N'130202000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'935', N'乔屯街道办事处', N'130203001000', N'130203000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'936', N'文化路街道办事处', N'130203002000', N'130203000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'937', N'钓鱼台街道办事处', N'130203003000', N'130203000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'938', N'东新村街道办事处', N'130203004000', N'130203000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'939', N'缸窑街道办事处', N'130203005000', N'130203000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'940', N'机场路街道办事处', N'130203006000', N'130203000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'941', N'河北路街道办事处', N'130203007000', N'130203000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'942', N'龙东街道办事处', N'130203008000', N'130203000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'943', N'大里街道办事处', N'130203009000', N'130203000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'944', N'光明街道办事处', N'130203010000', N'130203000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'945', N'翔云道街道办事处', N'130203011000', N'130203000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'946', N'韩城镇', N'130203100000', N'130203000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'947', N'果园乡', N'130203200000', N'130203000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'948', N'林西街道办事处', N'130204001000', N'130204000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'949', N'唐家庄街道办事处', N'130204002000', N'130204000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'950', N'古冶街道办事处', N'130204003000', N'130204000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'951', N'赵各庄街道办事处', N'130204004000', N'130204000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'952', N'京华街道办事处', N'130204007000', N'130204000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'953', N'范各庄镇', N'130204100000', N'130204000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'954', N'卑家店镇', N'130204101000', N'130204000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'955', N'王辇庄乡', N'130204201000', N'130204000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'956', N'习家套乡', N'130204202000', N'130204000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'957', N'大庄坨乡', N'130204203000', N'130204000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'958', N'马家沟街道办事处', N'130205001000', N'130205000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'959', N'开平街道办事处', N'130205002000', N'130205000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'960', N'税务庄街道办事处', N'130205003000', N'130205000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'961', N'陡电街道办事处', N'130205005000', N'130205000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'962', N'荆各庄街道办事处', N'130205006000', N'130205000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'963', N'开平镇', N'130205100000', N'130205000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'964', N'栗园镇', N'130205101000', N'130205000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'965', N'郑庄子镇', N'130205102000', N'130205000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'966', N'双桥镇', N'130205103000', N'130205000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'967', N'洼里镇', N'130205104000', N'130205000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'968', N'越河镇', N'130205105000', N'130205000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'969', N'小集镇', N'130207103000', N'130207000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'970', N'黄各庄镇', N'130207104000', N'130207000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'971', N'西葛镇', N'130207105000', N'130207000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'972', N'大新庄镇', N'130207106000', N'130207000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'973', N'钱营镇', N'130207107000', N'130207000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'974', N'唐坊镇', N'130207108000', N'130207000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'975', N'王兰庄镇', N'130207109000', N'130207000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'976', N'柳树酄镇', N'130207110000', N'130207000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'977', N'黑沿子镇', N'130207111000', N'130207000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'978', N'丰南镇', N'130207113000', N'130207000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'979', N'大齐各庄镇', N'130207114000', N'130207000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'980', N'岔河镇', N'130207115000', N'130207000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'981', N'南孙庄乡', N'130207201000', N'130207000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'982', N'东田庄乡', N'130207202000', N'130207000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'983', N'尖字沽乡', N'130207203000', N'130207000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'984', N'太平路街道办事处', N'130208001000', N'130208000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'985', N'燕山路街道办事处', N'130208002000', N'130208000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'986', N'浭阳街道办事处', N'130208003000', N'130208000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'987', N'丰润镇', N'130208100000', N'130208000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'988', N'任各庄镇', N'130208102000', N'130208000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'989', N'左家坞镇', N'130208103000', N'130208000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'990', N'泉河头镇', N'130208104000', N'130208000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'991', N'王官营镇', N'130208105000', N'130208000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'992', N'火石营镇', N'130208106000', N'130208000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'993', N'新军屯镇', N'130208109000', N'130208000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'994', N'小张各庄镇', N'130208110000', N'130208000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'995', N'丰登坞镇', N'130208111000', N'130208000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'996', N'李钊庄镇', N'130208112000', N'130208000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'997', N'白官屯镇', N'130208113000', N'130208000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'998', N'石各庄镇', N'130208114000', N'130208000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'999', N'沙流河镇', N'130208115000', N'130208000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1000', N'七树庄镇', N'130208116000', N'130208000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1001', N'杨官林镇', N'130208117000', N'130208000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1002', N'银城铺镇', N'130208118000', N'130208000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1003', N'常庄镇', N'130208119000', N'130208000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1004', N'姜家营乡', N'130208202000', N'130208000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1005', N'欢喜庄乡', N'130208205000', N'130208000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1006', N'刘家营乡', N'130208208000', N'130208000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1007', N'唐海镇', N'130209100000', N'130209000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1008', N'滨海镇', N'130209112000', N'130209000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1009', N'柳赞镇', N'130209113000', N'130209000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1010', N'一农场', N'130209401000', N'130209000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1011', N'三农场', N'130209403000', N'130209000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1012', N'四农场', N'130209404000', N'130209000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1013', N'五农场', N'130209405000', N'130209000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1014', N'六农场', N'130209406000', N'130209000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1015', N'七农场', N'130209407000', N'130209000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1016', N'八农场', N'130209408000', N'130209000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1017', N'九农场', N'130209409000', N'130209000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1018', N'十农场', N'130209410000', N'130209000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1019', N'十一农场', N'130209411000', N'130209000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1020', N'八里滩养殖场', N'130209412000', N'130209000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1021', N'十里海养殖场', N'130209413000', N'130209000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1022', N'南堡经济开发区', N'130209450000', N'130209000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1023', N'曹妃甸工业区', N'130209451000', N'130209000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1024', N'曹妃甸新城', N'130209452000', N'130209000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1025', N'友谊路街道办事处', N'130224001000', N'130224000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1026', N'倴城镇', N'130224100000', N'130224000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1027', N'宋道口镇', N'130224101000', N'130224000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1028', N'长凝镇', N'130224102000', N'130224000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1029', N'胡各庄镇', N'130224103000', N'130224000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1030', N'坨里镇', N'130224104000', N'130224000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1031', N'姚王庄镇', N'130224105000', N'130224000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1032', N'司各庄镇', N'130224106000', N'130224000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1033', N'安各庄镇', N'130224107000', N'130224000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1034', N'扒齿港镇', N'130224108000', N'130224000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1035', N'程庄镇', N'130224109000', N'130224000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1036', N'青坨营镇', N'130224110000', N'130224000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1037', N'柏各庄镇', N'130224111000', N'130224000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1038', N'南堡镇', N'130224114000', N'130224000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1039', N'方各庄镇', N'130224115000', N'130224000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1040', N'东黄坨镇', N'130224116000', N'130224000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1041', N'马城镇', N'130224117000', N'130224000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1042', N'乐安街道办事处', N'130225001000', N'130225000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1043', N'乐亭镇', N'130225100000', N'130225000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1044', N'汤家河镇', N'130225101000', N'130225000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1045', N'胡家坨镇', N'130225102000', N'130225000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1046', N'阎各庄镇', N'130225104000', N'130225000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1047', N'马头营镇', N'130225105000', N'130225000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1048', N'新寨镇', N'130225106000', N'130225000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1049', N'汀流河镇', N'130225107000', N'130225000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1050', N'姜各庄镇', N'130225108000', N'130225000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1051', N'毛庄镇', N'130225109000', N'130225000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1052', N'中堡镇', N'130225110000', N'130225000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1053', N'庞各庄乡', N'130225201000', N'130225000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1054', N'大相各庄乡', N'130225202000', N'130225000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1055', N'古河乡', N'130225203000', N'130225000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1056', N'河北乐亭经济开发区', N'130225453000', N'130225000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1057', N'乐亭县城区工业聚集区管理委员会', N'130225454000', N'130225000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1058', N'迁西县栗乡街道办事处', N'130227001000', N'130227000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1059', N'兴城镇', N'130227100000', N'130227000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1060', N'金厂峪镇', N'130227101000', N'130227000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1061', N'洒河桥镇', N'130227102000', N'130227000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1062', N'太平寨镇', N'130227103000', N'130227000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1063', N'罗家屯镇', N'130227104000', N'130227000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1064', N'东荒峪镇', N'130227105000', N'130227000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1065', N'新集镇', N'130227106000', N'130227000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1066', N'三屯营镇', N'130227107000', N'130227000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1067', N'滦阳镇', N'130227108000', N'130227000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1068', N'白庙子乡', N'130227200000', N'130227000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1069', N'上营乡', N'130227201000', N'130227000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1070', N'汉儿庄乡', N'130227202000', N'130227000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1071', N'渔户寨乡', N'130227203000', N'130227000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1072', N'旧城乡', N'130227204000', N'130227000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1073', N'尹庄乡', N'130227205000', N'130227000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1074', N'东莲花院乡', N'130227206000', N'130227000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1075', N'新庄子乡', N'130227207000', N'130227000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1076', N'迁西县栗乡工业产业聚集区', N'130227450000', N'130227000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1077', N'无终街道办事处', N'130229001000', N'130229000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1078', N'玉田镇', N'130229100000', N'130229000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1079', N'亮甲店镇', N'130229101000', N'130229000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1080', N'鸦鸿桥镇', N'130229102000', N'130229000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1081', N'窝洛沽镇', N'130229103000', N'130229000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1082', N'石臼窝镇', N'130229104000', N'130229000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1083', N'虹桥镇', N'130229105000', N'130229000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1084', N'散水头镇', N'130229106000', N'130229000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1085', N'林南仓镇', N'130229107000', N'130229000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1086', N'林西镇', N'130229108000', N'130229000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1087', N'杨家板桥镇', N'130229109000', N'130229000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1088', N'彩亭桥镇', N'130229110000', N'130229000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1089', N'孤树镇', N'130229111000', N'130229000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1090', N'大安镇镇', N'130229112000', N'130229000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1091', N'唐自头镇', N'130229113000', N'130229000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1092', N'郭家屯镇', N'130229114000', N'130229000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1093', N'杨家套镇', N'130229115000', N'130229000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1094', N'林头屯乡', N'130229201000', N'130229000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1095', N'潮洛窝乡', N'130229203000', N'130229000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1096', N'陈家铺乡', N'130229204000', N'130229000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1097', N'郭家桥乡', N'130229205000', N'130229000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1098', N'芦台开发区海北镇', N'130271100000', N'130271000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1099', N'芦台开发区新华路街道办事处', N'130271450000', N'130271000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1100', N'汉沽管理区汉丰镇', N'130272101000', N'130272000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1101', N'汉沽管理区兴农办事处', N'130272451000', N'130272000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1102', N'汉沽管理区振兴街道办事处', N'130272452000', N'130272000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1103', N'街道办事处', N'130273001000', N'130273000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1104', N'庆北办事处', N'130273003000', N'130273000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1105', N'三女河办事处', N'130273004000', N'130273000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1106', N'老庄子镇', N'130273101000', N'130273000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1107', N'唐山海港开发区王滩镇', N'130274103000', N'130274000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1108', N'唐山海港经济开发区街道办事处', N'130274451000', N'130274000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1109', N'唐山湾国际旅游岛', N'130274452000', N'130274000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1110', N'大清河', N'130274455000', N'130274000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1111', N'华明路街道办事处', N'130281001000', N'130281000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1112', N'文化路街道办事处', N'130281002000', N'130281000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1113', N'遵化镇', N'130281100000', N'130281000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1114', N'堡子店镇', N'130281101000', N'130281000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1115', N'马兰峪镇', N'130281102000', N'130281000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1116', N'平安城镇', N'130281103000', N'130281000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1117', N'东新庄镇', N'130281104000', N'130281000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1118', N'新店子镇', N'130281105000', N'130281000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1119', N'党峪镇', N'130281106000', N'130281000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1120', N'地北头镇', N'130281107000', N'130281000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1121', N'东旧寨镇', N'130281108000', N'130281000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1122', N'铁厂镇', N'130281109000', N'130281000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1123', N'苏家洼镇', N'130281110000', N'130281000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1124', N'建明镇', N'130281111000', N'130281000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1125', N'石门镇', N'130281112000', N'130281000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1126', N'西留村乡', N'130281200000', N'130281000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1127', N'崔家庄乡', N'130281201000', N'130281000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1128', N'兴旺寨乡', N'130281202000', N'130281000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1129', N'西下营满族乡', N'130281203000', N'130281000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1130', N'汤泉满族乡', N'130281204000', N'130281000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1131', N'东陵满族乡', N'130281205000', N'130281000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1132', N'刘备寨乡', N'130281206000', N'130281000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1133', N'团瓢庄乡', N'130281207000', N'130281000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1134', N'娘娘庄乡', N'130281208000', N'130281000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1135', N'西三里乡', N'130281209000', N'130281000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1136', N'侯家寨乡', N'130281210000', N'130281000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1137', N'小厂乡', N'130281211000', N'130281000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1138', N'迁安镇', N'130283100000', N'130283000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1139', N'夏官营镇', N'130283101000', N'130283000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1140', N'杨各庄镇', N'130283102000', N'130283000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1141', N'建昌营镇', N'130283103000', N'130283000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1142', N'赵店子镇', N'130283104000', N'130283000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1143', N'野鸡坨镇', N'130283105000', N'130283000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1144', N'大崔庄镇', N'130283106000', N'130283000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1145', N'杨店子镇', N'130283107000', N'130283000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1146', N'蔡园镇', N'130283108000', N'130283000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1147', N'马兰庄镇', N'130283109000', N'130283000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1148', N'沙河驿镇', N'130283110000', N'130283000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1149', N'木厂口镇', N'130283111000', N'130283000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1150', N'扣庄乡', N'130283200000', N'130283000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1151', N'彭店子乡', N'130283201000', N'130283000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1152', N'上射雁庄乡', N'130283202000', N'130283000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1153', N'闫家店乡', N'130283203000', N'130283000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1154', N'五重安乡', N'130283204000', N'130283000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1155', N'大五里乡', N'130283205000', N'130283000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1156', N'太平庄乡', N'130283206000', N'130283000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1157', N'滦河街道办事处', N'130284001000', N'130284000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1158', N'古城街道办事处', N'130284002000', N'130284000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1159', N'滦城路街道办事处', N'130284003000', N'130284000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1160', N'响堂街道办事处', N'130284004000', N'130284000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1161', N'东安各庄镇', N'130284102000', N'130284000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1162', N'雷庄镇', N'130284103000', N'130284000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1163', N'茨榆坨镇', N'130284104000', N'130284000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1164', N'榛子镇', N'130284105000', N'130284000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1165', N'杨柳庄镇', N'130284106000', N'130284000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1166', N'油榨镇', N'130284107000', N'130284000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1167', N'古马镇', N'130284108000', N'130284000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1168', N'小马庄镇', N'130284109000', N'130284000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1169', N'九百户镇', N'130284110000', N'130284000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1170', N'王店子镇', N'130284111000', N'130284000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1171', N'文化路街道办事处', N'130302001000', N'130302000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1172', N'海滨路街道办事处', N'130302002000', N'130302000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1173', N'北环路街道办事处', N'130302003000', N'130302000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1174', N'建设大街街道办事处', N'130302004000', N'130302000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1175', N'河东街道办事处', N'130302005000', N'130302000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1176', N'西港路街道办事处', N'130302006000', N'130302000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1177', N'燕山大街街道办事处', N'130302007000', N'130302000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1178', N'港城大街街道办事处', N'130302008000', N'130302000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1179', N'东环路街道办事处', N'130302009000', N'130302000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1180', N'白塔岭街道办事处', N'130302010000', N'130302000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1181', N'东港镇', N'130302100000', N'130302000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1182', N'海港镇', N'130302101000', N'130302000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1183', N'西港镇', N'130302102000', N'130302000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1184', N'海阳镇', N'130302103000', N'130302000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1185', N'北港镇', N'130302104000', N'130302000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1186', N'杜庄镇', N'130302105000', N'130302000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1187', N'石门寨镇', N'130302106000', N'130302000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1188', N'驻操营镇', N'130302107000', N'130302000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1189', N'临港物流园区', N'130302403000', N'130302000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1190', N'海港经济开发区', N'130302404000', N'130302000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1191', N'南关街道办事处', N'130303001000', N'130303000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1192', N'古城街道办事处', N'130303002000', N'130303000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1193', N'西关街道办事处', N'130303003000', N'130303000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1194', N'路南街道办事处', N'130303004000', N'130303000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1195', N'第一关镇', N'130303100000', N'130303000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1196', N'石河镇', N'130303101000', N'130303000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1197', N'孟姜镇', N'130303102000', N'130303000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1198', N'西山街道办事处', N'130304001000', N'130304000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1199', N'东山街道办事处', N'130304002000', N'130304000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1200', N'海滨镇', N'130304100000', N'130304000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1201', N'戴河镇', N'130304101000', N'130304000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1202', N'牛头崖镇', N'130304103000', N'130304000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1203', N'骊城街道办事处', N'130306001000', N'130306000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1204', N'抚宁镇', N'130306100000', N'130306000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1205', N'留守营镇', N'130306101000', N'130306000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1206', N'榆关镇', N'130306102000', N'130306000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1207', N'台营镇', N'130306105000', N'130306000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1208', N'大新寨镇', N'130306106000', N'130306000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1209', N'茶棚乡', N'130306200000', N'130306000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1210', N'深河乡', N'130306202000', N'130306000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1211', N'都阳路街道办事处', N'130321001000', N'130321000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1212', N'青龙镇', N'130321100000', N'130321000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1213', N'祖山镇', N'130321101000', N'130321000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1214', N'木头凳镇', N'130321102000', N'130321000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1215', N'双山子镇', N'130321103000', N'130321000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1216', N'马圈子镇', N'130321104000', N'130321000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1217', N'肖营子镇', N'130321105000', N'130321000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1218', N'大巫岚镇', N'130321106000', N'130321000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1219', N'土门子镇', N'130321107000', N'130321000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1220', N'八道河镇', N'130321108000', N'130321000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1221', N'隔河头镇', N'130321109000', N'130321000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1222', N'娄杖子镇', N'130321110000', N'130321000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1223', N'凤凰山乡', N'130321200000', N'130321000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1224', N'龙王庙乡', N'130321201000', N'130321000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1225', N'三星口乡', N'130321202000', N'130321000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1226', N'干沟乡', N'130321203000', N'130321000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1227', N'大石岭乡', N'130321206000', N'130321000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1228', N'官场乡', N'130321208000', N'130321000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1229', N'茨榆山乡', N'130321209000', N'130321000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1230', N'平方子乡', N'130321210000', N'130321000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1231', N'安子岭乡', N'130321211000', N'130321000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1232', N'朱杖子乡', N'130321212000', N'130321000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1233', N'草碾乡', N'130321213000', N'130321000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1234', N'七道河乡', N'130321214000', N'130321000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1235', N'三拨子乡', N'130321217000', N'130321000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1236', N'凉水河乡', N'130321218000', N'130321000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1237', N'昌黎镇', N'130322100000', N'130322000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1238', N'靖安镇', N'130322101000', N'130322000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1239', N'安山镇', N'130322102000', N'130322000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1240', N'龙家店镇', N'130322103000', N'130322000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1241', N'泥井镇', N'130322104000', N'130322000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1242', N'大蒲河镇', N'130322105000', N'130322000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1243', N'新集镇', N'130322106000', N'130322000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1244', N'刘台庄镇', N'130322107000', N'130322000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1245', N'茹荷镇', N'130322108000', N'130322000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1246', N'朱各庄镇', N'130322109000', N'130322000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1247', N'荒佃庄镇', N'130322110000', N'130322000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1248', N'团林乡', N'130322201000', N'130322000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1249', N'葛条港乡', N'130322202000', N'130322000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1250', N'马坨店乡', N'130322203000', N'130322000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1251', N'两山乡', N'130322206000', N'130322000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1252', N'十里铺乡', N'130322207000', N'130322000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1253', N'卢龙镇', N'130324100000', N'130324000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1254', N'潘庄镇', N'130324101000', N'130324000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1255', N'燕河营镇', N'130324102000', N'130324000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1256', N'双望镇', N'130324103000', N'130324000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1257', N'刘田各庄镇', N'130324104000', N'130324000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1258', N'石门镇', N'130324105000', N'130324000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1259', N'木井镇', N'130324106000', N'130324000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1260', N'陈官屯镇', N'130324107000', N'130324000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1261', N'蛤泊镇', N'130324108000', N'130324000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1262', N'下寨乡', N'130324200000', N'130324000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1263', N'刘家营乡', N'130324201000', N'130324000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1264', N'印庄乡', N'130324203000', N'130324000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1265', N'河北卢龙经济开发区', N'130324400000', N'130324000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1266', N'船厂路街道办事处', N'130371005000', N'130371000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1267', N'珠江道街道办事处', N'130371011000', N'130371000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1268', N'黄河道街道办事处', N'130371012000', N'130371000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1269', N'腾飞路街道办事处', N'130371013000', N'130371000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1270', N'渤海乡', N'130371200000', N'130371000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1271', N'榆关管理区办事处', N'130371400000', N'130371000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1272', N'牛头崖管理区办事处', N'130371401000', N'130371000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1273', N'南戴河街道办事处', N'130372001000', N'130372000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1274', N'大蒲河管理处', N'130372400000', N'130372000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1275', N'团林管理处', N'130372401000', N'130372000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1276', N'留守营管理处', N'130372402000', N'130372000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1277', N'火磨街道办事处', N'130402001000', N'130402000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1278', N'陵园路街道办事处', N'130402002000', N'130402000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1279', N'光明路街道办事处', N'130402003000', N'130402000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1280', N'滏东街道办事处', N'130402004000', N'130402000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1281', N'罗城头街道办事处', N'130402005000', N'130402000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1282', N'渚河路街道办事处', N'130402006000', N'130402000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1283', N'浴新南街道办事处', N'130402007000', N'130402000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1284', N'农林路街道办事处', N'130402008000', N'130402000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1285', N'贸东街道办事处', N'130402009000', N'130402000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1286', N'贸西街道办事处', N'130402010000', N'130402000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1287', N'盛和路街道办事处', N'130402011000', N'130402000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1288', N'北张庄镇', N'130402101000', N'130402000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1289', N'河沙镇镇', N'130402102000', N'130402000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1290', N'马庄乡', N'130402200000', N'130402000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1291', N'南堡乡', N'130402201000', N'130402000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1292', N'代召乡', N'130402202000', N'130402000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1293', N'丛台西街道办事处', N'130403001000', N'130403000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1294', N'联纺西街道办事处', N'130403002000', N'130403000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1295', N'联纺东街道办事处', N'130403003000', N'130403000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1296', N'光明桥街道办事处', N'130403004000', N'130403000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1297', N'丛台东街道办事处', N'130403005000', N'130403000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1298', N'四季青街道办事处', N'130403006000', N'130403000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1299', N'和平街道办事处', N'130403007000', N'130403000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1300', N'中华街道办事处', N'130403008000', N'130403000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1301', N'人民路街道办事处', N'130403009000', N'130403000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1302', N'柳林桥街道办事处', N'130403010000', N'130403000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1303', N'黄粱梦镇', N'130403101000', N'130403000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1304', N'苏曹乡', N'130403200000', N'130403000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1305', N'三陵乡', N'130403205000', N'130403000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1306', N'南吕固乡', N'130403206000', N'130403000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1307', N'兼庄乡', N'130403207000', N'130403000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1308', N'胜利桥街道办事处', N'130404001000', N'130404000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1309', N'百家村街道办事处', N'130404002000', N'130404000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1310', N'铁路大院街道办事处', N'130404003000', N'130404000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1311', N'化林路街道办事处', N'130404004000', N'130404000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1312', N'庞村街道办事处', N'130404005000', N'130404000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1313', N'二六七二街道办事处', N'130404006000', N'130404000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1314', N'石化街道办事处', N'130404007000', N'130404000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1315', N'户村镇', N'130404100000', N'130404000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1316', N'彭家寨乡', N'130404200000', N'130404000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1317', N'康庄乡', N'130404201000', N'130404000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1318', N'滏阳东路街道办事处', N'130406001000', N'130406000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1319', N'临水镇', N'130406100000', N'130406000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1320', N'峰峰镇', N'130406101000', N'130406000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1321', N'新坡镇', N'130406102000', N'130406000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1322', N'大社镇', N'130406103000', N'130406000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1323', N'和村镇', N'130406104000', N'130406000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1324', N'义井镇', N'130406105000', N'130406000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1325', N'彭城镇', N'130406106000', N'130406000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1326', N'界城镇', N'130406107000', N'130406000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1327', N'大峪镇', N'130406108000', N'130406000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1328', N'西固义乡', N'130406200000', N'130406000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1329', N'肥乡镇', N'130407100000', N'130407000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1330', N'天台山镇', N'130407101000', N'130407000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1331', N'辛安镇镇', N'130407102000', N'130407000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1332', N'大寺上镇', N'130407103000', N'130407000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1333', N'东漳堡镇', N'130407104000', N'130407000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1334', N'毛演堡乡', N'130407202000', N'130407000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1335', N'元固乡', N'130407203000', N'130407000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1336', N'屯庄营乡', N'130407204000', N'130407000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1337', N'旧店乡', N'130407206000', N'130407000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1338', N'临洺关镇', N'130408100000', N'130408000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1339', N'大北汪镇', N'130408101000', N'130408000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1340', N'张西堡镇', N'130408102000', N'130408000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1341', N'广府镇', N'130408103000', N'130408000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1342', N'永合会镇', N'130408105000', N'130408000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1343', N'刘营镇', N'130408106000', N'130408000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1344', N'西苏镇', N'130408107000', N'130408000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1345', N'讲武镇', N'130408108000', N'130408000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1346', N'东杨庄镇', N'130408109000', N'130408000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1347', N'界河店乡', N'130408201000', N'130408000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1348', N'刘汉乡', N'130408203000', N'130408000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1349', N'正西乡', N'130408204000', N'130408000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1350', N'曲陌乡', N'130408206000', N'130408000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1351', N'辛庄堡乡', N'130408207000', N'130408000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1352', N'小龙马乡', N'130408208000', N'130408000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1353', N'西河庄乡', N'130408211000', N'130408000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1354', N'西阳城乡', N'130408213000', N'130408000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1355', N'临漳镇', N'130423100000', N'130423000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1356', N'南东坊镇', N'130423101000', N'130423000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1357', N'孙陶集镇', N'130423102000', N'130423000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1358', N'柳园镇', N'130423103000', N'130423000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1359', N'称勾集镇', N'130423104000', N'130423000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1360', N'邺城镇', N'130423105000', N'130423000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1361', N'章里集镇', N'130423106000', N'130423000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1362', N'狄邱乡', N'130423200000', N'130423000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1363', N'张村集乡', N'130423201000', N'130423000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1364', N'西羊羔乡', N'130423202000', N'130423000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1365', N'杜村集乡', N'130423204000', N'130423000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1366', N'习文乡', N'130423206000', N'130423000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1367', N'砖寨营乡', N'130423207000', N'130423000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1368', N'柏鹤集乡', N'130423208000', N'130423000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1369', N'成安镇', N'130424100000', N'130424000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1370', N'商城镇', N'130424101000', N'130424000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1371', N'漳河店镇', N'130424102000', N'130424000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1372', N'李家疃镇', N'130424103000', N'130424000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1373', N'北乡义镇', N'130424104000', N'130424000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1374', N'辛义乡', N'130424200000', N'130424000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1375', N'柏寺营乡', N'130424201000', N'130424000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1376', N'道东堡乡', N'130424202000', N'130424000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1377', N'长巷乡', N'130424204000', N'130424000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1378', N'大名镇', N'130425100000', N'130425000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1379', N'杨桥镇', N'130425101000', N'130425000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1380', N'万堤镇', N'130425102000', N'130425000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1381', N'龙王庙镇', N'130425103000', N'130425000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1382', N'束馆镇', N'130425104000', N'130425000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1383', N'金滩镇', N'130425105000', N'130425000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1384', N'沙圪塔镇', N'130425106000', N'130425000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1385', N'大街镇', N'130425107000', N'130425000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1386', N'铺上镇', N'130425108000', N'130425000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1387', N'孙甘店镇', N'130425109000', N'130425000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1388', N'王村乡', N'130425201000', N'130425000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1389', N'黄金堤乡', N'130425203000', N'130425000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1390', N'旧治乡', N'130425205000', N'130425000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1391', N'西未庄乡', N'130425206000', N'130425000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1392', N'西付集乡', N'130425208000', N'130425000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1393', N'埝头乡', N'130425209000', N'130425000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1394', N'北峰乡', N'130425210000', N'130425000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1395', N'张铁集乡', N'130425211000', N'130425000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1396', N'红庙乡', N'130425212000', N'130425000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1397', N'营镇回族乡', N'130425213000', N'130425000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1398', N'平安街道办事处', N'130426001000', N'130426000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1399', N'河南店镇', N'130426101000', N'130426000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1400', N'索堡镇', N'130426102000', N'130426000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1401', N'西戌镇', N'130426103000', N'130426000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1402', N'井店镇', N'130426104000', N'130426000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1403', N'更乐镇', N'130426105000', N'130426000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1404', N'固新镇', N'130426106000', N'130426000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1405', N'西达镇', N'130426107000', N'130426000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1406', N'偏城镇', N'130426108000', N'130426000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1407', N'神头乡', N'130426200000', N'130426000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1408', N'辽城乡', N'130426201000', N'130426000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1409', N'偏店乡', N'130426202000', N'130426000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1410', N'龙虎乡', N'130426203000', N'130426000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1411', N'木井乡', N'130426204000', N'130426000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1412', N'关防乡', N'130426205000', N'130426000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1413', N'合漳乡', N'130426206000', N'130426000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1414', N'鹿头乡', N'130426207000', N'130426000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1415', N'涉城镇', N'130426400000', N'130426000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1416', N'磁州镇', N'130427100000', N'130427000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1417', N'讲武城镇', N'130427103000', N'130427000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1418', N'岳城镇', N'130427104000', N'130427000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1419', N'观台镇', N'130427105000', N'130427000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1420', N'白土镇', N'130427107000', N'130427000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1421', N'黄沙镇', N'130427108000', N'130427000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1422', N'路村营乡', N'130427200000', N'130427000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1423', N'时村营乡', N'130427204000', N'130427000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1424', N'陶泉乡', N'130427207000', N'130427000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1425', N'都党乡', N'130427208000', N'130427000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1426', N'北贾壁乡', N'130427209000', N'130427000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1427', N'新马头镇', N'130430100000', N'130430000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1428', N'邱城镇', N'130430101000', N'130430000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1429', N'梁二庄镇', N'130430102000', N'130430000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1430', N'香城固镇', N'130430103000', N'130430000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1431', N'古城营镇', N'130430104000', N'130430000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1432', N'南辛店乡', N'130430201000', N'130430000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1433', N'陈村回族乡', N'130430204000', N'130430000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1434', N'鸡泽镇', N'130431100000', N'130431000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1435', N'小寨镇', N'130431101000', N'130431000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1436', N'双塔镇', N'130431102000', N'130431000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1437', N'曹庄镇', N'130431103000', N'130431000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1438', N'浮图店乡', N'130431200000', N'130431000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1439', N'吴官营乡', N'130431201000', N'130431000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1440', N'风正乡', N'130431202000', N'130431000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1441', N'广平镇', N'130432100000', N'130432000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1442', N'平固店镇', N'130432101000', N'130432000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1443', N'胜营镇', N'130432102000', N'130432000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1444', N'南阳堡镇', N'130432103000', N'130432000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1445', N'十里铺乡', N'130432201000', N'130432000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1446', N'南韩村乡', N'130432202000', N'130432000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1447', N'东张孟乡', N'130432204000', N'130432000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1448', N'馆陶镇', N'130433100000', N'130433000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1449', N'房寨镇', N'130433101000', N'130433000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1450', N'柴堡镇', N'130433102000', N'130433000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1451', N'魏僧寨镇', N'130433103000', N'130433000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1452', N'寿山寺乡', N'130433200000', N'130433000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1453', N'王桥乡', N'130433201000', N'130433000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1454', N'南徐村乡', N'130433202000', N'130433000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1455', N'路桥乡', N'130433203000', N'130433000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1456', N'魏城镇', N'130434100000', N'130434000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1457', N'德政镇', N'130434101000', N'130434000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1458', N'北皋镇', N'130434102000', N'130434000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1459', N'双井镇', N'130434103000', N'130434000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1460', N'牙里镇', N'130434104000', N'130434000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1461', N'车往镇', N'130434105000', N'130434000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1462', N'回隆镇', N'130434106000', N'130434000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1463', N'张二庄镇', N'130434107000', N'130434000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1464', N'东代固镇', N'130434108000', N'130434000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1465', N'院堡镇', N'130434109000', N'130434000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1466', N'棘针寨镇', N'130434110000', N'130434000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1467', N'南双庙镇', N'130434111000', N'130434000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1468', N'沙口集乡', N'130434202000', N'130434000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1469', N'野胡拐乡', N'130434203000', N'130434000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1470', N'仕望集乡', N'130434204000', N'130434000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1471', N'前大磨乡', N'130434205000', N'130434000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1472', N'大辛庄乡', N'130434208000', N'130434000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1473', N'大马村乡', N'130434209000', N'130434000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1474', N'边马乡', N'130434210000', N'130434000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1475', N'北台头乡', N'130434212000', N'130434000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1476', N'泊口乡', N'130434213000', N'130434000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1477', N'曲周镇', N'130435100000', N'130435000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1478', N'安寨镇', N'130435101000', N'130435000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1479', N'侯村镇', N'130435102000', N'130435000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1480', N'河南疃镇', N'130435103000', N'130435000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1481', N'第四疃镇', N'130435104000', N'130435000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1482', N'白寨镇', N'130435105000', N'130435000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1483', N'槐桥乡', N'130435200000', N'130435000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1484', N'南里岳乡', N'130435201000', N'130435000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1485', N'大河道乡', N'130435203000', N'130435000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1486', N'依庄乡', N'130435204000', N'130435000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1487', N'开发区办事处', N'130471001000', N'130471000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1488', N'尚璧镇', N'130471100000', N'130471000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1489', N'南沿村镇', N'130471101000', N'130471000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1490', N'小西堡乡', N'130471200000', N'130471000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1491', N'姚寨乡', N'130471201000', N'130471000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1492', N'城南办事处', N'130473001000', N'130473000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1493', N'高臾镇', N'130473100000', N'130473000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1494', N'西光禄镇', N'130473101000', N'130473000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1495', N'林坛镇', N'130473102000', N'130473000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1496', N'马头镇', N'130473103000', N'130473000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1497', N'辛庄营乡', N'130473200000', N'130473000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1498', N'花官营乡', N'130473201000', N'130473000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1499', N'台城乡', N'130473202000', N'130473000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1500', N'南城乡', N'130473203000', N'130473000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1501', N'武安镇', N'130481100000', N'130481000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1502', N'康二城镇', N'130481101000', N'130481000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1503', N'午汲镇', N'130481102000', N'130481000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1504', N'磁山镇', N'130481103000', N'130481000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1505', N'伯延镇', N'130481104000', N'130481000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1506', N'淑村镇', N'130481105000', N'130481000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1507', N'大同镇', N'130481106000', N'130481000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1508', N'邑城镇', N'130481107000', N'130481000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1509', N'矿山镇', N'130481108000', N'130481000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1510', N'贺进镇', N'130481109000', N'130481000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1511', N'阳邑镇', N'130481110000', N'130481000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1512', N'徘徊镇', N'130481111000', N'130481000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1513', N'冶陶镇', N'130481112000', N'130481000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1514', N'上团城乡', N'130481200000', N'130481000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1515', N'北安庄乡', N'130481201000', N'130481000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1516', N'北安乐乡', N'130481202000', N'130481000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1517', N'西土山乡', N'130481203000', N'130481000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1518', N'西寺庄乡', N'130481204000', N'130481000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1519', N'活水乡', N'130481205000', N'130481000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1520', N'石洞乡', N'130481206000', N'130481000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1521', N'管陶乡', N'130481207000', N'130481000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1522', N'马家庄乡', N'130481208000', N'130481000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1523', N'南长街街道办事处', N'130502001000', N'130502000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1524', N'北大街街道办事处', N'130502002000', N'130502000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1525', N'西大街街道办事处', N'130502003000', N'130502000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1526', N'西门里街道办事处', N'130502004000', N'130502000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1527', N'泉东街道办事处', N'130502005000', N'130502000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1528', N'豫让桥街道', N'130502006000', N'130502000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1529', N'东郭村镇', N'130502100000', N'130502000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1530', N'祝村镇', N'130502101000', N'130502000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1531', N'大梁庄乡', N'130502200000', N'130502000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1532', N'钢铁路街道办事处', N'130503001000', N'130503000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1533', N'中兴路街道办事处', N'130503002000', N'130503000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1534', N'达活泉街道办事处', N'130503003000', N'130503000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1535', N'张宽街道办事处', N'130503004000', N'130503000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1536', N'章村街道办事处', N'130503005000', N'130503000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1537', N'中华大街街道办事处', N'130503006000', N'130503000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1538', N'团结路街道办事处', N'130503007000', N'130503000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1539', N'泉西街道办事处', N'130503008000', N'130503000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1540', N'南大郭镇', N'130503100000', N'130503000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1541', N'李村镇', N'130503101000', N'130503000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1542', N'晏家屯镇', N'130521103000', N'130521000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1543', N'南石门镇', N'130521104000', N'130521000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1544', N'羊范镇', N'130521105000', N'130521000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1545', N'皇寺镇', N'130521106000', N'130521000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1546', N'会宁镇', N'130521107000', N'130521000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1547', N'西黄村镇', N'130521108000', N'130521000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1548', N'路罗镇', N'130521109000', N'130521000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1549', N'将军墓镇', N'130521110000', N'130521000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1550', N'浆水镇', N'130521111000', N'130521000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1551', N'宋家庄镇', N'130521112000', N'130521000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1552', N'太子井乡', N'130521200000', N'130521000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1553', N'龙泉寺乡', N'130521201000', N'130521000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1554', N'北小庄乡', N'130521202000', N'130521000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1555', N'城计头乡', N'130521203000', N'130521000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1556', N'白岸乡', N'130521204000', N'130521000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1557', N'冀家村乡', N'130521206000', N'130521000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1558', N'临城镇', N'130522100000', N'130522000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1559', N'东镇镇', N'130522101000', N'130522000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1560', N'西竖镇', N'130522102000', N'130522000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1561', N'郝庄镇', N'130522103000', N'130522000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1562', N'黑城乡', N'130522200000', N'130522000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1563', N'鸭鸽营乡', N'130522201000', N'130522000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1564', N'石城乡', N'130522203000', N'130522000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1565', N'赵庄乡', N'130522205000', N'130522000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1566', N'内丘镇', N'130523100000', N'130523000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1567', N'大孟村镇', N'130523101000', N'130523000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1568', N'金店镇', N'130523102000', N'130523000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1569', N'官庄镇', N'130523103000', N'130523000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1570', N'柳林镇', N'130523104000', N'130523000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1571', N'五郭店乡', N'130523200000', N'130523000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1572', N'南赛乡', N'130523203000', N'130523000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1573', N'獐獏乡', N'130523204000', N'130523000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1574', N'侯家庄乡', N'130523205000', N'130523000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1575', N'柏乡镇', N'130524100000', N'130524000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1576', N'固城店镇', N'130524101000', N'130524000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1577', N'西汪镇', N'130524102000', N'130524000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1578', N'龙华镇', N'130524103000', N'130524000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1579', N'王家庄乡', N'130524200000', N'130524000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1580', N'内步乡', N'130524203000', N'130524000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1581', N'隆尧镇', N'130525100000', N'130525000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1582', N'魏家庄镇', N'130525101000', N'130525000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1583', N'尹村镇', N'130525102000', N'130525000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1584', N'山口镇', N'130525103000', N'130525000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1585', N'莲子镇镇', N'130525104000', N'130525000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1586', N'固城镇', N'130525105000', N'130525000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1587', N'东良镇', N'130525106000', N'130525000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1588', N'北楼乡', N'130525200000', N'130525000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1589', N'双碑乡', N'130525202000', N'130525000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1590', N'牛家桥乡', N'130525203000', N'130525000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1591', N'千户营乡', N'130525204000', N'130525000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1592', N'大张庄乡', N'130525205000', N'130525000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1593', N'柳行农场', N'130525400000', N'130525000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1594', N'任城镇', N'130526100000', N'130526000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1595', N'邢家湾镇', N'130526101000', N'130526000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1596', N'辛店镇', N'130526102000', N'130526000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1597', N'天口镇', N'130526103000', N'130526000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1598', N'西固城乡', N'130526200000', N'130526000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1599', N'永福庄乡', N'130526201000', N'130526000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1600', N'大屯乡', N'130526202000', N'130526000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1601', N'骆庄乡', N'130526204000', N'130526000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1602', N'和阳镇', N'130527100000', N'130527000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1603', N'贾宋镇', N'130527101000', N'130527000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1604', N'郝桥镇', N'130527102000', N'130527000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1605', N'东三召乡', N'130527200000', N'130527000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1606', N'阎里乡', N'130527201000', N'130527000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1607', N'河郭乡', N'130527202000', N'130527000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1608', N'史召乡', N'130527203000', N'130527000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1609', N'三思乡', N'130527204000', N'130527000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1610', N'宁北街道办事处', N'130528001000', N'130528000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1611', N'凤凰镇', N'130528100000', N'130528000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1612', N'河渠镇', N'130528101000', N'130528000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1613', N'北河庄镇', N'130528102000', N'130528000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1614', N'耿庄桥镇', N'130528103000', N'130528000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1615', N'东汪镇', N'130528104000', N'130528000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1616', N'贾家口镇', N'130528105000', N'130528000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1617', N'四芝兰镇', N'130528106000', N'130528000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1618', N'大陆村镇', N'130528107000', N'130528000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1619', N'苏家庄镇', N'130528108000', N'130528000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1620', N'换马店镇', N'130528109000', N'130528000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1621', N'唐邱镇', N'130528110000', N'130528000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1622', N'侯口乡', N'130528200000', N'130528000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1623', N'纪昌庄乡', N'130528202000', N'130528000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1624', N'北鱼乡', N'130528205000', N'130528000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1625', N'徐家河乡', N'130528208000', N'130528000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1626', N'大曹庄乡', N'130528209000', N'130528000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1627', N'大曹庄管理区', N'130528401000', N'130528000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1628', N'巨鹿镇', N'130529100000', N'130529000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1629', N'王虎寨镇', N'130529101000', N'130529000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1630', N'西郭城镇', N'130529102000', N'130529000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1631', N'官亭镇', N'130529103000', N'130529000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1632', N'阎疃镇', N'130529104000', N'130529000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1633', N'小吕寨镇', N'130529105000', N'130529000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1634', N'苏家营镇', N'130529106000', N'130529000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1635', N'堤村乡', N'130529200000', N'130529000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1636', N'张王疃乡', N'130529201000', N'130529000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1637', N'观寨乡', N'130529202000', N'130529000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1638', N'新河镇', N'130530100000', N'130530000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1639', N'寻寨镇', N'130530101000', N'130530000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1640', N'白神首乡', N'130530200000', N'130530000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1641', N'荆家庄乡', N'130530201000', N'130530000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1642', N'西流乡', N'130530202000', N'130530000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1643', N'仁让里乡', N'130530203000', N'130530000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1644', N'广宗镇', N'130531100000', N'130531000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1645', N'冯家寨镇', N'130531101000', N'130531000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1646', N'北塘疃镇', N'130531102000', N'130531000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1647', N'核桃园镇', N'130531103000', N'130531000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1648', N'葫芦乡', N'130531200000', N'130531000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1649', N'大平台乡', N'130531201000', N'130531000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1650', N'件只乡', N'130531202000', N'130531000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1651', N'东召乡', N'130531204000', N'130531000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1652', N'平乡县中华路街道办事处', N'130532001000', N'130532000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1653', N'平乡镇', N'130532101000', N'130532000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1654', N'河古庙镇', N'130532102000', N'130532000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1655', N'节固乡', N'130532200000', N'130532000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1656', N'油召乡', N'130532201000', N'130532000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1657', N'田付村乡', N'130532202000', N'130532000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1658', N'寻召乡', N'130532203000', N'130532000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1659', N'洺州镇', N'130533100000', N'130533000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1660', N'梨园屯镇', N'130533101000', N'130533000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1661', N'章台镇', N'130533102000', N'130533000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1662', N'侯贯镇', N'130533103000', N'130533000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1663', N'七级镇', N'130533104000', N'130533000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1664', N'贺营镇', N'130533105000', N'130533000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1665', N'方家营镇', N'130533106000', N'130533000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1666', N'常庄镇', N'130533107000', N'130533000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1667', N'第什营镇', N'130533108000', N'130533000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1668', N'贺钊镇', N'130533109000', N'130533000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1669', N'赵村镇', N'130533110000', N'130533000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1670', N'枣园乡', N'130533202000', N'130533000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1671', N'固献乡', N'130533203000', N'130533000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1672', N'张家营乡', N'130533206000', N'130533000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1673', N'常屯乡', N'130533207000', N'130533000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1674', N'高公庄乡', N'130533209000', N'130533000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1675', N'葛仙庄镇', N'130534100000', N'130534000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1676', N'连庄镇', N'130534101000', N'130534000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1677', N'油坊镇', N'130534102000', N'130534000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1678', N'谢炉镇', N'130534103000', N'130534000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1679', N'王官庄镇', N'130534104000', N'130534000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1680', N'坝营镇', N'130534105000', N'130534000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1681', N'临西镇', N'130535100000', N'130535000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1682', N'河西镇', N'130535101000', N'130535000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1683', N'下堡寺镇', N'130535102000', N'130535000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1684', N'尖冢镇', N'130535103000', N'130535000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1685', N'老官寨镇', N'130535104000', N'130535000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1686', N'吕寨镇', N'130535105000', N'130535000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1687', N'东枣园乡', N'130535200000', N'130535000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1688', N'摇鞍镇乡', N'130535203000', N'130535000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1689', N'大刘庄乡', N'130535204000', N'130535000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1690', N'轴承工业园区', N'130535400000', N'130535000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1691', N'东汪镇', N'130571100000', N'130571000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1692', N'王快镇', N'130571101000', N'130571000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1693', N'沙河城镇', N'130571103000', N'130571000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1694', N'留村镇', N'130571104000', N'130571000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1695', N'市高新技术开发区', N'130571400000', N'130571000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1696', N'凤岗街道办事处', N'130581001000', N'130581000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1697', N'南杜街道办事处', N'130581002000', N'130581000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1698', N'北胡街道办事处', N'130581003000', N'130581000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1699', N'西丁街道办事处', N'130581004000', N'130581000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1700', N'苏村镇', N'130581100000', N'130581000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1701', N'大高村镇', N'130581101000', N'130581000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1702', N'垂杨镇', N'130581102000', N'130581000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1703', N'明化镇', N'130581103000', N'130581000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1704', N'段芦头镇', N'130581104000', N'130581000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1705', N'紫冢镇', N'130581105000', N'130581000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1706', N'大村乡', N'130581200000', N'130581000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1707', N'南便村乡', N'130581201000', N'130581000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1708', N'大屯乡', N'130581202000', N'130581000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1709', N'王道寨乡', N'130581203000', N'130581000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1710', N'薛吴村乡', N'130581204000', N'130581000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1711', N'褡裢街道办事处', N'130582001000', N'130582000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1712', N'桥东街道办事处', N'130582002000', N'130582000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1713', N'桥西街道办事处', N'130582003000', N'130582000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1714', N'赞善办事处', N'130582004000', N'130582000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1715', N'周庄街道办事处', N'130582005000', N'130582000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1716', N'新城镇', N'130582101000', N'130582000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1717', N'白塔镇', N'130582102000', N'130582000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1718', N'十里亭镇', N'130582103000', N'130582000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1719', N'綦村镇', N'130582104000', N'130582000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1720', N'册井乡', N'130582201000', N'130582000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1721', N'刘石岗乡', N'130582202000', N'130582000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1722', N'柴关乡', N'130582203000', N'130582000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1723', N'蝉房乡', N'130582204000', N'130582000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1724', N'先锋街道办事处', N'130602001000', N'130602000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1725', N'新市场街道办事处', N'130602002000', N'130602000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1726', N'东风街道办事处', N'130602003000', N'130602000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1727', N'建南街道办事处', N'130602004000', N'130602000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1728', N'韩村北路街道办事处', N'130602005000', N'130602000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1729', N'颉庄乡', N'130602200000', N'130602000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1730', N'富昌乡', N'130602201000', N'130602000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1731', N'韩村乡', N'130602202000', N'130602000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1732', N'南奇乡', N'130602203000', N'130602000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1733', N'江城乡', N'130602204000', N'130602000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1734', N'和平里街道办事处', N'130606001000', N'130606000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1735', N'五四路街道办事处', N'130606002000', N'130606000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1736', N'西关街道办事处', N'130606003000', N'130606000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1737', N'中华路街道办事处', N'130606004000', N'130606000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1738', N'东关街道办事处', N'130606005000', N'130606000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1739', N'联盟街道办事处', N'130606006000', N'130606000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1740', N'红星街道办事处', N'130606007000', N'130606000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1741', N'裕华街道办事处', N'130606008000', N'130606000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1742', N'永华街道办事处', N'130606009000', N'130606000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1743', N'南关街道办事处', N'130606010000', N'130606000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1744', N'韩庄乡', N'130606200000', N'130606000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1745', N'东金庄乡', N'130606201000', N'130606000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1746', N'百楼乡', N'130606202000', N'130606000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1747', N'杨庄乡', N'130606203000', N'130606000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1748', N'南大园乡', N'130606204000', N'130606000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1749', N'焦庄乡', N'130606205000', N'130606000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1750', N'五尧乡', N'130606206000', N'130606000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1751', N'惠阳街道办事处', N'130607001000', N'130607000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1752', N'满城镇', N'130607100000', N'130607000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1753', N'大册营镇', N'130607101000', N'130607000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1754', N'神星镇', N'130607102000', N'130607000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1755', N'南韩村镇', N'130607103000', N'130607000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1756', N'方顺桥镇', N'130607104000', N'130607000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1757', N'于家庄乡', N'130607201000', N'130607000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1758', N'要庄乡', N'130607203000', N'130607000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1759', N'白龙乡', N'130607204000', N'130607000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1760', N'石井乡', N'130607205000', N'130607000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1761', N'坨南乡', N'130607206000', N'130607000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1762', N'刘家台乡', N'130607207000', N'130607000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1763', N'河北满城经济开发区', N'130607400000', N'130607000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1764', N'清苑镇', N'130608100000', N'130608000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1765', N'冉庄镇', N'130608101000', N'130608000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1766', N'阳城镇', N'130608102000', N'130608000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1767', N'魏村镇', N'130608103000', N'130608000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1768', N'温仁镇', N'130608104000', N'130608000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1769', N'张登镇', N'130608105000', N'130608000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1770', N'大庄镇', N'130608106000', N'130608000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1771', N'臧村镇', N'130608107000', N'130608000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1772', N'望亭镇', N'130608108000', N'130608000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1773', N'白团乡', N'130608200000', N'130608000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1774', N'北店乡', N'130608201000', N'130608000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1775', N'石桥乡', N'130608202000', N'130608000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1776', N'李庄乡', N'130608203000', N'130608000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1777', N'北王力乡', N'130608204000', N'130608000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1778', N'东吕乡', N'130608205000', N'130608000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1779', N'何桥乡', N'130608206000', N'130608000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1780', N'孙村乡', N'130608207000', N'130608000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1781', N'阎庄乡', N'130608208000', N'130608000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1782', N'河北清苑经济开发区', N'130608400000', N'130608000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1783', N'安肃镇', N'130609100000', N'130609000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1784', N'崔庄镇', N'130609101000', N'130609000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1785', N'大因镇', N'130609102000', N'130609000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1786', N'遂城镇', N'130609103000', N'130609000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1787', N'高林村镇', N'130609104000', N'130609000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1788', N'大王店镇', N'130609105000', N'130609000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1789', N'漕河镇', N'130609106000', N'130609000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1790', N'东史端镇', N'130609107000', N'130609000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1791', N'留村镇', N'130609108000', N'130609000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1792', N'正村镇', N'130609109000', N'130609000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1793', N'户木乡', N'130609203000', N'130609000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1794', N'瀑河乡', N'130609204000', N'130609000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1795', N'东釜山乡', N'130609205000', N'130609000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1796', N'义联庄乡', N'130609206000', N'130609000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1797', N'城区社区管理办公室街道办事处', N'130623001000', N'130623000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1798', N'涞水镇', N'130623100000', N'130623000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1799', N'永阳镇', N'130623101000', N'130623000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1800', N'义安镇', N'130623102000', N'130623000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1801', N'石亭镇', N'130623103000', N'130623000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1802', N'赵各庄镇', N'130623104000', N'130623000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1803', N'九龙镇', N'130623105000', N'130623000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1804', N'三坡镇', N'130623106000', N'130623000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1805', N'一渡镇', N'130623107000', N'130623000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1806', N'明义镇', N'130623108000', N'130623000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1807', N'王村镇', N'130623109000', N'130623000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1808', N'娄村镇', N'130623110000', N'130623000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1809', N'东文山乡', N'130623202000', N'130623000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1810', N'其中口乡', N'130623205000', N'130623000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1811', N'龙门乡', N'130623206000', N'130623000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1812', N'胡家庄乡', N'130623207000', N'130623000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1813', N'涞水县经济开发区', N'130623400000', N'130623000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1814', N'阜平镇', N'130624100000', N'130624000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1815', N'龙泉关镇', N'130624101000', N'130624000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1816', N'平阳镇', N'130624102000', N'130624000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1817', N'城南庄镇', N'130624103000', N'130624000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1818', N'天生桥镇', N'130624104000', N'130624000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1819', N'王林口镇', N'130624105000', N'130624000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1820', N'台峪乡', N'130624202000', N'130624000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1821', N'大台乡', N'130624203000', N'130624000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1822', N'史家寨乡', N'130624204000', N'130624000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1823', N'砂窝乡', N'130624205000', N'130624000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1824', N'吴王口乡', N'130624206000', N'130624000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1825', N'夏庄乡', N'130624207000', N'130624000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1826', N'北果元乡', N'130624208000', N'130624000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1827', N'定兴镇', N'130626100000', N'130626000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1828', N'固城镇', N'130626101000', N'130626000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1829', N'贤寓镇', N'130626102000', N'130626000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1830', N'北河镇', N'130626103000', N'130626000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1831', N'天宫寺镇', N'130626104000', N'130626000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1832', N'小朱庄镇', N'130626105000', N'130626000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1833', N'姚村镇', N'130626106000', N'130626000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1834', N'东落堡乡', N'130626200000', N'130626000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1835', N'高里乡', N'130626201000', N'130626000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1836', N'张家庄乡', N'130626202000', N'130626000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1837', N'肖村乡', N'130626204000', N'130626000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1838', N'柳卓乡', N'130626205000', N'130626000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1839', N'杨村乡', N'130626206000', N'130626000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1840', N'北田乡', N'130626207000', N'130626000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1841', N'北南蔡乡', N'130626208000', N'130626000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1842', N'李郁庄乡', N'130626209000', N'130626000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1843', N'仁厚镇', N'130627100000', N'130627000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1844', N'王京镇', N'130627101000', N'130627000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1845', N'高昌镇', N'130627102000', N'130627000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1846', N'北罗镇', N'130627103000', N'130627000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1847', N'白合镇', N'130627104000', N'130627000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1848', N'军城镇', N'130627105000', N'130627000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1849', N'川里镇', N'130627106000', N'130627000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1850', N'长古城镇', N'130627107000', N'130627000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1851', N'罗庄镇', N'130627108000', N'130627000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1852', N'都亭乡', N'130627201000', N'130627000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1853', N'南店头乡', N'130627202000', N'130627000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1854', N'北店头乡', N'130627203000', N'130627000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1855', N'雹水乡', N'130627205000', N'130627000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1856', N'大洋乡', N'130627206000', N'130627000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1857', N'迷城乡', N'130627207000', N'130627000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1858', N'齐家佐乡', N'130627208000', N'130627000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1859', N'羊角乡', N'130627209000', N'130627000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1860', N'石门乡', N'130627210000', N'130627000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1861', N'黄石口乡', N'130627211000', N'130627000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1862', N'倒马关乡', N'130627212000', N'130627000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1863', N'高阳县锦华街道办事处', N'130628001000', N'130628000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1864', N'庞口镇', N'130628101000', N'130628000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1865', N'西演镇', N'130628102000', N'130628000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1866', N'邢家南镇', N'130628103000', N'130628000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1867', N'晋庄镇', N'130628104000', N'130628000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1868', N'蒲口乡', N'130628202000', N'130628000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1869', N'小王果庄乡', N'130628203000', N'130628000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1870', N'庞家佐乡', N'130628205000', N'130628000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1871', N'高阳县经济开发区', N'130628400000', N'130628000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1872', N'容城镇', N'130629100000', N'130629000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1873', N'小里镇', N'130629101000', N'130629000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1874', N'南张镇', N'130629102000', N'130629000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1875', N'大河镇', N'130629103000', N'130629000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1876', N'晾马台镇', N'130629104000', N'130629000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1877', N'八于乡', N'130629200000', N'130629000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1878', N'贾光乡', N'130629201000', N'130629000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1879', N'平王乡', N'130629203000', N'130629000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1880', N'涞源镇', N'130630100000', N'130630000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1881', N'银坊镇', N'130630101000', N'130630000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1882', N'走马驿镇', N'130630102000', N'130630000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1883', N'水堡镇', N'130630103000', N'130630000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1884', N'王安镇', N'130630104000', N'130630000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1885', N'杨家庄镇', N'130630105000', N'130630000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1886', N'白石山镇', N'130630106000', N'130630000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1887', N'南屯镇', N'130630107000', N'130630000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1888', N'南马庄乡', N'130630201000', N'130630000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1889', N'北石佛乡', N'130630202000', N'130630000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1890', N'金家井乡', N'130630203000', N'130630000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1891', N'留家庄乡', N'130630204000', N'130630000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1892', N'上庄乡', N'130630205000', N'130630000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1893', N'东团堡乡', N'130630206000', N'130630000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1894', N'塔崖驿乡', N'130630207000', N'130630000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1895', N'乌龙沟乡', N'130630208000', N'130630000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1896', N'烟煤洞乡', N'130630209000', N'130630000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1897', N'望都镇', N'130631100000', N'130631000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1898', N'固店镇', N'130631101000', N'130631000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1899', N'贾村镇', N'130631102000', N'130631000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1900', N'中韩庄镇', N'130631103000', N'130631000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1901', N'寺庄乡', N'130631200000', N'130631000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1902', N'赵庄乡', N'130631201000', N'130631000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1903', N'黑堡乡', N'130631202000', N'130631000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1904', N'高岭乡', N'130631204000', N'130631000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1905', N'望都经济开发区', N'130631400000', N'130631000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1906', N'安新镇', N'130632100000', N'130632000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1907', N'大王镇', N'130632101000', N'130632000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1908', N'三台镇', N'130632102000', N'130632000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1909', N'端村镇', N'130632103000', N'130632000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1910', N'赵北口镇', N'130632104000', N'130632000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1911', N'同口镇', N'130632105000', N'130632000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1912', N'刘李庄镇', N'130632106000', N'130632000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1913', N'安州镇', N'130632107000', N'130632000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1914', N'老河头镇', N'130632108000', N'130632000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1915', N'圈头乡', N'130632200000', N'130632000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1916', N'寨里乡', N'130632201000', N'130632000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1917', N'芦庄乡', N'130632202000', N'130632000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1918', N'龙化乡', N'130632203000', N'130632000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1919', N'易州镇', N'130633100000', N'130633000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1920', N'梁格庄镇', N'130633101000', N'130633000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1921', N'西陵镇', N'130633102000', N'130633000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1922', N'裴山镇', N'130633103000', N'130633000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1923', N'塘湖镇', N'130633104000', N'130633000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1924', N'狼牙山镇', N'130633105000', N'130633000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1925', N'良岗镇', N'130633106000', N'130633000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1926', N'紫荆关镇', N'130633107000', N'130633000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1927', N'高村镇', N'130633108000', N'130633000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1928', N'桥头乡', N'130633200000', N'130633000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1929', N'白马乡', N'130633201000', N'130633000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1930', N'流井乡', N'130633202000', N'130633000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1931', N'高陌乡', N'130633204000', N'130633000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1932', N'大龙华乡', N'130633205000', N'130633000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1933', N'安格庄乡', N'130633206000', N'130633000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1934', N'凌云册乡', N'130633207000', N'130633000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1935', N'西山北乡', N'130633208000', N'130633000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1936', N'尉都乡', N'130633209000', N'130633000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1937', N'独乐乡', N'130633210000', N'130633000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1938', N'七峪乡', N'130633211000', N'130633000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1939', N'富岗乡', N'130633212000', N'130633000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1940', N'坡仓乡', N'130633213000', N'130633000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1941', N'牛岗乡', N'130633214000', N'130633000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1942', N'桥家河乡', N'130633215000', N'130633000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1943', N'甘河净乡', N'130633216000', N'130633000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1944', N'蔡家峪乡', N'130633217000', N'130633000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1945', N'南城司乡', N'130633218000', N'130633000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1946', N'恒州镇', N'130634100000', N'130634000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1947', N'灵山镇', N'130634101000', N'130634000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1948', N'燕赵镇', N'130634102000', N'130634000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1949', N'羊平镇', N'130634103000', N'130634000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1950', N'文德镇', N'130634104000', N'130634000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1951', N'晓林镇', N'130634105000', N'130634000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1952', N'邸村镇', N'130634106000', N'130634000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1953', N'齐村镇', N'130634107000', N'130634000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1954', N'路庄子乡', N'130634200000', N'130634000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1955', N'下河乡', N'130634201000', N'130634000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1956', N'庄窠乡', N'130634202000', N'130634000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1957', N'孝墓乡', N'130634203000', N'130634000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1958', N'东旺乡', N'130634205000', N'130634000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1959', N'产德乡', N'130634208000', N'130634000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1960', N'党城乡', N'130634210000', N'130634000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1961', N'郎家庄乡', N'130634211000', N'130634000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1962', N'范家庄乡', N'130634212000', N'130634000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1963', N'北台乡', N'130634213000', N'130634000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1964', N'蠡吾镇', N'130635100000', N'130635000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1965', N'留史镇', N'130635101000', N'130635000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1966', N'大百尺镇', N'130635102000', N'130635000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1967', N'辛兴镇', N'130635103000', N'130635000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1968', N'北郭丹镇', N'130635104000', N'130635000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1969', N'万安镇', N'130635105000', N'130635000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1970', N'桑园镇', N'130635106000', N'130635000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1971', N'南庄镇', N'130635107000', N'130635000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1972', N'大曲堤镇', N'130635108000', N'130635000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1973', N'鲍墟镇', N'130635109000', N'130635000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1974', N'小陈乡', N'130635200000', N'130635000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1975', N'林堡乡', N'130635201000', N'130635000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1976', N'北埝头乡', N'130635202000', N'130635000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1977', N'蒲阳镇', N'130636100000', N'130636000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1978', N'高于铺镇', N'130636101000', N'130636000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1979', N'腰山镇', N'130636102000', N'130636000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1980', N'蒲上镇', N'130636103000', N'130636000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1981', N'神南镇', N'130636104000', N'130636000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1982', N'白云乡', N'130636201000', N'130636000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1983', N'河口乡', N'130636202000', N'130636000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1984', N'安阳乡', N'130636203000', N'130636000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1985', N'台鱼乡', N'130636204000', N'130636000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1986', N'大悲乡', N'130636205000', N'130636000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1987', N'博野镇', N'130637100000', N'130637000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1988', N'小店镇', N'130637101000', N'130637000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1989', N'程委镇', N'130637102000', N'130637000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1990', N'东墟镇', N'130637103000', N'130637000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1991', N'北杨镇', N'130637104000', N'130637000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1992', N'城东镇', N'130637105000', N'130637000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1993', N'南小王乡', N'130637203000', N'130637000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1994', N'雄州镇', N'130638100000', N'130638000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1995', N'昝岗镇', N'130638101000', N'130638000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1996', N'大营镇', N'130638102000', N'130638000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1997', N'龙湾镇', N'130638103000', N'130638000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1998', N'朱各庄镇', N'130638104000', N'130638000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'1999', N'米家务镇', N'130638105000', N'130638000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2000', N'鄚州镇', N'130638106000', N'130638000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2001', N'苟各庄镇', N'130638107000', N'130638000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2002', N'北沙口乡', N'130638200000', N'130638000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2003', N'双堂乡', N'130638203000', N'130638000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2004', N'张岗乡', N'130638204000', N'130638000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2005', N'七间房乡', N'130638205000', N'130638000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2006', N'贤台乡', N'130671202000', N'130671000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2007', N'大马坊乡', N'130671205000', N'130671000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2008', N'保定国家高新区', N'130671400000', N'130671000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2009', N'白沟镇', N'130672103000', N'130672000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2010', N'双塔街道办事处', N'130681001000', N'130681000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2011', N'桃园街道办事处', N'130681002000', N'130681000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2012', N'清凉寺街道办事处', N'130681003000', N'130681000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2013', N'松林店镇', N'130681100000', N'130681000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2014', N'码头镇', N'130681101000', N'130681000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2015', N'东城坊镇', N'130681102000', N'130681000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2016', N'高官庄镇', N'130681103000', N'130681000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2017', N'东仙坡镇', N'130681104000', N'130681000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2018', N'百尺竿镇', N'130681105000', N'130681000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2019', N'义和庄镇', N'130681106000', N'130681000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2020', N'刁窝镇', N'130681107000', N'130681000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2021', N'林家屯镇', N'130681108000', N'130681000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2022', N'豆庄镇', N'130681109000', N'130681000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2023', N'孙庄乡', N'130681204000', N'130681000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2024', N'高新技术产业开发区管理委员会', N'130681400000', N'130681000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2025', N'京南经济开发区管理委员会', N'130681401000', N'130681000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2026', N'南城区街道办事处', N'130682001000', N'130682000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2027', N'北城区街道办事处', N'130682002000', N'130682000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2028', N'西城区街道办事处', N'130682003000', N'130682000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2029', N'长安路街道办事处', N'130682004000', N'130682000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2030', N'留早镇', N'130682100000', N'130682000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2031', N'清风店镇', N'130682101000', N'130682000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2032', N'庞村镇', N'130682102000', N'130682000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2033', N'砖路镇', N'130682103000', N'130682000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2034', N'明月店镇', N'130682104000', N'130682000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2035', N'叮咛店镇', N'130682105000', N'130682000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2036', N'东亭镇', N'130682106000', N'130682000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2037', N'大辛庄镇', N'130682107000', N'130682000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2038', N'东旺镇', N'130682108000', N'130682000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2039', N'高蓬镇', N'130682109000', N'130682000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2040', N'邢邑镇', N'130682110000', N'130682000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2041', N'李亲顾镇', N'130682111000', N'130682000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2042', N'子位镇', N'130682112000', N'130682000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2043', N'开元镇', N'130682113000', N'130682000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2044', N'周村镇', N'130682115000', N'130682000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2045', N'息冢镇', N'130682116000', N'130682000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2046', N'东留春乡', N'130682203000', N'130682000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2047', N'号头庄回族乡', N'130682204000', N'130682000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2048', N'杨家庄乡', N'130682205000', N'130682000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2049', N'大鹿庄乡', N'130682206000', N'130682000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2050', N'西城乡', N'130682208000', N'130682000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2051', N'药都街道办事处', N'130683001000', N'130683000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2052', N'祁州路街道办事处', N'130683002000', N'130683000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2053', N'伍仁桥镇', N'130683101000', N'130683000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2054', N'石佛镇', N'130683102000', N'130683000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2055', N'郑章镇', N'130683103000', N'130683000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2056', N'大五女镇', N'130683104000', N'130683000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2057', N'西佛落镇', N'130683105000', N'130683000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2058', N'西城镇', N'130683106000', N'130683000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2059', N'明官店乡', N'130683200000', N'130683000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2060', N'南娄底乡', N'130683201000', N'130683000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2061', N'北段村乡', N'130683204000', N'130683000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2062', N'现代中药工业园区', N'130683400000', N'130683000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2063', N'和平街道办事处', N'130684001000', N'130684000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2064', N'军城街道办事处', N'130684002000', N'130684000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2065', N'东盛街道办事处', N'130684003000', N'130684000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2066', N'北城街道办事处', N'130684004000', N'130684000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2067', N'兴华路街道办事处', N'130684005000', N'130684000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2068', N'方官镇', N'130684100000', N'130684000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2069', N'新城镇', N'130684101000', N'130684000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2070', N'泗庄镇', N'130684102000', N'130684000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2071', N'辛立庄镇', N'130684104000', N'130684000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2072', N'东马营镇', N'130684105000', N'130684000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2073', N'辛桥镇', N'130684106000', N'130684000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2074', N'肖官营镇', N'130684107000', N'130684000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2075', N'张六庄镇', N'130684108000', N'130684000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2076', N'梁家营乡', N'130684201000', N'130684000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2077', N'红旗楼街道办事处', N'130702001000', N'130702000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2078', N'胜利北路街道办事处', N'130702002000', N'130702000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2079', N'五一路街道办事处', N'130702003000', N'130702000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2080', N'花园街街道办事处', N'130702004000', N'130702000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2081', N'工业路街道办事处', N'130702005000', N'130702000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2082', N'姚家庄镇', N'130702101000', N'130702000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2083', N'大仓盖镇', N'130702102000', N'130702000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2084', N'东望山乡', N'130702202000', N'130702000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2085', N'新华街街道办事处', N'130703001000', N'130703000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2086', N'大境门街道办事处', N'130703002000', N'130703000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2087', N'明德北街街道办事处', N'130703003000', N'130703000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2088', N'明德南街街道办事处', N'130703004000', N'130703000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2089', N'堡子里街道办事处', N'130703005000', N'130703000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2090', N'南营坊街道办事处', N'130703006000', N'130703000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2091', N'工人新村街道办事处', N'130703007000', N'130703000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2092', N'东窑子镇', N'130703100000', N'130703000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2093', N'天泰寺街道办事处', N'130705001000', N'130705000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2094', N'皇城街道办事处', N'130705002000', N'130705000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2095', N'南关街道办事处', N'130705003000', N'130705000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2096', N'南大街街道办事处', N'130705004000', N'130705000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2097', N'大北街街道办事处', N'130705005000', N'130705000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2098', N'工业街街道办事处', N'130705006000', N'130705000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2099', N'建国街街道办事处', N'130705007000', N'130705000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2100', N'庞家堡镇', N'130705100000', N'130705000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2101', N'深井镇', N'130705101000', N'130705000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2102', N'崞村镇', N'130705102000', N'130705000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2103', N'洋河南镇', N'130705104000', N'130705000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2104', N'贾家营镇', N'130705106000', N'130705000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2105', N'顾家营镇', N'130705107000', N'130705000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2106', N'赵川镇', N'130705108000', N'130705000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2107', N'河子西乡', N'130705200000', N'130705000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2108', N'春光乡', N'130705201000', N'130705000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2109', N'侯家庙乡', N'130705202000', N'130705000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2110', N'李家堡乡', N'130705204000', N'130705000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2111', N'王家湾乡', N'130705205000', N'130705000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2112', N'塔儿村乡', N'130705206000', N'130705000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2113', N'江家屯乡', N'130705207000', N'130705000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2114', N'城镇街道办事处', N'130706001000', N'130706000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2115', N'煤矿街道办事处', N'130706002000', N'130706000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2116', N'花园乡', N'130706200000', N'130706000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2117', N'辛庄子乡', N'130706201000', N'130706000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2118', N'定方水乡', N'130706202000', N'130706000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2119', N'段家堡乡', N'130706203000', N'130706000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2120', N'孔家庄街道办事处', N'130708001000', N'130708000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2121', N'孔家庄镇', N'130708100000', N'130708000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2122', N'万全镇', N'130708101000', N'130708000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2123', N'洗马林镇', N'130708102000', N'130708000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2124', N'郭磊庄镇', N'130708103000', N'130708000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2125', N'膳房堡乡', N'130708200000', N'130708000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2126', N'北新屯乡', N'130708201000', N'130708000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2127', N'宣平堡乡', N'130708202000', N'130708000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2128', N'高庙堡乡', N'130708203000', N'130708000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2129', N'旧堡乡', N'130708204000', N'130708000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2130', N'安家堡乡', N'130708205000', N'130708000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2131', N'北沙城乡', N'130708206000', N'130708000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2132', N'西湾子街道办', N'130709001000', N'130709000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2133', N'西湾子镇', N'130709100000', N'130709000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2134', N'高家营镇', N'130709101000', N'130709000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2135', N'四台嘴乡', N'130709200000', N'130709000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2136', N'红旗营乡', N'130709201000', N'130709000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2137', N'石窑子乡', N'130709202000', N'130709000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2138', N'驿马图乡', N'130709203000', N'130709000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2139', N'石嘴子乡', N'130709204000', N'130709000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2140', N'狮子沟乡', N'130709205000', N'130709000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2141', N'清三营乡', N'130709206000', N'130709000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2142', N'白旗乡', N'130709207000', N'130709000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2143', N'张北镇', N'130722100000', N'130722000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2144', N'公会镇', N'130722101000', N'130722000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2145', N'二台镇', N'130722102000', N'130722000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2146', N'大囫囵镇', N'130722103000', N'130722000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2147', N'小二台镇', N'130722104000', N'130722000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2148', N'油篓沟镇', N'130722106000', N'130722000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2149', N'大河镇', N'130722107000', N'130722000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2150', N'台路沟乡', N'130722200000', N'130722000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2151', N'馒头营乡', N'130722202000', N'130722000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2152', N'二泉井乡', N'130722203000', N'130722000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2153', N'单晶河乡', N'130722204000', N'130722000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2154', N'海流图乡', N'130722206000', N'130722000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2155', N'两面井乡', N'130722207000', N'130722000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2156', N'大西湾乡', N'130722208000', N'130722000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2157', N'郝家营乡', N'130722209000', N'130722000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2158', N'白庙滩乡', N'130722210000', N'130722000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2159', N'战海乡', N'130722212000', N'130722000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2160', N'三号乡', N'130722213000', N'130722000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2161', N'康保镇', N'130723100000', N'130723000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2162', N'张纪镇', N'130723101000', N'130723000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2163', N'土城子镇', N'130723102000', N'130723000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2164', N'邓油坊镇', N'130723103000', N'130723000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2165', N'李家地镇', N'130723104000', N'130723000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2166', N'照阳河镇', N'130723105000', N'130723000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2167', N'屯垦镇', N'130723106000', N'130723000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2168', N'闫油坊乡', N'130723200000', N'130723000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2169', N'丹清河乡', N'130723201000', N'130723000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2170', N'哈咇嘎乡', N'130723202000', N'130723000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2171', N'二号卜乡', N'130723203000', N'130723000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2172', N'芦家营乡', N'130723204000', N'130723000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2173', N'忠义乡', N'130723205000', N'130723000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2174', N'处长地乡', N'130723206000', N'130723000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2175', N'满德堂乡', N'130723207000', N'130723000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2176', N'康保牧场', N'130723500000', N'130723000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2177', N'屯垦林场', N'130723501000', N'130723000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2178', N'平定堡镇', N'130724100000', N'130724000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2179', N'小厂镇', N'130724101000', N'130724000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2180', N'黄盖淖镇', N'130724102000', N'130724000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2181', N'九连城镇', N'130724103000', N'130724000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2182', N'高山堡乡', N'130724200000', N'130724000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2183', N'小河子乡', N'130724201000', N'130724000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2184', N'二道渠乡', N'130724202000', N'130724000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2185', N'大二号回族乡', N'130724203000', N'130724000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2186', N'闪电河乡', N'130724204000', N'130724000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2187', N'长梁乡', N'130724205000', N'130724000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2188', N'丰源店乡', N'130724206000', N'130724000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2189', N'西辛营乡', N'130724207000', N'130724000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2190', N'莲花滩乡', N'130724208000', N'130724000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2191', N'白土窑乡', N'130724209000', N'130724000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2192', N'南壕堑镇', N'130725100000', N'130725000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2193', N'大青沟镇', N'130725101000', N'130725000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2194', N'八道沟镇', N'130725102000', N'130725000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2195', N'红土梁镇', N'130725103000', N'130725000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2196', N'小蒜沟镇', N'130725104000', N'130725000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2197', N'三工地镇', N'130725105000', N'130725000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2198', N'满井镇', N'130725106000', N'130725000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2199', N'大营盘乡', N'130725200000', N'130725000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2200', N'大苏计乡', N'130725201000', N'130725000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2201', N'石井乡', N'130725202000', N'130725000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2202', N'七甲乡', N'130725205000', N'130725000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2203', N'套里庄乡', N'130725206000', N'130725000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2204', N'甲石河乡', N'130725207000', N'130725000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2205', N'下马圈乡', N'130725208000', N'130725000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2206', N'蔚州镇', N'130726100000', N'130726000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2207', N'代王城镇', N'130726101000', N'130726000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2208', N'西合营镇', N'130726102000', N'130726000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2209', N'吉家庄镇', N'130726103000', N'130726000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2210', N'白乐镇', N'130726104000', N'130726000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2211', N'暖泉镇', N'130726105000', N'130726000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2212', N'南留庄镇', N'130726106000', N'130726000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2213', N'北水泉镇', N'130726107000', N'130726000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2214', N'桃花镇', N'130726108000', N'130726000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2215', N'阳眷镇', N'130726109000', N'130726000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2216', N'宋家庄镇', N'130726110000', N'130726000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2217', N'下宫村乡', N'130726200000', N'130726000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2218', N'南杨庄乡', N'130726202000', N'130726000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2219', N'柏树乡', N'130726203000', N'130726000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2220', N'常宁乡', N'130726204000', N'130726000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2221', N'涌泉庄乡', N'130726205000', N'130726000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2222', N'杨庄窠乡', N'130726206000', N'130726000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2223', N'南岭庄乡', N'130726207000', N'130726000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2224', N'陈家洼乡', N'130726208000', N'130726000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2225', N'黄梅乡', N'130726209000', N'130726000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2226', N'白草村乡', N'130726210000', N'130726000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2227', N'草沟堡乡', N'130726211000', N'130726000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2228', N'西城镇', N'130727100000', N'130727000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2229', N'东城镇', N'130727101000', N'130727000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2230', N'化稍营镇', N'130727102000', N'130727000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2231', N'揣骨疃镇', N'130727103000', N'130727000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2232', N'东井集镇', N'130727104000', N'130727000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2233', N'要家庄乡', N'130727200000', N'130727000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2234', N'东坊城堡乡', N'130727201000', N'130727000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2235', N'井儿沟乡', N'130727202000', N'130727000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2236', N'三马坊乡', N'130727203000', N'130727000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2237', N'高墙乡', N'130727204000', N'130727000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2238', N'大田洼乡', N'130727205000', N'130727000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2239', N'辛堡乡', N'130727206000', N'130727000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2240', N'马圈堡乡', N'130727207000', N'130727000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2241', N'浮图讲乡', N'130727208000', N'130727000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2242', N'柴沟堡镇', N'130728100000', N'130728000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2243', N'左卫镇', N'130728101000', N'130728000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2244', N'头百户镇', N'130728102000', N'130728000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2245', N'怀安城镇', N'130728103000', N'130728000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2246', N'渡口堡乡', N'130728200000', N'130728000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2247', N'第六屯乡', N'130728201000', N'130728000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2248', N'西湾堡乡', N'130728202000', N'130728000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2249', N'西沙城乡', N'130728203000', N'130728000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2250', N'太平庄乡', N'130728204000', N'130728000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2251', N'王虎屯乡', N'130728205000', N'130728000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2252', N'第三堡乡', N'130728206000', N'130728000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2253', N'沙城镇', N'130730100000', N'130730000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2254', N'北辛堡镇', N'130730101000', N'130730000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2255', N'新保安镇', N'130730102000', N'130730000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2256', N'东花园镇', N'130730103000', N'130730000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2257', N'官厅镇', N'130730104000', N'130730000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2258', N'桑园镇', N'130730105000', N'130730000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2259', N'存瑞镇', N'130730106000', N'130730000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2260', N'土木镇', N'130730107000', N'130730000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2261', N'大黄庄镇', N'130730108000', N'130730000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2262', N'西八里镇', N'130730109000', N'130730000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2263', N'小南辛堡镇', N'130730110000', N'130730000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2264', N'狼山乡', N'130730200000', N'130730000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2265', N'鸡鸣驿乡', N'130730203000', N'130730000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2266', N'东八里乡', N'130730205000', N'130730000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2267', N'瑞云观乡', N'130730207000', N'130730000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2268', N'孙庄子乡', N'130730208000', N'130730000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2269', N'王家楼回族乡', N'130730210000', N'130730000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2270', N'涿鹿镇', N'130731100000', N'130731000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2271', N'张家堡镇', N'130731101000', N'130731000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2272', N'武家沟镇', N'130731102000', N'130731000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2273', N'五堡镇', N'130731103000', N'130731000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2274', N'保岱镇', N'130731104000', N'130731000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2275', N'矾山镇', N'130731105000', N'130731000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2276', N'大堡镇', N'130731106000', N'130731000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2277', N'河东镇', N'130731107000', N'130731000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2278', N'东小庄镇', N'130731108000', N'130731000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2279', N'辉耀镇', N'130731109000', N'130731000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2280', N'大河南镇', N'130731110000', N'130731000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2281', N'温泉屯镇', N'130731111000', N'130731000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2282', N'蟒石口镇', N'130731112000', N'130731000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2283', N'栾庄乡', N'130731201000', N'130731000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2284', N'黑山寺乡', N'130731204000', N'130731000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2285', N'卧佛寺乡', N'130731205000', N'130731000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2286', N'谢家堡乡', N'130731206000', N'130731000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2287', N'赤城镇', N'130732100000', N'130732000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2288', N'田家窑镇', N'130732101000', N'130732000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2289', N'龙关镇', N'130732102000', N'130732000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2290', N'雕鹗镇', N'130732103000', N'130732000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2291', N'独石口镇', N'130732104000', N'130732000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2292', N'白草镇', N'130732105000', N'130732000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2293', N'龙门所镇', N'130732106000', N'130732000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2294', N'后城镇', N'130732107000', N'130732000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2295', N'东卯镇', N'130732108000', N'130732000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2296', N'炮梁乡', N'130732200000', N'130732000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2297', N'大海陀乡', N'130732201000', N'130732000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2298', N'镇宁堡乡', N'130732202000', N'130732000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2299', N'马营乡', N'130732203000', N'130732000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2300', N'云州乡', N'130732204000', N'130732000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2301', N'三道川乡', N'130732205000', N'130732000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2302', N'东万口乡', N'130732206000', N'130732000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2303', N'茨营子乡', N'130732207000', N'130732000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2304', N'样田乡', N'130732208000', N'130732000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2305', N'南站街道办事处', N'130771001000', N'130771000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2306', N'马路东街道办事处', N'130771002000', N'130771000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2307', N'老鸦庄镇', N'130771100000', N'130771000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2308', N'沈家屯镇', N'130771101000', N'130771000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2309', N'姚家房镇', N'130771102000', N'130771000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2310', N'沙岭子镇', N'130771103000', N'130771000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2311', N'沙沟镇', N'130772105000', N'130772000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2312', N'宇宙营乡', N'130772215000', N'130772000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2313', N'察北管理区黄山管理处', N'130772401000', N'130772000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2314', N'察北管理区石门管理处', N'130772402000', N'130772000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2315', N'察北管理区乌兰管理处', N'130772403000', N'130772000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2316', N'察北管理区金沙管理处', N'130772404000', N'130772000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2317', N'察北管理区白塔管理处', N'130772405000', N'130772000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2318', N'榆树沟管理处', N'130773501000', N'130773000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2319', N'沙梁子管理处', N'130773502000', N'130773000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2320', N'小城子管理处', N'130773503000', N'130773000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2321', N'东大门管理处', N'130773504000', N'130773000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2322', N'西大街街道', N'130802001000', N'130802000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2323', N'头道牌楼街道', N'130802002000', N'130802000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2324', N'潘家沟街道', N'130802003000', N'130802000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2325', N'中华路街道', N'130802004000', N'130802000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2326', N'新华路街道', N'130802005000', N'130802000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2327', N'石洞子沟街道', N'130802006000', N'130802000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2328', N'桥东街道', N'130802007000', N'130802000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2329', N'水泉沟镇', N'130802100000', N'130802000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2330', N'狮子沟镇', N'130802101000', N'130802000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2331', N'牛圈子沟镇', N'130802102000', N'130802000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2332', N'大石庙镇', N'130802103000', N'130802000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2333', N'双峰寺镇', N'130802105000', N'130802000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2334', N'元宝山街道', N'130803001000', N'130803000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2335', N'钢城街道', N'130803002000', N'130803000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2336', N'秀水街道', N'130803003000', N'130803000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2337', N'双塔山镇', N'130803100000', N'130803000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2338', N'滦河镇', N'130803101000', N'130803000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2339', N'大庙镇', N'130803102000', N'130803000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2340', N'偏桥子镇', N'130803103000', N'130803000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2341', N'西地镇', N'130803104000', N'130803000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2342', N'陈栅子乡', N'130803200000', N'130803000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2343', N'鹰手营子矿区铁北路街道办事处', N'130804001000', N'130804000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2344', N'鹰手营子镇', N'130804100000', N'130804000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2345', N'北马圈子镇', N'130804101000', N'130804000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2346', N'寿王坟镇', N'130804102000', N'130804000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2347', N'汪家庄镇', N'130804103000', N'130804000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2348', N'下板城镇', N'130821100000', N'130821000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2349', N'甲山镇', N'130821102000', N'130821000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2350', N'六沟镇', N'130821103000', N'130821000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2351', N'三沟镇', N'130821104000', N'130821000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2352', N'头沟镇', N'130821105000', N'130821000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2353', N'高寺台镇', N'130821106000', N'130821000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2354', N'鞍匠镇', N'130821107000', N'130821000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2355', N'三家镇', N'130821108000', N'130821000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2356', N'磴上镇', N'130821109000', N'130821000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2357', N'上谷镇', N'130821110000', N'130821000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2358', N'新杖子镇', N'130821111000', N'130821000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2359', N'石灰窑镇', N'130821112000', N'130821000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2360', N'东小白旗乡', N'130821200000', N'130821000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2361', N'刘杖子乡', N'130821202000', N'130821000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2362', N'孟家院乡', N'130821204000', N'130821000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2363', N'大营子乡', N'130821205000', N'130821000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2364', N'八家乡', N'130821206000', N'130821000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2365', N'满杖子乡', N'130821208000', N'130821000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2366', N'五道河乡', N'130821210000', N'130821000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2367', N'岔沟乡', N'130821211000', N'130821000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2368', N'岗子满族乡', N'130821212000', N'130821000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2369', N'两家满族乡', N'130821214000', N'130821000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2370', N'仓子乡', N'130821216000', N'130821000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2371', N'兴隆镇', N'130822100000', N'130822000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2372', N'半壁山镇', N'130822101000', N'130822000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2373', N'挂兰峪镇', N'130822102000', N'130822000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2374', N'青松岭镇', N'130822103000', N'130822000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2375', N'六道河镇', N'130822104000', N'130822000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2376', N'平安堡镇', N'130822105000', N'130822000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2377', N'北营房镇', N'130822106000', N'130822000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2378', N'孤山子镇', N'130822107000', N'130822000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2379', N'蓝旗营镇', N'130822108000', N'130822000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2380', N'雾灵山镇', N'130822109000', N'130822000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2381', N'李家营镇', N'130822110000', N'130822000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2382', N'大杖子镇', N'130822111000', N'130822000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2383', N'三道河镇', N'130822112000', N'130822000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2384', N'蘑菇峪镇', N'130822113000', N'130822000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2385', N'大水泉镇', N'130822114000', N'130822000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2386', N'南天门满族乡', N'130822200000', N'130822000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2387', N'八卦岭满族乡', N'130822202000', N'130822000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2388', N'陡子峪乡', N'130822203000', N'130822000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2389', N'上石洞乡', N'130822204000', N'130822000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2390', N'安子岭乡', N'130822211000', N'130822000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2391', N'中兴路街道办事处', N'130824001000', N'130824000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2392', N'滦平镇', N'130824100000', N'130824000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2393', N'长山峪镇', N'130824101000', N'130824000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2394', N'红旗镇', N'130824102000', N'130824000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2395', N'金沟屯镇', N'130824103000', N'130824000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2396', N'虎什哈镇', N'130824104000', N'130824000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2397', N'巴克什营镇', N'130824105000', N'130824000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2398', N'张百湾镇', N'130824106000', N'130824000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2399', N'付营子镇', N'130824107000', N'130824000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2400', N'大屯镇', N'130824108000', N'130824000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2401', N'火斗山镇', N'130824109000', N'130824000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2402', N'平坊满族乡', N'130824200000', N'130824000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2403', N'安纯沟门满族乡', N'130824201000', N'130824000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2404', N'小营满族乡', N'130824205000', N'130824000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2405', N'西沟满族乡', N'130824206000', N'130824000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2406', N'邓厂满族乡', N'130824207000', N'130824000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2407', N'五道营子满族乡', N'130824208000', N'130824000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2408', N'马营子满族乡', N'130824209000', N'130824000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2409', N'付家店满族乡', N'130824210000', N'130824000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2410', N'两间房乡', N'130824212000', N'130824000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2411', N'涝洼乡', N'130824213000', N'130824000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2412', N'安州街道办事处', N'130825001000', N'130825000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2413', N'隆化镇', N'130825100000', N'130825000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2414', N'韩麻营镇', N'130825101000', N'130825000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2415', N'中关镇', N'130825102000', N'130825000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2416', N'七家镇', N'130825103000', N'130825000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2417', N'汤头沟镇', N'130825104000', N'130825000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2418', N'张三营镇', N'130825105000', N'130825000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2419', N'唐三营镇', N'130825106000', N'130825000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2420', N'蓝旗镇', N'130825107000', N'130825000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2421', N'步古沟镇', N'130825108000', N'130825000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2422', N'郭家屯镇', N'130825109000', N'130825000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2423', N'荒地乡', N'130825200000', N'130825000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2424', N'章吉营乡', N'130825201000', N'130825000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2425', N'茅荆坝乡', N'130825202000', N'130825000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2426', N'尹家营满族乡', N'130825203000', N'130825000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2427', N'庙子沟蒙古族满族乡', N'130825204000', N'130825000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2428', N'偏坡营满族乡', N'130825205000', N'130825000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2429', N'山湾乡', N'130825206000', N'130825000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2430', N'八达营蒙古族乡', N'130825207000', N'130825000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2431', N'太平庄满族乡', N'130825208000', N'130825000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2432', N'旧屯满族乡', N'130825209000', N'130825000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2433', N'西阿超满族蒙古族乡', N'130825210000', N'130825000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2434', N'白虎沟满族蒙古族乡', N'130825211000', N'130825000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2435', N'碱房乡', N'130825212000', N'130825000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2436', N'韩家店乡', N'130825213000', N'130825000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2437', N'湾沟门乡', N'130825214000', N'130825000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2438', N'大阁镇', N'130826100000', N'130826000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2439', N'大滩镇', N'130826101000', N'130826000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2440', N'鱼儿山镇', N'130826102000', N'130826000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2441', N'土城镇', N'130826103000', N'130826000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2442', N'黄旗镇', N'130826104000', N'130826000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2443', N'凤山镇', N'130826105000', N'130826000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2444', N'波罗诺镇', N'130826106000', N'130826000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2445', N'黑山咀镇', N'130826107000', N'130826000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2446', N'天桥镇', N'130826108000', N'130826000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2447', N'胡麻营镇', N'130826109000', N'130826000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2448', N'万胜永乡', N'130826200000', N'130826000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2449', N'四岔口乡', N'130826201000', N'130826000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2450', N'苏家店乡', N'130826202000', N'130826000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2451', N'外沟门乡', N'130826203000', N'130826000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2452', N'草原乡', N'130826204000', N'130826000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2453', N'窟窿山乡', N'130826205000', N'130826000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2454', N'小坝子乡', N'130826206000', N'130826000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2455', N'五道营乡', N'130826207000', N'130826000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2456', N'南关蒙古族乡', N'130826208000', N'130826000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2457', N'选将营乡', N'130826209000', N'130826000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2458', N'西官营乡', N'130826210000', N'130826000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2459', N'王营乡', N'130826211000', N'130826000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2460', N'北头营乡', N'130826212000', N'130826000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2461', N'石人沟乡', N'130826214000', N'130826000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2462', N'汤河乡', N'130826215000', N'130826000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2463', N'杨木栅子乡', N'130826216000', N'130826000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2464', N'宽城镇', N'130827100000', N'130827000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2465', N'龙须门镇', N'130827101000', N'130827000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2466', N'峪耳崖镇', N'130827102000', N'130827000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2467', N'板城镇', N'130827103000', N'130827000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2468', N'汤道河镇', N'130827104000', N'130827000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2469', N'饽罗台镇', N'130827105000', N'130827000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2470', N'碾子峪镇', N'130827106000', N'130827000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2471', N'亮甲台镇', N'130827107000', N'130827000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2472', N'化皮溜子镇', N'130827108000', N'130827000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2473', N'松岭镇', N'130827109000', N'130827000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2474', N'塌山乡', N'130827201000', N'130827000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2475', N'孟子岭乡', N'130827203000', N'130827000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2476', N'独石沟乡', N'130827204000', N'130827000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2477', N'铧尖乡', N'130827207000', N'130827000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2478', N'东黄花川乡', N'130827208000', N'130827000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2479', N'苇子沟乡', N'130827210000', N'130827000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2480', N'大字沟门乡', N'130827211000', N'130827000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2481', N'大石柱子乡', N'130827212000', N'130827000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2482', N'围场镇', N'130828100000', N'130828000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2483', N'四合永镇', N'130828101000', N'130828000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2484', N'克勒沟镇', N'130828102000', N'130828000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2485', N'棋盘山镇', N'130828103000', N'130828000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2486', N'半截塔镇', N'130828104000', N'130828000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2487', N'朝阳地镇', N'130828105000', N'130828000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2488', N'朝阳湾镇', N'130828106000', N'130828000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2489', N'腰站镇', N'130828107000', N'130828000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2490', N'龙头山镇', N'130828108000', N'130828000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2491', N'新拨镇', N'130828109000', N'130828000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2492', N'御道口镇', N'130828110000', N'130828000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2493', N'城子镇', N'130828111000', N'130828000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2494', N'道坝子乡', N'130828200000', N'130828000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2495', N'黄土坎乡', N'130828203000', N'130828000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2496', N'四道沟乡', N'130828204000', N'130828000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2497', N'兰旗卡伦乡', N'130828205000', N'130828000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2498', N'银窝沟乡', N'130828206000', N'130828000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2499', N'新地乡', N'130828207000', N'130828000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2500', N'广发永乡', N'130828208000', N'130828000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2501', N'育太和乡', N'130828209000', N'130828000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2502', N'郭家湾乡', N'130828210000', N'130828000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2503', N'杨家湾乡', N'130828211000', N'130828000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2504', N'大唤起乡', N'130828212000', N'130828000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2505', N'哈里哈乡', N'130828213000', N'130828000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2506', N'张家湾乡', N'130828215000', N'130828000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2507', N'宝元栈乡', N'130828216000', N'130828000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2508', N'山湾子乡', N'130828217000', N'130828000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2509', N'三义永乡', N'130828218000', N'130828000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2510', N'姜家店乡', N'130828219000', N'130828000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2511', N'下伙房乡', N'130828220000', N'130828000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2512', N'燕格柏乡', N'130828221000', N'130828000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2513', N'牌楼乡', N'130828222000', N'130828000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2514', N'老窝铺乡', N'130828224000', N'130828000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2515', N'石桌子乡', N'130828226000', N'130828000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2516', N'大头山乡', N'130828227000', N'130828000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2517', N'南山嘴乡', N'130828228000', N'130828000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2518', N'西龙头乡', N'130828229000', N'130828000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2519', N'塞罕坝机械林场', N'130828450000', N'130828000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2520', N'国营御道口牧场', N'130828500000', N'130828000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2521', N'冯营子镇', N'130871104000', N'130871000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2522', N'上板城镇', N'130871106000', N'130871000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2523', N'平泉镇', N'130881100000', N'130881000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2524', N'黄土梁子镇', N'130881101000', N'130881000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2525', N'榆树林子镇', N'130881102000', N'130881000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2526', N'杨树岭镇', N'130881103000', N'130881000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2527', N'七沟镇', N'130881104000', N'130881000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2528', N'小寺沟镇', N'130881105000', N'130881000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2529', N'党坝镇', N'130881106000', N'130881000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2530', N'卧龙镇', N'130881107000', N'130881000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2531', N'南五十家子镇', N'130881108000', N'130881000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2532', N'北五十家子镇', N'130881109000', N'130881000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2533', N'桲椤树镇', N'130881110000', N'130881000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2534', N'柳溪镇', N'130881111000', N'130881000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2535', N'平北镇', N'130881112000', N'130881000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2536', N'青河镇', N'130881113000', N'130881000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2537', N'台头山镇', N'130881114000', N'130881000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2538', N'王土房乡', N'130881200000', N'130881000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2539', N'七家岱满族乡', N'130881203000', N'130881000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2540', N'茅兰沟满族蒙古族乡', N'130881206000', N'130881000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2541', N'道虎沟乡', N'130881210000', N'130881000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2542', N'建设北街街道办事处', N'130902001000', N'130902000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2543', N'车站街道办事处', N'130902002000', N'130902000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2544', N'南大街街道办事处', N'130902003000', N'130902000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2545', N'东环街道办事处', N'130902004000', N'130902000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2546', N'道东街道办事处', N'130902005000', N'130902000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2547', N'小赵庄乡', N'130902200000', N'130902000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2548', N'水月寺街道办事处', N'130903001000', N'130903000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2549', N'南环中路街道办事处', N'130903002000', N'130903000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2550', N'南湖街道办事处', N'130903003000', N'130903000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2551', N'市场街道办事处', N'130903004000', N'130903000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2552', N'西环中街街道办事处', N'130903005000', N'130903000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2553', N'公园街道办事处', N'130903006000', N'130903000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2554', N'小王庄镇', N'130903100000', N'130903000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2555', N'南陈屯乡', N'130903200000', N'130903000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2556', N'旧州镇', N'130921100000', N'130921000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2557', N'兴济镇', N'130921101000', N'130921000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2558', N'杜生镇', N'130921102000', N'130921000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2559', N'崔尔庄镇', N'130921103000', N'130921000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2560', N'薛官屯乡', N'130921200000', N'130921000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2561', N'捷地回族乡', N'130921201000', N'130921000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2562', N'张官屯乡', N'130921202000', N'130921000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2563', N'李天木回族乡', N'130921203000', N'130921000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2564', N'风化店乡', N'130921204000', N'130921000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2565', N'姚官屯乡', N'130921205000', N'130921000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2566', N'杜林回族乡', N'130921206000', N'130921000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2567', N'汪家铺乡', N'130921207000', N'130921000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2568', N'刘家庙乡', N'130921208000', N'130921000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2569', N'仵龙堂乡', N'130921209000', N'130921000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2570', N'大官厅乡', N'130921210000', N'130921000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2571', N'高川乡', N'130921211000', N'130921000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2572', N'黄递铺乡', N'130921212000', N'130921000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2573', N'大褚村回族乡', N'130921213000', N'130921000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2574', N'纸房头乡', N'130921214000', N'130921000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2575', N'清州镇', N'130922100000', N'130922000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2576', N'金牛镇', N'130922101000', N'130922000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2577', N'新兴镇', N'130922102000', N'130922000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2578', N'流河镇', N'130922103000', N'130922000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2579', N'木门店镇', N'130922104000', N'130922000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2580', N'马厂镇', N'130922105000', N'130922000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2581', N'盘古镇', N'130922106000', N'130922000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2582', N'上伍乡', N'130922200000', N'130922000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2583', N'曹寺乡', N'130922201000', N'130922000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2584', N'陈嘴乡', N'130922203000', N'130922000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2585', N'青县农场', N'130922400000', N'130922000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2586', N'东光镇', N'130923100000', N'130923000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2587', N'连镇镇', N'130923101000', N'130923000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2588', N'找王镇', N'130923102000', N'130923000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2589', N'秦村镇', N'130923103000', N'130923000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2590', N'灯明寺镇', N'130923104000', N'130923000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2591', N'南霞口镇', N'130923105000', N'130923000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2592', N'大单镇', N'130923106000', N'130923000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2593', N'龙王李镇', N'130923107000', N'130923000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2594', N'于桥乡', N'130923201000', N'130923000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2595', N'苏基镇', N'130924100000', N'130924000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2596', N'辛集镇', N'130924101000', N'130924000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2597', N'高湾镇', N'130924102000', N'130924000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2598', N'赵毛陶乡', N'130924200000', N'130924000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2599', N'香坊乡', N'130924201000', N'130924000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2600', N'小山乡', N'130924202000', N'130924000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2601', N'张会亭乡', N'130924203000', N'130924000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2602', N'海兴县农场', N'130924400000', N'130924000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2603', N'青先农场', N'130924401000', N'130924000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2604', N'青锋农场', N'130924402000', N'130924000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2605', N'盐山镇', N'130925100000', N'130925000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2606', N'望树镇', N'130925101000', N'130925000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2607', N'庆云镇', N'130925102000', N'130925000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2608', N'韩集镇', N'130925103000', N'130925000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2609', N'千童镇', N'130925104000', N'130925000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2610', N'圣佛镇', N'130925105000', N'130925000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2611', N'边务乡', N'130925200000', N'130925000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2612', N'小营乡', N'130925201000', N'130925000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2613', N'杨集乡', N'130925202000', N'130925000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2614', N'孟店乡', N'130925203000', N'130925000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2615', N'常庄乡', N'130925204000', N'130925000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2616', N'小庄乡', N'130925205000', N'130925000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2617', N'肃宁镇', N'130926100000', N'130926000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2618', N'梁家村镇', N'130926101000', N'130926000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2619', N'窝北镇', N'130926102000', N'130926000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2620', N'尚村镇', N'130926103000', N'130926000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2621', N'万里镇', N'130926104000', N'130926000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2622', N'师素镇', N'130926105000', N'130926000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2623', N'河北留善寺乡', N'130926203000', N'130926000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2624', N'付家佐乡', N'130926204000', N'130926000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2625', N'邵庄乡', N'130926205000', N'130926000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2626', N'南皮镇', N'130927100000', N'130927000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2627', N'冯家口镇', N'130927101000', N'130927000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2628', N'寨子镇', N'130927102000', N'130927000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2629', N'鲍官屯镇', N'130927103000', N'130927000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2630', N'王寺镇', N'130927104000', N'130927000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2631', N'乌马营镇', N'130927105000', N'130927000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2632', N'大浪淀乡', N'130927200000', N'130927000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2633', N'刘八里乡', N'130927201000', N'130927000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2634', N'潞灌乡', N'130927202000', N'130927000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2635', N'桑园镇', N'130928100000', N'130928000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2636', N'铁城镇', N'130928101000', N'130928000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2637', N'于集镇', N'130928102000', N'130928000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2638', N'梁集镇', N'130928103000', N'130928000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2639', N'安陵镇', N'130928104000', N'130928000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2640', N'曹家洼乡', N'130928200000', N'130928000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2641', N'宋门乡', N'130928201000', N'130928000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2642', N'杨家寺乡', N'130928202000', N'130928000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2643', N'沟店铺乡', N'130928203000', N'130928000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2644', N'何庄乡', N'130928204000', N'130928000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2645', N'吴桥经济技术开发区', N'130928400000', N'130928000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2646', N'乐寿镇', N'130929100000', N'130929000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2647', N'淮镇镇', N'130929101000', N'130929000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2648', N'郭庄镇', N'130929102000', N'130929000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2649', N'河城街镇', N'130929103000', N'130929000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2650', N'韩村镇', N'130929104000', N'130929000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2651', N'陌南镇', N'130929105000', N'130929000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2652', N'陈庄镇', N'130929106000', N'130929000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2653', N'徐留高乡', N'130929205000', N'130929000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2654', N'商林乡', N'130929206000', N'130929000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2655', N'段村乡', N'130929207000', N'130929000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2656', N'张村乡', N'130929209000', N'130929000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2657', N'临河乡', N'130929210000', N'130929000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2658', N'小平王乡', N'130929211000', N'130929000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2659', N'十五级乡', N'130929212000', N'130929000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2660', N'垒头乡', N'130929213000', N'130929000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2661', N'南河头乡', N'130929214000', N'130929000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2662', N'西城乡', N'130929215000', N'130929000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2663', N'本斋回族乡', N'130929216000', N'130929000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2664', N'农场', N'130929400000', N'130929000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2665', N'献县经济开发区', N'130929401000', N'130929000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2666', N'孟村镇', N'130930100000', N'130930000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2667', N'新县镇', N'130930101000', N'130930000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2668', N'辛店镇', N'130930102000', N'130930000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2669', N'高寨镇', N'130930103000', N'130930000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2670', N'宋庄子乡', N'130930200000', N'130930000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2671', N'牛进庄乡', N'130930201000', N'130930000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2672', N'开发区乡', N'130971400000', N'130971000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2673', N'高新乡', N'130972400000', N'130972000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2674', N'新村回族乡', N'130973206000', N'130973000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2675', N'南大港管理区', N'130973400000', N'130973000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2676', N'国营中捷农场', N'130973401000', N'130973000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2677', N'港城街道办事处', N'130973402000', N'130973000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2678', N'临港化工园区', N'130973403000', N'130973000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2679', N'解放街道办事处', N'130981001000', N'130981000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2680', N'河东街道办事处', N'130981002000', N'130981000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2681', N'古楼街道办事处', N'130981003000', N'130981000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2682', N'泊镇', N'130981100000', N'130981000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2683', N'交河镇', N'130981101000', N'130981000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2684', N'齐桥镇', N'130981102000', N'130981000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2685', N'寺门村镇', N'130981103000', N'130981000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2686', N'郝村镇', N'130981104000', N'130981000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2687', N'富镇镇', N'130981105000', N'130981000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2688', N'文庙镇', N'130981106000', N'130981000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2689', N'洼里王镇', N'130981107000', N'130981000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2690', N'王武庄乡', N'130981201000', N'130981000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2691', N'营子乡', N'130981202000', N'130981000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2692', N'四营乡', N'130981203000', N'130981000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2693', N'西辛店乡', N'130981204000', N'130981000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2694', N'泊头市工业区管委会', N'130981400000', N'130981000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2695', N'新华路街道', N'130982001000', N'130982000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2696', N'西环路街道', N'130982002000', N'130982000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2697', N'永丰路街道', N'130982003000', N'130982000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2698', N'中华路办事处', N'130982004000', N'130982000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2699', N'渤海路街道', N'130982005000', N'130982000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2700', N'油建路街道', N'130982006000', N'130982000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2701', N'会战道街道', N'130982007000', N'130982000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2702', N'出岸镇', N'130982100000', N'130982000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2703', N'石门桥镇', N'130982101000', N'130982000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2704', N'吕公堡镇', N'130982102000', N'130982000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2705', N'长丰镇', N'130982103000', N'130982000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2706', N'梁召镇', N'130982106000', N'130982000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2707', N'辛中驿镇', N'130982107000', N'130982000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2708', N'麻家坞镇', N'130982108000', N'130982000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2709', N'议论堡乡', N'130982203000', N'130982000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2710', N'青塔乡', N'130982204000', N'130982000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2711', N'北辛庄乡', N'130982205000', N'130982000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2712', N'北汉乡', N'130982207000', N'130982000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2713', N'于村乡', N'130982208000', N'130982000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2714', N'华北石油管理局', N'130982400000', N'130982000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2715', N'开发区管理委员会', N'130982500000', N'130982000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2716', N'河北任丘雁翎工业园区', N'130982501000', N'130982000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2717', N'骅东街道', N'130983001000', N'130983000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2718', N'骅中街道', N'130983002000', N'130983000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2719', N'骅西街道', N'130983003000', N'130983000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2720', N'黄骅镇', N'130983100000', N'130983000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2721', N'南排河镇', N'130983101000', N'130983000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2722', N'吕桥镇', N'130983102000', N'130983000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2723', N'旧城镇', N'130983103000', N'130983000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2724', N'羊二庄回族乡', N'130983200000', N'130983000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2725', N'常郭乡', N'130983202000', N'130983000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2726', N'滕庄子乡', N'130983203000', N'130983000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2727', N'官庄乡', N'130983204000', N'130983000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2728', N'齐家务乡', N'130983205000', N'130983000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2729', N'羊三木回族乡', N'130983207000', N'130983000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2730', N'瀛州路街道办事处', N'130984001000', N'130984000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2731', N'城垣西路街道办事处', N'130984002000', N'130984000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2732', N'米各庄镇', N'130984101000', N'130984000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2733', N'景和镇', N'130984102000', N'130984000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2734', N'卧佛堂镇', N'130984103000', N'130984000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2735', N'束城镇', N'130984104000', N'130984000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2736', N'留古寺镇', N'130984105000', N'130984000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2737', N'沙河桥镇', N'130984106000', N'130984000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2738', N'诗经村镇', N'130984107000', N'130984000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2739', N'故仙乡', N'130984200000', N'130984000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2740', N'黎民居乡', N'130984201000', N'130984000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2741', N'兴村乡', N'130984202000', N'130984000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2742', N'沙洼乡', N'130984203000', N'130984000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2743', N'西九吉乡', N'130984204000', N'130984000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2744', N'北石槽乡', N'130984205000', N'130984000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2745', N'时村乡', N'130984209000', N'130984000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2746', N'行别营乡', N'130984210000', N'130984000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2747', N'尊祖庄乡', N'130984211000', N'130984000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2748', N'龙华店乡', N'130984212000', N'130984000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2749', N'果子洼回族乡', N'130984213000', N'130984000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2750', N'河间经济开发区管理委员会', N'130984401000', N'130984000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2751', N'河北河间瀛州经济开发区管理委员会', N'130984402000', N'130984000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2752', N'银河南路街道', N'131002001000', N'131002000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2753', N'光明西道街道', N'131002002000', N'131002000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2754', N'永华道街道办事处', N'131002003000', N'131002000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2755', N'落垡镇', N'131002100000', N'131002000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2756', N'码头镇', N'131002101000', N'131002000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2757', N'葛渔城镇', N'131002102000', N'131002000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2758', N'东沽港镇', N'131002103000', N'131002000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2759', N'调河头镇', N'131002104000', N'131002000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2760', N'杨税务乡', N'131002200000', N'131002000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2761', N'仇庄乡', N'131002201000', N'131002000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2762', N'北史家务乡', N'131002203000', N'131002000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2763', N'廊坊龙河高新技术产业开发区', N'131002400000', N'131002000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2764', N'河北廊坊高新技术产业开发区', N'131002401000', N'131002000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2765', N'河北廊坊龙港经济开发区', N'131002402000', N'131002000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2766', N'河北安次经济开发区', N'131002403000', N'131002000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2767', N'银河北路街道', N'131003001000', N'131003000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2768', N'爱民东道街道', N'131003002000', N'131003000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2769', N'解放道街道', N'131003003000', N'131003000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2770', N'新开路街道', N'131003004000', N'131003000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2771', N'新源道街道', N'131003005000', N'131003000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2772', N'南尖塔镇', N'131003100000', N'131003000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2773', N'万庄镇', N'131003101000', N'131003000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2774', N'九州镇', N'131003102000', N'131003000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2775', N'北旺乡', N'131003200000', N'131003000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2776', N'新世纪步行街管理委员会', N'131003500000', N'131003000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2777', N'固安镇', N'131022100000', N'131022000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2778', N'宫村镇', N'131022101000', N'131022000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2779', N'柳泉镇', N'131022102000', N'131022000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2780', N'牛驼镇', N'131022103000', N'131022000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2781', N'马庄镇', N'131022104000', N'131022000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2782', N'东湾乡', N'131022200000', N'131022000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2783', N'彭村乡', N'131022201000', N'131022000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2784', N'渠沟乡', N'131022202000', N'131022000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2785', N'礼让店乡', N'131022203000', N'131022000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2786', N'固安温泉休闲商务产业园区', N'131022400000', N'131022000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2787', N'城区街道办事处', N'131023001000', N'131023000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2788', N'永清镇', N'131023100000', N'131023000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2789', N'韩村镇', N'131023101000', N'131023000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2790', N'后奕镇', N'131023102000', N'131023000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2791', N'别古庄镇', N'131023103000', N'131023000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2792', N'里澜城镇', N'131023104000', N'131023000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2793', N'管家务回族乡', N'131023200000', N'131023000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2794', N'曹家务乡', N'131023201000', N'131023000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2795', N'龙虎庄乡', N'131023202000', N'131023000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2796', N'刘街乡', N'131023203000', N'131023000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2797', N'三圣口乡', N'131023204000', N'131023000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2798', N'河北永清经济开发区', N'131023400000', N'131023000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2799', N'北京亦庄永清高新技术产业开发区区', N'131023401000', N'131023000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2800', N'淑阳镇', N'131024100000', N'131024000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2801', N'蒋辛屯镇', N'131024101000', N'131024000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2802', N'渠口镇', N'131024102000', N'131024000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2803', N'安头屯镇', N'131024103000', N'131024000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2804', N'安平镇', N'131024104000', N'131024000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2805', N'刘宋镇', N'131024105000', N'131024000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2806', N'五百户镇', N'131024106000', N'131024000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2807', N'钱旺镇', N'131024107000', N'131024000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2808', N'钳屯镇', N'131024108000', N'131024000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2809', N'香河开发区', N'131024500000', N'131024000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2810', N'香河新兴产业示范区', N'131024501000', N'131024000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2811', N'平舒镇', N'131025100000', N'131025000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2812', N'旺村镇', N'131025101000', N'131025000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2813', N'大尚屯镇', N'131025102000', N'131025000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2814', N'南赵扶镇', N'131025103000', N'131025000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2815', N'留各庄镇', N'131025104000', N'131025000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2816', N'权村镇', N'131025105000', N'131025000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2817', N'里坦镇', N'131025106000', N'131025000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2818', N'广安镇', N'131025107000', N'131025000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2819', N'北魏乡', N'131025200000', N'131025000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2820', N'臧屯乡', N'131025202000', N'131025000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2821', N'河北大城经济开发区', N'131025400000', N'131025000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2822', N'文安镇', N'131026100000', N'131026000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2823', N'新镇镇', N'131026101000', N'131026000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2824', N'苏桥镇', N'131026102000', N'131026000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2825', N'大柳河镇', N'131026103000', N'131026000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2826', N'左各庄镇', N'131026104000', N'131026000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2827', N'滩里镇', N'131026105000', N'131026000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2828', N'史各庄镇', N'131026106000', N'131026000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2829', N'赵各庄镇', N'131026107000', N'131026000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2830', N'兴隆宫镇', N'131026108000', N'131026000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2831', N'大留镇镇', N'131026109000', N'131026000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2832', N'孙氏镇', N'131026110000', N'131026000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2833', N'德归镇', N'131026111000', N'131026000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2834', N'大围河回族满族乡', N'131026200000', N'131026000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2835', N'北辰街道办事处', N'131028001000', N'131028000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2836', N'大厂镇', N'131028100000', N'131028000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2837', N'夏垫镇', N'131028101000', N'131028000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2838', N'祁各庄镇', N'131028102000', N'131028000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2839', N'邵府镇', N'131028103000', N'131028000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2840', N'陈府镇', N'131028104000', N'131028000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2841', N'河北大厂高新技术产业开发区', N'131028400000', N'131028000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2842', N'耀华道街道办事处', N'131071450000', N'131071000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2843', N'云鹏道街道办事处', N'131071451000', N'131071000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2844', N'裕华街道办事处', N'131081001000', N'131081000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2845', N'霸州镇', N'131081100000', N'131081000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2846', N'南孟镇', N'131081101000', N'131081000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2847', N'信安镇', N'131081102000', N'131081000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2848', N'堂二里镇', N'131081103000', N'131081000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2849', N'煎茶铺镇', N'131081104000', N'131081000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2850', N'胜芳镇', N'131081105000', N'131081000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2851', N'杨芬港镇', N'131081106000', N'131081000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2852', N'岔河集乡', N'131081200000', N'131081000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2853', N'康仙庄乡', N'131081201000', N'131081000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2854', N'东杨庄乡', N'131081202000', N'131081000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2855', N'王庄子乡', N'131081203000', N'131081000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2856', N'东段乡', N'131081204000', N'131081000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2857', N'鼎盛东大街街道办事处', N'131082001000', N'131082000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2858', N'泃阳西大街街道办事处', N'131082002000', N'131082000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2859', N'泃阳镇', N'131082100000', N'131082000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2860', N'李旗庄镇', N'131082101000', N'131082000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2861', N'杨庄镇', N'131082102000', N'131082000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2862', N'皇庄镇', N'131082103000', N'131082000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2863', N'新集镇', N'131082104000', N'131082000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2864', N'段甲岭镇', N'131082105000', N'131082000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2865', N'黄土庄镇', N'131082106000', N'131082000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2866', N'高楼镇', N'131082107000', N'131082000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2867', N'齐心庄镇', N'131082108000', N'131082000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2868', N'燕郊镇', N'131082109000', N'131082000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2869', N'燕郊经济技术开发区', N'131082450000', N'131082000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2870', N'三河市农业高新技术园区', N'131082451000', N'131082000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2871', N'河西街道办事处', N'131102001000', N'131102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2872', N'河东街道办事处', N'131102002000', N'131102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2873', N'路北街道办事处', N'131102003000', N'131102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2874', N'中华街道办事处', N'131102004000', N'131102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2875', N'郑家河沿镇', N'131102100000', N'131102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2876', N'赵家圈镇', N'131102101000', N'131102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2877', N'邓庄镇', N'131102102000', N'131102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2878', N'何家庄乡', N'131102200000', N'131102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2879', N'冀州镇', N'131103100000', N'131103000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2880', N'官道李镇', N'131103102000', N'131103000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2881', N'南午村镇', N'131103103000', N'131103000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2882', N'周村镇', N'131103104000', N'131103000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2883', N'码头李镇', N'131103105000', N'131103000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2884', N'西王镇', N'131103106000', N'131103000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2885', N'门家庄乡', N'131103200000', N'131103000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2886', N'徐家庄乡', N'131103201000', N'131103000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2887', N'北漳淮乡', N'131103202000', N'131103000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2888', N'小寨乡', N'131103203000', N'131103000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2889', N'枣强镇', N'131121100000', N'131121000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2890', N'恩察镇', N'131121101000', N'131121000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2891', N'大营镇', N'131121102000', N'131121000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2892', N'嘉会镇', N'131121103000', N'131121000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2893', N'马屯镇', N'131121104000', N'131121000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2894', N'肖张镇', N'131121105000', N'131121000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2895', N'张秀屯镇', N'131121106000', N'131121000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2896', N'新屯镇', N'131121107000', N'131121000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2897', N'唐林镇', N'131121108000', N'131121000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2898', N'王均乡', N'131121202000', N'131121000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2899', N'王常乡', N'131121204000', N'131121000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2900', N'武邑镇', N'131122100000', N'131122000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2901', N'清凉店镇', N'131122101000', N'131122000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2902', N'审坡镇', N'131122102000', N'131122000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2903', N'赵桥镇', N'131122103000', N'131122000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2904', N'韩庄镇', N'131122104000', N'131122000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2905', N'肖桥头镇', N'131122105000', N'131122000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2906', N'龙店镇', N'131122106000', N'131122000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2907', N'圈头乡', N'131122201000', N'131122000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2908', N'大紫塔乡', N'131122203000', N'131122000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2909', N'武强镇', N'131123100000', N'131123000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2910', N'街关镇', N'131123101000', N'131123000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2911', N'周窝镇', N'131123102000', N'131123000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2912', N'东孙庄镇', N'131123103000', N'131123000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2913', N'豆村乡', N'131123200000', N'131123000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2914', N'北代乡', N'131123201000', N'131123000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2915', N'饶阳镇', N'131124100000', N'131124000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2916', N'大尹村镇', N'131124101000', N'131124000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2917', N'五公镇', N'131124102000', N'131124000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2918', N'大官亭镇', N'131124103000', N'131124000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2919', N'王同岳镇', N'131124104000', N'131124000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2920', N'留楚乡', N'131124202000', N'131124000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2921', N'东里满乡', N'131124203000', N'131124000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2922', N'安平镇', N'131125100000', N'131125000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2923', N'马店镇', N'131125101000', N'131125000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2924', N'南王庄镇', N'131125102000', N'131125000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2925', N'大子文镇', N'131125103000', N'131125000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2926', N'东黄城镇', N'131125104000', N'131125000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2927', N'大何庄乡', N'131125200000', N'131125000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2928', N'程油子乡', N'131125201000', N'131125000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2929', N'西两洼乡', N'131125202000', N'131125000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2930', N'河北丝网工业园区', N'131125400000', N'131125000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2931', N'郑口镇', N'131126100000', N'131126000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2932', N'夏庄镇', N'131126101000', N'131126000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2933', N'青罕镇', N'131126102000', N'131126000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2934', N'故城镇', N'131126103000', N'131126000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2935', N'武官寨镇', N'131126104000', N'131126000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2936', N'饶阳店镇', N'131126105000', N'131126000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2937', N'军屯镇', N'131126106000', N'131126000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2938', N'建国镇', N'131126107000', N'131126000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2939', N'西半屯镇', N'131126108000', N'131126000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2940', N'房庄镇', N'131126109000', N'131126000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2941', N'三朗镇', N'131126110000', N'131126000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2942', N'辛庄乡', N'131126200000', N'131126000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2943', N'里老乡', N'131126201000', N'131126000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2944', N'景州镇', N'131127100000', N'131127000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2945', N'龙华镇', N'131127101000', N'131127000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2946', N'广川镇', N'131127102000', N'131127000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2947', N'王瞳镇', N'131127103000', N'131127000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2948', N'洚河流镇', N'131127104000', N'131127000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2949', N'安陵镇', N'131127105000', N'131127000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2950', N'杜桥镇', N'131127106000', N'131127000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2951', N'王谦寺镇', N'131127107000', N'131127000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2952', N'北留智镇', N'131127108000', N'131127000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2953', N'留智庙镇', N'131127109000', N'131127000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2954', N'梁集镇', N'131127110000', N'131127000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2955', N'刘集乡', N'131127200000', N'131127000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2956', N'连镇乡', N'131127201000', N'131127000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2957', N'温城乡', N'131127203000', N'131127000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2958', N'后留名府乡', N'131127204000', N'131127000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2959', N'青兰乡', N'131127205000', N'131127000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2960', N'河北景县高新技术产业开发区', N'131127400000', N'131127000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2961', N'阜城镇', N'131128100000', N'131128000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2962', N'古城镇', N'131128101000', N'131128000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2963', N'码头镇', N'131128102000', N'131128000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2964', N'霞口镇', N'131128103000', N'131128000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2965', N'崔家庙镇', N'131128104000', N'131128000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2966', N'漫河镇', N'131128105000', N'131128000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2967', N'建桥乡', N'131128201000', N'131128000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2968', N'蒋坊乡', N'131128202000', N'131128000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2969', N'大白乡', N'131128203000', N'131128000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2970', N'王集乡', N'131128204000', N'131128000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2971', N'大麻森乡', N'131171201000', N'131171000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2972', N'衡水高新技术产业开发区', N'131171400000', N'131171000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2973', N'新型功能材料产业园', N'131171401000', N'131171000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2974', N'苏正办事处', N'131171402000', N'131171000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2975', N'魏家屯镇', N'131172101000', N'131172000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2976', N'彭杜村乡', N'131172203000', N'131172000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2977', N'滨湖新区教育园区', N'131172401000', N'131172000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2978', N'唐奉镇', N'131182100000', N'131182000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2979', N'深州镇', N'131182101000', N'131182000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2980', N'辰时镇', N'131182102000', N'131182000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2981', N'榆科镇', N'131182103000', N'131182000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2982', N'魏家桥镇', N'131182104000', N'131182000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2983', N'大堤镇', N'131182105000', N'131182000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2984', N'前磨头镇', N'131182106000', N'131182000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2985', N'王家井镇', N'131182107000', N'131182000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2986', N'护驾迟镇', N'131182108000', N'131182000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2987', N'大屯镇', N'131182109000', N'131182000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2988', N'高古庄镇', N'131182110000', N'131182000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2989', N'兵曹乡', N'131182200000', N'131182000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2990', N'穆村乡', N'131182201000', N'131182000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2991', N'东安庄乡', N'131182202000', N'131182000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2992', N'北溪村乡', N'131182203000', N'131182000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2993', N'大冯营乡', N'131182204000', N'131182000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2994', N'乔屯乡', N'131182206000', N'131182000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2995', N'河北省深州监狱', N'131182400000', N'131182000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2996', N'深州市城市新区管理委员会', N'131182401000', N'131182000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2997', N'经济开发区', N'131182403000', N'131182000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2998', N'坞城街道办事处', N'140105001000', N'140105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'2999', N'营盘街道办事处', N'140105002000', N'140105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3000', N'北营街道办事处', N'140105003000', N'140105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3001', N'平阳路街道办事处', N'140105004000', N'140105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3002', N'黄陵街道办事处', N'140105005000', N'140105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3003', N'小店街道办事处', N'140105006000', N'140105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3004', N'龙城街道办事处', N'140105007000', N'140105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3005', N'北格镇', N'140105100000', N'140105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3006', N'西温庄乡', N'140105200000', N'140105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3007', N'刘家堡乡', N'140105201000', N'140105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3008', N'柳巷街道办事处', N'140106001000', N'140106000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3009', N'文庙街道办事处', N'140106002000', N'140106000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3010', N'庙前街道办事处', N'140106003000', N'140106000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3011', N'迎泽街道办事处', N'140106004000', N'140106000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3012', N'桥东街道办事处', N'140106005000', N'140106000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3013', N'老军营街道办事处', N'140106006000', N'140106000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3014', N'郝庄镇', N'140106100000', N'140106000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3015', N'巨轮街道办事处', N'140107001000', N'140107000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3016', N'三桥街道办事处', N'140107002000', N'140107000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3017', N'鼓楼街道办事处', N'140107003000', N'140107000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3018', N'杏花岭街道办事处', N'140107004000', N'140107000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3019', N'坝陵桥街道办事处', N'140107005000', N'140107000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3020', N'大东关街道办事处', N'140107006000', N'140107000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3021', N'职工新街街道办事处', N'140107007000', N'140107000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3022', N'敦化坊街道办事处', N'140107008000', N'140107000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3023', N'涧河街道办事处', N'140107009000', N'140107000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3024', N'杨家峪街道办事处', N'140107010000', N'140107000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3025', N'中涧河乡', N'140107200000', N'140107000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3026', N'小返乡', N'140107201000', N'140107000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3027', N'尖草坪街道办事处', N'140108001000', N'140108000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3028', N'光社街道办事处', N'140108002000', N'140108000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3029', N'上兰街道办事处', N'140108003000', N'140108000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3030', N'南寨街道办事处', N'140108004000', N'140108000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3031', N'迎新街道办事处', N'140108005000', N'140108000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3032', N'古城街道办事处', N'140108006000', N'140108000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3033', N'汇丰街道办事处', N'140108007000', N'140108000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3034', N'柴村街道办事处', N'140108008000', N'140108000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3035', N'新城街道办事处', N'140108009000', N'140108000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3036', N'向阳镇', N'140108100000', N'140108000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3037', N'阳曲镇', N'140108101000', N'140108000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3038', N'马头水乡', N'140108200000', N'140108000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3039', N'柏板乡', N'140108201000', N'140108000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3040', N'西焉乡', N'140108202000', N'140108000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3041', N'千峰街道办事处', N'140109001000', N'140109000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3042', N'下元街道办事处', N'140109002000', N'140109000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3043', N'和平街道办事处', N'140109003000', N'140109000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3044', N'兴华街道办事处', N'140109004000', N'140109000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3045', N'万柏林街道办事处', N'140109005000', N'140109000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3046', N'杜儿坪街道办事处', N'140109006000', N'140109000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3047', N'白家庄街道办事处', N'140109007000', N'140109000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3048', N'南寒街道办事处', N'140109008000', N'140109000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3049', N'东社街道办事处', N'140109009000', N'140109000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3050', N'化客头街道办事处', N'140109010000', N'140109000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3051', N'小井峪街道办事处', N'140109011000', N'140109000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3052', N'西铭街道办事处', N'140109012000', N'140109000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3053', N'长风西街街道办事处', N'140109013000', N'140109000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3054', N'神堂沟街道办事处', N'140109014000', N'140109000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3055', N'王封乡', N'140109200000', N'140109000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3056', N'义井街道办事处', N'140110001000', N'140110000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3057', N'罗城街道办事处', N'140110002000', N'140110000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3058', N'晋源街道办事处', N'140110003000', N'140110000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3059', N'金胜镇', N'140110100000', N'140110000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3060', N'晋祠镇', N'140110101000', N'140110000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3061', N'姚村镇', N'140110102000', N'140110000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3062', N'清源镇', N'140121100000', N'140121000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3063', N'徐沟镇', N'140121101000', N'140121000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3064', N'东于镇', N'140121102000', N'140121000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3065', N'孟封镇', N'140121103000', N'140121000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3066', N'马峪乡', N'140121200000', N'140121000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3067', N'柳杜乡', N'140121201000', N'140121000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3068', N'西谷乡', N'140121202000', N'140121000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3069', N'王答乡', N'140121203000', N'140121000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3070', N'集义乡', N'140121204000', N'140121000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3071', N'黄寨镇', N'140122100000', N'140122000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3072', N'大盂镇', N'140122101000', N'140122000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3073', N'东黄水镇', N'140122102000', N'140122000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3074', N'泥屯镇', N'140122103000', N'140122000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3075', N'中心镇建设管理办公室', N'140122104000', N'140122000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3076', N'高村乡', N'140122200000', N'140122000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3077', N'侯村乡', N'140122201000', N'140122000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3078', N'凌井店乡', N'140122202000', N'140122000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3079', N'西凌井乡', N'140122203000', N'140122000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3080', N'北小店乡', N'140122204000', N'140122000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3081', N'杨兴乡', N'140122205000', N'140122000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3082', N'娄烦镇', N'140123100000', N'140123000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3083', N'静游镇', N'140123101000', N'140123000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3084', N'杜交曲镇', N'140123102000', N'140123000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3085', N'庙湾乡', N'140123200000', N'140123000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3086', N'马家庄乡', N'140123201000', N'140123000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3087', N'盖家庄乡', N'140123202000', N'140123000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3088', N'米峪镇乡', N'140123203000', N'140123000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3089', N'天池店乡', N'140123204000', N'140123000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3090', N'唐槐园区街道办事处', N'140171401000', N'140171000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3091', N'学府园区街道办事处', N'140171402000', N'140171000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3092', N'阳曲产业园区街道办事处', N'140171403000', N'140171000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3093', N'潇河园区街道办事处', N'140171404000', N'140171000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3094', N'科创城街道办事处', N'140171405000', N'140171000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3095', N'东曲街道办事处', N'140181001000', N'140181000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3096', N'西曲街道办事处', N'140181002000', N'140181000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3097', N'桃园街道办事处', N'140181003000', N'140181000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3098', N'屯兰街道办事处', N'140181004000', N'140181000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3099', N'河口镇', N'140181100000', N'140181000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3100', N'镇城底镇', N'140181101000', N'140181000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3101', N'马兰镇', N'140181102000', N'140181000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3102', N'阁上乡', N'140181200000', N'140181000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3103', N'加乐泉乡', N'140181201000', N'140181000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3104', N'梭峪乡', N'140181202000', N'140181000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3105', N'岔口乡', N'140181203000', N'140181000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3106', N'常安乡', N'140181204000', N'140181000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3107', N'原相乡', N'140181205000', N'140181000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3108', N'邢家社乡', N'140181206000', N'140181000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3109', N'新荣镇', N'140212100000', N'140212000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3110', N'古店镇', N'140212101000', N'140212000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3111', N'破鲁堡乡', N'140212200000', N'140212000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3112', N'郭家窑乡', N'140212202000', N'140212000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3113', N'花元屯乡', N'140212203000', N'140212000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3114', N'西村乡', N'140212206000', N'140212000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3115', N'上深涧乡', N'140212207000', N'140212000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3116', N'堡子湾乡', N'140212209000', N'140212000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3117', N'新荣区街道管理中心', N'140212400000', N'140212000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3118', N'南关街道办事处', N'140213001000', N'140213000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3119', N'北关街道办事处', N'140213002000', N'140213000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3120', N'东街街道办事处', N'140213003000', N'140213000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3121', N'西街街道办事处', N'140213004000', N'140213000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3122', N'南街街道办事处', N'140213005000', N'140213000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3123', N'北街街道办事处', N'140213006000', N'140213000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3124', N'新建南路街道办事处', N'140213007000', N'140213000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3125', N'新建北路街道办事处', N'140213008000', N'140213000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3126', N'大庆路街道办事处', N'140213009000', N'140213000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3127', N'新华街街道办事处', N'140213010000', N'140213000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3128', N'向阳里街道办事处', N'140213011000', N'140213000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3129', N'振华南街街道办事处', N'140213012000', N'140213000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3130', N'开源街街道办事处', N'140213013000', N'140213000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3131', N'新旺乡', N'140213201000', N'140213000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3132', N'水泊寺乡', N'140213202000', N'140213000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3133', N'马军营乡', N'140213203000', N'140213000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3134', N'新胜街道办事处', N'140214001000', N'140214000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3135', N'新平旺街道办事处', N'140214002000', N'140214000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3136', N'煤峪口街道办事处', N'140214003000', N'140214000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3137', N'永定庄街道办事处', N'140214004000', N'140214000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3138', N'同家梁街道办事处', N'140214005000', N'140214000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3139', N'四老沟街道办事处', N'140214006000', N'140214000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3140', N'忻州窑街道办事处', N'140214007000', N'140214000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3141', N'白洞街道办事处', N'140214008000', N'140214000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3142', N'雁崖街道办事处', N'140214009000', N'140214000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3143', N'挖金湾街道办事处', N'140214010000', N'140214000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3144', N'晋华宫街道办事处', N'140214011000', N'140214000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3145', N'马脊梁街道办事处', N'140214012000', N'140214000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3146', N'大斗沟街道办事处', N'140214013000', N'140214000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3147', N'王村街道办事处', N'140214014000', N'140214000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3148', N'姜家湾街道办事处', N'140214015000', N'140214000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3149', N'新泉路街道办事处', N'140214016000', N'140214000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3150', N'民胜街道办事处', N'140214017000', N'140214000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3151', N'口泉街道办事处', N'140214018000', N'140214000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3152', N'马口街道办事处', N'140214019000', N'140214000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3153', N'燕子山街道办事处', N'140214020000', N'140214000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3154', N'杏儿沟街道办事处', N'140214021000', N'140214000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3155', N'青磁窑街道办事处', N'140214022000', N'140214000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3156', N'平泉路街道办事处', N'140214023000', N'140214000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3157', N'四台沟街道办事处', N'140214024000', N'140214000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3158', N'和顺街道办事处', N'140214025000', N'140214000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3159', N'和瑞街道办事处', N'140214026000', N'140214000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3160', N'平盛路街道办事处', N'140214027000', N'140214000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3161', N'清泉街街道办事处', N'140214028000', N'140214000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3162', N'西花园街道办事处', N'140214029000', N'140214000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3163', N'老平旺街道办事处', N'140214030000', N'140214000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3164', N'高山镇', N'140214101000', N'140214000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3165', N'云冈镇', N'140214102000', N'140214000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3166', N'口泉乡', N'140214200000', N'140214000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3167', N'西韩岭乡', N'140214206000', N'140214000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3168', N'平旺乡', N'140214207000', N'140214000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3169', N'鸦儿崖乡', N'140214210000', N'140214000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3170', N'西坪镇', N'140215100000', N'140215000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3171', N'倍加造镇', N'140215101000', N'140215000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3172', N'周士庄镇', N'140215102000', N'140215000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3173', N'吉家庄乡', N'140215201000', N'140215000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3174', N'峰峪乡', N'140215202000', N'140215000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3175', N'杜庄乡', N'140215204000', N'140215000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3176', N'党留庄乡', N'140215205000', N'140215000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3177', N'瓜园乡', N'140215207000', N'140215000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3178', N'聚乐乡', N'140215209000', N'140215000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3179', N'许堡乡', N'140215211000', N'140215000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3180', N'湖东办事处', N'140215401000', N'140215000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3181', N'东街办事处', N'140215402000', N'140215000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3182', N'西街办事处', N'140215403000', N'140215000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3183', N'龙泉镇', N'140221100000', N'140221000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3184', N'罗文皂镇', N'140221101000', N'140221000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3185', N'大白登镇', N'140221102000', N'140221000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3186', N'王官屯镇', N'140221103000', N'140221000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3187', N'古城镇', N'140221104000', N'140221000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3188', N'东小村镇', N'140221105000', N'140221000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3189', N'友宰镇', N'140221106000', N'140221000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3190', N'长城乡', N'140221201000', N'140221000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3191', N'北徐屯乡', N'140221202000', N'140221000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3192', N'狮子屯乡', N'140221204000', N'140221000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3193', N'下深井乡', N'140221209000', N'140221000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3194', N'鳌石乡', N'140221212000', N'140221000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3195', N'玉泉镇', N'140222100000', N'140222000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3196', N'谷前堡镇', N'140222101000', N'140222000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3197', N'米薪关镇', N'140222102000', N'140222000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3198', N'逯家湾镇', N'140222103000', N'140222000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3199', N'新平堡镇', N'140222104000', N'140222000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3200', N'卅里铺乡', N'140222200000', N'140222000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3201', N'南河堡乡', N'140222202000', N'140222000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3202', N'贾家屯乡', N'140222204000', N'140222000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3203', N'赵家沟乡', N'140222206000', N'140222000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3204', N'南高崖乡', N'140222208000', N'140222000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3205', N'张西河乡', N'140222209000', N'140222000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3206', N'马家皂乡', N'140222210000', N'140222000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3207', N'壶泉镇', N'140223100000', N'140223000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3208', N'南村镇', N'140223101000', N'140223000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3209', N'一斗泉乡', N'140223200000', N'140223000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3210', N'蕉山乡', N'140223202000', N'140223000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3211', N'加斗乡', N'140223203000', N'140223000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3212', N'宜兴乡', N'140223206000', N'140223000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3213', N'作疃乡', N'140223207000', N'140223000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3214', N'梁庄乡', N'140223209000', N'140223000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3215', N'望狐乡', N'140223211000', N'140223000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3216', N'武灵镇', N'140224100000', N'140224000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3217', N'东河南镇', N'140224101000', N'140224000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3218', N'上寨镇', N'140224102000', N'140224000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3219', N'落水河乡', N'140224200000', N'140224000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3220', N'史庄乡', N'140224203000', N'140224000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3221', N'赵北乡', N'140224205000', N'140224000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3222', N'石家田乡', N'140224206000', N'140224000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3223', N'柳科乡', N'140224207000', N'140224000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3224', N'白崖台乡', N'140224208000', N'140224000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3225', N'红石塄乡', N'140224210000', N'140224000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3226', N'下关乡', N'140224212000', N'140224000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3227', N'独峪乡', N'140224213000', N'140224000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3228', N'永安镇', N'140225100000', N'140225000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3229', N'西坊城镇', N'140225101000', N'140225000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3230', N'蔡村镇', N'140225102000', N'140225000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3231', N'沙圪坨镇', N'140225103000', N'140225000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3232', N'王庄堡镇', N'140225104000', N'140225000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3233', N'大磁窑镇', N'140225105000', N'140225000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3234', N'东坊城乡', N'140225201000', N'140225000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3235', N'裴村乡', N'140225203000', N'140225000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3236', N'驼峰乡', N'140225204000', N'140225000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3237', N'西留村乡', N'140225205000', N'140225000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3238', N'下韩村乡', N'140225206000', N'140225000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3239', N'南榆林乡', N'140225208000', N'140225000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3240', N'吴城乡', N'140225210000', N'140225000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3241', N'黄花滩乡', N'140225212000', N'140225000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3242', N'大仁庄乡', N'140225213000', N'140225000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3243', N'千佛岭乡', N'140225215000', N'140225000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3244', N'官儿乡', N'140225218000', N'140225000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3245', N'青磁窑乡', N'140225220000', N'140225000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3246', N'云兴镇', N'140226100000', N'140226000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3247', N'鹊儿山镇', N'140226101000', N'140226000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3248', N'店湾镇', N'140226102000', N'140226000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3249', N'管家堡乡', N'140226200000', N'140226000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3250', N'张家场乡', N'140226201000', N'140226000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3251', N'三屯乡', N'140226205000', N'140226000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3252', N'马道头乡', N'140226206000', N'140226000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3253', N'小京庄乡', N'140226207000', N'140226000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3254', N'水窑乡', N'140226209000', N'140226000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3255', N'经济技术开发区乡级单位', N'140271400000', N'140271000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3256', N'上站街道办事处', N'140302001000', N'140302000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3257', N'下站街道办事处', N'140302002000', N'140302000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3258', N'北大街街道办事处', N'140302003000', N'140302000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3259', N'南山路街道办事处', N'140302004000', N'140302000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3260', N'义井街道办事处', N'140302005000', N'140302000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3261', N'坡底街道办事处', N'140302006000', N'140302000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3262', N'义井镇', N'140302100000', N'140302000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3263', N'平潭街街道办事处', N'140303001000', N'140303000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3264', N'蔡洼街道办事处', N'140303003000', N'140303000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3265', N'赛鱼街道办事处', N'140303004000', N'140303000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3266', N'沙坪街道办事处', N'140303005000', N'140303000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3267', N'贵石沟街道办事处', N'140303006000', N'140303000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3268', N'桥头街道办事处', N'140303007000', N'140303000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3269', N'荫营镇', N'140311100000', N'140311000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3270', N'河底镇', N'140311101000', N'140311000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3271', N'平坦镇', N'140311103000', N'140311000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3272', N'西南舁乡', N'140311200000', N'140311000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3273', N'杨家庄乡', N'140311201000', N'140311000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3274', N'李家庄乡', N'140311202000', N'140311000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3275', N'旧街乡', N'140311203000', N'140311000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3276', N'开发区', N'140311400000', N'140311000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3277', N'冠山镇', N'140321100000', N'140321000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3278', N'冶西镇', N'140321101000', N'140321000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3279', N'锁簧镇', N'140321102000', N'140321000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3280', N'张庄镇', N'140321103000', N'140321000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3281', N'东回镇', N'140321104000', N'140321000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3282', N'柏井镇', N'140321105000', N'140321000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3283', N'娘子关镇', N'140321106000', N'140321000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3284', N'巨城镇', N'140321107000', N'140321000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3285', N'石门口乡', N'140321200000', N'140321000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3286', N'岔口乡', N'140321201000', N'140321000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3287', N'秀水镇', N'140322100000', N'140322000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3288', N'孙家庄镇', N'140322101000', N'140322000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3289', N'路家村镇', N'140322102000', N'140322000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3290', N'南娄镇', N'140322103000', N'140322000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3291', N'牛村镇', N'140322104000', N'140322000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3292', N'苌池镇', N'140322105000', N'140322000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3293', N'上社镇', N'140322106000', N'140322000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3294', N'西烟镇', N'140322107000', N'140322000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3295', N'仙人乡', N'140322200000', N'140322000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3296', N'北下庄乡', N'140322201000', N'140322000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3297', N'下社乡', N'140322202000', N'140322000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3298', N'梁家寨乡', N'140322203000', N'140322000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3299', N'西潘乡', N'140322204000', N'140322000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3300', N'东梁乡', N'140322205000', N'140322000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3301', N'东街街道办事处', N'140412001000', N'140412000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3302', N'西街街道办事处', N'140412002000', N'140412000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3303', N'英雄南路街道办事处', N'140412003000', N'140412000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3304', N'英雄中路街道办事处', N'140412004000', N'140412000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3305', N'紫金街街道办事处', N'140412005000', N'140412000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3306', N'太行东街街道办事处', N'140412006000', N'140412000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3307', N'太行西街街道办事处', N'140412007000', N'140412000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3308', N'延安南路街道办事处', N'140412008000', N'140412000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3309', N'常青街道办事处', N'140412009000', N'140412000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3310', N'五马街道办事处', N'140412010000', N'140412000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3311', N'长北街道办事处', N'140412011000', N'140412000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3312', N'故县街道办事处', N'140412012000', N'140412000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3313', N'老顶山镇', N'140412100000', N'140412000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3314', N'堠北庄镇', N'140412101000', N'140412000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3315', N'大辛庄镇', N'140412102000', N'140412000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3316', N'马厂镇', N'140412103000', N'140412000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3317', N'黄碾镇', N'140412104000', N'140412000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3318', N'西白兔乡', N'140412200000', N'140412000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3319', N'长治市漳泽工业转型试验区管理委员会', N'140412400000', N'140412000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3320', N'长治市老顶山旅游开发管理中心', N'140412401000', N'140412000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3321', N'韩店镇', N'140413100000', N'140413000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3322', N'苏店镇', N'140413101000', N'140413000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3323', N'荫城镇', N'140413102000', N'140413000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3324', N'西火镇', N'140413103000', N'140413000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3325', N'八义镇', N'140413104000', N'140413000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3326', N'贾掌镇', N'140413105000', N'140413000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3327', N'郝家庄乡', N'140413200000', N'140413000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3328', N'西池乡', N'140413201000', N'140413000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3329', N'北呈乡', N'140413202000', N'140413000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3330', N'东和乡', N'140413203000', N'140413000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3331', N'南宋乡', N'140413204000', N'140413000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3332', N'振兴新区', N'140413400000', N'140413000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3333', N'上党经济技术开发区', N'140413401000', N'140413000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3334', N'长治市经济技术开发区长治县部分', N'140413406000', N'140413000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3335', N'信义管委会', N'140413407000', N'140413000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3336', N'麟绛镇', N'140414100000', N'140414000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3337', N'上村镇', N'140414101000', N'140414000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3338', N'渔泽镇', N'140414102000', N'140414000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3339', N'余吾镇', N'140414103000', N'140414000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3340', N'吾元镇', N'140414104000', N'140414000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3341', N'张店镇', N'140414105000', N'140414000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3342', N'丰宜镇', N'140414106000', N'140414000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3343', N'李高乡', N'140414200000', N'140414000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3344', N'路村乡', N'140414201000', N'140414000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3345', N'河神庙乡', N'140414202000', N'140414000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3346', N'西贾乡', N'140414203000', N'140414000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3347', N'西流寨开发区', N'140414400000', N'140414000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3348', N'康庄工业园区', N'140414401000', N'140414000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3349', N'上莲开发区', N'140414402000', N'140414000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3350', N'屯留县经济技术开发区', N'140414403000', N'140414000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3351', N'潞华街道办事处', N'140415001000', N'140415000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3352', N'成家川街道办事处', N'140415002000', N'140415000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3353', N'店上镇', N'140415100000', N'140415000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3354', N'微子镇', N'140415101000', N'140415000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3355', N'辛安泉镇', N'140415102000', N'140415000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3356', N'翟店镇', N'140415103000', N'140415000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3357', N'合室乡', N'140415200000', N'140415000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3358', N'黄牛蹄乡', N'140415201000', N'140415000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3359', N'史回乡', N'140415202000', N'140415000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3360', N'潞城经济技术开发区', N'140415400000', N'140415000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3361', N'古韩镇', N'140423100000', N'140423000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3362', N'王桥镇', N'140423101000', N'140423000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3363', N'侯堡镇', N'140423102000', N'140423000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3364', N'夏店镇', N'140423103000', N'140423000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3365', N'虒亭镇', N'140423104000', N'140423000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3366', N'西营镇', N'140423105000', N'140423000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3367', N'王村镇', N'140423106000', N'140423000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3368', N'下良镇', N'140423107000', N'140423000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3369', N'善福乡', N'140423200000', N'140423000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3370', N'北底乡', N'140423201000', N'140423000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3371', N'上马乡', N'140423202000', N'140423000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3372', N'富阳工业园区', N'140423400000', N'140423000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3373', N'襄垣经济技术开发区', N'140423402000', N'140423000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3374', N'青羊镇', N'140425100000', N'140425000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3375', N'龙溪镇', N'140425101000', N'140425000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3376', N'石城镇', N'140425102000', N'140425000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3377', N'苗庄镇', N'140425103000', N'140425000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3378', N'杏城镇', N'140425104000', N'140425000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3379', N'西沟乡', N'140425200000', N'140425000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3380', N'东寺头乡', N'140425201000', N'140425000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3381', N'虹梯关乡', N'140425202000', N'140425000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3382', N'阳高乡', N'140425203000', N'140425000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3383', N'北耽车乡', N'140425204000', N'140425000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3384', N'中五井乡', N'140425205000', N'140425000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3385', N'北社乡', N'140425206000', N'140425000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3386', N'平顺经济技术开发区', N'140425400000', N'140425000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3387', N'黎侯镇', N'140426100000', N'140426000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3388', N'东阳关镇', N'140426101000', N'140426000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3389', N'上遥镇', N'140426102000', N'140426000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3390', N'西井镇', N'140426103000', N'140426000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3391', N'黄崖洞镇', N'140426104000', N'140426000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3392', N'西仵乡', N'140426200000', N'140426000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3393', N'停河铺乡', N'140426201000', N'140426000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3394', N'程家山乡', N'140426202000', N'140426000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3395', N'洪井乡', N'140426203000', N'140426000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3396', N'黎城县经济技术开发区', N'140426400000', N'140426000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3397', N'龙泉镇', N'140427100000', N'140427000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3398', N'百尺镇', N'140427101000', N'140427000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3399', N'店上镇', N'140427102000', N'140427000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3400', N'晋庄镇', N'140427103000', N'140427000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3401', N'树掌镇', N'140427104000', N'140427000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3402', N'集店乡', N'140427200000', N'140427000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3403', N'黄山乡', N'140427201000', N'140427000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3404', N'东井岭乡', N'140427202000', N'140427000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3405', N'石坡乡', N'140427203000', N'140427000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3406', N'五龙山乡', N'140427204000', N'140427000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3407', N'鹅屋乡', N'140427205000', N'140427000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3408', N'桥上乡', N'140427206000', N'140427000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3409', N'常平办事处', N'140427400000', N'140427000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3410', N'壶关经济开发区', N'140427401000', N'140427000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3411', N'丹朱镇', N'140428100000', N'140428000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3412', N'鲍店镇', N'140428101000', N'140428000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3413', N'石哲镇', N'140428102000', N'140428000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3414', N'大堡头镇', N'140428103000', N'140428000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3415', N'慈林镇', N'140428104000', N'140428000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3416', N'色头镇', N'140428105000', N'140428000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3417', N'南漳镇', N'140428106000', N'140428000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3418', N'岚水乡', N'140428200000', N'140428000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3419', N'碾张乡', N'140428201000', N'140428000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3420', N'常张乡', N'140428202000', N'140428000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3421', N'南陈乡', N'140428203000', N'140428000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3422', N'宋村乡', N'140428204000', N'140428000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3423', N'长子经济技术开发区', N'140428400000', N'140428000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3424', N'丰州镇', N'140429100000', N'140429000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3425', N'洪水镇', N'140429101000', N'140429000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3426', N'蟠龙镇', N'140429102000', N'140429000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3427', N'监漳镇', N'140429103000', N'140429000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3428', N'故城镇', N'140429104000', N'140429000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3429', N'墨镫乡', N'140429200000', N'140429000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3430', N'韩北乡', N'140429201000', N'140429000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3431', N'大有乡', N'140429202000', N'140429000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3432', N'贾豁乡', N'140429203000', N'140429000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3433', N'故县乡', N'140429204000', N'140429000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3434', N'上司乡', N'140429205000', N'140429000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3435', N'石北乡', N'140429206000', N'140429000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3436', N'涌泉乡', N'140429207000', N'140429000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3437', N'分水岭乡', N'140429208000', N'140429000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3438', N'武乡经济技术开发区', N'140429400000', N'140429000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3439', N'定昌镇', N'140430100000', N'140430000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3440', N'郭村镇', N'140430101000', N'140430000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3441', N'故县镇', N'140430102000', N'140430000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3442', N'新店镇', N'140430103000', N'140430000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3443', N'漳源镇', N'140430104000', N'140430000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3444', N'册村镇', N'140430105000', N'140430000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3445', N'段柳乡', N'140430200000', N'140430000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3446', N'松村乡', N'140430201000', N'140430000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3447', N'次村乡', N'140430202000', N'140430000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3448', N'牛寺乡', N'140430203000', N'140430000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3449', N'南里乡', N'140430204000', N'140430000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3450', N'南泉乡', N'140430205000', N'140430000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3451', N'杨安乡', N'140430206000', N'140430000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3452', N'沁河镇', N'140431100000', N'140431000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3453', N'郭道镇', N'140431101000', N'140431000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3454', N'灵空山镇', N'140431102000', N'140431000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3455', N'王和镇', N'140431103000', N'140431000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3456', N'李元镇', N'140431104000', N'140431000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3457', N'中峪乡', N'140431200000', N'140431000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3458', N'法中乡', N'140431201000', N'140431000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3459', N'交口乡', N'140431202000', N'140431000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3460', N'聪子峪乡', N'140431203000', N'140431000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3461', N'韩洪乡', N'140431204000', N'140431000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3462', N'官滩乡', N'140431205000', N'140431000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3463', N'景凤乡', N'140431206000', N'140431000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3464', N'赤石桥乡', N'140431207000', N'140431000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3465', N'王陶乡', N'140431208000', N'140431000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3466', N'沁源经济技术开发区', N'140431400000', N'140431000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3467', N'长治高新技术开发区城北街办事处', N'140471400000', N'140471000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3468', N'东街街道办事处', N'140502001000', N'140502000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3469', N'西街街道办事处', N'140502002000', N'140502000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3470', N'南街街道办事处', N'140502003000', N'140502000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3471', N'北街街道办事处', N'140502004000', N'140502000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3472', N'钟家庄办事处', N'140502006000', N'140502000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3473', N'西上庄办事处', N'140502007000', N'140502000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3474', N'开发区街道办事处', N'140502009000', N'140502000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3475', N'北石店镇', N'140502100000', N'140502000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3476', N'龙港镇', N'140521100000', N'140521000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3477', N'中村镇', N'140521101000', N'140521000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3478', N'郑庄镇', N'140521102000', N'140521000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3479', N'端氏镇', N'140521103000', N'140521000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3480', N'嘉峰镇', N'140521104000', N'140521000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3481', N'郑村镇', N'140521105000', N'140521000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3482', N'柿庄镇', N'140521106000', N'140521000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3483', N'樊村河乡', N'140521200000', N'140521000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3484', N'土沃乡', N'140521201000', N'140521000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3485', N'张村乡', N'140521202000', N'140521000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3486', N'苏庄乡', N'140521203000', N'140521000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3487', N'胡底乡', N'140521204000', N'140521000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3488', N'固县乡', N'140521205000', N'140521000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3489', N'十里乡', N'140521206000', N'140521000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3490', N'凤城镇', N'140522100000', N'140522000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3491', N'北留镇', N'140522101000', N'140522000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3492', N'润城镇', N'140522102000', N'140522000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3493', N'町店镇', N'140522103000', N'140522000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3494', N'芹池镇', N'140522104000', N'140522000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3495', N'次营镇', N'140522105000', N'140522000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3496', N'横河镇', N'140522106000', N'140522000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3497', N'河北镇', N'140522107000', N'140522000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3498', N'蟒河镇', N'140522108000', N'140522000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3499', N'东冶镇', N'140522109000', N'140522000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3500', N'白桑乡', N'140522200000', N'140522000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3501', N'寺头乡', N'140522201000', N'140522000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3502', N'西河乡', N'140522202000', N'140522000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3503', N'演礼乡', N'140522203000', N'140522000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3504', N'固隆乡', N'140522204000', N'140522000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3505', N'董封乡', N'140522205000', N'140522000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3506', N'驾岭乡', N'140522206000', N'140522000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3507', N'林场管理处', N'140522401000', N'140522000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3508', N'崇文镇', N'140524100000', N'140524000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3509', N'礼义镇', N'140524101000', N'140524000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3510', N'附城镇', N'140524102000', N'140524000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3511', N'西河底镇', N'140524103000', N'140524000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3512', N'平城镇', N'140524104000', N'140524000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3513', N'杨村镇', N'140524105000', N'140524000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3514', N'潞城镇', N'140524106000', N'140524000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3515', N'夺火乡', N'140524204000', N'140524000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3516', N'马圪当乡', N'140524206000', N'140524000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3517', N'古郊乡', N'140524207000', N'140524000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3518', N'六泉乡', N'140524209000', N'140524000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3519', N'秦家庄乡', N'140524212000', N'140524000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3520', N'南村镇', N'140525100000', N'140525000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3521', N'下村镇', N'140525101000', N'140525000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3522', N'大东沟镇', N'140525102000', N'140525000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3523', N'周村镇', N'140525103000', N'140525000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3524', N'犁川镇', N'140525104000', N'140525000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3525', N'晋庙铺镇', N'140525105000', N'140525000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3526', N'金村镇', N'140525106000', N'140525000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3527', N'高都镇', N'140525107000', N'140525000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3528', N'巴公镇', N'140525108000', N'140525000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3529', N'大阳镇', N'140525109000', N'140525000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3530', N'山河镇', N'140525110000', N'140525000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3531', N'大箕镇', N'140525111000', N'140525000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3532', N'柳树口镇', N'140525112000', N'140525000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3533', N'北义城镇', N'140525113000', N'140525000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3534', N'川底乡', N'140525200000', N'140525000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3535', N'李寨乡', N'140525201000', N'140525000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3536', N'南岭乡', N'140525202000', N'140525000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3537', N'北城街道办事处', N'140581001000', N'140581000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3538', N'东城街道办事处', N'140581002000', N'140581000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3539', N'南城街道办事处', N'140581003000', N'140581000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3540', N'米山镇', N'140581101000', N'140581000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3541', N'三甲镇', N'140581102000', N'140581000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3542', N'神农镇', N'140581103000', N'140581000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3543', N'陈区镇', N'140581104000', N'140581000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3544', N'北诗镇', N'140581105000', N'140581000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3545', N'河西镇', N'140581106000', N'140581000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3546', N'马村镇', N'140581107000', N'140581000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3547', N'野川镇', N'140581108000', N'140581000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3548', N'寺庄镇', N'140581109000', N'140581000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3549', N'建宁乡', N'140581201000', N'140581000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3550', N'石末乡', N'140581202000', N'140581000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3551', N'原村乡', N'140581203000', N'140581000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3552', N'永录乡', N'140581204000', N'140581000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3553', N'北城街道办事处', N'140602001000', N'140602000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3554', N'南城街道办事处', N'140602002000', N'140602000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3555', N'神头街道办事处', N'140602003000', N'140602000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3556', N'北旺庄街道办事处', N'140602004000', N'140602000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3557', N'神头镇', N'140602100000', N'140602000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3558', N'利民镇', N'140602101000', N'140602000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3559', N'下团堡乡', N'140602200000', N'140602000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3560', N'小平易乡', N'140602201000', N'140602000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3561', N'滋润乡', N'140602202000', N'140602000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3562', N'福善庄乡', N'140602203000', N'140602000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3563', N'南榆林乡', N'140602204000', N'140602000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3564', N'贾庄乡', N'140602205000', N'140602000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3565', N'沙塄河乡', N'140602206000', N'140602000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3566', N'窑子头乡', N'140602207000', N'140602000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3567', N'张蔡庄乡', N'140602208000', N'140602000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3568', N'井坪镇', N'140603100000', N'140603000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3569', N'凤凰城镇', N'140603101000', N'140603000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3570', N'白堂乡', N'140603200000', N'140603000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3571', N'陶村乡', N'140603201000', N'140603000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3572', N'下水头乡', N'140603202000', N'140603000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3573', N'双碾乡', N'140603203000', N'140603000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3574', N'阻虎乡', N'140603204000', N'140603000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3575', N'高石庄乡', N'140603205000', N'140603000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3576', N'西水界乡', N'140603206000', N'140603000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3577', N'下面高乡', N'140603207000', N'140603000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3578', N'下木角乡', N'140603208000', N'140603000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3579', N'向阳堡乡', N'140603209000', N'140603000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3580', N'榆岭乡', N'140603210000', N'140603000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3581', N'东城管理委员会', N'140621001000', N'140621000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3582', N'西城管理委员会', N'140621002000', N'140621000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3583', N'玉井镇', N'140621100000', N'140621000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3584', N'北周庄镇', N'140621101000', N'140621000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3585', N'古城镇', N'140621102000', N'140621000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3586', N'岱岳镇', N'140621103000', N'140621000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3587', N'吴马营乡', N'140621200000', N'140621000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3588', N'马营乡', N'140621201000', N'140621000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3589', N'下喇叭乡', N'140621202000', N'140621000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3590', N'合盛堡乡', N'140621203000', N'140621000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3591', N'安荣乡', N'140621205000', N'140621000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3592', N'薛圐圙乡', N'140621206000', N'140621000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3593', N'后所乡', N'140621207000', N'140621000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3594', N'张家庄乡', N'140621208000', N'140621000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3595', N'马营庄乡', N'140621209000', N'140621000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3596', N'山阴农牧场', N'140621400000', N'140621000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3597', N'金城镇', N'140622100000', N'140622000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3598', N'南河种镇', N'140622101000', N'140622000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3599', N'下社镇', N'140622102000', N'140622000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3600', N'镇子梁乡', N'140622200000', N'140622000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3601', N'义井乡', N'140622201000', N'140622000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3602', N'藏寨乡', N'140622202000', N'140622000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3603', N'大黄巍乡', N'140622203000', N'140622000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3604', N'杏寨乡', N'140622204000', N'140622000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3605', N'下马峪乡', N'140622205000', N'140622000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3606', N'南泉乡', N'140622206000', N'140622000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3607', N'大临河乡', N'140622207000', N'140622000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3608', N'白马石乡', N'140622208000', N'140622000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3609', N'新城镇', N'140623100000', N'140623000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3610', N'右卫镇', N'140623101000', N'140623000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3611', N'威远镇', N'140623102000', N'140623000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3612', N'元堡子镇', N'140623103000', N'140623000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3613', N'牛心堡乡', N'140623200000', N'140623000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3614', N'白头里乡', N'140623201000', N'140623000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3615', N'高家堡乡', N'140623202000', N'140623000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3616', N'丁家窑乡', N'140623203000', N'140623000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3617', N'杨千河乡', N'140623204000', N'140623000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3618', N'李达窑乡', N'140623205000', N'140623000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3619', N'山西朔州经济开发区街道办事处筹备处', N'140671400000', N'140671000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3620', N'云中镇', N'140681100000', N'140681000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3621', N'吴家窑镇', N'140681101000', N'140681000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3622', N'金沙滩镇', N'140681102000', N'140681000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3623', N'毛家皂镇', N'140681103000', N'140681000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3624', N'何家堡乡', N'140681200000', N'140681000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3625', N'新家园乡', N'140681201000', N'140681000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3626', N'亲和乡', N'140681202000', N'140681000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3627', N'海北头乡', N'140681203000', N'140681000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3628', N'马辛庄乡', N'140681204000', N'140681000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3629', N'河头乡', N'140681205000', N'140681000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3630', N'金沙滩农牧场', N'140681500000', N'140681000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3631', N'金沙滩林场', N'140681501000', N'140681000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3632', N'北关街道办事处', N'140702001000', N'140702000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3633', N'锦纶街道办事处', N'140702002000', N'140702000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3634', N'新华街道办事处', N'140702003000', N'140702000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3635', N'西南街道办事处', N'140702004000', N'140702000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3636', N'路西街道办事处', N'140702005000', N'140702000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3637', N'经纬街道办事处', N'140702006000', N'140702000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3638', N'安宁街道办事处', N'140702007000', N'140702000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3639', N'新建街道办事处', N'140702008000', N'140702000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3640', N'晋华街道办事处', N'140702009000', N'140702000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3641', N'乌金山镇', N'140702100000', N'140702000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3642', N'东阳镇', N'140702101000', N'140702000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3643', N'什贴镇', N'140702102000', N'140702000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3644', N'长凝镇', N'140702103000', N'140702000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3645', N'北田镇', N'140702104000', N'140702000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3646', N'修文镇', N'140702105000', N'140702000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3647', N'郭家堡乡', N'140702200000', N'140702000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3648', N'张庆乡', N'140702201000', N'140702000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3649', N'庄子乡', N'140702202000', N'140702000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3650', N'东赵乡', N'140702203000', N'140702000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3651', N'榆次区使赵乡社会事务管理中心', N'140702204000', N'140702000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3652', N'山西转型综合改革示范区晋中开发区', N'140702401000', N'140702000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3653', N'箕城镇', N'140721100000', N'140721000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3654', N'云簇镇', N'140721101000', N'140721000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3655', N'郝北镇', N'140721102000', N'140721000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3656', N'社城镇', N'140721103000', N'140721000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3657', N'河峪乡', N'140721200000', N'140721000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3658', N'北寨乡', N'140721201000', N'140721000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3659', N'西马乡', N'140721202000', N'140721000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3660', N'岚峪乡', N'140721203000', N'140721000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3661', N'讲堂乡', N'140721204000', N'140721000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3662', N'城区管理委员会', N'140721400000', N'140721000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3663', N'城区街道管理委员会', N'140722001000', N'140722000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3664', N'辽阳镇', N'140722100000', N'140722000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3665', N'桐峪镇', N'140722101000', N'140722000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3666', N'麻田镇', N'140722102000', N'140722000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3667', N'芹泉镇', N'140722103000', N'140722000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3668', N'拐儿镇', N'140722104000', N'140722000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3669', N'寒王乡', N'140722200000', N'140722000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3670', N'石匣乡', N'140722201000', N'140722000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3671', N'龙泉乡', N'140722202000', N'140722000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3672', N'粟城乡', N'140722203000', N'140722000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3673', N'羊角乡', N'140722204000', N'140722000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3674', N'城区管理委员会', N'140723001000', N'140723000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3675', N'义兴镇', N'140723100000', N'140723000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3676', N'李阳镇', N'140723101000', N'140723000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3677', N'松烟镇', N'140723102000', N'140723000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3678', N'青城镇', N'140723103000', N'140723000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3679', N'横岭镇', N'140723104000', N'140723000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3680', N'喂马乡', N'140723200000', N'140723000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3681', N'平松乡', N'140723201000', N'140723000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3682', N'牛川乡', N'140723202000', N'140723000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3683', N'马坊乡', N'140723203000', N'140723000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3684', N'阳光占乡', N'140723204000', N'140723000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3685', N'城区社区管理委员会', N'140724001000', N'140724000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3686', N'乐平镇', N'140724100000', N'140724000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3687', N'皋落镇', N'140724101000', N'140724000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3688', N'冶头镇', N'140724102000', N'140724000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3689', N'沾尚镇', N'140724103000', N'140724000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3690', N'大寨镇', N'140724104000', N'140724000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3691', N'李家庄乡', N'140724200000', N'140724000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3692', N'界都乡', N'140724201000', N'140724000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3693', N'三都乡', N'140724202000', N'140724000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3694', N'赵壁乡', N'140724203000', N'140724000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3695', N'孔氏乡', N'140724204000', N'140724000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3696', N'闫庄乡', N'140724205000', N'140724000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3697', N'西寨乡', N'140724206000', N'140724000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3698', N'朝阳镇', N'140725100000', N'140725000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3699', N'南燕竹镇', N'140725101000', N'140725000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3700', N'宗艾镇', N'140725102000', N'140725000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3701', N'平头镇', N'140725103000', N'140725000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3702', N'松塔镇', N'140725104000', N'140725000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3703', N'西洛镇', N'140725105000', N'140725000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3704', N'尹灵芝镇', N'140725106000', N'140725000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3705', N'平舒乡', N'140725200000', N'140725000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3706', N'解愁乡', N'140725201000', N'140725000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3707', N'温家庄乡', N'140725202000', N'140725000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3708', N'景尚乡', N'140725203000', N'140725000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3709', N'上湖乡', N'140725204000', N'140725000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3710', N'羊头崖乡', N'140725205000', N'140725000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3711', N'马首乡', N'140725206000', N'140725000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3712', N'明星镇', N'140726100000', N'140726000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3713', N'胡村镇', N'140726101000', N'140726000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3714', N'范村镇', N'140726102000', N'140726000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3715', N'侯城乡', N'140726200000', N'140726000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3716', N'北汪乡', N'140726201000', N'140726000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3717', N'水秀乡', N'140726202000', N'140726000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3718', N'阳邑乡', N'140726203000', N'140726000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3719', N'小白乡', N'140726204000', N'140726000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3720', N'任村乡', N'140726205000', N'140726000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3721', N'白塔区管委会', N'140726401000', N'140726000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3722', N'北城区管委会', N'140726402000', N'140726000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3723', N'南城区管委会', N'140726403000', N'140726000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3724', N'昌源城区管理委员会', N'140727001000', N'140727000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3725', N'丹枫城区管理委员会', N'140727002000', N'140727000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3726', N'麓台城区管理委员会', N'140727003000', N'140727000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3727', N'昭馀镇', N'140727100000', N'140727000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3728', N'东观镇', N'140727101000', N'140727000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3729', N'古县镇', N'140727102000', N'140727000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3730', N'贾令镇', N'140727103000', N'140727000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3731', N'城赵镇', N'140727104000', N'140727000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3732', N'来远镇', N'140727105000', N'140727000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3733', N'西六支乡', N'140727200000', N'140727000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3734', N'峪口乡', N'140727201000', N'140727000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3735', N'祁县经济开发区管理委员会', N'140727400000', N'140727000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3736', N'古城街道办事处', N'140728001000', N'140728000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3737', N'城东街道办事处', N'140728002000', N'140728000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3738', N'城西街道办事处', N'140728003000', N'140728000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3739', N'古陶镇', N'140728100000', N'140728000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3740', N'段村镇', N'140728101000', N'140728000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3741', N'东泉镇', N'140728102000', N'140728000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3742', N'洪善镇', N'140728103000', N'140728000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3743', N'宁固镇', N'140728104000', N'140728000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3744', N'南政乡', N'140728200000', N'140728000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3745', N'中都乡', N'140728201000', N'140728000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3746', N'岳壁乡', N'140728202000', N'140728000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3747', N'卜宜乡', N'140728203000', N'140728000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3748', N'孟山乡', N'140728204000', N'140728000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3749', N'朱坑乡', N'140728205000', N'140728000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3750', N'襄垣乡', N'140728206000', N'140728000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3751', N'杜家庄乡', N'140728207000', N'140728000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3752', N'香乐乡', N'140728208000', N'140728000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3753', N'东城管理委员会', N'140729001000', N'140729000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3754', N'西城管理委员会', N'140729002000', N'140729000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3755', N'北城管理委员会', N'140729003000', N'140729000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3756', N'翠峰镇', N'140729100000', N'140729000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3757', N'静升镇', N'140729101000', N'140729000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3758', N'两渡镇', N'140729102000', N'140729000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3759', N'夏门镇', N'140729103000', N'140729000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3760', N'南关镇', N'140729104000', N'140729000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3761', N'段纯镇', N'140729105000', N'140729000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3762', N'马和乡', N'140729200000', N'140729000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3763', N'英武乡', N'140729201000', N'140729000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3764', N'王禹乡', N'140729202000', N'140729000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3765', N'坛镇乡', N'140729203000', N'140729000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3766', N'梁家焉乡', N'140729204000', N'140729000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3767', N'交口乡', N'140729205000', N'140729000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3768', N'北关街道办事处', N'140781001000', N'140781000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3769', N'西关街道办事处', N'140781002000', N'140781000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3770', N'东南街道办事处', N'140781003000', N'140781000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3771', N'西南街道办事处', N'140781004000', N'140781000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3772', N'北坛街道办事处', N'140781005000', N'140781000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3773', N'义安镇', N'140781100000', N'140781000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3774', N'张兰镇', N'140781101000', N'140781000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3775', N'连福镇', N'140781102000', N'140781000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3776', N'洪山镇', N'140781103000', N'140781000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3777', N'龙凤镇', N'140781104000', N'140781000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3778', N'绵山镇', N'140781105000', N'140781000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3779', N'义棠镇', N'140781106000', N'140781000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3780', N'城关乡', N'140781200000', N'140781000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3781', N'宋古乡', N'140781201000', N'140781000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3782', N'三佳乡', N'140781202000', N'140781000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3783', N'中城街道办事处', N'140802001000', N'140802000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3784', N'东城街道办事处', N'140802002000', N'140802000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3785', N'西城街道办事处', N'140802003000', N'140802000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3786', N'南城街道办事处', N'140802004000', N'140802000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3787', N'北城街道办事处', N'140802005000', N'140802000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3788', N'安邑街道办事处', N'140802006000', N'140802000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3789', N'大渠街道办事处', N'140802007000', N'140802000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3790', N'姚孟街道办事处', N'140802008000', N'140802000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3791', N'解州镇', N'140802100000', N'140802000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3792', N'龙居镇', N'140802101000', N'140802000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3793', N'北相镇', N'140802102000', N'140802000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3794', N'泓芝驿镇', N'140802103000', N'140802000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3795', N'三路里镇', N'140802104000', N'140802000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3796', N'陶村镇', N'140802105000', N'140802000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3797', N'东郭镇', N'140802106000', N'140802000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3798', N'席张乡', N'140802200000', N'140802000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3799', N'金井乡', N'140802201000', N'140802000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3800', N'王范乡', N'140802202000', N'140802000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3801', N'冯村乡', N'140802203000', N'140802000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3802', N'上郭乡', N'140802204000', N'140802000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3803', N'上王乡', N'140802205000', N'140802000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3804', N'山西运城经济开发区', N'140802402000', N'140802000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3805', N'运城空港经济开发区', N'140802403000', N'140802000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3806', N'猗氏镇', N'140821100000', N'140821000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3807', N'嵋阳镇', N'140821101000', N'140821000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3808', N'临晋镇', N'140821102000', N'140821000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3809', N'七级镇', N'140821103000', N'140821000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3810', N'东张镇', N'140821104000', N'140821000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3811', N'孙吉镇', N'140821105000', N'140821000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3812', N'三管镇', N'140821106000', N'140821000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3813', N'牛杜镇', N'140821107000', N'140821000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3814', N'耽子镇', N'140821108000', N'140821000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3815', N'楚侯乡', N'140821200000', N'140821000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3816', N'庙上乡', N'140821201000', N'140821000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3817', N'角杯乡', N'140821202000', N'140821000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3818', N'北辛乡', N'140821203000', N'140821000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3819', N'北景乡', N'140821204000', N'140821000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3820', N'临猗县城市社区管理办公室', N'140821402000', N'140821000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3821', N'解店镇', N'140822100000', N'140822000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3822', N'通化镇', N'140822101000', N'140822000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3823', N'汉薛镇', N'140822102000', N'140822000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3824', N'荣河镇', N'140822103000', N'140822000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3825', N'万泉乡', N'140822200000', N'140822000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3826', N'里望乡', N'140822201000', N'140822000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3827', N'西村乡', N'140822202000', N'140822000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3828', N'南张乡', N'140822203000', N'140822000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3829', N'高村乡', N'140822204000', N'140822000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3830', N'皇甫乡', N'140822205000', N'140822000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3831', N'贾村乡', N'140822206000', N'140822000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3832', N'王显乡', N'140822207000', N'140822000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3833', N'光华乡', N'140822208000', N'140822000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3834', N'裴庄乡', N'140822209000', N'140822000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3835', N'桐城镇', N'140823100000', N'140823000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3836', N'郭家庄镇', N'140823101000', N'140823000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3837', N'畖底镇', N'140823102000', N'140823000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3838', N'薛店镇', N'140823103000', N'140823000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3839', N'东镇镇', N'140823104000', N'140823000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3840', N'礼元镇', N'140823105000', N'140823000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3841', N'河底镇', N'140823106000', N'140823000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3842', N'神柏乡', N'140823200000', N'140823000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3843', N'阳隅乡', N'140823201000', N'140823000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3844', N'侯村乡', N'140823202000', N'140823000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3845', N'裴社乡', N'140823203000', N'140823000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3846', N'后宫乡', N'140823204000', N'140823000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3847', N'石门乡', N'140823205000', N'140823000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3848', N'社区管理办公室', N'140823400000', N'140823000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3849', N'稷峰镇', N'140824100000', N'140824000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3850', N'西社镇', N'140824101000', N'140824000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3851', N'化峪镇', N'140824102000', N'140824000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3852', N'翟店镇', N'140824103000', N'140824000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3853', N'清河镇', N'140824104000', N'140824000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3854', N'蔡村乡', N'140824200000', N'140824000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3855', N'太阳乡', N'140824201000', N'140824000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3856', N'稷山县社区服务中心', N'140824400000', N'140824000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3857', N'龙兴镇', N'140825100000', N'140825000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3858', N'三泉镇', N'140825101000', N'140825000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3859', N'泽掌镇', N'140825102000', N'140825000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3860', N'北张镇', N'140825103000', N'140825000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3861', N'古交镇', N'140825104000', N'140825000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3862', N'万安镇', N'140825105000', N'140825000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3863', N'阳王镇', N'140825106000', N'140825000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3864', N'泉掌镇', N'140825107000', N'140825000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3865', N'横桥乡', N'140825200000', N'140825000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3866', N'社区办', N'140825400000', N'140825000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3867', N'新绛县煤化园区管委会', N'140825498000', N'140825000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3868', N'古绛镇', N'140826100000', N'140826000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3869', N'横水镇', N'140826101000', N'140826000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3870', N'陈村镇', N'140826102000', N'140826000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3871', N'卫庄镇', N'140826103000', N'140826000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3872', N'么里镇', N'140826104000', N'140826000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3873', N'南樊镇', N'140826105000', N'140826000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3874', N'安峪镇', N'140826106000', N'140826000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3875', N'大交镇', N'140826107000', N'140826000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3876', N'郝庄乡', N'140826200000', N'140826000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3877', N'冷口乡', N'140826201000', N'140826000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3878', N'山西绛县经济开发区', N'140826402000', N'140826000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3879', N'新城镇', N'140827100000', N'140827000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3880', N'历山镇', N'140827101000', N'140827000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3881', N'古城镇', N'140827102000', N'140827000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3882', N'王茅镇', N'140827103000', N'140827000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3883', N'毛家湾镇', N'140827104000', N'140827000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3884', N'蒲掌乡', N'140827200000', N'140827000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3885', N'英言乡', N'140827201000', N'140827000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3886', N'解峪乡', N'140827202000', N'140827000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3887', N'华峰乡', N'140827203000', N'140827000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3888', N'长直乡', N'140827204000', N'140827000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3889', N'皋落乡', N'140827205000', N'140827000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3890', N'瑶峰镇', N'140828100000', N'140828000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3891', N'庙前镇', N'140828101000', N'140828000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3892', N'裴介镇', N'140828102000', N'140828000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3893', N'水头镇', N'140828103000', N'140828000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3894', N'埝掌镇', N'140828104000', N'140828000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3895', N'泗交镇', N'140828105000', N'140828000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3896', N'尉郭乡', N'140828200000', N'140828000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3897', N'禹王乡', N'140828201000', N'140828000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3898', N'胡张乡', N'140828202000', N'140828000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3899', N'南大里乡', N'140828203000', N'140828000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3900', N'祁家河乡', N'140828204000', N'140828000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3901', N'圣人涧镇', N'140829100000', N'140829000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3902', N'常乐镇', N'140829101000', N'140829000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3903', N'张店镇', N'140829102000', N'140829000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3904', N'张村镇', N'140829103000', N'140829000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3905', N'曹川镇', N'140829104000', N'140829000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3906', N'三门镇', N'140829105000', N'140829000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3907', N'洪池乡', N'140829200000', N'140829000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3908', N'杜马乡', N'140829201000', N'140829000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3909', N'部官乡', N'140829202000', N'140829000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3910', N'坡底乡', N'140829203000', N'140829000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3911', N'古魏镇', N'140830100000', N'140830000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3912', N'风陵渡镇', N'140830101000', N'140830000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3913', N'陌南镇', N'140830102000', N'140830000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3914', N'西陌镇', N'140830103000', N'140830000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3915', N'永乐镇', N'140830104000', N'140830000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3916', N'大王镇', N'140830105000', N'140830000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3917', N'阳城镇', N'140830106000', N'140830000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3918', N'东垆乡', N'140830200000', N'140830000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3919', N'南卫乡', N'140830201000', N'140830000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3920', N'学张乡', N'140830202000', N'140830000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3921', N'城镇社区管理委员会', N'140830401000', N'140830000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3922', N'山西风陵渡经济开发区', N'140830402000', N'140830000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3923', N'城西街道办事处', N'140881001000', N'140881000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3924', N'城北街道办事处', N'140881002000', N'140881000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3925', N'城东街道办事处', N'140881003000', N'140881000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3926', N'虞乡镇', N'140881100000', N'140881000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3927', N'卿头镇', N'140881101000', N'140881000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3928', N'开张镇', N'140881102000', N'140881000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3929', N'栲栳镇', N'140881103000', N'140881000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3930', N'蒲州镇', N'140881104000', N'140881000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3931', N'韩阳镇', N'140881105000', N'140881000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3932', N'张营镇', N'140881106000', N'140881000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3933', N'伍姓湖农场', N'140881400000', N'140881000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3934', N'虞乡农场', N'140881401000', N'140881000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3935', N'董村农场', N'140881402000', N'140881000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3936', N'城区街道办事处', N'140882001000', N'140882000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3937', N'清涧街道办事处', N'140882002000', N'140882000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3938', N'樊村镇', N'140882100000', N'140882000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3939', N'僧楼镇', N'140882101000', N'140882000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3940', N'小梁乡', N'140882200000', N'140882000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3941', N'柴家乡', N'140882201000', N'140882000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3942', N'赵家庄乡', N'140882202000', N'140882000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3943', N'下化乡', N'140882203000', N'140882000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3944', N'阳村乡', N'140882204000', N'140882000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3945', N'山西铝厂', N'140882450000', N'140882000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3946', N'秀容街道办事处', N'140902001000', N'140902000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3947', N'长征街街道办事处', N'140902002000', N'140902000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3948', N'新建路街道办事处', N'140902003000', N'140902000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3949', N'播明镇', N'140902100000', N'140902000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3950', N'奇村镇', N'140902101000', N'140902000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3951', N'三交镇', N'140902102000', N'140902000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3952', N'庄磨镇', N'140902103000', N'140902000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3953', N'豆罗镇', N'140902104000', N'140902000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3954', N'董村镇', N'140902105000', N'140902000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3955', N'曹张乡', N'140902200000', N'140902000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3956', N'高城乡', N'140902201000', N'140902000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3957', N'秦城乡', N'140902202000', N'140902000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3958', N'解原乡', N'140902203000', N'140902000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3959', N'合索乡', N'140902204000', N'140902000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3960', N'阳坡乡', N'140902205000', N'140902000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3961', N'兰村乡', N'140902206000', N'140902000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3962', N'紫岩乡', N'140902207000', N'140902000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3963', N'西张乡', N'140902208000', N'140902000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3964', N'东楼乡', N'140902209000', N'140902000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3965', N'北义井乡', N'140902210000', N'140902000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3966', N'晋昌镇', N'140921100000', N'140921000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3967', N'河边镇', N'140921101000', N'140921000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3968', N'宏道镇', N'140921102000', N'140921000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3969', N'杨芳乡', N'140921200000', N'140921000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3970', N'南王乡', N'140921201000', N'140921000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3971', N'蒋村乡', N'140921202000', N'140921000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3972', N'神山乡', N'140921203000', N'140921000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3973', N'季庄乡', N'140921204000', N'140921000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3974', N'受禄乡', N'140921205000', N'140921000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3975', N'台城镇', N'140922100000', N'140922000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3976', N'耿镇镇', N'140922102000', N'140922000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3977', N'豆村镇', N'140922103000', N'140922000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3978', N'白家庄镇', N'140922104000', N'140922000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3979', N'东冶镇', N'140922105000', N'140922000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3980', N'沟南乡', N'140922200000', N'140922000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3981', N'东雷乡', N'140922201000', N'140922000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3982', N'高洪口乡', N'140922202000', N'140922000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3983', N'门限石乡', N'140922203000', N'140922000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3984', N'陈家庄乡', N'140922204000', N'140922000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3985', N'建安乡', N'140922205000', N'140922000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3986', N'神西乡', N'140922206000', N'140922000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3987', N'蒋坊乡', N'140922207000', N'140922000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3988', N'灵境乡', N'140922208000', N'140922000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3989', N'阳白乡', N'140922209000', N'140922000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3990', N'茹村乡', N'140922210000', N'140922000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3991', N'上馆镇', N'140923100000', N'140923000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3992', N'阳明堡镇', N'140923101000', N'140923000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3993', N'峨口镇', N'140923102000', N'140923000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3994', N'聂营镇', N'140923103000', N'140923000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3995', N'枣林镇', N'140923104000', N'140923000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3996', N'滩上镇', N'140923105000', N'140923000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3997', N'新高乡', N'140923200000', N'140923000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3998', N'峪口乡', N'140923201000', N'140923000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'3999', N'上磨坊乡', N'140923202000', N'140923000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4000', N'胡峪乡', N'140923203000', N'140923000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4001', N'雁门关乡', N'140923204000', N'140923000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4002', N'繁城镇', N'140924100000', N'140924000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4003', N'砂河镇', N'140924101000', N'140924000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4004', N'大营镇', N'140924102000', N'140924000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4005', N'下茹越乡', N'140924200000', N'140924000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4006', N'杏园乡', N'140924201000', N'140924000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4007', N'光裕堡乡', N'140924202000', N'140924000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4008', N'集义庄乡', N'140924203000', N'140924000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4009', N'东山乡', N'140924204000', N'140924000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4010', N'金山铺乡', N'140924205000', N'140924000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4011', N'柏家庄乡', N'140924206000', N'140924000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4012', N'横涧乡', N'140924207000', N'140924000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4013', N'神堂堡乡', N'140924208000', N'140924000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4014', N'岩头乡', N'140924209000', N'140924000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4015', N'繁峙县城居民办事处', N'140924401000', N'140924000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4016', N'凤凰镇', N'140925100000', N'140925000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4017', N'阳方口镇', N'140925101000', N'140925000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4018', N'东寨镇', N'140925102000', N'140925000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4019', N'石家庄镇', N'140925103000', N'140925000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4020', N'薛家洼乡', N'140925200000', N'140925000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4021', N'余庄乡', N'140925201000', N'140925000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4022', N'涔山乡', N'140925202000', N'140925000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4023', N'化北屯乡', N'140925203000', N'140925000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4024', N'西马坊乡', N'140925204000', N'140925000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4025', N'新堡乡', N'140925205000', N'140925000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4026', N'迭台寺乡', N'140925206000', N'140925000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4027', N'圪廖乡', N'140925207000', N'140925000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4028', N'怀道乡', N'140925208000', N'140925000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4029', N'东马坊乡', N'140925209000', N'140925000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4030', N'阳方口煤矿生活区', N'140925400000', N'140925000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4031', N'城区居民办事处', N'140925401000', N'140925000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4032', N'鹅城镇', N'140926100000', N'140926000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4033', N'杜家村镇', N'140926101000', N'140926000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4034', N'康家会镇', N'140926102000', N'140926000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4035', N'丰润镇', N'140926103000', N'140926000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4036', N'堂尔上乡', N'140926201000', N'140926000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4037', N'中庄乡', N'140926202000', N'140926000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4038', N'双路乡', N'140926203000', N'140926000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4039', N'段家寨乡', N'140926204000', N'140926000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4040', N'辛村乡', N'140926205000', N'140926000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4041', N'王村乡', N'140926206000', N'140926000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4042', N'神峪沟乡', N'140926207000', N'140926000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4043', N'娘子神乡', N'140926208000', N'140926000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4044', N'娑婆乡', N'140926209000', N'140926000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4045', N'赤泥洼乡', N'140926210000', N'140926000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4046', N'龙泉镇', N'140927100000', N'140927000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4047', N'义井镇', N'140927101000', N'140927000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4048', N'八角镇', N'140927102000', N'140927000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4049', N'东湖乡', N'140927200000', N'140927000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4050', N'太平庄乡', N'140927201000', N'140927000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4051', N'虎北乡', N'140927202000', N'140927000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4052', N'贺职乡', N'140927203000', N'140927000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4053', N'长畛乡', N'140927204000', N'140927000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4054', N'烈堡乡', N'140927205000', N'140927000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4055', N'大严备乡', N'140927206000', N'140927000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4056', N'砚城镇', N'140928100000', N'140928000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4057', N'小河头镇', N'140928101000', N'140928000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4058', N'三岔镇', N'140928102000', N'140928000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4059', N'前所乡', N'140928200000', N'140928000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4060', N'李家坪乡', N'140928201000', N'140928000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4061', N'孙家坪乡', N'140928202000', N'140928000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4062', N'梁家坪乡', N'140928203000', N'140928000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4063', N'胡会乡', N'140928204000', N'140928000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4064', N'新寨乡', N'140928205000', N'140928000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4065', N'韩家楼乡', N'140928206000', N'140928000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4066', N'东秀庄乡', N'140928207000', N'140928000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4067', N'杏岭子乡', N'140928208000', N'140928000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4068', N'岚漪镇', N'140929100000', N'140929000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4069', N'三井镇', N'140929101000', N'140929000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4070', N'神堂坪乡', N'140929200000', N'140929000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4071', N'高家会乡', N'140929201000', N'140929000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4072', N'李家沟乡', N'140929202000', N'140929000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4073', N'水峪贯乡', N'140929203000', N'140929000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4074', N'西豹峪乡', N'140929204000', N'140929000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4075', N'温泉乡', N'140929205000', N'140929000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4076', N'阳坪乡', N'140929206000', N'140929000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4077', N'大涧乡', N'140929207000', N'140929000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4078', N'宋家沟乡', N'140929208000', N'140929000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4079', N'王家岔乡', N'140929209000', N'140929000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4080', N'文笔镇', N'140930100000', N'140930000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4081', N'楼子营镇', N'140930101000', N'140930000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4082', N'刘家塔镇', N'140930102000', N'140930000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4083', N'巡镇镇', N'140930103000', N'140930000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4084', N'鹿固乡', N'140930200000', N'140930000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4085', N'前川乡', N'140930201000', N'140930000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4086', N'单寨乡', N'140930202000', N'140930000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4087', N'土沟乡', N'140930203000', N'140930000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4088', N'旧县乡', N'140930204000', N'140930000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4089', N'沙坪乡', N'140930205000', N'140930000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4090', N'社梁乡', N'140930206000', N'140930000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4091', N'沙泉乡', N'140930207000', N'140930000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4092', N'赵家沟乡', N'140930208000', N'140930000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4093', N'河曲县居民办事处', N'140930400000', N'140930000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4094', N'东关镇', N'140931100000', N'140931000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4095', N'义门镇', N'140931101000', N'140931000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4096', N'桥头镇', N'140931102000', N'140931000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4097', N'杨家湾镇', N'140931103000', N'140931000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4098', N'腰庄乡', N'140931200000', N'140931000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4099', N'韩家川乡', N'140931201000', N'140931000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4100', N'林遮峪乡', N'140931202000', N'140931000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4101', N'冯家川乡', N'140931203000', N'140931000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4102', N'土崖塔乡', N'140931204000', N'140931000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4103', N'孙家沟乡', N'140931205000', N'140931000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4104', N'窑洼乡', N'140931206000', N'140931000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4105', N'窑圪台乡', N'140931207000', N'140931000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4106', N'南河沟乡', N'140931208000', N'140931000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4107', N'新关镇', N'140932100000', N'140932000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4108', N'天峰坪镇', N'140932101000', N'140932000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4109', N'老营镇', N'140932102000', N'140932000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4110', N'万家寨镇', N'140932103000', N'140932000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4111', N'窑头乡', N'140932200000', N'140932000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4112', N'楼沟乡', N'140932201000', N'140932000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4113', N'尚峪乡', N'140932202000', N'140932000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4114', N'南堡子乡', N'140932203000', N'140932000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4115', N'水泉乡', N'140932204000', N'140932000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4116', N'陈家营乡', N'140932205000', N'140932000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4117', N'台怀镇', N'140971100000', N'140971000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4118', N'金岗库乡', N'140971200000', N'140971000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4119', N'石咀乡', N'140971201000', N'140971000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4120', N'北城街道办事处', N'140981001000', N'140981000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4121', N'南城街道办事处', N'140981002000', N'140981000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4122', N'轩煤矿区街道办事处', N'140981003000', N'140981000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4123', N'东社镇', N'140981100000', N'140981000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4124', N'苏龙口镇', N'140981101000', N'140981000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4125', N'崞阳镇', N'140981102000', N'140981000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4126', N'大牛店镇', N'140981103000', N'140981000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4127', N'闫庄镇', N'140981104000', N'140981000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4128', N'长梁沟镇', N'140981105000', N'140981000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4129', N'轩岗镇', N'140981106000', N'140981000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4130', N'新原乡', N'140981200000', N'140981000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4131', N'南白乡', N'140981201000', N'140981000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4132', N'子干乡', N'140981202000', N'140981000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4133', N'中阳乡', N'140981203000', N'140981000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4134', N'沿沟乡', N'140981204000', N'140981000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4135', N'大林乡', N'140981205000', N'140981000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4136', N'西镇乡', N'140981206000', N'140981000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4137', N'解村乡', N'140981207000', N'140981000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4138', N'王家庄乡', N'140981208000', N'140981000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4139', N'楼板寨乡', N'140981209000', N'140981000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4140', N'段家堡乡', N'140981210000', N'140981000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4141', N'山西鲁能晋北铝业工矿区', N'140981400000', N'140981000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4142', N'原平市石豹沟煤矿工矿区', N'140981401000', N'140981000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4143', N'原平农场', N'140981403000', N'140981000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4144', N'解放路街道办事处', N'141002001000', N'141002000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4145', N'鼓楼西街街道办事处', N'141002002000', N'141002000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4146', N'水塔街街道办事处', N'141002003000', N'141002000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4147', N'南街街道办事处', N'141002004000', N'141002000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4148', N'乡贤街街道办事处', N'141002005000', N'141002000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4149', N'辛寺街街道办事处', N'141002006000', N'141002000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4150', N'铁路东街道办事处', N'141002007000', N'141002000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4151', N'车站街街道办事处', N'141002008000', N'141002000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4152', N'汾河街道办事处', N'141002009000', N'141002000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4153', N'滨河办事处', N'141002010000', N'141002000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4154', N'屯里镇', N'141002100000', N'141002000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4155', N'乔李镇', N'141002101000', N'141002000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4156', N'大阳镇', N'141002102000', N'141002000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4157', N'县底镇', N'141002103000', N'141002000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4158', N'刘村镇', N'141002104000', N'141002000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4159', N'金殿镇', N'141002105000', N'141002000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4160', N'吴村镇', N'141002106000', N'141002000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4161', N'土门镇', N'141002107000', N'141002000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4162', N'魏村镇', N'141002108000', N'141002000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4163', N'尧庙镇', N'141002109000', N'141002000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4164', N'段店乡', N'141002200000', N'141002000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4165', N'贾得乡', N'141002201000', N'141002000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4166', N'贺家庄乡', N'141002202000', N'141002000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4167', N'一平垣乡', N'141002203000', N'141002000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4168', N'枕头乡', N'141002204000', N'141002000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4169', N'河底乡', N'141002205000', N'141002000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4170', N'乐昌镇', N'141021100000', N'141021000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4171', N'史村镇', N'141021101000', N'141021000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4172', N'曲村镇', N'141021102000', N'141021000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4173', N'高显镇', N'141021103000', N'141021000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4174', N'里村镇', N'141021104000', N'141021000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4175', N'北董乡', N'141021200000', N'141021000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4176', N'杨谈乡', N'141021201000', N'141021000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4177', N'唐兴镇', N'141022100000', N'141022000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4178', N'南梁镇', N'141022101000', N'141022000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4179', N'里砦镇', N'141022102000', N'141022000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4180', N'隆化镇', N'141022103000', N'141022000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4181', N'桥上镇', N'141022104000', N'141022000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4182', N'西阎镇', N'141022105000', N'141022000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4183', N'中卫乡', N'141022200000', N'141022000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4184', N'南唐乡', N'141022201000', N'141022000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4185', N'王庄乡', N'141022202000', N'141022000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4186', N'浇底乡', N'141022203000', N'141022000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4187', N'新城镇', N'141023100000', N'141023000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4188', N'赵康镇', N'141023101000', N'141023000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4189', N'汾城镇', N'141023102000', N'141023000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4190', N'南贾镇', N'141023103000', N'141023000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4191', N'古城镇', N'141023104000', N'141023000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4192', N'襄陵镇', N'141023105000', N'141023000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4193', N'邓庄镇', N'141023106000', N'141023000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4194', N'陶寺乡', N'141023200000', N'141023000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4195', N'永固乡', N'141023201000', N'141023000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4196', N'景毛乡', N'141023202000', N'141023000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4197', N'西贾乡', N'141023203000', N'141023000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4198', N'南辛店乡', N'141023204000', N'141023000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4199', N'大邓乡', N'141023205000', N'141023000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4200', N'大槐树镇', N'141024100000', N'141024000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4201', N'甘亭镇', N'141024101000', N'141024000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4202', N'曲亭镇', N'141024102000', N'141024000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4203', N'苏堡镇', N'141024103000', N'141024000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4204', N'广胜寺镇', N'141024104000', N'141024000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4205', N'明姜镇', N'141024105000', N'141024000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4206', N'赵城镇', N'141024106000', N'141024000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4207', N'万安镇', N'141024107000', N'141024000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4208', N'刘家垣镇', N'141024108000', N'141024000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4209', N'淹底乡', N'141024200000', N'141024000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4210', N'兴唐寺乡', N'141024201000', N'141024000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4211', N'堤村乡', N'141024202000', N'141024000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4212', N'辛村乡', N'141024203000', N'141024000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4213', N'龙马乡', N'141024204000', N'141024000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4214', N'山头乡', N'141024205000', N'141024000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4215', N'左木乡', N'141024206000', N'141024000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4216', N'岳阳镇', N'141025100000', N'141025000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4217', N'北平镇', N'141025101000', N'141025000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4218', N'古阳镇', N'141025102000', N'141025000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4219', N'旧县镇', N'141025103000', N'141025000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4220', N'石壁乡', N'141025200000', N'141025000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4221', N'永乐乡', N'141025201000', N'141025000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4222', N'南垣乡', N'141025202000', N'141025000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4223', N'府城镇', N'141026100000', N'141026000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4224', N'和川镇', N'141026101000', N'141026000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4225', N'唐城镇', N'141026102000', N'141026000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4226', N'冀氏镇', N'141026103000', N'141026000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4227', N'马必乡', N'141026200000', N'141026000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4228', N'杜村乡', N'141026201000', N'141026000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4229', N'良马乡', N'141026202000', N'141026000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4230', N'天坛镇', N'141027100000', N'141027000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4231', N'响水河镇', N'141027101000', N'141027000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4232', N'张庄乡', N'141027200000', N'141027000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4233', N'东张乡', N'141027201000', N'141027000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4234', N'槐埝乡', N'141027202000', N'141027000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4235', N'北王乡', N'141027203000', N'141027000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4236', N'北韩乡', N'141027204000', N'141027000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4237', N'米家垣乡', N'141027205000', N'141027000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4238', N'寨圪塔乡', N'141027206000', N'141027000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4239', N'吉昌镇', N'141028100000', N'141028000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4240', N'屯里镇', N'141028101000', N'141028000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4241', N'壶口镇', N'141028102000', N'141028000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4242', N'车城乡', N'141028200000', N'141028000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4243', N'文城乡', N'141028201000', N'141028000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4244', N'东城乡', N'141028202000', N'141028000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4245', N'柏山寺乡', N'141028203000', N'141028000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4246', N'中垛乡', N'141028204000', N'141028000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4247', N'昌宁镇', N'141029100000', N'141029000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4248', N'光华镇', N'141029101000', N'141029000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4249', N'台头镇', N'141029102000', N'141029000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4250', N'管头镇', N'141029103000', N'141029000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4251', N'西坡镇', N'141029104000', N'141029000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4252', N'双鹤乡', N'141029200000', N'141029000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4253', N'关王庙乡', N'141029201000', N'141029000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4254', N'尉庄乡', N'141029202000', N'141029000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4255', N'西交口乡', N'141029203000', N'141029000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4256', N'枣岭乡', N'141029204000', N'141029000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4257', N'昕水镇', N'141030100000', N'141030000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4258', N'曲峨镇', N'141030101000', N'141030000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4259', N'三多乡', N'141030200000', N'141030000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4260', N'太德乡', N'141030201000', N'141030000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4261', N'徐家垛乡', N'141030202000', N'141030000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4262', N'太古乡', N'141030203000', N'141030000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4263', N'龙泉镇', N'141031100000', N'141031000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4264', N'午城镇', N'141031101000', N'141031000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4265', N'黄土镇', N'141031102000', N'141031000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4266', N'阳头升乡', N'141031200000', N'141031000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4267', N'寨子乡', N'141031201000', N'141031000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4268', N'陡坡乡', N'141031202000', N'141031000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4269', N'下李乡', N'141031203000', N'141031000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4270', N'城南乡', N'141031204000', N'141031000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4271', N'芝河镇', N'141032100000', N'141032000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4272', N'桑壁镇', N'141032101000', N'141032000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4273', N'阁底乡', N'141032200000', N'141032000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4274', N'南庄乡', N'141032201000', N'141032000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4275', N'打石腰乡', N'141032202000', N'141032000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4276', N'坡头乡', N'141032203000', N'141032000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4277', N'交口乡', N'141032204000', N'141032000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4278', N'蒲城镇', N'141033100000', N'141033000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4279', N'薛关镇', N'141033101000', N'141033000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4280', N'黑龙关镇', N'141033102000', N'141033000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4281', N'克城镇', N'141033103000', N'141033000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4282', N'山中乡', N'141033200000', N'141033000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4283', N'古县乡', N'141033201000', N'141033000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4284', N'红道乡', N'141033202000', N'141033000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4285', N'乔家湾乡', N'141033203000', N'141033000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4286', N'太林乡', N'141033204000', N'141033000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4287', N'永安镇', N'141034100000', N'141034000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4288', N'对竹镇', N'141034101000', N'141034000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4289', N'勍香镇', N'141034102000', N'141034000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4290', N'和平镇', N'141034103000', N'141034000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4291', N'僧念镇', N'141034104000', N'141034000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4292', N'佃坪乡', N'141034200000', N'141034000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4293', N'团柏乡', N'141034201000', N'141034000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4294', N'邢家要乡', N'141034202000', N'141034000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4295', N'社区管理委员会', N'141034400000', N'141034000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4296', N'路东街道办事处', N'141081001000', N'141081000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4297', N'路西街道办事处', N'141081002000', N'141081000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4298', N'浍滨街道办事处', N'141081003000', N'141081000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4299', N'上马街道办事处', N'141081004000', N'141081000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4300', N'张村街道办事处', N'141081005000', N'141081000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4301', N'新田乡', N'141081200000', N'141081000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4302', N'高村乡', N'141081201000', N'141081000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4303', N'凤城乡', N'141081202000', N'141081000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4304', N'鼓楼街道办事处', N'141082001000', N'141082000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4305', N'北环路街道办事处', N'141082002000', N'141082000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4306', N'南环路街道办事处', N'141082003000', N'141082000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4307', N'开元街道办事处', N'141082004000', N'141082000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4308', N'退沙街道办事处', N'141082005000', N'141082000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4309', N'白龙镇', N'141082100000', N'141082000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4310', N'辛置镇', N'141082101000', N'141082000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4311', N'大张镇', N'141082102000', N'141082000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4312', N'李曹镇', N'141082103000', N'141082000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4313', N'陶唐峪乡', N'141082200000', N'141082000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4314', N'三教乡', N'141082201000', N'141082000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4315', N'师庄乡', N'141082202000', N'141082000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4316', N'滨河街道办事处', N'141102001000', N'141102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4317', N'凤山街道办事处', N'141102002000', N'141102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4318', N'莲花池街道办事处', N'141102003000', N'141102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4319', N'城北街道办事处', N'141102004000', N'141102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4320', N'田家会街道办事处', N'141102005000', N'141102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4321', N'交口街道办事处', N'141102006000', N'141102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4322', N'西属巴街道办事处', N'141102007000', N'141102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4323', N'吴城镇', N'141102100000', N'141102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4324', N'信义镇', N'141102101000', N'141102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4325', N'红眼川乡', N'141102200000', N'141102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4326', N'枣林乡', N'141102201000', N'141102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4327', N'坪头乡', N'141102202000', N'141102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4328', N'凤城镇', N'141121100000', N'141121000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4329', N'开栅镇', N'141121101000', N'141121000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4330', N'南庄镇', N'141121102000', N'141121000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4331', N'南安镇', N'141121103000', N'141121000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4332', N'刘胡兰镇', N'141121104000', N'141121000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4333', N'下曲镇', N'141121105000', N'141121000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4334', N'孝义镇', N'141121106000', N'141121000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4335', N'南武乡', N'141121200000', N'141121000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4336', N'西城乡', N'141121201000', N'141121000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4337', N'北张乡', N'141121202000', N'141121000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4338', N'马西乡', N'141121203000', N'141121000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4339', N'西槽头乡', N'141121204000', N'141121000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4340', N'天宁镇', N'141122100000', N'141122000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4341', N'夏家营镇', N'141122101000', N'141122000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4342', N'西营镇', N'141122102000', N'141122000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4343', N'水峪贯镇', N'141122103000', N'141122000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4344', N'西社镇', N'141122104000', N'141122000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4345', N'庞泉沟镇', N'141122105000', N'141122000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4346', N'洪相乡', N'141122200000', N'141122000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4347', N'岭底乡', N'141122201000', N'141122000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4348', N'东坡底乡', N'141122202000', N'141122000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4349', N'会立乡', N'141122203000', N'141122000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4350', N'夏家营生态工业园区管委会', N'141122400000', N'141122000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4351', N'蔚汾镇', N'141123100000', N'141123000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4352', N'魏家滩镇', N'141123101000', N'141123000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4353', N'瓦塘镇', N'141123102000', N'141123000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4354', N'康宁镇', N'141123103000', N'141123000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4355', N'高家村镇', N'141123104000', N'141123000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4356', N'罗峪口镇', N'141123105000', N'141123000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4357', N'蔡家会镇', N'141123106000', N'141123000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4358', N'交楼申乡', N'141123200000', N'141123000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4359', N'恶虎滩乡', N'141123201000', N'141123000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4360', N'东会乡', N'141123202000', N'141123000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4361', N'固贤乡', N'141123203000', N'141123000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4362', N'奥家湾乡', N'141123204000', N'141123000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4363', N'蔡家崖乡', N'141123205000', N'141123000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4364', N'贺家会乡', N'141123206000', N'141123000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4365', N'孟家坪乡', N'141123207000', N'141123000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4366', N'赵家坪乡', N'141123208000', N'141123000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4367', N'圪垯上乡', N'141123209000', N'141123000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4368', N'兴县经济技术开发区', N'141123400000', N'141123000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4369', N'临泉镇', N'141124100000', N'141124000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4370', N'白文镇', N'141124101000', N'141124000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4371', N'城庄镇', N'141124102000', N'141124000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4372', N'兔坂镇', N'141124103000', N'141124000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4373', N'克虎镇', N'141124104000', N'141124000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4374', N'三交镇', N'141124105000', N'141124000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4375', N'湍水头镇', N'141124106000', N'141124000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4376', N'林家坪镇', N'141124107000', N'141124000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4377', N'招贤镇', N'141124108000', N'141124000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4378', N'碛口镇', N'141124109000', N'141124000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4379', N'刘家会镇', N'141124110000', N'141124000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4380', N'丛罗峪镇', N'141124111000', N'141124000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4381', N'曲峪镇', N'141124112000', N'141124000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4382', N'木瓜坪乡', N'141124200000', N'141124000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4383', N'安业乡', N'141124201000', N'141124000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4384', N'玉坪乡', N'141124202000', N'141124000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4385', N'青凉寺乡', N'141124203000', N'141124000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4386', N'石白头乡', N'141124204000', N'141124000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4387', N'雷家碛乡', N'141124205000', N'141124000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4388', N'八堡乡', N'141124206000', N'141124000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4389', N'大禹乡', N'141124207000', N'141124000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4390', N'车赶乡', N'141124208000', N'141124000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4391', N'安家庄乡', N'141124209000', N'141124000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4392', N'柳林镇', N'141125100000', N'141125000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4393', N'穆村镇', N'141125101000', N'141125000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4394', N'薛村镇', N'141125102000', N'141125000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4395', N'庄上镇', N'141125103000', N'141125000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4396', N'留誉镇', N'141125104000', N'141125000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4397', N'三交镇', N'141125105000', N'141125000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4398', N'成家庄镇', N'141125106000', N'141125000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4399', N'孟门镇', N'141125107000', N'141125000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4400', N'李家湾乡', N'141125200000', N'141125000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4401', N'贾家垣乡', N'141125201000', N'141125000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4402', N'陈家湾乡', N'141125202000', N'141125000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4403', N'金家庄乡', N'141125203000', N'141125000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4404', N'高家沟乡', N'141125204000', N'141125000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4405', N'石西乡', N'141125205000', N'141125000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4406', N'王家沟乡', N'141125206000', N'141125000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4407', N'灵泉镇', N'141126100000', N'141126000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4408', N'罗村镇', N'141126101000', N'141126000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4409', N'义牒镇', N'141126102000', N'141126000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4410', N'小蒜镇', N'141126103000', N'141126000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4411', N'龙交乡', N'141126200000', N'141126000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4412', N'和合乡', N'141126201000', N'141126000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4413', N'前山乡', N'141126202000', N'141126000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4414', N'曹家垣乡', N'141126203000', N'141126000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4415', N'裴沟乡', N'141126204000', N'141126000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4416', N'东村镇', N'141127100000', N'141127000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4417', N'岚城镇', N'141127101000', N'141127000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4418', N'普明镇', N'141127102000', N'141127000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4419', N'界河口镇', N'141127103000', N'141127000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4420', N'土峪乡', N'141127200000', N'141127000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4421', N'上明乡', N'141127201000', N'141127000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4422', N'王狮乡', N'141127202000', N'141127000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4423', N'梁家庄乡', N'141127203000', N'141127000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4424', N'顺会乡', N'141127204000', N'141127000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4425', N'河口乡', N'141127205000', N'141127000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4426', N'社科乡', N'141127206000', N'141127000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4427', N'大蛇头乡', N'141127207000', N'141127000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4428', N'岚县普明工业园区', N'141127400000', N'141127000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4429', N'圪洞镇', N'141128100000', N'141128000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4430', N'马坊镇', N'141128101000', N'141128000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4431', N'峪口镇', N'141128102000', N'141128000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4432', N'大武镇', N'141128103000', N'141128000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4433', N'北武当镇', N'141128104000', N'141128000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4434', N'积翠乡', N'141128200000', N'141128000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4435', N'麻地会乡', N'141128201000', N'141128000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4436', N'宁乡镇', N'141129100000', N'141129000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4437', N'金罗镇', N'141129101000', N'141129000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4438', N'枝柯镇', N'141129102000', N'141129000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4439', N'武家庄镇', N'141129103000', N'141129000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4440', N'暖泉镇', N'141129104000', N'141129000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4441', N'下枣林乡', N'141129201000', N'141129000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4442', N'车鸣峪乡', N'141129202000', N'141129000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4443', N'水头镇', N'141130100000', N'141130000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4444', N'康城镇', N'141130101000', N'141130000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4445', N'双池镇', N'141130102000', N'141130000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4446', N'桃红坡镇', N'141130103000', N'141130000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4447', N'石口乡', N'141130200000', N'141130000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4448', N'回龙乡', N'141130201000', N'141130000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4449', N'温泉乡', N'141130202000', N'141130000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4450', N'新义街道办事处', N'141181001000', N'141181000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4451', N'中阳楼街道办事处', N'141181002000', N'141181000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4452', N'振兴街道办事处', N'141181003000', N'141181000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4453', N'胜溪湖街道办事处', N'141181004000', N'141181000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4454', N'崇文街道办事处', N'141181005000', N'141181000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4455', N'兑镇镇', N'141181100000', N'141181000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4456', N'阳泉曲镇', N'141181101000', N'141181000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4457', N'下堡镇', N'141181102000', N'141181000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4458', N'西辛庄镇', N'141181103000', N'141181000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4459', N'高阳镇', N'141181104000', N'141181000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4460', N'梧桐镇', N'141181105000', N'141181000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4461', N'柱濮镇', N'141181106000', N'141181000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4462', N'大孝堡乡', N'141181200000', N'141181000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4463', N'下栅乡', N'141181201000', N'141181000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4464', N'驿马乡', N'141181202000', N'141181000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4465', N'南阳乡', N'141181203000', N'141181000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4466', N'杜村乡', N'141181204000', N'141181000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4467', N'文峰街道办事处', N'141182001000', N'141182000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4468', N'太和桥街道办事处', N'141182002000', N'141182000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4469', N'贾家庄镇', N'141182100000', N'141182000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4470', N'杏花村镇', N'141182101000', N'141182000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4471', N'冀村镇', N'141182102000', N'141182000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4472', N'肖家庄镇', N'141182103000', N'141182000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4473', N'演武镇', N'141182104000', N'141182000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4474', N'三泉镇', N'141182105000', N'141182000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4475', N'石庄镇', N'141182106000', N'141182000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4476', N'杨家庄镇', N'141182107000', N'141182000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4477', N'峪道河镇', N'141182108000', N'141182000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4478', N'西河乡', N'141182200000', N'141182000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4479', N'阳城乡', N'141182201000', N'141182000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4480', N'栗家庄乡', N'141182202000', N'141182000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4481', N'南薰街道办事处', N'141182400000', N'141182000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4482', N'辰北街道办事处', N'141182401000', N'141182000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4483', N'海拉尔东路街道办事处', N'150102001000', N'150102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4484', N'锡林路街道办事处', N'150102002000', N'150102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4485', N'中山东路街道办事处', N'150102003000', N'150102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4486', N'东街街道办事处', N'150102004000', N'150102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4487', N'西街街道办事处', N'150102005000', N'150102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4488', N'东风路街道办事处', N'150102006000', N'150102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4489', N'迎新路街道办事处', N'150102007000', N'150102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4490', N'成吉思汗大街街道办事处', N'150102008000', N'150102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4491', N'保合少镇', N'150102101000', N'150102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4492', N'新城区鸿盛高科技园区', N'150102400000', N'150102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4493', N'新华西路办事处', N'150103001000', N'150103000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4494', N'中山西路办事处', N'150103002000', N'150103000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4495', N'光明路办事处', N'150103003000', N'150103000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4496', N'海拉尔西路办事处', N'150103004000', N'150103000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4497', N'环河街办事处', N'150103005000', N'150103000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4498', N'通道街办事处', N'150103006000', N'150103000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4499', N'钢铁路办事处', N'150103007000', N'150103000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4500', N'攸攸板镇', N'150103100000', N'150103000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4501', N'小召前街办事处', N'150104001000', N'150104000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4502', N'兴隆巷办事处', N'150104002000', N'150104000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4503', N'长和廊办事处', N'150104003000', N'150104000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4504', N'石东路办事处', N'150104004000', N'150104000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4505', N'大南街办事处', N'150104005000', N'150104000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4506', N'鄂尔多斯路办事处', N'150104006000', N'150104000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4507', N'西菜园办事处', N'150104007000', N'150104000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4508', N'昭君路办事处', N'150104008000', N'150104000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4509', N'小黑河镇', N'150104100000', N'150104000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4510', N'裕隆工业园区', N'150104400000', N'150104000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4511', N'人民路街道办事处', N'150105001000', N'150105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4512', N'大学西路街道办事处', N'150105002000', N'150105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4513', N'乌兰察布东路街道办事处', N'150105003000', N'150105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4514', N'大学东路街道办事处', N'150105004000', N'150105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4515', N'中专路街道办事处', N'150105005000', N'150105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4516', N'昭乌达路街道办事处', N'150105006000', N'150105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4517', N'巴彦街道办事处', N'150105007000', N'150105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4518', N'敕勒川路街道办事处', N'150105008000', N'150105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4519', N'榆林镇', N'150105101000', N'150105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4520', N'黄合少镇', N'150105103000', N'150105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4521', N'金河镇', N'150105104000', N'150105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4522', N'金桥经济技术开发区', N'150105400000', N'150105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4523', N'察素齐镇', N'150121100000', N'150121000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4524', N'毕克齐镇', N'150121101000', N'150121000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4525', N'善岱镇', N'150121102000', N'150121000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4526', N'台阁牧镇', N'150121103000', N'150121000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4527', N'白庙子镇', N'150121104000', N'150121000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4528', N'沙尔沁镇', N'150121105000', N'150121000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4529', N'敕勒川镇', N'150121106000', N'150121000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4530', N'北什轴乡', N'150121207000', N'150121000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4531', N'塔布赛乡', N'150121208000', N'150121000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4532', N'呼和浩特金山经济技术开发区', N'150121401000', N'150121000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4533', N'双河镇', N'150122100000', N'150122000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4534', N'新营子镇', N'150122101000', N'150122000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4535', N'五申镇', N'150122102000', N'150122000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4536', N'伍什家镇', N'150122103000', N'150122000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4537', N'古城镇', N'150122104000', N'150122000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4538', N'托县工业园区', N'150122400000', N'150122000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4539', N'城关镇', N'150123100000', N'150123000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4540', N'盛乐镇', N'150123101000', N'150123000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4541', N'新店子镇', N'150123102000', N'150123000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4542', N'舍必崖乡', N'150123203000', N'150123000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4543', N'大红城乡', N'150123205000', N'150123000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4544', N'羊群沟乡', N'150123206000', N'150123000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4545', N'黑老夭乡', N'150123207000', N'150123000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4546', N'巧什营乡', N'150123208000', N'150123000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4547', N'盛乐经济工业园区', N'150123400000', N'150123000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4548', N'城关镇', N'150124100000', N'150124000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4549', N'宏河镇', N'150124101000', N'150124000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4550', N'喇嘛湾镇', N'150124102000', N'150124000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4551', N'老牛湾镇', N'150124103000', N'150124000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4552', N'窑沟乡', N'150124200000', N'150124000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4553', N'北堡乡', N'150124201000', N'150124000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4554', N'韮菜庄乡', N'150124202000', N'150124000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4555', N'五良太乡', N'150124203000', N'150124000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4556', N'可可以力更镇', N'150125100000', N'150125000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4557', N'哈乐镇', N'150125101000', N'150125000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4558', N'西乌兰不浪镇', N'150125102000', N'150125000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4559', N'大青山乡', N'150125200000', N'150125000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4560', N'上秃亥乡', N'150125205000', N'150125000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4561', N'得胜沟乡', N'150125207000', N'150125000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4562', N'二份子乡', N'150125211000', N'150125000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4563', N'哈拉合少乡', N'150125213000', N'150125000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4564', N'耗赖山乡', N'150125214000', N'150125000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4565', N'内蒙古武川经济开发区', N'150125402000', N'150125000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4566', N'武川金三角经济开发区', N'150125403000', N'150125000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4567', N'金海开发区', N'150171400000', N'150171000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4568', N'如意工业园区', N'150172401000', N'150172000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4569', N'金川工业园区', N'150172402000', N'150172000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4570', N'呼和浩特出口加工区', N'150172403000', N'150172000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4571', N'呼和浩特留学人员创业园', N'150172404000', N'150172000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4572', N'沙尔沁工业区（如意南区）', N'150172405000', N'150172000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4573', N'呼和浩特白塔空港物流园区', N'150172406000', N'150172000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4574', N'和平街道办事处', N'150202001000', N'150202000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4575', N'财神庙街道办事处', N'150202002000', N'150202000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4576', N'西脑包街道办事处', N'150202003000', N'150202000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4577', N'南门外街道办事处', N'150202004000', N'150202000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4578', N'南圪洞街道办事处', N'150202005000', N'150202000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4579', N'东站街道办事处', N'150202006000', N'150202000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4580', N'回民街道办事处', N'150202007000', N'150202000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4581', N'天骄街道办事处', N'150202008000', N'150202000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4582', N'河东街道办事处', N'150202009000', N'150202000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4583', N'铁西街道办事处', N'150202010000', N'150202000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4584', N'东兴街道办事处', N'150202011000', N'150202000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4585', N'杨圪楞街道办事处', N'150202012000', N'150202000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4586', N'河东镇', N'150202100000', N'150202000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4587', N'沙尔沁镇', N'150202101000', N'150202000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4588', N'县级单位直辖村级单位（特殊镇）', N'150202198000', N'150202000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4589', N'铝业工业园区', N'150202400000', N'150202000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4590', N'少先路街道办事处', N'150203001000', N'150203000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4591', N'沼潭街道办事处', N'150203003000', N'150203000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4592', N'林荫路街道办事处', N'150203004000', N'150203000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4593', N'友谊大街街道办事处', N'150203005000', N'150203000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4594', N'阿尔丁大街街道办事处', N'150203006000', N'150203000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4595', N'团结大街街道办事处', N'150203007000', N'150203000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4596', N'鞍山道街道办事处', N'150203008000', N'150203000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4597', N'前进道街道办事处', N'150203009000', N'150203000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4598', N'市府东路街道办事处', N'150203010000', N'150203000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4599', N'白云路街道办事处', N'150203011000', N'150203000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4600', N'黄河西路街道办事处', N'150203012000', N'150203000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4601', N'昆工路街道办事处', N'150203013000', N'150203000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4602', N'昆北街道办事处', N'150203014000', N'150203000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4603', N'昆河镇', N'150203100000', N'150203000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4604', N'卜尔汉图镇', N'150203102000', N'150203000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4605', N'包钢厂区办事处', N'150203400000', N'150203000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4606', N'先锋道街道办事处', N'150204001000', N'150204000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4607', N'幸福路街道办事处', N'150204002000', N'150204000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4608', N'万青路街道办事处', N'150204003000', N'150204000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4609', N'富强路街道办事处', N'150204004000', N'150204000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4610', N'科学路街道办事处', N'150204005000', N'150204000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4611', N'青山路街道办事处', N'150204006000', N'150204000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4612', N'自由路街道办事处', N'150204007000', N'150204000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4613', N'乌素图街道办事处', N'150204008000', N'150204000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4614', N'青福镇', N'150204100000', N'150204000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4615', N'兴胜镇', N'150204101000', N'150204000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4616', N'包头市装备制造产业园区', N'150204401000', N'150204000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4617', N'石拐街道办事处', N'150205001000', N'150205000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4618', N'大发街道办事处', N'150205002000', N'150205000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4619', N'大磁街道办事处', N'150205003000', N'150205000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4620', N'五当沟街道办事处', N'150205004000', N'150205000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4621', N'白狐沟街道办事处', N'150205005000', N'150205000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4622', N'大德恒办事处', N'150205006000', N'150205000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4623', N'五当召镇', N'150205101000', N'150205000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4624', N'吉忽伦图苏木', N'150205202000', N'150205000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4625', N'工业园区管理委员会', N'150205400000', N'150205000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4626', N'矿山路街道办事处', N'150206001000', N'150206000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4627', N'通阳道街道办事处', N'150206002000', N'150206000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4628', N'沙河街道办事处', N'150207001000', N'150207000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4629', N'赛汗街道办事处', N'150207002000', N'150207000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4630', N'萨如拉街道办事处', N'150207003000', N'150207000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4631', N'白音席勒街道办事处', N'150207004000', N'150207000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4632', N'麻池镇', N'150207103000', N'150207000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4633', N'哈林格尔镇', N'150207105000', N'150207000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4634', N'哈业胡同镇', N'150207110000', N'150207000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4635', N'阿嘎如泰苏木乡', N'150207202000', N'150207000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4636', N'萨拉齐镇', N'150221104000', N'150221000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4637', N'双龙镇', N'150221105000', N'150221000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4638', N'美岱召镇', N'150221106000', N'150221000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4639', N'沟门镇', N'150221107000', N'150221000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4640', N'将军尧镇', N'150221108000', N'150221000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4641', N'海子乡', N'150221213000', N'150221000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4642', N'明沙淖乡', N'150221214000', N'150221000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4643', N'苏波盖乡', N'150221215000', N'150221000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4644', N'九峰山生态管理委员会', N'150221500000', N'150221000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4645', N'金山镇', N'150222102000', N'150222000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4646', N'西斗铺镇', N'150222103000', N'150222000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4647', N'下湿壕镇', N'150222104000', N'150222000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4648', N'银号镇', N'150222105000', N'150222000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4649', N'怀朔镇', N'150222106000', N'150222000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4650', N'兴顺西镇', N'150222107000', N'150222000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4651', N'满都拉镇', N'150223102000', N'150223000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4652', N'希拉穆仁镇', N'150223103000', N'150223000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4653', N'百灵庙镇', N'150223104000', N'150223000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4654', N'石宝镇', N'150223105000', N'150223000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4655', N'乌克忽洞镇', N'150223106000', N'150223000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4656', N'明安镇', N'150223107000', N'150223000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4657', N'巴音花镇', N'150223108000', N'150223000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4658', N'达尔罕苏木乡', N'150223213000', N'150223000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4659', N'查干哈达苏木', N'150223214000', N'150223000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4660', N'巴音敖包苏木', N'150223215000', N'150223000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4661', N'西河乡', N'150223216000', N'150223000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4662', N'小文公乡', N'150223217000', N'150223000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4663', N'稀土路街道办事处', N'150271010000', N'150271000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4664', N'民馨路街道办事处', N'150271020000', N'150271000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4665', N'万水泉镇', N'150271102000', N'150271000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4666', N'凤凰岭街道办事处', N'150302001000', N'150302000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4667', N'海北街道办事处', N'150302002000', N'150302000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4668', N'新华街道办事处', N'150302003000', N'150302000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4669', N'新华西街道办事处', N'150302004000', N'150302000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4670', N'滨河街道办事处', N'150302007000', N'150302000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4671', N'林荫街道办事处', N'150302008000', N'150302000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4672', N'千里山镇', N'150302101000', N'150302000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4673', N'乌海市海勃湾千里山工业园区', N'150302400000', N'150302000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4674', N'拉僧仲街道办事处', N'150303001000', N'150303000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4675', N'西卓子山街道办事处', N'150303002000', N'150303000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4676', N'公乌素镇', N'150303102000', N'150303000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4677', N'拉僧庙镇', N'150303103000', N'150303000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4678', N'巴音陶亥镇', N'150303104000', N'150303000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4679', N'三道坎街道办事处', N'150304002000', N'150304000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4680', N'五虎山街道办事处', N'150304003000', N'150304000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4681', N'新达街道办事处', N'150304008000', N'150304000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4682', N'巴音赛街道办事处', N'150304009000', N'150304000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4683', N'梁家沟街道办事处', N'150304010000', N'150304000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4684', N'苏海图街道办事处', N'150304011000', N'150304000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4685', N'滨海街道办事处', N'150304012000', N'150304000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4686', N'乌兰淖尔镇', N'150304101000', N'150304000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4687', N'乌达经济开发区', N'150304400000', N'150304000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4688', N'西屯街道办事处', N'150402001000', N'150402000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4689', N'三中街街道办事处', N'150402002000', N'150402000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4690', N'永巨街道办事处', N'150402003000', N'150402000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4691', N'东城街道办事处', N'150402004000', N'150402000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4692', N'南新街街道办事处', N'150402005000', N'150402000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4693', N'站前街道办事处', N'150402006000', N'150402000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4694', N'铁南街道办事处', N'150402007000', N'150402000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4695', N'长青街道办事处', N'150402008000', N'150402000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4696', N'哈达街道办事处', N'150402009000', N'150402000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4697', N'西城街道办事处', N'150402010000', N'150402000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4698', N'桥北街道办事处', N'150402011000', N'150402000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4699', N'红庙子镇', N'150402100000', N'150402000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4700', N'文钟镇', N'150402102000', N'150402000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4701', N'红山高新技术产业园区管理委员会', N'150402400000', N'150402000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4702', N'红山物流园区', N'150402401000', N'150402000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4703', N'红山区农畜产品加工产业园区', N'150402402000', N'150402000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4704', N'西露天街道办事处', N'150403001000', N'150403000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4705', N'平庄城区街道办事处', N'150403002000', N'150403000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4706', N'平庄东城街道办事处', N'150403003000', N'150403000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4707', N'平庄西城街道办事处', N'150403004000', N'150403000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4708', N'马林街道办事处', N'150403005000', N'150403000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4709', N'云杉路街道办事处', N'150403006000', N'150403000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4710', N'风水沟镇', N'150403100000', N'150403000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4711', N'元宝山镇', N'150403101000', N'150403000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4712', N'美丽河镇', N'150403102000', N'150403000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4713', N'平庄镇', N'150403103000', N'150403000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4714', N'五家镇', N'150403104000', N'150403000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4715', N'小五家乡', N'150403200000', N'150403000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4716', N'振兴街道办事处', N'150404001000', N'150404000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4717', N'向阳街道办事处', N'150404002000', N'150404000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4718', N'松州街道办事处', N'150404003000', N'150404000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4719', N'铁东街道办事处', N'150404004000', N'150404000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4720', N'穆家营子镇', N'150404100000', N'150404000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4721', N'初头朗镇', N'150404101000', N'150404000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4722', N'大庙镇', N'150404102000', N'150404000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4723', N'王府镇', N'150404103000', N'150404000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4724', N'老府镇', N'150404104000', N'150404000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4725', N'哈拉道口镇', N'150404105000', N'150404000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4726', N'上官地镇', N'150404106000', N'150404000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4727', N'安庆镇', N'150404107000', N'150404000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4728', N'太平地镇', N'150404108000', N'150404000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4729', N'当铺地满族乡', N'150404200000', N'150404000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4730', N'夏家店乡', N'150404201000', N'150404000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4731', N'城子乡', N'150404202000', N'150404000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4732', N'大夫营子乡', N'150404203000', N'150404000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4733', N'岗子乡', N'150404204000', N'150404000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4734', N'玉龙街道办事处', N'150404400000', N'150404000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4735', N'全宁街道办事处', N'150404401000', N'150404000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4736', N'兴安街道办事处', N'150404407000', N'150404000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4737', N'天山镇', N'150421100000', N'150421000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4738', N'天山口镇', N'150421101000', N'150421000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4739', N'双胜镇', N'150421102000', N'150421000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4740', N'坤都镇', N'150421103000', N'150421000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4741', N'巴彦花镇', N'150421104000', N'150421000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4742', N'绍根镇', N'150421105000', N'150421000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4743', N'扎嘎斯台镇', N'150421106000', N'150421000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4744', N'新民乡', N'150421200000', N'150421000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4745', N'先锋乡', N'150421201000', N'150421000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4746', N'罕苏木苏木', N'150421202000', N'150421000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4747', N'赛汉塔拉苏木', N'150421203000', N'150421000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4748', N'巴拉奇如德苏木', N'150421204000', N'150421000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4749', N'乌兰哈达乡', N'150421205000', N'150421000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4750', N'巴彦温都尔苏木', N'150421206000', N'150421000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4751', N'轻工食品产业园', N'150421400000', N'150421000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4752', N'新能源产业园', N'150421401000', N'150421000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4753', N'绍根煤碳及煤化工产业园', N'150421402000', N'150421000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4754', N'罕乌拉街道办事处', N'150421403000', N'150421000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4755', N'欧沐沦街道办事处', N'150421404000', N'150421000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4756', N'林东镇', N'150422100000', N'150422000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4757', N'隆昌镇', N'150422101000', N'150422000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4758', N'十三敖包镇', N'150422102000', N'150422000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4759', N'碧流台镇', N'150422103000', N'150422000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4760', N'富河镇', N'150422104000', N'150422000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4761', N'白音勿拉镇', N'150422105000', N'150422000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4762', N'哈拉哈达镇', N'150422106000', N'150422000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4763', N'查干哈达苏木', N'150422200000', N'150422000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4764', N'乌兰达坝苏木', N'150422201000', N'150422000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4765', N'三山乡', N'150422202000', N'150422000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4766', N'花加拉嘎乡', N'150422203000', N'150422000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4767', N'上京高新技术产业集中区', N'150422400000', N'150422000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4768', N'南塔工业集中区', N'150422401000', N'150422000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4769', N'凤凰山工业集中区', N'150422402000', N'150422000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4770', N'林东西城街道办事处', N'150422403000', N'150422000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4771', N'林东东城街道办事处', N'150422404000', N'150422000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4772', N'大板镇', N'150423100000', N'150423000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4773', N'索博日嘎镇', N'150423101000', N'150423000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4774', N'宝日勿苏镇', N'150423102000', N'150423000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4775', N'查干诺尔镇', N'150423103000', N'150423000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4776', N'巴彦琥硕镇', N'150423105000', N'150423000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4777', N'西拉沐沦苏木', N'150423200000', N'150423000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4778', N'巴彦塔拉苏木', N'150423201000', N'150423000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4779', N'幸福之路苏木', N'150423202000', N'150423000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4780', N'查干沐沦苏木', N'150423203000', N'150423000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4781', N'大板煤电化基地', N'150423400000', N'150423000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4782', N'林西镇', N'150424100000', N'150424000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4783', N'新城子镇', N'150424101000', N'150424000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4784', N'新林镇', N'150424102000', N'150424000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4785', N'五十家子镇', N'150424103000', N'150424000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4786', N'官地镇', N'150424104000', N'150424000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4787', N'大井镇', N'150424105000', N'150424000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4788', N'统部镇', N'150424106000', N'150424000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4789', N'大营子乡', N'150424200000', N'150424000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4790', N'十二吐乡', N'150424201000', N'150424000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4791', N'城北街道办事处筹备处', N'150424400000', N'150424000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4792', N'城南街道办事处筹备处', N'150424401000', N'150424000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4793', N'内蒙古林西工业园区', N'150424402000', N'150424000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4794', N'经棚镇', N'150425100000', N'150425000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4795', N'宇宙地镇', N'150425101000', N'150425000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4796', N'土城子镇', N'150425102000', N'150425000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4797', N'同兴镇', N'150425103000', N'150425000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4798', N'万合永镇', N'150425104000', N'150425000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4799', N'芝瑞镇', N'150425105000', N'150425000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4800', N'达来诺日镇', N'150425106000', N'150425000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4801', N'新开地乡', N'150425200000', N'150425000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4802', N'红山子乡', N'150425201000', N'150425000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4803', N'达日罕乌拉苏木', N'150425202000', N'150425000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4804', N'巴彦查干苏木', N'150425203000', N'150425000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4805', N'浩来呼热苏木', N'150425204000', N'150425000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4806', N'乌兰布统苏木', N'150425205000', N'150425000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4807', N'应昌街道办事处', N'150425400000', N'150425000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4808', N'热水塘温泉疗养旅游开发区管委会', N'150425401000', N'150425000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4809', N'克什克腾旗煤电化基地', N'150425402000', N'150425000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4810', N'西拉沐沦街道办事处', N'150425403000', N'150425000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4811', N'克什克腾旗渔场', N'150425502000', N'150425000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4812', N'乌丹镇', N'150426100000', N'150426000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4813', N'乌敦套海镇', N'150426101000', N'150426000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4814', N'五分地镇', N'150426102000', N'150426000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4815', N'桥头镇', N'150426103000', N'150426000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4816', N'广德公镇', N'150426104000', N'150426000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4817', N'梧桐花镇', N'150426105000', N'150426000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4818', N'海拉苏镇', N'150426106000', N'150426000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4819', N'亿合公镇', N'150426107000', N'150426000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4820', N'解放营子乡', N'150426200000', N'150426000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4821', N'阿什罕苏木', N'150426201000', N'150426000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4822', N'新苏莫苏木', N'150426202000', N'150426000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4823', N'白音套海苏木', N'150426203000', N'150426000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4824', N'毛山东乡', N'150426204000', N'150426000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4825', N'格日僧苏木', N'150426205000', N'150426000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4826', N'玉龙工业园区', N'150426400000', N'150426000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4827', N'紫城街道筹备处', N'150426402000', N'150426000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4828', N'全宁街道筹备处', N'150426403000', N'150426000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4829', N'锦山镇', N'150428100000', N'150428000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4830', N'美林镇', N'150428101000', N'150428000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4831', N'王爷府镇', N'150428102000', N'150428000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4832', N'小牛群镇', N'150428103000', N'150428000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4833', N'牛家营子镇', N'150428104000', N'150428000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4834', N'乃林镇', N'150428105000', N'150428000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4835', N'西桥镇', N'150428106000', N'150428000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4836', N'十家满族乡', N'150428200000', N'150428000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4837', N'南台子乡', N'150428201000', N'150428000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4838', N'乃林果树农场', N'150428400000', N'150428000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4839', N'马鞍山羊场', N'150428401000', N'150428000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4840', N'赤峰市和美工贸园区', N'150428402000', N'150428000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4841', N'锦山工业园区', N'150428403000', N'150428000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4842', N'天义镇', N'150429100000', N'150429000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4843', N'小城子镇', N'150429101000', N'150429000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4844', N'大城子镇', N'150429102000', N'150429000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4845', N'八里罕镇', N'150429103000', N'150429000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4846', N'黑里河镇', N'150429104000', N'150429000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4847', N'右北平镇', N'150429105000', N'150429000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4848', N'大双庙镇', N'150429106000', N'150429000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4849', N'汐子镇', N'150429107000', N'150429000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4850', N'大明镇', N'150429108000', N'150429000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4851', N'忙农镇', N'150429109000', N'150429000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4852', N'五化镇', N'150429110000', N'150429000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4853', N'三座店镇', N'150429111000', N'150429000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4854', N'必斯营子镇', N'150429112000', N'150429000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4855', N'一肯中乡', N'150429202000', N'150429000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4856', N'存金沟乡', N'150429203000', N'150429000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4857', N'中京工业园', N'150429400000', N'150429000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4858', N'塞飞亚食品工业园', N'150429401000', N'150429000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4859', N'八里罕酒业园区', N'150429402000', N'150429000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4860', N'再生资源产业园', N'150429403000', N'150429000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4861', N'生物科技产业园区', N'150429404000', N'150429000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4862', N'汐子工业园', N'150429405000', N'150429000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4863', N'农机产业园区', N'150429406000', N'150429000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4864', N'新惠镇', N'150430100000', N'150430000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4865', N'四家子镇', N'150430101000', N'150430000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4866', N'长胜镇', N'150430102000', N'150430000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4867', N'贝子府镇', N'150430103000', N'150430000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4868', N'四道湾子镇', N'150430104000', N'150430000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4869', N'下洼镇', N'150430105000', N'150430000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4870', N'金厂沟梁镇', N'150430106000', N'150430000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4871', N'兴隆洼镇', N'150430107000', N'150430000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4872', N'黄羊洼镇', N'150430108000', N'150430000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4873', N'牛古吐镇', N'150430109000', N'150430000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4874', N'古鲁板蒿镇', N'150430110000', N'150430000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4875', N'木头营子乡', N'150430202000', N'150430000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4876', N'丰收乡', N'150430204000', N'150430000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4877', N'玛尼罕乡', N'150430205000', N'150430000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4878', N'萨力巴乡', N'150430206000', N'150430000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4879', N'敖润苏莫苏木', N'150430207000', N'150430000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4880', N'国营种羊场', N'150430400000', N'150430000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4881', N'敖汉旗新惠工业园区', N'150430401000', N'150430000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4882', N'贝子府化工集中区', N'150430402000', N'150430000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4883', N'四家子冶金工业集中区', N'150430403000', N'150430000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4884', N'科尔沁街道办事处', N'150502001000', N'150502000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4885', N'西门街道办事处', N'150502002000', N'150502000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4886', N'永清街道办事处', N'150502003000', N'150502000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4887', N'明仁街道办事处', N'150502004000', N'150502000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4888', N'施介街道办事处', N'150502005000', N'150502000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4889', N'清真街道办事处', N'150502006000', N'150502000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4890', N'东郊街道办事处', N'150502007000', N'150502000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4891', N'铁路街道办事处', N'150502008000', N'150502000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4892', N'红星街道办事处', N'150502009000', N'150502000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4893', N'霍林街道办事处', N'150502010000', N'150502000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4894', N'建国街道办事处', N'150502011000', N'150502000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4895', N'大林镇', N'150502100000', N'150502000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4896', N'钱家店镇', N'150502101000', N'150502000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4897', N'余粮堡镇', N'150502102000', N'150502000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4898', N'木里图镇', N'150502103000', N'150502000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4899', N'丰田镇', N'150502104000', N'150502000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4900', N'清河镇', N'150502105000', N'150502000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4901', N'育新镇', N'150502106000', N'150502000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4902', N'庆和镇', N'150502107000', N'150502000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4903', N'敖力布皋镇', N'150502108000', N'150502000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4904', N'莫力庙苏木', N'150502200000', N'150502000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4905', N'哲南农场', N'150502400000', N'150502000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4906', N'三义堂农场', N'150502401000', N'150502000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4907', N'高林屯种畜场', N'150502402000', N'150502000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4908', N'胡力海原种繁殖场', N'150502403000', N'150502000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4909', N'莫力庙羊场', N'150502404000', N'150502000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4910', N'半截店牧场', N'150502405000', N'150502000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4911', N'保康镇', N'150521100000', N'150521000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4912', N'宝龙山镇', N'150521101000', N'150521000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4913', N'舍伯吐镇', N'150521102000', N'150521000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4914', N'巴彦塔拉镇', N'150521103000', N'150521000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4915', N'门达镇', N'150521104000', N'150521000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4916', N'架玛吐镇', N'150521105000', N'150521000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4917', N'腰林毛都镇', N'150521106000', N'150521000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4918', N'希伯花镇', N'150521107000', N'150521000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4919', N'花吐古拉镇', N'150521108000', N'150521000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4920', N'代力吉镇', N'150521109000', N'150521000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4921', N'努日木镇', N'150521110000', N'150521000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4922', N'花胡硕苏木乡', N'150521200000', N'150521000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4923', N'协代苏木乡', N'150521201000', N'150521000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4924', N'白兴吐苏木乡', N'150521202000', N'150521000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4925', N'图布信苏木乡', N'150521203000', N'150521000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4926', N'敖包苏木', N'150521204000', N'150521000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4927', N'胜利乡', N'150521205000', N'150521000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4928', N'白音塔拉农场', N'150521400000', N'150521000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4929', N'珠日河牧场', N'150521401000', N'150521000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4930', N'丰库牧场', N'150521402000', N'150521000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4931', N'保康街道办事处', N'150521403000', N'150521000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4932', N'甘旗卡镇', N'150522100000', N'150522000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4933', N'吉尔嘎朗镇', N'150522101000', N'150522000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4934', N'金宝屯镇', N'150522102000', N'150522000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4935', N'常胜镇', N'150522103000', N'150522000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4936', N'查日苏镇', N'150522104000', N'150522000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4937', N'双胜镇', N'150522105000', N'150522000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4938', N'阿古拉镇', N'150522106000', N'150522000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4939', N'朝鲁吐镇', N'150522107000', N'150522000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4940', N'努古斯台镇', N'150522108000', N'150522000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4941', N'海鲁吐镇', N'150522109000', N'150522000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4942', N'阿都沁苏木', N'150522200000', N'150522000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4943', N'茂道吐苏木', N'150522201000', N'150522000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4944', N'巴嘎塔拉苏木', N'150522202000', N'150522000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4945', N'散都苏木', N'150522203000', N'150522000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4946', N'巴彦毛都苏木', N'150522204000', N'150522000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4947', N'胜利农场', N'150522400000', N'150522000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4948', N'孟根达坝牧场', N'150522401000', N'150522000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4949', N'查金台牧场', N'150522402000', N'150522000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4950', N'原种场', N'150522403000', N'150522000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4951', N'大青沟管理局', N'150522404000', N'150522000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4952', N'哈日乌苏种畜场', N'150522405000', N'150522000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4953', N'乌兰敖道渔场', N'150522406000', N'150522000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4954', N'金宝屯林场', N'150522407000', N'150522000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4955', N'朝鲁吐林场', N'150522408000', N'150522000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4956', N'茂道吐林场', N'150522409000', N'150522000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4957', N'伊胡塔林场', N'150522410000', N'150522000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4958', N'乌旦塔拉林场', N'150522411000', N'150522000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4959', N'开鲁镇', N'150523100000', N'150523000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4960', N'大榆树镇', N'150523101000', N'150523000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4961', N'黑龙坝镇', N'150523102000', N'150523000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4962', N'麦新镇', N'150523103000', N'150523000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4963', N'义和塔拉镇', N'150523104000', N'150523000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4964', N'建华镇', N'150523105000', N'150523000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4965', N'小街基镇', N'150523106000', N'150523000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4966', N'东风镇', N'150523107000', N'150523000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4967', N'吉日嘎郎吐镇', N'150523108000', N'150523000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4968', N'东来镇', N'150523109000', N'150523000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4969', N'清河牧场', N'150523400000', N'150523000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4970', N'辽河农场', N'150523401000', N'150523000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4971', N'保安农场', N'150523402000', N'150523000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4972', N'库伦镇', N'150524100000', N'150524000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4973', N'扣河子镇', N'150524101000', N'150524000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4974', N'白音花镇', N'150524102000', N'150524000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4975', N'六家子镇', N'150524103000', N'150524000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4976', N'额勒顺镇', N'150524104000', N'150524000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4977', N'茫汗苏木', N'150524200000', N'150524000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4978', N'先进苏木', N'150524201000', N'150524000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4979', N'水泉乡', N'150524202000', N'150524000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4980', N'库伦街道办事处', N'150524400000', N'150524000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4981', N'大沁他拉镇', N'150525100000', N'150525000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4982', N'八仙筒镇', N'150525101000', N'150525000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4983', N'青龙山镇', N'150525102000', N'150525000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4984', N'新镇', N'150525103000', N'150525000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4985', N'治安镇', N'150525104000', N'150525000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4986', N'东明镇', N'150525105000', N'150525000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4987', N'沙日浩来镇', N'150525106000', N'150525000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4988', N'义隆永镇', N'150525107000', N'150525000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4989', N'固日班花苏木', N'150525200000', N'150525000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4990', N'白音他拉苏木', N'150525201000', N'150525000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4991', N'明仁苏木', N'150525202000', N'150525000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4992', N'黄花塔拉苏木', N'150525203000', N'150525000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4993', N'土城子乡', N'150525204000', N'150525000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4994', N'苇莲苏乡', N'150525205000', N'150525000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4995', N'国有六号农场', N'150525400000', N'150525000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4996', N'鲁北镇', N'150526100000', N'150526000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4997', N'黄花山镇', N'150526101000', N'150526000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4998', N'嘎亥图镇', N'150526102000', N'150526000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'4999', N'巨日合镇', N'150526103000', N'150526000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5000', N'巴雅尔图胡硕镇', N'150526104000', N'150526000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5001', N'香山镇', N'150526105000', N'150526000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5002', N'阿日昆都楞镇', N'150526106000', N'150526000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5003', N'巴彦塔拉苏木乡', N'150526200000', N'150526000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5004', N'乌力吉木仁苏木乡', N'150526201000', N'150526000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5005', N'道老杜苏木乡', N'150526202000', N'150526000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5006', N'格日朝鲁苏木乡', N'150526203000', N'150526000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5007', N'前德门苏木', N'150526204000', N'150526000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5008', N'乌兰哈达苏木', N'150526205000', N'150526000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5009', N'查布嘎图苏木', N'150526206000', N'150526000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5010', N'乌额格其苏木', N'150526207000', N'150526000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5011', N'乌额格其牧场', N'150526400000', N'150526000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5012', N'香山农场', N'150526401000', N'150526000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5013', N'乌日根塔拉农场', N'150526402000', N'150526000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5014', N'嘎达苏种畜场', N'150526403000', N'150526000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5015', N'河西街道办事处', N'150571001000', N'150571000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5016', N'电厂街道办事处', N'150571002000', N'150571000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5017', N'新城街道办事处', N'150571003000', N'150571000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5018', N'滨河街道办事处', N'150571004000', N'150571000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5019', N'辽河镇', N'150571100000', N'150571000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5020', N'珠斯花街道办事处', N'150581001000', N'150581000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5021', N'莫斯台街道办事处', N'150581002000', N'150581000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5022', N'宝日呼吉尔街道办事处', N'150581003000', N'150581000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5023', N'沙尔呼热街道办事处', N'150581004000', N'150581000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5024', N'达来胡硕苏木', N'150581200000', N'150581000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5025', N'东蒙鑫农牧业有限责任公司', N'150581400000', N'150581000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5026', N'交通街道办事处', N'150602001000', N'150602000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5027', N'公园街道办事处', N'150602002000', N'150602000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5028', N'林荫街道办事处', N'150602003000', N'150602000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5029', N'建设街道办事处', N'150602004000', N'150602000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5030', N'富兴街道办事处', N'150602005000', N'150602000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5031', N'天骄街道办事处', N'150602006000', N'150602000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5032', N'诃额伦街道办事处', N'150602007000', N'150602000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5033', N'巴音门克街道办事处', N'150602008000', N'150602000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5034', N'幸福街道办事处', N'150602010000', N'150602000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5035', N'纺织街道办事处', N'150602011000', N'150602000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5036', N'兴盛街道办事处', N'150602012000', N'150602000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5037', N'民族街道办事处', N'150602013000', N'150602000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5038', N'泊尔江海子镇', N'150602100000', N'150602000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5039', N'罕台镇', N'150602101000', N'150602000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5040', N'铜川镇', N'150602102000', N'150602000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5041', N'鄂尔多斯市装备制造基地', N'150602400000', N'150602000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5042', N'东胜区轻纺工业园区', N'150602401000', N'150602000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5043', N'铜川汽车博览园', N'150602404000', N'150602000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5044', N'哈巴格希街道办事处', N'150603001000', N'150603000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5045', N'青春山街道办事处', N'150603002000', N'150603000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5046', N'滨河街道办事处', N'150603003000', N'150603000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5047', N'康新街道办事处', N'150603008000', N'150603000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5048', N'鄂尔多斯市高新技术产业园区', N'150603401000', N'150603000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5049', N'鄂尔多斯市云计算产业园区', N'150603402000', N'150603000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5050', N'工业街道办事处', N'150621001000', N'150621000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5051', N'昭君街道办事处', N'150621002000', N'150621000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5052', N'锡尼街道办事处', N'150621003000', N'150621000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5053', N'白塔街道办事处', N'150621004000', N'150621000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5054', N'西园街道办事处', N'150621005000', N'150621000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5055', N'平原街道办事处', N'150621006000', N'150621000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5056', N'树林召镇', N'150621100000', N'150621000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5057', N'吉格斯太镇', N'150621101000', N'150621000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5058', N'白泥井镇', N'150621102000', N'150621000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5059', N'王爱召镇', N'150621103000', N'150621000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5060', N'昭君镇', N'150621104000', N'150621000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5061', N'恩格贝镇', N'150621105000', N'150621000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5062', N'中和西镇', N'150621106000', N'150621000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5063', N'风水梁镇', N'150621107000', N'150621000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5064', N'展旦召苏木乡', N'150621200000', N'150621000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5065', N'达拉特经济开发区', N'150621400000', N'150621000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5066', N'鄂尔多斯市生态示范区管理委员会', N'150621401000', N'150621000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5067', N'兴隆街道', N'150622001000', N'150622000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5068', N'迎泽街道', N'150622002000', N'150622000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5069', N'蓝天街道', N'150622003000', N'150622000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5070', N'友谊街道', N'150622004000', N'150622000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5071', N'薛家湾镇', N'150622100000', N'150622000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5072', N'沙圪堵镇', N'150622101000', N'150622000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5073', N'大路镇', N'150622102000', N'150622000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5074', N'纳日松镇', N'150622103000', N'150622000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5075', N'龙口镇', N'150622104000', N'150622000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5076', N'准格尔召镇', N'150622105000', N'150622000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5077', N'魏家峁镇', N'150622106000', N'150622000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5078', N'暖水乡', N'150622200000', N'150622000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5079', N'十二连城乡', N'150622201000', N'150622000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5080', N'布尔陶亥苏木乡', N'150622202000', N'150622000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5081', N'准格尔经济开发区', N'150622400000', N'150622000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5082', N'大路煤化工基地', N'150622401000', N'150622000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5083', N'敖勒召其镇', N'150623100000', N'150623000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5084', N'上海庙镇', N'150623101000', N'150623000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5085', N'城川镇', N'150623102000', N'150623000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5086', N'昂素镇', N'150623103000', N'150623000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5087', N'上海庙经济开发区', N'150623400000', N'150623000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5088', N'乌兰镇', N'150624100000', N'150624000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5089', N'棋盘井镇', N'150624101000', N'150624000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5090', N'蒙西镇', N'150624102000', N'150624000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5091', N'木凯淖尔镇', N'150624103000', N'150624000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5092', N'苏米图苏木乡', N'150624200000', N'150624000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5093', N'阿尔巴斯苏木乡', N'150624201000', N'150624000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5094', N'蒙西工业园区', N'150624403000', N'150624000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5095', N'棋盘井工业园区', N'150624404000', N'150624000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5096', N'锡尼镇', N'150625100000', N'150625000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5097', N'巴拉贡镇', N'150625101000', N'150625000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5098', N'吉日嘎朗图镇', N'150625102000', N'150625000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5099', N'独贵特拉镇', N'150625103000', N'150625000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5100', N'呼和木独镇', N'150625104000', N'150625000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5101', N'伊和乌素苏木乡', N'150625200000', N'150625000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5102', N'杭锦旗独贵塔拉工业园区管理委员会', N'150625400000', N'150625000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5103', N'鄂尔多斯新能源产业示范区', N'150625401000', N'150625000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5104', N'嘎鲁图镇', N'150626100000', N'150626000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5105', N'乌审召镇', N'150626101000', N'150626000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5106', N'图克镇', N'150626102000', N'150626000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5107', N'乌兰陶勒盖镇', N'150626103000', N'150626000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5108', N'无定河镇', N'150626104000', N'150626000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5109', N'苏力德苏木乡', N'150626200000', N'150626000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5110', N'阿勒腾席热镇', N'150627100000', N'150627000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5111', N'札萨克镇', N'150627101000', N'150627000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5112', N'乌兰木伦镇', N'150627102000', N'150627000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5113', N'纳林陶亥镇', N'150627103000', N'150627000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5114', N'苏布尔嘎镇', N'150627104000', N'150627000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5115', N'红庆河镇', N'150627105000', N'150627000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5116', N'伊金霍洛镇', N'150627106000', N'150627000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5117', N'鄂尔多斯江苏工业园区', N'150627400000', N'150627000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5118', N'鄂尔多斯圣圆煤化工基地', N'150627403000', N'150627000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5119', N'鄂尔多斯蒙古源流文化产业园区', N'150627405000', N'150627000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5120', N'伊金霍洛旗札萨克物流园区', N'150627406000', N'150627000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5121', N'鄂尔多斯空港物流园区', N'150627407000', N'150627000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5122', N'正阳办事处', N'150702001000', N'150702000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5123', N'健康街道办事处', N'150702002000', N'150702000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5124', N'靠山街道办事处', N'150702003000', N'150702000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5125', N'胜利街道办事处', N'150702004000', N'150702000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5126', N'呼伦街道办事处', N'150702005000', N'150702000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5127', N'建设街道办事处', N'150702007000', N'150702000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5128', N'东山街道办事处', N'150702008000', N'150702000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5129', N'哈克镇', N'150702100000', N'150702000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5130', N'奋斗镇', N'150702101000', N'150702000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5131', N'第三街道办事处', N'150703001000', N'150703000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5132', N'第一街道办事处', N'150703002000', N'150703000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5133', N'第二街道办事处', N'150703003000', N'150703000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5134', N'第四街道办事处', N'150703004000', N'150703000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5135', N'第五街道办事处', N'150703005000', N'150703000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5136', N'灵泉镇', N'150703100000', N'150703000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5137', N'那吉镇', N'150721100000', N'150721000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5138', N'六合镇', N'150721101000', N'150721000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5139', N'亚东镇', N'150721102000', N'150721000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5140', N'霍尔奇镇', N'150721103000', N'150721000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5141', N'向阳峪镇', N'150721104000', N'150721000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5142', N'三岔河镇', N'150721105000', N'150721000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5143', N'复兴镇', N'150721106000', N'150721000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5144', N'兴安镇', N'150721107000', N'150721000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5145', N'得力其尔鄂温克民族乡', N'150721200000', N'150721000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5146', N'查巴奇鄂温克民族乡', N'150721201000', N'150721000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5147', N'音河达斡尔鄂温克民族乡', N'150721202000', N'150721000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5148', N'新发朝鲜民族乡', N'150721203000', N'150721000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5149', N'那吉屯农场', N'150721400000', N'150721000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5150', N'格尼河农场', N'150721401000', N'150721000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5151', N'阿荣旗林业局', N'150721402000', N'150721000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5152', N'尼尔基镇', N'150722100000', N'150722000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5153', N'红彦镇', N'150722101000', N'150722000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5154', N'宝山镇', N'150722102000', N'150722000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5155', N'哈达阳镇', N'150722103000', N'150722000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5156', N'阿尔拉镇', N'150722104000', N'150722000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5157', N'汉古尔河镇', N'150722105000', N'150722000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5158', N'西瓦尔图镇', N'150722106000', N'150722000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5159', N'腾克镇', N'150722108000', N'150722000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5160', N'奎勒河镇', N'150722109000', N'150722000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5161', N'塔温敖宝镇', N'150722110000', N'150722000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5162', N'登特科镇', N'150722111000', N'150722000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5163', N'巴彦鄂温克民族乡', N'150722200000', N'150722000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5164', N'库如奇乡', N'150722201000', N'150722000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5165', N'额尔和乡', N'150722202000', N'150722000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5166', N'杜拉尔鄂温克民族乡', N'150722203000', N'150722000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5167', N'国营甘河农场', N'150722400000', N'150722000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5168', N'国营巴彦农场', N'150722401000', N'150722000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5169', N'国营欧肯河农场', N'150722402000', N'150722000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5170', N'国营东方红农场', N'150722403000', N'150722000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5171', N'阿里河镇', N'150723100000', N'150723000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5172', N'大杨树镇', N'150723101000', N'150723000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5173', N'甘河镇', N'150723102000', N'150723000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5174', N'吉文镇', N'150723103000', N'150723000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5175', N'诺敏镇', N'150723104000', N'150723000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5176', N'乌鲁布铁镇', N'150723105000', N'150723000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5177', N'宜里镇', N'150723106000', N'150723000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5178', N'克一河镇', N'150723107000', N'150723000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5179', N'古里乡', N'150723200000', N'150723000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5180', N'托扎敏乡', N'150723201000', N'150723000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5181', N'大兴安岭管理局诺敏河农场', N'150723400000', N'150723000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5182', N'大兴安岭农场宜里农场', N'150723401000', N'150723000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5183', N'大兴安岭农场管理局扎兰河农场', N'150723402000', N'150723000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5184', N'大兴安岭农场管理局古里农场', N'150723403000', N'150723000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5185', N'加格达奇区', N'150723404000', N'150723000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5186', N'松岭地区', N'150723405000', N'150723000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5187', N'大杨树林业局', N'150723406000', N'150723000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5188', N'甘河林业局', N'150723407000', N'150723000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5189', N'克一河林业局', N'150723408000', N'150723000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5190', N'吉文林业局', N'150723409000', N'150723000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5191', N'阿里河林业局', N'150723410000', N'150723000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5192', N'大兴安岭农工商联合公司', N'150723411000', N'150723000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5193', N'大兴安岭农场管理局东方红农场', N'150723412000', N'150723000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5194', N'大兴安岭农场管理局欧肯河农场', N'150723413000', N'150723000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5195', N'大兴安岭林管局毕拉河林业局', N'150723414000', N'150723000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5196', N'大兴安岭林管局伊图里河林业局', N'150723415000', N'150723000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5197', N'大兴安岭林管局库都尔林业局', N'150723416000', N'150723000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5198', N'大兴安岭林管局乌尔其汗林业局', N'150723417000', N'150723000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5199', N'巴彦托海镇', N'150724100000', N'150724000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5200', N'大雁镇', N'150724110000', N'150724000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5201', N'伊敏河镇', N'150724111000', N'150724000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5202', N'红花尔基镇', N'150724112000', N'150724000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5203', N'巴彦查岗苏木', N'150724210000', N'150724000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5204', N'锡尼河西苏木', N'150724211000', N'150724000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5205', N'锡尼河东苏木', N'150724212000', N'150724000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5206', N'巴彦塔拉达斡尔民族乡', N'150724213000', N'150724000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5207', N'伊敏苏木', N'150724214000', N'150724000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5208', N'辉苏木', N'150724215000', N'150724000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5209', N'巴彦托海经济开发区', N'150724400000', N'150724000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5210', N'伊敏河高载能工业园区', N'150724401000', N'150724000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5211', N'大雁马铃薯高新技术示范园区', N'150724402000', N'150724000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5212', N'呼伦贝尔新城区', N'150724403000', N'150724000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5213', N'陈旗巴彦库仁镇', N'150725100000', N'150725000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5214', N'陈旗宝日希勒镇', N'150725101000', N'150725000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5215', N'陈旗呼和诺尔镇', N'150725102000', N'150725000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5216', N'陈旗西乌珠尔苏木', N'150725200000', N'150725000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5217', N'陈旗鄂温克民族苏木', N'150725201000', N'150725000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5218', N'陈旗东乌珠尔苏木', N'150725202000', N'150725000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5219', N'陈旗巴彦哈达苏木', N'150725203000', N'150725000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5220', N'陈巴尔虎旗国营哈图达牧场', N'150725501000', N'150725000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5221', N'陈旗国营浩特陶海农牧场', N'150725502000', N'150725000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5222', N'陈旗国营特泥河牧场', N'150725503000', N'150725000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5223', N'嵯岗镇', N'150726101000', N'150726000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5224', N'阿木古郎镇', N'150726102000', N'150726000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5225', N'新宝力格苏木', N'150726202000', N'150726000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5226', N'乌布尔宝力格苏木', N'150726203000', N'150726000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5227', N'罕达盖苏木', N'150726204000', N'150726000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5228', N'吉布胡郎图苏木', N'150726205000', N'150726000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5229', N'甘珠尔苏木', N'150726206000', N'150726000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5230', N'嵯岗双娃牧场', N'150726400000', N'150726000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5231', N'阿拉坦额莫勒镇', N'150727100000', N'150727000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5232', N'阿日哈沙特镇', N'150727101000', N'150727000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5233', N'呼伦镇', N'150727102000', N'150727000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5234', N'贝尔苏木', N'150727200000', N'150727000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5235', N'克尔伦苏木', N'150727201000', N'150727000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5236', N'达赉苏木', N'150727202000', N'150727000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5237', N'宝格德乌拉苏木', N'150727203000', N'150727000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5238', N'敖尔金牧场', N'150727500000', N'150727000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5239', N'东山街道办事处', N'150781001000', N'150781000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5240', N'道南街道办事处', N'150781002000', N'150781000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5241', N'道北街道办事处', N'150781003000', N'150781000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5242', N'兴华街道办事处', N'150781004000', N'150781000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5243', N'敖尔金街道办事处', N'150781012000', N'150781000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5244', N'新开河镇', N'150781100000', N'150781000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5245', N'满洲里市互市贸易区', N'150781400000', N'150781000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5246', N'满洲里市经济合作区', N'150781401000', N'150781000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5247', N'满洲里市东湖区', N'150781402000', N'150781000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5248', N'满洲里市扎煤公司', N'150781403000', N'150781000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5249', N'扎赉诺尔矿区', N'150781404000', N'150781000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5250', N'满洲里市工业园区', N'150781405000', N'150781000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5251', N'满洲里国际物流产业园区', N'150781406000', N'150781000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5252', N'胜利街道办事处', N'150782001000', N'150782000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5253', N'红旗街道办事处', N'150782002000', N'150782000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5254', N'新工街道办事处', N'150782003000', N'150782000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5255', N'永兴街道办事处', N'150782004000', N'150782000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5256', N'建设街道办事处', N'150782005000', N'150782000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5257', N'暖泉街道办事处', N'150782006000', N'150782000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5258', N'免渡河镇', N'150782100000', N'150782000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5259', N'博克图镇', N'150782101000', N'150782000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5260', N'绰河源镇', N'150782102000', N'150782000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5261', N'乌尔其汉镇', N'150782103000', N'150782000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5262', N'库都尔镇', N'150782104000', N'150782000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5263', N'图里河镇', N'150782105000', N'150782000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5264', N'乌奴耳镇', N'150782106000', N'150782000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5265', N'塔尔气镇', N'150782107000', N'150782000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5266', N'伊图里河镇', N'150782108000', N'150782000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5267', N'牧原镇', N'150782109000', N'150782000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5268', N'莫拐农场', N'150782400000', N'150782000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5269', N'牙克石农场', N'150782401000', N'150782000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5270', N'免渡河农场', N'150782402000', N'150782000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5271', N'兴华街道办事处', N'150783001000', N'150783000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5272', N'正阳街道办事处', N'150783002000', N'150783000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5273', N'繁荣街道办事处', N'150783003000', N'150783000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5274', N'向阳街道办事处', N'150783004000', N'150783000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5275', N'高台子街道办事处', N'150783005000', N'150783000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5276', N'铁东街道办事处', N'150783006000', N'150783000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5277', N'河西街道办事处', N'150783007000', N'150783000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5278', N'蘑菇气镇', N'150783100000', N'150783000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5279', N'卧牛河镇', N'150783102000', N'150783000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5280', N'成吉思汗镇', N'150783103000', N'150783000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5281', N'大河湾镇', N'150783104000', N'150783000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5282', N'浩饶山镇', N'150783105000', N'150783000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5283', N'柴河镇', N'150783106000', N'150783000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5284', N'中和镇', N'150783107000', N'150783000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5285', N'哈多河镇', N'150783108000', N'150783000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5286', N'达斡尔民族乡', N'150783200000', N'150783000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5287', N'鄂伦春民族乡', N'150783201000', N'150783000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5288', N'萨马街鄂温克民族乡', N'150783202000', N'150783000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5289', N'洼堤乡', N'150783203000', N'150783000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5290', N'大河湾农场', N'150783400000', N'150783000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5291', N'绰尔河农场', N'150783401000', N'150783000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5292', N'扎兰屯马场', N'150783402000', N'150783000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5293', N'成吉思汗牧场', N'150783403000', N'150783000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5294', N'公安部后勤供应处农场', N'150783404000', N'150783000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5295', N'南木林业局', N'150783405000', N'150783000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5296', N'柴河林业局', N'150783406000', N'150783000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5297', N'扎兰屯市林业局', N'150783407000', N'150783000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5298', N'市原种场', N'150783408000', N'150783000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5299', N'拉布达林街道办事处', N'150784001000', N'150784000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5300', N'上库力街道办事处', N'150784002000', N'150784000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5301', N'黑山头镇', N'150784101000', N'150784000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5302', N'莫尔道嘎镇', N'150784103000', N'150784000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5303', N'恩和哈达镇', N'150784104000', N'150784000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5304', N'三河回族乡', N'150784200000', N'150784000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5305', N'恩和俄罗斯族民族乡', N'150784210000', N'150784000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5306', N'蒙兀室韦苏木', N'150784211000', N'150784000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5307', N'奇乾乡', N'150784212000', N'150784000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5308', N'海拉尔农垦集团有限公司拉布大林农场分公司', N'150784400000', N'150784000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5309', N'三河金騋农牧有限责任公司', N'150784401000', N'150784000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5310', N'海拉尔农垦集团有限责任公司上库力农场分公司', N'150784402000', N'150784000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5311', N'海拉尔农垦集团有限责任公司苏沁牧场分公司', N'150784403000', N'150784000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5312', N'河东街道办事处', N'150785001000', N'150785000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5313', N'河西街道办事处', N'150785002000', N'150785000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5314', N'森工街道办事处', N'150785003000', N'150785000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5315', N'好里堡街道办事处', N'150785004000', N'150785000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5316', N'金河镇', N'150785101000', N'150785000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5317', N'阿龙山镇', N'150785102000', N'150785000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5318', N'满归镇', N'150785103000', N'150785000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5319', N'得耳布尔镇', N'150785104000', N'150785000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5320', N'敖鲁古雅乡', N'150785200000', N'150785000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5321', N'团结办事处', N'150802001000', N'150802000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5322', N'车站办事处', N'150802002000', N'150802000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5323', N'先锋办事处', N'150802003000', N'150802000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5324', N'解放办事处', N'150802004000', N'150802000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5325', N'新华办事处', N'150802005000', N'150802000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5326', N'东环路办事处', N'150802006000', N'150802000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5327', N'铁南办事处', N'150802007000', N'150802000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5328', N'西环路办事处', N'150802008000', N'150802000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5329', N'北环路办事处', N'150802009000', N'150802000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5330', N'金川办事处', N'150802013000', N'150802000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5331', N'汇丰办事处', N'150802014000', N'150802000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5332', N'狼山镇', N'150802100000', N'150802000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5333', N'新华镇', N'150802101000', N'150802000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5334', N'干召庙镇', N'150802102000', N'150802000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5335', N'乌兰图克镇', N'150802103000', N'150802000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5336', N'双河镇', N'150802104000', N'150802000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5337', N'城关镇', N'150802105000', N'150802000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5338', N'白脑包镇', N'150802106000', N'150802000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5339', N'曙光乡', N'150802200000', N'150802000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5340', N'八一乡', N'150802201000', N'150802000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5341', N'狼山农场', N'150802400000', N'150802000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5342', N'临河农场', N'150802401000', N'150802000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5343', N'隆兴昌镇', N'150821100000', N'150821000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5344', N'塔尔湖镇', N'150821101000', N'150821000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5345', N'套海镇', N'150821102000', N'150821000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5346', N'新公中镇', N'150821103000', N'150821000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5347', N'天吉太镇', N'150821104000', N'150821000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5348', N'胜丰镇', N'150821105000', N'150821000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5349', N'银定图镇', N'150821106000', N'150821000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5350', N'复兴镇', N'150821107000', N'150821000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5351', N'和胜乡', N'150821200000', N'150821000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5352', N'巴彦淖尔市建丰农场', N'150821400000', N'150821000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5353', N'内蒙古东土城劳动教养管理所', N'150821401000', N'150821000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5354', N'巴彦高勒镇', N'150822100000', N'150822000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5355', N'隆盛合镇', N'150822101000', N'150822000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5356', N'渡口镇', N'150822102000', N'150822000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5357', N'补隆淖镇', N'150822103000', N'150822000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5358', N'沙金套海苏木', N'150822200000', N'150822000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5359', N'乌兰布和农场', N'150822400000', N'150822000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5360', N'巴彦套海农场', N'150822401000', N'150822000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5361', N'哈腾套海农场', N'150822402000', N'150822000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5362', N'包尔盖农场', N'150822403000', N'150822000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5363', N'纳林套海农场', N'150822404000', N'150822000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5364', N'沙漠林业实验中心农场', N'150822405000', N'150822000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5365', N'乌拉山镇', N'150823100000', N'150823000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5366', N'白彦花镇', N'150823101000', N'150823000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5367', N'先锋镇', N'150823102000', N'150823000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5368', N'新安镇', N'150823103000', N'150823000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5369', N'西小召镇', N'150823104000', N'150823000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5370', N'大佘太镇', N'150823105000', N'150823000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5371', N'明安镇', N'150823106000', N'150823000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5372', N'小佘太镇', N'150823107000', N'150823000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5373', N'苏独仑镇', N'150823108000', N'150823000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5374', N'额尔登布拉格苏木', N'150823200000', N'150823000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5375', N'沙德格苏木', N'150823201000', N'150823000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5376', N'巴彦淖尔市中滩农场', N'150823400000', N'150823000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5377', N'巴彦淖尔市西山咀农场', N'150823401000', N'150823000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5378', N'巴彦淖尔市新安农场', N'150823402000', N'150823000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5379', N'巴彦淖尔市苏独仑农场', N'150823403000', N'150823000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5380', N'巴彦淖尔市大佘太牧场', N'150823404000', N'150823000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5381', N'巴彦淖尔市乌梁素海渔场', N'150823405000', N'150823000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5382', N'海流图镇', N'150824100000', N'150824000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5383', N'乌加河镇', N'150824101000', N'150824000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5384', N'德岭山镇', N'150824102000', N'150824000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5385', N'石哈河镇', N'150824103000', N'150824000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5386', N'甘其毛都镇', N'150824104000', N'150824000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5387', N'温更镇', N'150824105000', N'150824000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5388', N'呼鲁斯太苏木', N'150824200000', N'150824000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5389', N'川井苏木', N'150824201000', N'150824000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5390', N'巴音乌兰苏木', N'150824202000', N'150824000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5391', N'新忽热苏木', N'150824203000', N'150824000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5392', N'牧羊海牧场', N'150824400000', N'150824000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5393', N'同和太种畜场', N'150824401000', N'150824000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5394', N'巴音宝力格镇', N'150825100000', N'150825000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5395', N'呼和温都尔镇', N'150825101000', N'150825000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5396', N'潮格温都尔镇', N'150825102000', N'150825000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5397', N'获各琦苏木', N'150825200000', N'150825000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5398', N'巴音前达门苏木', N'150825201000', N'150825000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5399', N'乌盖苏木', N'150825202000', N'150825000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5400', N'陕坝镇', N'150826100000', N'150826000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5401', N'头道桥镇', N'150826101000', N'150826000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5402', N'二道桥镇', N'150826102000', N'150826000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5403', N'三道桥镇', N'150826103000', N'150826000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5404', N'蛮会镇', N'150826104000', N'150826000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5405', N'团结镇', N'150826105000', N'150826000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5406', N'双庙镇', N'150826106000', N'150826000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5407', N'沙海镇', N'150826107000', N'150826000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5408', N'蒙海镇', N'150826108000', N'150826000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5409', N'太阳庙农场', N'150826500000', N'150826000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5410', N'新体路街道办事处', N'150902001000', N'150902000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5411', N'桥东街道办事处', N'150902002000', N'150902000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5412', N'前进路街道办事处', N'150902003000', N'150902000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5413', N'常青街道办事处', N'150902004000', N'150902000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5414', N'虎山街道办事处', N'150902005000', N'150902000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5415', N'桥西街道办事处', N'150902006000', N'150902000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5416', N'新华街街道办事处', N'150902007000', N'150902000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5417', N'泉山街道办事处', N'150902008000', N'150902000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5418', N'卧龙街道办事处', N'150902009000', N'150902000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5419', N'霸王河街道办事处', N'150902010000', N'150902000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5420', N'白海子镇', N'150902105000', N'150902000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5421', N'马莲渠乡', N'150902205000', N'150902000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5422', N'卓资山镇', N'150921106000', N'150921000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5423', N'旗下营镇', N'150921107000', N'150921000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5424', N'卓资县十八台镇', N'150921108000', N'150921000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5425', N'卓资县巴音锡勒镇', N'150921109000', N'150921000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5426', N'卓资县梨花镇', N'150921110000', N'150921000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5427', N'卓资县大榆树乡', N'150921210000', N'150921000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5428', N'卓资县红召乡', N'150921211000', N'150921000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5429', N'卓资县复兴乡', N'150921212000', N'150921000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5430', N'化德县长顺镇', N'150922103000', N'150922000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5431', N'化德县朝阳镇', N'150922104000', N'150922000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5432', N'化德县七号镇', N'150922105000', N'150922000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5433', N'化德县德包图乡', N'150922200000', N'150922000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5434', N'化德县公腊胡洞乡', N'150922201000', N'150922000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5435', N'化德县白音特拉乡', N'150922218000', N'150922000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5436', N'七台镇', N'150923101000', N'150923000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5437', N'十八顷镇', N'150923102000', N'150923000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5438', N'大黑沙土镇', N'150923103000', N'150923000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5439', N'西井子镇', N'150923104000', N'150923000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5440', N'屯垦队镇', N'150923105000', N'150923000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5441', N'小海子镇', N'150923106000', N'150923000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5442', N'大库伦乡', N'150923200000', N'150923000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5443', N'卯都乡', N'150923201000', N'150923000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5444', N'玻璃忽镜乡', N'150923202000', N'150923000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5445', N'三大顷乡', N'150923203000', N'150923000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5446', N'城关镇', N'150924106000', N'150924000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5447', N'张皋镇', N'150924107000', N'150924000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5448', N'赛乌素镇', N'150924108000', N'150924000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5449', N'鄂尔栋镇', N'150924109000', N'150924000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5450', N'店子镇', N'150924110000', N'150924000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5451', N'大库联乡', N'150924209000', N'150924000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5452', N'民族团结乡', N'150924210000', N'150924000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5453', N'大同夭乡', N'150924211000', N'150924000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5454', N'五股泉乡', N'150924212000', N'150924000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5455', N'南部矿区管委会', N'150924400000', N'150924000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5456', N'鸿茅镇', N'150925103000', N'150925000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5457', N'六苏木镇', N'150925104000', N'150925000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5458', N'麦胡图镇', N'150925105000', N'150925000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5459', N'永兴镇', N'150925106000', N'150925000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5460', N'蛮汉镇', N'150925107000', N'150925000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5461', N'岱海镇', N'150925108000', N'150925000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5462', N'天成乡', N'150925218000', N'150925000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5463', N'曹碾满族乡', N'150925220000', N'150925000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5464', N'蛮汉山林场', N'150925401000', N'150925000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5465', N'岱海林场', N'150925402000', N'150925000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5466', N'土贵乌拉镇', N'150926105000', N'150926000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5467', N'平地泉镇', N'150926106000', N'150926000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5468', N'玫瑰营镇', N'150926107000', N'150926000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5469', N'巴音塔拉镇', N'150926108000', N'150926000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5470', N'黄旗海镇', N'150926109000', N'150926000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5471', N'乌拉哈乌拉乡', N'150926209000', N'150926000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5472', N'黄茂营乡', N'150926210000', N'150926000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5473', N'三岔口乡', N'150926211000', N'150926000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5474', N'老圈沟乡', N'150926212000', N'150926000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5475', N'察右前旗天皮山冶金化工工业园区', N'150926400000', N'150926000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5476', N'察右前旗察哈尔工业园区', N'150926401000', N'150926000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5477', N'科布尔镇', N'150927103000', N'150927000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5478', N'铁沙盖镇', N'150927104000', N'150927000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5479', N'黄羊城镇', N'150927105000', N'150927000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5480', N'广益隆镇', N'150927106000', N'150927000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5481', N'乌素图镇', N'150927107000', N'150927000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5482', N'大滩乡', N'150927216000', N'150927000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5483', N'宏盘乡', N'150927217000', N'150927000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5484', N'巴音乡', N'150927218000', N'150927000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5485', N'库联苏木', N'150927219000', N'150927000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5486', N'乌兰哈页苏木', N'150927220000', N'150927000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5487', N'察右中旗土城子乡', N'150927221000', N'150927000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5488', N'辉腾锡勒园区管理委员会', N'150927400000', N'150927000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5489', N'白音察干镇', N'150928105000', N'150928000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5490', N'察哈尔右翼后旗土牧尔台镇', N'150928106000', N'150928000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5491', N'察哈尔右翼后旗红格尔图镇', N'150928107000', N'150928000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5492', N'察哈尔右翼后旗贲红镇', N'150928108000', N'150928000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5493', N'察哈尔右翼后旗大六号镇', N'150928109000', N'150928000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5494', N'察哈尔右翼后旗当郎忽洞苏木', N'150928209000', N'150928000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5495', N'察哈尔右翼后旗乌兰哈达苏木', N'150928210000', N'150928000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5496', N'察哈尔右翼后旗锡勒乡', N'150928211000', N'150928000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5497', N'四子王旗乌兰花镇', N'150929100000', N'150929000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5498', N'四子王旗吉生太镇', N'150929101000', N'150929000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5499', N'四子王旗库伦图镇', N'150929102000', N'150929000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5500', N'四子王旗供济堂镇', N'150929103000', N'150929000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5501', N'四子王旗白音朝克图镇', N'150929104000', N'150929000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5502', N'四子王旗红格尔苏木', N'150929200000', N'150929000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5503', N'四子王旗江岸苏木', N'150929201000', N'150929000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5504', N'四子王旗查干补力格苏木', N'150929202000', N'150929000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5505', N'四子王旗脑木更苏木', N'150929203000', N'150929000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5506', N'四子王旗东八号乡', N'150929204000', N'150929000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5507', N'四子王旗忽鸡图乡', N'150929205000', N'150929000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5508', N'四子王旗大黑河乡', N'150929206000', N'150929000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5509', N'四子王旗巴音敖包苏木', N'150929207000', N'150929000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5510', N'四子王旗乌兰牧场', N'150929400000', N'150929000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5511', N'新城区街道办事处', N'150981005000', N'150981000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5512', N'旧城区街道办事处', N'150981006000', N'150981000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5513', N'北城区街道办事处', N'150981007000', N'150981000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5514', N'工业区街道办事处', N'150981008000', N'150981000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5515', N'南城区街道办事处', N'150981009000', N'150981000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5516', N'隆盛庄镇', N'150981107000', N'150981000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5517', N'黑土台镇', N'150981108000', N'150981000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5518', N'红砂坝镇', N'150981109000', N'150981000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5519', N'巨宝庄镇', N'150981110000', N'150981000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5520', N'三义泉镇', N'150981111000', N'150981000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5521', N'浑源窑乡', N'150981207000', N'150981000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5522', N'元山子乡', N'150981208000', N'150981000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5523', N'官屯堡乡', N'150981209000', N'150981000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5524', N'爱国办事处', N'152201001000', N'152201000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5525', N'和平办事处', N'152201002000', N'152201000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5526', N'兴安办事处', N'152201003000', N'152201000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5527', N'胜利办事处', N'152201004000', N'152201000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5528', N'铁西办事处', N'152201005000', N'152201000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5529', N'都林办事处', N'152201006000', N'152201000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5530', N'五一办事处', N'152201007000', N'152201000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5531', N'城郊办事处', N'152201008000', N'152201000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5532', N'新城办事处', N'152201009000', N'152201000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5533', N'乌兰哈达镇', N'152201100000', N'152201000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5534', N'葛根庙镇', N'152201101000', N'152201000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5535', N'太本站镇', N'152201102000', N'152201000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5536', N'义勒力特镇', N'152201103000', N'152201000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5537', N'呼和马场', N'152201401000', N'152201000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5538', N'乌兰浩特工业经济开发区', N'152201402000', N'152201000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5539', N'乌兰浩特经济技术开发区', N'152201403000', N'152201000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5540', N'阿尔山市林海街道', N'152202001000', N'152202000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5541', N'阿尔山市新城街道', N'152202002000', N'152202000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5542', N'阿尔山市温泉街道', N'152202003000', N'152202000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5543', N'伊尔施街道办事处', N'152202004000', N'152202000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5544', N'阿尔山市天池镇', N'152202100000', N'152202000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5545', N'阿尔山市白狼镇', N'152202101000', N'152202000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5546', N'阿尔山市五岔沟镇', N'152202102000', N'152202000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5547', N'明水河镇', N'152202103000', N'152202000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5548', N'科尔沁镇', N'152221100000', N'152221000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5549', N'索伦镇', N'152221101000', N'152221000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5550', N'德佰斯镇', N'152221102000', N'152221000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5551', N'大石寨镇', N'152221103000', N'152221000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5552', N'归流河镇', N'152221104000', N'152221000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5553', N'居力很镇', N'152221105000', N'152221000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5554', N'察尔森镇', N'152221106000', N'152221000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5555', N'额尔格图镇', N'152221107000', N'152221000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5556', N'俄体镇', N'152221108000', N'152221000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5557', N'满族屯满族乡', N'152221200000', N'152221000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5558', N'乌兰毛都苏木乡', N'152221201000', N'152221000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5559', N'阿力得尔苏木乡', N'152221202000', N'152221000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5560', N'巴日嘎斯台乡', N'152221203000', N'152221000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5561', N'桃合木苏木', N'152221204000', N'152221000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5562', N'跃进马场', N'152221400000', N'152221000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5563', N'索伦牧场', N'152221401000', N'152221000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5564', N'阿力得尔牧场', N'152221403000', N'152221000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5565', N'公主陵牧场', N'152221404000', N'152221000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5566', N'绿水种畜场', N'152221405000', N'152221000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5567', N'科右前旗工业园区', N'152221407000', N'152221000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5568', N'科右前旗现代农牧业园区', N'152221408000', N'152221000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5569', N'巴彦呼舒镇', N'152222100000', N'152222000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5570', N'巴仁哲里木镇', N'152222101000', N'152222000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5571', N'吐列毛都镇', N'152222102000', N'152222000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5572', N'杜尔基镇', N'152222103000', N'152222000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5573', N'高力板镇', N'152222104000', N'152222000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5574', N'好腰苏木镇', N'152222105000', N'152222000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5575', N'代钦塔拉苏木', N'152222200000', N'152222000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5576', N'新佳木苏木', N'152222201000', N'152222000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5577', N'哈日诺尔苏木', N'152222202000', N'152222000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5578', N'额木庭高勒苏木', N'152222203000', N'152222000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5579', N'巴彦茫哈苏木', N'152222204000', N'152222000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5580', N'巴彦淖尔苏木', N'152222205000', N'152222000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5581', N'布敦化牧场', N'152222400000', N'152222000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5582', N'吐列毛杜农场', N'152222401000', N'152222000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5583', N'孟恩套力盖矿区工作部', N'152222402000', N'152222000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5584', N'布敦化矿区工作部', N'152222403000', N'152222000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5585', N'音德尔镇', N'152223100000', N'152223000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5586', N'新林镇', N'152223101000', N'152223000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5587', N'巴彦高勒镇', N'152223102000', N'152223000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5588', N'胡尔勒镇', N'152223103000', N'152223000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5589', N'阿尔本格勒镇', N'152223104000', N'152223000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5590', N'巴达尔胡镇', N'152223105000', N'152223000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5591', N'图牧吉镇', N'152223106000', N'152223000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5592', N'好力保镇', N'152223107000', N'152223000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5593', N'巴彦乌兰苏木', N'152223201000', N'152223000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5594', N'宝力根花苏木', N'152223202000', N'152223000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5595', N'阿拉达尔吐苏木', N'152223203000', N'152223000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5596', N'巴彦扎拉嘎乡', N'152223204000', N'152223000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5597', N'努文木仁乡', N'152223205000', N'152223000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5598', N'内蒙古自治区图牧吉强制隔离戒毒所', N'152223400000', N'152223000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5599', N'保安沼监狱', N'152223401000', N'152223000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5600', N'乌兰监狱', N'152223402000', N'152223000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5601', N'乌塔其监狱', N'152223403000', N'152223000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5602', N'种畜场', N'152223404000', N'152223000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5603', N'八一牧场', N'152223405000', N'152223000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5604', N'巴达尔胡农场', N'152223406000', N'152223000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5605', N'突泉镇', N'152224100000', N'152224000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5606', N'六户镇', N'152224101000', N'152224000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5607', N'东杜尔基镇', N'152224102000', N'152224000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5608', N'永安镇', N'152224103000', N'152224000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5609', N'水泉镇', N'152224104000', N'152224000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5610', N'宝石镇', N'152224105000', N'152224000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5611', N'学田乡', N'152224200000', N'152224000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5612', N'九龙乡', N'152224201000', N'152224000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5613', N'太平乡', N'152224202000', N'152224000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5614', N'东杜尔基国营农场', N'152224400000', N'152224000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5615', N'格日勒敖都苏木', N'152501200000', N'152501000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5616', N'二连浩特市社区建设管理局', N'152501400000', N'152501000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5617', N'二连边境经济技术合作区', N'152501401000', N'152501000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5618', N'希日塔拉街道办事处', N'152502001000', N'152502000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5619', N'宝力根街道办事处', N'152502002000', N'152502000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5620', N'杭盖街道办事处', N'152502003000', N'152502000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5621', N'楚古兰街道办事处', N'152502004000', N'152502000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5622', N'额尔敦街道办事处', N'152502005000', N'152502000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5623', N'南郊街道办事处', N'152502006000', N'152502000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5624', N'巴彦查干街道办事处', N'152502007000', N'152502000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5625', N'阿尔善宝拉格镇', N'152502100000', N'152502000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5626', N'宝力根苏木', N'152502200000', N'152502000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5627', N'朝克乌拉苏木', N'152502201000', N'152502000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5628', N'巴彦锡勒办事处乡', N'152502202000', N'152502000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5629', N'巴彦宝拉格苏木', N'152502203000', N'152502000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5630', N'锡林郭勒盟经济技术开发区', N'152502400000', N'152502000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5631', N'白音库伦牧场', N'152502500000', N'152502000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5632', N'贝力克牧场', N'152502501000', N'152502000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5633', N'毛登牧场', N'152502502000', N'152502000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5634', N'别力古台镇', N'152522100000', N'152522000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5635', N'洪格尔高勒镇', N'152522101000', N'152522000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5636', N'查干淖尔镇', N'152522102000', N'152522000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5637', N'那仁宝拉格苏木', N'152522200000', N'152522000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5638', N'伊和高勒苏木', N'152522201000', N'152522000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5639', N'吉尔嘎郎图苏木', N'152522202000', N'152522000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5640', N'巴彦图嘎苏木', N'152522203000', N'152522000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5641', N'玛尼图煤矿', N'152522400000', N'152522000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5642', N'阿旗德力格尔工业园区', N'152522401000', N'152522000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5643', N'满都拉图镇', N'152523100000', N'152523000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5644', N'查干敖包镇', N'152523101000', N'152523000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5645', N'巴彦淖尔镇', N'152523102000', N'152523000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5646', N'巴彦乌拉苏木', N'152523200000', N'152523000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5647', N'赛罕高毕苏木', N'152523201000', N'152523000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5648', N'洪格尔苏木', N'152523202000', N'152523000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5649', N'达来苏木', N'152523203000', N'152523000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5650', N'苏尼特左旗芒来循环经济产业园区', N'152523400000', N'152523000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5651', N'恩格尔河灌区', N'152523500000', N'152523000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5652', N'赛汉塔拉镇', N'152524100000', N'152524000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5653', N'朱日和镇', N'152524101000', N'152524000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5654', N'乌日根塔拉镇', N'152524102000', N'152524000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5655', N'桑宝拉格苏木', N'152524200000', N'152524000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5656', N'额仁淖尔苏木', N'152524201000', N'152524000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5657', N'赛罕乌力吉苏木', N'152524202000', N'152524000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5658', N'阿其图乌拉苏木', N'152524203000', N'152524000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5659', N'苏尼特右旗朱日和工业园区', N'152524400000', N'152524000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5660', N'乌里雅斯太镇', N'152525100000', N'152525000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5661', N'道特淖尔镇', N'152525101000', N'152525000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5662', N'嘎达布其镇', N'152525102000', N'152525000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5663', N'满都胡宝拉格镇', N'152525103000', N'152525000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5664', N'额吉淖尔镇', N'152525104000', N'152525000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5665', N'呼热图淖尔苏木', N'152525200000', N'152525000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5666', N'萨麦苏木', N'152525201000', N'152525000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5667', N'嘎海乐苏木', N'152525202000', N'152525000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5668', N'阿拉坦合力苏木', N'152525203000', N'152525000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5669', N'乌里雅斯太工业区', N'152525400000', N'152525000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5670', N'宝格达乌拉总场', N'152525503000', N'152525000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5671', N'巴拉嘎尔高勒镇', N'152526100000', N'152526000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5672', N'巴彦花镇', N'152526101000', N'152526000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5673', N'吉仁高勒镇', N'152526102000', N'152526000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5674', N'浩勒图高勒镇', N'152526103000', N'152526000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5675', N'高日罕镇', N'152526104000', N'152526000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5676', N'巴彦胡舒苏木', N'152526200000', N'152526000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5677', N'乌兰哈拉嘎苏木', N'152526201000', N'152526000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5678', N'西乌旗白音华能源化工园区', N'152526400000', N'152526000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5679', N'林业总场', N'152526500000', N'152526000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5680', N'宝昌镇', N'152527100000', N'152527000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5681', N'千斤沟镇', N'152527101000', N'152527000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5682', N'红旗镇', N'152527102000', N'152527000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5683', N'骆驼山镇', N'152527103000', N'152527000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5684', N'永丰镇', N'152527104000', N'152527000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5685', N'幸福乡', N'152527200000', N'152527000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5686', N'贡宝拉格苏木', N'152527201000', N'152527000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5687', N'万寿滩良种场', N'152527500000', N'152527000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5688', N'新宝拉格镇', N'152528100000', N'152528000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5689', N'巴彦塔拉镇', N'152528101000', N'152528000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5690', N'翁贡乌拉苏木', N'152528200000', N'152528000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5691', N'宝格达音髙勒苏木', N'152528201000', N'152528000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5692', N'明安图镇', N'152529100000', N'152529000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5693', N'星耀镇', N'152529101000', N'152529000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5694', N'伊和淖尔苏木', N'152529200000', N'152529000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5695', N'乌兰查布苏木', N'152529201000', N'152529000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5696', N'宝拉根陶海苏木', N'152529202000', N'152529000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5697', N'额里图种畜场', N'152529500000', N'152529000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5698', N'哲日根图林场', N'152529502000', N'152529000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5699', N'上都镇', N'152530100000', N'152530000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5700', N'桑根达来镇', N'152530101000', N'152530000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5701', N'哈毕日嘎镇', N'152530102000', N'152530000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5702', N'宝绍代苏木', N'152530200000', N'152530000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5703', N'那日图苏木', N'152530201000', N'152530000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5704', N'赛音呼都嘎苏木', N'152530202000', N'152530000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5705', N'扎格斯台苏木', N'152530203000', N'152530000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5706', N'五一种畜场总场', N'152530500000', N'152530000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5707', N'黑城子示范区', N'152530501000', N'152530000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5708', N'大北沟镇', N'152531100000', N'152531000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5709', N'多伦诺尔镇', N'152531101000', N'152531000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5710', N'滦源镇', N'152531102000', N'152531000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5711', N'蔡木山乡', N'152531201000', N'152531000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5712', N'西干沟乡', N'152531202000', N'152531000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5713', N'多伦新型工业化化工区', N'152531400000', N'152531000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5714', N'巴彦胡硕镇', N'152571101000', N'152571000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5715', N'哈拉盖图农牧场', N'152571500000', N'152571000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5716', N'贺斯格乌拉牧场', N'152571501000', N'152571000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5717', N'乌拉盖牧场', N'152571502000', N'152571000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5718', N'温都尔勒图镇', N'152921102000', N'152921000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5719', N'巴润别立镇', N'152921105000', N'152921000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5720', N'巴彦浩特镇', N'152921110000', N'152921000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5721', N'嘉尔嘎勒赛汉镇', N'152921111000', N'152921000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5722', N'吉兰泰镇', N'152921112000', N'152921000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5723', N'宗别立镇', N'152921113000', N'152921000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5724', N'敖伦布拉格镇', N'152921114000', N'152921000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5725', N'腾格里额里斯镇', N'152921115000', N'152921000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5726', N'巴彦木仁苏木乡', N'152921203000', N'152921000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5727', N'乌力吉苏木乡', N'152921213000', N'152921000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5728', N'巴彦诺日公苏木乡', N'152921214000', N'152921000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5729', N'额尔克哈什哈苏木乡', N'152921215000', N'152921000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5730', N'银根苏木', N'152921216000', N'152921000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5731', N'超格图呼热苏木', N'152921217000', N'152921000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5732', N'腾格里经济技术开发区', N'152921401000', N'152921000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5733', N'巴彦浩特额鲁特街道办事处', N'152921402000', N'152921000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5734', N'巴彦浩特南环路街道办事处', N'152921403000', N'152921000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5735', N'巴彦浩特新华街道办事处', N'152921404000', N'152921000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5736', N'巴彦浩特王府街道办事处', N'152921405000', N'152921000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5737', N'巴丹吉林镇', N'152922103000', N'152922000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5738', N'雅布赖镇', N'152922104000', N'152922000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5739', N'阿拉腾敖包镇', N'152922105000', N'152922000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5740', N'曼德拉苏木', N'152922211000', N'152922000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5741', N'阿拉腾朝格苏木', N'152922212000', N'152922000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5742', N'巴音高勒苏木', N'152922213000', N'152922000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5743', N'塔木素布拉格苏木', N'152922214000', N'152922000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5744', N'额济纳旗航空街道', N'152923001000', N'152923000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5745', N'额济纳旗东风街道', N'152923002000', N'152923000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5746', N'达来呼布镇', N'152923100000', N'152923000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5747', N'额济纳旗东风镇', N'152923101000', N'152923000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5748', N'哈日布日格德音乌拉镇', N'152923102000', N'152923000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5749', N'额济纳旗赛汉陶来苏木', N'152923200000', N'152923000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5750', N'额济纳旗马鬃山苏木', N'152923201000', N'152923000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5751', N'额济纳旗苏泊淖尔苏木', N'152923202000', N'152923000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5752', N'巴彦陶来苏木', N'152923203000', N'152923000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5753', N'温图高勒苏木', N'152923204000', N'152923000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5754', N'乌斯太镇', N'152971100000', N'152971000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5755', N'浑河湾街道', N'210102001000', N'210102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5756', N'新华街道', N'210102002000', N'210102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5757', N'西塔街道', N'210102007000', N'210102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5758', N'八经街道', N'210102013000', N'210102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5759', N'马路湾街道', N'210102016000', N'210102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5760', N'集贤街道', N'210102017000', N'210102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5761', N'南湖街道', N'210102019000', N'210102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5762', N'长白街道', N'210102021000', N'210102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5763', N'太原街街道', N'210102022000', N'210102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5764', N'北市场街道', N'210102023000', N'210102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5765', N'南市场街道', N'210102025000', N'210102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5766', N'沈水湾街道', N'210102027000', N'210102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5767', N'浑河站西街道', N'210102028000', N'210102000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5768', N'大西街道', N'210103004000', N'210103000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5769', N'滨河街道', N'210103005000', N'210103000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5770', N'万莲街道', N'210103006000', N'210103000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5771', N'大南街道', N'210103010000', N'210103000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5772', N'山东庙街道', N'210103011000', N'210103000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5773', N'朱剪炉街道', N'210103013000', N'210103000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5774', N'新北站街道', N'210103014000', N'210103000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5775', N'风雨坛街道', N'210103015000', N'210103000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5776', N'皇城街道', N'210103017000', N'210103000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5777', N'五里河街道', N'210103018000', N'210103000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5778', N'南塔街道', N'210103019000', N'210103000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5779', N'泉园街道', N'210103020000', N'210103000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5780', N'丰乐街道', N'210103021000', N'210103000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5781', N'马官桥街道', N'210103022000', N'210103000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5782', N'东陵街道', N'210103023000', N'210103000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5783', N'大北街道', N'210104002000', N'210104000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5784', N'万泉街道', N'210104003000', N'210104000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5785', N'洮昌街道', N'210104004000', N'210104000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5786', N'文官街道', N'210104006000', N'210104000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5787', N'二台子街道', N'210104007000', N'210104000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5788', N'津桥街道', N'210104008000', N'210104000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5789', N'东站街道', N'210104009000', N'210104000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5790', N'北海街道', N'210104010000', N'210104000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5791', N'长安街道', N'210104012000', N'210104000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5792', N'新东街道', N'210104014000', N'210104000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5793', N'东塔街道', N'210104015000', N'210104000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5794', N'小东街道', N'210104016000', N'210104000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5795', N'上园街道', N'210104017000', N'210104000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5796', N'前进街道', N'210104018000', N'210104000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5797', N'三台子街道', N'210105001000', N'210105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5798', N'辽河街道', N'210105003000', N'210105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5799', N'黄河街道', N'210105008000', N'210105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5800', N'三洞桥街道', N'210105012000', N'210105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5801', N'华山街道', N'210105013000', N'210105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5802', N'寿泉街道', N'210105014000', N'210105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5803', N'塔湾街道', N'210105015000', N'210105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5804', N'明廉街道', N'210105017000', N'210105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5805', N'新乐街道', N'210105019000', N'210105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5806', N'舍利塔街道', N'210105020000', N'210105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5807', N'北塔街道', N'210105021000', N'210105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5808', N'陵东街道', N'210105022000', N'210105000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5809', N'昆明湖街道', N'210106001000', N'210106000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5810', N'工人村街道', N'210106003000', N'210106000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5811', N'七路街道', N'210106005000', N'210106000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5812', N'启工街道', N'210106007000', N'210106000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5813', N'笃工街道', N'210106013000', N'210106000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5814', N'兴华街道', N'210106015000', N'210106000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5815', N'兴工街道', N'210106018000', N'210106000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5816', N'霁虹街道', N'210106019000', N'210106000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5817', N'凌空街道', N'210106020000', N'210106000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5818', N'重工街道', N'210106021000', N'210106000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5819', N'艳粉街道', N'210106022000', N'210106000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5820', N'保工街道', N'210106023000', N'210106000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5821', N'兴顺街道', N'210106024000', N'210106000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5822', N'贵和街道', N'210106025000', N'210106000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5823', N'大青中朝友谊街道', N'210106026000', N'210106000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5824', N'翟家街道', N'210106027000', N'210106000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5825', N'西三环街道', N'210106028000', N'210106000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5826', N'大潘街道', N'210106029000', N'210106000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5827', N'彰驿站街道', N'210106030000', N'210106000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5828', N'高花街道', N'210106031000', N'210106000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5829', N'沈阳市经济技术开发区管理委员会', N'210106401000', N'210106000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5830', N'解放街道', N'210111001000', N'210111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5831', N'民主街道', N'210111003000', N'210111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5832', N'临湖街道', N'210111004000', N'210111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5833', N'中兴街道', N'210111005000', N'210111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5834', N'湖西街道', N'210111006000', N'210111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5835', N'八一街道', N'210111007000', N'210111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5836', N'红菱街道', N'210111008000', N'210111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5837', N'林盛街道', N'210111009000', N'210111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5838', N'沙河街道', N'210111010000', N'210111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5839', N'十里河街道', N'210111011000', N'210111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5840', N'陈相街道', N'210111012000', N'210111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5841', N'姚千街道', N'210111013000', N'210111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5842', N'王纲街道', N'210111014000', N'210111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5843', N'永乐街道', N'210111015000', N'210111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5844', N'大沟街道', N'210111016000', N'210111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5845', N'白清街道', N'210111017000', N'210111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5846', N'佟沟街道办事处', N'210111018000', N'210111000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5847', N'东湖街道', N'210112009000', N'210112000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5848', N'五三街道', N'210112010000', N'210112000000')
GO

INSERT INTO [dbo].[t_s_town] VALUES (N'5849', N'浑河站东街道', N