/*
Navicat MySQL Data Transfer

Source Server         : localhost
Source Server Version : 50724
Source Host           : localhost:3306
Source Database       : thymelte

Target Server Type    : MYSQL
Target Server Version : 50724
File Encoding         : 65001

Date: 2019-05-06 13:59:29
*/

SET FOREIGN_KEY_CHECKS=0;
SET @@global.sql_mode ='STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION';
SET sql_mode ='STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION';

-- ----------------------------
-- Table structure for logging_event
-- ----------------------------
DROP TABLE IF EXISTS `logging_event`;
CREATE TABLE `logging_event` (
  `timestmp` bigint(20) NOT NULL,
  `formatted_message` text NOT NULL,
  `logger_name` varchar(254) NOT NULL,
  `level_string` varchar(254) NOT NULL,
  `thread_name` varchar(254) DEFAULT NULL,
  `reference_flag` smallint(6) DEFAULT NULL,
  `arg0` varchar(254) DEFAULT NULL,
  `arg1` varchar(254) DEFAULT NULL,
  `arg2` varchar(254) DEFAULT NULL,
  `arg3` varchar(254) DEFAULT NULL,
  `caller_filename` varchar(254) NOT NULL,
  `caller_class` varchar(254) NOT NULL,
  `caller_method` varchar(254) NOT NULL,
  `caller_line` char(4) NOT NULL,
  `event_id` bigint(20) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`event_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=9742 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of logging_event
-- ----------------------------

-- ----------------------------
-- Table structure for logging_event_exception
-- ----------------------------
DROP TABLE IF EXISTS `logging_event_exception`;
CREATE TABLE `logging_event_exception` (
  `event_id` bigint(20) NOT NULL,
  `i` smallint(6) NOT NULL,
  `trace_line` varchar(254) NOT NULL,
  PRIMARY KEY (`event_id`,`i`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of logging_event_exception
-- ----------------------------

-- ----------------------------
-- Table structure for logging_event_property
-- ----------------------------
DROP TABLE IF EXISTS `logging_event_property`;
CREATE TABLE `logging_event_property` (
  `event_id` bigint(20) NOT NULL,
  `mapped_key` varchar(36) NOT NULL,
  `mapped_value` text,
  PRIMARY KEY (`event_id`,`mapped_key`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of logging_event_property
-- ----------------------------

-- ----------------------------
-- Table structure for oauth_access_token
-- ----------------------------
DROP TABLE IF EXISTS `oauth_access_token`;
CREATE TABLE `oauth_access_token` (
  `token_id` varchar(36) DEFAULT NULL,
  `token` blob,
  `authentication_id` varchar(36) DEFAULT NULL,
  `user_name` varchar(255) DEFAULT NULL,
  `client_id` varchar(36) DEFAULT NULL,
  `authentication` blob,
  `refresh_token` varchar(255) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of oauth_access_token
-- ----------------------------

-- ----------------------------
-- Table structure for oauth_client_details
-- ----------------------------
DROP TABLE IF EXISTS `oauth_client_details`;
CREATE TABLE `oauth_client_details` (
  `client_id` varchar(36) NOT NULL,
  `resource_ids` varchar(255) DEFAULT NULL,
  `client_secret` varchar(255) DEFAULT NULL,
  `scope` varchar(255) DEFAULT NULL,
  `authorized_grant_types` varchar(255) DEFAULT NULL,
  `web_server_redirect_uri` varchar(255) DEFAULT NULL,
  `authorities` varchar(255) DEFAULT NULL,
  `access_token_validity` int(11) DEFAULT NULL,
  `refresh_token_validity` int(11) DEFAULT NULL,
  `additional_information` varchar(4096) DEFAULT NULL,
  `autoapprove` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`client_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of oauth_client_details
-- ----------------------------

-- ----------------------------
-- Table structure for oauth_client_token
-- ----------------------------
DROP TABLE IF EXISTS `oauth_client_token`;
CREATE TABLE `oauth_client_token` (
  `token_id` varchar(36) DEFAULT NULL,
  `token` blob,
  `authentication_id` varchar(36) DEFAULT NULL,
  `user_name` varchar(255) DEFAULT NULL,
  `client_id` varchar(36) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of oauth_client_token
-- ----------------------------

-- ----------------------------
-- Table structure for oauth_code
-- ----------------------------
DROP TABLE IF EXISTS `oauth_code`;
CREATE TABLE `oauth_code` (
  `code` varchar(255) DEFAULT NULL,
  `authentication` blob
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of oauth_code
-- ----------------------------

-- ----------------------------
-- Table structure for oauth_refresh_token
-- ----------------------------
DROP TABLE IF EXISTS `oauth_refresh_token`;
CREATE TABLE `oauth_refresh_token` (
  `token_id` varchar(36) DEFAULT NULL,
  `token` blob,
  `authentication` blob
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of oauth_refresh_token
-- ----------------------------

-- ----------------------------
-- Table structure for t_account_bind
-- ----------------------------
DROP TABLE IF EXISTS `t_account_bind`;
CREATE TABLE `t_account_bind` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `create_by` bigint(20) DEFAULT NULL COMMENT '创建人id',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` bigint(20) DEFAULT NULL COMMENT '更新人id',
  `update_date` datetime DEFAULT NULL COMMENT '更新时间',
  `user_id` bigint(20) DEFAULT NULL COMMENT '用户id',
  `account_type` int(4) DEFAULT NULL COMMENT '账号类型',
  `account_no` varchar(50) DEFAULT NULL COMMENT '账号',
  `password` varchar(50) DEFAULT NULL COMMENT '密码',
  `secret_key` varchar(50) DEFAULT NULL COMMENT '绑定密钥',
  `is_bind` tinyint(1) DEFAULT NULL COMMENT '是否绑定',
  `overdue_time` datetime DEFAULT NULL COMMENT '绑定过期时间',
  `status` varchar(32) DEFAULT NULL COMMENT '状态',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='账号绑定';

-- ----------------------------
-- Records of t_account_bind
-- ----------------------------

-- ----------------------------
-- Table structure for t_authorities
-- ----------------------------
DROP TABLE IF EXISTS `t_authorities`;
CREATE TABLE `t_authorities` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `create_by` bigint(20) DEFAULT NULL COMMENT '创建人id',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` bigint(20) DEFAULT NULL COMMENT '更新人id',
  `update_date` datetime DEFAULT NULL COMMENT '更新时间',
  `user_id` bigint(20) NOT NULL COMMENT '用户id',
  `authority` varchar(50) NOT NULL COMMENT '权限',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `ix_auth_username` (`user_id`,`authority`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=153213727645106188 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='权限表';

-- ----------------------------
-- Records of t_authorities
-- ----------------------------
INSERT INTO `t_authorities` VALUES ('1', null, null, null, null, '1000000000', 'ROLE_ADMIN');
INSERT INTO `t_authorities` VALUES ('2', null, null, null, null, '1000000000', 'ROLE_SU');
INSERT INTO `t_authorities` VALUES ('5', null, null, null, null, '1000000000', 'ROLE_USER');
INSERT INTO `t_authorities` VALUES ('153212753320869888', null, '2019-04-26 17:05:45', null, null, '1000000005', 'ROLE_ADMIN');
INSERT INTO `t_authorities` VALUES ('153212753320869889', null, '2019-04-26 17:05:45', null, null, '1000000005', 'ROLE_SU');
INSERT INTO `t_authorities` VALUES ('153213727645106187', null, null, null, null, '1000000001', 'ROLE_USER');
INSERT INTO `t_authorities` VALUES ('152236789137018880', null, null, null, null, '1000000005', 'ROLE_USER');
INSERT INTO `t_authorities` VALUES ('153213727645106186', null, null, null, null, '1000000019', 'ROLE_USER');

-- ----------------------------
-- Table structure for t_bill
-- ----------------------------
DROP TABLE IF EXISTS `t_bill`;
CREATE TABLE `t_bill` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `create_by` bigint(20) DEFAULT NULL COMMENT '创建人id',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` bigint(20) DEFAULT NULL COMMENT '更新人id',
  `update_date` datetime DEFAULT NULL COMMENT '更新时间',
  `bill_type` varchar(50) DEFAULT NULL COMMENT '账单分类',
  `bill_status` varchar(50) DEFAULT NULL COMMENT '账单状态',
  `bill_desc` varchar(100) DEFAULT NULL COMMENT '账单描述',
  `receiving_address` varchar(100) DEFAULT NULL COMMENT '收货地址',
  `logistics_info` varchar(50) DEFAULT NULL COMMENT '物流信息',
  `logistics_no` varchar(50) DEFAULT NULL COMMENT '物流号',
  `logistics_status` varchar(50) DEFAULT NULL COMMENT '物流状况',
  `bill_date` datetime DEFAULT NULL COMMENT '账单日期',
  `total_amount` double DEFAULT NULL COMMENT '付款金额',
  `quantity` int(11) DEFAULT NULL COMMENT '数量',
  `out_trade_no` varchar(50) DEFAULT NULL COMMENT '商户订单号',
  `to_member_name` varchar(50) DEFAULT NULL COMMENT '对方账号名称',
  `to_member_id` varchar(50) DEFAULT NULL COMMENT '对方账号',
  `payment_type` varchar(50) DEFAULT NULL COMMENT '付款方式',
  `payment_account_no` varchar(50) DEFAULT NULL COMMENT '付款账号',
  `reason` varchar(255) DEFAULT NULL COMMENT '理由',
  `integral_reward` int(11) DEFAULT NULL COMMENT '积分奖励',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `bill_context` longtext COMMENT '账单内容',
  `user_id` bigint(20) DEFAULT NULL COMMENT '用户id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=99550831044595713 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='订单';

-- ----------------------------
-- Records of t_bill
-- ----------------------------
INSERT INTO `t_bill` VALUES ('96425796905865216', null, '2018-11-23 14:58:30', null, null, null, '1', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '1');
INSERT INTO `t_bill` VALUES ('96426847977476096', null, '2018-11-23 14:58:34', null, null, '1', '1', 'app下单测试', null, null, null, null, null, '0.01', '1', null, null, null, null, null, null, null, null, '订单内容', '2');
INSERT INTO `t_bill` VALUES ('96427201976733696', null, null, null, null, '1', '1', 'app下单测试', null, null, null, null, null, '0.01', '1', null, null, null, null, null, null, null, null, '订单内容', '3');
INSERT INTO `t_bill` VALUES ('96427228090470400', null, null, null, null, '1', '1', 'web下单测试', null, null, null, null, null, '0.01', '1', null, null, null, null, null, null, null, null, '订单内容', '88603625256910848');
INSERT INTO `t_bill` VALUES ('96429136997912576', null, null, null, null, '1', '1', 'web下单测试', null, null, null, null, null, '1', '1', null, null, null, null, null, null, null, null, '订单内容', '88612918546923520');
INSERT INTO `t_bill` VALUES ('96430026467184640', null, null, null, null, '1', '1', 'web下单测试', null, null, null, null, null, '1', '1', null, null, null, null, null, null, null, null, '订单内容', '88612918546923520');
INSERT INTO `t_bill` VALUES ('96430832113291264', null, null, null, null, '1', '1', 'web下单测试', null, null, null, null, null, '1', '1', null, null, null, null, null, null, null, null, '订单内容', '1');
INSERT INTO `t_bill` VALUES ('96437935628488704', null, null, null, null, '1', '1', 'web下单测试', null, null, null, null, null, '0.01', '1', null, null, null, null, null, null, null, null, '订单内容', '88612918546923520');
INSERT INTO `t_bill` VALUES ('96439030799011840', null, null, null, null, '1', '1', 'web下单测试', null, null, null, null, null, '0.01', '1', null, null, null, null, null, null, null, null, '订单内容', '3');
INSERT INTO `t_bill` VALUES ('96562854160896000', null, null, null, null, '1', '1', 'web下单测试', null, null, null, null, null, '0.01', '1', null, null, null, null, null, null, null, null, '订单内容', '88612918546923520');
INSERT INTO `t_bill` VALUES ('96565841943990272', null, null, null, null, '1', '1', 'web下单测试', null, null, null, null, null, '0.01', '1', null, null, null, null, null, null, null, null, '订单内容', '2');
INSERT INTO `t_bill` VALUES ('96567083948707840', null, null, null, null, '1', '1', 'web下单测试', null, null, null, null, null, '0.01', '1', '38893725107093504', null, null, null, null, null, null, null, '订单内容', '1');
INSERT INTO `t_bill` VALUES ('96567979038347264', null, null, null, null, '1', '1', 'web下单测试', null, null, null, null, null, '0.01', '1', '38894620511305728', null, null, null, null, null, null, null, '订单内容', '1');
INSERT INTO `t_bill` VALUES ('96597624597123072', null, null, null, null, '0', '1', '测试统一下单', null, null, null, null, null, '0.01', '1', '38924265185083392', null, null, null, null, null, null, null, '付款详情页的订单信息', '1');
INSERT INTO `t_bill` VALUES ('96598706656251904', null, null, null, null, '0', '1', '测试统一下单', null, null, null, null, null, '0.01', '1', '38925347969826816', null, null, null, null, null, null, null, '付款详情页的订单信息', '1');
INSERT INTO `t_bill` VALUES ('99550831044595712', null, null, null, null, '0', '1', '测试统一下单', null, null, null, null, null, '0.01', '1', '41877472341393408', null, null, null, null, null, null, null, '付款详情页的订单信息', null);

-- ----------------------------
-- Table structure for t_dict_type
-- ----------------------------
DROP TABLE IF EXISTS `t_dict_type`;
CREATE TABLE `t_dict_type` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `create_by` bigint(20) DEFAULT NULL COMMENT '创建人id',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` bigint(20) DEFAULT NULL COMMENT '更新人id',
  `update_date` datetime DEFAULT NULL COMMENT '更新时间',
  `type_code` varchar(255) CHARACTER SET utf8 NOT NULL COMMENT '字典编码',
  `type_name` varchar(255) CHARACTER SET utf8 NOT NULL COMMENT '字典编码名称',
  `type_group_id` bigint(20) NOT NULL COMMENT '字典组id',
  `type_group_code` varchar(255) CHARACTER SET utf8 NOT NULL COMMENT '字典组编码',
  `order_num` int(4) DEFAULT NULL COMMENT '排序',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `fk_type_group_id` (`type_group_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=155566528442400769 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='字典';

-- ----------------------------
-- Records of t_dict_type
-- ----------------------------
INSERT INTO `t_dict_type` VALUES ('100000001', '1000000005', '2019-05-05 01:11:33', '1000000005', '2019-05-05 01:11:33', '0', 'phone', '1', 'login_type', '1');
INSERT INTO `t_dict_type` VALUES ('100000002', '1000000005', '2019-05-05 01:11:33', '1000000005', '2019-05-05 01:11:33', '1', 'web', '1', 'login_type', '2');
INSERT INTO `t_dict_type` VALUES ('100000003', '1000000005', '2019-05-05 01:11:33', '1000000005', '2019-05-05 01:11:33', '0', '不可用', '2', 'status', '0');
INSERT INTO `t_dict_type` VALUES ('100000004', '1000000005', '2019-05-05 01:11:33', '1000000005', '2019-05-05 01:11:33', '1', '可用', '2', 'status', '1');
INSERT INTO `t_dict_type` VALUES ('100000005', '1000000005', '2019-05-05 01:11:33', '1000000005', '2019-05-05 01:11:33', 'ROLE_USER', '普通用户', '3', 'role_type', '2');
INSERT INTO `t_dict_type` VALUES ('100000006', '1000000005', '2019-05-05 01:11:33', '1000000005', '2019-05-05 01:11:33', 'ROLE_ADMIN', '管理员', '3', 'role_type', '1');
INSERT INTO `t_dict_type` VALUES ('100000007', '1000000005', '2019-05-05 01:11:33', '1000000005', '2019-05-05 01:11:33', 'ROLE_SU', '超管', '3', 'role_type', '0');
INSERT INTO `t_dict_type` VALUES ('100000008', '1000000005', '2019-05-05 01:11:33', '1000000005', '2019-05-05 01:11:33', 'true', '男', '4', 'sex_type', '1');
INSERT INTO `t_dict_type` VALUES ('100000009', '1000000005', '2019-05-05 01:11:33', '1000000005', '2019-05-05 01:11:33', 'false', '女', '4', 'sex_type', '2');
INSERT INTO `t_dict_type` VALUES ('100000010', '1000000005', '2019-05-05 01:11:33', '1000000005', '2019-05-05 01:11:33', '0', '离线', '5', 'login_status', '1');
INSERT INTO `t_dict_type` VALUES ('100000011', '1000000005', '2019-05-05 01:11:33', '1000000005', '2019-05-05 01:11:33', '1', '在线', '5', 'login_status', '2');
INSERT INTO `t_dict_type` VALUES ('100000012', '1000000005', '2019-05-05 01:11:33', '1000000005', '2019-05-05 01:11:33', '0', '关闭', '6', 'alarm_clock_status', '1');
INSERT INTO `t_dict_type` VALUES ('100000013', '1000000005', '2019-05-05 01:11:33', '1000000005', '2019-05-05 01:11:33', '1', '启用', '6', 'alarm_clock_status', '2');
INSERT INTO `t_dict_type` VALUES ('100000014', '1000000005', '2019-05-05 01:11:33', '1000000005', '2019-05-05 01:11:33', '1', '一级菜单', '7', 'menu_type', '1');
INSERT INTO `t_dict_type` VALUES ('100000015', '1000000005', '2019-05-05 01:11:33', '1000000005', '2019-05-05 01:11:33', '2', '二级菜单', '7', 'menu_type', '2');
INSERT INTO `t_dict_type` VALUES ('95854276256989184', '1000000005', '2019-05-05 01:11:33', '1000000005', '2019-05-05 01:11:33', '2', '勿扰', '5', 'login_status', '3');
INSERT INTO `t_dict_type` VALUES ('96958562013544448', '1000000005', '2019-05-05 01:11:33', '1000000005', '2019-05-05 01:11:33', '1', '待付款', '96950073392365568', 'bill_status', '1');
INSERT INTO `t_dict_type` VALUES ('96959193222742016', '1000000005', '2019-05-05 01:11:33', '1000000005', '2019-05-05 01:11:33', '2', '已付款，待发货', '96950073392365568', 'bill_status', '2');
INSERT INTO `t_dict_type` VALUES ('96961451628953600', '1000000005', '2019-05-05 01:11:33', '1000000005', '2019-05-05 01:11:33', '3', '已发货，待收货', '96950073392365568', 'bill_status', '3');
INSERT INTO `t_dict_type` VALUES ('96962768984342528', '1000000005', '2019-05-05 01:11:33', '1000000005', '2019-05-05 01:11:33', '4', '交易成功', '96950073392365568', 'bill_status', '4');
INSERT INTO `t_dict_type` VALUES ('96963159130112000', '1000000005', '2019-05-05 01:11:33', '1000000005', '2019-05-05 01:11:33', '5', '交易关闭', '96950073392365568', 'bill_status', '5');
INSERT INTO `t_dict_type` VALUES ('96963562651516928', '1000000005', '2019-05-05 01:11:33', '1000000005', '2019-05-05 01:11:33', '6', '退款中', '96950073392365568', 'bill_status', '6');
INSERT INTO `t_dict_type` VALUES ('97357187684237312', '1000000005', '2019-05-05 01:11:33', '1000000005', '2019-05-05 01:11:33', '1', '充值', '97356870024429568', 'bill_type', '1');
INSERT INTO `t_dict_type` VALUES ('96964537789448192', '1000000005', '2019-05-05 01:11:33', '1000000005', '2019-05-05 01:11:33', '43', '发热', '95684503049076736', 'test', '1');
INSERT INTO `t_dict_type` VALUES ('96965184324632576', '1000000005', '2019-05-05 01:11:33', '1000000005', '2019-05-05 01:11:33', '3', '非人防', '95684503049076736', 'test', '1');
INSERT INTO `t_dict_type` VALUES ('96965451875090432', '1000000005', '2019-05-05 01:11:33', '1000000005', '2019-05-05 01:11:33', '44', '烦烦烦', '95684503049076736', 'test', '1');
INSERT INTO `t_dict_type` VALUES ('97354533956485120', '1000000005', '2019-05-05 01:11:33', '1000000005', '2019-05-05 01:11:33', '3', '3', '95684503049076736', 'test', '3');
INSERT INTO `t_dict_type` VALUES ('97366040169676800', '1000000005', '2019-05-05 01:11:33', '1000000005', '2019-05-05 01:11:33', 'alipay', '支付宝', '97365554750291968', 'payment_type', '1');
INSERT INTO `t_dict_type` VALUES ('97366110180999168', '1000000005', '2019-05-05 01:11:33', '1000000005', '2019-05-05 01:11:33', 'wxpay', '微信', '97365554750291968', 'payment_type', '2');
INSERT INTO `t_dict_type` VALUES ('97536125287006208', '1000000005', '2019-05-05 01:11:33', '1000000005', '2019-05-05 01:11:33', '1', '产品消息', '97535843673047040', 'msg_type', '1');
INSERT INTO `t_dict_type` VALUES ('97536221990879232', '1000000005', '2019-05-05 01:11:33', '1000000005', '2019-05-05 01:11:33', '2', '安全消息', '97535843673047040', 'msg_type', '2');
INSERT INTO `t_dict_type` VALUES ('97536285903683584', '1000000005', '2019-05-05 01:11:33', '1000000005', '2019-05-05 01:11:33', '3', '服务消息', '97535843673047040', 'msg_type', '3');
INSERT INTO `t_dict_type` VALUES ('97536343411785728', '1000000005', '2019-05-05 01:11:33', '1000000005', '2019-05-05 01:11:33', '4', '活动消息', '97535843673047040', 'msg_type', '4');
INSERT INTO `t_dict_type` VALUES ('97536415625117696', '1000000005', '2019-05-05 01:11:33', '1000000005', '2019-05-05 01:11:33', '5', '历史消息', '97535843673047040', 'msg_type', '5');
INSERT INTO `t_dict_type` VALUES ('97536494998126592', '1000000005', '2019-05-05 01:11:33', '1000000005', '2019-05-05 01:11:33', '6', '故障消息', '97535843673047040', 'msg_type', '6');
INSERT INTO `t_dict_type` VALUES ('99136468701675520', '1000000005', '2019-05-05 01:11:33', '1000000005', '2019-05-05 01:11:33', '1', 'banner', '99135515659337728', 'news_type', '1');
INSERT INTO `t_dict_type` VALUES ('155566528442400768', '1000000005', '2019-05-05 01:11:33', '1000000005', '2019-05-05 01:11:33', 'Transfer', '穿梭框', '155564655257845760', 'element_component', '14');
INSERT INTO `t_dict_type` VALUES ('155566444615041024', '1000000005', '2019-05-05 01:11:33', '1000000005', '2019-05-05 01:11:33', 'ColorPicker', '颜色选择器', '155564655257845760', 'element_component', '13');
INSERT INTO `t_dict_type` VALUES ('155566354039046144', '1000000005', '2019-05-05 01:11:33', '1000000005', '2019-05-05 01:11:33', 'Rate', '评分', '155564655257845760', 'element_component', '12');
INSERT INTO `t_dict_type` VALUES ('155566295306207232', '1000000005', '2019-05-05 01:11:33', '1000000005', '2019-05-05 01:11:33', 'Upload', '上传', '155564655257845760', 'element_component', '11');
INSERT INTO `t_dict_type` VALUES ('155566223822684160', '1000000005', '2019-05-05 01:11:33', '1000000005', '2019-05-05 01:11:33', 'DatePicker', '日期选择器', '155564655257845760', 'element_component', '10');
INSERT INTO `t_dict_type` VALUES ('155566122928701440', '1000000005', '2019-05-05 01:11:33', '1000000005', '2019-05-05 01:11:33', 'TimePicker', '时间选择器', '155564655257845760', 'element_component', '9');
INSERT INTO `t_dict_type` VALUES ('155566025453076480', '1000000005', '2019-05-05 01:11:33', '1000000005', '2019-05-05 01:11:33', 'Slider', '滑块', '155564655257845760', 'element_component', '8');
INSERT INTO `t_dict_type` VALUES ('155565960655273984', '1000000005', '2019-05-05 01:11:33', '1000000005', '2019-05-05 01:11:33', 'Switch', '开关', '155564655257845760', 'element_component', '7');
INSERT INTO `t_dict_type` VALUES ('155565909979693056', '1000000005', '2019-05-05 01:11:33', '1000000005', '2019-05-05 01:11:33', 'Cascader', '级联选择器', '155564655257845760', 'element_component', '6');
INSERT INTO `t_dict_type` VALUES ('155565797303910400', '1000000005', '2019-05-05 01:11:33', '1000000005', '2019-05-05 01:11:33', 'Select', '选择器', '155564655257845760', 'element_component', '5');
INSERT INTO `t_dict_type` VALUES ('155565698930704384', '1000000005', '2019-05-05 01:11:33', '1000000005', '2019-05-05 01:11:33', 'InputNumber', '计数器', '155564655257845760', 'element_component', '4');
INSERT INTO `t_dict_type` VALUES ('155565420294701056', '1000000005', '2019-05-05 01:11:33', '1000000005', '2019-05-05 01:11:33', 'Checkbox', '多选框', '155564655257845760', 'element_component', '3');
INSERT INTO `t_dict_type` VALUES ('155565360102244352', '1000000005', '2019-05-05 01:11:33', '1000000005', '2019-05-05 01:11:33', 'Radio', '单选框', '155564655257845760', 'element_component', '2');
INSERT INTO `t_dict_type` VALUES ('155565261192167424', '1000000005', '2019-05-05 01:11:33', '1000000005', '2019-05-05 01:11:33', 'Input', '输入框', '155564655257845760', 'element_component', '1');
INSERT INTO `t_dict_type` VALUES ('108265713587716096', '1000000005', '2019-05-05 01:11:33', '1000000005', '2019-05-05 01:11:33', '1', 'on', '108265224984854528', 'job_status', '1');
INSERT INTO `t_dict_type` VALUES ('108265787696873472', '1000000005', '2019-05-05 01:11:33', '1000000005', '2019-05-05 01:11:33', '0', 'off', '108265224984854528', 'job_status', '2');
INSERT INTO `t_dict_type` VALUES ('113787304258043904', '1000000005', '2019-05-05 01:11:33', '1000000005', '2019-05-05 01:11:33', '1', '草稿', '113787027396231168', 'news_status', '1');
INSERT INTO `t_dict_type` VALUES ('113787421593698304', '1000000005', '2019-05-05 01:11:33', '1000000005', '2019-05-05 01:11:33', '2', '发布', '113787027396231168', 'news_status', '2');
INSERT INTO `t_dict_type` VALUES ('119131930154237952', '1000000005', '2019-05-05 01:11:33', '1000000005', '2019-05-05 01:11:33', 'true', '激活', '113787027396231169', 'enabled_status', '1');
INSERT INTO `t_dict_type` VALUES ('119132047645081600', '1000000005', '2019-05-05 01:11:33', '1000000005', '2019-05-05 01:11:33', 'false', '禁用', '113787027396231169', 'enabled_status', '2');

-- ----------------------------
-- Table structure for t_dict_type_group
-- ----------------------------
DROP TABLE IF EXISTS `t_dict_type_group`;
CREATE TABLE `t_dict_type_group` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `create_by` bigint(20) DEFAULT NULL COMMENT '创建人id',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` bigint(20) DEFAULT NULL COMMENT '更新人id',
  `update_date` datetime DEFAULT NULL COMMENT '更新时间',
  `type_group_code` varchar(255) CHARACTER SET utf8 NOT NULL COMMENT '字典组编码',
  `type_group_name` varchar(255) CHARACTER SET utf8 NOT NULL COMMENT '字典组名称',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=155564655257845761 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='字典组';

-- ----------------------------
-- Records of t_dict_type_group
-- ----------------------------
INSERT INTO `t_dict_type_group` VALUES ('1', '1000000005', '2019-05-05 01:11:53', '1000000005', '2019-05-05 01:11:53', 'login_type', '登录方式');
INSERT INTO `t_dict_type_group` VALUES ('2', '1000000005', '2019-05-05 01:11:53', '1000000005', '2019-05-05 01:11:53', 'status', '状态');
INSERT INTO `t_dict_type_group` VALUES ('3', '1000000005', '2019-05-05 01:11:53', '1000000005', '2019-05-05 01:11:53', 'role_type', '角色种类');
INSERT INTO `t_dict_type_group` VALUES ('4', '1000000005', '2019-05-05 01:11:53', '1000000005', '2019-05-05 01:11:53', 'sex_type', '性别');
INSERT INTO `t_dict_type_group` VALUES ('5', '1000000005', '2019-05-05 01:11:53', '1000000005', '2019-05-05 01:11:53', 'login_status', '登录状态');
INSERT INTO `t_dict_type_group` VALUES ('6', '1000000005', '2019-05-05 01:11:53', '1000000005', '2019-05-05 01:11:53', 'alarm_clock_status', '闹钟状态');
INSERT INTO `t_dict_type_group` VALUES ('7', '1000000005', '2019-05-05 01:11:53', '1000000005', '2019-05-05 01:11:53', 'menu_type', '菜单类型');
INSERT INTO `t_dict_type_group` VALUES ('96950073392365568', '1000000005', '2019-05-05 01:11:53', '1000000005', '2019-05-05 01:11:53', 'bill_status', '订单状态');
INSERT INTO `t_dict_type_group` VALUES ('97356870024429568', '1000000005', '2019-05-05 01:11:53', '1000000005', '2019-05-05 01:11:53', 'bill_type', '账单类型');
INSERT INTO `t_dict_type_group` VALUES ('97365554750291968', '1000000005', '2019-05-05 01:11:53', '1000000005', '2019-05-05 01:11:53', 'payment_type', '支付方式');
INSERT INTO `t_dict_type_group` VALUES ('97535843673047040', '1000000005', '2019-05-05 01:11:53', '1000000005', '2019-05-05 01:11:53', 'msg_type', '消息类型');
INSERT INTO `t_dict_type_group` VALUES ('99135515659337728', '1000000005', '2019-05-05 01:11:53', '1000000005', '2019-05-05 01:11:53', 'news_type', '新闻类型');
INSERT INTO `t_dict_type_group` VALUES ('155564655257845760', '1000000005', '2019-05-05 01:11:53', '1000000005', '2019-05-05 01:11:53', 'element_component', '饿了么Element组件');
INSERT INTO `t_dict_type_group` VALUES ('108265224984854528', '1000000005', '2019-05-05 01:11:53', '1000000005', '2019-05-05 01:11:53', 'job_status', 'job状态');
INSERT INTO `t_dict_type_group` VALUES ('113787027396231168', '1000000005', '2019-05-05 01:11:53', '1000000005', '2019-05-05 01:11:53', 'news_status', '新闻状态');
INSERT INTO `t_dict_type_group` VALUES ('113787027396231169', '1000000005', '2019-05-05 01:11:53', '1000000005', '2019-05-05 01:11:53', 'enabled_status', '有效状态');

-- ----------------------------
-- Table structure for t_log_login
-- ----------------------------
DROP TABLE IF EXISTS `t_log_login`;
CREATE TABLE `t_log_login` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `create_by` bigint(20) DEFAULT NULL COMMENT '创建人id',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` bigint(20) DEFAULT NULL COMMENT '更新人id',
  `update_date` datetime DEFAULT NULL COMMENT '更新时间',
  `create_time` datetime DEFAULT NULL,
  `ip` varchar(255) DEFAULT NULL,
  `username` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=93524539023032321 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of t_log_login
-- ----------------------------

-- ----------------------------
-- Table structure for t_multi_language
-- ----------------------------
DROP TABLE IF EXISTS `t_multi_language`;
CREATE TABLE `t_multi_language` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `language_code` varchar(255) NOT NULL COMMENT '语言',
  `reference` varchar(255) NOT NULL COMMENT '参考',
  `message` varchar(255) NOT NULL COMMENT '信息',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='国际化信息';

-- ----------------------------
-- Records of t_multi_language
-- ----------------------------

-- ----------------------------
-- Table structure for t_news_info
-- ----------------------------
DROP TABLE IF EXISTS `t_news_info`;
CREATE TABLE `t_news_info` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `create_by` bigint(20) DEFAULT NULL COMMENT '创建人id',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` bigint(20) DEFAULT NULL COMMENT '更新人id',
  `update_date` datetime DEFAULT NULL COMMENT '更新时间',
  `title` varchar(255) DEFAULT NULL COMMENT '标题',
  `user_id` bigint(20) DEFAULT NULL COMMENT '用户id',
  `status` int(4) DEFAULT NULL COMMENT '状态',
  `content` text COMMENT '新闻内容',
  `image_url` varchar(255) DEFAULT NULL COMMENT '缩略图',
  `publish_date` datetime DEFAULT NULL COMMENT '发布时间',
  `tags` varchar(255) DEFAULT NULL COMMENT '标签',
  `news_type` int(4) DEFAULT NULL COMMENT '新闻类型',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=118466795840606209 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='新闻';

-- ----------------------------
-- Records of t_news_info
-- ----------------------------
INSERT INTO `t_news_info` VALUES ('114746419348377600', '1000000005', '2019-05-05 01:12:14', '1000000005', '2019-05-05 01:12:14', '测试', '1000000000', '1', '<p>1</p>', null, '2019-01-10 13:34:12', '1', '1');
INSERT INTO `t_news_info` VALUES ('117693842005823488', '1000000005', '2019-05-05 01:12:14', '1000000005', '2019-05-05 01:12:14', '测试', '1000000000', '2', '', null, '2019-01-18 16:58:34', '1', '1');

-- ----------------------------
-- Table structure for t_news_tag
-- ----------------------------
DROP TABLE IF EXISTS `t_news_tag`;
CREATE TABLE `t_news_tag` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `create_by` bigint(20) DEFAULT NULL COMMENT '创建人id',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` bigint(20) DEFAULT NULL COMMENT '更新人id',
  `update_date` datetime DEFAULT NULL COMMENT '更新时间',
  `news_info_id` bigint(20) DEFAULT NULL,
  `tag_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=FIXED;

-- ----------------------------
-- Records of t_news_tag
-- ----------------------------

-- ----------------------------
-- Table structure for t_notice_msg
-- ----------------------------
DROP TABLE IF EXISTS `t_notice_msg`;
CREATE TABLE `t_notice_msg` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `create_by` bigint(20) DEFAULT NULL COMMENT '创建人id',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` bigint(20) DEFAULT NULL COMMENT '更新人id',
  `update_date` datetime DEFAULT NULL COMMENT '更新时间',
  `user_id` bigint(20) DEFAULT NULL COMMENT '用户id',
  `msg_type` int(8) DEFAULT NULL COMMENT '消息类型',
  `content` longtext COMMENT '消息内容',
  `is_read` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否已读',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='通知消息';

-- ----------------------------
-- Records of t_notice_msg
-- ----------------------------

-- ----------------------------
-- Table structure for t_qr_code
-- ----------------------------
DROP TABLE IF EXISTS `t_qr_code`;
CREATE TABLE `t_qr_code` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `create_by` bigint(20) DEFAULT NULL COMMENT '创建人id',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` bigint(20) DEFAULT NULL COMMENT '更新人id',
  `update_date` datetime DEFAULT NULL COMMENT '更新时间',
  `is_ok` tinyint(1) DEFAULT NULL,
  `sid` varchar(255) DEFAULT NULL,
  `token` varchar(255) DEFAULT NULL,
  `username` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of t_qr_code
-- ----------------------------

-- ----------------------------
-- Table structure for t_reset_pwd_info
-- ----------------------------
DROP TABLE IF EXISTS `t_reset_pwd_info`;
CREATE TABLE `t_reset_pwd_info` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `create_by` bigint(20) DEFAULT NULL COMMENT '创建人id',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` bigint(20) DEFAULT NULL COMMENT '更新人id',
  `update_date` datetime DEFAULT NULL COMMENT '更新时间',
  `expires_in` timestamp(6) NULL DEFAULT NULL,
  `secret_key` varchar(255) DEFAULT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `valid` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of t_reset_pwd_info
-- ----------------------------

-- ----------------------------
-- Table structure for t_side_menu
-- ----------------------------
DROP TABLE IF EXISTS `t_side_menu`;
CREATE TABLE `t_side_menu` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `create_by` bigint(20) DEFAULT NULL COMMENT '创建人id',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` bigint(20) DEFAULT NULL COMMENT '更新人id',
  `update_date` datetime DEFAULT NULL COMMENT '更新时间',
  `name` varchar(255) DEFAULT NULL COMMENT '菜单名称',
  `url` varchar(255) DEFAULT NULL COMMENT '菜单地址',
  `request_method` varchar(25) NOT NULL DEFAULT '*',
  `icon` varchar(255) DEFAULT NULL COMMENT '菜单图标',
  `pid` bigint(20) DEFAULT NULL COMMENT '菜单组id',
  `order_num` int(4) NOT NULL DEFAULT '0' COMMENT '排序',
  `show_in_menu` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否显示在菜单列表',
  `entity_name` varchar(25) DEFAULT NULL COMMENT '实体类名',
  `remark` varchar(25) DEFAULT NULL COMMENT '备注',
  `link_id` bigint(20) DEFAULT NULL COMMENT '关联id',
  `menu_type` int(4) DEFAULT NULL COMMENT '菜单类型[1:一级菜单, 2:二级菜单, 3:三级菜单]',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=155328152225185805 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='侧边菜单表';

-- ----------------------------
-- Records of t_side_menu
-- ----------------------------
INSERT INTO `t_side_menu` VALUES ('119869773617172480', '1000000005', '2019-05-05 01:14:04', '1000000005', '2019-05-05 01:14:04', '删除', '/api/quartzJobs/ids', 'DELETE', '', '119869773415845888', '0', '0', 'QuartzJob', 'delete', '0', '3');
INSERT INTO `t_side_menu` VALUES ('12', '1000000005', '2019-05-05 01:14:04', '1000000005', '2019-05-05 01:14:04', '权限管理', '/api/authorities/list', '*', 'fas fa-lock', '1', '4', '1', 'Authority', 'list', '0', '2');
INSERT INTO `t_side_menu` VALUES ('3', '1000000005', '2019-05-05 01:14:04', '1000000005', '2019-05-05 01:14:04', '数据字典', '/api/dictTypeGroups/list', '*', 'fa fa-book', '1', '5', '1', 'DictTypeGroup', 'list', '0', '2');
INSERT INTO `t_side_menu` VALUES ('90997036798705664', '1000000005', '2019-05-05 01:14:04', '1000000005', '2019-05-05 01:14:04', 'druid', '/druid/index.html', '*', 'fa fa-cog', '90995059306004480', '3', '1', null, null, '0', '2');
INSERT INTO `t_side_menu` VALUES ('8', '1000000005', '2019-05-05 01:14:04', '1000000005', '2019-05-05 01:14:04', '菜单管理', '/api/sideMenus/list', '*', 'fas fa-list-ul', '1', '2', '1', 'SideMenu', 'list', '0', '2');
INSERT INTO `t_side_menu` VALUES ('94108390556434432', '1000000005', '2019-05-05 01:14:04', '1000000005', '2019-05-05 01:14:04', '了解OauthServer', '/easyui/home.html', '*', 'fas fa-compass', '94105929343041536', '1', '1', null, null, '0', '2');
INSERT INTO `t_side_menu` VALUES ('1', '1000000005', '2019-05-05 01:14:04', '1000000005', '2019-05-05 01:14:04', '系统管理', '', '*', 'fas fa-tools', '0', '2', '1', null, null, '0', '1');
INSERT INTO `t_side_menu` VALUES ('93126997827387392', '1000000005', '2019-05-05 01:14:04', '1000000005', '2019-05-05 01:14:04', '日志管理', '/api/loggingEvents?easyui-list', '*', 'fa fa-book', '90995059306004480', '4', '1', null, null, '0', '2');
INSERT INTO `t_side_menu` VALUES ('119869773600395264', '1000000005', '2019-05-05 01:14:04', '1000000005', '2019-05-05 01:14:04', '修改', '/api/quartzJobs/edit', 'GET,PATCH', '', '119869773415845888', '0', '0', 'QuartzJob', 'edit', '0', '2');
INSERT INTO `t_side_menu` VALUES ('80832133433655296', '1000000005', '2019-05-05 01:14:04', '1000000005', '2019-05-05 01:14:04', '代码生成', '/api/tables/list', '*', 'fa fa-table', '90995059306004480', '1', '1', null, null, '0', '3');
INSERT INTO `t_side_menu` VALUES ('90995059306004480', '1000000005', '2019-05-05 01:14:04', '1000000005', '2019-05-05 01:14:04', '系统工具', '', '*', 'fas fa-cogs', '0', '3', '1', null, null, '0', '2');
INSERT INTO `t_side_menu` VALUES ('90995810619097088', '1000000005', '2019-05-05 01:14:04', '1000000005', '2019-05-05 01:14:04', 'swagger', '/swagger-ui.html', '*', 'fa fa-cog', '90995059306004480', '2', '1', null, null, '0', '2');
INSERT INTO `t_side_menu` VALUES ('94105929343041536', '1000000005', '2019-05-05 01:14:04', '1000000005', '2019-05-05 01:14:04', '主页', null, '*', 'fas fa-home', '0', '1', '1', null, null, '0', '1');
INSERT INTO `t_side_menu` VALUES ('119869773587812352', '1000000005', '2019-05-05 01:14:04', '1000000005', '2019-05-05 01:14:04', '新增', '/api/quartzJobs/add', 'GET,POST', '', '119869773415845888', '0', '0', 'QuartzJob', 'add', '0', '3');
INSERT INTO `t_side_menu` VALUES ('118471356282179584', '1000000005', '2019-05-05 01:14:04', '1000000005', '2019-05-05 01:14:04', '删除', '/api/newsInfos/ids', 'DELETE', '', '118471356118601728', '0', '0', 'NewsInfo', 'delete', '0', '3');
INSERT INTO `t_side_menu` VALUES ('118471356265402368', '1000000005', '2019-05-05 01:14:04', '1000000005', '2019-05-05 01:14:04', '修改', '/api/newsInfos/edit', 'GET,PATCH', '', '118471356118601728', '0', '0', 'NewsInfo', 'edit', '0', '3');
INSERT INTO `t_side_menu` VALUES ('118471356248625152', '1000000005', '2019-05-05 01:14:04', '1000000005', '2019-05-05 01:14:04', '新增', '/api/newsInfos/add', 'GET,POST', '', '118471356118601728', '0', '0', 'NewsInfo', 'add', '0', '3');
INSERT INTO `t_side_menu` VALUES ('118471356227653632', '1000000005', '2019-05-05 01:14:04', '1000000005', '2019-05-05 01:14:04', '查看', '/api/newsInfos/data', 'GET', '', '118471356118601728', '0', '0', 'NewsInfo', 'data', '118471356118601728', '3');
INSERT INTO `t_side_menu` VALUES ('118471356118601728', '1000000005', '2019-05-05 01:14:04', '1000000005', '2019-05-05 01:14:04', '新闻管理', '/api/newsInfos/list', 'GET', 'fas fa-file-alt', '94105929343041536', '2', '1', 'NewsInfo', 'list', '0', '2');
INSERT INTO `t_side_menu` VALUES ('107876685461848070', '1000000005', '2019-05-05 01:14:04', '1000000005', '2019-05-05 01:14:04', '角色管理', '/api/roleAuthorities/list', 'GET', 'fa fa-user', '1', '6', '1', 'RoleAuthority', 'list', '0', '2');
INSERT INTO `t_side_menu` VALUES ('107876685461848071', '1000000005', '2019-05-05 01:14:04', '1000000005', '2019-05-05 01:14:04', '订单管理', '/api/bills/list', '*', 'fas fa-dollar-sign', '94105929343041536', '3', '1', null, null, '0', '2');
INSERT INTO `t_side_menu` VALUES ('119869773415845888', '1000000005', '2019-05-05 01:14:04', '1000000005', '2019-05-05 01:14:04', '任务管理', '/api/quartzJobs/list', 'GET', 'fas fa-tasks', '1', '0', '1', 'QuartzJob', 'list', '0', '2');
INSERT INTO `t_side_menu` VALUES ('119494224726069248', '1000000005', '2019-05-05 01:14:04', '1000000005', '2019-05-05 01:14:04', '删除', '/api/oauthUsers/ids', 'DELETE', '', '119494224361164800', '0', '0', 'OauthUser', 'delete', '0', '3');
INSERT INTO `t_side_menu` VALUES ('119869773566840832', '1000000005', '2019-05-05 01:14:04', '1000000005', '2019-05-05 01:14:04', '查看', '/api/quartzJobs/data', 'GET', '', '119869773415845888', '0', '0', 'QuartzJob', 'data', '119869773415845888', '3');
INSERT INTO `t_side_menu` VALUES ('119494224713486336', '1000000005', '2019-05-05 01:14:04', '1000000005', '2019-05-05 01:14:04', '修改', '/api/oauthUsers/edit', 'GET,PATCH', '', '119494224361164800', '0', '0', 'OauthUser', 'edit', '0', '3');
INSERT INTO `t_side_menu` VALUES ('119494224361164800', '1000000005', '2019-05-05 01:14:04', '1000000005', '2019-05-05 01:14:04', '用户管理', '/api/oauthUsers/list', 'GET', 'fas fa-user-circle', '1', '4', '1', 'OauthUser', 'list', '0', '2');
INSERT INTO `t_side_menu` VALUES ('119494224675737600', '1000000005', '2019-05-05 01:14:04', '1000000005', '2019-05-05 01:14:04', '查看', '/api/oauthUsers/data', 'GET', '', '119494224361164800', '0', '0', 'OauthUser', 'data', '119494224361164800', '3');
INSERT INTO `t_side_menu` VALUES ('119494224700903424', '1000000005', '2019-05-05 01:14:04', '1000000005', '2019-05-05 01:14:04', '新增', '/api/oauthUsers/add', 'GET,POST', '', '119494224361164800', '0', '0', 'OauthUser', 'add', '0', '3');
INSERT INTO `t_side_menu` VALUES ('155328152225185792', '1000000005', '2019-05-05 01:14:04', '1000000005', '2019-05-05 01:14:04', 'demo', null, '*', 'fas fa-chart-area', '0', '4', '1', null, null, '0', '1');
INSERT INTO `t_side_menu` VALUES ('154250076045316096', '1000000005', '2019-05-05 01:14:04', '1000000005', '2019-05-05 01:14:04', '图标管理', '/api/fontAwesomes/list', 'GET', 'fas fa-list-ol', '1', '0', '1', 'FontAwesome', 'list', '0', '2');
INSERT INTO `t_side_menu` VALUES ('154250076150173696', '1000000005', '2019-05-05 01:14:04', '1000000005', '2019-05-05 01:14:04', '查看', '/api/fontAwesomes/data', 'GET', '', '154250076045316096', '0', '0', 'FontAwesome', 'data', '154250076045316096', '3');
INSERT INTO `t_side_menu` VALUES ('154250076171145216', '1000000005', '2019-05-05 01:14:04', '1000000005', '2019-05-05 01:14:04', '新增', '/api/fontAwesomes/add', 'GET,POST', '', '154250076045316096', '0', '0', 'FontAwesome', 'add', '0', '3');
INSERT INTO `t_side_menu` VALUES ('154250076196311040', '1000000005', '2019-05-05 01:14:04', '1000000005', '2019-05-05 01:14:04', '修改', '/api/fontAwesomes/edit', 'GET,PATCH', '', '154250076045316096', '0', '0', 'FontAwesome', 'edit', '0', '3');
INSERT INTO `t_side_menu` VALUES ('154250076221476864', '1000000005', '2019-05-05 01:14:04', '1000000005', '2019-05-05 01:14:04', '删除', '/api/fontAwesomes/ids', 'DELETE', '', '154250076045316096', '0', '0', 'FontAwesome', 'delete', '0', '3');
INSERT INTO `t_side_menu` VALUES ('155328152225185793', '1000000005', '2019-05-05 01:14:04', '1000000005', '2019-05-05 01:14:04', '删除', '/api/authorities/ids', 'DELETE', '', '12', '0', '0', 'Authority', 'delete', '0', '3');
INSERT INTO `t_side_menu` VALUES ('155328152225185794', '1000000005', '2019-05-05 01:14:04', '1000000005', '2019-05-05 01:14:04', '修改', '/api/authorities/edit', 'GET,PATCH', '', '12', '0', '0', 'Authority', 'edit', '0', '3');
INSERT INTO `t_side_menu` VALUES ('155328152225185795', '1000000005', '2019-05-05 01:14:04', '1000000005', '2019-05-05 01:14:04', '新增', '/api/authorities/add', 'GET,POST', '', '12', '0', '0', 'Authority', 'add', '0', '3');
INSERT INTO `t_side_menu` VALUES ('155328152225185796', '1000000005', '2019-05-05 01:14:04', '1000000005', '2019-05-05 01:14:04', '查看', '/api/authorities/data', 'GET', '', '12', '0', '0', 'Authority', 'data', '12', '3');
INSERT INTO `t_side_menu` VALUES ('155328152225185797', '1000000005', '2019-05-05 01:14:04', '1000000005', '2019-05-05 01:14:04', '删除', '/api/dictTypeGroups/ids', 'DELETE', '', '3', '0', '0', 'DictTypeGroup', 'delete', '0', '3');
INSERT INTO `t_side_menu` VALUES ('155328152225185798', '1000000005', '2019-05-05 01:14:04', '1000000005', '2019-05-05 01:14:04', '修改', '/api/dictTypeGroups/edit', 'GET,PATCH', '', '3', '0', '0', 'DictTypeGroup', 'edit', '0', '3');
INSERT INTO `t_side_menu` VALUES ('155328152225185799', '1000000005', '2019-05-05 01:14:04', '1000000005', '2019-05-05 01:14:04', '新增', '/api/dictTypeGroups/add', 'GET,POST', '', '3', '0', '0', 'DictTypeGroup', 'add', '0', '3');
INSERT INTO `t_side_menu` VALUES ('155328152225185800', '1000000005', '2019-05-05 01:14:04', '1000000005', '2019-05-05 01:14:04', '查看', '/api/dictTypeGroups/data', 'GET', '', '3', '0', '0', 'DictTypeGroup', 'data', '3', '3');
INSERT INTO `t_side_menu` VALUES ('155328152225185801', '1000000005', '2019-05-05 01:14:04', '1000000005', '2019-05-05 01:14:04', '删除', '/api/sideMenus/ids', 'DELETE', '', '8', '0', '0', 'SideMenu', 'delete', '0', '3');
INSERT INTO `t_side_menu` VALUES ('155328152225185802', '1000000005', '2019-05-05 01:14:04', '1000000005', '2019-05-05 01:14:04', '修改', '/api/sideMenus/edit', 'GET,PATCH', '', '8', '0', '0', 'SideMenu', 'edit', '0', '3');
INSERT INTO `t_side_menu` VALUES ('155328152225185803', '1000000005', '2019-05-05 01:14:04', '1000000005', '2019-05-05 01:14:04', '新增', '/api/sideMenus/add', 'GET,POST', '', '8', '0', '0', 'SideMenu', 'add', '0', '3');
INSERT INTO `t_side_menu` VALUES ('155328152225185804', '1000000005', '2019-05-05 01:14:04', '1000000005', '2019-05-05 01:14:04', '查看', '/api/sideMenus/data', 'GET', '', '8', '0', '0', 'SideMenu', 'data', '8', '3');

-- ----------------------------
-- Table structure for t_side_menu_authority
-- ----------------------------
DROP TABLE IF EXISTS `t_side_menu_authority`;
CREATE TABLE `t_side_menu_authority` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `create_by` bigint(20) DEFAULT NULL COMMENT '创建人id',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` bigint(20) DEFAULT NULL COMMENT '更新人id',
  `update_date` datetime DEFAULT NULL COMMENT '更新时间',
  `side_menu_id` bigint(20) NOT NULL,
  `authority` varchar(50) NOT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `tsma_index_sid_au` (`side_menu_id`,`authority`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=154250076330529182 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of t_side_menu_authority
-- ----------------------------
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529135', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '155328152225185792', 'ROLE_USER');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529120', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '155328152225185792', 'ROLE_ADMIN');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529118', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '90997036798705664', 'ROLE_ADMIN');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529119', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '93126997827387392', 'ROLE_ADMIN');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529181', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '155328152225185792', 'ROLE_SU');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529180', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '93126997827387392', 'ROLE_SU');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529179', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '90997036798705664', 'ROLE_SU');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529178', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '90995810619097088', 'ROLE_SU');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529177', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '80832133433655296', 'ROLE_SU');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529176', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '90995059306004480', 'ROLE_SU');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529175', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '107876685461848070', 'ROLE_SU');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529174', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '155328152225185800', 'ROLE_SU');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529173', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '155328152225185799', 'ROLE_SU');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529172', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '155328152225185798', 'ROLE_SU');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529171', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '155328152225185797', 'ROLE_SU');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529170', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '3', 'ROLE_SU');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529169', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '155328152225185796', 'ROLE_SU');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529168', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '155328152225185795', 'ROLE_SU');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529167', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '155328152225185794', 'ROLE_SU');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529166', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '155328152225185793', 'ROLE_SU');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529165', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '12', 'ROLE_SU');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529164', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '155328152225185804', 'ROLE_SU');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529163', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '155328152225185803', 'ROLE_SU');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529162', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '155328152225185802', 'ROLE_SU');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529161', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '155328152225185801', 'ROLE_SU');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529160', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '8', 'ROLE_SU');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529159', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '154250076221476864', 'ROLE_SU');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529158', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '154250076196311040', 'ROLE_SU');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529157', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '154250076171145216', 'ROLE_SU');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529156', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '154250076150173696', 'ROLE_SU');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529155', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '154250076045316096', 'ROLE_SU');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529154', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '119869773617172480', 'ROLE_SU');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529153', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '119869773600395264', 'ROLE_SU');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529152', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '119869773587812352', 'ROLE_SU');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529151', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '119869773566840832', 'ROLE_SU');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529150', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '119869773415845888', 'ROLE_SU');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529149', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '1', 'ROLE_SU');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529148', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '107876685461848071', 'ROLE_SU');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529147', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '94108390556434432', 'ROLE_SU');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529146', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '119494224726069248', 'ROLE_SU');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529145', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '119494224713486336', 'ROLE_SU');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529144', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '119494224700903424', 'ROLE_SU');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529143', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '119494224675737600', 'ROLE_SU');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529142', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '119494224361164800', 'ROLE_SU');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529141', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '118471356282179584', 'ROLE_SU');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529140', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '118471356265402368', 'ROLE_SU');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529117', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '90995810619097088', 'ROLE_ADMIN');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529116', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '80832133433655296', 'ROLE_ADMIN');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529115', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '90995059306004480', 'ROLE_ADMIN');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529114', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '107876685461848070', 'ROLE_ADMIN');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529113', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '107876685461848071', 'ROLE_ADMIN');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529112', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '94108390556434432', 'ROLE_ADMIN');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529108', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '119494224675737600', 'ROLE_ADMIN');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529109', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '119494224700903424', 'ROLE_ADMIN');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529110', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '119494224713486336', 'ROLE_ADMIN');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529111', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '119494224726069248', 'ROLE_ADMIN');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529139', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '118471356248625152', 'ROLE_SU');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529138', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '118471356227653632', 'ROLE_SU');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529137', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '118471356118601728', 'ROLE_SU');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529136', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '94105929343041536', 'ROLE_SU');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529107', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '119494224361164800', 'ROLE_ADMIN');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529134', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '154250076221476864', 'ROLE_USER');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529133', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '154250076196311040', 'ROLE_USER');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529132', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '154250076171145216', 'ROLE_USER');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529131', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '154250076150173696', 'ROLE_USER');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529130', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '154250076045316096', 'ROLE_USER');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529129', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '119869773617172480', 'ROLE_USER');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529128', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '119869773600395264', 'ROLE_USER');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529127', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '119869773587812352', 'ROLE_USER');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529126', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '119869773566840832', 'ROLE_USER');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529125', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '119869773415845888', 'ROLE_USER');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529124', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '119494224675737600', 'ROLE_USER');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529123', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '118471356265402368', 'ROLE_USER');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529122', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '118471356248625152', 'ROLE_USER');
INSERT INTO `t_side_menu_authority` VALUES ('154250076330529121', '1000000005', '2019-05-05 01:14:36', '1000000005', '2019-05-05 01:14:36', '118471356227653632', 'ROLE_USER');

-- ----------------------------
-- Table structure for t_s_city
-- ----------------------------
DROP TABLE IF EXISTS `t_s_city`;
CREATE TABLE `t_s_city` (
  `id` int(11) NOT NULL,
  `name` varchar(64) DEFAULT NULL,
  `city_id` varchar(12) DEFAULT NULL,
  `province_id` varchar(12) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Records of t_s_city
-- ----------------------------
INSERT INTO `t_s_city` VALUES ('1', '市辖区', '110100000000', '110000000000');
INSERT INTO `t_s_city` VALUES ('2', '市辖区', '120100000000', '120000000000');
INSERT INTO `t_s_city` VALUES ('3', '石家庄市', '130100000000', '130000000000');
INSERT INTO `t_s_city` VALUES ('4', '唐山市', '130200000000', '130000000000');
INSERT INTO `t_s_city` VALUES ('5', '秦皇岛市', '130300000000', '130000000000');
INSERT INTO `t_s_city` VALUES ('6', '邯郸市', '130400000000', '130000000000');
INSERT INTO `t_s_city` VALUES ('7', '邢台市', '130500000000', '130000000000');
INSERT INTO `t_s_city` VALUES ('8', '保定市', '130600000000', '130000000000');
INSERT INTO `t_s_city` VALUES ('9', '张家口市', '130700000000', '130000000000');
INSERT INTO `t_s_city` VALUES ('10', '承德市', '130800000000', '130000000000');
INSERT INTO `t_s_city` VALUES ('11', '沧州市', '130900000000', '130000000000');
INSERT INTO `t_s_city` VALUES ('12', '廊坊市', '131000000000', '130000000000');
INSERT INTO `t_s_city` VALUES ('13', '衡水市', '131100000000', '130000000000');
INSERT INTO `t_s_city` VALUES ('14', '太原市', '140100000000', '140000000000');
INSERT INTO `t_s_city` VALUES ('15', '大同市', '140200000000', '140000000000');
INSERT INTO `t_s_city` VALUES ('16', '阳泉市', '140300000000', '140000000000');
INSERT INTO `t_s_city` VALUES ('17', '长治市', '140400000000', '140000000000');
INSERT INTO `t_s_city` VALUES ('18', '晋城市', '140500000000', '140000000000');
INSERT INTO `t_s_city` VALUES ('19', '朔州市', '140600000000', '140000000000');
INSERT INTO `t_s_city` VALUES ('20', '晋中市', '140700000000', '140000000000');
INSERT INTO `t_s_city` VALUES ('21', '运城市', '140800000000', '140000000000');
INSERT INTO `t_s_city` VALUES ('22', '忻州市', '140900000000', '140000000000');
INSERT INTO `t_s_city` VALUES ('23', '临汾市', '141000000000', '140000000000');
INSERT INTO `t_s_city` VALUES ('24', '吕梁市', '141100000000', '140000000000');
INSERT INTO `t_s_city` VALUES ('25', '呼和浩特市', '150100000000', '150000000000');
INSERT INTO `t_s_city` VALUES ('26', '包头市', '150200000000', '150000000000');
INSERT INTO `t_s_city` VALUES ('27', '乌海市', '150300000000', '150000000000');
INSERT INTO `t_s_city` VALUES ('28', '赤峰市', '150400000000', '150000000000');
INSERT INTO `t_s_city` VALUES ('29', '通辽市', '150500000000', '150000000000');
INSERT INTO `t_s_city` VALUES ('30', '鄂尔多斯市', '150600000000', '150000000000');
INSERT INTO `t_s_city` VALUES ('31', '呼伦贝尔市', '150700000000', '150000000000');
INSERT INTO `t_s_city` VALUES ('32', '巴彦淖尔市', '150800000000', '150000000000');
INSERT INTO `t_s_city` VALUES ('33', '乌兰察布市', '150900000000', '150000000000');
INSERT INTO `t_s_city` VALUES ('34', '兴安盟', '152200000000', '150000000000');
INSERT INTO `t_s_city` VALUES ('35', '锡林郭勒盟', '152500000000', '150000000000');
INSERT INTO `t_s_city` VALUES ('36', '阿拉善盟', '152900000000', '150000000000');
INSERT INTO `t_s_city` VALUES ('37', '沈阳市', '210100000000', '210000000000');
INSERT INTO `t_s_city` VALUES ('38', '大连市', '210200000000', '210000000000');
INSERT INTO `t_s_city` VALUES ('39', '鞍山市', '210300000000', '210000000000');
INSERT INTO `t_s_city` VALUES ('40', '抚顺市', '210400000000', '210000000000');
INSERT INTO `t_s_city` VALUES ('41', '本溪市', '210500000000', '210000000000');
INSERT INTO `t_s_city` VALUES ('42', '丹东市', '210600000000', '210000000000');
INSERT INTO `t_s_city` VALUES ('43', '锦州市', '210700000000', '210000000000');
INSERT INTO `t_s_city` VALUES ('44', '营口市', '210800000000', '210000000000');
INSERT INTO `t_s_city` VALUES ('45', '阜新市', '210900000000', '210000000000');
INSERT INTO `t_s_city` VALUES ('46', '辽阳市', '211000000000', '210000000000');
INSERT INTO `t_s_city` VALUES ('47', '盘锦市', '211100000000', '210000000000');
INSERT INTO `t_s_city` VALUES ('48', '铁岭市', '211200000000', '210000000000');
INSERT INTO `t_s_city` VALUES ('49', '朝阳市', '211300000000', '210000000000');
INSERT INTO `t_s_city` VALUES ('50', '葫芦岛市', '211400000000', '210000000000');
INSERT INTO `t_s_city` VALUES ('51', '长春市', '220100000000', '220000000000');
INSERT INTO `t_s_city` VALUES ('52', '吉林市', '220200000000', '220000000000');
INSERT INTO `t_s_city` VALUES ('53', '四平市', '220300000000', '220000000000');
INSERT INTO `t_s_city` VALUES ('54', '辽源市', '220400000000', '220000000000');
INSERT INTO `t_s_city` VALUES ('55', '通化市', '220500000000', '220000000000');
INSERT INTO `t_s_city` VALUES ('56', '白山市', '220600000000', '220000000000');
INSERT INTO `t_s_city` VALUES ('57', '松原市', '220700000000', '220000000000');
INSERT INTO `t_s_city` VALUES ('58', '白城市', '220800000000', '220000000000');
INSERT INTO `t_s_city` VALUES ('59', '延边朝鲜族自治州', '222400000000', '220000000000');
INSERT INTO `t_s_city` VALUES ('60', '哈尔滨市', '230100000000', '230000000000');
INSERT INTO `t_s_city` VALUES ('61', '齐齐哈尔市', '230200000000', '230000000000');
INSERT INTO `t_s_city` VALUES ('62', '鸡西市', '230300000000', '230000000000');
INSERT INTO `t_s_city` VALUES ('63', '鹤岗市', '230400000000', '230000000000');
INSERT INTO `t_s_city` VALUES ('64', '双鸭山市', '230500000000', '230000000000');
INSERT INTO `t_s_city` VALUES ('65', '大庆市', '230600000000', '230000000000');
INSERT INTO `t_s_city` VALUES ('66', '伊春市', '230700000000', '230000000000');
INSERT INTO `t_s_city` VALUES ('67', '佳木斯市', '230800000000', '230000000000');
INSERT INTO `t_s_city` VALUES ('68', '七台河市', '230900000000', '230000000000');
INSERT INTO `t_s_city` VALUES ('69', '牡丹江市', '231000000000', '230000000000');
INSERT INTO `t_s_city` VALUES ('70', '黑河市', '231100000000', '230000000000');
INSERT INTO `t_s_city` VALUES ('71', '绥化市', '231200000000', '230000000000');
INSERT INTO `t_s_city` VALUES ('72', '大兴安岭地区', '232700000000', '230000000000');
INSERT INTO `t_s_city` VALUES ('73', '市辖区', '310100000000', '310000000000');
INSERT INTO `t_s_city` VALUES ('74', '南京市', '320100000000', '320000000000');
INSERT INTO `t_s_city` VALUES ('75', '无锡市', '320200000000', '320000000000');
INSERT INTO `t_s_city` VALUES ('76', '徐州市', '320300000000', '320000000000');
INSERT INTO `t_s_city` VALUES ('77', '常州市', '320400000000', '320000000000');
INSERT INTO `t_s_city` VALUES ('78', '苏州市', '320500000000', '320000000000');
INSERT INTO `t_s_city` VALUES ('79', '南通市', '320600000000', '320000000000');
INSERT INTO `t_s_city` VALUES ('80', '连云港市', '320700000000', '320000000000');
INSERT INTO `t_s_city` VALUES ('81', '淮安市', '320800000000', '320000000000');
INSERT INTO `t_s_city` VALUES ('82', '盐城市', '320900000000', '320000000000');
INSERT INTO `t_s_city` VALUES ('83', '扬州市', '321000000000', '320000000000');
INSERT INTO `t_s_city` VALUES ('84', '镇江市', '321100000000', '320000000000');
INSERT INTO `t_s_city` VALUES ('85', '泰州市', '321200000000', '320000000000');
INSERT INTO `t_s_city` VALUES ('86', '宿迁市', '321300000000', '320000000000');
INSERT INTO `t_s_city` VALUES ('87', '杭州市', '330100000000', '330000000000');
INSERT INTO `t_s_city` VALUES ('88', '宁波市', '330200000000', '330000000000');
INSERT INTO `t_s_city` VALUES ('89', '温州市', '330300000000', '330000000000');
INSERT INTO `t_s_city` VALUES ('90', '嘉兴市', '330400000000', '330000000000');
INSERT INTO `t_s_city` VALUES ('91', '湖州市', '330500000000', '330000000000');
INSERT INTO `t_s_city` VALUES ('92', '绍兴市', '330600000000', '330000000000');
INSERT INTO `t_s_city` VALUES ('93', '金华市', '330700000000', '330000000000');
INSERT INTO `t_s_city` VALUES ('94', '衢州市', '330800000000', '330000000000');
INSERT INTO `t_s_city` VALUES ('95', '舟山市', '330900000000', '330000000000');
INSERT INTO `t_s_city` VALUES ('96', '台州市', '331000000000', '330000000000');
INSERT INTO `t_s_city` VALUES ('97', '丽水市', '331100000000', '330000000000');
INSERT INTO `t_s_city` VALUES ('98', '合肥市', '340100000000', '340000000000');
INSERT INTO `t_s_city` VALUES ('99', '芜湖市', '340200000000', '340000000000');
INSERT INTO `t_s_city` VALUES ('100', '蚌埠市', '340300000000', '340000000000');
INSERT INTO `t_s_city` VALUES ('101', '淮南市', '340400000000', '340000000000');
INSERT INTO `t_s_city` VALUES ('102', '马鞍山市', '340500000000', '340000000000');
INSERT INTO `t_s_city` VALUES ('103', '淮北市', '340600000000', '340000000000');
INSERT INTO `t_s_city` VALUES ('104', '铜陵市', '340700000000', '340000000000');
INSERT INTO `t_s_city` VALUES ('105', '安庆市', '340800000000', '340000000000');
INSERT INTO `t_s_city` VALUES ('106', '黄山市', '341000000000', '340000000000');
INSERT INTO `t_s_city` VALUES ('107', '滁州市', '341100000000', '340000000000');
INSERT INTO `t_s_city` VALUES ('108', '阜阳市', '341200000000', '340000000000');
INSERT INTO `t_s_city` VALUES ('109', '宿州市', '341300000000', '340000000000');
INSERT INTO `t_s_city` VALUES ('110', '六安市', '341500000000', '340000000000');
INSERT INTO `t_s_city` VALUES ('111', '亳州市', '341600000000', '340000000000');
INSERT INTO `t_s_city` VALUES ('112', '池州市', '341700000000', '340000000000');
INSERT INTO `t_s_city` VALUES ('113', '宣城市', '341800000000', '340000000000');
INSERT INTO `t_s_city` VALUES ('114', '福州市', '350100000000', '350000000000');
INSERT INTO `t_s_city` VALUES ('115', '厦门市', '350200000000', '350000000000');
INSERT INTO `t_s_city` VALUES ('116', '莆田市', '350300000000', '350000000000');
INSERT INTO `t_s_city` VALUES ('117', '三明市', '350400000000', '350000000000');
INSERT INTO `t_s_city` VALUES ('118', '泉州市', '350500000000', '350000000000');
INSERT INTO `t_s_city` VALUES ('119', '漳州市', '350600000000', '350000000000');
INSERT INTO `t_s_city` VALUES ('120', '南平市', '350700000000', '350000000000');
INSERT INTO `t_s_city` VALUES ('121', '龙岩市', '350800000000', '350000000000');
INSERT INTO `t_s_city` VALUES ('122', '宁德市', '350900000000', '350000000000');
INSERT INTO `t_s_city` VALUES ('123', '南昌市', '360100000000', '360000000000');
INSERT INTO `t_s_city` VALUES ('124', '景德镇市', '360200000000', '360000000000');
INSERT INTO `t_s_city` VALUES ('125', '萍乡市', '360300000000', '360000000000');
INSERT INTO `t_s_city` VALUES ('126', '九江市', '360400000000', '360000000000');
INSERT INTO `t_s_city` VALUES ('127', '新余市', '360500000000', '360000000000');
INSERT INTO `t_s_city` VALUES ('128', '鹰潭市', '360600000000', '360000000000');
INSERT INTO `t_s_city` VALUES ('129', '赣州市', '360700000000', '360000000000');
INSERT INTO `t_s_city` VALUES ('130', '吉安市', '360800000000', '360000000000');
INSERT INTO `t_s_city` VALUES ('131', '宜春市', '360900000000', '360000000000');
INSERT INTO `t_s_city` VALUES ('132', '抚州市', '361000000000', '360000000000');
INSERT INTO `t_s_city` VALUES ('133', '上饶市', '361100000000', '360000000000');
INSERT INTO `t_s_city` VALUES ('134', '济南市', '370100000000', '370000000000');
INSERT INTO `t_s_city` VALUES ('135', '青岛市', '370200000000', '370000000000');
INSERT INTO `t_s_city` VALUES ('136', '淄博市', '370300000000', '370000000000');
INSERT INTO `t_s_city` VALUES ('137', '枣庄市', '370400000000', '370000000000');
INSERT INTO `t_s_city` VALUES ('138', '东营市', '370500000000', '370000000000');
INSERT INTO `t_s_city` VALUES ('139', '烟台市', '370600000000', '370000000000');
INSERT INTO `t_s_city` VALUES ('140', '潍坊市', '370700000000', '370000000000');
INSERT INTO `t_s_city` VALUES ('141', '济宁市', '370800000000', '370000000000');
INSERT INTO `t_s_city` VALUES ('142', '泰安市', '370900000000', '370000000000');
INSERT INTO `t_s_city` VALUES ('143', '威海市', '371000000000', '370000000000');
INSERT INTO `t_s_city` VALUES ('144', '日照市', '371100000000', '370000000000');
INSERT INTO `t_s_city` VALUES ('145', '莱芜市', '371200000000', '370000000000');
INSERT INTO `t_s_city` VALUES ('146', '临沂市', '371300000000', '370000000000');
INSERT INTO `t_s_city` VALUES ('147', '德州市', '371400000000', '370000000000');
INSERT INTO `t_s_city` VALUES ('148', '聊城市', '371500000000', '370000000000');
INSERT INTO `t_s_city` VALUES ('149', '滨州市', '371600000000', '370000000000');
INSERT INTO `t_s_city` VALUES ('150', '菏泽市', '371700000000', '370000000000');
INSERT INTO `t_s_city` VALUES ('151', '郑州市', '410100000000', '410000000000');
INSERT INTO `t_s_city` VALUES ('152', '开封市', '410200000000', '410000000000');
INSERT INTO `t_s_city` VALUES ('153', '洛阳市', '410300000000', '410000000000');
INSERT INTO `t_s_city` VALUES ('154', '平顶山市', '410400000000', '410000000000');
INSERT INTO `t_s_city` VALUES ('155', '安阳市', '410500000000', '410000000000');
INSERT INTO `t_s_city` VALUES ('156', '鹤壁市', '410600000000', '410000000000');
INSERT INTO `t_s_city` VALUES ('157', '新乡市', '410700000000', '410000000000');
INSERT INTO `t_s_city` VALUES ('158', '焦作市', '410800000000', '410000000000');
INSERT INTO `t_s_city` VALUES ('159', '濮阳市', '410900000000', '410000000000');
INSERT INTO `t_s_city` VALUES ('160', '许昌市', '411000000000', '410000000000');
INSERT INTO `t_s_city` VALUES ('161', '漯河市', '411100000000', '410000000000');
INSERT INTO `t_s_city` VALUES ('162', '三门峡市', '411200000000', '410000000000');
INSERT INTO `t_s_city` VALUES ('163', '南阳市', '411300000000', '410000000000');
INSERT INTO `t_s_city` VALUES ('164', '商丘市', '411400000000', '410000000000');
INSERT INTO `t_s_city` VALUES ('165', '信阳市', '411500000000', '410000000000');
INSERT INTO `t_s_city` VALUES ('166', '周口市', '411600000000', '410000000000');
INSERT INTO `t_s_city` VALUES ('167', '驻马店市', '411700000000', '410000000000');
INSERT INTO `t_s_city` VALUES ('168', '省直辖县级行政区划', '419000000000', '410000000000');
INSERT INTO `t_s_city` VALUES ('169', '武汉市', '420100000000', '420000000000');
INSERT INTO `t_s_city` VALUES ('170', '黄石市', '420200000000', '420000000000');
INSERT INTO `t_s_city` VALUES ('171', '十堰市', '420300000000', '420000000000');
INSERT INTO `t_s_city` VALUES ('172', '宜昌市', '420500000000', '420000000000');
INSERT INTO `t_s_city` VALUES ('173', '襄阳市', '420600000000', '420000000000');
INSERT INTO `t_s_city` VALUES ('174', '鄂州市', '420700000000', '420000000000');
INSERT INTO `t_s_city` VALUES ('175', '荆门市', '420800000000', '420000000000');
INSERT INTO `t_s_city` VALUES ('176', '孝感市', '420900000000', '420000000000');
INSERT INTO `t_s_city` VALUES ('177', '荆州市', '421000000000', '420000000000');
INSERT INTO `t_s_city` VALUES ('178', '黄冈市', '421100000000', '420000000000');
INSERT INTO `t_s_city` VALUES ('179', '咸宁市', '421200000000', '420000000000');
INSERT INTO `t_s_city` VALUES ('180', '随州市', '421300000000', '420000000000');
INSERT INTO `t_s_city` VALUES ('181', '恩施土家族苗族自治州', '422800000000', '420000000000');
INSERT INTO `t_s_city` VALUES ('182', '省直辖县级行政区划', '429000000000', '420000000000');
INSERT INTO `t_s_city` VALUES ('183', '长沙市', '430100000000', '430000000000');
INSERT INTO `t_s_city` VALUES ('184', '株洲市', '430200000000', '430000000000');
INSERT INTO `t_s_city` VALUES ('185', '湘潭市', '430300000000', '430000000000');
INSERT INTO `t_s_city` VALUES ('186', '衡阳市', '430400000000', '430000000000');
INSERT INTO `t_s_city` VALUES ('187', '邵阳市', '430500000000', '430000000000');
INSERT INTO `t_s_city` VALUES ('188', '岳阳市', '430600000000', '430000000000');
INSERT INTO `t_s_city` VALUES ('189', '常德市', '430700000000', '430000000000');
INSERT INTO `t_s_city` VALUES ('190', '张家界市', '430800000000', '430000000000');
INSERT INTO `t_s_city` VALUES ('191', '益阳市', '430900000000', '430000000000');
INSERT INTO `t_s_city` VALUES ('192', '郴州市', '431000000000', '430000000000');
INSERT INTO `t_s_city` VALUES ('193', '永州市', '431100000000', '430000000000');
INSERT INTO `t_s_city` VALUES ('194', '怀化市', '431200000000', '430000000000');
INSERT INTO `t_s_city` VALUES ('195', '娄底市', '431300000000', '430000000000');
INSERT INTO `t_s_city` VALUES ('196', '湘西土家族苗族自治州', '433100000000', '430000000000');
INSERT INTO `t_s_city` VALUES ('197', '广州市', '440100000000', '440000000000');
INSERT INTO `t_s_city` VALUES ('198', '韶关市', '440200000000', '440000000000');
INSERT INTO `t_s_city` VALUES ('199', '深圳市', '440300000000', '440000000000');
INSERT INTO `t_s_city` VALUES ('200', '珠海市', '440400000000', '440000000000');
INSERT INTO `t_s_city` VALUES ('201', '汕头市', '440500000000', '440000000000');
INSERT INTO `t_s_city` VALUES ('202', '佛山市', '440600000000', '440000000000');
INSERT INTO `t_s_city` VALUES ('203', '江门市', '440700000000', '440000000000');
INSERT INTO `t_s_city` VALUES ('204', '湛江市', '440800000000', '440000000000');
INSERT INTO `t_s_city` VALUES ('205', '茂名市', '440900000000', '440000000000');
INSERT INTO `t_s_city` VALUES ('206', '肇庆市', '441200000000', '440000000000');
INSERT INTO `t_s_city` VALUES ('207', '惠州市', '441300000000', '440000000000');
INSERT INTO `t_s_city` VALUES ('208', '梅州市', '441400000000', '440000000000');
INSERT INTO `t_s_city` VALUES ('209', '汕尾市', '441500000000', '440000000000');
INSERT INTO `t_s_city` VALUES ('210', '河源市', '441600000000', '440000000000');
INSERT INTO `t_s_city` VALUES ('211', '阳江市', '441700000000', '440000000000');
INSERT INTO `t_s_city` VALUES ('212', '清远市', '441800000000', '440000000000');
INSERT INTO `t_s_city` VALUES ('213', '东莞市', '441900000000', '440000000000');
INSERT INTO `t_s_city` VALUES ('214', '中山市', '442000000000', '440000000000');
INSERT INTO `t_s_city` VALUES ('215', '潮州市', '445100000000', '440000000000');
INSERT INTO `t_s_city` VALUES ('216', '揭阳市', '445200000000', '440000000000');
INSERT INTO `t_s_city` VALUES ('217', '云浮市', '445300000000', '440000000000');
INSERT INTO `t_s_city` VALUES ('218', '南宁市', '450100000000', '450000000000');
INSERT INTO `t_s_city` VALUES ('219', '柳州市', '450200000000', '450000000000');
INSERT INTO `t_s_city` VALUES ('220', '桂林市', '450300000000', '450000000000');
INSERT INTO `t_s_city` VALUES ('221', '梧州市', '450400000000', '450000000000');
INSERT INTO `t_s_city` VALUES ('222', '北海市', '450500000000', '450000000000');
INSERT INTO `t_s_city` VALUES ('223', '防城港市', '450600000000', '450000000000');
INSERT INTO `t_s_city` VALUES ('224', '钦州市', '450700000000', '450000000000');
INSERT INTO `t_s_city` VALUES ('225', '贵港市', '450800000000', '450000000000');
INSERT INTO `t_s_city` VALUES ('226', '玉林市', '450900000000', '450000000000');
INSERT INTO `t_s_city` VALUES ('227', '百色市', '451000000000', '450000000000');
INSERT INTO `t_s_city` VALUES ('228', '贺州市', '451100000000', '450000000000');
INSERT INTO `t_s_city` VALUES ('229', '河池市', '451200000000', '450000000000');
INSERT INTO `t_s_city` VALUES ('230', '来宾市', '451300000000', '450000000000');
INSERT INTO `t_s_city` VALUES ('231', '崇左市', '451400000000', '450000000000');
INSERT INTO `t_s_city` VALUES ('232', '海口市', '460100000000', '460000000000');
INSERT INTO `t_s_city` VALUES ('233', '三亚市', '460200000000', '460000000000');
INSERT INTO `t_s_city` VALUES ('234', '三沙市', '460300000000', '460000000000');
INSERT INTO `t_s_city` VALUES ('235', '儋州市', '460400000000', '460000000000');
INSERT INTO `t_s_city` VALUES ('236', '省直辖县级行政区划', '469000000000', '460000000000');
INSERT INTO `t_s_city` VALUES ('237', '市辖区', '500100000000', '500000000000');
INSERT INTO `t_s_city` VALUES ('238', '县', '500200000000', '500000000000');
INSERT INTO `t_s_city` VALUES ('239', '成都市', '510100000000', '510000000000');
INSERT INTO `t_s_city` VALUES ('240', '自贡市', '510300000000', '510000000000');
INSERT INTO `t_s_city` VALUES ('241', '攀枝花市', '510400000000', '510000000000');
INSERT INTO `t_s_city` VALUES ('242', '泸州市', '510500000000', '510000000000');
INSERT INTO `t_s_city` VALUES ('243', '德阳市', '510600000000', '510000000000');
INSERT INTO `t_s_city` VALUES ('244', '绵阳市', '510700000000', '510000000000');
INSERT INTO `t_s_city` VALUES ('245', '广元市', '510800000000', '510000000000');
INSERT INTO `t_s_city` VALUES ('246', '遂宁市', '510900000000', '510000000000');
INSERT INTO `t_s_city` VALUES ('247', '内江市', '511000000000', '510000000000');
INSERT INTO `t_s_city` VALUES ('248', '乐山市', '511100000000', '510000000000');
INSERT INTO `t_s_city` VALUES ('249', '南充市', '511300000000', '510000000000');
INSERT INTO `t_s_city` VALUES ('250', '眉山市', '511400000000', '510000000000');
INSERT INTO `t_s_city` VALUES ('251', '宜宾市', '511500000000', '510000000000');
INSERT INTO `t_s_city` VALUES ('252', '广安市', '511600000000', '510000000000');
INSERT INTO `t_s_city` VALUES ('253', '达州市', '511700000000', '510000000000');
INSERT INTO `t_s_city` VALUES ('254', '雅安市', '511800000000', '510000000000');
INSERT INTO `t_s_city` VALUES ('255', '巴中市', '511900000000', '510000000000');
INSERT INTO `t_s_city` VALUES ('256', '资阳市', '512000000000', '510000000000');
INSERT INTO `t_s_city` VALUES ('257', '阿坝藏族羌族自治州', '513200000000', '510000000000');
INSERT INTO `t_s_city` VALUES ('258', '甘孜藏族自治州', '513300000000', '510000000000');
INSERT INTO `t_s_city` VALUES ('259', '凉山彝族自治州', '513400000000', '510000000000');
INSERT INTO `t_s_city` VALUES ('260', '贵阳市', '520100000000', '520000000000');
INSERT INTO `t_s_city` VALUES ('261', '六盘水市', '520200000000', '520000000000');
INSERT INTO `t_s_city` VALUES ('262', '遵义市', '520300000000', '520000000000');
INSERT INTO `t_s_city` VALUES ('263', '安顺市', '520400000000', '520000000000');
INSERT INTO `t_s_city` VALUES ('264', '毕节市', '520500000000', '520000000000');
INSERT INTO `t_s_city` VALUES ('265', '铜仁市', '520600000000', '520000000000');
INSERT INTO `t_s_city` VALUES ('266', '黔西南布依族苗族自治州', '522300000000', '520000000000');
INSERT INTO `t_s_city` VALUES ('267', '黔东南苗族侗族自治州', '522600000000', '520000000000');
INSERT INTO `t_s_city` VALUES ('268', '黔南布依族苗族自治州', '522700000000', '520000000000');
INSERT INTO `t_s_city` VALUES ('269', '昆明市', '530100000000', '530000000000');
INSERT INTO `t_s_city` VALUES ('270', '曲靖市', '530300000000', '530000000000');
INSERT INTO `t_s_city` VALUES ('271', '玉溪市', '530400000000', '530000000000');
INSERT INTO `t_s_city` VALUES ('272', '保山市', '530500000000', '530000000000');
INSERT INTO `t_s_city` VALUES ('273', '昭通市', '530600000000', '530000000000');
INSERT INTO `t_s_city` VALUES ('274', '丽江市', '530700000000', '530000000000');
INSERT INTO `t_s_city` VALUES ('275', '普洱市', '530800000000', '530000000000');
INSERT INTO `t_s_city` VALUES ('276', '临沧市', '530900000000', '530000000000');
INSERT INTO `t_s_city` VALUES ('277', '楚雄彝族自治州', '532300000000', '530000000000');
INSERT INTO `t_s_city` VALUES ('278', '红河哈尼族彝族自治州', '532500000000', '530000000000');
INSERT INTO `t_s_city` VALUES ('279', '文山壮族苗族自治州', '532600000000', '530000000000');
INSERT INTO `t_s_city` VALUES ('280', '西双版纳傣族自治州', '532800000000', '530000000000');
INSERT INTO `t_s_city` VALUES ('281', '大理白族自治州', '532900000000', '530000000000');
INSERT INTO `t_s_city` VALUES ('282', '德宏傣族景颇族自治州', '533100000000', '530000000000');
INSERT INTO `t_s_city` VALUES ('283', '怒江傈僳族自治州', '533300000000', '530000000000');
INSERT INTO `t_s_city` VALUES ('284', '迪庆藏族自治州', '533400000000', '530000000000');
INSERT INTO `t_s_city` VALUES ('285', '拉萨市', '540100000000', '540000000000');
INSERT INTO `t_s_city` VALUES ('286', '日喀则市', '540200000000', '540000000000');
INSERT INTO `t_s_city` VALUES ('287', '昌都市', '540300000000', '540000000000');
INSERT INTO `t_s_city` VALUES ('288', '林芝市', '540400000000', '540000000000');
INSERT INTO `t_s_city` VALUES ('289', '山南市', '540500000000', '540000000000');
INSERT INTO `t_s_city` VALUES ('290', '那曲市', '540600000000', '540000000000');
INSERT INTO `t_s_city` VALUES ('291', '阿里地区', '542500000000', '540000000000');
INSERT INTO `t_s_city` VALUES ('292', '西安市', '610100000000', '610000000000');
INSERT INTO `t_s_city` VALUES ('293', '铜川市', '610200000000', '610000000000');
INSERT INTO `t_s_city` VALUES ('294', '宝鸡市', '610300000000', '610000000000');
INSERT INTO `t_s_city` VALUES ('295', '咸阳市', '610400000000', '610000000000');
INSERT INTO `t_s_city` VALUES ('296', '渭南市', '610500000000', '610000000000');
INSERT INTO `t_s_city` VALUES ('297', '延安市', '610600000000', '610000000000');
INSERT INTO `t_s_city` VALUES ('298', '汉中市', '610700000000', '610000000000');
INSERT INTO `t_s_city` VALUES ('299', '榆林市', '610800000000', '610000000000');
INSERT INTO `t_s_city` VALUES ('300', '安康市', '610900000000', '610000000000');
INSERT INTO `t_s_city` VALUES ('301', '商洛市', '611000000000', '610000000000');
INSERT INTO `t_s_city` VALUES ('302', '兰州市', '620100000000', '620000000000');
INSERT INTO `t_s_city` VALUES ('303', '嘉峪关市', '620200000000', '620000000000');
INSERT INTO `t_s_city` VALUES ('304', '金昌市', '620300000000', '620000000000');
INSERT INTO `t_s_city` VALUES ('305', '白银市', '620400000000', '620000000000');
INSERT INTO `t_s_city` VALUES ('306', '天水市', '620500000000', '620000000000');
INSERT INTO `t_s_city` VALUES ('307', '武威市', '620600000000', '620000000000');
INSERT INTO `t_s_city` VALUES ('308', '张掖市', '620700000000', '620000000000');
INSERT INTO `t_s_city` VALUES ('309', '平凉市', '620800000000', '620000000000');
INSERT INTO `t_s_city` VALUES ('310', '酒泉市', '620900000000', '620000000000');
INSERT INTO `t_s_city` VALUES ('311', '庆阳市', '621000000000', '620000000000');
INSERT INTO `t_s_city` VALUES ('312', '定西市', '621100000000', '620000000000');
INSERT INTO `t_s_city` VALUES ('313', '陇南市', '621200000000', '620000000000');
INSERT INTO `t_s_city` VALUES ('314', '临夏回族自治州', '622900000000', '620000000000');
INSERT INTO `t_s_city` VALUES ('315', '甘南藏族自治州', '623000000000', '620000000000');
INSERT INTO `t_s_city` VALUES ('316', '西宁市', '630100000000', '630000000000');
INSERT INTO `t_s_city` VALUES ('317', '海东市', '630200000000', '630000000000');
INSERT INTO `t_s_city` VALUES ('318', '海北藏族自治州', '632200000000', '630000000000');
INSERT INTO `t_s_city` VALUES ('319', '黄南藏族自治州', '632300000000', '630000000000');
INSERT INTO `t_s_city` VALUES ('320', '海南藏族自治州', '632500000000', '630000000000');
INSERT INTO `t_s_city` VALUES ('321', '果洛藏族自治州', '632600000000', '630000000000');
INSERT INTO `t_s_city` VALUES ('322', '玉树藏族自治州', '632700000000', '630000000000');
INSERT INTO `t_s_city` VALUES ('323', '海西蒙古族藏族自治州', '632800000000', '630000000000');
INSERT INTO `t_s_city` VALUES ('324', '银川市', '640100000000', '640000000000');
INSERT INTO `t_s_city` VALUES ('325', '石嘴山市', '640200000000', '640000000000');
INSERT INTO `t_s_city` VALUES ('326', '吴忠市', '640300000000', '640000000000');
INSERT INTO `t_s_city` VALUES ('327', '固原市', '640400000000', '640000000000');
INSERT INTO `t_s_city` VALUES ('328', '中卫市', '640500000000', '640000000000');
INSERT INTO `t_s_city` VALUES ('329', '乌鲁木齐市', '650100000000', '650000000000');
INSERT INTO `t_s_city` VALUES ('330', '克拉玛依市', '650200000000', '650000000000');
INSERT INTO `t_s_city` VALUES ('331', '吐鲁番市', '650400000000', '650000000000');
INSERT INTO `t_s_city` VALUES ('332', '哈密市', '650500000000', '650000000000');
INSERT INTO `t_s_city` VALUES ('333', '昌吉回族自治州', '652300000000', '650000000000');
INSERT INTO `t_s_city` VALUES ('334', '博尔塔拉蒙古自治州', '652700000000', '650000000000');
INSERT INTO `t_s_city` VALUES ('335', '巴音郭楞蒙古自治州', '652800000000', '650000000000');
INSERT INTO `t_s_city` VALUES ('336', '阿克苏地区', '652900000000', '650000000000');
INSERT INTO `t_s_city` VALUES ('337', '克孜勒苏柯尔克孜自治州', '653000000000', '650000000000');
INSERT INTO `t_s_city` VALUES ('338', '喀什地区', '653100000000', '650000000000');
INSERT INTO `t_s_city` VALUES ('339', '和田地区', '653200000000', '650000000000');
INSERT INTO `t_s_city` VALUES ('340', '伊犁哈萨克自治州', '654000000000', '650000000000');
INSERT INTO `t_s_city` VALUES ('341', '塔城地区', '654200000000', '650000000000');
INSERT INTO `t_s_city` VALUES ('342', '阿勒泰地区', '654300000000', '650000000000');
INSERT INTO `t_s_city` VALUES ('343', '自治区直辖县级行政区划', '659000000000', '650000000000');

-- ----------------------------
-- Table structure for t_s_column_ui
-- ----------------------------
DROP TABLE IF EXISTS `t_s_column_ui`;
CREATE TABLE `t_s_column_ui` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `table_name` varchar(50) NOT NULL COMMENT '表名',
  `name` varchar(50) NOT NULL COMMENT '属性名',
  `ui_type` varchar(50) NOT NULL COMMENT '属性UI类型',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=147 DEFAULT CHARSET=utf8mb4 COMMENT='属性UI';

-- ----------------------------
-- Records of t_s_column_ui
-- ----------------------------
INSERT INTO `t_s_column_ui` VALUES ('84', 't_bill', 'updateBy', 'Input');
INSERT INTO `t_s_column_ui` VALUES ('83', 't_bill', 'createDate', 'DatePicker');
INSERT INTO `t_s_column_ui` VALUES ('82', 't_bill', 'createBy', 'Input');
INSERT INTO `t_s_column_ui` VALUES ('80', 't_s_column_ui', 'uiType', 'Input');
INSERT INTO `t_s_column_ui` VALUES ('79', 't_s_column_ui', 'name', 'Input');
INSERT INTO `t_s_column_ui` VALUES ('78', 't_s_column_ui', 'tableName', 'Select');
INSERT INTO `t_s_column_ui` VALUES ('81', 't_bill', 'id', 'Input');
INSERT INTO `t_s_column_ui` VALUES ('77', 't_s_column_ui', 'id', 'Input');
INSERT INTO `t_s_column_ui` VALUES ('85', 't_bill', 'updateDate', 'DatePicker');
INSERT INTO `t_s_column_ui` VALUES ('86', 't_bill', 'billType', 'Input');
INSERT INTO `t_s_column_ui` VALUES ('87', 't_bill', 'billStatus', 'Input');
INSERT INTO `t_s_column_ui` VALUES ('88', 't_bill', 'billDesc', 'Input');
INSERT INTO `t_s_column_ui` VALUES ('89', 't_bill', 'receivingAddress', 'Input');
INSERT INTO `t_s_column_ui` VALUES ('90', 't_bill', 'logisticsInfo', 'Input');
INSERT INTO `t_s_column_ui` VALUES ('91', 't_bill', 'logisticsNo', 'Input');
INSERT INTO `t_s_column_ui` VALUES ('92', 't_bill', 'logisticsStatus', 'Input');
INSERT INTO `t_s_column_ui` VALUES ('93', 't_bill', 'billDate', 'DatePicker');
INSERT INTO `t_s_column_ui` VALUES ('94', 't_bill', 'totalAmount', 'Input');
INSERT INTO `t_s_column_ui` VALUES ('95', 't_bill', 'quantity', 'Input');
INSERT INTO `t_s_column_ui` VALUES ('96', 't_bill', 'outTradeNo', 'Input');
INSERT INTO `t_s_column_ui` VALUES ('97', 't_bill', 'toMemberName', 'Input');
INSERT INTO `t_s_column_ui` VALUES ('98', 't_bill', 'toMemberId', 'Input');
INSERT INTO `t_s_column_ui` VALUES ('99', 't_bill', 'paymentType', 'Input');
INSERT INTO `t_s_column_ui` VALUES ('100', 't_bill', 'paymentAccountNo', 'Input');
INSERT INTO `t_s_column_ui` VALUES ('101', 't_bill', 'reason', 'Input');
INSERT INTO `t_s_column_ui` VALUES ('102', 't_bill', 'integralReward', 'Input');
INSERT INTO `t_s_column_ui` VALUES ('103', 't_bill', 'remark', 'Input');
INSERT INTO `t_s_column_ui` VALUES ('104', 't_bill', 'billContext', 'Input');
INSERT INTO `t_s_column_ui` VALUES ('105', 't_bill', 'userId', 'Input');
INSERT INTO `t_s_column_ui` VALUES ('106', 't_news_info', 'id', 'Input');
INSERT INTO `t_s_column_ui` VALUES ('107', 't_news_info', 'createBy', 'Input');
INSERT INTO `t_s_column_ui` VALUES ('108', 't_news_info', 'createDate', 'DatePicker');
INSERT INTO `t_s_column_ui` VALUES ('109', 't_news_info', 'updateBy', 'Input');
INSERT INTO `t_s_column_ui` VALUES ('110', 't_news_info', 'updateDate', 'DatePicker');
INSERT INTO `t_s_column_ui` VALUES ('111', 't_news_info', 'title', 'Input');
INSERT INTO `t_s_column_ui` VALUES ('112', 't_news_info', 'userId', 'Input');
INSERT INTO `t_s_column_ui` VALUES ('113', 't_news_info', 'status', 'Input');
INSERT INTO `t_s_column_ui` VALUES ('114', 't_news_info', 'content', 'Input');
INSERT INTO `t_s_column_ui` VALUES ('115', 't_news_info', 'imageUrl', 'Input');
INSERT INTO `t_s_column_ui` VALUES ('116', 't_news_info', 'publishDate', 'DatePicker');
INSERT INTO `t_s_column_ui` VALUES ('117', 't_news_info', 'tags', 'Input');
INSERT INTO `t_s_column_ui` VALUES ('118', 't_news_info', 'newsType', 'Input');
INSERT INTO `t_s_column_ui` VALUES ('133', 't_s_quartz_job', 'id', 'Input');
INSERT INTO `t_s_column_ui` VALUES ('134', 't_s_quartz_job', 'createBy', 'Input');
INSERT INTO `t_s_column_ui` VALUES ('135', 't_s_quartz_job', 'createDate', 'DatePicker');
INSERT INTO `t_s_column_ui` VALUES ('136', 't_s_quartz_job', 'updateBy', 'Input');
INSERT INTO `t_s_column_ui` VALUES ('137', 't_s_quartz_job', 'updateDate', 'DatePicker');
INSERT INTO `t_s_column_ui` VALUES ('138', 't_s_quartz_job', 'cronExpression', 'Input');
INSERT INTO `t_s_column_ui` VALUES ('139', 't_s_quartz_job', 'methodName', 'Input');
INSERT INTO `t_s_column_ui` VALUES ('140', 't_s_quartz_job', 'isConcurrent', 'Input');
INSERT INTO `t_s_column_ui` VALUES ('141', 't_s_quartz_job', 'description', 'Input');
INSERT INTO `t_s_column_ui` VALUES ('142', 't_s_quartz_job', 'beanName', 'Input');
INSERT INTO `t_s_column_ui` VALUES ('143', 't_s_quartz_job', 'triggerName', 'Input');
INSERT INTO `t_s_column_ui` VALUES ('144', 't_s_quartz_job', 'jobStatus', 'Input');
INSERT INTO `t_s_column_ui` VALUES ('145', 't_s_quartz_job', 'springBean', 'Input');
INSERT INTO `t_s_column_ui` VALUES ('146', 't_s_quartz_job', 'jobName', 'Input');

-- ----------------------------
-- Table structure for t_s_country
-- ----------------------------
DROP TABLE IF EXISTS `t_s_country`;
CREATE TABLE `t_s_country` (
  `_id` int(11) NOT NULL,
  `name` varchar(64) DEFAULT NULL,
  `country_id` varchar(12) DEFAULT NULL,
  `city_id` varchar(12) DEFAULT NULL,
  PRIMARY KEY (`_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Records of t_s_country
-- ----------------------------
INSERT INTO `t_s_country` VALUES ('1', '东城区', '110101000000', '110100000000');
INSERT INTO `t_s_country` VALUES ('2', '西城区', '110102000000', '110100000000');
INSERT INTO `t_s_country` VALUES ('3', '朝阳区', '110105000000', '110100000000');
INSERT INTO `t_s_country` VALUES ('4', '丰台区', '110106000000', '110100000000');
INSERT INTO `t_s_country` VALUES ('5', '石景山区', '110107000000', '110100000000');
INSERT INTO `t_s_country` VALUES ('6', '海淀区', '110108000000', '110100000000');
INSERT INTO `t_s_country` VALUES ('7', '门头沟区', '110109000000', '110100000000');
INSERT INTO `t_s_country` VALUES ('8', '房山区', '110111000000', '110100000000');
INSERT INTO `t_s_country` VALUES ('9', '通州区', '110112000000', '110100000000');
INSERT INTO `t_s_country` VALUES ('10', '顺义区', '110113000000', '110100000000');
INSERT INTO `t_s_country` VALUES ('11', '昌平区', '110114000000', '110100000000');
INSERT INTO `t_s_country` VALUES ('12', '大兴区', '110115000000', '110100000000');
INSERT INTO `t_s_country` VALUES ('13', '怀柔区', '110116000000', '110100000000');
INSERT INTO `t_s_country` VALUES ('14', '平谷区', '110117000000', '110100000000');
INSERT INTO `t_s_country` VALUES ('15', '密云区', '110118000000', '110100000000');
INSERT INTO `t_s_country` VALUES ('16', '延庆区', '110119000000', '110100000000');
INSERT INTO `t_s_country` VALUES ('17', '和平区', '120101000000', '120100000000');
INSERT INTO `t_s_country` VALUES ('18', '河东区', '120102000000', '120100000000');
INSERT INTO `t_s_country` VALUES ('19', '河西区', '120103000000', '120100000000');
INSERT INTO `t_s_country` VALUES ('20', '南开区', '120104000000', '120100000000');
INSERT INTO `t_s_country` VALUES ('21', '河北区', '120105000000', '120100000000');
INSERT INTO `t_s_country` VALUES ('22', '红桥区', '120106000000', '120100000000');
INSERT INTO `t_s_country` VALUES ('23', '东丽区', '120110000000', '120100000000');
INSERT INTO `t_s_country` VALUES ('24', '西青区', '120111000000', '120100000000');
INSERT INTO `t_s_country` VALUES ('25', '津南区', '120112000000', '120100000000');
INSERT INTO `t_s_country` VALUES ('26', '北辰区', '120113000000', '120100000000');
INSERT INTO `t_s_country` VALUES ('27', '武清区', '120114000000', '120100000000');
INSERT INTO `t_s_country` VALUES ('28', '宝坻区', '120115000000', '120100000000');
INSERT INTO `t_s_country` VALUES ('29', '滨海新区', '120116000000', '120100000000');
INSERT INTO `t_s_country` VALUES ('30', '宁河区', '120117000000', '120100000000');
INSERT INTO `t_s_country` VALUES ('31', '静海区', '120118000000', '120100000000');
INSERT INTO `t_s_country` VALUES ('32', '蓟州区', '120119000000', '120100000000');
INSERT INTO `t_s_country` VALUES ('33', '市辖区', '130101000000', '130100000000');
INSERT INTO `t_s_country` VALUES ('34', '长安区', '130102000000', '130100000000');
INSERT INTO `t_s_country` VALUES ('35', '桥西区', '130104000000', '130100000000');
INSERT INTO `t_s_country` VALUES ('36', '新华区', '130105000000', '130100000000');
INSERT INTO `t_s_country` VALUES ('37', '井陉矿区', '130107000000', '130100000000');
INSERT INTO `t_s_country` VALUES ('38', '裕华区', '130108000000', '130100000000');
INSERT INTO `t_s_country` VALUES ('39', '藁城区', '130109000000', '130100000000');
INSERT INTO `t_s_country` VALUES ('40', '鹿泉区', '130110000000', '130100000000');
INSERT INTO `t_s_country` VALUES ('41', '栾城区', '130111000000', '130100000000');
INSERT INTO `t_s_country` VALUES ('42', '井陉县', '130121000000', '130100000000');
INSERT INTO `t_s_country` VALUES ('43', '正定县', '130123000000', '130100000000');
INSERT INTO `t_s_country` VALUES ('44', '行唐县', '130125000000', '130100000000');
INSERT INTO `t_s_country` VALUES ('45', '灵寿县', '130126000000', '130100000000');
INSERT INTO `t_s_country` VALUES ('46', '高邑县', '130127000000', '130100000000');
INSERT INTO `t_s_country` VALUES ('47', '深泽县', '130128000000', '130100000000');
INSERT INTO `t_s_country` VALUES ('48', '赞皇县', '130129000000', '130100000000');
INSERT INTO `t_s_country` VALUES ('49', '无极县', '130130000000', '130100000000');
INSERT INTO `t_s_country` VALUES ('50', '平山县', '130131000000', '130100000000');
INSERT INTO `t_s_country` VALUES ('51', '元氏县', '130132000000', '130100000000');
INSERT INTO `t_s_country` VALUES ('52', '赵县', '130133000000', '130100000000');
INSERT INTO `t_s_country` VALUES ('53', '石家庄高新技术产业开发区', '130171000000', '130100000000');
INSERT INTO `t_s_country` VALUES ('54', '石家庄循环化工园区', '130172000000', '130100000000');
INSERT INTO `t_s_country` VALUES ('55', '辛集市', '130181000000', '130100000000');
INSERT INTO `t_s_country` VALUES ('56', '晋州市', '130183000000', '130100000000');
INSERT INTO `t_s_country` VALUES ('57', '新乐市', '130184000000', '130100000000');
INSERT INTO `t_s_country` VALUES ('58', '市辖区', '130201000000', '130200000000');
INSERT INTO `t_s_country` VALUES ('59', '路南区', '130202000000', '130200000000');
INSERT INTO `t_s_country` VALUES ('60', '路北区', '130203000000', '130200000000');
INSERT INTO `t_s_country` VALUES ('61', '古冶区', '130204000000', '130200000000');
INSERT INTO `t_s_country` VALUES ('62', '开平区', '130205000000', '130200000000');
INSERT INTO `t_s_country` VALUES ('63', '丰南区', '130207000000', '130200000000');
INSERT INTO `t_s_country` VALUES ('64', '丰润区', '130208000000', '130200000000');
INSERT INTO `t_s_country` VALUES ('65', '曹妃甸区', '130209000000', '130200000000');
INSERT INTO `t_s_country` VALUES ('66', '滦南县', '130224000000', '130200000000');
INSERT INTO `t_s_country` VALUES ('67', '乐亭县', '130225000000', '130200000000');
INSERT INTO `t_s_country` VALUES ('68', '迁西县', '130227000000', '130200000000');
INSERT INTO `t_s_country` VALUES ('69', '玉田县', '130229000000', '130200000000');
INSERT INTO `t_s_country` VALUES ('70', '唐山市芦台经济技术开发区', '130271000000', '130200000000');
INSERT INTO `t_s_country` VALUES ('71', '唐山市汉沽管理区', '130272000000', '130200000000');
INSERT INTO `t_s_country` VALUES ('72', '唐山高新技术产业开发区', '130273000000', '130200000000');
INSERT INTO `t_s_country` VALUES ('73', '河北唐山海港经济开发区', '130274000000', '130200000000');
INSERT INTO `t_s_country` VALUES ('74', '遵化市', '130281000000', '130200000000');
INSERT INTO `t_s_country` VALUES ('75', '迁安市', '130283000000', '130200000000');
INSERT INTO `t_s_country` VALUES ('76', '滦州市', '130284000000', '130200000000');
INSERT INTO `t_s_country` VALUES ('77', '市辖区', '130301000000', '130300000000');
INSERT INTO `t_s_country` VALUES ('78', '海港区', '130302000000', '130300000000');
INSERT INTO `t_s_country` VALUES ('79', '山海关区', '130303000000', '130300000000');
INSERT INTO `t_s_country` VALUES ('80', '北戴河区', '130304000000', '130300000000');
INSERT INTO `t_s_country` VALUES ('81', '抚宁区', '130306000000', '130300000000');
INSERT INTO `t_s_country` VALUES ('82', '青龙满族自治县', '130321000000', '130300000000');
INSERT INTO `t_s_country` VALUES ('83', '昌黎县', '130322000000', '130300000000');
INSERT INTO `t_s_country` VALUES ('84', '卢龙县', '130324000000', '130300000000');
INSERT INTO `t_s_country` VALUES ('85', '秦皇岛市经济技术开发区', '130371000000', '130300000000');
INSERT INTO `t_s_country` VALUES ('86', '北戴河新区', '130372000000', '130300000000');
INSERT INTO `t_s_country` VALUES ('87', '市辖区', '130401000000', '130400000000');
INSERT INTO `t_s_country` VALUES ('88', '邯山区', '130402000000', '130400000000');
INSERT INTO `t_s_country` VALUES ('89', '丛台区', '130403000000', '130400000000');
INSERT INTO `t_s_country` VALUES ('90', '复兴区', '130404000000', '130400000000');
INSERT INTO `t_s_country` VALUES ('91', '峰峰矿区', '130406000000', '130400000000');
INSERT INTO `t_s_country` VALUES ('92', '肥乡区', '130407000000', '130400000000');
INSERT INTO `t_s_country` VALUES ('93', '永年区', '130408000000', '130400000000');
INSERT INTO `t_s_country` VALUES ('94', '临漳县', '130423000000', '130400000000');
INSERT INTO `t_s_country` VALUES ('95', '成安县', '130424000000', '130400000000');
INSERT INTO `t_s_country` VALUES ('96', '大名县', '130425000000', '130400000000');
INSERT INTO `t_s_country` VALUES ('97', '涉县', '130426000000', '130400000000');
INSERT INTO `t_s_country` VALUES ('98', '磁县', '130427000000', '130400000000');
INSERT INTO `t_s_country` VALUES ('99', '邱县', '130430000000', '130400000000');
INSERT INTO `t_s_country` VALUES ('100', '鸡泽县', '130431000000', '130400000000');
INSERT INTO `t_s_country` VALUES ('101', '广平县', '130432000000', '130400000000');
INSERT INTO `t_s_country` VALUES ('102', '馆陶县', '130433000000', '130400000000');
INSERT INTO `t_s_country` VALUES ('103', '魏县', '130434000000', '130400000000');
INSERT INTO `t_s_country` VALUES ('104', '曲周县', '130435000000', '130400000000');
INSERT INTO `t_s_country` VALUES ('105', '邯郸经济技术开发区', '130471000000', '130400000000');
INSERT INTO `t_s_country` VALUES ('106', '邯郸冀南新区', '130473000000', '130400000000');
INSERT INTO `t_s_country` VALUES ('107', '武安市', '130481000000', '130400000000');
INSERT INTO `t_s_country` VALUES ('108', '市辖区', '130501000000', '130500000000');
INSERT INTO `t_s_country` VALUES ('109', '桥东区', '130502000000', '130500000000');
INSERT INTO `t_s_country` VALUES ('110', '桥西区', '130503000000', '130500000000');
INSERT INTO `t_s_country` VALUES ('111', '邢台县', '130521000000', '130500000000');
INSERT INTO `t_s_country` VALUES ('112', '临城县', '130522000000', '130500000000');
INSERT INTO `t_s_country` VALUES ('113', '内丘县', '130523000000', '130500000000');
INSERT INTO `t_s_country` VALUES ('114', '柏乡县', '130524000000', '130500000000');
INSERT INTO `t_s_country` VALUES ('115', '隆尧县', '130525000000', '130500000000');
INSERT INTO `t_s_country` VALUES ('116', '任县', '130526000000', '130500000000');
INSERT INTO `t_s_country` VALUES ('117', '南和县', '130527000000', '130500000000');
INSERT INTO `t_s_country` VALUES ('118', '宁晋县', '130528000000', '130500000000');
INSERT INTO `t_s_country` VALUES ('119', '巨鹿县', '130529000000', '130500000000');
INSERT INTO `t_s_country` VALUES ('120', '新河县', '130530000000', '130500000000');
INSERT INTO `t_s_country` VALUES ('121', '广宗县', '130531000000', '130500000000');
INSERT INTO `t_s_country` VALUES ('122', '平乡县', '130532000000', '130500000000');
INSERT INTO `t_s_country` VALUES ('123', '威县', '130533000000', '130500000000');
INSERT INTO `t_s_country` VALUES ('124', '清河县', '130534000000', '130500000000');
INSERT INTO `t_s_country` VALUES ('125', '临西县', '130535000000', '130500000000');
INSERT INTO `t_s_country` VALUES ('126', '河北邢台经济开发区', '130571000000', '130500000000');
INSERT INTO `t_s_country` VALUES ('127', '南宫市', '130581000000', '130500000000');
INSERT INTO `t_s_country` VALUES ('128', '沙河市', '130582000000', '130500000000');
INSERT INTO `t_s_country` VALUES ('129', '市辖区', '130601000000', '130600000000');
INSERT INTO `t_s_country` VALUES ('130', '竞秀区', '130602000000', '130600000000');
INSERT INTO `t_s_country` VALUES ('131', '莲池区', '130606000000', '130600000000');
INSERT INTO `t_s_country` VALUES ('132', '满城区', '130607000000', '130600000000');
INSERT INTO `t_s_country` VALUES ('133', '清苑区', '130608000000', '130600000000');
INSERT INTO `t_s_country` VALUES ('134', '徐水区', '130609000000', '130600000000');
INSERT INTO `t_s_country` VALUES ('135', '涞水县', '130623000000', '130600000000');
INSERT INTO `t_s_country` VALUES ('136', '阜平县', '130624000000', '130600000000');
INSERT INTO `t_s_country` VALUES ('137', '定兴县', '130626000000', '130600000000');
INSERT INTO `t_s_country` VALUES ('138', '唐县', '130627000000', '130600000000');
INSERT INTO `t_s_country` VALUES ('139', '高阳县', '130628000000', '130600000000');
INSERT INTO `t_s_country` VALUES ('140', '容城县', '130629000000', '130600000000');
INSERT INTO `t_s_country` VALUES ('141', '涞源县', '130630000000', '130600000000');
INSERT INTO `t_s_country` VALUES ('142', '望都县', '130631000000', '130600000000');
INSERT INTO `t_s_country` VALUES ('143', '安新县', '130632000000', '130600000000');
INSERT INTO `t_s_country` VALUES ('144', '易县', '130633000000', '130600000000');
INSERT INTO `t_s_country` VALUES ('145', '曲阳县', '130634000000', '130600000000');
INSERT INTO `t_s_country` VALUES ('146', '蠡县', '130635000000', '130600000000');
INSERT INTO `t_s_country` VALUES ('147', '顺平县', '130636000000', '130600000000');
INSERT INTO `t_s_country` VALUES ('148', '博野县', '130637000000', '130600000000');
INSERT INTO `t_s_country` VALUES ('149', '雄县', '130638000000', '130600000000');
INSERT INTO `t_s_country` VALUES ('150', '保定高新技术产业开发区', '130671000000', '130600000000');
INSERT INTO `t_s_country` VALUES ('151', '保定白沟新城', '130672000000', '130600000000');
INSERT INTO `t_s_country` VALUES ('152', '涿州市', '130681000000', '130600000000');
INSERT INTO `t_s_country` VALUES ('153', '定州市', '130682000000', '130600000000');
INSERT INTO `t_s_country` VALUES ('154', '安国市', '130683000000', '130600000000');
INSERT INTO `t_s_country` VALUES ('155', '高碑店市', '130684000000', '130600000000');
INSERT INTO `t_s_country` VALUES ('156', '市辖区', '130701000000', '130700000000');
INSERT INTO `t_s_country` VALUES ('157', '桥东区', '130702000000', '130700000000');
INSERT INTO `t_s_country` VALUES ('158', '桥西区', '130703000000', '130700000000');
INSERT INTO `t_s_country` VALUES ('159', '宣化区', '130705000000', '130700000000');
INSERT INTO `t_s_country` VALUES ('160', '下花园区', '130706000000', '130700000000');
INSERT INTO `t_s_country` VALUES ('161', '万全区', '130708000000', '130700000000');
INSERT INTO `t_s_country` VALUES ('162', '崇礼区', '130709000000', '130700000000');
INSERT INTO `t_s_country` VALUES ('163', '张北县', '130722000000', '130700000000');
INSERT INTO `t_s_country` VALUES ('164', '康保县', '130723000000', '130700000000');
INSERT INTO `t_s_country` VALUES ('165', '沽源县', '130724000000', '130700000000');
INSERT INTO `t_s_country` VALUES ('166', '尚义县', '130725000000', '130700000000');
INSERT INTO `t_s_country` VALUES ('167', '蔚县', '130726000000', '130700000000');
INSERT INTO `t_s_country` VALUES ('168', '阳原县', '130727000000', '130700000000');
INSERT INTO `t_s_country` VALUES ('169', '怀安县', '130728000000', '130700000000');
INSERT INTO `t_s_country` VALUES ('170', '怀来县', '130730000000', '130700000000');
INSERT INTO `t_s_country` VALUES ('171', '涿鹿县', '130731000000', '130700000000');
INSERT INTO `t_s_country` VALUES ('172', '赤城县', '130732000000', '130700000000');
INSERT INTO `t_s_country` VALUES ('173', '张家口市高新技术产业开发区', '130771000000', '130700000000');
INSERT INTO `t_s_country` VALUES ('174', '张家口市察北管理区', '130772000000', '130700000000');
INSERT INTO `t_s_country` VALUES ('175', '张家口市塞北管理区', '130773000000', '130700000000');
INSERT INTO `t_s_country` VALUES ('176', '市辖区', '130801000000', '130800000000');
INSERT INTO `t_s_country` VALUES ('177', '双桥区', '130802000000', '130800000000');
INSERT INTO `t_s_country` VALUES ('178', '双滦区', '130803000000', '130800000000');
INSERT INTO `t_s_country` VALUES ('179', '鹰手营子矿区', '130804000000', '130800000000');
INSERT INTO `t_s_country` VALUES ('180', '承德县', '130821000000', '130800000000');
INSERT INTO `t_s_country` VALUES ('181', '兴隆县', '130822000000', '130800000000');
INSERT INTO `t_s_country` VALUES ('182', '滦平县', '130824000000', '130800000000');
INSERT INTO `t_s_country` VALUES ('183', '隆化县', '130825000000', '130800000000');
INSERT INTO `t_s_country` VALUES ('184', '丰宁满族自治县', '130826000000', '130800000000');
INSERT INTO `t_s_country` VALUES ('185', '宽城满族自治县', '130827000000', '130800000000');
INSERT INTO `t_s_country` VALUES ('186', '围场满族蒙古族自治县', '130828000000', '130800000000');
INSERT INTO `t_s_country` VALUES ('187', '承德高新技术产业开发区', '130871000000', '130800000000');
INSERT INTO `t_s_country` VALUES ('188', '平泉市', '130881000000', '130800000000');
INSERT INTO `t_s_country` VALUES ('189', '市辖区', '130901000000', '130900000000');
INSERT INTO `t_s_country` VALUES ('190', '新华区', '130902000000', '130900000000');
INSERT INTO `t_s_country` VALUES ('191', '运河区', '130903000000', '130900000000');
INSERT INTO `t_s_country` VALUES ('192', '沧县', '130921000000', '130900000000');
INSERT INTO `t_s_country` VALUES ('193', '青县', '130922000000', '130900000000');
INSERT INTO `t_s_country` VALUES ('194', '东光县', '130923000000', '130900000000');
INSERT INTO `t_s_country` VALUES ('195', '海兴县', '130924000000', '130900000000');
INSERT INTO `t_s_country` VALUES ('196', '盐山县', '130925000000', '130900000000');
INSERT INTO `t_s_country` VALUES ('197', '肃宁县', '130926000000', '130900000000');
INSERT INTO `t_s_country` VALUES ('198', '南皮县', '130927000000', '130900000000');
INSERT INTO `t_s_country` VALUES ('199', '吴桥县', '130928000000', '130900000000');
INSERT INTO `t_s_country` VALUES ('200', '献县', '130929000000', '130900000000');
INSERT INTO `t_s_country` VALUES ('201', '孟村回族自治县', '130930000000', '130900000000');
INSERT INTO `t_s_country` VALUES ('202', '河北沧州经济开发区', '130971000000', '130900000000');
INSERT INTO `t_s_country` VALUES ('203', '沧州高新技术产业开发区', '130972000000', '130900000000');
INSERT INTO `t_s_country` VALUES ('204', '沧州渤海新区', '130973000000', '130900000000');
INSERT INTO `t_s_country` VALUES ('205', '泊头市', '130981000000', '130900000000');
INSERT INTO `t_s_country` VALUES ('206', '任丘市', '130982000000', '130900000000');
INSERT INTO `t_s_country` VALUES ('207', '黄骅市', '130983000000', '130900000000');
INSERT INTO `t_s_country` VALUES ('208', '河间市', '130984000000', '130900000000');
INSERT INTO `t_s_country` VALUES ('209', '市辖区', '131001000000', '131000000000');
INSERT INTO `t_s_country` VALUES ('210', '安次区', '131002000000', '131000000000');
INSERT INTO `t_s_country` VALUES ('211', '广阳区', '131003000000', '131000000000');
INSERT INTO `t_s_country` VALUES ('212', '固安县', '131022000000', '131000000000');
INSERT INTO `t_s_country` VALUES ('213', '永清县', '131023000000', '131000000000');
INSERT INTO `t_s_country` VALUES ('214', '香河县', '131024000000', '131000000000');
INSERT INTO `t_s_country` VALUES ('215', '大城县', '131025000000', '131000000000');
INSERT INTO `t_s_country` VALUES ('216', '文安县', '131026000000', '131000000000');
INSERT INTO `t_s_country` VALUES ('217', '大厂回族自治县', '131028000000', '131000000000');
INSERT INTO `t_s_country` VALUES ('218', '廊坊经济技术开发区', '131071000000', '131000000000');
INSERT INTO `t_s_country` VALUES ('219', '霸州市', '131081000000', '131000000000');
INSERT INTO `t_s_country` VALUES ('220', '三河市', '131082000000', '131000000000');
INSERT INTO `t_s_country` VALUES ('221', '市辖区', '131101000000', '131100000000');
INSERT INTO `t_s_country` VALUES ('222', '桃城区', '131102000000', '131100000000');
INSERT INTO `t_s_country` VALUES ('223', '冀州区', '131103000000', '131100000000');
INSERT INTO `t_s_country` VALUES ('224', '枣强县', '131121000000', '131100000000');
INSERT INTO `t_s_country` VALUES ('225', '武邑县', '131122000000', '131100000000');
INSERT INTO `t_s_country` VALUES ('226', '武强县', '131123000000', '131100000000');
INSERT INTO `t_s_country` VALUES ('227', '饶阳县', '131124000000', '131100000000');
INSERT INTO `t_s_country` VALUES ('228', '安平县', '131125000000', '131100000000');
INSERT INTO `t_s_country` VALUES ('229', '故城县', '131126000000', '131100000000');
INSERT INTO `t_s_country` VALUES ('230', '景县', '131127000000', '131100000000');
INSERT INTO `t_s_country` VALUES ('231', '阜城县', '131128000000', '131100000000');
INSERT INTO `t_s_country` VALUES ('232', '河北衡水高新技术产业开发区', '131171000000', '131100000000');
INSERT INTO `t_s_country` VALUES ('233', '衡水滨湖新区', '131172000000', '131100000000');
INSERT INTO `t_s_country` VALUES ('234', '深州市', '131182000000', '131100000000');
INSERT INTO `t_s_country` VALUES ('235', '市辖区', '140101000000', '140100000000');
INSERT INTO `t_s_country` VALUES ('236', '小店区', '140105000000', '140100000000');
INSERT INTO `t_s_country` VALUES ('237', '迎泽区', '140106000000', '140100000000');
INSERT INTO `t_s_country` VALUES ('238', '杏花岭区', '140107000000', '140100000000');
INSERT INTO `t_s_country` VALUES ('239', '尖草坪区', '140108000000', '140100000000');
INSERT INTO `t_s_country` VALUES ('240', '万柏林区', '140109000000', '140100000000');
INSERT INTO `t_s_country` VALUES ('241', '晋源区', '140110000000', '140100000000');
INSERT INTO `t_s_country` VALUES ('242', '清徐县', '140121000000', '140100000000');
INSERT INTO `t_s_country` VALUES ('243', '阳曲县', '140122000000', '140100000000');
INSERT INTO `t_s_country` VALUES ('244', '娄烦县', '140123000000', '140100000000');
INSERT INTO `t_s_country` VALUES ('245', '山西转型综合改革示范区', '140171000000', '140100000000');
INSERT INTO `t_s_country` VALUES ('246', '古交市', '140181000000', '140100000000');
INSERT INTO `t_s_country` VALUES ('247', '市辖区', '140201000000', '140200000000');
INSERT INTO `t_s_country` VALUES ('248', '新荣区', '140212000000', '140200000000');
INSERT INTO `t_s_country` VALUES ('249', '平城区', '140213000000', '140200000000');
INSERT INTO `t_s_country` VALUES ('250', '云冈区', '140214000000', '140200000000');
INSERT INTO `t_s_country` VALUES ('251', '云州区', '140215000000', '140200000000');
INSERT INTO `t_s_country` VALUES ('252', '阳高县', '140221000000', '140200000000');
INSERT INTO `t_s_country` VALUES ('253', '天镇县', '140222000000', '140200000000');
INSERT INTO `t_s_country` VALUES ('254', '广灵县', '140223000000', '140200000000');
INSERT INTO `t_s_country` VALUES ('255', '灵丘县', '140224000000', '140200000000');
INSERT INTO `t_s_country` VALUES ('256', '浑源县', '140225000000', '140200000000');
INSERT INTO `t_s_country` VALUES ('257', '左云县', '140226000000', '140200000000');
INSERT INTO `t_s_country` VALUES ('258', '山西大同经济开发区', '140271000000', '140200000000');
INSERT INTO `t_s_country` VALUES ('259', '市辖区', '140301000000', '140300000000');
INSERT INTO `t_s_country` VALUES ('260', '城区', '140302000000', '140300000000');
INSERT INTO `t_s_country` VALUES ('261', '矿区', '140303000000', '140300000000');
INSERT INTO `t_s_country` VALUES ('262', '郊区', '140311000000', '140300000000');
INSERT INTO `t_s_country` VALUES ('263', '平定县', '140321000000', '140300000000');
INSERT INTO `t_s_country` VALUES ('264', '盂县', '140322000000', '140300000000');
INSERT INTO `t_s_country` VALUES ('265', '市辖区', '140401000000', '140400000000');
INSERT INTO `t_s_country` VALUES ('266', '潞州区', '140412000000', '140400000000');
INSERT INTO `t_s_country` VALUES ('267', '上党区', '140413000000', '140400000000');
INSERT INTO `t_s_country` VALUES ('268', '屯留区', '140414000000', '140400000000');
INSERT INTO `t_s_country` VALUES ('269', '潞城区', '140415000000', '140400000000');
INSERT INTO `t_s_country` VALUES ('270', '襄垣县', '140423000000', '140400000000');
INSERT INTO `t_s_country` VALUES ('271', '平顺县', '140425000000', '140400000000');
INSERT INTO `t_s_country` VALUES ('272', '黎城县', '140426000000', '140400000000');
INSERT INTO `t_s_country` VALUES ('273', '壶关县', '140427000000', '140400000000');
INSERT INTO `t_s_country` VALUES ('274', '长子县', '140428000000', '140400000000');
INSERT INTO `t_s_country` VALUES ('275', '武乡县', '140429000000', '140400000000');
INSERT INTO `t_s_country` VALUES ('276', '沁县', '140430000000', '140400000000');
INSERT INTO `t_s_country` VALUES ('277', '沁源县', '140431000000', '140400000000');
INSERT INTO `t_s_country` VALUES ('278', '山西长治高新技术产业园区', '140471000000', '140400000000');
INSERT INTO `t_s_country` VALUES ('279', '市辖区', '140501000000', '140500000000');
INSERT INTO `t_s_country` VALUES ('280', '城区', '140502000000', '140500000000');
INSERT INTO `t_s_country` VALUES ('281', '沁水县', '140521000000', '140500000000');
INSERT INTO `t_s_country` VALUES ('282', '阳城县', '140522000000', '140500000000');
INSERT INTO `t_s_country` VALUES ('283', '陵川县', '140524000000', '140500000000');
INSERT INTO `t_s_country` VALUES ('284', '泽州县', '140525000000', '140500000000');
INSERT INTO `t_s_country` VALUES ('285', '高平市', '140581000000', '140500000000');
INSERT INTO `t_s_country` VALUES ('286', '市辖区', '140601000000', '140600000000');
INSERT INTO `t_s_country` VALUES ('287', '朔城区', '140602000000', '140600000000');
INSERT INTO `t_s_country` VALUES ('288', '平鲁区', '140603000000', '140600000000');
INSERT INTO `t_s_country` VALUES ('289', '山阴县', '140621000000', '140600000000');
INSERT INTO `t_s_country` VALUES ('290', '应县', '140622000000', '140600000000');
INSERT INTO `t_s_country` VALUES ('291', '右玉县', '140623000000', '140600000000');
INSERT INTO `t_s_country` VALUES ('292', '山西朔州经济开发区', '140671000000', '140600000000');
INSERT INTO `t_s_country` VALUES ('293', '怀仁市', '140681000000', '140600000000');
INSERT INTO `t_s_country` VALUES ('294', '市辖区', '140701000000', '140700000000');
INSERT INTO `t_s_country` VALUES ('295', '榆次区', '140702000000', '140700000000');
INSERT INTO `t_s_country` VALUES ('296', '榆社县', '140721000000', '140700000000');
INSERT INTO `t_s_country` VALUES ('297', '左权县', '140722000000', '140700000000');
INSERT INTO `t_s_country` VALUES ('298', '和顺县', '140723000000', '140700000000');
INSERT INTO `t_s_country` VALUES ('299', '昔阳县', '140724000000', '140700000000');
INSERT INTO `t_s_country` VALUES ('300', '寿阳县', '140725000000', '140700000000');
INSERT INTO `t_s_country` VALUES ('301', '太谷县', '140726000000', '140700000000');
INSERT INTO `t_s_country` VALUES ('302', '祁县', '140727000000', '140700000000');
INSERT INTO `t_s_country` VALUES ('303', '平遥县', '140728000000', '140700000000');
INSERT INTO `t_s_country` VALUES ('304', '灵石县', '140729000000', '140700000000');
INSERT INTO `t_s_country` VALUES ('305', '介休市', '140781000000', '140700000000');
INSERT INTO `t_s_country` VALUES ('306', '市辖区', '140801000000', '140800000000');
INSERT INTO `t_s_country` VALUES ('307', '盐湖区', '140802000000', '140800000000');
INSERT INTO `t_s_country` VALUES ('308', '临猗县', '140821000000', '140800000000');
INSERT INTO `t_s_country` VALUES ('309', '万荣县', '140822000000', '140800000000');
INSERT INTO `t_s_country` VALUES ('310', '闻喜县', '140823000000', '140800000000');
INSERT INTO `t_s_country` VALUES ('311', '稷山县', '140824000000', '140800000000');
INSERT INTO `t_s_country` VALUES ('312', '新绛县', '140825000000', '140800000000');
INSERT INTO `t_s_country` VALUES ('313', '绛县', '140826000000', '140800000000');
INSERT INTO `t_s_country` VALUES ('314', '垣曲县', '140827000000', '140800000000');
INSERT INTO `t_s_country` VALUES ('315', '夏县', '140828000000', '140800000000');
INSERT INTO `t_s_country` VALUES ('316', '平陆县', '140829000000', '140800000000');
INSERT INTO `t_s_country` VALUES ('317', '芮城县', '140830000000', '140800000000');
INSERT INTO `t_s_country` VALUES ('318', '永济市', '140881000000', '140800000000');
INSERT INTO `t_s_country` VALUES ('319', '河津市', '140882000000', '140800000000');
INSERT INTO `t_s_country` VALUES ('320', '市辖区', '140901000000', '140900000000');
INSERT INTO `t_s_country` VALUES ('321', '忻府区', '140902000000', '140900000000');
INSERT INTO `t_s_country` VALUES ('322', '定襄县', '140921000000', '140900000000');
INSERT INTO `t_s_country` VALUES ('323', '五台县', '140922000000', '140900000000');
INSERT INTO `t_s_country` VALUES ('324', '代县', '140923000000', '140900000000');
INSERT INTO `t_s_country` VALUES ('325', '繁峙县', '140924000000', '140900000000');
INSERT INTO `t_s_country` VALUES ('326', '宁武县', '140925000000', '140900000000');
INSERT INTO `t_s_country` VALUES ('327', '静乐县', '140926000000', '140900000000');
INSERT INTO `t_s_country` VALUES ('328', '神池县', '140927000000', '140900000000');
INSERT INTO `t_s_country` VALUES ('329', '五寨县', '140928000000', '140900000000');
INSERT INTO `t_s_country` VALUES ('330', '岢岚县', '140929000000', '140900000000');
INSERT INTO `t_s_country` VALUES ('331', '河曲县', '140930000000', '140900000000');
INSERT INTO `t_s_country` VALUES ('332', '保德县', '140931000000', '140900000000');
INSERT INTO `t_s_country` VALUES ('333', '偏关县', '140932000000', '140900000000');
INSERT INTO `t_s_country` VALUES ('334', '五台山风景名胜区', '140971000000', '140900000000');
INSERT INTO `t_s_country` VALUES ('335', '原平市', '140981000000', '140900000000');
INSERT INTO `t_s_country` VALUES ('336', '市辖区', '141001000000', '141000000000');
INSERT INTO `t_s_country` VALUES ('337', '尧都区', '141002000000', '141000000000');
INSERT INTO `t_s_country` VALUES ('338', '曲沃县', '141021000000', '141000000000');
INSERT INTO `t_s_country` VALUES ('339', '翼城县', '141022000000', '141000000000');
INSERT INTO `t_s_country` VALUES ('340', '襄汾县', '141023000000', '141000000000');
INSERT INTO `t_s_country` VALUES ('341', '洪洞县', '141024000000', '141000000000');
INSERT INTO `t_s_country` VALUES ('342', '古县', '141025000000', '141000000000');
INSERT INTO `t_s_country` VALUES ('343', '安泽县', '141026000000', '141000000000');
INSERT INTO `t_s_country` VALUES ('344', '浮山县', '141027000000', '141000000000');
INSERT INTO `t_s_country` VALUES ('345', '吉县', '141028000000', '141000000000');
INSERT INTO `t_s_country` VALUES ('346', '乡宁县', '141029000000', '141000000000');
INSERT INTO `t_s_country` VALUES ('347', '大宁县', '141030000000', '141000000000');
INSERT INTO `t_s_country` VALUES ('348', '隰县', '141031000000', '141000000000');
INSERT INTO `t_s_country` VALUES ('349', '永和县', '141032000000', '141000000000');
INSERT INTO `t_s_country` VALUES ('350', '蒲县', '141033000000', '141000000000');
INSERT INTO `t_s_country` VALUES ('351', '汾西县', '141034000000', '141000000000');
INSERT INTO `t_s_country` VALUES ('352', '侯马市', '141081000000', '141000000000');
INSERT INTO `t_s_country` VALUES ('353', '霍州市', '141082000000', '141000000000');
INSERT INTO `t_s_country` VALUES ('354', '市辖区', '141101000000', '141100000000');
INSERT INTO `t_s_country` VALUES ('355', '离石区', '141102000000', '141100000000');
INSERT INTO `t_s_country` VALUES ('356', '文水县', '141121000000', '141100000000');
INSERT INTO `t_s_country` VALUES ('357', '交城县', '141122000000', '141100000000');
INSERT INTO `t_s_country` VALUES ('358', '兴县', '141123000000', '141100000000');
INSERT INTO `t_s_country` VALUES ('359', '临县', '141124000000', '141100000000');
INSERT INTO `t_s_country` VALUES ('360', '柳林县', '141125000000', '141100000000');
INSERT INTO `t_s_country` VALUES ('361', '石楼县', '141126000000', '141100000000');
INSERT INTO `t_s_country` VALUES ('362', '岚县', '141127000000', '141100000000');
INSERT INTO `t_s_country` VALUES ('363', '方山县', '141128000000', '141100000000');
INSERT INTO `t_s_country` VALUES ('364', '中阳县', '141129000000', '141100000000');
INSERT INTO `t_s_country` VALUES ('365', '交口县', '141130000000', '141100000000');
INSERT INTO `t_s_country` VALUES ('366', '孝义市', '141181000000', '141100000000');
INSERT INTO `t_s_country` VALUES ('367', '汾阳市', '141182000000', '141100000000');
INSERT INTO `t_s_country` VALUES ('368', '市辖区', '150101000000', '150100000000');
INSERT INTO `t_s_country` VALUES ('369', '新城区', '150102000000', '150100000000');
INSERT INTO `t_s_country` VALUES ('370', '回民区', '150103000000', '150100000000');
INSERT INTO `t_s_country` VALUES ('371', '玉泉区', '150104000000', '150100000000');
INSERT INTO `t_s_country` VALUES ('372', '赛罕区', '150105000000', '150100000000');
INSERT INTO `t_s_country` VALUES ('373', '土默特左旗', '150121000000', '150100000000');
INSERT INTO `t_s_country` VALUES ('374', '托克托县', '150122000000', '150100000000');
INSERT INTO `t_s_country` VALUES ('375', '和林格尔县', '150123000000', '150100000000');
INSERT INTO `t_s_country` VALUES ('376', '清水河县', '150124000000', '150100000000');
INSERT INTO `t_s_country` VALUES ('377', '武川县', '150125000000', '150100000000');
INSERT INTO `t_s_country` VALUES ('378', '呼和浩特金海工业园区', '150171000000', '150100000000');
INSERT INTO `t_s_country` VALUES ('379', '呼和浩特经济技术开发区', '150172000000', '150100000000');
INSERT INTO `t_s_country` VALUES ('380', '市辖区', '150201000000', '150200000000');
INSERT INTO `t_s_country` VALUES ('381', '东河区', '150202000000', '150200000000');
INSERT INTO `t_s_country` VALUES ('382', '昆都仑区', '150203000000', '150200000000');
INSERT INTO `t_s_country` VALUES ('383', '青山区', '150204000000', '150200000000');
INSERT INTO `t_s_country` VALUES ('384', '石拐区', '150205000000', '150200000000');
INSERT INTO `t_s_country` VALUES ('385', '白云鄂博矿区', '150206000000', '150200000000');
INSERT INTO `t_s_country` VALUES ('386', '九原区', '150207000000', '150200000000');
INSERT INTO `t_s_country` VALUES ('387', '土默特右旗', '150221000000', '150200000000');
INSERT INTO `t_s_country` VALUES ('388', '固阳县', '150222000000', '150200000000');
INSERT INTO `t_s_country` VALUES ('389', '达尔罕茂明安联合旗', '150223000000', '150200000000');
INSERT INTO `t_s_country` VALUES ('390', '包头稀土高新技术产业开发区', '150271000000', '150200000000');
INSERT INTO `t_s_country` VALUES ('391', '市辖区', '150301000000', '150300000000');
INSERT INTO `t_s_country` VALUES ('392', '海勃湾区', '150302000000', '150300000000');
INSERT INTO `t_s_country` VALUES ('393', '海南区', '150303000000', '150300000000');
INSERT INTO `t_s_country` VALUES ('394', '乌达区', '150304000000', '150300000000');
INSERT INTO `t_s_country` VALUES ('395', '市辖区', '150401000000', '150400000000');
INSERT INTO `t_s_country` VALUES ('396', '红山区', '150402000000', '150400000000');
INSERT INTO `t_s_country` VALUES ('397', '元宝山区', '150403000000', '150400000000');
INSERT INTO `t_s_country` VALUES ('398', '松山区', '150404000000', '150400000000');
INSERT INTO `t_s_country` VALUES ('399', '阿鲁科尔沁旗', '150421000000', '150400000000');
INSERT INTO `t_s_country` VALUES ('400', '巴林左旗', '150422000000', '150400000000');
INSERT INTO `t_s_country` VALUES ('401', '巴林右旗', '150423000000', '150400000000');
INSERT INTO `t_s_country` VALUES ('402', '林西县', '150424000000', '150400000000');
INSERT INTO `t_s_country` VALUES ('403', '克什克腾旗', '150425000000', '150400000000');
INSERT INTO `t_s_country` VALUES ('404', '翁牛特旗', '150426000000', '150400000000');
INSERT INTO `t_s_country` VALUES ('405', '喀喇沁旗', '150428000000', '150400000000');
INSERT INTO `t_s_country` VALUES ('406', '宁城县', '150429000000', '150400000000');
INSERT INTO `t_s_country` VALUES ('407', '敖汉旗', '150430000000', '150400000000');
INSERT INTO `t_s_country` VALUES ('408', '市辖区', '150501000000', '150500000000');
INSERT INTO `t_s_country` VALUES ('409', '科尔沁区', '150502000000', '150500000000');
INSERT INTO `t_s_country` VALUES ('410', '科尔沁左翼中旗', '150521000000', '150500000000');
INSERT INTO `t_s_country` VALUES ('411', '科尔沁左翼后旗', '150522000000', '150500000000');
INSERT INTO `t_s_country` VALUES ('412', '开鲁县', '150523000000', '150500000000');
INSERT INTO `t_s_country` VALUES ('413', '库伦旗', '150524000000', '150500000000');
INSERT INTO `t_s_country` VALUES ('414', '奈曼旗', '150525000000', '150500000000');
INSERT INTO `t_s_country` VALUES ('415', '扎鲁特旗', '150526000000', '150500000000');
INSERT INTO `t_s_country` VALUES ('416', '通辽经济技术开发区', '150571000000', '150500000000');
INSERT INTO `t_s_country` VALUES ('417', '霍林郭勒市', '150581000000', '150500000000');
INSERT INTO `t_s_country` VALUES ('418', '市辖区', '150601000000', '150600000000');
INSERT INTO `t_s_country` VALUES ('419', '东胜区', '150602000000', '150600000000');
INSERT INTO `t_s_country` VALUES ('420', '康巴什区', '150603000000', '150600000000');
INSERT INTO `t_s_country` VALUES ('421', '达拉特旗', '150621000000', '150600000000');
INSERT INTO `t_s_country` VALUES ('422', '准格尔旗', '150622000000', '150600000000');
INSERT INTO `t_s_country` VALUES ('423', '鄂托克前旗', '150623000000', '150600000000');
INSERT INTO `t_s_country` VALUES ('424', '鄂托克旗', '150624000000', '150600000000');
INSERT INTO `t_s_country` VALUES ('425', '杭锦旗', '150625000000', '150600000000');
INSERT INTO `t_s_country` VALUES ('426', '乌审旗', '150626000000', '150600000000');
INSERT INTO `t_s_country` VALUES ('427', '伊金霍洛旗', '150627000000', '150600000000');
INSERT INTO `t_s_country` VALUES ('428', '市辖区', '150701000000', '150700000000');
INSERT INTO `t_s_country` VALUES ('429', '海拉尔区', '150702000000', '150700000000');
INSERT INTO `t_s_country` VALUES ('430', '扎赉诺尔区', '150703000000', '150700000000');
INSERT INTO `t_s_country` VALUES ('431', '阿荣旗', '150721000000', '150700000000');
INSERT INTO `t_s_country` VALUES ('432', '莫力达瓦达斡尔族自治旗', '150722000000', '150700000000');
INSERT INTO `t_s_country` VALUES ('433', '鄂伦春自治旗', '150723000000', '150700000000');
INSERT INTO `t_s_country` VALUES ('434', '鄂温克族自治旗', '150724000000', '150700000000');
INSERT INTO `t_s_country` VALUES ('435', '陈巴尔虎旗', '150725000000', '150700000000');
INSERT INTO `t_s_country` VALUES ('436', '新巴尔虎左旗', '150726000000', '150700000000');
INSERT INTO `t_s_country` VALUES ('437', '新巴尔虎右旗', '150727000000', '150700000000');
INSERT INTO `t_s_country` VALUES ('438', '满洲里市', '150781000000', '150700000000');
INSERT INTO `t_s_country` VALUES ('439', '牙克石市', '150782000000', '150700000000');
INSERT INTO `t_s_country` VALUES ('440', '扎兰屯市', '150783000000', '150700000000');
INSERT INTO `t_s_country` VALUES ('441', '额尔古纳市', '150784000000', '150700000000');
INSERT INTO `t_s_country` VALUES ('442', '根河市', '150785000000', '150700000000');
INSERT INTO `t_s_country` VALUES ('443', '市辖区', '150801000000', '150800000000');
INSERT INTO `t_s_country` VALUES ('444', '临河区', '150802000000', '150800000000');
INSERT INTO `t_s_country` VALUES ('445', '五原县', '150821000000', '150800000000');
INSERT INTO `t_s_country` VALUES ('446', '磴口县', '150822000000', '150800000000');
INSERT INTO `t_s_country` VALUES ('447', '乌拉特前旗', '150823000000', '150800000000');
INSERT INTO `t_s_country` VALUES ('448', '乌拉特中旗', '150824000000', '150800000000');
INSERT INTO `t_s_country` VALUES ('449', '乌拉特后旗', '150825000000', '150800000000');
INSERT INTO `t_s_country` VALUES ('450', '杭锦后旗', '150826000000', '150800000000');
INSERT INTO `t_s_country` VALUES ('451', '市辖区', '150901000000', '150900000000');
INSERT INTO `t_s_country` VALUES ('452', '集宁区', '150902000000', '150900000000');
INSERT INTO `t_s_country` VALUES ('453', '卓资县', '150921000000', '150900000000');
INSERT INTO `t_s_country` VALUES ('454', '化德县', '150922000000', '150900000000');
INSERT INTO `t_s_country` VALUES ('455', '商都县', '150923000000', '150900000000');
INSERT INTO `t_s_country` VALUES ('456', '兴和县', '150924000000', '150900000000');
INSERT INTO `t_s_country` VALUES ('457', '凉城县', '150925000000', '150900000000');
INSERT INTO `t_s_country` VALUES ('458', '察哈尔右翼前旗', '150926000000', '150900000000');
INSERT INTO `t_s_country` VALUES ('459', '察哈尔右翼中旗', '150927000000', '150900000000');
INSERT INTO `t_s_country` VALUES ('460', '察哈尔右翼后旗', '150928000000', '150900000000');
INSERT INTO `t_s_country` VALUES ('461', '四子王旗', '150929000000', '150900000000');
INSERT INTO `t_s_country` VALUES ('462', '丰镇市', '150981000000', '150900000000');
INSERT INTO `t_s_country` VALUES ('463', '乌兰浩特市', '152201000000', '152200000000');
INSERT INTO `t_s_country` VALUES ('464', '阿尔山市', '152202000000', '152200000000');
INSERT INTO `t_s_country` VALUES ('465', '科尔沁右翼前旗', '152221000000', '152200000000');
INSERT INTO `t_s_country` VALUES ('466', '科尔沁右翼中旗', '152222000000', '152200000000');
INSERT INTO `t_s_country` VALUES ('467', '扎赉特旗', '152223000000', '152200000000');
INSERT INTO `t_s_country` VALUES ('468', '突泉县', '152224000000', '152200000000');
INSERT INTO `t_s_country` VALUES ('469', '二连浩特市', '152501000000', '152500000000');
INSERT INTO `t_s_country` VALUES ('470', '锡林浩特市', '152502000000', '152500000000');
INSERT INTO `t_s_country` VALUES ('471', '阿巴嘎旗', '152522000000', '152500000000');
INSERT INTO `t_s_country` VALUES ('472', '苏尼特左旗', '152523000000', '152500000000');
INSERT INTO `t_s_country` VALUES ('473', '苏尼特右旗', '152524000000', '152500000000');
INSERT INTO `t_s_country` VALUES ('474', '东乌珠穆沁旗', '152525000000', '152500000000');
INSERT INTO `t_s_country` VALUES ('475', '西乌珠穆沁旗', '152526000000', '152500000000');
INSERT INTO `t_s_country` VALUES ('476', '太仆寺旗', '152527000000', '152500000000');
INSERT INTO `t_s_country` VALUES ('477', '镶黄旗', '152528000000', '152500000000');
INSERT INTO `t_s_country` VALUES ('478', '正镶白旗', '152529000000', '152500000000');
INSERT INTO `t_s_country` VALUES ('479', '正蓝旗', '152530000000', '152500000000');
INSERT INTO `t_s_country` VALUES ('480', '多伦县', '152531000000', '152500000000');
INSERT INTO `t_s_country` VALUES ('481', '乌拉盖管委会', '152571000000', '152500000000');
INSERT INTO `t_s_country` VALUES ('482', '阿拉善左旗', '152921000000', '152900000000');
INSERT INTO `t_s_country` VALUES ('483', '阿拉善右旗', '152922000000', '152900000000');
INSERT INTO `t_s_country` VALUES ('484', '额济纳旗', '152923000000', '152900000000');
INSERT INTO `t_s_country` VALUES ('485', '内蒙古阿拉善经济开发区', '152971000000', '152900000000');
INSERT INTO `t_s_country` VALUES ('486', '市辖区', '210101000000', '210100000000');
INSERT INTO `t_s_country` VALUES ('487', '和平区', '210102000000', '210100000000');
INSERT INTO `t_s_country` VALUES ('488', '沈河区', '210103000000', '210100000000');
INSERT INTO `t_s_country` VALUES ('489', '大东区', '210104000000', '210100000000');
INSERT INTO `t_s_country` VALUES ('490', '皇姑区', '210105000000', '210100000000');
INSERT INTO `t_s_country` VALUES ('491', '铁西区', '210106000000', '210100000000');
INSERT INTO `t_s_country` VALUES ('492', '苏家屯区', '210111000000', '210100000000');
INSERT INTO `t_s_country` VALUES ('493', '浑南区', '210112000000', '210100000000');
INSERT INTO `t_s_country` VALUES ('494', '沈北新区', '210113000000', '210100000000');
INSERT INTO `t_s_country` VALUES ('495', '于洪区', '210114000000', '210100000000');
INSERT INTO `t_s_country` VALUES ('496', '辽中区', '210115000000', '210100000000');
INSERT INTO `t_s_country` VALUES ('497', '康平县', '210123000000', '210100000000');
INSERT INTO `t_s_country` VALUES ('498', '法库县', '210124000000', '210100000000');
INSERT INTO `t_s_country` VALUES ('499', '新民市', '210181000000', '210100000000');
INSERT INTO `t_s_country` VALUES ('500', '市辖区', '210201000000', '210200000000');
INSERT INTO `t_s_country` VALUES ('501', '中山区', '210202000000', '210200000000');
INSERT INTO `t_s_country` VALUES ('502', '西岗区', '210203000000', '210200000000');
INSERT INTO `t_s_country` VALUES ('503', '沙河口区', '210204000000', '210200000000');
INSERT INTO `t_s_country` VALUES ('504', '甘井子区', '210211000000', '210200000000');
INSERT INTO `t_s_country` VALUES ('505', '旅顺口区', '210212000000', '210200000000');
INSERT INTO `t_s_country` VALUES ('506', '金州区', '210213000000', '210200000000');
INSERT INTO `t_s_country` VALUES ('507', '普兰店区', '210214000000', '210200000000');
INSERT INTO `t_s_country` VALUES ('508', '长海县', '210224000000', '210200000000');
INSERT INTO `t_s_country` VALUES ('509', '瓦房店市', '210281000000', '210200000000');
INSERT INTO `t_s_country` VALUES ('510', '庄河市', '210283000000', '210200000000');
INSERT INTO `t_s_country` VALUES ('511', '市辖区', '210301000000', '210300000000');
INSERT INTO `t_s_country` VALUES ('512', '铁东区', '210302000000', '210300000000');
INSERT INTO `t_s_country` VALUES ('513', '铁西区', '210303000000', '210300000000');
INSERT INTO `t_s_country` VALUES ('514', '立山区', '210304000000', '210300000000');
INSERT INTO `t_s_country` VALUES ('515', '千山区', '210311000000', '210300000000');
INSERT INTO `t_s_country` VALUES ('516', '台安县', '210321000000', '210300000000');
INSERT INTO `t_s_country` VALUES ('517', '岫岩满族自治县', '210323000000', '210300000000');
INSERT INTO `t_s_country` VALUES ('518', '海城市', '210381000000', '210300000000');
INSERT INTO `t_s_country` VALUES ('519', '市辖区', '210401000000', '210400000000');
INSERT INTO `t_s_country` VALUES ('520', '新抚区', '210402000000', '210400000000');
INSERT INTO `t_s_country` VALUES ('521', '东洲区', '210403000000', '210400000000');
INSERT INTO `t_s_country` VALUES ('522', '望花区', '210404000000', '210400000000');
INSERT INTO `t_s_country` VALUES ('523', '顺城区', '210411000000', '210400000000');
INSERT INTO `t_s_country` VALUES ('524', '抚顺县', '210421000000', '210400000000');
INSERT INTO `t_s_country` VALUES ('525', '新宾满族自治县', '210422000000', '210400000000');
INSERT INTO `t_s_country` VALUES ('526', '清原满族自治县', '210423000000', '210400000000');
INSERT INTO `t_s_country` VALUES ('527', '市辖区', '210501000000', '210500000000');
INSERT INTO `t_s_country` VALUES ('528', '平山区', '210502000000', '210500000000');
INSERT INTO `t_s_country` VALUES ('529', '溪湖区', '210503000000', '210500000000');
INSERT INTO `t_s_country` VALUES ('530', '明山区', '210504000000', '210500000000');
INSERT INTO `t_s_country` VALUES ('531', '南芬区', '210505000000', '210500000000');
INSERT INTO `t_s_country` VALUES ('532', '本溪满族自治县', '210521000000', '210500000000');
INSERT INTO `t_s_country` VALUES ('533', '桓仁满族自治县', '210522000000', '210500000000');
INSERT INTO `t_s_country` VALUES ('534', '市辖区', '210601000000', '210600000000');
INSERT INTO `t_s_country` VALUES ('535', '元宝区', '210602000000', '210600000000');
INSERT INTO `t_s_country` VALUES ('536', '振兴区', '210603000000', '210600000000');
INSERT INTO `t_s_country` VALUES ('537', '振安区', '210604000000', '210600000000');
INSERT INTO `t_s_country` VALUES ('538', '宽甸满族自治县', '210624000000', '210600000000');
INSERT INTO `t_s_country` VALUES ('539', '东港市', '210681000000', '210600000000');
INSERT INTO `t_s_country` VALUES ('540', '凤城市', '210682000000', '210600000000');
INSERT INTO `t_s_country` VALUES ('541', '市辖区', '210701000000', '210700000000');
INSERT INTO `t_s_country` VALUES ('542', '古塔区', '210702000000', '210700000000');
INSERT INTO `t_s_country` VALUES ('543', '凌河区', '210703000000', '210700000000');
INSERT INTO `t_s_country` VALUES ('544', '太和区', '210711000000', '210700000000');
INSERT INTO `t_s_country` VALUES ('545', '黑山县', '210726000000', '210700000000');
INSERT INTO `t_s_country` VALUES ('546', '义县', '210727000000', '210700000000');
INSERT INTO `t_s_country` VALUES ('547', '凌海市', '210781000000', '210700000000');
INSERT INTO `t_s_country` VALUES ('548', '北镇市', '210782000000', '210700000000');
INSERT INTO `t_s_country` VALUES ('549', '市辖区', '210801000000', '210800000000');
INSERT INTO `t_s_country` VALUES ('550', '站前区', '210802000000', '210800000000');
INSERT INTO `t_s_country` VALUES ('551', '西市区', '210803000000', '210800000000');
INSERT INTO `t_s_country` VALUES ('552', '鲅鱼圈区', '210804000000', '210800000000');
INSERT INTO `t_s_country` VALUES ('553', '老边区', '210811000000', '210800000000');
INSERT INTO `t_s_country` VALUES ('554', '盖州市', '210881000000', '210800000000');
INSERT INTO `t_s_country` VALUES ('555', '大石桥市', '210882000000', '210800000000');
INSERT INTO `t_s_country` VALUES ('556', '市辖区', '210901000000', '210900000000');
INSERT INTO `t_s_country` VALUES ('557', '海州区', '210902000000', '210900000000');
INSERT INTO `t_s_country` VALUES ('558', '新邱区', '210903000000', '210900000000');
INSERT INTO `t_s_country` VALUES ('559', '太平区', '210904000000', '210900000000');
INSERT INTO `t_s_country` VALUES ('560', '清河门区', '210905000000', '210900000000');
INSERT INTO `t_s_country` VALUES ('561', '细河区', '210911000000', '210900000000');
INSERT INTO `t_s_country` VALUES ('562', '阜新蒙古族自治县', '210921000000', '210900000000');
INSERT INTO `t_s_country` VALUES ('563', '彰武县', '210922000000', '210900000000');
INSERT INTO `t_s_country` VALUES ('564', '市辖区', '211001000000', '211000000000');
INSERT INTO `t_s_country` VALUES ('565', '白塔区', '211002000000', '211000000000');
INSERT INTO `t_s_country` VALUES ('566', '文圣区', '211003000000', '211000000000');
INSERT INTO `t_s_country` VALUES ('567', '宏伟区', '211004000000', '211000000000');
INSERT INTO `t_s_country` VALUES ('568', '弓长岭区', '211005000000', '211000000000');
INSERT INTO `t_s_country` VALUES ('569', '太子河区', '211011000000', '211000000000');
INSERT INTO `t_s_country` VALUES ('570', '辽阳县', '211021000000', '211000000000');
INSERT INTO `t_s_country` VALUES ('571', '灯塔市', '211081000000', '211000000000');
INSERT INTO `t_s_country` VALUES ('572', '市辖区', '211101000000', '211100000000');
INSERT INTO `t_s_country` VALUES ('573', '双台子区', '211102000000', '211100000000');
INSERT INTO `t_s_country` VALUES ('574', '兴隆台区', '211103000000', '211100000000');
INSERT INTO `t_s_country` VALUES ('575', '大洼区', '211104000000', '211100000000');
INSERT INTO `t_s_country` VALUES ('576', '盘山县', '211122000000', '211100000000');
INSERT INTO `t_s_country` VALUES ('577', '市辖区', '211201000000', '211200000000');
INSERT INTO `t_s_country` VALUES ('578', '银州区', '211202000000', '211200000000');
INSERT INTO `t_s_country` VALUES ('579', '清河区', '211204000000', '211200000000');
INSERT INTO `t_s_country` VALUES ('580', '铁岭县', '211221000000', '211200000000');
INSERT INTO `t_s_country` VALUES ('581', '西丰县', '211223000000', '211200000000');
INSERT INTO `t_s_country` VALUES ('582', '昌图县', '211224000000', '211200000000');
INSERT INTO `t_s_country` VALUES ('583', '调兵山市', '211281000000', '211200000000');
INSERT INTO `t_s_country` VALUES ('584', '开原市', '211282000000', '211200000000');
INSERT INTO `t_s_country` VALUES ('585', '市辖区', '211301000000', '211300000000');
INSERT INTO `t_s_country` VALUES ('586', '双塔区', '211302000000', '211300000000');
INSERT INTO `t_s_country` VALUES ('587', '龙城区', '211303000000', '211300000000');
INSERT INTO `t_s_country` VALUES ('588', '朝阳县', '211321000000', '211300000000');
INSERT INTO `t_s_country` VALUES ('589', '建平县', '211322000000', '211300000000');
INSERT INTO `t_s_country` VALUES ('590', '喀喇沁左翼蒙古族自治县', '211324000000', '211300000000');
INSERT INTO `t_s_country` VALUES ('591', '北票市', '211381000000', '211300000000');
INSERT INTO `t_s_country` VALUES ('592', '凌源市', '211382000000', '211300000000');
INSERT INTO `t_s_country` VALUES ('593', '市辖区', '211401000000', '211400000000');
INSERT INTO `t_s_country` VALUES ('594', '连山区', '211402000000', '211400000000');
INSERT INTO `t_s_country` VALUES ('595', '龙港区', '211403000000', '211400000000');
INSERT INTO `t_s_country` VALUES ('596', '南票区', '211404000000', '211400000000');
INSERT INTO `t_s_country` VALUES ('597', '绥中县', '211421000000', '211400000000');
INSERT INTO `t_s_country` VALUES ('598', '建昌县', '211422000000', '211400000000');
INSERT INTO `t_s_country` VALUES ('599', '兴城市', '211481000000', '211400000000');
INSERT INTO `t_s_country` VALUES ('600', '市辖区', '220101000000', '220100000000');
INSERT INTO `t_s_country` VALUES ('601', '南关区', '220102000000', '220100000000');
INSERT INTO `t_s_country` VALUES ('602', '宽城区', '220103000000', '220100000000');
INSERT INTO `t_s_country` VALUES ('603', '朝阳区', '220104000000', '220100000000');
INSERT INTO `t_s_country` VALUES ('604', '二道区', '220105000000', '220100000000');
INSERT INTO `t_s_country` VALUES ('605', '绿园区', '220106000000', '220100000000');
INSERT INTO `t_s_country` VALUES ('606', '双阳区', '220112000000', '220100000000');
INSERT INTO `t_s_country` VALUES ('607', '九台区', '220113000000', '220100000000');
INSERT INTO `t_s_country` VALUES ('608', '农安县', '220122000000', '220100000000');
INSERT INTO `t_s_country` VALUES ('609', '长春经济技术开发区', '220171000000', '220100000000');
INSERT INTO `t_s_country` VALUES ('610', '长春净月高新技术产业开发区', '220172000000', '220100000000');
INSERT INTO `t_s_country` VALUES ('611', '长春高新技术产业开发区', '220173000000', '220100000000');
INSERT INTO `t_s_country` VALUES ('612', '长春汽车经济技术开发区', '220174000000', '220100000000');
INSERT INTO `t_s_country` VALUES ('613', '榆树市', '220182000000', '220100000000');
INSERT INTO `t_s_country` VALUES ('614', '德惠市', '220183000000', '220100000000');
INSERT INTO `t_s_country` VALUES ('615', '市辖区', '220201000000', '220200000000');
INSERT INTO `t_s_country` VALUES ('616', '昌邑区', '220202000000', '220200000000');
INSERT INTO `t_s_country` VALUES ('617', '龙潭区', '220203000000', '220200000000');
INSERT INTO `t_s_country` VALUES ('618', '船营区', '220204000000', '220200000000');
INSERT INTO `t_s_country` VALUES ('619', '丰满区', '220211000000', '220200000000');
INSERT INTO `t_s_country` VALUES ('620', '永吉县', '220221000000', '220200000000');
INSERT INTO `t_s_country` VALUES ('621', '吉林经济开发区', '220271000000', '220200000000');
INSERT INTO `t_s_country` VALUES ('622', '吉林高新技术产业开发区', '220272000000', '220200000000');
INSERT INTO `t_s_country` VALUES ('623', '吉林中国新加坡食品区', '220273000000', '220200000000');
INSERT INTO `t_s_country` VALUES ('624', '蛟河市', '220281000000', '220200000000');
INSERT INTO `t_s_country` VALUES ('625', '桦甸市', '220282000000', '220200000000');
INSERT INTO `t_s_country` VALUES ('626', '舒兰市', '220283000000', '220200000000');
INSERT INTO `t_s_country` VALUES ('627', '磐石市', '220284000000', '220200000000');
INSERT INTO `t_s_country` VALUES ('628', '市辖区', '220301000000', '220300000000');
INSERT INTO `t_s_country` VALUES ('629', '铁西区', '220302000000', '220300000000');
INSERT INTO `t_s_country` VALUES ('630', '铁东区', '220303000000', '220300000000');
INSERT INTO `t_s_country` VALUES ('631', '梨树县', '220322000000', '220300000000');
INSERT INTO `t_s_country` VALUES ('632', '伊通满族自治县', '220323000000', '220300000000');
INSERT INTO `t_s_country` VALUES ('633', '公主岭市', '220381000000', '220300000000');
INSERT INTO `t_s_country` VALUES ('634', '双辽市', '220382000000', '220300000000');
INSERT INTO `t_s_country` VALUES ('635', '市辖区', '220401000000', '220400000000');
INSERT INTO `t_s_country` VALUES ('636', '龙山区', '220402000000', '220400000000');
INSERT INTO `t_s_country` VALUES ('637', '西安区', '220403000000', '220400000000');
INSERT INTO `t_s_country` VALUES ('638', '东丰县', '220421000000', '220400000000');
INSERT INTO `t_s_country` VALUES ('639', '东辽县', '220422000000', '220400000000');
INSERT INTO `t_s_country` VALUES ('640', '市辖区', '220501000000', '220500000000');
INSERT INTO `t_s_country` VALUES ('641', '东昌区', '220502000000', '220500000000');
INSERT INTO `t_s_country` VALUES ('642', '二道江区', '220503000000', '220500000000');
INSERT INTO `t_s_country` VALUES ('643', '通化县', '220521000000', '220500000000');
INSERT INTO `t_s_country` VALUES ('644', '辉南县', '220523000000', '220500000000');
INSERT INTO `t_s_country` VALUES ('645', '柳河县', '220524000000', '220500000000');
INSERT INTO `t_s_country` VALUES ('646', '梅河口市', '220581000000', '220500000000');
INSERT INTO `t_s_country` VALUES ('647', '集安市', '220582000000', '220500000000');
INSERT INTO `t_s_country` VALUES ('648', '市辖区', '220601000000', '220600000000');
INSERT INTO `t_s_country` VALUES ('649', '浑江区', '220602000000', '220600000000');
INSERT INTO `t_s_country` VALUES ('650', '江源区', '220605000000', '220600000000');
INSERT INTO `t_s_country` VALUES ('651', '抚松县', '220621000000', '220600000000');
INSERT INTO `t_s_country` VALUES ('652', '靖宇县', '220622000000', '220600000000');
INSERT INTO `t_s_country` VALUES ('653', '长白朝鲜族自治县', '220623000000', '220600000000');
INSERT INTO `t_s_country` VALUES ('654', '临江市', '220681000000', '220600000000');
INSERT INTO `t_s_country` VALUES ('655', '市辖区', '220701000000', '220700000000');
INSERT INTO `t_s_country` VALUES ('656', '宁江区', '220702000000', '220700000000');
INSERT INTO `t_s_country` VALUES ('657', '前郭尔罗斯蒙古族自治县', '220721000000', '220700000000');
INSERT INTO `t_s_country` VALUES ('658', '长岭县', '220722000000', '220700000000');
INSERT INTO `t_s_country` VALUES ('659', '乾安县', '220723000000', '220700000000');
INSERT INTO `t_s_country` VALUES ('660', '吉林松原经济开发区', '220771000000', '220700000000');
INSERT INTO `t_s_country` VALUES ('661', '扶余市', '220781000000', '220700000000');
INSERT INTO `t_s_country` VALUES ('662', '市辖区', '220801000000', '220800000000');
INSERT INTO `t_s_country` VALUES ('663', '洮北区', '220802000000', '220800000000');
INSERT INTO `t_s_country` VALUES ('664', '镇赉县', '220821000000', '220800000000');
INSERT INTO `t_s_country` VALUES ('665', '通榆县', '220822000000', '220800000000');
INSERT INTO `t_s_country` VALUES ('666', '吉林白城经济开发区', '220871000000', '220800000000');
INSERT INTO `t_s_country` VALUES ('667', '洮南市', '220881000000', '220800000000');
INSERT INTO `t_s_country` VALUES ('668', '大安市', '220882000000', '220800000000');
INSERT INTO `t_s_country` VALUES ('669', '延吉市', '222401000000', '222400000000');
INSERT INTO `t_s_country` VALUES ('670', '图们市', '222402000000', '222400000000');
INSERT INTO `t_s_country` VALUES ('671', '敦化市', '222403000000', '222400000000');
INSERT INTO `t_s_country` VALUES ('672', '珲春市', '222404000000', '222400000000');
INSERT INTO `t_s_country` VALUES ('673', '龙井市', '222405000000', '222400000000');
INSERT INTO `t_s_country` VALUES ('674', '和龙市', '222406000000', '222400000000');
INSERT INTO `t_s_country` VALUES ('675', '汪清县', '222424000000', '222400000000');
INSERT INTO `t_s_country` VALUES ('676', '安图县', '222426000000', '222400000000');
INSERT INTO `t_s_country` VALUES ('677', '市辖区', '230101000000', '230100000000');
INSERT INTO `t_s_country` VALUES ('678', '道里区', '230102000000', '230100000000');
INSERT INTO `t_s_country` VALUES ('679', '南岗区', '230103000000', '230100000000');
INSERT INTO `t_s_country` VALUES ('680', '道外区', '230104000000', '230100000000');
INSERT INTO `t_s_country` VALUES ('681', '平房区', '230108000000', '230100000000');
INSERT INTO `t_s_country` VALUES ('682', '松北区', '230109000000', '230100000000');
INSERT INTO `t_s_country` VALUES ('683', '香坊区', '230110000000', '230100000000');
INSERT INTO `t_s_country` VALUES ('684', '呼兰区', '230111000000', '230100000000');
INSERT INTO `t_s_country` VALUES ('685', '阿城区', '230112000000', '230100000000');
INSERT INTO `t_s_country` VALUES ('686', '双城区', '230113000000', '230100000000');
INSERT INTO `t_s_country` VALUES ('687', '依兰县', '230123000000', '230100000000');
INSERT INTO `t_s_country` VALUES ('688', '方正县', '230124000000', '230100000000');
INSERT INTO `t_s_country` VALUES ('689', '宾县', '230125000000', '230100000000');
INSERT INTO `t_s_country` VALUES ('690', '巴彦县', '230126000000', '230100000000');
INSERT INTO `t_s_country` VALUES ('691', '木兰县', '230127000000', '230100000000');
INSERT INTO `t_s_country` VALUES ('692', '通河县', '230128000000', '230100000000');
INSERT INTO `t_s_country` VALUES ('693', '延寿县', '230129000000', '230100000000');
INSERT INTO `t_s_country` VALUES ('694', '尚志市', '230183000000', '230100000000');
INSERT INTO `t_s_country` VALUES ('695', '五常市', '230184000000', '230100000000');
INSERT INTO `t_s_country` VALUES ('696', '市辖区', '230201000000', '230200000000');
INSERT INTO `t_s_country` VALUES ('697', '龙沙区', '230202000000', '230200000000');
INSERT INTO `t_s_country` VALUES ('698', '建华区', '230203000000', '230200000000');
INSERT INTO `t_s_country` VALUES ('699', '铁锋区', '230204000000', '230200000000');
INSERT INTO `t_s_country` VALUES ('700', '昂昂溪区', '230205000000', '230200000000');
INSERT INTO `t_s_country` VALUES ('701', '富拉尔基区', '230206000000', '230200000000');
INSERT INTO `t_s_country` VALUES ('702', '碾子山区', '230207000000', '230200000000');
INSERT INTO `t_s_country` VALUES ('703', '梅里斯达斡尔族区', '230208000000', '230200000000');
INSERT INTO `t_s_country` VALUES ('704', '龙江县', '230221000000', '230200000000');
INSERT INTO `t_s_country` VALUES ('705', '依安县', '230223000000', '230200000000');
INSERT INTO `t_s_country` VALUES ('706', '泰来县', '230224000000', '230200000000');
INSERT INTO `t_s_country` VALUES ('707', '甘南县', '230225000000', '230200000000');
INSERT INTO `t_s_country` VALUES ('708', '富裕县', '230227000000', '230200000000');
INSERT INTO `t_s_country` VALUES ('709', '克山县', '230229000000', '230200000000');
INSERT INTO `t_s_country` VALUES ('710', '克东县', '230230000000', '230200000000');
INSERT INTO `t_s_country` VALUES ('711', '拜泉县', '230231000000', '230200000000');
INSERT INTO `t_s_country` VALUES ('712', '讷河市', '230281000000', '230200000000');
INSERT INTO `t_s_country` VALUES ('713', '市辖区', '230301000000', '230300000000');
INSERT INTO `t_s_country` VALUES ('714', '鸡冠区', '230302000000', '230300000000');
INSERT INTO `t_s_country` VALUES ('715', '恒山区', '230303000000', '230300000000');
INSERT INTO `t_s_country` VALUES ('716', '滴道区', '230304000000', '230300000000');
INSERT INTO `t_s_country` VALUES ('717', '梨树区', '230305000000', '230300000000');
INSERT INTO `t_s_country` VALUES ('718', '城子河区', '230306000000', '230300000000');
INSERT INTO `t_s_country` VALUES ('719', '麻山区', '230307000000', '230300000000');
INSERT INTO `t_s_country` VALUES ('720', '鸡东县', '230321000000', '230300000000');
INSERT INTO `t_s_country` VALUES ('721', '虎林市', '230381000000', '230300000000');
INSERT INTO `t_s_country` VALUES ('722', '密山市', '230382000000', '230300000000');
INSERT INTO `t_s_country` VALUES ('723', '市辖区', '230401000000', '230400000000');
INSERT INTO `t_s_country` VALUES ('724', '向阳区', '230402000000', '230400000000');
INSERT INTO `t_s_country` VALUES ('725', '工农区', '230403000000', '230400000000');
INSERT INTO `t_s_country` VALUES ('726', '南山区', '230404000000', '230400000000');
INSERT INTO `t_s_country` VALUES ('727', '兴安区', '230405000000', '230400000000');
INSERT INTO `t_s_country` VALUES ('728', '东山区', '230406000000', '230400000000');
INSERT INTO `t_s_country` VALUES ('729', '兴山区', '230407000000', '230400000000');
INSERT INTO `t_s_country` VALUES ('730', '萝北县', '230421000000', '230400000000');
INSERT INTO `t_s_country` VALUES ('731', '绥滨县', '230422000000', '230400000000');
INSERT INTO `t_s_country` VALUES ('732', '市辖区', '230501000000', '230500000000');
INSERT INTO `t_s_country` VALUES ('733', '尖山区', '230502000000', '230500000000');
INSERT INTO `t_s_country` VALUES ('734', '岭东区', '230503000000', '230500000000');
INSERT INTO `t_s_country` VALUES ('735', '四方台区', '230505000000', '230500000000');
INSERT INTO `t_s_country` VALUES ('736', '宝山区', '230506000000', '230500000000');
INSERT INTO `t_s_country` VALUES ('737', '集贤县', '230521000000', '230500000000');
INSERT INTO `t_s_country` VALUES ('738', '友谊县', '230522000000', '230500000000');
INSERT INTO `t_s_country` VALUES ('739', '宝清县', '230523000000', '230500000000');
INSERT INTO `t_s_country` VALUES ('740', '饶河县', '230524000000', '230500000000');
INSERT INTO `t_s_country` VALUES ('741', '市辖区', '230601000000', '230600000000');
INSERT INTO `t_s_country` VALUES ('742', '萨尔图区', '230602000000', '230600000000');
INSERT INTO `t_s_country` VALUES ('743', '龙凤区', '230603000000', '230600000000');
INSERT INTO `t_s_country` VALUES ('744', '让胡路区', '230604000000', '230600000000');
INSERT INTO `t_s_country` VALUES ('745', '红岗区', '230605000000', '230600000000');
INSERT INTO `t_s_country` VALUES ('746', '大同区', '230606000000', '230600000000');
INSERT INTO `t_s_country` VALUES ('747', '肇州县', '230621000000', '230600000000');
INSERT INTO `t_s_country` VALUES ('748', '肇源县', '230622000000', '230600000000');
INSERT INTO `t_s_country` VALUES ('749', '林甸县', '230623000000', '230600000000');
INSERT INTO `t_s_country` VALUES ('750', '杜尔伯特蒙古族自治县', '230624000000', '230600000000');
INSERT INTO `t_s_country` VALUES ('751', '大庆高新技术产业开发区', '230671000000', '230600000000');
INSERT INTO `t_s_country` VALUES ('752', '市辖区', '230701000000', '230700000000');
INSERT INTO `t_s_country` VALUES ('753', '伊春区', '230702000000', '230700000000');
INSERT INTO `t_s_country` VALUES ('754', '南岔区', '230703000000', '230700000000');
INSERT INTO `t_s_country` VALUES ('755', '友好区', '230704000000', '230700000000');
INSERT INTO `t_s_country` VALUES ('756', '西林区', '230705000000', '230700000000');
INSERT INTO `t_s_country` VALUES ('757', '翠峦区', '230706000000', '230700000000');
INSERT INTO `t_s_country` VALUES ('758', '新青区', '230707000000', '230700000000');
INSERT INTO `t_s_country` VALUES ('759', '美溪区', '230708000000', '230700000000');
INSERT INTO `t_s_country` VALUES ('760', '金山屯区', '230709000000', '230700000000');
INSERT INTO `t_s_country` VALUES ('761', '五营区', '230710000000', '230700000000');
INSERT INTO `t_s_country` VALUES ('762', '乌马河区', '230711000000', '230700000000');
INSERT INTO `t_s_country` VALUES ('763', '汤旺河区', '230712000000', '230700000000');
INSERT INTO `t_s_country` VALUES ('764', '带岭区', '230713000000', '230700000000');
INSERT INTO `t_s_country` VALUES ('765', '乌伊岭区', '230714000000', '230700000000');
INSERT INTO `t_s_country` VALUES ('766', '红星区', '230715000000', '230700000000');
INSERT INTO `t_s_country` VALUES ('767', '上甘岭区', '230716000000', '230700000000');
INSERT INTO `t_s_country` VALUES ('768', '嘉荫县', '230722000000', '230700000000');
INSERT INTO `t_s_country` VALUES ('769', '铁力市', '230781000000', '230700000000');
INSERT INTO `t_s_country` VALUES ('770', '市辖区', '230801000000', '230800000000');
INSERT INTO `t_s_country` VALUES ('771', '向阳区', '230803000000', '230800000000');
INSERT INTO `t_s_country` VALUES ('772', '前进区', '230804000000', '230800000000');
INSERT INTO `t_s_country` VALUES ('773', '东风区', '230805000000', '230800000000');
INSERT INTO `t_s_country` VALUES ('774', '郊区', '230811000000', '230800000000');
INSERT INTO `t_s_country` VALUES ('775', '桦南县', '230822000000', '230800000000');
INSERT INTO `t_s_country` VALUES ('776', '桦川县', '230826000000', '230800000000');
INSERT INTO `t_s_country` VALUES ('777', '汤原县', '230828000000', '230800000000');
INSERT INTO `t_s_country` VALUES ('778', '同江市', '230881000000', '230800000000');
INSERT INTO `t_s_country` VALUES ('779', '富锦市', '230882000000', '230800000000');
INSERT INTO `t_s_country` VALUES ('780', '抚远市', '230883000000', '230800000000');
INSERT INTO `t_s_country` VALUES ('781', '市辖区', '230901000000', '230900000000');
INSERT INTO `t_s_country` VALUES ('782', '新兴区', '230902000000', '230900000000');
INSERT INTO `t_s_country` VALUES ('783', '桃山区', '230903000000', '230900000000');
INSERT INTO `t_s_country` VALUES ('784', '茄子河区', '230904000000', '230900000000');
INSERT INTO `t_s_country` VALUES ('785', '勃利县', '230921000000', '230900000000');
INSERT INTO `t_s_country` VALUES ('786', '市辖区', '231001000000', '231000000000');
INSERT INTO `t_s_country` VALUES ('787', '东安区', '231002000000', '231000000000');
INSERT INTO `t_s_country` VALUES ('788', '阳明区', '231003000000', '231000000000');
INSERT INTO `t_s_country` VALUES ('789', '爱民区', '231004000000', '231000000000');
INSERT INTO `t_s_country` VALUES ('790', '西安区', '231005000000', '231000000000');
INSERT INTO `t_s_country` VALUES ('791', '林口县', '231025000000', '231000000000');
INSERT INTO `t_s_country` VALUES ('792', '牡丹江经济技术开发区', '231071000000', '231000000000');
INSERT INTO `t_s_country` VALUES ('793', '绥芬河市', '231081000000', '231000000000');
INSERT INTO `t_s_country` VALUES ('794', '海林市', '231083000000', '231000000000');
INSERT INTO `t_s_country` VALUES ('795', '宁安市', '231084000000', '231000000000');
INSERT INTO `t_s_country` VALUES ('796', '穆棱市', '231085000000', '231000000000');
INSERT INTO `t_s_country` VALUES ('797', '东宁市', '231086000000', '231000000000');
INSERT INTO `t_s_country` VALUES ('798', '市辖区', '231101000000', '231100000000');
INSERT INTO `t_s_country` VALUES ('799', '爱辉区', '231102000000', '231100000000');
INSERT INTO `t_s_country` VALUES ('800', '嫩江县', '231121000000', '231100000000');
INSERT INTO `t_s_country` VALUES ('801', '逊克县', '231123000000', '231100000000');
INSERT INTO `t_s_country` VALUES ('802', '孙吴县', '231124000000', '231100000000');
INSERT INTO `t_s_country` VALUES ('803', '北安市', '231181000000', '231100000000');
INSERT INTO `t_s_country` VALUES ('804', '五大连池市', '231182000000', '231100000000');
INSERT INTO `t_s_country` VALUES ('805', '市辖区', '231201000000', '231200000000');
INSERT INTO `t_s_country` VALUES ('806', '北林区', '231202000000', '231200000000');
INSERT INTO `t_s_country` VALUES ('807', '望奎县', '231221000000', '231200000000');
INSERT INTO `t_s_country` VALUES ('808', '兰西县', '231222000000', '231200000000');
INSERT INTO `t_s_country` VALUES ('809', '青冈县', '231223000000', '231200000000');
INSERT INTO `t_s_country` VALUES ('810', '庆安县', '231224000000', '231200000000');
INSERT INTO `t_s_country` VALUES ('811', '明水县', '231225000000', '231200000000');
INSERT INTO `t_s_country` VALUES ('812', '绥棱县', '231226000000', '231200000000');
INSERT INTO `t_s_country` VALUES ('813', '安达市', '231281000000', '231200000000');
INSERT INTO `t_s_country` VALUES ('814', '肇东市', '231282000000', '231200000000');
INSERT INTO `t_s_country` VALUES ('815', '海伦市', '231283000000', '231200000000');
INSERT INTO `t_s_country` VALUES ('816', '漠河市', '232701000000', '232700000000');
INSERT INTO `t_s_country` VALUES ('817', '呼玛县', '232721000000', '232700000000');
INSERT INTO `t_s_country` VALUES ('818', '塔河县', '232722000000', '232700000000');
INSERT INTO `t_s_country` VALUES ('819', '加格达奇区', '232761000000', '232700000000');
INSERT INTO `t_s_country` VALUES ('820', '松岭区', '232762000000', '232700000000');
INSERT INTO `t_s_country` VALUES ('821', '新林区', '232763000000', '232700000000');
INSERT INTO `t_s_country` VALUES ('822', '呼中区', '232764000000', '232700000000');
INSERT INTO `t_s_country` VALUES ('823', '黄浦区', '310101000000', '310100000000');
INSERT INTO `t_s_country` VALUES ('824', '徐汇区', '310104000000', '310100000000');
INSERT INTO `t_s_country` VALUES ('825', '长宁区', '310105000000', '310100000000');
INSERT INTO `t_s_country` VALUES ('826', '静安区', '310106000000', '310100000000');
INSERT INTO `t_s_country` VALUES ('827', '普陀区', '310107000000', '310100000000');
INSERT INTO `t_s_country` VALUES ('828', '虹口区', '310109000000', '310100000000');
INSERT INTO `t_s_country` VALUES ('829', '杨浦区', '310110000000', '310100000000');
INSERT INTO `t_s_country` VALUES ('830', '闵行区', '310112000000', '310100000000');
INSERT INTO `t_s_country` VALUES ('831', '宝山区', '310113000000', '310100000000');
INSERT INTO `t_s_country` VALUES ('832', '嘉定区', '310114000000', '310100000000');
INSERT INTO `t_s_country` VALUES ('833', '浦东新区', '310115000000', '310100000000');
INSERT INTO `t_s_country` VALUES ('834', '金山区', '310116000000', '310100000000');
INSERT INTO `t_s_country` VALUES ('835', '松江区', '310117000000', '310100000000');
INSERT INTO `t_s_country` VALUES ('836', '青浦区', '310118000000', '310100000000');
INSERT INTO `t_s_country` VALUES ('837', '奉贤区', '310120000000', '310100000000');
INSERT INTO `t_s_country` VALUES ('838', '崇明区', '310151000000', '310100000000');
INSERT INTO `t_s_country` VALUES ('839', '市辖区', '320101000000', '320100000000');
INSERT INTO `t_s_country` VALUES ('840', '玄武区', '320102000000', '320100000000');
INSERT INTO `t_s_country` VALUES ('841', '秦淮区', '320104000000', '320100000000');
INSERT INTO `t_s_country` VALUES ('842', '建邺区', '320105000000', '320100000000');
INSERT INTO `t_s_country` VALUES ('843', '鼓楼区', '320106000000', '320100000000');
INSERT INTO `t_s_country` VALUES ('844', '浦口区', '320111000000', '320100000000');
INSERT INTO `t_s_country` VALUES ('845', '栖霞区', '320113000000', '320100000000');
INSERT INTO `t_s_country` VALUES ('846', '雨花台区', '320114000000', '320100000000');
INSERT INTO `t_s_country` VALUES ('847', '江宁区', '320115000000', '320100000000');
INSERT INTO `t_s_country` VALUES ('848', '六合区', '320116000000', '320100000000');
INSERT INTO `t_s_country` VALUES ('849', '溧水区', '320117000000', '320100000000');
INSERT INTO `t_s_country` VALUES ('850', '高淳区', '320118000000', '320100000000');
INSERT INTO `t_s_country` VALUES ('851', '市辖区', '320201000000', '320200000000');
INSERT INTO `t_s_country` VALUES ('852', '锡山区', '320205000000', '320200000000');
INSERT INTO `t_s_country` VALUES ('853', '惠山区', '320206000000', '320200000000');
INSERT INTO `t_s_country` VALUES ('854', '滨湖区', '320211000000', '320200000000');
INSERT INTO `t_s_country` VALUES ('855', '梁溪区', '320213000000', '320200000000');
INSERT INTO `t_s_country` VALUES ('856', '新吴区', '320214000000', '320200000000');
INSERT INTO `t_s_country` VALUES ('857', '江阴市', '320281000000', '320200000000');
INSERT INTO `t_s_country` VALUES ('858', '宜兴市', '320282000000', '320200000000');
INSERT INTO `t_s_country` VALUES ('859', '市辖区', '320301000000', '320300000000');
INSERT INTO `t_s_country` VALUES ('860', '鼓楼区', '320302000000', '320300000000');
INSERT INTO `t_s_country` VALUES ('861', '云龙区', '320303000000', '320300000000');
INSERT INTO `t_s_country` VALUES ('862', '贾汪区', '320305000000', '320300000000');
INSERT INTO `t_s_country` VALUES ('863', '泉山区', '320311000000', '320300000000');
INSERT INTO `t_s_country` VALUES ('864', '铜山区', '320312000000', '320300000000');
INSERT INTO `t_s_country` VALUES ('865', '丰县', '320321000000', '320300000000');
INSERT INTO `t_s_country` VALUES ('866', '沛县', '320322000000', '320300000000');
INSERT INTO `t_s_country` VALUES ('867', '睢宁县', '320324000000', '320300000000');
INSERT INTO `t_s_country` VALUES ('868', '徐州经济技术开发区', '320371000000', '320300000000');
INSERT INTO `t_s_country` VALUES ('869', '新沂市', '320381000000', '320300000000');
INSERT INTO `t_s_country` VALUES ('870', '邳州市', '320382000000', '320300000000');
INSERT INTO `t_s_country` VALUES ('871', '市辖区', '320401000000', '320400000000');
INSERT INTO `t_s_country` VALUES ('872', '天宁区', '320402000000', '320400000000');
INSERT INTO `t_s_country` VALUES ('873', '钟楼区', '320404000000', '320400000000');
INSERT INTO `t_s_country` VALUES ('874', '新北区', '320411000000', '320400000000');
INSERT INTO `t_s_country` VALUES ('875', '武进区', '320412000000', '320400000000');
INSERT INTO `t_s_country` VALUES ('876', '金坛区', '320413000000', '320400000000');
INSERT INTO `t_s_country` VALUES ('877', '溧阳市', '320481000000', '320400000000');
INSERT INTO `t_s_country` VALUES ('878', '市辖区', '320501000000', '320500000000');
INSERT INTO `t_s_country` VALUES ('879', '虎丘区', '320505000000', '320500000000');
INSERT INTO `t_s_country` VALUES ('880', '吴中区', '320506000000', '320500000000');
INSERT INTO `t_s_country` VALUES ('881', '相城区', '320507000000', '320500000000');
INSERT INTO `t_s_country` VALUES ('882', '姑苏区', '320508000000', '320500000000');
INSERT INTO `t_s_country` VALUES ('883', '吴江区', '320509000000', '320500000000');
INSERT INTO `t_s_country` VALUES ('884', '苏州工业园区', '320571000000', '320500000000');
INSERT INTO `t_s_country` VALUES ('885', '常熟市', '320581000000', '320500000000');
INSERT INTO `t_s_country` VALUES ('886', '张家港市', '320582000000', '320500000000');
INSERT INTO `t_s_country` VALUES ('887', '昆山市', '320583000000', '320500000000');
INSERT INTO `t_s_country` VALUES ('888', '太仓市', '320585000000', '320500000000');
INSERT INTO `t_s_country` VALUES ('889', '市辖区', '320601000000', '320600000000');
INSERT INTO `t_s_country` VALUES ('890', '崇川区', '320602000000', '320600000000');
INSERT INTO `t_s_country` VALUES ('891', '港闸区', '320611000000', '320600000000');
INSERT INTO `t_s_country` VALUES ('892', '通州区', '320612000000', '320600000000');
INSERT INTO `t_s_country` VALUES ('893', '如东县', '320623000000', '320600000000');
INSERT INTO `t_s_country` VALUES ('894', '南通经济技术开发区', '320671000000', '320600000000');
INSERT INTO `t_s_country` VALUES ('895', '启东市', '320681000000', '320600000000');
INSERT INTO `t_s_country` VALUES ('896', '如皋市', '320682000000', '320600000000');
INSERT INTO `t_s_country` VALUES ('897', '海门市', '320684000000', '320600000000');
INSERT INTO `t_s_country` VALUES ('898', '海安市', '320685000000', '320600000000');
INSERT INTO `t_s_country` VALUES ('899', '市辖区', '320701000000', '320700000000');
INSERT INTO `t_s_country` VALUES ('900', '连云区', '320703000000', '320700000000');
INSERT INTO `t_s_country` VALUES ('901', '海州区', '320706000000', '320700000000');
INSERT INTO `t_s_country` VALUES ('902', '赣榆区', '320707000000', '320700000000');
INSERT INTO `t_s_country` VALUES ('903', '东海县', '320722000000', '320700000000');
INSERT INTO `t_s_country` VALUES ('904', '灌云县', '320723000000', '320700000000');
INSERT INTO `t_s_country` VALUES ('905', '灌南县', '320724000000', '320700000000');
INSERT INTO `t_s_country` VALUES ('906', '连云港经济技术开发区', '320771000000', '320700000000');
INSERT INTO `t_s_country` VALUES ('907', '连云港高新技术产业开发区', '320772000000', '320700000000');
INSERT INTO `t_s_country` VALUES ('908', '市辖区', '320801000000', '320800000000');
INSERT INTO `t_s_country` VALUES ('909', '淮安区', '320803000000', '320800000000');
INSERT INTO `t_s_country` VALUES ('910', '淮阴区', '320804000000', '320800000000');
INSERT INTO `t_s_country` VALUES ('911', '清江浦区', '320812000000', '320800000000');
INSERT INTO `t_s_country` VALUES ('912', '洪泽区', '320813000000', '320800000000');
INSERT INTO `t_s_country` VALUES ('913', '涟水县', '320826000000', '320800000000');
INSERT INTO `t_s_country` VALUES ('914', '盱眙县', '320830000000', '320800000000');
INSERT INTO `t_s_country` VALUES ('915', '金湖县', '320831000000', '320800000000');
INSERT INTO `t_s_country` VALUES ('916', '淮安经济技术开发区', '320871000000', '320800000000');
INSERT INTO `t_s_country` VALUES ('917', '市辖区', '320901000000', '320900000000');
INSERT INTO `t_s_country` VALUES ('918', '亭湖区', '320902000000', '320900000000');
INSERT INTO `t_s_country` VALUES ('919', '盐都区', '320903000000', '320900000000');
INSERT INTO `t_s_country` VALUES ('920', '大丰区', '320904000000', '320900000000');
INSERT INTO `t_s_country` VALUES ('921', '响水县', '320921000000', '320900000000');
INSERT INTO `t_s_country` VALUES ('922', '滨海县', '320922000000', '320900000000');
INSERT INTO `t_s_country` VALUES ('923', '阜宁县', '320923000000', '320900000000');
INSERT INTO `t_s_country` VALUES ('924', '射阳县', '320924000000', '320900000000');
INSERT INTO `t_s_country` VALUES ('925', '建湖县', '320925000000', '320900000000');
INSERT INTO `t_s_country` VALUES ('926', '盐城经济技术开发区', '320971000000', '320900000000');
INSERT INTO `t_s_country` VALUES ('927', '东台市', '320981000000', '320900000000');
INSERT INTO `t_s_country` VALUES ('928', '市辖区', '321001000000', '321000000000');
INSERT INTO `t_s_country` VALUES ('929', '广陵区', '321002000000', '321000000000');
INSERT INTO `t_s_country` VALUES ('930', '邗江区', '321003000000', '321000000000');
INSERT INTO `t_s_country` VALUES ('931', '江都区', '321012000000', '321000000000');
INSERT INTO `t_s_country` VALUES ('932', '宝应县', '321023000000', '321000000000');
INSERT INTO `t_s_country` VALUES ('933', '扬州经济技术开发区', '321071000000', '321000000000');
INSERT INTO `t_s_country` VALUES ('934', '仪征市', '321081000000', '321000000000');
INSERT INTO `t_s_country` VALUES ('935', '高邮市', '321084000000', '321000000000');
INSERT INTO `t_s_country` VALUES ('936', '市辖区', '321101000000', '321100000000');
INSERT INTO `t_s_country` VALUES ('937', '京口区', '321102000000', '321100000000');
INSERT INTO `t_s_country` VALUES ('938', '润州区', '321111000000', '321100000000');
INSERT INTO `t_s_country` VALUES ('939', '丹徒区', '321112000000', '321100000000');
INSERT INTO `t_s_country` VALUES ('940', '镇江新区', '321171000000', '321100000000');
INSERT INTO `t_s_country` VALUES ('941', '丹阳市', '321181000000', '321100000000');
INSERT INTO `t_s_country` VALUES ('942', '扬中市', '321182000000', '321100000000');
INSERT INTO `t_s_country` VALUES ('943', '句容市', '321183000000', '321100000000');
INSERT INTO `t_s_country` VALUES ('944', '市辖区', '321201000000', '321200000000');
INSERT INTO `t_s_country` VALUES ('945', '海陵区', '321202000000', '321200000000');
INSERT INTO `t_s_country` VALUES ('946', '高港区', '321203000000', '321200000000');
INSERT INTO `t_s_country` VALUES ('947', '姜堰区', '321204000000', '321200000000');
INSERT INTO `t_s_country` VALUES ('948', '泰州医药高新技术产业开发区', '321271000000', '321200000000');
INSERT INTO `t_s_country` VALUES ('949', '兴化市', '321281000000', '321200000000');
INSERT INTO `t_s_country` VALUES ('950', '靖江市', '321282000000', '321200000000');
INSERT INTO `t_s_country` VALUES ('951', '泰兴市', '321283000000', '321200000000');
INSERT INTO `t_s_country` VALUES ('952', '市辖区', '321301000000', '321300000000');
INSERT INTO `t_s_country` VALUES ('953', '宿城区', '321302000000', '321300000000');
INSERT INTO `t_s_country` VALUES ('954', '宿豫区', '321311000000', '321300000000');
INSERT INTO `t_s_country` VALUES ('955', '沭阳县', '321322000000', '321300000000');
INSERT INTO `t_s_country` VALUES ('956', '泗阳县', '321323000000', '321300000000');
INSERT INTO `t_s_country` VALUES ('957', '泗洪县', '321324000000', '321300000000');
INSERT INTO `t_s_country` VALUES ('958', '宿迁经济技术开发区', '321371000000', '321300000000');
INSERT INTO `t_s_country` VALUES ('959', '市辖区', '330101000000', '330100000000');
INSERT INTO `t_s_country` VALUES ('960', '上城区', '330102000000', '330100000000');
INSERT INTO `t_s_country` VALUES ('961', '下城区', '330103000000', '330100000000');
INSERT INTO `t_s_country` VALUES ('962', '江干区', '330104000000', '330100000000');
INSERT INTO `t_s_country` VALUES ('963', '拱墅区', '330105000000', '330100000000');
INSERT INTO `t_s_country` VALUES ('964', '西湖区', '330106000000', '330100000000');
INSERT INTO `t_s_country` VALUES ('965', '滨江区', '330108000000', '330100000000');
INSERT INTO `t_s_country` VALUES ('966', '萧山区', '330109000000', '330100000000');
INSERT INTO `t_s_country` VALUES ('967', '余杭区', '330110000000', '330100000000');
INSERT INTO `t_s_country` VALUES ('968', '富阳区', '330111000000', '330100000000');
INSERT INTO `t_s_country` VALUES ('969', '临安区', '330112000000', '330100000000');
INSERT INTO `t_s_country` VALUES ('970', '桐庐县', '330122000000', '330100000000');
INSERT INTO `t_s_country` VALUES ('971', '淳安县', '330127000000', '330100000000');
INSERT INTO `t_s_country` VALUES ('972', '建德市', '330182000000', '330100000000');
INSERT INTO `t_s_country` VALUES ('973', '市辖区', '330201000000', '330200000000');
INSERT INTO `t_s_country` VALUES ('974', '海曙区', '330203000000', '330200000000');
INSERT INTO `t_s_country` VALUES ('975', '江北区', '330205000000', '330200000000');
INSERT INTO `t_s_country` VALUES ('976', '北仑区', '330206000000', '330200000000');
INSERT INTO `t_s_country` VALUES ('977', '镇海区', '330211000000', '330200000000');
INSERT INTO `t_s_country` VALUES ('978', '鄞州区', '330212000000', '330200000000');
INSERT INTO `t_s_country` VALUES ('979', '奉化区', '330213000000', '330200000000');
INSERT INTO `t_s_country` VALUES ('980', '象山县', '330225000000', '330200000000');
INSERT INTO `t_s_country` VALUES ('981', '宁海县', '330226000000', '330200000000');
INSERT INTO `t_s_country` VALUES ('982', '余姚市', '330281000000', '330200000000');
INSERT INTO `t_s_country` VALUES ('983', '慈溪市', '330282000000', '330200000000');
INSERT INTO `t_s_country` VALUES ('984', '市辖区', '330301000000', '330300000000');
INSERT INTO `t_s_country` VALUES ('985', '鹿城区', '330302000000', '330300000000');
INSERT INTO `t_s_country` VALUES ('986', '龙湾区', '330303000000', '330300000000');
INSERT INTO `t_s_country` VALUES ('987', '瓯海区', '330304000000', '330300000000');
INSERT INTO `t_s_country` VALUES ('988', '洞头区', '330305000000', '330300000000');
INSERT INTO `t_s_country` VALUES ('989', '永嘉县', '330324000000', '330300000000');
INSERT INTO `t_s_country` VALUES ('990', '平阳县', '330326000000', '330300000000');
INSERT INTO `t_s_country` VALUES ('991', '苍南县', '330327000000', '330300000000');
INSERT INTO `t_s_country` VALUES ('992', '文成县', '330328000000', '330300000000');
INSERT INTO `t_s_country` VALUES ('993', '泰顺县', '330329000000', '330300000000');
INSERT INTO `t_s_country` VALUES ('994', '温州经济技术开发区', '330371000000', '330300000000');
INSERT INTO `t_s_country` VALUES ('995', '瑞安市', '330381000000', '330300000000');
INSERT INTO `t_s_country` VALUES ('996', '乐清市', '330382000000', '330300000000');
INSERT INTO `t_s_country` VALUES ('997', '市辖区', '330401000000', '330400000000');
INSERT INTO `t_s_country` VALUES ('998', '南湖区', '330402000000', '330400000000');
INSERT INTO `t_s_country` VALUES ('999', '秀洲区', '330411000000', '330400000000');
INSERT INTO `t_s_country` VALUES ('1000', '嘉善县', '330421000000', '330400000000');
INSERT INTO `t_s_country` VALUES ('1001', '海盐县', '330424000000', '330400000000');
INSERT INTO `t_s_country` VALUES ('1002', '海宁市', '330481000000', '330400000000');
INSERT INTO `t_s_country` VALUES ('1003', '平湖市', '330482000000', '330400000000');
INSERT INTO `t_s_country` VALUES ('1004', '桐乡市', '330483000000', '330400000000');
INSERT INTO `t_s_country` VALUES ('1005', '市辖区', '330501000000', '330500000000');
INSERT INTO `t_s_country` VALUES ('1006', '吴兴区', '330502000000', '330500000000');
INSERT INTO `t_s_country` VALUES ('1007', '南浔区', '330503000000', '330500000000');
INSERT INTO `t_s_country` VALUES ('1008', '德清县', '330521000000', '330500000000');
INSERT INTO `t_s_country` VALUES ('1009', '长兴县', '330522000000', '330500000000');
INSERT INTO `t_s_country` VALUES ('1010', '安吉县', '330523000000', '330500000000');
INSERT INTO `t_s_country` VALUES ('1011', '市辖区', '330601000000', '330600000000');
INSERT INTO `t_s_country` VALUES ('1012', '越城区', '330602000000', '330600000000');
INSERT INTO `t_s_country` VALUES ('1013', '柯桥区', '330603000000', '330600000000');
INSERT INTO `t_s_country` VALUES ('1014', '上虞区', '330604000000', '330600000000');
INSERT INTO `t_s_country` VALUES ('1015', '新昌县', '330624000000', '330600000000');
INSERT INTO `t_s_country` VALUES ('1016', '诸暨市', '330681000000', '330600000000');
INSERT INTO `t_s_country` VALUES ('1017', '嵊州市', '330683000000', '330600000000');
INSERT INTO `t_s_country` VALUES ('1018', '市辖区', '330701000000', '330700000000');
INSERT INTO `t_s_country` VALUES ('1019', '婺城区', '330702000000', '330700000000');
INSERT INTO `t_s_country` VALUES ('1020', '金东区', '330703000000', '330700000000');
INSERT INTO `t_s_country` VALUES ('1021', '武义县', '330723000000', '330700000000');
INSERT INTO `t_s_country` VALUES ('1022', '浦江县', '330726000000', '330700000000');
INSERT INTO `t_s_country` VALUES ('1023', '磐安县', '330727000000', '330700000000');
INSERT INTO `t_s_country` VALUES ('1024', '兰溪市', '330781000000', '330700000000');
INSERT INTO `t_s_country` VALUES ('1025', '义乌市', '330782000000', '330700000000');
INSERT INTO `t_s_country` VALUES ('1026', '东阳市', '330783000000', '330700000000');
INSERT INTO `t_s_country` VALUES ('1027', '永康市', '330784000000', '330700000000');
INSERT INTO `t_s_country` VALUES ('1028', '市辖区', '330801000000', '330800000000');
INSERT INTO `t_s_country` VALUES ('1029', '柯城区', '330802000000', '330800000000');
INSERT INTO `t_s_country` VALUES ('1030', '衢江区', '330803000000', '330800000000');
INSERT INTO `t_s_country` VALUES ('1031', '常山县', '330822000000', '330800000000');
INSERT INTO `t_s_country` VALUES ('1032', '开化县', '330824000000', '330800000000');
INSERT INTO `t_s_country` VALUES ('1033', '龙游县', '330825000000', '330800000000');
INSERT INTO `t_s_country` VALUES ('1034', '江山市', '330881000000', '330800000000');
INSERT INTO `t_s_country` VALUES ('1035', '市辖区', '330901000000', '330900000000');
INSERT INTO `t_s_country` VALUES ('1036', '定海区', '330902000000', '330900000000');
INSERT INTO `t_s_country` VALUES ('1037', '普陀区', '330903000000', '330900000000');
INSERT INTO `t_s_country` VALUES ('1038', '岱山县', '330921000000', '330900000000');
INSERT INTO `t_s_country` VALUES ('1039', '嵊泗县', '330922000000', '330900000000');
INSERT INTO `t_s_country` VALUES ('1040', '市辖区', '331001000000', '331000000000');
INSERT INTO `t_s_country` VALUES ('1041', '椒江区', '331002000000', '331000000000');
INSERT INTO `t_s_country` VALUES ('1042', '黄岩区', '331003000000', '331000000000');
INSERT INTO `t_s_country` VALUES ('1043', '路桥区', '331004000000', '331000000000');
INSERT INTO `t_s_country` VALUES ('1044', '三门县', '331022000000', '331000000000');
INSERT INTO `t_s_country` VALUES ('1045', '天台县', '331023000000', '331000000000');
INSERT INTO `t_s_country` VALUES ('1046', '仙居县', '331024000000', '331000000000');
INSERT INTO `t_s_country` VALUES ('1047', '温岭市', '331081000000', '331000000000');
INSERT INTO `t_s_country` VALUES ('1048', '临海市', '331082000000', '331000000000');
INSERT INTO `t_s_country` VALUES ('1049', '玉环市', '331083000000', '331000000000');
INSERT INTO `t_s_country` VALUES ('1050', '市辖区', '331101000000', '331100000000');
INSERT INTO `t_s_country` VALUES ('1051', '莲都区', '331102000000', '331100000000');
INSERT INTO `t_s_country` VALUES ('1052', '青田县', '331121000000', '331100000000');
INSERT INTO `t_s_country` VALUES ('1053', '缙云县', '331122000000', '331100000000');
INSERT INTO `t_s_country` VALUES ('1054', '遂昌县', '331123000000', '331100000000');
INSERT INTO `t_s_country` VALUES ('1055', '松阳县', '331124000000', '331100000000');
INSERT INTO `t_s_country` VALUES ('1056', '云和县', '331125000000', '331100000000');
INSERT INTO `t_s_country` VALUES ('1057', '庆元县', '331126000000', '331100000000');
INSERT INTO `t_s_country` VALUES ('1058', '景宁畲族自治县', '331127000000', '331100000000');
INSERT INTO `t_s_country` VALUES ('1059', '龙泉市', '331181000000', '331100000000');
INSERT INTO `t_s_country` VALUES ('1060', '市辖区', '340101000000', '340100000000');
INSERT INTO `t_s_country` VALUES ('1061', '瑶海区', '340102000000', '340100000000');
INSERT INTO `t_s_country` VALUES ('1062', '庐阳区', '340103000000', '340100000000');
INSERT INTO `t_s_country` VALUES ('1063', '蜀山区', '340104000000', '340100000000');
INSERT INTO `t_s_country` VALUES ('1064', '包河区', '340111000000', '340100000000');
INSERT INTO `t_s_country` VALUES ('1065', '长丰县', '340121000000', '340100000000');
INSERT INTO `t_s_country` VALUES ('1066', '肥东县', '340122000000', '340100000000');
INSERT INTO `t_s_country` VALUES ('1067', '肥西县', '340123000000', '340100000000');
INSERT INTO `t_s_country` VALUES ('1068', '庐江县', '340124000000', '340100000000');
INSERT INTO `t_s_country` VALUES ('1069', '合肥高新技术产业开发区', '340171000000', '340100000000');
INSERT INTO `t_s_country` VALUES ('1070', '合肥经济技术开发区', '340172000000', '340100000000');
INSERT INTO `t_s_country` VALUES ('1071', '合肥新站高新技术产业开发区', '340173000000', '340100000000');
INSERT INTO `t_s_country` VALUES ('1072', '巢湖市', '340181000000', '340100000000');
INSERT INTO `t_s_country` VALUES ('1073', '市辖区', '340201000000', '340200000000');
INSERT INTO `t_s_country` VALUES ('1074', '镜湖区', '340202000000', '340200000000');
INSERT INTO `t_s_country` VALUES ('1075', '弋江区', '340203000000', '340200000000');
INSERT INTO `t_s_country` VALUES ('1076', '鸠江区', '340207000000', '340200000000');
INSERT INTO `t_s_country` VALUES ('1077', '三山区', '340208000000', '340200000000');
INSERT INTO `t_s_country` VALUES ('1078', '芜湖县', '340221000000', '340200000000');
INSERT INTO `t_s_country` VALUES ('1079', '繁昌县', '340222000000', '340200000000');
INSERT INTO `t_s_country` VALUES ('1080', '南陵县', '340223000000', '340200000000');
INSERT INTO `t_s_country` VALUES ('1081', '无为县', '340225000000', '340200000000');
INSERT INTO `t_s_country` VALUES ('1082', '芜湖经济技术开发区', '340271000000', '340200000000');
INSERT INTO `t_s_country` VALUES ('1083', '安徽芜湖长江大桥经济开发区', '340272000000', '340200000000');
INSERT INTO `t_s_country` VALUES ('1084', '市辖区', '340301000000', '340300000000');
INSERT INTO `t_s_country` VALUES ('1085', '龙子湖区', '340302000000', '340300000000');
INSERT INTO `t_s_country` VALUES ('1086', '蚌山区', '340303000000', '340300000000');
INSERT INTO `t_s_country` VALUES ('1087', '禹会区', '340304000000', '340300000000');
INSERT INTO `t_s_country` VALUES ('1088', '淮上区', '340311000000', '340300000000');
INSERT INTO `t_s_country` VALUES ('1089', '怀远县', '340321000000', '340300000000');
INSERT INTO `t_s_country` VALUES ('1090', '五河县', '340322000000', '340300000000');
INSERT INTO `t_s_country` VALUES ('1091', '固镇县', '340323000000', '340300000000');
INSERT INTO `t_s_country` VALUES ('1092', '蚌埠市高新技术开发区', '340371000000', '340300000000');
INSERT INTO `t_s_country` VALUES ('1093', '蚌埠市经济开发区', '340372000000', '340300000000');
INSERT INTO `t_s_country` VALUES ('1094', '市辖区', '340401000000', '340400000000');
INSERT INTO `t_s_country` VALUES ('1095', '大通区', '340402000000', '340400000000');
INSERT INTO `t_s_country` VALUES ('1096', '田家庵区', '340403000000', '340400000000');
INSERT INTO `t_s_country` VALUES ('1097', '谢家集区', '340404000000', '340400000000');
INSERT INTO `t_s_country` VALUES ('1098', '八公山区', '340405000000', '340400000000');
INSERT INTO `t_s_country` VALUES ('1099', '潘集区', '340406000000', '340400000000');
INSERT INTO `t_s_country` VALUES ('1100', '凤台县', '340421000000', '340400000000');
INSERT INTO `t_s_country` VALUES ('1101', '寿县', '340422000000', '340400000000');
INSERT INTO `t_s_country` VALUES ('1102', '市辖区', '340501000000', '340500000000');
INSERT INTO `t_s_country` VALUES ('1103', '花山区', '340503000000', '340500000000');
INSERT INTO `t_s_country` VALUES ('1104', '雨山区', '340504000000', '340500000000');
INSERT INTO `t_s_country` VALUES ('1105', '博望区', '340506000000', '340500000000');
INSERT INTO `t_s_country` VALUES ('1106', '当涂县', '340521000000', '340500000000');
INSERT INTO `t_s_country` VALUES ('1107', '含山县', '340522000000', '340500000000');
INSERT INTO `t_s_country` VALUES ('1108', '和县', '340523000000', '340500000000');
INSERT INTO `t_s_country` VALUES ('1109', '市辖区', '340601000000', '340600000000');
INSERT INTO `t_s_country` VALUES ('1110', '杜集区', '340602000000', '340600000000');
INSERT INTO `t_s_country` VALUES ('1111', '相山区', '340603000000', '340600000000');
INSERT INTO `t_s_country` VALUES ('1112', '烈山区', '340604000000', '340600000000');
INSERT INTO `t_s_country` VALUES ('1113', '濉溪县', '340621000000', '340600000000');
INSERT INTO `t_s_country` VALUES ('1114', '市辖区', '340701000000', '340700000000');
INSERT INTO `t_s_country` VALUES ('1115', '铜官区', '340705000000', '340700000000');
INSERT INTO `t_s_country` VALUES ('1116', '义安区', '340706000000', '340700000000');
INSERT INTO `t_s_country` VALUES ('1117', '郊区', '340711000000', '340700000000');
INSERT INTO `t_s_country` VALUES ('1118', '枞阳县', '340722000000', '340700000000');
INSERT INTO `t_s_country` VALUES ('1119', '市辖区', '340801000000', '340800000000');
INSERT INTO `t_s_country` VALUES ('1120', '迎江区', '340802000000', '340800000000');
INSERT INTO `t_s_country` VALUES ('1121', '大观区', '340803000000', '340800000000');
INSERT INTO `t_s_country` VALUES ('1122', '宜秀区', '340811000000', '340800000000');
INSERT INTO `t_s_country` VALUES ('1123', '怀宁县', '340822000000', '340800000000');
INSERT INTO `t_s_country` VALUES ('1124', '太湖县', '340825000000', '340800000000');
INSERT INTO `t_s_country` VALUES ('1125', '宿松县', '340826000000', '340800000000');
INSERT INTO `t_s_country` VALUES ('1126', '望江县', '340827000000', '340800000000');
INSERT INTO `t_s_country` VALUES ('1127', '岳西县', '340828000000', '340800000000');
INSERT INTO `t_s_country` VALUES ('1128', '安徽安庆经济开发区', '340871000000', '340800000000');
INSERT INTO `t_s_country` VALUES ('1129', '桐城市', '340881000000', '340800000000');
INSERT INTO `t_s_country` VALUES ('1130', '潜山市', '340882000000', '340800000000');
INSERT INTO `t_s_country` VALUES ('1131', '市辖区', '341001000000', '341000000000');
INSERT INTO `t_s_country` VALUES ('1132', '屯溪区', '341002000000', '341000000000');
INSERT INTO `t_s_country` VALUES ('1133', '黄山区', '341003000000', '341000000000');
INSERT INTO `t_s_country` VALUES ('1134', '徽州区', '341004000000', '341000000000');
INSERT INTO `t_s_country` VALUES ('1135', '歙县', '341021000000', '341000000000');
INSERT INTO `t_s_country` VALUES ('1136', '休宁县', '341022000000', '341000000000');
INSERT INTO `t_s_country` VALUES ('1137', '黟县', '341023000000', '341000000000');
INSERT INTO `t_s_country` VALUES ('1138', '祁门县', '341024000000', '341000000000');
INSERT INTO `t_s_country` VALUES ('1139', '市辖区', '341101000000', '341100000000');
INSERT INTO `t_s_country` VALUES ('1140', '琅琊区', '341102000000', '341100000000');
INSERT INTO `t_s_country` VALUES ('1141', '南谯区', '341103000000', '341100000000');
INSERT INTO `t_s_country` VALUES ('1142', '来安县', '341122000000', '341100000000');
INSERT INTO `t_s_country` VALUES ('1143', '全椒县', '341124000000', '341100000000');
INSERT INTO `t_s_country` VALUES ('1144', '定远县', '341125000000', '341100000000');
INSERT INTO `t_s_country` VALUES ('1145', '凤阳县', '341126000000', '341100000000');
INSERT INTO `t_s_country` VALUES ('1146', '苏滁现代产业园', '341171000000', '341100000000');
INSERT INTO `t_s_country` VALUES ('1147', '滁州经济技术开发区', '341172000000', '341100000000');
INSERT INTO `t_s_country` VALUES ('1148', '天长市', '341181000000', '341100000000');
INSERT INTO `t_s_country` VALUES ('1149', '明光市', '341182000000', '341100000000');
INSERT INTO `t_s_country` VALUES ('1150', '市辖区', '341201000000', '341200000000');
INSERT INTO `t_s_country` VALUES ('1151', '颍州区', '341202000000', '341200000000');
INSERT INTO `t_s_country` VALUES ('1152', '颍东区', '341203000000', '341200000000');
INSERT INTO `t_s_country` VALUES ('1153', '颍泉区', '341204000000', '341200000000');
INSERT INTO `t_s_country` VALUES ('1154', '临泉县', '341221000000', '341200000000');
INSERT INTO `t_s_country` VALUES ('1155', '太和县', '341222000000', '341200000000');
INSERT INTO `t_s_country` VALUES ('1156', '阜南县', '341225000000', '341200000000');
INSERT INTO `t_s_country` VALUES ('1157', '颍上县', '341226000000', '341200000000');
INSERT INTO `t_s_country` VALUES ('1158', '阜阳合肥现代产业园区', '341271000000', '341200000000');
INSERT INTO `t_s_country` VALUES ('1159', '阜阳经济技术开发区', '341272000000', '341200000000');
INSERT INTO `t_s_country` VALUES ('1160', '界首市', '341282000000', '341200000000');
INSERT INTO `t_s_country` VALUES ('1161', '市辖区', '341301000000', '341300000000');
INSERT INTO `t_s_country` VALUES ('1162', '埇桥区', '341302000000', '341300000000');
INSERT INTO `t_s_country` VALUES ('1163', '砀山县', '341321000000', '341300000000');
INSERT INTO `t_s_country` VALUES ('1164', '萧县', '341322000000', '341300000000');
INSERT INTO `t_s_country` VALUES ('1165', '灵璧县', '341323000000', '341300000000');
INSERT INTO `t_s_country` VALUES ('1166', '泗县', '341324000000', '341300000000');
INSERT INTO `t_s_country` VALUES ('1167', '宿州马鞍山现代产业园区', '341371000000', '341300000000');
INSERT INTO `t_s_country` VALUES ('1168', '宿州经济技术开发区', '341372000000', '341300000000');
INSERT INTO `t_s_country` VALUES ('1169', '市辖区', '341501000000', '341500000000');
INSERT INTO `t_s_country` VALUES ('1170', '金安区', '341502000000', '341500000000');
INSERT INTO `t_s_country` VALUES ('1171', '裕安区', '341503000000', '341500000000');
INSERT INTO `t_s_country` VALUES ('1172', '叶集区', '341504000000', '341500000000');
INSERT INTO `t_s_country` VALUES ('1173', '霍邱县', '341522000000', '341500000000');
INSERT INTO `t_s_country` VALUES ('1174', '舒城县', '341523000000', '341500000000');
INSERT INTO `t_s_country` VALUES ('1175', '金寨县', '341524000000', '341500000000');
INSERT INTO `t_s_country` VALUES ('1176', '霍山县', '341525000000', '341500000000');
INSERT INTO `t_s_country` VALUES ('1177', '市辖区', '341601000000', '341600000000');
INSERT INTO `t_s_country` VALUES ('1178', '谯城区', '341602000000', '341600000000');
INSERT INTO `t_s_country` VALUES ('1179', '涡阳县', '341621000000', '341600000000');
INSERT INTO `t_s_country` VALUES ('1180', '蒙城县', '341622000000', '341600000000');
INSERT INTO `t_s_country` VALUES ('1181', '利辛县', '341623000000', '341600000000');
INSERT INTO `t_s_country` VALUES ('1182', '市辖区', '341701000000', '341700000000');
INSERT INTO `t_s_country` VALUES ('1183', '贵池区', '341702000000', '341700000000');
INSERT INTO `t_s_country` VALUES ('1184', '东至县', '341721000000', '341700000000');
INSERT INTO `t_s_country` VALUES ('1185', '石台县', '341722000000', '341700000000');
INSERT INTO `t_s_country` VALUES ('1186', '青阳县', '341723000000', '341700000000');
INSERT INTO `t_s_country` VALUES ('1187', '市辖区', '341801000000', '341800000000');
INSERT INTO `t_s_country` VALUES ('1188', '宣州区', '341802000000', '341800000000');
INSERT INTO `t_s_country` VALUES ('1189', '郎溪县', '341821000000', '341800000000');
INSERT INTO `t_s_country` VALUES ('1190', '广德县', '341822000000', '341800000000');
INSERT INTO `t_s_country` VALUES ('1191', '泾县', '341823000000', '341800000000');
INSERT INTO `t_s_country` VALUES ('1192', '绩溪县', '341824000000', '341800000000');
INSERT INTO `t_s_country` VALUES ('1193', '旌德县', '341825000000', '341800000000');
INSERT INTO `t_s_country` VALUES ('1194', '宣城市经济开发区', '341871000000', '341800000000');
INSERT INTO `t_s_country` VALUES ('1195', '宁国市', '341881000000', '341800000000');
INSERT INTO `t_s_country` VALUES ('1196', '市辖区', '350101000000', '350100000000');
INSERT INTO `t_s_country` VALUES ('1197', '鼓楼区', '350102000000', '350100000000');
INSERT INTO `t_s_country` VALUES ('1198', '台江区', '350103000000', '350100000000');
INSERT INTO `t_s_country` VALUES ('1199', '仓山区', '350104000000', '350100000000');
INSERT INTO `t_s_country` VALUES ('1200', '马尾区', '350105000000', '350100000000');
INSERT INTO `t_s_country` VALUES ('1201', '晋安区', '350111000000', '350100000000');
INSERT INTO `t_s_country` VALUES ('1202', '长乐区', '350112000000', '350100000000');
INSERT INTO `t_s_country` VALUES ('1203', '闽侯县', '350121000000', '350100000000');
INSERT INTO `t_s_country` VALUES ('1204', '连江县', '350122000000', '350100000000');
INSERT INTO `t_s_country` VALUES ('1205', '罗源县', '350123000000', '350100000000');
INSERT INTO `t_s_country` VALUES ('1206', '闽清县', '350124000000', '350100000000');
INSERT INTO `t_s_country` VALUES ('1207', '永泰县', '350125000000', '350100000000');
INSERT INTO `t_s_country` VALUES ('1208', '平潭县', '350128000000', '350100000000');
INSERT INTO `t_s_country` VALUES ('1209', '福清市', '350181000000', '350100000000');
INSERT INTO `t_s_country` VALUES ('1210', '市辖区', '350201000000', '350200000000');
INSERT INTO `t_s_country` VALUES ('1211', '思明区', '350203000000', '350200000000');
INSERT INTO `t_s_country` VALUES ('1212', '海沧区', '350205000000', '350200000000');
INSERT INTO `t_s_country` VALUES ('1213', '湖里区', '350206000000', '350200000000');
INSERT INTO `t_s_country` VALUES ('1214', '集美区', '350211000000', '350200000000');
INSERT INTO `t_s_country` VALUES ('1215', '同安区', '350212000000', '350200000000');
INSERT INTO `t_s_country` VALUES ('1216', '翔安区', '350213000000', '350200000000');
INSERT INTO `t_s_country` VALUES ('1217', '市辖区', '350301000000', '350300000000');
INSERT INTO `t_s_country` VALUES ('1218', '城厢区', '350302000000', '350300000000');
INSERT INTO `t_s_country` VALUES ('1219', '涵江区', '350303000000', '350300000000');
INSERT INTO `t_s_country` VALUES ('1220', '荔城区', '350304000000', '350300000000');
INSERT INTO `t_s_country` VALUES ('1221', '秀屿区', '350305000000', '350300000000');
INSERT INTO `t_s_country` VALUES ('1222', '仙游县', '350322000000', '350300000000');
INSERT INTO `t_s_country` VALUES ('1223', '市辖区', '350401000000', '350400000000');
INSERT INTO `t_s_country` VALUES ('1224', '梅列区', '350402000000', '350400000000');
INSERT INTO `t_s_country` VALUES ('1225', '三元区', '350403000000', '350400000000');
INSERT INTO `t_s_country` VALUES ('1226', '明溪县', '350421000000', '350400000000');
INSERT INTO `t_s_country` VALUES ('1227', '清流县', '350423000000', '350400000000');
INSERT INTO `t_s_country` VALUES ('1228', '宁化县', '350424000000', '350400000000');
INSERT INTO `t_s_country` VALUES ('1229', '大田县', '350425000000', '350400000000');
INSERT INTO `t_s_country` VALUES ('1230', '尤溪县', '350426000000', '350400000000');
INSERT INTO `t_s_country` VALUES ('1231', '沙县', '350427000000', '350400000000');
INSERT INTO `t_s_country` VALUES ('1232', '将乐县', '350428000000', '350400000000');
INSERT INTO `t_s_country` VALUES ('1233', '泰宁县', '350429000000', '350400000000');
INSERT INTO `t_s_country` VALUES ('1234', '建宁县', '350430000000', '350400000000');
INSERT INTO `t_s_country` VALUES ('1235', '永安市', '350481000000', '350400000000');
INSERT INTO `t_s_country` VALUES ('1236', '市辖区', '350501000000', '350500000000');
INSERT INTO `t_s_country` VALUES ('1237', '鲤城区', '350502000000', '350500000000');
INSERT INTO `t_s_country` VALUES ('1238', '丰泽区', '350503000000', '350500000000');
INSERT INTO `t_s_country` VALUES ('1239', '洛江区', '350504000000', '350500000000');
INSERT INTO `t_s_country` VALUES ('1240', '泉港区', '350505000000', '350500000000');
INSERT INTO `t_s_country` VALUES ('1241', '惠安县', '350521000000', '350500000000');
INSERT INTO `t_s_country` VALUES ('1242', '安溪县', '350524000000', '350500000000');
INSERT INTO `t_s_country` VALUES ('1243', '永春县', '350525000000', '350500000000');
INSERT INTO `t_s_country` VALUES ('1244', '德化县', '350526000000', '350500000000');
INSERT INTO `t_s_country` VALUES ('1245', '金门县', '350527000000', '350500000000');
INSERT INTO `t_s_country` VALUES ('1246', '石狮市', '350581000000', '350500000000');
INSERT INTO `t_s_country` VALUES ('1247', '晋江市', '350582000000', '350500000000');
INSERT INTO `t_s_country` VALUES ('1248', '南安市', '350583000000', '350500000000');
INSERT INTO `t_s_country` VALUES ('1249', '市辖区', '350601000000', '350600000000');
INSERT INTO `t_s_country` VALUES ('1250', '芗城区', '350602000000', '350600000000');
INSERT INTO `t_s_country` VALUES ('1251', '龙文区', '350603000000', '350600000000');
INSERT INTO `t_s_country` VALUES ('1252', '云霄县', '350622000000', '350600000000');
INSERT INTO `t_s_country` VALUES ('1253', '漳浦县', '350623000000', '350600000000');
INSERT INTO `t_s_country` VALUES ('1254', '诏安县', '350624000000', '350600000000');
INSERT INTO `t_s_country` VALUES ('1255', '长泰县', '350625000000', '350600000000');
INSERT INTO `t_s_country` VALUES ('1256', '东山县', '350626000000', '350600000000');
INSERT INTO `t_s_country` VALUES ('1257', '南靖县', '350627000000', '350600000000');
INSERT INTO `t_s_country` VALUES ('1258', '平和县', '350628000000', '350600000000');
INSERT INTO `t_s_country` VALUES ('1259', '华安县', '350629000000', '350600000000');
INSERT INTO `t_s_country` VALUES ('1260', '龙海市', '350681000000', '350600000000');
INSERT INTO `t_s_country` VALUES ('1261', '市辖区', '350701000000', '350700000000');
INSERT INTO `t_s_country` VALUES ('1262', '延平区', '350702000000', '350700000000');
INSERT INTO `t_s_country` VALUES ('1263', '建阳区', '350703000000', '350700000000');
INSERT INTO `t_s_country` VALUES ('1264', '顺昌县', '350721000000', '350700000000');
INSERT INTO `t_s_country` VALUES ('1265', '浦城县', '350722000000', '350700000000');
INSERT INTO `t_s_country` VALUES ('1266', '光泽县', '350723000000', '350700000000');
INSERT INTO `t_s_country` VALUES ('1267', '松溪县', '350724000000', '350700000000');
INSERT INTO `t_s_country` VALUES ('1268', '政和县', '350725000000', '350700000000');
INSERT INTO `t_s_country` VALUES ('1269', '邵武市', '350781000000', '350700000000');
INSERT INTO `t_s_country` VALUES ('1270', '武夷山市', '350782000000', '350700000000');
INSERT INTO `t_s_country` VALUES ('1271', '建瓯市', '350783000000', '350700000000');
INSERT INTO `t_s_country` VALUES ('1272', '市辖区', '350801000000', '350800000000');
INSERT INTO `t_s_country` VALUES ('1273', '新罗区', '350802000000', '350800000000');
INSERT INTO `t_s_country` VALUES ('1274', '永定区', '350803000000', '350800000000');
INSERT INTO `t_s_country` VALUES ('1275', '长汀县', '350821000000', '350800000000');
INSERT INTO `t_s_country` VALUES ('1276', '上杭县', '350823000000', '350800000000');
INSERT INTO `t_s_country` VALUES ('1277', '武平县', '350824000000', '350800000000');
INSERT INTO `t_s_country` VALUES ('1278', '连城县', '350825000000', '350800000000');
INSERT INTO `t_s_country` VALUES ('1279', '漳平市', '350881000000', '350800000000');
INSERT INTO `t_s_country` VALUES ('1280', '市辖区', '350901000000', '350900000000');
INSERT INTO `t_s_country` VALUES ('1281', '蕉城区', '350902000000', '350900000000');
INSERT INTO `t_s_country` VALUES ('1282', '霞浦县', '350921000000', '350900000000');
INSERT INTO `t_s_country` VALUES ('1283', '古田县', '350922000000', '350900000000');
INSERT INTO `t_s_country` VALUES ('1284', '屏南县', '350923000000', '350900000000');
INSERT INTO `t_s_country` VALUES ('1285', '寿宁县', '350924000000', '350900000000');
INSERT INTO `t_s_country` VALUES ('1286', '周宁县', '350925000000', '350900000000');
INSERT INTO `t_s_country` VALUES ('1287', '柘荣县', '350926000000', '350900000000');
INSERT INTO `t_s_country` VALUES ('1288', '福安市', '350981000000', '350900000000');
INSERT INTO `t_s_country` VALUES ('1289', '福鼎市', '350982000000', '350900000000');
INSERT INTO `t_s_country` VALUES ('1290', '市辖区', '360101000000', '360100000000');
INSERT INTO `t_s_country` VALUES ('1291', '东湖区', '360102000000', '360100000000');
INSERT INTO `t_s_country` VALUES ('1292', '西湖区', '360103000000', '360100000000');
INSERT INTO `t_s_country` VALUES ('1293', '青云谱区', '360104000000', '360100000000');
INSERT INTO `t_s_country` VALUES ('1294', '湾里区', '360105000000', '360100000000');
INSERT INTO `t_s_country` VALUES ('1295', '青山湖区', '360111000000', '360100000000');
INSERT INTO `t_s_country` VALUES ('1296', '新建区', '360112000000', '360100000000');
INSERT INTO `t_s_country` VALUES ('1297', '南昌县', '360121000000', '360100000000');
INSERT INTO `t_s_country` VALUES ('1298', '安义县', '360123000000', '360100000000');
INSERT INTO `t_s_country` VALUES ('1299', '进贤县', '360124000000', '360100000000');
INSERT INTO `t_s_country` VALUES ('1300', '市辖区', '360201000000', '360200000000');
INSERT INTO `t_s_country` VALUES ('1301', '昌江区', '360202000000', '360200000000');
INSERT INTO `t_s_country` VALUES ('1302', '珠山区', '360203000000', '360200000000');
INSERT INTO `t_s_country` VALUES ('1303', '浮梁县', '360222000000', '360200000000');
INSERT INTO `t_s_country` VALUES ('1304', '乐平市', '360281000000', '360200000000');
INSERT INTO `t_s_country` VALUES ('1305', '市辖区', '360301000000', '360300000000');
INSERT INTO `t_s_country` VALUES ('1306', '安源区', '360302000000', '360300000000');
INSERT INTO `t_s_country` VALUES ('1307', '湘东区', '360313000000', '360300000000');
INSERT INTO `t_s_country` VALUES ('1308', '莲花县', '360321000000', '360300000000');
INSERT INTO `t_s_country` VALUES ('1309', '上栗县', '360322000000', '360300000000');
INSERT INTO `t_s_country` VALUES ('1310', '芦溪县', '360323000000', '360300000000');
INSERT INTO `t_s_country` VALUES ('1311', '市辖区', '360401000000', '360400000000');
INSERT INTO `t_s_country` VALUES ('1312', '濂溪区', '360402000000', '360400000000');
INSERT INTO `t_s_country` VALUES ('1313', '浔阳区', '360403000000', '360400000000');
INSERT INTO `t_s_country` VALUES ('1314', '柴桑区', '360404000000', '360400000000');
INSERT INTO `t_s_country` VALUES ('1315', '武宁县', '360423000000', '360400000000');
INSERT INTO `t_s_country` VALUES ('1316', '修水县', '360424000000', '360400000000');
INSERT INTO `t_s_country` VALUES ('1317', '永修县', '360425000000', '360400000000');
INSERT INTO `t_s_country` VALUES ('1318', '德安县', '360426000000', '360400000000');
INSERT INTO `t_s_country` VALUES ('1319', '都昌县', '360428000000', '360400000000');
INSERT INTO `t_s_country` VALUES ('1320', '湖口县', '360429000000', '360400000000');
INSERT INTO `t_s_country` VALUES ('1321', '彭泽县', '360430000000', '360400000000');
INSERT INTO `t_s_country` VALUES ('1322', '瑞昌市', '360481000000', '360400000000');
INSERT INTO `t_s_country` VALUES ('1323', '共青城市', '360482000000', '360400000000');
INSERT INTO `t_s_country` VALUES ('1324', '庐山市', '360483000000', '360400000000');
INSERT INTO `t_s_country` VALUES ('1325', '市辖区', '360501000000', '360500000000');
INSERT INTO `t_s_country` VALUES ('1326', '渝水区', '360502000000', '360500000000');
INSERT INTO `t_s_country` VALUES ('1327', '分宜县', '360521000000', '360500000000');
INSERT INTO `t_s_country` VALUES ('1328', '市辖区', '360601000000', '360600000000');
INSERT INTO `t_s_country` VALUES ('1329', '月湖区', '360602000000', '360600000000');
INSERT INTO `t_s_country` VALUES ('1330', '余江区', '360603000000', '360600000000');
INSERT INTO `t_s_country` VALUES ('1331', '贵溪市', '360681000000', '360600000000');
INSERT INTO `t_s_country` VALUES ('1332', '市辖区', '360701000000', '360700000000');
INSERT INTO `t_s_country` VALUES ('1333', '章贡区', '360702000000', '360700000000');
INSERT INTO `t_s_country` VALUES ('1334', '南康区', '360703000000', '360700000000');
INSERT INTO `t_s_country` VALUES ('1335', '赣县区', '360704000000', '360700000000');
INSERT INTO `t_s_country` VALUES ('1336', '信丰县', '360722000000', '360700000000');
INSERT INTO `t_s_country` VALUES ('1337', '大余县', '360723000000', '360700000000');
INSERT INTO `t_s_country` VALUES ('1338', '上犹县', '360724000000', '360700000000');
INSERT INTO `t_s_country` VALUES ('1339', '崇义县', '360725000000', '360700000000');
INSERT INTO `t_s_country` VALUES ('1340', '安远县', '360726000000', '360700000000');
INSERT INTO `t_s_country` VALUES ('1341', '龙南县', '360727000000', '360700000000');
INSERT INTO `t_s_country` VALUES ('1342', '定南县', '360728000000', '360700000000');
INSERT INTO `t_s_country` VALUES ('1343', '全南县', '360729000000', '360700000000');
INSERT INTO `t_s_country` VALUES ('1344', '宁都县', '360730000000', '360700000000');
INSERT INTO `t_s_country` VALUES ('1345', '于都县', '360731000000', '360700000000');
INSERT INTO `t_s_country` VALUES ('1346', '兴国县', '360732000000', '360700000000');
INSERT INTO `t_s_country` VALUES ('1347', '会昌县', '360733000000', '360700000000');
INSERT INTO `t_s_country` VALUES ('1348', '寻乌县', '360734000000', '360700000000');
INSERT INTO `t_s_country` VALUES ('1349', '石城县', '360735000000', '360700000000');
INSERT INTO `t_s_country` VALUES ('1350', '瑞金市', '360781000000', '360700000000');
INSERT INTO `t_s_country` VALUES ('1351', '市辖区', '360801000000', '360800000000');
INSERT INTO `t_s_country` VALUES ('1352', '吉州区', '360802000000', '360800000000');
INSERT INTO `t_s_country` VALUES ('1353', '青原区', '360803000000', '360800000000');
INSERT INTO `t_s_country` VALUES ('1354', '吉安县', '360821000000', '360800000000');
INSERT INTO `t_s_country` VALUES ('1355', '吉水县', '360822000000', '360800000000');
INSERT INTO `t_s_country` VALUES ('1356', '峡江县', '360823000000', '360800000000');
INSERT INTO `t_s_country` VALUES ('1357', '新干县', '360824000000', '360800000000');
INSERT INTO `t_s_country` VALUES ('1358', '永丰县', '360825000000', '360800000000');
INSERT INTO `t_s_country` VALUES ('1359', '泰和县', '360826000000', '360800000000');
INSERT INTO `t_s_country` VALUES ('1360', '遂川县', '360827000000', '360800000000');
INSERT INTO `t_s_country` VALUES ('1361', '万安县', '360828000000', '360800000000');
INSERT INTO `t_s_country` VALUES ('1362', '安福县', '360829000000', '360800000000');
INSERT INTO `t_s_country` VALUES ('1363', '永新县', '360830000000', '360800000000');
INSERT INTO `t_s_country` VALUES ('1364', '井冈山市', '360881000000', '360800000000');
INSERT INTO `t_s_country` VALUES ('1365', '市辖区', '360901000000', '360900000000');
INSERT INTO `t_s_country` VALUES ('1366', '袁州区', '360902000000', '360900000000');
INSERT INTO `t_s_country` VALUES ('1367', '奉新县', '360921000000', '360900000000');
INSERT INTO `t_s_country` VALUES ('1368', '万载县', '360922000000', '360900000000');
INSERT INTO `t_s_country` VALUES ('1369', '上高县', '360923000000', '360900000000');
INSERT INTO `t_s_country` VALUES ('1370', '宜丰县', '360924000000', '360900000000');
INSERT INTO `t_s_country` VALUES ('1371', '靖安县', '360925000000', '360900000000');
INSERT INTO `t_s_country` VALUES ('1372', '铜鼓县', '360926000000', '360900000000');
INSERT INTO `t_s_country` VALUES ('1373', '丰城市', '360981000000', '360900000000');
INSERT INTO `t_s_country` VALUES ('1374', '樟树市', '360982000000', '360900000000');
INSERT INTO `t_s_country` VALUES ('1375', '高安市', '360983000000', '360900000000');
INSERT INTO `t_s_country` VALUES ('1376', '市辖区', '361001000000', '361000000000');
INSERT INTO `t_s_country` VALUES ('1377', '临川区', '361002000000', '361000000000');
INSERT INTO `t_s_country` VALUES ('1378', '东乡区', '361003000000', '361000000000');
INSERT INTO `t_s_country` VALUES ('1379', '南城县', '361021000000', '361000000000');
INSERT INTO `t_s_country` VALUES ('1380', '黎川县', '361022000000', '361000000000');
INSERT INTO `t_s_country` VALUES ('1381', '南丰县', '361023000000', '361000000000');
INSERT INTO `t_s_country` VALUES ('1382', '崇仁县', '361024000000', '361000000000');
INSERT INTO `t_s_country` VALUES ('1383', '乐安县', '361025000000', '361000000000');
INSERT INTO `t_s_country` VALUES ('1384', '宜黄县', '361026000000', '361000000000');
INSERT INTO `t_s_country` VALUES ('1385', '金溪县', '361027000000', '361000000000');
INSERT INTO `t_s_country` VALUES ('1386', '资溪县', '361028000000', '361000000000');
INSERT INTO `t_s_country` VALUES ('1387', '广昌县', '361030000000', '361000000000');
INSERT INTO `t_s_country` VALUES ('1388', '市辖区', '361101000000', '361100000000');
INSERT INTO `t_s_country` VALUES ('1389', '信州区', '361102000000', '361100000000');
INSERT INTO `t_s_country` VALUES ('1390', '广丰区', '361103000000', '361100000000');
INSERT INTO `t_s_country` VALUES ('1391', '上饶县', '361121000000', '361100000000');
INSERT INTO `t_s_country` VALUES ('1392', '玉山县', '361123000000', '361100000000');
INSERT INTO `t_s_country` VALUES ('1393', '铅山县', '361124000000', '361100000000');
INSERT INTO `t_s_country` VALUES ('1394', '横峰县', '361125000000', '361100000000');
INSERT INTO `t_s_country` VALUES ('1395', '弋阳县', '361126000000', '361100000000');
INSERT INTO `t_s_country` VALUES ('1396', '余干县', '361127000000', '361100000000');
INSERT INTO `t_s_country` VALUES ('1397', '鄱阳县', '361128000000', '361100000000');
INSERT INTO `t_s_country` VALUES ('1398', '万年县', '361129000000', '361100000000');
INSERT INTO `t_s_country` VALUES ('1399', '婺源县', '361130000000', '361100000000');
INSERT INTO `t_s_country` VALUES ('1400', '德兴市', '361181000000', '361100000000');
INSERT INTO `t_s_country` VALUES ('1401', '市辖区', '370101000000', '370100000000');
INSERT INTO `t_s_country` VALUES ('1402', '历下区', '370102000000', '370100000000');
INSERT INTO `t_s_country` VALUES ('1403', '市中区', '370103000000', '370100000000');
INSERT INTO `t_s_country` VALUES ('1404', '槐荫区', '370104000000', '370100000000');
INSERT INTO `t_s_country` VALUES ('1405', '天桥区', '370105000000', '370100000000');
INSERT INTO `t_s_country` VALUES ('1406', '历城区', '370112000000', '370100000000');
INSERT INTO `t_s_country` VALUES ('1407', '长清区', '370113000000', '370100000000');
INSERT INTO `t_s_country` VALUES ('1408', '章丘区', '370114000000', '370100000000');
INSERT INTO `t_s_country` VALUES ('1409', '济阳区', '370115000000', '370100000000');
INSERT INTO `t_s_country` VALUES ('1410', '平阴县', '370124000000', '370100000000');
INSERT INTO `t_s_country` VALUES ('1411', '商河县', '370126000000', '370100000000');
INSERT INTO `t_s_country` VALUES ('1412', '济南高新技术产业开发区', '370171000000', '370100000000');
INSERT INTO `t_s_country` VALUES ('1413', '市辖区', '370201000000', '370200000000');
INSERT INTO `t_s_country` VALUES ('1414', '市南区', '370202000000', '370200000000');
INSERT INTO `t_s_country` VALUES ('1415', '市北区', '370203000000', '370200000000');
INSERT INTO `t_s_country` VALUES ('1416', '黄岛区', '370211000000', '370200000000');
INSERT INTO `t_s_country` VALUES ('1417', '崂山区', '370212000000', '370200000000');
INSERT INTO `t_s_country` VALUES ('1418', '李沧区', '370213000000', '370200000000');
INSERT INTO `t_s_country` VALUES ('1419', '城阳区', '370214000000', '370200000000');
INSERT INTO `t_s_country` VALUES ('1420', '即墨区', '370215000000', '370200000000');
INSERT INTO `t_s_country` VALUES ('1421', '青岛高新技术产业开发区', '370271000000', '370200000000');
INSERT INTO `t_s_country` VALUES ('1422', '胶州市', '370281000000', '370200000000');
INSERT INTO `t_s_country` VALUES ('1423', '平度市', '370283000000', '370200000000');
INSERT INTO `t_s_country` VALUES ('1424', '莱西市', '370285000000', '370200000000');
INSERT INTO `t_s_country` VALUES ('1425', '市辖区', '370301000000', '370300000000');
INSERT INTO `t_s_country` VALUES ('1426', '淄川区', '370302000000', '370300000000');
INSERT INTO `t_s_country` VALUES ('1427', '张店区', '370303000000', '370300000000');
INSERT INTO `t_s_country` VALUES ('1428', '博山区', '370304000000', '370300000000');
INSERT INTO `t_s_country` VALUES ('1429', '临淄区', '370305000000', '370300000000');
INSERT INTO `t_s_country` VALUES ('1430', '周村区', '370306000000', '370300000000');
INSERT INTO `t_s_country` VALUES ('1431', '桓台县', '370321000000', '370300000000');
INSERT INTO `t_s_country` VALUES ('1432', '高青县', '370322000000', '370300000000');
INSERT INTO `t_s_country` VALUES ('1433', '沂源县', '370323000000', '370300000000');
INSERT INTO `t_s_country` VALUES ('1434', '市辖区', '370401000000', '370400000000');
INSERT INTO `t_s_country` VALUES ('1435', '市中区', '370402000000', '370400000000');
INSERT INTO `t_s_country` VALUES ('1436', '薛城区', '370403000000', '370400000000');
INSERT INTO `t_s_country` VALUES ('1437', '峄城区', '370404000000', '370400000000');
INSERT INTO `t_s_country` VALUES ('1438', '台儿庄区', '370405000000', '370400000000');
INSERT INTO `t_s_country` VALUES ('1439', '山亭区', '370406000000', '370400000000');
INSERT INTO `t_s_country` VALUES ('1440', '滕州市', '370481000000', '370400000000');
INSERT INTO `t_s_country` VALUES ('1441', '市辖区', '370501000000', '370500000000');
INSERT INTO `t_s_country` VALUES ('1442', '东营区', '370502000000', '370500000000');
INSERT INTO `t_s_country` VALUES ('1443', '河口区', '370503000000', '370500000000');
INSERT INTO `t_s_country` VALUES ('1444', '垦利区', '370505000000', '370500000000');
INSERT INTO `t_s_country` VALUES ('1445', '利津县', '370522000000', '370500000000');
INSERT INTO `t_s_country` VALUES ('1446', '广饶县', '370523000000', '370500000000');
INSERT INTO `t_s_country` VALUES ('1447', '东营经济技术开发区', '370571000000', '370500000000');
INSERT INTO `t_s_country` VALUES ('1448', '东营港经济开发区', '370572000000', '370500000000');
INSERT INTO `t_s_country` VALUES ('1449', '市辖区', '370601000000', '370600000000');
INSERT INTO `t_s_country` VALUES ('1450', '芝罘区', '370602000000', '370600000000');
INSERT INTO `t_s_country` VALUES ('1451', '福山区', '370611000000', '370600000000');
INSERT INTO `t_s_country` VALUES ('1452', '牟平区', '370612000000', '370600000000');
INSERT INTO `t_s_country` VALUES ('1453', '莱山区', '370613000000', '370600000000');
INSERT INTO `t_s_country` VALUES ('1454', '长岛县', '370634000000', '370600000000');
INSERT INTO `t_s_country` VALUES ('1455', '烟台高新技术产业开发区', '370671000000', '370600000000');
INSERT INTO `t_s_country` VALUES ('1456', '烟台经济技术开发区', '370672000000', '370600000000');
INSERT INTO `t_s_country` VALUES ('1457', '龙口市', '370681000000', '370600000000');
INSERT INTO `t_s_country` VALUES ('1458', '莱阳市', '370682000000', '370600000000');
INSERT INTO `t_s_country` VALUES ('1459', '莱州市', '370683000000', '370600000000');
INSERT INTO `t_s_country` VALUES ('1460', '蓬莱市', '370684000000', '370600000000');
INSERT INTO `t_s_country` VALUES ('1461', '招远市', '370685000000', '370600000000');
INSERT INTO `t_s_country` VALUES ('1462', '栖霞市', '370686000000', '370600000000');
INSERT INTO `t_s_country` VALUES ('1463', '海阳市', '370687000000', '370600000000');
INSERT INTO `t_s_country` VALUES ('1464', '市辖区', '370701000000', '370700000000');
INSERT INTO `t_s_country` VALUES ('1465', '潍城区', '370702000000', '370700000000');
INSERT INTO `t_s_country` VALUES ('1466', '寒亭区', '370703000000', '370700000000');
INSERT INTO `t_s_country` VALUES ('1467', '坊子区', '370704000000', '370700000000');
INSERT INTO `t_s_country` VALUES ('1468', '奎文区', '370705000000', '370700000000');
INSERT INTO `t_s_country` VALUES ('1469', '临朐县', '370724000000', '370700000000');
INSERT INTO `t_s_country` VALUES ('1470', '昌乐县', '370725000000', '370700000000');
INSERT INTO `t_s_country` VALUES ('1471', '潍坊滨海经济技术开发区', '370772000000', '370700000000');
INSERT INTO `t_s_country` VALUES ('1472', '青州市', '370781000000', '370700000000');
INSERT INTO `t_s_country` VALUES ('1473', '诸城市', '370782000000', '370700000000');
INSERT INTO `t_s_country` VALUES ('1474', '寿光市', '370783000000', '370700000000');
INSERT INTO `t_s_country` VALUES ('1475', '安丘市', '370784000000', '370700000000');
INSERT INTO `t_s_country` VALUES ('1476', '高密市', '370785000000', '370700000000');
INSERT INTO `t_s_country` VALUES ('1477', '昌邑市', '370786000000', '370700000000');
INSERT INTO `t_s_country` VALUES ('1478', '市辖区', '370801000000', '370800000000');
INSERT INTO `t_s_country` VALUES ('1479', '任城区', '370811000000', '370800000000');
INSERT INTO `t_s_country` VALUES ('1480', '兖州区', '370812000000', '370800000000');
INSERT INTO `t_s_country` VALUES ('1481', '微山县', '370826000000', '370800000000');
INSERT INTO `t_s_country` VALUES ('1482', '鱼台县', '370827000000', '370800000000');
INSERT INTO `t_s_country` VALUES ('1483', '金乡县', '370828000000', '370800000000');
INSERT INTO `t_s_country` VALUES ('1484', '嘉祥县', '370829000000', '370800000000');
INSERT INTO `t_s_country` VALUES ('1485', '汶上县', '370830000000', '370800000000');
INSERT INTO `t_s_country` VALUES ('1486', '泗水县', '370831000000', '370800000000');
INSERT INTO `t_s_country` VALUES ('1487', '梁山县', '370832000000', '370800000000');
INSERT INTO `t_s_country` VALUES ('1488', '济宁高新技术产业开发区', '370871000000', '370800000000');
INSERT INTO `t_s_country` VALUES ('1489', '曲阜市', '370881000000', '370800000000');
INSERT INTO `t_s_country` VALUES ('1490', '邹城市', '370883000000', '370800000000');
INSERT INTO `t_s_country` VALUES ('1491', '市辖区', '370901000000', '370900000000');
INSERT INTO `t_s_country` VALUES ('1492', '泰山区', '370902000000', '370900000000');
INSERT INTO `t_s_country` VALUES ('1493', '岱岳区', '370911000000', '370900000000');
INSERT INTO `t_s_country` VALUES ('1494', '宁阳县', '370921000000', '370900000000');
INSERT INTO `t_s_country` VALUES ('1495', '东平县', '370923000000', '370900000000');
INSERT INTO `t_s_country` VALUES ('1496', '新泰市', '370982000000', '370900000000');
INSERT INTO `t_s_country` VALUES ('1497', '肥城市', '370983000000', '370900000000');
INSERT INTO `t_s_country` VALUES ('1498', '市辖区', '371001000000', '371000000000');
INSERT INTO `t_s_country` VALUES ('1499', '环翠区', '371002000000', '371000000000');
INSERT INTO `t_s_country` VALUES ('1500', '文登区', '371003000000', '371000000000');
INSERT INTO `t_s_country` VALUES ('1501', '威海火炬高技术产业开发区', '371071000000', '371000000000');
INSERT INTO `t_s_country` VALUES ('1502', '威海经济技术开发区', '371072000000', '371000000000');
INSERT INTO `t_s_country` VALUES ('1503', '威海临港经济技术开发区', '371073000000', '371000000000');
INSERT INTO `t_s_country` VALUES ('1504', '荣成市', '371082000000', '371000000000');
INSERT INTO `t_s_country` VALUES ('1505', '乳山市', '371083000000', '371000000000');
INSERT INTO `t_s_country` VALUES ('1506', '市辖区', '371101000000', '371100000000');
INSERT INTO `t_s_country` VALUES ('1507', '东港区', '371102000000', '371100000000');
INSERT INTO `t_s_country` VALUES ('1508', '岚山区', '371103000000', '371100000000');
INSERT INTO `t_s_country` VALUES ('1509', '五莲县', '371121000000', '371100000000');
INSERT INTO `t_s_country` VALUES ('1510', '莒县', '371122000000', '371100000000');
INSERT INTO `t_s_country` VALUES ('1511', '日照经济技术开发区', '371171000000', '371100000000');
INSERT INTO `t_s_country` VALUES ('1512', '市辖区', '371201000000', '371200000000');
INSERT INTO `t_s_country` VALUES ('1513', '莱城区', '371202000000', '371200000000');
INSERT INTO `t_s_country` VALUES ('1514', '钢城区', '371203000000', '371200000000');
INSERT INTO `t_s_country` VALUES ('1515', '市辖区', '371301000000', '371300000000');
INSERT INTO `t_s_country` VALUES ('1516', '兰山区', '371302000000', '371300000000');
INSERT INTO `t_s_country` VALUES ('1517', '罗庄区', '371311000000', '371300000000');
INSERT INTO `t_s_country` VALUES ('1518', '河东区', '371312000000', '371300000000');
INSERT INTO `t_s_country` VALUES ('1519', '沂南县', '371321000000', '371300000000');
INSERT INTO `t_s_country` VALUES ('1520', '郯城县', '371322000000', '371300000000');
INSERT INTO `t_s_country` VALUES ('1521', '沂水县', '371323000000', '371300000000');
INSERT INTO `t_s_country` VALUES ('1522', '兰陵县', '371324000000', '371300000000');
INSERT INTO `t_s_country` VALUES ('1523', '费县', '371325000000', '371300000000');
INSERT INTO `t_s_country` VALUES ('1524', '平邑县', '371326000000', '371300000000');
INSERT INTO `t_s_country` VALUES ('1525', '莒南县', '371327000000', '371300000000');
INSERT INTO `t_s_country` VALUES ('1526', '蒙阴县', '371328000000', '371300000000');
INSERT INTO `t_s_country` VALUES ('1527', '临沭县', '371329000000', '371300000000');
INSERT INTO `t_s_country` VALUES ('1528', '临沂高新技术产业开发区', '371371000000', '371300000000');
INSERT INTO `t_s_country` VALUES ('1529', '临沂经济技术开发区', '371372000000', '371300000000');
INSERT INTO `t_s_country` VALUES ('1530', '临沂临港经济开发区', '371373000000', '371300000000');
INSERT INTO `t_s_country` VALUES ('1531', '市辖区', '371401000000', '371400000000');
INSERT INTO `t_s_country` VALUES ('1532', '德城区', '371402000000', '371400000000');
INSERT INTO `t_s_country` VALUES ('1533', '陵城区', '371403000000', '371400000000');
INSERT INTO `t_s_country` VALUES ('1534', '宁津县', '371422000000', '371400000000');
INSERT INTO `t_s_country` VALUES ('1535', '庆云县', '371423000000', '371400000000');
INSERT INTO `t_s_country` VALUES ('1536', '临邑县', '371424000000', '371400000000');
INSERT INTO `t_s_country` VALUES ('1537', '齐河县', '371425000000', '371400000000');
INSERT INTO `t_s_country` VALUES ('1538', '平原县', '371426000000', '371400000000');
INSERT INTO `t_s_country` VALUES ('1539', '夏津县', '371427000000', '371400000000');
INSERT INTO `t_s_country` VALUES ('1540', '武城县', '371428000000', '371400000000');
INSERT INTO `t_s_country` VALUES ('1541', '德州经济技术开发区', '371471000000', '371400000000');
INSERT INTO `t_s_country` VALUES ('1542', '德州运河经济开发区', '371472000000', '371400000000');
INSERT INTO `t_s_country` VALUES ('1543', '乐陵市', '371481000000', '371400000000');
INSERT INTO `t_s_country` VALUES ('1544', '禹城市', '371482000000', '371400000000');
INSERT INTO `t_s_country` VALUES ('1545', '市辖区', '371501000000', '371500000000');
INSERT INTO `t_s_country` VALUES ('1546', '东昌府区', '371502000000', '371500000000');
INSERT INTO `t_s_country` VALUES ('1547', '阳谷县', '371521000000', '371500000000');
INSERT INTO `t_s_country` VALUES ('1548', '莘县', '371522000000', '371500000000');
INSERT INTO `t_s_country` VALUES ('1549', '茌平县', '371523000000', '371500000000');
INSERT INTO `t_s_country` VALUES ('1550', '东阿县', '371524000000', '371500000000');
INSERT INTO `t_s_country` VALUES ('1551', '冠县', '371525000000', '371500000000');
INSERT INTO `t_s_country` VALUES ('1552', '高唐县', '371526000000', '371500000000');
INSERT INTO `t_s_country` VALUES ('1553', '临清市', '371581000000', '371500000000');
INSERT INTO `t_s_country` VALUES ('1554', '市辖区', '371601000000', '371600000000');
INSERT INTO `t_s_country` VALUES ('1555', '滨城区', '371602000000', '371600000000');
INSERT INTO `t_s_country` VALUES ('1556', '沾化区', '371603000000', '371600000000');
INSERT INTO `t_s_country` VALUES ('1557', '惠民县', '371621000000', '371600000000');
INSERT INTO `t_s_country` VALUES ('1558', '阳信县', '371622000000', '371600000000');
INSERT INTO `t_s_country` VALUES ('1559', '无棣县', '371623000000', '371600000000');
INSERT INTO `t_s_country` VALUES ('1560', '博兴县', '371625000000', '371600000000');
INSERT INTO `t_s_country` VALUES ('1561', '邹平市', '371681000000', '371600000000');
INSERT INTO `t_s_country` VALUES ('1562', '市辖区', '371701000000', '371700000000');
INSERT INTO `t_s_country` VALUES ('1563', '牡丹区', '371702000000', '371700000000');
INSERT INTO `t_s_country` VALUES ('1564', '定陶区', '371703000000', '371700000000');
INSERT INTO `t_s_country` VALUES ('1565', '曹县', '371721000000', '371700000000');
INSERT INTO `t_s_country` VALUES ('1566', '单县', '371722000000', '371700000000');
INSERT INTO `t_s_country` VALUES ('1567', '成武县', '371723000000', '371700000000');
INSERT INTO `t_s_country` VALUES ('1568', '巨野县', '371724000000', '371700000000');
INSERT INTO `t_s_country` VALUES ('1569', '郓城县', '371725000000', '371700000000');
INSERT INTO `t_s_country` VALUES ('1570', '鄄城县', '371726000000', '371700000000');
INSERT INTO `t_s_country` VALUES ('1571', '东明县', '371728000000', '371700000000');
INSERT INTO `t_s_country` VALUES ('1572', '菏泽经济技术开发区', '371771000000', '371700000000');
INSERT INTO `t_s_country` VALUES ('1573', '菏泽高新技术开发区', '371772000000', '371700000000');
INSERT INTO `t_s_country` VALUES ('1574', '市辖区', '410101000000', '410100000000');
INSERT INTO `t_s_country` VALUES ('1575', '中原区', '410102000000', '410100000000');
INSERT INTO `t_s_country` VALUES ('1576', '二七区', '410103000000', '410100000000');
INSERT INTO `t_s_country` VALUES ('1577', '管城回族区', '410104000000', '410100000000');
INSERT INTO `t_s_country` VALUES ('1578', '金水区', '410105000000', '410100000000');
INSERT INTO `t_s_country` VALUES ('1579', '上街区', '410106000000', '410100000000');
INSERT INTO `t_s_country` VALUES ('1580', '惠济区', '410108000000', '410100000000');
INSERT INTO `t_s_country` VALUES ('1581', '中牟县', '410122000000', '410100000000');
INSERT INTO `t_s_country` VALUES ('1582', '郑州经济技术开发区', '410171000000', '410100000000');
INSERT INTO `t_s_country` VALUES ('1583', '郑州高新技术产业开发区', '410172000000', '410100000000');
INSERT INTO `t_s_country` VALUES ('1584', '郑州航空港经济综合实验区', '410173000000', '410100000000');
INSERT INTO `t_s_country` VALUES ('1585', '巩义市', '410181000000', '410100000000');
INSERT INTO `t_s_country` VALUES ('1586', '荥阳市', '410182000000', '410100000000');
INSERT INTO `t_s_country` VALUES ('1587', '新密市', '410183000000', '410100000000');
INSERT INTO `t_s_country` VALUES ('1588', '新郑市', '410184000000', '410100000000');
INSERT INTO `t_s_country` VALUES ('1589', '登封市', '410185000000', '410100000000');
INSERT INTO `t_s_country` VALUES ('1590', '市辖区', '410201000000', '410200000000');
INSERT INTO `t_s_country` VALUES ('1591', '龙亭区', '410202000000', '410200000000');
INSERT INTO `t_s_country` VALUES ('1592', '顺河回族区', '410203000000', '410200000000');
INSERT INTO `t_s_country` VALUES ('1593', '鼓楼区', '410204000000', '410200000000');
INSERT INTO `t_s_country` VALUES ('1594', '禹王台区', '410205000000', '410200000000');
INSERT INTO `t_s_country` VALUES ('1595', '祥符区', '410212000000', '410200000000');
INSERT INTO `t_s_country` VALUES ('1596', '杞县', '410221000000', '410200000000');
INSERT INTO `t_s_country` VALUES ('1597', '通许县', '410222000000', '410200000000');
INSERT INTO `t_s_country` VALUES ('1598', '尉氏县', '410223000000', '410200000000');
INSERT INTO `t_s_country` VALUES ('1599', '兰考县', '410225000000', '410200000000');
INSERT INTO `t_s_country` VALUES ('1600', '市辖区', '410301000000', '410300000000');
INSERT INTO `t_s_country` VALUES ('1601', '老城区', '410302000000', '410300000000');
INSERT INTO `t_s_country` VALUES ('1602', '西工区', '410303000000', '410300000000');
INSERT INTO `t_s_country` VALUES ('1603', '瀍河回族区', '410304000000', '410300000000');
INSERT INTO `t_s_country` VALUES ('1604', '涧西区', '410305000000', '410300000000');
INSERT INTO `t_s_country` VALUES ('1605', '吉利区', '410306000000', '410300000000');
INSERT INTO `t_s_country` VALUES ('1606', '洛龙区', '410311000000', '410300000000');
INSERT INTO `t_s_country` VALUES ('1607', '孟津县', '410322000000', '410300000000');
INSERT INTO `t_s_country` VALUES ('1608', '新安县', '410323000000', '410300000000');
INSERT INTO `t_s_country` VALUES ('1609', '栾川县', '410324000000', '410300000000');
INSERT INTO `t_s_country` VALUES ('1610', '嵩县', '410325000000', '410300000000');
INSERT INTO `t_s_country` VALUES ('1611', '汝阳县', '410326000000', '410300000000');
INSERT INTO `t_s_country` VALUES ('1612', '宜阳县', '410327000000', '410300000000');
INSERT INTO `t_s_country` VALUES ('1613', '洛宁县', '410328000000', '410300000000');
INSERT INTO `t_s_country` VALUES ('1614', '伊川县', '410329000000', '410300000000');
INSERT INTO `t_s_country` VALUES ('1615', '洛阳高新技术产业开发区', '410371000000', '410300000000');
INSERT INTO `t_s_country` VALUES ('1616', '偃师市', '410381000000', '410300000000');
INSERT INTO `t_s_country` VALUES ('1617', '市辖区', '410401000000', '410400000000');
INSERT INTO `t_s_country` VALUES ('1618', '新华区', '410402000000', '410400000000');
INSERT INTO `t_s_country` VALUES ('1619', '卫东区', '410403000000', '410400000000');
INSERT INTO `t_s_country` VALUES ('1620', '石龙区', '410404000000', '410400000000');
INSERT INTO `t_s_country` VALUES ('1621', '湛河区', '410411000000', '410400000000');
INSERT INTO `t_s_country` VALUES ('1622', '宝丰县', '410421000000', '410400000000');
INSERT INTO `t_s_country` VALUES ('1623', '叶县', '410422000000', '410400000000');
INSERT INTO `t_s_country` VALUES ('1624', '鲁山县', '410423000000', '410400000000');
INSERT INTO `t_s_country` VALUES ('1625', '郏县', '410425000000', '410400000000');
INSERT INTO `t_s_country` VALUES ('1626', '平顶山高新技术产业开发区', '410471000000', '410400000000');
INSERT INTO `t_s_country` VALUES ('1627', '平顶山市新城区', '410472000000', '410400000000');
INSERT INTO `t_s_country` VALUES ('1628', '舞钢市', '410481000000', '410400000000');
INSERT INTO `t_s_country` VALUES ('1629', '汝州市', '410482000000', '410400000000');
INSERT INTO `t_s_country` VALUES ('1630', '市辖区', '410501000000', '410500000000');
INSERT INTO `t_s_country` VALUES ('1631', '文峰区', '410502000000', '410500000000');
INSERT INTO `t_s_country` VALUES ('1632', '北关区', '410503000000', '410500000000');
INSERT INTO `t_s_country` VALUES ('1633', '殷都区', '410505000000', '410500000000');
INSERT INTO `t_s_country` VALUES ('1634', '龙安区', '410506000000', '410500000000');
INSERT INTO `t_s_country` VALUES ('1635', '安阳县', '410522000000', '410500000000');
INSERT INTO `t_s_country` VALUES ('1636', '汤阴县', '410523000000', '410500000000');
INSERT INTO `t_s_country` VALUES ('1637', '滑县', '410526000000', '410500000000');
INSERT INTO `t_s_country` VALUES ('1638', '内黄县', '410527000000', '410500000000');
INSERT INTO `t_s_country` VALUES ('1639', '安阳高新技术产业开发区', '410571000000', '410500000000');
INSERT INTO `t_s_country` VALUES ('1640', '林州市', '410581000000', '410500000000');
INSERT INTO `t_s_country` VALUES ('1641', '市辖区', '410601000000', '410600000000');
INSERT INTO `t_s_country` VALUES ('1642', '鹤山区', '410602000000', '410600000000');
INSERT INTO `t_s_country` VALUES ('1643', '山城区', '410603000000', '410600000000');
INSERT INTO `t_s_country` VALUES ('1644', '淇滨区', '410611000000', '410600000000');
INSERT INTO `t_s_country` VALUES ('1645', '浚县', '410621000000', '410600000000');
INSERT INTO `t_s_country` VALUES ('1646', '淇县', '410622000000', '410600000000');
INSERT INTO `t_s_country` VALUES ('1647', '鹤壁经济技术开发区', '410671000000', '410600000000');
INSERT INTO `t_s_country` VALUES ('1648', '市辖区', '410701000000', '410700000000');
INSERT INTO `t_s_country` VALUES ('1649', '红旗区', '410702000000', '410700000000');
INSERT INTO `t_s_country` VALUES ('1650', '卫滨区', '410703000000', '410700000000');
INSERT INTO `t_s_country` VALUES ('1651', '凤泉区', '410704000000', '410700000000');
INSERT INTO `t_s_country` VALUES ('1652', '牧野区', '410711000000', '410700000000');
INSERT INTO `t_s_country` VALUES ('1653', '新乡县', '410721000000', '410700000000');
INSERT INTO `t_s_country` VALUES ('1654', '获嘉县', '410724000000', '410700000000');
INSERT INTO `t_s_country` VALUES ('1655', '原阳县', '410725000000', '410700000000');
INSERT INTO `t_s_country` VALUES ('1656', '延津县', '410726000000', '410700000000');
INSERT INTO `t_s_country` VALUES ('1657', '封丘县', '410727000000', '410700000000');
INSERT INTO `t_s_country` VALUES ('1658', '长垣县', '410728000000', '410700000000');
INSERT INTO `t_s_country` VALUES ('1659', '新乡高新技术产业开发区', '410771000000', '410700000000');
INSERT INTO `t_s_country` VALUES ('1660', '新乡经济技术开发区', '410772000000', '410700000000');
INSERT INTO `t_s_country` VALUES ('1661', '新乡市平原城乡一体化示范区', '410773000000', '410700000000');
INSERT INTO `t_s_country` VALUES ('1662', '卫辉市', '410781000000', '410700000000');
INSERT INTO `t_s_country` VALUES ('1663', '辉县市', '410782000000', '410700000000');
INSERT INTO `t_s_country` VALUES ('1664', '市辖区', '410801000000', '410800000000');
INSERT INTO `t_s_country` VALUES ('1665', '解放区', '410802000000', '410800000000');
INSERT INTO `t_s_country` VALUES ('1666', '中站区', '410803000000', '410800000000');
INSERT INTO `t_s_country` VALUES ('1667', '马村区', '410804000000', '410800000000');
INSERT INTO `t_s_country` VALUES ('1668', '山阳区', '410811000000', '410800000000');
INSERT INTO `t_s_country` VALUES ('1669', '修武县', '410821000000', '410800000000');
INSERT INTO `t_s_country` VALUES ('1670', '博爱县', '410822000000', '410800000000');
INSERT INTO `t_s_country` VALUES ('1671', '武陟县', '410823000000', '410800000000');
INSERT INTO `t_s_country` VALUES ('1672', '温县', '410825000000', '410800000000');
INSERT INTO `t_s_country` VALUES ('1673', '焦作城乡一体化示范区', '410871000000', '410800000000');
INSERT INTO `t_s_country` VALUES ('1674', '沁阳市', '410882000000', '410800000000');
INSERT INTO `t_s_country` VALUES ('1675', '孟州市', '410883000000', '410800000000');
INSERT INTO `t_s_country` VALUES ('1676', '市辖区', '410901000000', '410900000000');
INSERT INTO `t_s_country` VALUES ('1677', '华龙区', '410902000000', '410900000000');
INSERT INTO `t_s_country` VALUES ('1678', '清丰县', '410922000000', '410900000000');
INSERT INTO `t_s_country` VALUES ('1679', '南乐县', '410923000000', '410900000000');
INSERT INTO `t_s_country` VALUES ('1680', '范县', '410926000000', '410900000000');
INSERT INTO `t_s_country` VALUES ('1681', '台前县', '410927000000', '410900000000');
INSERT INTO `t_s_country` VALUES ('1682', '濮阳县', '410928000000', '410900000000');
INSERT INTO `t_s_country` VALUES ('1683', '河南濮阳工业园区', '410971000000', '410900000000');
INSERT INTO `t_s_country` VALUES ('1684', '濮阳经济技术开发区', '410972000000', '410900000000');
INSERT INTO `t_s_country` VALUES ('1685', '市辖区', '411001000000', '411000000000');
INSERT INTO `t_s_country` VALUES ('1686', '魏都区', '411002000000', '411000000000');
INSERT INTO `t_s_country` VALUES ('1687', '建安区', '411003000000', '411000000000');
INSERT INTO `t_s_country` VALUES ('1688', '鄢陵县', '411024000000', '411000000000');
INSERT INTO `t_s_country` VALUES ('1689', '襄城县', '411025000000', '411000000000');
INSERT INTO `t_s_country` VALUES ('1690', '许昌经济技术开发区', '411071000000', '411000000000');
INSERT INTO `t_s_country` VALUES ('1691', '禹州市', '411081000000', '411000000000');
INSERT INTO `t_s_country` VALUES ('1692', '长葛市', '411082000000', '411000000000');
INSERT INTO `t_s_country` VALUES ('1693', '市辖区', '411101000000', '411100000000');
INSERT INTO `t_s_country` VALUES ('1694', '源汇区', '411102000000', '411100000000');
INSERT INTO `t_s_country` VALUES ('1695', '郾城区', '411103000000', '411100000000');
INSERT INTO `t_s_country` VALUES ('1696', '召陵区', '411104000000', '411100000000');
INSERT INTO `t_s_country` VALUES ('1697', '舞阳县', '411121000000', '411100000000');
INSERT INTO `t_s_country` VALUES ('1698', '临颍县', '411122000000', '411100000000');
INSERT INTO `t_s_country` VALUES ('1699', '漯河经济技术开发区', '411171000000', '411100000000');
INSERT INTO `t_s_country` VALUES ('1700', '市辖区', '411201000000', '411200000000');
INSERT INTO `t_s_country` VALUES ('1701', '湖滨区', '411202000000', '411200000000');
INSERT INTO `t_s_country` VALUES ('1702', '陕州区', '411203000000', '411200000000');
INSERT INTO `t_s_country` VALUES ('1703', '渑池县', '411221000000', '411200000000');
INSERT INTO `t_s_country` VALUES ('1704', '卢氏县', '411224000000', '411200000000');
INSERT INTO `t_s_country` VALUES ('1705', '河南三门峡经济开发区', '411271000000', '411200000000');
INSERT INTO `t_s_country` VALUES ('1706', '义马市', '411281000000', '411200000000');
INSERT INTO `t_s_country` VALUES ('1707', '灵宝市', '411282000000', '411200000000');
INSERT INTO `t_s_country` VALUES ('1708', '市辖区', '411301000000', '411300000000');
INSERT INTO `t_s_country` VALUES ('1709', '宛城区', '411302000000', '411300000000');
INSERT INTO `t_s_country` VALUES ('1710', '卧龙区', '411303000000', '411300000000');
INSERT INTO `t_s_country` VALUES ('1711', '南召县', '411321000000', '411300000000');
INSERT INTO `t_s_country` VALUES ('1712', '方城县', '411322000000', '411300000000');
INSERT INTO `t_s_country` VALUES ('1713', '西峡县', '411323000000', '411300000000');
INSERT INTO `t_s_country` VALUES ('1714', '镇平县', '411324000000', '411300000000');
INSERT INTO `t_s_country` VALUES ('1715', '内乡县', '411325000000', '411300000000');
INSERT INTO `t_s_country` VALUES ('1716', '淅川县', '411326000000', '411300000000');
INSERT INTO `t_s_country` VALUES ('1717', '社旗县', '411327000000', '411300000000');
INSERT INTO `t_s_country` VALUES ('1718', '唐河县', '411328000000', '411300000000');
INSERT INTO `t_s_country` VALUES ('1719', '新野县', '411329000000', '411300000000');
INSERT INTO `t_s_country` VALUES ('1720', '桐柏县', '411330000000', '411300000000');
INSERT INTO `t_s_country` VALUES ('1721', '南阳高新技术产业开发区', '411371000000', '411300000000');
INSERT INTO `t_s_country` VALUES ('1722', '南阳市城乡一体化示范区', '411372000000', '411300000000');
INSERT INTO `t_s_country` VALUES ('1723', '邓州市', '411381000000', '411300000000');
INSERT INTO `t_s_country` VALUES ('1724', '市辖区', '411401000000', '411400000000');
INSERT INTO `t_s_country` VALUES ('1725', '梁园区', '411402000000', '411400000000');
INSERT INTO `t_s_country` VALUES ('1726', '睢阳区', '411403000000', '411400000000');
INSERT INTO `t_s_country` VALUES ('1727', '民权县', '411421000000', '411400000000');
INSERT INTO `t_s_country` VALUES ('1728', '睢县', '411422000000', '411400000000');
INSERT INTO `t_s_country` VALUES ('1729', '宁陵县', '411423000000', '411400000000');
INSERT INTO `t_s_country` VALUES ('1730', '柘城县', '411424000000', '411400000000');
INSERT INTO `t_s_country` VALUES ('1731', '虞城县', '411425000000', '411400000000');
INSERT INTO `t_s_country` VALUES ('1732', '夏邑县', '411426000000', '411400000000');
INSERT INTO `t_s_country` VALUES ('1733', '豫东综合物流产业聚集区', '411471000000', '411400000000');
INSERT INTO `t_s_country` VALUES ('1734', '河南商丘经济开发区', '411472000000', '411400000000');
INSERT INTO `t_s_country` VALUES ('1735', '永城市', '411481000000', '411400000000');
INSERT INTO `t_s_country` VALUES ('1736', '市辖区', '411501000000', '411500000000');
INSERT INTO `t_s_country` VALUES ('1737', '浉河区', '411502000000', '411500000000');
INSERT INTO `t_s_country` VALUES ('1738', '平桥区', '411503000000', '411500000000');
INSERT INTO `t_s_country` VALUES ('1739', '罗山县', '411521000000', '411500000000');
INSERT INTO `t_s_country` VALUES ('1740', '光山县', '411522000000', '411500000000');
INSERT INTO `t_s_country` VALUES ('1741', '新县', '411523000000', '411500000000');
INSERT INTO `t_s_country` VALUES ('1742', '商城县', '411524000000', '411500000000');
INSERT INTO `t_s_country` VALUES ('1743', '固始县', '411525000000', '411500000000');
INSERT INTO `t_s_country` VALUES ('1744', '潢川县', '411526000000', '411500000000');
INSERT INTO `t_s_country` VALUES ('1745', '淮滨县', '411527000000', '411500000000');
INSERT INTO `t_s_country` VALUES ('1746', '息县', '411528000000', '411500000000');
INSERT INTO `t_s_country` VALUES ('1747', '信阳高新技术产业开发区', '411571000000', '411500000000');
INSERT INTO `t_s_country` VALUES ('1748', '市辖区', '411601000000', '411600000000');
INSERT INTO `t_s_country` VALUES ('1749', '川汇区', '411602000000', '411600000000');
INSERT INTO `t_s_country` VALUES ('1750', '扶沟县', '411621000000', '411600000000');
INSERT INTO `t_s_country` VALUES ('1751', '西华县', '411622000000', '411600000000');
INSERT INTO `t_s_country` VALUES ('1752', '商水县', '411623000000', '411600000000');
INSERT INTO `t_s_country` VALUES ('1753', '沈丘县', '411624000000', '411600000000');
INSERT INTO `t_s_country` VALUES ('1754', '郸城县', '411625000000', '411600000000');
INSERT INTO `t_s_country` VALUES ('1755', '淮阳县', '411626000000', '411600000000');
INSERT INTO `t_s_country` VALUES ('1756', '太康县', '411627000000', '411600000000');
INSERT INTO `t_s_country` VALUES ('1757', '鹿邑县', '411628000000', '411600000000');
INSERT INTO `t_s_country` VALUES ('1758', '河南周口经济开发区', '411671000000', '411600000000');
INSERT INTO `t_s_country` VALUES ('1759', '项城市', '411681000000', '411600000000');
INSERT INTO `t_s_country` VALUES ('1760', '市辖区', '411701000000', '411700000000');
INSERT INTO `t_s_country` VALUES ('1761', '驿城区', '411702000000', '411700000000');
INSERT INTO `t_s_country` VALUES ('1762', '西平县', '411721000000', '411700000000');
INSERT INTO `t_s_country` VALUES ('1763', '上蔡县', '411722000000', '411700000000');
INSERT INTO `t_s_country` VALUES ('1764', '平舆县', '411723000000', '411700000000');
INSERT INTO `t_s_country` VALUES ('1765', '正阳县', '411724000000', '411700000000');
INSERT INTO `t_s_country` VALUES ('1766', '确山县', '411725000000', '411700000000');
INSERT INTO `t_s_country` VALUES ('1767', '泌阳县', '411726000000', '411700000000');
INSERT INTO `t_s_country` VALUES ('1768', '汝南县', '411727000000', '411700000000');
INSERT INTO `t_s_country` VALUES ('1769', '遂平县', '411728000000', '411700000000');
INSERT INTO `t_s_country` VALUES ('1770', '新蔡县', '411729000000', '411700000000');
INSERT INTO `t_s_country` VALUES ('1771', '河南驻马店经济开发区', '411771000000', '411700000000');
INSERT INTO `t_s_country` VALUES ('1772', '济源市', '419001000000', '419000000000');
INSERT INTO `t_s_country` VALUES ('1773', '市辖区', '420101000000', '420100000000');
INSERT INTO `t_s_country` VALUES ('1774', '江岸区', '420102000000', '420100000000');
INSERT INTO `t_s_country` VALUES ('1775', '江汉区', '420103000000', '420100000000');
INSERT INTO `t_s_country` VALUES ('1776', '硚口区', '420104000000', '420100000000');
INSERT INTO `t_s_country` VALUES ('1777', '汉阳区', '420105000000', '420100000000');
INSERT INTO `t_s_country` VALUES ('1778', '武昌区', '420106000000', '420100000000');
INSERT INTO `t_s_country` VALUES ('1779', '青山区', '420107000000', '420100000000');
INSERT INTO `t_s_country` VALUES ('1780', '洪山区', '420111000000', '420100000000');
INSERT INTO `t_s_country` VALUES ('1781', '东西湖区', '420112000000', '420100000000');
INSERT INTO `t_s_country` VALUES ('1782', '汉南区', '420113000000', '420100000000');
INSERT INTO `t_s_country` VALUES ('1783', '蔡甸区', '420114000000', '420100000000');
INSERT INTO `t_s_country` VALUES ('1784', '江夏区', '420115000000', '420100000000');
INSERT INTO `t_s_country` VALUES ('1785', '黄陂区', '420116000000', '420100000000');
INSERT INTO `t_s_country` VALUES ('1786', '新洲区', '420117000000', '420100000000');
INSERT INTO `t_s_country` VALUES ('1787', '市辖区', '420201000000', '420200000000');
INSERT INTO `t_s_country` VALUES ('1788', '黄石港区', '420202000000', '420200000000');
INSERT INTO `t_s_country` VALUES ('1789', '西塞山区', '420203000000', '420200000000');
INSERT INTO `t_s_country` VALUES ('1790', '下陆区', '420204000000', '420200000000');
INSERT INTO `t_s_country` VALUES ('1791', '铁山区', '420205000000', '420200000000');
INSERT INTO `t_s_country` VALUES ('1792', '阳新县', '420222000000', '420200000000');
INSERT INTO `t_s_country` VALUES ('1793', '大冶市', '420281000000', '420200000000');
INSERT INTO `t_s_country` VALUES ('1794', '市辖区', '420301000000', '420300000000');
INSERT INTO `t_s_country` VALUES ('1795', '茅箭区', '420302000000', '420300000000');
INSERT INTO `t_s_country` VALUES ('1796', '张湾区', '420303000000', '420300000000');
INSERT INTO `t_s_country` VALUES ('1797', '郧阳区', '420304000000', '420300000000');
INSERT INTO `t_s_country` VALUES ('1798', '郧西县', '420322000000', '420300000000');
INSERT INTO `t_s_country` VALUES ('1799', '竹山县', '420323000000', '420300000000');
INSERT INTO `t_s_country` VALUES ('1800', '竹溪县', '420324000000', '420300000000');
INSERT INTO `t_s_country` VALUES ('1801', '房县', '420325000000', '420300000000');
INSERT INTO `t_s_country` VALUES ('1802', '丹江口市', '420381000000', '420300000000');
INSERT INTO `t_s_country` VALUES ('1803', '市辖区', '420501000000', '420500000000');
INSERT INTO `t_s_country` VALUES ('1804', '西陵区', '420502000000', '420500000000');
INSERT INTO `t_s_country` VALUES ('1805', '伍家岗区', '420503000000', '420500000000');
INSERT INTO `t_s_country` VALUES ('1806', '点军区', '420504000000', '420500000000');
INSERT INTO `t_s_country` VALUES ('1807', '猇亭区', '420505000000', '420500000000');
INSERT INTO `t_s_country` VALUES ('1808', '夷陵区', '420506000000', '420500000000');
INSERT INTO `t_s_country` VALUES ('1809', '远安县', '420525000000', '420500000000');
INSERT INTO `t_s_country` VALUES ('1810', '兴山县', '420526000000', '420500000000');
INSERT INTO `t_s_country` VALUES ('1811', '秭归县', '420527000000', '420500000000');
INSERT INTO `t_s_country` VALUES ('1812', '长阳土家族自治县', '420528000000', '420500000000');
INSERT INTO `t_s_country` VALUES ('1813', '五峰土家族自治县', '420529000000', '420500000000');
INSERT INTO `t_s_country` VALUES ('1814', '宜都市', '420581000000', '420500000000');
INSERT INTO `t_s_country` VALUES ('1815', '当阳市', '420582000000', '420500000000');
INSERT INTO `t_s_country` VALUES ('1816', '枝江市', '420583000000', '420500000000');
INSERT INTO `t_s_country` VALUES ('1817', '市辖区', '420601000000', '420600000000');
INSERT INTO `t_s_country` VALUES ('1818', '襄城区', '420602000000', '420600000000');
INSERT INTO `t_s_country` VALUES ('1819', '樊城区', '420606000000', '420600000000');
INSERT INTO `t_s_country` VALUES ('1820', '襄州区', '420607000000', '420600000000');
INSERT INTO `t_s_country` VALUES ('1821', '南漳县', '420624000000', '420600000000');
INSERT INTO `t_s_country` VALUES ('1822', '谷城县', '420625000000', '420600000000');
INSERT INTO `t_s_country` VALUES ('1823', '保康县', '420626000000', '420600000000');
INSERT INTO `t_s_country` VALUES ('1824', '老河口市', '420682000000', '420600000000');
INSERT INTO `t_s_country` VALUES ('1825', '枣阳市', '420683000000', '420600000000');
INSERT INTO `t_s_country` VALUES ('1826', '宜城市', '420684000000', '420600000000');
INSERT INTO `t_s_country` VALUES ('1827', '市辖区', '420701000000', '420700000000');
INSERT INTO `t_s_country` VALUES ('1828', '梁子湖区', '420702000000', '420700000000');
INSERT INTO `t_s_country` VALUES ('1829', '华容区', '420703000000', '420700000000');
INSERT INTO `t_s_country` VALUES ('1830', '鄂城区', '420704000000', '420700000000');
INSERT INTO `t_s_country` VALUES ('1831', '市辖区', '420801000000', '420800000000');
INSERT INTO `t_s_country` VALUES ('1832', '东宝区', '420802000000', '420800000000');
INSERT INTO `t_s_country` VALUES ('1833', '掇刀区', '420804000000', '420800000000');
INSERT INTO `t_s_country` VALUES ('1834', '沙洋县', '420822000000', '420800000000');
INSERT INTO `t_s_country` VALUES ('1835', '钟祥市', '420881000000', '420800000000');
INSERT INTO `t_s_country` VALUES ('1836', '京山市', '420882000000', '420800000000');
INSERT INTO `t_s_country` VALUES ('1837', '市辖区', '420901000000', '420900000000');
INSERT INTO `t_s_country` VALUES ('1838', '孝南区', '420902000000', '420900000000');
INSERT INTO `t_s_country` VALUES ('1839', '孝昌县', '420921000000', '420900000000');
INSERT INTO `t_s_country` VALUES ('1840', '大悟县', '420922000000', '420900000000');
INSERT INTO `t_s_country` VALUES ('1841', '云梦县', '420923000000', '420900000000');
INSERT INTO `t_s_country` VALUES ('1842', '应城市', '420981000000', '420900000000');
INSERT INTO `t_s_country` VALUES ('1843', '安陆市', '420982000000', '420900000000');
INSERT INTO `t_s_country` VALUES ('1844', '汉川市', '420984000000', '420900000000');
INSERT INTO `t_s_country` VALUES ('1845', '市辖区', '421001000000', '421000000000');
INSERT INTO `t_s_country` VALUES ('1846', '沙市区', '421002000000', '421000000000');
INSERT INTO `t_s_country` VALUES ('1847', '荆州区', '421003000000', '421000000000');
INSERT INTO `t_s_country` VALUES ('1848', '公安县', '421022000000', '421000000000');
INSERT INTO `t_s_country` VALUES ('1849', '监利县', '421023000000', '421000000000');
INSERT INTO `t_s_country` VALUES ('1850', '江陵县', '421024000000', '421000000000');
INSERT INTO `t_s_country` VALUES ('1851', '荆州经济技术开发区', '421071000000', '421000000000');
INSERT INTO `t_s_country` VALUES ('1852', '石首市', '421081000000', '421000000000');
INSERT INTO `t_s_country` VALUES ('1853', '洪湖市', '421083000000', '421000000000');
INSERT INTO `t_s_country` VALUES ('1854', '松滋市', '421087000000', '421000000000');
INSERT INTO `t_s_country` VALUES ('1855', '市辖区', '421101000000', '421100000000');
INSERT INTO `t_s_country` VALUES ('1856', '黄州区', '421102000000', '421100000000');
INSERT INTO `t_s_country` VALUES ('1857', '团风县', '421121000000', '421100000000');
INSERT INTO `t_s_country` VALUES ('1858', '红安县', '421122000000', '421100000000');
INSERT INTO `t_s_country` VALUES ('1859', '罗田县', '421123000000', '421100000000');
INSERT INTO `t_s_country` VALUES ('1860', '英山县', '421124000000', '421100000000');
INSERT INTO `t_s_country` VALUES ('1861', '浠水县', '421125000000', '421100000000');
INSERT INTO `t_s_country` VALUES ('1862', '蕲春县', '421126000000', '421100000000');
INSERT INTO `t_s_country` VALUES ('1863', '黄梅县', '421127000000', '421100000000');
INSERT INTO `t_s_country` VALUES ('1864', '龙感湖管理区', '421171000000', '421100000000');
INSERT INTO `t_s_country` VALUES ('1865', '麻城市', '421181000000', '421100000000');
INSERT INTO `t_s_country` VALUES ('1866', '武穴市', '421182000000', '421100000000');
INSERT INTO `t_s_country` VALUES ('1867', '市辖区', '421201000000', '421200000000');
INSERT INTO `t_s_country` VALUES ('1868', '咸安区', '421202000000', '421200000000');
INSERT INTO `t_s_country` VALUES ('1869', '嘉鱼县', '421221000000', '421200000000');
INSERT INTO `t_s_country` VALUES ('1870', '通城县', '421222000000', '421200000000');
INSERT INTO `t_s_country` VALUES ('1871', '崇阳县', '421223000000', '421200000000');
INSERT INTO `t_s_country` VALUES ('1872', '通山县', '421224000000', '421200000000');
INSERT INTO `t_s_country` VALUES ('1873', '赤壁市', '421281000000', '421200000000');
INSERT INTO `t_s_country` VALUES ('1874', '市辖区', '421301000000', '421300000000');
INSERT INTO `t_s_country` VALUES ('1875', '曾都区', '421303000000', '421300000000');
INSERT INTO `t_s_country` VALUES ('1876', '随县', '421321000000', '421300000000');
INSERT INTO `t_s_country` VALUES ('1877', '广水市', '421381000000', '421300000000');
INSERT INTO `t_s_country` VALUES ('1878', '恩施市', '422801000000', '422800000000');
INSERT INTO `t_s_country` VALUES ('1879', '利川市', '422802000000', '422800000000');
INSERT INTO `t_s_country` VALUES ('1880', '建始县', '422822000000', '422800000000');
INSERT INTO `t_s_country` VALUES ('1881', '巴东县', '422823000000', '422800000000');
INSERT INTO `t_s_country` VALUES ('1882', '宣恩县', '422825000000', '422800000000');
INSERT INTO `t_s_country` VALUES ('1883', '咸丰县', '422826000000', '422800000000');
INSERT INTO `t_s_country` VALUES ('1884', '来凤县', '422827000000', '422800000000');
INSERT INTO `t_s_country` VALUES ('1885', '鹤峰县', '422828000000', '422800000000');
INSERT INTO `t_s_country` VALUES ('1886', '仙桃市', '429004000000', '429000000000');
INSERT INTO `t_s_country` VALUES ('1887', '潜江市', '429005000000', '429000000000');
INSERT INTO `t_s_country` VALUES ('1888', '天门市', '429006000000', '429000000000');
INSERT INTO `t_s_country` VALUES ('1889', '神农架林区', '429021000000', '429000000000');
INSERT INTO `t_s_country` VALUES ('1890', '市辖区', '430101000000', '430100000000');
INSERT INTO `t_s_country` VALUES ('1891', '芙蓉区', '430102000000', '430100000000');
INSERT INTO `t_s_country` VALUES ('1892', '天心区', '430103000000', '430100000000');
INSERT INTO `t_s_country` VALUES ('1893', '岳麓区', '430104000000', '430100000000');
INSERT INTO `t_s_country` VALUES ('1894', '开福区', '430105000000', '430100000000');
INSERT INTO `t_s_country` VALUES ('1895', '雨花区', '430111000000', '430100000000');
INSERT INTO `t_s_country` VALUES ('1896', '望城区', '430112000000', '430100000000');
INSERT INTO `t_s_country` VALUES ('1897', '长沙县', '430121000000', '430100000000');
INSERT INTO `t_s_country` VALUES ('1898', '浏阳市', '430181000000', '430100000000');
INSERT INTO `t_s_country` VALUES ('1899', '宁乡市', '430182000000', '430100000000');
INSERT INTO `t_s_country` VALUES ('1900', '市辖区', '430201000000', '430200000000');
INSERT INTO `t_s_country` VALUES ('1901', '荷塘区', '430202000000', '430200000000');
INSERT INTO `t_s_country` VALUES ('1902', '芦淞区', '430203000000', '430200000000');
INSERT INTO `t_s_country` VALUES ('1903', '石峰区', '430204000000', '430200000000');
INSERT INTO `t_s_country` VALUES ('1904', '天元区', '430211000000', '430200000000');
INSERT INTO `t_s_country` VALUES ('1905', '渌口区', '430212000000', '430200000000');
INSERT INTO `t_s_country` VALUES ('1906', '攸县', '430223000000', '430200000000');
INSERT INTO `t_s_country` VALUES ('1907', '茶陵县', '430224000000', '430200000000');
INSERT INTO `t_s_country` VALUES ('1908', '炎陵县', '430225000000', '430200000000');
INSERT INTO `t_s_country` VALUES ('1909', '云龙示范区', '430271000000', '430200000000');
INSERT INTO `t_s_country` VALUES ('1910', '醴陵市', '430281000000', '430200000000');
INSERT INTO `t_s_country` VALUES ('1911', '市辖区', '430301000000', '430300000000');
INSERT INTO `t_s_country` VALUES ('1912', '雨湖区', '430302000000', '430300000000');
INSERT INTO `t_s_country` VALUES ('1913', '岳塘区', '430304000000', '430300000000');
INSERT INTO `t_s_country` VALUES ('1914', '湘潭县', '430321000000', '430300000000');
INSERT INTO `t_s_country` VALUES ('1915', '湖南湘潭高新技术产业园区', '430371000000', '430300000000');
INSERT INTO `t_s_country` VALUES ('1916', '湘潭昭山示范区', '430372000000', '430300000000');
INSERT INTO `t_s_country` VALUES ('1917', '湘潭九华示范区', '430373000000', '430300000000');
INSERT INTO `t_s_country` VALUES ('1918', '湘乡市', '430381000000', '430300000000');
INSERT INTO `t_s_country` VALUES ('1919', '韶山市', '430382000000', '430300000000');
INSERT INTO `t_s_country` VALUES ('1920', '市辖区', '430401000000', '430400000000');
INSERT INTO `t_s_country` VALUES ('1921', '珠晖区', '430405000000', '430400000000');
INSERT INTO `t_s_country` VALUES ('1922', '雁峰区', '430406000000', '430400000000');
INSERT INTO `t_s_country` VALUES ('1923', '石鼓区', '430407000000', '430400000000');
INSERT INTO `t_s_country` VALUES ('1924', '蒸湘区', '430408000000', '430400000000');
INSERT INTO `t_s_country` VALUES ('1925', '南岳区', '430412000000', '430400000000');
INSERT INTO `t_s_country` VALUES ('1926', '衡阳县', '430421000000', '430400000000');
INSERT INTO `t_s_country` VALUES ('1927', '衡南县', '430422000000', '430400000000');
INSERT INTO `t_s_country` VALUES ('1928', '衡山县', '430423000000', '430400000000');
INSERT INTO `t_s_country` VALUES ('1929', '衡东县', '430424000000', '430400000000');
INSERT INTO `t_s_country` VALUES ('1930', '祁东县', '430426000000', '430400000000');
INSERT INTO `t_s_country` VALUES ('1931', '衡阳综合保税区', '430471000000', '430400000000');
INSERT INTO `t_s_country` VALUES ('1932', '湖南衡阳高新技术产业园区', '430472000000', '430400000000');
INSERT INTO `t_s_country` VALUES ('1933', '湖南衡阳松木经济开发区', '430473000000', '430400000000');
INSERT INTO `t_s_country` VALUES ('1934', '耒阳市', '430481000000', '430400000000');
INSERT INTO `t_s_country` VALUES ('1935', '常宁市', '430482000000', '430400000000');
INSERT INTO `t_s_country` VALUES ('1936', '市辖区', '430501000000', '430500000000');
INSERT INTO `t_s_country` VALUES ('1937', '双清区', '430502000000', '430500000000');
INSERT INTO `t_s_country` VALUES ('1938', '大祥区', '430503000000', '430500000000');
INSERT INTO `t_s_country` VALUES ('1939', '北塔区', '430511000000', '430500000000');
INSERT INTO `t_s_country` VALUES ('1940', '邵东县', '430521000000', '430500000000');
INSERT INTO `t_s_country` VALUES ('1941', '新邵县', '430522000000', '430500000000');
INSERT INTO `t_s_country` VALUES ('1942', '邵阳县', '430523000000', '430500000000');
INSERT INTO `t_s_country` VALUES ('1943', '隆回县', '430524000000', '430500000000');
INSERT INTO `t_s_country` VALUES ('1944', '洞口县', '430525000000', '430500000000');
INSERT INTO `t_s_country` VALUES ('1945', '绥宁县', '430527000000', '430500000000');
INSERT INTO `t_s_country` VALUES ('1946', '新宁县', '430528000000', '430500000000');
INSERT INTO `t_s_country` VALUES ('1947', '城步苗族自治县', '430529000000', '430500000000');
INSERT INTO `t_s_country` VALUES ('1948', '武冈市', '430581000000', '430500000000');
INSERT INTO `t_s_country` VALUES ('1949', '市辖区', '430601000000', '430600000000');
INSERT INTO `t_s_country` VALUES ('1950', '岳阳楼区', '430602000000', '430600000000');
INSERT INTO `t_s_country` VALUES ('1951', '云溪区', '430603000000', '430600000000');
INSERT INTO `t_s_country` VALUES ('1952', '君山区', '430611000000', '430600000000');
INSERT INTO `t_s_country` VALUES ('1953', '岳阳县', '430621000000', '430600000000');
INSERT INTO `t_s_country` VALUES ('1954', '华容县', '430623000000', '430600000000');
INSERT INTO `t_s_country` VALUES ('1955', '湘阴县', '430624000000', '430600000000');
INSERT INTO `t_s_country` VALUES ('1956', '平江县', '430626000000', '430600000000');
INSERT INTO `t_s_country` VALUES ('1957', '岳阳市屈原管理区', '430671000000', '430600000000');
INSERT INTO `t_s_country` VALUES ('1958', '汨罗市', '430681000000', '430600000000');
INSERT INTO `t_s_country` VALUES ('1959', '临湘市', '430682000000', '430600000000');
INSERT INTO `t_s_country` VALUES ('1960', '市辖区', '430701000000', '430700000000');
INSERT INTO `t_s_country` VALUES ('1961', '武陵区', '430702000000', '430700000000');
INSERT INTO `t_s_country` VALUES ('1962', '鼎城区', '430703000000', '430700000000');
INSERT INTO `t_s_country` VALUES ('1963', '安乡县', '430721000000', '430700000000');
INSERT INTO `t_s_country` VALUES ('1964', '汉寿县', '430722000000', '430700000000');
INSERT INTO `t_s_country` VALUES ('1965', '澧县', '430723000000', '430700000000');
INSERT INTO `t_s_country` VALUES ('1966', '临澧县', '430724000000', '430700000000');
INSERT INTO `t_s_country` VALUES ('1967', '桃源县', '430725000000', '430700000000');
INSERT INTO `t_s_country` VALUES ('1968', '石门县', '430726000000', '430700000000');
INSERT INTO `t_s_country` VALUES ('1969', '常德市西洞庭管理区', '430771000000', '430700000000');
INSERT INTO `t_s_country` VALUES ('1970', '津市市', '430781000000', '430700000000');
INSERT INTO `t_s_country` VALUES ('1971', '市辖区', '430801000000', '430800000000');
INSERT INTO `t_s_country` VALUES ('1972', '永定区', '430802000000', '430800000000');
INSERT INTO `t_s_country` VALUES ('1973', '武陵源区', '430811000000', '430800000000');
INSERT INTO `t_s_country` VALUES ('1974', '慈利县', '430821000000', '430800000000');
INSERT INTO `t_s_country` VALUES ('1975', '桑植县', '430822000000', '430800000000');
INSERT INTO `t_s_country` VALUES ('1976', '市辖区', '430901000000', '430900000000');
INSERT INTO `t_s_country` VALUES ('1977', '资阳区', '430902000000', '430900000000');
INSERT INTO `t_s_country` VALUES ('1978', '赫山区', '430903000000', '430900000000');
INSERT INTO `t_s_country` VALUES ('1979', '南县', '430921000000', '430900000000');
INSERT INTO `t_s_country` VALUES ('1980', '桃江县', '430922000000', '430900000000');
INSERT INTO `t_s_country` VALUES ('1981', '安化县', '430923000000', '430900000000');
INSERT INTO `t_s_country` VALUES ('1982', '益阳市大通湖管理区', '430971000000', '430900000000');
INSERT INTO `t_s_country` VALUES ('1983', '湖南益阳高新技术产业园区', '430972000000', '430900000000');
INSERT INTO `t_s_country` VALUES ('1984', '沅江市', '430981000000', '430900000000');
INSERT INTO `t_s_country` VALUES ('1985', '市辖区', '431001000000', '431000000000');
INSERT INTO `t_s_country` VALUES ('1986', '北湖区', '431002000000', '431000000000');
INSERT INTO `t_s_country` VALUES ('1987', '苏仙区', '431003000000', '431000000000');
INSERT INTO `t_s_country` VALUES ('1988', '桂阳县', '431021000000', '431000000000');
INSERT INTO `t_s_country` VALUES ('1989', '宜章县', '431022000000', '431000000000');
INSERT INTO `t_s_country` VALUES ('1990', '永兴县', '431023000000', '431000000000');
INSERT INTO `t_s_country` VALUES ('1991', '嘉禾县', '431024000000', '431000000000');
INSERT INTO `t_s_country` VALUES ('1992', '临武县', '431025000000', '431000000000');
INSERT INTO `t_s_country` VALUES ('1993', '汝城县', '431026000000', '431000000000');
INSERT INTO `t_s_country` VALUES ('1994', '桂东县', '431027000000', '431000000000');
INSERT INTO `t_s_country` VALUES ('1995', '安仁县', '431028000000', '431000000000');
INSERT INTO `t_s_country` VALUES ('1996', '资兴市', '431081000000', '431000000000');
INSERT INTO `t_s_country` VALUES ('1997', '市辖区', '431101000000', '431100000000');
INSERT INTO `t_s_country` VALUES ('1998', '零陵区', '431102000000', '431100000000');
INSERT INTO `t_s_country` VALUES ('1999', '冷水滩区', '431103000000', '431100000000');
INSERT INTO `t_s_country` VALUES ('2000', '祁阳县', '431121000000', '431100000000');
INSERT INTO `t_s_country` VALUES ('2001', '东安县', '431122000000', '431100000000');
INSERT INTO `t_s_country` VALUES ('2002', '双牌县', '431123000000', '431100000000');
INSERT INTO `t_s_country` VALUES ('2003', '道县', '431124000000', '431100000000');
INSERT INTO `t_s_country` VALUES ('2004', '江永县', '431125000000', '431100000000');
INSERT INTO `t_s_country` VALUES ('2005', '宁远县', '431126000000', '431100000000');
INSERT INTO `t_s_country` VALUES ('2006', '蓝山县', '431127000000', '431100000000');
INSERT INTO `t_s_country` VALUES ('2007', '新田县', '431128000000', '431100000000');
INSERT INTO `t_s_country` VALUES ('2008', '江华瑶族自治县', '431129000000', '431100000000');
INSERT INTO `t_s_country` VALUES ('2009', '永州经济技术开发区', '431171000000', '431100000000');
INSERT INTO `t_s_country` VALUES ('2010', '永州市金洞管理区', '431172000000', '431100000000');
INSERT INTO `t_s_country` VALUES ('2011', '永州市回龙圩管理区', '431173000000', '431100000000');
INSERT INTO `t_s_country` VALUES ('2012', '市辖区', '431201000000', '431200000000');
INSERT INTO `t_s_country` VALUES ('2013', '鹤城区', '431202000000', '431200000000');
INSERT INTO `t_s_country` VALUES ('2014', '中方县', '431221000000', '431200000000');
INSERT INTO `t_s_country` VALUES ('2015', '沅陵县', '431222000000', '431200000000');
INSERT INTO `t_s_country` VALUES ('2016', '辰溪县', '431223000000', '431200000000');
INSERT INTO `t_s_country` VALUES ('2017', '溆浦县', '431224000000', '431200000000');
INSERT INTO `t_s_country` VALUES ('2018', '会同县', '431225000000', '431200000000');
INSERT INTO `t_s_country` VALUES ('2019', '麻阳苗族自治县', '431226000000', '431200000000');
INSERT INTO `t_s_country` VALUES ('2020', '新晃侗族自治县', '431227000000', '431200000000');
INSERT INTO `t_s_country` VALUES ('2021', '芷江侗族自治县', '431228000000', '431200000000');
INSERT INTO `t_s_country` VALUES ('2022', '靖州苗族侗族自治县', '431229000000', '431200000000');
INSERT INTO `t_s_country` VALUES ('2023', '通道侗族自治县', '431230000000', '431200000000');
INSERT INTO `t_s_country` VALUES ('2024', '怀化市洪江管理区', '431271000000', '431200000000');
INSERT INTO `t_s_country` VALUES ('2025', '洪江市', '431281000000', '431200000000');
INSERT INTO `t_s_country` VALUES ('2026', '市辖区', '431301000000', '431300000000');
INSERT INTO `t_s_country` VALUES ('2027', '娄星区', '431302000000', '431300000000');
INSERT INTO `t_s_country` VALUES ('2028', '双峰县', '431321000000', '431300000000');
INSERT INTO `t_s_country` VALUES ('2029', '新化县', '431322000000', '431300000000');
INSERT INTO `t_s_country` VALUES ('2030', '冷水江市', '431381000000', '431300000000');
INSERT INTO `t_s_country` VALUES ('2031', '涟源市', '431382000000', '431300000000');
INSERT INTO `t_s_country` VALUES ('2032', '吉首市', '433101000000', '433100000000');
INSERT INTO `t_s_country` VALUES ('2033', '泸溪县', '433122000000', '433100000000');
INSERT INTO `t_s_country` VALUES ('2034', '凤凰县', '433123000000', '433100000000');
INSERT INTO `t_s_country` VALUES ('2035', '花垣县', '433124000000', '433100000000');
INSERT INTO `t_s_country` VALUES ('2036', '保靖县', '433125000000', '433100000000');
INSERT INTO `t_s_country` VALUES ('2037', '古丈县', '433126000000', '433100000000');
INSERT INTO `t_s_country` VALUES ('2038', '永顺县', '433127000000', '433100000000');
INSERT INTO `t_s_country` VALUES ('2039', '龙山县', '433130000000', '433100000000');
INSERT INTO `t_s_country` VALUES ('2040', '湖南吉首经济开发区', '433172000000', '433100000000');
INSERT INTO `t_s_country` VALUES ('2041', '湖南永顺经济开发区', '433173000000', '433100000000');
INSERT INTO `t_s_country` VALUES ('2042', '市辖区', '440101000000', '440100000000');
INSERT INTO `t_s_country` VALUES ('2043', '荔湾区', '440103000000', '440100000000');
INSERT INTO `t_s_country` VALUES ('2044', '越秀区', '440104000000', '440100000000');
INSERT INTO `t_s_country` VALUES ('2045', '海珠区', '440105000000', '440100000000');
INSERT INTO `t_s_country` VALUES ('2046', '天河区', '440106000000', '440100000000');
INSERT INTO `t_s_country` VALUES ('2047', '白云区', '440111000000', '440100000000');
INSERT INTO `t_s_country` VALUES ('2048', '黄埔区', '440112000000', '440100000000');
INSERT INTO `t_s_country` VALUES ('2049', '番禺区', '440113000000', '440100000000');
INSERT INTO `t_s_country` VALUES ('2050', '花都区', '440114000000', '440100000000');
INSERT INTO `t_s_country` VALUES ('2051', '南沙区', '440115000000', '440100000000');
INSERT INTO `t_s_country` VALUES ('2052', '从化区', '440117000000', '440100000000');
INSERT INTO `t_s_country` VALUES ('2053', '增城区', '440118000000', '440100000000');
INSERT INTO `t_s_country` VALUES ('2054', '市辖区', '440201000000', '440200000000');
INSERT INTO `t_s_country` VALUES ('2055', '武江区', '440203000000', '440200000000');
INSERT INTO `t_s_country` VALUES ('2056', '浈江区', '440204000000', '440200000000');
INSERT INTO `t_s_country` VALUES ('2057', '曲江区', '440205000000', '440200000000');
INSERT INTO `t_s_country` VALUES ('2058', '始兴县', '440222000000', '440200000000');
INSERT INTO `t_s_country` VALUES ('2059', '仁化县', '440224000000', '440200000000');
INSERT INTO `t_s_country` VALUES ('2060', '翁源县', '440229000000', '440200000000');
INSERT INTO `t_s_country` VALUES ('2061', '乳源瑶族自治县', '440232000000', '440200000000');
INSERT INTO `t_s_country` VALUES ('2062', '新丰县', '440233000000', '440200000000');
INSERT INTO `t_s_country` VALUES ('2063', '乐昌市', '440281000000', '440200000000');
INSERT INTO `t_s_country` VALUES ('2064', '南雄市', '440282000000', '440200000000');
INSERT INTO `t_s_country` VALUES ('2065', '市辖区', '440301000000', '440300000000');
INSERT INTO `t_s_country` VALUES ('2066', '罗湖区', '440303000000', '440300000000');
INSERT INTO `t_s_country` VALUES ('2067', '福田区', '440304000000', '440300000000');
INSERT INTO `t_s_country` VALUES ('2068', '南山区', '440305000000', '440300000000');
INSERT INTO `t_s_country` VALUES ('2069', '宝安区', '440306000000', '440300000000');
INSERT INTO `t_s_country` VALUES ('2070', '龙岗区', '440307000000', '440300000000');
INSERT INTO `t_s_country` VALUES ('2071', '盐田区', '440308000000', '440300000000');
INSERT INTO `t_s_country` VALUES ('2072', '龙华区', '440309000000', '440300000000');
INSERT INTO `t_s_country` VALUES ('2073', '坪山区', '440310000000', '440300000000');
INSERT INTO `t_s_country` VALUES ('2074', '光明区', '440311000000', '440300000000');
INSERT INTO `t_s_country` VALUES ('2075', '市辖区', '440401000000', '440400000000');
INSERT INTO `t_s_country` VALUES ('2076', '香洲区', '440402000000', '440400000000');
INSERT INTO `t_s_country` VALUES ('2077', '斗门区', '440403000000', '440400000000');
INSERT INTO `t_s_country` VALUES ('2078', '金湾区', '440404000000', '440400000000');
INSERT INTO `t_s_country` VALUES ('2079', '市辖区', '440501000000', '440500000000');
INSERT INTO `t_s_country` VALUES ('2080', '龙湖区', '440507000000', '440500000000');
INSERT INTO `t_s_country` VALUES ('2081', '金平区', '440511000000', '440500000000');
INSERT INTO `t_s_country` VALUES ('2082', '濠江区', '440512000000', '440500000000');
INSERT INTO `t_s_country` VALUES ('2083', '潮阳区', '440513000000', '440500000000');
INSERT INTO `t_s_country` VALUES ('2084', '潮南区', '440514000000', '440500000000');
INSERT INTO `t_s_country` VALUES ('2085', '澄海区', '440515000000', '440500000000');
INSERT INTO `t_s_country` VALUES ('2086', '南澳县', '440523000000', '440500000000');
INSERT INTO `t_s_country` VALUES ('2087', '市辖区', '440601000000', '440600000000');
INSERT INTO `t_s_country` VALUES ('2088', '禅城区', '440604000000', '440600000000');
INSERT INTO `t_s_country` VALUES ('2089', '南海区', '440605000000', '440600000000');
INSERT INTO `t_s_country` VALUES ('2090', '顺德区', '440606000000', '440600000000');
INSERT INTO `t_s_country` VALUES ('2091', '三水区', '440607000000', '440600000000');
INSERT INTO `t_s_country` VALUES ('2092', '高明区', '440608000000', '440600000000');
INSERT INTO `t_s_country` VALUES ('2093', '市辖区', '440701000000', '440700000000');
INSERT INTO `t_s_country` VALUES ('2094', '蓬江区', '440703000000', '440700000000');
INSERT INTO `t_s_country` VALUES ('2095', '江海区', '440704000000', '440700000000');
INSERT INTO `t_s_country` VALUES ('2096', '新会区', '440705000000', '440700000000');
INSERT INTO `t_s_country` VALUES ('2097', '台山市', '440781000000', '440700000000');
INSERT INTO `t_s_country` VALUES ('2098', '开平市', '440783000000', '440700000000');
INSERT INTO `t_s_country` VALUES ('2099', '鹤山市', '440784000000', '440700000000');
INSERT INTO `t_s_country` VALUES ('2100', '恩平市', '440785000000', '440700000000');
INSERT INTO `t_s_country` VALUES ('2101', '市辖区', '440801000000', '440800000000');
INSERT INTO `t_s_country` VALUES ('2102', '赤坎区', '440802000000', '440800000000');
INSERT INTO `t_s_country` VALUES ('2103', '霞山区', '440803000000', '440800000000');
INSERT INTO `t_s_country` VALUES ('2104', '坡头区', '440804000000', '440800000000');
INSERT INTO `t_s_country` VALUES ('2105', '麻章区', '440811000000', '440800000000');
INSERT INTO `t_s_country` VALUES ('2106', '遂溪县', '440823000000', '440800000000');
INSERT INTO `t_s_country` VALUES ('2107', '徐闻县', '440825000000', '440800000000');
INSERT INTO `t_s_country` VALUES ('2108', '廉江市', '440881000000', '440800000000');
INSERT INTO `t_s_country` VALUES ('2109', '雷州市', '440882000000', '440800000000');
INSERT INTO `t_s_country` VALUES ('2110', '吴川市', '440883000000', '440800000000');
INSERT INTO `t_s_country` VALUES ('2111', '市辖区', '440901000000', '440900000000');
INSERT INTO `t_s_country` VALUES ('2112', '茂南区', '440902000000', '440900000000');
INSERT INTO `t_s_country` VALUES ('2113', '电白区', '440904000000', '440900000000');
INSERT INTO `t_s_country` VALUES ('2114', '高州市', '440981000000', '440900000000');
INSERT INTO `t_s_country` VALUES ('2115', '化州市', '440982000000', '440900000000');
INSERT INTO `t_s_country` VALUES ('2116', '信宜市', '440983000000', '440900000000');
INSERT INTO `t_s_country` VALUES ('2117', '市辖区', '441201000000', '441200000000');
INSERT INTO `t_s_country` VALUES ('2118', '端州区', '441202000000', '441200000000');
INSERT INTO `t_s_country` VALUES ('2119', '鼎湖区', '441203000000', '441200000000');
INSERT INTO `t_s_country` VALUES ('2120', '高要区', '441204000000', '441200000000');
INSERT INTO `t_s_country` VALUES ('2121', '广宁县', '441223000000', '441200000000');
INSERT INTO `t_s_country` VALUES ('2122', '怀集县', '441224000000', '441200000000');
INSERT INTO `t_s_country` VALUES ('2123', '封开县', '441225000000', '441200000000');
INSERT INTO `t_s_country` VALUES ('2124', '德庆县', '441226000000', '441200000000');
INSERT INTO `t_s_country` VALUES ('2125', '四会市', '441284000000', '441200000000');
INSERT INTO `t_s_country` VALUES ('2126', '市辖区', '441301000000', '441300000000');
INSERT INTO `t_s_country` VALUES ('2127', '惠城区', '441302000000', '441300000000');
INSERT INTO `t_s_country` VALUES ('2128', '惠阳区', '441303000000', '441300000000');
INSERT INTO `t_s_country` VALUES ('2129', '博罗县', '441322000000', '441300000000');
INSERT INTO `t_s_country` VALUES ('2130', '惠东县', '441323000000', '441300000000');
INSERT INTO `t_s_country` VALUES ('2131', '龙门县', '441324000000', '441300000000');
INSERT INTO `t_s_country` VALUES ('2132', '市辖区', '441401000000', '441400000000');
INSERT INTO `t_s_country` VALUES ('2133', '梅江区', '441402000000', '441400000000');
INSERT INTO `t_s_country` VALUES ('2134', '梅县区', '441403000000', '441400000000');
INSERT INTO `t_s_country` VALUES ('2135', '大埔县', '441422000000', '441400000000');
INSERT INTO `t_s_country` VALUES ('2136', '丰顺县', '441423000000', '441400000000');
INSERT INTO `t_s_country` VALUES ('2137', '五华县', '441424000000', '441400000000');
INSERT INTO `t_s_country` VALUES ('2138', '平远县', '441426000000', '441400000000');
INSERT INTO `t_s_country` VALUES ('2139', '蕉岭县', '441427000000', '441400000000');
INSERT INTO `t_s_country` VALUES ('2140', '兴宁市', '441481000000', '441400000000');
INSERT INTO `t_s_country` VALUES ('2141', '市辖区', '441501000000', '441500000000');
INSERT INTO `t_s_country` VALUES ('2142', '城区', '441502000000', '441500000000');
INSERT INTO `t_s_country` VALUES ('2143', '海丰县', '441521000000', '441500000000');
INSERT INTO `t_s_country` VALUES ('2144', '陆河县', '441523000000', '441500000000');
INSERT INTO `t_s_country` VALUES ('2145', '陆丰市', '441581000000', '441500000000');
INSERT INTO `t_s_country` VALUES ('2146', '市辖区', '441601000000', '441600000000');
INSERT INTO `t_s_country` VALUES ('2147', '源城区', '441602000000', '441600000000');
INSERT INTO `t_s_country` VALUES ('2148', '紫金县', '441621000000', '441600000000');
INSERT INTO `t_s_country` VALUES ('2149', '龙川县', '441622000000', '441600000000');
INSERT INTO `t_s_country` VALUES ('2150', '连平县', '441623000000', '441600000000');
INSERT INTO `t_s_country` VALUES ('2151', '和平县', '441624000000', '441600000000');
INSERT INTO `t_s_country` VALUES ('2152', '东源县', '441625000000', '441600000000');
INSERT INTO `t_s_country` VALUES ('2153', '市辖区', '441701000000', '441700000000');
INSERT INTO `t_s_country` VALUES ('2154', '江城区', '441702000000', '441700000000');
INSERT INTO `t_s_country` VALUES ('2155', '阳东区', '441704000000', '441700000000');
INSERT INTO `t_s_country` VALUES ('2156', '阳西县', '441721000000', '441700000000');
INSERT INTO `t_s_country` VALUES ('2157', '阳春市', '441781000000', '441700000000');
INSERT INTO `t_s_country` VALUES ('2158', '市辖区', '441801000000', '441800000000');
INSERT INTO `t_s_country` VALUES ('2159', '清城区', '441802000000', '441800000000');
INSERT INTO `t_s_country` VALUES ('2160', '清新区', '441803000000', '441800000000');
INSERT INTO `t_s_country` VALUES ('2161', '佛冈县', '441821000000', '441800000000');
INSERT INTO `t_s_country` VALUES ('2162', '阳山县', '441823000000', '441800000000');
INSERT INTO `t_s_country` VALUES ('2163', '连山壮族瑶族自治县', '441825000000', '441800000000');
INSERT INTO `t_s_country` VALUES ('2164', '连南瑶族自治县', '441826000000', '441800000000');
INSERT INTO `t_s_country` VALUES ('2165', '英德市', '441881000000', '441800000000');
INSERT INTO `t_s_country` VALUES ('2166', '连州市', '441882000000', '441800000000');
INSERT INTO `t_s_country` VALUES ('2167', '市辖区', '445101000000', '445100000000');
INSERT INTO `t_s_country` VALUES ('2168', '湘桥区', '445102000000', '445100000000');
INSERT INTO `t_s_country` VALUES ('2169', '潮安区', '445103000000', '445100000000');
INSERT INTO `t_s_country` VALUES ('2170', '饶平县', '445122000000', '445100000000');
INSERT INTO `t_s_country` VALUES ('2171', '市辖区', '445201000000', '445200000000');
INSERT INTO `t_s_country` VALUES ('2172', '榕城区', '445202000000', '445200000000');
INSERT INTO `t_s_country` VALUES ('2173', '揭东区', '445203000000', '445200000000');
INSERT INTO `t_s_country` VALUES ('2174', '揭西县', '445222000000', '445200000000');
INSERT INTO `t_s_country` VALUES ('2175', '惠来县', '445224000000', '445200000000');
INSERT INTO `t_s_country` VALUES ('2176', '普宁市', '445281000000', '445200000000');
INSERT INTO `t_s_country` VALUES ('2177', '市辖区', '445301000000', '445300000000');
INSERT INTO `t_s_country` VALUES ('2178', '云城区', '445302000000', '445300000000');
INSERT INTO `t_s_country` VALUES ('2179', '云安区', '445303000000', '445300000000');
INSERT INTO `t_s_country` VALUES ('2180', '新兴县', '445321000000', '445300000000');
INSERT INTO `t_s_country` VALUES ('2181', '郁南县', '445322000000', '445300000000');
INSERT INTO `t_s_country` VALUES ('2182', '罗定市', '445381000000', '445300000000');
INSERT INTO `t_s_country` VALUES ('2183', '市辖区', '450101000000', '450100000000');
INSERT INTO `t_s_country` VALUES ('2184', '兴宁区', '450102000000', '450100000000');
INSERT INTO `t_s_country` VALUES ('2185', '青秀区', '450103000000', '450100000000');
INSERT INTO `t_s_country` VALUES ('2186', '江南区', '450105000000', '450100000000');
INSERT INTO `t_s_country` VALUES ('2187', '西乡塘区', '450107000000', '450100000000');
INSERT INTO `t_s_country` VALUES ('2188', '良庆区', '450108000000', '450100000000');
INSERT INTO `t_s_country` VALUES ('2189', '邕宁区', '450109000000', '450100000000');
INSERT INTO `t_s_country` VALUES ('2190', '武鸣区', '450110000000', '450100000000');
INSERT INTO `t_s_country` VALUES ('2191', '隆安县', '450123000000', '450100000000');
INSERT INTO `t_s_country` VALUES ('2192', '马山县', '450124000000', '450100000000');
INSERT INTO `t_s_country` VALUES ('2193', '上林县', '450125000000', '450100000000');
INSERT INTO `t_s_country` VALUES ('2194', '宾阳县', '450126000000', '450100000000');
INSERT INTO `t_s_country` VALUES ('2195', '横县', '450127000000', '450100000000');
INSERT INTO `t_s_country` VALUES ('2196', '市辖区', '450201000000', '450200000000');
INSERT INTO `t_s_country` VALUES ('2197', '城中区', '450202000000', '450200000000');
INSERT INTO `t_s_country` VALUES ('2198', '鱼峰区', '450203000000', '450200000000');
INSERT INTO `t_s_country` VALUES ('2199', '柳南区', '450204000000', '450200000000');
INSERT INTO `t_s_country` VALUES ('2200', '柳北区', '450205000000', '450200000000');
INSERT INTO `t_s_country` VALUES ('2201', '柳江区', '450206000000', '450200000000');
INSERT INTO `t_s_country` VALUES ('2202', '柳城县', '450222000000', '450200000000');
INSERT INTO `t_s_country` VALUES ('2203', '鹿寨县', '450223000000', '450200000000');
INSERT INTO `t_s_country` VALUES ('2204', '融安县', '450224000000', '450200000000');
INSERT INTO `t_s_country` VALUES ('2205', '融水苗族自治县', '450225000000', '450200000000');
INSERT INTO `t_s_country` VALUES ('2206', '三江侗族自治县', '450226000000', '450200000000');
INSERT INTO `t_s_country` VALUES ('2207', '市辖区', '450301000000', '450300000000');
INSERT INTO `t_s_country` VALUES ('2208', '秀峰区', '450302000000', '450300000000');
INSERT INTO `t_s_country` VALUES ('2209', '叠彩区', '450303000000', '450300000000');
INSERT INTO `t_s_country` VALUES ('2210', '象山区', '450304000000', '450300000000');
INSERT INTO `t_s_country` VALUES ('2211', '七星区', '450305000000', '450300000000');
INSERT INTO `t_s_country` VALUES ('2212', '雁山区', '450311000000', '450300000000');
INSERT INTO `t_s_country` VALUES ('2213', '临桂区', '450312000000', '450300000000');
INSERT INTO `t_s_country` VALUES ('2214', '阳朔县', '450321000000', '450300000000');
INSERT INTO `t_s_country` VALUES ('2215', '灵川县', '450323000000', '450300000000');
INSERT INTO `t_s_country` VALUES ('2216', '全州县', '450324000000', '450300000000');
INSERT INTO `t_s_country` VALUES ('2217', '兴安县', '450325000000', '450300000000');
INSERT INTO `t_s_country` VALUES ('2218', '永福县', '450326000000', '450300000000');
INSERT INTO `t_s_country` VALUES ('2219', '灌阳县', '450327000000', '450300000000');
INSERT INTO `t_s_country` VALUES ('2220', '龙胜各族自治县', '450328000000', '450300000000');
INSERT INTO `t_s_country` VALUES ('2221', '资源县', '450329000000', '450300000000');
INSERT INTO `t_s_country` VALUES ('2222', '平乐县', '450330000000', '450300000000');
INSERT INTO `t_s_country` VALUES ('2223', '恭城瑶族自治县', '450332000000', '450300000000');
INSERT INTO `t_s_country` VALUES ('2224', '荔浦市', '450381000000', '450300000000');
INSERT INTO `t_s_country` VALUES ('2225', '市辖区', '450401000000', '450400000000');
INSERT INTO `t_s_country` VALUES ('2226', '万秀区', '450403000000', '450400000000');
INSERT INTO `t_s_country` VALUES ('2227', '长洲区', '450405000000', '450400000000');
INSERT INTO `t_s_country` VALUES ('2228', '龙圩区', '450406000000', '450400000000');
INSERT INTO `t_s_country` VALUES ('2229', '苍梧县', '450421000000', '450400000000');
INSERT INTO `t_s_country` VALUES ('2230', '藤县', '450422000000', '450400000000');
INSERT INTO `t_s_country` VALUES ('2231', '蒙山县', '450423000000', '450400000000');
INSERT INTO `t_s_country` VALUES ('2232', '岑溪市', '450481000000', '450400000000');
INSERT INTO `t_s_country` VALUES ('2233', '市辖区', '450501000000', '450500000000');
INSERT INTO `t_s_country` VALUES ('2234', '海城区', '450502000000', '450500000000');
INSERT INTO `t_s_country` VALUES ('2235', '银海区', '450503000000', '450500000000');
INSERT INTO `t_s_country` VALUES ('2236', '铁山港区', '450512000000', '450500000000');
INSERT INTO `t_s_country` VALUES ('2237', '合浦县', '450521000000', '450500000000');
INSERT INTO `t_s_country` VALUES ('2238', '市辖区', '450601000000', '450600000000');
INSERT INTO `t_s_country` VALUES ('2239', '港口区', '450602000000', '450600000000');
INSERT INTO `t_s_country` VALUES ('2240', '防城区', '450603000000', '450600000000');
INSERT INTO `t_s_country` VALUES ('2241', '上思县', '450621000000', '450600000000');
INSERT INTO `t_s_country` VALUES ('2242', '东兴市', '450681000000', '450600000000');
INSERT INTO `t_s_country` VALUES ('2243', '市辖区', '450701000000', '450700000000');
INSERT INTO `t_s_country` VALUES ('2244', '钦南区', '450702000000', '450700000000');
INSERT INTO `t_s_country` VALUES ('2245', '钦北区', '450703000000', '450700000000');
INSERT INTO `t_s_country` VALUES ('2246', '灵山县', '450721000000', '450700000000');
INSERT INTO `t_s_country` VALUES ('2247', '浦北县', '450722000000', '450700000000');
INSERT INTO `t_s_country` VALUES ('2248', '市辖区', '450801000000', '450800000000');
INSERT INTO `t_s_country` VALUES ('2249', '港北区', '450802000000', '450800000000');
INSERT INTO `t_s_country` VALUES ('2250', '港南区', '450803000000', '450800000000');
INSERT INTO `t_s_country` VALUES ('2251', '覃塘区', '450804000000', '450800000000');
INSERT INTO `t_s_country` VALUES ('2252', '平南县', '450821000000', '450800000000');
INSERT INTO `t_s_country` VALUES ('2253', '桂平市', '450881000000', '450800000000');
INSERT INTO `t_s_country` VALUES ('2254', '市辖区', '450901000000', '450900000000');
INSERT INTO `t_s_country` VALUES ('2255', '玉州区', '450902000000', '450900000000');
INSERT INTO `t_s_country` VALUES ('2256', '福绵区', '450903000000', '450900000000');
INSERT INTO `t_s_country` VALUES ('2257', '容县', '450921000000', '450900000000');
INSERT INTO `t_s_country` VALUES ('2258', '陆川县', '450922000000', '450900000000');
INSERT INTO `t_s_country` VALUES ('2259', '博白县', '450923000000', '450900000000');
INSERT INTO `t_s_country` VALUES ('2260', '兴业县', '450924000000', '450900000000');
INSERT INTO `t_s_country` VALUES ('2261', '北流市', '450981000000', '450900000000');
INSERT INTO `t_s_country` VALUES ('2262', '市辖区', '451001000000', '451000000000');
INSERT INTO `t_s_country` VALUES ('2263', '右江区', '451002000000', '451000000000');
INSERT INTO `t_s_country` VALUES ('2264', '田阳县', '451021000000', '451000000000');
INSERT INTO `t_s_country` VALUES ('2265', '田东县', '451022000000', '451000000000');
INSERT INTO `t_s_country` VALUES ('2266', '平果县', '451023000000', '451000000000');
INSERT INTO `t_s_country` VALUES ('2267', '德保县', '451024000000', '451000000000');
INSERT INTO `t_s_country` VALUES ('2268', '那坡县', '451026000000', '451000000000');
INSERT INTO `t_s_country` VALUES ('2269', '凌云县', '451027000000', '451000000000');
INSERT INTO `t_s_country` VALUES ('2270', '乐业县', '451028000000', '451000000000');
INSERT INTO `t_s_country` VALUES ('2271', '田林县', '451029000000', '451000000000');
INSERT INTO `t_s_country` VALUES ('2272', '西林县', '451030000000', '451000000000');
INSERT INTO `t_s_country` VALUES ('2273', '隆林各族自治县', '451031000000', '451000000000');
INSERT INTO `t_s_country` VALUES ('2274', '靖西市', '451081000000', '451000000000');
INSERT INTO `t_s_country` VALUES ('2275', '市辖区', '451101000000', '451100000000');
INSERT INTO `t_s_country` VALUES ('2276', '八步区', '451102000000', '451100000000');
INSERT INTO `t_s_country` VALUES ('2277', '平桂区', '451103000000', '451100000000');
INSERT INTO `t_s_country` VALUES ('2278', '昭平县', '451121000000', '451100000000');
INSERT INTO `t_s_country` VALUES ('2279', '钟山县', '451122000000', '451100000000');
INSERT INTO `t_s_country` VALUES ('2280', '富川瑶族自治县', '451123000000', '451100000000');
INSERT INTO `t_s_country` VALUES ('2281', '市辖区', '451201000000', '451200000000');
INSERT INTO `t_s_country` VALUES ('2282', '金城江区', '451202000000', '451200000000');
INSERT INTO `t_s_country` VALUES ('2283', '宜州区', '451203000000', '451200000000');
INSERT INTO `t_s_country` VALUES ('2284', '南丹县', '451221000000', '451200000000');
INSERT INTO `t_s_country` VALUES ('2285', '天峨县', '451222000000', '451200000000');
INSERT INTO `t_s_country` VALUES ('2286', '凤山县', '451223000000', '451200000000');
INSERT INTO `t_s_country` VALUES ('2287', '东兰县', '451224000000', '451200000000');
INSERT INTO `t_s_country` VALUES ('2288', '罗城仫佬族自治县', '451225000000', '451200000000');
INSERT INTO `t_s_country` VALUES ('2289', '环江毛南族自治县', '451226000000', '451200000000');
INSERT INTO `t_s_country` VALUES ('2290', '巴马瑶族自治县', '451227000000', '451200000000');
INSERT INTO `t_s_country` VALUES ('2291', '都安瑶族自治县', '451228000000', '451200000000');
INSERT INTO `t_s_country` VALUES ('2292', '大化瑶族自治县', '451229000000', '451200000000');
INSERT INTO `t_s_country` VALUES ('2293', '市辖区', '451301000000', '451300000000');
INSERT INTO `t_s_country` VALUES ('2294', '兴宾区', '451302000000', '451300000000');
INSERT INTO `t_s_country` VALUES ('2295', '忻城县', '451321000000', '451300000000');
INSERT INTO `t_s_country` VALUES ('2296', '象州县', '451322000000', '451300000000');
INSERT INTO `t_s_country` VALUES ('2297', '武宣县', '451323000000', '451300000000');
INSERT INTO `t_s_country` VALUES ('2298', '金秀瑶族自治县', '451324000000', '451300000000');
INSERT INTO `t_s_country` VALUES ('2299', '合山市', '451381000000', '451300000000');
INSERT INTO `t_s_country` VALUES ('2300', '市辖区', '451401000000', '451400000000');
INSERT INTO `t_s_country` VALUES ('2301', '江州区', '451402000000', '451400000000');
INSERT INTO `t_s_country` VALUES ('2302', '扶绥县', '451421000000', '451400000000');
INSERT INTO `t_s_country` VALUES ('2303', '宁明县', '451422000000', '451400000000');
INSERT INTO `t_s_country` VALUES ('2304', '龙州县', '451423000000', '451400000000');
INSERT INTO `t_s_country` VALUES ('2305', '大新县', '451424000000', '451400000000');
INSERT INTO `t_s_country` VALUES ('2306', '天等县', '451425000000', '451400000000');
INSERT INTO `t_s_country` VALUES ('2307', '凭祥市', '451481000000', '451400000000');
INSERT INTO `t_s_country` VALUES ('2308', '市辖区', '460101000000', '460100000000');
INSERT INTO `t_s_country` VALUES ('2309', '秀英区', '460105000000', '460100000000');
INSERT INTO `t_s_country` VALUES ('2310', '龙华区', '460106000000', '460100000000');
INSERT INTO `t_s_country` VALUES ('2311', '琼山区', '460107000000', '460100000000');
INSERT INTO `t_s_country` VALUES ('2312', '美兰区', '460108000000', '460100000000');
INSERT INTO `t_s_country` VALUES ('2313', '市辖区', '460201000000', '460200000000');
INSERT INTO `t_s_country` VALUES ('2314', '海棠区', '460202000000', '460200000000');
INSERT INTO `t_s_country` VALUES ('2315', '吉阳区', '460203000000', '460200000000');
INSERT INTO `t_s_country` VALUES ('2316', '天涯区', '460204000000', '460200000000');
INSERT INTO `t_s_country` VALUES ('2317', '崖州区', '460205000000', '460200000000');
INSERT INTO `t_s_country` VALUES ('2318', '西沙群岛', '460321000000', '460300000000');
INSERT INTO `t_s_country` VALUES ('2319', '南沙群岛', '460322000000', '460300000000');
INSERT INTO `t_s_country` VALUES ('2320', '中沙群岛的岛礁及其海域', '460323000000', '460300000000');
INSERT INTO `t_s_country` VALUES ('2321', '五指山市', '469001000000', '469000000000');
INSERT INTO `t_s_country` VALUES ('2322', '琼海市', '469002000000', '469000000000');
INSERT INTO `t_s_country` VALUES ('2323', '文昌市', '469005000000', '469000000000');
INSERT INTO `t_s_country` VALUES ('2324', '万宁市', '469006000000', '469000000000');
INSERT INTO `t_s_country` VALUES ('2325', '东方市', '469007000000', '469000000000');
INSERT INTO `t_s_country` VALUES ('2326', '定安县', '469021000000', '469000000000');
INSERT INTO `t_s_country` VALUES ('2327', '屯昌县', '469022000000', '469000000000');
INSERT INTO `t_s_country` VALUES ('2328', '澄迈县', '469023000000', '469000000000');
INSERT INTO `t_s_country` VALUES ('2329', '临高县', '469024000000', '469000000000');
INSERT INTO `t_s_country` VALUES ('2330', '白沙黎族自治县', '469025000000', '469000000000');
INSERT INTO `t_s_country` VALUES ('2331', '昌江黎族自治县', '469026000000', '469000000000');
INSERT INTO `t_s_country` VALUES ('2332', '乐东黎族自治县', '469027000000', '469000000000');
INSERT INTO `t_s_country` VALUES ('2333', '陵水黎族自治县', '469028000000', '469000000000');
INSERT INTO `t_s_country` VALUES ('2334', '保亭黎族苗族自治县', '469029000000', '469000000000');
INSERT INTO `t_s_country` VALUES ('2335', '琼中黎族苗族自治县', '469030000000', '469000000000');
INSERT INTO `t_s_country` VALUES ('2336', '万州区', '500101000000', '500100000000');
INSERT INTO `t_s_country` VALUES ('2337', '涪陵区', '500102000000', '500100000000');
INSERT INTO `t_s_country` VALUES ('2338', '渝中区', '500103000000', '500100000000');
INSERT INTO `t_s_country` VALUES ('2339', '大渡口区', '500104000000', '500100000000');
INSERT INTO `t_s_country` VALUES ('2340', '江北区', '500105000000', '500100000000');
INSERT INTO `t_s_country` VALUES ('2341', '沙坪坝区', '500106000000', '500100000000');
INSERT INTO `t_s_country` VALUES ('2342', '九龙坡区', '500107000000', '500100000000');
INSERT INTO `t_s_country` VALUES ('2343', '南岸区', '500108000000', '500100000000');
INSERT INTO `t_s_country` VALUES ('2344', '北碚区', '500109000000', '500100000000');
INSERT INTO `t_s_country` VALUES ('2345', '綦江区', '500110000000', '500100000000');
INSERT INTO `t_s_country` VALUES ('2346', '大足区', '500111000000', '500100000000');
INSERT INTO `t_s_country` VALUES ('2347', '渝北区', '500112000000', '500100000000');
INSERT INTO `t_s_country` VALUES ('2348', '巴南区', '500113000000', '500100000000');
INSERT INTO `t_s_country` VALUES ('2349', '黔江区', '500114000000', '500100000000');
INSERT INTO `t_s_country` VALUES ('2350', '长寿区', '500115000000', '500100000000');
INSERT INTO `t_s_country` VALUES ('2351', '江津区', '500116000000', '500100000000');
INSERT INTO `t_s_country` VALUES ('2352', '合川区', '500117000000', '500100000000');
INSERT INTO `t_s_country` VALUES ('2353', '永川区', '500118000000', '500100000000');
INSERT INTO `t_s_country` VALUES ('2354', '南川区', '500119000000', '500100000000');
INSERT INTO `t_s_country` VALUES ('2355', '璧山区', '500120000000', '500100000000');
INSERT INTO `t_s_country` VALUES ('2356', '铜梁区', '500151000000', '500100000000');
INSERT INTO `t_s_country` VALUES ('2357', '潼南区', '500152000000', '500100000000');
INSERT INTO `t_s_country` VALUES ('2358', '荣昌区', '500153000000', '500100000000');
INSERT INTO `t_s_country` VALUES ('2359', '开州区', '500154000000', '500100000000');
INSERT INTO `t_s_country` VALUES ('2360', '梁平区', '500155000000', '500100000000');
INSERT INTO `t_s_country` VALUES ('2361', '武隆区', '500156000000', '500100000000');
INSERT INTO `t_s_country` VALUES ('2362', '城口县', '500229000000', '500200000000');
INSERT INTO `t_s_country` VALUES ('2363', '丰都县', '500230000000', '500200000000');
INSERT INTO `t_s_country` VALUES ('2364', '垫江县', '500231000000', '500200000000');
INSERT INTO `t_s_country` VALUES ('2365', '忠县', '500233000000', '500200000000');
INSERT INTO `t_s_country` VALUES ('2366', '云阳县', '500235000000', '500200000000');
INSERT INTO `t_s_country` VALUES ('2367', '奉节县', '500236000000', '500200000000');
INSERT INTO `t_s_country` VALUES ('2368', '巫山县', '500237000000', '500200000000');
INSERT INTO `t_s_country` VALUES ('2369', '巫溪县', '500238000000', '500200000000');
INSERT INTO `t_s_country` VALUES ('2370', '石柱土家族自治县', '500240000000', '500200000000');
INSERT INTO `t_s_country` VALUES ('2371', '秀山土家族苗族自治县', '500241000000', '500200000000');
INSERT INTO `t_s_country` VALUES ('2372', '酉阳土家族苗族自治县', '500242000000', '500200000000');
INSERT INTO `t_s_country` VALUES ('2373', '彭水苗族土家族自治县', '500243000000', '500200000000');
INSERT INTO `t_s_country` VALUES ('2374', '市辖区', '510101000000', '510100000000');
INSERT INTO `t_s_country` VALUES ('2375', '锦江区', '510104000000', '510100000000');
INSERT INTO `t_s_country` VALUES ('2376', '青羊区', '510105000000', '510100000000');
INSERT INTO `t_s_country` VALUES ('2377', '金牛区', '510106000000', '510100000000');
INSERT INTO `t_s_country` VALUES ('2378', '武侯区', '510107000000', '510100000000');
INSERT INTO `t_s_country` VALUES ('2379', '成华区', '510108000000', '510100000000');
INSERT INTO `t_s_country` VALUES ('2380', '龙泉驿区', '510112000000', '510100000000');
INSERT INTO `t_s_country` VALUES ('2381', '青白江区', '510113000000', '510100000000');
INSERT INTO `t_s_country` VALUES ('2382', '新都区', '510114000000', '510100000000');
INSERT INTO `t_s_country` VALUES ('2383', '温江区', '510115000000', '510100000000');
INSERT INTO `t_s_country` VALUES ('2384', '双流区', '510116000000', '510100000000');
INSERT INTO `t_s_country` VALUES ('2385', '郫都区', '510117000000', '510100000000');
INSERT INTO `t_s_country` VALUES ('2386', '金堂县', '510121000000', '510100000000');
INSERT INTO `t_s_country` VALUES ('2387', '大邑县', '510129000000', '510100000000');
INSERT INTO `t_s_country` VALUES ('2388', '蒲江县', '510131000000', '510100000000');
INSERT INTO `t_s_country` VALUES ('2389', '新津县', '510132000000', '510100000000');
INSERT INTO `t_s_country` VALUES ('2390', '都江堰市', '510181000000', '510100000000');
INSERT INTO `t_s_country` VALUES ('2391', '彭州市', '510182000000', '510100000000');
INSERT INTO `t_s_country` VALUES ('2392', '邛崃市', '510183000000', '510100000000');
INSERT INTO `t_s_country` VALUES ('2393', '崇州市', '510184000000', '510100000000');
INSERT INTO `t_s_country` VALUES ('2394', '简阳市', '510185000000', '510100000000');
INSERT INTO `t_s_country` VALUES ('2395', '市辖区', '510301000000', '510300000000');
INSERT INTO `t_s_country` VALUES ('2396', '自流井区', '510302000000', '510300000000');
INSERT INTO `t_s_country` VALUES ('2397', '贡井区', '510303000000', '510300000000');
INSERT INTO `t_s_country` VALUES ('2398', '大安区', '510304000000', '510300000000');
INSERT INTO `t_s_country` VALUES ('2399', '沿滩区', '510311000000', '510300000000');
INSERT INTO `t_s_country` VALUES ('2400', '荣县', '510321000000', '510300000000');
INSERT INTO `t_s_country` VALUES ('2401', '富顺县', '510322000000', '510300000000');
INSERT INTO `t_s_country` VALUES ('2402', '市辖区', '510401000000', '510400000000');
INSERT INTO `t_s_country` VALUES ('2403', '东区', '510402000000', '510400000000');
INSERT INTO `t_s_country` VALUES ('2404', '西区', '510403000000', '510400000000');
INSERT INTO `t_s_country` VALUES ('2405', '仁和区', '510411000000', '510400000000');
INSERT INTO `t_s_country` VALUES ('2406', '米易县', '510421000000', '510400000000');
INSERT INTO `t_s_country` VALUES ('2407', '盐边县', '510422000000', '510400000000');
INSERT INTO `t_s_country` VALUES ('2408', '市辖区', '510501000000', '510500000000');
INSERT INTO `t_s_country` VALUES ('2409', '江阳区', '510502000000', '510500000000');
INSERT INTO `t_s_country` VALUES ('2410', '纳溪区', '510503000000', '510500000000');
INSERT INTO `t_s_country` VALUES ('2411', '龙马潭区', '510504000000', '510500000000');
INSERT INTO `t_s_country` VALUES ('2412', '泸县', '510521000000', '510500000000');
INSERT INTO `t_s_country` VALUES ('2413', '合江县', '510522000000', '510500000000');
INSERT INTO `t_s_country` VALUES ('2414', '叙永县', '510524000000', '510500000000');
INSERT INTO `t_s_country` VALUES ('2415', '古蔺县', '510525000000', '510500000000');
INSERT INTO `t_s_country` VALUES ('2416', '市辖区', '510601000000', '510600000000');
INSERT INTO `t_s_country` VALUES ('2417', '旌阳区', '510603000000', '510600000000');
INSERT INTO `t_s_country` VALUES ('2418', '罗江区', '510604000000', '510600000000');
INSERT INTO `t_s_country` VALUES ('2419', '中江县', '510623000000', '510600000000');
INSERT INTO `t_s_country` VALUES ('2420', '广汉市', '510681000000', '510600000000');
INSERT INTO `t_s_country` VALUES ('2421', '什邡市', '510682000000', '510600000000');
INSERT INTO `t_s_country` VALUES ('2422', '绵竹市', '510683000000', '510600000000');
INSERT INTO `t_s_country` VALUES ('2423', '市辖区', '510701000000', '510700000000');
INSERT INTO `t_s_country` VALUES ('2424', '涪城区', '510703000000', '510700000000');
INSERT INTO `t_s_country` VALUES ('2425', '游仙区', '510704000000', '510700000000');
INSERT INTO `t_s_country` VALUES ('2426', '安州区', '510705000000', '510700000000');
INSERT INTO `t_s_country` VALUES ('2427', '三台县', '510722000000', '510700000000');
INSERT INTO `t_s_country` VALUES ('2428', '盐亭县', '510723000000', '510700000000');
INSERT INTO `t_s_country` VALUES ('2429', '梓潼县', '510725000000', '510700000000');
INSERT INTO `t_s_country` VALUES ('2430', '北川羌族自治县', '510726000000', '510700000000');
INSERT INTO `t_s_country` VALUES ('2431', '平武县', '510727000000', '510700000000');
INSERT INTO `t_s_country` VALUES ('2432', '江油市', '510781000000', '510700000000');
INSERT INTO `t_s_country` VALUES ('2433', '市辖区', '510801000000', '510800000000');
INSERT INTO `t_s_country` VALUES ('2434', '利州区', '510802000000', '510800000000');
INSERT INTO `t_s_country` VALUES ('2435', '昭化区', '510811000000', '510800000000');
INSERT INTO `t_s_country` VALUES ('2436', '朝天区', '510812000000', '510800000000');
INSERT INTO `t_s_country` VALUES ('2437', '旺苍县', '510821000000', '510800000000');
INSERT INTO `t_s_country` VALUES ('2438', '青川县', '510822000000', '510800000000');
INSERT INTO `t_s_country` VALUES ('2439', '剑阁县', '510823000000', '510800000000');
INSERT INTO `t_s_country` VALUES ('2440', '苍溪县', '510824000000', '510800000000');
INSERT INTO `t_s_country` VALUES ('2441', '市辖区', '510901000000', '510900000000');
INSERT INTO `t_s_country` VALUES ('2442', '船山区', '510903000000', '510900000000');
INSERT INTO `t_s_country` VALUES ('2443', '安居区', '510904000000', '510900000000');
INSERT INTO `t_s_country` VALUES ('2444', '蓬溪县', '510921000000', '510900000000');
INSERT INTO `t_s_country` VALUES ('2445', '射洪县', '510922000000', '510900000000');
INSERT INTO `t_s_country` VALUES ('2446', '大英县', '510923000000', '510900000000');
INSERT INTO `t_s_country` VALUES ('2447', '市辖区', '511001000000', '511000000000');
INSERT INTO `t_s_country` VALUES ('2448', '市中区', '511002000000', '511000000000');
INSERT INTO `t_s_country` VALUES ('2449', '东兴区', '511011000000', '511000000000');
INSERT INTO `t_s_country` VALUES ('2450', '威远县', '511024000000', '511000000000');
INSERT INTO `t_s_country` VALUES ('2451', '资中县', '511025000000', '511000000000');
INSERT INTO `t_s_country` VALUES ('2452', '内江经济开发区', '511071000000', '511000000000');
INSERT INTO `t_s_country` VALUES ('2453', '隆昌市', '511083000000', '511000000000');
INSERT INTO `t_s_country` VALUES ('2454', '市辖区', '511101000000', '511100000000');
INSERT INTO `t_s_country` VALUES ('2455', '市中区', '511102000000', '511100000000');
INSERT INTO `t_s_country` VALUES ('2456', '沙湾区', '511111000000', '511100000000');
INSERT INTO `t_s_country` VALUES ('2457', '五通桥区', '511112000000', '511100000000');
INSERT INTO `t_s_country` VALUES ('2458', '金口河区', '511113000000', '511100000000');
INSERT INTO `t_s_country` VALUES ('2459', '犍为县', '511123000000', '511100000000');
INSERT INTO `t_s_country` VALUES ('2460', '井研县', '511124000000', '511100000000');
INSERT INTO `t_s_country` VALUES ('2461', '夹江县', '511126000000', '511100000000');
INSERT INTO `t_s_country` VALUES ('2462', '沐川县', '511129000000', '511100000000');
INSERT INTO `t_s_country` VALUES ('2463', '峨边彝族自治县', '511132000000', '511100000000');
INSERT INTO `t_s_country` VALUES ('2464', '马边彝族自治县', '511133000000', '511100000000');
INSERT INTO `t_s_country` VALUES ('2465', '峨眉山市', '511181000000', '511100000000');
INSERT INTO `t_s_country` VALUES ('2466', '市辖区', '511301000000', '511300000000');
INSERT INTO `t_s_country` VALUES ('2467', '顺庆区', '511302000000', '511300000000');
INSERT INTO `t_s_country` VALUES ('2468', '高坪区', '511303000000', '511300000000');
INSERT INTO `t_s_country` VALUES ('2469', '嘉陵区', '511304000000', '511300000000');
INSERT INTO `t_s_country` VALUES ('2470', '南部县', '511321000000', '511300000000');
INSERT INTO `t_s_country` VALUES ('2471', '营山县', '511322000000', '511300000000');
INSERT INTO `t_s_country` VALUES ('2472', '蓬安县', '511323000000', '511300000000');
INSERT INTO `t_s_country` VALUES ('2473', '仪陇县', '511324000000', '511300000000');
INSERT INTO `t_s_country` VALUES ('2474', '西充县', '511325000000', '511300000000');
INSERT INTO `t_s_country` VALUES ('2475', '阆中市', '511381000000', '511300000000');
INSERT INTO `t_s_country` VALUES ('2476', '市辖区', '511401000000', '511400000000');
INSERT INTO `t_s_country` VALUES ('2477', '东坡区', '511402000000', '511400000000');
INSERT INTO `t_s_country` VALUES ('2478', '彭山区', '511403000000', '511400000000');
INSERT INTO `t_s_country` VALUES ('2479', '仁寿县', '511421000000', '511400000000');
INSERT INTO `t_s_country` VALUES ('2480', '洪雅县', '511423000000', '511400000000');
INSERT INTO `t_s_country` VALUES ('2481', '丹棱县', '511424000000', '511400000000');
INSERT INTO `t_s_country` VALUES ('2482', '青神县', '511425000000', '511400000000');
INSERT INTO `t_s_country` VALUES ('2483', '市辖区', '511501000000', '511500000000');
INSERT INTO `t_s_country` VALUES ('2484', '翠屏区', '511502000000', '511500000000');
INSERT INTO `t_s_country` VALUES ('2485', '南溪区', '511503000000', '511500000000');
INSERT INTO `t_s_country` VALUES ('2486', '叙州区', '511504000000', '511500000000');
INSERT INTO `t_s_country` VALUES ('2487', '江安县', '511523000000', '511500000000');
INSERT INTO `t_s_country` VALUES ('2488', '长宁县', '511524000000', '511500000000');
INSERT INTO `t_s_country` VALUES ('2489', '高县', '511525000000', '511500000000');
INSERT INTO `t_s_country` VALUES ('2490', '珙县', '511526000000', '511500000000');
INSERT INTO `t_s_country` VALUES ('2491', '筠连县', '511527000000', '511500000000');
INSERT INTO `t_s_country` VALUES ('2492', '兴文县', '511528000000', '511500000000');
INSERT INTO `t_s_country` VALUES ('2493', '屏山县', '511529000000', '511500000000');
INSERT INTO `t_s_country` VALUES ('2494', '市辖区', '511601000000', '511600000000');
INSERT INTO `t_s_country` VALUES ('2495', '广安区', '511602000000', '511600000000');
INSERT INTO `t_s_country` VALUES ('2496', '前锋区', '511603000000', '511600000000');
INSERT INTO `t_s_country` VALUES ('2497', '岳池县', '511621000000', '511600000000');
INSERT INTO `t_s_country` VALUES ('2498', '武胜县', '511622000000', '511600000000');
INSERT INTO `t_s_country` VALUES ('2499', '邻水县', '511623000000', '511600000000');
INSERT INTO `t_s_country` VALUES ('2500', '华蓥市', '511681000000', '511600000000');
INSERT INTO `t_s_country` VALUES ('2501', '市辖区', '511701000000', '511700000000');
INSERT INTO `t_s_country` VALUES ('2502', '通川区', '511702000000', '511700000000');
INSERT INTO `t_s_country` VALUES ('2503', '达川区', '511703000000', '511700000000');
INSERT INTO `t_s_country` VALUES ('2504', '宣汉县', '511722000000', '511700000000');
INSERT INTO `t_s_country` VALUES ('2505', '开江县', '511723000000', '511700000000');
INSERT INTO `t_s_country` VALUES ('2506', '大竹县', '511724000000', '511700000000');
INSERT INTO `t_s_country` VALUES ('2507', '渠县', '511725000000', '511700000000');
INSERT INTO `t_s_country` VALUES ('2508', '达州经济开发区', '511771000000', '511700000000');
INSERT INTO `t_s_country` VALUES ('2509', '万源市', '511781000000', '511700000000');
INSERT INTO `t_s_country` VALUES ('2510', '市辖区', '511801000000', '511800000000');
INSERT INTO `t_s_country` VALUES ('2511', '雨城区', '511802000000', '511800000000');
INSERT INTO `t_s_country` VALUES ('2512', '名山区', '511803000000', '511800000000');
INSERT INTO `t_s_country` VALUES ('2513', '荥经县', '511822000000', '511800000000');
INSERT INTO `t_s_country` VALUES ('2514', '汉源县', '511823000000', '511800000000');
INSERT INTO `t_s_country` VALUES ('2515', '石棉县', '511824000000', '511800000000');
INSERT INTO `t_s_country` VALUES ('2516', '天全县', '511825000000', '511800000000');
INSERT INTO `t_s_country` VALUES ('2517', '芦山县', '511826000000', '511800000000');
INSERT INTO `t_s_country` VALUES ('2518', '宝兴县', '511827000000', '511800000000');
INSERT INTO `t_s_country` VALUES ('2519', '市辖区', '511901000000', '511900000000');
INSERT INTO `t_s_country` VALUES ('2520', '巴州区', '511902000000', '511900000000');
INSERT INTO `t_s_country` VALUES ('2521', '恩阳区', '511903000000', '511900000000');
INSERT INTO `t_s_country` VALUES ('2522', '通江县', '511921000000', '511900000000');
INSERT INTO `t_s_country` VALUES ('2523', '南江县', '511922000000', '511900000000');
INSERT INTO `t_s_country` VALUES ('2524', '平昌县', '511923000000', '511900000000');
INSERT INTO `t_s_country` VALUES ('2525', '巴中经济开发区', '511971000000', '511900000000');
INSERT INTO `t_s_country` VALUES ('2526', '市辖区', '512001000000', '512000000000');
INSERT INTO `t_s_country` VALUES ('2527', '雁江区', '512002000000', '512000000000');
INSERT INTO `t_s_country` VALUES ('2528', '安岳县', '512021000000', '512000000000');
INSERT INTO `t_s_country` VALUES ('2529', '乐至县', '512022000000', '512000000000');
INSERT INTO `t_s_country` VALUES ('2530', '马尔康市', '513201000000', '513200000000');
INSERT INTO `t_s_country` VALUES ('2531', '汶川县', '513221000000', '513200000000');
INSERT INTO `t_s_country` VALUES ('2532', '理县', '513222000000', '513200000000');
INSERT INTO `t_s_country` VALUES ('2533', '茂县', '513223000000', '513200000000');
INSERT INTO `t_s_country` VALUES ('2534', '松潘县', '513224000000', '513200000000');
INSERT INTO `t_s_country` VALUES ('2535', '九寨沟县', '513225000000', '513200000000');
INSERT INTO `t_s_country` VALUES ('2536', '金川县', '513226000000', '513200000000');
INSERT INTO `t_s_country` VALUES ('2537', '小金县', '513227000000', '513200000000');
INSERT INTO `t_s_country` VALUES ('2538', '黑水县', '513228000000', '513200000000');
INSERT INTO `t_s_country` VALUES ('2539', '壤塘县', '513230000000', '513200000000');
INSERT INTO `t_s_country` VALUES ('2540', '阿坝县', '513231000000', '513200000000');
INSERT INTO `t_s_country` VALUES ('2541', '若尔盖县', '513232000000', '513200000000');
INSERT INTO `t_s_country` VALUES ('2542', '红原县', '513233000000', '513200000000');
INSERT INTO `t_s_country` VALUES ('2543', '康定市', '513301000000', '513300000000');
INSERT INTO `t_s_country` VALUES ('2544', '泸定县', '513322000000', '513300000000');
INSERT INTO `t_s_country` VALUES ('2545', '丹巴县', '513323000000', '513300000000');
INSERT INTO `t_s_country` VALUES ('2546', '九龙县', '513324000000', '513300000000');
INSERT INTO `t_s_country` VALUES ('2547', '雅江县', '513325000000', '513300000000');
INSERT INTO `t_s_country` VALUES ('2548', '道孚县', '513326000000', '513300000000');
INSERT INTO `t_s_country` VALUES ('2549', '炉霍县', '513327000000', '513300000000');
INSERT INTO `t_s_country` VALUES ('2550', '甘孜县', '513328000000', '513300000000');
INSERT INTO `t_s_country` VALUES ('2551', '新龙县', '513329000000', '513300000000');
INSERT INTO `t_s_country` VALUES ('2552', '德格县', '513330000000', '513300000000');
INSERT INTO `t_s_country` VALUES ('2553', '白玉县', '513331000000', '513300000000');
INSERT INTO `t_s_country` VALUES ('2554', '石渠县', '513332000000', '513300000000');
INSERT INTO `t_s_country` VALUES ('2555', '色达县', '513333000000', '513300000000');
INSERT INTO `t_s_country` VALUES ('2556', '理塘县', '513334000000', '513300000000');
INSERT INTO `t_s_country` VALUES ('2557', '巴塘县', '513335000000', '513300000000');
INSERT INTO `t_s_country` VALUES ('2558', '乡城县', '513336000000', '513300000000');
INSERT INTO `t_s_country` VALUES ('2559', '稻城县', '513337000000', '513300000000');
INSERT INTO `t_s_country` VALUES ('2560', '得荣县', '513338000000', '513300000000');
INSERT INTO `t_s_country` VALUES ('2561', '西昌市', '513401000000', '513400000000');
INSERT INTO `t_s_country` VALUES ('2562', '木里藏族自治县', '513422000000', '513400000000');
INSERT INTO `t_s_country` VALUES ('2563', '盐源县', '513423000000', '513400000000');
INSERT INTO `t_s_country` VALUES ('2564', '德昌县', '513424000000', '513400000000');
INSERT INTO `t_s_country` VALUES ('2565', '会理县', '513425000000', '513400000000');
INSERT INTO `t_s_country` VALUES ('2566', '会东县', '513426000000', '513400000000');
INSERT INTO `t_s_country` VALUES ('2567', '宁南县', '513427000000', '513400000000');
INSERT INTO `t_s_country` VALUES ('2568', '普格县', '513428000000', '513400000000');
INSERT INTO `t_s_country` VALUES ('2569', '布拖县', '513429000000', '513400000000');
INSERT INTO `t_s_country` VALUES ('2570', '金阳县', '513430000000', '513400000000');
INSERT INTO `t_s_country` VALUES ('2571', '昭觉县', '513431000000', '513400000000');
INSERT INTO `t_s_country` VALUES ('2572', '喜德县', '513432000000', '513400000000');
INSERT INTO `t_s_country` VALUES ('2573', '冕宁县', '513433000000', '513400000000');
INSERT INTO `t_s_country` VALUES ('2574', '越西县', '513434000000', '513400000000');
INSERT INTO `t_s_country` VALUES ('2575', '甘洛县', '513435000000', '513400000000');
INSERT INTO `t_s_country` VALUES ('2576', '美姑县', '513436000000', '513400000000');
INSERT INTO `t_s_country` VALUES ('2577', '雷波县', '513437000000', '513400000000');
INSERT INTO `t_s_country` VALUES ('2578', '市辖区', '520101000000', '520100000000');
INSERT INTO `t_s_country` VALUES ('2579', '南明区', '520102000000', '520100000000');
INSERT INTO `t_s_country` VALUES ('2580', '云岩区', '520103000000', '520100000000');
INSERT INTO `t_s_country` VALUES ('2581', '花溪区', '520111000000', '520100000000');
INSERT INTO `t_s_country` VALUES ('2582', '乌当区', '520112000000', '520100000000');
INSERT INTO `t_s_country` VALUES ('2583', '白云区', '520113000000', '520100000000');
INSERT INTO `t_s_country` VALUES ('2584', '观山湖区', '520115000000', '520100000000');
INSERT INTO `t_s_country` VALUES ('2585', '开阳县', '520121000000', '520100000000');
INSERT INTO `t_s_country` VALUES ('2586', '息烽县', '520122000000', '520100000000');
INSERT INTO `t_s_country` VALUES ('2587', '修文县', '520123000000', '520100000000');
INSERT INTO `t_s_country` VALUES ('2588', '清镇市', '520181000000', '520100000000');
INSERT INTO `t_s_country` VALUES ('2589', '钟山区', '520201000000', '520200000000');
INSERT INTO `t_s_country` VALUES ('2590', '六枝特区', '520203000000', '520200000000');
INSERT INTO `t_s_country` VALUES ('2591', '水城县', '520221000000', '520200000000');
INSERT INTO `t_s_country` VALUES ('2592', '盘州市', '520281000000', '520200000000');
INSERT INTO `t_s_country` VALUES ('2593', '市辖区', '520301000000', '520300000000');
INSERT INTO `t_s_country` VALUES ('2594', '红花岗区', '520302000000', '520300000000');
INSERT INTO `t_s_country` VALUES ('2595', '汇川区', '520303000000', '520300000000');
INSERT INTO `t_s_country` VALUES ('2596', '播州区', '520304000000', '520300000000');
INSERT INTO `t_s_country` VALUES ('2597', '桐梓县', '520322000000', '520300000000');
INSERT INTO `t_s_country` VALUES ('2598', '绥阳县', '520323000000', '520300000000');
INSERT INTO `t_s_country` VALUES ('2599', '正安县', '520324000000', '520300000000');
INSERT INTO `t_s_country` VALUES ('2600', '道真仡佬族苗族自治县', '520325000000', '520300000000');
INSERT INTO `t_s_country` VALUES ('2601', '务川仡佬族苗族自治县', '520326000000', '520300000000');
INSERT INTO `t_s_country` VALUES ('2602', '凤冈县', '520327000000', '520300000000');
INSERT INTO `t_s_country` VALUES ('2603', '湄潭县', '520328000000', '520300000000');
INSERT INTO `t_s_country` VALUES ('2604', '余庆县', '520329000000', '520300000000');
INSERT INTO `t_s_country` VALUES ('2605', '习水县', '520330000000', '520300000000');
INSERT INTO `t_s_country` VALUES ('2606', '赤水市', '520381000000', '520300000000');
INSERT INTO `t_s_country` VALUES ('2607', '仁怀市', '520382000000', '520300000000');
INSERT INTO `t_s_country` VALUES ('2608', '市辖区', '520401000000', '520400000000');
INSERT INTO `t_s_country` VALUES ('2609', '西秀区', '520402000000', '520400000000');
INSERT INTO `t_s_country` VALUES ('2610', '平坝区', '520403000000', '520400000000');
INSERT INTO `t_s_country` VALUES ('2611', '普定县', '520422000000', '520400000000');
INSERT INTO `t_s_country` VALUES ('2612', '镇宁布依族苗族自治县', '520423000000', '520400000000');
INSERT INTO `t_s_country` VALUES ('2613', '关岭布依族苗族自治县', '520424000000', '520400000000');
INSERT INTO `t_s_country` VALUES ('2614', '紫云苗族布依族自治县', '520425000000', '520400000000');
INSERT INTO `t_s_country` VALUES ('2615', '市辖区', '520501000000', '520500000000');
INSERT INTO `t_s_country` VALUES ('2616', '七星关区', '520502000000', '520500000000');
INSERT INTO `t_s_country` VALUES ('2617', '大方县', '520521000000', '520500000000');
INSERT INTO `t_s_country` VALUES ('2618', '黔西县', '520522000000', '520500000000');
INSERT INTO `t_s_country` VALUES ('2619', '金沙县', '520523000000', '520500000000');
INSERT INTO `t_s_country` VALUES ('2620', '织金县', '520524000000', '520500000000');
INSERT INTO `t_s_country` VALUES ('2621', '纳雍县', '520525000000', '520500000000');
INSERT INTO `t_s_country` VALUES ('2622', '威宁彝族回族苗族自治县', '520526000000', '520500000000');
INSERT INTO `t_s_country` VALUES ('2623', '赫章县', '520527000000', '520500000000');
INSERT INTO `t_s_country` VALUES ('2624', '市辖区', '520601000000', '520600000000');
INSERT INTO `t_s_country` VALUES ('2625', '碧江区', '520602000000', '520600000000');
INSERT INTO `t_s_country` VALUES ('2626', '万山区', '520603000000', '520600000000');
INSERT INTO `t_s_country` VALUES ('2627', '江口县', '520621000000', '520600000000');
INSERT INTO `t_s_country` VALUES ('2628', '玉屏侗族自治县', '520622000000', '520600000000');
INSERT INTO `t_s_country` VALUES ('2629', '石阡县', '520623000000', '520600000000');
INSERT INTO `t_s_country` VALUES ('2630', '思南县', '520624000000', '520600000000');
INSERT INTO `t_s_country` VALUES ('2631', '印江土家族苗族自治县', '520625000000', '520600000000');
INSERT INTO `t_s_country` VALUES ('2632', '德江县', '520626000000', '520600000000');
INSERT INTO `t_s_country` VALUES ('2633', '沿河土家族自治县', '520627000000', '520600000000');
INSERT INTO `t_s_country` VALUES ('2634', '松桃苗族自治县', '520628000000', '520600000000');
INSERT INTO `t_s_country` VALUES ('2635', '兴义市', '522301000000', '522300000000');
INSERT INTO `t_s_country` VALUES ('2636', '兴仁市', '522302000000', '522300000000');
INSERT INTO `t_s_country` VALUES ('2637', '普安县', '522323000000', '522300000000');
INSERT INTO `t_s_country` VALUES ('2638', '晴隆县', '522324000000', '522300000000');
INSERT INTO `t_s_country` VALUES ('2639', '贞丰县', '522325000000', '522300000000');
INSERT INTO `t_s_country` VALUES ('2640', '望谟县', '522326000000', '522300000000');
INSERT INTO `t_s_country` VALUES ('2641', '册亨县', '522327000000', '522300000000');
INSERT INTO `t_s_country` VALUES ('2642', '安龙县', '522328000000', '522300000000');
INSERT INTO `t_s_country` VALUES ('2643', '凯里市', '522601000000', '522600000000');
INSERT INTO `t_s_country` VALUES ('2644', '黄平县', '522622000000', '522600000000');
INSERT INTO `t_s_country` VALUES ('2645', '施秉县', '522623000000', '522600000000');
INSERT INTO `t_s_country` VALUES ('2646', '三穗县', '522624000000', '522600000000');
INSERT INTO `t_s_country` VALUES ('2647', '镇远县', '522625000000', '522600000000');
INSERT INTO `t_s_country` VALUES ('2648', '岑巩县', '522626000000', '522600000000');
INSERT INTO `t_s_country` VALUES ('2649', '天柱县', '522627000000', '522600000000');
INSERT INTO `t_s_country` VALUES ('2650', '锦屏县', '522628000000', '522600000000');
INSERT INTO `t_s_country` VALUES ('2651', '剑河县', '522629000000', '522600000000');
INSERT INTO `t_s_country` VALUES ('2652', '台江县', '522630000000', '522600000000');
INSERT INTO `t_s_country` VALUES ('2653', '黎平县', '522631000000', '522600000000');
INSERT INTO `t_s_country` VALUES ('2654', '榕江县', '522632000000', '522600000000');
INSERT INTO `t_s_country` VALUES ('2655', '从江县', '522633000000', '522600000000');
INSERT INTO `t_s_country` VALUES ('2656', '雷山县', '522634000000', '522600000000');
INSERT INTO `t_s_country` VALUES ('2657', '麻江县', '522635000000', '522600000000');
INSERT INTO `t_s_country` VALUES ('2658', '丹寨县', '522636000000', '522600000000');
INSERT INTO `t_s_country` VALUES ('2659', '都匀市', '522701000000', '522700000000');
INSERT INTO `t_s_country` VALUES ('2660', '福泉市', '522702000000', '522700000000');
INSERT INTO `t_s_country` VALUES ('2661', '荔波县', '522722000000', '522700000000');
INSERT INTO `t_s_country` VALUES ('2662', '贵定县', '522723000000', '522700000000');
INSERT INTO `t_s_country` VALUES ('2663', '瓮安县', '522725000000', '522700000000');
INSERT INTO `t_s_country` VALUES ('2664', '独山县', '522726000000', '522700000000');
INSERT INTO `t_s_country` VALUES ('2665', '平塘县', '522727000000', '522700000000');
INSERT INTO `t_s_country` VALUES ('2666', '罗甸县', '522728000000', '522700000000');
INSERT INTO `t_s_country` VALUES ('2667', '长顺县', '522729000000', '522700000000');
INSERT INTO `t_s_country` VALUES ('2668', '龙里县', '522730000000', '522700000000');
INSERT INTO `t_s_country` VALUES ('2669', '惠水县', '522731000000', '522700000000');
INSERT INTO `t_s_country` VALUES ('2670', '三都水族自治县', '522732000000', '522700000000');
INSERT INTO `t_s_country` VALUES ('2671', '市辖区', '530101000000', '530100000000');
INSERT INTO `t_s_country` VALUES ('2672', '五华区', '530102000000', '530100000000');
INSERT INTO `t_s_country` VALUES ('2673', '盘龙区', '530103000000', '530100000000');
INSERT INTO `t_s_country` VALUES ('2674', '官渡区', '530111000000', '530100000000');
INSERT INTO `t_s_country` VALUES ('2675', '西山区', '530112000000', '530100000000');
INSERT INTO `t_s_country` VALUES ('2676', '东川区', '530113000000', '530100000000');
INSERT INTO `t_s_country` VALUES ('2677', '呈贡区', '530114000000', '530100000000');
INSERT INTO `t_s_country` VALUES ('2678', '晋宁区', '530115000000', '530100000000');
INSERT INTO `t_s_country` VALUES ('2679', '富民县', '530124000000', '530100000000');
INSERT INTO `t_s_country` VALUES ('2680', '宜良县', '530125000000', '530100000000');
INSERT INTO `t_s_country` VALUES ('2681', '石林彝族自治县', '530126000000', '530100000000');
INSERT INTO `t_s_country` VALUES ('2682', '嵩明县', '530127000000', '530100000000');
INSERT INTO `t_s_country` VALUES ('2683', '禄劝彝族苗族自治县', '530128000000', '530100000000');
INSERT INTO `t_s_country` VALUES ('2684', '寻甸回族彝族自治县', '530129000000', '530100000000');
INSERT INTO `t_s_country` VALUES ('2685', '安宁市', '530181000000', '530100000000');
INSERT INTO `t_s_country` VALUES ('2686', '市辖区', '530301000000', '530300000000');
INSERT INTO `t_s_country` VALUES ('2687', '麒麟区', '530302000000', '530300000000');
INSERT INTO `t_s_country` VALUES ('2688', '沾益区', '530303000000', '530300000000');
INSERT INTO `t_s_country` VALUES ('2689', '马龙区', '530304000000', '530300000000');
INSERT INTO `t_s_country` VALUES ('2690', '陆良县', '530322000000', '530300000000');
INSERT INTO `t_s_country` VALUES ('2691', '师宗县', '530323000000', '530300000000');
INSERT INTO `t_s_country` VALUES ('2692', '罗平县', '530324000000', '530300000000');
INSERT INTO `t_s_country` VALUES ('2693', '富源县', '530325000000', '530300000000');
INSERT INTO `t_s_country` VALUES ('2694', '会泽县', '530326000000', '530300000000');
INSERT INTO `t_s_country` VALUES ('2695', '宣威市', '530381000000', '530300000000');
INSERT INTO `t_s_country` VALUES ('2696', '市辖区', '530401000000', '530400000000');
INSERT INTO `t_s_country` VALUES ('2697', '红塔区', '530402000000', '530400000000');
INSERT INTO `t_s_country` VALUES ('2698', '江川区', '530403000000', '530400000000');
INSERT INTO `t_s_country` VALUES ('2699', '澄江县', '530422000000', '530400000000');
INSERT INTO `t_s_country` VALUES ('2700', '通海县', '530423000000', '530400000000');
INSERT INTO `t_s_country` VALUES ('2701', '华宁县', '530424000000', '530400000000');
INSERT INTO `t_s_country` VALUES ('2702', '易门县', '530425000000', '530400000000');
INSERT INTO `t_s_country` VALUES ('2703', '峨山彝族自治县', '530426000000', '530400000000');
INSERT INTO `t_s_country` VALUES ('2704', '新平彝族傣族自治县', '530427000000', '530400000000');
INSERT INTO `t_s_country` VALUES ('2705', '元江哈尼族彝族傣族自治县', '530428000000', '530400000000');
INSERT INTO `t_s_country` VALUES ('2706', '市辖区', '530501000000', '530500000000');
INSERT INTO `t_s_country` VALUES ('2707', '隆阳区', '530502000000', '530500000000');
INSERT INTO `t_s_country` VALUES ('2708', '施甸县', '530521000000', '530500000000');
INSERT INTO `t_s_country` VALUES ('2709', '龙陵县', '530523000000', '530500000000');
INSERT INTO `t_s_country` VALUES ('2710', '昌宁县', '530524000000', '530500000000');
INSERT INTO `t_s_country` VALUES ('2711', '腾冲市', '530581000000', '530500000000');
INSERT INTO `t_s_country` VALUES ('2712', '市辖区', '530601000000', '530600000000');
INSERT INTO `t_s_country` VALUES ('2713', '昭阳区', '530602000000', '530600000000');
INSERT INTO `t_s_country` VALUES ('2714', '鲁甸县', '530621000000', '530600000000');
INSERT INTO `t_s_country` VALUES ('2715', '巧家县', '530622000000', '530600000000');
INSERT INTO `t_s_country` VALUES ('2716', '盐津县', '530623000000', '530600000000');
INSERT INTO `t_s_country` VALUES ('2717', '大关县', '530624000000', '530600000000');
INSERT INTO `t_s_country` VALUES ('2718', '永善县', '530625000000', '530600000000');
INSERT INTO `t_s_country` VALUES ('2719', '绥江县', '530626000000', '530600000000');
INSERT INTO `t_s_country` VALUES ('2720', '镇雄县', '530627000000', '530600000000');
INSERT INTO `t_s_country` VALUES ('2721', '彝良县', '530628000000', '530600000000');
INSERT INTO `t_s_country` VALUES ('2722', '威信县', '530629000000', '530600000000');
INSERT INTO `t_s_country` VALUES ('2723', '水富市', '530681000000', '530600000000');
INSERT INTO `t_s_country` VALUES ('2724', '市辖区', '530701000000', '530700000000');
INSERT INTO `t_s_country` VALUES ('2725', '古城区', '530702000000', '530700000000');
INSERT INTO `t_s_country` VALUES ('2726', '玉龙纳西族自治县', '530721000000', '530700000000');
INSERT INTO `t_s_country` VALUES ('2727', '永胜县', '530722000000', '530700000000');
INSERT INTO `t_s_country` VALUES ('2728', '华坪县', '530723000000', '530700000000');
INSERT INTO `t_s_country` VALUES ('2729', '宁蒗彝族自治县', '530724000000', '530700000000');
INSERT INTO `t_s_country` VALUES ('2730', '市辖区', '530801000000', '530800000000');
INSERT INTO `t_s_country` VALUES ('2731', '思茅区', '530802000000', '530800000000');
INSERT INTO `t_s_country` VALUES ('2732', '宁洱哈尼族彝族自治县', '530821000000', '530800000000');
INSERT INTO `t_s_country` VALUES ('2733', '墨江哈尼族自治县', '530822000000', '530800000000');
INSERT INTO `t_s_country` VALUES ('2734', '景东彝族自治县', '530823000000', '530800000000');
INSERT INTO `t_s_country` VALUES ('2735', '景谷傣族彝族自治县', '530824000000', '530800000000');
INSERT INTO `t_s_country` VALUES ('2736', '镇沅彝族哈尼族拉祜族自治县', '530825000000', '530800000000');
INSERT INTO `t_s_country` VALUES ('2737', '江城哈尼族彝族自治县', '530826000000', '530800000000');
INSERT INTO `t_s_country` VALUES ('2738', '孟连傣族拉祜族佤族自治县', '530827000000', '530800000000');
INSERT INTO `t_s_country` VALUES ('2739', '澜沧拉祜族自治县', '530828000000', '530800000000');
INSERT INTO `t_s_country` VALUES ('2740', '西盟佤族自治县', '530829000000', '530800000000');
INSERT INTO `t_s_country` VALUES ('2741', '市辖区', '530901000000', '530900000000');
INSERT INTO `t_s_country` VALUES ('2742', '临翔区', '530902000000', '530900000000');
INSERT INTO `t_s_country` VALUES ('2743', '凤庆县', '530921000000', '530900000000');
INSERT INTO `t_s_country` VALUES ('2744', '云县', '530922000000', '530900000000');
INSERT INTO `t_s_country` VALUES ('2745', '永德县', '530923000000', '530900000000');
INSERT INTO `t_s_country` VALUES ('2746', '镇康县', '530924000000', '530900000000');
INSERT INTO `t_s_country` VALUES ('2747', '双江拉祜族佤族布朗族傣族自治县', '530925000000', '530900000000');
INSERT INTO `t_s_country` VALUES ('2748', '耿马傣族佤族自治县', '530926000000', '530900000000');
INSERT INTO `t_s_country` VALUES ('2749', '沧源佤族自治县', '530927000000', '530900000000');
INSERT INTO `t_s_country` VALUES ('2750', '楚雄市', '532301000000', '532300000000');
INSERT INTO `t_s_country` VALUES ('2751', '双柏县', '532322000000', '532300000000');
INSERT INTO `t_s_country` VALUES ('2752', '牟定县', '532323000000', '532300000000');
INSERT INTO `t_s_country` VALUES ('2753', '南华县', '532324000000', '532300000000');
INSERT INTO `t_s_country` VALUES ('2754', '姚安县', '532325000000', '532300000000');
INSERT INTO `t_s_country` VALUES ('2755', '大姚县', '532326000000', '532300000000');
INSERT INTO `t_s_country` VALUES ('2756', '永仁县', '532327000000', '532300000000');
INSERT INTO `t_s_country` VALUES ('2757', '元谋县', '532328000000', '532300000000');
INSERT INTO `t_s_country` VALUES ('2758', '武定县', '532329000000', '532300000000');
INSERT INTO `t_s_country` VALUES ('2759', '禄丰县', '532331000000', '532300000000');
INSERT INTO `t_s_country` VALUES ('2760', '个旧市', '532501000000', '532500000000');
INSERT INTO `t_s_country` VALUES ('2761', '开远市', '532502000000', '532500000000');
INSERT INTO `t_s_country` VALUES ('2762', '蒙自市', '532503000000', '532500000000');
INSERT INTO `t_s_country` VALUES ('2763', '弥勒市', '532504000000', '532500000000');
INSERT INTO `t_s_country` VALUES ('2764', '屏边苗族自治县', '532523000000', '532500000000');
INSERT INTO `t_s_country` VALUES ('2765', '建水县', '532524000000', '532500000000');
INSERT INTO `t_s_country` VALUES ('2766', '石屏县', '532525000000', '532500000000');
INSERT INTO `t_s_country` VALUES ('2767', '泸西县', '532527000000', '532500000000');
INSERT INTO `t_s_country` VALUES ('2768', '元阳县', '532528000000', '532500000000');
INSERT INTO `t_s_country` VALUES ('2769', '红河县', '532529000000', '532500000000');
INSERT INTO `t_s_country` VALUES ('2770', '金平苗族瑶族傣族自治县', '532530000000', '532500000000');
INSERT INTO `t_s_country` VALUES ('2771', '绿春县', '532531000000', '532500000000');
INSERT INTO `t_s_country` VALUES ('2772', '河口瑶族自治县', '532532000000', '532500000000');
INSERT INTO `t_s_country` VALUES ('2773', '文山市', '532601000000', '532600000000');
INSERT INTO `t_s_country` VALUES ('2774', '砚山县', '532622000000', '532600000000');
INSERT INTO `t_s_country` VALUES ('2775', '西畴县', '532623000000', '532600000000');
INSERT INTO `t_s_country` VALUES ('2776', '麻栗坡县', '532624000000', '532600000000');
INSERT INTO `t_s_country` VALUES ('2777', '马关县', '532625000000', '532600000000');
INSERT INTO `t_s_country` VALUES ('2778', '丘北县', '532626000000', '532600000000');
INSERT INTO `t_s_country` VALUES ('2779', '广南县', '532627000000', '532600000000');
INSERT INTO `t_s_country` VALUES ('2780', '富宁县', '532628000000', '532600000000');
INSERT INTO `t_s_country` VALUES ('2781', '景洪市', '532801000000', '532800000000');
INSERT INTO `t_s_country` VALUES ('2782', '勐海县', '532822000000', '532800000000');
INSERT INTO `t_s_country` VALUES ('2783', '勐腊县', '532823000000', '532800000000');
INSERT INTO `t_s_country` VALUES ('2784', '大理市', '532901000000', '532900000000');
INSERT INTO `t_s_country` VALUES ('2785', '漾濞彝族自治县', '532922000000', '532900000000');
INSERT INTO `t_s_country` VALUES ('2786', '祥云县', '532923000000', '532900000000');
INSERT INTO `t_s_country` VALUES ('2787', '宾川县', '532924000000', '532900000000');
INSERT INTO `t_s_country` VALUES ('2788', '弥渡县', '532925000000', '532900000000');
INSERT INTO `t_s_country` VALUES ('2789', '南涧彝族自治县', '532926000000', '532900000000');
INSERT INTO `t_s_country` VALUES ('2790', '巍山彝族回族自治县', '532927000000', '532900000000');
INSERT INTO `t_s_country` VALUES ('2791', '永平县', '532928000000', '532900000000');
INSERT INTO `t_s_country` VALUES ('2792', '云龙县', '532929000000', '532900000000');
INSERT INTO `t_s_country` VALUES ('2793', '洱源县', '532930000000', '532900000000');
INSERT INTO `t_s_country` VALUES ('2794', '剑川县', '532931000000', '532900000000');
INSERT INTO `t_s_country` VALUES ('2795', '鹤庆县', '532932000000', '532900000000');
INSERT INTO `t_s_country` VALUES ('2796', '瑞丽市', '533102000000', '533100000000');
INSERT INTO `t_s_country` VALUES ('2797', '芒市', '533103000000', '533100000000');
INSERT INTO `t_s_country` VALUES ('2798', '梁河县', '533122000000', '533100000000');
INSERT INTO `t_s_country` VALUES ('2799', '盈江县', '533123000000', '533100000000');
INSERT INTO `t_s_country` VALUES ('2800', '陇川县', '533124000000', '533100000000');
INSERT INTO `t_s_country` VALUES ('2801', '泸水市', '533301000000', '533300000000');
INSERT INTO `t_s_country` VALUES ('2802', '福贡县', '533323000000', '533300000000');
INSERT INTO `t_s_country` VALUES ('2803', '贡山独龙族怒族自治县', '533324000000', '533300000000');
INSERT INTO `t_s_country` VALUES ('2804', '兰坪白族普米族自治县', '533325000000', '533300000000');
INSERT INTO `t_s_country` VALUES ('2805', '香格里拉市', '533401000000', '533400000000');
INSERT INTO `t_s_country` VALUES ('2806', '德钦县', '533422000000', '533400000000');
INSERT INTO `t_s_country` VALUES ('2807', '维西傈僳族自治县', '533423000000', '533400000000');
INSERT INTO `t_s_country` VALUES ('2808', '市辖区', '540101000000', '540100000000');
INSERT INTO `t_s_country` VALUES ('2809', '城关区', '540102000000', '540100000000');
INSERT INTO `t_s_country` VALUES ('2810', '堆龙德庆区', '540103000000', '540100000000');
INSERT INTO `t_s_country` VALUES ('2811', '达孜区', '540104000000', '540100000000');
INSERT INTO `t_s_country` VALUES ('2812', '林周县', '540121000000', '540100000000');
INSERT INTO `t_s_country` VALUES ('2813', '当雄县', '540122000000', '540100000000');
INSERT INTO `t_s_country` VALUES ('2814', '尼木县', '540123000000', '540100000000');
INSERT INTO `t_s_country` VALUES ('2815', '曲水县', '540124000000', '540100000000');
INSERT INTO `t_s_country` VALUES ('2816', '墨竹工卡县', '540127000000', '540100000000');
INSERT INTO `t_s_country` VALUES ('2817', '格尔木藏青工业园区', '540171000000', '540100000000');
INSERT INTO `t_s_country` VALUES ('2818', '拉萨经济技术开发区', '540172000000', '540100000000');
INSERT INTO `t_s_country` VALUES ('2819', '西藏文化旅游创意园区', '540173000000', '540100000000');
INSERT INTO `t_s_country` VALUES ('2820', '达孜工业园区', '540174000000', '540100000000');
INSERT INTO `t_s_country` VALUES ('2821', '桑珠孜区', '540202000000', '540200000000');
INSERT INTO `t_s_country` VALUES ('2822', '南木林县', '540221000000', '540200000000');
INSERT INTO `t_s_country` VALUES ('2823', '江孜县', '540222000000', '540200000000');
INSERT INTO `t_s_country` VALUES ('2824', '定日县', '540223000000', '540200000000');
INSERT INTO `t_s_country` VALUES ('2825', '萨迦县', '540224000000', '540200000000');
INSERT INTO `t_s_country` VALUES ('2826', '拉孜县', '540225000000', '540200000000');
INSERT INTO `t_s_country` VALUES ('2827', '昂仁县', '540226000000', '540200000000');
INSERT INTO `t_s_country` VALUES ('2828', '谢通门县', '540227000000', '540200000000');
INSERT INTO `t_s_country` VALUES ('2829', '白朗县', '540228000000', '540200000000');
INSERT INTO `t_s_country` VALUES ('2830', '仁布县', '540229000000', '540200000000');
INSERT INTO `t_s_country` VALUES ('2831', '康马县', '540230000000', '540200000000');
INSERT INTO `t_s_country` VALUES ('2832', '定结县', '540231000000', '540200000000');
INSERT INTO `t_s_country` VALUES ('2833', '仲巴县', '540232000000', '540200000000');
INSERT INTO `t_s_country` VALUES ('2834', '亚东县', '540233000000', '540200000000');
INSERT INTO `t_s_country` VALUES ('2835', '吉隆县', '540234000000', '540200000000');
INSERT INTO `t_s_country` VALUES ('2836', '聂拉木县', '540235000000', '540200000000');
INSERT INTO `t_s_country` VALUES ('2837', '萨嘎县', '540236000000', '540200000000');
INSERT INTO `t_s_country` VALUES ('2838', '岗巴县', '540237000000', '540200000000');
INSERT INTO `t_s_country` VALUES ('2839', '卡若区', '540302000000', '540300000000');
INSERT INTO `t_s_country` VALUES ('2840', '江达县', '540321000000', '540300000000');
INSERT INTO `t_s_country` VALUES ('2841', '贡觉县', '540322000000', '540300000000');
INSERT INTO `t_s_country` VALUES ('2842', '类乌齐县', '540323000000', '540300000000');
INSERT INTO `t_s_country` VALUES ('2843', '丁青县', '540324000000', '540300000000');
INSERT INTO `t_s_country` VALUES ('2844', '察雅县', '540325000000', '540300000000');
INSERT INTO `t_s_country` VALUES ('2845', '八宿县', '540326000000', '540300000000');
INSERT INTO `t_s_country` VALUES ('2846', '左贡县', '540327000000', '540300000000');
INSERT INTO `t_s_country` VALUES ('2847', '芒康县', '540328000000', '540300000000');
INSERT INTO `t_s_country` VALUES ('2848', '洛隆县', '540329000000', '540300000000');
INSERT INTO `t_s_country` VALUES ('2849', '边坝县', '540330000000', '540300000000');
INSERT INTO `t_s_country` VALUES ('2850', '巴宜区', '540402000000', '540400000000');
INSERT INTO `t_s_country` VALUES ('2851', '工布江达县', '540421000000', '540400000000');
INSERT INTO `t_s_country` VALUES ('2852', '米林县', '540422000000', '540400000000');
INSERT INTO `t_s_country` VALUES ('2853', '墨脱县', '540423000000', '540400000000');
INSERT INTO `t_s_country` VALUES ('2854', '波密县', '540424000000', '540400000000');
INSERT INTO `t_s_country` VALUES ('2855', '察隅县', '540425000000', '540400000000');
INSERT INTO `t_s_country` VALUES ('2856', '朗县', '540426000000', '540400000000');
INSERT INTO `t_s_country` VALUES ('2857', '市辖区', '540501000000', '540500000000');
INSERT INTO `t_s_country` VALUES ('2858', '乃东区', '540502000000', '540500000000');
INSERT INTO `t_s_country` VALUES ('2859', '扎囊县', '540521000000', '540500000000');
INSERT INTO `t_s_country` VALUES ('2860', '贡嘎县', '540522000000', '540500000000');
INSERT INTO `t_s_country` VALUES ('2861', '桑日县', '540523000000', '540500000000');
INSERT INTO `t_s_country` VALUES ('2862', '琼结县', '540524000000', '540500000000');
INSERT INTO `t_s_country` VALUES ('2863', '曲松县', '540525000000', '540500000000');
INSERT INTO `t_s_country` VALUES ('2864', '措美县', '540526000000', '540500000000');
INSERT INTO `t_s_country` VALUES ('2865', '洛扎县', '540527000000', '540500000000');
INSERT INTO `t_s_country` VALUES ('2866', '加查县', '540528000000', '540500000000');
INSERT INTO `t_s_country` VALUES ('2867', '隆子县', '540529000000', '540500000000');
INSERT INTO `t_s_country` VALUES ('2868', '错那县', '540530000000', '540500000000');
INSERT INTO `t_s_country` VALUES ('2869', '浪卡子县', '540531000000', '540500000000');
INSERT INTO `t_s_country` VALUES ('2870', '色尼区', '540602000000', '540600000000');
INSERT INTO `t_s_country` VALUES ('2871', '嘉黎县', '540621000000', '540600000000');
INSERT INTO `t_s_country` VALUES ('2872', '比如县', '540622000000', '540600000000');
INSERT INTO `t_s_country` VALUES ('2873', '聂荣县', '540623000000', '540600000000');
INSERT INTO `t_s_country` VALUES ('2874', '安多县', '540624000000', '540600000000');
INSERT INTO `t_s_country` VALUES ('2875', '申扎县', '540625000000', '540600000000');
INSERT INTO `t_s_country` VALUES ('2876', '索县', '540626000000', '540600000000');
INSERT INTO `t_s_country` VALUES ('2877', '班戈县', '540627000000', '540600000000');
INSERT INTO `t_s_country` VALUES ('2878', '巴青县', '540628000000', '540600000000');
INSERT INTO `t_s_country` VALUES ('2879', '尼玛县', '540629000000', '540600000000');
INSERT INTO `t_s_country` VALUES ('2880', '双湖县', '540630000000', '540600000000');
INSERT INTO `t_s_country` VALUES ('2881', '普兰县', '542521000000', '542500000000');
INSERT INTO `t_s_country` VALUES ('2882', '札达县', '542522000000', '542500000000');
INSERT INTO `t_s_country` VALUES ('2883', '噶尔县', '542523000000', '542500000000');
INSERT INTO `t_s_country` VALUES ('2884', '日土县', '542524000000', '542500000000');
INSERT INTO `t_s_country` VALUES ('2885', '革吉县', '542525000000', '542500000000');
INSERT INTO `t_s_country` VALUES ('2886', '改则县', '542526000000', '542500000000');
INSERT INTO `t_s_country` VALUES ('2887', '措勤县', '542527000000', '542500000000');
INSERT INTO `t_s_country` VALUES ('2888', '市辖区', '610101000000', '610100000000');
INSERT INTO `t_s_country` VALUES ('2889', '新城区', '610102000000', '610100000000');
INSERT INTO `t_s_country` VALUES ('2890', '碑林区', '610103000000', '610100000000');
INSERT INTO `t_s_country` VALUES ('2891', '莲湖区', '610104000000', '610100000000');
INSERT INTO `t_s_country` VALUES ('2892', '灞桥区', '610111000000', '610100000000');
INSERT INTO `t_s_country` VALUES ('2893', '未央区', '610112000000', '610100000000');
INSERT INTO `t_s_country` VALUES ('2894', '雁塔区', '610113000000', '610100000000');
INSERT INTO `t_s_country` VALUES ('2895', '阎良区', '610114000000', '610100000000');
INSERT INTO `t_s_country` VALUES ('2896', '临潼区', '610115000000', '610100000000');
INSERT INTO `t_s_country` VALUES ('2897', '长安区', '610116000000', '610100000000');
INSERT INTO `t_s_country` VALUES ('2898', '高陵区', '610117000000', '610100000000');
INSERT INTO `t_s_country` VALUES ('2899', '鄠邑区', '610118000000', '610100000000');
INSERT INTO `t_s_country` VALUES ('2900', '蓝田县', '610122000000', '610100000000');
INSERT INTO `t_s_country` VALUES ('2901', '周至县', '610124000000', '610100000000');
INSERT INTO `t_s_country` VALUES ('2902', '市辖区', '610201000000', '610200000000');
INSERT INTO `t_s_country` VALUES ('2903', '王益区', '610202000000', '610200000000');
INSERT INTO `t_s_country` VALUES ('2904', '印台区', '610203000000', '610200000000');
INSERT INTO `t_s_country` VALUES ('2905', '耀州区', '610204000000', '610200000000');
INSERT INTO `t_s_country` VALUES ('2906', '宜君县', '610222000000', '610200000000');
INSERT INTO `t_s_country` VALUES ('2907', '市辖区', '610301000000', '610300000000');
INSERT INTO `t_s_country` VALUES ('2908', '渭滨区', '610302000000', '610300000000');
INSERT INTO `t_s_country` VALUES ('2909', '金台区', '610303000000', '610300000000');
INSERT INTO `t_s_country` VALUES ('2910', '陈仓区', '610304000000', '610300000000');
INSERT INTO `t_s_country` VALUES ('2911', '凤翔县', '610322000000', '610300000000');
INSERT INTO `t_s_country` VALUES ('2912', '岐山县', '610323000000', '610300000000');
INSERT INTO `t_s_country` VALUES ('2913', '扶风县', '610324000000', '610300000000');
INSERT INTO `t_s_country` VALUES ('2914', '眉县', '610326000000', '610300000000');
INSERT INTO `t_s_country` VALUES ('2915', '陇县', '610327000000', '610300000000');
INSERT INTO `t_s_country` VALUES ('2916', '千阳县', '610328000000', '610300000000');
INSERT INTO `t_s_country` VALUES ('2917', '麟游县', '610329000000', '610300000000');
INSERT INTO `t_s_country` VALUES ('2918', '凤县', '610330000000', '610300000000');
INSERT INTO `t_s_country` VALUES ('2919', '太白县', '610331000000', '610300000000');
INSERT INTO `t_s_country` VALUES ('2920', '市辖区', '610401000000', '610400000000');
INSERT INTO `t_s_country` VALUES ('2921', '秦都区', '610402000000', '610400000000');
INSERT INTO `t_s_country` VALUES ('2922', '杨陵区', '610403000000', '610400000000');
INSERT INTO `t_s_country` VALUES ('2923', '渭城区', '610404000000', '610400000000');
INSERT INTO `t_s_country` VALUES ('2924', '三原县', '610422000000', '610400000000');
INSERT INTO `t_s_country` VALUES ('2925', '泾阳县', '610423000000', '610400000000');
INSERT INTO `t_s_country` VALUES ('2926', '乾县', '610424000000', '610400000000');
INSERT INTO `t_s_country` VALUES ('2927', '礼泉县', '610425000000', '610400000000');
INSERT INTO `t_s_country` VALUES ('2928', '永寿县', '610426000000', '610400000000');
INSERT INTO `t_s_country` VALUES ('2929', '长武县', '610428000000', '610400000000');
INSERT INTO `t_s_country` VALUES ('2930', '旬邑县', '610429000000', '610400000000');
INSERT INTO `t_s_country` VALUES ('2931', '淳化县', '610430000000', '610400000000');
INSERT INTO `t_s_country` VALUES ('2932', '武功县', '610431000000', '610400000000');
INSERT INTO `t_s_country` VALUES ('2933', '兴平市', '610481000000', '610400000000');
INSERT INTO `t_s_country` VALUES ('2934', '彬州市', '610482000000', '610400000000');
INSERT INTO `t_s_country` VALUES ('2935', '市辖区', '610501000000', '610500000000');
INSERT INTO `t_s_country` VALUES ('2936', '临渭区', '610502000000', '610500000000');
INSERT INTO `t_s_country` VALUES ('2937', '华州区', '610503000000', '610500000000');
INSERT INTO `t_s_country` VALUES ('2938', '潼关县', '610522000000', '610500000000');
INSERT INTO `t_s_country` VALUES ('2939', '大荔县', '610523000000', '610500000000');
INSERT INTO `t_s_country` VALUES ('2940', '合阳县', '610524000000', '610500000000');
INSERT INTO `t_s_country` VALUES ('2941', '澄城县', '610525000000', '610500000000');
INSERT INTO `t_s_country` VALUES ('2942', '蒲城县', '610526000000', '610500000000');
INSERT INTO `t_s_country` VALUES ('2943', '白水县', '610527000000', '610500000000');
INSERT INTO `t_s_country` VALUES ('2944', '富平县', '610528000000', '610500000000');
INSERT INTO `t_s_country` VALUES ('2945', '韩城市', '610581000000', '610500000000');
INSERT INTO `t_s_country` VALUES ('2946', '华阴市', '610582000000', '610500000000');
INSERT INTO `t_s_country` VALUES ('2947', '市辖区', '610601000000', '610600000000');
INSERT INTO `t_s_country` VALUES ('2948', '宝塔区', '610602000000', '610600000000');
INSERT INTO `t_s_country` VALUES ('2949', '安塞区', '610603000000', '610600000000');
INSERT INTO `t_s_country` VALUES ('2950', '延长县', '610621000000', '610600000000');
INSERT INTO `t_s_country` VALUES ('2951', '延川县', '610622000000', '610600000000');
INSERT INTO `t_s_country` VALUES ('2952', '子长县', '610623000000', '610600000000');
INSERT INTO `t_s_country` VALUES ('2953', '志丹县', '610625000000', '610600000000');
INSERT INTO `t_s_country` VALUES ('2954', '吴起县', '610626000000', '610600000000');
INSERT INTO `t_s_country` VALUES ('2955', '甘泉县', '610627000000', '610600000000');
INSERT INTO `t_s_country` VALUES ('2956', '富县', '610628000000', '610600000000');
INSERT INTO `t_s_country` VALUES ('2957', '洛川县', '610629000000', '610600000000');
INSERT INTO `t_s_country` VALUES ('2958', '宜川县', '610630000000', '610600000000');
INSERT INTO `t_s_country` VALUES ('2959', '黄龙县', '610631000000', '610600000000');
INSERT INTO `t_s_country` VALUES ('2960', '黄陵县', '610632000000', '610600000000');
INSERT INTO `t_s_country` VALUES ('2961', '市辖区', '610701000000', '610700000000');
INSERT INTO `t_s_country` VALUES ('2962', '汉台区', '610702000000', '610700000000');
INSERT INTO `t_s_country` VALUES ('2963', '南郑区', '610703000000', '610700000000');
INSERT INTO `t_s_country` VALUES ('2964', '城固县', '610722000000', '610700000000');
INSERT INTO `t_s_country` VALUES ('2965', '洋县', '610723000000', '610700000000');
INSERT INTO `t_s_country` VALUES ('2966', '西乡县', '610724000000', '610700000000');
INSERT INTO `t_s_country` VALUES ('2967', '勉县', '610725000000', '610700000000');
INSERT INTO `t_s_country` VALUES ('2968', '宁强县', '610726000000', '610700000000');
INSERT INTO `t_s_country` VALUES ('2969', '略阳县', '610727000000', '610700000000');
INSERT INTO `t_s_country` VALUES ('2970', '镇巴县', '610728000000', '610700000000');
INSERT INTO `t_s_country` VALUES ('2971', '留坝县', '610729000000', '610700000000');
INSERT INTO `t_s_country` VALUES ('2972', '佛坪县', '610730000000', '610700000000');
INSERT INTO `t_s_country` VALUES ('2973', '市辖区', '610801000000', '610800000000');
INSERT INTO `t_s_country` VALUES ('2974', '榆阳区', '610802000000', '610800000000');
INSERT INTO `t_s_country` VALUES ('2975', '横山区', '610803000000', '610800000000');
INSERT INTO `t_s_country` VALUES ('2976', '府谷县', '610822000000', '610800000000');
INSERT INTO `t_s_country` VALUES ('2977', '靖边县', '610824000000', '610800000000');
INSERT INTO `t_s_country` VALUES ('2978', '定边县', '610825000000', '610800000000');
INSERT INTO `t_s_country` VALUES ('2979', '绥德县', '610826000000', '610800000000');
INSERT INTO `t_s_country` VALUES ('2980', '米脂县', '610827000000', '610800000000');
INSERT INTO `t_s_country` VALUES ('2981', '佳县', '610828000000', '610800000000');
INSERT INTO `t_s_country` VALUES ('2982', '吴堡县', '610829000000', '610800000000');
INSERT INTO `t_s_country` VALUES ('2983', '清涧县', '610830000000', '610800000000');
INSERT INTO `t_s_country` VALUES ('2984', '子洲县', '610831000000', '610800000000');
INSERT INTO `t_s_country` VALUES ('2985', '神木市', '610881000000', '610800000000');
INSERT INTO `t_s_country` VALUES ('2986', '市辖区', '610901000000', '610900000000');
INSERT INTO `t_s_country` VALUES ('2987', '汉滨区', '610902000000', '610900000000');
INSERT INTO `t_s_country` VALUES ('2988', '汉阴县', '610921000000', '610900000000');
INSERT INTO `t_s_country` VALUES ('2989', '石泉县', '610922000000', '610900000000');
INSERT INTO `t_s_country` VALUES ('2990', '宁陕县', '610923000000', '610900000000');
INSERT INTO `t_s_country` VALUES ('2991', '紫阳县', '610924000000', '610900000000');
INSERT INTO `t_s_country` VALUES ('2992', '岚皋县', '610925000000', '610900000000');
INSERT INTO `t_s_country` VALUES ('2993', '平利县', '610926000000', '610900000000');
INSERT INTO `t_s_country` VALUES ('2994', '镇坪县', '610927000000', '610900000000');
INSERT INTO `t_s_country` VALUES ('2995', '旬阳县', '610928000000', '610900000000');
INSERT INTO `t_s_country` VALUES ('2996', '白河县', '610929000000', '610900000000');
INSERT INTO `t_s_country` VALUES ('2997', '市辖区', '611001000000', '611000000000');
INSERT INTO `t_s_country` VALUES ('2998', '商州区', '611002000000', '611000000000');
INSERT INTO `t_s_country` VALUES ('2999', '洛南县', '611021000000', '611000000000');
INSERT INTO `t_s_country` VALUES ('3000', '丹凤县', '611022000000', '611000000000');
INSERT INTO `t_s_country` VALUES ('3001', '商南县', '611023000000', '611000000000');
INSERT INTO `t_s_country` VALUES ('3002', '山阳县', '611024000000', '611000000000');
INSERT INTO `t_s_country` VALUES ('3003', '镇安县', '611025000000', '611000000000');
INSERT INTO `t_s_country` VALUES ('3004', '柞水县', '611026000000', '611000000000');
INSERT INTO `t_s_country` VALUES ('3005', '市辖区', '620101000000', '620100000000');
INSERT INTO `t_s_country` VALUES ('3006', '城关区', '620102000000', '620100000000');
INSERT INTO `t_s_country` VALUES ('3007', '七里河区', '620103000000', '620100000000');
INSERT INTO `t_s_country` VALUES ('3008', '西固区', '620104000000', '620100000000');
INSERT INTO `t_s_country` VALUES ('3009', '安宁区', '620105000000', '620100000000');
INSERT INTO `t_s_country` VALUES ('3010', '红古区', '620111000000', '620100000000');
INSERT INTO `t_s_country` VALUES ('3011', '永登县', '620121000000', '620100000000');
INSERT INTO `t_s_country` VALUES ('3012', '皋兰县', '620122000000', '620100000000');
INSERT INTO `t_s_country` VALUES ('3013', '榆中县', '620123000000', '620100000000');
INSERT INTO `t_s_country` VALUES ('3014', '兰州新区', '620171000000', '620100000000');
INSERT INTO `t_s_country` VALUES ('3015', '市辖区', '620201000000', '620200000000');
INSERT INTO `t_s_country` VALUES ('3016', '市辖区', '620301000000', '620300000000');
INSERT INTO `t_s_country` VALUES ('3017', '金川区', '620302000000', '620300000000');
INSERT INTO `t_s_country` VALUES ('3018', '永昌县', '620321000000', '620300000000');
INSERT INTO `t_s_country` VALUES ('3019', '市辖区', '620401000000', '620400000000');
INSERT INTO `t_s_country` VALUES ('3020', '白银区', '620402000000', '620400000000');
INSERT INTO `t_s_country` VALUES ('3021', '平川区', '620403000000', '620400000000');
INSERT INTO `t_s_country` VALUES ('3022', '靖远县', '620421000000', '620400000000');
INSERT INTO `t_s_country` VALUES ('3023', '会宁县', '620422000000', '620400000000');
INSERT INTO `t_s_country` VALUES ('3024', '景泰县', '620423000000', '620400000000');
INSERT INTO `t_s_country` VALUES ('3025', '市辖区', '620501000000', '620500000000');
INSERT INTO `t_s_country` VALUES ('3026', '秦州区', '620502000000', '620500000000');
INSERT INTO `t_s_country` VALUES ('3027', '麦积区', '620503000000', '620500000000');
INSERT INTO `t_s_country` VALUES ('3028', '清水县', '620521000000', '620500000000');
INSERT INTO `t_s_country` VALUES ('3029', '秦安县', '620522000000', '620500000000');
INSERT INTO `t_s_country` VALUES ('3030', '甘谷县', '620523000000', '620500000000');
INSERT INTO `t_s_country` VALUES ('3031', '武山县', '620524000000', '620500000000');
INSERT INTO `t_s_country` VALUES ('3032', '张家川回族自治县', '620525000000', '620500000000');
INSERT INTO `t_s_country` VALUES ('3033', '市辖区', '620601000000', '620600000000');
INSERT INTO `t_s_country` VALUES ('3034', '凉州区', '620602000000', '620600000000');
INSERT INTO `t_s_country` VALUES ('3035', '民勤县', '620621000000', '620600000000');
INSERT INTO `t_s_country` VALUES ('3036', '古浪县', '620622000000', '620600000000');
INSERT INTO `t_s_country` VALUES ('3037', '天祝藏族自治县', '620623000000', '620600000000');
INSERT INTO `t_s_country` VALUES ('3038', '市辖区', '620701000000', '620700000000');
INSERT INTO `t_s_country` VALUES ('3039', '甘州区', '620702000000', '620700000000');
INSERT INTO `t_s_country` VALUES ('3040', '肃南裕固族自治县', '620721000000', '620700000000');
INSERT INTO `t_s_country` VALUES ('3041', '民乐县', '620722000000', '620700000000');
INSERT INTO `t_s_country` VALUES ('3042', '临泽县', '620723000000', '620700000000');
INSERT INTO `t_s_country` VALUES ('3043', '高台县', '620724000000', '620700000000');
INSERT INTO `t_s_country` VALUES ('3044', '山丹县', '620725000000', '620700000000');
INSERT INTO `t_s_country` VALUES ('3045', '市辖区', '620801000000', '620800000000');
INSERT INTO `t_s_country` VALUES ('3046', '崆峒区', '620802000000', '620800000000');
INSERT INTO `t_s_country` VALUES ('3047', '泾川县', '620821000000', '620800000000');
INSERT INTO `t_s_country` VALUES ('3048', '灵台县', '620822000000', '620800000000');
INSERT INTO `t_s_country` VALUES ('3049', '崇信县', '620823000000', '620800000000');
INSERT INTO `t_s_country` VALUES ('3050', '庄浪县', '620825000000', '620800000000');
INSERT INTO `t_s_country` VALUES ('3051', '静宁县', '620826000000', '620800000000');
INSERT INTO `t_s_country` VALUES ('3052', '华亭市', '620881000000', '620800000000');
INSERT INTO `t_s_country` VALUES ('3053', '市辖区', '620901000000', '620900000000');
INSERT INTO `t_s_country` VALUES ('3054', '肃州区', '620902000000', '620900000000');
INSERT INTO `t_s_country` VALUES ('3055', '金塔县', '620921000000', '620900000000');
INSERT INTO `t_s_country` VALUES ('3056', '瓜州县', '620922000000', '620900000000');
INSERT INTO `t_s_country` VALUES ('3057', '肃北蒙古族自治县', '620923000000', '620900000000');
INSERT INTO `t_s_country` VALUES ('3058', '阿克塞哈萨克族自治县', '620924000000', '620900000000');
INSERT INTO `t_s_country` VALUES ('3059', '玉门市', '620981000000', '620900000000');
INSERT INTO `t_s_country` VALUES ('3060', '敦煌市', '620982000000', '620900000000');
INSERT INTO `t_s_country` VALUES ('3061', '市辖区', '621001000000', '621000000000');
INSERT INTO `t_s_country` VALUES ('3062', '西峰区', '621002000000', '621000000000');
INSERT INTO `t_s_country` VALUES ('3063', '庆城县', '621021000000', '621000000000');
INSERT INTO `t_s_country` VALUES ('3064', '环县', '621022000000', '621000000000');
INSERT INTO `t_s_country` VALUES ('3065', '华池县', '621023000000', '621000000000');
INSERT INTO `t_s_country` VALUES ('3066', '合水县', '621024000000', '621000000000');
INSERT INTO `t_s_country` VALUES ('3067', '正宁县', '621025000000', '621000000000');
INSERT INTO `t_s_country` VALUES ('3068', '宁县', '621026000000', '621000000000');
INSERT INTO `t_s_country` VALUES ('3069', '镇原县', '621027000000', '621000000000');
INSERT INTO `t_s_country` VALUES ('3070', '市辖区', '621101000000', '621100000000');
INSERT INTO `t_s_country` VALUES ('3071', '安定区', '621102000000', '621100000000');
INSERT INTO `t_s_country` VALUES ('3072', '通渭县', '621121000000', '621100000000');
INSERT INTO `t_s_country` VALUES ('3073', '陇西县', '621122000000', '621100000000');
INSERT INTO `t_s_country` VALUES ('3074', '渭源县', '621123000000', '621100000000');
INSERT INTO `t_s_country` VALUES ('3075', '临洮县', '621124000000', '621100000000');
INSERT INTO `t_s_country` VALUES ('3076', '漳县', '621125000000', '621100000000');
INSERT INTO `t_s_country` VALUES ('3077', '岷县', '621126000000', '621100000000');
INSERT INTO `t_s_country` VALUES ('3078', '市辖区', '621201000000', '621200000000');
INSERT INTO `t_s_country` VALUES ('3079', '武都区', '621202000000', '621200000000');
INSERT INTO `t_s_country` VALUES ('3080', '成县', '621221000000', '621200000000');
INSERT INTO `t_s_country` VALUES ('3081', '文县', '621222000000', '621200000000');
INSERT INTO `t_s_country` VALUES ('3082', '宕昌县', '621223000000', '621200000000');
INSERT INTO `t_s_country` VALUES ('3083', '康县', '621224000000', '621200000000');
INSERT INTO `t_s_country` VALUES ('3084', '西和县', '621225000000', '621200000000');
INSERT INTO `t_s_country` VALUES ('3085', '礼县', '621226000000', '621200000000');
INSERT INTO `t_s_country` VALUES ('3086', '徽县', '621227000000', '621200000000');
INSERT INTO `t_s_country` VALUES ('3087', '两当县', '621228000000', '621200000000');
INSERT INTO `t_s_country` VALUES ('3088', '临夏市', '622901000000', '622900000000');
INSERT INTO `t_s_country` VALUES ('3089', '临夏县', '622921000000', '622900000000');
INSERT INTO `t_s_country` VALUES ('3090', '康乐县', '622922000000', '622900000000');
INSERT INTO `t_s_country` VALUES ('3091', '永靖县', '622923000000', '622900000000');
INSERT INTO `t_s_country` VALUES ('3092', '广河县', '622924000000', '622900000000');
INSERT INTO `t_s_country` VALUES ('3093', '和政县', '622925000000', '622900000000');
INSERT INTO `t_s_country` VALUES ('3094', '东乡族自治县', '622926000000', '622900000000');
INSERT INTO `t_s_country` VALUES ('3095', '积石山保安族东乡族撒拉族自治县', '622927000000', '622900000000');
INSERT INTO `t_s_country` VALUES ('3096', '合作市', '623001000000', '623000000000');
INSERT INTO `t_s_country` VALUES ('3097', '临潭县', '623021000000', '623000000000');
INSERT INTO `t_s_country` VALUES ('3098', '卓尼县', '623022000000', '623000000000');
INSERT INTO `t_s_country` VALUES ('3099', '舟曲县', '623023000000', '623000000000');
INSERT INTO `t_s_country` VALUES ('3100', '迭部县', '623024000000', '623000000000');
INSERT INTO `t_s_country` VALUES ('3101', '玛曲县', '623025000000', '623000000000');
INSERT INTO `t_s_country` VALUES ('3102', '碌曲县', '623026000000', '623000000000');
INSERT INTO `t_s_country` VALUES ('3103', '夏河县', '623027000000', '623000000000');
INSERT INTO `t_s_country` VALUES ('3104', '市辖区', '630101000000', '630100000000');
INSERT INTO `t_s_country` VALUES ('3105', '城东区', '630102000000', '630100000000');
INSERT INTO `t_s_country` VALUES ('3106', '城中区', '630103000000', '630100000000');
INSERT INTO `t_s_country` VALUES ('3107', '城西区', '630104000000', '630100000000');
INSERT INTO `t_s_country` VALUES ('3108', '城北区', '630105000000', '630100000000');
INSERT INTO `t_s_country` VALUES ('3109', '大通回族土族自治县', '630121000000', '630100000000');
INSERT INTO `t_s_country` VALUES ('3110', '湟中县', '630122000000', '630100000000');
INSERT INTO `t_s_country` VALUES ('3111', '湟源县', '630123000000', '630100000000');
INSERT INTO `t_s_country` VALUES ('3112', '乐都区', '630202000000', '630200000000');
INSERT INTO `t_s_country` VALUES ('3113', '平安区', '630203000000', '630200000000');
INSERT INTO `t_s_country` VALUES ('3114', '民和回族土族自治县', '630222000000', '630200000000');
INSERT INTO `t_s_country` VALUES ('3115', '互助土族自治县', '630223000000', '630200000000');
INSERT INTO `t_s_country` VALUES ('3116', '化隆回族自治县', '630224000000', '630200000000');
INSERT INTO `t_s_country` VALUES ('3117', '循化撒拉族自治县', '630225000000', '630200000000');
INSERT INTO `t_s_country` VALUES ('3118', '门源回族自治县', '632221000000', '632200000000');
INSERT INTO `t_s_country` VALUES ('3119', '祁连县', '632222000000', '632200000000');
INSERT INTO `t_s_country` VALUES ('3120', '海晏县', '632223000000', '632200000000');
INSERT INTO `t_s_country` VALUES ('3121', '刚察县', '632224000000', '632200000000');
INSERT INTO `t_s_country` VALUES ('3122', '同仁县', '632321000000', '632300000000');
INSERT INTO `t_s_country` VALUES ('3123', '尖扎县', '632322000000', '632300000000');
INSERT INTO `t_s_country` VALUES ('3124', '泽库县', '632323000000', '632300000000');
INSERT INTO `t_s_country` VALUES ('3125', '河南蒙古族自治县', '632324000000', '632300000000');
INSERT INTO `t_s_country` VALUES ('3126', '共和县', '632521000000', '632500000000');
INSERT INTO `t_s_country` VALUES ('3127', '同德县', '632522000000', '632500000000');
INSERT INTO `t_s_country` VALUES ('3128', '贵德县', '632523000000', '632500000000');
INSERT INTO `t_s_country` VALUES ('3129', '兴海县', '632524000000', '632500000000');
INSERT INTO `t_s_country` VALUES ('3130', '贵南县', '632525000000', '632500000000');
INSERT INTO `t_s_country` VALUES ('3131', '玛沁县', '632621000000', '632600000000');
INSERT INTO `t_s_country` VALUES ('3132', '班玛县', '632622000000', '632600000000');
INSERT INTO `t_s_country` VALUES ('3133', '甘德县', '632623000000', '632600000000');
INSERT INTO `t_s_country` VALUES ('3134', '达日县', '632624000000', '632600000000');
INSERT INTO `t_s_country` VALUES ('3135', '久治县', '632625000000', '632600000000');
INSERT INTO `t_s_country` VALUES ('3136', '玛多县', '632626000000', '632600000000');
INSERT INTO `t_s_country` VALUES ('3137', '玉树市', '632701000000', '632700000000');
INSERT INTO `t_s_country` VALUES ('3138', '杂多县', '632722000000', '632700000000');
INSERT INTO `t_s_country` VALUES ('3139', '称多县', '632723000000', '632700000000');
INSERT INTO `t_s_country` VALUES ('3140', '治多县', '632724000000', '632700000000');
INSERT INTO `t_s_country` VALUES ('3141', '囊谦县', '632725000000', '632700000000');
INSERT INTO `t_s_country` VALUES ('3142', '曲麻莱县', '632726000000', '632700000000');
INSERT INTO `t_s_country` VALUES ('3143', '格尔木市', '632801000000', '632800000000');
INSERT INTO `t_s_country` VALUES ('3144', '德令哈市', '632802000000', '632800000000');
INSERT INTO `t_s_country` VALUES ('3145', '茫崖市', '632803000000', '632800000000');
INSERT INTO `t_s_country` VALUES ('3146', '乌兰县', '632821000000', '632800000000');
INSERT INTO `t_s_country` VALUES ('3147', '都兰县', '632822000000', '632800000000');
INSERT INTO `t_s_country` VALUES ('3148', '天峻县', '632823000000', '632800000000');
INSERT INTO `t_s_country` VALUES ('3149', '大柴旦行政委员会', '632857000000', '632800000000');
INSERT INTO `t_s_country` VALUES ('3150', '市辖区', '640101000000', '640100000000');
INSERT INTO `t_s_country` VALUES ('3151', '兴庆区', '640104000000', '640100000000');
INSERT INTO `t_s_country` VALUES ('3152', '西夏区', '640105000000', '640100000000');
INSERT INTO `t_s_country` VALUES ('3153', '金凤区', '640106000000', '640100000000');
INSERT INTO `t_s_country` VALUES ('3154', '永宁县', '640121000000', '640100000000');
INSERT INTO `t_s_country` VALUES ('3155', '贺兰县', '640122000000', '640100000000');
INSERT INTO `t_s_country` VALUES ('3156', '灵武市', '640181000000', '640100000000');
INSERT INTO `t_s_country` VALUES ('3157', '市辖区', '640201000000', '640200000000');
INSERT INTO `t_s_country` VALUES ('3158', '大武口区', '640202000000', '640200000000');
INSERT INTO `t_s_country` VALUES ('3159', '惠农区', '640205000000', '640200000000');
INSERT INTO `t_s_country` VALUES ('3160', '平罗县', '640221000000', '640200000000');
INSERT INTO `t_s_country` VALUES ('3161', '市辖区', '640301000000', '640300000000');
INSERT INTO `t_s_country` VALUES ('3162', '利通区', '640302000000', '640300000000');
INSERT INTO `t_s_country` VALUES ('3163', '红寺堡区', '640303000000', '640300000000');
INSERT INTO `t_s_country` VALUES ('3164', '盐池县', '640323000000', '640300000000');
INSERT INTO `t_s_country` VALUES ('3165', '同心县', '640324000000', '640300000000');
INSERT INTO `t_s_country` VALUES ('3166', '青铜峡市', '640381000000', '640300000000');
INSERT INTO `t_s_country` VALUES ('3167', '市辖区', '640401000000', '640400000000');
INSERT INTO `t_s_country` VALUES ('3168', '原州区', '640402000000', '640400000000');
INSERT INTO `t_s_country` VALUES ('3169', '西吉县', '640422000000', '640400000000');
INSERT INTO `t_s_country` VALUES ('3170', '隆德县', '640423000000', '640400000000');
INSERT INTO `t_s_country` VALUES ('3171', '泾源县', '640424000000', '640400000000');
INSERT INTO `t_s_country` VALUES ('3172', '彭阳县', '640425000000', '640400000000');
INSERT INTO `t_s_country` VALUES ('3173', '市辖区', '640501000000', '640500000000');
INSERT INTO `t_s_country` VALUES ('3174', '沙坡头区', '640502000000', '640500000000');
INSERT INTO `t_s_country` VALUES ('3175', '中宁县', '640521000000', '640500000000');
INSERT INTO `t_s_country` VALUES ('3176', '海原县', '640522000000', '640500000000');
INSERT INTO `t_s_country` VALUES ('3177', '市辖区', '650101000000', '650100000000');
INSERT INTO `t_s_country` VALUES ('3178', '天山区', '650102000000', '650100000000');
INSERT INTO `t_s_country` VALUES ('3179', '沙依巴克区', '650103000000', '650100000000');
INSERT INTO `t_s_country` VALUES ('3180', '新市区', '650104000000', '650100000000');
INSERT INTO `t_s_country` VALUES ('3181', '水磨沟区', '650105000000', '650100000000');
INSERT INTO `t_s_country` VALUES ('3182', '头屯河区', '650106000000', '650100000000');
INSERT INTO `t_s_country` VALUES ('3183', '达坂城区', '650107000000', '650100000000');
INSERT INTO `t_s_country` VALUES ('3184', '米东区', '650109000000', '650100000000');
INSERT INTO `t_s_country` VALUES ('3185', '乌鲁木齐县', '650121000000', '650100000000');
INSERT INTO `t_s_country` VALUES ('3186', '乌鲁木齐经济技术开发区', '650171000000', '650100000000');
INSERT INTO `t_s_country` VALUES ('3187', '乌鲁木齐高新技术产业开发区', '650172000000', '650100000000');
INSERT INTO `t_s_country` VALUES ('3188', '市辖区', '650201000000', '650200000000');
INSERT INTO `t_s_country` VALUES ('3189', '独山子区', '650202000000', '650200000000');
INSERT INTO `t_s_country` VALUES ('3190', '克拉玛依区', '650203000000', '650200000000');
INSERT INTO `t_s_country` VALUES ('3191', '白碱滩区', '650204000000', '650200000000');
INSERT INTO `t_s_country` VALUES ('3192', '乌尔禾区', '650205000000', '650200000000');
INSERT INTO `t_s_country` VALUES ('3193', '高昌区', '650402000000', '650400000000');
INSERT INTO `t_s_country` VALUES ('3194', '鄯善县', '650421000000', '650400000000');
INSERT INTO `t_s_country` VALUES ('3195', '托克逊县', '650422000000', '650400000000');
INSERT INTO `t_s_country` VALUES ('3196', '伊州区', '650502000000', '650500000000');
INSERT INTO `t_s_country` VALUES ('3197', '巴里坤哈萨克自治县', '650521000000', '650500000000');
INSERT INTO `t_s_country` VALUES ('3198', '伊吾县', '650522000000', '650500000000');
INSERT INTO `t_s_country` VALUES ('3199', '昌吉市', '652301000000', '652300000000');
INSERT INTO `t_s_country` VALUES ('3200', '阜康市', '652302000000', '652300000000');
INSERT INTO `t_s_country` VALUES ('3201', '呼图壁县', '652323000000', '652300000000');
INSERT INTO `t_s_country` VALUES ('3202', '玛纳斯县', '652324000000', '652300000000');
INSERT INTO `t_s_country` VALUES ('3203', '奇台县', '652325000000', '652300000000');
INSERT INTO `t_s_country` VALUES ('3204', '吉木萨尔县', '652327000000', '652300000000');
INSERT INTO `t_s_country` VALUES ('3205', '木垒哈萨克自治县', '652328000000', '652300000000');
INSERT INTO `t_s_country` VALUES ('3206', '博乐市', '652701000000', '652700000000');
INSERT INTO `t_s_country` VALUES ('3207', '阿拉山口市', '652702000000', '652700000000');
INSERT INTO `t_s_country` VALUES ('3208', '精河县', '652722000000', '652700000000');
INSERT INTO `t_s_country` VALUES ('3209', '温泉县', '652723000000', '652700000000');
INSERT INTO `t_s_country` VALUES ('3210', '库尔勒市', '652801000000', '652800000000');
INSERT INTO `t_s_country` VALUES ('3211', '轮台县', '652822000000', '652800000000');
INSERT INTO `t_s_country` VALUES ('3212', '尉犁县', '652823000000', '652800000000');
INSERT INTO `t_s_country` VALUES ('3213', '若羌县', '652824000000', '652800000000');
INSERT INTO `t_s_country` VALUES ('3214', '且末县', '652825000000', '652800000000');
INSERT INTO `t_s_country` VALUES ('3215', '焉耆回族自治县', '652826000000', '652800000000');
INSERT INTO `t_s_country` VALUES ('3216', '和静县', '652827000000', '652800000000');
INSERT INTO `t_s_country` VALUES ('3217', '和硕县', '652828000000', '652800000000');
INSERT INTO `t_s_country` VALUES ('3218', '博湖县', '652829000000', '652800000000');
INSERT INTO `t_s_country` VALUES ('3219', '库尔勒经济技术开发区', '652871000000', '652800000000');
INSERT INTO `t_s_country` VALUES ('3220', '阿克苏市', '652901000000', '652900000000');
INSERT INTO `t_s_country` VALUES ('3221', '温宿县', '652922000000', '652900000000');
INSERT INTO `t_s_country` VALUES ('3222', '库车县', '652923000000', '652900000000');
INSERT INTO `t_s_country` VALUES ('3223', '沙雅县', '652924000000', '652900000000');
INSERT INTO `t_s_country` VALUES ('3224', '新和县', '652925000000', '652900000000');
INSERT INTO `t_s_country` VALUES ('3225', '拜城县', '652926000000', '652900000000');
INSERT INTO `t_s_country` VALUES ('3226', '乌什县', '652927000000', '652900000000');
INSERT INTO `t_s_country` VALUES ('3227', '阿瓦提县', '652928000000', '652900000000');
INSERT INTO `t_s_country` VALUES ('3228', '柯坪县', '652929000000', '652900000000');
INSERT INTO `t_s_country` VALUES ('3229', '阿图什市', '653001000000', '653000000000');
INSERT INTO `t_s_country` VALUES ('3230', '阿克陶县', '653022000000', '653000000000');
INSERT INTO `t_s_country` VALUES ('3231', '阿合奇县', '653023000000', '653000000000');
INSERT INTO `t_s_country` VALUES ('3232', '乌恰县', '653024000000', '653000000000');
INSERT INTO `t_s_country` VALUES ('3233', '喀什市', '653101000000', '653100000000');
INSERT INTO `t_s_country` VALUES ('3234', '疏附县', '653121000000', '653100000000');
INSERT INTO `t_s_country` VALUES ('3235', '疏勒县', '653122000000', '653100000000');
INSERT INTO `t_s_country` VALUES ('3236', '英吉沙县', '653123000000', '653100000000');
INSERT INTO `t_s_country` VALUES ('3237', '泽普县', '653124000000', '653100000000');
INSERT INTO `t_s_country` VALUES ('3238', '莎车县', '653125000000', '653100000000');
INSERT INTO `t_s_country` VALUES ('3239', '叶城县', '653126000000', '653100000000');
INSERT INTO `t_s_country` VALUES ('3240', '麦盖提县', '653127000000', '653100000000');
INSERT INTO `t_s_country` VALUES ('3241', '岳普湖县', '653128000000', '653100000000');
INSERT INTO `t_s_country` VALUES ('3242', '伽师县', '653129000000', '653100000000');
INSERT INTO `t_s_country` VALUES ('3243', '巴楚县', '653130000000', '653100000000');
INSERT INTO `t_s_country` VALUES ('3244', '塔什库尔干塔吉克自治县', '653131000000', '653100000000');
INSERT INTO `t_s_country` VALUES ('3245', '和田市', '653201000000', '653200000000');
INSERT INTO `t_s_country` VALUES ('3246', '和田县', '653221000000', '653200000000');
INSERT INTO `t_s_country` VALUES ('3247', '墨玉县', '653222000000', '653200000000');
INSERT INTO `t_s_country` VALUES ('3248', '皮山县', '653223000000', '653200000000');
INSERT INTO `t_s_country` VALUES ('3249', '洛浦县', '653224000000', '653200000000');
INSERT INTO `t_s_country` VALUES ('3250', '策勒县', '653225000000', '653200000000');
INSERT INTO `t_s_country` VALUES ('3251', '于田县', '653226000000', '653200000000');
INSERT INTO `t_s_country` VALUES ('3252', '民丰县', '653227000000', '653200000000');
INSERT INTO `t_s_country` VALUES ('3253', '伊宁市', '654002000000', '654000000000');
INSERT INTO `t_s_country` VALUES ('3254', '奎屯市', '654003000000', '654000000000');
INSERT INTO `t_s_country` VALUES ('3255', '霍尔果斯市', '654004000000', '654000000000');
INSERT INTO `t_s_country` VALUES ('3256', '伊宁县', '654021000000', '654000000000');
INSERT INTO `t_s_country` VALUES ('3257', '察布查尔锡伯自治县', '654022000000', '654000000000');
INSERT INTO `t_s_country` VALUES ('3258', '霍城县', '654023000000', '654000000000');
INSERT INTO `t_s_country` VALUES ('3259', '巩留县', '654024000000', '654000000000');
INSERT INTO `t_s_country` VALUES ('3260', '新源县', '654025000000', '654000000000');
INSERT INTO `t_s_country` VALUES ('3261', '昭苏县', '654026000000', '654000000000');
INSERT INTO `t_s_country` VALUES ('3262', '特克斯县', '654027000000', '654000000000');
INSERT INTO `t_s_country` VALUES ('3263', '尼勒克县', '654028000000', '654000000000');
INSERT INTO `t_s_country` VALUES ('3264', '塔城市', '654201000000', '654200000000');
INSERT INTO `t_s_country` VALUES ('3265', '乌苏市', '654202000000', '654200000000');
INSERT INTO `t_s_country` VALUES ('3266', '额敏县', '654221000000', '654200000000');
INSERT INTO `t_s_country` VALUES ('3267', '沙湾县', '654223000000', '654200000000');
INSERT INTO `t_s_country` VALUES ('3268', '托里县', '654224000000', '654200000000');
INSERT INTO `t_s_country` VALUES ('3269', '裕民县', '654225000000', '654200000000');
INSERT INTO `t_s_country` VALUES ('3270', '和布克赛尔蒙古自治县', '654226000000', '654200000000');
INSERT INTO `t_s_country` VALUES ('3271', '阿勒泰市', '654301000000', '654300000000');
INSERT INTO `t_s_country` VALUES ('3272', '布尔津县', '654321000000', '654300000000');
INSERT INTO `t_s_country` VALUES ('3273', '富蕴县', '654322000000', '654300000000');
INSERT INTO `t_s_country` VALUES ('3274', '福海县', '654323000000', '654300000000');
INSERT INTO `t_s_country` VALUES ('3275', '哈巴河县', '654324000000', '654300000000');
INSERT INTO `t_s_country` VALUES ('3276', '青河县', '654325000000', '654300000000');
INSERT INTO `t_s_country` VALUES ('3277', '吉木乃县', '654326000000', '654300000000');
INSERT INTO `t_s_country` VALUES ('3278', '石河子市', '659001000000', '659000000000');
INSERT INTO `t_s_country` VALUES ('3279', '阿拉尔市', '659002000000', '659000000000');
INSERT INTO `t_s_country` VALUES ('3280', '图木舒克市', '659003000000', '659000000000');
INSERT INTO `t_s_country` VALUES ('3281', '五家渠市', '659004000000', '659000000000');
INSERT INTO `t_s_country` VALUES ('3282', '铁门关市', '659006000000', '659000000000');

-- ----------------------------
-- Table structure for t_s_font_awesome
-- ----------------------------
DROP TABLE IF EXISTS `t_s_font_awesome`;
CREATE TABLE `t_s_font_awesome` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `create_by` bigint(20) DEFAULT NULL COMMENT '创建人id',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` bigint(20) DEFAULT NULL COMMENT '更新人id',
  `update_date` datetime DEFAULT NULL COMMENT '更新时间',
  `icon_class` varchar(50) NOT NULL COMMENT '图标class',
  `label` varchar(50) NOT NULL COMMENT '英文标签',
  `tags` varchar(50) DEFAULT NULL COMMENT '中文标签',
  `order_num` int(11) DEFAULT NULL COMMENT '排序',
  `status` int(11) DEFAULT '1' COMMENT '状态',
  PRIMARY KEY (`id`),
  UNIQUE KEY `icon_class` (`icon_class`)
) ENGINE=MyISAM AUTO_INCREMENT=45 DEFAULT CHARSET=utf8mb4 COMMENT='Font Awesome字体图标';

-- ----------------------------
-- Records of t_s_font_awesome
-- ----------------------------
INSERT INTO `t_s_font_awesome` VALUES ('2', '1000000005', '2019-05-05 01:13:35', '1000000005', '2019-05-05 01:13:35', 'fas fa-user', 'user', '用户', '1', '1');
INSERT INTO `t_s_font_awesome` VALUES ('3', '1000000005', '2019-05-05 01:13:35', '1000000005', '2019-05-05 01:13:35', 'fas fa-user-circle', 'user-circle', '用户，圆形用户', '1', '1');
INSERT INTO `t_s_font_awesome` VALUES ('4', '1000000005', '2019-05-05 01:13:35', '1000000005', '2019-05-05 01:13:35', 'fas fa-tasks', 'tasks', '任务', '1', '1');
INSERT INTO `t_s_font_awesome` VALUES ('5', '1000000005', '2019-05-05 01:13:35', '1000000005', '2019-05-05 01:13:35', 'fas fa-cog', 'cog', '设置', '1', '1');
INSERT INTO `t_s_font_awesome` VALUES ('6', '1000000005', '2019-05-05 01:13:35', '1000000005', '2019-05-05 01:13:35', 'fas fa-cogs', 'cogs', '设置', '1', '1');
INSERT INTO `t_s_font_awesome` VALUES ('7', '1000000005', '2019-05-05 01:13:35', '1000000005', '2019-05-05 01:13:35', 'fas fa-tools', 'tools', '工具，设置', '1', '1');
INSERT INTO `t_s_font_awesome` VALUES ('8', '1000000005', '2019-05-05 01:13:35', '1000000005', '2019-05-05 01:13:35', 'fas fa-list-ol', 'list-ol', '列表，有序列表', '1', '1');
INSERT INTO `t_s_font_awesome` VALUES ('9', '1000000005', '2019-05-05 01:13:35', '1000000005', '2019-05-05 01:13:35', 'fas fa-list-ul', 'list-ul', '列表，无序列表', '1', '1');
INSERT INTO `t_s_font_awesome` VALUES ('10', '1000000005', '2019-05-05 01:13:35', '1000000005', '2019-05-05 01:13:35', 'fas fa-bell', 'bell', '铃，钟，提示，消息，信息', '1', '1');
INSERT INTO `t_s_font_awesome` VALUES ('11', '1000000005', '2019-05-05 01:13:35', '1000000005', '2019-05-05 01:13:35', 'fas fa-exclamation-circle', 'exclamation-circle', '感叹号，提示，消息，圆形', '1', '1');
INSERT INTO `t_s_font_awesome` VALUES ('12', '1000000005', '2019-05-05 01:13:35', '1000000005', '2019-05-05 01:13:35', 'fas fa-exclamation-triangle', 'exclamation-triangle', '感叹号，提示，消息，三角形', '1', '1');
INSERT INTO `t_s_font_awesome` VALUES ('13', '1000000005', '2019-05-05 01:13:35', '1000000005', '2019-05-05 01:13:35', 'fas fa-address-book', 'address-book', '通讯录，用户', '1', '1');
INSERT INTO `t_s_font_awesome` VALUES ('14', '1000000005', '2019-05-05 01:13:35', '1000000005', '2019-05-05 01:13:35', 'fas fa-address-card', 'address-card', '地址卡，用户', '1', '1');
INSERT INTO `t_s_font_awesome` VALUES ('15', '1000000005', '2019-05-05 01:13:35', '1000000005', '2019-05-05 01:13:35', 'fas fa-book', 'book', '书，书籍，字典，数据，数据字典', '1', '1');
INSERT INTO `t_s_font_awesome` VALUES ('16', '1000000005', '2019-05-05 01:13:35', '1000000005', '2019-05-05 01:13:35', 'fas fa-calendar', 'calendar', '日历', '1', '1');
INSERT INTO `t_s_font_awesome` VALUES ('17', '1000000005', '2019-05-05 01:13:35', '1000000005', '2019-05-05 01:13:35', 'fas fa-calendar-alt', 'calendar-alt', '日历', '1', '1');
INSERT INTO `t_s_font_awesome` VALUES ('18', '1000000005', '2019-05-05 01:13:35', '1000000005', '2019-05-05 01:13:35', 'fas fa-chart-area', 'chart-area', '图表', '1', '1');
INSERT INTO `t_s_font_awesome` VALUES ('19', '1000000005', '2019-05-05 01:13:35', '1000000005', '2019-05-05 01:13:35', 'fas fa-chart-bar', 'chart-bar', '图表', '1', '1');
INSERT INTO `t_s_font_awesome` VALUES ('20', '1000000005', '2019-05-05 01:13:35', '1000000005', '2019-05-05 01:13:35', 'fas fa-chart-line', 'chart-line', '图表', '1', '1');
INSERT INTO `t_s_font_awesome` VALUES ('21', '1000000005', '2019-05-05 01:13:35', '1000000005', '2019-05-05 01:13:35', 'fas fa-chart-pie', 'chart-pie', '图表', '1', '1');
INSERT INTO `t_s_font_awesome` VALUES ('22', '1000000005', '2019-05-05 01:13:35', '1000000005', '2019-05-05 01:13:35', 'fas fa-coffee', 'coffee', '咖啡', '1', '1');
INSERT INTO `t_s_font_awesome` VALUES ('23', '1000000005', '2019-05-05 01:13:35', '1000000005', '2019-05-05 01:13:35', 'fas fa-compass', 'compass', '指南针，罗盘，消息', '1', '1');
INSERT INTO `t_s_font_awesome` VALUES ('24', '1000000005', '2019-05-05 01:13:35', '1000000005', '2019-05-05 01:13:35', 'fas fa-leaf', 'leaf', '树叶', '1', '1');
INSERT INTO `t_s_font_awesome` VALUES ('25', '1000000005', '2019-05-05 01:13:35', '1000000005', '2019-05-05 01:13:35', 'fas fa-comment-dots', 'comment-dots', '评论，聊天', '1', '1');
INSERT INTO `t_s_font_awesome` VALUES ('26', '1000000005', '2019-05-05 01:13:35', '1000000005', '2019-05-05 01:13:35', 'fas fa-comment', 'comment', '评论，聊天', '1', '1');
INSERT INTO `t_s_font_awesome` VALUES ('27', '1000000005', '2019-05-05 01:13:35', '1000000005', '2019-05-05 01:13:35', 'fas fa-comment-alt', 'comment-alt', '评论，聊天', '1', '1');
INSERT INTO `t_s_font_awesome` VALUES ('28', '1000000005', '2019-05-05 01:13:35', '1000000005', '2019-05-05 01:13:35', 'fas fa-comments', 'comments', '评论，聊天', '1', '1');
INSERT INTO `t_s_font_awesome` VALUES ('29', '1000000005', '2019-05-05 01:13:35', '1000000005', '2019-05-05 01:13:35', 'fas fa-code', 'code', '代码，编码', '1', '1');
INSERT INTO `t_s_font_awesome` VALUES ('30', '1000000005', '2019-05-05 01:13:35', '1000000005', '2019-05-05 01:13:35', 'fas fa-bug', 'bug', 'bug，日志，调试，代码，编码', '1', '1');
INSERT INTO `t_s_font_awesome` VALUES ('31', '1000000005', '2019-05-05 01:13:35', '1000000005', '2019-05-05 01:13:35', 'fas fa-archive', 'archive', '档案，存档，文件', '1', '1');
INSERT INTO `t_s_font_awesome` VALUES ('32', '1000000005', '2019-05-05 01:13:35', '1000000005', '2019-05-05 01:13:35', 'fas fa-file', 'file', '文件，文档', '1', '1');
INSERT INTO `t_s_font_awesome` VALUES ('33', '1000000005', '2019-05-05 01:13:35', '1000000005', '2019-05-05 01:13:35', 'fas fa-file-alt', 'file-alt', '文件', '1', '1');
INSERT INTO `t_s_font_awesome` VALUES ('34', '1000000005', '2019-05-05 01:13:35', '1000000005', '2019-05-05 01:13:35', 'fas fa-envelope', 'envelope', '信封，收件箱，消息', '1', '1');
INSERT INTO `t_s_font_awesome` VALUES ('35', '1000000005', '2019-05-05 01:13:35', '1000000005', '2019-05-05 01:13:35', 'fas fa-database', 'database', '数据库', '1', '1');
INSERT INTO `t_s_font_awesome` VALUES ('36', '1000000005', '2019-05-05 01:13:35', '1000000005', '2019-05-05 01:13:35', 'fas fa-desktop', 'desktop', '桌面，台式机，电脑', '1', '1');
INSERT INTO `t_s_font_awesome` VALUES ('37', '1000000005', '2019-05-05 01:13:35', '1000000005', '2019-05-05 01:13:35', 'fas fa-clock', 'clock', '时钟，任务', '1', '1');
INSERT INTO `t_s_font_awesome` VALUES ('38', '1000000005', '2019-05-05 01:13:35', '1000000005', '2019-05-05 01:13:35', 'fas fa-ban', 'ban', '禁止，黑名单', '1', '1');
INSERT INTO `t_s_font_awesome` VALUES ('39', '1000000005', '2019-05-05 01:13:35', '1000000005', '2019-05-05 01:13:35', 'fas fa-lock', 'lock', '锁，权限', '1', '1');
INSERT INTO `t_s_font_awesome` VALUES ('40', '1000000005', '2019-05-05 01:13:35', '1000000005', '2019-05-05 01:13:35', 'fas fa-tshirt', 'tshirt', 'T恤，换肤，皮肤', '1', '1');
INSERT INTO `t_s_font_awesome` VALUES ('41', '1000000005', '2019-05-05 01:13:35', '1000000005', '2019-05-05 01:13:35', 'fas fa-heart', 'heart', '心，喜欢，收藏', '1', '1');
INSERT INTO `t_s_font_awesome` VALUES ('42', '1000000005', '2019-05-05 01:13:35', '1000000005', '2019-05-05 01:13:35', 'fas fa-home', 'home', '主页', '1', '1');
INSERT INTO `t_s_font_awesome` VALUES ('43', '1000000005', '2019-05-05 01:13:35', '1000000005', '2019-05-05 01:13:35', 'fas fa-dollar-sign', 'dollar-sign', '美元', '1', '1');
INSERT INTO `t_s_font_awesome` VALUES ('44', '1000000005', '2019-05-05 01:13:35', '1000000005', '2019-05-05 01:13:35', 'fas fa-wallet', 'wallet', '钱包', '1', '1');

-- ----------------------------
-- Table structure for t_s_province
-- ----------------------------
DROP TABLE IF EXISTS `t_s_province`;
CREATE TABLE `t_s_province` (
  `id` int(11) NOT NULL,
  `name` varchar(64) DEFAULT NULL,
  `province_id` varchar(12) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Records of t_s_province
-- ----------------------------
INSERT INTO `t_s_province` VALUES ('1', '北京市', '110000000000');
INSERT INTO `t_s_province` VALUES ('2', '天津市', '120000000000');
INSERT INTO `t_s_province` VALUES ('3', '河北省', '130000000000');
INSERT INTO `t_s_province` VALUES ('4', '山西省', '140000000000');
INSERT INTO `t_s_province` VALUES ('5', '内蒙古自治区', '150000000000');
INSERT INTO `t_s_province` VALUES ('6', '辽宁省', '210000000000');
INSERT INTO `t_s_province` VALUES ('7', '吉林省', '220000000000');
INSERT INTO `t_s_province` VALUES ('8', '黑龙江省', '230000000000');
INSERT INTO `t_s_province` VALUES ('9', '上海市', '310000000000');
INSERT INTO `t_s_province` VALUES ('10', '江苏省', '320000000000');
INSERT INTO `t_s_province` VALUES ('11', '浙江省', '330000000000');
INSERT INTO `t_s_province` VALUES ('12', '安徽省', '340000000000');
INSERT INTO `t_s_province` VALUES ('13', '福建省', '350000000000');
INSERT INTO `t_s_province` VALUES ('14', '江西省', '360000000000');
INSERT INTO `t_s_province` VALUES ('15', '山东省', '370000000000');
INSERT INTO `t_s_province` VALUES ('16', '河南省', '410000000000');
INSERT INTO `t_s_province` VALUES ('17', '湖北省', '420000000000');
INSERT INTO `t_s_province` VALUES ('18', '湖南省', '430000000000');
INSERT INTO `t_s_province` VALUES ('19', '广东省', '440000000000');
INSERT INTO `t_s_province` VALUES ('20', '广西壮族自治区', '450000000000');
INSERT INTO `t_s_province` VALUES ('21', '海南省', '460000000000');
INSERT INTO `t_s_province` VALUES ('22', '重庆市', '500000000000');
INSERT INTO `t_s_province` VALUES ('23', '四川省', '510000000000');
INSERT INTO `t_s_province` VALUES ('24', '贵州省', '520000000000');
INSERT INTO `t_s_province` VALUES ('25', '云南省', '530000000000');
INSERT INTO `t_s_province` VALUES ('26', '西藏自治区', '540000000000');
INSERT INTO `t_s_province` VALUES ('27', '陕西省', '610000000000');
INSERT INTO `t_s_province` VALUES ('28', '甘肃省', '620000000000');
INSERT INTO `t_s_province` VALUES ('29', '青海省', '630000000000');
INSERT INTO `t_s_province` VALUES ('30', '宁夏回族自治区', '640000000000');
INSERT INTO `t_s_province` VALUES ('31', '新疆维吾尔自治区', '650000000000');

-- ----------------------------
-- Table structure for t_s_quartz_job
-- ----------------------------
DROP TABLE IF EXISTS `t_s_quartz_job`;
CREATE TABLE `t_s_quartz_job` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `create_by` bigint(20) DEFAULT NULL COMMENT '创建人id',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` bigint(20) DEFAULT NULL COMMENT '更新人id',
  `update_date` datetime DEFAULT NULL COMMENT '更新时间',
  `cron_expression` varchar(50) DEFAULT NULL COMMENT 'cron表达式',
  `method_name` varchar(255) DEFAULT NULL COMMENT '任务调用的方法名',
  `is_concurrent` int(4) DEFAULT NULL COMMENT '任务是否有状态',
  `description` varchar(255) DEFAULT NULL COMMENT '描述',
  `bean_name` varchar(255) DEFAULT NULL COMMENT '任务执行时调用哪个类的方法 包名+类名，完全限定名',
  `trigger_name` varchar(255) DEFAULT NULL COMMENT '触发器名称',
  `job_status` int(4) DEFAULT NULL COMMENT '任务状态',
  `spring_bean` varchar(255) DEFAULT NULL,
  `job_name` varchar(255) DEFAULT NULL COMMENT '任务名',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='quartz任务';

-- ----------------------------
-- Records of t_s_quartz_job
-- ----------------------------
INSERT INTO `t_s_quartz_job` VALUES ('1', '1', '2018-12-21 22:21:26', '1000000000', '2019-01-25 14:25:43', '*/5 * * * * ?', 'execute', '0', '测试', 'com.simon.task.SampleTask', 'org.quartz.CronTrigger', '0', 'com.simon.task.SampleTask', 'com.simon.task.SampleTask');

-- ----------------------------
-- Table structure for t_s_town
-- ----------------------------
DROP TABLE IF EXISTS `t_s_town`;
CREATE TABLE `t_s_town` (
  `id` int(11) NOT NULL,
  `name` varchar(64) DEFAULT NULL,
  `town_id` varchar(12) DEFAULT NULL,
  `country_id` varchar(12) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Records of t_s_town
-- ----------------------------
INSERT INTO `t_s_town` VALUES ('1', '东华门街道办事处', '110101001000', '110101000000');
INSERT INTO `t_s_town` VALUES ('2', '景山街道办事处', '110101002000', '110101000000');
INSERT INTO `t_s_town` VALUES ('3', '交道口街道办事处', '110101003000', '110101000000');
INSERT INTO `t_s_town` VALUES ('4', '安定门街道办事处', '110101004000', '110101000000');
INSERT INTO `t_s_town` VALUES ('5', '北新桥街道办事处', '110101005000', '110101000000');
INSERT INTO `t_s_town` VALUES ('6', '东四街道办事处', '110101006000', '110101000000');
INSERT INTO `t_s_town` VALUES ('7', '朝阳门街道办事处', '110101007000', '110101000000');
INSERT INTO `t_s_town` VALUES ('8', '建国门街道办事处', '110101008000', '110101000000');
INSERT INTO `t_s_town` VALUES ('9', '东直门街道办事处', '110101009000', '110101000000');
INSERT INTO `t_s_town` VALUES ('10', '和平里街道办事处', '110101010000', '110101000000');
INSERT INTO `t_s_town` VALUES ('11', '前门街道办事处', '110101011000', '110101000000');
INSERT INTO `t_s_town` VALUES ('12', '崇文门外街道办事处', '110101012000', '110101000000');
INSERT INTO `t_s_town` VALUES ('13', '东花市街道办事处', '110101013000', '110101000000');
INSERT INTO `t_s_town` VALUES ('14', '龙潭街道办事处', '110101014000', '110101000000');
INSERT INTO `t_s_town` VALUES ('15', '体育馆路街道办事处', '110101015000', '110101000000');
INSERT INTO `t_s_town` VALUES ('16', '天坛街道办事处', '110101016000', '110101000000');
INSERT INTO `t_s_town` VALUES ('17', '永定门外街道办事处', '110101017000', '110101000000');
INSERT INTO `t_s_town` VALUES ('18', '西长安街街道办事处', '110102001000', '110102000000');
INSERT INTO `t_s_town` VALUES ('19', '新街口街道办事处', '110102003000', '110102000000');
INSERT INTO `t_s_town` VALUES ('20', '月坛街道办事处', '110102007000', '110102000000');
INSERT INTO `t_s_town` VALUES ('21', '展览路街道办事处', '110102009000', '110102000000');
INSERT INTO `t_s_town` VALUES ('22', '德胜街道办事处', '110102010000', '110102000000');
INSERT INTO `t_s_town` VALUES ('23', '金融街街道办事处', '110102011000', '110102000000');
INSERT INTO `t_s_town` VALUES ('24', '什刹海街道办事处', '110102012000', '110102000000');
INSERT INTO `t_s_town` VALUES ('25', '大栅栏街道办事处', '110102013000', '110102000000');
INSERT INTO `t_s_town` VALUES ('26', '天桥街道办事处', '110102014000', '110102000000');
INSERT INTO `t_s_town` VALUES ('27', '椿树街道办事处', '110102015000', '110102000000');
INSERT INTO `t_s_town` VALUES ('28', '陶然亭街道办事处', '110102016000', '110102000000');
INSERT INTO `t_s_town` VALUES ('29', '广安门内街道办事处', '110102017000', '110102000000');
INSERT INTO `t_s_town` VALUES ('30', '牛街街道办事处', '110102018000', '110102000000');
INSERT INTO `t_s_town` VALUES ('31', '白纸坊街道办事处', '110102019000', '110102000000');
INSERT INTO `t_s_town` VALUES ('32', '广安门外街道办事处', '110102020000', '110102000000');
INSERT INTO `t_s_town` VALUES ('33', '建外街道办事处', '110105001000', '110105000000');
INSERT INTO `t_s_town` VALUES ('34', '朝外街道办事处', '110105002000', '110105000000');
INSERT INTO `t_s_town` VALUES ('35', '呼家楼街道办事处', '110105003000', '110105000000');
INSERT INTO `t_s_town` VALUES ('36', '三里屯街道办事处', '110105004000', '110105000000');
INSERT INTO `t_s_town` VALUES ('37', '左家庄街道办事处', '110105005000', '110105000000');
INSERT INTO `t_s_town` VALUES ('38', '香河园街道办事处', '110105006000', '110105000000');
INSERT INTO `t_s_town` VALUES ('39', '和平街街道办事处', '110105007000', '110105000000');
INSERT INTO `t_s_town` VALUES ('40', '安贞街道办事处', '110105008000', '110105000000');
INSERT INTO `t_s_town` VALUES ('41', '亚运村街道办事处', '110105009000', '110105000000');
INSERT INTO `t_s_town` VALUES ('42', '小关街道办事处', '110105010000', '110105000000');
INSERT INTO `t_s_town` VALUES ('43', '酒仙桥街道办事处', '110105011000', '110105000000');
INSERT INTO `t_s_town` VALUES ('44', '麦子店街道办事处', '110105012000', '110105000000');
INSERT INTO `t_s_town` VALUES ('45', '团结湖街道办事处', '110105013000', '110105000000');
INSERT INTO `t_s_town` VALUES ('46', '六里屯街道办事处', '110105014000', '110105000000');
INSERT INTO `t_s_town` VALUES ('47', '八里庄街道办事处', '110105015000', '110105000000');
INSERT INTO `t_s_town` VALUES ('48', '双井街道办事处', '110105016000', '110105000000');
INSERT INTO `t_s_town` VALUES ('49', '劲松街道办事处', '110105017000', '110105000000');
INSERT INTO `t_s_town` VALUES ('50', '潘家园街道办事处', '110105018000', '110105000000');
INSERT INTO `t_s_town` VALUES ('51', '垡头街道办事处', '110105019000', '110105000000');
INSERT INTO `t_s_town` VALUES ('52', '南磨房地区办事处', '110105021000', '110105000000');
INSERT INTO `t_s_town` VALUES ('53', '高碑店地区办事处', '110105022000', '110105000000');
INSERT INTO `t_s_town` VALUES ('54', '将台地区办事处', '110105023000', '110105000000');
INSERT INTO `t_s_town` VALUES ('55', '太阳宫地区办事处', '110105024000', '110105000000');
INSERT INTO `t_s_town` VALUES ('56', '大屯街道办事处', '110105025000', '110105000000');
INSERT INTO `t_s_town` VALUES ('57', '望京街道办事处', '110105026000', '110105000000');
INSERT INTO `t_s_town` VALUES ('58', '小红门地区办事处', '110105027000', '110105000000');
INSERT INTO `t_s_town` VALUES ('59', '十八里店地区办事处', '110105028000', '110105000000');
INSERT INTO `t_s_town` VALUES ('60', '平房地区办事处', '110105029000', '110105000000');
INSERT INTO `t_s_town` VALUES ('61', '东风地区办事处', '110105030000', '110105000000');
INSERT INTO `t_s_town` VALUES ('62', '奥运村街道办事处', '110105031000', '110105000000');
INSERT INTO `t_s_town` VALUES ('63', '来广营地区办事处', '110105032000', '110105000000');
INSERT INTO `t_s_town` VALUES ('64', '常营地区办事处', '110105033000', '110105000000');
INSERT INTO `t_s_town` VALUES ('65', '三间房地区办事处', '110105034000', '110105000000');
INSERT INTO `t_s_town` VALUES ('66', '管庄地区办事处', '110105035000', '110105000000');
INSERT INTO `t_s_town` VALUES ('67', '金盏地区办事处', '110105036000', '110105000000');
INSERT INTO `t_s_town` VALUES ('68', '孙河地区办事处', '110105037000', '110105000000');
INSERT INTO `t_s_town` VALUES ('69', '崔各庄地区办事处', '110105038000', '110105000000');
INSERT INTO `t_s_town` VALUES ('70', '东坝地区办事处', '110105039000', '110105000000');
INSERT INTO `t_s_town` VALUES ('71', '黑庄户地区办事处', '110105040000', '110105000000');
INSERT INTO `t_s_town` VALUES ('72', '豆各庄地区办事处', '110105041000', '110105000000');
INSERT INTO `t_s_town` VALUES ('73', '王四营地区办事处', '110105042000', '110105000000');
INSERT INTO `t_s_town` VALUES ('74', '东湖街道办事处', '110105043000', '110105000000');
INSERT INTO `t_s_town` VALUES ('75', '首都机场街道办事处', '110105400000', '110105000000');
INSERT INTO `t_s_town` VALUES ('76', '右安门街道办事处', '110106001000', '110106000000');
INSERT INTO `t_s_town` VALUES ('77', '太平桥街道办事处', '110106002000', '110106000000');
INSERT INTO `t_s_town` VALUES ('78', '西罗园街道办事处', '110106003000', '110106000000');
INSERT INTO `t_s_town` VALUES ('79', '大红门街道办事处', '110106004000', '110106000000');
INSERT INTO `t_s_town` VALUES ('80', '南苑街道办事处', '110106005000', '110106000000');
INSERT INTO `t_s_town` VALUES ('81', '东高地街道办事处', '110106006000', '110106000000');
INSERT INTO `t_s_town` VALUES ('82', '东铁匠营街道办事处', '110106007000', '110106000000');
INSERT INTO `t_s_town` VALUES ('83', '卢沟桥街道办事处', '110106008000', '110106000000');
INSERT INTO `t_s_town` VALUES ('84', '丰台街道办事处', '110106009000', '110106000000');
INSERT INTO `t_s_town` VALUES ('85', '新村街道办事处', '110106010000', '110106000000');
INSERT INTO `t_s_town` VALUES ('86', '长辛店街道办事处', '110106011000', '110106000000');
INSERT INTO `t_s_town` VALUES ('87', '云岗街道办事处', '110106012000', '110106000000');
INSERT INTO `t_s_town` VALUES ('88', '方庄地区办事处', '110106013000', '110106000000');
INSERT INTO `t_s_town` VALUES ('89', '宛平城地区办事处', '110106014000', '110106000000');
INSERT INTO `t_s_town` VALUES ('90', '马家堡街道办事处', '110106015000', '110106000000');
INSERT INTO `t_s_town` VALUES ('91', '和义街道办事处', '110106016000', '110106000000');
INSERT INTO `t_s_town` VALUES ('92', '卢沟桥地区办事处', '110106017000', '110106000000');
INSERT INTO `t_s_town` VALUES ('93', '花乡地区办事处', '110106018000', '110106000000');
INSERT INTO `t_s_town` VALUES ('94', '南苑地区办事处', '110106019000', '110106000000');
INSERT INTO `t_s_town` VALUES ('95', '长辛店镇', '110106100000', '110106000000');
INSERT INTO `t_s_town` VALUES ('96', '王佐镇', '110106101000', '110106000000');
INSERT INTO `t_s_town` VALUES ('97', '八宝山街道办事处', '110107001000', '110107000000');
INSERT INTO `t_s_town` VALUES ('98', '老山街道办事处', '110107002000', '110107000000');
INSERT INTO `t_s_town` VALUES ('99', '八角街道办事处', '110107003000', '110107000000');
INSERT INTO `t_s_town` VALUES ('100', '古城街道办事处', '110107004000', '110107000000');
INSERT INTO `t_s_town` VALUES ('101', '苹果园街道办事处', '110107005000', '110107000000');
INSERT INTO `t_s_town` VALUES ('102', '金顶街街道办事处', '110107006000', '110107000000');
INSERT INTO `t_s_town` VALUES ('103', '广宁街道办事处', '110107009000', '110107000000');
INSERT INTO `t_s_town` VALUES ('104', '五里坨街道办事处', '110107010000', '110107000000');
INSERT INTO `t_s_town` VALUES ('105', '鲁谷街道办事处', '110107011000', '110107000000');
INSERT INTO `t_s_town` VALUES ('106', '万寿路街道办事处', '110108001000', '110108000000');
INSERT INTO `t_s_town` VALUES ('107', '永定路街道办事处', '110108002000', '110108000000');
INSERT INTO `t_s_town` VALUES ('108', '羊坊店街道办事处', '110108003000', '110108000000');
INSERT INTO `t_s_town` VALUES ('109', '甘家口街道办事处', '110108004000', '110108000000');
INSERT INTO `t_s_town` VALUES ('110', '八里庄街道办事处', '110108005000', '110108000000');
INSERT INTO `t_s_town` VALUES ('111', '紫竹院街道办事处', '110108006000', '110108000000');
INSERT INTO `t_s_town` VALUES ('112', '北下关街道办事处', '110108007000', '110108000000');
INSERT INTO `t_s_town` VALUES ('113', '北太平庄街道办事处', '110108008000', '110108000000');
INSERT INTO `t_s_town` VALUES ('114', '学院路街道办事处', '110108010000', '110108000000');
INSERT INTO `t_s_town` VALUES ('115', '中关村街道办事处', '110108011000', '110108000000');
INSERT INTO `t_s_town` VALUES ('116', '海淀街道办事处', '110108012000', '110108000000');
INSERT INTO `t_s_town` VALUES ('117', '青龙桥街道办事处', '110108013000', '110108000000');
INSERT INTO `t_s_town` VALUES ('118', '清华园街道办事处', '110108014000', '110108000000');
INSERT INTO `t_s_town` VALUES ('119', '燕园街道办事处', '110108015000', '110108000000');
INSERT INTO `t_s_town` VALUES ('120', '香山街道办事处', '110108016000', '110108000000');
INSERT INTO `t_s_town` VALUES ('121', '清河街道办事处', '110108017000', '110108000000');
INSERT INTO `t_s_town` VALUES ('122', '花园路街道办事处', '110108018000', '110108000000');
INSERT INTO `t_s_town` VALUES ('123', '西三旗街道办事处', '110108019000', '110108000000');
INSERT INTO `t_s_town` VALUES ('124', '马连洼街道办事处', '110108020000', '110108000000');
INSERT INTO `t_s_town` VALUES ('125', '田村路街道办事处', '110108021000', '110108000000');
INSERT INTO `t_s_town` VALUES ('126', '上地街道办事处', '110108022000', '110108000000');
INSERT INTO `t_s_town` VALUES ('127', '万柳地区办事处', '110108023000', '110108000000');
INSERT INTO `t_s_town` VALUES ('128', '东升地区办事处', '110108024000', '110108000000');
INSERT INTO `t_s_town` VALUES ('129', '曙光街道办事处', '110108025000', '110108000000');
INSERT INTO `t_s_town` VALUES ('130', '温泉地区办事处', '110108026000', '110108000000');
INSERT INTO `t_s_town` VALUES ('131', '四季青地区办事处', '110108027000', '110108000000');
INSERT INTO `t_s_town` VALUES ('132', '西北旺地区办事处', '110108028000', '110108000000');
INSERT INTO `t_s_town` VALUES ('133', '苏家坨地区办事处', '110108029000', '110108000000');
INSERT INTO `t_s_town` VALUES ('134', '上庄地区办事处', '110108030000', '110108000000');
INSERT INTO `t_s_town` VALUES ('135', '大峪街道办事处', '110109001000', '110109000000');
INSERT INTO `t_s_town` VALUES ('136', '城子街道办事处', '110109002000', '110109000000');
INSERT INTO `t_s_town` VALUES ('137', '东辛房街道办事处', '110109003000', '110109000000');
INSERT INTO `t_s_town` VALUES ('138', '大台街道办事处', '110109004000', '110109000000');
INSERT INTO `t_s_town` VALUES ('139', '王平地区办事处', '110109005000', '110109000000');
INSERT INTO `t_s_town` VALUES ('140', '永定地区办事处', '110109006000', '110109000000');
INSERT INTO `t_s_town` VALUES ('141', '龙泉地区办事处', '110109007000', '110109000000');
INSERT INTO `t_s_town` VALUES ('142', '潭柘寺镇', '110109101000', '110109000000');
INSERT INTO `t_s_town` VALUES ('143', '军庄镇', '110109104000', '110109000000');
INSERT INTO `t_s_town` VALUES ('144', '雁翅镇', '110109105000', '110109000000');
INSERT INTO `t_s_town` VALUES ('145', '斋堂镇', '110109106000', '110109000000');
INSERT INTO `t_s_town` VALUES ('146', '清水镇', '110109107000', '110109000000');
INSERT INTO `t_s_town` VALUES ('147', '妙峰山镇', '110109108000', '110109000000');
INSERT INTO `t_s_town` VALUES ('148', '城关街道办事处', '110111001000', '110111000000');
INSERT INTO `t_s_town` VALUES ('149', '新镇街道办事处', '110111002000', '110111000000');
INSERT INTO `t_s_town` VALUES ('150', '向阳街道办事处', '110111004000', '110111000000');
INSERT INTO `t_s_town` VALUES ('151', '东风街道办事处', '110111005000', '110111000000');
INSERT INTO `t_s_town` VALUES ('152', '迎风街道办事处', '110111006000', '110111000000');
INSERT INTO `t_s_town` VALUES ('153', '星城街道办事处', '110111007000', '110111000000');
INSERT INTO `t_s_town` VALUES ('154', '良乡地区办事处', '110111008000', '110111000000');
INSERT INTO `t_s_town` VALUES ('155', '周口店地区办事处', '110111009000', '110111000000');
INSERT INTO `t_s_town` VALUES ('156', '琉璃河地区办事处', '110111010000', '110111000000');
INSERT INTO `t_s_town` VALUES ('157', '拱辰街道办事处', '110111011000', '110111000000');
INSERT INTO `t_s_town` VALUES ('158', '西潞街道办事处', '110111012000', '110111000000');
INSERT INTO `t_s_town` VALUES ('159', '阎村镇', '110111101000', '110111000000');
INSERT INTO `t_s_town` VALUES ('160', '窦店镇', '110111103000', '110111000000');
INSERT INTO `t_s_town` VALUES ('161', '石楼镇', '110111104000', '110111000000');
INSERT INTO `t_s_town` VALUES ('162', '长阳镇', '110111105000', '110111000000');
INSERT INTO `t_s_town` VALUES ('163', '河北镇', '110111107000', '110111000000');
INSERT INTO `t_s_town` VALUES ('164', '长沟镇', '110111108000', '110111000000');
INSERT INTO `t_s_town` VALUES ('165', '大石窝镇', '110111109000', '110111000000');
INSERT INTO `t_s_town` VALUES ('166', '张坊镇', '110111110000', '110111000000');
INSERT INTO `t_s_town` VALUES ('167', '十渡镇', '110111111000', '110111000000');
INSERT INTO `t_s_town` VALUES ('168', '青龙湖镇', '110111112000', '110111000000');
INSERT INTO `t_s_town` VALUES ('169', '韩村河镇', '110111115000', '110111000000');
INSERT INTO `t_s_town` VALUES ('170', '霞云岭乡', '110111208000', '110111000000');
INSERT INTO `t_s_town` VALUES ('171', '南窖乡', '110111209000', '110111000000');
INSERT INTO `t_s_town` VALUES ('172', '佛子庄乡', '110111210000', '110111000000');
INSERT INTO `t_s_town` VALUES ('173', '大安山乡', '110111211000', '110111000000');
INSERT INTO `t_s_town` VALUES ('174', '史家营乡', '110111212000', '110111000000');
INSERT INTO `t_s_town` VALUES ('175', '蒲洼乡', '110111213000', '110111000000');
INSERT INTO `t_s_town` VALUES ('176', '中仓街道办事处', '110112001000', '110112000000');
INSERT INTO `t_s_town` VALUES ('177', '新华街道办事处', '110112002000', '110112000000');
INSERT INTO `t_s_town` VALUES ('178', '北苑街道办事处', '110112003000', '110112000000');
INSERT INTO `t_s_town` VALUES ('179', '玉桥街道办事处', '110112004000', '110112000000');
INSERT INTO `t_s_town` VALUES ('180', '永顺地区办事处', '110112005000', '110112000000');
INSERT INTO `t_s_town` VALUES ('181', '梨园地区办事处', '110112006000', '110112000000');
INSERT INTO `t_s_town` VALUES ('182', '宋庄镇', '110112104000', '110112000000');
INSERT INTO `t_s_town` VALUES ('183', '张家湾镇', '110112105000', '110112000000');
INSERT INTO `t_s_town` VALUES ('184', '漷县镇', '110112106000', '110112000000');
INSERT INTO `t_s_town` VALUES ('185', '马驹桥镇', '110112109000', '110112000000');
INSERT INTO `t_s_town` VALUES ('186', '西集镇', '110112110000', '110112000000');
INSERT INTO `t_s_town` VALUES ('187', '台湖镇', '110112114000', '110112000000');
INSERT INTO `t_s_town` VALUES ('188', '永乐店镇', '110112117000', '110112000000');
INSERT INTO `t_s_town` VALUES ('189', '潞城镇', '110112119000', '110112000000');
INSERT INTO `t_s_town` VALUES ('190', '于家务回族乡', '110112209000', '110112000000');
INSERT INTO `t_s_town` VALUES ('191', '胜利街道办事处', '110113001000', '110113000000');
INSERT INTO `t_s_town` VALUES ('192', '光明街道办事处', '110113002000', '110113000000');
INSERT INTO `t_s_town` VALUES ('193', '仁和地区办事处', '110113003000', '110113000000');
INSERT INTO `t_s_town` VALUES ('194', '后沙峪地区办事处', '110113004000', '110113000000');
INSERT INTO `t_s_town` VALUES ('195', '天竺地区办事处', '110113005000', '110113000000');
INSERT INTO `t_s_town` VALUES ('196', '杨镇地区办事处', '110113006000', '110113000000');
INSERT INTO `t_s_town` VALUES ('197', '牛栏山地区办事处', '110113007000', '110113000000');
INSERT INTO `t_s_town` VALUES ('198', '南法信地区办事处', '110113008000', '110113000000');
INSERT INTO `t_s_town` VALUES ('199', '马坡地区办事处', '110113009000', '110113000000');
INSERT INTO `t_s_town` VALUES ('200', '石园街道办事处', '110113010000', '110113000000');
INSERT INTO `t_s_town` VALUES ('201', '空港街道办事处', '110113011000', '110113000000');
INSERT INTO `t_s_town` VALUES ('202', '双丰街道办事处', '110113012000', '110113000000');
INSERT INTO `t_s_town` VALUES ('203', '旺泉街道办事处', '110113013000', '110113000000');
INSERT INTO `t_s_town` VALUES ('204', '高丽营镇', '110113101000', '110113000000');
INSERT INTO `t_s_town` VALUES ('205', '李桥镇', '110113104000', '110113000000');
INSERT INTO `t_s_town` VALUES ('206', '李遂镇', '110113105000', '110113000000');
INSERT INTO `t_s_town` VALUES ('207', '南彩镇', '110113106000', '110113000000');
INSERT INTO `t_s_town` VALUES ('208', '北务镇', '110113108000', '110113000000');
INSERT INTO `t_s_town` VALUES ('209', '大孙各庄镇', '110113109000', '110113000000');
INSERT INTO `t_s_town` VALUES ('210', '张镇', '110113110000', '110113000000');
INSERT INTO `t_s_town` VALUES ('211', '龙湾屯镇', '110113111000', '110113000000');
INSERT INTO `t_s_town` VALUES ('212', '木林镇', '110113112000', '110113000000');
INSERT INTO `t_s_town` VALUES ('213', '北小营镇', '110113113000', '110113000000');
INSERT INTO `t_s_town` VALUES ('214', '北石槽镇', '110113115000', '110113000000');
INSERT INTO `t_s_town` VALUES ('215', '赵全营镇', '110113116000', '110113000000');
INSERT INTO `t_s_town` VALUES ('216', '城北街道办事处', '110114001000', '110114000000');
INSERT INTO `t_s_town` VALUES ('217', '南口地区办事处', '110114002000', '110114000000');
INSERT INTO `t_s_town` VALUES ('218', '马池口地区办事处', '110114003000', '110114000000');
INSERT INTO `t_s_town` VALUES ('219', '沙河地区办事处', '110114004000', '110114000000');
INSERT INTO `t_s_town` VALUES ('220', '城南街道办事处', '110114005000', '110114000000');
INSERT INTO `t_s_town` VALUES ('221', '东小口地区办事处', '110114007000', '110114000000');
INSERT INTO `t_s_town` VALUES ('222', '天通苑北街道办事处', '110114008000', '110114000000');
INSERT INTO `t_s_town` VALUES ('223', '天通苑南街道办事处', '110114009000', '110114000000');
INSERT INTO `t_s_town` VALUES ('224', '霍营街道办事处', '110114010000', '110114000000');
INSERT INTO `t_s_town` VALUES ('225', '回龙观街道办事处', '110114011000', '110114000000');
INSERT INTO `t_s_town` VALUES ('226', '龙泽园街道办事处', '110114012000', '110114000000');
INSERT INTO `t_s_town` VALUES ('227', '史各庄街道办事处', '110114013000', '110114000000');
INSERT INTO `t_s_town` VALUES ('228', '阳坊镇', '110114104000', '110114000000');
INSERT INTO `t_s_town` VALUES ('229', '小汤山镇', '110114110000', '110114000000');
INSERT INTO `t_s_town` VALUES ('230', '南邵镇', '110114111000', '110114000000');
INSERT INTO `t_s_town` VALUES ('231', '崔村镇', '110114112000', '110114000000');
INSERT INTO `t_s_town` VALUES ('232', '百善镇', '110114113000', '110114000000');
INSERT INTO `t_s_town` VALUES ('233', '北七家镇', '110114115000', '110114000000');
INSERT INTO `t_s_town` VALUES ('234', '兴寿镇', '110114116000', '110114000000');
INSERT INTO `t_s_town` VALUES ('235', '流村镇', '110114118000', '110114000000');
INSERT INTO `t_s_town` VALUES ('236', '十三陵镇', '110114119000', '110114000000');
INSERT INTO `t_s_town` VALUES ('237', '延寿镇', '110114120000', '110114000000');
INSERT INTO `t_s_town` VALUES ('238', '兴丰街道办事处', '110115001000', '110115000000');
INSERT INTO `t_s_town` VALUES ('239', '林校路街道办事处', '110115002000', '110115000000');
INSERT INTO `t_s_town` VALUES ('240', '清源街道办事处', '110115003000', '110115000000');
INSERT INTO `t_s_town` VALUES ('241', '亦庄地区办事处', '110115004000', '110115000000');
INSERT INTO `t_s_town` VALUES ('242', '黄村地区办事处', '110115005000', '110115000000');
INSERT INTO `t_s_town` VALUES ('243', '旧宫地区办事处', '110115006000', '110115000000');
INSERT INTO `t_s_town` VALUES ('244', '西红门地区办事处', '110115007000', '110115000000');
INSERT INTO `t_s_town` VALUES ('245', '瀛海地区办事处', '110115008000', '110115000000');
INSERT INTO `t_s_town` VALUES ('246', '观音寺街道办事处', '110115009000', '110115000000');
INSERT INTO `t_s_town` VALUES ('247', '天宫院街道办事处', '110115010000', '110115000000');
INSERT INTO `t_s_town` VALUES ('248', '高米店街道办事处', '110115011000', '110115000000');
INSERT INTO `t_s_town` VALUES ('249', '荣华街道办事处', '110115012000', '110115000000');
INSERT INTO `t_s_town` VALUES ('250', '博兴街道办事处', '110115013000', '110115000000');
INSERT INTO `t_s_town` VALUES ('251', '青云店镇', '110115103000', '110115000000');
INSERT INTO `t_s_town` VALUES ('252', '采育镇', '110115104000', '110115000000');
INSERT INTO `t_s_town` VALUES ('253', '安定镇', '110115105000', '110115000000');
INSERT INTO `t_s_town` VALUES ('254', '礼贤镇', '110115106000', '110115000000');
INSERT INTO `t_s_town` VALUES ('255', '榆垡镇', '110115107000', '110115000000');
INSERT INTO `t_s_town` VALUES ('256', '庞各庄镇', '110115108000', '110115000000');
INSERT INTO `t_s_town` VALUES ('257', '北臧村镇', '110115109000', '110115000000');
INSERT INTO `t_s_town` VALUES ('258', '魏善庄镇', '110115110000', '110115000000');
INSERT INTO `t_s_town` VALUES ('259', '长子营镇', '110115111000', '110115000000');
INSERT INTO `t_s_town` VALUES ('260', '北京经济技术开发区', '110115403000', '110115000000');
INSERT INTO `t_s_town` VALUES ('261', '中关村国家自主创新示范区大兴生物医药产业基地', '110115404000', '110115000000');
INSERT INTO `t_s_town` VALUES ('262', '国家新媒体产业基地', '110115405000', '110115000000');
INSERT INTO `t_s_town` VALUES ('263', '泉河街道办事处', '110116001000', '110116000000');
INSERT INTO `t_s_town` VALUES ('264', '龙山街道办事处', '110116002000', '110116000000');
INSERT INTO `t_s_town` VALUES ('265', '怀柔地区办事处', '110116003000', '110116000000');
INSERT INTO `t_s_town` VALUES ('266', '雁栖地区办事处', '110116004000', '110116000000');
INSERT INTO `t_s_town` VALUES ('267', '庙城地区办事处', '110116005000', '110116000000');
INSERT INTO `t_s_town` VALUES ('268', '北房镇', '110116102000', '110116000000');
INSERT INTO `t_s_town` VALUES ('269', '杨宋镇', '110116103000', '110116000000');
INSERT INTO `t_s_town` VALUES ('270', '桥梓镇', '110116105000', '110116000000');
INSERT INTO `t_s_town` VALUES ('271', '怀北镇', '110116106000', '110116000000');
INSERT INTO `t_s_town` VALUES ('272', '汤河口镇', '110116107000', '110116000000');
INSERT INTO `t_s_town` VALUES ('273', '渤海镇', '110116108000', '110116000000');
INSERT INTO `t_s_town` VALUES ('274', '九渡河镇', '110116109000', '110116000000');
INSERT INTO `t_s_town` VALUES ('275', '琉璃庙镇', '110116110000', '110116000000');
INSERT INTO `t_s_town` VALUES ('276', '宝山镇', '110116111000', '110116000000');
INSERT INTO `t_s_town` VALUES ('277', '长哨营满族乡', '110116211000', '110116000000');
INSERT INTO `t_s_town` VALUES ('278', '喇叭沟门满族乡', '110116213000', '110116000000');
INSERT INTO `t_s_town` VALUES ('279', '北京雁栖经济开发区', '110116400000', '110116000000');
INSERT INTO `t_s_town` VALUES ('280', '滨河街道办事处', '110117001000', '110117000000');
INSERT INTO `t_s_town` VALUES ('281', '兴谷街道办事处', '110117002000', '110117000000');
INSERT INTO `t_s_town` VALUES ('282', '渔阳地区办事处', '110117003000', '110117000000');
INSERT INTO `t_s_town` VALUES ('283', '峪口地区办事处', '110117004000', '110117000000');
INSERT INTO `t_s_town` VALUES ('284', '马坊地区办事处', '110117005000', '110117000000');
INSERT INTO `t_s_town` VALUES ('285', '金海湖地区办事处', '110117006000', '110117000000');
INSERT INTO `t_s_town` VALUES ('286', '东高村镇', '110117101000', '110117000000');
INSERT INTO `t_s_town` VALUES ('287', '山东庄镇', '110117102000', '110117000000');
INSERT INTO `t_s_town` VALUES ('288', '南独乐河镇', '110117104000', '110117000000');
INSERT INTO `t_s_town` VALUES ('289', '大华山镇', '110117105000', '110117000000');
INSERT INTO `t_s_town` VALUES ('290', '夏各庄镇', '110117106000', '110117000000');
INSERT INTO `t_s_town` VALUES ('291', '马昌营镇', '110117108000', '110117000000');
INSERT INTO `t_s_town` VALUES ('292', '王辛庄镇', '110117110000', '110117000000');
INSERT INTO `t_s_town` VALUES ('293', '大兴庄镇', '110117111000', '110117000000');
INSERT INTO `t_s_town` VALUES ('294', '刘家店镇', '110117112000', '110117000000');
INSERT INTO `t_s_town` VALUES ('295', '镇罗营镇', '110117114000', '110117000000');
INSERT INTO `t_s_town` VALUES ('296', '黄松峪乡', '110117213000', '110117000000');
INSERT INTO `t_s_town` VALUES ('297', '熊儿寨乡', '110117214000', '110117000000');
INSERT INTO `t_s_town` VALUES ('298', '鼓楼街道办事处', '110118001000', '110118000000');
INSERT INTO `t_s_town` VALUES ('299', '果园街道办事处', '110118002000', '110118000000');
INSERT INTO `t_s_town` VALUES ('300', '檀营地区办事处', '110118003000', '110118000000');
INSERT INTO `t_s_town` VALUES ('301', '密云镇', '110118100000', '110118000000');
INSERT INTO `t_s_town` VALUES ('302', '溪翁庄镇', '110118101000', '110118000000');
INSERT INTO `t_s_town` VALUES ('303', '西田各庄镇', '110118102000', '110118000000');
INSERT INTO `t_s_town` VALUES ('304', '十里堡镇', '110118103000', '110118000000');
INSERT INTO `t_s_town` VALUES ('305', '河南寨镇', '110118104000', '110118000000');
INSERT INTO `t_s_town` VALUES ('306', '巨各庄镇', '110118105000', '110118000000');
INSERT INTO `t_s_town` VALUES ('307', '穆家峪镇', '110118106000', '110118000000');
INSERT INTO `t_s_town` VALUES ('308', '太师屯镇', '110118107000', '110118000000');
INSERT INTO `t_s_town` VALUES ('309', '高岭镇', '110118108000', '110118000000');
INSERT INTO `t_s_town` VALUES ('310', '不老屯镇', '110118109000', '110118000000');
INSERT INTO `t_s_town` VALUES ('311', '冯家峪镇', '110118110000', '110118000000');
INSERT INTO `t_s_town` VALUES ('312', '古北口镇', '110118111000', '110118000000');
INSERT INTO `t_s_town` VALUES ('313', '大城子镇', '110118112000', '110118000000');
INSERT INTO `t_s_town` VALUES ('314', '东邵渠镇', '110118113000', '110118000000');
INSERT INTO `t_s_town` VALUES ('315', '北庄镇', '110118114000', '110118000000');
INSERT INTO `t_s_town` VALUES ('316', '新城子镇', '110118115000', '110118000000');
INSERT INTO `t_s_town` VALUES ('317', '石城镇', '110118116000', '110118000000');
INSERT INTO `t_s_town` VALUES ('318', '北京密云经济开发区', '110118400000', '110118000000');
INSERT INTO `t_s_town` VALUES ('319', '百泉街道办事处', '110119001000', '110119000000');
INSERT INTO `t_s_town` VALUES ('320', '香水园街道办事处', '110119002000', '110119000000');
INSERT INTO `t_s_town` VALUES ('321', '儒林街道办事处', '110119003000', '110119000000');
INSERT INTO `t_s_town` VALUES ('322', '延庆镇', '110119100000', '110119000000');
INSERT INTO `t_s_town` VALUES ('323', '康庄镇', '110119101000', '110119000000');
INSERT INTO `t_s_town` VALUES ('324', '八达岭镇', '110119102000', '110119000000');
INSERT INTO `t_s_town` VALUES ('325', '永宁镇', '110119103000', '110119000000');
INSERT INTO `t_s_town` VALUES ('326', '旧县镇', '110119104000', '110119000000');
INSERT INTO `t_s_town` VALUES ('327', '张山营镇', '110119105000', '110119000000');
INSERT INTO `t_s_town` VALUES ('328', '四海镇', '110119106000', '110119000000');
INSERT INTO `t_s_town` VALUES ('329', '千家店镇', '110119107000', '110119000000');
INSERT INTO `t_s_town` VALUES ('330', '沈家营镇', '110119108000', '110119000000');
INSERT INTO `t_s_town` VALUES ('331', '大榆树镇', '110119109000', '110119000000');
INSERT INTO `t_s_town` VALUES ('332', '井庄镇', '110119110000', '110119000000');
INSERT INTO `t_s_town` VALUES ('333', '大庄科乡', '110119200000', '110119000000');
INSERT INTO `t_s_town` VALUES ('334', '刘斌堡乡', '110119201000', '110119000000');
INSERT INTO `t_s_town` VALUES ('335', '香营乡', '110119202000', '110119000000');
INSERT INTO `t_s_town` VALUES ('336', '珍珠泉乡', '110119203000', '110119000000');
INSERT INTO `t_s_town` VALUES ('337', '劝业场街道', '120101001000', '120101000000');
INSERT INTO `t_s_town` VALUES ('338', '小白楼街道', '120101002000', '120101000000');
INSERT INTO `t_s_town` VALUES ('339', '五大道街道', '120101003000', '120101000000');
INSERT INTO `t_s_town` VALUES ('340', '新兴街道', '120101004000', '120101000000');
INSERT INTO `t_s_town` VALUES ('341', '南营门街道', '120101005000', '120101000000');
INSERT INTO `t_s_town` VALUES ('342', '南市街道', '120101006000', '120101000000');
INSERT INTO `t_s_town` VALUES ('343', '大王庄街道', '120102001000', '120102000000');
INSERT INTO `t_s_town` VALUES ('344', '大直沽街道', '120102002000', '120102000000');
INSERT INTO `t_s_town` VALUES ('345', '中山门街道', '120102003000', '120102000000');
INSERT INTO `t_s_town` VALUES ('346', '富民路街道', '120102004000', '120102000000');
INSERT INTO `t_s_town` VALUES ('347', '二号桥街道', '120102005000', '120102000000');
INSERT INTO `t_s_town` VALUES ('348', '春华街道', '120102006000', '120102000000');
INSERT INTO `t_s_town` VALUES ('349', '唐家口街道', '120102007000', '120102000000');
INSERT INTO `t_s_town` VALUES ('350', '向阳楼街道', '120102008000', '120102000000');
INSERT INTO `t_s_town` VALUES ('351', '常州道街道', '120102009000', '120102000000');
INSERT INTO `t_s_town` VALUES ('352', '上杭路街道', '120102010000', '120102000000');
INSERT INTO `t_s_town` VALUES ('353', '东新街道', '120102011000', '120102000000');
INSERT INTO `t_s_town` VALUES ('354', '鲁山道街道', '120102012000', '120102000000');
INSERT INTO `t_s_town` VALUES ('355', '天津铁厂街道', '120102013000', '120102000000');
INSERT INTO `t_s_town` VALUES ('356', '大营门街道', '120103001000', '120103000000');
INSERT INTO `t_s_town` VALUES ('357', '下瓦房街道', '120103002000', '120103000000');
INSERT INTO `t_s_town` VALUES ('358', '桃园街道', '120103003000', '120103000000');
INSERT INTO `t_s_town` VALUES ('359', '挂甲寺街道', '120103004000', '120103000000');
INSERT INTO `t_s_town` VALUES ('360', '马场街道', '120103005000', '120103000000');
INSERT INTO `t_s_town` VALUES ('361', '越秀路街道', '120103006000', '120103000000');
INSERT INTO `t_s_town` VALUES ('362', '友谊路街道', '120103007000', '120103000000');
INSERT INTO `t_s_town` VALUES ('363', '天塔街道', '120103008000', '120103000000');
INSERT INTO `t_s_town` VALUES ('364', '尖山街道', '120103009000', '120103000000');
INSERT INTO `t_s_town` VALUES ('365', '陈塘庄街道', '120103010000', '120103000000');
INSERT INTO `t_s_town` VALUES ('366', '柳林街道', '120103011000', '120103000000');
INSERT INTO `t_s_town` VALUES ('367', '东海街道', '120103012000', '120103000000');
INSERT INTO `t_s_town` VALUES ('368', '梅江街道', '120103013000', '120103000000');
INSERT INTO `t_s_town` VALUES ('369', '太湖路街道', '120103014000', '120103000000');
INSERT INTO `t_s_town` VALUES ('370', '长虹街道', '120104001000', '120104000000');
INSERT INTO `t_s_town` VALUES ('371', '鼓楼街道', '120104002000', '120104000000');
INSERT INTO `t_s_town` VALUES ('372', '兴南街道', '120104003000', '120104000000');
INSERT INTO `t_s_town` VALUES ('373', '广开街道', '120104004000', '120104000000');
INSERT INTO `t_s_town` VALUES ('374', '万兴街道', '120104005000', '120104000000');
INSERT INTO `t_s_town` VALUES ('375', '学府街道', '120104006000', '120104000000');
INSERT INTO `t_s_town` VALUES ('376', '向阳路街道', '120104007000', '120104000000');
INSERT INTO `t_s_town` VALUES ('377', '嘉陵道街道', '120104008000', '120104000000');
INSERT INTO `t_s_town` VALUES ('378', '王顶堤街道', '120104009000', '120104000000');
INSERT INTO `t_s_town` VALUES ('379', '水上公园街道', '120104010000', '120104000000');
INSERT INTO `t_s_town` VALUES ('380', '体育中心街道', '120104011000', '120104000000');
INSERT INTO `t_s_town` VALUES ('381', '华苑街道', '120104012000', '120104000000');
INSERT INTO `t_s_town` VALUES ('382', '光复道街道', '120105001000', '120105000000');
INSERT INTO `t_s_town` VALUES ('383', '望海楼街道', '120105002000', '120105000000');
INSERT INTO `t_s_town` VALUES ('384', '鸿顺里街道', '120105003000', '120105000000');
INSERT INTO `t_s_town` VALUES ('385', '新开河街道', '120105004000', '120105000000');
INSERT INTO `t_s_town` VALUES ('386', '铁东路街道', '120105005000', '120105000000');
INSERT INTO `t_s_town` VALUES ('387', '建昌道街道', '120105006000', '120105000000');
INSERT INTO `t_s_town` VALUES ('388', '宁园街道', '120105007000', '120105000000');
INSERT INTO `t_s_town` VALUES ('389', '王串场街道', '120105008000', '120105000000');
INSERT INTO `t_s_town` VALUES ('390', '江都路街道', '120105009000', '120105000000');
INSERT INTO `t_s_town` VALUES ('391', '月牙河街道', '120105010000', '120105000000');
INSERT INTO `t_s_town` VALUES ('392', '西于庄街道', '120106001000', '120106000000');
INSERT INTO `t_s_town` VALUES ('393', '双环村街道', '120106002000', '120106000000');
INSERT INTO `t_s_town` VALUES ('394', '咸阳北路街道', '120106003000', '120106000000');
INSERT INTO `t_s_town` VALUES ('395', '丁字沽街道', '120106004000', '120106000000');
INSERT INTO `t_s_town` VALUES ('396', '西沽街道', '120106005000', '120106000000');
INSERT INTO `t_s_town` VALUES ('397', '三条石街道', '120106006000', '120106000000');
INSERT INTO `t_s_town` VALUES ('398', '邵公庄街道', '120106008000', '120106000000');
INSERT INTO `t_s_town` VALUES ('399', '芥园街道', '120106009000', '120106000000');
INSERT INTO `t_s_town` VALUES ('400', '铃铛阁街道', '120106010000', '120106000000');
INSERT INTO `t_s_town` VALUES ('401', '大胡同街道', '120106011000', '120106000000');
INSERT INTO `t_s_town` VALUES ('402', '和苑街道办事处', '120106012000', '120106000000');
INSERT INTO `t_s_town` VALUES ('403', '张贵庄街道', '120110001000', '120110000000');
INSERT INTO `t_s_town` VALUES ('404', '丰年村街道', '120110002000', '120110000000');
INSERT INTO `t_s_town` VALUES ('405', '万新街道', '120110003000', '120110000000');
INSERT INTO `t_s_town` VALUES ('406', '无瑕街道', '120110004000', '120110000000');
INSERT INTO `t_s_town` VALUES ('407', '新立街道', '120110005000', '120110000000');
INSERT INTO `t_s_town` VALUES ('408', '华明街道', '120110006000', '120110000000');
INSERT INTO `t_s_town` VALUES ('409', '金钟街道', '120110007000', '120110000000');
INSERT INTO `t_s_town` VALUES ('410', '军粮城街道', '120110008000', '120110000000');
INSERT INTO `t_s_town` VALUES ('411', '金桥街道', '120110009000', '120110000000');
INSERT INTO `t_s_town` VALUES ('412', '华新街道', '120110010000', '120110000000');
INSERT INTO `t_s_town` VALUES ('413', '东丽湖街道', '120110011000', '120110000000');
INSERT INTO `t_s_town` VALUES ('414', '天津开发区西区', '120110400000', '120110000000');
INSERT INTO `t_s_town` VALUES ('415', '天津航空物流区', '120110401000', '120110000000');
INSERT INTO `t_s_town` VALUES ('416', '天津空港经济区', '120110402000', '120110000000');
INSERT INTO `t_s_town` VALUES ('417', '东丽区经济技术开发区', '120110403000', '120110000000');
INSERT INTO `t_s_town` VALUES ('418', '综合保税区', '120110405000', '120110000000');
INSERT INTO `t_s_town` VALUES ('419', '航空新城', '120110406000', '120110000000');
INSERT INTO `t_s_town` VALUES ('420', '服务滨海新区建设管理委员会', '120110407000', '120110000000');
INSERT INTO `t_s_town` VALUES ('421', '西营门街道', '120111001000', '120111000000');
INSERT INTO `t_s_town` VALUES ('422', '李七庄街道', '120111002000', '120111000000');
INSERT INTO `t_s_town` VALUES ('423', '赤龙南街道', '120111003000', '120111000000');
INSERT INTO `t_s_town` VALUES ('424', '中北镇', '120111100000', '120111000000');
INSERT INTO `t_s_town` VALUES ('425', '杨柳青镇', '120111101000', '120111000000');
INSERT INTO `t_s_town` VALUES ('426', '辛口镇', '120111102000', '120111000000');
INSERT INTO `t_s_town` VALUES ('427', '张家窝镇', '120111103000', '120111000000');
INSERT INTO `t_s_town` VALUES ('428', '精武镇', '120111104000', '120111000000');
INSERT INTO `t_s_town` VALUES ('429', '大寺镇', '120111105000', '120111000000');
INSERT INTO `t_s_town` VALUES ('430', '王稳庄镇', '120111106000', '120111000000');
INSERT INTO `t_s_town` VALUES ('431', '天津开发区微电子小区', '120111400000', '120111000000');
INSERT INTO `t_s_town` VALUES ('432', '新技术产业园区', '120111401000', '120111000000');
INSERT INTO `t_s_town` VALUES ('433', '西青高校区', '120111402000', '120111000000');
INSERT INTO `t_s_town` VALUES ('434', '西青区开发区', '120111450000', '120111000000');
INSERT INTO `t_s_town` VALUES ('435', '双新街道办事处', '120112001000', '120112000000');
INSERT INTO `t_s_town` VALUES ('436', '双林街道办事处', '120112002000', '120112000000');
INSERT INTO `t_s_town` VALUES ('437', '咸水沽镇', '120112100000', '120112000000');
INSERT INTO `t_s_town` VALUES ('438', '葛沽镇', '120112101000', '120112000000');
INSERT INTO `t_s_town` VALUES ('439', '小站镇', '120112102000', '120112000000');
INSERT INTO `t_s_town` VALUES ('440', '双港镇', '120112103000', '120112000000');
INSERT INTO `t_s_town` VALUES ('441', '辛庄镇', '120112104000', '120112000000');
INSERT INTO `t_s_town` VALUES ('442', '双桥河镇', '120112106000', '120112000000');
INSERT INTO `t_s_town` VALUES ('443', '八里台镇', '120112107000', '120112000000');
INSERT INTO `t_s_town` VALUES ('444', '北闸口镇', '120112108000', '120112000000');
INSERT INTO `t_s_town` VALUES ('445', '铁路十八局', '120112401000', '120112000000');
INSERT INTO `t_s_town` VALUES ('446', '长青办事处', '120112403000', '120112000000');
INSERT INTO `t_s_town` VALUES ('447', '津南开发区东区', '120112404000', '120112000000');
INSERT INTO `t_s_town` VALUES ('448', '津南开发区西区', '120112405000', '120112000000');
INSERT INTO `t_s_town` VALUES ('449', '海河教育园区', '120112407000', '120112000000');
INSERT INTO `t_s_town` VALUES ('450', '双林农场', '120112500000', '120112000000');
INSERT INTO `t_s_town` VALUES ('451', '津南国家农业园区', '120112501000', '120112000000');
INSERT INTO `t_s_town` VALUES ('452', '果园新村街道', '120113001000', '120113000000');
INSERT INTO `t_s_town` VALUES ('453', '集贤里街道', '120113002000', '120113000000');
INSERT INTO `t_s_town` VALUES ('454', '普东街道', '120113003000', '120113000000');
INSERT INTO `t_s_town` VALUES ('455', '瑞景街道', '120113004000', '120113000000');
INSERT INTO `t_s_town` VALUES ('456', '佳荣里街道', '120113005000', '120113000000');
INSERT INTO `t_s_town` VALUES ('457', '青源街道', '120113006000', '120113000000');
INSERT INTO `t_s_town` VALUES ('458', '广源街道', '120113007000', '120113000000');
INSERT INTO `t_s_town` VALUES ('459', '天穆镇', '120113100000', '120113000000');
INSERT INTO `t_s_town` VALUES ('460', '北仓镇', '120113101000', '120113000000');
INSERT INTO `t_s_town` VALUES ('461', '双街镇', '120113102000', '120113000000');
INSERT INTO `t_s_town` VALUES ('462', '双口镇', '120113103000', '120113000000');
INSERT INTO `t_s_town` VALUES ('463', '青光镇', '120113104000', '120113000000');
INSERT INTO `t_s_town` VALUES ('464', '宜兴埠镇', '120113106000', '120113000000');
INSERT INTO `t_s_town` VALUES ('465', '小淀镇', '120113107000', '120113000000');
INSERT INTO `t_s_town` VALUES ('466', '大张庄镇', '120113108000', '120113000000');
INSERT INTO `t_s_town` VALUES ('467', '西堤头镇', '120113111000', '120113000000');
INSERT INTO `t_s_town` VALUES ('468', '科技园区北区', '120113400000', '120113000000');
INSERT INTO `t_s_town` VALUES ('469', '科技园区南区', '120113401000', '120113000000');
INSERT INTO `t_s_town` VALUES ('470', '天津医药医疗器械工业园', '120113402000', '120113000000');
INSERT INTO `t_s_town` VALUES ('471', '天津陆路港物流装备产业园', '120113403000', '120113000000');
INSERT INTO `t_s_town` VALUES ('472', '天津风电产业园', '120113404000', '120113000000');
INSERT INTO `t_s_town` VALUES ('473', '红旗农场', '120113500000', '120113000000');
INSERT INTO `t_s_town` VALUES ('474', '曙光农场', '120113501000', '120113000000');
INSERT INTO `t_s_town` VALUES ('475', '杨村街道', '120114001000', '120114000000');
INSERT INTO `t_s_town` VALUES ('476', '下朱庄街道', '120114002000', '120114000000');
INSERT INTO `t_s_town` VALUES ('477', '东蒲洼街道', '120114003000', '120114000000');
INSERT INTO `t_s_town` VALUES ('478', '黄庄街道', '120114004000', '120114000000');
INSERT INTO `t_s_town` VALUES ('479', '徐官屯街道', '120114005000', '120114000000');
INSERT INTO `t_s_town` VALUES ('480', '运河西街道', '120114006000', '120114000000');
INSERT INTO `t_s_town` VALUES ('481', '梅厂镇', '120114101000', '120114000000');
INSERT INTO `t_s_town` VALUES ('482', '大碱厂镇', '120114102000', '120114000000');
INSERT INTO `t_s_town` VALUES ('483', '崔黄口镇', '120114103000', '120114000000');
INSERT INTO `t_s_town` VALUES ('484', '大良镇', '120114104000', '120114000000');
INSERT INTO `t_s_town` VALUES ('485', '下伍旗镇', '120114105000', '120114000000');
INSERT INTO `t_s_town` VALUES ('486', '南蔡村镇', '120114106000', '120114000000');
INSERT INTO `t_s_town` VALUES ('487', '大孟庄镇', '120114107000', '120114000000');
INSERT INTO `t_s_town` VALUES ('488', '泗村店镇', '120114108000', '120114000000');
INSERT INTO `t_s_town` VALUES ('489', '河西务镇', '120114109000', '120114000000');
INSERT INTO `t_s_town` VALUES ('490', '城关镇', '120114110000', '120114000000');
INSERT INTO `t_s_town` VALUES ('491', '东马圈镇', '120114111000', '120114000000');
INSERT INTO `t_s_town` VALUES ('492', '黄花店镇', '120114112000', '120114000000');
INSERT INTO `t_s_town` VALUES ('493', '石各庄镇', '120114113000', '120114000000');
INSERT INTO `t_s_town` VALUES ('494', '王庆坨镇', '120114114000', '120114000000');
INSERT INTO `t_s_town` VALUES ('495', '汊沽港镇', '120114115000', '120114000000');
INSERT INTO `t_s_town` VALUES ('496', '河北屯镇', '120114116000', '120114000000');
INSERT INTO `t_s_town` VALUES ('497', '上马台镇', '120114117000', '120114000000');
INSERT INTO `t_s_town` VALUES ('498', '大王古庄镇', '120114118000', '120114000000');
INSERT INTO `t_s_town` VALUES ('499', '陈咀镇', '120114119000', '120114000000');
INSERT INTO `t_s_town` VALUES ('500', '豆张庄镇', '120114120000', '120114000000');
INSERT INTO `t_s_town` VALUES ('501', '曹子里镇', '120114121000', '120114000000');
INSERT INTO `t_s_town` VALUES ('502', '大黄堡镇', '120114122000', '120114000000');
INSERT INTO `t_s_town` VALUES ('503', '高村镇', '120114123000', '120114000000');
INSERT INTO `t_s_town` VALUES ('504', '白古屯镇', '120114124000', '120114000000');
INSERT INTO `t_s_town` VALUES ('505', '天津开发区逸仙科学工业园', '120114400000', '120114000000');
INSERT INTO `t_s_town` VALUES ('506', '武清经济技术开发区', '120114401000', '120114000000');
INSERT INTO `t_s_town` VALUES ('507', '天津武清商务区', '120114402000', '120114000000');
INSERT INTO `t_s_town` VALUES ('508', '天津京滨工业园', '120114403000', '120114000000');
INSERT INTO `t_s_town` VALUES ('509', '天津京津电子商务产业园', '120114404000', '120114000000');
INSERT INTO `t_s_town` VALUES ('510', '天津武清汽车产业园', '120114405000', '120114000000');
INSERT INTO `t_s_town` VALUES ('511', '天津京津科技谷', '120114406000', '120114000000');
INSERT INTO `t_s_town` VALUES ('512', '京津高村科技创新园', '120114407000', '120114000000');
INSERT INTO `t_s_town` VALUES ('513', '武清农场', '120114500000', '120114000000');
INSERT INTO `t_s_town` VALUES ('514', '海滨街道', '120115001000', '120115000000');
INSERT INTO `t_s_town` VALUES ('515', '宝平街道', '120115002000', '120115000000');
INSERT INTO `t_s_town` VALUES ('516', '钰华街道', '120115003000', '120115000000');
INSERT INTO `t_s_town` VALUES ('517', '大白街道', '120115004000', '120115000000');
INSERT INTO `t_s_town` VALUES ('518', '口东街道', '120115005000', '120115000000');
INSERT INTO `t_s_town` VALUES ('519', '周良街道', '120115006000', '120115000000');
INSERT INTO `t_s_town` VALUES ('520', '潮阳街道', '120115007000', '120115000000');
INSERT INTO `t_s_town` VALUES ('521', '朝霞街道', '120115008000', '120115000000');
INSERT INTO `t_s_town` VALUES ('522', '大口屯镇', '120115101000', '120115000000');
INSERT INTO `t_s_town` VALUES ('523', '王卜庄镇', '120115103000', '120115000000');
INSERT INTO `t_s_town` VALUES ('524', '方家庄镇', '120115104000', '120115000000');
INSERT INTO `t_s_town` VALUES ('525', '林亭口镇', '120115105000', '120115000000');
INSERT INTO `t_s_town` VALUES ('526', '八门城镇', '120115106000', '120115000000');
INSERT INTO `t_s_town` VALUES ('527', '大钟庄镇', '120115107000', '120115000000');
INSERT INTO `t_s_town` VALUES ('528', '新安镇', '120115108000', '120115000000');
INSERT INTO `t_s_town` VALUES ('529', '霍各庄镇', '120115111000', '120115000000');
INSERT INTO `t_s_town` VALUES ('530', '新开口镇', '120115113000', '120115000000');
INSERT INTO `t_s_town` VALUES ('531', '大唐庄镇', '120115115000', '120115000000');
INSERT INTO `t_s_town` VALUES ('532', '牛道口镇', '120115119000', '120115000000');
INSERT INTO `t_s_town` VALUES ('533', '史各庄镇', '120115120000', '120115000000');
INSERT INTO `t_s_town` VALUES ('534', '郝各庄镇', '120115121000', '120115000000');
INSERT INTO `t_s_town` VALUES ('535', '牛家牌镇', '120115123000', '120115000000');
INSERT INTO `t_s_town` VALUES ('536', '尔王庄镇', '120115124000', '120115000000');
INSERT INTO `t_s_town` VALUES ('537', '黄庄镇', '120115125000', '120115000000');
INSERT INTO `t_s_town` VALUES ('538', '天宝工业园区', '120115453000', '120115000000');
INSERT INTO `t_s_town` VALUES ('539', '九园工业园区', '120115454000', '120115000000');
INSERT INTO `t_s_town` VALUES ('540', '京津新城', '120115455000', '120115000000');
INSERT INTO `t_s_town` VALUES ('541', '里自沽农场', '120115500000', '120115000000');
INSERT INTO `t_s_town` VALUES ('542', '黄庄农场', '120115501000', '120115000000');
INSERT INTO `t_s_town` VALUES ('543', '大钟农场', '120115502000', '120115000000');
INSERT INTO `t_s_town` VALUES ('544', '塘沽街道', '120116001000', '120116000000');
INSERT INTO `t_s_town` VALUES ('545', '杭州道街道', '120116005000', '120116000000');
INSERT INTO `t_s_town` VALUES ('546', '新河街道', '120116006000', '120116000000');
INSERT INTO `t_s_town` VALUES ('547', '大沽街道', '120116007000', '120116000000');
INSERT INTO `t_s_town` VALUES ('548', '新北街道', '120116008000', '120116000000');
INSERT INTO `t_s_town` VALUES ('549', '北塘街道', '120116009000', '120116000000');
INSERT INTO `t_s_town` VALUES ('550', '胡家园街道', '120116011000', '120116000000');
INSERT INTO `t_s_town` VALUES ('551', '新港街道', '120116012000', '120116000000');
INSERT INTO `t_s_town` VALUES ('552', '新村街道', '120116013000', '120116000000');
INSERT INTO `t_s_town` VALUES ('553', '泰达街道（天津经济技术开发区东区）', '120116014000', '120116000000');
INSERT INTO `t_s_town` VALUES ('554', '汉沽街道', '120116031000', '120116000000');
INSERT INTO `t_s_town` VALUES ('555', '寨上街道', '120116032000', '120116000000');
INSERT INTO `t_s_town` VALUES ('556', '茶淀街道', '120116033000', '120116000000');
INSERT INTO `t_s_town` VALUES ('557', '大港街道', '120116051000', '120116000000');
INSERT INTO `t_s_town` VALUES ('558', '古林街道', '120116053000', '120116000000');
INSERT INTO `t_s_town` VALUES ('559', '海滨街道', '120116054000', '120116000000');
INSERT INTO `t_s_town` VALUES ('560', '新城镇', '120116100000', '120116000000');
INSERT INTO `t_s_town` VALUES ('561', '杨家泊镇', '120116135000', '120116000000');
INSERT INTO `t_s_town` VALUES ('562', '太平镇', '120116156000', '120116000000');
INSERT INTO `t_s_town` VALUES ('563', '小王庄镇', '120116157000', '120116000000');
INSERT INTO `t_s_town` VALUES ('564', '中塘镇', '120116158000', '120116000000');
INSERT INTO `t_s_town` VALUES ('565', '天津经济技术开发区（其他片区）', '120116400000', '120116000000');
INSERT INTO `t_s_town` VALUES ('566', '天津港保税区', '120116401000', '120116000000');
INSERT INTO `t_s_town` VALUES ('567', '天津滨海新区高新技术产业开发区', '120116402000', '120116000000');
INSERT INTO `t_s_town` VALUES ('568', '东疆保税港区', '120116403000', '120116000000');
INSERT INTO `t_s_town` VALUES ('569', '中新天津生态城', '120116406000', '120116000000');
INSERT INTO `t_s_town` VALUES ('570', '天津滨海中关村科技园', '120116415000', '120116000000');
INSERT INTO `t_s_town` VALUES ('571', '芦台镇', '120117100000', '120117000000');
INSERT INTO `t_s_town` VALUES ('572', '宁河镇', '120117102000', '120117000000');
INSERT INTO `t_s_town` VALUES ('573', '苗庄镇', '120117103000', '120117000000');
INSERT INTO `t_s_town` VALUES ('574', '丰台镇', '120117104000', '120117000000');
INSERT INTO `t_s_town` VALUES ('575', '岳龙镇', '120117105000', '120117000000');
INSERT INTO `t_s_town` VALUES ('576', '板桥镇', '120117106000', '120117000000');
INSERT INTO `t_s_town` VALUES ('577', '潘庄镇', '120117107000', '120117000000');
INSERT INTO `t_s_town` VALUES ('578', '造甲城镇', '120117109000', '120117000000');
INSERT INTO `t_s_town` VALUES ('579', '七里海镇', '120117110000', '120117000000');
INSERT INTO `t_s_town` VALUES ('580', '大北涧沽镇', '120117111000', '120117000000');
INSERT INTO `t_s_town` VALUES ('581', '东棘坨镇', '120117112000', '120117000000');
INSERT INTO `t_s_town` VALUES ('582', '北淮淀镇', '120117113000', '120117000000');
INSERT INTO `t_s_town` VALUES ('583', '俵口镇', '120117114000', '120117000000');
INSERT INTO `t_s_town` VALUES ('584', '廉庄镇', '120117115000', '120117000000');
INSERT INTO `t_s_town` VALUES ('585', '宁河区贸易开发区', '120117400000', '120117000000');
INSERT INTO `t_s_town` VALUES ('586', '宁河区经济开发区', '120117401000', '120117000000');
INSERT INTO `t_s_town` VALUES ('587', '天津未来科技城开发区片区', '120117402000', '120117000000');
INSERT INTO `t_s_town` VALUES ('588', '天津未来科技城滨海高新区片区', '120117403000', '120117000000');
INSERT INTO `t_s_town` VALUES ('589', '天津未来科技城宁河片区现代产业区组团', '120117451000', '120117000000');
INSERT INTO `t_s_town` VALUES ('590', '天津未来科技城宁河片区潘庄工业区组团', '120117452000', '120117000000');
INSERT INTO `t_s_town` VALUES ('591', '天津未来科技城宁河片区北淮淀组团', '120117453000', '120117000000');
INSERT INTO `t_s_town` VALUES ('592', '潘庄农场', '120117500000', '120117000000');
INSERT INTO `t_s_town` VALUES ('593', '华康街道办事处', '120118001000', '120118000000');
INSERT INTO `t_s_town` VALUES ('594', '静海镇', '120118100000', '120118000000');
INSERT INTO `t_s_town` VALUES ('595', '唐官屯镇', '120118101000', '120118000000');
INSERT INTO `t_s_town` VALUES ('596', '独流镇', '120118102000', '120118000000');
INSERT INTO `t_s_town` VALUES ('597', '王口镇', '120118103000', '120118000000');
INSERT INTO `t_s_town` VALUES ('598', '台头镇', '120118104000', '120118000000');
INSERT INTO `t_s_town` VALUES ('599', '子牙镇', '120118105000', '120118000000');
INSERT INTO `t_s_town` VALUES ('600', '陈官屯镇', '120118106000', '120118000000');
INSERT INTO `t_s_town` VALUES ('601', '中旺镇', '120118107000', '120118000000');
INSERT INTO `t_s_town` VALUES ('602', '大邱庄镇', '120118108000', '120118000000');
INSERT INTO `t_s_town` VALUES ('603', '蔡公庄镇', '120118109000', '120118000000');
INSERT INTO `t_s_town` VALUES ('604', '梁头镇', '120118110000', '120118000000');
INSERT INTO `t_s_town` VALUES ('605', '团泊镇', '120118111000', '120118000000');
INSERT INTO `t_s_town` VALUES ('606', '双塘镇', '120118112000', '120118000000');
INSERT INTO `t_s_town` VALUES ('607', '大丰堆镇', '120118113000', '120118000000');
INSERT INTO `t_s_town` VALUES ('608', '沿庄镇', '120118114000', '120118000000');
INSERT INTO `t_s_town` VALUES ('609', '西翟庄镇', '120118115000', '120118000000');
INSERT INTO `t_s_town` VALUES ('610', '良王庄乡', '120118200000', '120118000000');
INSERT INTO `t_s_town` VALUES ('611', '杨成庄乡', '120118201000', '120118000000');
INSERT INTO `t_s_town` VALUES ('612', '天津静海经济开发区', '120118400000', '120118000000');
INSERT INTO `t_s_town` VALUES ('613', '天津子牙循环经济产业区', '120118402000', '120118000000');
INSERT INTO `t_s_town` VALUES ('614', '团泊新城', '120118403000', '120118000000');
INSERT INTO `t_s_town` VALUES ('615', '文昌街道办事处', '120119001000', '120119000000');
INSERT INTO `t_s_town` VALUES ('616', '渔阳镇', '120119100000', '120119000000');
INSERT INTO `t_s_town` VALUES ('617', '洇溜镇', '120119101000', '120119000000');
INSERT INTO `t_s_town` VALUES ('618', '官庄镇', '120119102000', '120119000000');
INSERT INTO `t_s_town` VALUES ('619', '马伸桥镇', '120119103000', '120119000000');
INSERT INTO `t_s_town` VALUES ('620', '下营镇', '120119104000', '120119000000');
INSERT INTO `t_s_town` VALUES ('621', '邦均镇', '120119105000', '120119000000');
INSERT INTO `t_s_town` VALUES ('622', '别山镇', '120119106000', '120119000000');
INSERT INTO `t_s_town` VALUES ('623', '尤古庄镇', '120119108000', '120119000000');
INSERT INTO `t_s_town` VALUES ('624', '上仓镇', '120119109000', '120119000000');
INSERT INTO `t_s_town` VALUES ('625', '下仓镇', '120119111000', '120119000000');
INSERT INTO `t_s_town` VALUES ('626', '罗庄子镇', '120119112000', '120119000000');
INSERT INTO `t_s_town` VALUES ('627', '白涧镇', '120119113000', '120119000000');
INSERT INTO `t_s_town` VALUES ('628', '五百户镇', '120119114000', '120119000000');
INSERT INTO `t_s_town` VALUES ('629', '侯家营镇', '120119115000', '120119000000');
INSERT INTO `t_s_town` VALUES ('630', '桑梓镇', '120119116000', '120119000000');
INSERT INTO `t_s_town` VALUES ('631', '东施古镇', '120119117000', '120119000000');
INSERT INTO `t_s_town` VALUES ('632', '下窝头镇', '120119118000', '120119000000');
INSERT INTO `t_s_town` VALUES ('633', '杨津庄镇', '120119119000', '120119000000');
INSERT INTO `t_s_town` VALUES ('634', '出头岭镇', '120119120000', '120119000000');
INSERT INTO `t_s_town` VALUES ('635', '西龙虎峪镇', '120119121000', '120119000000');
INSERT INTO `t_s_town` VALUES ('636', '穿芳峪镇', '120119122000', '120119000000');
INSERT INTO `t_s_town` VALUES ('637', '东二营镇', '120119123000', '120119000000');
INSERT INTO `t_s_town` VALUES ('638', '许家台镇', '120119124000', '120119000000');
INSERT INTO `t_s_town` VALUES ('639', '礼明庄镇', '120119125000', '120119000000');
INSERT INTO `t_s_town` VALUES ('640', '东赵各庄镇', '120119126000', '120119000000');
INSERT INTO `t_s_town` VALUES ('641', '孙各庄乡', '120119203000', '120119000000');
INSERT INTO `t_s_town` VALUES ('642', '蓟县新城建设管理委员会', '120119400000', '120119000000');
INSERT INTO `t_s_town` VALUES ('643', '建北街道办事处', '130102001000', '130102000000');
INSERT INTO `t_s_town` VALUES ('644', '青园街道办事处', '130102002000', '130102000000');
INSERT INTO `t_s_town` VALUES ('645', '广安街道办事处', '130102003000', '130102000000');
INSERT INTO `t_s_town` VALUES ('646', '育才街道办事处', '130102004000', '130102000000');
INSERT INTO `t_s_town` VALUES ('647', '跃进街道办事处', '130102005000', '130102000000');
INSERT INTO `t_s_town` VALUES ('648', '河东街道办事处', '130102007000', '130102000000');
INSERT INTO `t_s_town` VALUES ('649', '长丰街道办事处', '130102010000', '130102000000');
INSERT INTO `t_s_town` VALUES ('650', '谈固街道办事处', '130102011000', '130102000000');
INSERT INTO `t_s_town` VALUES ('651', '中山东路街道办事处', '130102012000', '130102000000');
INSERT INTO `t_s_town` VALUES ('652', '阜康街道办事处', '130102013000', '130102000000');
INSERT INTO `t_s_town` VALUES ('653', '建安街道办事处', '130102014000', '130102000000');
INSERT INTO `t_s_town` VALUES ('654', '胜利北街道办事处', '130102015000', '130102000000');
INSERT INTO `t_s_town` VALUES ('655', '西兆通镇', '130102100000', '130102000000');
INSERT INTO `t_s_town` VALUES ('656', '南村镇', '130102101000', '130102000000');
INSERT INTO `t_s_town` VALUES ('657', '高营镇', '130102102000', '130102000000');
INSERT INTO `t_s_town` VALUES ('658', '桃园镇', '130102103000', '130102000000');
INSERT INTO `t_s_town` VALUES ('659', '东里街道办事处', '130104001000', '130104000000');
INSERT INTO `t_s_town` VALUES ('660', '中山街道办事处', '130104002000', '130104000000');
INSERT INTO `t_s_town` VALUES ('661', '南长街道办事处', '130104004000', '130104000000');
INSERT INTO `t_s_town` VALUES ('662', '维明街道办事处', '130104005000', '130104000000');
INSERT INTO `t_s_town` VALUES ('663', '友谊街道办事处', '130104007000', '130104000000');
INSERT INTO `t_s_town` VALUES ('664', '红旗街道办事处', '130104008000', '130104000000');
INSERT INTO `t_s_town` VALUES ('665', '新石街道办事处', '130104009000', '130104000000');
INSERT INTO `t_s_town` VALUES ('666', '苑东街道办事处', '130104010000', '130104000000');
INSERT INTO `t_s_town` VALUES ('667', '西里街道办事处', '130104011000', '130104000000');
INSERT INTO `t_s_town` VALUES ('668', '振头街道办事处', '130104012000', '130104000000');
INSERT INTO `t_s_town` VALUES ('669', '留营街道办事处', '130104013000', '130104000000');
INSERT INTO `t_s_town` VALUES ('670', '长兴街道办事处', '130104014000', '130104000000');
INSERT INTO `t_s_town` VALUES ('671', '彭后街道办事处', '130104015000', '130104000000');
INSERT INTO `t_s_town` VALUES ('672', '东风街道办事处', '130104016000', '130104000000');
INSERT INTO `t_s_town` VALUES ('673', '东华街道办事处', '130104017000', '130104000000');
INSERT INTO `t_s_town` VALUES ('674', '休门街道办事处', '130104018000', '130104000000');
INSERT INTO `t_s_town` VALUES ('675', '汇通街道办事处', '130104019000', '130104000000');
INSERT INTO `t_s_town` VALUES ('676', '革新街街道办事处', '130105001000', '130105000000');
INSERT INTO `t_s_town` VALUES ('677', '新华路街道办事处', '130105003000', '130105000000');
INSERT INTO `t_s_town` VALUES ('678', '宁安街道办事处', '130105004000', '130105000000');
INSERT INTO `t_s_town` VALUES ('679', '东焦街道办事处', '130105005000', '130105000000');
INSERT INTO `t_s_town` VALUES ('680', '西苑街道办事处', '130105006000', '130105000000');
INSERT INTO `t_s_town` VALUES ('681', '合作路街道办事处', '130105007000', '130105000000');
INSERT INTO `t_s_town` VALUES ('682', '联盟街道办事处', '130105008000', '130105000000');
INSERT INTO `t_s_town` VALUES ('683', '石岗街道办事处', '130105009000', '130105000000');
INSERT INTO `t_s_town` VALUES ('684', '天苑街道办事处', '130105011000', '130105000000');
INSERT INTO `t_s_town` VALUES ('685', '北苑街道办事处', '130105012000', '130105000000');
INSERT INTO `t_s_town` VALUES ('686', '赵陵铺路街道办事处', '130105013000', '130105000000');
INSERT INTO `t_s_town` VALUES ('687', '西三庄街道办事处', '130105014000', '130105000000');
INSERT INTO `t_s_town` VALUES ('688', '大郭街道办事处', '130105015000', '130105000000');
INSERT INTO `t_s_town` VALUES ('689', '杜北街道办事处', '130105016000', '130105000000');
INSERT INTO `t_s_town` VALUES ('690', '赵佗路街道办事处', '130105017000', '130105000000');
INSERT INTO `t_s_town` VALUES ('691', '矿市街道办事处', '130107001000', '130107000000');
INSERT INTO `t_s_town` VALUES ('692', '四微街道办事处', '130107002000', '130107000000');
INSERT INTO `t_s_town` VALUES ('693', '贾庄镇', '130107100000', '130107000000');
INSERT INTO `t_s_town` VALUES ('694', '凤山镇', '130107101000', '130107000000');
INSERT INTO `t_s_town` VALUES ('695', '横涧乡', '130107200000', '130107000000');
INSERT INTO `t_s_town` VALUES ('696', '裕兴街道办事处', '130108001000', '130108000000');
INSERT INTO `t_s_town` VALUES ('697', '裕强街道办事处', '130108002000', '130108000000');
INSERT INTO `t_s_town` VALUES ('698', '东苑街道办事处', '130108003000', '130108000000');
INSERT INTO `t_s_town` VALUES ('699', '建通街道办事处', '130108004000', '130108000000');
INSERT INTO `t_s_town` VALUES ('700', '槐底街道办事处', '130108005000', '130108000000');
INSERT INTO `t_s_town` VALUES ('701', '裕华路街道办事处', '130108006000', '130108000000');
INSERT INTO `t_s_town` VALUES ('702', '裕东街道办事处', '130108007000', '130108000000');
INSERT INTO `t_s_town` VALUES ('703', '裕翔街道办事处', '130108008000', '130108000000');
INSERT INTO `t_s_town` VALUES ('704', '建华南街道办事处', '130108009000', '130108000000');
INSERT INTO `t_s_town` VALUES ('705', '方村镇', '130108101000', '130108000000');
INSERT INTO `t_s_town` VALUES ('706', '廉州镇', '130109100000', '130109000000');
INSERT INTO `t_s_town` VALUES ('707', '兴安镇', '130109101000', '130109000000');
INSERT INTO `t_s_town` VALUES ('708', '贾市庄镇', '130109102000', '130109000000');
INSERT INTO `t_s_town` VALUES ('709', '南营镇', '130109103000', '130109000000');
INSERT INTO `t_s_town` VALUES ('710', '梅花镇', '130109104000', '130109000000');
INSERT INTO `t_s_town` VALUES ('711', '岗上镇', '130109105000', '130109000000');
INSERT INTO `t_s_town` VALUES ('712', '南董镇', '130109107000', '130109000000');
INSERT INTO `t_s_town` VALUES ('713', '张家庄镇', '130109108000', '130109000000');
INSERT INTO `t_s_town` VALUES ('714', '南孟镇', '130109109000', '130109000000');
INSERT INTO `t_s_town` VALUES ('715', '增村镇', '130109110000', '130109000000');
INSERT INTO `t_s_town` VALUES ('716', '常安镇', '130109111000', '130109000000');
INSERT INTO `t_s_town` VALUES ('717', '西关镇', '130109112000', '130109000000');
INSERT INTO `t_s_town` VALUES ('718', '九门回族乡', '130109200000', '130109000000');
INSERT INTO `t_s_town` VALUES ('719', '石家庄经济技术开发区', '130109500000', '130109000000');
INSERT INTO `t_s_town` VALUES ('720', '获鹿镇', '130110100000', '130110000000');
INSERT INTO `t_s_town` VALUES ('721', '铜冶镇', '130110101000', '130110000000');
INSERT INTO `t_s_town` VALUES ('722', '寺家庄镇', '130110102000', '130110000000');
INSERT INTO `t_s_town` VALUES ('723', '上庄镇', '130110103000', '130110000000');
INSERT INTO `t_s_town` VALUES ('724', '李村镇', '130110104000', '130110000000');
INSERT INTO `t_s_town` VALUES ('725', '宜安镇', '130110105000', '130110000000');
INSERT INTO `t_s_town` VALUES ('726', '黄壁庄镇', '130110106000', '130110000000');
INSERT INTO `t_s_town` VALUES ('727', '大河镇', '130110107000', '130110000000');
INSERT INTO `t_s_town` VALUES ('728', '山尹村镇', '130110108000', '130110000000');
INSERT INTO `t_s_town` VALUES ('729', '石井乡', '130110200000', '130110000000');
INSERT INTO `t_s_town` VALUES ('730', '白鹿泉乡', '130110201000', '130110000000');
INSERT INTO `t_s_town` VALUES ('731', '上寨乡', '130110202000', '130110000000');
INSERT INTO `t_s_town` VALUES ('732', '河北鹿泉经济开发区', '130110500000', '130110000000');
INSERT INTO `t_s_town` VALUES ('733', '栾城镇', '130111100000', '130111000000');
INSERT INTO `t_s_town` VALUES ('734', '冶河镇', '130111103000', '130111000000');
INSERT INTO `t_s_town` VALUES ('735', '窦妪镇', '130111104000', '130111000000');
INSERT INTO `t_s_town` VALUES ('736', '楼底镇', '130111105000', '130111000000');
INSERT INTO `t_s_town` VALUES ('737', '南高乡', '130111200000', '130111000000');
INSERT INTO `t_s_town` VALUES ('738', '柳林屯乡', '130111201000', '130111000000');
INSERT INTO `t_s_town` VALUES ('739', '西营乡', '130111202000', '130111000000');
INSERT INTO `t_s_town` VALUES ('740', '微水镇', '130121100000', '130121000000');
INSERT INTO `t_s_town` VALUES ('741', '上安镇', '130121101000', '130121000000');
INSERT INTO `t_s_town` VALUES ('742', '天长镇', '130121102000', '130121000000');
INSERT INTO `t_s_town` VALUES ('743', '秀林镇', '130121103000', '130121000000');
INSERT INTO `t_s_town` VALUES ('744', '南峪镇', '130121104000', '130121000000');
INSERT INTO `t_s_town` VALUES ('745', '威州镇', '130121105000', '130121000000');
INSERT INTO `t_s_town` VALUES ('746', '小作镇', '130121106000', '130121000000');
INSERT INTO `t_s_town` VALUES ('747', '南障城镇', '130121107000', '130121000000');
INSERT INTO `t_s_town` VALUES ('748', '苍岩山镇', '130121108000', '130121000000');
INSERT INTO `t_s_town` VALUES ('749', '测鱼镇', '130121109000', '130121000000');
INSERT INTO `t_s_town` VALUES ('750', '吴家窑乡', '130121200000', '130121000000');
INSERT INTO `t_s_town` VALUES ('751', '北正乡', '130121201000', '130121000000');
INSERT INTO `t_s_town` VALUES ('752', '于家乡', '130121202000', '130121000000');
INSERT INTO `t_s_town` VALUES ('753', '孙庄乡', '130121203000', '130121000000');
INSERT INTO `t_s_town` VALUES ('754', '南陉乡', '130121204000', '130121000000');
INSERT INTO `t_s_town` VALUES ('755', '辛庄乡', '130121205000', '130121000000');
INSERT INTO `t_s_town` VALUES ('756', '南王庄乡', '130121206000', '130121000000');
INSERT INTO `t_s_town` VALUES ('757', '诸福屯街道办事处', '130123001000', '130123000000');
INSERT INTO `t_s_town` VALUES ('758', '三里屯街道办事处', '130123002000', '130123000000');
INSERT INTO `t_s_town` VALUES ('759', '正定镇', '130123100000', '130123000000');
INSERT INTO `t_s_town` VALUES ('760', '新城铺镇', '130123102000', '130123000000');
INSERT INTO `t_s_town` VALUES ('761', '新安镇', '130123103000', '130123000000');
INSERT INTO `t_s_town` VALUES ('762', '南牛乡', '130123200000', '130123000000');
INSERT INTO `t_s_town` VALUES ('763', '南楼乡', '130123201000', '130123000000');
INSERT INTO `t_s_town` VALUES ('764', '西平乐乡', '130123202000', '130123000000');
INSERT INTO `t_s_town` VALUES ('765', '北早现乡', '130123203000', '130123000000');
INSERT INTO `t_s_town` VALUES ('766', '曲阳桥乡', '130123204000', '130123000000');
INSERT INTO `t_s_town` VALUES ('767', '龙州镇', '130125100000', '130125000000');
INSERT INTO `t_s_town` VALUES ('768', '南桥镇', '130125101000', '130125000000');
INSERT INTO `t_s_town` VALUES ('769', '上碑镇', '130125102000', '130125000000');
INSERT INTO `t_s_town` VALUES ('770', '口头镇', '130125103000', '130125000000');
INSERT INTO `t_s_town` VALUES ('771', '独羊岗乡', '130125200000', '130125000000');
INSERT INTO `t_s_town` VALUES ('772', '安香乡', '130125201000', '130125000000');
INSERT INTO `t_s_town` VALUES ('773', '只里乡', '130125202000', '130125000000');
INSERT INTO `t_s_town` VALUES ('774', '市同乡', '130125203000', '130125000000');
INSERT INTO `t_s_town` VALUES ('775', '翟营乡', '130125204000', '130125000000');
INSERT INTO `t_s_town` VALUES ('776', '城寨乡', '130125205000', '130125000000');
INSERT INTO `t_s_town` VALUES ('777', '上方乡', '130125206000', '130125000000');
INSERT INTO `t_s_town` VALUES ('778', '玉亭乡', '130125207000', '130125000000');
INSERT INTO `t_s_town` VALUES ('779', '北河乡', '130125208000', '130125000000');
INSERT INTO `t_s_town` VALUES ('780', '上闫庄乡', '130125209000', '130125000000');
INSERT INTO `t_s_town` VALUES ('781', '九口子乡', '130125210000', '130125000000');
INSERT INTO `t_s_town` VALUES ('782', '开发区', '130125400000', '130125000000');
INSERT INTO `t_s_town` VALUES ('783', '灵寿镇', '130126100000', '130126000000');
INSERT INTO `t_s_town` VALUES ('784', '青同镇', '130126101000', '130126000000');
INSERT INTO `t_s_town` VALUES ('785', '塔上镇', '130126102000', '130126000000');
INSERT INTO `t_s_town` VALUES ('786', '陈庄镇', '130126103000', '130126000000');
INSERT INTO `t_s_town` VALUES ('787', '慈峪镇', '130126104000', '130126000000');
INSERT INTO `t_s_town` VALUES ('788', '岔头镇', '130126105000', '130126000000');
INSERT INTO `t_s_town` VALUES ('789', '三圣院乡', '130126200000', '130126000000');
INSERT INTO `t_s_town` VALUES ('790', '北洼乡', '130126201000', '130126000000');
INSERT INTO `t_s_town` VALUES ('791', '牛城乡', '130126202000', '130126000000');
INSERT INTO `t_s_town` VALUES ('792', '狗台乡', '130126203000', '130126000000');
INSERT INTO `t_s_town` VALUES ('793', '南寨乡', '130126204000', '130126000000');
INSERT INTO `t_s_town` VALUES ('794', '南燕川乡', '130126205000', '130126000000');
INSERT INTO `t_s_town` VALUES ('795', '北谭庄乡', '130126206000', '130126000000');
INSERT INTO `t_s_town` VALUES ('796', '寨头乡', '130126207000', '130126000000');
INSERT INTO `t_s_town` VALUES ('797', '南营乡', '130126208000', '130126000000');
INSERT INTO `t_s_town` VALUES ('798', '高邑镇', '130127100000', '130127000000');
INSERT INTO `t_s_town` VALUES ('799', '大营镇', '130127101000', '130127000000');
INSERT INTO `t_s_town` VALUES ('800', '富村镇', '130127102000', '130127000000');
INSERT INTO `t_s_town` VALUES ('801', '万城镇', '130127103000', '130127000000');
INSERT INTO `t_s_town` VALUES ('802', '中韩乡', '130127201000', '130127000000');
INSERT INTO `t_s_town` VALUES ('803', '深泽镇', '130128100000', '130128000000');
INSERT INTO `t_s_town` VALUES ('804', '铁杆镇', '130128101000', '130128000000');
INSERT INTO `t_s_town` VALUES ('805', '赵八镇', '130128102000', '130128000000');
INSERT INTO `t_s_town` VALUES ('806', '白庄乡', '130128200000', '130128000000');
INSERT INTO `t_s_town` VALUES ('807', '留村乡', '130128201000', '130128000000');
INSERT INTO `t_s_town` VALUES ('808', '桥头乡', '130128203000', '130128000000');
INSERT INTO `t_s_town` VALUES ('809', '赞皇镇', '130129100000', '130129000000');
INSERT INTO `t_s_town` VALUES ('810', '院头镇', '130129101000', '130129000000');
INSERT INTO `t_s_town` VALUES ('811', '南邢郭镇', '130129102000', '130129000000');
INSERT INTO `t_s_town` VALUES ('812', '嶂石岩镇', '130129103000', '130129000000');
INSERT INTO `t_s_town` VALUES ('813', '西龙门乡', '130129200000', '130129000000');
INSERT INTO `t_s_town` VALUES ('814', '南清河乡', '130129202000', '130129000000');
INSERT INTO `t_s_town` VALUES ('815', '西阳泽乡', '130129203000', '130129000000');
INSERT INTO `t_s_town` VALUES ('816', '土门乡', '130129204000', '130129000000');
INSERT INTO `t_s_town` VALUES ('817', '黄北坪乡', '130129205000', '130129000000');
INSERT INTO `t_s_town` VALUES ('818', '许亭乡', '130129207000', '130129000000');
INSERT INTO `t_s_town` VALUES ('819', '张楞乡', '130129208000', '130129000000');
INSERT INTO `t_s_town` VALUES ('820', '无极镇', '130130100000', '130130000000');
INSERT INTO `t_s_town` VALUES ('821', '七汲镇', '130130101000', '130130000000');
INSERT INTO `t_s_town` VALUES ('822', '张段固镇', '130130102000', '130130000000');
INSERT INTO `t_s_town` VALUES ('823', '北苏镇', '130130103000', '130130000000');
INSERT INTO `t_s_town` VALUES ('824', '郭庄镇', '130130104000', '130130000000');
INSERT INTO `t_s_town` VALUES ('825', '大陈镇', '130130105000', '130130000000');
INSERT INTO `t_s_town` VALUES ('826', '高头回族乡', '130130200000', '130130000000');
INSERT INTO `t_s_town` VALUES ('827', '郝庄乡', '130130201000', '130130000000');
INSERT INTO `t_s_town` VALUES ('828', '东侯坊乡', '130130202000', '130130000000');
INSERT INTO `t_s_town` VALUES ('829', '里城道乡', '130130203000', '130130000000');
INSERT INTO `t_s_town` VALUES ('830', '南流乡', '130130204000', '130130000000');
INSERT INTO `t_s_town` VALUES ('831', '平山镇', '130131100000', '130131000000');
INSERT INTO `t_s_town` VALUES ('832', '东回舍镇', '130131101000', '130131000000');
INSERT INTO `t_s_town` VALUES ('833', '温塘镇', '130131102000', '130131000000');
INSERT INTO `t_s_town` VALUES ('834', '南甸镇', '130131103000', '130131000000');
INSERT INTO `t_s_town` VALUES ('835', '岗南镇', '130131104000', '130131000000');
INSERT INTO `t_s_town` VALUES ('836', '古月镇', '130131105000', '130131000000');
INSERT INTO `t_s_town` VALUES ('837', '下槐镇', '130131106000', '130131000000');
INSERT INTO `t_s_town` VALUES ('838', '孟家庄镇', '130131107000', '130131000000');
INSERT INTO `t_s_town` VALUES ('839', '小觉镇', '130131108000', '130131000000');
INSERT INTO `t_s_town` VALUES ('840', '蛟潭庄镇', '130131109000', '130131000000');
INSERT INTO `t_s_town` VALUES ('841', '西柏坡镇', '130131110000', '130131000000');
INSERT INTO `t_s_town` VALUES ('842', '下口镇', '130131111000', '130131000000');
INSERT INTO `t_s_town` VALUES ('843', '西大吾乡', '130131200000', '130131000000');
INSERT INTO `t_s_town` VALUES ('844', '上三汲乡', '130131201000', '130131000000');
INSERT INTO `t_s_town` VALUES ('845', '两河乡', '130131202000', '130131000000');
INSERT INTO `t_s_town` VALUES ('846', '东王坡乡', '130131203000', '130131000000');
INSERT INTO `t_s_town` VALUES ('847', '苏家庄乡', '130131204000', '130131000000');
INSERT INTO `t_s_town` VALUES ('848', '宅北乡', '130131205000', '130131000000');
INSERT INTO `t_s_town` VALUES ('849', '北冶乡', '130131207000', '130131000000');
INSERT INTO `t_s_town` VALUES ('850', '上观音堂乡', '130131209000', '130131000000');
INSERT INTO `t_s_town` VALUES ('851', '杨家桥乡', '130131210000', '130131000000');
INSERT INTO `t_s_town` VALUES ('852', '营里乡', '130131211000', '130131000000');
INSERT INTO `t_s_town` VALUES ('853', '合河口乡', '130131212000', '130131000000');
INSERT INTO `t_s_town` VALUES ('854', '城区街道办事处', '130132001000', '130132000000');
INSERT INTO `t_s_town` VALUES ('855', '槐阳镇', '130132100000', '130132000000');
INSERT INTO `t_s_town` VALUES ('856', '殷村镇', '130132101000', '130132000000');
INSERT INTO `t_s_town` VALUES ('857', '南佐镇', '130132102000', '130132000000');
INSERT INTO `t_s_town` VALUES ('858', '宋曹镇', '130132103000', '130132000000');
INSERT INTO `t_s_town` VALUES ('859', '南因镇', '130132104000', '130132000000');
INSERT INTO `t_s_town` VALUES ('860', '姬村镇', '130132105000', '130132000000');
INSERT INTO `t_s_town` VALUES ('861', '北褚镇', '130132106000', '130132000000');
INSERT INTO `t_s_town` VALUES ('862', '马村镇', '130132107000', '130132000000');
INSERT INTO `t_s_town` VALUES ('863', '东张乡', '130132201000', '130132000000');
INSERT INTO `t_s_town` VALUES ('864', '赵同乡', '130132202000', '130132000000');
INSERT INTO `t_s_town` VALUES ('865', '苏村乡', '130132204000', '130132000000');
INSERT INTO `t_s_town` VALUES ('866', '苏阳乡', '130132205000', '130132000000');
INSERT INTO `t_s_town` VALUES ('867', '北正乡', '130132206000', '130132000000');
INSERT INTO `t_s_town` VALUES ('868', '前仙乡', '130132207000', '130132000000');
INSERT INTO `t_s_town` VALUES ('869', '黑水河乡', '130132208000', '130132000000');
INSERT INTO `t_s_town` VALUES ('870', '赵州镇', '130133100000', '130133000000');
INSERT INTO `t_s_town` VALUES ('871', '范庄镇', '130133101000', '130133000000');
INSERT INTO `t_s_town` VALUES ('872', '北王里镇', '130133102000', '130133000000');
INSERT INTO `t_s_town` VALUES ('873', '新寨店镇', '130133103000', '130133000000');
INSERT INTO `t_s_town` VALUES ('874', '韩村镇', '130133104000', '130133000000');
INSERT INTO `t_s_town` VALUES ('875', '南柏舍镇', '130133105000', '130133000000');
INSERT INTO `t_s_town` VALUES ('876', '沙河店镇', '130133106000', '130133000000');
INSERT INTO `t_s_town` VALUES ('877', '前大章乡', '130133200000', '130133000000');
INSERT INTO `t_s_town` VALUES ('878', '谢庄乡', '130133201000', '130133000000');
INSERT INTO `t_s_town` VALUES ('879', '高村乡', '130133202000', '130133000000');
INSERT INTO `t_s_town` VALUES ('880', '王西章乡', '130133203000', '130133000000');
INSERT INTO `t_s_town` VALUES ('881', '长江街道办事处', '130171010000', '130171000000');
INSERT INTO `t_s_town` VALUES ('882', '太行街道办事处', '130171011000', '130171000000');
INSERT INTO `t_s_town` VALUES ('883', '宋营镇', '130171100000', '130171000000');
INSERT INTO `t_s_town` VALUES ('884', '郄马镇', '130171101000', '130171000000');
INSERT INTO `t_s_town` VALUES ('885', '丘头镇', '130172100000', '130172000000');
INSERT INTO `t_s_town` VALUES ('886', '辛集镇', '130181100000', '130181000000');
INSERT INTO `t_s_town` VALUES ('887', '旧城镇', '130181101000', '130181000000');
INSERT INTO `t_s_town` VALUES ('888', '张古庄镇', '130181102000', '130181000000');
INSERT INTO `t_s_town` VALUES ('889', '位伯镇', '130181103000', '130181000000');
INSERT INTO `t_s_town` VALUES ('890', '新垒头镇', '130181104000', '130181000000');
INSERT INTO `t_s_town` VALUES ('891', '新城镇', '130181105000', '130181000000');
INSERT INTO `t_s_town` VALUES ('892', '南智邱镇', '130181106000', '130181000000');
INSERT INTO `t_s_town` VALUES ('893', '王口镇', '130181107000', '130181000000');
INSERT INTO `t_s_town` VALUES ('894', '天宫营乡', '130181200000', '130181000000');
INSERT INTO `t_s_town` VALUES ('895', '前营乡', '130181201000', '130181000000');
INSERT INTO `t_s_town` VALUES ('896', '马庄乡', '130181202000', '130181000000');
INSERT INTO `t_s_town` VALUES ('897', '和睦井乡', '130181203000', '130181000000');
INSERT INTO `t_s_town` VALUES ('898', '田家庄乡', '130181204000', '130181000000');
INSERT INTO `t_s_town` VALUES ('899', '中里厢乡', '130181205000', '130181000000');
INSERT INTO `t_s_town` VALUES ('900', '小辛庄乡', '130181206000', '130181000000');
INSERT INTO `t_s_town` VALUES ('901', '辛集经济开发区', '130181500000', '130181000000');
INSERT INTO `t_s_town` VALUES ('902', '晋州镇', '130183100000', '130183000000');
INSERT INTO `t_s_town` VALUES ('903', '总十庄镇', '130183101000', '130183000000');
INSERT INTO `t_s_town` VALUES ('904', '营里镇', '130183102000', '130183000000');
INSERT INTO `t_s_town` VALUES ('905', '桃园镇', '130183103000', '130183000000');
INSERT INTO `t_s_town` VALUES ('906', '东卓宿镇', '130183104000', '130183000000');
INSERT INTO `t_s_town` VALUES ('907', '马于镇', '130183105000', '130183000000');
INSERT INTO `t_s_town` VALUES ('908', '小樵镇', '130183106000', '130183000000');
INSERT INTO `t_s_town` VALUES ('909', '槐树镇', '130183107000', '130183000000');
INSERT INTO `t_s_town` VALUES ('910', '东里庄镇', '130183108000', '130183000000');
INSERT INTO `t_s_town` VALUES ('911', '周家庄乡', '130183201000', '130183000000');
INSERT INTO `t_s_town` VALUES ('912', '长寿街道办事处', '130184001000', '130184000000');
INSERT INTO `t_s_town` VALUES ('913', '化皮镇', '130184101000', '130184000000');
INSERT INTO `t_s_town` VALUES ('914', '承安镇', '130184102000', '130184000000');
INSERT INTO `t_s_town` VALUES ('915', '正莫镇', '130184103000', '130184000000');
INSERT INTO `t_s_town` VALUES ('916', '南大岳镇', '130184104000', '130184000000');
INSERT INTO `t_s_town` VALUES ('917', '杜固镇', '130184105000', '130184000000');
INSERT INTO `t_s_town` VALUES ('918', '邯邰镇', '130184106000', '130184000000');
INSERT INTO `t_s_town` VALUES ('919', '东王镇', '130184107000', '130184000000');
INSERT INTO `t_s_town` VALUES ('920', '马头铺镇', '130184108000', '130184000000');
INSERT INTO `t_s_town` VALUES ('921', '协神乡', '130184200000', '130184000000');
INSERT INTO `t_s_town` VALUES ('922', '木村乡', '130184201000', '130184000000');
INSERT INTO `t_s_town` VALUES ('923', '彭家庄回族乡', '130184202000', '130184000000');
INSERT INTO `t_s_town` VALUES ('924', '学院南路街道办事处', '130202001000', '130202000000');
INSERT INTO `t_s_town` VALUES ('925', '友谊街道办事处', '130202002000', '130202000000');
INSERT INTO `t_s_town` VALUES ('926', '广场街道办事处', '130202003000', '130202000000');
INSERT INTO `t_s_town` VALUES ('927', '永红桥街道办事处', '130202004000', '130202000000');
INSERT INTO `t_s_town` VALUES ('928', '小山街道办事处', '130202005000', '130202000000');
INSERT INTO `t_s_town` VALUES ('929', '文北街道办事处', '130202006000', '130202000000');
INSERT INTO `t_s_town` VALUES ('930', '钱营街道办事处', '130202007000', '130202000000');
INSERT INTO `t_s_town` VALUES ('931', '惠民道街道办事处', '130202008000', '130202000000');
INSERT INTO `t_s_town` VALUES ('932', '梁家屯路街道办事处', '130202009000', '130202000000');
INSERT INTO `t_s_town` VALUES ('933', '稻地镇', '130202102000', '130202000000');
INSERT INTO `t_s_town` VALUES ('934', '女织寨乡', '130202200000', '130202000000');
INSERT INTO `t_s_town` VALUES ('935', '乔屯街道办事处', '130203001000', '130203000000');
INSERT INTO `t_s_town` VALUES ('936', '文化路街道办事处', '130203002000', '130203000000');
INSERT INTO `t_s_town` VALUES ('937', '钓鱼台街道办事处', '130203003000', '130203000000');
INSERT INTO `t_s_town` VALUES ('938', '东新村街道办事处', '130203004000', '130203000000');
INSERT INTO `t_s_town` VALUES ('939', '缸窑街道办事处', '130203005000', '130203000000');
INSERT INTO `t_s_town` VALUES ('940', '机场路街道办事处', '130203006000', '130203000000');
INSERT INTO `t_s_town` VALUES ('941', '河北路街道办事处', '130203007000', '130203000000');
INSERT INTO `t_s_town` VALUES ('942', '龙东街道办事处', '130203008000', '130203000000');
INSERT INTO `t_s_town` VALUES ('943', '大里街道办事处', '130203009000', '130203000000');
INSERT INTO `t_s_town` VALUES ('944', '光明街道办事处', '130203010000', '130203000000');
INSERT INTO `t_s_town` VALUES ('945', '翔云道街道办事处', '130203011000', '130203000000');
INSERT INTO `t_s_town` VALUES ('946', '韩城镇', '130203100000', '130203000000');
INSERT INTO `t_s_town` VALUES ('947', '果园乡', '130203200000', '130203000000');
INSERT INTO `t_s_town` VALUES ('948', '林西街道办事处', '130204001000', '130204000000');
INSERT INTO `t_s_town` VALUES ('949', '唐家庄街道办事处', '130204002000', '130204000000');
INSERT INTO `t_s_town` VALUES ('950', '古冶街道办事处', '130204003000', '130204000000');
INSERT INTO `t_s_town` VALUES ('951', '赵各庄街道办事处', '130204004000', '130204000000');
INSERT INTO `t_s_town` VALUES ('952', '京华街道办事处', '130204007000', '130204000000');
INSERT INTO `t_s_town` VALUES ('953', '范各庄镇', '130204100000', '130204000000');
INSERT INTO `t_s_town` VALUES ('954', '卑家店镇', '130204101000', '130204000000');
INSERT INTO `t_s_town` VALUES ('955', '王辇庄乡', '130204201000', '130204000000');
INSERT INTO `t_s_town` VALUES ('956', '习家套乡', '130204202000', '130204000000');
INSERT INTO `t_s_town` VALUES ('957', '大庄坨乡', '130204203000', '130204000000');
INSERT INTO `t_s_town` VALUES ('958', '马家沟街道办事处', '130205001000', '130205000000');
INSERT INTO `t_s_town` VALUES ('959', '开平街道办事处', '130205002000', '130205000000');
INSERT INTO `t_s_town` VALUES ('960', '税务庄街道办事处', '130205003000', '130205000000');
INSERT INTO `t_s_town` VALUES ('961', '陡电街道办事处', '130205005000', '130205000000');
INSERT INTO `t_s_town` VALUES ('962', '荆各庄街道办事处', '130205006000', '130205000000');
INSERT INTO `t_s_town` VALUES ('963', '开平镇', '130205100000', '130205000000');
INSERT INTO `t_s_town` VALUES ('964', '栗园镇', '130205101000', '130205000000');
INSERT INTO `t_s_town` VALUES ('965', '郑庄子镇', '130205102000', '130205000000');
INSERT INTO `t_s_town` VALUES ('966', '双桥镇', '130205103000', '130205000000');
INSERT INTO `t_s_town` VALUES ('967', '洼里镇', '130205104000', '130205000000');
INSERT INTO `t_s_town` VALUES ('968', '越河镇', '130205105000', '130205000000');
INSERT INTO `t_s_town` VALUES ('969', '小集镇', '130207103000', '130207000000');
INSERT INTO `t_s_town` VALUES ('970', '黄各庄镇', '130207104000', '130207000000');
INSERT INTO `t_s_town` VALUES ('971', '西葛镇', '130207105000', '130207000000');
INSERT INTO `t_s_town` VALUES ('972', '大新庄镇', '130207106000', '130207000000');
INSERT INTO `t_s_town` VALUES ('973', '钱营镇', '130207107000', '130207000000');
INSERT INTO `t_s_town` VALUES ('974', '唐坊镇', '130207108000', '130207000000');
INSERT INTO `t_s_town` VALUES ('975', '王兰庄镇', '130207109000', '130207000000');
INSERT INTO `t_s_town` VALUES ('976', '柳树酄镇', '130207110000', '130207000000');
INSERT INTO `t_s_town` VALUES ('977', '黑沿子镇', '130207111000', '130207000000');
INSERT INTO `t_s_town` VALUES ('978', '丰南镇', '130207113000', '130207000000');
INSERT INTO `t_s_town` VALUES ('979', '大齐各庄镇', '130207114000', '130207000000');
INSERT INTO `t_s_town` VALUES ('980', '岔河镇', '130207115000', '130207000000');
INSERT INTO `t_s_town` VALUES ('981', '南孙庄乡', '130207201000', '130207000000');
INSERT INTO `t_s_town` VALUES ('982', '东田庄乡', '130207202000', '130207000000');
INSERT INTO `t_s_town` VALUES ('983', '尖字沽乡', '130207203000', '130207000000');
INSERT INTO `t_s_town` VALUES ('984', '太平路街道办事处', '130208001000', '130208000000');
INSERT INTO `t_s_town` VALUES ('985', '燕山路街道办事处', '130208002000', '130208000000');
INSERT INTO `t_s_town` VALUES ('986', '浭阳街道办事处', '130208003000', '130208000000');
INSERT INTO `t_s_town` VALUES ('987', '丰润镇', '130208100000', '130208000000');
INSERT INTO `t_s_town` VALUES ('988', '任各庄镇', '130208102000', '130208000000');
INSERT INTO `t_s_town` VALUES ('989', '左家坞镇', '130208103000', '130208000000');
INSERT INTO `t_s_town` VALUES ('990', '泉河头镇', '130208104000', '130208000000');
INSERT INTO `t_s_town` VALUES ('991', '王官营镇', '130208105000', '130208000000');
INSERT INTO `t_s_town` VALUES ('992', '火石营镇', '130208106000', '130208000000');
INSERT INTO `t_s_town` VALUES ('993', '新军屯镇', '130208109000', '130208000000');
INSERT INTO `t_s_town` VALUES ('994', '小张各庄镇', '130208110000', '130208000000');
INSERT INTO `t_s_town` VALUES ('995', '丰登坞镇', '130208111000', '130208000000');
INSERT INTO `t_s_town` VALUES ('996', '李钊庄镇', '130208112000', '130208000000');
INSERT INTO `t_s_town` VALUES ('997', '白官屯镇', '130208113000', '130208000000');
INSERT INTO `t_s_town` VALUES ('998', '石各庄镇', '130208114000', '130208000000');
INSERT INTO `t_s_town` VALUES ('999', '沙流河镇', '130208115000', '130208000000');
INSERT INTO `t_s_town` VALUES ('1000', '七树庄镇', '130208116000', '130208000000');
INSERT INTO `t_s_town` VALUES ('1001', '杨官林镇', '130208117000', '130208000000');
INSERT INTO `t_s_town` VALUES ('1002', '银城铺镇', '130208118000', '130208000000');
INSERT INTO `t_s_town` VALUES ('1003', '常庄镇', '130208119000', '130208000000');
INSERT INTO `t_s_town` VALUES ('1004', '姜家营乡', '130208202000', '130208000000');
INSERT INTO `t_s_town` VALUES ('1005', '欢喜庄乡', '130208205000', '130208000000');
INSERT INTO `t_s_town` VALUES ('1006', '刘家营乡', '130208208000', '130208000000');
INSERT INTO `t_s_town` VALUES ('1007', '唐海镇', '130209100000', '130209000000');
INSERT INTO `t_s_town` VALUES ('1008', '滨海镇', '130209112000', '130209000000');
INSERT INTO `t_s_town` VALUES ('1009', '柳赞镇', '130209113000', '130209000000');
INSERT INTO `t_s_town` VALUES ('1010', '一农场', '130209401000', '130209000000');
INSERT INTO `t_s_town` VALUES ('1011', '三农场', '130209403000', '130209000000');
INSERT INTO `t_s_town` VALUES ('1012', '四农场', '130209404000', '130209000000');
INSERT INTO `t_s_town` VALUES ('1013', '五农场', '130209405000', '130209000000');
INSERT INTO `t_s_town` VALUES ('1014', '六农场', '130209406000', '130209000000');
INSERT INTO `t_s_town` VALUES ('1015', '七农场', '130209407000', '130209000000');
INSERT INTO `t_s_town` VALUES ('1016', '八农场', '130209408000', '130209000000');
INSERT INTO `t_s_town` VALUES ('1017', '九农场', '130209409000', '130209000000');
INSERT INTO `t_s_town` VALUES ('1018', '十农场', '130209410000', '130209000000');
INSERT INTO `t_s_town` VALUES ('1019', '十一农场', '130209411000', '130209000000');
INSERT INTO `t_s_town` VALUES ('1020', '八里滩养殖场', '130209412000', '130209000000');
INSERT INTO `t_s_town` VALUES ('1021', '十里海养殖场', '130209413000', '130209000000');
INSERT INTO `t_s_town` VALUES ('1022', '南堡经济开发区', '130209450000', '130209000000');
INSERT INTO `t_s_town` VALUES ('1023', '曹妃甸工业区', '130209451000', '130209000000');
INSERT INTO `t_s_town` VALUES ('1024', '曹妃甸新城', '130209452000', '130209000000');
INSERT INTO `t_s_town` VALUES ('1025', '友谊路街道办事处', '130224001000', '130224000000');
INSERT INTO `t_s_town` VALUES ('1026', '倴城镇', '130224100000', '130224000000');
INSERT INTO `t_s_town` VALUES ('1027', '宋道口镇', '130224101000', '130224000000');
INSERT INTO `t_s_town` VALUES ('1028', '长凝镇', '130224102000', '130224000000');
INSERT INTO `t_s_town` VALUES ('1029', '胡各庄镇', '130224103000', '130224000000');
INSERT INTO `t_s_town` VALUES ('1030', '坨里镇', '130224104000', '130224000000');
INSERT INTO `t_s_town` VALUES ('1031', '姚王庄镇', '130224105000', '130224000000');
INSERT INTO `t_s_town` VALUES ('1032', '司各庄镇', '130224106000', '130224000000');
INSERT INTO `t_s_town` VALUES ('1033', '安各庄镇', '130224107000', '130224000000');
INSERT INTO `t_s_town` VALUES ('1034', '扒齿港镇', '130224108000', '130224000000');
INSERT INTO `t_s_town` VALUES ('1035', '程庄镇', '130224109000', '130224000000');
INSERT INTO `t_s_town` VALUES ('1036', '青坨营镇', '130224110000', '130224000000');
INSERT INTO `t_s_town` VALUES ('1037', '柏各庄镇', '130224111000', '130224000000');
INSERT INTO `t_s_town` VALUES ('1038', '南堡镇', '130224114000', '130224000000');
INSERT INTO `t_s_town` VALUES ('1039', '方各庄镇', '130224115000', '130224000000');
INSERT INTO `t_s_town` VALUES ('1040', '东黄坨镇', '130224116000', '130224000000');
INSERT INTO `t_s_town` VALUES ('1041', '马城镇', '130224117000', '130224000000');
INSERT INTO `t_s_town` VALUES ('1042', '乐安街道办事处', '130225001000', '130225000000');
INSERT INTO `t_s_town` VALUES ('1043', '乐亭镇', '130225100000', '130225000000');
INSERT INTO `t_s_town` VALUES ('1044', '汤家河镇', '130225101000', '130225000000');
INSERT INTO `t_s_town` VALUES ('1045', '胡家坨镇', '130225102000', '130225000000');
INSERT INTO `t_s_town` VALUES ('1046', '阎各庄镇', '130225104000', '130225000000');
INSERT INTO `t_s_town` VALUES ('1047', '马头营镇', '130225105000', '130225000000');
INSERT INTO `t_s_town` VALUES ('1048', '新寨镇', '130225106000', '130225000000');
INSERT INTO `t_s_town` VALUES ('1049', '汀流河镇', '130225107000', '130225000000');
INSERT INTO `t_s_town` VALUES ('1050', '姜各庄镇', '130225108000', '130225000000');
INSERT INTO `t_s_town` VALUES ('1051', '毛庄镇', '130225109000', '130225000000');
INSERT INTO `t_s_town` VALUES ('1052', '中堡镇', '130225110000', '130225000000');
INSERT INTO `t_s_town` VALUES ('1053', '庞各庄乡', '130225201000', '130225000000');
INSERT INTO `t_s_town` VALUES ('1054', '大相各庄乡', '130225202000', '130225000000');
INSERT INTO `t_s_town` VALUES ('1055', '古河乡', '130225203000', '130225000000');
INSERT INTO `t_s_town` VALUES ('1056', '河北乐亭经济开发区', '130225453000', '130225000000');
INSERT INTO `t_s_town` VALUES ('1057', '乐亭县城区工业聚集区管理委员会', '130225454000', '130225000000');
INSERT INTO `t_s_town` VALUES ('1058', '迁西县栗乡街道办事处', '130227001000', '130227000000');
INSERT INTO `t_s_town` VALUES ('1059', '兴城镇', '130227100000', '130227000000');
INSERT INTO `t_s_town` VALUES ('1060', '金厂峪镇', '130227101000', '130227000000');
INSERT INTO `t_s_town` VALUES ('1061', '洒河桥镇', '130227102000', '130227000000');
INSERT INTO `t_s_town` VALUES ('1062', '太平寨镇', '130227103000', '130227000000');
INSERT INTO `t_s_town` VALUES ('1063', '罗家屯镇', '130227104000', '130227000000');
INSERT INTO `t_s_town` VALUES ('1064', '东荒峪镇', '130227105000', '130227000000');
INSERT INTO `t_s_town` VALUES ('1065', '新集镇', '130227106000', '130227000000');
INSERT INTO `t_s_town` VALUES ('1066', '三屯营镇', '130227107000', '130227000000');
INSERT INTO `t_s_town` VALUES ('1067', '滦阳镇', '130227108000', '130227000000');
INSERT INTO `t_s_town` VALUES ('1068', '白庙子乡', '130227200000', '130227000000');
INSERT INTO `t_s_town` VALUES ('1069', '上营乡', '130227201000', '130227000000');
INSERT INTO `t_s_town` VALUES ('1070', '汉儿庄乡', '130227202000', '130227000000');
INSERT INTO `t_s_town` VALUES ('1071', '渔户寨乡', '130227203000', '130227000000');
INSERT INTO `t_s_town` VALUES ('1072', '旧城乡', '130227204000', '130227000000');
INSERT INTO `t_s_town` VALUES ('1073', '尹庄乡', '130227205000', '130227000000');
INSERT INTO `t_s_town` VALUES ('1074', '东莲花院乡', '130227206000', '130227000000');
INSERT INTO `t_s_town` VALUES ('1075', '新庄子乡', '130227207000', '130227000000');
INSERT INTO `t_s_town` VALUES ('1076', '迁西县栗乡工业产业聚集区', '130227450000', '130227000000');
INSERT INTO `t_s_town` VALUES ('1077', '无终街道办事处', '130229001000', '130229000000');
INSERT INTO `t_s_town` VALUES ('1078', '玉田镇', '130229100000', '130229000000');
INSERT INTO `t_s_town` VALUES ('1079', '亮甲店镇', '130229101000', '130229000000');
INSERT INTO `t_s_town` VALUES ('1080', '鸦鸿桥镇', '130229102000', '130229000000');
INSERT INTO `t_s_town` VALUES ('1081', '窝洛沽镇', '130229103000', '130229000000');
INSERT INTO `t_s_town` VALUES ('1082', '石臼窝镇', '130229104000', '130229000000');
INSERT INTO `t_s_town` VALUES ('1083', '虹桥镇', '130229105000', '130229000000');
INSERT INTO `t_s_town` VALUES ('1084', '散水头镇', '130229106000', '130229000000');
INSERT INTO `t_s_town` VALUES ('1085', '林南仓镇', '130229107000', '130229000000');
INSERT INTO `t_s_town` VALUES ('1086', '林西镇', '130229108000', '130229000000');
INSERT INTO `t_s_town` VALUES ('1087', '杨家板桥镇', '130229109000', '130229000000');
INSERT INTO `t_s_town` VALUES ('1088', '彩亭桥镇', '130229110000', '130229000000');
INSERT INTO `t_s_town` VALUES ('1089', '孤树镇', '130229111000', '130229000000');
INSERT INTO `t_s_town` VALUES ('1090', '大安镇镇', '130229112000', '130229000000');
INSERT INTO `t_s_town` VALUES ('1091', '唐自头镇', '130229113000', '130229000000');
INSERT INTO `t_s_town` VALUES ('1092', '郭家屯镇', '130229114000', '130229000000');
INSERT INTO `t_s_town` VALUES ('1093', '杨家套镇', '130229115000', '130229000000');
INSERT INTO `t_s_town` VALUES ('1094', '林头屯乡', '130229201000', '130229000000');
INSERT INTO `t_s_town` VALUES ('1095', '潮洛窝乡', '130229203000', '130229000000');
INSERT INTO `t_s_town` VALUES ('1096', '陈家铺乡', '130229204000', '130229000000');
INSERT INTO `t_s_town` VALUES ('1097', '郭家桥乡', '130229205000', '130229000000');
INSERT INTO `t_s_town` VALUES ('1098', '芦台开发区海北镇', '130271100000', '130271000000');
INSERT INTO `t_s_town` VALUES ('1099', '芦台开发区新华路街道办事处', '130271450000', '130271000000');
INSERT INTO `t_s_town` VALUES ('1100', '汉沽管理区汉丰镇', '130272101000', '130272000000');
INSERT INTO `t_s_town` VALUES ('1101', '汉沽管理区兴农办事处', '130272451000', '130272000000');
INSERT INTO `t_s_town` VALUES ('1102', '汉沽管理区振兴街道办事处', '130272452000', '130272000000');
INSERT INTO `t_s_town` VALUES ('1103', '街道办事处', '130273001000', '130273000000');
INSERT INTO `t_s_town` VALUES ('1104', '庆北办事处', '130273003000', '130273000000');
INSERT INTO `t_s_town` VALUES ('1105', '三女河办事处', '130273004000', '130273000000');
INSERT INTO `t_s_town` VALUES ('1106', '老庄子镇', '130273101000', '130273000000');
INSERT INTO `t_s_town` VALUES ('1107', '唐山海港开发区王滩镇', '130274103000', '130274000000');
INSERT INTO `t_s_town` VALUES ('1108', '唐山海港经济开发区街道办事处', '130274451000', '130274000000');
INSERT INTO `t_s_town` VALUES ('1109', '唐山湾国际旅游岛', '130274452000', '130274000000');
INSERT INTO `t_s_town` VALUES ('1110', '大清河', '130274455000', '130274000000');
INSERT INTO `t_s_town` VALUES ('1111', '华明路街道办事处', '130281001000', '130281000000');
INSERT INTO `t_s_town` VALUES ('1112', '文化路街道办事处', '130281002000', '130281000000');
INSERT INTO `t_s_town` VALUES ('1113', '遵化镇', '130281100000', '130281000000');
INSERT INTO `t_s_town` VALUES ('1114', '堡子店镇', '130281101000', '130281000000');
INSERT INTO `t_s_town` VALUES ('1115', '马兰峪镇', '130281102000', '130281000000');
INSERT INTO `t_s_town` VALUES ('1116', '平安城镇', '130281103000', '130281000000');
INSERT INTO `t_s_town` VALUES ('1117', '东新庄镇', '130281104000', '130281000000');
INSERT INTO `t_s_town` VALUES ('1118', '新店子镇', '130281105000', '130281000000');
INSERT INTO `t_s_town` VALUES ('1119', '党峪镇', '130281106000', '130281000000');
INSERT INTO `t_s_town` VALUES ('1120', '地北头镇', '130281107000', '130281000000');
INSERT INTO `t_s_town` VALUES ('1121', '东旧寨镇', '130281108000', '130281000000');
INSERT INTO `t_s_town` VALUES ('1122', '铁厂镇', '130281109000', '130281000000');
INSERT INTO `t_s_town` VALUES ('1123', '苏家洼镇', '130281110000', '130281000000');
INSERT INTO `t_s_town` VALUES ('1124', '建明镇', '130281111000', '130281000000');
INSERT INTO `t_s_town` VALUES ('1125', '石门镇', '130281112000', '130281000000');
INSERT INTO `t_s_town` VALUES ('1126', '西留村乡', '130281200000', '130281000000');
INSERT INTO `t_s_town` VALUES ('1127', '崔家庄乡', '130281201000', '130281000000');
INSERT INTO `t_s_town` VALUES ('1128', '兴旺寨乡', '130281202000', '130281000000');
INSERT INTO `t_s_town` VALUES ('1129', '西下营满族乡', '130281203000', '130281000000');
INSERT INTO `t_s_town` VALUES ('1130', '汤泉满族乡', '130281204000', '130281000000');
INSERT INTO `t_s_town` VALUES ('1131', '东陵满族乡', '130281205000', '130281000000');
INSERT INTO `t_s_town` VALUES ('1132', '刘备寨乡', '130281206000', '130281000000');
INSERT INTO `t_s_town` VALUES ('1133', '团瓢庄乡', '130281207000', '130281000000');
INSERT INTO `t_s_town` VALUES ('1134', '娘娘庄乡', '130281208000', '130281000000');
INSERT INTO `t_s_town` VALUES ('1135', '西三里乡', '130281209000', '130281000000');
INSERT INTO `t_s_town` VALUES ('1136', '侯家寨乡', '130281210000', '130281000000');
INSERT INTO `t_s_town` VALUES ('1137', '小厂乡', '130281211000', '130281000000');
INSERT INTO `t_s_town` VALUES ('1138', '迁安镇', '130283100000', '130283000000');
INSERT INTO `t_s_town` VALUES ('1139', '夏官营镇', '130283101000', '130283000000');
INSERT INTO `t_s_town` VALUES ('1140', '杨各庄镇', '130283102000', '130283000000');
INSERT INTO `t_s_town` VALUES ('1141', '建昌营镇', '130283103000', '130283000000');
INSERT INTO `t_s_town` VALUES ('1142', '赵店子镇', '130283104000', '130283000000');
INSERT INTO `t_s_town` VALUES ('1143', '野鸡坨镇', '130283105000', '130283000000');
INSERT INTO `t_s_town` VALUES ('1144', '大崔庄镇', '130283106000', '130283000000');
INSERT INTO `t_s_town` VALUES ('1145', '杨店子镇', '130283107000', '130283000000');
INSERT INTO `t_s_town` VALUES ('1146', '蔡园镇', '130283108000', '130283000000');
INSERT INTO `t_s_town` VALUES ('1147', '马兰庄镇', '130283109000', '130283000000');
INSERT INTO `t_s_town` VALUES ('1148', '沙河驿镇', '130283110000', '130283000000');
INSERT INTO `t_s_town` VALUES ('1149', '木厂口镇', '130283111000', '130283000000');
INSERT INTO `t_s_town` VALUES ('1150', '扣庄乡', '130283200000', '130283000000');
INSERT INTO `t_s_town` VALUES ('1151', '彭店子乡', '130283201000', '130283000000');
INSERT INTO `t_s_town` VALUES ('1152', '上射雁庄乡', '130283202000', '130283000000');
INSERT INTO `t_s_town` VALUES ('1153', '闫家店乡', '130283203000', '130283000000');
INSERT INTO `t_s_town` VALUES ('1154', '五重安乡', '130283204000', '130283000000');
INSERT INTO `t_s_town` VALUES ('1155', '大五里乡', '130283205000', '130283000000');
INSERT INTO `t_s_town` VALUES ('1156', '太平庄乡', '130283206000', '130283000000');
INSERT INTO `t_s_town` VALUES ('1157', '滦河街道办事处', '130284001000', '130284000000');
INSERT INTO `t_s_town` VALUES ('1158', '古城街道办事处', '130284002000', '130284000000');
INSERT INTO `t_s_town` VALUES ('1159', '滦城路街道办事处', '130284003000', '130284000000');
INSERT INTO `t_s_town` VALUES ('1160', '响堂街道办事处', '130284004000', '130284000000');
INSERT INTO `t_s_town` VALUES ('1161', '东安各庄镇', '130284102000', '130284000000');
INSERT INTO `t_s_town` VALUES ('1162', '雷庄镇', '130284103000', '130284000000');
INSERT INTO `t_s_town` VALUES ('1163', '茨榆坨镇', '130284104000', '130284000000');
INSERT INTO `t_s_town` VALUES ('1164', '榛子镇', '130284105000', '130284000000');
INSERT INTO `t_s_town` VALUES ('1165', '杨柳庄镇', '130284106000', '130284000000');
INSERT INTO `t_s_town` VALUES ('1166', '油榨镇', '130284107000', '130284000000');
INSERT INTO `t_s_town` VALUES ('1167', '古马镇', '130284108000', '130284000000');
INSERT INTO `t_s_town` VALUES ('1168', '小马庄镇', '130284109000', '130284000000');
INSERT INTO `t_s_town` VALUES ('1169', '九百户镇', '130284110000', '130284000000');
INSERT INTO `t_s_town` VALUES ('1170', '王店子镇', '130284111000', '130284000000');
INSERT INTO `t_s_town` VALUES ('1171', '文化路街道办事处', '130302001000', '130302000000');
INSERT INTO `t_s_town` VALUES ('1172', '海滨路街道办事处', '130302002000', '130302000000');
INSERT INTO `t_s_town` VALUES ('1173', '北环路街道办事处', '130302003000', '130302000000');
INSERT INTO `t_s_town` VALUES ('1174', '建设大街街道办事处', '130302004000', '130302000000');
INSERT INTO `t_s_town` VALUES ('1175', '河东街道办事处', '130302005000', '130302000000');
INSERT INTO `t_s_town` VALUES ('1176', '西港路街道办事处', '130302006000', '130302000000');
INSERT INTO `t_s_town` VALUES ('1177', '燕山大街街道办事处', '130302007000', '130302000000');
INSERT INTO `t_s_town` VALUES ('1178', '港城大街街道办事处', '130302008000', '130302000000');
INSERT INTO `t_s_town` VALUES ('1179', '东环路街道办事处', '130302009000', '130302000000');
INSERT INTO `t_s_town` VALUES ('1180', '白塔岭街道办事处', '130302010000', '130302000000');
INSERT INTO `t_s_town` VALUES ('1181', '东港镇', '130302100000', '130302000000');
INSERT INTO `t_s_town` VALUES ('1182', '海港镇', '130302101000', '130302000000');
INSERT INTO `t_s_town` VALUES ('1183', '西港镇', '130302102000', '130302000000');
INSERT INTO `t_s_town` VALUES ('1184', '海阳镇', '130302103000', '130302000000');
INSERT INTO `t_s_town` VALUES ('1185', '北港镇', '130302104000', '130302000000');
INSERT INTO `t_s_town` VALUES ('1186', '杜庄镇', '130302105000', '130302000000');
INSERT INTO `t_s_town` VALUES ('1187', '石门寨镇', '130302106000', '130302000000');
INSERT INTO `t_s_town` VALUES ('1188', '驻操营镇', '130302107000', '130302000000');
INSERT INTO `t_s_town` VALUES ('1189', '临港物流园区', '130302403000', '130302000000');
INSERT INTO `t_s_town` VALUES ('1190', '海港经济开发区', '130302404000', '130302000000');
INSERT INTO `t_s_town` VALUES ('1191', '南关街道办事处', '130303001000', '130303000000');
INSERT INTO `t_s_town` VALUES ('1192', '古城街道办事处', '130303002000', '130303000000');
INSERT INTO `t_s_town` VALUES ('1193', '西关街道办事处', '130303003000', '130303000000');
INSERT INTO `t_s_town` VALUES ('1194', '路南街道办事处', '130303004000', '130303000000');
INSERT INTO `t_s_town` VALUES ('1195', '第一关镇', '130303100000', '130303000000');
INSERT INTO `t_s_town` VALUES ('1196', '石河镇', '130303101000', '130303000000');
INSERT INTO `t_s_town` VALUES ('1197', '孟姜镇', '130303102000', '130303000000');
INSERT INTO `t_s_town` VALUES ('1198', '西山街道办事处', '130304001000', '130304000000');
INSERT INTO `t_s_town` VALUES ('1199', '东山街道办事处', '130304002000', '130304000000');
INSERT INTO `t_s_town` VALUES ('1200', '海滨镇', '130304100000', '130304000000');
INSERT INTO `t_s_town` VALUES ('1201', '戴河镇', '130304101000', '130304000000');
INSERT INTO `t_s_town` VALUES ('1202', '牛头崖镇', '130304103000', '130304000000');
INSERT INTO `t_s_town` VALUES ('1203', '骊城街道办事处', '130306001000', '130306000000');
INSERT INTO `t_s_town` VALUES ('1204', '抚宁镇', '130306100000', '130306000000');
INSERT INTO `t_s_town` VALUES ('1205', '留守营镇', '130306101000', '130306000000');
INSERT INTO `t_s_town` VALUES ('1206', '榆关镇', '130306102000', '130306000000');
INSERT INTO `t_s_town` VALUES ('1207', '台营镇', '130306105000', '130306000000');
INSERT INTO `t_s_town` VALUES ('1208', '大新寨镇', '130306106000', '130306000000');
INSERT INTO `t_s_town` VALUES ('1209', '茶棚乡', '130306200000', '130306000000');
INSERT INTO `t_s_town` VALUES ('1210', '深河乡', '130306202000', '130306000000');
INSERT INTO `t_s_town` VALUES ('1211', '都阳路街道办事处', '130321001000', '130321000000');
INSERT INTO `t_s_town` VALUES ('1212', '青龙镇', '130321100000', '130321000000');
INSERT INTO `t_s_town` VALUES ('1213', '祖山镇', '130321101000', '130321000000');
INSERT INTO `t_s_town` VALUES ('1214', '木头凳镇', '130321102000', '130321000000');
INSERT INTO `t_s_town` VALUES ('1215', '双山子镇', '130321103000', '130321000000');
INSERT INTO `t_s_town` VALUES ('1216', '马圈子镇', '130321104000', '130321000000');
INSERT INTO `t_s_town` VALUES ('1217', '肖营子镇', '130321105000', '130321000000');
INSERT INTO `t_s_town` VALUES ('1218', '大巫岚镇', '130321106000', '130321000000');
INSERT INTO `t_s_town` VALUES ('1219', '土门子镇', '130321107000', '130321000000');
INSERT INTO `t_s_town` VALUES ('1220', '八道河镇', '130321108000', '130321000000');
INSERT INTO `t_s_town` VALUES ('1221', '隔河头镇', '130321109000', '130321000000');
INSERT INTO `t_s_town` VALUES ('1222', '娄杖子镇', '130321110000', '130321000000');
INSERT INTO `t_s_town` VALUES ('1223', '凤凰山乡', '130321200000', '130321000000');
INSERT INTO `t_s_town` VALUES ('1224', '龙王庙乡', '130321201000', '130321000000');
INSERT INTO `t_s_town` VALUES ('1225', '三星口乡', '130321202000', '130321000000');
INSERT INTO `t_s_town` VALUES ('1226', '干沟乡', '130321203000', '130321000000');
INSERT INTO `t_s_town` VALUES ('1227', '大石岭乡', '130321206000', '130321000000');
INSERT INTO `t_s_town` VALUES ('1228', '官场乡', '130321208000', '130321000000');
INSERT INTO `t_s_town` VALUES ('1229', '茨榆山乡', '130321209000', '130321000000');
INSERT INTO `t_s_town` VALUES ('1230', '平方子乡', '130321210000', '130321000000');
INSERT INTO `t_s_town` VALUES ('1231', '安子岭乡', '130321211000', '130321000000');
INSERT INTO `t_s_town` VALUES ('1232', '朱杖子乡', '130321212000', '130321000000');
INSERT INTO `t_s_town` VALUES ('1233', '草碾乡', '130321213000', '130321000000');
INSERT INTO `t_s_town` VALUES ('1234', '七道河乡', '130321214000', '130321000000');
INSERT INTO `t_s_town` VALUES ('1235', '三拨子乡', '130321217000', '130321000000');
INSERT INTO `t_s_town` VALUES ('1236', '凉水河乡', '130321218000', '130321000000');
INSERT INTO `t_s_town` VALUES ('1237', '昌黎镇', '130322100000', '130322000000');
INSERT INTO `t_s_town` VALUES ('1238', '靖安镇', '130322101000', '130322000000');
INSERT INTO `t_s_town` VALUES ('1239', '安山镇', '130322102000', '130322000000');
INSERT INTO `t_s_town` VALUES ('1240', '龙家店镇', '130322103000', '130322000000');
INSERT INTO `t_s_town` VALUES ('1241', '泥井镇', '130322104000', '130322000000');
INSERT INTO `t_s_town` VALUES ('1242', '大蒲河镇', '130322105000', '130322000000');
INSERT INTO `t_s_town` VALUES ('1243', '新集镇', '130322106000', '130322000000');
INSERT INTO `t_s_town` VALUES ('1244', '刘台庄镇', '130322107000', '130322000000');
INSERT INTO `t_s_town` VALUES ('1245', '茹荷镇', '130322108000', '130322000000');
INSERT INTO `t_s_town` VALUES ('1246', '朱各庄镇', '130322109000', '130322000000');
INSERT INTO `t_s_town` VALUES ('1247', '荒佃庄镇', '130322110000', '130322000000');
INSERT INTO `t_s_town` VALUES ('1248', '团林乡', '130322201000', '130322000000');
INSERT INTO `t_s_town` VALUES ('1249', '葛条港乡', '130322202000', '130322000000');
INSERT INTO `t_s_town` VALUES ('1250', '马坨店乡', '130322203000', '130322000000');
INSERT INTO `t_s_town` VALUES ('1251', '两山乡', '130322206000', '130322000000');
INSERT INTO `t_s_town` VALUES ('1252', '十里铺乡', '130322207000', '130322000000');
INSERT INTO `t_s_town` VALUES ('1253', '卢龙镇', '130324100000', '130324000000');
INSERT INTO `t_s_town` VALUES ('1254', '潘庄镇', '130324101000', '130324000000');
INSERT INTO `t_s_town` VALUES ('1255', '燕河营镇', '130324102000', '130324000000');
INSERT INTO `t_s_town` VALUES ('1256', '双望镇', '130324103000', '130324000000');
INSERT INTO `t_s_town` VALUES ('1257', '刘田各庄镇', '130324104000', '130324000000');
INSERT INTO `t_s_town` VALUES ('1258', '石门镇', '130324105000', '130324000000');
INSERT INTO `t_s_town` VALUES ('1259', '木井镇', '130324106000', '130324000000');
INSERT INTO `t_s_town` VALUES ('1260', '陈官屯镇', '130324107000', '130324000000');
INSERT INTO `t_s_town` VALUES ('1261', '蛤泊镇', '130324108000', '130324000000');
INSERT INTO `t_s_town` VALUES ('1262', '下寨乡', '130324200000', '130324000000');
INSERT INTO `t_s_town` VALUES ('1263', '刘家营乡', '130324201000', '130324000000');
INSERT INTO `t_s_town` VALUES ('1264', '印庄乡', '130324203000', '130324000000');
INSERT INTO `t_s_town` VALUES ('1265', '河北卢龙经济开发区', '130324400000', '130324000000');
INSERT INTO `t_s_town` VALUES ('1266', '船厂路街道办事处', '130371005000', '130371000000');
INSERT INTO `t_s_town` VALUES ('1267', '珠江道街道办事处', '130371011000', '130371000000');
INSERT INTO `t_s_town` VALUES ('1268', '黄河道街道办事处', '130371012000', '130371000000');
INSERT INTO `t_s_town` VALUES ('1269', '腾飞路街道办事处', '130371013000', '130371000000');
INSERT INTO `t_s_town` VALUES ('1270', '渤海乡', '130371200000', '130371000000');
INSERT INTO `t_s_town` VALUES ('1271', '榆关管理区办事处', '130371400000', '130371000000');
INSERT INTO `t_s_town` VALUES ('1272', '牛头崖管理区办事处', '130371401000', '130371000000');
INSERT INTO `t_s_town` VALUES ('1273', '南戴河街道办事处', '130372001000', '130372000000');
INSERT INTO `t_s_town` VALUES ('1274', '大蒲河管理处', '130372400000', '130372000000');
INSERT INTO `t_s_town` VALUES ('1275', '团林管理处', '130372401000', '130372000000');
INSERT INTO `t_s_town` VALUES ('1276', '留守营管理处', '130372402000', '130372000000');
INSERT INTO `t_s_town` VALUES ('1277', '火磨街道办事处', '130402001000', '130402000000');
INSERT INTO `t_s_town` VALUES ('1278', '陵园路街道办事处', '130402002000', '130402000000');
INSERT INTO `t_s_town` VALUES ('1279', '光明路街道办事处', '130402003000', '130402000000');
INSERT INTO `t_s_town` VALUES ('1280', '滏东街道办事处', '130402004000', '130402000000');
INSERT INTO `t_s_town` VALUES ('1281', '罗城头街道办事处', '130402005000', '130402000000');
INSERT INTO `t_s_town` VALUES ('1282', '渚河路街道办事处', '130402006000', '130402000000');
INSERT INTO `t_s_town` VALUES ('1283', '浴新南街道办事处', '130402007000', '130402000000');
INSERT INTO `t_s_town` VALUES ('1284', '农林路街道办事处', '130402008000', '130402000000');
INSERT INTO `t_s_town` VALUES ('1285', '贸东街道办事处', '130402009000', '130402000000');
INSERT INTO `t_s_town` VALUES ('1286', '贸西街道办事处', '130402010000', '130402000000');
INSERT INTO `t_s_town` VALUES ('1287', '盛和路街道办事处', '130402011000', '130402000000');
INSERT INTO `t_s_town` VALUES ('1288', '北张庄镇', '130402101000', '130402000000');
INSERT INTO `t_s_town` VALUES ('1289', '河沙镇镇', '130402102000', '130402000000');
INSERT INTO `t_s_town` VALUES ('1290', '马庄乡', '130402200000', '130402000000');
INSERT INTO `t_s_town` VALUES ('1291', '南堡乡', '130402201000', '130402000000');
INSERT INTO `t_s_town` VALUES ('1292', '代召乡', '130402202000', '130402000000');
INSERT INTO `t_s_town` VALUES ('1293', '丛台西街道办事处', '130403001000', '130403000000');
INSERT INTO `t_s_town` VALUES ('1294', '联纺西街道办事处', '130403002000', '130403000000');
INSERT INTO `t_s_town` VALUES ('1295', '联纺东街道办事处', '130403003000', '130403000000');
INSERT INTO `t_s_town` VALUES ('1296', '光明桥街道办事处', '130403004000', '130403000000');
INSERT INTO `t_s_town` VALUES ('1297', '丛台东街道办事处', '130403005000', '130403000000');
INSERT INTO `t_s_town` VALUES ('1298', '四季青街道办事处', '130403006000', '130403000000');
INSERT INTO `t_s_town` VALUES ('1299', '和平街道办事处', '130403007000', '130403000000');
INSERT INTO `t_s_town` VALUES ('1300', '中华街道办事处', '130403008000', '130403000000');
INSERT INTO `t_s_town` VALUES ('1301', '人民路街道办事处', '130403009000', '130403000000');
INSERT INTO `t_s_town` VALUES ('1302', '柳林桥街道办事处', '130403010000', '130403000000');
INSERT INTO `t_s_town` VALUES ('1303', '黄粱梦镇', '130403101000', '130403000000');
INSERT INTO `t_s_town` VALUES ('1304', '苏曹乡', '130403200000', '130403000000');
INSERT INTO `t_s_town` VALUES ('1305', '三陵乡', '130403205000', '130403000000');
INSERT INTO `t_s_town` VALUES ('1306', '南吕固乡', '130403206000', '130403000000');
INSERT INTO `t_s_town` VALUES ('1307', '兼庄乡', '130403207000', '130403000000');
INSERT INTO `t_s_town` VALUES ('1308', '胜利桥街道办事处', '130404001000', '130404000000');
INSERT INTO `t_s_town` VALUES ('1309', '百家村街道办事处', '130404002000', '130404000000');
INSERT INTO `t_s_town` VALUES ('1310', '铁路大院街道办事处', '130404003000', '130404000000');
INSERT INTO `t_s_town` VALUES ('1311', '化林路街道办事处', '130404004000', '130404000000');
INSERT INTO `t_s_town` VALUES ('1312', '庞村街道办事处', '130404005000', '130404000000');
INSERT INTO `t_s_town` VALUES ('1313', '二六七二街道办事处', '130404006000', '130404000000');
INSERT INTO `t_s_town` VALUES ('1314', '石化街道办事处', '130404007000', '130404000000');
INSERT INTO `t_s_town` VALUES ('1315', '户村镇', '130404100000', '130404000000');
INSERT INTO `t_s_town` VALUES ('1316', '彭家寨乡', '130404200000', '130404000000');
INSERT INTO `t_s_town` VALUES ('1317', '康庄乡', '130404201000', '130404000000');
INSERT INTO `t_s_town` VALUES ('1318', '滏阳东路街道办事处', '130406001000', '130406000000');
INSERT INTO `t_s_town` VALUES ('1319', '临水镇', '130406100000', '130406000000');
INSERT INTO `t_s_town` VALUES ('1320', '峰峰镇', '130406101000', '130406000000');
INSERT INTO `t_s_town` VALUES ('1321', '新坡镇', '130406102000', '130406000000');
INSERT INTO `t_s_town` VALUES ('1322', '大社镇', '130406103000', '130406000000');
INSERT INTO `t_s_town` VALUES ('1323', '和村镇', '130406104000', '130406000000');
INSERT INTO `t_s_town` VALUES ('1324', '义井镇', '130406105000', '130406000000');
INSERT INTO `t_s_town` VALUES ('1325', '彭城镇', '130406106000', '130406000000');
INSERT INTO `t_s_town` VALUES ('1326', '界城镇', '130406107000', '130406000000');
INSERT INTO `t_s_town` VALUES ('1327', '大峪镇', '130406108000', '130406000000');
INSERT INTO `t_s_town` VALUES ('1328', '西固义乡', '130406200000', '130406000000');
INSERT INTO `t_s_town` VALUES ('1329', '肥乡镇', '130407100000', '130407000000');
INSERT INTO `t_s_town` VALUES ('1330', '天台山镇', '130407101000', '130407000000');
INSERT INTO `t_s_town` VALUES ('1331', '辛安镇镇', '130407102000', '130407000000');
INSERT INTO `t_s_town` VALUES ('1332', '大寺上镇', '130407103000', '130407000000');
INSERT INTO `t_s_town` VALUES ('1333', '东漳堡镇', '130407104000', '130407000000');
INSERT INTO `t_s_town` VALUES ('1334', '毛演堡乡', '130407202000', '130407000000');
INSERT INTO `t_s_town` VALUES ('1335', '元固乡', '130407203000', '130407000000');
INSERT INTO `t_s_town` VALUES ('1336', '屯庄营乡', '130407204000', '130407000000');
INSERT INTO `t_s_town` VALUES ('1337', '旧店乡', '130407206000', '130407000000');
INSERT INTO `t_s_town` VALUES ('1338', '临洺关镇', '130408100000', '130408000000');
INSERT INTO `t_s_town` VALUES ('1339', '大北汪镇', '130408101000', '130408000000');
INSERT INTO `t_s_town` VALUES ('1340', '张西堡镇', '130408102000', '130408000000');
INSERT INTO `t_s_town` VALUES ('1341', '广府镇', '130408103000', '130408000000');
INSERT INTO `t_s_town` VALUES ('1342', '永合会镇', '130408105000', '130408000000');
INSERT INTO `t_s_town` VALUES ('1343', '刘营镇', '130408106000', '130408000000');
INSERT INTO `t_s_town` VALUES ('1344', '西苏镇', '130408107000', '130408000000');
INSERT INTO `t_s_town` VALUES ('1345', '讲武镇', '130408108000', '130408000000');
INSERT INTO `t_s_town` VALUES ('1346', '东杨庄镇', '130408109000', '130408000000');
INSERT INTO `t_s_town` VALUES ('1347', '界河店乡', '130408201000', '130408000000');
INSERT INTO `t_s_town` VALUES ('1348', '刘汉乡', '130408203000', '130408000000');
INSERT INTO `t_s_town` VALUES ('1349', '正西乡', '130408204000', '130408000000');
INSERT INTO `t_s_town` VALUES ('1350', '曲陌乡', '130408206000', '130408000000');
INSERT INTO `t_s_town` VALUES ('1351', '辛庄堡乡', '130408207000', '130408000000');
INSERT INTO `t_s_town` VALUES ('1352', '小龙马乡', '130408208000', '130408000000');
INSERT INTO `t_s_town` VALUES ('1353', '西河庄乡', '130408211000', '130408000000');
INSERT INTO `t_s_town` VALUES ('1354', '西阳城乡', '130408213000', '130408000000');
INSERT INTO `t_s_town` VALUES ('1355', '临漳镇', '130423100000', '130423000000');
INSERT INTO `t_s_town` VALUES ('1356', '南东坊镇', '130423101000', '130423000000');
INSERT INTO `t_s_town` VALUES ('1357', '孙陶集镇', '130423102000', '130423000000');
INSERT INTO `t_s_town` VALUES ('1358', '柳园镇', '130423103000', '130423000000');
INSERT INTO `t_s_town` VALUES ('1359', '称勾集镇', '130423104000', '130423000000');
INSERT INTO `t_s_town` VALUES ('1360', '邺城镇', '130423105000', '130423000000');
INSERT INTO `t_s_town` VALUES ('1361', '章里集镇', '130423106000', '130423000000');
INSERT INTO `t_s_town` VALUES ('1362', '狄邱乡', '130423200000', '130423000000');
INSERT INTO `t_s_town` VALUES ('1363', '张村集乡', '130423201000', '130423000000');
INSERT INTO `t_s_town` VALUES ('1364', '西羊羔乡', '130423202000', '130423000000');
INSERT INTO `t_s_town` VALUES ('1365', '杜村集乡', '130423204000', '130423000000');
INSERT INTO `t_s_town` VALUES ('1366', '习文乡', '130423206000', '130423000000');
INSERT INTO `t_s_town` VALUES ('1367', '砖寨营乡', '130423207000', '130423000000');
INSERT INTO `t_s_town` VALUES ('1368', '柏鹤集乡', '130423208000', '130423000000');
INSERT INTO `t_s_town` VALUES ('1369', '成安镇', '130424100000', '130424000000');
INSERT INTO `t_s_town` VALUES ('1370', '商城镇', '130424101000', '130424000000');
INSERT INTO `t_s_town` VALUES ('1371', '漳河店镇', '130424102000', '130424000000');
INSERT INTO `t_s_town` VALUES ('1372', '李家疃镇', '130424103000', '130424000000');
INSERT INTO `t_s_town` VALUES ('1373', '北乡义镇', '130424104000', '130424000000');
INSERT INTO `t_s_town` VALUES ('1374', '辛义乡', '130424200000', '130424000000');
INSERT INTO `t_s_town` VALUES ('1375', '柏寺营乡', '130424201000', '130424000000');
INSERT INTO `t_s_town` VALUES ('1376', '道东堡乡', '130424202000', '130424000000');
INSERT INTO `t_s_town` VALUES ('1377', '长巷乡', '130424204000', '130424000000');
INSERT INTO `t_s_town` VALUES ('1378', '大名镇', '130425100000', '130425000000');
INSERT INTO `t_s_town` VALUES ('1379', '杨桥镇', '130425101000', '130425000000');
INSERT INTO `t_s_town` VALUES ('1380', '万堤镇', '130425102000', '130425000000');
INSERT INTO `t_s_town` VALUES ('1381', '龙王庙镇', '130425103000', '130425000000');
INSERT INTO `t_s_town` VALUES ('1382', '束馆镇', '130425104000', '130425000000');
INSERT INTO `t_s_town` VALUES ('1383', '金滩镇', '130425105000', '130425000000');
INSERT INTO `t_s_town` VALUES ('1384', '沙圪塔镇', '130425106000', '130425000000');
INSERT INTO `t_s_town` VALUES ('1385', '大街镇', '130425107000', '130425000000');
INSERT INTO `t_s_town` VALUES ('1386', '铺上镇', '130425108000', '130425000000');
INSERT INTO `t_s_town` VALUES ('1387', '孙甘店镇', '130425109000', '130425000000');
INSERT INTO `t_s_town` VALUES ('1388', '王村乡', '130425201000', '130425000000');
INSERT INTO `t_s_town` VALUES ('1389', '黄金堤乡', '130425203000', '130425000000');
INSERT INTO `t_s_town` VALUES ('1390', '旧治乡', '130425205000', '130425000000');
INSERT INTO `t_s_town` VALUES ('1391', '西未庄乡', '130425206000', '130425000000');
INSERT INTO `t_s_town` VALUES ('1392', '西付集乡', '130425208000', '130425000000');
INSERT INTO `t_s_town` VALUES ('1393', '埝头乡', '130425209000', '130425000000');
INSERT INTO `t_s_town` VALUES ('1394', '北峰乡', '130425210000', '130425000000');
INSERT INTO `t_s_town` VALUES ('1395', '张铁集乡', '130425211000', '130425000000');
INSERT INTO `t_s_town` VALUES ('1396', '红庙乡', '130425212000', '130425000000');
INSERT INTO `t_s_town` VALUES ('1397', '营镇回族乡', '130425213000', '130425000000');
INSERT INTO `t_s_town` VALUES ('1398', '平安街道办事处', '130426001000', '130426000000');
INSERT INTO `t_s_town` VALUES ('1399', '河南店镇', '130426101000', '130426000000');
INSERT INTO `t_s_town` VALUES ('1400', '索堡镇', '130426102000', '130426000000');
INSERT INTO `t_s_town` VALUES ('1401', '西戌镇', '130426103000', '130426000000');
INSERT INTO `t_s_town` VALUES ('1402', '井店镇', '130426104000', '130426000000');
INSERT INTO `t_s_town` VALUES ('1403', '更乐镇', '130426105000', '130426000000');
INSERT INTO `t_s_town` VALUES ('1404', '固新镇', '130426106000', '130426000000');
INSERT INTO `t_s_town` VALUES ('1405', '西达镇', '130426107000', '130426000000');
INSERT INTO `t_s_town` VALUES ('1406', '偏城镇', '130426108000', '130426000000');
INSERT INTO `t_s_town` VALUES ('1407', '神头乡', '130426200000', '130426000000');
INSERT INTO `t_s_town` VALUES ('1408', '辽城乡', '130426201000', '130426000000');
INSERT INTO `t_s_town` VALUES ('1409', '偏店乡', '130426202000', '130426000000');
INSERT INTO `t_s_town` VALUES ('1410', '龙虎乡', '130426203000', '130426000000');
INSERT INTO `t_s_town` VALUES ('1411', '木井乡', '130426204000', '130426000000');
INSERT INTO `t_s_town` VALUES ('1412', '关防乡', '130426205000', '130426000000');
INSERT INTO `t_s_town` VALUES ('1413', '合漳乡', '130426206000', '130426000000');
INSERT INTO `t_s_town` VALUES ('1414', '鹿头乡', '130426207000', '130426000000');
INSERT INTO `t_s_town` VALUES ('1415', '涉城镇', '130426400000', '130426000000');
INSERT INTO `t_s_town` VALUES ('1416', '磁州镇', '130427100000', '130427000000');
INSERT INTO `t_s_town` VALUES ('1417', '讲武城镇', '130427103000', '130427000000');
INSERT INTO `t_s_town` VALUES ('1418', '岳城镇', '130427104000', '130427000000');
INSERT INTO `t_s_town` VALUES ('1419', '观台镇', '130427105000', '130427000000');
INSERT INTO `t_s_town` VALUES ('1420', '白土镇', '130427107000', '130427000000');
INSERT INTO `t_s_town` VALUES ('1421', '黄沙镇', '130427108000', '130427000000');
INSERT INTO `t_s_town` VALUES ('1422', '路村营乡', '130427200000', '130427000000');
INSERT INTO `t_s_town` VALUES ('1423', '时村营乡', '130427204000', '130427000000');
INSERT INTO `t_s_town` VALUES ('1424', '陶泉乡', '130427207000', '130427000000');
INSERT INTO `t_s_town` VALUES ('1425', '都党乡', '130427208000', '130427000000');
INSERT INTO `t_s_town` VALUES ('1426', '北贾壁乡', '130427209000', '130427000000');
INSERT INTO `t_s_town` VALUES ('1427', '新马头镇', '130430100000', '130430000000');
INSERT INTO `t_s_town` VALUES ('1428', '邱城镇', '130430101000', '130430000000');
INSERT INTO `t_s_town` VALUES ('1429', '梁二庄镇', '130430102000', '130430000000');
INSERT INTO `t_s_town` VALUES ('1430', '香城固镇', '130430103000', '130430000000');
INSERT INTO `t_s_town` VALUES ('1431', '古城营镇', '130430104000', '130430000000');
INSERT INTO `t_s_town` VALUES ('1432', '南辛店乡', '130430201000', '130430000000');
INSERT INTO `t_s_town` VALUES ('1433', '陈村回族乡', '130430204000', '130430000000');
INSERT INTO `t_s_town` VALUES ('1434', '鸡泽镇', '130431100000', '130431000000');
INSERT INTO `t_s_town` VALUES ('1435', '小寨镇', '130431101000', '130431000000');
INSERT INTO `t_s_town` VALUES ('1436', '双塔镇', '130431102000', '130431000000');
INSERT INTO `t_s_town` VALUES ('1437', '曹庄镇', '130431103000', '130431000000');
INSERT INTO `t_s_town` VALUES ('1438', '浮图店乡', '130431200000', '130431000000');
INSERT INTO `t_s_town` VALUES ('1439', '吴官营乡', '130431201000', '130431000000');
INSERT INTO `t_s_town` VALUES ('1440', '风正乡', '130431202000', '130431000000');
INSERT INTO `t_s_town` VALUES ('1441', '广平镇', '130432100000', '130432000000');
INSERT INTO `t_s_town` VALUES ('1442', '平固店镇', '130432101000', '130432000000');
INSERT INTO `t_s_town` VALUES ('1443', '胜营镇', '130432102000', '130432000000');
INSERT INTO `t_s_town` VALUES ('1444', '南阳堡镇', '130432103000', '130432000000');
INSERT INTO `t_s_town` VALUES ('1445', '十里铺乡', '130432201000', '130432000000');
INSERT INTO `t_s_town` VALUES ('1446', '南韩村乡', '130432202000', '130432000000');
INSERT INTO `t_s_town` VALUES ('1447', '东张孟乡', '130432204000', '130432000000');
INSERT INTO `t_s_town` VALUES ('1448', '馆陶镇', '130433100000', '130433000000');
INSERT INTO `t_s_town` VALUES ('1449', '房寨镇', '130433101000', '130433000000');
INSERT INTO `t_s_town` VALUES ('1450', '柴堡镇', '130433102000', '130433000000');
INSERT INTO `t_s_town` VALUES ('1451', '魏僧寨镇', '130433103000', '130433000000');
INSERT INTO `t_s_town` VALUES ('1452', '寿山寺乡', '130433200000', '130433000000');
INSERT INTO `t_s_town` VALUES ('1453', '王桥乡', '130433201000', '130433000000');
INSERT INTO `t_s_town` VALUES ('1454', '南徐村乡', '130433202000', '130433000000');
INSERT INTO `t_s_town` VALUES ('1455', '路桥乡', '130433203000', '130433000000');
INSERT INTO `t_s_town` VALUES ('1456', '魏城镇', '130434100000', '130434000000');
INSERT INTO `t_s_town` VALUES ('1457', '德政镇', '130434101000', '130434000000');
INSERT INTO `t_s_town` VALUES ('1458', '北皋镇', '130434102000', '130434000000');
INSERT INTO `t_s_town` VALUES ('1459', '双井镇', '130434103000', '130434000000');
INSERT INTO `t_s_town` VALUES ('1460', '牙里镇', '130434104000', '130434000000');
INSERT INTO `t_s_town` VALUES ('1461', '车往镇', '130434105000', '130434000000');
INSERT INTO `t_s_town` VALUES ('1462', '回隆镇', '130434106000', '130434000000');
INSERT INTO `t_s_town` VALUES ('1463', '张二庄镇', '130434107000', '130434000000');
INSERT INTO `t_s_town` VALUES ('1464', '东代固镇', '130434108000', '130434000000');
INSERT INTO `t_s_town` VALUES ('1465', '院堡镇', '130434109000', '130434000000');
INSERT INTO `t_s_town` VALUES ('1466', '棘针寨镇', '130434110000', '130434000000');
INSERT INTO `t_s_town` VALUES ('1467', '南双庙镇', '130434111000', '130434000000');
INSERT INTO `t_s_town` VALUES ('1468', '沙口集乡', '130434202000', '130434000000');
INSERT INTO `t_s_town` VALUES ('1469', '野胡拐乡', '130434203000', '130434000000');
INSERT INTO `t_s_town` VALUES ('1470', '仕望集乡', '130434204000', '130434000000');
INSERT INTO `t_s_town` VALUES ('1471', '前大磨乡', '130434205000', '130434000000');
INSERT INTO `t_s_town` VALUES ('1472', '大辛庄乡', '130434208000', '130434000000');
INSERT INTO `t_s_town` VALUES ('1473', '大马村乡', '130434209000', '130434000000');
INSERT INTO `t_s_town` VALUES ('1474', '边马乡', '130434210000', '130434000000');
INSERT INTO `t_s_town` VALUES ('1475', '北台头乡', '130434212000', '130434000000');
INSERT INTO `t_s_town` VALUES ('1476', '泊口乡', '130434213000', '130434000000');
INSERT INTO `t_s_town` VALUES ('1477', '曲周镇', '130435100000', '130435000000');
INSERT INTO `t_s_town` VALUES ('1478', '安寨镇', '130435101000', '130435000000');
INSERT INTO `t_s_town` VALUES ('1479', '侯村镇', '130435102000', '130435000000');
INSERT INTO `t_s_town` VALUES ('1480', '河南疃镇', '130435103000', '130435000000');
INSERT INTO `t_s_town` VALUES ('1481', '第四疃镇', '130435104000', '130435000000');
INSERT INTO `t_s_town` VALUES ('1482', '白寨镇', '130435105000', '130435000000');
INSERT INTO `t_s_town` VALUES ('1483', '槐桥乡', '130435200000', '130435000000');
INSERT INTO `t_s_town` VALUES ('1484', '南里岳乡', '130435201000', '130435000000');
INSERT INTO `t_s_town` VALUES ('1485', '大河道乡', '130435203000', '130435000000');
INSERT INTO `t_s_town` VALUES ('1486', '依庄乡', '130435204000', '130435000000');
INSERT INTO `t_s_town` VALUES ('1487', '开发区办事处', '130471001000', '130471000000');
INSERT INTO `t_s_town` VALUES ('1488', '尚璧镇', '130471100000', '130471000000');
INSERT INTO `t_s_town` VALUES ('1489', '南沿村镇', '130471101000', '130471000000');
INSERT INTO `t_s_town` VALUES ('1490', '小西堡乡', '130471200000', '130471000000');
INSERT INTO `t_s_town` VALUES ('1491', '姚寨乡', '130471201000', '130471000000');
INSERT INTO `t_s_town` VALUES ('1492', '城南办事处', '130473001000', '130473000000');
INSERT INTO `t_s_town` VALUES ('1493', '高臾镇', '130473100000', '130473000000');
INSERT INTO `t_s_town` VALUES ('1494', '西光禄镇', '130473101000', '130473000000');
INSERT INTO `t_s_town` VALUES ('1495', '林坛镇', '130473102000', '130473000000');
INSERT INTO `t_s_town` VALUES ('1496', '马头镇', '130473103000', '130473000000');
INSERT INTO `t_s_town` VALUES ('1497', '辛庄营乡', '130473200000', '130473000000');
INSERT INTO `t_s_town` VALUES ('1498', '花官营乡', '130473201000', '130473000000');
INSERT INTO `t_s_town` VALUES ('1499', '台城乡', '130473202000', '130473000000');
INSERT INTO `t_s_town` VALUES ('1500', '南城乡', '130473203000', '130473000000');
INSERT INTO `t_s_town` VALUES ('1501', '武安镇', '130481100000', '130481000000');
INSERT INTO `t_s_town` VALUES ('1502', '康二城镇', '130481101000', '130481000000');
INSERT INTO `t_s_town` VALUES ('1503', '午汲镇', '130481102000', '130481000000');
INSERT INTO `t_s_town` VALUES ('1504', '磁山镇', '130481103000', '130481000000');
INSERT INTO `t_s_town` VALUES ('1505', '伯延镇', '130481104000', '130481000000');
INSERT INTO `t_s_town` VALUES ('1506', '淑村镇', '130481105000', '130481000000');
INSERT INTO `t_s_town` VALUES ('1507', '大同镇', '130481106000', '130481000000');
INSERT INTO `t_s_town` VALUES ('1508', '邑城镇', '130481107000', '130481000000');
INSERT INTO `t_s_town` VALUES ('1509', '矿山镇', '130481108000', '130481000000');
INSERT INTO `t_s_town` VALUES ('1510', '贺进镇', '130481109000', '130481000000');
INSERT INTO `t_s_town` VALUES ('1511', '阳邑镇', '130481110000', '130481000000');
INSERT INTO `t_s_town` VALUES ('1512', '徘徊镇', '130481111000', '130481000000');
INSERT INTO `t_s_town` VALUES ('1513', '冶陶镇', '130481112000', '130481000000');
INSERT INTO `t_s_town` VALUES ('1514', '上团城乡', '130481200000', '130481000000');
INSERT INTO `t_s_town` VALUES ('1515', '北安庄乡', '130481201000', '130481000000');
INSERT INTO `t_s_town` VALUES ('1516', '北安乐乡', '130481202000', '130481000000');
INSERT INTO `t_s_town` VALUES ('1517', '西土山乡', '130481203000', '130481000000');
INSERT INTO `t_s_town` VALUES ('1518', '西寺庄乡', '130481204000', '130481000000');
INSERT INTO `t_s_town` VALUES ('1519', '活水乡', '130481205000', '130481000000');
INSERT INTO `t_s_town` VALUES ('1520', '石洞乡', '130481206000', '130481000000');
INSERT INTO `t_s_town` VALUES ('1521', '管陶乡', '130481207000', '130481000000');
INSERT INTO `t_s_town` VALUES ('1522', '马家庄乡', '130481208000', '130481000000');
INSERT INTO `t_s_town` VALUES ('1523', '南长街街道办事处', '130502001000', '130502000000');
INSERT INTO `t_s_town` VALUES ('1524', '北大街街道办事处', '130502002000', '130502000000');
INSERT INTO `t_s_town` VALUES ('1525', '西大街街道办事处', '130502003000', '130502000000');
INSERT INTO `t_s_town` VALUES ('1526', '西门里街道办事处', '130502004000', '130502000000');
INSERT INTO `t_s_town` VALUES ('1527', '泉东街道办事处', '130502005000', '130502000000');
INSERT INTO `t_s_town` VALUES ('1528', '豫让桥街道', '130502006000', '130502000000');
INSERT INTO `t_s_town` VALUES ('1529', '东郭村镇', '130502100000', '130502000000');
INSERT INTO `t_s_town` VALUES ('1530', '祝村镇', '130502101000', '130502000000');
INSERT INTO `t_s_town` VALUES ('1531', '大梁庄乡', '130502200000', '130502000000');
INSERT INTO `t_s_town` VALUES ('1532', '钢铁路街道办事处', '130503001000', '130503000000');
INSERT INTO `t_s_town` VALUES ('1533', '中兴路街道办事处', '130503002000', '130503000000');
INSERT INTO `t_s_town` VALUES ('1534', '达活泉街道办事处', '130503003000', '130503000000');
INSERT INTO `t_s_town` VALUES ('1535', '张宽街道办事处', '130503004000', '130503000000');
INSERT INTO `t_s_town` VALUES ('1536', '章村街道办事处', '130503005000', '130503000000');
INSERT INTO `t_s_town` VALUES ('1537', '中华大街街道办事处', '130503006000', '130503000000');
INSERT INTO `t_s_town` VALUES ('1538', '团结路街道办事处', '130503007000', '130503000000');
INSERT INTO `t_s_town` VALUES ('1539', '泉西街道办事处', '130503008000', '130503000000');
INSERT INTO `t_s_town` VALUES ('1540', '南大郭镇', '130503100000', '130503000000');
INSERT INTO `t_s_town` VALUES ('1541', '李村镇', '130503101000', '130503000000');
INSERT INTO `t_s_town` VALUES ('1542', '晏家屯镇', '130521103000', '130521000000');
INSERT INTO `t_s_town` VALUES ('1543', '南石门镇', '130521104000', '130521000000');
INSERT INTO `t_s_town` VALUES ('1544', '羊范镇', '130521105000', '130521000000');
INSERT INTO `t_s_town` VALUES ('1545', '皇寺镇', '130521106000', '130521000000');
INSERT INTO `t_s_town` VALUES ('1546', '会宁镇', '130521107000', '130521000000');
INSERT INTO `t_s_town` VALUES ('1547', '西黄村镇', '130521108000', '130521000000');
INSERT INTO `t_s_town` VALUES ('1548', '路罗镇', '130521109000', '130521000000');
INSERT INTO `t_s_town` VALUES ('1549', '将军墓镇', '130521110000', '130521000000');
INSERT INTO `t_s_town` VALUES ('1550', '浆水镇', '130521111000', '130521000000');
INSERT INTO `t_s_town` VALUES ('1551', '宋家庄镇', '130521112000', '130521000000');
INSERT INTO `t_s_town` VALUES ('1552', '太子井乡', '130521200000', '130521000000');
INSERT INTO `t_s_town` VALUES ('1553', '龙泉寺乡', '130521201000', '130521000000');
INSERT INTO `t_s_town` VALUES ('1554', '北小庄乡', '130521202000', '130521000000');
INSERT INTO `t_s_town` VALUES ('1555', '城计头乡', '130521203000', '130521000000');
INSERT INTO `t_s_town` VALUES ('1556', '白岸乡', '130521204000', '130521000000');
INSERT INTO `t_s_town` VALUES ('1557', '冀家村乡', '130521206000', '130521000000');
INSERT INTO `t_s_town` VALUES ('1558', '临城镇', '130522100000', '130522000000');
INSERT INTO `t_s_town` VALUES ('1559', '东镇镇', '130522101000', '130522000000');
INSERT INTO `t_s_town` VALUES ('1560', '西竖镇', '130522102000', '130522000000');
INSERT INTO `t_s_town` VALUES ('1561', '郝庄镇', '130522103000', '130522000000');
INSERT INTO `t_s_town` VALUES ('1562', '黑城乡', '130522200000', '130522000000');
INSERT INTO `t_s_town` VALUES ('1563', '鸭鸽营乡', '130522201000', '130522000000');
INSERT INTO `t_s_town` VALUES ('1564', '石城乡', '130522203000', '130522000000');
INSERT INTO `t_s_town` VALUES ('1565', '赵庄乡', '130522205000', '130522000000');
INSERT INTO `t_s_town` VALUES ('1566', '内丘镇', '130523100000', '130523000000');
INSERT INTO `t_s_town` VALUES ('1567', '大孟村镇', '130523101000', '130523000000');
INSERT INTO `t_s_town` VALUES ('1568', '金店镇', '130523102000', '130523000000');
INSERT INTO `t_s_town` VALUES ('1569', '官庄镇', '130523103000', '130523000000');
INSERT INTO `t_s_town` VALUES ('1570', '柳林镇', '130523104000', '130523000000');
INSERT INTO `t_s_town` VALUES ('1571', '五郭店乡', '130523200000', '130523000000');
INSERT INTO `t_s_town` VALUES ('1572', '南赛乡', '130523203000', '130523000000');
INSERT INTO `t_s_town` VALUES ('1573', '獐獏乡', '130523204000', '130523000000');
INSERT INTO `t_s_town` VALUES ('1574', '侯家庄乡', '130523205000', '130523000000');
INSERT INTO `t_s_town` VALUES ('1575', '柏乡镇', '130524100000', '130524000000');
INSERT INTO `t_s_town` VALUES ('1576', '固城店镇', '130524101000', '130524000000');
INSERT INTO `t_s_town` VALUES ('1577', '西汪镇', '130524102000', '130524000000');
INSERT INTO `t_s_town` VALUES ('1578', '龙华镇', '130524103000', '130524000000');
INSERT INTO `t_s_town` VALUES ('1579', '王家庄乡', '130524200000', '130524000000');
INSERT INTO `t_s_town` VALUES ('1580', '内步乡', '130524203000', '130524000000');
INSERT INTO `t_s_town` VALUES ('1581', '隆尧镇', '130525100000', '130525000000');
INSERT INTO `t_s_town` VALUES ('1582', '魏家庄镇', '130525101000', '130525000000');
INSERT INTO `t_s_town` VALUES ('1583', '尹村镇', '130525102000', '130525000000');
INSERT INTO `t_s_town` VALUES ('1584', '山口镇', '130525103000', '130525000000');
INSERT INTO `t_s_town` VALUES ('1585', '莲子镇镇', '130525104000', '130525000000');
INSERT INTO `t_s_town` VALUES ('1586', '固城镇', '130525105000', '130525000000');
INSERT INTO `t_s_town` VALUES ('1587', '东良镇', '130525106000', '130525000000');
INSERT INTO `t_s_town` VALUES ('1588', '北楼乡', '130525200000', '130525000000');
INSERT INTO `t_s_town` VALUES ('1589', '双碑乡', '130525202000', '130525000000');
INSERT INTO `t_s_town` VALUES ('1590', '牛家桥乡', '130525203000', '130525000000');
INSERT INTO `t_s_town` VALUES ('1591', '千户营乡', '130525204000', '130525000000');
INSERT INTO `t_s_town` VALUES ('1592', '大张庄乡', '130525205000', '130525000000');
INSERT INTO `t_s_town` VALUES ('1593', '柳行农场', '130525400000', '130525000000');
INSERT INTO `t_s_town` VALUES ('1594', '任城镇', '130526100000', '130526000000');
INSERT INTO `t_s_town` VALUES ('1595', '邢家湾镇', '130526101000', '130526000000');
INSERT INTO `t_s_town` VALUES ('1596', '辛店镇', '130526102000', '130526000000');
INSERT INTO `t_s_town` VALUES ('1597', '天口镇', '130526103000', '130526000000');
INSERT INTO `t_s_town` VALUES ('1598', '西固城乡', '130526200000', '130526000000');
INSERT INTO `t_s_town` VALUES ('1599', '永福庄乡', '130526201000', '130526000000');
INSERT INTO `t_s_town` VALUES ('1600', '大屯乡', '130526202000', '130526000000');
INSERT INTO `t_s_town` VALUES ('1601', '骆庄乡', '130526204000', '130526000000');
INSERT INTO `t_s_town` VALUES ('1602', '和阳镇', '130527100000', '130527000000');
INSERT INTO `t_s_town` VALUES ('1603', '贾宋镇', '130527101000', '130527000000');
INSERT INTO `t_s_town` VALUES ('1604', '郝桥镇', '130527102000', '130527000000');
INSERT INTO `t_s_town` VALUES ('1605', '东三召乡', '130527200000', '130527000000');
INSERT INTO `t_s_town` VALUES ('1606', '阎里乡', '130527201000', '130527000000');
INSERT INTO `t_s_town` VALUES ('1607', '河郭乡', '130527202000', '130527000000');
INSERT INTO `t_s_town` VALUES ('1608', '史召乡', '130527203000', '130527000000');
INSERT INTO `t_s_town` VALUES ('1609', '三思乡', '130527204000', '130527000000');
INSERT INTO `t_s_town` VALUES ('1610', '宁北街道办事处', '130528001000', '130528000000');
INSERT INTO `t_s_town` VALUES ('1611', '凤凰镇', '130528100000', '130528000000');
INSERT INTO `t_s_town` VALUES ('1612', '河渠镇', '130528101000', '130528000000');
INSERT INTO `t_s_town` VALUES ('1613', '北河庄镇', '130528102000', '130528000000');
INSERT INTO `t_s_town` VALUES ('1614', '耿庄桥镇', '130528103000', '130528000000');
INSERT INTO `t_s_town` VALUES ('1615', '东汪镇', '130528104000', '130528000000');
INSERT INTO `t_s_town` VALUES ('1616', '贾家口镇', '130528105000', '130528000000');
INSERT INTO `t_s_town` VALUES ('1617', '四芝兰镇', '130528106000', '130528000000');
INSERT INTO `t_s_town` VALUES ('1618', '大陆村镇', '130528107000', '130528000000');
INSERT INTO `t_s_town` VALUES ('1619', '苏家庄镇', '130528108000', '130528000000');
INSERT INTO `t_s_town` VALUES ('1620', '换马店镇', '130528109000', '130528000000');
INSERT INTO `t_s_town` VALUES ('1621', '唐邱镇', '130528110000', '130528000000');
INSERT INTO `t_s_town` VALUES ('1622', '侯口乡', '130528200000', '130528000000');
INSERT INTO `t_s_town` VALUES ('1623', '纪昌庄乡', '130528202000', '130528000000');
INSERT INTO `t_s_town` VALUES ('1624', '北鱼乡', '130528205000', '130528000000');
INSERT INTO `t_s_town` VALUES ('1625', '徐家河乡', '130528208000', '130528000000');
INSERT INTO `t_s_town` VALUES ('1626', '大曹庄乡', '130528209000', '130528000000');
INSERT INTO `t_s_town` VALUES ('1627', '大曹庄管理区', '130528401000', '130528000000');
INSERT INTO `t_s_town` VALUES ('1628', '巨鹿镇', '130529100000', '130529000000');
INSERT INTO `t_s_town` VALUES ('1629', '王虎寨镇', '130529101000', '130529000000');
INSERT INTO `t_s_town` VALUES ('1630', '西郭城镇', '130529102000', '130529000000');
INSERT INTO `t_s_town` VALUES ('1631', '官亭镇', '130529103000', '130529000000');
INSERT INTO `t_s_town` VALUES ('1632', '阎疃镇', '130529104000', '130529000000');
INSERT INTO `t_s_town` VALUES ('1633', '小吕寨镇', '130529105000', '130529000000');
INSERT INTO `t_s_town` VALUES ('1634', '苏家营镇', '130529106000', '130529000000');
INSERT INTO `t_s_town` VALUES ('1635', '堤村乡', '130529200000', '130529000000');
INSERT INTO `t_s_town` VALUES ('1636', '张王疃乡', '130529201000', '130529000000');
INSERT INTO `t_s_town` VALUES ('1637', '观寨乡', '130529202000', '130529000000');
INSERT INTO `t_s_town` VALUES ('1638', '新河镇', '130530100000', '130530000000');
INSERT INTO `t_s_town` VALUES ('1639', '寻寨镇', '130530101000', '130530000000');
INSERT INTO `t_s_town` VALUES ('1640', '白神首乡', '130530200000', '130530000000');
INSERT INTO `t_s_town` VALUES ('1641', '荆家庄乡', '130530201000', '130530000000');
INSERT INTO `t_s_town` VALUES ('1642', '西流乡', '130530202000', '130530000000');
INSERT INTO `t_s_town` VALUES ('1643', '仁让里乡', '130530203000', '130530000000');
INSERT INTO `t_s_town` VALUES ('1644', '广宗镇', '130531100000', '130531000000');
INSERT INTO `t_s_town` VALUES ('1645', '冯家寨镇', '130531101000', '130531000000');
INSERT INTO `t_s_town` VALUES ('1646', '北塘疃镇', '130531102000', '130531000000');
INSERT INTO `t_s_town` VALUES ('1647', '核桃园镇', '130531103000', '130531000000');
INSERT INTO `t_s_town` VALUES ('1648', '葫芦乡', '130531200000', '130531000000');
INSERT INTO `t_s_town` VALUES ('1649', '大平台乡', '130531201000', '130531000000');
INSERT INTO `t_s_town` VALUES ('1650', '件只乡', '130531202000', '130531000000');
INSERT INTO `t_s_town` VALUES ('1651', '东召乡', '130531204000', '130531000000');
INSERT INTO `t_s_town` VALUES ('1652', '平乡县中华路街道办事处', '130532001000', '130532000000');
INSERT INTO `t_s_town` VALUES ('1653', '平乡镇', '130532101000', '130532000000');
INSERT INTO `t_s_town` VALUES ('1654', '河古庙镇', '130532102000', '130532000000');
INSERT INTO `t_s_town` VALUES ('1655', '节固乡', '130532200000', '130532000000');
INSERT INTO `t_s_town` VALUES ('1656', '油召乡', '130532201000', '130532000000');
INSERT INTO `t_s_town` VALUES ('1657', '田付村乡', '130532202000', '130532000000');
INSERT INTO `t_s_town` VALUES ('1658', '寻召乡', '130532203000', '130532000000');
INSERT INTO `t_s_town` VALUES ('1659', '洺州镇', '130533100000', '130533000000');
INSERT INTO `t_s_town` VALUES ('1660', '梨园屯镇', '130533101000', '130533000000');
INSERT INTO `t_s_town` VALUES ('1661', '章台镇', '130533102000', '130533000000');
INSERT INTO `t_s_town` VALUES ('1662', '侯贯镇', '130533103000', '130533000000');
INSERT INTO `t_s_town` VALUES ('1663', '七级镇', '130533104000', '130533000000');
INSERT INTO `t_s_town` VALUES ('1664', '贺营镇', '130533105000', '130533000000');
INSERT INTO `t_s_town` VALUES ('1665', '方家营镇', '130533106000', '130533000000');
INSERT INTO `t_s_town` VALUES ('1666', '常庄镇', '130533107000', '130533000000');
INSERT INTO `t_s_town` VALUES ('1667', '第什营镇', '130533108000', '130533000000');
INSERT INTO `t_s_town` VALUES ('1668', '贺钊镇', '130533109000', '130533000000');
INSERT INTO `t_s_town` VALUES ('1669', '赵村镇', '130533110000', '130533000000');
INSERT INTO `t_s_town` VALUES ('1670', '枣园乡', '130533202000', '130533000000');
INSERT INTO `t_s_town` VALUES ('1671', '固献乡', '130533203000', '130533000000');
INSERT INTO `t_s_town` VALUES ('1672', '张家营乡', '130533206000', '130533000000');
INSERT INTO `t_s_town` VALUES ('1673', '常屯乡', '130533207000', '130533000000');
INSERT INTO `t_s_town` VALUES ('1674', '高公庄乡', '130533209000', '130533000000');
INSERT INTO `t_s_town` VALUES ('1675', '葛仙庄镇', '130534100000', '130534000000');
INSERT INTO `t_s_town` VALUES ('1676', '连庄镇', '130534101000', '130534000000');
INSERT INTO `t_s_town` VALUES ('1677', '油坊镇', '130534102000', '130534000000');
INSERT INTO `t_s_town` VALUES ('1678', '谢炉镇', '130534103000', '130534000000');
INSERT INTO `t_s_town` VALUES ('1679', '王官庄镇', '130534104000', '130534000000');
INSERT INTO `t_s_town` VALUES ('1680', '坝营镇', '130534105000', '130534000000');
INSERT INTO `t_s_town` VALUES ('1681', '临西镇', '130535100000', '130535000000');
INSERT INTO `t_s_town` VALUES ('1682', '河西镇', '130535101000', '130535000000');
INSERT INTO `t_s_town` VALUES ('1683', '下堡寺镇', '130535102000', '130535000000');
INSERT INTO `t_s_town` VALUES ('1684', '尖冢镇', '130535103000', '130535000000');
INSERT INTO `t_s_town` VALUES ('1685', '老官寨镇', '130535104000', '130535000000');
INSERT INTO `t_s_town` VALUES ('1686', '吕寨镇', '130535105000', '130535000000');
INSERT INTO `t_s_town` VALUES ('1687', '东枣园乡', '130535200000', '130535000000');
INSERT INTO `t_s_town` VALUES ('1688', '摇鞍镇乡', '130535203000', '130535000000');
INSERT INTO `t_s_town` VALUES ('1689', '大刘庄乡', '130535204000', '130535000000');
INSERT INTO `t_s_town` VALUES ('1690', '轴承工业园区', '130535400000', '130535000000');
INSERT INTO `t_s_town` VALUES ('1691', '东汪镇', '130571100000', '130571000000');
INSERT INTO `t_s_town` VALUES ('1692', '王快镇', '130571101000', '130571000000');
INSERT INTO `t_s_town` VALUES ('1693', '沙河城镇', '130571103000', '130571000000');
INSERT INTO `t_s_town` VALUES ('1694', '留村镇', '130571104000', '130571000000');
INSERT INTO `t_s_town` VALUES ('1695', '市高新技术开发区', '130571400000', '130571000000');
INSERT INTO `t_s_town` VALUES ('1696', '凤岗街道办事处', '130581001000', '130581000000');
INSERT INTO `t_s_town` VALUES ('1697', '南杜街道办事处', '130581002000', '130581000000');
INSERT INTO `t_s_town` VALUES ('1698', '北胡街道办事处', '130581003000', '130581000000');
INSERT INTO `t_s_town` VALUES ('1699', '西丁街道办事处', '130581004000', '130581000000');
INSERT INTO `t_s_town` VALUES ('1700', '苏村镇', '130581100000', '130581000000');
INSERT INTO `t_s_town` VALUES ('1701', '大高村镇', '130581101000', '130581000000');
INSERT INTO `t_s_town` VALUES ('1702', '垂杨镇', '130581102000', '130581000000');
INSERT INTO `t_s_town` VALUES ('1703', '明化镇', '130581103000', '130581000000');
INSERT INTO `t_s_town` VALUES ('1704', '段芦头镇', '130581104000', '130581000000');
INSERT INTO `t_s_town` VALUES ('1705', '紫冢镇', '130581105000', '130581000000');
INSERT INTO `t_s_town` VALUES ('1706', '大村乡', '130581200000', '130581000000');
INSERT INTO `t_s_town` VALUES ('1707', '南便村乡', '130581201000', '130581000000');
INSERT INTO `t_s_town` VALUES ('1708', '大屯乡', '130581202000', '130581000000');
INSERT INTO `t_s_town` VALUES ('1709', '王道寨乡', '130581203000', '130581000000');
INSERT INTO `t_s_town` VALUES ('1710', '薛吴村乡', '130581204000', '130581000000');
INSERT INTO `t_s_town` VALUES ('1711', '褡裢街道办事处', '130582001000', '130582000000');
INSERT INTO `t_s_town` VALUES ('1712', '桥东街道办事处', '130582002000', '130582000000');
INSERT INTO `t_s_town` VALUES ('1713', '桥西街道办事处', '130582003000', '130582000000');
INSERT INTO `t_s_town` VALUES ('1714', '赞善办事处', '130582004000', '130582000000');
INSERT INTO `t_s_town` VALUES ('1715', '周庄街道办事处', '130582005000', '130582000000');
INSERT INTO `t_s_town` VALUES ('1716', '新城镇', '130582101000', '130582000000');
INSERT INTO `t_s_town` VALUES ('1717', '白塔镇', '130582102000', '130582000000');
INSERT INTO `t_s_town` VALUES ('1718', '十里亭镇', '130582103000', '130582000000');
INSERT INTO `t_s_town` VALUES ('1719', '綦村镇', '130582104000', '130582000000');
INSERT INTO `t_s_town` VALUES ('1720', '册井乡', '130582201000', '130582000000');
INSERT INTO `t_s_town` VALUES ('1721', '刘石岗乡', '130582202000', '130582000000');
INSERT INTO `t_s_town` VALUES ('1722', '柴关乡', '130582203000', '130582000000');
INSERT INTO `t_s_town` VALUES ('1723', '蝉房乡', '130582204000', '130582000000');
INSERT INTO `t_s_town` VALUES ('1724', '先锋街道办事处', '130602001000', '130602000000');
INSERT INTO `t_s_town` VALUES ('1725', '新市场街道办事处', '130602002000', '130602000000');
INSERT INTO `t_s_town` VALUES ('1726', '东风街道办事处', '130602003000', '130602000000');
INSERT INTO `t_s_town` VALUES ('1727', '建南街道办事处', '130602004000', '130602000000');
INSERT INTO `t_s_town` VALUES ('1728', '韩村北路街道办事处', '130602005000', '130602000000');
INSERT INTO `t_s_town` VALUES ('1729', '颉庄乡', '130602200000', '130602000000');
INSERT INTO `t_s_town` VALUES ('1730', '富昌乡', '130602201000', '130602000000');
INSERT INTO `t_s_town` VALUES ('1731', '韩村乡', '130602202000', '130602000000');
INSERT INTO `t_s_town` VALUES ('1732', '南奇乡', '130602203000', '130602000000');
INSERT INTO `t_s_town` VALUES ('1733', '江城乡', '130602204000', '130602000000');
INSERT INTO `t_s_town` VALUES ('1734', '和平里街道办事处', '130606001000', '130606000000');
INSERT INTO `t_s_town` VALUES ('1735', '五四路街道办事处', '130606002000', '130606000000');
INSERT INTO `t_s_town` VALUES ('1736', '西关街道办事处', '130606003000', '130606000000');
INSERT INTO `t_s_town` VALUES ('1737', '中华路街道办事处', '130606004000', '130606000000');
INSERT INTO `t_s_town` VALUES ('1738', '东关街道办事处', '130606005000', '130606000000');
INSERT INTO `t_s_town` VALUES ('1739', '联盟街道办事处', '130606006000', '130606000000');
INSERT INTO `t_s_town` VALUES ('1740', '红星街道办事处', '130606007000', '130606000000');
INSERT INTO `t_s_town` VALUES ('1741', '裕华街道办事处', '130606008000', '130606000000');
INSERT INTO `t_s_town` VALUES ('1742', '永华街道办事处', '130606009000', '130606000000');
INSERT INTO `t_s_town` VALUES ('1743', '南关街道办事处', '130606010000', '130606000000');
INSERT INTO `t_s_town` VALUES ('1744', '韩庄乡', '130606200000', '130606000000');
INSERT INTO `t_s_town` VALUES ('1745', '东金庄乡', '130606201000', '130606000000');
INSERT INTO `t_s_town` VALUES ('1746', '百楼乡', '130606202000', '130606000000');
INSERT INTO `t_s_town` VALUES ('1747', '杨庄乡', '130606203000', '130606000000');
INSERT INTO `t_s_town` VALUES ('1748', '南大园乡', '130606204000', '130606000000');
INSERT INTO `t_s_town` VALUES ('1749', '焦庄乡', '130606205000', '130606000000');
INSERT INTO `t_s_town` VALUES ('1750', '五尧乡', '130606206000', '130606000000');
INSERT INTO `t_s_town` VALUES ('1751', '惠阳街道办事处', '130607001000', '130607000000');
INSERT INTO `t_s_town` VALUES ('1752', '满城镇', '130607100000', '130607000000');
INSERT INTO `t_s_town` VALUES ('1753', '大册营镇', '130607101000', '130607000000');
INSERT INTO `t_s_town` VALUES ('1754', '神星镇', '130607102000', '130607000000');
INSERT INTO `t_s_town` VALUES ('1755', '南韩村镇', '130607103000', '130607000000');
INSERT INTO `t_s_town` VALUES ('1756', '方顺桥镇', '130607104000', '130607000000');
INSERT INTO `t_s_town` VALUES ('1757', '于家庄乡', '130607201000', '130607000000');
INSERT INTO `t_s_town` VALUES ('1758', '要庄乡', '130607203000', '130607000000');
INSERT INTO `t_s_town` VALUES ('1759', '白龙乡', '130607204000', '130607000000');
INSERT INTO `t_s_town` VALUES ('1760', '石井乡', '130607205000', '130607000000');
INSERT INTO `t_s_town` VALUES ('1761', '坨南乡', '130607206000', '130607000000');
INSERT INTO `t_s_town` VALUES ('1762', '刘家台乡', '130607207000', '130607000000');
INSERT INTO `t_s_town` VALUES ('1763', '河北满城经济开发区', '130607400000', '130607000000');
INSERT INTO `t_s_town` VALUES ('1764', '清苑镇', '130608100000', '130608000000');
INSERT INTO `t_s_town` VALUES ('1765', '冉庄镇', '130608101000', '130608000000');
INSERT INTO `t_s_town` VALUES ('1766', '阳城镇', '130608102000', '130608000000');
INSERT INTO `t_s_town` VALUES ('1767', '魏村镇', '130608103000', '130608000000');
INSERT INTO `t_s_town` VALUES ('1768', '温仁镇', '130608104000', '130608000000');
INSERT INTO `t_s_town` VALUES ('1769', '张登镇', '130608105000', '130608000000');
INSERT INTO `t_s_town` VALUES ('1770', '大庄镇', '130608106000', '130608000000');
INSERT INTO `t_s_town` VALUES ('1771', '臧村镇', '130608107000', '130608000000');
INSERT INTO `t_s_town` VALUES ('1772', '望亭镇', '130608108000', '130608000000');
INSERT INTO `t_s_town` VALUES ('1773', '白团乡', '130608200000', '130608000000');
INSERT INTO `t_s_town` VALUES ('1774', '北店乡', '130608201000', '130608000000');
INSERT INTO `t_s_town` VALUES ('1775', '石桥乡', '130608202000', '130608000000');
INSERT INTO `t_s_town` VALUES ('1776', '李庄乡', '130608203000', '130608000000');
INSERT INTO `t_s_town` VALUES ('1777', '北王力乡', '130608204000', '130608000000');
INSERT INTO `t_s_town` VALUES ('1778', '东吕乡', '130608205000', '130608000000');
INSERT INTO `t_s_town` VALUES ('1779', '何桥乡', '130608206000', '130608000000');
INSERT INTO `t_s_town` VALUES ('1780', '孙村乡', '130608207000', '130608000000');
INSERT INTO `t_s_town` VALUES ('1781', '阎庄乡', '130608208000', '130608000000');
INSERT INTO `t_s_town` VALUES ('1782', '河北清苑经济开发区', '130608400000', '130608000000');
INSERT INTO `t_s_town` VALUES ('1783', '安肃镇', '130609100000', '130609000000');
INSERT INTO `t_s_town` VALUES ('1784', '崔庄镇', '130609101000', '130609000000');
INSERT INTO `t_s_town` VALUES ('1785', '大因镇', '130609102000', '130609000000');
INSERT INTO `t_s_town` VALUES ('1786', '遂城镇', '130609103000', '130609000000');
INSERT INTO `t_s_town` VALUES ('1787', '高林村镇', '130609104000', '130609000000');
INSERT INTO `t_s_town` VALUES ('1788', '大王店镇', '130609105000', '130609000000');
INSERT INTO `t_s_town` VALUES ('1789', '漕河镇', '130609106000', '130609000000');
INSERT INTO `t_s_town` VALUES ('1790', '东史端镇', '130609107000', '130609000000');
INSERT INTO `t_s_town` VALUES ('1791', '留村镇', '130609108000', '130609000000');
INSERT INTO `t_s_town` VALUES ('1792', '正村镇', '130609109000', '130609000000');
INSERT INTO `t_s_town` VALUES ('1793', '户木乡', '130609203000', '130609000000');
INSERT INTO `t_s_town` VALUES ('1794', '瀑河乡', '130609204000', '130609000000');
INSERT INTO `t_s_town` VALUES ('1795', '东釜山乡', '130609205000', '130609000000');
INSERT INTO `t_s_town` VALUES ('1796', '义联庄乡', '130609206000', '130609000000');
INSERT INTO `t_s_town` VALUES ('1797', '城区社区管理办公室街道办事处', '130623001000', '130623000000');
INSERT INTO `t_s_town` VALUES ('1798', '涞水镇', '130623100000', '130623000000');
INSERT INTO `t_s_town` VALUES ('1799', '永阳镇', '130623101000', '130623000000');
INSERT INTO `t_s_town` VALUES ('1800', '义安镇', '130623102000', '130623000000');
INSERT INTO `t_s_town` VALUES ('1801', '石亭镇', '130623103000', '130623000000');
INSERT INTO `t_s_town` VALUES ('1802', '赵各庄镇', '130623104000', '130623000000');
INSERT INTO `t_s_town` VALUES ('1803', '九龙镇', '130623105000', '130623000000');
INSERT INTO `t_s_town` VALUES ('1804', '三坡镇', '130623106000', '130623000000');
INSERT INTO `t_s_town` VALUES ('1805', '一渡镇', '130623107000', '130623000000');
INSERT INTO `t_s_town` VALUES ('1806', '明义镇', '130623108000', '130623000000');
INSERT INTO `t_s_town` VALUES ('1807', '王村镇', '130623109000', '130623000000');
INSERT INTO `t_s_town` VALUES ('1808', '娄村镇', '130623110000', '130623000000');
INSERT INTO `t_s_town` VALUES ('1809', '东文山乡', '130623202000', '130623000000');
INSERT INTO `t_s_town` VALUES ('1810', '其中口乡', '130623205000', '130623000000');
INSERT INTO `t_s_town` VALUES ('1811', '龙门乡', '130623206000', '130623000000');
INSERT INTO `t_s_town` VALUES ('1812', '胡家庄乡', '130623207000', '130623000000');
INSERT INTO `t_s_town` VALUES ('1813', '涞水县经济开发区', '130623400000', '130623000000');
INSERT INTO `t_s_town` VALUES ('1814', '阜平镇', '130624100000', '130624000000');
INSERT INTO `t_s_town` VALUES ('1815', '龙泉关镇', '130624101000', '130624000000');
INSERT INTO `t_s_town` VALUES ('1816', '平阳镇', '130624102000', '130624000000');
INSERT INTO `t_s_town` VALUES ('1817', '城南庄镇', '130624103000', '130624000000');
INSERT INTO `t_s_town` VALUES ('1818', '天生桥镇', '130624104000', '130624000000');
INSERT INTO `t_s_town` VALUES ('1819', '王林口镇', '130624105000', '130624000000');
INSERT INTO `t_s_town` VALUES ('1820', '台峪乡', '130624202000', '130624000000');
INSERT INTO `t_s_town` VALUES ('1821', '大台乡', '130624203000', '130624000000');
INSERT INTO `t_s_town` VALUES ('1822', '史家寨乡', '130624204000', '130624000000');
INSERT INTO `t_s_town` VALUES ('1823', '砂窝乡', '130624205000', '130624000000');
INSERT INTO `t_s_town` VALUES ('1824', '吴王口乡', '130624206000', '130624000000');
INSERT INTO `t_s_town` VALUES ('1825', '夏庄乡', '130624207000', '130624000000');
INSERT INTO `t_s_town` VALUES ('1826', '北果元乡', '130624208000', '130624000000');
INSERT INTO `t_s_town` VALUES ('1827', '定兴镇', '130626100000', '130626000000');
INSERT INTO `t_s_town` VALUES ('1828', '固城镇', '130626101000', '130626000000');
INSERT INTO `t_s_town` VALUES ('1829', '贤寓镇', '130626102000', '130626000000');
INSERT INTO `t_s_town` VALUES ('1830', '北河镇', '130626103000', '130626000000');
INSERT INTO `t_s_town` VALUES ('1831', '天宫寺镇', '130626104000', '130626000000');
INSERT INTO `t_s_town` VALUES ('1832', '小朱庄镇', '130626105000', '130626000000');
INSERT INTO `t_s_town` VALUES ('1833', '姚村镇', '130626106000', '130626000000');
INSERT INTO `t_s_town` VALUES ('1834', '东落堡乡', '130626200000', '130626000000');
INSERT INTO `t_s_town` VALUES ('1835', '高里乡', '130626201000', '130626000000');
INSERT INTO `t_s_town` VALUES ('1836', '张家庄乡', '130626202000', '130626000000');
INSERT INTO `t_s_town` VALUES ('1837', '肖村乡', '130626204000', '130626000000');
INSERT INTO `t_s_town` VALUES ('1838', '柳卓乡', '130626205000', '130626000000');
INSERT INTO `t_s_town` VALUES ('1839', '杨村乡', '130626206000', '130626000000');
INSERT INTO `t_s_town` VALUES ('1840', '北田乡', '130626207000', '130626000000');
INSERT INTO `t_s_town` VALUES ('1841', '北南蔡乡', '130626208000', '130626000000');
INSERT INTO `t_s_town` VALUES ('1842', '李郁庄乡', '130626209000', '130626000000');
INSERT INTO `t_s_town` VALUES ('1843', '仁厚镇', '130627100000', '130627000000');
INSERT INTO `t_s_town` VALUES ('1844', '王京镇', '130627101000', '130627000000');
INSERT INTO `t_s_town` VALUES ('1845', '高昌镇', '130627102000', '130627000000');
INSERT INTO `t_s_town` VALUES ('1846', '北罗镇', '130627103000', '130627000000');
INSERT INTO `t_s_town` VALUES ('1847', '白合镇', '130627104000', '130627000000');
INSERT INTO `t_s_town` VALUES ('1848', '军城镇', '130627105000', '130627000000');
INSERT INTO `t_s_town` VALUES ('1849', '川里镇', '130627106000', '130627000000');
INSERT INTO `t_s_town` VALUES ('1850', '长古城镇', '130627107000', '130627000000');
INSERT INTO `t_s_town` VALUES ('1851', '罗庄镇', '130627108000', '130627000000');
INSERT INTO `t_s_town` VALUES ('1852', '都亭乡', '130627201000', '130627000000');
INSERT INTO `t_s_town` VALUES ('1853', '南店头乡', '130627202000', '130627000000');
INSERT INTO `t_s_town` VALUES ('1854', '北店头乡', '130627203000', '130627000000');
INSERT INTO `t_s_town` VALUES ('1855', '雹水乡', '130627205000', '130627000000');
INSERT INTO `t_s_town` VALUES ('1856', '大洋乡', '130627206000', '130627000000');
INSERT INTO `t_s_town` VALUES ('1857', '迷城乡', '130627207000', '130627000000');
INSERT INTO `t_s_town` VALUES ('1858', '齐家佐乡', '130627208000', '130627000000');
INSERT INTO `t_s_town` VALUES ('1859', '羊角乡', '130627209000', '130627000000');
INSERT INTO `t_s_town` VALUES ('1860', '石门乡', '130627210000', '130627000000');
INSERT INTO `t_s_town` VALUES ('1861', '黄石口乡', '130627211000', '130627000000');
INSERT INTO `t_s_town` VALUES ('1862', '倒马关乡', '130627212000', '130627000000');
INSERT INTO `t_s_town` VALUES ('1863', '高阳县锦华街道办事处', '130628001000', '130628000000');
INSERT INTO `t_s_town` VALUES ('1864', '庞口镇', '130628101000', '130628000000');
INSERT INTO `t_s_town` VALUES ('1865', '西演镇', '130628102000', '130628000000');
INSERT INTO `t_s_town` VALUES ('1866', '邢家南镇', '130628103000', '130628000000');
INSERT INTO `t_s_town` VALUES ('1867', '晋庄镇', '130628104000', '130628000000');
INSERT INTO `t_s_town` VALUES ('1868', '蒲口乡', '130628202000', '130628000000');
INSERT INTO `t_s_town` VALUES ('1869', '小王果庄乡', '130628203000', '130628000000');
INSERT INTO `t_s_town` VALUES ('1870', '庞家佐乡', '130628205000', '130628000000');
INSERT INTO `t_s_town` VALUES ('1871', '高阳县经济开发区', '130628400000', '130628000000');
INSERT INTO `t_s_town` VALUES ('1872', '容城镇', '130629100000', '130629000000');
INSERT INTO `t_s_town` VALUES ('1873', '小里镇', '130629101000', '130629000000');
INSERT INTO `t_s_town` VALUES ('1874', '南张镇', '130629102000', '130629000000');
INSERT INTO `t_s_town` VALUES ('1875', '大河镇', '130629103000', '130629000000');
INSERT INTO `t_s_town` VALUES ('1876', '晾马台镇', '130629104000', '130629000000');
INSERT INTO `t_s_town` VALUES ('1877', '八于乡', '130629200000', '130629000000');
INSERT INTO `t_s_town` VALUES ('1878', '贾光乡', '130629201000', '130629000000');
INSERT INTO `t_s_town` VALUES ('1879', '平王乡', '130629203000', '130629000000');
INSERT INTO `t_s_town` VALUES ('1880', '涞源镇', '130630100000', '130630000000');
INSERT INTO `t_s_town` VALUES ('1881', '银坊镇', '130630101000', '130630000000');
INSERT INTO `t_s_town` VALUES ('1882', '走马驿镇', '130630102000', '130630000000');
INSERT INTO `t_s_town` VALUES ('1883', '水堡镇', '130630103000', '130630000000');
INSERT INTO `t_s_town` VALUES ('1884', '王安镇', '130630104000', '130630000000');
INSERT INTO `t_s_town` VALUES ('1885', '杨家庄镇', '130630105000', '130630000000');
INSERT INTO `t_s_town` VALUES ('1886', '白石山镇', '130630106000', '130630000000');
INSERT INTO `t_s_town` VALUES ('1887', '南屯镇', '130630107000', '130630000000');
INSERT INTO `t_s_town` VALUES ('1888', '南马庄乡', '130630201000', '130630000000');
INSERT INTO `t_s_town` VALUES ('1889', '北石佛乡', '130630202000', '130630000000');
INSERT INTO `t_s_town` VALUES ('1890', '金家井乡', '130630203000', '130630000000');
INSERT INTO `t_s_town` VALUES ('1891', '留家庄乡', '130630204000', '130630000000');
INSERT INTO `t_s_town` VALUES ('1892', '上庄乡', '130630205000', '130630000000');
INSERT INTO `t_s_town` VALUES ('1893', '东团堡乡', '130630206000', '130630000000');
INSERT INTO `t_s_town` VALUES ('1894', '塔崖驿乡', '130630207000', '130630000000');
INSERT INTO `t_s_town` VALUES ('1895', '乌龙沟乡', '130630208000', '130630000000');
INSERT INTO `t_s_town` VALUES ('1896', '烟煤洞乡', '130630209000', '130630000000');
INSERT INTO `t_s_town` VALUES ('1897', '望都镇', '130631100000', '130631000000');
INSERT INTO `t_s_town` VALUES ('1898', '固店镇', '130631101000', '130631000000');
INSERT INTO `t_s_town` VALUES ('1899', '贾村镇', '130631102000', '130631000000');
INSERT INTO `t_s_town` VALUES ('1900', '中韩庄镇', '130631103000', '130631000000');
INSERT INTO `t_s_town` VALUES ('1901', '寺庄乡', '130631200000', '130631000000');
INSERT INTO `t_s_town` VALUES ('1902', '赵庄乡', '130631201000', '130631000000');
INSERT INTO `t_s_town` VALUES ('1903', '黑堡乡', '130631202000', '130631000000');
INSERT INTO `t_s_town` VALUES ('1904', '高岭乡', '130631204000', '130631000000');
INSERT INTO `t_s_town` VALUES ('1905', '望都经济开发区', '130631400000', '130631000000');
INSERT INTO `t_s_town` VALUES ('1906', '安新镇', '130632100000', '130632000000');
INSERT INTO `t_s_town` VALUES ('1907', '大王镇', '130632101000', '130632000000');
INSERT INTO `t_s_town` VALUES ('1908', '三台镇', '130632102000', '130632000000');
INSERT INTO `t_s_town` VALUES ('1909', '端村镇', '130632103000', '130632000000');
INSERT INTO `t_s_town` VALUES ('1910', '赵北口镇', '130632104000', '130632000000');
INSERT INTO `t_s_town` VALUES ('1911', '同口镇', '130632105000', '130632000000');
INSERT INTO `t_s_town` VALUES ('1912', '刘李庄镇', '130632106000', '130632000000');
INSERT INTO `t_s_town` VALUES ('1913', '安州镇', '130632107000', '130632000000');
INSERT INTO `t_s_town` VALUES ('1914', '老河头镇', '130632108000', '130632000000');
INSERT INTO `t_s_town` VALUES ('1915', '圈头乡', '130632200000', '130632000000');
INSERT INTO `t_s_town` VALUES ('1916', '寨里乡', '130632201000', '130632000000');
INSERT INTO `t_s_town` VALUES ('1917', '芦庄乡', '130632202000', '130632000000');
INSERT INTO `t_s_town` VALUES ('1918', '龙化乡', '130632203000', '130632000000');
INSERT INTO `t_s_town` VALUES ('1919', '易州镇', '130633100000', '130633000000');
INSERT INTO `t_s_town` VALUES ('1920', '梁格庄镇', '130633101000', '130633000000');
INSERT INTO `t_s_town` VALUES ('1921', '西陵镇', '130633102000', '130633000000');
INSERT INTO `t_s_town` VALUES ('1922', '裴山镇', '130633103000', '130633000000');
INSERT INTO `t_s_town` VALUES ('1923', '塘湖镇', '130633104000', '130633000000');
INSERT INTO `t_s_town` VALUES ('1924', '狼牙山镇', '130633105000', '130633000000');
INSERT INTO `t_s_town` VALUES ('1925', '良岗镇', '130633106000', '130633000000');
INSERT INTO `t_s_town` VALUES ('1926', '紫荆关镇', '130633107000', '130633000000');
INSERT INTO `t_s_town` VALUES ('1927', '高村镇', '130633108000', '130633000000');
INSERT INTO `t_s_town` VALUES ('1928', '桥头乡', '130633200000', '130633000000');
INSERT INTO `t_s_town` VALUES ('1929', '白马乡', '130633201000', '130633000000');
INSERT INTO `t_s_town` VALUES ('1930', '流井乡', '130633202000', '130633000000');
INSERT INTO `t_s_town` VALUES ('1931', '高陌乡', '130633204000', '130633000000');
INSERT INTO `t_s_town` VALUES ('1932', '大龙华乡', '130633205000', '130633000000');
INSERT INTO `t_s_town` VALUES ('1933', '安格庄乡', '130633206000', '130633000000');
INSERT INTO `t_s_town` VALUES ('1934', '凌云册乡', '130633207000', '130633000000');
INSERT INTO `t_s_town` VALUES ('1935', '西山北乡', '130633208000', '130633000000');
INSERT INTO `t_s_town` VALUES ('1936', '尉都乡', '130633209000', '130633000000');
INSERT INTO `t_s_town` VALUES ('1937', '独乐乡', '130633210000', '130633000000');
INSERT INTO `t_s_town` VALUES ('1938', '七峪乡', '130633211000', '130633000000');
INSERT INTO `t_s_town` VALUES ('1939', '富岗乡', '130633212000', '130633000000');
INSERT INTO `t_s_town` VALUES ('1940', '坡仓乡', '130633213000', '130633000000');
INSERT INTO `t_s_town` VALUES ('1941', '牛岗乡', '130633214000', '130633000000');
INSERT INTO `t_s_town` VALUES ('1942', '桥家河乡', '130633215000', '130633000000');
INSERT INTO `t_s_town` VALUES ('1943', '甘河净乡', '130633216000', '130633000000');
INSERT INTO `t_s_town` VALUES ('1944', '蔡家峪乡', '130633217000', '130633000000');
INSERT INTO `t_s_town` VALUES ('1945', '南城司乡', '130633218000', '130633000000');
INSERT INTO `t_s_town` VALUES ('1946', '恒州镇', '130634100000', '130634000000');
INSERT INTO `t_s_town` VALUES ('1947', '灵山镇', '130634101000', '130634000000');
INSERT INTO `t_s_town` VALUES ('1948', '燕赵镇', '130634102000', '130634000000');
INSERT INTO `t_s_town` VALUES ('1949', '羊平镇', '130634103000', '130634000000');
INSERT INTO `t_s_town` VALUES ('1950', '文德镇', '130634104000', '130634000000');
INSERT INTO `t_s_town` VALUES ('1951', '晓林镇', '130634105000', '130634000000');
INSERT INTO `t_s_town` VALUES ('1952', '邸村镇', '130634106000', '130634000000');
INSERT INTO `t_s_town` VALUES ('1953', '齐村镇', '130634107000', '130634000000');
INSERT INTO `t_s_town` VALUES ('1954', '路庄子乡', '130634200000', '130634000000');
INSERT INTO `t_s_town` VALUES ('1955', '下河乡', '130634201000', '130634000000');
INSERT INTO `t_s_town` VALUES ('1956', '庄窠乡', '130634202000', '130634000000');
INSERT INTO `t_s_town` VALUES ('1957', '孝墓乡', '130634203000', '130634000000');
INSERT INTO `t_s_town` VALUES ('1958', '东旺乡', '130634205000', '130634000000');
INSERT INTO `t_s_town` VALUES ('1959', '产德乡', '130634208000', '130634000000');
INSERT INTO `t_s_town` VALUES ('1960', '党城乡', '130634210000', '130634000000');
INSERT INTO `t_s_town` VALUES ('1961', '郎家庄乡', '130634211000', '130634000000');
INSERT INTO `t_s_town` VALUES ('1962', '范家庄乡', '130634212000', '130634000000');
INSERT INTO `t_s_town` VALUES ('1963', '北台乡', '130634213000', '130634000000');
INSERT INTO `t_s_town` VALUES ('1964', '蠡吾镇', '130635100000', '130635000000');
INSERT INTO `t_s_town` VALUES ('1965', '留史镇', '130635101000', '130635000000');
INSERT INTO `t_s_town` VALUES ('1966', '大百尺镇', '130635102000', '130635000000');
INSERT INTO `t_s_town` VALUES ('1967', '辛兴镇', '130635103000', '130635000000');
INSERT INTO `t_s_town` VALUES ('1968', '北郭丹镇', '130635104000', '130635000000');
INSERT INTO `t_s_town` VALUES ('1969', '万安镇', '130635105000', '130635000000');
INSERT INTO `t_s_town` VALUES ('1970', '桑园镇', '130635106000', '130635000000');
INSERT INTO `t_s_town` VALUES ('1971', '南庄镇', '130635107000', '130635000000');
INSERT INTO `t_s_town` VALUES ('1972', '大曲堤镇', '130635108000', '130635000000');
INSERT INTO `t_s_town` VALUES ('1973', '鲍墟镇', '130635109000', '130635000000');
INSERT INTO `t_s_town` VALUES ('1974', '小陈乡', '130635200000', '130635000000');
INSERT INTO `t_s_town` VALUES ('1975', '林堡乡', '130635201000', '130635000000');
INSERT INTO `t_s_town` VALUES ('1976', '北埝头乡', '130635202000', '130635000000');
INSERT INTO `t_s_town` VALUES ('1977', '蒲阳镇', '130636100000', '130636000000');
INSERT INTO `t_s_town` VALUES ('1978', '高于铺镇', '130636101000', '130636000000');
INSERT INTO `t_s_town` VALUES ('1979', '腰山镇', '130636102000', '130636000000');
INSERT INTO `t_s_town` VALUES ('1980', '蒲上镇', '130636103000', '130636000000');
INSERT INTO `t_s_town` VALUES ('1981', '神南镇', '130636104000', '130636000000');
INSERT INTO `t_s_town` VALUES ('1982', '白云乡', '130636201000', '130636000000');
INSERT INTO `t_s_town` VALUES ('1983', '河口乡', '130636202000', '130636000000');
INSERT INTO `t_s_town` VALUES ('1984', '安阳乡', '130636203000', '130636000000');
INSERT INTO `t_s_town` VALUES ('1985', '台鱼乡', '130636204000', '130636000000');
INSERT INTO `t_s_town` VALUES ('1986', '大悲乡', '130636205000', '130636000000');
INSERT INTO `t_s_town` VALUES ('1987', '博野镇', '130637100000', '130637000000');
INSERT INTO `t_s_town` VALUES ('1988', '小店镇', '130637101000', '130637000000');
INSERT INTO `t_s_town` VALUES ('1989', '程委镇', '130637102000', '130637000000');
INSERT INTO `t_s_town` VALUES ('1990', '东墟镇', '130637103000', '130637000000');
INSERT INTO `t_s_town` VALUES ('1991', '北杨镇', '130637104000', '130637000000');
INSERT INTO `t_s_town` VALUES ('1992', '城东镇', '130637105000', '130637000000');
INSERT INTO `t_s_town` VALUES ('1993', '南小王乡', '130637203000', '130637000000');
INSERT INTO `t_s_town` VALUES ('1994', '雄州镇', '130638100000', '130638000000');
INSERT INTO `t_s_town` VALUES ('1995', '昝岗镇', '130638101000', '130638000000');
INSERT INTO `t_s_town` VALUES ('1996', '大营镇', '130638102000', '130638000000');
INSERT INTO `t_s_town` VALUES ('1997', '龙湾镇', '130638103000', '130638000000');
INSERT INTO `t_s_town` VALUES ('1998', '朱各庄镇', '130638104000', '130638000000');
INSERT INTO `t_s_town` VALUES ('1999', '米家务镇', '130638105000', '130638000000');
INSERT INTO `t_s_town` VALUES ('2000', '鄚州镇', '130638106000', '130638000000');
INSERT INTO `t_s_town` VALUES ('2001', '苟各庄镇', '130638107000', '130638000000');
INSERT INTO `t_s_town` VALUES ('2002', '北沙口乡', '130638200000', '130638000000');
INSERT INTO `t_s_town` VALUES ('2003', '双堂乡', '130638203000', '130638000000');
INSERT INTO `t_s_town` VALUES ('2004', '张岗乡', '130638204000', '130638000000');
INSERT INTO `t_s_town` VALUES ('2005', '七间房乡', '130638205000', '130638000000');
INSERT INTO `t_s_town` VALUES ('2006', '贤台乡', '130671202000', '130671000000');
INSERT INTO `t_s_town` VALUES ('2007', '大马坊乡', '130671205000', '130671000000');
INSERT INTO `t_s_town` VALUES ('2008', '保定国家高新区', '130671400000', '130671000000');
INSERT INTO `t_s_town` VALUES ('2009', '白沟镇', '130672103000', '130672000000');
INSERT INTO `t_s_town` VALUES ('2010', '双塔街道办事处', '130681001000', '130681000000');
INSERT INTO `t_s_town` VALUES ('2011', '桃园街道办事处', '130681002000', '130681000000');
INSERT INTO `t_s_town` VALUES ('2012', '清凉寺街道办事处', '130681003000', '130681000000');
INSERT INTO `t_s_town` VALUES ('2013', '松林店镇', '130681100000', '130681000000');
INSERT INTO `t_s_town` VALUES ('2014', '码头镇', '130681101000', '130681000000');
INSERT INTO `t_s_town` VALUES ('2015', '东城坊镇', '130681102000', '130681000000');
INSERT INTO `t_s_town` VALUES ('2016', '高官庄镇', '130681103000', '130681000000');
INSERT INTO `t_s_town` VALUES ('2017', '东仙坡镇', '130681104000', '130681000000');
INSERT INTO `t_s_town` VALUES ('2018', '百尺竿镇', '130681105000', '130681000000');
INSERT INTO `t_s_town` VALUES ('2019', '义和庄镇', '130681106000', '130681000000');
INSERT INTO `t_s_town` VALUES ('2020', '刁窝镇', '130681107000', '130681000000');
INSERT INTO `t_s_town` VALUES ('2021', '林家屯镇', '130681108000', '130681000000');
INSERT INTO `t_s_town` VALUES ('2022', '豆庄镇', '130681109000', '130681000000');
INSERT INTO `t_s_town` VALUES ('2023', '孙庄乡', '130681204000', '130681000000');
INSERT INTO `t_s_town` VALUES ('2024', '高新技术产业开发区管理委员会', '130681400000', '130681000000');
INSERT INTO `t_s_town` VALUES ('2025', '京南经济开发区管理委员会', '130681401000', '130681000000');
INSERT INTO `t_s_town` VALUES ('2026', '南城区街道办事处', '130682001000', '130682000000');
INSERT INTO `t_s_town` VALUES ('2027', '北城区街道办事处', '130682002000', '130682000000');
INSERT INTO `t_s_town` VALUES ('2028', '西城区街道办事处', '130682003000', '130682000000');
INSERT INTO `t_s_town` VALUES ('2029', '长安路街道办事处', '130682004000', '130682000000');
INSERT INTO `t_s_town` VALUES ('2030', '留早镇', '130682100000', '130682000000');
INSERT INTO `t_s_town` VALUES ('2031', '清风店镇', '130682101000', '130682000000');
INSERT INTO `t_s_town` VALUES ('2032', '庞村镇', '130682102000', '130682000000');
INSERT INTO `t_s_town` VALUES ('2033', '砖路镇', '130682103000', '130682000000');
INSERT INTO `t_s_town` VALUES ('2034', '明月店镇', '130682104000', '130682000000');
INSERT INTO `t_s_town` VALUES ('2035', '叮咛店镇', '130682105000', '130682000000');
INSERT INTO `t_s_town` VALUES ('2036', '东亭镇', '130682106000', '130682000000');
INSERT INTO `t_s_town` VALUES ('2037', '大辛庄镇', '130682107000', '130682000000');
INSERT INTO `t_s_town` VALUES ('2038', '东旺镇', '130682108000', '130682000000');
INSERT INTO `t_s_town` VALUES ('2039', '高蓬镇', '130682109000', '130682000000');
INSERT INTO `t_s_town` VALUES ('2040', '邢邑镇', '130682110000', '130682000000');
INSERT INTO `t_s_town` VALUES ('2041', '李亲顾镇', '130682111000', '130682000000');
INSERT INTO `t_s_town` VALUES ('2042', '子位镇', '130682112000', '130682000000');
INSERT INTO `t_s_town` VALUES ('2043', '开元镇', '130682113000', '130682000000');
INSERT INTO `t_s_town` VALUES ('2044', '周村镇', '130682115000', '130682000000');
INSERT INTO `t_s_town` VALUES ('2045', '息冢镇', '130682116000', '130682000000');
INSERT INTO `t_s_town` VALUES ('2046', '东留春乡', '130682203000', '130682000000');
INSERT INTO `t_s_town` VALUES ('2047', '号头庄回族乡', '130682204000', '130682000000');
INSERT INTO `t_s_town` VALUES ('2048', '杨家庄乡', '130682205000', '130682000000');
INSERT INTO `t_s_town` VALUES ('2049', '大鹿庄乡', '130682206000', '130682000000');
INSERT INTO `t_s_town` VALUES ('2050', '西城乡', '130682208000', '130682000000');
INSERT INTO `t_s_town` VALUES ('2051', '药都街道办事处', '130683001000', '130683000000');
INSERT INTO `t_s_town` VALUES ('2052', '祁州路街道办事处', '130683002000', '130683000000');
INSERT INTO `t_s_town` VALUES ('2053', '伍仁桥镇', '130683101000', '130683000000');
INSERT INTO `t_s_town` VALUES ('2054', '石佛镇', '130683102000', '130683000000');
INSERT INTO `t_s_town` VALUES ('2055', '郑章镇', '130683103000', '130683000000');
INSERT INTO `t_s_town` VALUES ('2056', '大五女镇', '130683104000', '130683000000');
INSERT INTO `t_s_town` VALUES ('2057', '西佛落镇', '130683105000', '130683000000');
INSERT INTO `t_s_town` VALUES ('2058', '西城镇', '130683106000', '130683000000');
INSERT INTO `t_s_town` VALUES ('2059', '明官店乡', '130683200000', '130683000000');
INSERT INTO `t_s_town` VALUES ('2060', '南娄底乡', '130683201000', '130683000000');
INSERT INTO `t_s_town` VALUES ('2061', '北段村乡', '130683204000', '130683000000');
INSERT INTO `t_s_town` VALUES ('2062', '现代中药工业园区', '130683400000', '130683000000');
INSERT INTO `t_s_town` VALUES ('2063', '和平街道办事处', '130684001000', '130684000000');
INSERT INTO `t_s_town` VALUES ('2064', '军城街道办事处', '130684002000', '130684000000');
INSERT INTO `t_s_town` VALUES ('2065', '东盛街道办事处', '130684003000', '130684000000');
INSERT INTO `t_s_town` VALUES ('2066', '北城街道办事处', '130684004000', '130684000000');
INSERT INTO `t_s_town` VALUES ('2067', '兴华路街道办事处', '130684005000', '130684000000');
INSERT INTO `t_s_town` VALUES ('2068', '方官镇', '130684100000', '130684000000');
INSERT INTO `t_s_town` VALUES ('2069', '新城镇', '130684101000', '130684000000');
INSERT INTO `t_s_town` VALUES ('2070', '泗庄镇', '130684102000', '130684000000');
INSERT INTO `t_s_town` VALUES ('2071', '辛立庄镇', '130684104000', '130684000000');
INSERT INTO `t_s_town` VALUES ('2072', '东马营镇', '130684105000', '130684000000');
INSERT INTO `t_s_town` VALUES ('2073', '辛桥镇', '130684106000', '130684000000');
INSERT INTO `t_s_town` VALUES ('2074', '肖官营镇', '130684107000', '130684000000');
INSERT INTO `t_s_town` VALUES ('2075', '张六庄镇', '130684108000', '130684000000');
INSERT INTO `t_s_town` VALUES ('2076', '梁家营乡', '130684201000', '130684000000');
INSERT INTO `t_s_town` VALUES ('2077', '红旗楼街道办事处', '130702001000', '130702000000');
INSERT INTO `t_s_town` VALUES ('2078', '胜利北路街道办事处', '130702002000', '130702000000');
INSERT INTO `t_s_town` VALUES ('2079', '五一路街道办事处', '130702003000', '130702000000');
INSERT INTO `t_s_town` VALUES ('2080', '花园街街道办事处', '130702004000', '130702000000');
INSERT INTO `t_s_town` VALUES ('2081', '工业路街道办事处', '130702005000', '130702000000');
INSERT INTO `t_s_town` VALUES ('2082', '姚家庄镇', '130702101000', '130702000000');
INSERT INTO `t_s_town` VALUES ('2083', '大仓盖镇', '130702102000', '130702000000');
INSERT INTO `t_s_town` VALUES ('2084', '东望山乡', '130702202000', '130702000000');
INSERT INTO `t_s_town` VALUES ('2085', '新华街街道办事处', '130703001000', '130703000000');
INSERT INTO `t_s_town` VALUES ('2086', '大境门街道办事处', '130703002000', '130703000000');
INSERT INTO `t_s_town` VALUES ('2087', '明德北街街道办事处', '130703003000', '130703000000');
INSERT INTO `t_s_town` VALUES ('2088', '明德南街街道办事处', '130703004000', '130703000000');
INSERT INTO `t_s_town` VALUES ('2089', '堡子里街道办事处', '130703005000', '130703000000');
INSERT INTO `t_s_town` VALUES ('2090', '南营坊街道办事处', '130703006000', '130703000000');
INSERT INTO `t_s_town` VALUES ('2091', '工人新村街道办事处', '130703007000', '130703000000');
INSERT INTO `t_s_town` VALUES ('2092', '东窑子镇', '130703100000', '130703000000');
INSERT INTO `t_s_town` VALUES ('2093', '天泰寺街道办事处', '130705001000', '130705000000');
INSERT INTO `t_s_town` VALUES ('2094', '皇城街道办事处', '130705002000', '130705000000');
INSERT INTO `t_s_town` VALUES ('2095', '南关街道办事处', '130705003000', '130705000000');
INSERT INTO `t_s_town` VALUES ('2096', '南大街街道办事处', '130705004000', '130705000000');
INSERT INTO `t_s_town` VALUES ('2097', '大北街街道办事处', '130705005000', '130705000000');
INSERT INTO `t_s_town` VALUES ('2098', '工业街街道办事处', '130705006000', '130705000000');
INSERT INTO `t_s_town` VALUES ('2099', '建国街街道办事处', '130705007000', '130705000000');
INSERT INTO `t_s_town` VALUES ('2100', '庞家堡镇', '130705100000', '130705000000');
INSERT INTO `t_s_town` VALUES ('2101', '深井镇', '130705101000', '130705000000');
INSERT INTO `t_s_town` VALUES ('2102', '崞村镇', '130705102000', '130705000000');
INSERT INTO `t_s_town` VALUES ('2103', '洋河南镇', '130705104000', '130705000000');
INSERT INTO `t_s_town` VALUES ('2104', '贾家营镇', '130705106000', '130705000000');
INSERT INTO `t_s_town` VALUES ('2105', '顾家营镇', '130705107000', '130705000000');
INSERT INTO `t_s_town` VALUES ('2106', '赵川镇', '130705108000', '130705000000');
INSERT INTO `t_s_town` VALUES ('2107', '河子西乡', '130705200000', '130705000000');
INSERT INTO `t_s_town` VALUES ('2108', '春光乡', '130705201000', '130705000000');
INSERT INTO `t_s_town` VALUES ('2109', '侯家庙乡', '130705202000', '130705000000');
INSERT INTO `t_s_town` VALUES ('2110', '李家堡乡', '130705204000', '130705000000');
INSERT INTO `t_s_town` VALUES ('2111', '王家湾乡', '130705205000', '130705000000');
INSERT INTO `t_s_town` VALUES ('2112', '塔儿村乡', '130705206000', '130705000000');
INSERT INTO `t_s_town` VALUES ('2113', '江家屯乡', '130705207000', '130705000000');
INSERT INTO `t_s_town` VALUES ('2114', '城镇街道办事处', '130706001000', '130706000000');
INSERT INTO `t_s_town` VALUES ('2115', '煤矿街道办事处', '130706002000', '130706000000');
INSERT INTO `t_s_town` VALUES ('2116', '花园乡', '130706200000', '130706000000');
INSERT INTO `t_s_town` VALUES ('2117', '辛庄子乡', '130706201000', '130706000000');
INSERT INTO `t_s_town` VALUES ('2118', '定方水乡', '130706202000', '130706000000');
INSERT INTO `t_s_town` VALUES ('2119', '段家堡乡', '130706203000', '130706000000');
INSERT INTO `t_s_town` VALUES ('2120', '孔家庄街道办事处', '130708001000', '130708000000');
INSERT INTO `t_s_town` VALUES ('2121', '孔家庄镇', '130708100000', '130708000000');
INSERT INTO `t_s_town` VALUES ('2122', '万全镇', '130708101000', '130708000000');
INSERT INTO `t_s_town` VALUES ('2123', '洗马林镇', '130708102000', '130708000000');
INSERT INTO `t_s_town` VALUES ('2124', '郭磊庄镇', '130708103000', '130708000000');
INSERT INTO `t_s_town` VALUES ('2125', '膳房堡乡', '130708200000', '130708000000');
INSERT INTO `t_s_town` VALUES ('2126', '北新屯乡', '130708201000', '130708000000');
INSERT INTO `t_s_town` VALUES ('2127', '宣平堡乡', '130708202000', '130708000000');
INSERT INTO `t_s_town` VALUES ('2128', '高庙堡乡', '130708203000', '130708000000');
INSERT INTO `t_s_town` VALUES ('2129', '旧堡乡', '130708204000', '130708000000');
INSERT INTO `t_s_town` VALUES ('2130', '安家堡乡', '130708205000', '130708000000');
INSERT INTO `t_s_town` VALUES ('2131', '北沙城乡', '130708206000', '130708000000');
INSERT INTO `t_s_town` VALUES ('2132', '西湾子街道办', '130709001000', '130709000000');
INSERT INTO `t_s_town` VALUES ('2133', '西湾子镇', '130709100000', '130709000000');
INSERT INTO `t_s_town` VALUES ('2134', '高家营镇', '130709101000', '130709000000');
INSERT INTO `t_s_town` VALUES ('2135', '四台嘴乡', '130709200000', '130709000000');
INSERT INTO `t_s_town` VALUES ('2136', '红旗营乡', '130709201000', '130709000000');
INSERT INTO `t_s_town` VALUES ('2137', '石窑子乡', '130709202000', '130709000000');
INSERT INTO `t_s_town` VALUES ('2138', '驿马图乡', '130709203000', '130709000000');
INSERT INTO `t_s_town` VALUES ('2139', '石嘴子乡', '130709204000', '130709000000');
INSERT INTO `t_s_town` VALUES ('2140', '狮子沟乡', '130709205000', '130709000000');
INSERT INTO `t_s_town` VALUES ('2141', '清三营乡', '130709206000', '130709000000');
INSERT INTO `t_s_town` VALUES ('2142', '白旗乡', '130709207000', '130709000000');
INSERT INTO `t_s_town` VALUES ('2143', '张北镇', '130722100000', '130722000000');
INSERT INTO `t_s_town` VALUES ('2144', '公会镇', '130722101000', '130722000000');
INSERT INTO `t_s_town` VALUES ('2145', '二台镇', '130722102000', '130722000000');
INSERT INTO `t_s_town` VALUES ('2146', '大囫囵镇', '130722103000', '130722000000');
INSERT INTO `t_s_town` VALUES ('2147', '小二台镇', '130722104000', '130722000000');
INSERT INTO `t_s_town` VALUES ('2148', '油篓沟镇', '130722106000', '130722000000');
INSERT INTO `t_s_town` VALUES ('2149', '大河镇', '130722107000', '130722000000');
INSERT INTO `t_s_town` VALUES ('2150', '台路沟乡', '130722200000', '130722000000');
INSERT INTO `t_s_town` VALUES ('2151', '馒头营乡', '130722202000', '130722000000');
INSERT INTO `t_s_town` VALUES ('2152', '二泉井乡', '130722203000', '130722000000');
INSERT INTO `t_s_town` VALUES ('2153', '单晶河乡', '130722204000', '130722000000');
INSERT INTO `t_s_town` VALUES ('2154', '海流图乡', '130722206000', '130722000000');
INSERT INTO `t_s_town` VALUES ('2155', '两面井乡', '130722207000', '130722000000');
INSERT INTO `t_s_town` VALUES ('2156', '大西湾乡', '130722208000', '130722000000');
INSERT INTO `t_s_town` VALUES ('2157', '郝家营乡', '130722209000', '130722000000');
INSERT INTO `t_s_town` VALUES ('2158', '白庙滩乡', '130722210000', '130722000000');
INSERT INTO `t_s_town` VALUES ('2159', '战海乡', '130722212000', '130722000000');
INSERT INTO `t_s_town` VALUES ('2160', '三号乡', '130722213000', '130722000000');
INSERT INTO `t_s_town` VALUES ('2161', '康保镇', '130723100000', '130723000000');
INSERT INTO `t_s_town` VALUES ('2162', '张纪镇', '130723101000', '130723000000');
INSERT INTO `t_s_town` VALUES ('2163', '土城子镇', '130723102000', '130723000000');
INSERT INTO `t_s_town` VALUES ('2164', '邓油坊镇', '130723103000', '130723000000');
INSERT INTO `t_s_town` VALUES ('2165', '李家地镇', '130723104000', '130723000000');
INSERT INTO `t_s_town` VALUES ('2166', '照阳河镇', '130723105000', '130723000000');
INSERT INTO `t_s_town` VALUES ('2167', '屯垦镇', '130723106000', '130723000000');
INSERT INTO `t_s_town` VALUES ('2168', '闫油坊乡', '130723200000', '130723000000');
INSERT INTO `t_s_town` VALUES ('2169', '丹清河乡', '130723201000', '130723000000');
INSERT INTO `t_s_town` VALUES ('2170', '哈咇嘎乡', '130723202000', '130723000000');
INSERT INTO `t_s_town` VALUES ('2171', '二号卜乡', '130723203000', '130723000000');
INSERT INTO `t_s_town` VALUES ('2172', '芦家营乡', '130723204000', '130723000000');
INSERT INTO `t_s_town` VALUES ('2173', '忠义乡', '130723205000', '130723000000');
INSERT INTO `t_s_town` VALUES ('2174', '处长地乡', '130723206000', '130723000000');
INSERT INTO `t_s_town` VALUES ('2175', '满德堂乡', '130723207000', '130723000000');
INSERT INTO `t_s_town` VALUES ('2176', '康保牧场', '130723500000', '130723000000');
INSERT INTO `t_s_town` VALUES ('2177', '屯垦林场', '130723501000', '130723000000');
INSERT INTO `t_s_town` VALUES ('2178', '平定堡镇', '130724100000', '130724000000');
INSERT INTO `t_s_town` VALUES ('2179', '小厂镇', '130724101000', '130724000000');
INSERT INTO `t_s_town` VALUES ('2180', '黄盖淖镇', '130724102000', '130724000000');
INSERT INTO `t_s_town` VALUES ('2181', '九连城镇', '130724103000', '130724000000');
INSERT INTO `t_s_town` VALUES ('2182', '高山堡乡', '130724200000', '130724000000');
INSERT INTO `t_s_town` VALUES ('2183', '小河子乡', '130724201000', '130724000000');
INSERT INTO `t_s_town` VALUES ('2184', '二道渠乡', '130724202000', '130724000000');
INSERT INTO `t_s_town` VALUES ('2185', '大二号回族乡', '130724203000', '130724000000');
INSERT INTO `t_s_town` VALUES ('2186', '闪电河乡', '130724204000', '130724000000');
INSERT INTO `t_s_town` VALUES ('2187', '长梁乡', '130724205000', '130724000000');
INSERT INTO `t_s_town` VALUES ('2188', '丰源店乡', '130724206000', '130724000000');
INSERT INTO `t_s_town` VALUES ('2189', '西辛营乡', '130724207000', '130724000000');
INSERT INTO `t_s_town` VALUES ('2190', '莲花滩乡', '130724208000', '130724000000');
INSERT INTO `t_s_town` VALUES ('2191', '白土窑乡', '130724209000', '130724000000');
INSERT INTO `t_s_town` VALUES ('2192', '南壕堑镇', '130725100000', '130725000000');
INSERT INTO `t_s_town` VALUES ('2193', '大青沟镇', '130725101000', '130725000000');
INSERT INTO `t_s_town` VALUES ('2194', '八道沟镇', '130725102000', '130725000000');
INSERT INTO `t_s_town` VALUES ('2195', '红土梁镇', '130725103000', '130725000000');
INSERT INTO `t_s_town` VALUES ('2196', '小蒜沟镇', '130725104000', '130725000000');
INSERT INTO `t_s_town` VALUES ('2197', '三工地镇', '130725105000', '130725000000');
INSERT INTO `t_s_town` VALUES ('2198', '满井镇', '130725106000', '130725000000');
INSERT INTO `t_s_town` VALUES ('2199', '大营盘乡', '130725200000', '130725000000');
INSERT INTO `t_s_town` VALUES ('2200', '大苏计乡', '130725201000', '130725000000');
INSERT INTO `t_s_town` VALUES ('2201', '石井乡', '130725202000', '130725000000');
INSERT INTO `t_s_town` VALUES ('2202', '七甲乡', '130725205000', '130725000000');
INSERT INTO `t_s_town` VALUES ('2203', '套里庄乡', '130725206000', '130725000000');
INSERT INTO `t_s_town` VALUES ('2204', '甲石河乡', '130725207000', '130725000000');
INSERT INTO `t_s_town` VALUES ('2205', '下马圈乡', '130725208000', '130725000000');
INSERT INTO `t_s_town` VALUES ('2206', '蔚州镇', '130726100000', '130726000000');
INSERT INTO `t_s_town` VALUES ('2207', '代王城镇', '130726101000', '130726000000');
INSERT INTO `t_s_town` VALUES ('2208', '西合营镇', '130726102000', '130726000000');
INSERT INTO `t_s_town` VALUES ('2209', '吉家庄镇', '130726103000', '130726000000');
INSERT INTO `t_s_town` VALUES ('2210', '白乐镇', '130726104000', '130726000000');
INSERT INTO `t_s_town` VALUES ('2211', '暖泉镇', '130726105000', '130726000000');
INSERT INTO `t_s_town` VALUES ('2212', '南留庄镇', '130726106000', '130726000000');
INSERT INTO `t_s_town` VALUES ('2213', '北水泉镇', '130726107000', '130726000000');
INSERT INTO `t_s_town` VALUES ('2214', '桃花镇', '130726108000', '130726000000');
INSERT INTO `t_s_town` VALUES ('2215', '阳眷镇', '130726109000', '130726000000');
INSERT INTO `t_s_town` VALUES ('2216', '宋家庄镇', '130726110000', '130726000000');
INSERT INTO `t_s_town` VALUES ('2217', '下宫村乡', '130726200000', '130726000000');
INSERT INTO `t_s_town` VALUES ('2218', '南杨庄乡', '130726202000', '130726000000');
INSERT INTO `t_s_town` VALUES ('2219', '柏树乡', '130726203000', '130726000000');
INSERT INTO `t_s_town` VALUES ('2220', '常宁乡', '130726204000', '130726000000');
INSERT INTO `t_s_town` VALUES ('2221', '涌泉庄乡', '130726205000', '130726000000');
INSERT INTO `t_s_town` VALUES ('2222', '杨庄窠乡', '130726206000', '130726000000');
INSERT INTO `t_s_town` VALUES ('2223', '南岭庄乡', '130726207000', '130726000000');
INSERT INTO `t_s_town` VALUES ('2224', '陈家洼乡', '130726208000', '130726000000');
INSERT INTO `t_s_town` VALUES ('2225', '黄梅乡', '130726209000', '130726000000');
INSERT INTO `t_s_town` VALUES ('2226', '白草村乡', '130726210000', '130726000000');
INSERT INTO `t_s_town` VALUES ('2227', '草沟堡乡', '130726211000', '130726000000');
INSERT INTO `t_s_town` VALUES ('2228', '西城镇', '130727100000', '130727000000');
INSERT INTO `t_s_town` VALUES ('2229', '东城镇', '130727101000', '130727000000');
INSERT INTO `t_s_town` VALUES ('2230', '化稍营镇', '130727102000', '130727000000');
INSERT INTO `t_s_town` VALUES ('2231', '揣骨疃镇', '130727103000', '130727000000');
INSERT INTO `t_s_town` VALUES ('2232', '东井集镇', '130727104000', '130727000000');
INSERT INTO `t_s_town` VALUES ('2233', '要家庄乡', '130727200000', '130727000000');
INSERT INTO `t_s_town` VALUES ('2234', '东坊城堡乡', '130727201000', '130727000000');
INSERT INTO `t_s_town` VALUES ('2235', '井儿沟乡', '130727202000', '130727000000');
INSERT INTO `t_s_town` VALUES ('2236', '三马坊乡', '130727203000', '130727000000');
INSERT INTO `t_s_town` VALUES ('2237', '高墙乡', '130727204000', '130727000000');
INSERT INTO `t_s_town` VALUES ('2238', '大田洼乡', '130727205000', '130727000000');
INSERT INTO `t_s_town` VALUES ('2239', '辛堡乡', '130727206000', '130727000000');
INSERT INTO `t_s_town` VALUES ('2240', '马圈堡乡', '130727207000', '130727000000');
INSERT INTO `t_s_town` VALUES ('2241', '浮图讲乡', '130727208000', '130727000000');
INSERT INTO `t_s_town` VALUES ('2242', '柴沟堡镇', '130728100000', '130728000000');
INSERT INTO `t_s_town` VALUES ('2243', '左卫镇', '130728101000', '130728000000');
INSERT INTO `t_s_town` VALUES ('2244', '头百户镇', '130728102000', '130728000000');
INSERT INTO `t_s_town` VALUES ('2245', '怀安城镇', '130728103000', '130728000000');
INSERT INTO `t_s_town` VALUES ('2246', '渡口堡乡', '130728200000', '130728000000');
INSERT INTO `t_s_town` VALUES ('2247', '第六屯乡', '130728201000', '130728000000');
INSERT INTO `t_s_town` VALUES ('2248', '西湾堡乡', '130728202000', '130728000000');
INSERT INTO `t_s_town` VALUES ('2249', '西沙城乡', '130728203000', '130728000000');
INSERT INTO `t_s_town` VALUES ('2250', '太平庄乡', '130728204000', '130728000000');
INSERT INTO `t_s_town` VALUES ('2251', '王虎屯乡', '130728205000', '130728000000');
INSERT INTO `t_s_town` VALUES ('2252', '第三堡乡', '130728206000', '130728000000');
INSERT INTO `t_s_town` VALUES ('2253', '沙城镇', '130730100000', '130730000000');
INSERT INTO `t_s_town` VALUES ('2254', '北辛堡镇', '130730101000', '130730000000');
INSERT INTO `t_s_town` VALUES ('2255', '新保安镇', '130730102000', '130730000000');
INSERT INTO `t_s_town` VALUES ('2256', '东花园镇', '130730103000', '130730000000');
INSERT INTO `t_s_town` VALUES ('2257', '官厅镇', '130730104000', '130730000000');
INSERT INTO `t_s_town` VALUES ('2258', '桑园镇', '130730105000', '130730000000');
INSERT INTO `t_s_town` VALUES ('2259', '存瑞镇', '130730106000', '130730000000');
INSERT INTO `t_s_town` VALUES ('2260', '土木镇', '130730107000', '130730000000');
INSERT INTO `t_s_town` VALUES ('2261', '大黄庄镇', '130730108000', '130730000000');
INSERT INTO `t_s_town` VALUES ('2262', '西八里镇', '130730109000', '130730000000');
INSERT INTO `t_s_town` VALUES ('2263', '小南辛堡镇', '130730110000', '130730000000');
INSERT INTO `t_s_town` VALUES ('2264', '狼山乡', '130730200000', '130730000000');
INSERT INTO `t_s_town` VALUES ('2265', '鸡鸣驿乡', '130730203000', '130730000000');
INSERT INTO `t_s_town` VALUES ('2266', '东八里乡', '130730205000', '130730000000');
INSERT INTO `t_s_town` VALUES ('2267', '瑞云观乡', '130730207000', '130730000000');
INSERT INTO `t_s_town` VALUES ('2268', '孙庄子乡', '130730208000', '130730000000');
INSERT INTO `t_s_town` VALUES ('2269', '王家楼回族乡', '130730210000', '130730000000');
INSERT INTO `t_s_town` VALUES ('2270', '涿鹿镇', '130731100000', '130731000000');
INSERT INTO `t_s_town` VALUES ('2271', '张家堡镇', '130731101000', '130731000000');
INSERT INTO `t_s_town` VALUES ('2272', '武家沟镇', '130731102000', '130731000000');
INSERT INTO `t_s_town` VALUES ('2273', '五堡镇', '130731103000', '130731000000');
INSERT INTO `t_s_town` VALUES ('2274', '保岱镇', '130731104000', '130731000000');
INSERT INTO `t_s_town` VALUES ('2275', '矾山镇', '130731105000', '130731000000');
INSERT INTO `t_s_town` VALUES ('2276', '大堡镇', '130731106000', '130731000000');
INSERT INTO `t_s_town` VALUES ('2277', '河东镇', '130731107000', '130731000000');
INSERT INTO `t_s_town` VALUES ('2278', '东小庄镇', '130731108000', '130731000000');
INSERT INTO `t_s_town` VALUES ('2279', '辉耀镇', '130731109000', '130731000000');
INSERT INTO `t_s_town` VALUES ('2280', '大河南镇', '130731110000', '130731000000');
INSERT INTO `t_s_town` VALUES ('2281', '温泉屯镇', '130731111000', '130731000000');
INSERT INTO `t_s_town` VALUES ('2282', '蟒石口镇', '130731112000', '130731000000');
INSERT INTO `t_s_town` VALUES ('2283', '栾庄乡', '130731201000', '130731000000');
INSERT INTO `t_s_town` VALUES ('2284', '黑山寺乡', '130731204000', '130731000000');
INSERT INTO `t_s_town` VALUES ('2285', '卧佛寺乡', '130731205000', '130731000000');
INSERT INTO `t_s_town` VALUES ('2286', '谢家堡乡', '130731206000', '130731000000');
INSERT INTO `t_s_town` VALUES ('2287', '赤城镇', '130732100000', '130732000000');
INSERT INTO `t_s_town` VALUES ('2288', '田家窑镇', '130732101000', '130732000000');
INSERT INTO `t_s_town` VALUES ('2289', '龙关镇', '130732102000', '130732000000');
INSERT INTO `t_s_town` VALUES ('2290', '雕鹗镇', '130732103000', '130732000000');
INSERT INTO `t_s_town` VALUES ('2291', '独石口镇', '130732104000', '130732000000');
INSERT INTO `t_s_town` VALUES ('2292', '白草镇', '130732105000', '130732000000');
INSERT INTO `t_s_town` VALUES ('2293', '龙门所镇', '130732106000', '130732000000');
INSERT INTO `t_s_town` VALUES ('2294', '后城镇', '130732107000', '130732000000');
INSERT INTO `t_s_town` VALUES ('2295', '东卯镇', '130732108000', '130732000000');
INSERT INTO `t_s_town` VALUES ('2296', '炮梁乡', '130732200000', '130732000000');
INSERT INTO `t_s_town` VALUES ('2297', '大海陀乡', '130732201000', '130732000000');
INSERT INTO `t_s_town` VALUES ('2298', '镇宁堡乡', '130732202000', '130732000000');
INSERT INTO `t_s_town` VALUES ('2299', '马营乡', '130732203000', '130732000000');
INSERT INTO `t_s_town` VALUES ('2300', '云州乡', '130732204000', '130732000000');
INSERT INTO `t_s_town` VALUES ('2301', '三道川乡', '130732205000', '130732000000');
INSERT INTO `t_s_town` VALUES ('2302', '东万口乡', '130732206000', '130732000000');
INSERT INTO `t_s_town` VALUES ('2303', '茨营子乡', '130732207000', '130732000000');
INSERT INTO `t_s_town` VALUES ('2304', '样田乡', '130732208000', '130732000000');
INSERT INTO `t_s_town` VALUES ('2305', '南站街道办事处', '130771001000', '130771000000');
INSERT INTO `t_s_town` VALUES ('2306', '马路东街道办事处', '130771002000', '130771000000');
INSERT INTO `t_s_town` VALUES ('2307', '老鸦庄镇', '130771100000', '130771000000');
INSERT INTO `t_s_town` VALUES ('2308', '沈家屯镇', '130771101000', '130771000000');
INSERT INTO `t_s_town` VALUES ('2309', '姚家房镇', '130771102000', '130771000000');
INSERT INTO `t_s_town` VALUES ('2310', '沙岭子镇', '130771103000', '130771000000');
INSERT INTO `t_s_town` VALUES ('2311', '沙沟镇', '130772105000', '130772000000');
INSERT INTO `t_s_town` VALUES ('2312', '宇宙营乡', '130772215000', '130772000000');
INSERT INTO `t_s_town` VALUES ('2313', '察北管理区黄山管理处', '130772401000', '130772000000');
INSERT INTO `t_s_town` VALUES ('2314', '察北管理区石门管理处', '130772402000', '130772000000');
INSERT INTO `t_s_town` VALUES ('2315', '察北管理区乌兰管理处', '130772403000', '130772000000');
INSERT INTO `t_s_town` VALUES ('2316', '察北管理区金沙管理处', '130772404000', '130772000000');
INSERT INTO `t_s_town` VALUES ('2317', '察北管理区白塔管理处', '130772405000', '130772000000');
INSERT INTO `t_s_town` VALUES ('2318', '榆树沟管理处', '130773501000', '130773000000');
INSERT INTO `t_s_town` VALUES ('2319', '沙梁子管理处', '130773502000', '130773000000');
INSERT INTO `t_s_town` VALUES ('2320', '小城子管理处', '130773503000', '130773000000');
INSERT INTO `t_s_town` VALUES ('2321', '东大门管理处', '130773504000', '130773000000');
INSERT INTO `t_s_town` VALUES ('2322', '西大街街道', '130802001000', '130802000000');
INSERT INTO `t_s_town` VALUES ('2323', '头道牌楼街道', '130802002000', '130802000000');
INSERT INTO `t_s_town` VALUES ('2324', '潘家沟街道', '130802003000', '130802000000');
INSERT INTO `t_s_town` VALUES ('2325', '中华路街道', '130802004000', '130802000000');
INSERT INTO `t_s_town` VALUES ('2326', '新华路街道', '130802005000', '130802000000');
INSERT INTO `t_s_town` VALUES ('2327', '石洞子沟街道', '130802006000', '130802000000');
INSERT INTO `t_s_town` VALUES ('2328', '桥东街道', '130802007000', '130802000000');
INSERT INTO `t_s_town` VALUES ('2329', '水泉沟镇', '130802100000', '130802000000');
INSERT INTO `t_s_town` VALUES ('2330', '狮子沟镇', '130802101000', '130802000000');
INSERT INTO `t_s_town` VALUES ('2331', '牛圈子沟镇', '130802102000', '130802000000');
INSERT INTO `t_s_town` VALUES ('2332', '大石庙镇', '130802103000', '130802000000');
INSERT INTO `t_s_town` VALUES ('2333', '双峰寺镇', '130802105000', '130802000000');
INSERT INTO `t_s_town` VALUES ('2334', '元宝山街道', '130803001000', '130803000000');
INSERT INTO `t_s_town` VALUES ('2335', '钢城街道', '130803002000', '130803000000');
INSERT INTO `t_s_town` VALUES ('2336', '秀水街道', '130803003000', '130803000000');
INSERT INTO `t_s_town` VALUES ('2337', '双塔山镇', '130803100000', '130803000000');
INSERT INTO `t_s_town` VALUES ('2338', '滦河镇', '130803101000', '130803000000');
INSERT INTO `t_s_town` VALUES ('2339', '大庙镇', '130803102000', '130803000000');
INSERT INTO `t_s_town` VALUES ('2340', '偏桥子镇', '130803103000', '130803000000');
INSERT INTO `t_s_town` VALUES ('2341', '西地镇', '130803104000', '130803000000');
INSERT INTO `t_s_town` VALUES ('2342', '陈栅子乡', '130803200000', '130803000000');
INSERT INTO `t_s_town` VALUES ('2343', '鹰手营子矿区铁北路街道办事处', '130804001000', '130804000000');
INSERT INTO `t_s_town` VALUES ('2344', '鹰手营子镇', '130804100000', '130804000000');
INSERT INTO `t_s_town` VALUES ('2345', '北马圈子镇', '130804101000', '130804000000');
INSERT INTO `t_s_town` VALUES ('2346', '寿王坟镇', '130804102000', '130804000000');
INSERT INTO `t_s_town` VALUES ('2347', '汪家庄镇', '130804103000', '130804000000');
INSERT INTO `t_s_town` VALUES ('2348', '下板城镇', '130821100000', '130821000000');
INSERT INTO `t_s_town` VALUES ('2349', '甲山镇', '130821102000', '130821000000');
INSERT INTO `t_s_town` VALUES ('2350', '六沟镇', '130821103000', '130821000000');
INSERT INTO `t_s_town` VALUES ('2351', '三沟镇', '130821104000', '130821000000');
INSERT INTO `t_s_town` VALUES ('2352', '头沟镇', '130821105000', '130821000000');
INSERT INTO `t_s_town` VALUES ('2353', '高寺台镇', '130821106000', '130821000000');
INSERT INTO `t_s_town` VALUES ('2354', '鞍匠镇', '130821107000', '130821000000');
INSERT INTO `t_s_town` VALUES ('2355', '三家镇', '130821108000', '130821000000');
INSERT INTO `t_s_town` VALUES ('2356', '磴上镇', '130821109000', '130821000000');
INSERT INTO `t_s_town` VALUES ('2357', '上谷镇', '130821110000', '130821000000');
INSERT INTO `t_s_town` VALUES ('2358', '新杖子镇', '130821111000', '130821000000');
INSERT INTO `t_s_town` VALUES ('2359', '石灰窑镇', '130821112000', '130821000000');
INSERT INTO `t_s_town` VALUES ('2360', '东小白旗乡', '130821200000', '130821000000');
INSERT INTO `t_s_town` VALUES ('2361', '刘杖子乡', '130821202000', '130821000000');
INSERT INTO `t_s_town` VALUES ('2362', '孟家院乡', '130821204000', '130821000000');
INSERT INTO `t_s_town` VALUES ('2363', '大营子乡', '130821205000', '130821000000');
INSERT INTO `t_s_town` VALUES ('2364', '八家乡', '130821206000', '130821000000');
INSERT INTO `t_s_town` VALUES ('2365', '满杖子乡', '130821208000', '130821000000');
INSERT INTO `t_s_town` VALUES ('2366', '五道河乡', '130821210000', '130821000000');
INSERT INTO `t_s_town` VALUES ('2367', '岔沟乡', '130821211000', '130821000000');
INSERT INTO `t_s_town` VALUES ('2368', '岗子满族乡', '130821212000', '130821000000');
INSERT INTO `t_s_town` VALUES ('2369', '两家满族乡', '130821214000', '130821000000');
INSERT INTO `t_s_town` VALUES ('2370', '仓子乡', '130821216000', '130821000000');
INSERT INTO `t_s_town` VALUES ('2371', '兴隆镇', '130822100000', '130822000000');
INSERT INTO `t_s_town` VALUES ('2372', '半壁山镇', '130822101000', '130822000000');
INSERT INTO `t_s_town` VALUES ('2373', '挂兰峪镇', '130822102000', '130822000000');
INSERT INTO `t_s_town` VALUES ('2374', '青松岭镇', '130822103000', '130822000000');
INSERT INTO `t_s_town` VALUES ('2375', '六道河镇', '130822104000', '130822000000');
INSERT INTO `t_s_town` VALUES ('2376', '平安堡镇', '130822105000', '130822000000');
INSERT INTO `t_s_town` VALUES ('2377', '北营房镇', '130822106000', '130822000000');
INSERT INTO `t_s_town` VALUES ('2378', '孤山子镇', '130822107000', '130822000000');
INSERT INTO `t_s_town` VALUES ('2379', '蓝旗营镇', '130822108000', '130822000000');
INSERT INTO `t_s_town` VALUES ('2380', '雾灵山镇', '130822109000', '130822000000');
INSERT INTO `t_s_town` VALUES ('2381', '李家营镇', '130822110000', '130822000000');
INSERT INTO `t_s_town` VALUES ('2382', '大杖子镇', '130822111000', '130822000000');
INSERT INTO `t_s_town` VALUES ('2383', '三道河镇', '130822112000', '130822000000');
INSERT INTO `t_s_town` VALUES ('2384', '蘑菇峪镇', '130822113000', '130822000000');
INSERT INTO `t_s_town` VALUES ('2385', '大水泉镇', '130822114000', '130822000000');
INSERT INTO `t_s_town` VALUES ('2386', '南天门满族乡', '130822200000', '130822000000');
INSERT INTO `t_s_town` VALUES ('2387', '八卦岭满族乡', '130822202000', '130822000000');
INSERT INTO `t_s_town` VALUES ('2388', '陡子峪乡', '130822203000', '130822000000');
INSERT INTO `t_s_town` VALUES ('2389', '上石洞乡', '130822204000', '130822000000');
INSERT INTO `t_s_town` VALUES ('2390', '安子岭乡', '130822211000', '130822000000');
INSERT INTO `t_s_town` VALUES ('2391', '中兴路街道办事处', '130824001000', '130824000000');
INSERT INTO `t_s_town` VALUES ('2392', '滦平镇', '130824100000', '130824000000');
INSERT INTO `t_s_town` VALUES ('2393', '长山峪镇', '130824101000', '130824000000');
INSERT INTO `t_s_town` VALUES ('2394', '红旗镇', '130824102000', '130824000000');
INSERT INTO `t_s_town` VALUES ('2395', '金沟屯镇', '130824103000', '130824000000');
INSERT INTO `t_s_town` VALUES ('2396', '虎什哈镇', '130824104000', '130824000000');
INSERT INTO `t_s_town` VALUES ('2397', '巴克什营镇', '130824105000', '130824000000');
INSERT INTO `t_s_town` VALUES ('2398', '张百湾镇', '130824106000', '130824000000');
INSERT INTO `t_s_town` VALUES ('2399', '付营子镇', '130824107000', '130824000000');
INSERT INTO `t_s_town` VALUES ('2400', '大屯镇', '130824108000', '130824000000');
INSERT INTO `t_s_town` VALUES ('2401', '火斗山镇', '130824109000', '130824000000');
INSERT INTO `t_s_town` VALUES ('2402', '平坊满族乡', '130824200000', '130824000000');
INSERT INTO `t_s_town` VALUES ('2403', '安纯沟门满族乡', '130824201000', '130824000000');
INSERT INTO `t_s_town` VALUES ('2404', '小营满族乡', '130824205000', '130824000000');
INSERT INTO `t_s_town` VALUES ('2405', '西沟满族乡', '130824206000', '130824000000');
INSERT INTO `t_s_town` VALUES ('2406', '邓厂满族乡', '130824207000', '130824000000');
INSERT INTO `t_s_town` VALUES ('2407', '五道营子满族乡', '130824208000', '130824000000');
INSERT INTO `t_s_town` VALUES ('2408', '马营子满族乡', '130824209000', '130824000000');
INSERT INTO `t_s_town` VALUES ('2409', '付家店满族乡', '130824210000', '130824000000');
INSERT INTO `t_s_town` VALUES ('2410', '两间房乡', '130824212000', '130824000000');
INSERT INTO `t_s_town` VALUES ('2411', '涝洼乡', '130824213000', '130824000000');
INSERT INTO `t_s_town` VALUES ('2412', '安州街道办事处', '130825001000', '130825000000');
INSERT INTO `t_s_town` VALUES ('2413', '隆化镇', '130825100000', '130825000000');
INSERT INTO `t_s_town` VALUES ('2414', '韩麻营镇', '130825101000', '130825000000');
INSERT INTO `t_s_town` VALUES ('2415', '中关镇', '130825102000', '130825000000');
INSERT INTO `t_s_town` VALUES ('2416', '七家镇', '130825103000', '130825000000');
INSERT INTO `t_s_town` VALUES ('2417', '汤头沟镇', '130825104000', '130825000000');
INSERT INTO `t_s_town` VALUES ('2418', '张三营镇', '130825105000', '130825000000');
INSERT INTO `t_s_town` VALUES ('2419', '唐三营镇', '130825106000', '130825000000');
INSERT INTO `t_s_town` VALUES ('2420', '蓝旗镇', '130825107000', '130825000000');
INSERT INTO `t_s_town` VALUES ('2421', '步古沟镇', '130825108000', '130825000000');
INSERT INTO `t_s_town` VALUES ('2422', '郭家屯镇', '130825109000', '130825000000');
INSERT INTO `t_s_town` VALUES ('2423', '荒地乡', '130825200000', '130825000000');
INSERT INTO `t_s_town` VALUES ('2424', '章吉营乡', '130825201000', '130825000000');
INSERT INTO `t_s_town` VALUES ('2425', '茅荆坝乡', '130825202000', '130825000000');
INSERT INTO `t_s_town` VALUES ('2426', '尹家营满族乡', '130825203000', '130825000000');
INSERT INTO `t_s_town` VALUES ('2427', '庙子沟蒙古族满族乡', '130825204000', '130825000000');
INSERT INTO `t_s_town` VALUES ('2428', '偏坡营满族乡', '130825205000', '130825000000');
INSERT INTO `t_s_town` VALUES ('2429', '山湾乡', '130825206000', '130825000000');
INSERT INTO `t_s_town` VALUES ('2430', '八达营蒙古族乡', '130825207000', '130825000000');
INSERT INTO `t_s_town` VALUES ('2431', '太平庄满族乡', '130825208000', '130825000000');
INSERT INTO `t_s_town` VALUES ('2432', '旧屯满族乡', '130825209000', '130825000000');
INSERT INTO `t_s_town` VALUES ('2433', '西阿超满族蒙古族乡', '130825210000', '130825000000');
INSERT INTO `t_s_town` VALUES ('2434', '白虎沟满族蒙古族乡', '130825211000', '130825000000');
INSERT INTO `t_s_town` VALUES ('2435', '碱房乡', '130825212000', '130825000000');
INSERT INTO `t_s_town` VALUES ('2436', '韩家店乡', '130825213000', '130825000000');
INSERT INTO `t_s_town` VALUES ('2437', '湾沟门乡', '130825214000', '130825000000');
INSERT INTO `t_s_town` VALUES ('2438', '大阁镇', '130826100000', '130826000000');
INSERT INTO `t_s_town` VALUES ('2439', '大滩镇', '130826101000', '130826000000');
INSERT INTO `t_s_town` VALUES ('2440', '鱼儿山镇', '130826102000', '130826000000');
INSERT INTO `t_s_town` VALUES ('2441', '土城镇', '130826103000', '130826000000');
INSERT INTO `t_s_town` VALUES ('2442', '黄旗镇', '130826104000', '130826000000');
INSERT INTO `t_s_town` VALUES ('2443', '凤山镇', '130826105000', '130826000000');
INSERT INTO `t_s_town` VALUES ('2444', '波罗诺镇', '130826106000', '130826000000');
INSERT INTO `t_s_town` VALUES ('2445', '黑山咀镇', '130826107000', '130826000000');
INSERT INTO `t_s_town` VALUES ('2446', '天桥镇', '130826108000', '130826000000');
INSERT INTO `t_s_town` VALUES ('2447', '胡麻营镇', '130826109000', '130826000000');
INSERT INTO `t_s_town` VALUES ('2448', '万胜永乡', '130826200000', '130826000000');
INSERT INTO `t_s_town` VALUES ('2449', '四岔口乡', '130826201000', '130826000000');
INSERT INTO `t_s_town` VALUES ('2450', '苏家店乡', '130826202000', '130826000000');
INSERT INTO `t_s_town` VALUES ('2451', '外沟门乡', '130826203000', '130826000000');
INSERT INTO `t_s_town` VALUES ('2452', '草原乡', '130826204000', '130826000000');
INSERT INTO `t_s_town` VALUES ('2453', '窟窿山乡', '130826205000', '130826000000');
INSERT INTO `t_s_town` VALUES ('2454', '小坝子乡', '130826206000', '130826000000');
INSERT INTO `t_s_town` VALUES ('2455', '五道营乡', '130826207000', '130826000000');
INSERT INTO `t_s_town` VALUES ('2456', '南关蒙古族乡', '130826208000', '130826000000');
INSERT INTO `t_s_town` VALUES ('2457', '选将营乡', '130826209000', '130826000000');
INSERT INTO `t_s_town` VALUES ('2458', '西官营乡', '130826210000', '130826000000');
INSERT INTO `t_s_town` VALUES ('2459', '王营乡', '130826211000', '130826000000');
INSERT INTO `t_s_town` VALUES ('2460', '北头营乡', '130826212000', '130826000000');
INSERT INTO `t_s_town` VALUES ('2461', '石人沟乡', '130826214000', '130826000000');
INSERT INTO `t_s_town` VALUES ('2462', '汤河乡', '130826215000', '130826000000');
INSERT INTO `t_s_town` VALUES ('2463', '杨木栅子乡', '130826216000', '130826000000');
INSERT INTO `t_s_town` VALUES ('2464', '宽城镇', '130827100000', '130827000000');
INSERT INTO `t_s_town` VALUES ('2465', '龙须门镇', '130827101000', '130827000000');
INSERT INTO `t_s_town` VALUES ('2466', '峪耳崖镇', '130827102000', '130827000000');
INSERT INTO `t_s_town` VALUES ('2467', '板城镇', '130827103000', '130827000000');
INSERT INTO `t_s_town` VALUES ('2468', '汤道河镇', '130827104000', '130827000000');
INSERT INTO `t_s_town` VALUES ('2469', '饽罗台镇', '130827105000', '130827000000');
INSERT INTO `t_s_town` VALUES ('2470', '碾子峪镇', '130827106000', '130827000000');
INSERT INTO `t_s_town` VALUES ('2471', '亮甲台镇', '130827107000', '130827000000');
INSERT INTO `t_s_town` VALUES ('2472', '化皮溜子镇', '130827108000', '130827000000');
INSERT INTO `t_s_town` VALUES ('2473', '松岭镇', '130827109000', '130827000000');
INSERT INTO `t_s_town` VALUES ('2474', '塌山乡', '130827201000', '130827000000');
INSERT INTO `t_s_town` VALUES ('2475', '孟子岭乡', '130827203000', '130827000000');
INSERT INTO `t_s_town` VALUES ('2476', '独石沟乡', '130827204000', '130827000000');
INSERT INTO `t_s_town` VALUES ('2477', '铧尖乡', '130827207000', '130827000000');
INSERT INTO `t_s_town` VALUES ('2478', '东黄花川乡', '130827208000', '130827000000');
INSERT INTO `t_s_town` VALUES ('2479', '苇子沟乡', '130827210000', '130827000000');
INSERT INTO `t_s_town` VALUES ('2480', '大字沟门乡', '130827211000', '130827000000');
INSERT INTO `t_s_town` VALUES ('2481', '大石柱子乡', '130827212000', '130827000000');
INSERT INTO `t_s_town` VALUES ('2482', '围场镇', '130828100000', '130828000000');
INSERT INTO `t_s_town` VALUES ('2483', '四合永镇', '130828101000', '130828000000');
INSERT INTO `t_s_town` VALUES ('2484', '克勒沟镇', '130828102000', '130828000000');
INSERT INTO `t_s_town` VALUES ('2485', '棋盘山镇', '130828103000', '130828000000');
INSERT INTO `t_s_town` VALUES ('2486', '半截塔镇', '130828104000', '130828000000');
INSERT INTO `t_s_town` VALUES ('2487', '朝阳地镇', '130828105000', '130828000000');
INSERT INTO `t_s_town` VALUES ('2488', '朝阳湾镇', '130828106000', '130828000000');
INSERT INTO `t_s_town` VALUES ('2489', '腰站镇', '130828107000', '130828000000');
INSERT INTO `t_s_town` VALUES ('2490', '龙头山镇', '130828108000', '130828000000');
INSERT INTO `t_s_town` VALUES ('2491', '新拨镇', '130828109000', '130828000000');
INSERT INTO `t_s_town` VALUES ('2492', '御道口镇', '130828110000', '130828000000');
INSERT INTO `t_s_town` VALUES ('2493', '城子镇', '130828111000', '130828000000');
INSERT INTO `t_s_town` VALUES ('2494', '道坝子乡', '130828200000', '130828000000');
INSERT INTO `t_s_town` VALUES ('2495', '黄土坎乡', '130828203000', '130828000000');
INSERT INTO `t_s_town` VALUES ('2496', '四道沟乡', '130828204000', '130828000000');
INSERT INTO `t_s_town` VALUES ('2497', '兰旗卡伦乡', '130828205000', '130828000000');
INSERT INTO `t_s_town` VALUES ('2498', '银窝沟乡', '130828206000', '130828000000');
INSERT INTO `t_s_town` VALUES ('2499', '新地乡', '130828207000', '130828000000');
INSERT INTO `t_s_town` VALUES ('2500', '广发永乡', '130828208000', '130828000000');
INSERT INTO `t_s_town` VALUES ('2501', '育太和乡', '130828209000', '130828000000');
INSERT INTO `t_s_town` VALUES ('2502', '郭家湾乡', '130828210000', '130828000000');
INSERT INTO `t_s_town` VALUES ('2503', '杨家湾乡', '130828211000', '130828000000');
INSERT INTO `t_s_town` VALUES ('2504', '大唤起乡', '130828212000', '130828000000');
INSERT INTO `t_s_town` VALUES ('2505', '哈里哈乡', '130828213000', '130828000000');
INSERT INTO `t_s_town` VALUES ('2506', '张家湾乡', '130828215000', '130828000000');
INSERT INTO `t_s_town` VALUES ('2507', '宝元栈乡', '130828216000', '130828000000');
INSERT INTO `t_s_town` VALUES ('2508', '山湾子乡', '130828217000', '130828000000');
INSERT INTO `t_s_town` VALUES ('2509', '三义永乡', '130828218000', '130828000000');
INSERT INTO `t_s_town` VALUES ('2510', '姜家店乡', '130828219000', '130828000000');
INSERT INTO `t_s_town` VALUES ('2511', '下伙房乡', '130828220000', '130828000000');
INSERT INTO `t_s_town` VALUES ('2512', '燕格柏乡', '130828221000', '130828000000');
INSERT INTO `t_s_town` VALUES ('2513', '牌楼乡', '130828222000', '130828000000');
INSERT INTO `t_s_town` VALUES ('2514', '老窝铺乡', '130828224000', '130828000000');
INSERT INTO `t_s_town` VALUES ('2515', '石桌子乡', '130828226000', '130828000000');
INSERT INTO `t_s_town` VALUES ('2516', '大头山乡', '130828227000', '130828000000');
INSERT INTO `t_s_town` VALUES ('2517', '南山嘴乡', '130828228000', '130828000000');
INSERT INTO `t_s_town` VALUES ('2518', '西龙头乡', '130828229000', '130828000000');
INSERT INTO `t_s_town` VALUES ('2519', '塞罕坝机械林场', '130828450000', '130828000000');
INSERT INTO `t_s_town` VALUES ('2520', '国营御道口牧场', '130828500000', '130828000000');
INSERT INTO `t_s_town` VALUES ('2521', '冯营子镇', '130871104000', '130871000000');
INSERT INTO `t_s_town` VALUES ('2522', '上板城镇', '130871106000', '130871000000');
INSERT INTO `t_s_town` VALUES ('2523', '平泉镇', '130881100000', '130881000000');
INSERT INTO `t_s_town` VALUES ('2524', '黄土梁子镇', '130881101000', '130881000000');
INSERT INTO `t_s_town` VALUES ('2525', '榆树林子镇', '130881102000', '130881000000');
INSERT INTO `t_s_town` VALUES ('2526', '杨树岭镇', '130881103000', '130881000000');
INSERT INTO `t_s_town` VALUES ('2527', '七沟镇', '130881104000', '130881000000');
INSERT INTO `t_s_town` VALUES ('2528', '小寺沟镇', '130881105000', '130881000000');
INSERT INTO `t_s_town` VALUES ('2529', '党坝镇', '130881106000', '130881000000');
INSERT INTO `t_s_town` VALUES ('2530', '卧龙镇', '130881107000', '130881000000');
INSERT INTO `t_s_town` VALUES ('2531', '南五十家子镇', '130881108000', '130881000000');
INSERT INTO `t_s_town` VALUES ('2532', '北五十家子镇', '130881109000', '130881000000');
INSERT INTO `t_s_town` VALUES ('2533', '桲椤树镇', '130881110000', '130881000000');
INSERT INTO `t_s_town` VALUES ('2534', '柳溪镇', '130881111000', '130881000000');
INSERT INTO `t_s_town` VALUES ('2535', '平北镇', '130881112000', '130881000000');
INSERT INTO `t_s_town` VALUES ('2536', '青河镇', '130881113000', '130881000000');
INSERT INTO `t_s_town` VALUES ('2537', '台头山镇', '130881114000', '130881000000');
INSERT INTO `t_s_town` VALUES ('2538', '王土房乡', '130881200000', '130881000000');
INSERT INTO `t_s_town` VALUES ('2539', '七家岱满族乡', '130881203000', '130881000000');
INSERT INTO `t_s_town` VALUES ('2540', '茅兰沟满族蒙古族乡', '130881206000', '130881000000');
INSERT INTO `t_s_town` VALUES ('2541', '道虎沟乡', '130881210000', '130881000000');
INSERT INTO `t_s_town` VALUES ('2542', '建设北街街道办事处', '130902001000', '130902000000');
INSERT INTO `t_s_town` VALUES ('2543', '车站街道办事处', '130902002000', '130902000000');
INSERT INTO `t_s_town` VALUES ('2544', '南大街街道办事处', '130902003000', '130902000000');
INSERT INTO `t_s_town` VALUES ('2545', '东环街道办事处', '130902004000', '130902000000');
INSERT INTO `t_s_town` VALUES ('2546', '道东街道办事处', '130902005000', '130902000000');
INSERT INTO `t_s_town` VALUES ('2547', '小赵庄乡', '130902200000', '130902000000');
INSERT INTO `t_s_town` VALUES ('2548', '水月寺街道办事处', '130903001000', '130903000000');
INSERT INTO `t_s_town` VALUES ('2549', '南环中路街道办事处', '130903002000', '130903000000');
INSERT INTO `t_s_town` VALUES ('2550', '南湖街道办事处', '130903003000', '130903000000');
INSERT INTO `t_s_town` VALUES ('2551', '市场街道办事处', '130903004000', '130903000000');
INSERT INTO `t_s_town` VALUES ('2552', '西环中街街道办事处', '130903005000', '130903000000');
INSERT INTO `t_s_town` VALUES ('2553', '公园街道办事处', '130903006000', '130903000000');
INSERT INTO `t_s_town` VALUES ('2554', '小王庄镇', '130903100000', '130903000000');
INSERT INTO `t_s_town` VALUES ('2555', '南陈屯乡', '130903200000', '130903000000');
INSERT INTO `t_s_town` VALUES ('2556', '旧州镇', '130921100000', '130921000000');
INSERT INTO `t_s_town` VALUES ('2557', '兴济镇', '130921101000', '130921000000');
INSERT INTO `t_s_town` VALUES ('2558', '杜生镇', '130921102000', '130921000000');
INSERT INTO `t_s_town` VALUES ('2559', '崔尔庄镇', '130921103000', '130921000000');
INSERT INTO `t_s_town` VALUES ('2560', '薛官屯乡', '130921200000', '130921000000');
INSERT INTO `t_s_town` VALUES ('2561', '捷地回族乡', '130921201000', '130921000000');
INSERT INTO `t_s_town` VALUES ('2562', '张官屯乡', '130921202000', '130921000000');
INSERT INTO `t_s_town` VALUES ('2563', '李天木回族乡', '130921203000', '130921000000');
INSERT INTO `t_s_town` VALUES ('2564', '风化店乡', '130921204000', '130921000000');
INSERT INTO `t_s_town` VALUES ('2565', '姚官屯乡', '130921205000', '130921000000');
INSERT INTO `t_s_town` VALUES ('2566', '杜林回族乡', '130921206000', '130921000000');
INSERT INTO `t_s_town` VALUES ('2567', '汪家铺乡', '130921207000', '130921000000');
INSERT INTO `t_s_town` VALUES ('2568', '刘家庙乡', '130921208000', '130921000000');
INSERT INTO `t_s_town` VALUES ('2569', '仵龙堂乡', '130921209000', '130921000000');
INSERT INTO `t_s_town` VALUES ('2570', '大官厅乡', '130921210000', '130921000000');
INSERT INTO `t_s_town` VALUES ('2571', '高川乡', '130921211000', '130921000000');
INSERT INTO `t_s_town` VALUES ('2572', '黄递铺乡', '130921212000', '130921000000');
INSERT INTO `t_s_town` VALUES ('2573', '大褚村回族乡', '130921213000', '130921000000');
INSERT INTO `t_s_town` VALUES ('2574', '纸房头乡', '130921214000', '130921000000');
INSERT INTO `t_s_town` VALUES ('2575', '清州镇', '130922100000', '130922000000');
INSERT INTO `t_s_town` VALUES ('2576', '金牛镇', '130922101000', '130922000000');
INSERT INTO `t_s_town` VALUES ('2577', '新兴镇', '130922102000', '130922000000');
INSERT INTO `t_s_town` VALUES ('2578', '流河镇', '130922103000', '130922000000');
INSERT INTO `t_s_town` VALUES ('2579', '木门店镇', '130922104000', '130922000000');
INSERT INTO `t_s_town` VALUES ('2580', '马厂镇', '130922105000', '130922000000');
INSERT INTO `t_s_town` VALUES ('2581', '盘古镇', '130922106000', '130922000000');
INSERT INTO `t_s_town` VALUES ('2582', '上伍乡', '130922200000', '130922000000');
INSERT INTO `t_s_town` VALUES ('2583', '曹寺乡', '130922201000', '130922000000');
INSERT INTO `t_s_town` VALUES ('2584', '陈嘴乡', '130922203000', '130922000000');
INSERT INTO `t_s_town` VALUES ('2585', '青县农场', '130922400000', '130922000000');
INSERT INTO `t_s_town` VALUES ('2586', '东光镇', '130923100000', '130923000000');
INSERT INTO `t_s_town` VALUES ('2587', '连镇镇', '130923101000', '130923000000');
INSERT INTO `t_s_town` VALUES ('2588', '找王镇', '130923102000', '130923000000');
INSERT INTO `t_s_town` VALUES ('2589', '秦村镇', '130923103000', '130923000000');
INSERT INTO `t_s_town` VALUES ('2590', '灯明寺镇', '130923104000', '130923000000');
INSERT INTO `t_s_town` VALUES ('2591', '南霞口镇', '130923105000', '130923000000');
INSERT INTO `t_s_town` VALUES ('2592', '大单镇', '130923106000', '130923000000');
INSERT INTO `t_s_town` VALUES ('2593', '龙王李镇', '130923107000', '130923000000');
INSERT INTO `t_s_town` VALUES ('2594', '于桥乡', '130923201000', '130923000000');
INSERT INTO `t_s_town` VALUES ('2595', '苏基镇', '130924100000', '130924000000');
INSERT INTO `t_s_town` VALUES ('2596', '辛集镇', '130924101000', '130924000000');
INSERT INTO `t_s_town` VALUES ('2597', '高湾镇', '130924102000', '130924000000');
INSERT INTO `t_s_town` VALUES ('2598', '赵毛陶乡', '130924200000', '130924000000');
INSERT INTO `t_s_town` VALUES ('2599', '香坊乡', '130924201000', '130924000000');
INSERT INTO `t_s_town` VALUES ('2600', '小山乡', '130924202000', '130924000000');
INSERT INTO `t_s_town` VALUES ('2601', '张会亭乡', '130924203000', '130924000000');
INSERT INTO `t_s_town` VALUES ('2602', '海兴县农场', '130924400000', '130924000000');
INSERT INTO `t_s_town` VALUES ('2603', '青先农场', '130924401000', '130924000000');
INSERT INTO `t_s_town` VALUES ('2604', '青锋农场', '130924402000', '130924000000');
INSERT INTO `t_s_town` VALUES ('2605', '盐山镇', '130925100000', '130925000000');
INSERT INTO `t_s_town` VALUES ('2606', '望树镇', '130925101000', '130925000000');
INSERT INTO `t_s_town` VALUES ('2607', '庆云镇', '130925102000', '130925000000');
INSERT INTO `t_s_town` VALUES ('2608', '韩集镇', '130925103000', '130925000000');
INSERT INTO `t_s_town` VALUES ('2609', '千童镇', '130925104000', '130925000000');
INSERT INTO `t_s_town` VALUES ('2610', '圣佛镇', '130925105000', '130925000000');
INSERT INTO `t_s_town` VALUES ('2611', '边务乡', '130925200000', '130925000000');
INSERT INTO `t_s_town` VALUES ('2612', '小营乡', '130925201000', '130925000000');
INSERT INTO `t_s_town` VALUES ('2613', '杨集乡', '130925202000', '130925000000');
INSERT INTO `t_s_town` VALUES ('2614', '孟店乡', '130925203000', '130925000000');
INSERT INTO `t_s_town` VALUES ('2615', '常庄乡', '130925204000', '130925000000');
INSERT INTO `t_s_town` VALUES ('2616', '小庄乡', '130925205000', '130925000000');
INSERT INTO `t_s_town` VALUES ('2617', '肃宁镇', '130926100000', '130926000000');
INSERT INTO `t_s_town` VALUES ('2618', '梁家村镇', '130926101000', '130926000000');
INSERT INTO `t_s_town` VALUES ('2619', '窝北镇', '130926102000', '130926000000');
INSERT INTO `t_s_town` VALUES ('2620', '尚村镇', '130926103000', '130926000000');
INSERT INTO `t_s_town` VALUES ('2621', '万里镇', '130926104000', '130926000000');
INSERT INTO `t_s_town` VALUES ('2622', '师素镇', '130926105000', '130926000000');
INSERT INTO `t_s_town` VALUES ('2623', '河北留善寺乡', '130926203000', '130926000000');
INSERT INTO `t_s_town` VALUES ('2624', '付家佐乡', '130926204000', '130926000000');
INSERT INTO `t_s_town` VALUES ('2625', '邵庄乡', '130926205000', '130926000000');
INSERT INTO `t_s_town` VALUES ('2626', '南皮镇', '130927100000', '130927000000');
INSERT INTO `t_s_town` VALUES ('2627', '冯家口镇', '130927101000', '130927000000');
INSERT INTO `t_s_town` VALUES ('2628', '寨子镇', '130927102000', '130927000000');
INSERT INTO `t_s_town` VALUES ('2629', '鲍官屯镇', '130927103000', '130927000000');
INSERT INTO `t_s_town` VALUES ('2630', '王寺镇', '130927104000', '130927000000');
INSERT INTO `t_s_town` VALUES ('2631', '乌马营镇', '130927105000', '130927000000');
INSERT INTO `t_s_town` VALUES ('2632', '大浪淀乡', '130927200000', '130927000000');
INSERT INTO `t_s_town` VALUES ('2633', '刘八里乡', '130927201000', '130927000000');
INSERT INTO `t_s_town` VALUES ('2634', '潞灌乡', '130927202000', '130927000000');
INSERT INTO `t_s_town` VALUES ('2635', '桑园镇', '130928100000', '130928000000');
INSERT INTO `t_s_town` VALUES ('2636', '铁城镇', '130928101000', '130928000000');
INSERT INTO `t_s_town` VALUES ('2637', '于集镇', '130928102000', '130928000000');
INSERT INTO `t_s_town` VALUES ('2638', '梁集镇', '130928103000', '130928000000');
INSERT INTO `t_s_town` VALUES ('2639', '安陵镇', '130928104000', '130928000000');
INSERT INTO `t_s_town` VALUES ('2640', '曹家洼乡', '130928200000', '130928000000');
INSERT INTO `t_s_town` VALUES ('2641', '宋门乡', '130928201000', '130928000000');
INSERT INTO `t_s_town` VALUES ('2642', '杨家寺乡', '130928202000', '130928000000');
INSERT INTO `t_s_town` VALUES ('2643', '沟店铺乡', '130928203000', '130928000000');
INSERT INTO `t_s_town` VALUES ('2644', '何庄乡', '130928204000', '130928000000');
INSERT INTO `t_s_town` VALUES ('2645', '吴桥经济技术开发区', '130928400000', '130928000000');
INSERT INTO `t_s_town` VALUES ('2646', '乐寿镇', '130929100000', '130929000000');
INSERT INTO `t_s_town` VALUES ('2647', '淮镇镇', '130929101000', '130929000000');
INSERT INTO `t_s_town` VALUES ('2648', '郭庄镇', '130929102000', '130929000000');
INSERT INTO `t_s_town` VALUES ('2649', '河城街镇', '130929103000', '130929000000');
INSERT INTO `t_s_town` VALUES ('2650', '韩村镇', '130929104000', '130929000000');
INSERT INTO `t_s_town` VALUES ('2651', '陌南镇', '130929105000', '130929000000');
INSERT INTO `t_s_town` VALUES ('2652', '陈庄镇', '130929106000', '130929000000');
INSERT INTO `t_s_town` VALUES ('2653', '徐留高乡', '130929205000', '130929000000');
INSERT INTO `t_s_town` VALUES ('2654', '商林乡', '130929206000', '130929000000');
INSERT INTO `t_s_town` VALUES ('2655', '段村乡', '130929207000', '130929000000');
INSERT INTO `t_s_town` VALUES ('2656', '张村乡', '130929209000', '130929000000');
INSERT INTO `t_s_town` VALUES ('2657', '临河乡', '130929210000', '130929000000');
INSERT INTO `t_s_town` VALUES ('2658', '小平王乡', '130929211000', '130929000000');
INSERT INTO `t_s_town` VALUES ('2659', '十五级乡', '130929212000', '130929000000');
INSERT INTO `t_s_town` VALUES ('2660', '垒头乡', '130929213000', '130929000000');
INSERT INTO `t_s_town` VALUES ('2661', '南河头乡', '130929214000', '130929000000');
INSERT INTO `t_s_town` VALUES ('2662', '西城乡', '130929215000', '130929000000');
INSERT INTO `t_s_town` VALUES ('2663', '本斋回族乡', '130929216000', '130929000000');
INSERT INTO `t_s_town` VALUES ('2664', '农场', '130929400000', '130929000000');
INSERT INTO `t_s_town` VALUES ('2665', '献县经济开发区', '130929401000', '130929000000');
INSERT INTO `t_s_town` VALUES ('2666', '孟村镇', '130930100000', '130930000000');
INSERT INTO `t_s_town` VALUES ('2667', '新县镇', '130930101000', '130930000000');
INSERT INTO `t_s_town` VALUES ('2668', '辛店镇', '130930102000', '130930000000');
INSERT INTO `t_s_town` VALUES ('2669', '高寨镇', '130930103000', '130930000000');
INSERT INTO `t_s_town` VALUES ('2670', '宋庄子乡', '130930200000', '130930000000');
INSERT INTO `t_s_town` VALUES ('2671', '牛进庄乡', '130930201000', '130930000000');
INSERT INTO `t_s_town` VALUES ('2672', '开发区乡', '130971400000', '130971000000');
INSERT INTO `t_s_town` VALUES ('2673', '高新乡', '130972400000', '130972000000');
INSERT INTO `t_s_town` VALUES ('2674', '新村回族乡', '130973206000', '130973000000');
INSERT INTO `t_s_town` VALUES ('2675', '南大港管理区', '130973400000', '130973000000');
INSERT INTO `t_s_town` VALUES ('2676', '国营中捷农场', '130973401000', '130973000000');
INSERT INTO `t_s_town` VALUES ('2677', '港城街道办事处', '130973402000', '130973000000');
INSERT INTO `t_s_town` VALUES ('2678', '临港化工园区', '130973403000', '130973000000');
INSERT INTO `t_s_town` VALUES ('2679', '解放街道办事处', '130981001000', '130981000000');
INSERT INTO `t_s_town` VALUES ('2680', '河东街道办事处', '130981002000', '130981000000');
INSERT INTO `t_s_town` VALUES ('2681', '古楼街道办事处', '130981003000', '130981000000');
INSERT INTO `t_s_town` VALUES ('2682', '泊镇', '130981100000', '130981000000');
INSERT INTO `t_s_town` VALUES ('2683', '交河镇', '130981101000', '130981000000');
INSERT INTO `t_s_town` VALUES ('2684', '齐桥镇', '130981102000', '130981000000');
INSERT INTO `t_s_town` VALUES ('2685', '寺门村镇', '130981103000', '130981000000');
INSERT INTO `t_s_town` VALUES ('2686', '郝村镇', '130981104000', '130981000000');
INSERT INTO `t_s_town` VALUES ('2687', '富镇镇', '130981105000', '130981000000');
INSERT INTO `t_s_town` VALUES ('2688', '文庙镇', '130981106000', '130981000000');
INSERT INTO `t_s_town` VALUES ('2689', '洼里王镇', '130981107000', '130981000000');
INSERT INTO `t_s_town` VALUES ('2690', '王武庄乡', '130981201000', '130981000000');
INSERT INTO `t_s_town` VALUES ('2691', '营子乡', '130981202000', '130981000000');
INSERT INTO `t_s_town` VALUES ('2692', '四营乡', '130981203000', '130981000000');
INSERT INTO `t_s_town` VALUES ('2693', '西辛店乡', '130981204000', '130981000000');
INSERT INTO `t_s_town` VALUES ('2694', '泊头市工业区管委会', '130981400000', '130981000000');
INSERT INTO `t_s_town` VALUES ('2695', '新华路街道', '130982001000', '130982000000');
INSERT INTO `t_s_town` VALUES ('2696', '西环路街道', '130982002000', '130982000000');
INSERT INTO `t_s_town` VALUES ('2697', '永丰路街道', '130982003000', '130982000000');
INSERT INTO `t_s_town` VALUES ('2698', '中华路办事处', '130982004000', '130982000000');
INSERT INTO `t_s_town` VALUES ('2699', '渤海路街道', '130982005000', '130982000000');
INSERT INTO `t_s_town` VALUES ('2700', '油建路街道', '130982006000', '130982000000');
INSERT INTO `t_s_town` VALUES ('2701', '会战道街道', '130982007000', '130982000000');
INSERT INTO `t_s_town` VALUES ('2702', '出岸镇', '130982100000', '130982000000');
INSERT INTO `t_s_town` VALUES ('2703', '石门桥镇', '130982101000', '130982000000');
INSERT INTO `t_s_town` VALUES ('2704', '吕公堡镇', '130982102000', '130982000000');
INSERT INTO `t_s_town` VALUES ('2705', '长丰镇', '130982103000', '130982000000');
INSERT INTO `t_s_town` VALUES ('2706', '梁召镇', '130982106000', '130982000000');
INSERT INTO `t_s_town` VALUES ('2707', '辛中驿镇', '130982107000', '130982000000');
INSERT INTO `t_s_town` VALUES ('2708', '麻家坞镇', '130982108000', '130982000000');
INSERT INTO `t_s_town` VALUES ('2709', '议论堡乡', '130982203000', '130982000000');
INSERT INTO `t_s_town` VALUES ('2710', '青塔乡', '130982204000', '130982000000');
INSERT INTO `t_s_town` VALUES ('2711', '北辛庄乡', '130982205000', '130982000000');
INSERT INTO `t_s_town` VALUES ('2712', '北汉乡', '130982207000', '130982000000');
INSERT INTO `t_s_town` VALUES ('2713', '于村乡', '130982208000', '130982000000');
INSERT INTO `t_s_town` VALUES ('2714', '华北石油管理局', '130982400000', '130982000000');
INSERT INTO `t_s_town` VALUES ('2715', '开发区管理委员会', '130982500000', '130982000000');
INSERT INTO `t_s_town` VALUES ('2716', '河北任丘雁翎工业园区', '130982501000', '130982000000');
INSERT INTO `t_s_town` VALUES ('2717', '骅东街道', '130983001000', '130983000000');
INSERT INTO `t_s_town` VALUES ('2718', '骅中街道', '130983002000', '130983000000');
INSERT INTO `t_s_town` VALUES ('2719', '骅西街道', '130983003000', '130983000000');
INSERT INTO `t_s_town` VALUES ('2720', '黄骅镇', '130983100000', '130983000000');
INSERT INTO `t_s_town` VALUES ('2721', '南排河镇', '130983101000', '130983000000');
INSERT INTO `t_s_town` VALUES ('2722', '吕桥镇', '130983102000', '130983000000');
INSERT INTO `t_s_town` VALUES ('2723', '旧城镇', '130983103000', '130983000000');
INSERT INTO `t_s_town` VALUES ('2724', '羊二庄回族乡', '130983200000', '130983000000');
INSERT INTO `t_s_town` VALUES ('2725', '常郭乡', '130983202000', '130983000000');
INSERT INTO `t_s_town` VALUES ('2726', '滕庄子乡', '130983203000', '130983000000');
INSERT INTO `t_s_town` VALUES ('2727', '官庄乡', '130983204000', '130983000000');
INSERT INTO `t_s_town` VALUES ('2728', '齐家务乡', '130983205000', '130983000000');
INSERT INTO `t_s_town` VALUES ('2729', '羊三木回族乡', '130983207000', '130983000000');
INSERT INTO `t_s_town` VALUES ('2730', '瀛州路街道办事处', '130984001000', '130984000000');
INSERT INTO `t_s_town` VALUES ('2731', '城垣西路街道办事处', '130984002000', '130984000000');
INSERT INTO `t_s_town` VALUES ('2732', '米各庄镇', '130984101000', '130984000000');
INSERT INTO `t_s_town` VALUES ('2733', '景和镇', '130984102000', '130984000000');
INSERT INTO `t_s_town` VALUES ('2734', '卧佛堂镇', '130984103000', '130984000000');
INSERT INTO `t_s_town` VALUES ('2735', '束城镇', '130984104000', '130984000000');
INSERT INTO `t_s_town` VALUES ('2736', '留古寺镇', '130984105000', '130984000000');
INSERT INTO `t_s_town` VALUES ('2737', '沙河桥镇', '130984106000', '130984000000');
INSERT INTO `t_s_town` VALUES ('2738', '诗经村镇', '130984107000', '130984000000');
INSERT INTO `t_s_town` VALUES ('2739', '故仙乡', '130984200000', '130984000000');
INSERT INTO `t_s_town` VALUES ('2740', '黎民居乡', '130984201000', '130984000000');
INSERT INTO `t_s_town` VALUES ('2741', '兴村乡', '130984202000', '130984000000');
INSERT INTO `t_s_town` VALUES ('2742', '沙洼乡', '130984203000', '130984000000');
INSERT INTO `t_s_town` VALUES ('2743', '西九吉乡', '130984204000', '130984000000');
INSERT INTO `t_s_town` VALUES ('2744', '北石槽乡', '130984205000', '130984000000');
INSERT INTO `t_s_town` VALUES ('2745', '时村乡', '130984209000', '130984000000');
INSERT INTO `t_s_town` VALUES ('2746', '行别营乡', '130984210000', '130984000000');
INSERT INTO `t_s_town` VALUES ('2747', '尊祖庄乡', '130984211000', '130984000000');
INSERT INTO `t_s_town` VALUES ('2748', '龙华店乡', '130984212000', '130984000000');
INSERT INTO `t_s_town` VALUES ('2749', '果子洼回族乡', '130984213000', '130984000000');
INSERT INTO `t_s_town` VALUES ('2750', '河间经济开发区管理委员会', '130984401000', '130984000000');
INSERT INTO `t_s_town` VALUES ('2751', '河北河间瀛州经济开发区管理委员会', '130984402000', '130984000000');
INSERT INTO `t_s_town` VALUES ('2752', '银河南路街道', '131002001000', '131002000000');
INSERT INTO `t_s_town` VALUES ('2753', '光明西道街道', '131002002000', '131002000000');
INSERT INTO `t_s_town` VALUES ('2754', '永华道街道办事处', '131002003000', '131002000000');
INSERT INTO `t_s_town` VALUES ('2755', '落垡镇', '131002100000', '131002000000');
INSERT INTO `t_s_town` VALUES ('2756', '码头镇', '131002101000', '131002000000');
INSERT INTO `t_s_town` VALUES ('2757', '葛渔城镇', '131002102000', '131002000000');
INSERT INTO `t_s_town` VALUES ('2758', '东沽港镇', '131002103000', '131002000000');
INSERT INTO `t_s_town` VALUES ('2759', '调河头镇', '131002104000', '131002000000');
INSERT INTO `t_s_town` VALUES ('2760', '杨税务乡', '131002200000', '131002000000');
INSERT INTO `t_s_town` VALUES ('2761', '仇庄乡', '131002201000', '131002000000');
INSERT INTO `t_s_town` VALUES ('2762', '北史家务乡', '131002203000', '131002000000');
INSERT INTO `t_s_town` VALUES ('2763', '廊坊龙河高新技术产业开发区', '131002400000', '131002000000');
INSERT INTO `t_s_town` VALUES ('2764', '河北廊坊高新技术产业开发区', '131002401000', '131002000000');
INSERT INTO `t_s_town` VALUES ('2765', '河北廊坊龙港经济开发区', '131002402000', '131002000000');
INSERT INTO `t_s_town` VALUES ('2766', '河北安次经济开发区', '131002403000', '131002000000');
INSERT INTO `t_s_town` VALUES ('2767', '银河北路街道', '131003001000', '131003000000');
INSERT INTO `t_s_town` VALUES ('2768', '爱民东道街道', '131003002000', '131003000000');
INSERT INTO `t_s_town` VALUES ('2769', '解放道街道', '131003003000', '131003000000');
INSERT INTO `t_s_town` VALUES ('2770', '新开路街道', '131003004000', '131003000000');
INSERT INTO `t_s_town` VALUES ('2771', '新源道街道', '131003005000', '131003000000');
INSERT INTO `t_s_town` VALUES ('2772', '南尖塔镇', '131003100000', '131003000000');
INSERT INTO `t_s_town` VALUES ('2773', '万庄镇', '131003101000', '131003000000');
INSERT INTO `t_s_town` VALUES ('2774', '九州镇', '131003102000', '131003000000');
INSERT INTO `t_s_town` VALUES ('2775', '北旺乡', '131003200000', '131003000000');
INSERT INTO `t_s_town` VALUES ('2776', '新世纪步行街管理委员会', '131003500000', '131003000000');
INSERT INTO `t_s_town` VALUES ('2777', '固安镇', '131022100000', '131022000000');
INSERT INTO `t_s_town` VALUES ('2778', '宫村镇', '131022101000', '131022000000');
INSERT INTO `t_s_town` VALUES ('2779', '柳泉镇', '131022102000', '131022000000');
INSERT INTO `t_s_town` VALUES ('2780', '牛驼镇', '131022103000', '131022000000');
INSERT INTO `t_s_town` VALUES ('2781', '马庄镇', '131022104000', '131022000000');
INSERT INTO `t_s_town` VALUES ('2782', '东湾乡', '131022200000', '131022000000');
INSERT INTO `t_s_town` VALUES ('2783', '彭村乡', '131022201000', '131022000000');
INSERT INTO `t_s_town` VALUES ('2784', '渠沟乡', '131022202000', '131022000000');
INSERT INTO `t_s_town` VALUES ('2785', '礼让店乡', '131022203000', '131022000000');
INSERT INTO `t_s_town` VALUES ('2786', '固安温泉休闲商务产业园区', '131022400000', '131022000000');
INSERT INTO `t_s_town` VALUES ('2787', '城区街道办事处', '131023001000', '131023000000');
INSERT INTO `t_s_town` VALUES ('2788', '永清镇', '131023100000', '131023000000');
INSERT INTO `t_s_town` VALUES ('2789', '韩村镇', '131023101000', '131023000000');
INSERT INTO `t_s_town` VALUES ('2790', '后奕镇', '131023102000', '131023000000');
INSERT INTO `t_s_town` VALUES ('2791', '别古庄镇', '131023103000', '131023000000');
INSERT INTO `t_s_town` VALUES ('2792', '里澜城镇', '131023104000', '131023000000');
INSERT INTO `t_s_town` VALUES ('2793', '管家务回族乡', '131023200000', '131023000000');
INSERT INTO `t_s_town` VALUES ('2794', '曹家务乡', '131023201000', '131023000000');
INSERT INTO `t_s_town` VALUES ('2795', '龙虎庄乡', '131023202000', '131023000000');
INSERT INTO `t_s_town` VALUES ('2796', '刘街乡', '131023203000', '131023000000');
INSERT INTO `t_s_town` VALUES ('2797', '三圣口乡', '131023204000', '131023000000');
INSERT INTO `t_s_town` VALUES ('2798', '河北永清经济开发区', '131023400000', '131023000000');
INSERT INTO `t_s_town` VALUES ('2799', '北京亦庄永清高新技术产业开发区区', '131023401000', '131023000000');
INSERT INTO `t_s_town` VALUES ('2800', '淑阳镇', '131024100000', '131024000000');
INSERT INTO `t_s_town` VALUES ('2801', '蒋辛屯镇', '131024101000', '131024000000');
INSERT INTO `t_s_town` VALUES ('2802', '渠口镇', '131024102000', '131024000000');
INSERT INTO `t_s_town` VALUES ('2803', '安头屯镇', '131024103000', '131024000000');
INSERT INTO `t_s_town` VALUES ('2804', '安平镇', '131024104000', '131024000000');
INSERT INTO `t_s_town` VALUES ('2805', '刘宋镇', '131024105000', '131024000000');
INSERT INTO `t_s_town` VALUES ('2806', '五百户镇', '131024106000', '131024000000');
INSERT INTO `t_s_town` VALUES ('2807', '钱旺镇', '131024107000', '131024000000');
INSERT INTO `t_s_town` VALUES ('2808', '钳屯镇', '131024108000', '131024000000');
INSERT INTO `t_s_town` VALUES ('2809', '香河开发区', '131024500000', '131024000000');
INSERT INTO `t_s_town` VALUES ('2810', '香河新兴产业示范区', '131024501000', '131024000000');
INSERT INTO `t_s_town` VALUES ('2811', '平舒镇', '131025100000', '131025000000');
INSERT INTO `t_s_town` VALUES ('2812', '旺村镇', '131025101000', '131025000000');
INSERT INTO `t_s_town` VALUES ('2813', '大尚屯镇', '131025102000', '131025000000');
INSERT INTO `t_s_town` VALUES ('2814', '南赵扶镇', '131025103000', '131025000000');
INSERT INTO `t_s_town` VALUES ('2815', '留各庄镇', '131025104000', '131025000000');
INSERT INTO `t_s_town` VALUES ('2816', '权村镇', '131025105000', '131025000000');
INSERT INTO `t_s_town` VALUES ('2817', '里坦镇', '131025106000', '131025000000');
INSERT INTO `t_s_town` VALUES ('2818', '广安镇', '131025107000', '131025000000');
INSERT INTO `t_s_town` VALUES ('2819', '北魏乡', '131025200000', '131025000000');
INSERT INTO `t_s_town` VALUES ('2820', '臧屯乡', '131025202000', '131025000000');
INSERT INTO `t_s_town` VALUES ('2821', '河北大城经济开发区', '131025400000', '131025000000');
INSERT INTO `t_s_town` VALUES ('2822', '文安镇', '131026100000', '131026000000');
INSERT INTO `t_s_town` VALUES ('2823', '新镇镇', '131026101000', '131026000000');
INSERT INTO `t_s_town` VALUES ('2824', '苏桥镇', '131026102000', '131026000000');
INSERT INTO `t_s_town` VALUES ('2825', '大柳河镇', '131026103000', '131026000000');
INSERT INTO `t_s_town` VALUES ('2826', '左各庄镇', '131026104000', '131026000000');
INSERT INTO `t_s_town` VALUES ('2827', '滩里镇', '131026105000', '131026000000');
INSERT INTO `t_s_town` VALUES ('2828', '史各庄镇', '131026106000', '131026000000');
INSERT INTO `t_s_town` VALUES ('2829', '赵各庄镇', '131026107000', '131026000000');
INSERT INTO `t_s_town` VALUES ('2830', '兴隆宫镇', '131026108000', '131026000000');
INSERT INTO `t_s_town` VALUES ('2831', '大留镇镇', '131026109000', '131026000000');
INSERT INTO `t_s_town` VALUES ('2832', '孙氏镇', '131026110000', '131026000000');
INSERT INTO `t_s_town` VALUES ('2833', '德归镇', '131026111000', '131026000000');
INSERT INTO `t_s_town` VALUES ('2834', '大围河回族满族乡', '131026200000', '131026000000');
INSERT INTO `t_s_town` VALUES ('2835', '北辰街道办事处', '131028001000', '131028000000');
INSERT INTO `t_s_town` VALUES ('2836', '大厂镇', '131028100000', '131028000000');
INSERT INTO `t_s_town` VALUES ('2837', '夏垫镇', '131028101000', '131028000000');
INSERT INTO `t_s_town` VALUES ('2838', '祁各庄镇', '131028102000', '131028000000');
INSERT INTO `t_s_town` VALUES ('2839', '邵府镇', '131028103000', '131028000000');
INSERT INTO `t_s_town` VALUES ('2840', '陈府镇', '131028104000', '131028000000');
INSERT INTO `t_s_town` VALUES ('2841', '河北大厂高新技术产业开发区', '131028400000', '131028000000');
INSERT INTO `t_s_town` VALUES ('2842', '耀华道街道办事处', '131071450000', '131071000000');
INSERT INTO `t_s_town` VALUES ('2843', '云鹏道街道办事处', '131071451000', '131071000000');
INSERT INTO `t_s_town` VALUES ('2844', '裕华街道办事处', '131081001000', '131081000000');
INSERT INTO `t_s_town` VALUES ('2845', '霸州镇', '131081100000', '131081000000');
INSERT INTO `t_s_town` VALUES ('2846', '南孟镇', '131081101000', '131081000000');
INSERT INTO `t_s_town` VALUES ('2847', '信安镇', '131081102000', '131081000000');
INSERT INTO `t_s_town` VALUES ('2848', '堂二里镇', '131081103000', '131081000000');
INSERT INTO `t_s_town` VALUES ('2849', '煎茶铺镇', '131081104000', '131081000000');
INSERT INTO `t_s_town` VALUES ('2850', '胜芳镇', '131081105000', '131081000000');
INSERT INTO `t_s_town` VALUES ('2851', '杨芬港镇', '131081106000', '131081000000');
INSERT INTO `t_s_town` VALUES ('2852', '岔河集乡', '131081200000', '131081000000');
INSERT INTO `t_s_town` VALUES ('2853', '康仙庄乡', '131081201000', '131081000000');
INSERT INTO `t_s_town` VALUES ('2854', '东杨庄乡', '131081202000', '131081000000');
INSERT INTO `t_s_town` VALUES ('2855', '王庄子乡', '131081203000', '131081000000');
INSERT INTO `t_s_town` VALUES ('2856', '东段乡', '131081204000', '131081000000');
INSERT INTO `t_s_town` VALUES ('2857', '鼎盛东大街街道办事处', '131082001000', '131082000000');
INSERT INTO `t_s_town` VALUES ('2858', '泃阳西大街街道办事处', '131082002000', '131082000000');
INSERT INTO `t_s_town` VALUES ('2859', '泃阳镇', '131082100000', '131082000000');
INSERT INTO `t_s_town` VALUES ('2860', '李旗庄镇', '131082101000', '131082000000');
INSERT INTO `t_s_town` VALUES ('2861', '杨庄镇', '131082102000', '131082000000');
INSERT INTO `t_s_town` VALUES ('2862', '皇庄镇', '131082103000', '131082000000');
INSERT INTO `t_s_town` VALUES ('2863', '新集镇', '131082104000', '131082000000');
INSERT INTO `t_s_town` VALUES ('2864', '段甲岭镇', '131082105000', '131082000000');
INSERT INTO `t_s_town` VALUES ('2865', '黄土庄镇', '131082106000', '131082000000');
INSERT INTO `t_s_town` VALUES ('2866', '高楼镇', '131082107000', '131082000000');
INSERT INTO `t_s_town` VALUES ('2867', '齐心庄镇', '131082108000', '131082000000');
INSERT INTO `t_s_town` VALUES ('2868', '燕郊镇', '131082109000', '131082000000');
INSERT INTO `t_s_town` VALUES ('2869', '燕郊经济技术开发区', '131082450000', '131082000000');
INSERT INTO `t_s_town` VALUES ('2870', '三河市农业高新技术园区', '131082451000', '131082000000');
INSERT INTO `t_s_town` VALUES ('2871', '河西街道办事处', '131102001000', '131102000000');
INSERT INTO `t_s_town` VALUES ('2872', '河东街道办事处', '131102002000', '131102000000');
INSERT INTO `t_s_town` VALUES ('2873', '路北街道办事处', '131102003000', '131102000000');
INSERT INTO `t_s_town` VALUES ('2874', '中华街道办事处', '131102004000', '131102000000');
INSERT INTO `t_s_town` VALUES ('2875', '郑家河沿镇', '131102100000', '131102000000');
INSERT INTO `t_s_town` VALUES ('2876', '赵家圈镇', '131102101000', '131102000000');
INSERT INTO `t_s_town` VALUES ('2877', '邓庄镇', '131102102000', '131102000000');
INSERT INTO `t_s_town` VALUES ('2878', '何家庄乡', '131102200000', '131102000000');
INSERT INTO `t_s_town` VALUES ('2879', '冀州镇', '131103100000', '131103000000');
INSERT INTO `t_s_town` VALUES ('2880', '官道李镇', '131103102000', '131103000000');
INSERT INTO `t_s_town` VALUES ('2881', '南午村镇', '131103103000', '131103000000');
INSERT INTO `t_s_town` VALUES ('2882', '周村镇', '131103104000', '131103000000');
INSERT INTO `t_s_town` VALUES ('2883', '码头李镇', '131103105000', '131103000000');
INSERT INTO `t_s_town` VALUES ('2884', '西王镇', '131103106000', '131103000000');
INSERT INTO `t_s_town` VALUES ('2885', '门家庄乡', '131103200000', '131103000000');
INSERT INTO `t_s_town` VALUES ('2886', '徐家庄乡', '131103201000', '131103000000');
INSERT INTO `t_s_town` VALUES ('2887', '北漳淮乡', '131103202000', '131103000000');
INSERT INTO `t_s_town` VALUES ('2888', '小寨乡', '131103203000', '131103000000');
INSERT INTO `t_s_town` VALUES ('2889', '枣强镇', '131121100000', '131121000000');
INSERT INTO `t_s_town` VALUES ('2890', '恩察镇', '131121101000', '131121000000');
INSERT INTO `t_s_town` VALUES ('2891', '大营镇', '131121102000', '131121000000');
INSERT INTO `t_s_town` VALUES ('2892', '嘉会镇', '131121103000', '131121000000');
INSERT INTO `t_s_town` VALUES ('2893', '马屯镇', '131121104000', '131121000000');
INSERT INTO `t_s_town` VALUES ('2894', '肖张镇', '131121105000', '131121000000');
INSERT INTO `t_s_town` VALUES ('2895', '张秀屯镇', '131121106000', '131121000000');
INSERT INTO `t_s_town` VALUES ('2896', '新屯镇', '131121107000', '131121000000');
INSERT INTO `t_s_town` VALUES ('2897', '唐林镇', '131121108000', '131121000000');
INSERT INTO `t_s_town` VALUES ('2898', '王均乡', '131121202000', '131121000000');
INSERT INTO `t_s_town` VALUES ('2899', '王常乡', '131121204000', '131121000000');
INSERT INTO `t_s_town` VALUES ('2900', '武邑镇', '131122100000', '131122000000');
INSERT INTO `t_s_town` VALUES ('2901', '清凉店镇', '131122101000', '131122000000');
INSERT INTO `t_s_town` VALUES ('2902', '审坡镇', '131122102000', '131122000000');
INSERT INTO `t_s_town` VALUES ('2903', '赵桥镇', '131122103000', '131122000000');
INSERT INTO `t_s_town` VALUES ('2904', '韩庄镇', '131122104000', '131122000000');
INSERT INTO `t_s_town` VALUES ('2905', '肖桥头镇', '131122105000', '131122000000');
INSERT INTO `t_s_town` VALUES ('2906', '龙店镇', '131122106000', '131122000000');
INSERT INTO `t_s_town` VALUES ('2907', '圈头乡', '131122201000', '131122000000');
INSERT INTO `t_s_town` VALUES ('2908', '大紫塔乡', '131122203000', '131122000000');
INSERT INTO `t_s_town` VALUES ('2909', '武强镇', '131123100000', '131123000000');
INSERT INTO `t_s_town` VALUES ('2910', '街关镇', '131123101000', '131123000000');
INSERT INTO `t_s_town` VALUES ('2911', '周窝镇', '131123102000', '131123000000');
INSERT INTO `t_s_town` VALUES ('2912', '东孙庄镇', '131123103000', '131123000000');
INSERT INTO `t_s_town` VALUES ('2913', '豆村乡', '131123200000', '131123000000');
INSERT INTO `t_s_town` VALUES ('2914', '北代乡', '131123201000', '131123000000');
INSERT INTO `t_s_town` VALUES ('2915', '饶阳镇', '131124100000', '131124000000');
INSERT INTO `t_s_town` VALUES ('2916', '大尹村镇', '131124101000', '131124000000');
INSERT INTO `t_s_town` VALUES ('2917', '五公镇', '131124102000', '131124000000');
INSERT INTO `t_s_town` VALUES ('2918', '大官亭镇', '131124103000', '131124000000');
INSERT INTO `t_s_town` VALUES ('2919', '王同岳镇', '131124104000', '131124000000');
INSERT INTO `t_s_town` VALUES ('2920', '留楚乡', '131124202000', '131124000000');
INSERT INTO `t_s_town` VALUES ('2921', '东里满乡', '131124203000', '131124000000');
INSERT INTO `t_s_town` VALUES ('2922', '安平镇', '131125100000', '131125000000');
INSERT INTO `t_s_town` VALUES ('2923', '马店镇', '131125101000', '131125000000');
INSERT INTO `t_s_town` VALUES ('2924', '南王庄镇', '131125102000', '131125000000');
INSERT INTO `t_s_town` VALUES ('2925', '大子文镇', '131125103000', '131125000000');
INSERT INTO `t_s_town` VALUES ('2926', '东黄城镇', '131125104000', '131125000000');
INSERT INTO `t_s_town` VALUES ('2927', '大何庄乡', '131125200000', '131125000000');
INSERT INTO `t_s_town` VALUES ('2928', '程油子乡', '131125201000', '131125000000');
INSERT INTO `t_s_town` VALUES ('2929', '西两洼乡', '131125202000', '131125000000');
INSERT INTO `t_s_town` VALUES ('2930', '河北丝网工业园区', '131125400000', '131125000000');
INSERT INTO `t_s_town` VALUES ('2931', '郑口镇', '131126100000', '131126000000');
INSERT INTO `t_s_town` VALUES ('2932', '夏庄镇', '131126101000', '131126000000');
INSERT INTO `t_s_town` VALUES ('2933', '青罕镇', '131126102000', '131126000000');
INSERT INTO `t_s_town` VALUES ('2934', '故城镇', '131126103000', '131126000000');
INSERT INTO `t_s_town` VALUES ('2935', '武官寨镇', '131126104000', '131126000000');
INSERT INTO `t_s_town` VALUES ('2936', '饶阳店镇', '131126105000', '131126000000');
INSERT INTO `t_s_town` VALUES ('2937', '军屯镇', '131126106000', '131126000000');
INSERT INTO `t_s_town` VALUES ('2938', '建国镇', '131126107000', '131126000000');
INSERT INTO `t_s_town` VALUES ('2939', '西半屯镇', '131126108000', '131126000000');
INSERT INTO `t_s_town` VALUES ('2940', '房庄镇', '131126109000', '131126000000');
INSERT INTO `t_s_town` VALUES ('2941', '三朗镇', '131126110000', '131126000000');
INSERT INTO `t_s_town` VALUES ('2942', '辛庄乡', '131126200000', '131126000000');
INSERT INTO `t_s_town` VALUES ('2943', '里老乡', '131126201000', '131126000000');
INSERT INTO `t_s_town` VALUES ('2944', '景州镇', '131127100000', '131127000000');
INSERT INTO `t_s_town` VALUES ('2945', '龙华镇', '131127101000', '131127000000');
INSERT INTO `t_s_town` VALUES ('2946', '广川镇', '131127102000', '131127000000');
INSERT INTO `t_s_town` VALUES ('2947', '王瞳镇', '131127103000', '131127000000');
INSERT INTO `t_s_town` VALUES ('2948', '洚河流镇', '131127104000', '131127000000');
INSERT INTO `t_s_town` VALUES ('2949', '安陵镇', '131127105000', '131127000000');
INSERT INTO `t_s_town` VALUES ('2950', '杜桥镇', '131127106000', '131127000000');
INSERT INTO `t_s_town` VALUES ('2951', '王谦寺镇', '131127107000', '131127000000');
INSERT INTO `t_s_town` VALUES ('2952', '北留智镇', '131127108000', '131127000000');
INSERT INTO `t_s_town` VALUES ('2953', '留智庙镇', '131127109000', '131127000000');
INSERT INTO `t_s_town` VALUES ('2954', '梁集镇', '131127110000', '131127000000');
INSERT INTO `t_s_town` VALUES ('2955', '刘集乡', '131127200000', '131127000000');
INSERT INTO `t_s_town` VALUES ('2956', '连镇乡', '131127201000', '131127000000');
INSERT INTO `t_s_town` VALUES ('2957', '温城乡', '131127203000', '131127000000');
INSERT INTO `t_s_town` VALUES ('2958', '后留名府乡', '131127204000', '131127000000');
INSERT INTO `t_s_town` VALUES ('2959', '青兰乡', '131127205000', '131127000000');
INSERT INTO `t_s_town` VALUES ('2960', '河北景县高新技术产业开发区', '131127400000', '131127000000');
INSERT INTO `t_s_town` VALUES ('2961', '阜城镇', '131128100000', '131128000000');
INSERT INTO `t_s_town` VALUES ('2962', '古城镇', '131128101000', '131128000000');
INSERT INTO `t_s_town` VALUES ('2963', '码头镇', '131128102000', '131128000000');
INSERT INTO `t_s_town` VALUES ('2964', '霞口镇', '131128103000', '131128000000');
INSERT INTO `t_s_town` VALUES ('2965', '崔家庙镇', '131128104000', '131128000000');
INSERT INTO `t_s_town` VALUES ('2966', '漫河镇', '131128105000', '131128000000');
INSERT INTO `t_s_town` VALUES ('2967', '建桥乡', '131128201000', '131128000000');
INSERT INTO `t_s_town` VALUES ('2968', '蒋坊乡', '131128202000', '131128000000');
INSERT INTO `t_s_town` VALUES ('2969', '大白乡', '131128203000', '131128000000');
INSERT INTO `t_s_town` VALUES ('2970', '王集乡', '131128204000', '131128000000');
INSERT INTO `t_s_town` VALUES ('2971', '大麻森乡', '131171201000', '131171000000');
INSERT INTO `t_s_town` VALUES ('2972', '衡水高新技术产业开发区', '131171400000', '131171000000');
INSERT INTO `t_s_town` VALUES ('2973', '新型功能材料产业园', '131171401000', '131171000000');
INSERT INTO `t_s_town` VALUES ('2974', '苏正办事处', '131171402000', '131171000000');
INSERT INTO `t_s_town` VALUES ('2975', '魏家屯镇', '131172101000', '131172000000');
INSERT INTO `t_s_town` VALUES ('2976', '彭杜村乡', '131172203000', '131172000000');
INSERT INTO `t_s_town` VALUES ('2977', '滨湖新区教育园区', '131172401000', '131172000000');
INSERT INTO `t_s_town` VALUES ('2978', '唐奉镇', '131182100000', '131182000000');
INSERT INTO `t_s_town` VALUES ('2979', '深州镇', '131182101000', '131182000000');
INSERT INTO `t_s_town` VALUES ('2980', '辰时镇', '131182102000', '131182000000');
INSERT INTO `t_s_town` VALUES ('2981', '榆科镇', '131182103000', '131182000000');
INSERT INTO `t_s_town` VALUES ('2982', '魏家桥镇', '131182104000', '131182000000');
INSERT INTO `t_s_town` VALUES ('2983', '大堤镇', '131182105000', '131182000000');
INSERT INTO `t_s_town` VALUES ('2984', '前磨头镇', '131182106000', '131182000000');
INSERT INTO `t_s_town` VALUES ('2985', '王家井镇', '131182107000', '131182000000');
INSERT INTO `t_s_town` VALUES ('2986', '护驾迟镇', '131182108000', '131182000000');
INSERT INTO `t_s_town` VALUES ('2987', '大屯镇', '131182109000', '131182000000');
INSERT INTO `t_s_town` VALUES ('2988', '高古庄镇', '131182110000', '131182000000');
INSERT INTO `t_s_town` VALUES ('2989', '兵曹乡', '131182200000', '131182000000');
INSERT INTO `t_s_town` VALUES ('2990', '穆村乡', '131182201000', '131182000000');
INSERT INTO `t_s_town` VALUES ('2991', '东安庄乡', '131182202000', '131182000000');
INSERT INTO `t_s_town` VALUES ('2992', '北溪村乡', '131182203000', '131182000000');
INSERT INTO `t_s_town` VALUES ('2993', '大冯营乡', '131182204000', '131182000000');
INSERT INTO `t_s_town` VALUES ('2994', '乔屯乡', '131182206000', '131182000000');
INSERT INTO `t_s_town` VALUES ('2995', '河北省深州监狱', '131182400000', '131182000000');
INSERT INTO `t_s_town` VALUES ('2996', '深州市城市新区管理委员会', '131182401000', '131182000000');
INSERT INTO `t_s_town` VALUES ('2997', '经济开发区', '131182403000', '131182000000');
INSERT INTO `t_s_town` VALUES ('2998', '坞城街道办事处', '140105001000', '140105000000');
INSERT INTO `t_s_town` VALUES ('2999', '营盘街道办事处', '140105002000', '140105000000');
INSERT INTO `t_s_town` VALUES ('3000', '北营街道办事处', '140105003000', '140105000000');
INSERT INTO `t_s_town` VALUES ('3001', '平阳路街道办事处', '140105004000', '140105000000');
INSERT INTO `t_s_town` VALUES ('3002', '黄陵街道办事处', '140105005000', '140105000000');
INSERT INTO `t_s_town` VALUES ('3003', '小店街道办事处', '140105006000', '140105000000');
INSERT INTO `t_s_town` VALUES ('3004', '龙城街道办事处', '140105007000', '140105000000');
INSERT INTO `t_s_town` VALUES ('3005', '北格镇', '140105100000', '140105000000');
INSERT INTO `t_s_town` VALUES ('3006', '西温庄乡', '140105200000', '140105000000');
INSERT INTO `t_s_town` VALUES ('3007', '刘家堡乡', '140105201000', '140105000000');
INSERT INTO `t_s_town` VALUES ('3008', '柳巷街道办事处', '140106001000', '140106000000');
INSERT INTO `t_s_town` VALUES ('3009', '文庙街道办事处', '140106002000', '140106000000');
INSERT INTO `t_s_town` VALUES ('3010', '庙前街道办事处', '140106003000', '140106000000');
INSERT INTO `t_s_town` VALUES ('3011', '迎泽街道办事处', '140106004000', '140106000000');
INSERT INTO `t_s_town` VALUES ('3012', '桥东街道办事处', '140106005000', '140106000000');
INSERT INTO `t_s_town` VALUES ('3013', '老军营街道办事处', '140106006000', '140106000000');
INSERT INTO `t_s_town` VALUES ('3014', '郝庄镇', '140106100000', '140106000000');
INSERT INTO `t_s_town` VALUES ('3015', '巨轮街道办事处', '140107001000', '140107000000');
INSERT INTO `t_s_town` VALUES ('3016', '三桥街道办事处', '140107002000', '140107000000');
INSERT INTO `t_s_town` VALUES ('3017', '鼓楼街道办事处', '140107003000', '140107000000');
INSERT INTO `t_s_town` VALUES ('3018', '杏花岭街道办事处', '140107004000', '140107000000');
INSERT INTO `t_s_town` VALUES ('3019', '坝陵桥街道办事处', '140107005000', '140107000000');
INSERT INTO `t_s_town` VALUES ('3020', '大东关街道办事处', '140107006000', '140107000000');
INSERT INTO `t_s_town` VALUES ('3021', '职工新街街道办事处', '140107007000', '140107000000');
INSERT INTO `t_s_town` VALUES ('3022', '敦化坊街道办事处', '140107008000', '140107000000');
INSERT INTO `t_s_town` VALUES ('3023', '涧河街道办事处', '140107009000', '140107000000');
INSERT INTO `t_s_town` VALUES ('3024', '杨家峪街道办事处', '140107010000', '140107000000');
INSERT INTO `t_s_town` VALUES ('3025', '中涧河乡', '140107200000', '140107000000');
INSERT INTO `t_s_town` VALUES ('3026', '小返乡', '140107201000', '140107000000');
INSERT INTO `t_s_town` VALUES ('3027', '尖草坪街道办事处', '140108001000', '140108000000');
INSERT INTO `t_s_town` VALUES ('3028', '光社街道办事处', '140108002000', '140108000000');
INSERT INTO `t_s_town` VALUES ('3029', '上兰街道办事处', '140108003000', '140108000000');
INSERT INTO `t_s_town` VALUES ('3030', '南寨街道办事处', '140108004000', '140108000000');
INSERT INTO `t_s_town` VALUES ('3031', '迎新街道办事处', '140108005000', '140108000000');
INSERT INTO `t_s_town` VALUES ('3032', '古城街道办事处', '140108006000', '140108000000');
INSERT INTO `t_s_town` VALUES ('3033', '汇丰街道办事处', '140108007000', '140108000000');
INSERT INTO `t_s_town` VALUES ('3034', '柴村街道办事处', '140108008000', '140108000000');
INSERT INTO `t_s_town` VALUES ('3035', '新城街道办事处', '140108009000', '140108000000');
INSERT INTO `t_s_town` VALUES ('3036', '向阳镇', '140108100000', '140108000000');
INSERT INTO `t_s_town` VALUES ('3037', '阳曲镇', '140108101000', '140108000000');
INSERT INTO `t_s_town` VALUES ('3038', '马头水乡', '140108200000', '140108000000');
INSERT INTO `t_s_town` VALUES ('3039', '柏板乡', '140108201000', '140108000000');
INSERT INTO `t_s_town` VALUES ('3040', '西焉乡', '140108202000', '140108000000');
INSERT INTO `t_s_town` VALUES ('3041', '千峰街道办事处', '140109001000', '140109000000');
INSERT INTO `t_s_town` VALUES ('3042', '下元街道办事处', '140109002000', '140109000000');
INSERT INTO `t_s_town` VALUES ('3043', '和平街道办事处', '140109003000', '140109000000');
INSERT INTO `t_s_town` VALUES ('3044', '兴华街道办事处', '140109004000', '140109000000');
INSERT INTO `t_s_town` VALUES ('3045', '万柏林街道办事处', '140109005000', '140109000000');
INSERT INTO `t_s_town` VALUES ('3046', '杜儿坪街道办事处', '140109006000', '140109000000');
INSERT INTO `t_s_town` VALUES ('3047', '白家庄街道办事处', '140109007000', '140109000000');
INSERT INTO `t_s_town` VALUES ('3048', '南寒街道办事处', '140109008000', '140109000000');
INSERT INTO `t_s_town` VALUES ('3049', '东社街道办事处', '140109009000', '140109000000');
INSERT INTO `t_s_town` VALUES ('3050', '化客头街道办事处', '140109010000', '140109000000');
INSERT INTO `t_s_town` VALUES ('3051', '小井峪街道办事处', '140109011000', '140109000000');
INSERT INTO `t_s_town` VALUES ('3052', '西铭街道办事处', '140109012000', '140109000000');
INSERT INTO `t_s_town` VALUES ('3053', '长风西街街道办事处', '140109013000', '140109000000');
INSERT INTO `t_s_town` VALUES ('3054', '神堂沟街道办事处', '140109014000', '140109000000');
INSERT INTO `t_s_town` VALUES ('3055', '王封乡', '140109200000', '140109000000');
INSERT INTO `t_s_town` VALUES ('3056', '义井街道办事处', '140110001000', '140110000000');
INSERT INTO `t_s_town` VALUES ('3057', '罗城街道办事处', '140110002000', '140110000000');
INSERT INTO `t_s_town` VALUES ('3058', '晋源街道办事处', '140110003000', '140110000000');
INSERT INTO `t_s_town` VALUES ('3059', '金胜镇', '140110100000', '140110000000');
INSERT INTO `t_s_town` VALUES ('3060', '晋祠镇', '140110101000', '140110000000');
INSERT INTO `t_s_town` VALUES ('3061', '姚村镇', '140110102000', '140110000000');
INSERT INTO `t_s_town` VALUES ('3062', '清源镇', '140121100000', '140121000000');
INSERT INTO `t_s_town` VALUES ('3063', '徐沟镇', '140121101000', '140121000000');
INSERT INTO `t_s_town` VALUES ('3064', '东于镇', '140121102000', '140121000000');
INSERT INTO `t_s_town` VALUES ('3065', '孟封镇', '140121103000', '140121000000');
INSERT INTO `t_s_town` VALUES ('3066', '马峪乡', '140121200000', '140121000000');
INSERT INTO `t_s_town` VALUES ('3067', '柳杜乡', '140121201000', '140121000000');
INSERT INTO `t_s_town` VALUES ('3068', '西谷乡', '140121202000', '140121000000');
INSERT INTO `t_s_town` VALUES ('3069', '王答乡', '140121203000', '140121000000');
INSERT INTO `t_s_town` VALUES ('3070', '集义乡', '140121204000', '140121000000');
INSERT INTO `t_s_town` VALUES ('3071', '黄寨镇', '140122100000', '140122000000');
INSERT INTO `t_s_town` VALUES ('3072', '大盂镇', '140122101000', '140122000000');
INSERT INTO `t_s_town` VALUES ('3073', '东黄水镇', '140122102000', '140122000000');
INSERT INTO `t_s_town` VALUES ('3074', '泥屯镇', '140122103000', '140122000000');
INSERT INTO `t_s_town` VALUES ('3075', '中心镇建设管理办公室', '140122104000', '140122000000');
INSERT INTO `t_s_town` VALUES ('3076', '高村乡', '140122200000', '140122000000');
INSERT INTO `t_s_town` VALUES ('3077', '侯村乡', '140122201000', '140122000000');
INSERT INTO `t_s_town` VALUES ('3078', '凌井店乡', '140122202000', '140122000000');
INSERT INTO `t_s_town` VALUES ('3079', '西凌井乡', '140122203000', '140122000000');
INSERT INTO `t_s_town` VALUES ('3080', '北小店乡', '140122204000', '140122000000');
INSERT INTO `t_s_town` VALUES ('3081', '杨兴乡', '140122205000', '140122000000');
INSERT INTO `t_s_town` VALUES ('3082', '娄烦镇', '140123100000', '140123000000');
INSERT INTO `t_s_town` VALUES ('3083', '静游镇', '140123101000', '140123000000');
INSERT INTO `t_s_town` VALUES ('3084', '杜交曲镇', '140123102000', '140123000000');
INSERT INTO `t_s_town` VALUES ('3085', '庙湾乡', '140123200000', '140123000000');
INSERT INTO `t_s_town` VALUES ('3086', '马家庄乡', '140123201000', '140123000000');
INSERT INTO `t_s_town` VALUES ('3087', '盖家庄乡', '140123202000', '140123000000');
INSERT INTO `t_s_town` VALUES ('3088', '米峪镇乡', '140123203000', '140123000000');
INSERT INTO `t_s_town` VALUES ('3089', '天池店乡', '140123204000', '140123000000');
INSERT INTO `t_s_town` VALUES ('3090', '唐槐园区街道办事处', '140171401000', '140171000000');
INSERT INTO `t_s_town` VALUES ('3091', '学府园区街道办事处', '140171402000', '140171000000');
INSERT INTO `t_s_town` VALUES ('3092', '阳曲产业园区街道办事处', '140171403000', '140171000000');
INSERT INTO `t_s_town` VALUES ('3093', '潇河园区街道办事处', '140171404000', '140171000000');
INSERT INTO `t_s_town` VALUES ('3094', '科创城街道办事处', '140171405000', '140171000000');
INSERT INTO `t_s_town` VALUES ('3095', '东曲街道办事处', '140181001000', '140181000000');
INSERT INTO `t_s_town` VALUES ('3096', '西曲街道办事处', '140181002000', '140181000000');
INSERT INTO `t_s_town` VALUES ('3097', '桃园街道办事处', '140181003000', '140181000000');
INSERT INTO `t_s_town` VALUES ('3098', '屯兰街道办事处', '140181004000', '140181000000');
INSERT INTO `t_s_town` VALUES ('3099', '河口镇', '140181100000', '140181000000');
INSERT INTO `t_s_town` VALUES ('3100', '镇城底镇', '140181101000', '140181000000');
INSERT INTO `t_s_town` VALUES ('3101', '马兰镇', '140181102000', '140181000000');
INSERT INTO `t_s_town` VALUES ('3102', '阁上乡', '140181200000', '140181000000');
INSERT INTO `t_s_town` VALUES ('3103', '加乐泉乡', '140181201000', '140181000000');
INSERT INTO `t_s_town` VALUES ('3104', '梭峪乡', '140181202000', '140181000000');
INSERT INTO `t_s_town` VALUES ('3105', '岔口乡', '140181203000', '140181000000');
INSERT INTO `t_s_town` VALUES ('3106', '常安乡', '140181204000', '140181000000');
INSERT INTO `t_s_town` VALUES ('3107', '原相乡', '140181205000', '140181000000');
INSERT INTO `t_s_town` VALUES ('3108', '邢家社乡', '140181206000', '140181000000');
INSERT INTO `t_s_town` VALUES ('3109', '新荣镇', '140212100000', '140212000000');
INSERT INTO `t_s_town` VALUES ('3110', '古店镇', '140212101000', '140212000000');
INSERT INTO `t_s_town` VALUES ('3111', '破鲁堡乡', '140212200000', '140212000000');
INSERT INTO `t_s_town` VALUES ('3112', '郭家窑乡', '140212202000', '140212000000');
INSERT INTO `t_s_town` VALUES ('3113', '花元屯乡', '140212203000', '140212000000');
INSERT INTO `t_s_town` VALUES ('3114', '西村乡', '140212206000', '140212000000');
INSERT INTO `t_s_town` VALUES ('3115', '上深涧乡', '140212207000', '140212000000');
INSERT INTO `t_s_town` VALUES ('3116', '堡子湾乡', '140212209000', '140212000000');
INSERT INTO `t_s_town` VALUES ('3117', '新荣区街道管理中心', '140212400000', '140212000000');
INSERT INTO `t_s_town` VALUES ('3118', '南关街道办事处', '140213001000', '140213000000');
INSERT INTO `t_s_town` VALUES ('3119', '北关街道办事处', '140213002000', '140213000000');
INSERT INTO `t_s_town` VALUES ('3120', '东街街道办事处', '140213003000', '140213000000');
INSERT INTO `t_s_town` VALUES ('3121', '西街街道办事处', '140213004000', '140213000000');
INSERT INTO `t_s_town` VALUES ('3122', '南街街道办事处', '140213005000', '140213000000');
INSERT INTO `t_s_town` VALUES ('3123', '北街街道办事处', '140213006000', '140213000000');
INSERT INTO `t_s_town` VALUES ('3124', '新建南路街道办事处', '140213007000', '140213000000');
INSERT INTO `t_s_town` VALUES ('3125', '新建北路街道办事处', '140213008000', '140213000000');
INSERT INTO `t_s_town` VALUES ('3126', '大庆路街道办事处', '140213009000', '140213000000');
INSERT INTO `t_s_town` VALUES ('3127', '新华街街道办事处', '140213010000', '140213000000');
INSERT INTO `t_s_town` VALUES ('3128', '向阳里街道办事处', '140213011000', '140213000000');
INSERT INTO `t_s_town` VALUES ('3129', '振华南街街道办事处', '140213012000', '140213000000');
INSERT INTO `t_s_town` VALUES ('3130', '开源街街道办事处', '140213013000', '140213000000');
INSERT INTO `t_s_town` VALUES ('3131', '新旺乡', '140213201000', '140213000000');
INSERT INTO `t_s_town` VALUES ('3132', '水泊寺乡', '140213202000', '140213000000');
INSERT INTO `t_s_town` VALUES ('3133', '马军营乡', '140213203000', '140213000000');
INSERT INTO `t_s_town` VALUES ('3134', '新胜街道办事处', '140214001000', '140214000000');
INSERT INTO `t_s_town` VALUES ('3135', '新平旺街道办事处', '140214002000', '140214000000');
INSERT INTO `t_s_town` VALUES ('3136', '煤峪口街道办事处', '140214003000', '140214000000');
INSERT INTO `t_s_town` VALUES ('3137', '永定庄街道办事处', '140214004000', '140214000000');
INSERT INTO `t_s_town` VALUES ('3138', '同家梁街道办事处', '140214005000', '140214000000');
INSERT INTO `t_s_town` VALUES ('3139', '四老沟街道办事处', '140214006000', '140214000000');
INSERT INTO `t_s_town` VALUES ('3140', '忻州窑街道办事处', '140214007000', '140214000000');
INSERT INTO `t_s_town` VALUES ('3141', '白洞街道办事处', '140214008000', '140214000000');
INSERT INTO `t_s_town` VALUES ('3142', '雁崖街道办事处', '140214009000', '140214000000');
INSERT INTO `t_s_town` VALUES ('3143', '挖金湾街道办事处', '140214010000', '140214000000');
INSERT INTO `t_s_town` VALUES ('3144', '晋华宫街道办事处', '140214011000', '140214000000');
INSERT INTO `t_s_town` VALUES ('3145', '马脊梁街道办事处', '140214012000', '140214000000');
INSERT INTO `t_s_town` VALUES ('3146', '大斗沟街道办事处', '140214013000', '140214000000');
INSERT INTO `t_s_town` VALUES ('3147', '王村街道办事处', '140214014000', '140214000000');
INSERT INTO `t_s_town` VALUES ('3148', '姜家湾街道办事处', '140214015000', '140214000000');
INSERT INTO `t_s_town` VALUES ('3149', '新泉路街道办事处', '140214016000', '140214000000');
INSERT INTO `t_s_town` VALUES ('3150', '民胜街道办事处', '140214017000', '140214000000');
INSERT INTO `t_s_town` VALUES ('3151', '口泉街道办事处', '140214018000', '140214000000');
INSERT INTO `t_s_town` VALUES ('3152', '马口街道办事处', '140214019000', '140214000000');
INSERT INTO `t_s_town` VALUES ('3153', '燕子山街道办事处', '140214020000', '140214000000');
INSERT INTO `t_s_town` VALUES ('3154', '杏儿沟街道办事处', '140214021000', '140214000000');
INSERT INTO `t_s_town` VALUES ('3155', '青磁窑街道办事处', '140214022000', '140214000000');
INSERT INTO `t_s_town` VALUES ('3156', '平泉路街道办事处', '140214023000', '140214000000');
INSERT INTO `t_s_town` VALUES ('3157', '四台沟街道办事处', '140214024000', '140214000000');
INSERT INTO `t_s_town` VALUES ('3158', '和顺街道办事处', '140214025000', '140214000000');
INSERT INTO `t_s_town` VALUES ('3159', '和瑞街道办事处', '140214026000', '140214000000');
INSERT INTO `t_s_town` VALUES ('3160', '平盛路街道办事处', '140214027000', '140214000000');
INSERT INTO `t_s_town` VALUES ('3161', '清泉街街道办事处', '140214028000', '140214000000');
INSERT INTO `t_s_town` VALUES ('3162', '西花园街道办事处', '140214029000', '140214000000');
INSERT INTO `t_s_town` VALUES ('3163', '老平旺街道办事处', '140214030000', '140214000000');
INSERT INTO `t_s_town` VALUES ('3164', '高山镇', '140214101000', '140214000000');
INSERT INTO `t_s_town` VALUES ('3165', '云冈镇', '140214102000', '140214000000');
INSERT INTO `t_s_town` VALUES ('3166', '口泉乡', '140214200000', '140214000000');
INSERT INTO `t_s_town` VALUES ('3167', '西韩岭乡', '140214206000', '140214000000');
INSERT INTO `t_s_town` VALUES ('3168', '平旺乡', '140214207000', '140214000000');
INSERT INTO `t_s_town` VALUES ('3169', '鸦儿崖乡', '140214210000', '140214000000');
INSERT INTO `t_s_town` VALUES ('3170', '西坪镇', '140215100000', '140215000000');
INSERT INTO `t_s_town` VALUES ('3171', '倍加造镇', '140215101000', '140215000000');
INSERT INTO `t_s_town` VALUES ('3172', '周士庄镇', '140215102000', '140215000000');
INSERT INTO `t_s_town` VALUES ('3173', '吉家庄乡', '140215201000', '140215000000');
INSERT INTO `t_s_town` VALUES ('3174', '峰峪乡', '140215202000', '140215000000');
INSERT INTO `t_s_town` VALUES ('3175', '杜庄乡', '140215204000', '140215000000');
INSERT INTO `t_s_town` VALUES ('3176', '党留庄乡', '140215205000', '140215000000');
INSERT INTO `t_s_town` VALUES ('3177', '瓜园乡', '140215207000', '140215000000');
INSERT INTO `t_s_town` VALUES ('3178', '聚乐乡', '140215209000', '140215000000');
INSERT INTO `t_s_town` VALUES ('3179', '许堡乡', '140215211000', '140215000000');
INSERT INTO `t_s_town` VALUES ('3180', '湖东办事处', '140215401000', '140215000000');
INSERT INTO `t_s_town` VALUES ('3181', '东街办事处', '140215402000', '140215000000');
INSERT INTO `t_s_town` VALUES ('3182', '西街办事处', '140215403000', '140215000000');
INSERT INTO `t_s_town` VALUES ('3183', '龙泉镇', '140221100000', '140221000000');
INSERT INTO `t_s_town` VALUES ('3184', '罗文皂镇', '140221101000', '140221000000');
INSERT INTO `t_s_town` VALUES ('3185', '大白登镇', '140221102000', '140221000000');
INSERT INTO `t_s_town` VALUES ('3186', '王官屯镇', '140221103000', '140221000000');
INSERT INTO `t_s_town` VALUES ('3187', '古城镇', '140221104000', '140221000000');
INSERT INTO `t_s_town` VALUES ('3188', '东小村镇', '140221105000', '140221000000');
INSERT INTO `t_s_town` VALUES ('3189', '友宰镇', '140221106000', '140221000000');
INSERT INTO `t_s_town` VALUES ('3190', '长城乡', '140221201000', '140221000000');
INSERT INTO `t_s_town` VALUES ('3191', '北徐屯乡', '140221202000', '140221000000');
INSERT INTO `t_s_town` VALUES ('3192', '狮子屯乡', '140221204000', '140221000000');
INSERT INTO `t_s_town` VALUES ('3193', '下深井乡', '140221209000', '140221000000');
INSERT INTO `t_s_town` VALUES ('3194', '鳌石乡', '140221212000', '140221000000');
INSERT INTO `t_s_town` VALUES ('3195', '玉泉镇', '140222100000', '140222000000');
INSERT INTO `t_s_town` VALUES ('3196', '谷前堡镇', '140222101000', '140222000000');
INSERT INTO `t_s_town` VALUES ('3197', '米薪关镇', '140222102000', '140222000000');
INSERT INTO `t_s_town` VALUES ('3198', '逯家湾镇', '140222103000', '140222000000');
INSERT INTO `t_s_town` VALUES ('3199', '新平堡镇', '140222104000', '140222000000');
INSERT INTO `t_s_town` VALUES ('3200', '卅里铺乡', '140222200000', '140222000000');
INSERT INTO `t_s_town` VALUES ('3201', '南河堡乡', '140222202000', '140222000000');
INSERT INTO `t_s_town` VALUES ('3202', '贾家屯乡', '140222204000', '140222000000');
INSERT INTO `t_s_town` VALUES ('3203', '赵家沟乡', '140222206000', '140222000000');
INSERT INTO `t_s_town` VALUES ('3204', '南高崖乡', '140222208000', '140222000000');
INSERT INTO `t_s_town` VALUES ('3205', '张西河乡', '140222209000', '140222000000');
INSERT INTO `t_s_town` VALUES ('3206', '马家皂乡', '140222210000', '140222000000');
INSERT INTO `t_s_town` VALUES ('3207', '壶泉镇', '140223100000', '140223000000');
INSERT INTO `t_s_town` VALUES ('3208', '南村镇', '140223101000', '140223000000');
INSERT INTO `t_s_town` VALUES ('3209', '一斗泉乡', '140223200000', '140223000000');
INSERT INTO `t_s_town` VALUES ('3210', '蕉山乡', '140223202000', '140223000000');
INSERT INTO `t_s_town` VALUES ('3211', '加斗乡', '140223203000', '140223000000');
INSERT INTO `t_s_town` VALUES ('3212', '宜兴乡', '140223206000', '140223000000');
INSERT INTO `t_s_town` VALUES ('3213', '作疃乡', '140223207000', '140223000000');
INSERT INTO `t_s_town` VALUES ('3214', '梁庄乡', '140223209000', '140223000000');
INSERT INTO `t_s_town` VALUES ('3215', '望狐乡', '140223211000', '140223000000');
INSERT INTO `t_s_town` VALUES ('3216', '武灵镇', '140224100000', '140224000000');
INSERT INTO `t_s_town` VALUES ('3217', '东河南镇', '140224101000', '140224000000');
INSERT INTO `t_s_town` VALUES ('3218', '上寨镇', '140224102000', '140224000000');
INSERT INTO `t_s_town` VALUES ('3219', '落水河乡', '140224200000', '140224000000');
INSERT INTO `t_s_town` VALUES ('3220', '史庄乡', '140224203000', '140224000000');
INSERT INTO `t_s_town` VALUES ('3221', '赵北乡', '140224205000', '140224000000');
INSERT INTO `t_s_town` VALUES ('3222', '石家田乡', '140224206000', '140224000000');
INSERT INTO `t_s_town` VALUES ('3223', '柳科乡', '140224207000', '140224000000');
INSERT INTO `t_s_town` VALUES ('3224', '白崖台乡', '140224208000', '140224000000');
INSERT INTO `t_s_town` VALUES ('3225', '红石塄乡', '140224210000', '140224000000');
INSERT INTO `t_s_town` VALUES ('3226', '下关乡', '140224212000', '140224000000');
INSERT INTO `t_s_town` VALUES ('3227', '独峪乡', '140224213000', '140224000000');
INSERT INTO `t_s_town` VALUES ('3228', '永安镇', '140225100000', '140225000000');
INSERT INTO `t_s_town` VALUES ('3229', '西坊城镇', '140225101000', '140225000000');
INSERT INTO `t_s_town` VALUES ('3230', '蔡村镇', '140225102000', '140225000000');
INSERT INTO `t_s_town` VALUES ('3231', '沙圪坨镇', '140225103000', '140225000000');
INSERT INTO `t_s_town` VALUES ('3232', '王庄堡镇', '140225104000', '140225000000');
INSERT INTO `t_s_town` VALUES ('3233', '大磁窑镇', '140225105000', '140225000000');
INSERT INTO `t_s_town` VALUES ('3234', '东坊城乡', '140225201000', '140225000000');
INSERT INTO `t_s_town` VALUES ('3235', '裴村乡', '140225203000', '140225000000');
INSERT INTO `t_s_town` VALUES ('3236', '驼峰乡', '140225204000', '140225000000');
INSERT INTO `t_s_town` VALUES ('3237', '西留村乡', '140225205000', '140225000000');
INSERT INTO `t_s_town` VALUES ('3238', '下韩村乡', '140225206000', '140225000000');
INSERT INTO `t_s_town` VALUES ('3239', '南榆林乡', '140225208000', '140225000000');
INSERT INTO `t_s_town` VALUES ('3240', '吴城乡', '140225210000', '140225000000');
INSERT INTO `t_s_town` VALUES ('3241', '黄花滩乡', '140225212000', '140225000000');
INSERT INTO `t_s_town` VALUES ('3242', '大仁庄乡', '140225213000', '140225000000');
INSERT INTO `t_s_town` VALUES ('3243', '千佛岭乡', '140225215000', '140225000000');
INSERT INTO `t_s_town` VALUES ('3244', '官儿乡', '140225218000', '140225000000');
INSERT INTO `t_s_town` VALUES ('3245', '青磁窑乡', '140225220000', '140225000000');
INSERT INTO `t_s_town` VALUES ('3246', '云兴镇', '140226100000', '140226000000');
INSERT INTO `t_s_town` VALUES ('3247', '鹊儿山镇', '140226101000', '140226000000');
INSERT INTO `t_s_town` VALUES ('3248', '店湾镇', '140226102000', '140226000000');
INSERT INTO `t_s_town` VALUES ('3249', '管家堡乡', '140226200000', '140226000000');
INSERT INTO `t_s_town` VALUES ('3250', '张家场乡', '140226201000', '140226000000');
INSERT INTO `t_s_town` VALUES ('3251', '三屯乡', '140226205000', '140226000000');
INSERT INTO `t_s_town` VALUES ('3252', '马道头乡', '140226206000', '140226000000');
INSERT INTO `t_s_town` VALUES ('3253', '小京庄乡', '140226207000', '140226000000');
INSERT INTO `t_s_town` VALUES ('3254', '水窑乡', '140226209000', '140226000000');
INSERT INTO `t_s_town` VALUES ('3255', '经济技术开发区乡级单位', '140271400000', '140271000000');
INSERT INTO `t_s_town` VALUES ('3256', '上站街道办事处', '140302001000', '140302000000');
INSERT INTO `t_s_town` VALUES ('3257', '下站街道办事处', '140302002000', '140302000000');
INSERT INTO `t_s_town` VALUES ('3258', '北大街街道办事处', '140302003000', '140302000000');
INSERT INTO `t_s_town` VALUES ('3259', '南山路街道办事处', '140302004000', '140302000000');
INSERT INTO `t_s_town` VALUES ('3260', '义井街道办事处', '140302005000', '140302000000');
INSERT INTO `t_s_town` VALUES ('3261', '坡底街道办事处', '140302006000', '140302000000');
INSERT INTO `t_s_town` VALUES ('3262', '义井镇', '140302100000', '140302000000');
INSERT INTO `t_s_town` VALUES ('3263', '平潭街街道办事处', '140303001000', '140303000000');
INSERT INTO `t_s_town` VALUES ('3264', '蔡洼街道办事处', '140303003000', '140303000000');
INSERT INTO `t_s_town` VALUES ('3265', '赛鱼街道办事处', '140303004000', '140303000000');
INSERT INTO `t_s_town` VALUES ('3266', '沙坪街道办事处', '140303005000', '140303000000');
INSERT INTO `t_s_town` VALUES ('3267', '贵石沟街道办事处', '140303006000', '140303000000');
INSERT INTO `t_s_town` VALUES ('3268', '桥头街道办事处', '140303007000', '140303000000');
INSERT INTO `t_s_town` VALUES ('3269', '荫营镇', '140311100000', '140311000000');
INSERT INTO `t_s_town` VALUES ('3270', '河底镇', '140311101000', '140311000000');
INSERT INTO `t_s_town` VALUES ('3271', '平坦镇', '140311103000', '140311000000');
INSERT INTO `t_s_town` VALUES ('3272', '西南舁乡', '140311200000', '140311000000');
INSERT INTO `t_s_town` VALUES ('3273', '杨家庄乡', '140311201000', '140311000000');
INSERT INTO `t_s_town` VALUES ('3274', '李家庄乡', '140311202000', '140311000000');
INSERT INTO `t_s_town` VALUES ('3275', '旧街乡', '140311203000', '140311000000');
INSERT INTO `t_s_town` VALUES ('3276', '开发区', '140311400000', '140311000000');
INSERT INTO `t_s_town` VALUES ('3277', '冠山镇', '140321100000', '140321000000');
INSERT INTO `t_s_town` VALUES ('3278', '冶西镇', '140321101000', '140321000000');
INSERT INTO `t_s_town` VALUES ('3279', '锁簧镇', '140321102000', '140321000000');
INSERT INTO `t_s_town` VALUES ('3280', '张庄镇', '140321103000', '140321000000');
INSERT INTO `t_s_town` VALUES ('3281', '东回镇', '140321104000', '140321000000');
INSERT INTO `t_s_town` VALUES ('3282', '柏井镇', '140321105000', '140321000000');
INSERT INTO `t_s_town` VALUES ('3283', '娘子关镇', '140321106000', '140321000000');
INSERT INTO `t_s_town` VALUES ('3284', '巨城镇', '140321107000', '140321000000');
INSERT INTO `t_s_town` VALUES ('3285', '石门口乡', '140321200000', '140321000000');
INSERT INTO `t_s_town` VALUES ('3286', '岔口乡', '140321201000', '140321000000');
INSERT INTO `t_s_town` VALUES ('3287', '秀水镇', '140322100000', '140322000000');
INSERT INTO `t_s_town` VALUES ('3288', '孙家庄镇', '140322101000', '140322000000');
INSERT INTO `t_s_town` VALUES ('3289', '路家村镇', '140322102000', '140322000000');
INSERT INTO `t_s_town` VALUES ('3290', '南娄镇', '140322103000', '140322000000');
INSERT INTO `t_s_town` VALUES ('3291', '牛村镇', '140322104000', '140322000000');
INSERT INTO `t_s_town` VALUES ('3292', '苌池镇', '140322105000', '140322000000');
INSERT INTO `t_s_town` VALUES ('3293', '上社镇', '140322106000', '140322000000');
INSERT INTO `t_s_town` VALUES ('3294', '西烟镇', '140322107000', '140322000000');
INSERT INTO `t_s_town` VALUES ('3295', '仙人乡', '140322200000', '140322000000');
INSERT INTO `t_s_town` VALUES ('3296', '北下庄乡', '140322201000', '140322000000');
INSERT INTO `t_s_town` VALUES ('3297', '下社乡', '140322202000', '140322000000');
INSERT INTO `t_s_town` VALUES ('3298', '梁家寨乡', '140322203000', '140322000000');
INSERT INTO `t_s_town` VALUES ('3299', '西潘乡', '140322204000', '140322000000');
INSERT INTO `t_s_town` VALUES ('3300', '东梁乡', '140322205000', '140322000000');
INSERT INTO `t_s_town` VALUES ('3301', '东街街道办事处', '140412001000', '140412000000');
INSERT INTO `t_s_town` VALUES ('3302', '西街街道办事处', '140412002000', '140412000000');
INSERT INTO `t_s_town` VALUES ('3303', '英雄南路街道办事处', '140412003000', '140412000000');
INSERT INTO `t_s_town` VALUES ('3304', '英雄中路街道办事处', '140412004000', '140412000000');
INSERT INTO `t_s_town` VALUES ('3305', '紫金街街道办事处', '140412005000', '140412000000');
INSERT INTO `t_s_town` VALUES ('3306', '太行东街街道办事处', '140412006000', '140412000000');
INSERT INTO `t_s_town` VALUES ('3307', '太行西街街道办事处', '140412007000', '140412000000');
INSERT INTO `t_s_town` VALUES ('3308', '延安南路街道办事处', '140412008000', '140412000000');
INSERT INTO `t_s_town` VALUES ('3309', '常青街道办事处', '140412009000', '140412000000');
INSERT INTO `t_s_town` VALUES ('3310', '五马街道办事处', '140412010000', '140412000000');
INSERT INTO `t_s_town` VALUES ('3311', '长北街道办事处', '140412011000', '140412000000');
INSERT INTO `t_s_town` VALUES ('3312', '故县街道办事处', '140412012000', '140412000000');
INSERT INTO `t_s_town` VALUES ('3313', '老顶山镇', '140412100000', '140412000000');
INSERT INTO `t_s_town` VALUES ('3314', '堠北庄镇', '140412101000', '140412000000');
INSERT INTO `t_s_town` VALUES ('3315', '大辛庄镇', '140412102000', '140412000000');
INSERT INTO `t_s_town` VALUES ('3316', '马厂镇', '140412103000', '140412000000');
INSERT INTO `t_s_town` VALUES ('3317', '黄碾镇', '140412104000', '140412000000');
INSERT INTO `t_s_town` VALUES ('3318', '西白兔乡', '140412200000', '140412000000');
INSERT INTO `t_s_town` VALUES ('3319', '长治市漳泽工业转型试验区管理委员会', '140412400000', '140412000000');
INSERT INTO `t_s_town` VALUES ('3320', '长治市老顶山旅游开发管理中心', '140412401000', '140412000000');
INSERT INTO `t_s_town` VALUES ('3321', '韩店镇', '140413100000', '140413000000');
INSERT INTO `t_s_town` VALUES ('3322', '苏店镇', '140413101000', '140413000000');
INSERT INTO `t_s_town` VALUES ('3323', '荫城镇', '140413102000', '140413000000');
INSERT INTO `t_s_town` VALUES ('3324', '西火镇', '140413103000', '140413000000');
INSERT INTO `t_s_town` VALUES ('3325', '八义镇', '140413104000', '140413000000');
INSERT INTO `t_s_town` VALUES ('3326', '贾掌镇', '140413105000', '140413000000');
INSERT INTO `t_s_town` VALUES ('3327', '郝家庄乡', '140413200000', '140413000000');
INSERT INTO `t_s_town` VALUES ('3328', '西池乡', '140413201000', '140413000000');
INSERT INTO `t_s_town` VALUES ('3329', '北呈乡', '140413202000', '140413000000');
INSERT INTO `t_s_town` VALUES ('3330', '东和乡', '140413203000', '140413000000');
INSERT INTO `t_s_town` VALUES ('3331', '南宋乡', '140413204000', '140413000000');
INSERT INTO `t_s_town` VALUES ('3332', '振兴新区', '140413400000', '140413000000');
INSERT INTO `t_s_town` VALUES ('3333', '上党经济技术开发区', '140413401000', '140413000000');
INSERT INTO `t_s_town` VALUES ('3334', '长治市经济技术开发区长治县部分', '140413406000', '140413000000');
INSERT INTO `t_s_town` VALUES ('3335', '信义管委会', '140413407000', '140413000000');
INSERT INTO `t_s_town` VALUES ('3336', '麟绛镇', '140414100000', '140414000000');
INSERT INTO `t_s_town` VALUES ('3337', '上村镇', '140414101000', '140414000000');
INSERT INTO `t_s_town` VALUES ('3338', '渔泽镇', '140414102000', '140414000000');
INSERT INTO `t_s_town` VALUES ('3339', '余吾镇', '140414103000', '140414000000');
INSERT INTO `t_s_town` VALUES ('3340', '吾元镇', '140414104000', '140414000000');
INSERT INTO `t_s_town` VALUES ('3341', '张店镇', '140414105000', '140414000000');
INSERT INTO `t_s_town` VALUES ('3342', '丰宜镇', '140414106000', '140414000000');
INSERT INTO `t_s_town` VALUES ('3343', '李高乡', '140414200000', '140414000000');
INSERT INTO `t_s_town` VALUES ('3344', '路村乡', '140414201000', '140414000000');
INSERT INTO `t_s_town` VALUES ('3345', '河神庙乡', '140414202000', '140414000000');
INSERT INTO `t_s_town` VALUES ('3346', '西贾乡', '140414203000', '140414000000');
INSERT INTO `t_s_town` VALUES ('3347', '西流寨开发区', '140414400000', '140414000000');
INSERT INTO `t_s_town` VALUES ('3348', '康庄工业园区', '140414401000', '140414000000');
INSERT INTO `t_s_town` VALUES ('3349', '上莲开发区', '140414402000', '140414000000');
INSERT INTO `t_s_town` VALUES ('3350', '屯留县经济技术开发区', '140414403000', '140414000000');
INSERT INTO `t_s_town` VALUES ('3351', '潞华街道办事处', '140415001000', '140415000000');
INSERT INTO `t_s_town` VALUES ('3352', '成家川街道办事处', '140415002000', '140415000000');
INSERT INTO `t_s_town` VALUES ('3353', '店上镇', '140415100000', '140415000000');
INSERT INTO `t_s_town` VALUES ('3354', '微子镇', '140415101000', '140415000000');
INSERT INTO `t_s_town` VALUES ('3355', '辛安泉镇', '140415102000', '140415000000');
INSERT INTO `t_s_town` VALUES ('3356', '翟店镇', '140415103000', '140415000000');
INSERT INTO `t_s_town` VALUES ('3357', '合室乡', '140415200000', '140415000000');
INSERT INTO `t_s_town` VALUES ('3358', '黄牛蹄乡', '140415201000', '140415000000');
INSERT INTO `t_s_town` VALUES ('3359', '史回乡', '140415202000', '140415000000');
INSERT INTO `t_s_town` VALUES ('3360', '潞城经济技术开发区', '140415400000', '140415000000');
INSERT INTO `t_s_town` VALUES ('3361', '古韩镇', '140423100000', '140423000000');
INSERT INTO `t_s_town` VALUES ('3362', '王桥镇', '140423101000', '140423000000');
INSERT INTO `t_s_town` VALUES ('3363', '侯堡镇', '140423102000', '140423000000');
INSERT INTO `t_s_town` VALUES ('3364', '夏店镇', '140423103000', '140423000000');
INSERT INTO `t_s_town` VALUES ('3365', '虒亭镇', '140423104000', '140423000000');
INSERT INTO `t_s_town` VALUES ('3366', '西营镇', '140423105000', '140423000000');
INSERT INTO `t_s_town` VALUES ('3367', '王村镇', '140423106000', '140423000000');
INSERT INTO `t_s_town` VALUES ('3368', '下良镇', '140423107000', '140423000000');
INSERT INTO `t_s_town` VALUES ('3369', '善福乡', '140423200000', '140423000000');
INSERT INTO `t_s_town` VALUES ('3370', '北底乡', '140423201000', '140423000000');
INSERT INTO `t_s_town` VALUES ('3371', '上马乡', '140423202000', '140423000000');
INSERT INTO `t_s_town` VALUES ('3372', '富阳工业园区', '140423400000', '140423000000');
INSERT INTO `t_s_town` VALUES ('3373', '襄垣经济技术开发区', '140423402000', '140423000000');
INSERT INTO `t_s_town` VALUES ('3374', '青羊镇', '140425100000', '140425000000');
INSERT INTO `t_s_town` VALUES ('3375', '龙溪镇', '140425101000', '140425000000');
INSERT INTO `t_s_town` VALUES ('3376', '石城镇', '140425102000', '140425000000');
INSERT INTO `t_s_town` VALUES ('3377', '苗庄镇', '140425103000', '140425000000');
INSERT INTO `t_s_town` VALUES ('3378', '杏城镇', '140425104000', '140425000000');
INSERT INTO `t_s_town` VALUES ('3379', '西沟乡', '140425200000', '140425000000');
INSERT INTO `t_s_town` VALUES ('3380', '东寺头乡', '140425201000', '140425000000');
INSERT INTO `t_s_town` VALUES ('3381', '虹梯关乡', '140425202000', '140425000000');
INSERT INTO `t_s_town` VALUES ('3382', '阳高乡', '140425203000', '140425000000');
INSERT INTO `t_s_town` VALUES ('3383', '北耽车乡', '140425204000', '140425000000');
INSERT INTO `t_s_town` VALUES ('3384', '中五井乡', '140425205000', '140425000000');
INSERT INTO `t_s_town` VALUES ('3385', '北社乡', '140425206000', '140425000000');
INSERT INTO `t_s_town` VALUES ('3386', '平顺经济技术开发区', '140425400000', '140425000000');
INSERT INTO `t_s_town` VALUES ('3387', '黎侯镇', '140426100000', '140426000000');
INSERT INTO `t_s_town` VALUES ('3388', '东阳关镇', '140426101000', '140426000000');
INSERT INTO `t_s_town` VALUES ('3389', '上遥镇', '140426102000', '140426000000');
INSERT INTO `t_s_town` VALUES ('3390', '西井镇', '140426103000', '140426000000');
INSERT INTO `t_s_town` VALUES ('3391', '黄崖洞镇', '140426104000', '140426000000');
INSERT INTO `t_s_town` VALUES ('3392', '西仵乡', '140426200000', '140426000000');
INSERT INTO `t_s_town` VALUES ('3393', '停河铺乡', '140426201000', '140426000000');
INSERT INTO `t_s_town` VALUES ('3394', '程家山乡', '140426202000', '140426000000');
INSERT INTO `t_s_town` VALUES ('3395', '洪井乡', '140426203000', '140426000000');
INSERT INTO `t_s_town` VALUES ('3396', '黎城县经济技术开发区', '140426400000', '140426000000');
INSERT INTO `t_s_town` VALUES ('3397', '龙泉镇', '140427100000', '140427000000');
INSERT INTO `t_s_town` VALUES ('3398', '百尺镇', '140427101000', '140427000000');
INSERT INTO `t_s_town` VALUES ('3399', '店上镇', '140427102000', '140427000000');
INSERT INTO `t_s_town` VALUES ('3400', '晋庄镇', '140427103000', '140427000000');
INSERT INTO `t_s_town` VALUES ('3401', '树掌镇', '140427104000', '140427000000');
INSERT INTO `t_s_town` VALUES ('3402', '集店乡', '140427200000', '140427000000');
INSERT INTO `t_s_town` VALUES ('3403', '黄山乡', '140427201000', '140427000000');
INSERT INTO `t_s_town` VALUES ('3404', '东井岭乡', '140427202000', '140427000000');
INSERT INTO `t_s_town` VALUES ('3405', '石坡乡', '140427203000', '140427000000');
INSERT INTO `t_s_town` VALUES ('3406', '五龙山乡', '140427204000', '140427000000');
INSERT INTO `t_s_town` VALUES ('3407', '鹅屋乡', '140427205000', '140427000000');
INSERT INTO `t_s_town` VALUES ('3408', '桥上乡', '140427206000', '140427000000');
INSERT INTO `t_s_town` VALUES ('3409', '常平办事处', '140427400000', '140427000000');
INSERT INTO `t_s_town` VALUES ('3410', '壶关经济开发区', '140427401000', '140427000000');
INSERT INTO `t_s_town` VALUES ('3411', '丹朱镇', '140428100000', '140428000000');
INSERT INTO `t_s_town` VALUES ('3412', '鲍店镇', '140428101000', '140428000000');
INSERT INTO `t_s_town` VALUES ('3413', '石哲镇', '140428102000', '140428000000');
INSERT INTO `t_s_town` VALUES ('3414', '大堡头镇', '140428103000', '140428000000');
INSERT INTO `t_s_town` VALUES ('3415', '慈林镇', '140428104000', '140428000000');
INSERT INTO `t_s_town` VALUES ('3416', '色头镇', '140428105000', '140428000000');
INSERT INTO `t_s_town` VALUES ('3417', '南漳镇', '140428106000', '140428000000');
INSERT INTO `t_s_town` VALUES ('3418', '岚水乡', '140428200000', '140428000000');
INSERT INTO `t_s_town` VALUES ('3419', '碾张乡', '140428201000', '140428000000');
INSERT INTO `t_s_town` VALUES ('3420', '常张乡', '140428202000', '140428000000');
INSERT INTO `t_s_town` VALUES ('3421', '南陈乡', '140428203000', '140428000000');
INSERT INTO `t_s_town` VALUES ('3422', '宋村乡', '140428204000', '140428000000');
INSERT INTO `t_s_town` VALUES ('3423', '长子经济技术开发区', '140428400000', '140428000000');
INSERT INTO `t_s_town` VALUES ('3424', '丰州镇', '140429100000', '140429000000');
INSERT INTO `t_s_town` VALUES ('3425', '洪水镇', '140429101000', '140429000000');
INSERT INTO `t_s_town` VALUES ('3426', '蟠龙镇', '140429102000', '140429000000');
INSERT INTO `t_s_town` VALUES ('3427', '监漳镇', '140429103000', '140429000000');
INSERT INTO `t_s_town` VALUES ('3428', '故城镇', '140429104000', '140429000000');
INSERT INTO `t_s_town` VALUES ('3429', '墨镫乡', '140429200000', '140429000000');
INSERT INTO `t_s_town` VALUES ('3430', '韩北乡', '140429201000', '140429000000');
INSERT INTO `t_s_town` VALUES ('3431', '大有乡', '140429202000', '140429000000');
INSERT INTO `t_s_town` VALUES ('3432', '贾豁乡', '140429203000', '140429000000');
INSERT INTO `t_s_town` VALUES ('3433', '故县乡', '140429204000', '140429000000');
INSERT INTO `t_s_town` VALUES ('3434', '上司乡', '140429205000', '140429000000');
INSERT INTO `t_s_town` VALUES ('3435', '石北乡', '140429206000', '140429000000');
INSERT INTO `t_s_town` VALUES ('3436', '涌泉乡', '140429207000', '140429000000');
INSERT INTO `t_s_town` VALUES ('3437', '分水岭乡', '140429208000', '140429000000');
INSERT INTO `t_s_town` VALUES ('3438', '武乡经济技术开发区', '140429400000', '140429000000');
INSERT INTO `t_s_town` VALUES ('3439', '定昌镇', '140430100000', '140430000000');
INSERT INTO `t_s_town` VALUES ('3440', '郭村镇', '140430101000', '140430000000');
INSERT INTO `t_s_town` VALUES ('3441', '故县镇', '140430102000', '140430000000');
INSERT INTO `t_s_town` VALUES ('3442', '新店镇', '140430103000', '140430000000');
INSERT INTO `t_s_town` VALUES ('3443', '漳源镇', '140430104000', '140430000000');
INSERT INTO `t_s_town` VALUES ('3444', '册村镇', '140430105000', '140430000000');
INSERT INTO `t_s_town` VALUES ('3445', '段柳乡', '140430200000', '140430000000');
INSERT INTO `t_s_town` VALUES ('3446', '松村乡', '140430201000', '140430000000');
INSERT INTO `t_s_town` VALUES ('3447', '次村乡', '140430202000', '140430000000');
INSERT INTO `t_s_town` VALUES ('3448', '牛寺乡', '140430203000', '140430000000');
INSERT INTO `t_s_town` VALUES ('3449', '南里乡', '140430204000', '140430000000');
INSERT INTO `t_s_town` VALUES ('3450', '南泉乡', '140430205000', '140430000000');
INSERT INTO `t_s_town` VALUES ('3451', '杨安乡', '140430206000', '140430000000');
INSERT INTO `t_s_town` VALUES ('3452', '沁河镇', '140431100000', '140431000000');
INSERT INTO `t_s_town` VALUES ('3453', '郭道镇', '140431101000', '140431000000');
INSERT INTO `t_s_town` VALUES ('3454', '灵空山镇', '140431102000', '140431000000');
INSERT INTO `t_s_town` VALUES ('3455', '王和镇', '140431103000', '140431000000');
INSERT INTO `t_s_town` VALUES ('3456', '李元镇', '140431104000', '140431000000');
INSERT INTO `t_s_town` VALUES ('3457', '中峪乡', '140431200000', '140431000000');
INSERT INTO `t_s_town` VALUES ('3458', '法中乡', '140431201000', '140431000000');
INSERT INTO `t_s_town` VALUES ('3459', '交口乡', '140431202000', '140431000000');
INSERT INTO `t_s_town` VALUES ('3460', '聪子峪乡', '140431203000', '140431000000');
INSERT INTO `t_s_town` VALUES ('3461', '韩洪乡', '140431204000', '140431000000');
INSERT INTO `t_s_town` VALUES ('3462', '官滩乡', '140431205000', '140431000000');
INSERT INTO `t_s_town` VALUES ('3463', '景凤乡', '140431206000', '140431000000');
INSERT INTO `t_s_town` VALUES ('3464', '赤石桥乡', '140431207000', '140431000000');
INSERT INTO `t_s_town` VALUES ('3465', '王陶乡', '140431208000', '140431000000');
INSERT INTO `t_s_town` VALUES ('3466', '沁源经济技术开发区', '140431400000', '140431000000');
INSERT INTO `t_s_town` VALUES ('3467', '长治高新技术开发区城北街办事处', '140471400000', '140471000000');
INSERT INTO `t_s_town` VALUES ('3468', '东街街道办事处', '140502001000', '140502000000');
INSERT INTO `t_s_town` VALUES ('3469', '西街街道办事处', '140502002000', '140502000000');
INSERT INTO `t_s_town` VALUES ('3470', '南街街道办事处', '140502003000', '140502000000');
INSERT INTO `t_s_town` VALUES ('3471', '北街街道办事处', '140502004000', '140502000000');
INSERT INTO `t_s_town` VALUES ('3472', '钟家庄办事处', '140502006000', '140502000000');
INSERT INTO `t_s_town` VALUES ('3473', '西上庄办事处', '140502007000', '140502000000');
INSERT INTO `t_s_town` VALUES ('3474', '开发区街道办事处', '140502009000', '140502000000');
INSERT INTO `t_s_town` VALUES ('3475', '北石店镇', '140502100000', '140502000000');
INSERT INTO `t_s_town` VALUES ('3476', '龙港镇', '140521100000', '140521000000');
INSERT INTO `t_s_town` VALUES ('3477', '中村镇', '140521101000', '140521000000');
INSERT INTO `t_s_town` VALUES ('3478', '郑庄镇', '140521102000', '140521000000');
INSERT INTO `t_s_town` VALUES ('3479', '端氏镇', '140521103000', '140521000000');
INSERT INTO `t_s_town` VALUES ('3480', '嘉峰镇', '140521104000', '140521000000');
INSERT INTO `t_s_town` VALUES ('3481', '郑村镇', '140521105000', '140521000000');
INSERT INTO `t_s_town` VALUES ('3482', '柿庄镇', '140521106000', '140521000000');
INSERT INTO `t_s_town` VALUES ('3483', '樊村河乡', '140521200000', '140521000000');
INSERT INTO `t_s_town` VALUES ('3484', '土沃乡', '140521201000', '140521000000');
INSERT INTO `t_s_town` VALUES ('3485', '张村乡', '140521202000', '140521000000');
INSERT INTO `t_s_town` VALUES ('3486', '苏庄乡', '140521203000', '140521000000');
INSERT INTO `t_s_town` VALUES ('3487', '胡底乡', '140521204000', '140521000000');
INSERT INTO `t_s_town` VALUES ('3488', '固县乡', '140521205000', '140521000000');
INSERT INTO `t_s_town` VALUES ('3489', '十里乡', '140521206000', '140521000000');
INSERT INTO `t_s_town` VALUES ('3490', '凤城镇', '140522100000', '140522000000');
INSERT INTO `t_s_town` VALUES ('3491', '北留镇', '140522101000', '140522000000');
INSERT INTO `t_s_town` VALUES ('3492', '润城镇', '140522102000', '140522000000');
INSERT INTO `t_s_town` VALUES ('3493', '町店镇', '140522103000', '140522000000');
INSERT INTO `t_s_town` VALUES ('3494', '芹池镇', '140522104000', '140522000000');
INSERT INTO `t_s_town` VALUES ('3495', '次营镇', '140522105000', '140522000000');
INSERT INTO `t_s_town` VALUES ('3496', '横河镇', '140522106000', '140522000000');
INSERT INTO `t_s_town` VALUES ('3497', '河北镇', '140522107000', '140522000000');
INSERT INTO `t_s_town` VALUES ('3498', '蟒河镇', '140522108000', '140522000000');
INSERT INTO `t_s_town` VALUES ('3499', '东冶镇', '140522109000', '140522000000');
INSERT INTO `t_s_town` VALUES ('3500', '白桑乡', '140522200000', '140522000000');
INSERT INTO `t_s_town` VALUES ('3501', '寺头乡', '140522201000', '140522000000');
INSERT INTO `t_s_town` VALUES ('3502', '西河乡', '140522202000', '140522000000');
INSERT INTO `t_s_town` VALUES ('3503', '演礼乡', '140522203000', '140522000000');
INSERT INTO `t_s_town` VALUES ('3504', '固隆乡', '140522204000', '140522000000');
INSERT INTO `t_s_town` VALUES ('3505', '董封乡', '140522205000', '140522000000');
INSERT INTO `t_s_town` VALUES ('3506', '驾岭乡', '140522206000', '140522000000');
INSERT INTO `t_s_town` VALUES ('3507', '林场管理处', '140522401000', '140522000000');
INSERT INTO `t_s_town` VALUES ('3508', '崇文镇', '140524100000', '140524000000');
INSERT INTO `t_s_town` VALUES ('3509', '礼义镇', '140524101000', '140524000000');
INSERT INTO `t_s_town` VALUES ('3510', '附城镇', '140524102000', '140524000000');
INSERT INTO `t_s_town` VALUES ('3511', '西河底镇', '140524103000', '140524000000');
INSERT INTO `t_s_town` VALUES ('3512', '平城镇', '140524104000', '140524000000');
INSERT INTO `t_s_town` VALUES ('3513', '杨村镇', '140524105000', '140524000000');
INSERT INTO `t_s_town` VALUES ('3514', '潞城镇', '140524106000', '140524000000');
INSERT INTO `t_s_town` VALUES ('3515', '夺火乡', '140524204000', '140524000000');
INSERT INTO `t_s_town` VALUES ('3516', '马圪当乡', '140524206000', '140524000000');
INSERT INTO `t_s_town` VALUES ('3517', '古郊乡', '140524207000', '140524000000');
INSERT INTO `t_s_town` VALUES ('3518', '六泉乡', '140524209000', '140524000000');
INSERT INTO `t_s_town` VALUES ('3519', '秦家庄乡', '140524212000', '140524000000');
INSERT INTO `t_s_town` VALUES ('3520', '南村镇', '140525100000', '140525000000');
INSERT INTO `t_s_town` VALUES ('3521', '下村镇', '140525101000', '140525000000');
INSERT INTO `t_s_town` VALUES ('3522', '大东沟镇', '140525102000', '140525000000');
INSERT INTO `t_s_town` VALUES ('3523', '周村镇', '140525103000', '140525000000');
INSERT INTO `t_s_town` VALUES ('3524', '犁川镇', '140525104000', '140525000000');
INSERT INTO `t_s_town` VALUES ('3525', '晋庙铺镇', '140525105000', '140525000000');
INSERT INTO `t_s_town` VALUES ('3526', '金村镇', '140525106000', '140525000000');
INSERT INTO `t_s_town` VALUES ('3527', '高都镇', '140525107000', '140525000000');
INSERT INTO `t_s_town` VALUES ('3528', '巴公镇', '140525108000', '140525000000');
INSERT INTO `t_s_town` VALUES ('3529', '大阳镇', '140525109000', '140525000000');
INSERT INTO `t_s_town` VALUES ('3530', '山河镇', '140525110000', '140525000000');
INSERT INTO `t_s_town` VALUES ('3531', '大箕镇', '140525111000', '140525000000');
INSERT INTO `t_s_town` VALUES ('3532', '柳树口镇', '140525112000', '140525000000');
INSERT INTO `t_s_town` VALUES ('3533', '北义城镇', '140525113000', '140525000000');
INSERT INTO `t_s_town` VALUES ('3534', '川底乡', '140525200000', '140525000000');
INSERT INTO `t_s_town` VALUES ('3535', '李寨乡', '140525201000', '140525000000');
INSERT INTO `t_s_town` VALUES ('3536', '南岭乡', '140525202000', '140525000000');
INSERT INTO `t_s_town` VALUES ('3537', '北城街道办事处', '140581001000', '140581000000');
INSERT INTO `t_s_town` VALUES ('3538', '东城街道办事处', '140581002000', '140581000000');
INSERT INTO `t_s_town` VALUES ('3539', '南城街道办事处', '140581003000', '140581000000');
INSERT INTO `t_s_town` VALUES ('3540', '米山镇', '140581101000', '140581000000');
INSERT INTO `t_s_town` VALUES ('3541', '三甲镇', '140581102000', '140581000000');
INSERT INTO `t_s_town` VALUES ('3542', '神农镇', '140581103000', '140581000000');
INSERT INTO `t_s_town` VALUES ('3543', '陈区镇', '140581104000', '140581000000');
INSERT INTO `t_s_town` VALUES ('3544', '北诗镇', '140581105000', '140581000000');
INSERT INTO `t_s_town` VALUES ('3545', '河西镇', '140581106000', '140581000000');
INSERT INTO `t_s_town` VALUES ('3546', '马村镇', '140581107000', '140581000000');
INSERT INTO `t_s_town` VALUES ('3547', '野川镇', '140581108000', '140581000000');
INSERT INTO `t_s_town` VALUES ('3548', '寺庄镇', '140581109000', '140581000000');
INSERT INTO `t_s_town` VALUES ('3549', '建宁乡', '140581201000', '140581000000');
INSERT INTO `t_s_town` VALUES ('3550', '石末乡', '140581202000', '140581000000');
INSERT INTO `t_s_town` VALUES ('3551', '原村乡', '140581203000', '140581000000');
INSERT INTO `t_s_town` VALUES ('3552', '永录乡', '140581204000', '140581000000');
INSERT INTO `t_s_town` VALUES ('3553', '北城街道办事处', '140602001000', '140602000000');
INSERT INTO `t_s_town` VALUES ('3554', '南城街道办事处', '140602002000', '140602000000');
INSERT INTO `t_s_town` VALUES ('3555', '神头街道办事处', '140602003000', '140602000000');
INSERT INTO `t_s_town` VALUES ('3556', '北旺庄街道办事处', '140602004000', '140602000000');
INSERT INTO `t_s_town` VALUES ('3557', '神头镇', '140602100000', '140602000000');
INSERT INTO `t_s_town` VALUES ('3558', '利民镇', '140602101000', '140602000000');
INSERT INTO `t_s_town` VALUES ('3559', '下团堡乡', '140602200000', '140602000000');
INSERT INTO `t_s_town` VALUES ('3560', '小平易乡', '140602201000', '140602000000');
INSERT INTO `t_s_town` VALUES ('3561', '滋润乡', '140602202000', '140602000000');
INSERT INTO `t_s_town` VALUES ('3562', '福善庄乡', '140602203000', '140602000000');
INSERT INTO `t_s_town` VALUES ('3563', '南榆林乡', '140602204000', '140602000000');
INSERT INTO `t_s_town` VALUES ('3564', '贾庄乡', '140602205000', '140602000000');
INSERT INTO `t_s_town` VALUES ('3565', '沙塄河乡', '140602206000', '140602000000');
INSERT INTO `t_s_town` VALUES ('3566', '窑子头乡', '140602207000', '140602000000');
INSERT INTO `t_s_town` VALUES ('3567', '张蔡庄乡', '140602208000', '140602000000');
INSERT INTO `t_s_town` VALUES ('3568', '井坪镇', '140603100000', '140603000000');
INSERT INTO `t_s_town` VALUES ('3569', '凤凰城镇', '140603101000', '140603000000');
INSERT INTO `t_s_town` VALUES ('3570', '白堂乡', '140603200000', '140603000000');
INSERT INTO `t_s_town` VALUES ('3571', '陶村乡', '140603201000', '140603000000');
INSERT INTO `t_s_town` VALUES ('3572', '下水头乡', '140603202000', '140603000000');
INSERT INTO `t_s_town` VALUES ('3573', '双碾乡', '140603203000', '140603000000');
INSERT INTO `t_s_town` VALUES ('3574', '阻虎乡', '140603204000', '140603000000');
INSERT INTO `t_s_town` VALUES ('3575', '高石庄乡', '140603205000', '140603000000');
INSERT INTO `t_s_town` VALUES ('3576', '西水界乡', '140603206000', '140603000000');
INSERT INTO `t_s_town` VALUES ('3577', '下面高乡', '140603207000', '140603000000');
INSERT INTO `t_s_town` VALUES ('3578', '下木角乡', '140603208000', '140603000000');
INSERT INTO `t_s_town` VALUES ('3579', '向阳堡乡', '140603209000', '140603000000');
INSERT INTO `t_s_town` VALUES ('3580', '榆岭乡', '140603210000', '140603000000');
INSERT INTO `t_s_town` VALUES ('3581', '东城管理委员会', '140621001000', '140621000000');
INSERT INTO `t_s_town` VALUES ('3582', '西城管理委员会', '140621002000', '140621000000');
INSERT INTO `t_s_town` VALUES ('3583', '玉井镇', '140621100000', '140621000000');
INSERT INTO `t_s_town` VALUES ('3584', '北周庄镇', '140621101000', '140621000000');
INSERT INTO `t_s_town` VALUES ('3585', '古城镇', '140621102000', '140621000000');
INSERT INTO `t_s_town` VALUES ('3586', '岱岳镇', '140621103000', '140621000000');
INSERT INTO `t_s_town` VALUES ('3587', '吴马营乡', '140621200000', '140621000000');
INSERT INTO `t_s_town` VALUES ('3588', '马营乡', '140621201000', '140621000000');
INSERT INTO `t_s_town` VALUES ('3589', '下喇叭乡', '140621202000', '140621000000');
INSERT INTO `t_s_town` VALUES ('3590', '合盛堡乡', '140621203000', '140621000000');
INSERT INTO `t_s_town` VALUES ('3591', '安荣乡', '140621205000', '140621000000');
INSERT INTO `t_s_town` VALUES ('3592', '薛圐圙乡', '140621206000', '140621000000');
INSERT INTO `t_s_town` VALUES ('3593', '后所乡', '140621207000', '140621000000');
INSERT INTO `t_s_town` VALUES ('3594', '张家庄乡', '140621208000', '140621000000');
INSERT INTO `t_s_town` VALUES ('3595', '马营庄乡', '140621209000', '140621000000');
INSERT INTO `t_s_town` VALUES ('3596', '山阴农牧场', '140621400000', '140621000000');
INSERT INTO `t_s_town` VALUES ('3597', '金城镇', '140622100000', '140622000000');
INSERT INTO `t_s_town` VALUES ('3598', '南河种镇', '140622101000', '140622000000');
INSERT INTO `t_s_town` VALUES ('3599', '下社镇', '140622102000', '140622000000');
INSERT INTO `t_s_town` VALUES ('3600', '镇子梁乡', '140622200000', '140622000000');
INSERT INTO `t_s_town` VALUES ('3601', '义井乡', '140622201000', '140622000000');
INSERT INTO `t_s_town` VALUES ('3602', '藏寨乡', '140622202000', '140622000000');
INSERT INTO `t_s_town` VALUES ('3603', '大黄巍乡', '140622203000', '140622000000');
INSERT INTO `t_s_town` VALUES ('3604', '杏寨乡', '140622204000', '140622000000');
INSERT INTO `t_s_town` VALUES ('3605', '下马峪乡', '140622205000', '140622000000');
INSERT INTO `t_s_town` VALUES ('3606', '南泉乡', '140622206000', '140622000000');
INSERT INTO `t_s_town` VALUES ('3607', '大临河乡', '140622207000', '140622000000');
INSERT INTO `t_s_town` VALUES ('3608', '白马石乡', '140622208000', '140622000000');
INSERT INTO `t_s_town` VALUES ('3609', '新城镇', '140623100000', '140623000000');
INSERT INTO `t_s_town` VALUES ('3610', '右卫镇', '140623101000', '140623000000');
INSERT INTO `t_s_town` VALUES ('3611', '威远镇', '140623102000', '140623000000');
INSERT INTO `t_s_town` VALUES ('3612', '元堡子镇', '140623103000', '140623000000');
INSERT INTO `t_s_town` VALUES ('3613', '牛心堡乡', '140623200000', '140623000000');
INSERT INTO `t_s_town` VALUES ('3614', '白头里乡', '140623201000', '140623000000');
INSERT INTO `t_s_town` VALUES ('3615', '高家堡乡', '140623202000', '140623000000');
INSERT INTO `t_s_town` VALUES ('3616', '丁家窑乡', '140623203000', '140623000000');
INSERT INTO `t_s_town` VALUES ('3617', '杨千河乡', '140623204000', '140623000000');
INSERT INTO `t_s_town` VALUES ('3618', '李达窑乡', '140623205000', '140623000000');
INSERT INTO `t_s_town` VALUES ('3619', '山西朔州经济开发区街道办事处筹备处', '140671400000', '140671000000');
INSERT INTO `t_s_town` VALUES ('3620', '云中镇', '140681100000', '140681000000');
INSERT INTO `t_s_town` VALUES ('3621', '吴家窑镇', '140681101000', '140681000000');
INSERT INTO `t_s_town` VALUES ('3622', '金沙滩镇', '140681102000', '140681000000');
INSERT INTO `t_s_town` VALUES ('3623', '毛家皂镇', '140681103000', '140681000000');
INSERT INTO `t_s_town` VALUES ('3624', '何家堡乡', '140681200000', '140681000000');
INSERT INTO `t_s_town` VALUES ('3625', '新家园乡', '140681201000', '140681000000');
INSERT INTO `t_s_town` VALUES ('3626', '亲和乡', '140681202000', '140681000000');
INSERT INTO `t_s_town` VALUES ('3627', '海北头乡', '140681203000', '140681000000');
INSERT INTO `t_s_town` VALUES ('3628', '马辛庄乡', '140681204000', '140681000000');
INSERT INTO `t_s_town` VALUES ('3629', '河头乡', '140681205000', '140681000000');
INSERT INTO `t_s_town` VALUES ('3630', '金沙滩农牧场', '140681500000', '140681000000');
INSERT INTO `t_s_town` VALUES ('3631', '金沙滩林场', '140681501000', '140681000000');
INSERT INTO `t_s_town` VALUES ('3632', '北关街道办事处', '140702001000', '140702000000');
INSERT INTO `t_s_town` VALUES ('3633', '锦纶街道办事处', '140702002000', '140702000000');
INSERT INTO `t_s_town` VALUES ('3634', '新华街道办事处', '140702003000', '140702000000');
INSERT INTO `t_s_town` VALUES ('3635', '西南街道办事处', '140702004000', '140702000000');
INSERT INTO `t_s_town` VALUES ('3636', '路西街道办事处', '140702005000', '140702000000');
INSERT INTO `t_s_town` VALUES ('3637', '经纬街道办事处', '140702006000', '140702000000');
INSERT INTO `t_s_town` VALUES ('3638', '安宁街道办事处', '140702007000', '140702000000');
INSERT INTO `t_s_town` VALUES ('3639', '新建街道办事处', '140702008000', '140702000000');
INSERT INTO `t_s_town` VALUES ('3640', '晋华街道办事处', '140702009000', '140702000000');
INSERT INTO `t_s_town` VALUES ('3641', '乌金山镇', '140702100000', '140702000000');
INSERT INTO `t_s_town` VALUES ('3642', '东阳镇', '140702101000', '140702000000');
INSERT INTO `t_s_town` VALUES ('3643', '什贴镇', '140702102000', '140702000000');
INSERT INTO `t_s_town` VALUES ('3644', '长凝镇', '140702103000', '140702000000');
INSERT INTO `t_s_town` VALUES ('3645', '北田镇', '140702104000', '140702000000');
INSERT INTO `t_s_town` VALUES ('3646', '修文镇', '140702105000', '140702000000');
INSERT INTO `t_s_town` VALUES ('3647', '郭家堡乡', '140702200000', '140702000000');
INSERT INTO `t_s_town` VALUES ('3648', '张庆乡', '140702201000', '140702000000');
INSERT INTO `t_s_town` VALUES ('3649', '庄子乡', '140702202000', '140702000000');
INSERT INTO `t_s_town` VALUES ('3650', '东赵乡', '140702203000', '140702000000');
INSERT INTO `t_s_town` VALUES ('3651', '榆次区使赵乡社会事务管理中心', '140702204000', '140702000000');
INSERT INTO `t_s_town` VALUES ('3652', '山西转型综合改革示范区晋中开发区', '140702401000', '140702000000');
INSERT INTO `t_s_town` VALUES ('3653', '箕城镇', '140721100000', '140721000000');
INSERT INTO `t_s_town` VALUES ('3654', '云簇镇', '140721101000', '140721000000');
INSERT INTO `t_s_town` VALUES ('3655', '郝北镇', '140721102000', '140721000000');
INSERT INTO `t_s_town` VALUES ('3656', '社城镇', '140721103000', '140721000000');
INSERT INTO `t_s_town` VALUES ('3657', '河峪乡', '140721200000', '140721000000');
INSERT INTO `t_s_town` VALUES ('3658', '北寨乡', '140721201000', '140721000000');
INSERT INTO `t_s_town` VALUES ('3659', '西马乡', '140721202000', '140721000000');
INSERT INTO `t_s_town` VALUES ('3660', '岚峪乡', '140721203000', '140721000000');
INSERT INTO `t_s_town` VALUES ('3661', '讲堂乡', '140721204000', '140721000000');
INSERT INTO `t_s_town` VALUES ('3662', '城区管理委员会', '140721400000', '140721000000');
INSERT INTO `t_s_town` VALUES ('3663', '城区街道管理委员会', '140722001000', '140722000000');
INSERT INTO `t_s_town` VALUES ('3664', '辽阳镇', '140722100000', '140722000000');
INSERT INTO `t_s_town` VALUES ('3665', '桐峪镇', '140722101000', '140722000000');
INSERT INTO `t_s_town` VALUES ('3666', '麻田镇', '140722102000', '140722000000');
INSERT INTO `t_s_town` VALUES ('3667', '芹泉镇', '140722103000', '140722000000');
INSERT INTO `t_s_town` VALUES ('3668', '拐儿镇', '140722104000', '140722000000');
INSERT INTO `t_s_town` VALUES ('3669', '寒王乡', '140722200000', '140722000000');
INSERT INTO `t_s_town` VALUES ('3670', '石匣乡', '140722201000', '140722000000');
INSERT INTO `t_s_town` VALUES ('3671', '龙泉乡', '140722202000', '140722000000');
INSERT INTO `t_s_town` VALUES ('3672', '粟城乡', '140722203000', '140722000000');
INSERT INTO `t_s_town` VALUES ('3673', '羊角乡', '140722204000', '140722000000');
INSERT INTO `t_s_town` VALUES ('3674', '城区管理委员会', '140723001000', '140723000000');
INSERT INTO `t_s_town` VALUES ('3675', '义兴镇', '140723100000', '140723000000');
INSERT INTO `t_s_town` VALUES ('3676', '李阳镇', '140723101000', '140723000000');
INSERT INTO `t_s_town` VALUES ('3677', '松烟镇', '140723102000', '140723000000');
INSERT INTO `t_s_town` VALUES ('3678', '青城镇', '140723103000', '140723000000');
INSERT INTO `t_s_town` VALUES ('3679', '横岭镇', '140723104000', '140723000000');
INSERT INTO `t_s_town` VALUES ('3680', '喂马乡', '140723200000', '140723000000');
INSERT INTO `t_s_town` VALUES ('3681', '平松乡', '140723201000', '140723000000');
INSERT INTO `t_s_town` VALUES ('3682', '牛川乡', '140723202000', '140723000000');
INSERT INTO `t_s_town` VALUES ('3683', '马坊乡', '140723203000', '140723000000');
INSERT INTO `t_s_town` VALUES ('3684', '阳光占乡', '140723204000', '140723000000');
INSERT INTO `t_s_town` VALUES ('3685', '城区社区管理委员会', '140724001000', '140724000000');
INSERT INTO `t_s_town` VALUES ('3686', '乐平镇', '140724100000', '140724000000');
INSERT INTO `t_s_town` VALUES ('3687', '皋落镇', '140724101000', '140724000000');
INSERT INTO `t_s_town` VALUES ('3688', '冶头镇', '140724102000', '140724000000');
INSERT INTO `t_s_town` VALUES ('3689', '沾尚镇', '140724103000', '140724000000');
INSERT INTO `t_s_town` VALUES ('3690', '大寨镇', '140724104000', '140724000000');
INSERT INTO `t_s_town` VALUES ('3691', '李家庄乡', '140724200000', '140724000000');
INSERT INTO `t_s_town` VALUES ('3692', '界都乡', '140724201000', '140724000000');
INSERT INTO `t_s_town` VALUES ('3693', '三都乡', '140724202000', '140724000000');
INSERT INTO `t_s_town` VALUES ('3694', '赵壁乡', '140724203000', '140724000000');
INSERT INTO `t_s_town` VALUES ('3695', '孔氏乡', '140724204000', '140724000000');
INSERT INTO `t_s_town` VALUES ('3696', '闫庄乡', '140724205000', '140724000000');
INSERT INTO `t_s_town` VALUES ('3697', '西寨乡', '140724206000', '140724000000');
INSERT INTO `t_s_town` VALUES ('3698', '朝阳镇', '140725100000', '140725000000');
INSERT INTO `t_s_town` VALUES ('3699', '南燕竹镇', '140725101000', '140725000000');
INSERT INTO `t_s_town` VALUES ('3700', '宗艾镇', '140725102000', '140725000000');
INSERT INTO `t_s_town` VALUES ('3701', '平头镇', '140725103000', '140725000000');
INSERT INTO `t_s_town` VALUES ('3702', '松塔镇', '140725104000', '140725000000');
INSERT INTO `t_s_town` VALUES ('3703', '西洛镇', '140725105000', '140725000000');
INSERT INTO `t_s_town` VALUES ('3704', '尹灵芝镇', '140725106000', '140725000000');
INSERT INTO `t_s_town` VALUES ('3705', '平舒乡', '140725200000', '140725000000');
INSERT INTO `t_s_town` VALUES ('3706', '解愁乡', '140725201000', '140725000000');
INSERT INTO `t_s_town` VALUES ('3707', '温家庄乡', '140725202000', '140725000000');
INSERT INTO `t_s_town` VALUES ('3708', '景尚乡', '140725203000', '140725000000');
INSERT INTO `t_s_town` VALUES ('3709', '上湖乡', '140725204000', '140725000000');
INSERT INTO `t_s_town` VALUES ('3710', '羊头崖乡', '140725205000', '140725000000');
INSERT INTO `t_s_town` VALUES ('3711', '马首乡', '140725206000', '140725000000');
INSERT INTO `t_s_town` VALUES ('3712', '明星镇', '140726100000', '140726000000');
INSERT INTO `t_s_town` VALUES ('3713', '胡村镇', '140726101000', '140726000000');
INSERT INTO `t_s_town` VALUES ('3714', '范村镇', '140726102000', '140726000000');
INSERT INTO `t_s_town` VALUES ('3715', '侯城乡', '140726200000', '140726000000');
INSERT INTO `t_s_town` VALUES ('3716', '北汪乡', '140726201000', '140726000000');
INSERT INTO `t_s_town` VALUES ('3717', '水秀乡', '140726202000', '140726000000');
INSERT INTO `t_s_town` VALUES ('3718', '阳邑乡', '140726203000', '140726000000');
INSERT INTO `t_s_town` VALUES ('3719', '小白乡', '140726204000', '140726000000');
INSERT INTO `t_s_town` VALUES ('3720', '任村乡', '140726205000', '140726000000');
INSERT INTO `t_s_town` VALUES ('3721', '白塔区管委会', '140726401000', '140726000000');
INSERT INTO `t_s_town` VALUES ('3722', '北城区管委会', '140726402000', '140726000000');
INSERT INTO `t_s_town` VALUES ('3723', '南城区管委会', '140726403000', '140726000000');
INSERT INTO `t_s_town` VALUES ('3724', '昌源城区管理委员会', '140727001000', '140727000000');
INSERT INTO `t_s_town` VALUES ('3725', '丹枫城区管理委员会', '140727002000', '140727000000');
INSERT INTO `t_s_town` VALUES ('3726', '麓台城区管理委员会', '140727003000', '140727000000');
INSERT INTO `t_s_town` VALUES ('3727', '昭馀镇', '140727100000', '140727000000');
INSERT INTO `t_s_town` VALUES ('3728', '东观镇', '140727101000', '140727000000');
INSERT INTO `t_s_town` VALUES ('3729', '古县镇', '140727102000', '140727000000');
INSERT INTO `t_s_town` VALUES ('3730', '贾令镇', '140727103000', '140727000000');
INSERT INTO `t_s_town` VALUES ('3731', '城赵镇', '140727104000', '140727000000');
INSERT INTO `t_s_town` VALUES ('3732', '来远镇', '140727105000', '140727000000');
INSERT INTO `t_s_town` VALUES ('3733', '西六支乡', '140727200000', '140727000000');
INSERT INTO `t_s_town` VALUES ('3734', '峪口乡', '140727201000', '140727000000');
INSERT INTO `t_s_town` VALUES ('3735', '祁县经济开发区管理委员会', '140727400000', '140727000000');
INSERT INTO `t_s_town` VALUES ('3736', '古城街道办事处', '140728001000', '140728000000');
INSERT INTO `t_s_town` VALUES ('3737', '城东街道办事处', '140728002000', '140728000000');
INSERT INTO `t_s_town` VALUES ('3738', '城西街道办事处', '140728003000', '140728000000');
INSERT INTO `t_s_town` VALUES ('3739', '古陶镇', '140728100000', '140728000000');
INSERT INTO `t_s_town` VALUES ('3740', '段村镇', '140728101000', '140728000000');
INSERT INTO `t_s_town` VALUES ('3741', '东泉镇', '140728102000', '140728000000');
INSERT INTO `t_s_town` VALUES ('3742', '洪善镇', '140728103000', '140728000000');
INSERT INTO `t_s_town` VALUES ('3743', '宁固镇', '140728104000', '140728000000');
INSERT INTO `t_s_town` VALUES ('3744', '南政乡', '140728200000', '140728000000');
INSERT INTO `t_s_town` VALUES ('3745', '中都乡', '140728201000', '140728000000');
INSERT INTO `t_s_town` VALUES ('3746', '岳壁乡', '140728202000', '140728000000');
INSERT INTO `t_s_town` VALUES ('3747', '卜宜乡', '140728203000', '140728000000');
INSERT INTO `t_s_town` VALUES ('3748', '孟山乡', '140728204000', '140728000000');
INSERT INTO `t_s_town` VALUES ('3749', '朱坑乡', '140728205000', '140728000000');
INSERT INTO `t_s_town` VALUES ('3750', '襄垣乡', '140728206000', '140728000000');
INSERT INTO `t_s_town` VALUES ('3751', '杜家庄乡', '140728207000', '140728000000');
INSERT INTO `t_s_town` VALUES ('3752', '香乐乡', '140728208000', '140728000000');
INSERT INTO `t_s_town` VALUES ('3753', '东城管理委员会', '140729001000', '140729000000');
INSERT INTO `t_s_town` VALUES ('3754', '西城管理委员会', '140729002000', '140729000000');
INSERT INTO `t_s_town` VALUES ('3755', '北城管理委员会', '140729003000', '140729000000');
INSERT INTO `t_s_town` VALUES ('3756', '翠峰镇', '140729100000', '140729000000');
INSERT INTO `t_s_town` VALUES ('3757', '静升镇', '140729101000', '140729000000');
INSERT INTO `t_s_town` VALUES ('3758', '两渡镇', '140729102000', '140729000000');
INSERT INTO `t_s_town` VALUES ('3759', '夏门镇', '140729103000', '140729000000');
INSERT INTO `t_s_town` VALUES ('3760', '南关镇', '140729104000', '140729000000');
INSERT INTO `t_s_town` VALUES ('3761', '段纯镇', '140729105000', '140729000000');
INSERT INTO `t_s_town` VALUES ('3762', '马和乡', '140729200000', '140729000000');
INSERT INTO `t_s_town` VALUES ('3763', '英武乡', '140729201000', '140729000000');
INSERT INTO `t_s_town` VALUES ('3764', '王禹乡', '140729202000', '140729000000');
INSERT INTO `t_s_town` VALUES ('3765', '坛镇乡', '140729203000', '140729000000');
INSERT INTO `t_s_town` VALUES ('3766', '梁家焉乡', '140729204000', '140729000000');
INSERT INTO `t_s_town` VALUES ('3767', '交口乡', '140729205000', '140729000000');
INSERT INTO `t_s_town` VALUES ('3768', '北关街道办事处', '140781001000', '140781000000');
INSERT INTO `t_s_town` VALUES ('3769', '西关街道办事处', '140781002000', '140781000000');
INSERT INTO `t_s_town` VALUES ('3770', '东南街道办事处', '140781003000', '140781000000');
INSERT INTO `t_s_town` VALUES ('3771', '西南街道办事处', '140781004000', '140781000000');
INSERT INTO `t_s_town` VALUES ('3772', '北坛街道办事处', '140781005000', '140781000000');
INSERT INTO `t_s_town` VALUES ('3773', '义安镇', '140781100000', '140781000000');
INSERT INTO `t_s_town` VALUES ('3774', '张兰镇', '140781101000', '140781000000');
INSERT INTO `t_s_town` VALUES ('3775', '连福镇', '140781102000', '140781000000');
INSERT INTO `t_s_town` VALUES ('3776', '洪山镇', '140781103000', '140781000000');
INSERT INTO `t_s_town` VALUES ('3777', '龙凤镇', '140781104000', '140781000000');
INSERT INTO `t_s_town` VALUES ('3778', '绵山镇', '140781105000', '140781000000');
INSERT INTO `t_s_town` VALUES ('3779', '义棠镇', '140781106000', '140781000000');
INSERT INTO `t_s_town` VALUES ('3780', '城关乡', '140781200000', '140781000000');
INSERT INTO `t_s_town` VALUES ('3781', '宋古乡', '140781201000', '140781000000');
INSERT INTO `t_s_town` VALUES ('3782', '三佳乡', '140781202000', '140781000000');
INSERT INTO `t_s_town` VALUES ('3783', '中城街道办事处', '140802001000', '140802000000');
INSERT INTO `t_s_town` VALUES ('3784', '东城街道办事处', '140802002000', '140802000000');
INSERT INTO `t_s_town` VALUES ('3785', '西城街道办事处', '140802003000', '140802000000');
INSERT INTO `t_s_town` VALUES ('3786', '南城街道办事处', '140802004000', '140802000000');
INSERT INTO `t_s_town` VALUES ('3787', '北城街道办事处', '140802005000', '140802000000');
INSERT INTO `t_s_town` VALUES ('3788', '安邑街道办事处', '140802006000', '140802000000');
INSERT INTO `t_s_town` VALUES ('3789', '大渠街道办事处', '140802007000', '140802000000');
INSERT INTO `t_s_town` VALUES ('3790', '姚孟街道办事处', '140802008000', '140802000000');
INSERT INTO `t_s_town` VALUES ('3791', '解州镇', '140802100000', '140802000000');
INSERT INTO `t_s_town` VALUES ('3792', '龙居镇', '140802101000', '140802000000');
INSERT INTO `t_s_town` VALUES ('3793', '北相镇', '140802102000', '140802000000');
INSERT INTO `t_s_town` VALUES ('3794', '泓芝驿镇', '140802103000', '140802000000');
INSERT INTO `t_s_town` VALUES ('3795', '三路里镇', '140802104000', '140802000000');
INSERT INTO `t_s_town` VALUES ('3796', '陶村镇', '140802105000', '140802000000');
INSERT INTO `t_s_town` VALUES ('3797', '东郭镇', '140802106000', '140802000000');
INSERT INTO `t_s_town` VALUES ('3798', '席张乡', '140802200000', '140802000000');
INSERT INTO `t_s_town` VALUES ('3799', '金井乡', '140802201000', '140802000000');
INSERT INTO `t_s_town` VALUES ('3800', '王范乡', '140802202000', '140802000000');
INSERT INTO `t_s_town` VALUES ('3801', '冯村乡', '140802203000', '140802000000');
INSERT INTO `t_s_town` VALUES ('3802', '上郭乡', '140802204000', '140802000000');
INSERT INTO `t_s_town` VALUES ('3803', '上王乡', '140802205000', '140802000000');
INSERT INTO `t_s_town` VALUES ('3804', '山西运城经济开发区', '140802402000', '140802000000');
INSERT INTO `t_s_town` VALUES ('3805', '运城空港经济开发区', '140802403000', '140802000000');
INSERT INTO `t_s_town` VALUES ('3806', '猗氏镇', '140821100000', '140821000000');
INSERT INTO `t_s_town` VALUES ('3807', '嵋阳镇', '140821101000', '140821000000');
INSERT INTO `t_s_town` VALUES ('3808', '临晋镇', '140821102000', '140821000000');
INSERT INTO `t_s_town` VALUES ('3809', '七级镇', '140821103000', '140821000000');
INSERT INTO `t_s_town` VALUES ('3810', '东张镇', '140821104000', '140821000000');
INSERT INTO `t_s_town` VALUES ('3811', '孙吉镇', '140821105000', '140821000000');
INSERT INTO `t_s_town` VALUES ('3812', '三管镇', '140821106000', '140821000000');
INSERT INTO `t_s_town` VALUES ('3813', '牛杜镇', '140821107000', '140821000000');
INSERT INTO `t_s_town` VALUES ('3814', '耽子镇', '140821108000', '140821000000');
INSERT INTO `t_s_town` VALUES ('3815', '楚侯乡', '140821200000', '140821000000');
INSERT INTO `t_s_town` VALUES ('3816', '庙上乡', '140821201000', '140821000000');
INSERT INTO `t_s_town` VALUES ('3817', '角杯乡', '140821202000', '140821000000');
INSERT INTO `t_s_town` VALUES ('3818', '北辛乡', '140821203000', '140821000000');
INSERT INTO `t_s_town` VALUES ('3819', '北景乡', '140821204000', '140821000000');
INSERT INTO `t_s_town` VALUES ('3820', '临猗县城市社区管理办公室', '140821402000', '140821000000');
INSERT INTO `t_s_town` VALUES ('3821', '解店镇', '140822100000', '140822000000');
INSERT INTO `t_s_town` VALUES ('3822', '通化镇', '140822101000', '140822000000');
INSERT INTO `t_s_town` VALUES ('3823', '汉薛镇', '140822102000', '140822000000');
INSERT INTO `t_s_town` VALUES ('3824', '荣河镇', '140822103000', '140822000000');
INSERT INTO `t_s_town` VALUES ('3825', '万泉乡', '140822200000', '140822000000');
INSERT INTO `t_s_town` VALUES ('3826', '里望乡', '140822201000', '140822000000');
INSERT INTO `t_s_town` VALUES ('3827', '西村乡', '140822202000', '140822000000');
INSERT INTO `t_s_town` VALUES ('3828', '南张乡', '140822203000', '140822000000');
INSERT INTO `t_s_town` VALUES ('3829', '高村乡', '140822204000', '140822000000');
INSERT INTO `t_s_town` VALUES ('3830', '皇甫乡', '140822205000', '140822000000');
INSERT INTO `t_s_town` VALUES ('3831', '贾村乡', '140822206000', '140822000000');
INSERT INTO `t_s_town` VALUES ('3832', '王显乡', '140822207000', '140822000000');
INSERT INTO `t_s_town` VALUES ('3833', '光华乡', '140822208000', '140822000000');
INSERT INTO `t_s_town` VALUES ('3834', '裴庄乡', '140822209000', '140822000000');
INSERT INTO `t_s_town` VALUES ('3835', '桐城镇', '140823100000', '140823000000');
INSERT INTO `t_s_town` VALUES ('3836', '郭家庄镇', '140823101000', '140823000000');
INSERT INTO `t_s_town` VALUES ('3837', '畖底镇', '140823102000', '140823000000');
INSERT INTO `t_s_town` VALUES ('3838', '薛店镇', '140823103000', '140823000000');
INSERT INTO `t_s_town` VALUES ('3839', '东镇镇', '140823104000', '140823000000');
INSERT INTO `t_s_town` VALUES ('3840', '礼元镇', '140823105000', '140823000000');
INSERT INTO `t_s_town` VALUES ('3841', '河底镇', '140823106000', '140823000000');
INSERT INTO `t_s_town` VALUES ('3842', '神柏乡', '140823200000', '140823000000');
INSERT INTO `t_s_town` VALUES ('3843', '阳隅乡', '140823201000', '140823000000');
INSERT INTO `t_s_town` VALUES ('3844', '侯村乡', '140823202000', '140823000000');
INSERT INTO `t_s_town` VALUES ('3845', '裴社乡', '140823203000', '140823000000');
INSERT INTO `t_s_town` VALUES ('3846', '后宫乡', '140823204000', '140823000000');
INSERT INTO `t_s_town` VALUES ('3847', '石门乡', '140823205000', '140823000000');
INSERT INTO `t_s_town` VALUES ('3848', '社区管理办公室', '140823400000', '140823000000');
INSERT INTO `t_s_town` VALUES ('3849', '稷峰镇', '140824100000', '140824000000');
INSERT INTO `t_s_town` VALUES ('3850', '西社镇', '140824101000', '140824000000');
INSERT INTO `t_s_town` VALUES ('3851', '化峪镇', '140824102000', '140824000000');
INSERT INTO `t_s_town` VALUES ('3852', '翟店镇', '140824103000', '140824000000');
INSERT INTO `t_s_town` VALUES ('3853', '清河镇', '140824104000', '140824000000');
INSERT INTO `t_s_town` VALUES ('3854', '蔡村乡', '140824200000', '140824000000');
INSERT INTO `t_s_town` VALUES ('3855', '太阳乡', '140824201000', '140824000000');
INSERT INTO `t_s_town` VALUES ('3856', '稷山县社区服务中心', '140824400000', '140824000000');
INSERT INTO `t_s_town` VALUES ('3857', '龙兴镇', '140825100000', '140825000000');
INSERT INTO `t_s_town` VALUES ('3858', '三泉镇', '140825101000', '140825000000');
INSERT INTO `t_s_town` VALUES ('3859', '泽掌镇', '140825102000', '140825000000');
INSERT INTO `t_s_town` VALUES ('3860', '北张镇', '140825103000', '140825000000');
INSERT INTO `t_s_town` VALUES ('3861', '古交镇', '140825104000', '140825000000');
INSERT INTO `t_s_town` VALUES ('3862', '万安镇', '140825105000', '140825000000');
INSERT INTO `t_s_town` VALUES ('3863', '阳王镇', '140825106000', '140825000000');
INSERT INTO `t_s_town` VALUES ('3864', '泉掌镇', '140825107000', '140825000000');
INSERT INTO `t_s_town` VALUES ('3865', '横桥乡', '140825200000', '140825000000');
INSERT INTO `t_s_town` VALUES ('3866', '社区办', '140825400000', '140825000000');
INSERT INTO `t_s_town` VALUES ('3867', '新绛县煤化园区管委会', '140825498000', '140825000000');
INSERT INTO `t_s_town` VALUES ('3868', '古绛镇', '140826100000', '140826000000');
INSERT INTO `t_s_town` VALUES ('3869', '横水镇', '140826101000', '140826000000');
INSERT INTO `t_s_town` VALUES ('3870', '陈村镇', '140826102000', '140826000000');
INSERT INTO `t_s_town` VALUES ('3871', '卫庄镇', '140826103000', '140826000000');
INSERT INTO `t_s_town` VALUES ('3872', '么里镇', '140826104000', '140826000000');
INSERT INTO `t_s_town` VALUES ('3873', '南樊镇', '140826105000', '140826000000');
INSERT INTO `t_s_town` VALUES ('3874', '安峪镇', '140826106000', '140826000000');
INSERT INTO `t_s_town` VALUES ('3875', '大交镇', '140826107000', '140826000000');
INSERT INTO `t_s_town` VALUES ('3876', '郝庄乡', '140826200000', '140826000000');
INSERT INTO `t_s_town` VALUES ('3877', '冷口乡', '140826201000', '140826000000');
INSERT INTO `t_s_town` VALUES ('3878', '山西绛县经济开发区', '140826402000', '140826000000');
INSERT INTO `t_s_town` VALUES ('3879', '新城镇', '140827100000', '140827000000');
INSERT INTO `t_s_town` VALUES ('3880', '历山镇', '140827101000', '140827000000');
INSERT INTO `t_s_town` VALUES ('3881', '古城镇', '140827102000', '140827000000');
INSERT INTO `t_s_town` VALUES ('3882', '王茅镇', '140827103000', '140827000000');
INSERT INTO `t_s_town` VALUES ('3883', '毛家湾镇', '140827104000', '140827000000');
INSERT INTO `t_s_town` VALUES ('3884', '蒲掌乡', '140827200000', '140827000000');
INSERT INTO `t_s_town` VALUES ('3885', '英言乡', '140827201000', '140827000000');
INSERT INTO `t_s_town` VALUES ('3886', '解峪乡', '140827202000', '140827000000');
INSERT INTO `t_s_town` VALUES ('3887', '华峰乡', '140827203000', '140827000000');
INSERT INTO `t_s_town` VALUES ('3888', '长直乡', '140827204000', '140827000000');
INSERT INTO `t_s_town` VALUES ('3889', '皋落乡', '140827205000', '140827000000');
INSERT INTO `t_s_town` VALUES ('3890', '瑶峰镇', '140828100000', '140828000000');
INSERT INTO `t_s_town` VALUES ('3891', '庙前镇', '140828101000', '140828000000');
INSERT INTO `t_s_town` VALUES ('3892', '裴介镇', '140828102000', '140828000000');
INSERT INTO `t_s_town` VALUES ('3893', '水头镇', '140828103000', '140828000000');
INSERT INTO `t_s_town` VALUES ('3894', '埝掌镇', '140828104000', '140828000000');
INSERT INTO `t_s_town` VALUES ('3895', '泗交镇', '140828105000', '140828000000');
INSERT INTO `t_s_town` VALUES ('3896', '尉郭乡', '140828200000', '140828000000');
INSERT INTO `t_s_town` VALUES ('3897', '禹王乡', '140828201000', '140828000000');
INSERT INTO `t_s_town` VALUES ('3898', '胡张乡', '140828202000', '140828000000');
INSERT INTO `t_s_town` VALUES ('3899', '南大里乡', '140828203000', '140828000000');
INSERT INTO `t_s_town` VALUES ('3900', '祁家河乡', '140828204000', '140828000000');
INSERT INTO `t_s_town` VALUES ('3901', '圣人涧镇', '140829100000', '140829000000');
INSERT INTO `t_s_town` VALUES ('3902', '常乐镇', '140829101000', '140829000000');
INSERT INTO `t_s_town` VALUES ('3903', '张店镇', '140829102000', '140829000000');
INSERT INTO `t_s_town` VALUES ('3904', '张村镇', '140829103000', '140829000000');
INSERT INTO `t_s_town` VALUES ('3905', '曹川镇', '140829104000', '140829000000');
INSERT INTO `t_s_town` VALUES ('3906', '三门镇', '140829105000', '140829000000');
INSERT INTO `t_s_town` VALUES ('3907', '洪池乡', '140829200000', '140829000000');
INSERT INTO `t_s_town` VALUES ('3908', '杜马乡', '140829201000', '140829000000');
INSERT INTO `t_s_town` VALUES ('3909', '部官乡', '140829202000', '140829000000');
INSERT INTO `t_s_town` VALUES ('3910', '坡底乡', '140829203000', '140829000000');
INSERT INTO `t_s_town` VALUES ('3911', '古魏镇', '140830100000', '140830000000');
INSERT INTO `t_s_town` VALUES ('3912', '风陵渡镇', '140830101000', '140830000000');
INSERT INTO `t_s_town` VALUES ('3913', '陌南镇', '140830102000', '140830000000');
INSERT INTO `t_s_town` VALUES ('3914', '西陌镇', '140830103000', '140830000000');
INSERT INTO `t_s_town` VALUES ('3915', '永乐镇', '140830104000', '140830000000');
INSERT INTO `t_s_town` VALUES ('3916', '大王镇', '140830105000', '140830000000');
INSERT INTO `t_s_town` VALUES ('3917', '阳城镇', '140830106000', '140830000000');
INSERT INTO `t_s_town` VALUES ('3918', '东垆乡', '140830200000', '140830000000');
INSERT INTO `t_s_town` VALUES ('3919', '南卫乡', '140830201000', '140830000000');
INSERT INTO `t_s_town` VALUES ('3920', '学张乡', '140830202000', '140830000000');
INSERT INTO `t_s_town` VALUES ('3921', '城镇社区管理委员会', '140830401000', '140830000000');
INSERT INTO `t_s_town` VALUES ('3922', '山西风陵渡经济开发区', '140830402000', '140830000000');
INSERT INTO `t_s_town` VALUES ('3923', '城西街道办事处', '140881001000', '140881000000');
INSERT INTO `t_s_town` VALUES ('3924', '城北街道办事处', '140881002000', '140881000000');
INSERT INTO `t_s_town` VALUES ('3925', '城东街道办事处', '140881003000', '140881000000');
INSERT INTO `t_s_town` VALUES ('3926', '虞乡镇', '140881100000', '140881000000');
INSERT INTO `t_s_town` VALUES ('3927', '卿头镇', '140881101000', '140881000000');
INSERT INTO `t_s_town` VALUES ('3928', '开张镇', '140881102000', '140881000000');
INSERT INTO `t_s_town` VALUES ('3929', '栲栳镇', '140881103000', '140881000000');
INSERT INTO `t_s_town` VALUES ('3930', '蒲州镇', '140881104000', '140881000000');
INSERT INTO `t_s_town` VALUES ('3931', '韩阳镇', '140881105000', '140881000000');
INSERT INTO `t_s_town` VALUES ('3932', '张营镇', '140881106000', '140881000000');
INSERT INTO `t_s_town` VALUES ('3933', '伍姓湖农场', '140881400000', '140881000000');
INSERT INTO `t_s_town` VALUES ('3934', '虞乡农场', '140881401000', '140881000000');
INSERT INTO `t_s_town` VALUES ('3935', '董村农场', '140881402000', '140881000000');
INSERT INTO `t_s_town` VALUES ('3936', '城区街道办事处', '140882001000', '140882000000');
INSERT INTO `t_s_town` VALUES ('3937', '清涧街道办事处', '140882002000', '140882000000');
INSERT INTO `t_s_town` VALUES ('3938', '樊村镇', '140882100000', '140882000000');
INSERT INTO `t_s_town` VALUES ('3939', '僧楼镇', '140882101000', '140882000000');
INSERT INTO `t_s_town` VALUES ('3940', '小梁乡', '140882200000', '140882000000');
INSERT INTO `t_s_town` VALUES ('3941', '柴家乡', '140882201000', '140882000000');
INSERT INTO `t_s_town` VALUES ('3942', '赵家庄乡', '140882202000', '140882000000');
INSERT INTO `t_s_town` VALUES ('3943', '下化乡', '140882203000', '140882000000');
INSERT INTO `t_s_town` VALUES ('3944', '阳村乡', '140882204000', '140882000000');
INSERT INTO `t_s_town` VALUES ('3945', '山西铝厂', '140882450000', '140882000000');
INSERT INTO `t_s_town` VALUES ('3946', '秀容街道办事处', '140902001000', '140902000000');
INSERT INTO `t_s_town` VALUES ('3947', '长征街街道办事处', '140902002000', '140902000000');
INSERT INTO `t_s_town` VALUES ('3948', '新建路街道办事处', '140902003000', '140902000000');
INSERT INTO `t_s_town` VALUES ('3949', '播明镇', '140902100000', '140902000000');
INSERT INTO `t_s_town` VALUES ('3950', '奇村镇', '140902101000', '140902000000');
INSERT INTO `t_s_town` VALUES ('3951', '三交镇', '140902102000', '140902000000');
INSERT INTO `t_s_town` VALUES ('3952', '庄磨镇', '140902103000', '140902000000');
INSERT INTO `t_s_town` VALUES ('3953', '豆罗镇', '140902104000', '140902000000');
INSERT INTO `t_s_town` VALUES ('3954', '董村镇', '140902105000', '140902000000');
INSERT INTO `t_s_town` VALUES ('3955', '曹张乡', '140902200000', '140902000000');
INSERT INTO `t_s_town` VALUES ('3956', '高城乡', '140902201000', '140902000000');
INSERT INTO `t_s_town` VALUES ('3957', '秦城乡', '140902202000', '140902000000');
INSERT INTO `t_s_town` VALUES ('3958', '解原乡', '140902203000', '140902000000');
INSERT INTO `t_s_town` VALUES ('3959', '合索乡', '140902204000', '140902000000');
INSERT INTO `t_s_town` VALUES ('3960', '阳坡乡', '140902205000', '140902000000');
INSERT INTO `t_s_town` VALUES ('3961', '兰村乡', '140902206000', '140902000000');
INSERT INTO `t_s_town` VALUES ('3962', '紫岩乡', '140902207000', '140902000000');
INSERT INTO `t_s_town` VALUES ('3963', '西张乡', '140902208000', '140902000000');
INSERT INTO `t_s_town` VALUES ('3964', '东楼乡', '140902209000', '140902000000');
INSERT INTO `t_s_town` VALUES ('3965', '北义井乡', '140902210000', '140902000000');
INSERT INTO `t_s_town` VALUES ('3966', '晋昌镇', '140921100000', '140921000000');
INSERT INTO `t_s_town` VALUES ('3967', '河边镇', '140921101000', '140921000000');
INSERT INTO `t_s_town` VALUES ('3968', '宏道镇', '140921102000', '140921000000');
INSERT INTO `t_s_town` VALUES ('3969', '杨芳乡', '140921200000', '140921000000');
INSERT INTO `t_s_town` VALUES ('3970', '南王乡', '140921201000', '140921000000');
INSERT INTO `t_s_town` VALUES ('3971', '蒋村乡', '140921202000', '140921000000');
INSERT INTO `t_s_town` VALUES ('3972', '神山乡', '140921203000', '140921000000');
INSERT INTO `t_s_town` VALUES ('3973', '季庄乡', '140921204000', '140921000000');
INSERT INTO `t_s_town` VALUES ('3974', '受禄乡', '140921205000', '140921000000');
INSERT INTO `t_s_town` VALUES ('3975', '台城镇', '140922100000', '140922000000');
INSERT INTO `t_s_town` VALUES ('3976', '耿镇镇', '140922102000', '140922000000');
INSERT INTO `t_s_town` VALUES ('3977', '豆村镇', '140922103000', '140922000000');
INSERT INTO `t_s_town` VALUES ('3978', '白家庄镇', '140922104000', '140922000000');
INSERT INTO `t_s_town` VALUES ('3979', '东冶镇', '140922105000', '140922000000');
INSERT INTO `t_s_town` VALUES ('3980', '沟南乡', '140922200000', '140922000000');
INSERT INTO `t_s_town` VALUES ('3981', '东雷乡', '140922201000', '140922000000');
INSERT INTO `t_s_town` VALUES ('3982', '高洪口乡', '140922202000', '140922000000');
INSERT INTO `t_s_town` VALUES ('3983', '门限石乡', '140922203000', '140922000000');
INSERT INTO `t_s_town` VALUES ('3984', '陈家庄乡', '140922204000', '140922000000');
INSERT INTO `t_s_town` VALUES ('3985', '建安乡', '140922205000', '140922000000');
INSERT INTO `t_s_town` VALUES ('3986', '神西乡', '140922206000', '140922000000');
INSERT INTO `t_s_town` VALUES ('3987', '蒋坊乡', '140922207000', '140922000000');
INSERT INTO `t_s_town` VALUES ('3988', '灵境乡', '140922208000', '140922000000');
INSERT INTO `t_s_town` VALUES ('3989', '阳白乡', '140922209000', '140922000000');
INSERT INTO `t_s_town` VALUES ('3990', '茹村乡', '140922210000', '140922000000');
INSERT INTO `t_s_town` VALUES ('3991', '上馆镇', '140923100000', '140923000000');
INSERT INTO `t_s_town` VALUES ('3992', '阳明堡镇', '140923101000', '140923000000');
INSERT INTO `t_s_town` VALUES ('3993', '峨口镇', '140923102000', '140923000000');
INSERT INTO `t_s_town` VALUES ('3994', '聂营镇', '140923103000', '140923000000');
INSERT INTO `t_s_town` VALUES ('3995', '枣林镇', '140923104000', '140923000000');
INSERT INTO `t_s_town` VALUES ('3996', '滩上镇', '140923105000', '140923000000');
INSERT INTO `t_s_town` VALUES ('3997', '新高乡', '140923200000', '140923000000');
INSERT INTO `t_s_town` VALUES ('3998', '峪口乡', '140923201000', '140923000000');
INSERT INTO `t_s_town` VALUES ('3999', '上磨坊乡', '140923202000', '140923000000');
INSERT INTO `t_s_town` VALUES ('4000', '胡峪乡', '140923203000', '140923000000');
INSERT INTO `t_s_town` VALUES ('4001', '雁门关乡', '140923204000', '140923000000');
INSERT INTO `t_s_town` VALUES ('4002', '繁城镇', '140924100000', '140924000000');
INSERT INTO `t_s_town` VALUES ('4003', '砂河镇', '140924101000', '140924000000');
INSERT INTO `t_s_town` VALUES ('4004', '大营镇', '140924102000', '140924000000');
INSERT INTO `t_s_town` VALUES ('4005', '下茹越乡', '140924200000', '140924000000');
INSERT INTO `t_s_town` VALUES ('4006', '杏园乡', '140924201000', '140924000000');
INSERT INTO `t_s_town` VALUES ('4007', '光裕堡乡', '140924202000', '140924000000');
INSERT INTO `t_s_town` VALUES ('4008', '集义庄乡', '140924203000', '140924000000');
INSERT INTO `t_s_town` VALUES ('4009', '东山乡', '140924204000', '140924000000');
INSERT INTO `t_s_town` VALUES ('4010', '金山铺乡', '140924205000', '140924000000');
INSERT INTO `t_s_town` VALUES ('4011', '柏家庄乡', '140924206000', '140924000000');
INSERT INTO `t_s_town` VALUES ('4012', '横涧乡', '140924207000', '140924000000');
INSERT INTO `t_s_town` VALUES ('4013', '神堂堡乡', '140924208000', '140924000000');
INSERT INTO `t_s_town` VALUES ('4014', '岩头乡', '140924209000', '140924000000');
INSERT INTO `t_s_town` VALUES ('4015', '繁峙县城居民办事处', '140924401000', '140924000000');
INSERT INTO `t_s_town` VALUES ('4016', '凤凰镇', '140925100000', '140925000000');
INSERT INTO `t_s_town` VALUES ('4017', '阳方口镇', '140925101000', '140925000000');
INSERT INTO `t_s_town` VALUES ('4018', '东寨镇', '140925102000', '140925000000');
INSERT INTO `t_s_town` VALUES ('4019', '石家庄镇', '140925103000', '140925000000');
INSERT INTO `t_s_town` VALUES ('4020', '薛家洼乡', '140925200000', '140925000000');
INSERT INTO `t_s_town` VALUES ('4021', '余庄乡', '140925201000', '140925000000');
INSERT INTO `t_s_town` VALUES ('4022', '涔山乡', '140925202000', '140925000000');
INSERT INTO `t_s_town` VALUES ('4023', '化北屯乡', '140925203000', '140925000000');
INSERT INTO `t_s_town` VALUES ('4024', '西马坊乡', '140925204000', '140925000000');
INSERT INTO `t_s_town` VALUES ('4025', '新堡乡', '140925205000', '140925000000');
INSERT INTO `t_s_town` VALUES ('4026', '迭台寺乡', '140925206000', '140925000000');
INSERT INTO `t_s_town` VALUES ('4027', '圪廖乡', '140925207000', '140925000000');
INSERT INTO `t_s_town` VALUES ('4028', '怀道乡', '140925208000', '140925000000');
INSERT INTO `t_s_town` VALUES ('4029', '东马坊乡', '140925209000', '140925000000');
INSERT INTO `t_s_town` VALUES ('4030', '阳方口煤矿生活区', '140925400000', '140925000000');
INSERT INTO `t_s_town` VALUES ('4031', '城区居民办事处', '140925401000', '140925000000');
INSERT INTO `t_s_town` VALUES ('4032', '鹅城镇', '140926100000', '140926000000');
INSERT INTO `t_s_town` VALUES ('4033', '杜家村镇', '140926101000', '140926000000');
INSERT INTO `t_s_town` VALUES ('4034', '康家会镇', '140926102000', '140926000000');
INSERT INTO `t_s_town` VALUES ('4035', '丰润镇', '140926103000', '140926000000');
INSERT INTO `t_s_town` VALUES ('4036', '堂尔上乡', '140926201000', '140926000000');
INSERT INTO `t_s_town` VALUES ('4037', '中庄乡', '140926202000', '140926000000');
INSERT INTO `t_s_town` VALUES ('4038', '双路乡', '140926203000', '140926000000');
INSERT INTO `t_s_town` VALUES ('4039', '段家寨乡', '140926204000', '140926000000');
INSERT INTO `t_s_town` VALUES ('4040', '辛村乡', '140926205000', '140926000000');
INSERT INTO `t_s_town` VALUES ('4041', '王村乡', '140926206000', '140926000000');
INSERT INTO `t_s_town` VALUES ('4042', '神峪沟乡', '140926207000', '140926000000');
INSERT INTO `t_s_town` VALUES ('4043', '娘子神乡', '140926208000', '140926000000');
INSERT INTO `t_s_town` VALUES ('4044', '娑婆乡', '140926209000', '140926000000');
INSERT INTO `t_s_town` VALUES ('4045', '赤泥洼乡', '140926210000', '140926000000');
INSERT INTO `t_s_town` VALUES ('4046', '龙泉镇', '140927100000', '140927000000');
INSERT INTO `t_s_town` VALUES ('4047', '义井镇', '140927101000', '140927000000');
INSERT INTO `t_s_town` VALUES ('4048', '八角镇', '140927102000', '140927000000');
INSERT INTO `t_s_town` VALUES ('4049', '东湖乡', '140927200000', '140927000000');
INSERT INTO `t_s_town` VALUES ('4050', '太平庄乡', '140927201000', '140927000000');
INSERT INTO `t_s_town` VALUES ('4051', '虎北乡', '140927202000', '140927000000');
INSERT INTO `t_s_town` VALUES ('4052', '贺职乡', '140927203000', '140927000000');
INSERT INTO `t_s_town` VALUES ('4053', '长畛乡', '140927204000', '140927000000');
INSERT INTO `t_s_town` VALUES ('4054', '烈堡乡', '140927205000', '140927000000');
INSERT INTO `t_s_town` VALUES ('4055', '大严备乡', '140927206000', '140927000000');
INSERT INTO `t_s_town` VALUES ('4056', '砚城镇', '140928100000', '140928000000');
INSERT INTO `t_s_town` VALUES ('4057', '小河头镇', '140928101000', '140928000000');
INSERT INTO `t_s_town` VALUES ('4058', '三岔镇', '140928102000', '140928000000');
INSERT INTO `t_s_town` VALUES ('4059', '前所乡', '140928200000', '140928000000');
INSERT INTO `t_s_town` VALUES ('4060', '李家坪乡', '140928201000', '140928000000');
INSERT INTO `t_s_town` VALUES ('4061', '孙家坪乡', '140928202000', '140928000000');
INSERT INTO `t_s_town` VALUES ('4062', '梁家坪乡', '140928203000', '140928000000');
INSERT INTO `t_s_town` VALUES ('4063', '胡会乡', '140928204000', '140928000000');
INSERT INTO `t_s_town` VALUES ('4064', '新寨乡', '140928205000', '140928000000');
INSERT INTO `t_s_town` VALUES ('4065', '韩家楼乡', '140928206000', '140928000000');
INSERT INTO `t_s_town` VALUES ('4066', '东秀庄乡', '140928207000', '140928000000');
INSERT INTO `t_s_town` VALUES ('4067', '杏岭子乡', '140928208000', '140928000000');
INSERT INTO `t_s_town` VALUES ('4068', '岚漪镇', '140929100000', '140929000000');
INSERT INTO `t_s_town` VALUES ('4069', '三井镇', '140929101000', '140929000000');
INSERT INTO `t_s_town` VALUES ('4070', '神堂坪乡', '140929200000', '140929000000');
INSERT INTO `t_s_town` VALUES ('4071', '高家会乡', '140929201000', '140929000000');
INSERT INTO `t_s_town` VALUES ('4072', '李家沟乡', '140929202000', '140929000000');
INSERT INTO `t_s_town` VALUES ('4073', '水峪贯乡', '140929203000', '140929000000');
INSERT INTO `t_s_town` VALUES ('4074', '西豹峪乡', '140929204000', '140929000000');
INSERT INTO `t_s_town` VALUES ('4075', '温泉乡', '140929205000', '140929000000');
INSERT INTO `t_s_town` VALUES ('4076', '阳坪乡', '140929206000', '140929000000');
INSERT INTO `t_s_town` VALUES ('4077', '大涧乡', '140929207000', '140929000000');
INSERT INTO `t_s_town` VALUES ('4078', '宋家沟乡', '140929208000', '140929000000');
INSERT INTO `t_s_town` VALUES ('4079', '王家岔乡', '140929209000', '140929000000');
INSERT INTO `t_s_town` VALUES ('4080', '文笔镇', '140930100000', '140930000000');
INSERT INTO `t_s_town` VALUES ('4081', '楼子营镇', '140930101000', '140930000000');
INSERT INTO `t_s_town` VALUES ('4082', '刘家塔镇', '140930102000', '140930000000');
INSERT INTO `t_s_town` VALUES ('4083', '巡镇镇', '140930103000', '140930000000');
INSERT INTO `t_s_town` VALUES ('4084', '鹿固乡', '140930200000', '140930000000');
INSERT INTO `t_s_town` VALUES ('4085', '前川乡', '140930201000', '140930000000');
INSERT INTO `t_s_town` VALUES ('4086', '单寨乡', '140930202000', '140930000000');
INSERT INTO `t_s_town` VALUES ('4087', '土沟乡', '140930203000', '140930000000');
INSERT INTO `t_s_town` VALUES ('4088', '旧县乡', '140930204000', '140930000000');
INSERT INTO `t_s_town` VALUES ('4089', '沙坪乡', '140930205000', '140930000000');
INSERT INTO `t_s_town` VALUES ('4090', '社梁乡', '140930206000', '140930000000');
INSERT INTO `t_s_town` VALUES ('4091', '沙泉乡', '140930207000', '140930000000');
INSERT INTO `t_s_town` VALUES ('4092', '赵家沟乡', '140930208000', '140930000000');
INSERT INTO `t_s_town` VALUES ('4093', '河曲县居民办事处', '140930400000', '140930000000');
INSERT INTO `t_s_town` VALUES ('4094', '东关镇', '140931100000', '140931000000');
INSERT INTO `t_s_town` VALUES ('4095', '义门镇', '140931101000', '140931000000');
INSERT INTO `t_s_town` VALUES ('4096', '桥头镇', '140931102000', '140931000000');
INSERT INTO `t_s_town` VALUES ('4097', '杨家湾镇', '140931103000', '140931000000');
INSERT INTO `t_s_town` VALUES ('4098', '腰庄乡', '140931200000', '140931000000');
INSERT INTO `t_s_town` VALUES ('4099', '韩家川乡', '140931201000', '140931000000');
INSERT INTO `t_s_town` VALUES ('4100', '林遮峪乡', '140931202000', '140931000000');
INSERT INTO `t_s_town` VALUES ('4101', '冯家川乡', '140931203000', '140931000000');
INSERT INTO `t_s_town` VALUES ('4102', '土崖塔乡', '140931204000', '140931000000');
INSERT INTO `t_s_town` VALUES ('4103', '孙家沟乡', '140931205000', '140931000000');
INSERT INTO `t_s_town` VALUES ('4104', '窑洼乡', '140931206000', '140931000000');
INSERT INTO `t_s_town` VALUES ('4105', '窑圪台乡', '140931207000', '140931000000');
INSERT INTO `t_s_town` VALUES ('4106', '南河沟乡', '140931208000', '140931000000');
INSERT INTO `t_s_town` VALUES ('4107', '新关镇', '140932100000', '140932000000');
INSERT INTO `t_s_town` VALUES ('4108', '天峰坪镇', '140932101000', '140932000000');
INSERT INTO `t_s_town` VALUES ('4109', '老营镇', '140932102000', '140932000000');
INSERT INTO `t_s_town` VALUES ('4110', '万家寨镇', '140932103000', '140932000000');
INSERT INTO `t_s_town` VALUES ('4111', '窑头乡', '140932200000', '140932000000');
INSERT INTO `t_s_town` VALUES ('4112', '楼沟乡', '140932201000', '140932000000');
INSERT INTO `t_s_town` VALUES ('4113', '尚峪乡', '140932202000', '140932000000');
INSERT INTO `t_s_town` VALUES ('4114', '南堡子乡', '140932203000', '140932000000');
INSERT INTO `t_s_town` VALUES ('4115', '水泉乡', '140932204000', '140932000000');
INSERT INTO `t_s_town` VALUES ('4116', '陈家营乡', '140932205000', '140932000000');
INSERT INTO `t_s_town` VALUES ('4117', '台怀镇', '140971100000', '140971000000');
INSERT INTO `t_s_town` VALUES ('4118', '金岗库乡', '140971200000', '140971000000');
INSERT INTO `t_s_town` VALUES ('4119', '石咀乡', '140971201000', '140971000000');
INSERT INTO `t_s_town` VALUES ('4120', '北城街道办事处', '140981001000', '140981000000');
INSERT INTO `t_s_town` VALUES ('4121', '南城街道办事处', '140981002000', '140981000000');
INSERT INTO `t_s_town` VALUES ('4122', '轩煤矿区街道办事处', '140981003000', '140981000000');
INSERT INTO `t_s_town` VALUES ('4123', '东社镇', '140981100000', '140981000000');
INSERT INTO `t_s_town` VALUES ('4124', '苏龙口镇', '140981101000', '140981000000');
INSERT INTO `t_s_town` VALUES ('4125', '崞阳镇', '140981102000', '140981000000');
INSERT INTO `t_s_town` VALUES ('4126', '大牛店镇', '140981103000', '140981000000');
INSERT INTO `t_s_town` VALUES ('4127', '闫庄镇', '140981104000', '140981000000');
INSERT INTO `t_s_town` VALUES ('4128', '长梁沟镇', '140981105000', '140981000000');
INSERT INTO `t_s_town` VALUES ('4129', '轩岗镇', '140981106000', '140981000000');
INSERT INTO `t_s_town` VALUES ('4130', '新原乡', '140981200000', '140981000000');
INSERT INTO `t_s_town` VALUES ('4131', '南白乡', '140981201000', '140981000000');
INSERT INTO `t_s_town` VALUES ('4132', '子干乡', '140981202000', '140981000000');
INSERT INTO `t_s_town` VALUES ('4133', '中阳乡', '140981203000', '140981000000');
INSERT INTO `t_s_town` VALUES ('4134', '沿沟乡', '140981204000', '140981000000');
INSERT INTO `t_s_town` VALUES ('4135', '大林乡', '140981205000', '140981000000');
INSERT INTO `t_s_town` VALUES ('4136', '西镇乡', '140981206000', '140981000000');
INSERT INTO `t_s_town` VALUES ('4137', '解村乡', '140981207000', '140981000000');
INSERT INTO `t_s_town` VALUES ('4138', '王家庄乡', '140981208000', '140981000000');
INSERT INTO `t_s_town` VALUES ('4139', '楼板寨乡', '140981209000', '140981000000');
INSERT INTO `t_s_town` VALUES ('4140', '段家堡乡', '140981210000', '140981000000');
INSERT INTO `t_s_town` VALUES ('4141', '山西鲁能晋北铝业工矿区', '140981400000', '140981000000');
INSERT INTO `t_s_town` VALUES ('4142', '原平市石豹沟煤矿工矿区', '140981401000', '140981000000');
INSERT INTO `t_s_town` VALUES ('4143', '原平农场', '140981403000', '140981000000');
INSERT INTO `t_s_town` VALUES ('4144', '解放路街道办事处', '141002001000', '141002000000');
INSERT INTO `t_s_town` VALUES ('4145', '鼓楼西街街道办事处', '141002002000', '141002000000');
INSERT INTO `t_s_town` VALUES ('4146', '水塔街街道办事处', '141002003000', '141002000000');
INSERT INTO `t_s_town` VALUES ('4147', '南街街道办事处', '141002004000', '141002000000');
INSERT INTO `t_s_town` VALUES ('4148', '乡贤街街道办事处', '141002005000', '141002000000');
INSERT INTO `t_s_town` VALUES ('4149', '辛寺街街道办事处', '141002006000', '141002000000');
INSERT INTO `t_s_town` VALUES ('4150', '铁路东街道办事处', '141002007000', '141002000000');
INSERT INTO `t_s_town` VALUES ('4151', '车站街街道办事处', '141002008000', '141002000000');
INSERT INTO `t_s_town` VALUES ('4152', '汾河街道办事处', '141002009000', '141002000000');
INSERT INTO `t_s_town` VALUES ('4153', '滨河办事处', '141002010000', '141002000000');
INSERT INTO `t_s_town` VALUES ('4154', '屯里镇', '141002100000', '141002000000');
INSERT INTO `t_s_town` VALUES ('4155', '乔李镇', '141002101000', '141002000000');
INSERT INTO `t_s_town` VALUES ('4156', '大阳镇', '141002102000', '141002000000');
INSERT INTO `t_s_town` VALUES ('4157', '县底镇', '141002103000', '141002000000');
INSERT INTO `t_s_town` VALUES ('4158', '刘村镇', '141002104000', '141002000000');
INSERT INTO `t_s_town` VALUES ('4159', '金殿镇', '141002105000', '141002000000');
INSERT INTO `t_s_town` VALUES ('4160', '吴村镇', '141002106000', '141002000000');
INSERT INTO `t_s_town` VALUES ('4161', '土门镇', '141002107000', '141002000000');
INSERT INTO `t_s_town` VALUES ('4162', '魏村镇', '141002108000', '141002000000');
INSERT INTO `t_s_town` VALUES ('4163', '尧庙镇', '141002109000', '141002000000');
INSERT INTO `t_s_town` VALUES ('4164', '段店乡', '141002200000', '141002000000');
INSERT INTO `t_s_town` VALUES ('4165', '贾得乡', '141002201000', '141002000000');
INSERT INTO `t_s_town` VALUES ('4166', '贺家庄乡', '141002202000', '141002000000');
INSERT INTO `t_s_town` VALUES ('4167', '一平垣乡', '141002203000', '141002000000');
INSERT INTO `t_s_town` VALUES ('4168', '枕头乡', '141002204000', '141002000000');
INSERT INTO `t_s_town` VALUES ('4169', '河底乡', '141002205000', '141002000000');
INSERT INTO `t_s_town` VALUES ('4170', '乐昌镇', '141021100000', '141021000000');
INSERT INTO `t_s_town` VALUES ('4171', '史村镇', '141021101000', '141021000000');
INSERT INTO `t_s_town` VALUES ('4172', '曲村镇', '141021102000', '141021000000');
INSERT INTO `t_s_town` VALUES ('4173', '高显镇', '141021103000', '141021000000');
INSERT INTO `t_s_town` VALUES ('4174', '里村镇', '141021104000', '141021000000');
INSERT INTO `t_s_town` VALUES ('4175', '北董乡', '141021200000', '141021000000');
INSERT INTO `t_s_town` VALUES ('4176', '杨谈乡', '141021201000', '141021000000');
INSERT INTO `t_s_town` VALUES ('4177', '唐兴镇', '141022100000', '141022000000');
INSERT INTO `t_s_town` VALUES ('4178', '南梁镇', '141022101000', '141022000000');
INSERT INTO `t_s_town` VALUES ('4179', '里砦镇', '141022102000', '141022000000');
INSERT INTO `t_s_town` VALUES ('4180', '隆化镇', '141022103000', '141022000000');
INSERT INTO `t_s_town` VALUES ('4181', '桥上镇', '141022104000', '141022000000');
INSERT INTO `t_s_town` VALUES ('4182', '西阎镇', '141022105000', '141022000000');
INSERT INTO `t_s_town` VALUES ('4183', '中卫乡', '141022200000', '141022000000');
INSERT INTO `t_s_town` VALUES ('4184', '南唐乡', '141022201000', '141022000000');
INSERT INTO `t_s_town` VALUES ('4185', '王庄乡', '141022202000', '141022000000');
INSERT INTO `t_s_town` VALUES ('4186', '浇底乡', '141022203000', '141022000000');
INSERT INTO `t_s_town` VALUES ('4187', '新城镇', '141023100000', '141023000000');
INSERT INTO `t_s_town` VALUES ('4188', '赵康镇', '141023101000', '141023000000');
INSERT INTO `t_s_town` VALUES ('4189', '汾城镇', '141023102000', '141023000000');
INSERT INTO `t_s_town` VALUES ('4190', '南贾镇', '141023103000', '141023000000');
INSERT INTO `t_s_town` VALUES ('4191', '古城镇', '141023104000', '141023000000');
INSERT INTO `t_s_town` VALUES ('4192', '襄陵镇', '141023105000', '141023000000');
INSERT INTO `t_s_town` VALUES ('4193', '邓庄镇', '141023106000', '141023000000');
INSERT INTO `t_s_town` VALUES ('4194', '陶寺乡', '141023200000', '141023000000');
INSERT INTO `t_s_town` VALUES ('4195', '永固乡', '141023201000', '141023000000');
INSERT INTO `t_s_town` VALUES ('4196', '景毛乡', '141023202000', '141023000000');
INSERT INTO `t_s_town` VALUES ('4197', '西贾乡', '141023203000', '141023000000');
INSERT INTO `t_s_town` VALUES ('4198', '南辛店乡', '141023204000', '141023000000');
INSERT INTO `t_s_town` VALUES ('4199', '大邓乡', '141023205000', '141023000000');
INSERT INTO `t_s_town` VALUES ('4200', '大槐树镇', '141024100000', '141024000000');
INSERT INTO `t_s_town` VALUES ('4201', '甘亭镇', '141024101000', '141024000000');
INSERT INTO `t_s_town` VALUES ('4202', '曲亭镇', '141024102000', '141024000000');
INSERT INTO `t_s_town` VALUES ('4203', '苏堡镇', '141024103000', '141024000000');
INSERT INTO `t_s_town` VALUES ('4204', '广胜寺镇', '141024104000', '141024000000');
INSERT INTO `t_s_town` VALUES ('4205', '明姜镇', '141024105000', '141024000000');
INSERT INTO `t_s_town` VALUES ('4206', '赵城镇', '141024106000', '141024000000');
INSERT INTO `t_s_town` VALUES ('4207', '万安镇', '141024107000', '141024000000');
INSERT INTO `t_s_town` VALUES ('4208', '刘家垣镇', '141024108000', '141024000000');
INSERT INTO `t_s_town` VALUES ('4209', '淹底乡', '141024200000', '141024000000');
INSERT INTO `t_s_town` VALUES ('4210', '兴唐寺乡', '141024201000', '141024000000');
INSERT INTO `t_s_town` VALUES ('4211', '堤村乡', '141024202000', '141024000000');
INSERT INTO `t_s_town` VALUES ('4212', '辛村乡', '141024203000', '141024000000');
INSERT INTO `t_s_town` VALUES ('4213', '龙马乡', '141024204000', '141024000000');
INSERT INTO `t_s_town` VALUES ('4214', '山头乡', '141024205000', '141024000000');
INSERT INTO `t_s_town` VALUES ('4215', '左木乡', '141024206000', '141024000000');
INSERT INTO `t_s_town` VALUES ('4216', '岳阳镇', '141025100000', '141025000000');
INSERT INTO `t_s_town` VALUES ('4217', '北平镇', '141025101000', '141025000000');
INSERT INTO `t_s_town` VALUES ('4218', '古阳镇', '141025102000', '141025000000');
INSERT INTO `t_s_town` VALUES ('4219', '旧县镇', '141025103000', '141025000000');
INSERT INTO `t_s_town` VALUES ('4220', '石壁乡', '141025200000', '141025000000');
INSERT INTO `t_s_town` VALUES ('4221', '永乐乡', '141025201000', '141025000000');
INSERT INTO `t_s_town` VALUES ('4222', '南垣乡', '141025202000', '141025000000');
INSERT INTO `t_s_town` VALUES ('4223', '府城镇', '141026100000', '141026000000');
INSERT INTO `t_s_town` VALUES ('4224', '和川镇', '141026101000', '141026000000');
INSERT INTO `t_s_town` VALUES ('4225', '唐城镇', '141026102000', '141026000000');
INSERT INTO `t_s_town` VALUES ('4226', '冀氏镇', '141026103000', '141026000000');
INSERT INTO `t_s_town` VALUES ('4227', '马必乡', '141026200000', '141026000000');
INSERT INTO `t_s_town` VALUES ('4228', '杜村乡', '141026201000', '141026000000');
INSERT INTO `t_s_town` VALUES ('4229', '良马乡', '141026202000', '141026000000');
INSERT INTO `t_s_town` VALUES ('4230', '天坛镇', '141027100000', '141027000000');
INSERT INTO `t_s_town` VALUES ('4231', '响水河镇', '141027101000', '141027000000');
INSERT INTO `t_s_town` VALUES ('4232', '张庄乡', '141027200000', '141027000000');
INSERT INTO `t_s_town` VALUES ('4233', '东张乡', '141027201000', '141027000000');
INSERT INTO `t_s_town` VALUES ('4234', '槐埝乡', '141027202000', '141027000000');
INSERT INTO `t_s_town` VALUES ('4235', '北王乡', '141027203000', '141027000000');
INSERT INTO `t_s_town` VALUES ('4236', '北韩乡', '141027204000', '141027000000');
INSERT INTO `t_s_town` VALUES ('4237', '米家垣乡', '141027205000', '141027000000');
INSERT INTO `t_s_town` VALUES ('4238', '寨圪塔乡', '141027206000', '141027000000');
INSERT INTO `t_s_town` VALUES ('4239', '吉昌镇', '141028100000', '141028000000');
INSERT INTO `t_s_town` VALUES ('4240', '屯里镇', '141028101000', '141028000000');
INSERT INTO `t_s_town` VALUES ('4241', '壶口镇', '141028102000', '141028000000');
INSERT INTO `t_s_town` VALUES ('4242', '车城乡', '141028200000', '141028000000');
INSERT INTO `t_s_town` VALUES ('4243', '文城乡', '141028201000', '141028000000');
INSERT INTO `t_s_town` VALUES ('4244', '东城乡', '141028202000', '141028000000');
INSERT INTO `t_s_town` VALUES ('4245', '柏山寺乡', '141028203000', '141028000000');
INSERT INTO `t_s_town` VALUES ('4246', '中垛乡', '141028204000', '141028000000');
INSERT INTO `t_s_town` VALUES ('4247', '昌宁镇', '141029100000', '141029000000');
INSERT INTO `t_s_town` VALUES ('4248', '光华镇', '141029101000', '141029000000');
INSERT INTO `t_s_town` VALUES ('4249', '台头镇', '141029102000', '141029000000');
INSERT INTO `t_s_town` VALUES ('4250', '管头镇', '141029103000', '141029000000');
INSERT INTO `t_s_town` VALUES ('4251', '西坡镇', '141029104000', '141029000000');
INSERT INTO `t_s_town` VALUES ('4252', '双鹤乡', '141029200000', '141029000000');
INSERT INTO `t_s_town` VALUES ('4253', '关王庙乡', '141029201000', '141029000000');
INSERT INTO `t_s_town` VALUES ('4254', '尉庄乡', '141029202000', '141029000000');
INSERT INTO `t_s_town` VALUES ('4255', '西交口乡', '141029203000', '141029000000');
INSERT INTO `t_s_town` VALUES ('4256', '枣岭乡', '141029204000', '141029000000');
INSERT INTO `t_s_town` VALUES ('4257', '昕水镇', '141030100000', '141030000000');
INSERT INTO `t_s_town` VALUES ('4258', '曲峨镇', '141030101000', '141030000000');
INSERT INTO `t_s_town` VALUES ('4259', '三多乡', '141030200000', '141030000000');
INSERT INTO `t_s_town` VALUES ('4260', '太德乡', '141030201000', '141030000000');
INSERT INTO `t_s_town` VALUES ('4261', '徐家垛乡', '141030202000', '141030000000');
INSERT INTO `t_s_town` VALUES ('4262', '太古乡', '141030203000', '141030000000');
INSERT INTO `t_s_town` VALUES ('4263', '龙泉镇', '141031100000', '141031000000');
INSERT INTO `t_s_town` VALUES ('4264', '午城镇', '141031101000', '141031000000');
INSERT INTO `t_s_town` VALUES ('4265', '黄土镇', '141031102000', '141031000000');
INSERT INTO `t_s_town` VALUES ('4266', '阳头升乡', '141031200000', '141031000000');
INSERT INTO `t_s_town` VALUES ('4267', '寨子乡', '141031201000', '141031000000');
INSERT INTO `t_s_town` VALUES ('4268', '陡坡乡', '141031202000', '141031000000');
INSERT INTO `t_s_town` VALUES ('4269', '下李乡', '141031203000', '141031000000');
INSERT INTO `t_s_town` VALUES ('4270', '城南乡', '141031204000', '141031000000');
INSERT INTO `t_s_town` VALUES ('4271', '芝河镇', '141032100000', '141032000000');
INSERT INTO `t_s_town` VALUES ('4272', '桑壁镇', '141032101000', '141032000000');
INSERT INTO `t_s_town` VALUES ('4273', '阁底乡', '141032200000', '141032000000');
INSERT INTO `t_s_town` VALUES ('4274', '南庄乡', '141032201000', '141032000000');
INSERT INTO `t_s_town` VALUES ('4275', '打石腰乡', '141032202000', '141032000000');
INSERT INTO `t_s_town` VALUES ('4276', '坡头乡', '141032203000', '141032000000');
INSERT INTO `t_s_town` VALUES ('4277', '交口乡', '141032204000', '141032000000');
INSERT INTO `t_s_town` VALUES ('4278', '蒲城镇', '141033100000', '141033000000');
INSERT INTO `t_s_town` VALUES ('4279', '薛关镇', '141033101000', '141033000000');
INSERT INTO `t_s_town` VALUES ('4280', '黑龙关镇', '141033102000', '141033000000');
INSERT INTO `t_s_town` VALUES ('4281', '克城镇', '141033103000', '141033000000');
INSERT INTO `t_s_town` VALUES ('4282', '山中乡', '141033200000', '141033000000');
INSERT INTO `t_s_town` VALUES ('4283', '古县乡', '141033201000', '141033000000');
INSERT INTO `t_s_town` VALUES ('4284', '红道乡', '141033202000', '141033000000');
INSERT INTO `t_s_town` VALUES ('4285', '乔家湾乡', '141033203000', '141033000000');
INSERT INTO `t_s_town` VALUES ('4286', '太林乡', '141033204000', '141033000000');
INSERT INTO `t_s_town` VALUES ('4287', '永安镇', '141034100000', '141034000000');
INSERT INTO `t_s_town` VALUES ('4288', '对竹镇', '141034101000', '141034000000');
INSERT INTO `t_s_town` VALUES ('4289', '勍香镇', '141034102000', '141034000000');
INSERT INTO `t_s_town` VALUES ('4290', '和平镇', '141034103000', '141034000000');
INSERT INTO `t_s_town` VALUES ('4291', '僧念镇', '141034104000', '141034000000');
INSERT INTO `t_s_town` VALUES ('4292', '佃坪乡', '141034200000', '141034000000');
INSERT INTO `t_s_town` VALUES ('4293', '团柏乡', '141034201000', '141034000000');
INSERT INTO `t_s_town` VALUES ('4294', '邢家要乡', '141034202000', '141034000000');
INSERT INTO `t_s_town` VALUES ('4295', '社区管理委员会', '141034400000', '141034000000');
INSERT INTO `t_s_town` VALUES ('4296', '路东街道办事处', '141081001000', '141081000000');
INSERT INTO `t_s_town` VALUES ('4297', '路西街道办事处', '141081002000', '141081000000');
INSERT INTO `t_s_town` VALUES ('4298', '浍滨街道办事处', '141081003000', '141081000000');
INSERT INTO `t_s_town` VALUES ('4299', '上马街道办事处', '141081004000', '141081000000');
INSERT INTO `t_s_town` VALUES ('4300', '张村街道办事处', '141081005000', '141081000000');
INSERT INTO `t_s_town` VALUES ('4301', '新田乡', '141081200000', '141081000000');
INSERT INTO `t_s_town` VALUES ('4302', '高村乡', '141081201000', '141081000000');
INSERT INTO `t_s_town` VALUES ('4303', '凤城乡', '141081202000', '141081000000');
INSERT INTO `t_s_town` VALUES ('4304', '鼓楼街道办事处', '141082001000', '141082000000');
INSERT INTO `t_s_town` VALUES ('4305', '北环路街道办事处', '141082002000', '141082000000');
INSERT INTO `t_s_town` VALUES ('4306', '南环路街道办事处', '141082003000', '141082000000');
INSERT INTO `t_s_town` VALUES ('4307', '开元街道办事处', '141082004000', '141082000000');
INSERT INTO `t_s_town` VALUES ('4308', '退沙街道办事处', '141082005000', '141082000000');
INSERT INTO `t_s_town` VALUES ('4309', '白龙镇', '141082100000', '141082000000');
INSERT INTO `t_s_town` VALUES ('4310', '辛置镇', '141082101000', '141082000000');
INSERT INTO `t_s_town` VALUES ('4311', '大张镇', '141082102000', '141082000000');
INSERT INTO `t_s_town` VALUES ('4312', '李曹镇', '141082103000', '141082000000');
INSERT INTO `t_s_town` VALUES ('4313', '陶唐峪乡', '141082200000', '141082000000');
INSERT INTO `t_s_town` VALUES ('4314', '三教乡', '141082201000', '141082000000');
INSERT INTO `t_s_town` VALUES ('4315', '师庄乡', '141082202000', '141082000000');
INSERT INTO `t_s_town` VALUES ('4316', '滨河街道办事处', '141102001000', '141102000000');
INSERT INTO `t_s_town` VALUES ('4317', '凤山街道办事处', '141102002000', '141102000000');
INSERT INTO `t_s_town` VALUES ('4318', '莲花池街道办事处', '141102003000', '141102000000');
INSERT INTO `t_s_town` VALUES ('4319', '城北街道办事处', '141102004000', '141102000000');
INSERT INTO `t_s_town` VALUES ('4320', '田家会街道办事处', '141102005000', '141102000000');
INSERT INTO `t_s_town` VALUES ('4321', '交口街道办事处', '141102006000', '141102000000');
INSERT INTO `t_s_town` VALUES ('4322', '西属巴街道办事处', '141102007000', '141102000000');
INSERT INTO `t_s_town` VALUES ('4323', '吴城镇', '141102100000', '141102000000');
INSERT INTO `t_s_town` VALUES ('4324', '信义镇', '141102101000', '141102000000');
INSERT INTO `t_s_town` VALUES ('4325', '红眼川乡', '141102200000', '141102000000');
INSERT INTO `t_s_town` VALUES ('4326', '枣林乡', '141102201000', '141102000000');
INSERT INTO `t_s_town` VALUES ('4327', '坪头乡', '141102202000', '141102000000');
INSERT INTO `t_s_town` VALUES ('4328', '凤城镇', '141121100000', '141121000000');
INSERT INTO `t_s_town` VALUES ('4329', '开栅镇', '141121101000', '141121000000');
INSERT INTO `t_s_town` VALUES ('4330', '南庄镇', '141121102000', '141121000000');
INSERT INTO `t_s_town` VALUES ('4331', '南安镇', '141121103000', '141121000000');
INSERT INTO `t_s_town` VALUES ('4332', '刘胡兰镇', '141121104000', '141121000000');
INSERT INTO `t_s_town` VALUES ('4333', '下曲镇', '141121105000', '141121000000');
INSERT INTO `t_s_town` VALUES ('4334', '孝义镇', '141121106000', '141121000000');
INSERT INTO `t_s_town` VALUES ('4335', '南武乡', '141121200000', '141121000000');
INSERT INTO `t_s_town` VALUES ('4336', '西城乡', '141121201000', '141121000000');
INSERT INTO `t_s_town` VALUES ('4337', '北张乡', '141121202000', '141121000000');
INSERT INTO `t_s_town` VALUES ('4338', '马西乡', '141121203000', '141121000000');
INSERT INTO `t_s_town` VALUES ('4339', '西槽头乡', '141121204000', '141121000000');
INSERT INTO `t_s_town` VALUES ('4340', '天宁镇', '141122100000', '141122000000');
INSERT INTO `t_s_town` VALUES ('4341', '夏家营镇', '141122101000', '141122000000');
INSERT INTO `t_s_town` VALUES ('4342', '西营镇', '141122102000', '141122000000');
INSERT INTO `t_s_town` VALUES ('4343', '水峪贯镇', '141122103000', '141122000000');
INSERT INTO `t_s_town` VALUES ('4344', '西社镇', '141122104000', '141122000000');
INSERT INTO `t_s_town` VALUES ('4345', '庞泉沟镇', '141122105000', '141122000000');
INSERT INTO `t_s_town` VALUES ('4346', '洪相乡', '141122200000', '141122000000');
INSERT INTO `t_s_town` VALUES ('4347', '岭底乡', '141122201000', '141122000000');
INSERT INTO `t_s_town` VALUES ('4348', '东坡底乡', '141122202000', '141122000000');
INSERT INTO `t_s_town` VALUES ('4349', '会立乡', '141122203000', '141122000000');
INSERT INTO `t_s_town` VALUES ('4350', '夏家营生态工业园区管委会', '141122400000', '141122000000');
INSERT INTO `t_s_town` VALUES ('4351', '蔚汾镇', '141123100000', '141123000000');
INSERT INTO `t_s_town` VALUES ('4352', '魏家滩镇', '141123101000', '141123000000');
INSERT INTO `t_s_town` VALUES ('4353', '瓦塘镇', '141123102000', '141123000000');
INSERT INTO `t_s_town` VALUES ('4354', '康宁镇', '141123103000', '141123000000');
INSERT INTO `t_s_town` VALUES ('4355', '高家村镇', '141123104000', '141123000000');
INSERT INTO `t_s_town` VALUES ('4356', '罗峪口镇', '141123105000', '141123000000');
INSERT INTO `t_s_town` VALUES ('4357', '蔡家会镇', '141123106000', '141123000000');
INSERT INTO `t_s_town` VALUES ('4358', '交楼申乡', '141123200000', '141123000000');
INSERT INTO `t_s_town` VALUES ('4359', '恶虎滩乡', '141123201000', '141123000000');
INSERT INTO `t_s_town` VALUES ('4360', '东会乡', '141123202000', '141123000000');
INSERT INTO `t_s_town` VALUES ('4361', '固贤乡', '141123203000', '141123000000');
INSERT INTO `t_s_town` VALUES ('4362', '奥家湾乡', '141123204000', '141123000000');
INSERT INTO `t_s_town` VALUES ('4363', '蔡家崖乡', '141123205000', '141123000000');
INSERT INTO `t_s_town` VALUES ('4364', '贺家会乡', '141123206000', '141123000000');
INSERT INTO `t_s_town` VALUES ('4365', '孟家坪乡', '141123207000', '141123000000');
INSERT INTO `t_s_town` VALUES ('4366', '赵家坪乡', '141123208000', '141123000000');
INSERT INTO `t_s_town` VALUES ('4367', '圪垯上乡', '141123209000', '141123000000');
INSERT INTO `t_s_town` VALUES ('4368', '兴县经济技术开发区', '141123400000', '141123000000');
INSERT INTO `t_s_town` VALUES ('4369', '临泉镇', '141124100000', '141124000000');
INSERT INTO `t_s_town` VALUES ('4370', '白文镇', '141124101000', '141124000000');
INSERT INTO `t_s_town` VALUES ('4371', '城庄镇', '141124102000', '141124000000');
INSERT INTO `t_s_town` VALUES ('4372', '兔坂镇', '141124103000', '141124000000');
INSERT INTO `t_s_town` VALUES ('4373', '克虎镇', '141124104000', '141124000000');
INSERT INTO `t_s_town` VALUES ('4374', '三交镇', '141124105000', '141124000000');
INSERT INTO `t_s_town` VALUES ('4375', '湍水头镇', '141124106000', '141124000000');
INSERT INTO `t_s_town` VALUES ('4376', '林家坪镇', '141124107000', '141124000000');
INSERT INTO `t_s_town` VALUES ('4377', '招贤镇', '141124108000', '141124000000');
INSERT INTO `t_s_town` VALUES ('4378', '碛口镇', '141124109000', '141124000000');
INSERT INTO `t_s_town` VALUES ('4379', '刘家会镇', '141124110000', '141124000000');
INSERT INTO `t_s_town` VALUES ('4380', '丛罗峪镇', '141124111000', '141124000000');
INSERT INTO `t_s_town` VALUES ('4381', '曲峪镇', '141124112000', '141124000000');
INSERT INTO `t_s_town` VALUES ('4382', '木瓜坪乡', '141124200000', '141124000000');
INSERT INTO `t_s_town` VALUES ('4383', '安业乡', '141124201000', '141124000000');
INSERT INTO `t_s_town` VALUES ('4384', '玉坪乡', '141124202000', '141124000000');
INSERT INTO `t_s_town` VALUES ('4385', '青凉寺乡', '141124203000', '141124000000');
INSERT INTO `t_s_town` VALUES ('4386', '石白头乡', '141124204000', '141124000000');
INSERT INTO `t_s_town` VALUES ('4387', '雷家碛乡', '141124205000', '141124000000');
INSERT INTO `t_s_town` VALUES ('4388', '八堡乡', '141124206000', '141124000000');
INSERT INTO `t_s_town` VALUES ('4389', '大禹乡', '141124207000', '141124000000');
INSERT INTO `t_s_town` VALUES ('4390', '车赶乡', '141124208000', '141124000000');
INSERT INTO `t_s_town` VALUES ('4391', '安家庄乡', '141124209000', '141124000000');
INSERT INTO `t_s_town` VALUES ('4392', '柳林镇', '141125100000', '141125000000');
INSERT INTO `t_s_town` VALUES ('4393', '穆村镇', '141125101000', '141125000000');
INSERT INTO `t_s_town` VALUES ('4394', '薛村镇', '141125102000', '141125000000');
INSERT INTO `t_s_town` VALUES ('4395', '庄上镇', '141125103000', '141125000000');
INSERT INTO `t_s_town` VALUES ('4396', '留誉镇', '141125104000', '141125000000');
INSERT INTO `t_s_town` VALUES ('4397', '三交镇', '141125105000', '141125000000');
INSERT INTO `t_s_town` VALUES ('4398', '成家庄镇', '141125106000', '141125000000');
INSERT INTO `t_s_town` VALUES ('4399', '孟门镇', '141125107000', '141125000000');
INSERT INTO `t_s_town` VALUES ('4400', '李家湾乡', '141125200000', '141125000000');
INSERT INTO `t_s_town` VALUES ('4401', '贾家垣乡', '141125201000', '141125000000');
INSERT INTO `t_s_town` VALUES ('4402', '陈家湾乡', '141125202000', '141125000000');
INSERT INTO `t_s_town` VALUES ('4403', '金家庄乡', '141125203000', '141125000000');
INSERT INTO `t_s_town` VALUES ('4404', '高家沟乡', '141125204000', '141125000000');
INSERT INTO `t_s_town` VALUES ('4405', '石西乡', '141125205000', '141125000000');
INSERT INTO `t_s_town` VALUES ('4406', '王家沟乡', '141125206000', '141125000000');
INSERT INTO `t_s_town` VALUES ('4407', '灵泉镇', '141126100000', '141126000000');
INSERT INTO `t_s_town` VALUES ('4408', '罗村镇', '141126101000', '141126000000');
INSERT INTO `t_s_town` VALUES ('4409', '义牒镇', '141126102000', '141126000000');
INSERT INTO `t_s_town` VALUES ('4410', '小蒜镇', '141126103000', '141126000000');
INSERT INTO `t_s_town` VALUES ('4411', '龙交乡', '141126200000', '141126000000');
INSERT INTO `t_s_town` VALUES ('4412', '和合乡', '141126201000', '141126000000');
INSERT INTO `t_s_town` VALUES ('4413', '前山乡', '141126202000', '141126000000');
INSERT INTO `t_s_town` VALUES ('4414', '曹家垣乡', '141126203000', '141126000000');
INSERT INTO `t_s_town` VALUES ('4415', '裴沟乡', '141126204000', '141126000000');
INSERT INTO `t_s_town` VALUES ('4416', '东村镇', '141127100000', '141127000000');
INSERT INTO `t_s_town` VALUES ('4417', '岚城镇', '141127101000', '141127000000');
INSERT INTO `t_s_town` VALUES ('4418', '普明镇', '141127102000', '141127000000');
INSERT INTO `t_s_town` VALUES ('4419', '界河口镇', '141127103000', '141127000000');
INSERT INTO `t_s_town` VALUES ('4420', '土峪乡', '141127200000', '141127000000');
INSERT INTO `t_s_town` VALUES ('4421', '上明乡', '141127201000', '141127000000');
INSERT INTO `t_s_town` VALUES ('4422', '王狮乡', '141127202000', '141127000000');
INSERT INTO `t_s_town` VALUES ('4423', '梁家庄乡', '141127203000', '141127000000');
INSERT INTO `t_s_town` VALUES ('4424', '顺会乡', '141127204000', '141127000000');
INSERT INTO `t_s_town` VALUES ('4425', '河口乡', '141127205000', '141127000000');
INSERT INTO `t_s_town` VALUES ('4426', '社科乡', '141127206000', '141127000000');
INSERT INTO `t_s_town` VALUES ('4427', '大蛇头乡', '141127207000', '141127000000');
INSERT INTO `t_s_town` VALUES ('4428', '岚县普明工业园区', '141127400000', '141127000000');
INSERT INTO `t_s_town` VALUES ('4429', '圪洞镇', '141128100000', '141128000000');
INSERT INTO `t_s_town` VALUES ('4430', '马坊镇', '141128101000', '141128000000');
INSERT INTO `t_s_town` VALUES ('4431', '峪口镇', '141128102000', '141128000000');
INSERT INTO `t_s_town` VALUES ('4432', '大武镇', '141128103000', '141128000000');
INSERT INTO `t_s_town` VALUES ('4433', '北武当镇', '141128104000', '141128000000');
INSERT INTO `t_s_town` VALUES ('4434', '积翠乡', '141128200000', '141128000000');
INSERT INTO `t_s_town` VALUES ('4435', '麻地会乡', '141128201000', '141128000000');
INSERT INTO `t_s_town` VALUES ('4436', '宁乡镇', '141129100000', '141129000000');
INSERT INTO `t_s_town` VALUES ('4437', '金罗镇', '141129101000', '141129000000');
INSERT INTO `t_s_town` VALUES ('4438', '枝柯镇', '141129102000', '141129000000');
INSERT INTO `t_s_town` VALUES ('4439', '武家庄镇', '141129103000', '141129000000');
INSERT INTO `t_s_town` VALUES ('4440', '暖泉镇', '141129104000', '141129000000');
INSERT INTO `t_s_town` VALUES ('4441', '下枣林乡', '141129201000', '141129000000');
INSERT INTO `t_s_town` VALUES ('4442', '车鸣峪乡', '141129202000', '141129000000');
INSERT INTO `t_s_town` VALUES ('4443', '水头镇', '141130100000', '141130000000');
INSERT INTO `t_s_town` VALUES ('4444', '康城镇', '141130101000', '141130000000');
INSERT INTO `t_s_town` VALUES ('4445', '双池镇', '141130102000', '141130000000');
INSERT INTO `t_s_town` VALUES ('4446', '桃红坡镇', '141130103000', '141130000000');
INSERT INTO `t_s_town` VALUES ('4447', '石口乡', '141130200000', '141130000000');
INSERT INTO `t_s_town` VALUES ('4448', '回龙乡', '141130201000', '141130000000');
INSERT INTO `t_s_town` VALUES ('4449', '温泉乡', '141130202000', '141130000000');
INSERT INTO `t_s_town` VALUES ('4450', '新义街道办事处', '141181001000', '141181000000');
INSERT INTO `t_s_town` VALUES ('4451', '中阳楼街道办事处', '141181002000', '141181000000');
INSERT INTO `t_s_town` VALUES ('4452', '振兴街道办事处', '141181003000', '141181000000');
INSERT INTO `t_s_town` VALUES ('4453', '胜溪湖街道办事处', '141181004000', '141181000000');
INSERT INTO `t_s_town` VALUES ('4454', '崇文街道办事处', '141181005000', '141181000000');
INSERT INTO `t_s_town` VALUES ('4455', '兑镇镇', '141181100000', '141181000000');
INSERT INTO `t_s_town` VALUES ('4456', '阳泉曲镇', '141181101000', '141181000000');
INSERT INTO `t_s_town` VALUES ('4457', '下堡镇', '141181102000', '141181000000');
INSERT INTO `t_s_town` VALUES ('4458', '西辛庄镇', '141181103000', '141181000000');
INSERT INTO `t_s_town` VALUES ('4459', '高阳镇', '141181104000', '141181000000');
INSERT INTO `t_s_town` VALUES ('4460', '梧桐镇', '141181105000', '141181000000');
INSERT INTO `t_s_town` VALUES ('4461', '柱濮镇', '141181106000', '141181000000');
INSERT INTO `t_s_town` VALUES ('4462', '大孝堡乡', '141181200000', '141181000000');
INSERT INTO `t_s_town` VALUES ('4463', '下栅乡', '141181201000', '141181000000');
INSERT INTO `t_s_town` VALUES ('4464', '驿马乡', '141181202000', '141181000000');
INSERT INTO `t_s_town` VALUES ('4465', '南阳乡', '141181203000', '141181000000');
INSERT INTO `t_s_town` VALUES ('4466', '杜村乡', '141181204000', '141181000000');
INSERT INTO `t_s_town` VALUES ('4467', '文峰街道办事处', '141182001000', '141182000000');
INSERT INTO `t_s_town` VALUES ('4468', '太和桥街道办事处', '141182002000', '141182000000');
INSERT INTO `t_s_town` VALUES ('4469', '贾家庄镇', '141182100000', '141182000000');
INSERT INTO `t_s_town` VALUES ('4470', '杏花村镇', '141182101000', '141182000000');
INSERT INTO `t_s_town` VALUES ('4471', '冀村镇', '141182102000', '141182000000');
INSERT INTO `t_s_town` VALUES ('4472', '肖家庄镇', '141182103000', '141182000000');
INSERT INTO `t_s_town` VALUES ('4473', '演武镇', '141182104000', '141182000000');
INSERT INTO `t_s_town` VALUES ('4474', '三泉镇', '141182105000', '141182000000');
INSERT INTO `t_s_town` VALUES ('4475', '石庄镇', '141182106000', '141182000000');
INSERT INTO `t_s_town` VALUES ('4476', '杨家庄镇', '141182107000', '141182000000');
INSERT INTO `t_s_town` VALUES ('4477', '峪道河镇', '141182108000', '141182000000');
INSERT INTO `t_s_town` VALUES ('4478', '西河乡', '141182200000', '141182000000');
INSERT INTO `t_s_town` VALUES ('4479', '阳城乡', '141182201000', '141182000000');
INSERT INTO `t_s_town` VALUES ('4480', '栗家庄乡', '141182202000', '141182000000');
INSERT INTO `t_s_town` VALUES ('4481', '南薰街道办事处', '141182400000', '141182000000');
INSERT INTO `t_s_town` VALUES ('4482', '辰北街道办事处', '141182401000', '141182000000');
INSERT INTO `t_s_town` VALUES ('4483', '海拉尔东路街道办事处', '150102001000', '150102000000');
INSERT INTO `t_s_town` VALUES ('4484', '锡林路街道办事处', '150102002000', '150102000000');
INSERT INTO `t_s_town` VALUES ('4485', '中山东路街道办事处', '150102003000', '150102000000');
INSERT INTO `t_s_town` VALUES ('4486', '东街街道办事处', '150102004000', '150102000000');
INSERT INTO `t_s_town` VALUES ('4487', '西街街道办事处', '150102005000', '150102000000');
INSERT INTO `t_s_town` VALUES ('4488', '东风路街道办事处', '150102006000', '150102000000');
INSERT INTO `t_s_town` VALUES ('4489', '迎新路街道办事处', '150102007000', '150102000000');
INSERT INTO `t_s_town` VALUES ('4490', '成吉思汗大街街道办事处', '150102008000', '150102000000');
INSERT INTO `t_s_town` VALUES ('4491', '保合少镇', '150102101000', '150102000000');
INSERT INTO `t_s_town` VALUES ('4492', '新城区鸿盛高科技园区', '150102400000', '150102000000');
INSERT INTO `t_s_town` VALUES ('4493', '新华西路办事处', '150103001000', '150103000000');
INSERT INTO `t_s_town` VALUES ('4494', '中山西路办事处', '150103002000', '150103000000');
INSERT INTO `t_s_town` VALUES ('4495', '光明路办事处', '150103003000', '150103000000');
INSERT INTO `t_s_town` VALUES ('4496', '海拉尔西路办事处', '150103004000', '150103000000');
INSERT INTO `t_s_town` VALUES ('4497', '环河街办事处', '150103005000', '150103000000');
INSERT INTO `t_s_town` VALUES ('4498', '通道街办事处', '150103006000', '150103000000');
INSERT INTO `t_s_town` VALUES ('4499', '钢铁路办事处', '150103007000', '150103000000');
INSERT INTO `t_s_town` VALUES ('4500', '攸攸板镇', '150103100000', '150103000000');
INSERT INTO `t_s_town` VALUES ('4501', '小召前街办事处', '150104001000', '150104000000');
INSERT INTO `t_s_town` VALUES ('4502', '兴隆巷办事处', '150104002000', '150104000000');
INSERT INTO `t_s_town` VALUES ('4503', '长和廊办事处', '150104003000', '150104000000');
INSERT INTO `t_s_town` VALUES ('4504', '石东路办事处', '150104004000', '150104000000');
INSERT INTO `t_s_town` VALUES ('4505', '大南街办事处', '150104005000', '150104000000');
INSERT INTO `t_s_town` VALUES ('4506', '鄂尔多斯路办事处', '150104006000', '150104000000');
INSERT INTO `t_s_town` VALUES ('4507', '西菜园办事处', '150104007000', '150104000000');
INSERT INTO `t_s_town` VALUES ('4508', '昭君路办事处', '150104008000', '150104000000');
INSERT INTO `t_s_town` VALUES ('4509', '小黑河镇', '150104100000', '150104000000');
INSERT INTO `t_s_town` VALUES ('4510', '裕隆工业园区', '150104400000', '150104000000');
INSERT INTO `t_s_town` VALUES ('4511', '人民路街道办事处', '150105001000', '150105000000');
INSERT INTO `t_s_town` VALUES ('4512', '大学西路街道办事处', '150105002000', '150105000000');
INSERT INTO `t_s_town` VALUES ('4513', '乌兰察布东路街道办事处', '150105003000', '150105000000');
INSERT INTO `t_s_town` VALUES ('4514', '大学东路街道办事处', '150105004000', '150105000000');
INSERT INTO `t_s_town` VALUES ('4515', '中专路街道办事处', '150105005000', '150105000000');
INSERT INTO `t_s_town` VALUES ('4516', '昭乌达路街道办事处', '150105006000', '150105000000');
INSERT INTO `t_s_town` VALUES ('4517', '巴彦街道办事处', '150105007000', '150105000000');
INSERT INTO `t_s_town` VALUES ('4518', '敕勒川路街道办事处', '150105008000', '150105000000');
INSERT INTO `t_s_town` VALUES ('4519', '榆林镇', '150105101000', '150105000000');
INSERT INTO `t_s_town` VALUES ('4520', '黄合少镇', '150105103000', '150105000000');
INSERT INTO `t_s_town` VALUES ('4521', '金河镇', '150105104000', '150105000000');
INSERT INTO `t_s_town` VALUES ('4522', '金桥经济技术开发区', '150105400000', '150105000000');
INSERT INTO `t_s_town` VALUES ('4523', '察素齐镇', '150121100000', '150121000000');
INSERT INTO `t_s_town` VALUES ('4524', '毕克齐镇', '150121101000', '150121000000');
INSERT INTO `t_s_town` VALUES ('4525', '善岱镇', '150121102000', '150121000000');
INSERT INTO `t_s_town` VALUES ('4526', '台阁牧镇', '150121103000', '150121000000');
INSERT INTO `t_s_town` VALUES ('4527', '白庙子镇', '150121104000', '150121000000');
INSERT INTO `t_s_town` VALUES ('4528', '沙尔沁镇', '150121105000', '150121000000');
INSERT INTO `t_s_town` VALUES ('4529', '敕勒川镇', '150121106000', '150121000000');
INSERT INTO `t_s_town` VALUES ('4530', '北什轴乡', '150121207000', '150121000000');
INSERT INTO `t_s_town` VALUES ('4531', '塔布赛乡', '150121208000', '150121000000');
INSERT INTO `t_s_town` VALUES ('4532', '呼和浩特金山经济技术开发区', '150121401000', '150121000000');
INSERT INTO `t_s_town` VALUES ('4533', '双河镇', '150122100000', '150122000000');
INSERT INTO `t_s_town` VALUES ('4534', '新营子镇', '150122101000', '150122000000');
INSERT INTO `t_s_town` VALUES ('4535', '五申镇', '150122102000', '150122000000');
INSERT INTO `t_s_town` VALUES ('4536', '伍什家镇', '150122103000', '150122000000');
INSERT INTO `t_s_town` VALUES ('4537', '古城镇', '150122104000', '150122000000');
INSERT INTO `t_s_town` VALUES ('4538', '托县工业园区', '150122400000', '150122000000');
INSERT INTO `t_s_town` VALUES ('4539', '城关镇', '150123100000', '150123000000');
INSERT INTO `t_s_town` VALUES ('4540', '盛乐镇', '150123101000', '150123000000');
INSERT INTO `t_s_town` VALUES ('4541', '新店子镇', '150123102000', '150123000000');
INSERT INTO `t_s_town` VALUES ('4542', '舍必崖乡', '150123203000', '150123000000');
INSERT INTO `t_s_town` VALUES ('4543', '大红城乡', '150123205000', '150123000000');
INSERT INTO `t_s_town` VALUES ('4544', '羊群沟乡', '150123206000', '150123000000');
INSERT INTO `t_s_town` VALUES ('4545', '黑老夭乡', '150123207000', '150123000000');
INSERT INTO `t_s_town` VALUES ('4546', '巧什营乡', '150123208000', '150123000000');
INSERT INTO `t_s_town` VALUES ('4547', '盛乐经济工业园区', '150123400000', '150123000000');
INSERT INTO `t_s_town` VALUES ('4548', '城关镇', '150124100000', '150124000000');
INSERT INTO `t_s_town` VALUES ('4549', '宏河镇', '150124101000', '150124000000');
INSERT INTO `t_s_town` VALUES ('4550', '喇嘛湾镇', '150124102000', '150124000000');
INSERT INTO `t_s_town` VALUES ('4551', '老牛湾镇', '150124103000', '150124000000');
INSERT INTO `t_s_town` VALUES ('4552', '窑沟乡', '150124200000', '150124000000');
INSERT INTO `t_s_town` VALUES ('4553', '北堡乡', '150124201000', '150124000000');
INSERT INTO `t_s_town` VALUES ('4554', '韮菜庄乡', '150124202000', '150124000000');
INSERT INTO `t_s_town` VALUES ('4555', '五良太乡', '150124203000', '150124000000');
INSERT INTO `t_s_town` VALUES ('4556', '可可以力更镇', '150125100000', '150125000000');
INSERT INTO `t_s_town` VALUES ('4557', '哈乐镇', '150125101000', '150125000000');
INSERT INTO `t_s_town` VALUES ('4558', '西乌兰不浪镇', '150125102000', '150125000000');
INSERT INTO `t_s_town` VALUES ('4559', '大青山乡', '150125200000', '150125000000');
INSERT INTO `t_s_town` VALUES ('4560', '上秃亥乡', '150125205000', '150125000000');
INSERT INTO `t_s_town` VALUES ('4561', '得胜沟乡', '150125207000', '150125000000');
INSERT INTO `t_s_town` VALUES ('4562', '二份子乡', '150125211000', '150125000000');
INSERT INTO `t_s_town` VALUES ('4563', '哈拉合少乡', '150125213000', '150125000000');
INSERT INTO `t_s_town` VALUES ('4564', '耗赖山乡', '150125214000', '150125000000');
INSERT INTO `t_s_town` VALUES ('4565', '内蒙古武川经济开发区', '150125402000', '150125000000');
INSERT INTO `t_s_town` VALUES ('4566', '武川金三角经济开发区', '150125403000', '150125000000');
INSERT INTO `t_s_town` VALUES ('4567', '金海开发区', '150171400000', '150171000000');
INSERT INTO `t_s_town` VALUES ('4568', '如意工业园区', '150172401000', '150172000000');
INSERT INTO `t_s_town` VALUES ('4569', '金川工业园区', '150172402000', '150172000000');
INSERT INTO `t_s_town` VALUES ('4570', '呼和浩特出口加工区', '150172403000', '150172000000');
INSERT INTO `t_s_town` VALUES ('4571', '呼和浩特留学人员创业园', '150172404000', '150172000000');
INSERT INTO `t_s_town` VALUES ('4572', '沙尔沁工业区（如意南区）', '150172405000', '150172000000');
INSERT INTO `t_s_town` VALUES ('4573', '呼和浩特白塔空港物流园区', '150172406000', '150172000000');
INSERT INTO `t_s_town` VALUES ('4574', '和平街道办事处', '150202001000', '150202000000');
INSERT INTO `t_s_town` VALUES ('4575', '财神庙街道办事处', '150202002000', '150202000000');
INSERT INTO `t_s_town` VALUES ('4576', '西脑包街道办事处', '150202003000', '150202000000');
INSERT INTO `t_s_town` VALUES ('4577', '南门外街道办事处', '150202004000', '150202000000');
INSERT INTO `t_s_town` VALUES ('4578', '南圪洞街道办事处', '150202005000', '150202000000');
INSERT INTO `t_s_town` VALUES ('4579', '东站街道办事处', '150202006000', '150202000000');
INSERT INTO `t_s_town` VALUES ('4580', '回民街道办事处', '150202007000', '150202000000');
INSERT INTO `t_s_town` VALUES ('4581', '天骄街道办事处', '150202008000', '150202000000');
INSERT INTO `t_s_town` VALUES ('4582', '河东街道办事处', '150202009000', '150202000000');
INSERT INTO `t_s_town` VALUES ('4583', '铁西街道办事处', '150202010000', '150202000000');
INSERT INTO `t_s_town` VALUES ('4584', '东兴街道办事处', '150202011000', '150202000000');
INSERT INTO `t_s_town` VALUES ('4585', '杨圪楞街道办事处', '150202012000', '150202000000');
INSERT INTO `t_s_town` VALUES ('4586', '河东镇', '150202100000', '150202000000');
INSERT INTO `t_s_town` VALUES ('4587', '沙尔沁镇', '150202101000', '150202000000');
INSERT INTO `t_s_town` VALUES ('4588', '县级单位直辖村级单位（特殊镇）', '150202198000', '150202000000');
INSERT INTO `t_s_town` VALUES ('4589', '铝业工业园区', '150202400000', '150202000000');
INSERT INTO `t_s_town` VALUES ('4590', '少先路街道办事处', '150203001000', '150203000000');
INSERT INTO `t_s_town` VALUES ('4591', '沼潭街道办事处', '150203003000', '150203000000');
INSERT INTO `t_s_town` VALUES ('4592', '林荫路街道办事处', '150203004000', '150203000000');
INSERT INTO `t_s_town` VALUES ('4593', '友谊大街街道办事处', '150203005000', '150203000000');
INSERT INTO `t_s_town` VALUES ('4594', '阿尔丁大街街道办事处', '150203006000', '150203000000');
INSERT INTO `t_s_town` VALUES ('4595', '团结大街街道办事处', '150203007000', '150203000000');
INSERT INTO `t_s_town` VALUES ('4596', '鞍山道街道办事处', '150203008000', '150203000000');
INSERT INTO `t_s_town` VALUES ('4597', '前进道街道办事处', '150203009000', '150203000000');
INSERT INTO `t_s_town` VALUES ('4598', '市府东路街道办事处', '150203010000', '150203000000');
INSERT INTO `t_s_town` VALUES ('4599', '白云路街道办事处', '150203011000', '150203000000');
INSERT INTO `t_s_town` VALUES ('4600', '黄河西路街道办事处', '150203012000', '150203000000');
INSERT INTO `t_s_town` VALUES ('4601', '昆工路街道办事处', '150203013000', '150203000000');
INSERT INTO `t_s_town` VALUES ('4602', '昆北街道办事处', '150203014000', '150203000000');
INSERT INTO `t_s_town` VALUES ('4603', '昆河镇', '150203100000', '150203000000');
INSERT INTO `t_s_town` VALUES ('4604', '卜尔汉图镇', '150203102000', '150203000000');
INSERT INTO `t_s_town` VALUES ('4605', '包钢厂区办事处', '150203400000', '150203000000');
INSERT INTO `t_s_town` VALUES ('4606', '先锋道街道办事处', '150204001000', '150204000000');
INSERT INTO `t_s_town` VALUES ('4607', '幸福路街道办事处', '150204002000', '150204000000');
INSERT INTO `t_s_town` VALUES ('4608', '万青路街道办事处', '150204003000', '150204000000');
INSERT INTO `t_s_town` VALUES ('4609', '富强路街道办事处', '150204004000', '150204000000');
INSERT INTO `t_s_town` VALUES ('4610', '科学路街道办事处', '150204005000', '150204000000');
INSERT INTO `t_s_town` VALUES ('4611', '青山路街道办事处', '150204006000', '150204000000');
INSERT INTO `t_s_town` VALUES ('4612', '自由路街道办事处', '150204007000', '150204000000');
INSERT INTO `t_s_town` VALUES ('4613', '乌素图街道办事处', '150204008000', '150204000000');
INSERT INTO `t_s_town` VALUES ('4614', '青福镇', '150204100000', '150204000000');
INSERT INTO `t_s_town` VALUES ('4615', '兴胜镇', '150204101000', '150204000000');
INSERT INTO `t_s_town` VALUES ('4616', '包头市装备制造产业园区', '150204401000', '150204000000');
INSERT INTO `t_s_town` VALUES ('4617', '石拐街道办事处', '150205001000', '150205000000');
INSERT INTO `t_s_town` VALUES ('4618', '大发街道办事处', '150205002000', '150205000000');
INSERT INTO `t_s_town` VALUES ('4619', '大磁街道办事处', '150205003000', '150205000000');
INSERT INTO `t_s_town` VALUES ('4620', '五当沟街道办事处', '150205004000', '150205000000');
INSERT INTO `t_s_town` VALUES ('4621', '白狐沟街道办事处', '150205005000', '150205000000');
INSERT INTO `t_s_town` VALUES ('4622', '大德恒办事处', '150205006000', '150205000000');
INSERT INTO `t_s_town` VALUES ('4623', '五当召镇', '150205101000', '150205000000');
INSERT INTO `t_s_town` VALUES ('4624', '吉忽伦图苏木', '150205202000', '150205000000');
INSERT INTO `t_s_town` VALUES ('4625', '工业园区管理委员会', '150205400000', '150205000000');
INSERT INTO `t_s_town` VALUES ('4626', '矿山路街道办事处', '150206001000', '150206000000');
INSERT INTO `t_s_town` VALUES ('4627', '通阳道街道办事处', '150206002000', '150206000000');
INSERT INTO `t_s_town` VALUES ('4628', '沙河街道办事处', '150207001000', '150207000000');
INSERT INTO `t_s_town` VALUES ('4629', '赛汗街道办事处', '150207002000', '150207000000');
INSERT INTO `t_s_town` VALUES ('4630', '萨如拉街道办事处', '150207003000', '150207000000');
INSERT INTO `t_s_town` VALUES ('4631', '白音席勒街道办事处', '150207004000', '150207000000');
INSERT INTO `t_s_town` VALUES ('4632', '麻池镇', '150207103000', '150207000000');
INSERT INTO `t_s_town` VALUES ('4633', '哈林格尔镇', '150207105000', '150207000000');
INSERT INTO `t_s_town` VALUES ('4634', '哈业胡同镇', '150207110000', '150207000000');
INSERT INTO `t_s_town` VALUES ('4635', '阿嘎如泰苏木乡', '150207202000', '150207000000');
INSERT INTO `t_s_town` VALUES ('4636', '萨拉齐镇', '150221104000', '150221000000');
INSERT INTO `t_s_town` VALUES ('4637', '双龙镇', '150221105000', '150221000000');
INSERT INTO `t_s_town` VALUES ('4638', '美岱召镇', '150221106000', '150221000000');
INSERT INTO `t_s_town` VALUES ('4639', '沟门镇', '150221107000', '150221000000');
INSERT INTO `t_s_town` VALUES ('4640', '将军尧镇', '150221108000', '150221000000');
INSERT INTO `t_s_town` VALUES ('4641', '海子乡', '150221213000', '150221000000');
INSERT INTO `t_s_town` VALUES ('4642', '明沙淖乡', '150221214000', '150221000000');
INSERT INTO `t_s_town` VALUES ('4643', '苏波盖乡', '150221215000', '150221000000');
INSERT INTO `t_s_town` VALUES ('4644', '九峰山生态管理委员会', '150221500000', '150221000000');
INSERT INTO `t_s_town` VALUES ('4645', '金山镇', '150222102000', '150222000000');
INSERT INTO `t_s_town` VALUES ('4646', '西斗铺镇', '150222103000', '150222000000');
INSERT INTO `t_s_town` VALUES ('4647', '下湿壕镇', '150222104000', '150222000000');
INSERT INTO `t_s_town` VALUES ('4648', '银号镇', '150222105000', '150222000000');
INSERT INTO `t_s_town` VALUES ('4649', '怀朔镇', '150222106000', '150222000000');
INSERT INTO `t_s_town` VALUES ('4650', '兴顺西镇', '150222107000', '150222000000');
INSERT INTO `t_s_town` VALUES ('4651', '满都拉镇', '150223102000', '150223000000');
INSERT INTO `t_s_town` VALUES ('4652', '希拉穆仁镇', '150223103000', '150223000000');
INSERT INTO `t_s_town` VALUES ('4653', '百灵庙镇', '150223104000', '150223000000');
INSERT INTO `t_s_town` VALUES ('4654', '石宝镇', '150223105000', '150223000000');
INSERT INTO `t_s_town` VALUES ('4655', '乌克忽洞镇', '150223106000', '150223000000');
INSERT INTO `t_s_town` VALUES ('4656', '明安镇', '150223107000', '150223000000');
INSERT INTO `t_s_town` VALUES ('4657', '巴音花镇', '150223108000', '150223000000');
INSERT INTO `t_s_town` VALUES ('4658', '达尔罕苏木乡', '150223213000', '150223000000');
INSERT INTO `t_s_town` VALUES ('4659', '查干哈达苏木', '150223214000', '150223000000');
INSERT INTO `t_s_town` VALUES ('4660', '巴音敖包苏木', '150223215000', '150223000000');
INSERT INTO `t_s_town` VALUES ('4661', '西河乡', '150223216000', '150223000000');
INSERT INTO `t_s_town` VALUES ('4662', '小文公乡', '150223217000', '150223000000');
INSERT INTO `t_s_town` VALUES ('4663', '稀土路街道办事处', '150271010000', '150271000000');
INSERT INTO `t_s_town` VALUES ('4664', '民馨路街道办事处', '150271020000', '150271000000');
INSERT INTO `t_s_town` VALUES ('4665', '万水泉镇', '150271102000', '150271000000');
INSERT INTO `t_s_town` VALUES ('4666', '凤凰岭街道办事处', '150302001000', '150302000000');
INSERT INTO `t_s_town` VALUES ('4667', '海北街道办事处', '150302002000', '150302000000');
INSERT INTO `t_s_town` VALUES ('4668', '新华街道办事处', '150302003000', '150302000000');
INSERT INTO `t_s_town` VALUES ('4669', '新华西街道办事处', '150302004000', '150302000000');
INSERT INTO `t_s_town` VALUES ('4670', '滨河街道办事处', '150302007000', '150302000000');
INSERT INTO `t_s_town` VALUES ('4671', '林荫街道办事处', '150302008000', '150302000000');
INSERT INTO `t_s_town` VALUES ('4672', '千里山镇', '150302101000', '150302000000');
INSERT INTO `t_s_town` VALUES ('4673', '乌海市海勃湾千里山工业园区', '150302400000', '150302000000');
INSERT INTO `t_s_town` VALUES ('4674', '拉僧仲街道办事处', '150303001000', '150303000000');
INSERT INTO `t_s_town` VALUES ('4675', '西卓子山街道办事处', '150303002000', '150303000000');
INSERT INTO `t_s_town` VALUES ('4676', '公乌素镇', '150303102000', '150303000000');
INSERT INTO `t_s_town` VALUES ('4677', '拉僧庙镇', '150303103000', '150303000000');
INSERT INTO `t_s_town` VALUES ('4678', '巴音陶亥镇', '150303104000', '150303000000');
INSERT INTO `t_s_town` VALUES ('4679', '三道坎街道办事处', '150304002000', '150304000000');
INSERT INTO `t_s_town` VALUES ('4680', '五虎山街道办事处', '150304003000', '150304000000');
INSERT INTO `t_s_town` VALUES ('4681', '新达街道办事处', '150304008000', '150304000000');
INSERT INTO `t_s_town` VALUES ('4682', '巴音赛街道办事处', '150304009000', '150304000000');
INSERT INTO `t_s_town` VALUES ('4683', '梁家沟街道办事处', '150304010000', '150304000000');
INSERT INTO `t_s_town` VALUES ('4684', '苏海图街道办事处', '150304011000', '150304000000');
INSERT INTO `t_s_town` VALUES ('4685', '滨海街道办事处', '150304012000', '150304000000');
INSERT INTO `t_s_town` VALUES ('4686', '乌兰淖尔镇', '150304101000', '150304000000');
INSERT INTO `t_s_town` VALUES ('4687', '乌达经济开发区', '150304400000', '150304000000');
INSERT INTO `t_s_town` VALUES ('4688', '西屯街道办事处', '150402001000', '150402000000');
INSERT INTO `t_s_town` VALUES ('4689', '三中街街道办事处', '150402002000', '150402000000');
INSERT INTO `t_s_town` VALUES ('4690', '永巨街道办事处', '150402003000', '150402000000');
INSERT INTO `t_s_town` VALUES ('4691', '东城街道办事处', '150402004000', '150402000000');
INSERT INTO `t_s_town` VALUES ('4692', '南新街街道办事处', '150402005000', '150402000000');
INSERT INTO `t_s_town` VALUES ('4693', '站前街道办事处', '150402006000', '150402000000');
INSERT INTO `t_s_town` VALUES ('4694', '铁南街道办事处', '150402007000', '150402000000');
INSERT INTO `t_s_town` VALUES ('4695', '长青街道办事处', '150402008000', '150402000000');
INSERT INTO `t_s_town` VALUES ('4696', '哈达街道办事处', '150402009000', '150402000000');
INSERT INTO `t_s_town` VALUES ('4697', '西城街道办事处', '150402010000', '150402000000');
INSERT INTO `t_s_town` VALUES ('4698', '桥北街道办事处', '150402011000', '150402000000');
INSERT INTO `t_s_town` VALUES ('4699', '红庙子镇', '150402100000', '150402000000');
INSERT INTO `t_s_town` VALUES ('4700', '文钟镇', '150402102000', '150402000000');
INSERT INTO `t_s_town` VALUES ('4701', '红山高新技术产业园区管理委员会', '150402400000', '150402000000');
INSERT INTO `t_s_town` VALUES ('4702', '红山物流园区', '150402401000', '150402000000');
INSERT INTO `t_s_town` VALUES ('4703', '红山区农畜产品加工产业园区', '150402402000', '150402000000');
INSERT INTO `t_s_town` VALUES ('4704', '西露天街道办事处', '150403001000', '150403000000');
INSERT INTO `t_s_town` VALUES ('4705', '平庄城区街道办事处', '150403002000', '150403000000');
INSERT INTO `t_s_town` VALUES ('4706', '平庄东城街道办事处', '150403003000', '150403000000');
INSERT INTO `t_s_town` VALUES ('4707', '平庄西城街道办事处', '150403004000', '150403000000');
INSERT INTO `t_s_town` VALUES ('4708', '马林街道办事处', '150403005000', '150403000000');
INSERT INTO `t_s_town` VALUES ('4709', '云杉路街道办事处', '150403006000', '150403000000');
INSERT INTO `t_s_town` VALUES ('4710', '风水沟镇', '150403100000', '150403000000');
INSERT INTO `t_s_town` VALUES ('4711', '元宝山镇', '150403101000', '150403000000');
INSERT INTO `t_s_town` VALUES ('4712', '美丽河镇', '150403102000', '150403000000');
INSERT INTO `t_s_town` VALUES ('4713', '平庄镇', '150403103000', '150403000000');
INSERT INTO `t_s_town` VALUES ('4714', '五家镇', '150403104000', '150403000000');
INSERT INTO `t_s_town` VALUES ('4715', '小五家乡', '150403200000', '150403000000');
INSERT INTO `t_s_town` VALUES ('4716', '振兴街道办事处', '150404001000', '150404000000');
INSERT INTO `t_s_town` VALUES ('4717', '向阳街道办事处', '150404002000', '150404000000');
INSERT INTO `t_s_town` VALUES ('4718', '松州街道办事处', '150404003000', '150404000000');
INSERT INTO `t_s_town` VALUES ('4719', '铁东街道办事处', '150404004000', '150404000000');
INSERT INTO `t_s_town` VALUES ('4720', '穆家营子镇', '150404100000', '150404000000');
INSERT INTO `t_s_town` VALUES ('4721', '初头朗镇', '150404101000', '150404000000');
INSERT INTO `t_s_town` VALUES ('4722', '大庙镇', '150404102000', '150404000000');
INSERT INTO `t_s_town` VALUES ('4723', '王府镇', '150404103000', '150404000000');
INSERT INTO `t_s_town` VALUES ('4724', '老府镇', '150404104000', '150404000000');
INSERT INTO `t_s_town` VALUES ('4725', '哈拉道口镇', '150404105000', '150404000000');
INSERT INTO `t_s_town` VALUES ('4726', '上官地镇', '150404106000', '150404000000');
INSERT INTO `t_s_town` VALUES ('4727', '安庆镇', '150404107000', '150404000000');
INSERT INTO `t_s_town` VALUES ('4728', '太平地镇', '150404108000', '150404000000');
INSERT INTO `t_s_town` VALUES ('4729', '当铺地满族乡', '150404200000', '150404000000');
INSERT INTO `t_s_town` VALUES ('4730', '夏家店乡', '150404201000', '150404000000');
INSERT INTO `t_s_town` VALUES ('4731', '城子乡', '150404202000', '150404000000');
INSERT INTO `t_s_town` VALUES ('4732', '大夫营子乡', '150404203000', '150404000000');
INSERT INTO `t_s_town` VALUES ('4733', '岗子乡', '150404204000', '150404000000');
INSERT INTO `t_s_town` VALUES ('4734', '玉龙街道办事处', '150404400000', '150404000000');
INSERT INTO `t_s_town` VALUES ('4735', '全宁街道办事处', '150404401000', '150404000000');
INSERT INTO `t_s_town` VALUES ('4736', '兴安街道办事处', '150404407000', '150404000000');
INSERT INTO `t_s_town` VALUES ('4737', '天山镇', '150421100000', '150421000000');
INSERT INTO `t_s_town` VALUES ('4738', '天山口镇', '150421101000', '150421000000');
INSERT INTO `t_s_town` VALUES ('4739', '双胜镇', '150421102000', '150421000000');
INSERT INTO `t_s_town` VALUES ('4740', '坤都镇', '150421103000', '150421000000');
INSERT INTO `t_s_town` VALUES ('4741', '巴彦花镇', '150421104000', '150421000000');
INSERT INTO `t_s_town` VALUES ('4742', '绍根镇', '150421105000', '150421000000');
INSERT INTO `t_s_town` VALUES ('4743', '扎嘎斯台镇', '150421106000', '150421000000');
INSERT INTO `t_s_town` VALUES ('4744', '新民乡', '150421200000', '150421000000');
INSERT INTO `t_s_town` VALUES ('4745', '先锋乡', '150421201000', '150421000000');
INSERT INTO `t_s_town` VALUES ('4746', '罕苏木苏木', '150421202000', '150421000000');
INSERT INTO `t_s_town` VALUES ('4747', '赛汉塔拉苏木', '150421203000', '150421000000');
INSERT INTO `t_s_town` VALUES ('4748', '巴拉奇如德苏木', '150421204000', '150421000000');
INSERT INTO `t_s_town` VALUES ('4749', '乌兰哈达乡', '150421205000', '150421000000');
INSERT INTO `t_s_town` VALUES ('4750', '巴彦温都尔苏木', '150421206000', '150421000000');
INSERT INTO `t_s_town` VALUES ('4751', '轻工食品产业园', '150421400000', '150421000000');
INSERT INTO `t_s_town` VALUES ('4752', '新能源产业园', '150421401000', '150421000000');
INSERT INTO `t_s_town` VALUES ('4753', '绍根煤碳及煤化工产业园', '150421402000', '150421000000');
INSERT INTO `t_s_town` VALUES ('4754', '罕乌拉街道办事处', '150421403000', '150421000000');
INSERT INTO `t_s_town` VALUES ('4755', '欧沐沦街道办事处', '150421404000', '150421000000');
INSERT INTO `t_s_town` VALUES ('4756', '林东镇', '150422100000', '150422000000');
INSERT INTO `t_s_town` VALUES ('4757', '隆昌镇', '150422101000', '150422000000');
INSERT INTO `t_s_town` VALUES ('4758', '十三敖包镇', '150422102000', '150422000000');
INSERT INTO `t_s_town` VALUES ('4759', '碧流台镇', '150422103000', '150422000000');
INSERT INTO `t_s_town` VALUES ('4760', '富河镇', '150422104000', '150422000000');
INSERT INTO `t_s_town` VALUES ('4761', '白音勿拉镇', '150422105000', '150422000000');
INSERT INTO `t_s_town` VALUES ('4762', '哈拉哈达镇', '150422106000', '150422000000');
INSERT INTO `t_s_town` VALUES ('4763', '查干哈达苏木', '150422200000', '150422000000');
INSERT INTO `t_s_town` VALUES ('4764', '乌兰达坝苏木', '150422201000', '150422000000');
INSERT INTO `t_s_town` VALUES ('4765', '三山乡', '150422202000', '150422000000');
INSERT INTO `t_s_town` VALUES ('4766', '花加拉嘎乡', '150422203000', '150422000000');
INSERT INTO `t_s_town` VALUES ('4767', '上京高新技术产业集中区', '150422400000', '150422000000');
INSERT INTO `t_s_town` VALUES ('4768', '南塔工业集中区', '150422401000', '150422000000');
INSERT INTO `t_s_town` VALUES ('4769', '凤凰山工业集中区', '150422402000', '150422000000');
INSERT INTO `t_s_town` VALUES ('4770', '林东西城街道办事处', '150422403000', '150422000000');
INSERT INTO `t_s_town` VALUES ('4771', '林东东城街道办事处', '150422404000', '150422000000');
INSERT INTO `t_s_town` VALUES ('4772', '大板镇', '150423100000', '150423000000');
INSERT INTO `t_s_town` VALUES ('4773', '索博日嘎镇', '150423101000', '150423000000');
INSERT INTO `t_s_town` VALUES ('4774', '宝日勿苏镇', '150423102000', '150423000000');
INSERT INTO `t_s_town` VALUES ('4775', '查干诺尔镇', '150423103000', '150423000000');
INSERT INTO `t_s_town` VALUES ('4776', '巴彦琥硕镇', '150423105000', '150423000000');
INSERT INTO `t_s_town` VALUES ('4777', '西拉沐沦苏木', '150423200000', '150423000000');
INSERT INTO `t_s_town` VALUES ('4778', '巴彦塔拉苏木', '150423201000', '150423000000');
INSERT INTO `t_s_town` VALUES ('4779', '幸福之路苏木', '150423202000', '150423000000');
INSERT INTO `t_s_town` VALUES ('4780', '查干沐沦苏木', '150423203000', '150423000000');
INSERT INTO `t_s_town` VALUES ('4781', '大板煤电化基地', '150423400000', '150423000000');
INSERT INTO `t_s_town` VALUES ('4782', '林西镇', '150424100000', '150424000000');
INSERT INTO `t_s_town` VALUES ('4783', '新城子镇', '150424101000', '150424000000');
INSERT INTO `t_s_town` VALUES ('4784', '新林镇', '150424102000', '150424000000');
INSERT INTO `t_s_town` VALUES ('4785', '五十家子镇', '150424103000', '150424000000');
INSERT INTO `t_s_town` VALUES ('4786', '官地镇', '150424104000', '150424000000');
INSERT INTO `t_s_town` VALUES ('4787', '大井镇', '150424105000', '150424000000');
INSERT INTO `t_s_town` VALUES ('4788', '统部镇', '150424106000', '150424000000');
INSERT INTO `t_s_town` VALUES ('4789', '大营子乡', '150424200000', '150424000000');
INSERT INTO `t_s_town` VALUES ('4790', '十二吐乡', '150424201000', '150424000000');
INSERT INTO `t_s_town` VALUES ('4791', '城北街道办事处筹备处', '150424400000', '150424000000');
INSERT INTO `t_s_town` VALUES ('4792', '城南街道办事处筹备处', '150424401000', '150424000000');
INSERT INTO `t_s_town` VALUES ('4793', '内蒙古林西工业园区', '150424402000', '150424000000');
INSERT INTO `t_s_town` VALUES ('4794', '经棚镇', '150425100000', '150425000000');
INSERT INTO `t_s_town` VALUES ('4795', '宇宙地镇', '150425101000', '150425000000');
INSERT INTO `t_s_town` VALUES ('4796', '土城子镇', '150425102000', '150425000000');
INSERT INTO `t_s_town` VALUES ('4797', '同兴镇', '150425103000', '150425000000');
INSERT INTO `t_s_town` VALUES ('4798', '万合永镇', '150425104000', '150425000000');
INSERT INTO `t_s_town` VALUES ('4799', '芝瑞镇', '150425105000', '150425000000');
INSERT INTO `t_s_town` VALUES ('4800', '达来诺日镇', '150425106000', '150425000000');
INSERT INTO `t_s_town` VALUES ('4801', '新开地乡', '150425200000', '150425000000');
INSERT INTO `t_s_town` VALUES ('4802', '红山子乡', '150425201000', '150425000000');
INSERT INTO `t_s_town` VALUES ('4803', '达日罕乌拉苏木', '150425202000', '150425000000');
INSERT INTO `t_s_town` VALUES ('4804', '巴彦查干苏木', '150425203000', '150425000000');
INSERT INTO `t_s_town` VALUES ('4805', '浩来呼热苏木', '150425204000', '150425000000');
INSERT INTO `t_s_town` VALUES ('4806', '乌兰布统苏木', '150425205000', '150425000000');
INSERT INTO `t_s_town` VALUES ('4807', '应昌街道办事处', '150425400000', '150425000000');
INSERT INTO `t_s_town` VALUES ('4808', '热水塘温泉疗养旅游开发区管委会', '150425401000', '150425000000');
INSERT INTO `t_s_town` VALUES ('4809', '克什克腾旗煤电化基地', '150425402000', '150425000000');
INSERT INTO `t_s_town` VALUES ('4810', '西拉沐沦街道办事处', '150425403000', '150425000000');
INSERT INTO `t_s_town` VALUES ('4811', '克什克腾旗渔场', '150425502000', '150425000000');
INSERT INTO `t_s_town` VALUES ('4812', '乌丹镇', '150426100000', '150426000000');
INSERT INTO `t_s_town` VALUES ('4813', '乌敦套海镇', '150426101000', '150426000000');
INSERT INTO `t_s_town` VALUES ('4814', '五分地镇', '150426102000', '150426000000');
INSERT INTO `t_s_town` VALUES ('4815', '桥头镇', '150426103000', '150426000000');
INSERT INTO `t_s_town` VALUES ('4816', '广德公镇', '150426104000', '150426000000');
INSERT INTO `t_s_town` VALUES ('4817', '梧桐花镇', '150426105000', '150426000000');
INSERT INTO `t_s_town` VALUES ('4818', '海拉苏镇', '150426106000', '150426000000');
INSERT INTO `t_s_town` VALUES ('4819', '亿合公镇', '150426107000', '150426000000');
INSERT INTO `t_s_town` VALUES ('4820', '解放营子乡', '150426200000', '150426000000');
INSERT INTO `t_s_town` VALUES ('4821', '阿什罕苏木', '150426201000', '150426000000');
INSERT INTO `t_s_town` VALUES ('4822', '新苏莫苏木', '150426202000', '150426000000');
INSERT INTO `t_s_town` VALUES ('4823', '白音套海苏木', '150426203000', '150426000000');
INSERT INTO `t_s_town` VALUES ('4824', '毛山东乡', '150426204000', '150426000000');
INSERT INTO `t_s_town` VALUES ('4825', '格日僧苏木', '150426205000', '150426000000');
INSERT INTO `t_s_town` VALUES ('4826', '玉龙工业园区', '150426400000', '150426000000');
INSERT INTO `t_s_town` VALUES ('4827', '紫城街道筹备处', '150426402000', '150426000000');
INSERT INTO `t_s_town` VALUES ('4828', '全宁街道筹备处', '150426403000', '150426000000');
INSERT INTO `t_s_town` VALUES ('4829', '锦山镇', '150428100000', '150428000000');
INSERT INTO `t_s_town` VALUES ('4830', '美林镇', '150428101000', '150428000000');
INSERT INTO `t_s_town` VALUES ('4831', '王爷府镇', '150428102000', '150428000000');
INSERT INTO `t_s_town` VALUES ('4832', '小牛群镇', '150428103000', '150428000000');
INSERT INTO `t_s_town` VALUES ('4833', '牛家营子镇', '150428104000', '150428000000');
INSERT INTO `t_s_town` VALUES ('4834', '乃林镇', '150428105000', '150428000000');
INSERT INTO `t_s_town` VALUES ('4835', '西桥镇', '150428106000', '150428000000');
INSERT INTO `t_s_town` VALUES ('4836', '十家满族乡', '150428200000', '150428000000');
INSERT INTO `t_s_town` VALUES ('4837', '南台子乡', '150428201000', '150428000000');
INSERT INTO `t_s_town` VALUES ('4838', '乃林果树农场', '150428400000', '150428000000');
INSERT INTO `t_s_town` VALUES ('4839', '马鞍山羊场', '150428401000', '150428000000');
INSERT INTO `t_s_town` VALUES ('4840', '赤峰市和美工贸园区', '150428402000', '150428000000');
INSERT INTO `t_s_town` VALUES ('4841', '锦山工业园区', '150428403000', '150428000000');
INSERT INTO `t_s_town` VALUES ('4842', '天义镇', '150429100000', '150429000000');
INSERT INTO `t_s_town` VALUES ('4843', '小城子镇', '150429101000', '150429000000');
INSERT INTO `t_s_town` VALUES ('4844', '大城子镇', '150429102000', '150429000000');
INSERT INTO `t_s_town` VALUES ('4845', '八里罕镇', '150429103000', '150429000000');
INSERT INTO `t_s_town` VALUES ('4846', '黑里河镇', '150429104000', '150429000000');
INSERT INTO `t_s_town` VALUES ('4847', '右北平镇', '150429105000', '150429000000');
INSERT INTO `t_s_town` VALUES ('4848', '大双庙镇', '150429106000', '150429000000');
INSERT INTO `t_s_town` VALUES ('4849', '汐子镇', '150429107000', '150429000000');
INSERT INTO `t_s_town` VALUES ('4850', '大明镇', '150429108000', '150429000000');
INSERT INTO `t_s_town` VALUES ('4851', '忙农镇', '150429109000', '150429000000');
INSERT INTO `t_s_town` VALUES ('4852', '五化镇', '150429110000', '150429000000');
INSERT INTO `t_s_town` VALUES ('4853', '三座店镇', '150429111000', '150429000000');
INSERT INTO `t_s_town` VALUES ('4854', '必斯营子镇', '150429112000', '150429000000');
INSERT INTO `t_s_town` VALUES ('4855', '一肯中乡', '150429202000', '150429000000');
INSERT INTO `t_s_town` VALUES ('4856', '存金沟乡', '150429203000', '150429000000');
INSERT INTO `t_s_town` VALUES ('4857', '中京工业园', '150429400000', '150429000000');
INSERT INTO `t_s_town` VALUES ('4858', '塞飞亚食品工业园', '150429401000', '150429000000');
INSERT INTO `t_s_town` VALUES ('4859', '八里罕酒业园区', '150429402000', '150429000000');
INSERT INTO `t_s_town` VALUES ('4860', '再生资源产业园', '150429403000', '150429000000');
INSERT INTO `t_s_town` VALUES ('4861', '生物科技产业园区', '150429404000', '150429000000');
INSERT INTO `t_s_town` VALUES ('4862', '汐子工业园', '150429405000', '150429000000');
INSERT INTO `t_s_town` VALUES ('4863', '农机产业园区', '150429406000', '150429000000');
INSERT INTO `t_s_town` VALUES ('4864', '新惠镇', '150430100000', '150430000000');
INSERT INTO `t_s_town` VALUES ('4865', '四家子镇', '150430101000', '150430000000');
INSERT INTO `t_s_town` VALUES ('4866', '长胜镇', '150430102000', '150430000000');
INSERT INTO `t_s_town` VALUES ('4867', '贝子府镇', '150430103000', '150430000000');
INSERT INTO `t_s_town` VALUES ('4868', '四道湾子镇', '150430104000', '150430000000');
INSERT INTO `t_s_town` VALUES ('4869', '下洼镇', '150430105000', '150430000000');
INSERT INTO `t_s_town` VALUES ('4870', '金厂沟梁镇', '150430106000', '150430000000');
INSERT INTO `t_s_town` VALUES ('4871', '兴隆洼镇', '150430107000', '150430000000');
INSERT INTO `t_s_town` VALUES ('4872', '黄羊洼镇', '150430108000', '150430000000');
INSERT INTO `t_s_town` VALUES ('4873', '牛古吐镇', '150430109000', '150430000000');
INSERT INTO `t_s_town` VALUES ('4874', '古鲁板蒿镇', '150430110000', '150430000000');
INSERT INTO `t_s_town` VALUES ('4875', '木头营子乡', '150430202000', '150430000000');
INSERT INTO `t_s_town` VALUES ('4876', '丰收乡', '150430204000', '150430000000');
INSERT INTO `t_s_town` VALUES ('4877', '玛尼罕乡', '150430205000', '150430000000');
INSERT INTO `t_s_town` VALUES ('4878', '萨力巴乡', '150430206000', '150430000000');
INSERT INTO `t_s_town` VALUES ('4879', '敖润苏莫苏木', '150430207000', '150430000000');
INSERT INTO `t_s_town` VALUES ('4880', '国营种羊场', '150430400000', '150430000000');
INSERT INTO `t_s_town` VALUES ('4881', '敖汉旗新惠工业园区', '150430401000', '150430000000');
INSERT INTO `t_s_town` VALUES ('4882', '贝子府化工集中区', '150430402000', '150430000000');
INSERT INTO `t_s_town` VALUES ('4883', '四家子冶金工业集中区', '150430403000', '150430000000');
INSERT INTO `t_s_town` VALUES ('4884', '科尔沁街道办事处', '150502001000', '150502000000');
INSERT INTO `t_s_town` VALUES ('4885', '西门街道办事处', '150502002000', '150502000000');
INSERT INTO `t_s_town` VALUES ('4886', '永清街道办事处', '150502003000', '150502000000');
INSERT INTO `t_s_town` VALUES ('4887', '明仁街道办事处', '150502004000', '150502000000');
INSERT INTO `t_s_town` VALUES ('4888', '施介街道办事处', '150502005000', '150502000000');
INSERT INTO `t_s_town` VALUES ('4889', '清真街道办事处', '150502006000', '150502000000');
INSERT INTO `t_s_town` VALUES ('4890', '东郊街道办事处', '150502007000', '150502000000');
INSERT INTO `t_s_town` VALUES ('4891', '铁路街道办事处', '150502008000', '150502000000');
INSERT INTO `t_s_town` VALUES ('4892', '红星街道办事处', '150502009000', '150502000000');
INSERT INTO `t_s_town` VALUES ('4893', '霍林街道办事处', '150502010000', '150502000000');
INSERT INTO `t_s_town` VALUES ('4894', '建国街道办事处', '150502011000', '150502000000');
INSERT INTO `t_s_town` VALUES ('4895', '大林镇', '150502100000', '150502000000');
INSERT INTO `t_s_town` VALUES ('4896', '钱家店镇', '150502101000', '150502000000');
INSERT INTO `t_s_town` VALUES ('4897', '余粮堡镇', '150502102000', '150502000000');
INSERT INTO `t_s_town` VALUES ('4898', '木里图镇', '150502103000', '150502000000');
INSERT INTO `t_s_town` VALUES ('4899', '丰田镇', '150502104000', '150502000000');
INSERT INTO `t_s_town` VALUES ('4900', '清河镇', '150502105000', '150502000000');
INSERT INTO `t_s_town` VALUES ('4901', '育新镇', '150502106000', '150502000000');
INSERT INTO `t_s_town` VALUES ('4902', '庆和镇', '150502107000', '150502000000');
INSERT INTO `t_s_town` VALUES ('4903', '敖力布皋镇', '150502108000', '150502000000');
INSERT INTO `t_s_town` VALUES ('4904', '莫力庙苏木', '150502200000', '150502000000');
INSERT INTO `t_s_town` VALUES ('4905', '哲南农场', '150502400000', '150502000000');
INSERT INTO `t_s_town` VALUES ('4906', '三义堂农场', '150502401000', '150502000000');
INSERT INTO `t_s_town` VALUES ('4907', '高林屯种畜场', '150502402000', '150502000000');
INSERT INTO `t_s_town` VALUES ('4908', '胡力海原种繁殖场', '150502403000', '150502000000');
INSERT INTO `t_s_town` VALUES ('4909', '莫力庙羊场', '150502404000', '150502000000');
INSERT INTO `t_s_town` VALUES ('4910', '半截店牧场', '150502405000', '150502000000');
INSERT INTO `t_s_town` VALUES ('4911', '保康镇', '150521100000', '150521000000');
INSERT INTO `t_s_town` VALUES ('4912', '宝龙山镇', '150521101000', '150521000000');
INSERT INTO `t_s_town` VALUES ('4913', '舍伯吐镇', '150521102000', '150521000000');
INSERT INTO `t_s_town` VALUES ('4914', '巴彦塔拉镇', '150521103000', '150521000000');
INSERT INTO `t_s_town` VALUES ('4915', '门达镇', '150521104000', '150521000000');
INSERT INTO `t_s_town` VALUES ('4916', '架玛吐镇', '150521105000', '150521000000');
INSERT INTO `t_s_town` VALUES ('4917', '腰林毛都镇', '150521106000', '150521000000');
INSERT INTO `t_s_town` VALUES ('4918', '希伯花镇', '150521107000', '150521000000');
INSERT INTO `t_s_town` VALUES ('4919', '花吐古拉镇', '150521108000', '150521000000');
INSERT INTO `t_s_town` VALUES ('4920', '代力吉镇', '150521109000', '150521000000');
INSERT INTO `t_s_town` VALUES ('4921', '努日木镇', '150521110000', '150521000000');
INSERT INTO `t_s_town` VALUES ('4922', '花胡硕苏木乡', '150521200000', '150521000000');
INSERT INTO `t_s_town` VALUES ('4923', '协代苏木乡', '150521201000', '150521000000');
INSERT INTO `t_s_town` VALUES ('4924', '白兴吐苏木乡', '150521202000', '150521000000');
INSERT INTO `t_s_town` VALUES ('4925', '图布信苏木乡', '150521203000', '150521000000');
INSERT INTO `t_s_town` VALUES ('4926', '敖包苏木', '150521204000', '150521000000');
INSERT INTO `t_s_town` VALUES ('4927', '胜利乡', '150521205000', '150521000000');
INSERT INTO `t_s_town` VALUES ('4928', '白音塔拉农场', '150521400000', '150521000000');
INSERT INTO `t_s_town` VALUES ('4929', '珠日河牧场', '150521401000', '150521000000');
INSERT INTO `t_s_town` VALUES ('4930', '丰库牧场', '150521402000', '150521000000');
INSERT INTO `t_s_town` VALUES ('4931', '保康街道办事处', '150521403000', '150521000000');
INSERT INTO `t_s_town` VALUES ('4932', '甘旗卡镇', '150522100000', '150522000000');
INSERT INTO `t_s_town` VALUES ('4933', '吉尔嘎朗镇', '150522101000', '150522000000');
INSERT INTO `t_s_town` VALUES ('4934', '金宝屯镇', '150522102000', '150522000000');
INSERT INTO `t_s_town` VALUES ('4935', '常胜镇', '150522103000', '150522000000');
INSERT INTO `t_s_town` VALUES ('4936', '查日苏镇', '150522104000', '150522000000');
INSERT INTO `t_s_town` VALUES ('4937', '双胜镇', '150522105000', '150522000000');
INSERT INTO `t_s_town` VALUES ('4938', '阿古拉镇', '150522106000', '150522000000');
INSERT INTO `t_s_town` VALUES ('4939', '朝鲁吐镇', '150522107000', '150522000000');
INSERT INTO `t_s_town` VALUES ('4940', '努古斯台镇', '150522108000', '150522000000');
INSERT INTO `t_s_town` VALUES ('4941', '海鲁吐镇', '150522109000', '150522000000');
INSERT INTO `t_s_town` VALUES ('4942', '阿都沁苏木', '150522200000', '150522000000');
INSERT INTO `t_s_town` VALUES ('4943', '茂道吐苏木', '150522201000', '150522000000');
INSERT INTO `t_s_town` VALUES ('4944', '巴嘎塔拉苏木', '150522202000', '150522000000');
INSERT INTO `t_s_town` VALUES ('4945', '散都苏木', '150522203000', '150522000000');
INSERT INTO `t_s_town` VALUES ('4946', '巴彦毛都苏木', '150522204000', '150522000000');
INSERT INTO `t_s_town` VALUES ('4947', '胜利农场', '150522400000', '150522000000');
INSERT INTO `t_s_town` VALUES ('4948', '孟根达坝牧场', '150522401000', '150522000000');
INSERT INTO `t_s_town` VALUES ('4949', '查金台牧场', '150522402000', '150522000000');
INSERT INTO `t_s_town` VALUES ('4950', '原种场', '150522403000', '150522000000');
INSERT INTO `t_s_town` VALUES ('4951', '大青沟管理局', '150522404000', '150522000000');
INSERT INTO `t_s_town` VALUES ('4952', '哈日乌苏种畜场', '150522405000', '150522000000');
INSERT INTO `t_s_town` VALUES ('4953', '乌兰敖道渔场', '150522406000', '150522000000');
INSERT INTO `t_s_town` VALUES ('4954', '金宝屯林场', '150522407000', '150522000000');
INSERT INTO `t_s_town` VALUES ('4955', '朝鲁吐林场', '150522408000', '150522000000');
INSERT INTO `t_s_town` VALUES ('4956', '茂道吐林场', '150522409000', '150522000000');
INSERT INTO `t_s_town` VALUES ('4957', '伊胡塔林场', '150522410000', '150522000000');
INSERT INTO `t_s_town` VALUES ('4958', '乌旦塔拉林场', '150522411000', '150522000000');
INSERT INTO `t_s_town` VALUES ('4959', '开鲁镇', '150523100000', '150523000000');
INSERT INTO `t_s_town` VALUES ('4960', '大榆树镇', '150523101000', '150523000000');
INSERT INTO `t_s_town` VALUES ('4961', '黑龙坝镇', '150523102000', '150523000000');
INSERT INTO `t_s_town` VALUES ('4962', '麦新镇', '150523103000', '150523000000');
INSERT INTO `t_s_town` VALUES ('4963', '义和塔拉镇', '150523104000', '150523000000');
INSERT INTO `t_s_town` VALUES ('4964', '建华镇', '150523105000', '150523000000');
INSERT INTO `t_s_town` VALUES ('4965', '小街基镇', '150523106000', '150523000000');
INSERT INTO `t_s_town` VALUES ('4966', '东风镇', '150523107000', '150523000000');
INSERT INTO `t_s_town` VALUES ('4967', '吉日嘎郎吐镇', '150523108000', '150523000000');
INSERT INTO `t_s_town` VALUES ('4968', '东来镇', '150523109000', '150523000000');
INSERT INTO `t_s_town` VALUES ('4969', '清河牧场', '150523400000', '150523000000');
INSERT INTO `t_s_town` VALUES ('4970', '辽河农场', '150523401000', '150523000000');
INSERT INTO `t_s_town` VALUES ('4971', '保安农场', '150523402000', '150523000000');
INSERT INTO `t_s_town` VALUES ('4972', '库伦镇', '150524100000', '150524000000');
INSERT INTO `t_s_town` VALUES ('4973', '扣河子镇', '150524101000', '150524000000');
INSERT INTO `t_s_town` VALUES ('4974', '白音花镇', '150524102000', '150524000000');
INSERT INTO `t_s_town` VALUES ('4975', '六家子镇', '150524103000', '150524000000');
INSERT INTO `t_s_town` VALUES ('4976', '额勒顺镇', '150524104000', '150524000000');
INSERT INTO `t_s_town` VALUES ('4977', '茫汗苏木', '150524200000', '150524000000');
INSERT INTO `t_s_town` VALUES ('4978', '先进苏木', '150524201000', '150524000000');
INSERT INTO `t_s_town` VALUES ('4979', '水泉乡', '150524202000', '150524000000');
INSERT INTO `t_s_town` VALUES ('4980', '库伦街道办事处', '150524400000', '150524000000');
INSERT INTO `t_s_town` VALUES ('4981', '大沁他拉镇', '150525100000', '150525000000');
INSERT INTO `t_s_town` VALUES ('4982', '八仙筒镇', '150525101000', '150525000000');
INSERT INTO `t_s_town` VALUES ('4983', '青龙山镇', '150525102000', '150525000000');
INSERT INTO `t_s_town` VALUES ('4984', '新镇', '150525103000', '150525000000');
INSERT INTO `t_s_town` VALUES ('4985', '治安镇', '150525104000', '150525000000');
INSERT INTO `t_s_town` VALUES ('4986', '东明镇', '150525105000', '150525000000');
INSERT INTO `t_s_town` VALUES ('4987', '沙日浩来镇', '150525106000', '150525000000');
INSERT INTO `t_s_town` VALUES ('4988', '义隆永镇', '150525107000', '150525000000');
INSERT INTO `t_s_town` VALUES ('4989', '固日班花苏木', '150525200000', '150525000000');
INSERT INTO `t_s_town` VALUES ('4990', '白音他拉苏木', '150525201000', '150525000000');
INSERT INTO `t_s_town` VALUES ('4991', '明仁苏木', '150525202000', '150525000000');
INSERT INTO `t_s_town` VALUES ('4992', '黄花塔拉苏木', '150525203000', '150525000000');
INSERT INTO `t_s_town` VALUES ('4993', '土城子乡', '150525204000', '150525000000');
INSERT INTO `t_s_town` VALUES ('4994', '苇莲苏乡', '150525205000', '150525000000');
INSERT INTO `t_s_town` VALUES ('4995', '国有六号农场', '150525400000', '150525000000');
INSERT INTO `t_s_town` VALUES ('4996', '鲁北镇', '150526100000', '150526000000');
INSERT INTO `t_s_town` VALUES ('4997', '黄花山镇', '150526101000', '150526000000');
INSERT INTO `t_s_town` VALUES ('4998', '嘎亥图镇', '150526102000', '150526000000');
INSERT INTO `t_s_town` VALUES ('4999', '巨日合镇', '150526103000', '150526000000');
INSERT INTO `t_s_town` VALUES ('5000', '巴雅尔图胡硕镇', '150526104000', '150526000000');
INSERT INTO `t_s_town` VALUES ('5001', '香山镇', '150526105000', '150526000000');
INSERT INTO `t_s_town` VALUES ('5002', '阿日昆都楞镇', '150526106000', '150526000000');
INSERT INTO `t_s_town` VALUES ('5003', '巴彦塔拉苏木乡', '150526200000', '150526000000');
INSERT INTO `t_s_town` VALUES ('5004', '乌力吉木仁苏木乡', '150526201000', '150526000000');
INSERT INTO `t_s_town` VALUES ('5005', '道老杜苏木乡', '150526202000', '150526000000');
INSERT INTO `t_s_town` VALUES ('5006', '格日朝鲁苏木乡', '150526203000', '150526000000');
INSERT INTO `t_s_town` VALUES ('5007', '前德门苏木', '150526204000', '150526000000');
INSERT INTO `t_s_town` VALUES ('5008', '乌兰哈达苏木', '150526205000', '150526000000');
INSERT INTO `t_s_town` VALUES ('5009', '查布嘎图苏木', '150526206000', '150526000000');
INSERT INTO `t_s_town` VALUES ('5010', '乌额格其苏木', '150526207000', '150526000000');
INSERT INTO `t_s_town` VALUES ('5011', '乌额格其牧场', '150526400000', '150526000000');
INSERT INTO `t_s_town` VALUES ('5012', '香山农场', '150526401000', '150526000000');
INSERT INTO `t_s_town` VALUES ('5013', '乌日根塔拉农场', '150526402000', '150526000000');
INSERT INTO `t_s_town` VALUES ('5014', '嘎达苏种畜场', '150526403000', '150526000000');
INSERT INTO `t_s_town` VALUES ('5015', '河西街道办事处', '150571001000', '150571000000');
INSERT INTO `t_s_town` VALUES ('5016', '电厂街道办事处', '150571002000', '150571000000');
INSERT INTO `t_s_town` VALUES ('5017', '新城街道办事处', '150571003000', '150571000000');
INSERT INTO `t_s_town` VALUES ('5018', '滨河街道办事处', '150571004000', '150571000000');
INSERT INTO `t_s_town` VALUES ('5019', '辽河镇', '150571100000', '150571000000');
INSERT INTO `t_s_town` VALUES ('5020', '珠斯花街道办事处', '150581001000', '150581000000');
INSERT INTO `t_s_town` VALUES ('5021', '莫斯台街道办事处', '150581002000', '150581000000');
INSERT INTO `t_s_town` VALUES ('5022', '宝日呼吉尔街道办事处', '150581003000', '150581000000');
INSERT INTO `t_s_town` VALUES ('5023', '沙尔呼热街道办事处', '150581004000', '150581000000');
INSERT INTO `t_s_town` VALUES ('5024', '达来胡硕苏木', '150581200000', '150581000000');
INSERT INTO `t_s_town` VALUES ('5025', '东蒙鑫农牧业有限责任公司', '150581400000', '150581000000');
INSERT INTO `t_s_town` VALUES ('5026', '交通街道办事处', '150602001000', '150602000000');
INSERT INTO `t_s_town` VALUES ('5027', '公园街道办事处', '150602002000', '150602000000');
INSERT INTO `t_s_town` VALUES ('5028', '林荫街道办事处', '150602003000', '150602000000');
INSERT INTO `t_s_town` VALUES ('5029', '建设街道办事处', '150602004000', '150602000000');
INSERT INTO `t_s_town` VALUES ('5030', '富兴街道办事处', '150602005000', '150602000000');
INSERT INTO `t_s_town` VALUES ('5031', '天骄街道办事处', '150602006000', '150602000000');
INSERT INTO `t_s_town` VALUES ('5032', '诃额伦街道办事处', '150602007000', '150602000000');
INSERT INTO `t_s_town` VALUES ('5033', '巴音门克街道办事处', '150602008000', '150602000000');
INSERT INTO `t_s_town` VALUES ('5034', '幸福街道办事处', '150602010000', '150602000000');
INSERT INTO `t_s_town` VALUES ('5035', '纺织街道办事处', '150602011000', '150602000000');
INSERT INTO `t_s_town` VALUES ('5036', '兴盛街道办事处', '150602012000', '150602000000');
INSERT INTO `t_s_town` VALUES ('5037', '民族街道办事处', '150602013000', '150602000000');
INSERT INTO `t_s_town` VALUES ('5038', '泊尔江海子镇', '150602100000', '150602000000');
INSERT INTO `t_s_town` VALUES ('5039', '罕台镇', '150602101000', '150602000000');
INSERT INTO `t_s_town` VALUES ('5040', '铜川镇', '150602102000', '150602000000');
INSERT INTO `t_s_town` VALUES ('5041', '鄂尔多斯市装备制造基地', '150602400000', '150602000000');
INSERT INTO `t_s_town` VALUES ('5042', '东胜区轻纺工业园区', '150602401000', '150602000000');
INSERT INTO `t_s_town` VALUES ('5043', '铜川汽车博览园', '150602404000', '150602000000');
INSERT INTO `t_s_town` VALUES ('5044', '哈巴格希街道办事处', '150603001000', '150603000000');
INSERT INTO `t_s_town` VALUES ('5045', '青春山街道办事处', '150603002000', '150603000000');
INSERT INTO `t_s_town` VALUES ('5046', '滨河街道办事处', '150603003000', '150603000000');
INSERT INTO `t_s_town` VALUES ('5047', '康新街道办事处', '150603008000', '150603000000');
INSERT INTO `t_s_town` VALUES ('5048', '鄂尔多斯市高新技术产业园区', '150603401000', '150603000000');
INSERT INTO `t_s_town` VALUES ('5049', '鄂尔多斯市云计算产业园区', '150603402000', '150603000000');
INSERT INTO `t_s_town` VALUES ('5050', '工业街道办事处', '150621001000', '150621000000');
INSERT INTO `t_s_town` VALUES ('5051', '昭君街道办事处', '150621002000', '150621000000');
INSERT INTO `t_s_town` VALUES ('5052', '锡尼街道办事处', '150621003000', '150621000000');
INSERT INTO `t_s_town` VALUES ('5053', '白塔街道办事处', '150621004000', '150621000000');
INSERT INTO `t_s_town` VALUES ('5054', '西园街道办事处', '150621005000', '150621000000');
INSERT INTO `t_s_town` VALUES ('5055', '平原街道办事处', '150621006000', '150621000000');
INSERT INTO `t_s_town` VALUES ('5056', '树林召镇', '150621100000', '150621000000');
INSERT INTO `t_s_town` VALUES ('5057', '吉格斯太镇', '150621101000', '150621000000');
INSERT INTO `t_s_town` VALUES ('5058', '白泥井镇', '150621102000', '150621000000');
INSERT INTO `t_s_town` VALUES ('5059', '王爱召镇', '150621103000', '150621000000');
INSERT INTO `t_s_town` VALUES ('5060', '昭君镇', '150621104000', '150621000000');
INSERT INTO `t_s_town` VALUES ('5061', '恩格贝镇', '150621105000', '150621000000');
INSERT INTO `t_s_town` VALUES ('5062', '中和西镇', '150621106000', '150621000000');
INSERT INTO `t_s_town` VALUES ('5063', '风水梁镇', '150621107000', '150621000000');
INSERT INTO `t_s_town` VALUES ('5064', '展旦召苏木乡', '150621200000', '150621000000');
INSERT INTO `t_s_town` VALUES ('5065', '达拉特经济开发区', '150621400000', '150621000000');
INSERT INTO `t_s_town` VALUES ('5066', '鄂尔多斯市生态示范区管理委员会', '150621401000', '150621000000');
INSERT INTO `t_s_town` VALUES ('5067', '兴隆街道', '150622001000', '150622000000');
INSERT INTO `t_s_town` VALUES ('5068', '迎泽街道', '150622002000', '150622000000');
INSERT INTO `t_s_town` VALUES ('5069', '蓝天街道', '150622003000', '150622000000');
INSERT INTO `t_s_town` VALUES ('5070', '友谊街道', '150622004000', '150622000000');
INSERT INTO `t_s_town` VALUES ('5071', '薛家湾镇', '150622100000', '150622000000');
INSERT INTO `t_s_town` VALUES ('5072', '沙圪堵镇', '150622101000', '150622000000');
INSERT INTO `t_s_town` VALUES ('5073', '大路镇', '150622102000', '150622000000');
INSERT INTO `t_s_town` VALUES ('5074', '纳日松镇', '150622103000', '150622000000');
INSERT INTO `t_s_town` VALUES ('5075', '龙口镇', '150622104000', '150622000000');
INSERT INTO `t_s_town` VALUES ('5076', '准格尔召镇', '150622105000', '150622000000');
INSERT INTO `t_s_town` VALUES ('5077', '魏家峁镇', '150622106000', '150622000000');
INSERT INTO `t_s_town` VALUES ('5078', '暖水乡', '150622200000', '150622000000');
INSERT INTO `t_s_town` VALUES ('5079', '十二连城乡', '150622201000', '150622000000');
INSERT INTO `t_s_town` VALUES ('5080', '布尔陶亥苏木乡', '150622202000', '150622000000');
INSERT INTO `t_s_town` VALUES ('5081', '准格尔经济开发区', '150622400000', '150622000000');
INSERT INTO `t_s_town` VALUES ('5082', '大路煤化工基地', '150622401000', '150622000000');
INSERT INTO `t_s_town` VALUES ('5083', '敖勒召其镇', '150623100000', '150623000000');
INSERT INTO `t_s_town` VALUES ('5084', '上海庙镇', '150623101000', '150623000000');
INSERT INTO `t_s_town` VALUES ('5085', '城川镇', '150623102000', '150623000000');
INSERT INTO `t_s_town` VALUES ('5086', '昂素镇', '150623103000', '150623000000');
INSERT INTO `t_s_town` VALUES ('5087', '上海庙经济开发区', '150623400000', '150623000000');
INSERT INTO `t_s_town` VALUES ('5088', '乌兰镇', '150624100000', '150624000000');
INSERT INTO `t_s_town` VALUES ('5089', '棋盘井镇', '150624101000', '150624000000');
INSERT INTO `t_s_town` VALUES ('5090', '蒙西镇', '150624102000', '150624000000');
INSERT INTO `t_s_town` VALUES ('5091', '木凯淖尔镇', '150624103000', '150624000000');
INSERT INTO `t_s_town` VALUES ('5092', '苏米图苏木乡', '150624200000', '150624000000');
INSERT INTO `t_s_town` VALUES ('5093', '阿尔巴斯苏木乡', '150624201000', '150624000000');
INSERT INTO `t_s_town` VALUES ('5094', '蒙西工业园区', '150624403000', '150624000000');
INSERT INTO `t_s_town` VALUES ('5095', '棋盘井工业园区', '150624404000', '150624000000');
INSERT INTO `t_s_town` VALUES ('5096', '锡尼镇', '150625100000', '150625000000');
INSERT INTO `t_s_town` VALUES ('5097', '巴拉贡镇', '150625101000', '150625000000');
INSERT INTO `t_s_town` VALUES ('5098', '吉日嘎朗图镇', '150625102000', '150625000000');
INSERT INTO `t_s_town` VALUES ('5099', '独贵特拉镇', '150625103000', '150625000000');
INSERT INTO `t_s_town` VALUES ('5100', '呼和木独镇', '150625104000', '150625000000');
INSERT INTO `t_s_town` VALUES ('5101', '伊和乌素苏木乡', '150625200000', '150625000000');
INSERT INTO `t_s_town` VALUES ('5102', '杭锦旗独贵塔拉工业园区管理委员会', '150625400000', '150625000000');
INSERT INTO `t_s_town` VALUES ('5103', '鄂尔多斯新能源产业示范区', '150625401000', '150625000000');
INSERT INTO `t_s_town` VALUES ('5104', '嘎鲁图镇', '150626100000', '150626000000');
INSERT INTO `t_s_town` VALUES ('5105', '乌审召镇', '150626101000', '150626000000');
INSERT INTO `t_s_town` VALUES ('5106', '图克镇', '150626102000', '150626000000');
INSERT INTO `t_s_town` VALUES ('5107', '乌兰陶勒盖镇', '150626103000', '150626000000');
INSERT INTO `t_s_town` VALUES ('5108', '无定河镇', '150626104000', '150626000000');
INSERT INTO `t_s_town` VALUES ('5109', '苏力德苏木乡', '150626200000', '150626000000');
INSERT INTO `t_s_town` VALUES ('5110', '阿勒腾席热镇', '150627100000', '150627000000');
INSERT INTO `t_s_town` VALUES ('5111', '札萨克镇', '150627101000', '150627000000');
INSERT INTO `t_s_town` VALUES ('5112', '乌兰木伦镇', '150627102000', '150627000000');
INSERT INTO `t_s_town` VALUES ('5113', '纳林陶亥镇', '150627103000', '150627000000');
INSERT INTO `t_s_town` VALUES ('5114', '苏布尔嘎镇', '150627104000', '150627000000');
INSERT INTO `t_s_town` VALUES ('5115', '红庆河镇', '150627105000', '150627000000');
INSERT INTO `t_s_town` VALUES ('5116', '伊金霍洛镇', '150627106000', '150627000000');
INSERT INTO `t_s_town` VALUES ('5117', '鄂尔多斯江苏工业园区', '150627400000', '150627000000');
INSERT INTO `t_s_town` VALUES ('5118', '鄂尔多斯圣圆煤化工基地', '150627403000', '150627000000');
INSERT INTO `t_s_town` VALUES ('5119', '鄂尔多斯蒙古源流文化产业园区', '150627405000', '150627000000');
INSERT INTO `t_s_town` VALUES ('5120', '伊金霍洛旗札萨克物流园区', '150627406000', '150627000000');
INSERT INTO `t_s_town` VALUES ('5121', '鄂尔多斯空港物流园区', '150627407000', '150627000000');
INSERT INTO `t_s_town` VALUES ('5122', '正阳办事处', '150702001000', '150702000000');
INSERT INTO `t_s_town` VALUES ('5123', '健康街道办事处', '150702002000', '150702000000');
INSERT INTO `t_s_town` VALUES ('5124', '靠山街道办事处', '150702003000', '150702000000');
INSERT INTO `t_s_town` VALUES ('5125', '胜利街道办事处', '150702004000', '150702000000');
INSERT INTO `t_s_town` VALUES ('5126', '呼伦街道办事处', '150702005000', '150702000000');
INSERT INTO `t_s_town` VALUES ('5127', '建设街道办事处', '150702007000', '150702000000');
INSERT INTO `t_s_town` VALUES ('5128', '东山街道办事处', '150702008000', '150702000000');
INSERT INTO `t_s_town` VALUES ('5129', '哈克镇', '150702100000', '150702000000');
INSERT INTO `t_s_town` VALUES ('5130', '奋斗镇', '150702101000', '150702000000');
INSERT INTO `t_s_town` VALUES ('5131', '第三街道办事处', '150703001000', '150703000000');
INSERT INTO `t_s_town` VALUES ('5132', '第一街道办事处', '150703002000', '150703000000');
INSERT INTO `t_s_town` VALUES ('5133', '第二街道办事处', '150703003000', '150703000000');
INSERT INTO `t_s_town` VALUES ('5134', '第四街道办事处', '150703004000', '150703000000');
INSERT INTO `t_s_town` VALUES ('5135', '第五街道办事处', '150703005000', '150703000000');
INSERT INTO `t_s_town` VALUES ('5136', '灵泉镇', '150703100000', '150703000000');
INSERT INTO `t_s_town` VALUES ('5137', '那吉镇', '150721100000', '150721000000');
INSERT INTO `t_s_town` VALUES ('5138', '六合镇', '150721101000', '150721000000');
INSERT INTO `t_s_town` VALUES ('5139', '亚东镇', '150721102000', '150721000000');
INSERT INTO `t_s_town` VALUES ('5140', '霍尔奇镇', '150721103000', '150721000000');
INSERT INTO `t_s_town` VALUES ('5141', '向阳峪镇', '150721104000', '150721000000');
INSERT INTO `t_s_town` VALUES ('5142', '三岔河镇', '150721105000', '150721000000');
INSERT INTO `t_s_town` VALUES ('5143', '复兴镇', '150721106000', '150721000000');
INSERT INTO `t_s_town` VALUES ('5144', '兴安镇', '150721107000', '150721000000');
INSERT INTO `t_s_town` VALUES ('5145', '得力其尔鄂温克民族乡', '150721200000', '150721000000');
INSERT INTO `t_s_town` VALUES ('5146', '查巴奇鄂温克民族乡', '150721201000', '150721000000');
INSERT INTO `t_s_town` VALUES ('5147', '音河达斡尔鄂温克民族乡', '150721202000', '150721000000');
INSERT INTO `t_s_town` VALUES ('5148', '新发朝鲜民族乡', '150721203000', '150721000000');
INSERT INTO `t_s_town` VALUES ('5149', '那吉屯农场', '150721400000', '150721000000');
INSERT INTO `t_s_town` VALUES ('5150', '格尼河农场', '150721401000', '150721000000');
INSERT INTO `t_s_town` VALUES ('5151', '阿荣旗林业局', '150721402000', '150721000000');
INSERT INTO `t_s_town` VALUES ('5152', '尼尔基镇', '150722100000', '150722000000');
INSERT INTO `t_s_town` VALUES ('5153', '红彦镇', '150722101000', '150722000000');
INSERT INTO `t_s_town` VALUES ('5154', '宝山镇', '150722102000', '150722000000');
INSERT INTO `t_s_town` VALUES ('5155', '哈达阳镇', '150722103000', '150722000000');
INSERT INTO `t_s_town` VALUES ('5156', '阿尔拉镇', '150722104000', '150722000000');
INSERT INTO `t_s_town` VALUES ('5157', '汉古尔河镇', '150722105000', '150722000000');
INSERT INTO `t_s_town` VALUES ('5158', '西瓦尔图镇', '150722106000', '150722000000');
INSERT INTO `t_s_town` VALUES ('5159', '腾克镇', '150722108000', '150722000000');
INSERT INTO `t_s_town` VALUES ('5160', '奎勒河镇', '150722109000', '150722000000');
INSERT INTO `t_s_town` VALUES ('5161', '塔温敖宝镇', '150722110000', '150722000000');
INSERT INTO `t_s_town` VALUES ('5162', '登特科镇', '150722111000', '150722000000');
INSERT INTO `t_s_town` VALUES ('5163', '巴彦鄂温克民族乡', '150722200000', '150722000000');
INSERT INTO `t_s_town` VALUES ('5164', '库如奇乡', '150722201000', '150722000000');
INSERT INTO `t_s_town` VALUES ('5165', '额尔和乡', '150722202000', '150722000000');
INSERT INTO `t_s_town` VALUES ('5166', '杜拉尔鄂温克民族乡', '150722203000', '150722000000');
INSERT INTO `t_s_town` VALUES ('5167', '国营甘河农场', '150722400000', '150722000000');
INSERT INTO `t_s_town` VALUES ('5168', '国营巴彦农场', '150722401000', '150722000000');
INSERT INTO `t_s_town` VALUES ('5169', '国营欧肯河农场', '150722402000', '150722000000');
INSERT INTO `t_s_town` VALUES ('5170', '国营东方红农场', '150722403000', '150722000000');
INSERT INTO `t_s_town` VALUES ('5171', '阿里河镇', '150723100000', '150723000000');
INSERT INTO `t_s_town` VALUES ('5172', '大杨树镇', '150723101000', '150723000000');
INSERT INTO `t_s_town` VALUES ('5173', '甘河镇', '150723102000', '150723000000');
INSERT INTO `t_s_town` VALUES ('5174', '吉文镇', '150723103000', '150723000000');
INSERT INTO `t_s_town` VALUES ('5175', '诺敏镇', '150723104000', '150723000000');
INSERT INTO `t_s_town` VALUES ('5176', '乌鲁布铁镇', '150723105000', '150723000000');
INSERT INTO `t_s_town` VALUES ('5177', '宜里镇', '150723106000', '150723000000');
INSERT INTO `t_s_town` VALUES ('5178', '克一河镇', '150723107000', '150723000000');
INSERT INTO `t_s_town` VALUES ('5179', '古里乡', '150723200000', '150723000000');
INSERT INTO `t_s_town` VALUES ('5180', '托扎敏乡', '150723201000', '150723000000');
INSERT INTO `t_s_town` VALUES ('5181', '大兴安岭管理局诺敏河农场', '150723400000', '150723000000');
INSERT INTO `t_s_town` VALUES ('5182', '大兴安岭农场宜里农场', '150723401000', '150723000000');
INSERT INTO `t_s_town` VALUES ('5183', '大兴安岭农场管理局扎兰河农场', '150723402000', '150723000000');
INSERT INTO `t_s_town` VALUES ('5184', '大兴安岭农场管理局古里农场', '150723403000', '150723000000');
INSERT INTO `t_s_town` VALUES ('5185', '加格达奇区', '150723404000', '150723000000');
INSERT INTO `t_s_town` VALUES ('5186', '松岭地区', '150723405000', '150723000000');
INSERT INTO `t_s_town` VALUES ('5187', '大杨树林业局', '150723406000', '150723000000');
INSERT INTO `t_s_town` VALUES ('5188', '甘河林业局', '150723407000', '150723000000');
INSERT INTO `t_s_town` VALUES ('5189', '克一河林业局', '150723408000', '150723000000');
INSERT INTO `t_s_town` VALUES ('5190', '吉文林业局', '150723409000', '150723000000');
INSERT INTO `t_s_town` VALUES ('5191', '阿里河林业局', '150723410000', '150723000000');
INSERT INTO `t_s_town` VALUES ('5192', '大兴安岭农工商联合公司', '150723411000', '150723000000');
INSERT INTO `t_s_town` VALUES ('5193', '大兴安岭农场管理局东方红农场', '150723412000', '150723000000');
INSERT INTO `t_s_town` VALUES ('5194', '大兴安岭农场管理局欧肯河农场', '150723413000', '150723000000');
INSERT INTO `t_s_town` VALUES ('5195', '大兴安岭林管局毕拉河林业局', '150723414000', '150723000000');
INSERT INTO `t_s_town` VALUES ('5196', '大兴安岭林管局伊图里河林业局', '150723415000', '150723000000');
INSERT INTO `t_s_town` VALUES ('5197', '大兴安岭林管局库都尔林业局', '150723416000', '150723000000');
INSERT INTO `t_s_town` VALUES ('5198', '大兴安岭林管局乌尔其汗林业局', '150723417000', '150723000000');
INSERT INTO `t_s_town` VALUES ('5199', '巴彦托海镇', '150724100000', '150724000000');
INSERT INTO `t_s_town` VALUES ('5200', '大雁镇', '150724110000', '150724000000');
INSERT INTO `t_s_town` VALUES ('5201', '伊敏河镇', '150724111000', '150724000000');
INSERT INTO `t_s_town` VALUES ('5202', '红花尔基镇', '150724112000', '150724000000');
INSERT INTO `t_s_town` VALUES ('5203', '巴彦查岗苏木', '150724210000', '150724000000');
INSERT INTO `t_s_town` VALUES ('5204', '锡尼河西苏木', '150724211000', '150724000000');
INSERT INTO `t_s_town` VALUES ('5205', '锡尼河东苏木', '150724212000', '150724000000');
INSERT INTO `t_s_town` VALUES ('5206', '巴彦塔拉达斡尔民族乡', '150724213000', '150724000000');
INSERT INTO `t_s_town` VALUES ('5207', '伊敏苏木', '150724214000', '150724000000');
INSERT INTO `t_s_town` VALUES ('5208', '辉苏木', '150724215000', '150724000000');
INSERT INTO `t_s_town` VALUES ('5209', '巴彦托海经济开发区', '150724400000', '150724000000');
INSERT INTO `t_s_town` VALUES ('5210', '伊敏河高载能工业园区', '150724401000', '150724000000');
INSERT INTO `t_s_town` VALUES ('5211', '大雁马铃薯高新技术示范园区', '150724402000', '150724000000');
INSERT INTO `t_s_town` VALUES ('5212', '呼伦贝尔新城区', '150724403000', '150724000000');
INSERT INTO `t_s_town` VALUES ('5213', '陈旗巴彦库仁镇', '150725100000', '150725000000');
INSERT INTO `t_s_town` VALUES ('5214', '陈旗宝日希勒镇', '150725101000', '150725000000');
INSERT INTO `t_s_town` VALUES ('5215', '陈旗呼和诺尔镇', '150725102000', '150725000000');
INSERT INTO `t_s_town` VALUES ('5216', '陈旗西乌珠尔苏木', '150725200000', '150725000000');
INSERT INTO `t_s_town` VALUES ('5217', '陈旗鄂温克民族苏木', '150725201000', '150725000000');
INSERT INTO `t_s_town` VALUES ('5218', '陈旗东乌珠尔苏木', '150725202000', '150725000000');
INSERT INTO `t_s_town` VALUES ('5219', '陈旗巴彦哈达苏木', '150725203000', '150725000000');
INSERT INTO `t_s_town` VALUES ('5220', '陈巴尔虎旗国营哈图达牧场', '150725501000', '150725000000');
INSERT INTO `t_s_town` VALUES ('5221', '陈旗国营浩特陶海农牧场', '150725502000', '150725000000');
INSERT INTO `t_s_town` VALUES ('5222', '陈旗国营特泥河牧场', '150725503000', '150725000000');
INSERT INTO `t_s_town` VALUES ('5223', '嵯岗镇', '150726101000', '150726000000');
INSERT INTO `t_s_town` VALUES ('5224', '阿木古郎镇', '150726102000', '150726000000');
INSERT INTO `t_s_town` VALUES ('5225', '新宝力格苏木', '150726202000', '150726000000');
INSERT INTO `t_s_town` VALUES ('5226', '乌布尔宝力格苏木', '150726203000', '150726000000');
INSERT INTO `t_s_town` VALUES ('5227', '罕达盖苏木', '150726204000', '150726000000');
INSERT INTO `t_s_town` VALUES ('5228', '吉布胡郎图苏木', '150726205000', '150726000000');
INSERT INTO `t_s_town` VALUES ('5229', '甘珠尔苏木', '150726206000', '150726000000');
INSERT INTO `t_s_town` VALUES ('5230', '嵯岗双娃牧场', '150726400000', '150726000000');
INSERT INTO `t_s_town` VALUES ('5231', '阿拉坦额莫勒镇', '150727100000', '150727000000');
INSERT INTO `t_s_town` VALUES ('5232', '阿日哈沙特镇', '150727101000', '150727000000');
INSERT INTO `t_s_town` VALUES ('5233', '呼伦镇', '150727102000', '150727000000');
INSERT INTO `t_s_town` VALUES ('5234', '贝尔苏木', '150727200000', '150727000000');
INSERT INTO `t_s_town` VALUES ('5235', '克尔伦苏木', '150727201000', '150727000000');
INSERT INTO `t_s_town` VALUES ('5236', '达赉苏木', '150727202000', '150727000000');
INSERT INTO `t_s_town` VALUES ('5237', '宝格德乌拉苏木', '150727203000', '150727000000');
INSERT INTO `t_s_town` VALUES ('5238', '敖尔金牧场', '150727500000', '150727000000');
INSERT INTO `t_s_town` VALUES ('5239', '东山街道办事处', '150781001000', '150781000000');
INSERT INTO `t_s_town` VALUES ('5240', '道南街道办事处', '150781002000', '150781000000');
INSERT INTO `t_s_town` VALUES ('5241', '道北街道办事处', '150781003000', '150781000000');
INSERT INTO `t_s_town` VALUES ('5242', '兴华街道办事处', '150781004000', '150781000000');
INSERT INTO `t_s_town` VALUES ('5243', '敖尔金街道办事处', '150781012000', '150781000000');
INSERT INTO `t_s_town` VALUES ('5244', '新开河镇', '150781100000', '150781000000');
INSERT INTO `t_s_town` VALUES ('5245', '满洲里市互市贸易区', '150781400000', '150781000000');
INSERT INTO `t_s_town` VALUES ('5246', '满洲里市经济合作区', '150781401000', '150781000000');
INSERT INTO `t_s_town` VALUES ('5247', '满洲里市东湖区', '150781402000', '150781000000');
INSERT INTO `t_s_town` VALUES ('5248', '满洲里市扎煤公司', '150781403000', '150781000000');
INSERT INTO `t_s_town` VALUES ('5249', '扎赉诺尔矿区', '150781404000', '150781000000');
INSERT INTO `t_s_town` VALUES ('5250', '满洲里市工业园区', '150781405000', '150781000000');
INSERT INTO `t_s_town` VALUES ('5251', '满洲里国际物流产业园区', '150781406000', '150781000000');
INSERT INTO `t_s_town` VALUES ('5252', '胜利街道办事处', '150782001000', '150782000000');
INSERT INTO `t_s_town` VALUES ('5253', '红旗街道办事处', '150782002000', '150782000000');
INSERT INTO `t_s_town` VALUES ('5254', '新工街道办事处', '150782003000', '150782000000');
INSERT INTO `t_s_town` VALUES ('5255', '永兴街道办事处', '150782004000', '150782000000');
INSERT INTO `t_s_town` VALUES ('5256', '建设街道办事处', '150782005000', '150782000000');
INSERT INTO `t_s_town` VALUES ('5257', '暖泉街道办事处', '150782006000', '150782000000');
INSERT INTO `t_s_town` VALUES ('5258', '免渡河镇', '150782100000', '150782000000');
INSERT INTO `t_s_town` VALUES ('5259', '博克图镇', '150782101000', '150782000000');
INSERT INTO `t_s_town` VALUES ('5260', '绰河源镇', '150782102000', '150782000000');
INSERT INTO `t_s_town` VALUES ('5261', '乌尔其汉镇', '150782103000', '150782000000');
INSERT INTO `t_s_town` VALUES ('5262', '库都尔镇', '150782104000', '150782000000');
INSERT INTO `t_s_town` VALUES ('5263', '图里河镇', '150782105000', '150782000000');
INSERT INTO `t_s_town` VALUES ('5264', '乌奴耳镇', '150782106000', '150782000000');
INSERT INTO `t_s_town` VALUES ('5265', '塔尔气镇', '150782107000', '150782000000');
INSERT INTO `t_s_town` VALUES ('5266', '伊图里河镇', '150782108000', '150782000000');
INSERT INTO `t_s_town` VALUES ('5267', '牧原镇', '150782109000', '150782000000');
INSERT INTO `t_s_town` VALUES ('5268', '莫拐农场', '150782400000', '150782000000');
INSERT INTO `t_s_town` VALUES ('5269', '牙克石农场', '150782401000', '150782000000');
INSERT INTO `t_s_town` VALUES ('5270', '免渡河农场', '150782402000', '150782000000');
INSERT INTO `t_s_town` VALUES ('5271', '兴华街道办事处', '150783001000', '150783000000');
INSERT INTO `t_s_town` VALUES ('5272', '正阳街道办事处', '150783002000', '150783000000');
INSERT INTO `t_s_town` VALUES ('5273', '繁荣街道办事处', '150783003000', '150783000000');
INSERT INTO `t_s_town` VALUES ('5274', '向阳街道办事处', '150783004000', '150783000000');
INSERT INTO `t_s_town` VALUES ('5275', '高台子街道办事处', '150783005000', '150783000000');
INSERT INTO `t_s_town` VALUES ('5276', '铁东街道办事处', '150783006000', '150783000000');
INSERT INTO `t_s_town` VALUES ('5277', '河西街道办事处', '150783007000', '150783000000');
INSERT INTO `t_s_town` VALUES ('5278', '蘑菇气镇', '150783100000', '150783000000');
INSERT INTO `t_s_town` VALUES ('5279', '卧牛河镇', '150783102000', '150783000000');
INSERT INTO `t_s_town` VALUES ('5280', '成吉思汗镇', '150783103000', '150783000000');
INSERT INTO `t_s_town` VALUES ('5281', '大河湾镇', '150783104000', '150783000000');
INSERT INTO `t_s_town` VALUES ('5282', '浩饶山镇', '150783105000', '150783000000');
INSERT INTO `t_s_town` VALUES ('5283', '柴河镇', '150783106000', '150783000000');
INSERT INTO `t_s_town` VALUES ('5284', '中和镇', '150783107000', '150783000000');
INSERT INTO `t_s_town` VALUES ('5285', '哈多河镇', '150783108000', '150783000000');
INSERT INTO `t_s_town` VALUES ('5286', '达斡尔民族乡', '150783200000', '150783000000');
INSERT INTO `t_s_town` VALUES ('5287', '鄂伦春民族乡', '150783201000', '150783000000');
INSERT INTO `t_s_town` VALUES ('5288', '萨马街鄂温克民族乡', '150783202000', '150783000000');
INSERT INTO `t_s_town` VALUES ('5289', '洼堤乡', '150783203000', '150783000000');
INSERT INTO `t_s_town` VALUES ('5290', '大河湾农场', '150783400000', '150783000000');
INSERT INTO `t_s_town` VALUES ('5291', '绰尔河农场', '150783401000', '150783000000');
INSERT INTO `t_s_town` VALUES ('5292', '扎兰屯马场', '150783402000', '150783000000');
INSERT INTO `t_s_town` VALUES ('5293', '成吉思汗牧场', '150783403000', '150783000000');
INSERT INTO `t_s_town` VALUES ('5294', '公安部后勤供应处农场', '150783404000', '150783000000');
INSERT INTO `t_s_town` VALUES ('5295', '南木林业局', '150783405000', '150783000000');
INSERT INTO `t_s_town` VALUES ('5296', '柴河林业局', '150783406000', '150783000000');
INSERT INTO `t_s_town` VALUES ('5297', '扎兰屯市林业局', '150783407000', '150783000000');
INSERT INTO `t_s_town` VALUES ('5298', '市原种场', '150783408000', '150783000000');
INSERT INTO `t_s_town` VALUES ('5299', '拉布达林街道办事处', '150784001000', '150784000000');
INSERT INTO `t_s_town` VALUES ('5300', '上库力街道办事处', '150784002000', '150784000000');
INSERT INTO `t_s_town` VALUES ('5301', '黑山头镇', '150784101000', '150784000000');
INSERT INTO `t_s_town` VALUES ('5302', '莫尔道嘎镇', '150784103000', '150784000000');
INSERT INTO `t_s_town` VALUES ('5303', '恩和哈达镇', '150784104000', '150784000000');
INSERT INTO `t_s_town` VALUES ('5304', '三河回族乡', '150784200000', '150784000000');
INSERT INTO `t_s_town` VALUES ('5305', '恩和俄罗斯族民族乡', '150784210000', '150784000000');
INSERT INTO `t_s_town` VALUES ('5306', '蒙兀室韦苏木', '150784211000', '150784000000');
INSERT INTO `t_s_town` VALUES ('5307', '奇乾乡', '150784212000', '150784000000');
INSERT INTO `t_s_town` VALUES ('5308', '海拉尔农垦集团有限公司拉布大林农场分公司', '150784400000', '150784000000');
INSERT INTO `t_s_town` VALUES ('5309', '三河金騋农牧有限责任公司', '150784401000', '150784000000');
INSERT INTO `t_s_town` VALUES ('5310', '海拉尔农垦集团有限责任公司上库力农场分公司', '150784402000', '150784000000');
INSERT INTO `t_s_town` VALUES ('5311', '海拉尔农垦集团有限责任公司苏沁牧场分公司', '150784403000', '150784000000');
INSERT INTO `t_s_town` VALUES ('5312', '河东街道办事处', '150785001000', '150785000000');
INSERT INTO `t_s_town` VALUES ('5313', '河西街道办事处', '150785002000', '150785000000');
INSERT INTO `t_s_town` VALUES ('5314', '森工街道办事处', '150785003000', '150785000000');
INSERT INTO `t_s_town` VALUES ('5315', '好里堡街道办事处', '150785004000', '150785000000');
INSERT INTO `t_s_town` VALUES ('5316', '金河镇', '150785101000', '150785000000');
INSERT INTO `t_s_town` VALUES ('5317', '阿龙山镇', '150785102000', '150785000000');
INSERT INTO `t_s_town` VALUES ('5318', '满归镇', '150785103000', '150785000000');
INSERT INTO `t_s_town` VALUES ('5319', '得耳布尔镇', '150785104000', '150785000000');
INSERT INTO `t_s_town` VALUES ('5320', '敖鲁古雅乡', '150785200000', '150785000000');
INSERT INTO `t_s_town` VALUES ('5321', '团结办事处', '150802001000', '150802000000');
INSERT INTO `t_s_town` VALUES ('5322', '车站办事处', '150802002000', '150802000000');
INSERT INTO `t_s_town` VALUES ('5323', '先锋办事处', '150802003000', '150802000000');
INSERT INTO `t_s_town` VALUES ('5324', '解放办事处', '150802004000', '150802000000');
INSERT INTO `t_s_town` VALUES ('5325', '新华办事处', '150802005000', '150802000000');
INSERT INTO `t_s_town` VALUES ('5326', '东环路办事处', '150802006000', '150802000000');
INSERT INTO `t_s_town` VALUES ('5327', '铁南办事处', '150802007000', '150802000000');
INSERT INTO `t_s_town` VALUES ('5328', '西环路办事处', '150802008000', '150802000000');
INSERT INTO `t_s_town` VALUES ('5329', '北环路办事处', '150802009000', '150802000000');
INSERT INTO `t_s_town` VALUES ('5330', '金川办事处', '150802013000', '150802000000');
INSERT INTO `t_s_town` VALUES ('5331', '汇丰办事处', '150802014000', '150802000000');
INSERT INTO `t_s_town` VALUES ('5332', '狼山镇', '150802100000', '150802000000');
INSERT INTO `t_s_town` VALUES ('5333', '新华镇', '150802101000', '150802000000');
INSERT INTO `t_s_town` VALUES ('5334', '干召庙镇', '150802102000', '150802000000');
INSERT INTO `t_s_town` VALUES ('5335', '乌兰图克镇', '150802103000', '150802000000');
INSERT INTO `t_s_town` VALUES ('5336', '双河镇', '150802104000', '150802000000');
INSERT INTO `t_s_town` VALUES ('5337', '城关镇', '150802105000', '150802000000');
INSERT INTO `t_s_town` VALUES ('5338', '白脑包镇', '150802106000', '150802000000');
INSERT INTO `t_s_town` VALUES ('5339', '曙光乡', '150802200000', '150802000000');
INSERT INTO `t_s_town` VALUES ('5340', '八一乡', '150802201000', '150802000000');
INSERT INTO `t_s_town` VALUES ('5341', '狼山农场', '150802400000', '150802000000');
INSERT INTO `t_s_town` VALUES ('5342', '临河农场', '150802401000', '150802000000');
INSERT INTO `t_s_town` VALUES ('5343', '隆兴昌镇', '150821100000', '150821000000');
INSERT INTO `t_s_town` VALUES ('5344', '塔尔湖镇', '150821101000', '150821000000');
INSERT INTO `t_s_town` VALUES ('5345', '套海镇', '150821102000', '150821000000');
INSERT INTO `t_s_town` VALUES ('5346', '新公中镇', '150821103000', '150821000000');
INSERT INTO `t_s_town` VALUES ('5347', '天吉太镇', '150821104000', '150821000000');
INSERT INTO `t_s_town` VALUES ('5348', '胜丰镇', '150821105000', '150821000000');
INSERT INTO `t_s_town` VALUES ('5349', '银定图镇', '150821106000', '150821000000');
INSERT INTO `t_s_town` VALUES ('5350', '复兴镇', '150821107000', '150821000000');
INSERT INTO `t_s_town` VALUES ('5351', '和胜乡', '150821200000', '150821000000');
INSERT INTO `t_s_town` VALUES ('5352', '巴彦淖尔市建丰农场', '150821400000', '150821000000');
INSERT INTO `t_s_town` VALUES ('5353', '内蒙古东土城劳动教养管理所', '150821401000', '150821000000');
INSERT INTO `t_s_town` VALUES ('5354', '巴彦高勒镇', '150822100000', '150822000000');
INSERT INTO `t_s_town` VALUES ('5355', '隆盛合镇', '150822101000', '150822000000');
INSERT INTO `t_s_town` VALUES ('5356', '渡口镇', '150822102000', '150822000000');
INSERT INTO `t_s_town` VALUES ('5357', '补隆淖镇', '150822103000', '150822000000');
INSERT INTO `t_s_town` VALUES ('5358', '沙金套海苏木', '150822200000', '150822000000');
INSERT INTO `t_s_town` VALUES ('5359', '乌兰布和农场', '150822400000', '150822000000');
INSERT INTO `t_s_town` VALUES ('5360', '巴彦套海农场', '150822401000', '150822000000');
INSERT INTO `t_s_town` VALUES ('5361', '哈腾套海农场', '150822402000', '150822000000');
INSERT INTO `t_s_town` VALUES ('5362', '包尔盖农场', '150822403000', '150822000000');
INSERT INTO `t_s_town` VALUES ('5363', '纳林套海农场', '150822404000', '150822000000');
INSERT INTO `t_s_town` VALUES ('5364', '沙漠林业实验中心农场', '150822405000', '150822000000');
INSERT INTO `t_s_town` VALUES ('5365', '乌拉山镇', '150823100000', '150823000000');
INSERT INTO `t_s_town` VALUES ('5366', '白彦花镇', '150823101000', '150823000000');
INSERT INTO `t_s_town` VALUES ('5367', '先锋镇', '150823102000', '150823000000');
INSERT INTO `t_s_town` VALUES ('5368', '新安镇', '150823103000', '150823000000');
INSERT INTO `t_s_town` VALUES ('5369', '西小召镇', '150823104000', '150823000000');
INSERT INTO `t_s_town` VALUES ('5370', '大佘太镇', '150823105000', '150823000000');
INSERT INTO `t_s_town` VALUES ('5371', '明安镇', '150823106000', '150823000000');
INSERT INTO `t_s_town` VALUES ('5372', '小佘太镇', '150823107000', '150823000000');
INSERT INTO `t_s_town` VALUES ('5373', '苏独仑镇', '150823108000', '150823000000');
INSERT INTO `t_s_town` VALUES ('5374', '额尔登布拉格苏木', '150823200000', '150823000000');
INSERT INTO `t_s_town` VALUES ('5375', '沙德格苏木', '150823201000', '150823000000');
INSERT INTO `t_s_town` VALUES ('5376', '巴彦淖尔市中滩农场', '150823400000', '150823000000');
INSERT INTO `t_s_town` VALUES ('5377', '巴彦淖尔市西山咀农场', '150823401000', '150823000000');
INSERT INTO `t_s_town` VALUES ('5378', '巴彦淖尔市新安农场', '150823402000', '150823000000');
INSERT INTO `t_s_town` VALUES ('5379', '巴彦淖尔市苏独仑农场', '150823403000', '150823000000');
INSERT INTO `t_s_town` VALUES ('5380', '巴彦淖尔市大佘太牧场', '150823404000', '150823000000');
INSERT INTO `t_s_town` VALUES ('5381', '巴彦淖尔市乌梁素海渔场', '150823405000', '150823000000');
INSERT INTO `t_s_town` VALUES ('5382', '海流图镇', '150824100000', '150824000000');
INSERT INTO `t_s_town` VALUES ('5383', '乌加河镇', '150824101000', '150824000000');
INSERT INTO `t_s_town` VALUES ('5384', '德岭山镇', '150824102000', '150824000000');
INSERT INTO `t_s_town` VALUES ('5385', '石哈河镇', '150824103000', '150824000000');
INSERT INTO `t_s_town` VALUES ('5386', '甘其毛都镇', '150824104000', '150824000000');
INSERT INTO `t_s_town` VALUES ('5387', '温更镇', '150824105000', '150824000000');
INSERT INTO `t_s_town` VALUES ('5388', '呼鲁斯太苏木', '150824200000', '150824000000');
INSERT INTO `t_s_town` VALUES ('5389', '川井苏木', '150824201000', '150824000000');
INSERT INTO `t_s_town` VALUES ('5390', '巴音乌兰苏木', '150824202000', '150824000000');
INSERT INTO `t_s_town` VALUES ('5391', '新忽热苏木', '150824203000', '150824000000');
INSERT INTO `t_s_town` VALUES ('5392', '牧羊海牧场', '150824400000', '150824000000');
INSERT INTO `t_s_town` VALUES ('5393', '同和太种畜场', '150824401000', '150824000000');
INSERT INTO `t_s_town` VALUES ('5394', '巴音宝力格镇', '150825100000', '150825000000');
INSERT INTO `t_s_town` VALUES ('5395', '呼和温都尔镇', '150825101000', '150825000000');
INSERT INTO `t_s_town` VALUES ('5396', '潮格温都尔镇', '150825102000', '150825000000');
INSERT INTO `t_s_town` VALUES ('5397', '获各琦苏木', '150825200000', '150825000000');
INSERT INTO `t_s_town` VALUES ('5398', '巴音前达门苏木', '150825201000', '150825000000');
INSERT INTO `t_s_town` VALUES ('5399', '乌盖苏木', '150825202000', '150825000000');
INSERT INTO `t_s_town` VALUES ('5400', '陕坝镇', '150826100000', '150826000000');
INSERT INTO `t_s_town` VALUES ('5401', '头道桥镇', '150826101000', '150826000000');
INSERT INTO `t_s_town` VALUES ('5402', '二道桥镇', '150826102000', '150826000000');
INSERT INTO `t_s_town` VALUES ('5403', '三道桥镇', '150826103000', '150826000000');
INSERT INTO `t_s_town` VALUES ('5404', '蛮会镇', '150826104000', '150826000000');
INSERT INTO `t_s_town` VALUES ('5405', '团结镇', '150826105000', '150826000000');
INSERT INTO `t_s_town` VALUES ('5406', '双庙镇', '150826106000', '150826000000');
INSERT INTO `t_s_town` VALUES ('5407', '沙海镇', '150826107000', '150826000000');
INSERT INTO `t_s_town` VALUES ('5408', '蒙海镇', '150826108000', '150826000000');
INSERT INTO `t_s_town` VALUES ('5409', '太阳庙农场', '150826500000', '150826000000');
INSERT INTO `t_s_town` VALUES ('5410', '新体路街道办事处', '150902001000', '150902000000');
INSERT INTO `t_s_town` VALUES ('5411', '桥东街道办事处', '150902002000', '150902000000');
INSERT INTO `t_s_town` VALUES ('5412', '前进路街道办事处', '150902003000', '150902000000');
INSERT INTO `t_s_town` VALUES ('5413', '常青街道办事处', '150902004000', '150902000000');
INSERT INTO `t_s_town` VALUES ('5414', '虎山街道办事处', '150902005000', '150902000000');
INSERT INTO `t_s_town` VALUES ('5415', '桥西街道办事处', '150902006000', '150902000000');
INSERT INTO `t_s_town` VALUES ('5416', '新华街街道办事处', '150902007000', '150902000000');
INSERT INTO `t_s_town` VALUES ('5417', '泉山街道办事处', '150902008000', '150902000000');
INSERT INTO `t_s_town` VALUES ('5418', '卧龙街道办事处', '150902009000', '150902000000');
INSERT INTO `t_s_town` VALUES ('5419', '霸王河街道办事处', '150902010000', '150902000000');
INSERT INTO `t_s_town` VALUES ('5420', '白海子镇', '150902105000', '150902000000');
INSERT INTO `t_s_town` VALUES ('5421', '马莲渠乡', '150902205000', '150902000000');
INSERT INTO `t_s_town` VALUES ('5422', '卓资山镇', '150921106000', '150921000000');
INSERT INTO `t_s_town` VALUES ('5423', '旗下营镇', '150921107000', '150921000000');
INSERT INTO `t_s_town` VALUES ('5424', '卓资县十八台镇', '150921108000', '150921000000');
INSERT INTO `t_s_town` VALUES ('5425', '卓资县巴音锡勒镇', '150921109000', '150921000000');
INSERT INTO `t_s_town` VALUES ('5426', '卓资县梨花镇', '150921110000', '150921000000');
INSERT INTO `t_s_town` VALUES ('5427', '卓资县大榆树乡', '150921210000', '150921000000');
INSERT INTO `t_s_town` VALUES ('5428', '卓资县红召乡', '150921211000', '150921000000');
INSERT INTO `t_s_town` VALUES ('5429', '卓资县复兴乡', '150921212000', '150921000000');
INSERT INTO `t_s_town` VALUES ('5430', '化德县长顺镇', '150922103000', '150922000000');
INSERT INTO `t_s_town` VALUES ('5431', '化德县朝阳镇', '150922104000', '150922000000');
INSERT INTO `t_s_town` VALUES ('5432', '化德县七号镇', '150922105000', '150922000000');
INSERT INTO `t_s_town` VALUES ('5433', '化德县德包图乡', '150922200000', '150922000000');
INSERT INTO `t_s_town` VALUES ('5434', '化德县公腊胡洞乡', '150922201000', '150922000000');
INSERT INTO `t_s_town` VALUES ('5435', '化德县白音特拉乡', '150922218000', '150922000000');
INSERT INTO `t_s_town` VALUES ('5436', '七台镇', '150923101000', '150923000000');
INSERT INTO `t_s_town` VALUES ('5437', '十八顷镇', '150923102000', '150923000000');
INSERT INTO `t_s_town` VALUES ('5438', '大黑沙土镇', '150923103000', '150923000000');
INSERT INTO `t_s_town` VALUES ('5439', '西井子镇', '150923104000', '150923000000');
INSERT INTO `t_s_town` VALUES ('5440', '屯垦队镇', '150923105000', '150923000000');
INSERT INTO `t_s_town` VALUES ('5441', '小海子镇', '150923106000', '150923000000');
INSERT INTO `t_s_town` VALUES ('5442', '大库伦乡', '150923200000', '150923000000');
INSERT INTO `t_s_town` VALUES ('5443', '卯都乡', '150923201000', '150923000000');
INSERT INTO `t_s_town` VALUES ('5444', '玻璃忽镜乡', '150923202000', '150923000000');
INSERT INTO `t_s_town` VALUES ('5445', '三大顷乡', '150923203000', '150923000000');
INSERT INTO `t_s_town` VALUES ('5446', '城关镇', '150924106000', '150924000000');
INSERT INTO `t_s_town` VALUES ('5447', '张皋镇', '150924107000', '150924000000');
INSERT INTO `t_s_town` VALUES ('5448', '赛乌素镇', '150924108000', '150924000000');
INSERT INTO `t_s_town` VALUES ('5449', '鄂尔栋镇', '150924109000', '150924000000');
INSERT INTO `t_s_town` VALUES ('5450', '店子镇', '150924110000', '150924000000');
INSERT INTO `t_s_town` VALUES ('5451', '大库联乡', '150924209000', '150924000000');
INSERT INTO `t_s_town` VALUES ('5452', '民族团结乡', '150924210000', '150924000000');
INSERT INTO `t_s_town` VALUES ('5453', '大同夭乡', '150924211000', '150924000000');
INSERT INTO `t_s_town` VALUES ('5454', '五股泉乡', '150924212000', '150924000000');
INSERT INTO `t_s_town` VALUES ('5455', '南部矿区管委会', '150924400000', '150924000000');
INSERT INTO `t_s_town` VALUES ('5456', '鸿茅镇', '150925103000', '150925000000');
INSERT INTO `t_s_town` VALUES ('5457', '六苏木镇', '150925104000', '150925000000');
INSERT INTO `t_s_town` VALUES ('5458', '麦胡图镇', '150925105000', '150925000000');
INSERT INTO `t_s_town` VALUES ('5459', '永兴镇', '150925106000', '150925000000');
INSERT INTO `t_s_town` VALUES ('5460', '蛮汉镇', '150925107000', '150925000000');
INSERT INTO `t_s_town` VALUES ('5461', '岱海镇', '150925108000', '150925000000');
INSERT INTO `t_s_town` VALUES ('5462', '天成乡', '150925218000', '150925000000');
INSERT INTO `t_s_town` VALUES ('5463', '曹碾满族乡', '150925220000', '150925000000');
INSERT INTO `t_s_town` VALUES ('5464', '蛮汉山林场', '150925401000', '150925000000');
INSERT INTO `t_s_town` VALUES ('5465', '岱海林场', '150925402000', '150925000000');
INSERT INTO `t_s_town` VALUES ('5466', '土贵乌拉镇', '150926105000', '150926000000');
INSERT INTO `t_s_town` VALUES ('5467', '平地泉镇', '150926106000', '150926000000');
INSERT INTO `t_s_town` VALUES ('5468', '玫瑰营镇', '150926107000', '150926000000');
INSERT INTO `t_s_town` VALUES ('5469', '巴音塔拉镇', '150926108000', '150926000000');
INSERT INTO `t_s_town` VALUES ('5470', '黄旗海镇', '150926109000', '150926000000');
INSERT INTO `t_s_town` VALUES ('5471', '乌拉哈乌拉乡', '150926209000', '150926000000');
INSERT INTO `t_s_town` VALUES ('5472', '黄茂营乡', '150926210000', '150926000000');
INSERT INTO `t_s_town` VALUES ('5473', '三岔口乡', '150926211000', '150926000000');
INSERT INTO `t_s_town` VALUES ('5474', '老圈沟乡', '150926212000', '150926000000');
INSERT INTO `t_s_town` VALUES ('5475', '察右前旗天皮山冶金化工工业园区', '150926400000', '150926000000');
INSERT INTO `t_s_town` VALUES ('5476', '察右前旗察哈尔工业园区', '150926401000', '150926000000');
INSERT INTO `t_s_town` VALUES ('5477', '科布尔镇', '150927103000', '150927000000');
INSERT INTO `t_s_town` VALUES ('5478', '铁沙盖镇', '150927104000', '150927000000');
INSERT INTO `t_s_town` VALUES ('5479', '黄羊城镇', '150927105000', '150927000000');
INSERT INTO `t_s_town` VALUES ('5480', '广益隆镇', '150927106000', '150927000000');
INSERT INTO `t_s_town` VALUES ('5481', '乌素图镇', '150927107000', '150927000000');
INSERT INTO `t_s_town` VALUES ('5482', '大滩乡', '150927216000', '150927000000');
INSERT INTO `t_s_town` VALUES ('5483', '宏盘乡', '150927217000', '150927000000');
INSERT INTO `t_s_town` VALUES ('5484', '巴音乡', '150927218000', '150927000000');
INSERT INTO `t_s_town` VALUES ('5485', '库联苏木', '150927219000', '150927000000');
INSERT INTO `t_s_town` VALUES ('5486', '乌兰哈页苏木', '150927220000', '150927000000');
INSERT INTO `t_s_town` VALUES ('5487', '察右中旗土城子乡', '150927221000', '150927000000');
INSERT INTO `t_s_town` VALUES ('5488', '辉腾锡勒园区管理委员会', '150927400000', '150927000000');
INSERT INTO `t_s_town` VALUES ('5489', '白音察干镇', '150928105000', '150928000000');
INSERT INTO `t_s_town` VALUES ('5490', '察哈尔右翼后旗土牧尔台镇', '150928106000', '150928000000');
INSERT INTO `t_s_town` VALUES ('5491', '察哈尔右翼后旗红格尔图镇', '150928107000', '150928000000');
INSERT INTO `t_s_town` VALUES ('5492', '察哈尔右翼后旗贲红镇', '150928108000', '150928000000');
INSERT INTO `t_s_town` VALUES ('5493', '察哈尔右翼后旗大六号镇', '150928109000', '150928000000');
INSERT INTO `t_s_town` VALUES ('5494', '察哈尔右翼后旗当郎忽洞苏木', '150928209000', '150928000000');
INSERT INTO `t_s_town` VALUES ('5495', '察哈尔右翼后旗乌兰哈达苏木', '150928210000', '150928000000');
INSERT INTO `t_s_town` VALUES ('5496', '察哈尔右翼后旗锡勒乡', '150928211000', '150928000000');
INSERT INTO `t_s_town` VALUES ('5497', '四子王旗乌兰花镇', '150929100000', '150929000000');
INSERT INTO `t_s_town` VALUES ('5498', '四子王旗吉生太镇', '150929101000', '150929000000');
INSERT INTO `t_s_town` VALUES ('5499', '四子王旗库伦图镇', '150929102000', '150929000000');
INSERT INTO `t_s_town` VALUES ('5500', '四子王旗供济堂镇', '150929103000', '150929000000');
INSERT INTO `t_s_town` VALUES ('5501', '四子王旗白音朝克图镇', '150929104000', '150929000000');
INSERT INTO `t_s_town` VALUES ('5502', '四子王旗红格尔苏木', '150929200000', '150929000000');
INSERT INTO `t_s_town` VALUES ('5503', '四子王旗江岸苏木', '150929201000', '150929000000');
INSERT INTO `t_s_town` VALUES ('5504', '四子王旗查干补力格苏木', '150929202000', '150929000000');
INSERT INTO `t_s_town` VALUES ('5505', '四子王旗脑木更苏木', '150929203000', '150929000000');
INSERT INTO `t_s_town` VALUES ('5506', '四子王旗东八号乡', '150929204000', '150929000000');
INSERT INTO `t_s_town` VALUES ('5507', '四子王旗忽鸡图乡', '150929205000', '150929000000');
INSERT INTO `t_s_town` VALUES ('5508', '四子王旗大黑河乡', '150929206000', '150929000000');
INSERT INTO `t_s_town` VALUES ('5509', '四子王旗巴音敖包苏木', '150929207000', '150929000000');
INSERT INTO `t_s_town` VALUES ('5510', '四子王旗乌兰牧场', '150929400000', '150929000000');
INSERT INTO `t_s_town` VALUES ('5511', '新城区街道办事处', '150981005000', '150981000000');
INSERT INTO `t_s_town` VALUES ('5512', '旧城区街道办事处', '150981006000', '150981000000');
INSERT INTO `t_s_town` VALUES ('5513', '北城区街道办事处', '150981007000', '150981000000');
INSERT INTO `t_s_town` VALUES ('5514', '工业区街道办事处', '150981008000', '150981000000');
INSERT INTO `t_s_town` VALUES ('5515', '南城区街道办事处', '150981009000', '150981000000');
INSERT INTO `t_s_town` VALUES ('5516', '隆盛庄镇', '150981107000', '150981000000');
INSERT INTO `t_s_town` VALUES ('5517', '黑土台镇', '150981108000', '150981000000');
INSERT INTO `t_s_town` VALUES ('5518', '红砂坝镇', '150981109000', '150981000000');
INSERT INTO `t_s_town` VALUES ('5519', '巨宝庄镇', '150981110000', '150981000000');
INSERT INTO `t_s_town` VALUES ('5520', '三义泉镇', '150981111000', '150981000000');
INSERT INTO `t_s_town` VALUES ('5521', '浑源窑乡', '150981207000', '150981000000');
INSERT INTO `t_s_town` VALUES ('5522', '元山子乡', '150981208000', '150981000000');
INSERT INTO `t_s_town` VALUES ('5523', '官屯堡乡', '150981209000', '150981000000');
INSERT INTO `t_s_town` VALUES ('5524', '爱国办事处', '152201001000', '152201000000');
INSERT INTO `t_s_town` VALUES ('5525', '和平办事处', '152201002000', '152201000000');
INSERT INTO `t_s_town` VALUES ('5526', '兴安办事处', '152201003000', '152201000000');
INSERT INTO `t_s_town` VALUES ('5527', '胜利办事处', '152201004000', '152201000000');
INSERT INTO `t_s_town` VALUES ('5528', '铁西办事处', '152201005000', '152201000000');
INSERT INTO `t_s_town` VALUES ('5529', '都林办事处', '152201006000', '152201000000');
INSERT INTO `t_s_town` VALUES ('5530', '五一办事处', '152201007000', '152201000000');
INSERT INTO `t_s_town` VALUES ('5531', '城郊办事处', '152201008000', '152201000000');
INSERT INTO `t_s_town` VALUES ('5532', '新城办事处', '152201009000', '152201000000');
INSERT INTO `t_s_town` VALUES ('5533', '乌兰哈达镇', '152201100000', '152201000000');
INSERT INTO `t_s_town` VALUES ('5534', '葛根庙镇', '152201101000', '152201000000');
INSERT INTO `t_s_town` VALUES ('5535', '太本站镇', '152201102000', '152201000000');
INSERT INTO `t_s_town` VALUES ('5536', '义勒力特镇', '152201103000', '152201000000');
INSERT INTO `t_s_town` VALUES ('5537', '呼和马场', '152201401000', '152201000000');
INSERT INTO `t_s_town` VALUES ('5538', '乌兰浩特工业经济开发区', '152201402000', '152201000000');
INSERT INTO `t_s_town` VALUES ('5539', '乌兰浩特经济技术开发区', '152201403000', '152201000000');
INSERT INTO `t_s_town` VALUES ('5540', '阿尔山市林海街道', '152202001000', '152202000000');
INSERT INTO `t_s_town` VALUES ('5541', '阿尔山市新城街道', '152202002000', '152202000000');
INSERT INTO `t_s_town` VALUES ('5542', '阿尔山市温泉街道', '152202003000', '152202000000');
INSERT INTO `t_s_town` VALUES ('5543', '伊尔施街道办事处', '152202004000', '152202000000');
INSERT INTO `t_s_town` VALUES ('5544', '阿尔山市天池镇', '152202100000', '152202000000');
INSERT INTO `t_s_town` VALUES ('5545', '阿尔山市白狼镇', '152202101000', '152202000000');
INSERT INTO `t_s_town` VALUES ('5546', '阿尔山市五岔沟镇', '152202102000', '152202000000');
INSERT INTO `t_s_town` VALUES ('5547', '明水河镇', '152202103000', '152202000000');
INSERT INTO `t_s_town` VALUES ('5548', '科尔沁镇', '152221100000', '152221000000');
INSERT INTO `t_s_town` VALUES ('5549', '索伦镇', '152221101000', '152221000000');
INSERT INTO `t_s_town` VALUES ('5550', '德佰斯镇', '152221102000', '152221000000');
INSERT INTO `t_s_town` VALUES ('5551', '大石寨镇', '152221103000', '152221000000');
INSERT INTO `t_s_town` VALUES ('5552', '归流河镇', '152221104000', '152221000000');
INSERT INTO `t_s_town` VALUES ('5553', '居力很镇', '152221105000', '152221000000');
INSERT INTO `t_s_town` VALUES ('5554', '察尔森镇', '152221106000', '152221000000');
INSERT INTO `t_s_town` VALUES ('5555', '额尔格图镇', '152221107000', '152221000000');
INSERT INTO `t_s_town` VALUES ('5556', '俄体镇', '152221108000', '152221000000');
INSERT INTO `t_s_town` VALUES ('5557', '满族屯满族乡', '152221200000', '152221000000');
INSERT INTO `t_s_town` VALUES ('5558', '乌兰毛都苏木乡', '152221201000', '152221000000');
INSERT INTO `t_s_town` VALUES ('5559', '阿力得尔苏木乡', '152221202000', '152221000000');
INSERT INTO `t_s_town` VALUES ('5560', '巴日嘎斯台乡', '152221203000', '152221000000');
INSERT INTO `t_s_town` VALUES ('5561', '桃合木苏木', '152221204000', '152221000000');
INSERT INTO `t_s_town` VALUES ('5562', '跃进马场', '152221400000', '152221000000');
INSERT INTO `t_s_town` VALUES ('5563', '索伦牧场', '152221401000', '152221000000');
INSERT INTO `t_s_town` VALUES ('5564', '阿力得尔牧场', '152221403000', '152221000000');
INSERT INTO `t_s_town` VALUES ('5565', '公主陵牧场', '152221404000', '152221000000');
INSERT INTO `t_s_town` VALUES ('5566', '绿水种畜场', '152221405000', '152221000000');
INSERT INTO `t_s_town` VALUES ('5567', '科右前旗工业园区', '152221407000', '152221000000');
INSERT INTO `t_s_town` VALUES ('5568', '科右前旗现代农牧业园区', '152221408000', '152221000000');
INSERT INTO `t_s_town` VALUES ('5569', '巴彦呼舒镇', '152222100000', '152222000000');
INSERT INTO `t_s_town` VALUES ('5570', '巴仁哲里木镇', '152222101000', '152222000000');
INSERT INTO `t_s_town` VALUES ('5571', '吐列毛都镇', '152222102000', '152222000000');
INSERT INTO `t_s_town` VALUES ('5572', '杜尔基镇', '152222103000', '152222000000');
INSERT INTO `t_s_town` VALUES ('5573', '高力板镇', '152222104000', '152222000000');
INSERT INTO `t_s_town` VALUES ('5574', '好腰苏木镇', '152222105000', '152222000000');
INSERT INTO `t_s_town` VALUES ('5575', '代钦塔拉苏木', '152222200000', '152222000000');
INSERT INTO `t_s_town` VALUES ('5576', '新佳木苏木', '152222201000', '152222000000');
INSERT INTO `t_s_town` VALUES ('5577', '哈日诺尔苏木', '152222202000', '152222000000');
INSERT INTO `t_s_town` VALUES ('5578', '额木庭高勒苏木', '152222203000', '152222000000');
INSERT INTO `t_s_town` VALUES ('5579', '巴彦茫哈苏木', '152222204000', '152222000000');
INSERT INTO `t_s_town` VALUES ('5580', '巴彦淖尔苏木', '152222205000', '152222000000');
INSERT INTO `t_s_town` VALUES ('5581', '布敦化牧场', '152222400000', '152222000000');
INSERT INTO `t_s_town` VALUES ('5582', '吐列毛杜农场', '152222401000', '152222000000');
INSERT INTO `t_s_town` VALUES ('5583', '孟恩套力盖矿区工作部', '152222402000', '152222000000');
INSERT INTO `t_s_town` VALUES ('5584', '布敦化矿区工作部', '152222403000', '152222000000');
INSERT INTO `t_s_town` VALUES ('5585', '音德尔镇', '152223100000', '152223000000');
INSERT INTO `t_s_town` VALUES ('5586', '新林镇', '152223101000', '152223000000');
INSERT INTO `t_s_town` VALUES ('5587', '巴彦高勒镇', '152223102000', '152223000000');
INSERT INTO `t_s_town` VALUES ('5588', '胡尔勒镇', '152223103000', '152223000000');
INSERT INTO `t_s_town` VALUES ('5589', '阿尔本格勒镇', '152223104000', '152223000000');
INSERT INTO `t_s_town` VALUES ('5590', '巴达尔胡镇', '152223105000', '152223000000');
INSERT INTO `t_s_town` VALUES ('5591', '图牧吉镇', '152223106000', '152223000000');
INSERT INTO `t_s_town` VALUES ('5592', '好力保镇', '152223107000', '152223000000');
INSERT INTO `t_s_town` VALUES ('5593', '巴彦乌兰苏木', '152223201000', '152223000000');
INSERT INTO `t_s_town` VALUES ('5594', '宝力根花苏木', '152223202000', '152223000000');
INSERT INTO `t_s_town` VALUES ('5595', '阿拉达尔吐苏木', '152223203000', '152223000000');
INSERT INTO `t_s_town` VALUES ('5596', '巴彦扎拉嘎乡', '152223204000', '152223000000');
INSERT INTO `t_s_town` VALUES ('5597', '努文木仁乡', '152223205000', '152223000000');
INSERT INTO `t_s_town` VALUES ('5598', '内蒙古自治区图牧吉强制隔离戒毒所', '152223400000', '152223000000');
INSERT INTO `t_s_town` VALUES ('5599', '保安沼监狱', '152223401000', '152223000000');
INSERT INTO `t_s_town` VALUES ('5600', '乌兰监狱', '152223402000', '152223000000');
INSERT INTO `t_s_town` VALUES ('5601', '乌塔其监狱', '152223403000', '152223000000');
INSERT INTO `t_s_town` VALUES ('5602', '种畜场', '152223404000', '152223000000');
INSERT INTO `t_s_town` VALUES ('5603', '八一牧场', '152223405000', '152223000000');
INSERT INTO `t_s_town` VALUES ('5604', '巴达尔胡农场', '152223406000', '152223000000');
INSERT INTO `t_s_town` VALUES ('5605', '突泉镇', '152224100000', '152224000000');
INSERT INTO `t_s_town` VALUES ('5606', '六户镇', '152224101000', '152224000000');
INSERT INTO `t_s_town` VALUES ('5607', '东杜尔基镇', '152224102000', '152224000000');
INSERT INTO `t_s_town` VALUES ('5608', '永安镇', '152224103000', '152224000000');
INSERT INTO `t_s_town` VALUES ('5609', '水泉镇', '152224104000', '152224000000');
INSERT INTO `t_s_town` VALUES ('5610', '宝石镇', '152224105000', '152224000000');
INSERT INTO `t_s_town` VALUES ('5611', '学田乡', '152224200000', '152224000000');
INSERT INTO `t_s_town` VALUES ('5612', '九龙乡', '152224201000', '152224000000');
INSERT INTO `t_s_town` VALUES ('5613', '太平乡', '152224202000', '152224000000');
INSERT INTO `t_s_town` VALUES ('5614', '东杜尔基国营农场', '152224400000', '152224000000');
INSERT INTO `t_s_town` VALUES ('5615', '格日勒敖都苏木', '152501200000', '152501000000');
INSERT INTO `t_s_town` VALUES ('5616', '二连浩特市社区建设管理局', '152501400000', '152501000000');
INSERT INTO `t_s_town` VALUES ('5617', '二连边境经济技术合作区', '152501401000', '152501000000');
INSERT INTO `t_s_town` VALUES ('5618', '希日塔拉街道办事处', '152502001000', '152502000000');
INSERT INTO `t_s_town` VALUES ('5619', '宝力根街道办事处', '152502002000', '152502000000');
INSERT INTO `t_s_town` VALUES ('5620', '杭盖街道办事处', '152502003000', '152502000000');
INSERT INTO `t_s_town` VALUES ('5621', '楚古兰街道办事处', '152502004000', '152502000000');
INSERT INTO `t_s_town` VALUES ('5622', '额尔敦街道办事处', '152502005000', '152502000000');
INSERT INTO `t_s_town` VALUES ('5623', '南郊街道办事处', '152502006000', '152502000000');
INSERT INTO `t_s_town` VALUES ('5624', '巴彦查干街道办事处', '152502007000', '152502000000');
INSERT INTO `t_s_town` VALUES ('5625', '阿尔善宝拉格镇', '152502100000', '152502000000');
INSERT INTO `t_s_town` VALUES ('5626', '宝力根苏木', '152502200000', '152502000000');
INSERT INTO `t_s_town` VALUES ('5627', '朝克乌拉苏木', '152502201000', '152502000000');
INSERT INTO `t_s_town` VALUES ('5628', '巴彦锡勒办事处乡', '152502202000', '152502000000');
INSERT INTO `t_s_town` VALUES ('5629', '巴彦宝拉格苏木', '152502203000', '152502000000');
INSERT INTO `t_s_town` VALUES ('5630', '锡林郭勒盟经济技术开发区', '152502400000', '152502000000');
INSERT INTO `t_s_town` VALUES ('5631', '白音库伦牧场', '152502500000', '152502000000');
INSERT INTO `t_s_town` VALUES ('5632', '贝力克牧场', '152502501000', '152502000000');
INSERT INTO `t_s_town` VALUES ('5633', '毛登牧场', '152502502000', '152502000000');
INSERT INTO `t_s_town` VALUES ('5634', '别力古台镇', '152522100000', '152522000000');
INSERT INTO `t_s_town` VALUES ('5635', '洪格尔高勒镇', '152522101000', '152522000000');
INSERT INTO `t_s_town` VALUES ('5636', '查干淖尔镇', '152522102000', '152522000000');
INSERT INTO `t_s_town` VALUES ('5637', '那仁宝拉格苏木', '152522200000', '152522000000');
INSERT INTO `t_s_town` VALUES ('5638', '伊和高勒苏木', '152522201000', '152522000000');
INSERT INTO `t_s_town` VALUES ('5639', '吉尔嘎郎图苏木', '152522202000', '152522000000');
INSERT INTO `t_s_town` VALUES ('5640', '巴彦图嘎苏木', '152522203000', '152522000000');
INSERT INTO `t_s_town` VALUES ('5641', '玛尼图煤矿', '152522400000', '152522000000');
INSERT INTO `t_s_town` VALUES ('5642', '阿旗德力格尔工业园区', '152522401000', '152522000000');
INSERT INTO `t_s_town` VALUES ('5643', '满都拉图镇', '152523100000', '152523000000');
INSERT INTO `t_s_town` VALUES ('5644', '查干敖包镇', '152523101000', '152523000000');
INSERT INTO `t_s_town` VALUES ('5645', '巴彦淖尔镇', '152523102000', '152523000000');
INSERT INTO `t_s_town` VALUES ('5646', '巴彦乌拉苏木', '152523200000', '152523000000');
INSERT INTO `t_s_town` VALUES ('5647', '赛罕高毕苏木', '152523201000', '152523000000');
INSERT INTO `t_s_town` VALUES ('5648', '洪格尔苏木', '152523202000', '152523000000');
INSERT INTO `t_s_town` VALUES ('5649', '达来苏木', '152523203000', '152523000000');
INSERT INTO `t_s_town` VALUES ('5650', '苏尼特左旗芒来循环经济产业园区', '152523400000', '152523000000');
INSERT INTO `t_s_town` VALUES ('5651', '恩格尔河灌区', '152523500000', '152523000000');
INSERT INTO `t_s_town` VALUES ('5652', '赛汉塔拉镇', '152524100000', '152524000000');
INSERT INTO `t_s_town` VALUES ('5653', '朱日和镇', '152524101000', '152524000000');
INSERT INTO `t_s_town` VALUES ('5654', '乌日根塔拉镇', '152524102000', '152524000000');
INSERT INTO `t_s_town` VALUES ('5655', '桑宝拉格苏木', '152524200000', '152524000000');
INSERT INTO `t_s_town` VALUES ('5656', '额仁淖尔苏木', '152524201000', '152524000000');
INSERT INTO `t_s_town` VALUES ('5657', '赛罕乌力吉苏木', '152524202000', '152524000000');
INSERT INTO `t_s_town` VALUES ('5658', '阿其图乌拉苏木', '152524203000', '152524000000');
INSERT INTO `t_s_town` VALUES ('5659', '苏尼特右旗朱日和工业园区', '152524400000', '152524000000');
INSERT INTO `t_s_town` VALUES ('5660', '乌里雅斯太镇', '152525100000', '152525000000');
INSERT INTO `t_s_town` VALUES ('5661', '道特淖尔镇', '152525101000', '152525000000');
INSERT INTO `t_s_town` VALUES ('5662', '嘎达布其镇', '152525102000', '152525000000');
INSERT INTO `t_s_town` VALUES ('5663', '满都胡宝拉格镇', '152525103000', '152525000000');
INSERT INTO `t_s_town` VALUES ('5664', '额吉淖尔镇', '152525104000', '152525000000');
INSERT INTO `t_s_town` VALUES ('5665', '呼热图淖尔苏木', '152525200000', '152525000000');
INSERT INTO `t_s_town` VALUES ('5666', '萨麦苏木', '152525201000', '152525000000');
INSERT INTO `t_s_town` VALUES ('5667', '嘎海乐苏木', '152525202000', '152525000000');
INSERT INTO `t_s_town` VALUES ('5668', '阿拉坦合力苏木', '152525203000', '152525000000');
INSERT INTO `t_s_town` VALUES ('5669', '乌里雅斯太工业区', '152525400000', '152525000000');
INSERT INTO `t_s_town` VALUES ('5670', '宝格达乌拉总场', '152525503000', '152525000000');
INSERT INTO `t_s_town` VALUES ('5671', '巴拉嘎尔高勒镇', '152526100000', '152526000000');
INSERT INTO `t_s_town` VALUES ('5672', '巴彦花镇', '152526101000', '152526000000');
INSERT INTO `t_s_town` VALUES ('5673', '吉仁高勒镇', '152526102000', '152526000000');
INSERT INTO `t_s_town` VALUES ('5674', '浩勒图高勒镇', '152526103000', '152526000000');
INSERT INTO `t_s_town` VALUES ('5675', '高日罕镇', '152526104000', '152526000000');
INSERT INTO `t_s_town` VALUES ('5676', '巴彦胡舒苏木', '152526200000', '152526000000');
INSERT INTO `t_s_town` VALUES ('5677', '乌兰哈拉嘎苏木', '152526201000', '152526000000');
INSERT INTO `t_s_town` VALUES ('5678', '西乌旗白音华能源化工园区', '152526400000', '152526000000');
INSERT INTO `t_s_town` VALUES ('5679', '林业总场', '152526500000', '152526000000');
INSERT INTO `t_s_town` VALUES ('5680', '宝昌镇', '152527100000', '152527000000');
INSERT INTO `t_s_town` VALUES ('5681', '千斤沟镇', '152527101000', '152527000000');
INSERT INTO `t_s_town` VALUES ('5682', '红旗镇', '152527102000', '152527000000');
INSERT INTO `t_s_town` VALUES ('5683', '骆驼山镇', '152527103000', '152527000000');
INSERT INTO `t_s_town` VALUES ('5684', '永丰镇', '152527104000', '152527000000');
INSERT INTO `t_s_town` VALUES ('5685', '幸福乡', '152527200000', '152527000000');
INSERT INTO `t_s_town` VALUES ('5686', '贡宝拉格苏木', '152527201000', '152527000000');
INSERT INTO `t_s_town` VALUES ('5687', '万寿滩良种场', '152527500000', '152527000000');
INSERT INTO `t_s_town` VALUES ('5688', '新宝拉格镇', '152528100000', '152528000000');
INSERT INTO `t_s_town` VALUES ('5689', '巴彦塔拉镇', '152528101000', '152528000000');
INSERT INTO `t_s_town` VALUES ('5690', '翁贡乌拉苏木', '152528200000', '152528000000');
INSERT INTO `t_s_town` VALUES ('5691', '宝格达音髙勒苏木', '152528201000', '152528000000');
INSERT INTO `t_s_town` VALUES ('5692', '明安图镇', '152529100000', '152529000000');
INSERT INTO `t_s_town` VALUES ('5693', '星耀镇', '152529101000', '152529000000');
INSERT INTO `t_s_town` VALUES ('5694', '伊和淖尔苏木', '152529200000', '152529000000');
INSERT INTO `t_s_town` VALUES ('5695', '乌兰查布苏木', '152529201000', '152529000000');
INSERT INTO `t_s_town` VALUES ('5696', '宝拉根陶海苏木', '152529202000', '152529000000');
INSERT INTO `t_s_town` VALUES ('5697', '额里图种畜场', '152529500000', '152529000000');
INSERT INTO `t_s_town` VALUES ('5698', '哲日根图林场', '152529502000', '152529000000');
INSERT INTO `t_s_town` VALUES ('5699', '上都镇', '152530100000', '152530000000');
INSERT INTO `t_s_town` VALUES ('5700', '桑根达来镇', '152530101000', '152530000000');
INSERT INTO `t_s_town` VALUES ('5701', '哈毕日嘎镇', '152530102000', '152530000000');
INSERT INTO `t_s_town` VALUES ('5702', '宝绍代苏木', '152530200000', '152530000000');
INSERT INTO `t_s_town` VALUES ('5703', '那日图苏木', '152530201000', '152530000000');
INSERT INTO `t_s_town` VALUES ('5704', '赛音呼都嘎苏木', '152530202000', '152530000000');
INSERT INTO `t_s_town` VALUES ('5705', '扎格斯台苏木', '152530203000', '152530000000');
INSERT INTO `t_s_town` VALUES ('5706', '五一种畜场总场', '152530500000', '152530000000');
INSERT INTO `t_s_town` VALUES ('5707', '黑城子示范区', '152530501000', '152530000000');
INSERT INTO `t_s_town` VALUES ('5708', '大北沟镇', '152531100000', '152531000000');
INSERT INTO `t_s_town` VALUES ('5709', '多伦诺尔镇', '152531101000', '152531000000');
INSERT INTO `t_s_town` VALUES ('5710', '滦源镇', '152531102000', '152531000000');
INSERT INTO `t_s_town` VALUES ('5711', '蔡木山乡', '152531201000', '152531000000');
INSERT INTO `t_s_town` VALUES ('5712', '西干沟乡', '152531202000', '152531000000');
INSERT INTO `t_s_town` VALUES ('5713', '多伦新型工业化化工区', '152531400000', '152531000000');
INSERT INTO `t_s_town` VALUES ('5714', '巴彦胡硕镇', '152571101000', '152571000000');
INSERT INTO `t_s_town` VALUES ('5715', '哈拉盖图农牧场', '152571500000', '152571000000');
INSERT INTO `t_s_town` VALUES ('5716', '贺斯格乌拉牧场', '152571501000', '152571000000');
INSERT INTO `t_s_town` VALUES ('5717', '乌拉盖牧场', '152571502000', '152571000000');
INSERT INTO `t_s_town` VALUES ('5718', '温都尔勒图镇', '152921102000', '152921000000');
INSERT INTO `t_s_town` VALUES ('5719', '巴润别立镇', '152921105000', '152921000000');
INSERT INTO `t_s_town` VALUES ('5720', '巴彦浩特镇', '152921110000', '152921000000');
INSERT INTO `t_s_town` VALUES ('5721', '嘉尔嘎勒赛汉镇', '152921111000', '152921000000');
INSERT INTO `t_s_town` VALUES ('5722', '吉兰泰镇', '152921112000', '152921000000');
INSERT INTO `t_s_town` VALUES ('5723', '宗别立镇', '152921113000', '152921000000');
INSERT INTO `t_s_town` VALUES ('5724', '敖伦布拉格镇', '152921114000', '152921000000');
INSERT INTO `t_s_town` VALUES ('5725', '腾格里额里斯镇', '152921115000', '152921000000');
INSERT INTO `t_s_town` VALUES ('5726', '巴彦木仁苏木乡', '152921203000', '152921000000');
INSERT INTO `t_s_town` VALUES ('5727', '乌力吉苏木乡', '152921213000', '152921000000');
INSERT INTO `t_s_town` VALUES ('5728', '巴彦诺日公苏木乡', '152921214000', '152921000000');
INSERT INTO `t_s_town` VALUES ('5729', '额尔克哈什哈苏木乡', '152921215000', '152921000000');
INSERT INTO `t_s_town` VALUES ('5730', '银根苏木', '152921216000', '152921000000');
INSERT INTO `t_s_town` VALUES ('5731', '超格图呼热苏木', '152921217000', '152921000000');
INSERT INTO `t_s_town` VALUES ('5732', '腾格里经济技术开发区', '152921401000', '152921000000');
INSERT INTO `t_s_town` VALUES ('5733', '巴彦浩特额鲁特街道办事处', '152921402000', '152921000000');
INSERT INTO `t_s_town` VALUES ('5734', '巴彦浩特南环路街道办事处', '152921403000', '152921000000');
INSERT INTO `t_s_town` VALUES ('5735', '巴彦浩特新华街道办事处', '152921404000', '152921000000');
INSERT INTO `t_s_town` VALUES ('5736', '巴彦浩特王府街道办事处', '152921405000', '152921000000');
INSERT INTO `t_s_town` VALUES ('5737', '巴丹吉林镇', '152922103000', '152922000000');
INSERT INTO `t_s_town` VALUES ('5738', '雅布赖镇', '152922104000', '152922000000');
INSERT INTO `t_s_town` VALUES ('5739', '阿拉腾敖包镇', '152922105000', '152922000000');
INSERT INTO `t_s_town` VALUES ('5740', '曼德拉苏木', '152922211000', '152922000000');
INSERT INTO `t_s_town` VALUES ('5741', '阿拉腾朝格苏木', '152922212000', '152922000000');
INSERT INTO `t_s_town` VALUES ('5742', '巴音高勒苏木', '152922213000', '152922000000');
INSERT INTO `t_s_town` VALUES ('5743', '塔木素布拉格苏木', '152922214000', '152922000000');
INSERT INTO `t_s_town` VALUES ('5744', '额济纳旗航空街道', '152923001000', '152923000000');
INSERT INTO `t_s_town` VALUES ('5745', '额济纳旗东风街道', '152923002000', '152923000000');
INSERT INTO `t_s_town` VALUES ('5746', '达来呼布镇', '152923100000', '152923000000');
INSERT INTO `t_s_town` VALUES ('5747', '额济纳旗东风镇', '152923101000', '152923000000');
INSERT INTO `t_s_town` VALUES ('5748', '哈日布日格德音乌拉镇', '152923102000', '152923000000');
INSERT INTO `t_s_town` VALUES ('5749', '额济纳旗赛汉陶来苏木', '152923200000', '152923000000');
INSERT INTO `t_s_town` VALUES ('5750', '额济纳旗马鬃山苏木', '152923201000', '152923000000');
INSERT INTO `t_s_town` VALUES ('5751', '额济纳旗苏泊淖尔苏木', '152923202000', '152923000000');
INSERT INTO `t_s_town` VALUES ('5752', '巴彦陶来苏木', '152923203000', '152923000000');
INSERT INTO `t_s_town` VALUES ('5753', '温图高勒苏木', '152923204000', '152923000000');
INSERT INTO `t_s_town` VALUES ('5754', '乌斯太镇', '152971100000', '152971000000');
INSERT INTO `t_s_town` VALUES ('5755', '浑河湾街道', '210102001000', '210102000000');
INSERT INTO `t_s_town` VALUES ('5756', '新华街道', '210102002000', '210102000000');
INSERT INTO `t_s_town` VALUES ('5757', '西塔街道', '210102007000', '210102000000');
INSERT INTO `t_s_town` VALUES ('5758', '八经街道', '210102013000', '210102000000');
INSERT INTO `t_s_town` VALUES ('5759', '马路湾街道', '210102016000', '210102000000');
INSERT INTO `t_s_town` VALUES ('5760', '集贤街道', '210102017000', '210102000000');
INSERT INTO `t_s_town` VALUES ('5761', '南湖街道', '210102019000', '210102000000');
INSERT INTO `t_s_town` VALUES ('5762', '长白街道', '210102021000', '210102000000');
INSERT INTO `t_s_town` VALUES ('5763', '太原街街道', '210102022000', '210102000000');
INSERT INTO `t_s_town` VALUES ('5764', '北市场街道', '210102023000', '210102000000');
INSERT INTO `t_s_town` VALUES ('5765', '南市场街道', '210102025000', '210102000000');
INSERT INTO `t_s_town` VALUES ('5766', '沈水湾街道', '210102027000', '210102000000');
INSERT INTO `t_s_town` VALUES ('5767', '浑河站西街道', '210102028000', '210102000000');
INSERT INTO `t_s_town` VALUES ('5768', '大西街道', '210103004000', '210103000000');
INSERT INTO `t_s_town` VALUES ('5769', '滨河街道', '210103005000', '210103000000');
INSERT INTO `t_s_town` VALUES ('5770', '万莲街道', '210103006000', '210103000000');
INSERT INTO `t_s_town` VALUES ('5771', '大南街道', '210103010000', '210103000000');
INSERT INTO `t_s_town` VALUES ('5772', '山东庙街道', '210103011000', '210103000000');
INSERT INTO `t_s_town` VALUES ('5773', '朱剪炉街道', '210103013000', '210103000000');
INSERT INTO `t_s_town` VALUES ('5774', '新北站街道', '210103014000', '210103000000');
INSERT INTO `t_s_town` VALUES ('5775', '风雨坛街道', '210103015000', '210103000000');
INSERT INTO `t_s_town` VALUES ('5776', '皇城街道', '210103017000', '210103000000');
INSERT INTO `t_s_town` VALUES ('5777', '五里河街道', '210103018000', '210103000000');
INSERT INTO `t_s_town` VALUES ('5778', '南塔街道', '210103019000', '210103000000');
INSERT INTO `t_s_town` VALUES ('5779', '泉园街道', '210103020000', '210103000000');
INSERT INTO `t_s_town` VALUES ('5780', '丰乐街道', '210103021000', '210103000000');
INSERT INTO `t_s_town` VALUES ('5781', '马官桥街道', '210103022000', '210103000000');
INSERT INTO `t_s_town` VALUES ('5782', '东陵街道', '210103023000', '210103000000');
INSERT INTO `t_s_town` VALUES ('5783', '大北街道', '210104002000', '210104000000');
INSERT INTO `t_s_town` VALUES ('5784', '万泉街道', '210104003000', '210104000000');
INSERT INTO `t_s_town` VALUES ('5785', '洮昌街道', '210104004000', '210104000000');
INSERT INTO `t_s_town` VALUES ('5786', '文官街道', '210104006000', '210104000000');
INSERT INTO `t_s_town` VALUES ('5787', '二台子街道', '210104007000', '210104000000');
INSERT INTO `t_s_town` VALUES ('5788', '津桥街道', '210104008000', '210104000000');
INSERT INTO `t_s_town` VALUES ('5789', '东站街道', '210104009000', '210104000000');
INSERT INTO `t_s_town` VALUES ('5790', '北海街道', '210104010000', '210104000000');
INSERT INTO `t_s_town` VALUES ('5791', '长安街道', '210104012000', '210104000000');
INSERT INTO `t_s_town` VALUES ('5792', '新东街道', '210104014000', '210104000000');
INSERT INTO `t_s_town` VALUES ('5793', '东塔街道', '210104015000', '210104000000');
INSERT INTO `t_s_town` VALUES ('5794', '小东街道', '210104016000', '210104000000');
INSERT INTO `t_s_town` VALUES ('5795', '上园街道', '210104017000', '210104000000');
INSERT INTO `t_s_town` VALUES ('5796', '前进街道', '210104018000', '210104000000');
INSERT INTO `t_s_town` VALUES ('5797', '三台子街道', '210105001000', '210105000000');
INSERT INTO `t_s_town` VALUES ('5798', '辽河街道', '210105003000', '210105000000');
INSERT INTO `t_s_town` VALUES ('5799', '黄河街道', '210105008000', '210105000000');
INSERT INTO `t_s_town` VALUES ('5800', '三洞桥街道', '210105012000', '210105000000');
INSERT INTO `t_s_town` VALUES ('5801', '华山街道', '210105013000', '210105000000');
INSERT INTO `t_s_town` VALUES ('5802', '寿泉街道', '210105014000', '210105000000');
INSERT INTO `t_s_town` VALUES ('5803', '塔湾街道', '210105015000', '210105000000');
INSERT INTO `t_s_town` VALUES ('5804', '明廉街道', '210105017000', '210105000000');
INSERT INTO `t_s_town` VALUES ('5805', '新乐街道', '210105019000', '210105000000');
INSERT INTO `t_s_town` VALUES ('5806', '舍利塔街道', '210105020000', '210105000000');
INSERT INTO `t_s_town` VALUES ('5807', '北塔街道', '210105021000', '210105000000');
INSERT INTO `t_s_town` VALUES ('5808', '陵东街道', '210105022000', '210105000000');
INSERT INTO `t_s_town` VALUES ('5809', '昆明湖街道', '210106001000', '210106000000');
INSERT INTO `t_s_town` VALUES ('5810', '工人村街道', '210106003000', '210106000000');
INSERT INTO `t_s_town` VALUES ('5811', '七路街道', '210106005000', '210106000000');
INSERT INTO `t_s_town` VALUES ('5812', '启工街道', '210106007000', '210106000000');
INSERT INTO `t_s_town` VALUES ('5813', '笃工街道', '210106013000', '210106000000');
INSERT INTO `t_s_town` VALUES ('5814', '兴华街道', '210106015000', '210106000000');
INSERT INTO `t_s_town` VALUES ('5815', '兴工街道', '210106018000', '210106000000');
INSERT INTO `t_s_town` VALUES ('5816', '霁虹街道', '210106019000', '210106000000');
INSERT INTO `t_s_town` VALUES ('5817', '凌空街道', '210106020000', '210106000000');
INSERT INTO `t_s_town` VALUES ('5818', '重工街道', '210106021000', '210106000000');
INSERT INTO `t_s_town` VALUES ('5819', '艳粉街道', '210106022000', '210106000000');
INSERT INTO `t_s_town` VALUES ('5820', '保工街道', '210106023000', '210106000000');
INSERT INTO `t_s_town` VALUES ('5821', '兴顺街道', '210106024000', '210106000000');
INSERT INTO `t_s_town` VALUES ('5822', '贵和街道', '210106025000', '210106000000');
INSERT INTO `t_s_town` VALUES ('5823', '大青中朝友谊街道', '210106026000', '210106000000');
INSERT INTO `t_s_town` VALUES ('5824', '翟家街道', '210106027000', '210106000000');
INSERT INTO `t_s_town` VALUES ('5825', '西三环街道', '210106028000', '210106000000');
INSERT INTO `t_s_town` VALUES ('5826', '大潘街道', '210106029000', '210106000000');
INSERT INTO `t_s_town` VALUES ('5827', '彰驿站街道', '210106030000', '210106000000');
INSERT INTO `t_s_town` VALUES ('5828', '高花街道', '210106031000', '210106000000');
INSERT INTO `t_s_town` VALUES ('5829', '沈阳市经济技术开发区管理委员会', '210106401000', '210106000000');
INSERT INTO `t_s_town` VALUES ('5830', '解放街道', '210111001000', '210111000000');
INSERT INTO `t_s_town` VALUES ('5831', '民主街道', '210111003000', '210111000000');
INSERT INTO `t_s_town` VALUES ('5832', '临湖街道', '210111004000', '210111000000');
INSERT INTO `t_s_town` VALUES ('5833', '中兴街道', '210111005000', '210111000000');
INSERT INTO `t_s_town` VALUES ('5834', '湖西街道', '210111006000', '210111000000');
INSERT INTO `t_s_town` VALUES ('5835', '八一街道', '210111007000', '210111000000');
INSERT INTO `t_s_town` VALUES ('5836', '红菱街道', '210111008000', '210111000000');
INSERT INTO `t_s_town` VALUES ('5837', '林盛街道', '210111009000', '210111000000');
INSERT INTO `t_s_town` VALUES ('5838', '沙河街道', '210111010000', '210111000000');
INSERT INTO `t_s_town` VALUES ('5839', '十里河街道', '210111011000', '210111000000');
INSERT INTO `t_s_town` VALUES ('5840', '陈相街道', '210111012000', '210111000000');
INSERT INTO `t_s_town` VALUES ('5841', '姚千街道', '210111013000', '210111000000');
INSERT INTO `t_s_town` VALUES ('5842', '王纲街道', '210111014000', '210111000000');
INSERT INTO `t_s_town` VALUES ('5843', '永乐街道', '210111015000', '210111000000');
INSERT INTO `t_s_town` VALUES ('5844', '大沟街道', '210111016000', '210111000000');
INSERT INTO `t_s_town` VALUES ('5845', '白清街道', '210111017000', '210111000000');
INSERT INTO `t_s_town` VALUES ('5846', '佟沟街道办事处', '210111018000', '210111000000');
INSERT INTO `t_s_town` VALUES ('5847', '东湖街道', '210112009000', '210112000000');
INSERT INTO `t_s_town` VALUES ('5848', '五三街道', '210112010000', '210112000000');
INSERT INTO `t_s_town` VALUES ('5849', '浑河站东街道', '210112012000', '210112000000');
INSERT INTO `t_s_town` VALUES ('5850', '高坎街道', '210112014000', '210112000000');
INSERT INTO `t_s_town` VALUES ('5851', '满堂街道', '210112015000', '210112000000');
INSERT INTO `t_s_town` VALUES ('5852', '深井子街道', '210112016000', '210112000000');
INSERT INTO `t_s_town` VALUES ('5853', '祝家街道', '210112017000', '210112000000');
INSERT INTO `t_s_town` VALUES ('5854', '白塔街道', '210112018000', '210112000000');
INSERT INTO `t_s_town` VALUES ('5855', '桃仙街道', '210112019000', '210112000000');
INSERT INTO `t_s_town` VALUES ('5856', '李相街道', '210112020000', '210112000000');
INSERT INTO `t_s_town` VALUES ('5857', '营城子街道', '210112021000', '210112000000');
INSERT INTO `t_s_town` VALUES ('5858', '汪家街道', '210112022000', '210112000000');
INSERT INTO `t_s_town` VALUES ('5859', '王滨街道', '210112023000', '210112000000');
INSERT INTO `t_s_town` VALUES ('5860', '望滨街道', '210112024000', '210112000000');
INSERT INTO `t_s_town` VALUES ('5861', '永胜街道', '210112025000', '210112000000');
INSERT INTO `t_s_town` VALUES ('5862', '新城子街道', '210113001000', '210113000000');
INSERT INTO `t_s_town` VALUES ('5863', '清水台街道', '210113002000', '210113000000');
INSERT INTO `t_s_town` VALUES ('5864', '辉山街道', '210113003000', '210113000000');
INSERT INTO `t_s_town` VALUES ('5865', '道义街道', '210113004000', '210113000000');
INSERT INTO `t_s_town` VALUES ('5866', '虎石台街道', '210113006000', '210113000000');
INSERT INTO `t_s_town` VALUES ('5867', '财落街道', '210113007000', '210113000000');
INSERT INTO `t_s_town` VALUES ('5868', '沈北街道', '210113009000', '210113000000');
INSERT INTO `t_s_town` VALUES ('5869', '马刚街道', '210113010000', '210113000000');
INSERT INTO `t_s_town` VALUES ('5870', '石佛寺街道', '210113011000', '210113000000');
INSERT INTO `t_s_town` VALUES ('5871', '黄家街道', '210113012000', '210113000000');
INSERT INTO `t_s_town` VALUES ('5872', '尹家街道', '210113013000', '210113000000');
INSERT INTO `t_s_town` VALUES ('5873', '兴隆台街道', '210113014000', '210113000000');
INSERT INTO `t_s_town` VALUES ('5874', '清泉街道', '210113015000', '210113000000');
INSERT INTO `t_s_town` VALUES ('5875', '青年农场', '210113401000', '210113000000');
INSERT INTO `t_s_town` VALUES ('5876', '前进农场', '210113402000', '210113000000');
INSERT INTO `t_s_town` VALUES ('5877', '育新农场', '210113403000', '210113000000');
INSERT INTO `t_s_town` VALUES ('5878', '沈北新区马刚林场', '210113404000', '210113000000');
INSERT INTO `t_s_town` VALUES ('5879', '沈北新区示范农场', '210113405000', '210113000000');
INSERT INTO `t_s_town` VALUES ('5880', '沈北新区种畜场', '210113406000', '210113000000');
INSERT INTO `t_s_town` VALUES ('5881', '迎宾路街道', '210114001000', '210114000000');
INSERT INTO `t_s_town` VALUES ('5882', '陵西街道', '210114003000', '210114000000');
INSERT INTO `t_s_town` VALUES ('5883', '于洪街道', '210114005000', '210114000000');
INSERT INTO `t_s_town` VALUES ('5884', '北陵街道', '210114007000', '210114000000');
INSERT INTO `t_s_town` VALUES ('5885', '沙岭街道', '210114009000', '210114000000');
INSERT INTO `t_s_town` VALUES ('5886', '南阳湖街道', '210114010000', '210114000000');
INSERT INTO `t_s_town` VALUES ('5887', '城东湖街道', '210114011000', '210114000000');
INSERT INTO `t_s_town` VALUES ('5888', '平罗街道', '210114012000', '210114000000');
INSERT INTO `t_s_town` VALUES ('5889', '马三家街道', '210114013000', '210114000000');
INSERT INTO `t_s_town` VALUES ('5890', '造化街道', '210114014000', '210114000000');
INSERT INTO `t_s_town` VALUES ('5891', '大兴街道', '210114015000', '210114000000');
INSERT INTO `t_s_town` VALUES ('5892', '光辉街道', '210114016000', '210114000000');
INSERT INTO `t_s_town` VALUES ('5893', '马三家强制隔离戒毒所', '210114401000', '210114000000');
INSERT INTO `t_s_town` VALUES ('5894', '光辉农场', '210114402000', '210114000000');
INSERT INTO `t_s_town` VALUES ('5895', '监狱城', '210114404000', '210114000000');
INSERT INTO `t_s_town` VALUES ('5896', '蒲西街道办事处', '210115001000', '210115000000');
INSERT INTO `t_s_town` VALUES ('5897', '蒲东街道办事处', '210115002000', '210115000000');
INSERT INTO `t_s_town` VALUES ('5898', '茨榆坨街道办事处', '210115003000', '210115000000');
INSERT INTO `t_s_town` VALUES ('5899', '城郊街道办事处', '210115004000', '210115000000');
INSERT INTO `t_s_town` VALUES ('5900', '于家房镇', '210115101000', '210115000000');
INSERT INTO `t_s_town` VALUES ('5901', '朱家房镇', '210115102000', '210115000000');
INSERT INTO `t_s_town` VALUES ('5902', '冷子堡镇', '210115103000', '210115000000');
INSERT INTO `t_s_town` VALUES ('5903', '刘二堡镇', '210115104000', '210115000000');
INSERT INTO `t_s_town` VALUES ('5904', '新民屯镇', '210115106000', '210115000000');
INSERT INTO `t_s_town` VALUES ('5905', '满都户镇', '210115107000', '210115000000');
INSERT INTO `t_s_town` VALUES ('5906', '杨士岗镇', '210115108000', '210115000000');
INSERT INTO `t_s_town` VALUES ('5907', '肖寨门镇', '210115109000', '210115000000');
INSERT INTO `t_s_town` VALUES ('5908', '长滩镇', '210115110000', '210115000000');
INSERT INTO `t_s_town` VALUES ('5909', '四方台镇', '210115111000', '210115000000');
INSERT INTO `t_s_town` VALUES ('5910', '六间房镇', '210115113000', '210115000000');
INSERT INTO `t_s_town` VALUES ('5911', '养士堡镇', '210115114000', '210115000000');
INSERT INTO `t_s_town` VALUES ('5912', '潘家堡镇', '210115115000', '210115000000');
INSERT INTO `t_s_town` VALUES ('5913', '老大房镇', '210115117000', '210115000000');
INSERT INTO `t_s_town` VALUES ('5914', '大黑岗子镇', '210115118000', '210115000000');
INSERT INTO `t_s_town` VALUES ('5915', '牛心坨镇', '210115119000', '210115000000');
INSERT INTO `t_s_town` VALUES ('5916', '四方台农场', '210115401000', '210115000000');
INSERT INTO `t_s_town` VALUES ('5917', '北三家子街道', '210123001000', '210123000000');
INSERT INTO `t_s_town` VALUES ('5918', '胜利街道', '210123002000', '210123000000');
INSERT INTO `t_s_town` VALUES ('5919', '东关街道', '210123003000', '210123000000');
INSERT INTO `t_s_town` VALUES ('5920', '小城子镇', '210123101000', '210123000000');
INSERT INTO `t_s_town` VALUES ('5921', '张强镇', '210123102000', '210123000000');
INSERT INTO `t_s_town` VALUES ('5922', '方家屯镇', '210123103000', '210123000000');
INSERT INTO `t_s_town` VALUES ('5923', '郝官屯镇', '210123105000', '210123000000');
INSERT INTO `t_s_town` VALUES ('5924', '二牛所口镇', '210123106000', '210123000000');
INSERT INTO `t_s_town` VALUES ('5925', '北四家子乡', '210123203000', '210123000000');
INSERT INTO `t_s_town` VALUES ('5926', '两家子乡', '210123204000', '210123000000');
INSERT INTO `t_s_town` VALUES ('5927', '海洲窝堡乡', '210123206000', '210123000000');
INSERT INTO `t_s_town` VALUES ('5928', '沙金台蒙古族满族乡', '210123208000', '210123000000');
INSERT INTO `t_s_town` VALUES ('5929', '柳树屯蒙古族满族乡', '210123209000', '210123000000');
INSERT INTO `t_s_town` VALUES ('5930', '西关屯蒙古族满族乡', '210123210000', '210123000000');
INSERT INTO `t_s_town` VALUES ('5931', '东升满族蒙古族乡', '210123211000', '210123000000');
INSERT INTO `t_s_town` VALUES ('5932', '吉祥街道', '210124001000', '210124000000');
INSERT INTO `t_s_town` VALUES ('5933', '龙山街道', '210124002000', '210124000000');
INSERT INTO `t_s_town` VALUES ('5934', '大孤家子镇', '210124101000', '210124000000');
INSERT INTO `t_s_town` VALUES ('5935', '三面船镇', '210124102000', '210124000000');
INSERT INTO `t_s_town` VALUES ('5936', '秀水河子镇', '210124103000', '210124000000');
INSERT INTO `t_s_town` VALUES ('5937', '叶茂台镇', '210124104000', '210124000000');
INSERT INTO `t_s_town` VALUES ('5938', '登仕堡子镇', '210124105000', '210124000000');
INSERT INTO `t_s_town` VALUES ('5939', '柏家沟镇', '210124106000', '210124000000');
INSERT INTO `t_s_town` VALUES ('5940', '丁家房镇', '210124107000', '210124000000');
INSERT INTO `t_s_town` VALUES ('5941', '孟家镇', '210124108000', '210124000000');
INSERT INTO `t_s_town` VALUES ('5942', '十间房镇', '210124109000', '210124000000');
INSERT INTO `t_s_town` VALUES ('5943', '冯贝堡镇', '210124110000', '210124000000');
INSERT INTO `t_s_town` VALUES ('5944', '依牛堡子镇', '210124111000', '210124000000');
INSERT INTO `t_s_town` VALUES ('5945', '包家屯镇', '210124113000', '210124000000');
INSERT INTO `t_s_town` VALUES ('5946', '慈恩寺乡', '210124201000', '210124000000');
INSERT INTO `t_s_town` VALUES ('5947', '和平乡', '210124203000', '210124000000');
INSERT INTO `t_s_town` VALUES ('5948', '四家子蒙古族乡', '210124208000', '210124000000');
INSERT INTO `t_s_town` VALUES ('5949', '双台子乡', '210124209000', '210124000000');
INSERT INTO `t_s_town` VALUES ('5950', '卧牛石乡', '210124210000', '210124000000');
INSERT INTO `t_s_town` VALUES ('5951', '东城街道', '210181001000', '210181000000');
INSERT INTO `t_s_town` VALUES ('5952', '辽滨街道', '210181002000', '210181000000');
INSERT INTO `t_s_town` VALUES ('5953', '西城街道', '210181003000', '210181000000');
INSERT INTO `t_s_town` VALUES ('5954', '新柳街道', '210181004000', '210181000000');
INSERT INTO `t_s_town` VALUES ('5955', '新城街道', '210181005000', '210181000000');
INSERT INTO `t_s_town` VALUES ('5956', '大红旗镇', '210181101000', '210181000000');
INSERT INTO `t_s_town` VALUES ('5957', '梁山镇', '210181102000', '210181000000');
INSERT INTO `t_s_town` VALUES ('5958', '公主屯镇', '210181103000', '210181000000');
INSERT INTO `t_s_town` VALUES ('5959', '兴隆镇', '210181104000', '210181000000');
INSERT INTO `t_s_town` VALUES ('5960', '前当堡镇', '210181105000', '210181000000');
INSERT INTO `t_s_town` VALUES ('5961', '大民屯镇', '210181106000', '210181000000');
INSERT INTO `t_s_town` VALUES ('5962', '大柳屯镇', '210181107000', '210181000000');
INSERT INTO `t_s_town` VALUES ('5963', '兴隆堡镇', '210181108000', '210181000000');
INSERT INTO `t_s_town` VALUES ('5964', '胡台镇', '210181109000', '210181000000');
INSERT INTO `t_s_town` VALUES ('5965', '法哈牛镇', '210181110000', '210181000000');
INSERT INTO `t_s_town` VALUES ('5966', '柳河沟镇', '210181111000', '210181000000');
INSERT INTO `t_s_town` VALUES ('5967', '高台子镇', '210181112000', '210181000000');
INSERT INTO `t_s_town` VALUES ('5968', '张家屯镇', '210181113000', '210181000000');
INSERT INTO `t_s_town` VALUES ('5969', '罗家房镇', '210181114000', '210181000000');
INSERT INTO `t_s_town` VALUES ('5970', '三道岗子镇', '210181115000', '210181000000');
INSERT INTO `t_s_town` VALUES ('5971', '东蛇山子镇', '210181116000', '210181000000');
INSERT INTO `t_s_town` VALUES ('5972', '陶家屯镇', '210181117000', '210181000000');
INSERT INTO `t_s_town` VALUES ('5973', '周坨子镇', '210181118000', '210181000000');
INSERT INTO `t_s_town` VALUES ('5974', '金五台子镇', '210181119000', '210181000000');
INSERT INTO `t_s_town` VALUES ('5975', '新农村镇', '210181120000', '210181000000');
INSERT INTO `t_s_town` VALUES ('5976', '红旗乡', '210181205000', '210181000000');
INSERT INTO `t_s_town` VALUES ('5977', '卢家屯乡', '210181206000', '210181000000');
INSERT INTO `t_s_town` VALUES ('5978', '姚堡乡', '210181207000', '210181000000');
INSERT INTO `t_s_town` VALUES ('5979', '于家窝堡乡', '210181209000', '210181000000');
INSERT INTO `t_s_town` VALUES ('5980', '海军广场街道', '210202001000', '210202000000');
INSERT INTO `t_s_town` VALUES ('5981', '桂林街道', '210202003000', '210202000000');
INSERT INTO `t_s_town` VALUES ('5982', '人民路街道', '210202005000', '210202000000');
INSERT INTO `t_s_town` VALUES ('5983', '青泥洼桥街道', '210202008000', '210202000000');
INSERT INTO `t_s_town` VALUES ('5984', '昆明街道', '210202009000', '210202000000');
INSERT INTO `t_s_town` VALUES ('5985', '葵英街道', '210202010000', '210202000000');
INSERT INTO `t_s_town` VALUES ('5986', '桃源街道', '210202011000', '210202000000');
INSERT INTO `t_s_town` VALUES ('5987', '老虎滩街道', '210202012000', '210202000000');
INSERT INTO `t_s_town` VALUES ('5988', '东港街道', '210202013000', '210202000000');
INSERT INTO `t_s_town` VALUES ('5989', '香炉礁街道', '210203001000', '210203000000');
INSERT INTO `t_s_town` VALUES ('5990', '站北街道', '210203002000', '210203000000');
INSERT INTO `t_s_town` VALUES ('5991', '日新街道', '210203004000', '210203000000');
INSERT INTO `t_s_town` VALUES ('5992', '北京街道', '210203005000', '210203000000');
INSERT INTO `t_s_town` VALUES ('5993', '八一路街道', '210203010000', '210203000000');
INSERT INTO `t_s_town` VALUES ('5994', '人民广场街道', '210203011000', '210203000000');
INSERT INTO `t_s_town` VALUES ('5995', '白云街道', '210203013000', '210203000000');
INSERT INTO `t_s_town` VALUES ('5996', '中山公园街道', '210204002000', '210204000000');
INSERT INTO `t_s_town` VALUES ('5997', '白山路街道', '210204004000', '210204000000');
INSERT INTO `t_s_town` VALUES ('5998', '兴工街道', '210204005000', '210204000000');
INSERT INTO `t_s_town` VALUES ('5999', '春柳街道', '210204006000', '210204000000');
INSERT INTO `t_s_town` VALUES ('6000', '马栏街道', '210204008000', '210204000000');
INSERT INTO `t_s_town` VALUES ('6001', '南沙河口街道', '210204009000', '210204000000');
INSERT INTO `t_s_town` VALUES ('6002', '黑石礁街道', '210204010000', '210204000000');
INSERT INTO `t_s_town` VALUES ('6003', '李家街道', '210204011000', '210204000000');
INSERT INTO `t_s_town` VALUES ('6004', '星海湾街道', '210204017000', '210204000000');
INSERT INTO `t_s_town` VALUES ('6005', '周水子街道', '210211001000', '210211000000');
INSERT INTO `t_s_town` VALUES ('6006', '椒金山街道', '210211002000', '210211000000');
INSERT INTO `t_s_town` VALUES ('6007', '甘井子街道', '210211004000', '210211000000');
INSERT INTO `t_s_town` VALUES ('6008', '南关岭街道', '210211006000', '210211000000');
INSERT INTO `t_s_town` VALUES ('6009', '泡崖街道', '210211007000', '210211000000');
INSERT INTO `t_s_town` VALUES ('6010', '中华路街道', '210211008000', '210211000000');
INSERT INTO `t_s_town` VALUES ('6011', '兴华街道', '210211009000', '210211000000');
INSERT INTO `t_s_town` VALUES ('6012', '机场街道', '210211010000', '210211000000');
INSERT INTO `t_s_town` VALUES ('6013', '辛寨子街道', '210211014000', '210211000000');
INSERT INTO `t_s_town` VALUES ('6014', '红旗街道', '210211015000', '210211000000');
INSERT INTO `t_s_town` VALUES ('6015', '凌水街道', '210211016000', '210211000000');
INSERT INTO `t_s_town` VALUES ('6016', '大连湾街道', '210211017000', '210211000000');
INSERT INTO `t_s_town` VALUES ('6017', '泉水街道', '210211018000', '210211000000');
INSERT INTO `t_s_town` VALUES ('6018', '革镇堡街道', '210211019000', '210211000000');
INSERT INTO `t_s_town` VALUES ('6019', '营城子街道', '210211020000', '210211000000');
INSERT INTO `t_s_town` VALUES ('6020', '七贤岭街道', '210211021000', '210211000000');
INSERT INTO `t_s_town` VALUES ('6021', '大连华侨果树农场', '210211400000', '210211000000');
INSERT INTO `t_s_town` VALUES ('6022', '登峰街道', '210212001000', '210212000000');
INSERT INTO `t_s_town` VALUES ('6023', '市场街道', '210212002000', '210212000000');
INSERT INTO `t_s_town` VALUES ('6024', '得胜街道', '210212003000', '210212000000');
INSERT INTO `t_s_town` VALUES ('6025', '光荣街道', '210212004000', '210212000000');
INSERT INTO `t_s_town` VALUES ('6026', '水师营街道', '210212005000', '210212000000');
INSERT INTO `t_s_town` VALUES ('6027', '龙王塘街道', '210212006000', '210212000000');
INSERT INTO `t_s_town` VALUES ('6028', '铁山街道', '210212007000', '210212000000');
INSERT INTO `t_s_town` VALUES ('6029', '双岛湾街道', '210212009000', '210212000000');
INSERT INTO `t_s_town` VALUES ('6030', '三涧堡街道', '210212010000', '210212000000');
INSERT INTO `t_s_town` VALUES ('6031', '长城街道', '210212011000', '210212000000');
INSERT INTO `t_s_town` VALUES ('6032', '龙头街道', '210212012000', '210212000000');
INSERT INTO `t_s_town` VALUES ('6033', '北海街道', '210212013000', '210212000000');
INSERT INTO `t_s_town` VALUES ('6034', '旅顺经济开发区', '210212400000', '210212000000');
INSERT INTO `t_s_town` VALUES ('6035', '大连奶牛场', '210212401000', '210212000000');
INSERT INTO `t_s_town` VALUES ('6036', '龙头分园', '210212402000', '210212000000');
INSERT INTO `t_s_town` VALUES ('6037', '拥政街道', '210213001000', '210213000000');
INSERT INTO `t_s_town` VALUES ('6038', '友谊街道', '210213002000', '210213000000');
INSERT INTO `t_s_town` VALUES ('6039', '光明街道', '210213003000', '210213000000');
INSERT INTO `t_s_town` VALUES ('6040', '马桥子街道', '210213004000', '210213000000');
INSERT INTO `t_s_town` VALUES ('6041', '海青岛街道', '210213005000', '210213000000');
INSERT INTO `t_s_town` VALUES ('6042', '大孤山街道', '210213006000', '210213000000');
INSERT INTO `t_s_town` VALUES ('6043', '中长街道', '210213007000', '210213000000');
INSERT INTO `t_s_town` VALUES ('6044', '站前街道', '210213008000', '210213000000');
INSERT INTO `t_s_town` VALUES ('6045', '先进街道', '210213009000', '210213000000');
INSERT INTO `t_s_town` VALUES ('6046', '董家沟街道', '210213011000', '210213000000');
INSERT INTO `t_s_town` VALUES ('6047', '金石滩街道', '210213012000', '210213000000');
INSERT INTO `t_s_town` VALUES ('6048', '湾里街道', '210213013000', '210213000000');
INSERT INTO `t_s_town` VALUES ('6049', '二十里堡街道', '210213014000', '210213000000');
INSERT INTO `t_s_town` VALUES ('6050', '亮甲店街道', '210213016000', '210213000000');
INSERT INTO `t_s_town` VALUES ('6051', '登沙河街道', '210213017000', '210213000000');
INSERT INTO `t_s_town` VALUES ('6052', '大魏家街道', '210213019000', '210213000000');
INSERT INTO `t_s_town` VALUES ('6053', '杏树街道', '210213020000', '210213000000');
INSERT INTO `t_s_town` VALUES ('6054', '七顶山街道', '210213021000', '210213000000');
INSERT INTO `t_s_town` VALUES ('6055', '华家街道', '210213022000', '210213000000');
INSERT INTO `t_s_town` VALUES ('6056', '向应街道', '210213023000', '210213000000');
INSERT INTO `t_s_town` VALUES ('6057', '大李家街道', '210213024000', '210213000000');
INSERT INTO `t_s_town` VALUES ('6058', '得胜街道', '210213025000', '210213000000');
INSERT INTO `t_s_town` VALUES ('6059', '大窑湾街道', '210213026000', '210213000000');
INSERT INTO `t_s_town` VALUES ('6060', '炮台街道', '210213027000', '210213000000');
INSERT INTO `t_s_town` VALUES ('6061', '复州湾街道', '210213028000', '210213000000');
INSERT INTO `t_s_town` VALUES ('6062', '三十里堡街道', '210213029000', '210213000000');
INSERT INTO `t_s_town` VALUES ('6063', '石河街道', '210213030000', '210213000000');
INSERT INTO `t_s_town` VALUES ('6064', '丰荣街道', '210214001000', '210214000000');
INSERT INTO `t_s_town` VALUES ('6065', '铁西街道', '210214002000', '210214000000');
INSERT INTO `t_s_town` VALUES ('6066', '太平街道', '210214003000', '210214000000');
INSERT INTO `t_s_town` VALUES ('6067', '南山街道', '210214004000', '210214000000');
INSERT INTO `t_s_town` VALUES ('6068', '皮口街道', '210214005000', '210214000000');
INSERT INTO `t_s_town` VALUES ('6069', '城子坦街道', '210214006000', '210214000000');
INSERT INTO `t_s_town` VALUES ('6070', '大刘家街道', '210214007000', '210214000000');
INSERT INTO `t_s_town` VALUES ('6071', '杨树房街道', '210214008000', '210214000000');
INSERT INTO `t_s_town` VALUES ('6072', '大谭街道', '210214009000', '210214000000');
INSERT INTO `t_s_town` VALUES ('6073', '唐家房街道', '210214010000', '210214000000');
INSERT INTO `t_s_town` VALUES ('6074', '莲山街道', '210214011000', '210214000000');
INSERT INTO `t_s_town` VALUES ('6075', '安波街道', '210214012000', '210214000000');
INSERT INTO `t_s_town` VALUES ('6076', '沙包街道', '210214013000', '210214000000');
INSERT INTO `t_s_town` VALUES ('6077', '星台街道', '210214014000', '210214000000');
INSERT INTO `t_s_town` VALUES ('6078', '墨盘街道', '210214015000', '210214000000');
INSERT INTO `t_s_town` VALUES ('6079', '同益街道', '210214016000', '210214000000');
INSERT INTO `t_s_town` VALUES ('6080', '乐甲街道', '210214017000', '210214000000');
INSERT INTO `t_s_town` VALUES ('6081', '双塔街道', '210214018000', '210214000000');
INSERT INTO `t_s_town` VALUES ('6082', '四平街道', '210214019000', '210214000000');
INSERT INTO `t_s_town` VALUES ('6083', '大长山岛镇', '210224100000', '210224000000');
INSERT INTO `t_s_town` VALUES ('6084', '獐子岛镇', '210224101000', '210224000000');
INSERT INTO `t_s_town` VALUES ('6085', '广鹿岛镇', '210224102000', '210224000000');
INSERT INTO `t_s_town` VALUES ('6086', '小长山岛镇', '210224103000', '210224000000');
INSERT INTO `t_s_town` VALUES ('6087', '海洋岛镇', '210224104000', '210224000000');
INSERT INTO `t_s_town` VALUES ('6088', '新华办事处', '210281001000', '210281000000');
INSERT INTO `t_s_town` VALUES ('6089', '文兰办事处', '210281002000', '210281000000');
INSERT INTO `t_s_town` VALUES ('6090', '岭东办事处', '210281003000', '210281000000');
INSERT INTO `t_s_town` VALUES ('6091', '共济办事处', '210281004000', '210281000000');
INSERT INTO `t_s_town` VALUES ('6092', '铁东办事处', '210281005000', '210281000000');
INSERT INTO `t_s_town` VALUES ('6093', '祝华办事处', '210281006000', '210281000000');
INSERT INTO `t_s_town` VALUES ('6094', '岗店办事处', '210281007000', '210281000000');
INSERT INTO `t_s_town` VALUES ('6095', '太阳街道办事处', '210281008000', '210281000000');
INSERT INTO `t_s_town` VALUES ('6096', '长兴岛办事处', '210281009000', '210281000000');
INSERT INTO `t_s_town` VALUES ('6097', '九龙办事处', '210281010000', '210281000000');
INSERT INTO `t_s_town` VALUES ('6098', '交流岛街道', '210281011000', '210281000000');
INSERT INTO `t_s_town` VALUES ('6099', '复州城镇', '210281101000', '210281000000');
INSERT INTO `t_s_town` VALUES ('6100', '松树镇', '210281103000', '210281000000');
INSERT INTO `t_s_town` VALUES ('6101', '得利寺镇', '210281105000', '210281000000');
INSERT INTO `t_s_town` VALUES ('6102', '万家岭镇', '210281106000', '210281000000');
INSERT INTO `t_s_town` VALUES ('6103', '许屯镇', '210281107000', '210281000000');
INSERT INTO `t_s_town` VALUES ('6104', '永宁镇', '210281108000', '210281000000');
INSERT INTO `t_s_town` VALUES ('6105', '谢屯镇', '210281109000', '210281000000');
INSERT INTO `t_s_town` VALUES ('6106', '老虎屯镇', '210281112000', '210281000000');
INSERT INTO `t_s_town` VALUES ('6107', '红沿河镇', '210281113000', '210281000000');
INSERT INTO `t_s_town` VALUES ('6108', '李官镇', '210281115000', '210281000000');
INSERT INTO `t_s_town` VALUES ('6109', '仙浴湾镇', '210281116000', '210281000000');
INSERT INTO `t_s_town` VALUES ('6110', '元台镇', '210281117000', '210281000000');
INSERT INTO `t_s_town` VALUES ('6111', '瓦窝镇', '210281118000', '210281000000');
INSERT INTO `t_s_town` VALUES ('6112', '赵屯乡', '210281201000', '210281000000');
INSERT INTO `t_s_town` VALUES ('6113', '土城乡', '210281203000', '210281000000');
INSERT INTO `t_s_town` VALUES ('6114', '阎店乡', '210281204000', '210281000000');
INSERT INTO `t_s_town` VALUES ('6115', '西杨乡', '210281205000', '210281000000');
INSERT INTO `t_s_town` VALUES ('6116', '驼山乡', '210281206000', '210281000000');
INSERT INTO `t_s_town` VALUES ('6117', '三台满族乡', '210281208000', '210281000000');
INSERT INTO `t_s_town` VALUES ('6118', '泡崖乡', '210281210000', '210281000000');
INSERT INTO `t_s_town` VALUES ('6119', '杨家满族乡', '210281212000', '210281000000');
INSERT INTO `t_s_town` VALUES ('6120', '城关街道', '210283001000', '210283000000');
INSERT INTO `t_s_town` VALUES ('6121', '新华街道', '210283002000', '210283000000');
INSERT INTO `t_s_town` VALUES ('6122', '兴达街道', '210283003000', '210283000000');
INSERT INTO `t_s_town` VALUES ('6123', '昌盛街道', '210283004000', '210283000000');
INSERT INTO `t_s_town` VALUES ('6124', '明阳街道', '210283005000', '210283000000');
INSERT INTO `t_s_town` VALUES ('6125', '青堆镇', '210283101000', '210283000000');
INSERT INTO `t_s_town` VALUES ('6126', '徐岭镇', '210283102000', '210283000000');
INSERT INTO `t_s_town` VALUES ('6127', '黑岛镇', '210283104000', '210283000000');
INSERT INTO `t_s_town` VALUES ('6128', '栗子房镇', '210283105000', '210283000000');
INSERT INTO `t_s_town` VALUES ('6129', '大营镇', '210283107000', '210283000000');
INSERT INTO `t_s_town` VALUES ('6130', '塔岭镇', '210283108000', '210283000000');
INSERT INTO `t_s_town` VALUES ('6131', '仙人洞镇', '210283109000', '210283000000');
INSERT INTO `t_s_town` VALUES ('6132', '蓉花山镇', '210283110000', '210283000000');
INSERT INTO `t_s_town` VALUES ('6133', '长岭镇', '210283111000', '210283000000');
INSERT INTO `t_s_town` VALUES ('6134', '荷花山镇', '210283112000', '210283000000');
INSERT INTO `t_s_town` VALUES ('6135', '城山镇', '210283113000', '210283000000');
INSERT INTO `t_s_town` VALUES ('6136', '光明山镇', '210283114000', '210283000000');
INSERT INTO `t_s_town` VALUES ('6137', '大郑镇', '210283115000', '210283000000');
INSERT INTO `t_s_town` VALUES ('6138', '吴炉镇', '210283118000', '210283000000');
INSERT INTO `t_s_town` VALUES ('6139', '王家镇', '210283120000', '210283000000');
INSERT INTO `t_s_town` VALUES ('6140', '鞍子山乡', '210283204000', '210283000000');
INSERT INTO `t_s_town` VALUES ('6141', '太平岭满族乡', '210283208000', '210283000000');
INSERT INTO `t_s_town` VALUES ('6142', '步云山乡', '210283209000', '210283000000');
INSERT INTO `t_s_town` VALUES ('6143', '桂云花满族乡', '210283211000', '210283000000');
INSERT INTO `t_s_town` VALUES ('6144', '兰店乡', '210283214000', '210283000000');
INSERT INTO `t_s_town` VALUES ('6145', '石城乡', '210283216000', '210283000000');
INSERT INTO `t_s_town` VALUES ('6146', '长甸街道办事处', '210302001000', '210302000000');
INSERT INTO `t_s_town` VALUES ('6147', '解放街道办事处', '210302002000', '210302000000');
INSERT INTO `t_s_town` VALUES ('6148', '山南街道办事处', '210302003000', '210302000000');
INSERT INTO `t_s_town` VALUES ('6149', '园林街道办事处', '210302004000', '210302000000');
INSERT INTO `t_s_town` VALUES ('6150', '胜利街道办事处', '210302005000', '210302000000');
INSERT INTO `t_s_town` VALUES ('6151', '站前街道办事处', '210302006000', '210302000000');
INSERT INTO `t_s_town` VALUES ('6152', '钢城街道办事处', '210302007000', '210302000000');
INSERT INTO `t_s_town` VALUES ('6153', '和平街道办事处', '210302008000', '210302000000');
INSERT INTO `t_s_town` VALUES ('6154', '对炉街道办事处', '210302009000', '210302000000');
INSERT INTO `t_s_town` VALUES ('6155', '东长甸街道办事处', '210302010000', '210302000000');
INSERT INTO `t_s_town` VALUES ('6156', '湖南街道办事处', '210302011000', '210302000000');
INSERT INTO `t_s_town` VALUES ('6157', '常青街道办事处', '210302012000', '210302000000');
INSERT INTO `t_s_town` VALUES ('6158', '新兴街道办事处', '210302013000', '210302000000');
INSERT INTO `t_s_town` VALUES ('6159', '旧堡街道办事处', '210302014000', '210302000000');
INSERT INTO `t_s_town` VALUES ('6160', '大孤山街道', '210302015000', '210302000000');
INSERT INTO `t_s_town` VALUES ('6161', '温泉街道办事处', '210302016000', '210302000000');
INSERT INTO `t_s_town` VALUES ('6162', '玉佛山风景区管理委员会', '210302400000', '210302000000');
INSERT INTO `t_s_town` VALUES ('6163', '启明街道办事处', '210303001000', '210303000000');
INSERT INTO `t_s_town` VALUES ('6164', '繁荣街道办事处', '210303002000', '210303000000');
INSERT INTO `t_s_town` VALUES ('6165', '八家子街道办事处', '210303003000', '210303000000');
INSERT INTO `t_s_town` VALUES ('6166', '兴盛街道办事处', '210303004000', '210303000000');
INSERT INTO `t_s_town` VALUES ('6167', '共和街道办事处', '210303005000', '210303000000');
INSERT INTO `t_s_town` VALUES ('6168', '永乐街道办事处', '210303006000', '210303000000');
INSERT INTO `t_s_town` VALUES ('6169', '北陶官街道办事处', '210303007000', '210303000000');
INSERT INTO `t_s_town` VALUES ('6170', '南华街道办事处', '210303008000', '210303000000');
INSERT INTO `t_s_town` VALUES ('6171', '大陆街道办事处', '210303009000', '210303000000');
INSERT INTO `t_s_town` VALUES ('6172', '新陶官街道办事处', '210303010000', '210303000000');
INSERT INTO `t_s_town` VALUES ('6173', '新城街道办事处', '210303011000', '210303000000');
INSERT INTO `t_s_town` VALUES ('6174', '永发街道办事处', '210303012000', '210303000000');
INSERT INTO `t_s_town` VALUES ('6175', '宁远街道办事处', '210303013000', '210303000000');
INSERT INTO `t_s_town` VALUES ('6176', '达道湾街道办事处', '210303014000', '210303000000');
INSERT INTO `t_s_town` VALUES ('6177', '友好街道办事处', '210304001000', '210304000000');
INSERT INTO `t_s_town` VALUES ('6178', '双山街道办事处', '210304004000', '210304000000');
INSERT INTO `t_s_town` VALUES ('6179', '立山街道办事处', '210304006000', '210304000000');
INSERT INTO `t_s_town` VALUES ('6180', '曙光街道办事处', '210304008000', '210304000000');
INSERT INTO `t_s_town` VALUES ('6181', '灵山街道办事处', '210304009000', '210304000000');
INSERT INTO `t_s_town` VALUES ('6182', '深南街道办事处', '210304013000', '210304000000');
INSERT INTO `t_s_town` VALUES ('6183', '深北街道办事处', '210304014000', '210304000000');
INSERT INTO `t_s_town` VALUES ('6184', '沙河街道办事处', '210304015000', '210304000000');
INSERT INTO `t_s_town` VALUES ('6185', '滨河街道办事处', '210304016000', '210304000000');
INSERT INTO `t_s_town` VALUES ('6186', '千山街道办事处', '210304017000', '210304000000');
INSERT INTO `t_s_town` VALUES ('6187', '齐大山街道办事处', '210304019000', '210304000000');
INSERT INTO `t_s_town` VALUES ('6188', '汪峪街道办事处', '210304020000', '210304000000');
INSERT INTO `t_s_town` VALUES ('6189', '红岭街道办事处', '210304021000', '210304000000');
INSERT INTO `t_s_town` VALUES ('6190', '对桩石街道办事处', '210311005000', '210311000000');
INSERT INTO `t_s_town` VALUES ('6191', '汤岗子街道办事处', '210311006000', '210311000000');
INSERT INTO `t_s_town` VALUES ('6192', '东鞍山街道办事处', '210311007000', '210311000000');
INSERT INTO `t_s_town` VALUES ('6193', '唐家房镇', '210311102000', '210311000000');
INSERT INTO `t_s_town` VALUES ('6194', '大屯镇', '210311103000', '210311000000');
INSERT INTO `t_s_town` VALUES ('6195', '甘泉镇', '210311104000', '210311000000');
INSERT INTO `t_s_town` VALUES ('6196', '八角台街道办事处', '210321001000', '210321000000');
INSERT INTO `t_s_town` VALUES ('6197', '台东街道办事处', '210321002000', '210321000000');
INSERT INTO `t_s_town` VALUES ('6198', '台南街道办事处', '210321003000', '210321000000');
INSERT INTO `t_s_town` VALUES ('6199', '台北街道办事处', '210321004000', '210321000000');
INSERT INTO `t_s_town` VALUES ('6200', '西佛镇', '210321101000', '210321000000');
INSERT INTO `t_s_town` VALUES ('6201', '新开河镇', '210321102000', '210321000000');
INSERT INTO `t_s_town` VALUES ('6202', '黄沙坨镇', '210321103000', '210321000000');
INSERT INTO `t_s_town` VALUES ('6203', '高力房镇', '210321104000', '210321000000');
INSERT INTO `t_s_town` VALUES ('6204', '桑林镇', '210321105000', '210321000000');
INSERT INTO `t_s_town` VALUES ('6205', '富家镇', '210321106000', '210321000000');
INSERT INTO `t_s_town` VALUES ('6206', '达牛镇', '210321107000', '210321000000');
INSERT INTO `t_s_town` VALUES ('6207', '台安县韭菜台镇', '210321109000', '210321000000');
INSERT INTO `t_s_town` VALUES ('6208', '新台镇', '210321110000', '210321000000');
INSERT INTO `t_s_town` VALUES ('6209', '桓洞镇', '210321111000', '210321000000');
INSERT INTO `t_s_town` VALUES ('6210', '新华农场', '210321400000', '210321000000');
INSERT INTO `t_s_town` VALUES ('6211', '洪家农牧场', '210321401000', '210321000000');
INSERT INTO `t_s_town` VALUES ('6212', '阜昌街道办事处', '210323001000', '210323000000');
INSERT INTO `t_s_town` VALUES ('6213', '大宁街道办事处', '210323002000', '210323000000');
INSERT INTO `t_s_town` VALUES ('6214', '兴隆街道办事处', '210323003000', '210323000000');
INSERT INTO `t_s_town` VALUES ('6215', '雅河街道办事处', '210323004000', '210323000000');
INSERT INTO `t_s_town` VALUES ('6216', '仙人咀街道办事处', '210323005000', '210323000000');
INSERT INTO `t_s_town` VALUES ('6217', '三家子镇', '210323101000', '210323000000');
INSERT INTO `t_s_town` VALUES ('6218', '石庙子镇', '210323102000', '210323000000');
INSERT INTO `t_s_town` VALUES ('6219', '黄花甸镇', '210323103000', '210323000000');
INSERT INTO `t_s_town` VALUES ('6220', '大营子镇', '210323104000', '210323000000');
INSERT INTO `t_s_town` VALUES ('6221', '苏子沟镇', '210323105000', '210323000000');
INSERT INTO `t_s_town` VALUES ('6222', '偏岭镇', '210323106000', '210323000000');
INSERT INTO `t_s_town` VALUES ('6223', '哈达碑镇', '210323107000', '210323000000');
INSERT INTO `t_s_town` VALUES ('6224', '新甸镇', '210323108000', '210323000000');
INSERT INTO `t_s_town` VALUES ('6225', '洋河镇', '210323109000', '210323000000');
INSERT INTO `t_s_town` VALUES ('6226', '杨家堡镇', '210323111000', '210323000000');
INSERT INTO `t_s_town` VALUES ('6227', '清凉山镇', '210323112000', '210323000000');
INSERT INTO `t_s_town` VALUES ('6228', '石灰窑镇', '210323113000', '210323000000');
INSERT INTO `t_s_town` VALUES ('6229', '前营子镇', '210323114000', '210323000000');
INSERT INTO `t_s_town` VALUES ('6230', '龙潭镇', '210323115000', '210323000000');
INSERT INTO `t_s_town` VALUES ('6231', '牧牛镇', '210323116000', '210323000000');
INSERT INTO `t_s_town` VALUES ('6232', '药山镇', '210323117000', '210323000000');
INSERT INTO `t_s_town` VALUES ('6233', '大房身镇', '210323118000', '210323000000');
INSERT INTO `t_s_town` VALUES ('6234', '朝阳镇', '210323119000', '210323000000');
INSERT INTO `t_s_town` VALUES ('6235', '红旗营子乡', '210323206000', '210323000000');
INSERT INTO `t_s_town` VALUES ('6236', '岭沟乡', '210323211000', '210323000000');
INSERT INTO `t_s_town` VALUES ('6237', '哨子河乡', '210323212000', '210323000000');
INSERT INTO `t_s_town` VALUES ('6238', '海州街道办事处', '210381001000', '210381000000');
INSERT INTO `t_s_town` VALUES ('6239', '兴海街道办事处', '210381002000', '210381000000');
INSERT INTO `t_s_town` VALUES ('6240', '响堂街道办事处', '210381003000', '210381000000');
INSERT INTO `t_s_town` VALUES ('6241', '东四街道办事处', '210381004000', '210381000000');
INSERT INTO `t_s_town` VALUES ('6242', '验军街道办事处', '210381005000', '210381000000');
INSERT INTO `t_s_town` VALUES ('6243', '温泉街道办事处', '210381006000', '210381000000');
INSERT INTO `t_s_town` VALUES ('6244', '孤山镇', '210381101000', '210381000000');
INSERT INTO `t_s_town` VALUES ('6245', '岔沟镇', '210381102000', '210381000000');
INSERT INTO `t_s_town` VALUES ('6246', '接文镇', '210381103000', '210381000000');
INSERT INTO `t_s_town` VALUES ('6247', '析木镇', '210381104000', '210381000000');
INSERT INTO `t_s_town` VALUES ('6248', '马风镇', '210381105000', '210381000000');
INSERT INTO `t_s_town` VALUES ('6249', '牌楼镇', '210381107000', '210381000000');
INSERT INTO `t_s_town` VALUES ('6250', '八里镇', '210381108000', '210381000000');
INSERT INTO `t_s_town` VALUES ('6251', '毛祁镇', '210381109000', '210381000000');
INSERT INTO `t_s_town` VALUES ('6252', '英落镇', '210381110000', '210381000000');
INSERT INTO `t_s_town` VALUES ('6253', '感王镇', '210381111000', '210381000000');
INSERT INTO `t_s_town` VALUES ('6254', '西柳镇', '210381112000', '210381000000');
INSERT INTO `t_s_town` VALUES ('6255', '中小镇', '210381113000', '210381000000');
INSERT INTO `t_s_town` VALUES ('6256', '王石镇', '210381114000', '210381000000');
INSERT INTO `t_s_town` VALUES ('6257', '南台镇', '210381115000', '210381000000');
INSERT INTO `t_s_town` VALUES ('6258', '腾鳌镇', '210381118000', '210381000000');
INSERT INTO `t_s_town` VALUES ('6259', '耿庄镇', '210381121000', '210381000000');
INSERT INTO `t_s_town` VALUES ('6260', '牛庄镇', '210381123000', '210381000000');
INSERT INTO `t_s_town` VALUES ('6261', '西四镇', '210381124000', '210381000000');
INSERT INTO `t_s_town` VALUES ('6262', '望台镇', '210381125000', '210381000000');
INSERT INTO `t_s_town` VALUES ('6263', '温香镇', '210381126000', '210381000000');
INSERT INTO `t_s_town` VALUES ('6264', '高坨镇', '210381127000', '210381000000');
INSERT INTO `t_s_town` VALUES ('6265', '站前街道', '210402001000', '210402000000');
INSERT INTO `t_s_town` VALUES ('6266', '东公园街道', '210402003000', '210402000000');
INSERT INTO `t_s_town` VALUES ('6267', '福民街道', '210402005000', '210402000000');
INSERT INTO `t_s_town` VALUES ('6268', '新抚街道', '210402007000', '210402000000');
INSERT INTO `t_s_town` VALUES ('6269', '榆林街道', '210402009000', '210402000000');
INSERT INTO `t_s_town` VALUES ('6270', '永安台街道', '210402011000', '210402000000');
INSERT INTO `t_s_town` VALUES ('6271', '千金街道', '210402013000', '210402000000');
INSERT INTO `t_s_town` VALUES ('6272', '南阳街道', '210402015000', '210402000000');
INSERT INTO `t_s_town` VALUES ('6273', '南花园街道', '210402017000', '210402000000');
INSERT INTO `t_s_town` VALUES ('6274', '刘山街道', '210402019000', '210402000000');
INSERT INTO `t_s_town` VALUES ('6275', '千金乡', '210402201000', '210402000000');
INSERT INTO `t_s_town` VALUES ('6276', '东洲街道', '210403002000', '210403000000');
INSERT INTO `t_s_town` VALUES ('6277', '张甸街道', '210403003000', '210403000000');
INSERT INTO `t_s_town` VALUES ('6278', '搭连街道', '210403004000', '210403000000');
INSERT INTO `t_s_town` VALUES ('6279', '龙凤街道', '210403005000', '210403000000');
INSERT INTO `t_s_town` VALUES ('6280', '新屯街道', '210403006000', '210403000000');
INSERT INTO `t_s_town` VALUES ('6281', '万新街道', '210403007000', '210403000000');
INSERT INTO `t_s_town` VALUES ('6282', '老虎台街道', '210403008000', '210403000000');
INSERT INTO `t_s_town` VALUES ('6283', '平山街道', '210403009000', '210403000000');
INSERT INTO `t_s_town` VALUES ('6284', '章党街道', '210403012000', '210403000000');
INSERT INTO `t_s_town` VALUES ('6285', '章党镇', '210403103000', '210403000000');
INSERT INTO `t_s_town` VALUES ('6286', '哈达镇', '210403104000', '210403000000');
INSERT INTO `t_s_town` VALUES ('6287', '碾盘乡', '210403202000', '210403000000');
INSERT INTO `t_s_town` VALUES ('6288', '兰山乡', '210403215000', '210403000000');
INSERT INTO `t_s_town` VALUES ('6289', '田屯街道', '210404001000', '210404000000');
INSERT INTO `t_s_town` VALUES ('6290', '工农街道', '210404002000', '210404000000');
INSERT INTO `t_s_town` VALUES ('6291', '建设街道', '210404003000', '210404000000');
INSERT INTO `t_s_town` VALUES ('6292', '和平街道', '210404004000', '210404000000');
INSERT INTO `t_s_town` VALUES ('6293', '光明街道', '210404005000', '210404000000');
INSERT INTO `t_s_town` VALUES ('6294', '朴屯街道', '210404006000', '210404000000');
INSERT INTO `t_s_town` VALUES ('6295', '演武街道', '210404007000', '210404000000');
INSERT INTO `t_s_town` VALUES ('6296', '五老屯街道', '210404008000', '210404000000');
INSERT INTO `t_s_town` VALUES ('6297', '古城子街道', '210404009000', '210404000000');
INSERT INTO `t_s_town` VALUES ('6298', '新民街道', '210404010000', '210404000000');
INSERT INTO `t_s_town` VALUES ('6299', '李石街道', '210404011000', '210404000000');
INSERT INTO `t_s_town` VALUES ('6300', '塔峪镇', '210404101000', '210404000000');
INSERT INTO `t_s_town` VALUES ('6301', '拉古满族乡', '210404201000', '210404000000');
INSERT INTO `t_s_town` VALUES ('6302', '河东街道', '210411001000', '210411000000');
INSERT INTO `t_s_town` VALUES ('6303', '长春街道', '210411002000', '210411000000');
INSERT INTO `t_s_town` VALUES ('6304', '葛布街道', '210411003000', '210411000000');
INSERT INTO `t_s_town` VALUES ('6305', '将军堡街道', '210411004000', '210411000000');
INSERT INTO `t_s_town` VALUES ('6306', '新华街道', '210411005000', '210411000000');
INSERT INTO `t_s_town` VALUES ('6307', '抚顺城街道', '210411007000', '210411000000');
INSERT INTO `t_s_town` VALUES ('6308', '前甸镇', '210411102000', '210411000000');
INSERT INTO `t_s_town` VALUES ('6309', '河北乡', '210411201000', '210411000000');
INSERT INTO `t_s_town` VALUES ('6310', '会元乡', '210411205000', '210411000000');
INSERT INTO `t_s_town` VALUES ('6311', '石文镇', '210421101000', '210421000000');
INSERT INTO `t_s_town` VALUES ('6312', '后安镇', '210421102000', '210421000000');
INSERT INTO `t_s_town` VALUES ('6313', '上马镇', '210421105000', '210421000000');
INSERT INTO `t_s_town` VALUES ('6314', '救兵镇', '210421106000', '210421000000');
INSERT INTO `t_s_town` VALUES ('6315', '马圈子乡', '210421204000', '210421000000');
INSERT INTO `t_s_town` VALUES ('6316', '峡河乡', '210421209000', '210421000000');
INSERT INTO `t_s_town` VALUES ('6317', '海浪乡', '210421211000', '210421000000');
INSERT INTO `t_s_town` VALUES ('6318', '汤图满族乡', '210421216000', '210421000000');
INSERT INTO `t_s_town` VALUES ('6319', '新宾镇', '210422100000', '210422000000');
INSERT INTO `t_s_town` VALUES ('6320', '旺清门镇', '210422101000', '210422000000');
INSERT INTO `t_s_town` VALUES ('6321', '永陵镇', '210422102000', '210422000000');
INSERT INTO `t_s_town` VALUES ('6322', '平顶山镇', '210422103000', '210422000000');
INSERT INTO `t_s_town` VALUES ('6323', '大四平镇', '210422104000', '210422000000');
INSERT INTO `t_s_town` VALUES ('6324', '苇子峪镇', '210422105000', '210422000000');
INSERT INTO `t_s_town` VALUES ('6325', '木奇镇', '210422106000', '210422000000');
INSERT INTO `t_s_town` VALUES ('6326', '上夹河镇', '210422108000', '210422000000');
INSERT INTO `t_s_town` VALUES ('6327', '南杂木镇', '210422109000', '210422000000');
INSERT INTO `t_s_town` VALUES ('6328', '红升乡', '210422202000', '210422000000');
INSERT INTO `t_s_town` VALUES ('6329', '响水河子乡', '210422203000', '210422000000');
INSERT INTO `t_s_town` VALUES ('6330', '红庙子乡', '210422204000', '210422000000');
INSERT INTO `t_s_town` VALUES ('6331', '北四平乡', '210422205000', '210422000000');
INSERT INTO `t_s_town` VALUES ('6332', '榆树乡', '210422207000', '210422000000');
INSERT INTO `t_s_town` VALUES ('6333', '下夹河乡', '210422208000', '210422000000');
INSERT INTO `t_s_town` VALUES ('6334', '清原镇', '210423100000', '210423000000');
INSERT INTO `t_s_town` VALUES ('6335', '红透山镇', '210423101000', '210423000000');
INSERT INTO `t_s_town` VALUES ('6336', '草市镇', '210423103000', '210423000000');
INSERT INTO `t_s_town` VALUES ('6337', '英额门镇', '210423104000', '210423000000');
INSERT INTO `t_s_town` VALUES ('6338', '南口前镇', '210423105000', '210423000000');
INSERT INTO `t_s_town` VALUES ('6339', '南山城镇', '210423106000', '210423000000');
INSERT INTO `t_s_town` VALUES ('6340', '湾甸子镇', '210423107000', '210423000000');
INSERT INTO `t_s_town` VALUES ('6341', '大孤家镇', '210423108000', '210423000000');
INSERT INTO `t_s_town` VALUES ('6342', '夏家堡镇', '210423109000', '210423000000');
INSERT INTO `t_s_town` VALUES ('6343', '北三家镇', '210423110000', '210423000000');
INSERT INTO `t_s_town` VALUES ('6344', '土口子乡', '210423203000', '210423000000');
INSERT INTO `t_s_town` VALUES ('6345', '敖家堡乡', '210423206000', '210423000000');
INSERT INTO `t_s_town` VALUES ('6346', '大苏河乡', '210423207000', '210423000000');
INSERT INTO `t_s_town` VALUES ('6347', '枸乃甸乡', '210423208000', '210423000000');
INSERT INTO `t_s_town` VALUES ('6348', '南地街道', '210502001000', '210502000000');
INSERT INTO `t_s_town` VALUES ('6349', '工人街道', '210502002000', '210502000000');
INSERT INTO `t_s_town` VALUES ('6350', '平山街道', '210502003000', '210502000000');
INSERT INTO `t_s_town` VALUES ('6351', '东明街道', '210502004000', '210502000000');
INSERT INTO `t_s_town` VALUES ('6352', '崔东街道', '210502005000', '210502000000');
INSERT INTO `t_s_town` VALUES ('6353', '站前街道', '210502007000', '210502000000');
INSERT INTO `t_s_town` VALUES ('6354', '千金街道', '210502008000', '210502000000');
INSERT INTO `t_s_town` VALUES ('6355', '北台街道办事处', '210502010000', '210502000000');
INSERT INTO `t_s_town` VALUES ('6356', '桥头街道办事处', '210502011000', '210502000000');
INSERT INTO `t_s_town` VALUES ('6357', '河东街道', '210503001000', '210503000000');
INSERT INTO `t_s_town` VALUES ('6358', '河西街道', '210503003000', '210503000000');
INSERT INTO `t_s_town` VALUES ('6359', '彩屯街道', '210503005000', '210503000000');
INSERT INTO `t_s_town` VALUES ('6360', '竖井街道', '210503006000', '210503000000');
INSERT INTO `t_s_town` VALUES ('6361', '彩北街道', '210503007000', '210503000000');
INSERT INTO `t_s_town` VALUES ('6362', '东风街道办事处', '210503009000', '210503000000');
INSERT INTO `t_s_town` VALUES ('6363', '石桥子街道办事处', '210503010000', '210503000000');
INSERT INTO `t_s_town` VALUES ('6364', '日月岛街道办事处', '210503011000', '210503000000');
INSERT INTO `t_s_town` VALUES ('6365', '张其寨街道办事处', '210503012000', '210503000000');
INSERT INTO `t_s_town` VALUES ('6366', '火连寨街道办事处', '210503013000', '210503000000');
INSERT INTO `t_s_town` VALUES ('6367', '金山街道', '210504001000', '210504000000');
INSERT INTO `t_s_town` VALUES ('6368', '北地街道', '210504002000', '210504000000');
INSERT INTO `t_s_town` VALUES ('6369', '高峪街道', '210504004000', '210504000000');
INSERT INTO `t_s_town` VALUES ('6370', '明山街道', '210504005000', '210504000000');
INSERT INTO `t_s_town` VALUES ('6371', '东兴街道', '210504007000', '210504000000');
INSERT INTO `t_s_town` VALUES ('6372', '新明街道', '210504008000', '210504000000');
INSERT INTO `t_s_town` VALUES ('6373', '牛心台街道', '210504009000', '210504000000');
INSERT INTO `t_s_town` VALUES ('6374', '卧龙街道', '210504010000', '210504000000');
INSERT INTO `t_s_town` VALUES ('6375', '高台子街道办事处', '210504011000', '210504000000');
INSERT INTO `t_s_town` VALUES ('6376', '南芬街道', '210505001000', '210505000000');
INSERT INTO `t_s_town` VALUES ('6377', '铁山街道', '210505002000', '210505000000');
INSERT INTO `t_s_town` VALUES ('6378', '郭家街道', '210505003000', '210505000000');
INSERT INTO `t_s_town` VALUES ('6379', '思山岭街道办事处', '210505004000', '210505000000');
INSERT INTO `t_s_town` VALUES ('6380', '下马塘街道办事处', '210505005000', '210505000000');
INSERT INTO `t_s_town` VALUES ('6381', '观音阁街道', '210521001000', '210521000000');
INSERT INTO `t_s_town` VALUES ('6382', '小市镇', '210521100000', '210521000000');
INSERT INTO `t_s_town` VALUES ('6383', '草河掌镇', '210521101000', '210521000000');
INSERT INTO `t_s_town` VALUES ('6384', '草河城镇', '210521102000', '210521000000');
INSERT INTO `t_s_town` VALUES ('6385', '草河口镇', '210521103000', '210521000000');
INSERT INTO `t_s_town` VALUES ('6386', '连山关镇', '210521104000', '210521000000');
INSERT INTO `t_s_town` VALUES ('6387', '清河城镇', '210521106000', '210521000000');
INSERT INTO `t_s_town` VALUES ('6388', '田师傅镇', '210521109000', '210521000000');
INSERT INTO `t_s_town` VALUES ('6389', '南甸镇', '210521110000', '210521000000');
INSERT INTO `t_s_town` VALUES ('6390', '碱厂镇', '210521111000', '210521000000');
INSERT INTO `t_s_town` VALUES ('6391', '高官镇', '210521112000', '210521000000');
INSERT INTO `t_s_town` VALUES ('6392', '东营房乡', '210521202000', '210521000000');
INSERT INTO `t_s_town` VALUES ('6393', '八卦城街道办事处', '210522001000', '210522000000');
INSERT INTO `t_s_town` VALUES ('6394', '桓仁镇', '210522100000', '210522000000');
INSERT INTO `t_s_town` VALUES ('6395', '普乐堡镇', '210522101000', '210522000000');
INSERT INTO `t_s_town` VALUES ('6396', '二棚甸子镇', '210522102000', '210522000000');
INSERT INTO `t_s_town` VALUES ('6397', '沙尖子镇', '210522103000', '210522000000');
INSERT INTO `t_s_town` VALUES ('6398', '五里甸子镇', '210522104000', '210522000000');
INSERT INTO `t_s_town` VALUES ('6399', '八里甸子镇', '210522108000', '210522000000');
INSERT INTO `t_s_town` VALUES ('6400', '华来镇', '210522110000', '210522000000');
INSERT INTO `t_s_town` VALUES ('6401', '古城镇', '210522111000', '210522000000');
INSERT INTO `t_s_town` VALUES ('6402', '雅河朝鲜族乡', '210522201000', '210522000000');
INSERT INTO `t_s_town` VALUES ('6403', '向阳乡', '210522202000', '210522000000');
INSERT INTO `t_s_town` VALUES ('6404', '黑沟乡', '210522206000', '210522000000');
INSERT INTO `t_s_town` VALUES ('6405', '北甸子乡', '210522208000', '210522000000');
INSERT INTO `t_s_town` VALUES ('6406', '六道口街道', '210602001000', '210602000000');
INSERT INTO `t_s_town` VALUES ('6407', '七道街道', '210602002000', '210602000000');
INSERT INTO `t_s_town` VALUES ('6408', '八道街道', '210602003000', '210602000000');
INSERT INTO `t_s_town` VALUES ('6409', '九道街道', '210602004000', '210602000000');
INSERT INTO `t_s_town` VALUES ('6410', '广济街道', '210602005000', '210602000000');
INSERT INTO `t_s_town` VALUES ('6411', '兴东街道', '210602006000', '210602000000');
INSERT INTO `t_s_town` VALUES ('6412', '金山镇', '210602101000', '210602000000');
INSERT INTO `t_s_town` VALUES ('6413', '头道桥街道', '210603001000', '210603000000');
INSERT INTO `t_s_town` VALUES ('6414', '站前街道', '210603002000', '210603000000');
INSERT INTO `t_s_town` VALUES ('6415', '临江街道', '210603003000', '210603000000');
INSERT INTO `t_s_town` VALUES ('6416', '六道沟街道', '210603004000', '210603000000');
INSERT INTO `t_s_town` VALUES ('6417', '帽盔山街道', '210603005000', '210603000000');
INSERT INTO `t_s_town` VALUES ('6418', '纤维街道', '210603006000', '210603000000');
INSERT INTO `t_s_town` VALUES ('6419', '永昌街道', '210603007000', '210603000000');
INSERT INTO `t_s_town` VALUES ('6420', '花园街道', '210603008000', '210603000000');
INSERT INTO `t_s_town` VALUES ('6421', '江海街道', '210603009000', '210603000000');
INSERT INTO `t_s_town` VALUES ('6422', '西城街道办事处', '210603010000', '210603000000');
INSERT INTO `t_s_town` VALUES ('6423', '浪头镇', '210603101000', '210603000000');
INSERT INTO `t_s_town` VALUES ('6424', '安民镇', '210603102000', '210603000000');
INSERT INTO `t_s_town` VALUES ('6425', '汤池镇', '210603103000', '210603000000');
INSERT INTO `t_s_town` VALUES ('6426', '鸭绿江街道', '210604001000', '210604000000');
INSERT INTO `t_s_town` VALUES ('6427', '金矿街道', '210604003000', '210604000000');
INSERT INTO `t_s_town` VALUES ('6428', '珍珠街道', '210604004000', '210604000000');
INSERT INTO `t_s_town` VALUES ('6429', '太平湾街道', '210604005000', '210604000000');
INSERT INTO `t_s_town` VALUES ('6430', '同兴镇', '210604102000', '210604000000');
INSERT INTO `t_s_town` VALUES ('6431', '五龙背镇', '210604104000', '210604000000');
INSERT INTO `t_s_town` VALUES ('6432', '楼房镇', '210604105000', '210604000000');
INSERT INTO `t_s_town` VALUES ('6433', '九连城镇', '210604106000', '210604000000');
INSERT INTO `t_s_town` VALUES ('6434', '汤山城镇', '210604107000', '210604000000');
INSERT INTO `t_s_town` VALUES ('6435', '宽甸镇', '210624100000', '210624000000');
INSERT INTO `t_s_town` VALUES ('6436', '灌水镇', '210624101000', '210624000000');
INSERT INTO `t_s_town` VALUES ('6437', '硼海镇', '210624102000', '210624000000');
INSERT INTO `t_s_town` VALUES ('6438', '红石镇', '210624103000', '210624000000');
INSERT INTO `t_s_town` VALUES ('6439', '毛甸子镇', '210624104000', '210624000000');
INSERT INTO `t_s_town` VALUES ('6440', '长甸镇', '210624105000', '210624000000');
INSERT INTO `t_s_town` VALUES ('6441', '永甸镇', '210624106000', '210624000000');
INSERT INTO `t_s_town` VALUES ('6442', '太平哨镇', '210624108000', '210624000000');
INSERT INTO `t_s_town` VALUES ('6443', '青山沟镇', '210624109000', '210624000000');
INSERT INTO `t_s_town` VALUES ('6444', '牛毛坞镇', '210624110000', '210624000000');
INSERT INTO `t_s_town` VALUES ('6445', '大川头镇', '210624111000', '210624000000');
INSERT INTO `t_s_town` VALUES ('6446', '青椅山镇', '210624112000', '210624000000');
INSERT INTO `t_s_town` VALUES ('6447', '杨木川镇', '210624113000', '210624000000');
INSERT INTO `t_s_town` VALUES ('6448', '虎山镇', '210624114000', '210624000000');
INSERT INTO `t_s_town` VALUES ('6449', '振江镇', '210624115000', '210624000000');
INSERT INTO `t_s_town` VALUES ('6450', '步达远镇', '210624116000', '210624000000');
INSERT INTO `t_s_town` VALUES ('6451', '大西岔镇', '210624117000', '210624000000');
INSERT INTO `t_s_town` VALUES ('6452', '八河川镇', '210624118000', '210624000000');
INSERT INTO `t_s_town` VALUES ('6453', '双山子镇', '210624119000', '210624000000');
INSERT INTO `t_s_town` VALUES ('6454', '石湖沟乡', '210624201000', '210624000000');
INSERT INTO `t_s_town` VALUES ('6455', '古楼子乡', '210624206000', '210624000000');
INSERT INTO `t_s_town` VALUES ('6456', '下露河朝鲜族乡', '210624212000', '210624000000');
INSERT INTO `t_s_town` VALUES ('6457', '大东街道', '210681001000', '210681000000');
INSERT INTO `t_s_town` VALUES ('6458', '新兴街道', '210681002000', '210681000000');
INSERT INTO `t_s_town` VALUES ('6459', '新城街道', '210681003000', '210681000000');
INSERT INTO `t_s_town` VALUES ('6460', '孤山镇', '210681101000', '210681000000');
INSERT INTO `t_s_town` VALUES ('6461', '前阳镇', '210681104000', '210681000000');
INSERT INTO `t_s_town` VALUES ('6462', '长安镇', '210681105000', '210681000000');
INSERT INTO `t_s_town` VALUES ('6463', '十字街镇', '210681106000', '210681000000');
INSERT INTO `t_s_town` VALUES ('6464', '长山镇', '210681107000', '210681000000');
INSERT INTO `t_s_town` VALUES ('6465', '北井子镇', '210681108000', '210681000000');
INSERT INTO `t_s_town` VALUES ('6466', '椅圈镇', '210681109000', '210681000000');
INSERT INTO `t_s_town` VALUES ('6467', '黄土坎镇', '210681110000', '210681000000');
INSERT INTO `t_s_town` VALUES ('6468', '马家店镇', '210681113000', '210681000000');
INSERT INTO `t_s_town` VALUES ('6469', '龙王庙镇', '210681114000', '210681000000');
INSERT INTO `t_s_town` VALUES ('6470', '小甸子镇', '210681115000', '210681000000');
INSERT INTO `t_s_town` VALUES ('6471', '菩萨庙镇', '210681117000', '210681000000');
INSERT INTO `t_s_town` VALUES ('6472', '黑沟镇', '210681118000', '210681000000');
INSERT INTO `t_s_town` VALUES ('6473', '新农镇', '210681119000', '210681000000');
INSERT INTO `t_s_town` VALUES ('6474', '合隆满族乡', '210681206000', '210681000000');
INSERT INTO `t_s_town` VALUES ('6475', '示范农场', '210681401000', '210681000000');
INSERT INTO `t_s_town` VALUES ('6476', '黄土坎农场', '210681402000', '210681000000');
INSERT INTO `t_s_town` VALUES ('6477', '海洋红农场', '210681403000', '210681000000');
INSERT INTO `t_s_town` VALUES ('6478', '兴隆农场', '210681404000', '210681000000');
INSERT INTO `t_s_town` VALUES ('6479', '五四农场', '210681405000', '210681000000');
INSERT INTO `t_s_town` VALUES ('6480', '凤凰城街道', '210682001000', '210682000000');
INSERT INTO `t_s_town` VALUES ('6481', '凤山街道', '210682002000', '210682000000');
INSERT INTO `t_s_town` VALUES ('6482', '草河街道', '210682003000', '210682000000');
INSERT INTO `t_s_town` VALUES ('6483', '宝山镇', '210682101000', '210682000000');
INSERT INTO `t_s_town` VALUES ('6484', '白旗镇', '210682102000', '210682000000');
INSERT INTO `t_s_town` VALUES ('6485', '沙里寨镇', '210682103000', '210682000000');
INSERT INTO `t_s_town` VALUES ('6486', '红旗镇', '210682104000', '210682000000');
INSERT INTO `t_s_town` VALUES ('6487', '蓝旗镇', '210682105000', '210682000000');
INSERT INTO `t_s_town` VALUES ('6488', '边门镇', '210682107000', '210682000000');
INSERT INTO `t_s_town` VALUES ('6489', '东汤镇', '210682110000', '210682000000');
INSERT INTO `t_s_town` VALUES ('6490', '石城镇', '210682111000', '210682000000');
INSERT INTO `t_s_town` VALUES ('6491', '大兴镇', '210682112000', '210682000000');
INSERT INTO `t_s_town` VALUES ('6492', '爱阳镇', '210682113000', '210682000000');
INSERT INTO `t_s_town` VALUES ('6493', '赛马镇', '210682114000', '210682000000');
INSERT INTO `t_s_town` VALUES ('6494', '弟兄山镇', '210682115000', '210682000000');
INSERT INTO `t_s_town` VALUES ('6495', '鸡冠山镇', '210682116000', '210682000000');
INSERT INTO `t_s_town` VALUES ('6496', '刘家河镇', '210682117000', '210682000000');
INSERT INTO `t_s_town` VALUES ('6497', '通远堡镇', '210682118000', '210682000000');
INSERT INTO `t_s_town` VALUES ('6498', '四门子镇', '210682119000', '210682000000');
INSERT INTO `t_s_town` VALUES ('6499', '青城子镇', '210682120000', '210682000000');
INSERT INTO `t_s_town` VALUES ('6500', '大堡蒙古族乡', '210682200000', '210682000000');
INSERT INTO `t_s_town` VALUES ('6501', '天安街道', '210702001000', '210702000000');
INSERT INTO `t_s_town` VALUES ('6502', '石油街道', '210702002000', '210702000000');
INSERT INTO `t_s_town` VALUES ('6503', '北街街道', '210702003000', '210702000000');
INSERT INTO `t_s_town` VALUES ('6504', '敬业街道', '210702004000', '210702000000');
INSERT INTO `t_s_town` VALUES ('6505', '保安街道', '210702005000', '210702000000');
INSERT INTO `t_s_town` VALUES ('6506', '南街街道', '210702006000', '210702000000');
INSERT INTO `t_s_town` VALUES ('6507', '饶阳街道', '210702007000', '210702000000');
INSERT INTO `t_s_town` VALUES ('6508', '站前街道', '210702008000', '210702000000');
INSERT INTO `t_s_town` VALUES ('6509', '士英街道', '210702009000', '210702000000');
INSERT INTO `t_s_town` VALUES ('6510', '钟屯街道办事处', '210702010000', '210702000000');
INSERT INTO `t_s_town` VALUES ('6511', '正大街道', '210703001000', '210703000000');
INSERT INTO `t_s_town` VALUES ('6512', '石桥子街道', '210703002000', '210703000000');
INSERT INTO `t_s_town` VALUES ('6513', '龙江街道', '210703003000', '210703000000');
INSERT INTO `t_s_town` VALUES ('6514', '榴花街道', '210703004000', '210703000000');
INSERT INTO `t_s_town` VALUES ('6515', '铁新街道', '210703005000', '210703000000');
INSERT INTO `t_s_town` VALUES ('6516', '凌安街道', '210703006000', '210703000000');
INSERT INTO `t_s_town` VALUES ('6517', '菊园街道', '210703007000', '210703000000');
INSERT INTO `t_s_town` VALUES ('6518', '康宁街道', '210703008000', '210703000000');
INSERT INTO `t_s_town` VALUES ('6519', '锦铁街道', '210703009000', '210703000000');
INSERT INTO `t_s_town` VALUES ('6520', '马家洼子街道', '210703010000', '210703000000');
INSERT INTO `t_s_town` VALUES ('6521', '紫荆街道', '210703011000', '210703000000');
INSERT INTO `t_s_town` VALUES ('6522', '锦州北山农工商总公司', '210703403000', '210703000000');
INSERT INTO `t_s_town` VALUES ('6523', '太和街道', '210711001000', '210711000000');
INSERT INTO `t_s_town` VALUES ('6524', '兴隆街道', '210711002000', '210711000000');
INSERT INTO `t_s_town` VALUES ('6525', '汤河子街道', '210711003000', '210711000000');
INSERT INTO `t_s_town` VALUES ('6526', '凌西街道', '210711004000', '210711000000');
INSERT INTO `t_s_town` VALUES ('6527', '大薛街道', '210711007000', '210711000000');
INSERT INTO `t_s_town` VALUES ('6528', '女儿河街道办事处', '210711008000', '210711000000');
INSERT INTO `t_s_town` VALUES ('6529', '营盘街道办事处', '210711009000', '210711000000');
INSERT INTO `t_s_town` VALUES ('6530', '新民街道办事处', '210711010000', '210711000000');
INSERT INTO `t_s_town` VALUES ('6531', '王家街道', '210711070000', '210711000000');
INSERT INTO `t_s_town` VALUES ('6532', '天桥街道', '210711071000', '210711000000');
INSERT INTO `t_s_town` VALUES ('6533', '杏山街道', '210711072000', '210711000000');
INSERT INTO `t_s_town` VALUES ('6534', '娘娘宫街道办事处', '210711073000', '210711000000');
INSERT INTO `t_s_town` VALUES ('6535', '龙栖湾街道办事处', '210711074000', '210711000000');
INSERT INTO `t_s_town` VALUES ('6536', '凌南街道', '210711080000', '210711000000');
INSERT INTO `t_s_town` VALUES ('6537', '松山街道办事处', '210711081000', '210711000000');
INSERT INTO `t_s_town` VALUES ('6538', '锦州市果树农场', '210711480000', '210711000000');
INSERT INTO `t_s_town` VALUES ('6539', '黑山街道办事处', '210726001000', '210726000000');
INSERT INTO `t_s_town` VALUES ('6540', '大虎山街道办事处', '210726002000', '210726000000');
INSERT INTO `t_s_town` VALUES ('6541', '芳山镇', '210726101000', '210726000000');
INSERT INTO `t_s_town` VALUES ('6542', '白厂门镇', '210726102000', '210726000000');
INSERT INTO `t_s_town` VALUES ('6543', '常兴镇', '210726103000', '210726000000');
INSERT INTO `t_s_town` VALUES ('6544', '姜屯镇', '210726104000', '210726000000');
INSERT INTO `t_s_town` VALUES ('6545', '励家镇', '210726105000', '210726000000');
INSERT INTO `t_s_town` VALUES ('6546', '绕阳河镇', '210726106000', '210726000000');
INSERT INTO `t_s_town` VALUES ('6547', '半拉门镇', '210726107000', '210726000000');
INSERT INTO `t_s_town` VALUES ('6548', '无梁殿镇', '210726108000', '210726000000');
INSERT INTO `t_s_town` VALUES ('6549', '胡家镇', '210726109000', '210726000000');
INSERT INTO `t_s_town` VALUES ('6550', '新立屯镇', '210726110000', '210726000000');
INSERT INTO `t_s_town` VALUES ('6551', '八道壕镇', '210726111000', '210726000000');
INSERT INTO `t_s_town` VALUES ('6552', '四家子镇', '210726113000', '210726000000');
INSERT INTO `t_s_town` VALUES ('6553', '新兴镇', '210726114000', '210726000000');
INSERT INTO `t_s_town` VALUES ('6554', '太和镇', '210726116000', '210726000000');
INSERT INTO `t_s_town` VALUES ('6555', '镇安镇', '210726117000', '210726000000');
INSERT INTO `t_s_town` VALUES ('6556', '英城子乡', '210726201000', '210726000000');
INSERT INTO `t_s_town` VALUES ('6557', '段家乡', '210726209000', '210726000000');
INSERT INTO `t_s_town` VALUES ('6558', '大兴乡', '210726210000', '210726000000');
INSERT INTO `t_s_town` VALUES ('6559', '薛屯乡', '210726212000', '210726000000');
INSERT INTO `t_s_town` VALUES ('6560', '辽宁省锦州市小东种畜场', '210726400000', '210726000000');
INSERT INTO `t_s_town` VALUES ('6561', '义州街道办事处', '210727001000', '210727000000');
INSERT INTO `t_s_town` VALUES ('6562', '城关街道办事处', '210727002000', '210727000000');
INSERT INTO `t_s_town` VALUES ('6563', '刘龙台镇', '210727101000', '210727000000');
INSERT INTO `t_s_town` VALUES ('6564', '七里河镇', '210727102000', '210727000000');
INSERT INTO `t_s_town` VALUES ('6565', '大榆树堡镇', '210727103000', '210727000000');
INSERT INTO `t_s_town` VALUES ('6566', '稍户营子镇', '210727104000', '210727000000');
INSERT INTO `t_s_town` VALUES ('6567', '九道岭镇', '210727105000', '210727000000');
INSERT INTO `t_s_town` VALUES ('6568', '高台子镇', '210727106000', '210727000000');
INSERT INTO `t_s_town` VALUES ('6569', '瓦子峪镇', '210727108000', '210727000000');
INSERT INTO `t_s_town` VALUES ('6570', '头台镇', '210727109000', '210727000000');
INSERT INTO `t_s_town` VALUES ('6571', '前杨镇', '210727110000', '210727000000');
INSERT INTO `t_s_town` VALUES ('6572', '张家堡镇', '210727111000', '210727000000');
INSERT INTO `t_s_town` VALUES ('6573', '头道河镇', '210727112000', '210727000000');
INSERT INTO `t_s_town` VALUES ('6574', '留龙沟镇', '210727113000', '210727000000');
INSERT INTO `t_s_town` VALUES ('6575', '聚粮屯镇', '210727114000', '210727000000');
INSERT INTO `t_s_town` VALUES ('6576', '地藏寺满族乡', '210727203000', '210727000000');
INSERT INTO `t_s_town` VALUES ('6577', '大定堡满族乡', '210727205000', '210727000000');
INSERT INTO `t_s_town` VALUES ('6578', '白庙子乡', '210727207000', '210727000000');
INSERT INTO `t_s_town` VALUES ('6579', '大凌河街道', '210781001000', '210781000000');
INSERT INTO `t_s_town` VALUES ('6580', '金城街道', '210781002000', '210781000000');
INSERT INTO `t_s_town` VALUES ('6581', '八千街道办事处', '210781003000', '210781000000');
INSERT INTO `t_s_town` VALUES ('6582', '大有街道办事处', '210781004000', '210781000000');
INSERT INTO `t_s_town` VALUES ('6583', '石山镇', '210781101000', '210781000000');
INSERT INTO `t_s_town` VALUES ('6584', '余积镇', '210781102000', '210781000000');
INSERT INTO `t_s_town` VALUES ('6585', '双羊镇', '210781103000', '210781000000');
INSERT INTO `t_s_town` VALUES ('6586', '班吉塔镇', '210781104000', '210781000000');
INSERT INTO `t_s_town` VALUES ('6587', '沈家台镇', '210781105000', '210781000000');
INSERT INTO `t_s_town` VALUES ('6588', '三台子镇', '210781106000', '210781000000');
INSERT INTO `t_s_town` VALUES ('6589', '右卫满族镇', '210781107000', '210781000000');
INSERT INTO `t_s_town` VALUES ('6590', '阎家镇', '210781108000', '210781000000');
INSERT INTO `t_s_town` VALUES ('6591', '新庄子镇', '210781109000', '210781000000');
INSERT INTO `t_s_town` VALUES ('6592', '翠岩镇', '210781112000', '210781000000');
INSERT INTO `t_s_town` VALUES ('6593', '安屯镇', '210781113000', '210781000000');
INSERT INTO `t_s_town` VALUES ('6594', '大业镇', '210781114000', '210781000000');
INSERT INTO `t_s_town` VALUES ('6595', '建业镇', '210781116000', '210781000000');
INSERT INTO `t_s_town` VALUES ('6596', '温滴楼满族镇', '210781117000', '210781000000');
INSERT INTO `t_s_town` VALUES ('6597', '白台子镇', '210781118000', '210781000000');
INSERT INTO `t_s_town` VALUES ('6598', '板石沟乡', '210781212000', '210781000000');
INSERT INTO `t_s_town` VALUES ('6599', '谢屯乡', '210781217000', '210781000000');
INSERT INTO `t_s_town` VALUES ('6600', '辽宁省金城原种场', '210781401000', '210781000000');
INSERT INTO `t_s_town` VALUES ('6601', '北镇街道办事处', '210782004000', '210782000000');
INSERT INTO `t_s_town` VALUES ('6602', '富屯街道办事处', '210782006000', '210782000000');
INSERT INTO `t_s_town` VALUES ('6603', '广宁街道办事处', '210782007000', '210782000000');
INSERT INTO `t_s_town` VALUES ('6604', '沟帮子街道办事处', '210782008000', '210782000000');
INSERT INTO `t_s_town` VALUES ('6605', '沙子河街道办事处', '210782009000', '210782000000');
INSERT INTO `t_s_town` VALUES ('6606', '大市镇', '210782101000', '210782000000');
INSERT INTO `t_s_town` VALUES ('6607', '罗罗堡镇', '210782102000', '210782000000');
INSERT INTO `t_s_town` VALUES ('6608', '常兴店镇', '210782103000', '210782000000');
INSERT INTO `t_s_town` VALUES ('6609', '正安镇', '210782104000', '210782000000');
INSERT INTO `t_s_town` VALUES ('6610', '闾阳镇', '210782105000', '210782000000');
INSERT INTO `t_s_town` VALUES ('6611', '中安镇', '210782106000', '210782000000');
INSERT INTO `t_s_town` VALUES ('6612', '廖屯镇', '210782107000', '210782000000');
INSERT INTO `t_s_town` VALUES ('6613', '赵屯镇', '210782109000', '210782000000');
INSERT INTO `t_s_town` VALUES ('6614', '青堆子镇', '210782110000', '210782000000');
INSERT INTO `t_s_town` VALUES ('6615', '高山子镇', '210782111000', '210782000000');
INSERT INTO `t_s_town` VALUES ('6616', '吴家镇', '210782113000', '210782000000');
INSERT INTO `t_s_town` VALUES ('6617', '鲍家乡', '210782203000', '210782000000');
INSERT INTO `t_s_town` VALUES ('6618', '大屯乡', '210782206000', '210782000000');
INSERT INTO `t_s_town` VALUES ('6619', '柳家乡', '210782209000', '210782000000');
INSERT INTO `t_s_town` VALUES ('6620', '辽宁省北镇市高山子监狱', '210782402000', '210782000000');
INSERT INTO `t_s_town` VALUES ('6621', '新立农场', '210782403000', '210782000000');
INSERT INTO `t_s_town` VALUES ('6622', '八田地街道', '210802001000', '210802000000');
INSERT INTO `t_s_town` VALUES ('6623', '建丰街道', '210802002000', '210802000000');
INSERT INTO `t_s_town` VALUES ('6624', '建设街道', '210802003000', '210802000000');
INSERT INTO `t_s_town` VALUES ('6625', '跃进街道', '210802004000', '210802000000');
INSERT INTO `t_s_town` VALUES ('6626', '东风街道', '210802005000', '210802000000');
INSERT INTO `t_s_town` VALUES ('6627', '新兴街道', '210802006000', '210802000000');
INSERT INTO `t_s_town` VALUES ('6628', '新建街道', '210802007000', '210802000000');
INSERT INTO `t_s_town` VALUES ('6629', '营口高新区站前区工业园', '210802401000', '210802000000');
INSERT INTO `t_s_town` VALUES ('6630', '胜利街道', '210803001000', '210803000000');
INSERT INTO `t_s_town` VALUES ('6631', '清华街道', '210803002000', '210803000000');
INSERT INTO `t_s_town` VALUES ('6632', '滨海街道', '210803003000', '210803000000');
INSERT INTO `t_s_town` VALUES ('6633', '得胜街道', '210803004000', '210803000000');
INSERT INTO `t_s_town` VALUES ('6634', '五台子街道', '210803005000', '210803000000');
INSERT INTO `t_s_town` VALUES ('6635', '渔市街道', '210803006000', '210803000000');
INSERT INTO `t_s_town` VALUES ('6636', '河北街道', '210803007000', '210803000000');
INSERT INTO `t_s_town` VALUES ('6637', '沿海街道', '210803008000', '210803000000');
INSERT INTO `t_s_town` VALUES ('6638', '辽宁自贸区营口片区', '210803400000', '210803000000');
INSERT INTO `t_s_town` VALUES ('6639', '辽宁（营口）沿海产业基地', '210803401000', '210803000000');
INSERT INTO `t_s_town` VALUES ('6640', '红海街道', '210804001000', '210804000000');
INSERT INTO `t_s_town` VALUES ('6641', '海星街道', '210804002000', '210804000000');
INSERT INTO `t_s_town` VALUES ('6642', '望海街道', '210804003000', '210804000000');
INSERT INTO `t_s_town` VALUES ('6643', '海东街道', '210804004000', '210804000000');
INSERT INTO `t_s_town` VALUES ('6644', '熊岳镇', '210804100000', '210804000000');
INSERT INTO `t_s_town` VALUES ('6645', '芦屯镇', '210804101000', '210804000000');
INSERT INTO `t_s_town` VALUES ('6646', '红旗满族镇', '210804102000', '210804000000');
INSERT INTO `t_s_town` VALUES ('6647', '老边街道', '210811001000', '210811000000');
INSERT INTO `t_s_town` VALUES ('6648', '城东街道', '210811002000', '210811000000');
INSERT INTO `t_s_town` VALUES ('6649', '路南镇', '210811101000', '210811000000');
INSERT INTO `t_s_town` VALUES ('6650', '柳树镇', '210811102000', '210811000000');
INSERT INTO `t_s_town` VALUES ('6651', '边城镇', '210811103000', '210811000000');
INSERT INTO `t_s_town` VALUES ('6652', '营口辽河经济开发区', '210811400000', '210811000000');
INSERT INTO `t_s_town` VALUES ('6653', '鼓楼街道', '210881001000', '210881000000');
INSERT INTO `t_s_town` VALUES ('6654', '西城街道', '210881002000', '210881000000');
INSERT INTO `t_s_town` VALUES ('6655', '东城街道', '210881003000', '210881000000');
INSERT INTO `t_s_town` VALUES ('6656', '太阳升街道', '210881004000', '210881000000');
INSERT INTO `t_s_town` VALUES ('6657', '团山街道', '210881005000', '210881000000');
INSERT INTO `t_s_town` VALUES ('6658', '西海街道', '210881006000', '210881000000');
INSERT INTO `t_s_town` VALUES ('6659', '九垄地街道', '210881007000', '210881000000');
INSERT INTO `t_s_town` VALUES ('6660', '归州街道', '210881008000', '210881000000');
INSERT INTO `t_s_town` VALUES ('6661', '高屯镇', '210881102000', '210881000000');
INSERT INTO `t_s_town` VALUES ('6662', '沙岗镇', '210881105000', '210881000000');
INSERT INTO `t_s_town` VALUES ('6663', '九寨镇', '210881109000', '210881000000');
INSERT INTO `t_s_town` VALUES ('6664', '万福镇', '210881110000', '210881000000');
INSERT INTO `t_s_town` VALUES ('6665', '卧龙泉镇', '210881111000', '210881000000');
INSERT INTO `t_s_town` VALUES ('6666', '青石岭镇', '210881112000', '210881000000');
INSERT INTO `t_s_town` VALUES ('6667', '暖泉镇', '210881113000', '210881000000');
INSERT INTO `t_s_town` VALUES ('6668', '榜式堡镇', '210881116000', '210881000000');
INSERT INTO `t_s_town` VALUES ('6669', '团甸镇', '210881117000', '210881000000');
INSERT INTO `t_s_town` VALUES ('6670', '双台镇', '210881118000', '210881000000');
INSERT INTO `t_s_town` VALUES ('6671', '杨运镇', '210881119000', '210881000000');
INSERT INTO `t_s_town` VALUES ('6672', '徐屯镇', '210881120000', '210881000000');
INSERT INTO `t_s_town` VALUES ('6673', '什字街镇', '210881121000', '210881000000');
INSERT INTO `t_s_town` VALUES ('6674', '矿洞沟镇', '210881122000', '210881000000');
INSERT INTO `t_s_town` VALUES ('6675', '陈屯镇', '210881123000', '210881000000');
INSERT INTO `t_s_town` VALUES ('6676', '梁屯镇', '210881124000', '210881000000');
INSERT INTO `t_s_town` VALUES ('6677', '小石棚乡', '210881216000', '210881000000');
INSERT INTO `t_s_town` VALUES ('6678', '果园乡', '210881217000', '210881000000');
INSERT INTO `t_s_town` VALUES ('6679', '二台乡', '210881218000', '210881000000');
INSERT INTO `t_s_town` VALUES ('6680', '石桥街道', '210882001000', '210882000000');
INSERT INTO `t_s_town` VALUES ('6681', '青花街道', '210882002000', '210882000000');
INSERT INTO `t_s_town` VALUES ('6682', '金桥街道', '210882003000', '210882000000');
INSERT INTO `t_s_town` VALUES ('6683', '钢都街道', '210882004000', '210882000000');
INSERT INTO `t_s_town` VALUES ('6684', '百寨街道', '210882005000', '210882000000');
INSERT INTO `t_s_town` VALUES ('6685', '水源镇', '210882101000', '210882000000');
INSERT INTO `t_s_town` VALUES ('6686', '沟沿镇', '210882102000', '210882000000');
INSERT INTO `t_s_town` VALUES ('6687', '石佛镇', '210882103000', '210882000000');
INSERT INTO `t_s_town` VALUES ('6688', '高坎镇', '210882104000', '210882000000');
INSERT INTO `t_s_town` VALUES ('6689', '旗口镇', '210882105000', '210882000000');
INSERT INTO `t_s_town` VALUES ('6690', '虎庄镇', '210882106000', '210882000000');
INSERT INTO `t_s_town` VALUES ('6691', '官屯镇', '210882107000', '210882000000');
INSERT INTO `t_s_town` VALUES ('6692', '博洛铺镇', '210882112000', '210882000000');
INSERT INTO `t_s_town` VALUES ('6693', '永安镇', '210882113000', '210882000000');
INSERT INTO `t_s_town` VALUES ('6694', '汤池镇', '210882114000', '210882000000');
INSERT INTO `t_s_town` VALUES ('6695', '建一镇', '210882115000', '210882000000');
INSERT INTO `t_s_town` VALUES ('6696', '黄土岭镇', '210882116000', '210882000000');
INSERT INTO `t_s_town` VALUES ('6697', '周家镇', '210882117000', '210882000000');
INSERT INTO `t_s_town` VALUES ('6698', '大石桥市水稻良种场', '210882400000', '210882000000');
INSERT INTO `t_s_town` VALUES ('6699', '大石桥市示范场', '210882401000', '210882000000');
INSERT INTO `t_s_town` VALUES ('6700', '新兴街道', '210902002000', '210902000000');
INSERT INTO `t_s_town` VALUES ('6701', '和平街道', '210902003000', '210902000000');
INSERT INTO `t_s_town` VALUES ('6702', '西山街道', '210902004000', '210902000000');
INSERT INTO `t_s_town` VALUES ('6703', '河北街道', '210902005000', '210902000000');
INSERT INTO `t_s_town` VALUES ('6704', '站前街道', '210902006000', '210902000000');
INSERT INTO `t_s_town` VALUES ('6705', '西阜新街道', '210902007000', '210902000000');
INSERT INTO `t_s_town` VALUES ('6706', '五龙街道', '210902008000', '210902000000');
INSERT INTO `t_s_town` VALUES ('6707', '平安西部街道', '210902009000', '210902000000');
INSERT INTO `t_s_town` VALUES ('6708', '工人村街道', '210902010000', '210902000000');
INSERT INTO `t_s_town` VALUES ('6709', '东梁街道', '210902011000', '210902000000');
INSERT INTO `t_s_town` VALUES ('6710', '韩家店镇', '210902101000', '210902000000');
INSERT INTO `t_s_town` VALUES ('6711', '兴隆街道', '210903001000', '210903000000');
INSERT INTO `t_s_town` VALUES ('6712', '中兴街道', '210903002000', '210903000000');
INSERT INTO `t_s_town` VALUES ('6713', '益民街道', '210903003000', '210903000000');
INSERT INTO `t_s_town` VALUES ('6714', '新发街道', '210903004000', '210903000000');
INSERT INTO `t_s_town` VALUES ('6715', '长营子蒙古族镇', '210903101000', '210903000000');
INSERT INTO `t_s_town` VALUES ('6716', '红树街道', '210904001000', '210904000000');
INSERT INTO `t_s_town` VALUES ('6717', '煤海街道', '210904002000', '210904000000');
INSERT INTO `t_s_town` VALUES ('6718', '高德街道', '210904003000', '210904000000');
INSERT INTO `t_s_town` VALUES ('6719', '孙家湾街道', '210904004000', '210904000000');
INSERT INTO `t_s_town` VALUES ('6720', '城南街道', '210904005000', '210904000000');
INSERT INTO `t_s_town` VALUES ('6721', '水泉镇', '210904101000', '210904000000');
INSERT INTO `t_s_town` VALUES ('6722', '清河街道', '210905001000', '210905000000');
INSERT INTO `t_s_town` VALUES ('6723', '六台街道', '210905002000', '210905000000');
INSERT INTO `t_s_town` VALUES ('6724', '艾友街道', '210905003000', '210905000000');
INSERT INTO `t_s_town` VALUES ('6725', '新北街道', '210905004000', '210905000000');
INSERT INTO `t_s_town` VALUES ('6726', '河西镇', '210905101000', '210905000000');
INSERT INTO `t_s_town` VALUES ('6727', '乌龙坝镇', '210905102000', '210905000000');
INSERT INTO `t_s_town` VALUES ('6728', '西苑街道', '210911001000', '210911000000');
INSERT INTO `t_s_town` VALUES ('6729', '北苑街道', '210911002000', '210911000000');
INSERT INTO `t_s_town` VALUES ('6730', '东苑街道', '210911003000', '210911000000');
INSERT INTO `t_s_town` VALUES ('6731', '学苑街道', '210911004000', '210911000000');
INSERT INTO `t_s_town` VALUES ('6732', '中苑街道', '210911005000', '210911000000');
INSERT INTO `t_s_town` VALUES ('6733', '华东街道', '210911006000', '210911000000');
INSERT INTO `t_s_town` VALUES ('6734', '四合镇', '210911102000', '210911000000');
INSERT INTO `t_s_town` VALUES ('6735', '六家子管委会', '210911401000', '210911000000');
INSERT INTO `t_s_town` VALUES ('6736', '城区街道办事处', '210921001000', '210921000000');
INSERT INTO `t_s_town` VALUES ('6737', '阜新镇', '210921100000', '210921000000');
INSERT INTO `t_s_town` VALUES ('6738', '东梁镇', '210921102000', '210921000000');
INSERT INTO `t_s_town` VALUES ('6739', '佛寺镇', '210921103000', '210921000000');
INSERT INTO `t_s_town` VALUES ('6740', '伊吗图镇', '210921104000', '210921000000');
INSERT INTO `t_s_town` VALUES ('6741', '旧庙镇', '210921105000', '210921000000');
INSERT INTO `t_s_town` VALUES ('6742', '务欢池镇', '210921106000', '210921000000');
INSERT INTO `t_s_town` VALUES ('6743', '建设镇', '210921107000', '210921000000');
INSERT INTO `t_s_town` VALUES ('6744', '大巴镇', '210921108000', '210921000000');
INSERT INTO `t_s_town` VALUES ('6745', '泡子镇', '210921109000', '210921000000');
INSERT INTO `t_s_town` VALUES ('6746', '十家子镇', '210921110000', '210921000000');
INSERT INTO `t_s_town` VALUES ('6747', '王府镇', '210921111000', '210921000000');
INSERT INTO `t_s_town` VALUES ('6748', '于寺镇', '210921112000', '210921000000');
INSERT INTO `t_s_town` VALUES ('6749', '富荣镇', '210921113000', '210921000000');
INSERT INTO `t_s_town` VALUES ('6750', '新民镇', '210921114000', '210921000000');
INSERT INTO `t_s_town` VALUES ('6751', '福兴地镇', '210921115000', '210921000000');
INSERT INTO `t_s_town` VALUES ('6752', '平安地镇', '210921116000', '210921000000');
INSERT INTO `t_s_town` VALUES ('6753', '沙拉镇', '210921117000', '210921000000');
INSERT INTO `t_s_town` VALUES ('6754', '大固本镇', '210921118000', '210921000000');
INSERT INTO `t_s_town` VALUES ('6755', '大五家子镇', '210921119000', '210921000000');
INSERT INTO `t_s_town` VALUES ('6756', '大板镇', '210921120000', '210921000000');
INSERT INTO `t_s_town` VALUES ('6757', '招束沟镇', '210921121000', '210921000000');
INSERT INTO `t_s_town` VALUES ('6758', '八家子镇', '210921122000', '210921000000');
INSERT INTO `t_s_town` VALUES ('6759', '蜘蛛山镇', '210921123000', '210921000000');
INSERT INTO `t_s_town` VALUES ('6760', '塔营子镇', '210921124000', '210921000000');
INSERT INTO `t_s_town` VALUES ('6761', '扎兰营子镇', '210921125000', '210921000000');
INSERT INTO `t_s_town` VALUES ('6762', '七家子镇', '210921126000', '210921000000');
INSERT INTO `t_s_town` VALUES ('6763', '红帽子镇', '210921127000', '210921000000');
INSERT INTO `t_s_town` VALUES ('6764', '紫都台镇', '210921128000', '210921000000');
INSERT INTO `t_s_town` VALUES ('6765', '化石戈镇', '210921129000', '210921000000');
INSERT INTO `t_s_town` VALUES ('6766', '哈达户稍镇', '210921130000', '210921000000');
INSERT INTO `t_s_town` VALUES ('6767', '老河土镇', '210921131000', '210921000000');
INSERT INTO `t_s_town` VALUES ('6768', '太平镇', '210921132000', '210921000000');
INSERT INTO `t_s_town` VALUES ('6769', '卧凤沟乡', '210921203000', '210921000000');
INSERT INTO `t_s_town` VALUES ('6770', '苍土乡', '210921211000', '210921000000');
INSERT INTO `t_s_town` VALUES ('6771', '国华乡', '210921222000', '210921000000');
INSERT INTO `t_s_town` VALUES ('6772', '泡子农场办事处', '210921401000', '210921000000');
INSERT INTO `t_s_town` VALUES ('6773', '彰武镇', '210922100000', '210922000000');
INSERT INTO `t_s_town` VALUES ('6774', '哈尔套镇', '210922101000', '210922000000');
INSERT INTO `t_s_town` VALUES ('6775', '章古台镇', '210922102000', '210922000000');
INSERT INTO `t_s_town` VALUES ('6776', '五峰镇', '210922103000', '210922000000');
INSERT INTO `t_s_town` VALUES ('6777', '冯家镇', '210922104000', '210922000000');
INSERT INTO `t_s_town` VALUES ('6778', '后新秋镇', '210922105000', '210922000000');
INSERT INTO `t_s_town` VALUES ('6779', '东六家子镇', '210922106000', '210922000000');
INSERT INTO `t_s_town` VALUES ('6780', '阿尔乡镇', '210922107000', '210922000000');
INSERT INTO `t_s_town` VALUES ('6781', '前福兴地镇', '210922108000', '210922000000');
INSERT INTO `t_s_town` VALUES ('6782', '双庙镇', '210922109000', '210922000000');
INSERT INTO `t_s_town` VALUES ('6783', '大四家子镇', '210922110000', '210922000000');
INSERT INTO `t_s_town` VALUES ('6784', '苇子沟镇', '210922111000', '210922000000');
INSERT INTO `t_s_town` VALUES ('6785', '兴隆山镇', '210922112000', '210922000000');
INSERT INTO `t_s_town` VALUES ('6786', '满堂红镇', '210922113000', '210922000000');
INSERT INTO `t_s_town` VALUES ('6787', '四合城镇', '210922114000', '210922000000');
INSERT INTO `t_s_town` VALUES ('6788', '大冷蒙古族镇', '210922115000', '210922000000');
INSERT INTO `t_s_town` VALUES ('6789', '两家子镇', '210922116000', '210922000000');
INSERT INTO `t_s_town` VALUES ('6790', '平安镇', '210922117000', '210922000000');
INSERT INTO `t_s_town` VALUES ('6791', '四堡子镇', '210922118000', '210922000000');
INSERT INTO `t_s_town` VALUES ('6792', '西六家子镇', '210922119000', '210922000000');
INSERT INTO `t_s_town` VALUES ('6793', '大德镇', '210922120000', '210922000000');
INSERT INTO `t_s_town` VALUES ('6794', '兴隆堡镇', '210922121000', '210922000000');
INSERT INTO `t_s_town` VALUES ('6795', '二道河子蒙古族乡', '210922202000', '210922000000');
INSERT INTO `t_s_town` VALUES ('6796', '丰田乡', '210922209000', '210922000000');
INSERT INTO `t_s_town` VALUES ('6797', '星火街道办事处', '211002001000', '211002000000');
INSERT INTO `t_s_town` VALUES ('6798', '胜利街道办事处', '211002002000', '211002000000');
INSERT INTO `t_s_town` VALUES ('6799', '跃进街道办事处', '211002003000', '211002000000');
INSERT INTO `t_s_town` VALUES ('6800', '卫国路街道办事处', '211002005000', '211002000000');
INSERT INTO `t_s_town` VALUES ('6801', '站前街道办事处', '211002006000', '211002000000');
INSERT INTO `t_s_town` VALUES ('6802', '武圣街道办事处', '211002010000', '211002000000');
INSERT INTO `t_s_town` VALUES ('6803', '襄平街道办事处', '211002011000', '211002000000');
INSERT INTO `t_s_town` VALUES ('6804', '文圣街道办事处', '211002012000', '211002000000');
INSERT INTO `t_s_town` VALUES ('6805', '南门街道办事处', '211002013000', '211002000000');
INSERT INTO `t_s_town` VALUES ('6806', '东兴街道办事处', '211002014000', '211002000000');
INSERT INTO `t_s_town` VALUES ('6807', '新华街道办事处', '211002015000', '211002000000');
INSERT INTO `t_s_town` VALUES ('6808', '庆阳街道办事处', '211003004000', '211003000000');
INSERT INTO `t_s_town` VALUES ('6809', '东京陵街道办事处', '211003008000', '211003000000');
INSERT INTO `t_s_town` VALUES ('6810', '新城街道办事处', '211003009000', '211003000000');
INSERT INTO `t_s_town` VALUES ('6811', '小屯镇', '211003101000', '211003000000');
INSERT INTO `t_s_town` VALUES ('6812', '罗大台镇', '211003102000', '211003000000');
INSERT INTO `t_s_town` VALUES ('6813', '工农街道办事处', '211004001000', '211004000000');
INSERT INTO `t_s_town` VALUES ('6814', '光华街道办事处', '211004002000', '211004000000');
INSERT INTO `t_s_town` VALUES ('6815', '新村街道办事处', '211004003000', '211004000000');
INSERT INTO `t_s_town` VALUES ('6816', '长征街道办事处', '211004004000', '211004000000');
INSERT INTO `t_s_town` VALUES ('6817', '曙光镇', '211004101000', '211004000000');
INSERT INTO `t_s_town` VALUES ('6818', '兰家镇', '211004102000', '211004000000');
INSERT INTO `t_s_town` VALUES ('6819', '苏家街道办事处', '211005001000', '211005000000');
INSERT INTO `t_s_town` VALUES ('6820', '团山街道办事处', '211005002000', '211005000000');
INSERT INTO `t_s_town` VALUES ('6821', '安平街道办事处', '211005003000', '211005000000');
INSERT INTO `t_s_town` VALUES ('6822', '汤河镇', '211005101000', '211005000000');
INSERT INTO `t_s_town` VALUES ('6823', '安平乡', '211005201000', '211005000000');
INSERT INTO `t_s_town` VALUES ('6824', '望水台街道办事处', '211011002000', '211011000000');
INSERT INTO `t_s_town` VALUES ('6825', '铁西街道办事处', '211011003000', '211011000000');
INSERT INTO `t_s_town` VALUES ('6826', '祁家镇', '211011101000', '211011000000');
INSERT INTO `t_s_town` VALUES ('6827', '沙岭镇', '211011102000', '211011000000');
INSERT INTO `t_s_town` VALUES ('6828', '王家镇', '211011103000', '211011000000');
INSERT INTO `t_s_town` VALUES ('6829', '东宁卫乡', '211011204000', '211011000000');
INSERT INTO `t_s_town` VALUES ('6830', '首山镇', '211021100000', '211021000000');
INSERT INTO `t_s_town` VALUES ('6831', '刘二堡镇', '211021101000', '211021000000');
INSERT INTO `t_s_town` VALUES ('6832', '小北河镇', '211021103000', '211021000000');
INSERT INTO `t_s_town` VALUES ('6833', '黄泥洼镇', '211021104000', '211021000000');
INSERT INTO `t_s_town` VALUES ('6834', '唐马寨镇', '211021106000', '211021000000');
INSERT INTO `t_s_town` VALUES ('6835', '穆家镇', '211021107000', '211021000000');
INSERT INTO `t_s_town` VALUES ('6836', '柳壕镇', '211021108000', '211021000000');
INSERT INTO `t_s_town` VALUES ('6837', '河栏镇', '211021110000', '211021000000');
INSERT INTO `t_s_town` VALUES ('6838', '隆昌镇', '211021111000', '211021000000');
INSERT INTO `t_s_town` VALUES ('6839', '八会镇', '211021112000', '211021000000');
INSERT INTO `t_s_town` VALUES ('6840', '寒岭镇', '211021113000', '211021000000');
INSERT INTO `t_s_town` VALUES ('6841', '兴隆镇', '211021114000', '211021000000');
INSERT INTO `t_s_town` VALUES ('6842', '下达河乡', '211021201000', '211021000000');
INSERT INTO `t_s_town` VALUES ('6843', '吉洞峪满族乡', '211021202000', '211021000000');
INSERT INTO `t_s_town` VALUES ('6844', '甜水满族乡', '211021206000', '211021000000');
INSERT INTO `t_s_town` VALUES ('6845', '烟台街道办事处', '211081001000', '211081000000');
INSERT INTO `t_s_town` VALUES ('6846', '万宝桥街道办事处', '211081002000', '211081000000');
INSERT INTO `t_s_town` VALUES ('6847', '古城子街道办事处', '211081003000', '211081000000');
INSERT INTO `t_s_town` VALUES ('6848', '佟二堡镇', '211081101000', '211081000000');
INSERT INTO `t_s_town` VALUES ('6849', '铧子镇', '211081102000', '211081000000');
INSERT INTO `t_s_town` VALUES ('6850', '张台子镇', '211081103000', '211081000000');
INSERT INTO `t_s_town` VALUES ('6851', '西大窑镇', '211081104000', '211081000000');
INSERT INTO `t_s_town` VALUES ('6852', '沈旦堡镇', '211081105000', '211081000000');
INSERT INTO `t_s_town` VALUES ('6853', '西马峰镇', '211081106000', '211081000000');
INSERT INTO `t_s_town` VALUES ('6854', '柳条寨镇', '211081107000', '211081000000');
INSERT INTO `t_s_town` VALUES ('6855', '柳河子镇', '211081108000', '211081000000');
INSERT INTO `t_s_town` VALUES ('6856', '大河南镇', '211081111000', '211081000000');
INSERT INTO `t_s_town` VALUES ('6857', '五星镇', '211081114000', '211081000000');
INSERT INTO `t_s_town` VALUES ('6858', '鸡冠山乡', '211081205000', '211081000000');
INSERT INTO `t_s_town` VALUES ('6859', '胜利街道', '211102002000', '211102000000');
INSERT INTO `t_s_town` VALUES ('6860', '建设街道', '211102003000', '211102000000');
INSERT INTO `t_s_town` VALUES ('6861', '红旗街道', '211102004000', '211102000000');
INSERT INTO `t_s_town` VALUES ('6862', '辽河街道', '211102005000', '211102000000');
INSERT INTO `t_s_town` VALUES ('6863', '铁东街道', '211102008000', '211102000000');
INSERT INTO `t_s_town` VALUES ('6864', '双盛街道', '211102009000', '211102000000');
INSERT INTO `t_s_town` VALUES ('6865', '统一镇', '211102100000', '211102000000');
INSERT INTO `t_s_town` VALUES ('6866', '陆家镇', '211102101000', '211102000000');
INSERT INTO `t_s_town` VALUES ('6867', '振兴街道', '211103001000', '211103000000');
INSERT INTO `t_s_town` VALUES ('6868', '兴隆街道', '211103002000', '211103000000');
INSERT INTO `t_s_town` VALUES ('6869', '渤海街道', '211103003000', '211103000000');
INSERT INTO `t_s_town` VALUES ('6870', '新工街道', '211103004000', '211103000000');
INSERT INTO `t_s_town` VALUES ('6871', '友谊街道', '211103006000', '211103000000');
INSERT INTO `t_s_town` VALUES ('6872', '曙光街道', '211103007000', '211103000000');
INSERT INTO `t_s_town` VALUES ('6873', '欢喜街道', '211103008000', '211103000000');
INSERT INTO `t_s_town` VALUES ('6874', '平安街道', '211103009000', '211103000000');
INSERT INTO `t_s_town` VALUES ('6875', '新生街道', '211103010000', '211103000000');
INSERT INTO `t_s_town` VALUES ('6876', '高升街道', '211103012000', '211103000000');
INSERT INTO `t_s_town` VALUES ('6877', '沈采街道', '211103013000', '211103000000');
INSERT INTO `t_s_town` VALUES ('6878', '锦采街道', '211103014000', '211103000000');
INSERT INTO `t_s_town` VALUES ('6879', '茨采街道', '211103015000', '211103000000');
INSERT INTO `t_s_town` VALUES ('6880', '创新街道', '211103016000', '211103000000');
INSERT INTO `t_s_town` VALUES ('6881', '兴盛街道', '211103017000', '211103000000');
INSERT INTO `t_s_town` VALUES ('6882', '兴海街道', '211103018000', '211103000000');
INSERT INTO `t_s_town` VALUES ('6883', '惠宾街道', '211103019000', '211103000000');
INSERT INTO `t_s_town` VALUES ('6884', '荣滨街道', '211104001000', '211104000000');
INSERT INTO `t_s_town` VALUES ('6885', '二界沟街道', '211104002000', '211104000000');
INSERT INTO `t_s_town` VALUES ('6886', '荣兴街道', '211104003000', '211104000000');
INSERT INTO `t_s_town` VALUES ('6887', '大洼街道', '211104004000', '211104000000');
INSERT INTO `t_s_town` VALUES ('6888', '田家街道', '211104005000', '211104000000');
INSERT INTO `t_s_town` VALUES ('6889', '榆树街道', '211104006000', '211104000000');
INSERT INTO `t_s_town` VALUES ('6890', '王家街道', '211104007000', '211104000000');
INSERT INTO `t_s_town` VALUES ('6891', '于楼街道', '211104009000', '211104000000');
INSERT INTO `t_s_town` VALUES ('6892', '田庄台镇', '211104101000', '211104000000');
INSERT INTO `t_s_town` VALUES ('6893', '东风镇', '211104103000', '211104000000');
INSERT INTO `t_s_town` VALUES ('6894', '新开镇', '211104104000', '211104000000');
INSERT INTO `t_s_town` VALUES ('6895', '清水镇', '211104106000', '211104000000');
INSERT INTO `t_s_town` VALUES ('6896', '新兴镇', '211104107000', '211104000000');
INSERT INTO `t_s_town` VALUES ('6897', '西安镇', '211104108000', '211104000000');
INSERT INTO `t_s_town` VALUES ('6898', '新立镇', '211104109000', '211104000000');
INSERT INTO `t_s_town` VALUES ('6899', '唐家镇', '211104112000', '211104000000');
INSERT INTO `t_s_town` VALUES ('6900', '平安镇', '211104113000', '211104000000');
INSERT INTO `t_s_town` VALUES ('6901', '赵圈河镇', '211104114000', '211104000000');
INSERT INTO `t_s_town` VALUES ('6902', '太平街道', '211122001000', '211122000000');
INSERT INTO `t_s_town` VALUES ('6903', '高升街道', '211122002000', '211122000000');
INSERT INTO `t_s_town` VALUES ('6904', '得胜街道', '211122003000', '211122000000');
INSERT INTO `t_s_town` VALUES ('6905', '沙岭镇', '211122101000', '211122000000');
INSERT INTO `t_s_town` VALUES ('6906', '胡家镇', '211122103000', '211122000000');
INSERT INTO `t_s_town` VALUES ('6907', '石新镇', '211122104000', '211122000000');
INSERT INTO `t_s_town` VALUES ('6908', '东郭镇', '211122105000', '211122000000');
INSERT INTO `t_s_town` VALUES ('6909', '羊圈子镇', '211122106000', '211122000000');
INSERT INTO `t_s_town` VALUES ('6910', '古城子镇', '211122107000', '211122000000');
INSERT INTO `t_s_town` VALUES ('6911', '坝墙子镇', '211122108000', '211122000000');
INSERT INTO `t_s_town` VALUES ('6912', '陈家镇', '211122110000', '211122000000');
INSERT INTO `t_s_town` VALUES ('6913', '甜水镇', '211122111000', '211122000000');
INSERT INTO `t_s_town` VALUES ('6914', '吴家镇', '211122112000', '211122000000');
INSERT INTO `t_s_town` VALUES ('6915', '盘山县林场', '211122400000', '211122000000');
INSERT INTO `t_s_town` VALUES ('6916', '红旗街道', '211202001000', '211202000000');
INSERT INTO `t_s_town` VALUES ('6917', '工人街道', '211202002000', '211202000000');
INSERT INTO `t_s_town` VALUES ('6918', '铁西街道', '211202003000', '211202000000');
INSERT INTO `t_s_town` VALUES ('6919', '铜钟街道', '211202004000', '211202000000');
INSERT INTO `t_s_town` VALUES ('6920', '柴河街道', '211202005000', '211202000000');
INSERT INTO `t_s_town` VALUES ('6921', '岭东街道', '211202006000', '211202000000');
INSERT INTO `t_s_town` VALUES ('6922', '辽海街道', '211202007000', '211202000000');
INSERT INTO `t_s_town` VALUES ('6923', '龙山乡', '211202201000', '211202000000');
INSERT INTO `t_s_town` VALUES ('6924', '铁岭经济开发区', '211202401000', '211202000000');
INSERT INTO `t_s_town` VALUES ('6925', '红旗街道', '211204001000', '211204000000');
INSERT INTO `t_s_town` VALUES ('6926', '向阳街道', '211204002000', '211204000000');
INSERT INTO `t_s_town` VALUES ('6927', '张相镇', '211204101000', '211204000000');
INSERT INTO `t_s_town` VALUES ('6928', '杨木林子镇', '211204102000', '211204000000');
INSERT INTO `t_s_town` VALUES ('6929', '聂家满族乡', '211204203000', '211204000000');
INSERT INTO `t_s_town` VALUES ('6930', '新台子镇', '211221101000', '211221000000');
INSERT INTO `t_s_town` VALUES ('6931', '阿吉镇', '211221102000', '211221000000');
INSERT INTO `t_s_town` VALUES ('6932', '平顶堡镇', '211221103000', '211221000000');
INSERT INTO `t_s_town` VALUES ('6933', '大甸子镇', '211221104000', '211221000000');
INSERT INTO `t_s_town` VALUES ('6934', '凡河镇', '211221105000', '211221000000');
INSERT INTO `t_s_town` VALUES ('6935', '腰堡镇', '211221106000', '211221000000');
INSERT INTO `t_s_town` VALUES ('6936', '镇西堡镇', '211221107000', '211221000000');
INSERT INTO `t_s_town` VALUES ('6937', '蔡牛镇', '211221108000', '211221000000');
INSERT INTO `t_s_town` VALUES ('6938', '李千户镇', '211221109000', '211221000000');
INSERT INTO `t_s_town` VALUES ('6939', '熊官屯镇', '211221110000', '211221000000');
INSERT INTO `t_s_town` VALUES ('6940', '横道河子镇', '211221111000', '211221000000');
INSERT INTO `t_s_town` VALUES ('6941', '双井子镇', '211221112000', '211221000000');
INSERT INTO `t_s_town` VALUES ('6942', '鸡冠山乡', '211221208000', '211221000000');
INSERT INTO `t_s_town` VALUES ('6943', '白旗寨满族乡', '211221209000', '211221000000');
INSERT INTO `t_s_town` VALUES ('6944', '种畜场', '211221401000', '211221000000');
INSERT INTO `t_s_town` VALUES ('6945', '西丰镇', '211223100000', '211223000000');
INSERT INTO `t_s_town` VALUES ('6946', '平岗镇', '211223101000', '211223000000');
INSERT INTO `t_s_town` VALUES ('6947', '郜家店镇', '211223102000', '211223000000');
INSERT INTO `t_s_town` VALUES ('6948', '凉泉镇', '211223103000', '211223000000');
INSERT INTO `t_s_town` VALUES ('6949', '振兴镇', '211223104000', '211223000000');
INSERT INTO `t_s_town` VALUES ('6950', '安民镇', '211223105000', '211223000000');
INSERT INTO `t_s_town` VALUES ('6951', '天德镇', '211223106000', '211223000000');
INSERT INTO `t_s_town` VALUES ('6952', '房木镇', '211223107000', '211223000000');
INSERT INTO `t_s_town` VALUES ('6953', '柏榆镇', '211223108000', '211223000000');
INSERT INTO `t_s_town` VALUES ('6954', '陶然镇', '211223109000', '211223000000');
INSERT INTO `t_s_town` VALUES ('6955', '钓鱼镇', '211223110000', '211223000000');
INSERT INTO `t_s_town` VALUES ('6956', '更刻镇', '211223111000', '211223000000');
INSERT INTO `t_s_town` VALUES ('6957', '德兴满族乡', '211223204000', '211223000000');
INSERT INTO `t_s_town` VALUES ('6958', '明德满族乡', '211223206000', '211223000000');
INSERT INTO `t_s_town` VALUES ('6959', '成平满族乡', '211223209000', '211223000000');
INSERT INTO `t_s_town` VALUES ('6960', '和隆满族乡', '211223211000', '211223000000');
INSERT INTO `t_s_town` VALUES ('6961', '营厂满族乡', '211223212000', '211223000000');
INSERT INTO `t_s_town` VALUES ('6962', '金星满族乡', '211223213000', '211223000000');
INSERT INTO `t_s_town` VALUES ('6963', '昌图镇', '211224100000', '211224000000');
INSERT INTO `t_s_town` VALUES ('6964', '老城镇', '211224101000', '211224000000');
INSERT INTO `t_s_town` VALUES ('6965', '八面城镇', '211224102000', '211224000000');
INSERT INTO `t_s_town` VALUES ('6966', '三江口镇', '211224103000', '211224000000');
INSERT INTO `t_s_town` VALUES ('6967', '金家镇', '211224104000', '211224000000');
INSERT INTO `t_s_town` VALUES ('6968', '宝力镇', '211224105000', '211224000000');
INSERT INTO `t_s_town` VALUES ('6969', '泉头镇', '211224106000', '211224000000');
INSERT INTO `t_s_town` VALUES ('6970', '双庙子镇', '211224107000', '211224000000');
INSERT INTO `t_s_town` VALUES ('6971', '亮中桥镇', '211224108000', '211224000000');
INSERT INTO `t_s_town` VALUES ('6972', '马仲河镇', '211224109000', '211224000000');
INSERT INTO `t_s_town` VALUES ('6973', '毛家店镇', '211224110000', '211224000000');
INSERT INTO `t_s_town` VALUES ('6974', '老四平镇', '211224111000', '211224000000');
INSERT INTO `t_s_town` VALUES ('6975', '大洼镇', '211224112000', '211224000000');
INSERT INTO `t_s_town` VALUES ('6976', '头道镇', '211224113000', '211224000000');
INSERT INTO `t_s_town` VALUES ('6977', '鴜鷺树镇', '211224114000', '211224000000');
INSERT INTO `t_s_town` VALUES ('6978', '傅家镇', '211224115000', '211224000000');
INSERT INTO `t_s_town` VALUES ('6979', '四合镇', '211224117000', '211224000000');
INSERT INTO `t_s_town` VALUES ('6980', '朝阳镇', '211224118000', '211224000000');
INSERT INTO `t_s_town` VALUES ('6981', '古榆树镇', '211224119000', '211224000000');
INSERT INTO `t_s_town` VALUES ('6982', '七家子镇', '211224120000', '211224000000');
INSERT INTO `t_s_town` VALUES ('6983', '东嘎镇', '211224121000', '211224000000');
INSERT INTO `t_s_town` VALUES ('6984', '四面城镇', '211224122000', '211224000000');
INSERT INTO `t_s_town` VALUES ('6985', '前双井镇', '211224123000', '211224000000');
INSERT INTO `t_s_town` VALUES ('6986', '通江口镇', '211224124000', '211224000000');
INSERT INTO `t_s_town` VALUES ('6987', '大四家子镇', '211224125000', '211224000000');
INSERT INTO `t_s_town` VALUES ('6988', '曲家店镇', '211224126000', '211224000000');
INSERT INTO `t_s_town` VALUES ('6989', '十八家子镇', '211224127000', '211224000000');
INSERT INTO `t_s_town` VALUES ('6990', '太平镇', '211224128000', '211224000000');
INSERT INTO `t_s_town` VALUES ('6991', '下二台镇', '211224129000', '211224000000');
INSERT INTO `t_s_town` VALUES ('6992', '平安堡镇', '211224130000', '211224000000');
INSERT INTO `t_s_town` VALUES ('6993', '大兴镇', '211224131000', '211224000000');
INSERT INTO `t_s_town` VALUES ('6994', '后窑镇', '211224132000', '211224000000');
INSERT INTO `t_s_town` VALUES ('6995', '长发镇', '211224133000', '211224000000');
INSERT INTO `t_s_town` VALUES ('6996', '三江口农场', '211224401000', '211224000000');
INSERT INTO `t_s_town` VALUES ('6997', '宝力农场', '211224402000', '211224000000');
INSERT INTO `t_s_town` VALUES ('6998', '新乡农场', '211224403000', '211224000000');
INSERT INTO `t_s_town` VALUES ('6999', '付家林场', '211224404000', '211224000000');
INSERT INTO `t_s_town` VALUES ('7000', '牤牛马场', '211224405000', '211224000000');
INSERT INTO `t_s_town` VALUES ('7001', '两家子农场', '211224406000', '211224000000');
INSERT INTO `t_s_town` VALUES ('7002', '兀术街街道', '211281001000', '211281000000');
INSERT INTO `t_s_town` VALUES ('7003', '调兵山街道', '211281002000', '211281000000');
INSERT INTO `t_s_town` VALUES ('7004', '晓明镇', '211281102000', '211281000000');
INSERT INTO `t_s_town` VALUES ('7005', '大明镇', '211281103000', '211281000000');
INSERT INTO `t_s_town` VALUES ('7006', '晓南镇', '211281105000', '211281000000');
INSERT INTO `t_s_town` VALUES ('7007', '新城街道', '211282001000', '211282000000');
INSERT INTO `t_s_town` VALUES ('7008', '老城街道', '211282002000', '211282000000');
INSERT INTO `t_s_town` VALUES ('7009', '兴开街道', '211282003000', '211282000000');
INSERT INTO `t_s_town` VALUES ('7010', '威远堡镇', '211282102000', '211282000000');
INSERT INTO `t_s_town` VALUES ('7011', '庆云堡镇', '211282103000', '211282000000');
INSERT INTO `t_s_town` VALUES ('7012', '中固镇', '211282104000', '211282000000');
INSERT INTO `t_s_town` VALUES ('7013', '八棵树镇', '211282105000', '211282000000');
INSERT INTO `t_s_town` VALUES ('7014', '金沟子镇', '211282106000', '211282000000');
INSERT INTO `t_s_town` VALUES ('7015', '八宝镇', '211282107000', '211282000000');
INSERT INTO `t_s_town` VALUES ('7016', '业民镇', '211282108000', '211282000000');
INSERT INTO `t_s_town` VALUES ('7017', '莲花镇', '211282109000', '211282000000');
INSERT INTO `t_s_town` VALUES ('7018', '靠山镇', '211282110000', '211282000000');
INSERT INTO `t_s_town` VALUES ('7019', '马家寨镇', '211282111000', '211282000000');
INSERT INTO `t_s_town` VALUES ('7020', '下肥镇', '211282112000', '211282000000');
INSERT INTO `t_s_town` VALUES ('7021', '松山镇', '211282113000', '211282000000');
INSERT INTO `t_s_town` VALUES ('7022', '城东镇', '211282114000', '211282000000');
INSERT INTO `t_s_town` VALUES ('7023', '李家台镇', '211282115000', '211282000000');
INSERT INTO `t_s_town` VALUES ('7024', '上肥地满族镇', '211282116000', '211282000000');
INSERT INTO `t_s_town` VALUES ('7025', '黄旗寨满族镇', '211282117000', '211282000000');
INSERT INTO `t_s_town` VALUES ('7026', '林丰满族乡', '211282217000', '211282000000');
INSERT INTO `t_s_town` VALUES ('7027', '南塔街道', '211302001000', '211302000000');
INSERT INTO `t_s_town` VALUES ('7028', '北塔街道', '211302002000', '211302000000');
INSERT INTO `t_s_town` VALUES ('7029', '前进街道', '211302003000', '211302000000');
INSERT INTO `t_s_town` VALUES ('7030', '凌河街道', '211302004000', '211302000000');
INSERT INTO `t_s_town` VALUES ('7031', '光明街道', '211302005000', '211302000000');
INSERT INTO `t_s_town` VALUES ('7032', '凌凤街道', '211302006000', '211302000000');
INSERT INTO `t_s_town` VALUES ('7033', '龙山街道', '211302007000', '211302000000');
INSERT INTO `t_s_town` VALUES ('7034', '站南街道', '211302008000', '211302000000');
INSERT INTO `t_s_town` VALUES ('7035', '红旗街道', '211302009000', '211302000000');
INSERT INTO `t_s_town` VALUES ('7036', '燕北街道', '211302010000', '211302000000');
INSERT INTO `t_s_town` VALUES ('7037', '燕都街道', '211302011000', '211302000000');
INSERT INTO `t_s_town` VALUES ('7038', '桃花吐镇', '211302100000', '211302000000');
INSERT INTO `t_s_town` VALUES ('7039', '他拉皋镇', '211302101000', '211302000000');
INSERT INTO `t_s_town` VALUES ('7040', '孙家湾镇', '211302102000', '211302000000');
INSERT INTO `t_s_town` VALUES ('7041', '长宝营子乡', '211302205000', '211302000000');
INSERT INTO `t_s_town` VALUES ('7042', '向阳街道', '211303001000', '211303000000');
INSERT INTO `t_s_town` VALUES ('7043', '燕山街道', '211303002000', '211303000000');
INSERT INTO `t_s_town` VALUES ('7044', '马山街道', '211303003000', '211303000000');
INSERT INTO `t_s_town` VALUES ('7045', '新华街道', '211303004000', '211303000000');
INSERT INTO `t_s_town` VALUES ('7046', '海龙街道', '211303005000', '211303000000');
INSERT INTO `t_s_town` VALUES ('7047', '开发区龙泉街道', '211303070000', '211303000000');
INSERT INTO `t_s_town` VALUES ('7048', '七道泉子镇', '211303101000', '211303000000');
INSERT INTO `t_s_town` VALUES ('7049', '西大营子镇', '211303102000', '211303000000');
INSERT INTO `t_s_town` VALUES ('7050', '召都巴镇', '211303103000', '211303000000');
INSERT INTO `t_s_town` VALUES ('7051', '大平房镇', '211303105000', '211303000000');
INSERT INTO `t_s_town` VALUES ('7052', '联合镇', '211303106000', '211303000000');
INSERT INTO `t_s_town` VALUES ('7053', '边杖子镇', '211303107000', '211303000000');
INSERT INTO `t_s_town` VALUES ('7054', '柳城街道', '211321001000', '211321000000');
INSERT INTO `t_s_town` VALUES ('7055', '波罗赤镇', '211321102000', '211321000000');
INSERT INTO `t_s_town` VALUES ('7056', '木头城子镇', '211321103000', '211321000000');
INSERT INTO `t_s_town` VALUES ('7057', '二十家子镇', '211321104000', '211321000000');
INSERT INTO `t_s_town` VALUES ('7058', '羊山镇', '211321105000', '211321000000');
INSERT INTO `t_s_town` VALUES ('7059', '六家子镇', '211321106000', '211321000000');
INSERT INTO `t_s_town` VALUES ('7060', '瓦房子镇', '211321107000', '211321000000');
INSERT INTO `t_s_town` VALUES ('7061', '大庙镇', '211321108000', '211321000000');
INSERT INTO `t_s_town` VALUES ('7062', '古山子镇', '211321110000', '211321000000');
INSERT INTO `t_s_town` VALUES ('7063', '南双庙镇', '211321111000', '211321000000');
INSERT INTO `t_s_town` VALUES ('7064', '台子镇', '211321112000', '211321000000');
INSERT INTO `t_s_town` VALUES ('7065', '清风岭镇', '211321113000', '211321000000');
INSERT INTO `t_s_town` VALUES ('7066', '胜利镇', '211321114000', '211321000000');
INSERT INTO `t_s_town` VALUES ('7067', '七道岭镇', '211321115000', '211321000000');
INSERT INTO `t_s_town` VALUES ('7068', '杨树湾镇', '211321116000', '211321000000');
INSERT INTO `t_s_town` VALUES ('7069', '西五家子乡', '211321211000', '211321000000');
INSERT INTO `t_s_town` VALUES ('7070', '北沟门子乡', '211321212000', '211321000000');
INSERT INTO `t_s_town` VALUES ('7071', '东大道乡', '211321214000', '211321000000');
INSERT INTO `t_s_town` VALUES ('7072', '乌兰河硕蒙古族乡', '211321215000', '211321000000');
INSERT INTO `t_s_town` VALUES ('7073', '东大屯乡', '211321220000', '211321000000');
INSERT INTO `t_s_town` VALUES ('7074', '松岭门蒙古族乡', '211321221000', '211321000000');
INSERT INTO `t_s_town` VALUES ('7075', '根德营子乡', '211321222000', '211321000000');
INSERT INTO `t_s_town` VALUES ('7076', '西营子乡', '211321224000', '211321000000');
INSERT INTO `t_s_town` VALUES ('7077', '北四家子乡', '211321228000', '211321000000');
INSERT INTO `t_s_town` VALUES ('7078', '王营子乡', '211321230000', '211321000000');
INSERT INTO `t_s_town` VALUES ('7079', '黑牛营子乡', '211321231000', '211321000000');
INSERT INTO `t_s_town` VALUES ('7080', '尚志乡', '211321232000', '211321000000');
INSERT INTO `t_s_town` VALUES ('7081', '国营朝阳县贾家店农场', '211321400000', '211321000000');
INSERT INTO `t_s_town` VALUES ('7082', '叶柏寿街道', '211322001000', '211322000000');
INSERT INTO `t_s_town` VALUES ('7083', '红山街道', '211322002000', '211322000000');
INSERT INTO `t_s_town` VALUES ('7084', '铁南街道', '211322003000', '211322000000');
INSERT INTO `t_s_town` VALUES ('7085', '万寿街道', '211322004000', '211322000000');
INSERT INTO `t_s_town` VALUES ('7086', '富山街道', '211322005000', '211322000000');
INSERT INTO `t_s_town` VALUES ('7087', '新城街道', '211322006000', '211322000000');
INSERT INTO `t_s_town` VALUES ('7088', '东城街道', '211322007000', '211322000000');
INSERT INTO `t_s_town` VALUES ('7089', '朱碌科镇', '211322101000', '211322000000');
INSERT INTO `t_s_town` VALUES ('7090', '建平镇', '211322102000', '211322000000');
INSERT INTO `t_s_town` VALUES ('7091', '黑水镇', '211322103000', '211322000000');
INSERT INTO `t_s_town` VALUES ('7092', '喀喇沁镇', '211322104000', '211322000000');
INSERT INTO `t_s_town` VALUES ('7093', '北二十家子镇', '211322105000', '211322000000');
INSERT INTO `t_s_town` VALUES ('7094', '沙海镇', '211322106000', '211322000000');
INSERT INTO `t_s_town` VALUES ('7095', '哈拉道口镇', '211322108000', '211322000000');
INSERT INTO `t_s_town` VALUES ('7096', '榆树林子镇', '211322109000', '211322000000');
INSERT INTO `t_s_town` VALUES ('7097', '老官地镇', '211322110000', '211322000000');
INSERT INTO `t_s_town` VALUES ('7098', '深井镇', '211322111000', '211322000000');
INSERT INTO `t_s_town` VALUES ('7099', '奎德素镇', '211322112000', '211322000000');
INSERT INTO `t_s_town` VALUES ('7100', '小塘镇', '211322113000', '211322000000');
INSERT INTO `t_s_town` VALUES ('7101', '马场镇', '211322114000', '211322000000');
INSERT INTO `t_s_town` VALUES ('7102', '昌隆镇', '211322115000', '211322000000');
INSERT INTO `t_s_town` VALUES ('7103', '张家营子镇', '211322117000', '211322000000');
INSERT INTO `t_s_town` VALUES ('7104', '青峰山镇', '211322118000', '211322000000');
INSERT INTO `t_s_town` VALUES ('7105', '太平庄镇', '211322119000', '211322000000');
INSERT INTO `t_s_town` VALUES ('7106', '青松岭乡', '211322205000', '211322000000');
INSERT INTO `t_s_town` VALUES ('7107', '杨树岭乡', '211322206000', '211322000000');
INSERT INTO `t_s_town` VALUES ('7108', '罗福沟乡', '211322209000', '211322000000');
INSERT INTO `t_s_town` VALUES ('7109', '烧锅营子乡', '211322211000', '211322000000');
INSERT INTO `t_s_town` VALUES ('7110', '白山乡', '211322214000', '211322000000');
INSERT INTO `t_s_town` VALUES ('7111', '三家蒙古族乡', '211322218000', '211322000000');
INSERT INTO `t_s_town` VALUES ('7112', '义成功乡', '211322220000', '211322000000');
INSERT INTO `t_s_town` VALUES ('7113', '八家国营农场', '211322400000', '211322000000');
INSERT INTO `t_s_town` VALUES ('7114', '热水国营畜牧农场', '211322401000', '211322000000');
INSERT INTO `t_s_town` VALUES ('7115', '大城子街道', '211324001000', '211324000000');
INSERT INTO `t_s_town` VALUES ('7116', '利州街道', '211324002000', '211324000000');
INSERT INTO `t_s_town` VALUES ('7117', '南哨街道', '211324003000', '211324000000');
INSERT INTO `t_s_town` VALUES ('7118', '南公营子镇', '211324101000', '211324000000');
INSERT INTO `t_s_town` VALUES ('7119', '山嘴子镇', '211324102000', '211324000000');
INSERT INTO `t_s_town` VALUES ('7120', '公营子镇', '211324104000', '211324000000');
INSERT INTO `t_s_town` VALUES ('7121', '白塔子镇', '211324105000', '211324000000');
INSERT INTO `t_s_town` VALUES ('7122', '中三家镇', '211324106000', '211324000000');
INSERT INTO `t_s_town` VALUES ('7123', '老爷庙镇', '211324107000', '211324000000');
INSERT INTO `t_s_town` VALUES ('7124', '六官营子镇', '211324108000', '211324000000');
INSERT INTO `t_s_town` VALUES ('7125', '平房子镇', '211324109000', '211324000000');
INSERT INTO `t_s_town` VALUES ('7126', '十二德堡镇', '211324110000', '211324000000');
INSERT INTO `t_s_town` VALUES ('7127', '羊角沟镇', '211324111000', '211324000000');
INSERT INTO `t_s_town` VALUES ('7128', '兴隆庄镇', '211324112000', '211324000000');
INSERT INTO `t_s_town` VALUES ('7129', '甘招镇', '211324113000', '211324000000');
INSERT INTO `t_s_town` VALUES ('7130', '东哨镇', '211324114000', '211324000000');
INSERT INTO `t_s_town` VALUES ('7131', '水泉镇', '211324115000', '211324000000');
INSERT INTO `t_s_town` VALUES ('7132', '尤杖子乡', '211324204000', '211324000000');
INSERT INTO `t_s_town` VALUES ('7133', '草场乡', '211324207000', '211324000000');
INSERT INTO `t_s_town` VALUES ('7134', '坤都营子乡', '211324210000', '211324000000');
INSERT INTO `t_s_town` VALUES ('7135', '大营子乡', '211324211000', '211324000000');
INSERT INTO `t_s_town` VALUES ('7136', '卧虎沟乡', '211324214000', '211324000000');
INSERT INTO `t_s_town` VALUES ('7137', '国营官大海农场', '211324400000', '211324000000');
INSERT INTO `t_s_town` VALUES ('7138', '城关街道', '211381001000', '211381000000');
INSERT INTO `t_s_town` VALUES ('7139', '南山街道', '211381002000', '211381000000');
INSERT INTO `t_s_town` VALUES ('7140', '冠山街道', '211381003000', '211381000000');
INSERT INTO `t_s_town` VALUES ('7141', '桥北街道', '211381004000', '211381000000');
INSERT INTO `t_s_town` VALUES ('7142', '三宝街道', '211381005000', '211381000000');
INSERT INTO `t_s_town` VALUES ('7143', '台吉街道', '211381006000', '211381000000');
INSERT INTO `t_s_town` VALUES ('7144', '双河街道', '211381008000', '211381000000');
INSERT INTO `t_s_town` VALUES ('7145', '西官营镇', '211381101000', '211381000000');
INSERT INTO `t_s_town` VALUES ('7146', '大板镇', '211381102000', '211381000000');
INSERT INTO `t_s_town` VALUES ('7147', '上园镇', '211381103000', '211381000000');
INSERT INTO `t_s_town` VALUES ('7148', '宝国老镇', '211381104000', '211381000000');
INSERT INTO `t_s_town` VALUES ('7149', '黑城子镇', '211381105000', '211381000000');
INSERT INTO `t_s_town` VALUES ('7150', '五间房镇', '211381107000', '211381000000');
INSERT INTO `t_s_town` VALUES ('7151', '台吉镇', '211381108000', '211381000000');
INSERT INTO `t_s_town` VALUES ('7152', '东官营镇', '211381109000', '211381000000');
INSERT INTO `t_s_town` VALUES ('7153', '龙潭镇', '211381110000', '211381000000');
INSERT INTO `t_s_town` VALUES ('7154', '北塔镇', '211381111000', '211381000000');
INSERT INTO `t_s_town` VALUES ('7155', '蒙古营镇', '211381112000', '211381000000');
INSERT INTO `t_s_town` VALUES ('7156', '大三家镇', '211381113000', '211381000000');
INSERT INTO `t_s_town` VALUES ('7157', '长皋乡', '211381201000', '211381000000');
INSERT INTO `t_s_town` VALUES ('7158', '常河营乡', '211381202000', '211381000000');
INSERT INTO `t_s_town` VALUES ('7159', '小塔子乡', '211381203000', '211381000000');
INSERT INTO `t_s_town` VALUES ('7160', '马友营蒙古族乡', '211381204000', '211381000000');
INSERT INTO `t_s_town` VALUES ('7161', '泉巨永乡', '211381206000', '211381000000');
INSERT INTO `t_s_town` VALUES ('7162', '哈尔脑乡', '211381212000', '211381000000');
INSERT INTO `t_s_town` VALUES ('7163', '南八家子乡', '211381213000', '211381000000');
INSERT INTO `t_s_town` VALUES ('7164', '章吉营乡', '211381214000', '211381000000');
INSERT INTO `t_s_town` VALUES ('7165', '三宝营乡', '211381215000', '211381000000');
INSERT INTO `t_s_town` VALUES ('7166', '巴图营乡', '211381216000', '211381000000');
INSERT INTO `t_s_town` VALUES ('7167', '台吉营乡', '211381218000', '211381000000');
INSERT INTO `t_s_town` VALUES ('7168', '娄家店乡', '211381220000', '211381000000');
INSERT INTO `t_s_town` VALUES ('7169', '北四家乡', '211381221000', '211381000000');
INSERT INTO `t_s_town` VALUES ('7170', '凉水河蒙古族乡', '211381223000', '211381000000');
INSERT INTO `t_s_town` VALUES ('7171', '三宝乡', '211381228000', '211381000000');
INSERT INTO `t_s_town` VALUES ('7172', '兴顺德国营农场', '211381400000', '211381000000');
INSERT INTO `t_s_town` VALUES ('7173', '下府经济开发区', '211381470000', '211381000000');
INSERT INTO `t_s_town` VALUES ('7174', '大黑山特别行政管理区', '211381471000', '211381000000');
INSERT INTO `t_s_town` VALUES ('7175', '东城街道', '211382001000', '211382000000');
INSERT INTO `t_s_town` VALUES ('7176', '北街街道', '211382002000', '211382000000');
INSERT INTO `t_s_town` VALUES ('7177', '南街街道', '211382003000', '211382000000');
INSERT INTO `t_s_town` VALUES ('7178', '凌北街道', '211382004000', '211382000000');
INSERT INTO `t_s_town` VALUES ('7179', '热水汤街道', '211382006000', '211382000000');
INSERT INTO `t_s_town` VALUES ('7180', '兴源街道', '211382007000', '211382000000');
INSERT INTO `t_s_town` VALUES ('7181', '红山街道', '211382008000', '211382000000');
INSERT INTO `t_s_town` VALUES ('7182', '城关街道', '211382009000', '211382000000');
INSERT INTO `t_s_town` VALUES ('7183', '万元店镇', '211382101000', '211382000000');
INSERT INTO `t_s_town` VALUES ('7184', '宋杖子镇', '211382102000', '211382000000');
INSERT INTO `t_s_town` VALUES ('7185', '三十家子镇', '211382103000', '211382000000');
INSERT INTO `t_s_town` VALUES ('7186', '杨杖子镇', '211382104000', '211382000000');
INSERT INTO `t_s_town` VALUES ('7187', '刀尔登镇', '211382105000', '211382000000');
INSERT INTO `t_s_town` VALUES ('7188', '松岭子镇', '211382106000', '211382000000');
INSERT INTO `t_s_town` VALUES ('7189', '四官营子镇', '211382107000', '211382000000');
INSERT INTO `t_s_town` VALUES ('7190', '沟门子镇', '211382108000', '211382000000');
INSERT INTO `t_s_town` VALUES ('7191', '小城子镇', '211382110000', '211382000000');
INSERT INTO `t_s_town` VALUES ('7192', '四合当镇', '211382111000', '211382000000');
INSERT INTO `t_s_town` VALUES ('7193', '乌兰白镇', '211382113000', '211382000000');
INSERT INTO `t_s_town` VALUES ('7194', '瓦房店镇', '211382114000', '211382000000');
INSERT INTO `t_s_town` VALUES ('7195', '大河北镇', '211382115000', '211382000000');
INSERT INTO `t_s_town` VALUES ('7196', '牛营子镇', '211382116000', '211382000000');
INSERT INTO `t_s_town` VALUES ('7197', '三道河子镇', '211382117000', '211382000000');
INSERT INTO `t_s_town` VALUES ('7198', '刘杖子镇', '211382118000', '211382000000');
INSERT INTO `t_s_town` VALUES ('7199', '大王杖子乡', '211382204000', '211382000000');
INSERT INTO `t_s_town` VALUES ('7200', '前进乡', '211382206000', '211382000000');
INSERT INTO `t_s_town` VALUES ('7201', '北炉乡', '211382210000', '211382000000');
INSERT INTO `t_s_town` VALUES ('7202', '三家子蒙古族乡', '211382217000', '211382000000');
INSERT INTO `t_s_town` VALUES ('7203', '佛爷洞乡', '211382219000', '211382000000');
INSERT INTO `t_s_town` VALUES ('7204', '河坎子乡', '211382220000', '211382000000');
INSERT INTO `t_s_town` VALUES ('7205', '连山街道', '211402001000', '211402000000');
INSERT INTO `t_s_town` VALUES ('7206', '站前街道', '211402002000', '211402000000');
INSERT INTO `t_s_town` VALUES ('7207', '渤海街道', '211402003000', '211402000000');
INSERT INTO `t_s_town` VALUES ('7208', '兴工街道', '211402004000', '211402000000');
INSERT INTO `t_s_town` VALUES ('7209', '石油街道', '211402005000', '211402000000');
INSERT INTO `t_s_town` VALUES ('7210', '化工街道', '211402006000', '211402000000');
INSERT INTO `t_s_town` VALUES ('7211', '化机街道', '211402007000', '211402000000');
INSERT INTO `t_s_town` VALUES ('7212', '水泥街道', '211402008000', '211402000000');
INSERT INTO `t_s_town` VALUES ('7213', '锦郊街道', '211402011000', '211402000000');
INSERT INTO `t_s_town` VALUES ('7214', '钢屯镇', '211402104000', '211402000000');
INSERT INTO `t_s_town` VALUES ('7215', '寺儿堡镇', '211402105000', '211402000000');
INSERT INTO `t_s_town` VALUES ('7216', '新台门镇', '211402106000', '211402000000');
INSERT INTO `t_s_town` VALUES ('7217', '沙河营乡', '211402201000', '211402000000');
INSERT INTO `t_s_town` VALUES ('7218', '孤竹营子乡', '211402202000', '211402000000');
INSERT INTO `t_s_town` VALUES ('7219', '白马石乡', '211402203000', '211402000000');
INSERT INTO `t_s_town` VALUES ('7220', '山神庙子乡', '211402205000', '211402000000');
INSERT INTO `t_s_town` VALUES ('7221', '塔山乡', '211402206000', '211402000000');
INSERT INTO `t_s_town` VALUES ('7222', '杨郊乡', '211402210000', '211402000000');
INSERT INTO `t_s_town` VALUES ('7223', '杨家杖子经济开发区', '211402400000', '211402000000');
INSERT INTO `t_s_town` VALUES ('7224', '葫芦岛街道', '211403001000', '211403000000');
INSERT INTO `t_s_town` VALUES ('7225', '东街道', '211403002000', '211403000000');
INSERT INTO `t_s_town` VALUES ('7226', '西街道', '211403003000', '211403000000');
INSERT INTO `t_s_town` VALUES ('7227', '望海寺街道', '211403004000', '211403000000');
INSERT INTO `t_s_town` VALUES ('7228', '龙湾街道', '211403005000', '211403000000');
INSERT INTO `t_s_town` VALUES ('7229', '滨海街道', '211403006000', '211403000000');
INSERT INTO `t_s_town` VALUES ('7230', '双龙街道', '211403007000', '211403000000');
INSERT INTO `t_s_town` VALUES ('7231', '玉皇街道', '211403008000', '211403000000');
INSERT INTO `t_s_town` VALUES ('7232', '连湾街道', '211403009000', '211403000000');
INSERT INTO `t_s_town` VALUES ('7233', '北港街道', '211403010000', '211403000000');
INSERT INTO `t_s_town` VALUES ('7234', '双树乡', '211403201000', '211403000000');
INSERT INTO `t_s_town` VALUES ('7235', '葫芦岛经济开发区', '211403400000', '211403000000');
INSERT INTO `t_s_town` VALUES ('7236', '葫芦岛市专利技术园区', '211403401000', '211403000000');
INSERT INTO `t_s_town` VALUES ('7237', '赵家屯街道', '211404001000', '211404000000');
INSERT INTO `t_s_town` VALUES ('7238', '沙锅屯街道', '211404002000', '211404000000');
INSERT INTO `t_s_town` VALUES ('7239', '邱皮沟街道', '211404003000', '211404000000');
INSERT INTO `t_s_town` VALUES ('7240', '苇子沟街道', '211404005000', '211404000000');
INSERT INTO `t_s_town` VALUES ('7241', '三家子街道', '211404006000', '211404000000');
INSERT INTO `t_s_town` VALUES ('7242', '小凌河街道', '211404007000', '211404000000');
INSERT INTO `t_s_town` VALUES ('7243', '九龙街道', '211404008000', '211404000000');
INSERT INTO `t_s_town` VALUES ('7244', '龙飞街道', '211404009000', '211404000000');
INSERT INTO `t_s_town` VALUES ('7245', '龙腾街道', '211404010000', '211404000000');
INSERT INTO `t_s_town` VALUES ('7246', '龙翔街道', '211404011000', '211404000000');
INSERT INTO `t_s_town` VALUES ('7247', '缸窑岭镇', '211404101000', '211404000000');
INSERT INTO `t_s_town` VALUES ('7248', '暖池塘镇', '211404102000', '211404000000');
INSERT INTO `t_s_town` VALUES ('7249', '高桥镇', '211404103000', '211404000000');
INSERT INTO `t_s_town` VALUES ('7250', '虹螺岘镇', '211404104000', '211404000000');
INSERT INTO `t_s_town` VALUES ('7251', '金星镇', '211404105000', '211404000000');
INSERT INTO `t_s_town` VALUES ('7252', '台集屯镇', '211404106000', '211404000000');
INSERT INTO `t_s_town` VALUES ('7253', '沙锅屯乡', '211404201000', '211404000000');
INSERT INTO `t_s_town` VALUES ('7254', '黄土坎乡', '211404203000', '211404000000');
INSERT INTO `t_s_town` VALUES ('7255', '大兴乡', '211404204000', '211404000000');
INSERT INTO `t_s_town` VALUES ('7256', '张相公屯乡', '211404205000', '211404000000');
INSERT INTO `t_s_town` VALUES ('7257', '乌金塘水库', '211404400000', '211404000000');
INSERT INTO `t_s_town` VALUES ('7258', '绥中镇', '211421100000', '211421000000');
INSERT INTO `t_s_town` VALUES ('7259', '西甸子镇', '211421101000', '211421000000');
INSERT INTO `t_s_town` VALUES ('7260', '宽邦镇', '211421102000', '211421000000');
INSERT INTO `t_s_town` VALUES ('7261', '大王庙镇', '211421103000', '211421000000');
INSERT INTO `t_s_town` VALUES ('7262', '万家镇', '211421104000', '211421000000');
INSERT INTO `t_s_town` VALUES ('7263', '前所镇', '211421105000', '211421000000');
INSERT INTO `t_s_town` VALUES ('7264', '高岭镇', '211421106000', '211421000000');
INSERT INTO `t_s_town` VALUES ('7265', '前卫镇', '211421107000', '211421000000');
INSERT INTO `t_s_town` VALUES ('7266', '荒地镇', '211421108000', '211421000000');
INSERT INTO `t_s_town` VALUES ('7267', '塔山屯镇', '211421109000', '211421000000');
INSERT INTO `t_s_town` VALUES ('7268', '高台镇', '211421113000', '211421000000');
INSERT INTO `t_s_town` VALUES ('7269', '王宝镇', '211421114000', '211421000000');
INSERT INTO `t_s_town` VALUES ('7270', '沙河镇', '211421115000', '211421000000');
INSERT INTO `t_s_town` VALUES ('7271', '小庄子镇', '211421116000', '211421000000');
INSERT INTO `t_s_town` VALUES ('7272', '西平坡满族乡', '211421201000', '211421000000');
INSERT INTO `t_s_town` VALUES ('7273', '葛家满族乡', '211421202000', '211421000000');
INSERT INTO `t_s_town` VALUES ('7274', '高甸子满族乡', '211421204000', '211421000000');
INSERT INTO `t_s_town` VALUES ('7275', '范家满族乡', '211421206000', '211421000000');
INSERT INTO `t_s_town` VALUES ('7276', '明水满族乡', '211421207000', '211421000000');
INSERT INTO `t_s_town` VALUES ('7277', '秋子沟乡', '211421208000', '211421000000');
INSERT INTO `t_s_town` VALUES ('7278', '加碑岩乡', '211421210000', '211421000000');
INSERT INTO `t_s_town` VALUES ('7279', '永安堡乡', '211421211000', '211421000000');
INSERT INTO `t_s_town` VALUES ('7280', '李家堡乡', '211421212000', '211421000000');
INSERT INTO `t_s_town` VALUES ('7281', '网户满族乡', '211421214000', '211421000000');
INSERT INTO `t_s_town` VALUES ('7282', '城郊乡', '211421217000', '211421000000');
INSERT INTO `t_s_town` VALUES ('7283', '大台山果树农场', '211421400000', '211421000000');
INSERT INTO `t_s_town` VALUES ('7284', '前所果树农场', '211421401000', '211421000000');
INSERT INTO `t_s_town` VALUES ('7285', '建昌镇', '211422100000', '211422000000');
INSERT INTO `t_s_town` VALUES ('7286', '八家子镇', '211422101000', '211422000000');
INSERT INTO `t_s_town` VALUES ('7287', '喇嘛洞镇', '211422102000', '211422000000');
INSERT INTO `t_s_town` VALUES ('7288', '药王庙镇', '211422103000', '211422000000');
INSERT INTO `t_s_town` VALUES ('7289', '汤神庙镇', '211422104000', '211422000000');
INSERT INTO `t_s_town` VALUES ('7290', '玲珑塔镇', '211422105000', '211422000000');
INSERT INTO `t_s_town` VALUES ('7291', '大屯镇', '211422106000', '211422000000');
INSERT INTO `t_s_town` VALUES ('7292', '牤牛营子乡', '211422201000', '211422000000');
INSERT INTO `t_s_town` VALUES ('7293', '素珠营子乡', '211422203000', '211422000000');
INSERT INTO `t_s_town` VALUES ('7294', '石佛乡', '211422204000', '211422000000');
INSERT INTO `t_s_town` VALUES ('7295', '王宝营子乡', '211422206000', '211422000000');
INSERT INTO `t_s_town` VALUES ('7296', '老大杖子乡', '211422207000', '211422000000');
INSERT INTO `t_s_town` VALUES ('7297', '要路沟乡', '211422208000', '211422000000');
INSERT INTO `t_s_town` VALUES ('7298', '魏家岭乡', '211422209000', '211422000000');
INSERT INTO `t_s_town` VALUES ('7299', '西碱厂乡', '211422210000', '211422000000');
INSERT INTO `t_s_town` VALUES ('7300', '头道营子乡', '211422211000', '211422000000');
INSERT INTO `t_s_town` VALUES ('7301', '新开岭乡', '211422212000', '211422000000');
INSERT INTO `t_s_town` VALUES ('7302', '贺杖子乡', '211422213000', '211422000000');
INSERT INTO `t_s_town` VALUES ('7303', '养马甸子乡', '211422214000', '211422000000');
INSERT INTO `t_s_town` VALUES ('7304', '和尚房子乡', '211422215000', '211422000000');
INSERT INTO `t_s_town` VALUES ('7305', '杨树湾子乡', '211422218000', '211422000000');
INSERT INTO `t_s_town` VALUES ('7306', '黑山科乡', '211422219000', '211422000000');
INSERT INTO `t_s_town` VALUES ('7307', '雷家店乡', '211422220000', '211422000000');
INSERT INTO `t_s_town` VALUES ('7308', '小德营子乡', '211422222000', '211422000000');
INSERT INTO `t_s_town` VALUES ('7309', '二道湾子蒙古族乡', '211422223000', '211422000000');
INSERT INTO `t_s_town` VALUES ('7310', '巴什罕乡', '211422224000', '211422000000');
INSERT INTO `t_s_town` VALUES ('7311', '娘娘庙乡', '211422225000', '211422000000');
INSERT INTO `t_s_town` VALUES ('7312', '谷杖子乡', '211422226000', '211422000000');
INSERT INTO `t_s_town` VALUES ('7313', '古城街道', '211481001000', '211481000000');
INSERT INTO `t_s_town` VALUES ('7314', '宁远街道', '211481002000', '211481000000');
INSERT INTO `t_s_town` VALUES ('7315', '城东街道', '211481003000', '211481000000');
INSERT INTO `t_s_town` VALUES ('7316', '温泉街道', '211481004000', '211481000000');
INSERT INTO `t_s_town` VALUES ('7317', '钓鱼台街道', '211481005000', '211481000000');
INSERT INTO `t_s_town` VALUES ('7318', '华山街道', '211481006000', '211481000000');
INSERT INTO `t_s_town` VALUES ('7319', '四家屯街道', '211481007000', '211481000000');
INSERT INTO `t_s_town` VALUES ('7320', '菊花街道', '211481008000', '211481000000');
INSERT INTO `t_s_town` VALUES ('7321', '临海街道', '211481009000', '211481000000');
INSERT INTO `t_s_town` VALUES ('7322', '曹庄镇', '211481101000', '211481000000');
INSERT INTO `t_s_town` VALUES ('7323', '沙后所满族镇', '211481103000', '211481000000');
INSERT INTO `t_s_town` VALUES ('7324', '东辛庄满族镇', '211481104000', '211481000000');
INSERT INTO `t_s_town` VALUES ('7325', '郭家满族镇', '211481105000', '211481000000');
INSERT INTO `t_s_town` VALUES ('7326', '红崖子镇', '211481106000', '211481000000');
INSERT INTO `t_s_town` VALUES ('7327', '徐大堡镇', '211481107000', '211481000000');
INSERT INTO `t_s_town` VALUES ('7328', '高家岭满族镇', '211481108000', '211481000000');
INSERT INTO `t_s_town` VALUES ('7329', '羊安满族乡', '211481201000', '211481000000');
INSERT INTO `t_s_town` VALUES ('7330', '元台子满族乡', '211481203000', '211481000000');
INSERT INTO `t_s_town` VALUES ('7331', '白塔满族乡', '211481204000', '211481000000');
INSERT INTO `t_s_town` VALUES ('7332', '望海满族乡', '211481206000', '211481000000');
INSERT INTO `t_s_town` VALUES ('7333', '刘台子满族乡', '211481207000', '211481000000');
INSERT INTO `t_s_town` VALUES ('7334', '大寨满族乡', '211481208000', '211481000000');
INSERT INTO `t_s_town` VALUES ('7335', '南大满族乡', '211481209000', '211481000000');
INSERT INTO `t_s_town` VALUES ('7336', '围屏满族乡', '211481210000', '211481000000');
INSERT INTO `t_s_town` VALUES ('7337', '碱厂满族乡', '211481212000', '211481000000');
INSERT INTO `t_s_town` VALUES ('7338', '三道沟满族乡', '211481213000', '211481000000');
INSERT INTO `t_s_town` VALUES ('7339', '旧门满族乡', '211481215000', '211481000000');
INSERT INTO `t_s_town` VALUES ('7340', '药王满族乡', '211481216000', '211481000000');
INSERT INTO `t_s_town` VALUES ('7341', '南岭街道办事处', '220102001000', '220102000000');
INSERT INTO `t_s_town` VALUES ('7342', '自强街道办事处', '220102002000', '220102000000');
INSERT INTO `t_s_town` VALUES ('7343', '民康街道办事处', '220102003000', '220102000000');
INSERT INTO `t_s_town` VALUES ('7344', '新春街道办事处', '220102004000', '220102000000');
INSERT INTO `t_s_town` VALUES ('7345', '长通街道办事处', '220102005000', '220102000000');
INSERT INTO `t_s_town` VALUES ('7346', '全安街道办事处', '220102006000', '220102000000');
INSERT INTO `t_s_town` VALUES ('7347', '曙光街道办事处', '220102007000', '220102000000');
INSERT INTO `t_s_town` VALUES ('7348', '永吉街道办事处', '220102008000', '220102000000');
INSERT INTO `t_s_town` VALUES ('7349', '桃源街道办事处', '220102009000', '220102000000');
INSERT INTO `t_s_town` VALUES ('7350', '鸿城街道办事处', '220102010000', '220102000000');
INSERT INTO `t_s_town` VALUES ('7351', '明珠街道办事处', '220102011000', '220102000000');
INSERT INTO `t_s_town` VALUES ('7352', '富裕街道办事处', '220102012000', '220102000000');
INSERT INTO `t_s_town` VALUES ('7353', '幸福乡', '220102200000', '220102000000');
INSERT INTO `t_s_town` VALUES ('7354', '新发街道办事处', '220103001000', '220103000000');
INSERT INTO `t_s_town` VALUES ('7355', '站前街道办事处', '220103002000', '220103000000');
INSERT INTO `t_s_town` VALUES ('7356', '南广街道办事处', '220103003000', '220103000000');
INSERT INTO `t_s_town` VALUES ('7357', '东广街道办事处', '220103004000', '220103000000');
INSERT INTO `t_s_town` VALUES ('7358', '群英街道办事处', '220103005000', '220103000000');
INSERT INTO `t_s_town` VALUES ('7359', '兴业街道办事处', '220103006000', '220103000000');
INSERT INTO `t_s_town` VALUES ('7360', '凯旋街道办事处', '220103007000', '220103000000');
INSERT INTO `t_s_town` VALUES ('7361', '团山街道办事处', '220103008000', '220103000000');
INSERT INTO `t_s_town` VALUES ('7362', '柳影街道办事处', '220103009000', '220103000000');
INSERT INTO `t_s_town` VALUES ('7363', '欣园街道办事处', '220103010000', '220103000000');
INSERT INTO `t_s_town` VALUES ('7364', '兰家镇', '220103100000', '220103000000');
INSERT INTO `t_s_town` VALUES ('7365', '米沙子镇', '220103101000', '220103000000');
INSERT INTO `t_s_town` VALUES ('7366', '万宝镇', '220103102000', '220103000000');
INSERT INTO `t_s_town` VALUES ('7367', '合隆镇', '220103171000', '220103000000');
INSERT INTO `t_s_town` VALUES ('7368', '前进街道办事处', '220104001000', '220104000000');
INSERT INTO `t_s_town` VALUES ('7369', '桂林街道办事处', '220104002000', '220104000000');
INSERT INTO `t_s_town` VALUES ('7370', '南湖街道办事处', '220104003000', '220104000000');
INSERT INTO `t_s_town` VALUES ('7371', '永昌街道办事处', '220104004000', '220104000000');
INSERT INTO `t_s_town` VALUES ('7372', '重庆街道办事处', '220104005000', '220104000000');
INSERT INTO `t_s_town` VALUES ('7373', '清和街道办事处', '220104006000', '220104000000');
INSERT INTO `t_s_town` VALUES ('7374', '红旗街道办事处', '220104007000', '220104000000');
INSERT INTO `t_s_town` VALUES ('7375', '湖西街道办事处', '220104008000', '220104000000');
INSERT INTO `t_s_town` VALUES ('7376', '富锋街道办事处', '220104009000', '220104000000');
INSERT INTO `t_s_town` VALUES ('7377', '乐山镇', '220104100000', '220104000000');
INSERT INTO `t_s_town` VALUES ('7378', '永春镇', '220104101000', '220104000000');
INSERT INTO `t_s_town` VALUES ('7379', '东盛街道办事处', '220105001000', '220105000000');
INSERT INTO `t_s_town` VALUES ('7380', '吉林街道办事处', '220105002000', '220105000000');
INSERT INTO `t_s_town` VALUES ('7381', '荣光街道办事处', '220105003000', '220105000000');
INSERT INTO `t_s_town` VALUES ('7382', '东站街道办事处', '220105004000', '220105000000');
INSERT INTO `t_s_town` VALUES ('7383', '远达街道办事处', '220105005000', '220105000000');
INSERT INTO `t_s_town` VALUES ('7384', '八里堡街道办事处', '220105006000', '220105000000');
INSERT INTO `t_s_town` VALUES ('7385', '长青街道办事处', '220105007000', '220105000000');
INSERT INTO `t_s_town` VALUES ('7386', '英俊镇', '220105100000', '220105000000');
INSERT INTO `t_s_town` VALUES ('7387', '劝农山镇（长春莲花山生态旅游度假区省级）', '220105173000', '220105000000');
INSERT INTO `t_s_town` VALUES ('7388', '泉眼镇', '220105174000', '220105000000');
INSERT INTO `t_s_town` VALUES ('7389', '四家乡（长春莲花山生态旅游度假区省级）', '220105270000', '220105000000');
INSERT INTO `t_s_town` VALUES ('7390', '正阳街道办事处', '220106001000', '220106000000');
INSERT INTO `t_s_town` VALUES ('7391', '春城街道办事处', '220106003000', '220106000000');
INSERT INTO `t_s_town` VALUES ('7392', '青年街道办事处', '220106005000', '220106000000');
INSERT INTO `t_s_town` VALUES ('7393', '普阳街道办事处', '220106006000', '220106000000');
INSERT INTO `t_s_town` VALUES ('7394', '铁西街道办事处', '220106007000', '220106000000');
INSERT INTO `t_s_town` VALUES ('7395', '林园街道办事处', '220106010000', '220106000000');
INSERT INTO `t_s_town` VALUES ('7396', '同心街道办事处', '220106011000', '220106000000');
INSERT INTO `t_s_town` VALUES ('7397', '合心镇', '220106100000', '220106000000');
INSERT INTO `t_s_town` VALUES ('7398', '西新镇', '220106101000', '220106000000');
INSERT INTO `t_s_town` VALUES ('7399', '城西镇', '220106102000', '220106000000');
INSERT INTO `t_s_town` VALUES ('7400', '绿园经济开发区', '220106400000', '220106000000');
INSERT INTO `t_s_town` VALUES ('7401', '云山街道办事处', '220112001000', '220112000000');
INSERT INTO `t_s_town` VALUES ('7402', '平湖街道办事处', '220112002000', '220112000000');
INSERT INTO `t_s_town` VALUES ('7403', '奢岭街道办事处', '220112003000', '220112000000');
INSERT INTO `t_s_town` VALUES ('7404', '山河街道办事处', '220112004000', '220112000000');
INSERT INTO `t_s_town` VALUES ('7405', '齐家镇', '220112100000', '220112000000');
INSERT INTO `t_s_town` VALUES ('7406', '太平镇', '220112101000', '220112000000');
INSERT INTO `t_s_town` VALUES ('7407', '鹿乡镇', '220112102000', '220112000000');
INSERT INTO `t_s_town` VALUES ('7408', '双营子回族乡（梅花鹿产业经济开发区）（省级）', '220112270000', '220112000000');
INSERT INTO `t_s_town` VALUES ('7409', '九台街道办事处', '220113001000', '220113000000');
INSERT INTO `t_s_town` VALUES ('7410', '营城街道办事处', '220113002000', '220113000000');
INSERT INTO `t_s_town` VALUES ('7411', '九郊街道办事处', '220113003000', '220113000000');
INSERT INTO `t_s_town` VALUES ('7412', '西营城街道办事处', '220113004000', '220113000000');
INSERT INTO `t_s_town` VALUES ('7413', '土们岭街道办事处', '220113005000', '220113000000');
INSERT INTO `t_s_town` VALUES ('7414', '苇子沟街道办事处', '220113006000', '220113000000');
INSERT INTO `t_s_town` VALUES ('7415', '兴隆街道办事处', '220113007000', '220113000000');
INSERT INTO `t_s_town` VALUES ('7416', '纪家街道办事处', '220113008000', '220113000000');
INSERT INTO `t_s_town` VALUES ('7417', '波泥河街道办事处', '220113009000', '220113000000');
INSERT INTO `t_s_town` VALUES ('7418', '卡伦湖街道办事处', '220113010000', '220113000000');
INSERT INTO `t_s_town` VALUES ('7419', '东湖街道办事处', '220113011000', '220113000000');
INSERT INTO `t_s_town` VALUES ('7420', '龙嘉街道办事处', '220113012000', '220113000000');
INSERT INTO `t_s_town` VALUES ('7421', '兴港街道办事处', '220113013000', '220113000000');
INSERT INTO `t_s_town` VALUES ('7422', '沐石河街道办事处', '220113014000', '220113000000');
INSERT INTO `t_s_town` VALUES ('7423', '城子街街道办事处', '220113015000', '220113000000');
INSERT INTO `t_s_town` VALUES ('7424', '其塔木镇', '220113102000', '220113000000');
INSERT INTO `t_s_town` VALUES ('7425', '上河湾镇', '220113103000', '220113000000');
INSERT INTO `t_s_town` VALUES ('7426', '胡家回族乡', '220113200000', '220113000000');
INSERT INTO `t_s_town` VALUES ('7427', '莽卡满族乡', '220113201000', '220113000000');
INSERT INTO `t_s_town` VALUES ('7428', '兴农街道办事处', '220122001000', '220122000000');
INSERT INTO `t_s_town` VALUES ('7429', '宝塔街道办事处', '220122002000', '220122000000');
INSERT INTO `t_s_town` VALUES ('7430', '和谐街道办事处', '220122003000', '220122000000');
INSERT INTO `t_s_town` VALUES ('7431', '黄龙街道办事处', '220122004000', '220122000000');
INSERT INTO `t_s_town` VALUES ('7432', '农安镇', '220122100000', '220122000000');
INSERT INTO `t_s_town` VALUES ('7433', '伏龙泉镇', '220122101000', '220122000000');
INSERT INTO `t_s_town` VALUES ('7434', '哈拉海镇', '220122102000', '220122000000');
INSERT INTO `t_s_town` VALUES ('7435', '靠山镇', '220122103000', '220122000000');
INSERT INTO `t_s_town` VALUES ('7436', '开安镇', '220122104000', '220122000000');
INSERT INTO `t_s_town` VALUES ('7437', '烧锅镇', '220122105000', '220122000000');
INSERT INTO `t_s_town` VALUES ('7438', '高家店镇', '220122106000', '220122000000');
INSERT INTO `t_s_town` VALUES ('7439', '华家镇', '220122107000', '220122000000');
INSERT INTO `t_s_town` VALUES ('7440', '三盛玉镇', '220122108000', '220122000000');
INSERT INTO `t_s_town` VALUES ('7441', '巴吉垒镇', '220122109000', '220122000000');
INSERT INTO `t_s_town` VALUES ('7442', '三岗镇', '220122110000', '220122000000');
INSERT INTO `t_s_town` VALUES ('7443', '前岗乡', '220122200000', '220122000000');
INSERT INTO `t_s_town` VALUES ('7444', '龙王乡', '220122201000', '220122000000');
INSERT INTO `t_s_town` VALUES ('7445', '万顺乡', '220122203000', '220122000000');
INSERT INTO `t_s_town` VALUES ('7446', '杨树林乡', '220122204000', '220122000000');
INSERT INTO `t_s_town` VALUES ('7447', '永安乡', '220122205000', '220122000000');
INSERT INTO `t_s_town` VALUES ('7448', '青山口乡', '220122206000', '220122000000');
INSERT INTO `t_s_town` VALUES ('7449', '黄鱼圈乡', '220122207000', '220122000000');
INSERT INTO `t_s_town` VALUES ('7450', '新农乡', '220122208000', '220122000000');
INSERT INTO `t_s_town` VALUES ('7451', '万金塔乡', '220122209000', '220122000000');
INSERT INTO `t_s_town` VALUES ('7452', '小城子乡', '220122210000', '220122000000');
INSERT INTO `t_s_town` VALUES ('7453', '洼中高农场', '220122400000', '220122000000');
INSERT INTO `t_s_town` VALUES ('7454', '临河街道办事处', '220171001000', '220171000000');
INSERT INTO `t_s_town` VALUES ('7455', '东方广场街道办事处', '220171002000', '220171000000');
INSERT INTO `t_s_town` VALUES ('7456', '会展街道办事处', '220171003000', '220171000000');
INSERT INTO `t_s_town` VALUES ('7457', '世纪街道办事处', '220171004000', '220171000000');
INSERT INTO `t_s_town` VALUES ('7458', '兴隆山镇', '220171100000', '220171000000');
INSERT INTO `t_s_town` VALUES ('7459', '永兴街道办事处', '220172001000', '220172000000');
INSERT INTO `t_s_town` VALUES ('7460', '净月街道办事处', '220172002000', '220172000000');
INSERT INTO `t_s_town` VALUES ('7461', '福祉街道办事处', '220172003000', '220172000000');
INSERT INTO `t_s_town` VALUES ('7462', '德正街道办事处', '220172004000', '220172000000');
INSERT INTO `t_s_town` VALUES ('7463', '彩织街道办事处', '220172005000', '220172000000');
INSERT INTO `t_s_town` VALUES ('7464', '德容街道办事处', '220172006000', '220172000000');
INSERT INTO `t_s_town` VALUES ('7465', '博硕街道办事处', '220172007000', '220172000000');
INSERT INTO `t_s_town` VALUES ('7466', '新立城镇', '220172100000', '220172000000');
INSERT INTO `t_s_town` VALUES ('7467', '新湖镇', '220172101000', '220172000000');
INSERT INTO `t_s_town` VALUES ('7468', '玉潭镇', '220172102000', '220172000000');
INSERT INTO `t_s_town` VALUES ('7469', '硅谷街道办事处', '220173001000', '220173000000');
INSERT INTO `t_s_town` VALUES ('7470', '北湖街道办事处', '220173002000', '220173000000');
INSERT INTO `t_s_town` VALUES ('7471', '奋进乡', '220173200000', '220173000000');
INSERT INTO `t_s_town` VALUES ('7472', '双德乡', '220173201000', '220173000000');
INSERT INTO `t_s_town` VALUES ('7473', '锦程街道办事处', '220174001000', '220174000000');
INSERT INTO `t_s_town` VALUES ('7474', '东风街道办事处', '220174002000', '220174000000');
INSERT INTO `t_s_town` VALUES ('7475', '长春汽车经济技术开发区（特殊镇）', '220174100000', '220174000000');
INSERT INTO `t_s_town` VALUES ('7476', '华昌街道办事处', '220182001000', '220182000000');
INSERT INTO `t_s_town` VALUES ('7477', '正阳街道办事处', '220182002000', '220182000000');
INSERT INTO `t_s_town` VALUES ('7478', '培英街道办事处', '220182003000', '220182000000');
INSERT INTO `t_s_town` VALUES ('7479', '城郊街道办事处', '220182004000', '220182000000');
INSERT INTO `t_s_town` VALUES ('7480', '五棵树镇', '220182100000', '220182000000');
INSERT INTO `t_s_town` VALUES ('7481', '弓棚镇', '220182101000', '220182000000');
INSERT INTO `t_s_town` VALUES ('7482', '闵家镇', '220182102000', '220182000000');
INSERT INTO `t_s_town` VALUES ('7483', '大坡镇', '220182103000', '220182000000');
INSERT INTO `t_s_town` VALUES ('7484', '黑林镇', '220182104000', '220182000000');
INSERT INTO `t_s_town` VALUES ('7485', '土桥镇', '220182105000', '220182000000');
INSERT INTO `t_s_town` VALUES ('7486', '新立镇', '220182106000', '220182000000');
INSERT INTO `t_s_town` VALUES ('7487', '大岭镇', '220182107000', '220182000000');
INSERT INTO `t_s_town` VALUES ('7488', '于家镇', '220182108000', '220182000000');
INSERT INTO `t_s_town` VALUES ('7489', '泗河镇', '220182109000', '220182000000');
INSERT INTO `t_s_town` VALUES ('7490', '八号镇', '220182110000', '220182000000');
INSERT INTO `t_s_town` VALUES ('7491', '刘家镇', '220182111000', '220182000000');
INSERT INTO `t_s_town` VALUES ('7492', '秀水镇', '220182112000', '220182000000');
INSERT INTO `t_s_town` VALUES ('7493', '保寿镇', '220182113000', '220182000000');
INSERT INTO `t_s_town` VALUES ('7494', '新庄镇', '220182114000', '220182000000');
INSERT INTO `t_s_town` VALUES ('7495', '育民乡', '220182200000', '220182000000');
INSERT INTO `t_s_town` VALUES ('7496', '红星乡', '220182201000', '220182000000');
INSERT INTO `t_s_town` VALUES ('7497', '太安乡', '220182202000', '220182000000');
INSERT INTO `t_s_town` VALUES ('7498', '先峰乡', '220182203000', '220182000000');
INSERT INTO `t_s_town` VALUES ('7499', '青山乡', '220182204000', '220182000000');
INSERT INTO `t_s_town` VALUES ('7500', '延和朝鲜族乡', '220182205000', '220182000000');
INSERT INTO `t_s_town` VALUES ('7501', '恩育乡', '220182206000', '220182000000');
INSERT INTO `t_s_town` VALUES ('7502', '城发乡', '220182207000', '220182000000');
INSERT INTO `t_s_town` VALUES ('7503', '环城乡', '220182208000', '220182000000');
INSERT INTO `t_s_town` VALUES ('7504', '胜利街道办事处', '220183001000', '220183000000');
INSERT INTO `t_s_town` VALUES ('7505', '建设街道办事处', '220183002000', '220183000000');
INSERT INTO `t_s_town` VALUES ('7506', '惠发街道办事处', '220183003000', '220183000000');
INSERT INTO `t_s_town` VALUES ('7507', '夏家店街道办事处', '220183004000', '220183000000');
INSERT INTO `t_s_town` VALUES ('7508', '大青嘴镇', '220183100000', '220183000000');
INSERT INTO `t_s_town` VALUES ('7509', '郭家镇', '220183101000', '220183000000');
INSERT INTO `t_s_town` VALUES ('7510', '松花江镇', '220183102000', '220183000000');
INSERT INTO `t_s_town` VALUES ('7511', '达家沟镇', '220183103000', '220183000000');
INSERT INTO `t_s_town` VALUES ('7512', '大房身镇', '220183104000', '220183000000');
INSERT INTO `t_s_town` VALUES ('7513', '岔路口镇', '220183105000', '220183000000');
INSERT INTO `t_s_town` VALUES ('7514', '朱城子镇', '220183106000', '220183000000');
INSERT INTO `t_s_town` VALUES ('7515', '布海镇', '220183107000', '220183000000');
INSERT INTO `t_s_town` VALUES ('7516', '天台镇', '220183108000', '220183000000');
INSERT INTO `t_s_town` VALUES ('7517', '菜园子镇', '220183109000', '220183000000');
INSERT INTO `t_s_town` VALUES ('7518', '同太乡', '220183200000', '220183000000');
INSERT INTO `t_s_town` VALUES ('7519', '边岗乡', '220183201000', '220183000000');
INSERT INTO `t_s_town` VALUES ('7520', '五台乡', '220183202000', '220183000000');
INSERT INTO `t_s_town` VALUES ('7521', '朝阳乡', '220183203000', '220183000000');
INSERT INTO `t_s_town` VALUES ('7522', '兴华街道办事处', '220202001000', '220202000000');
INSERT INTO `t_s_town` VALUES ('7523', '文庙街道办事处', '220202002000', '220202000000');
INSERT INTO `t_s_town` VALUES ('7524', '东局子街道办事处', '220202003000', '220202000000');
INSERT INTO `t_s_town` VALUES ('7525', '新地号街道办事处', '220202004000', '220202000000');
INSERT INTO `t_s_town` VALUES ('7526', '延安街道办事处', '220202005000', '220202000000');
INSERT INTO `t_s_town` VALUES ('7527', '站前街道办事处', '220202006000', '220202000000');
INSERT INTO `t_s_town` VALUES ('7528', '民主街道办事处', '220202007000', '220202000000');
INSERT INTO `t_s_town` VALUES ('7529', '莲花街道办事处', '220202008000', '220202000000');
INSERT INTO `t_s_town` VALUES ('7530', '通江街道办事处', '220202009000', '220202000000');
INSERT INTO `t_s_town` VALUES ('7531', '哈达湾街道办事处', '220202010000', '220202000000');
INSERT INTO `t_s_town` VALUES ('7532', '新建街道办事处', '220202011000', '220202000000');
INSERT INTO `t_s_town` VALUES ('7533', '延江街道办事处', '220202012000', '220202000000');
INSERT INTO `t_s_town` VALUES ('7534', '吉林东市商贸示范区（特殊街道）', '220202071000', '220202000000');
INSERT INTO `t_s_town` VALUES ('7535', '孤店子镇', '220202100000', '220202000000');
INSERT INTO `t_s_town` VALUES ('7536', '桦皮厂镇', '220202101000', '220202000000');
INSERT INTO `t_s_town` VALUES ('7537', '左家镇', '220202102000', '220202000000');
INSERT INTO `t_s_town` VALUES ('7538', '两家子满族乡', '220202200000', '220202000000');
INSERT INTO `t_s_town` VALUES ('7539', '土城子满族朝鲜族乡', '220202201000', '220202000000');
INSERT INTO `t_s_town` VALUES ('7540', '幸福经济管理区', '220202401000', '220202000000');
INSERT INTO `t_s_town` VALUES ('7541', '吉林哈达湾经济开发区', '220202402000', '220202000000');
INSERT INTO `t_s_town` VALUES ('7542', '龙华街道办事处', '220203001000', '220203000000');
INSERT INTO `t_s_town` VALUES ('7543', '湘潭街道办事处', '220203002000', '220203000000');
INSERT INTO `t_s_town` VALUES ('7544', '铁东街道办事处', '220203003000', '220203000000');
INSERT INTO `t_s_town` VALUES ('7545', '泡子沿街道办事处', '220203004000', '220203000000');
INSERT INTO `t_s_town` VALUES ('7546', '龙潭街道办事处', '220203005000', '220203000000');
INSERT INTO `t_s_town` VALUES ('7547', '新吉林街道办事处', '220203006000', '220203000000');
INSERT INTO `t_s_town` VALUES ('7548', '山前街道办事处', '220203007000', '220203000000');
INSERT INTO `t_s_town` VALUES ('7549', '新安街道办事处', '220203008000', '220203000000');
INSERT INTO `t_s_town` VALUES ('7550', '遵义街道办事处', '220203009000', '220203000000');
INSERT INTO `t_s_town` VALUES ('7551', '榆树街道办事处', '220203010000', '220203000000');
INSERT INTO `t_s_town` VALUES ('7552', '东城街道办事处', '220203012000', '220203000000');
INSERT INTO `t_s_town` VALUES ('7553', '承德街道办事处', '220203013000', '220203000000');
INSERT INTO `t_s_town` VALUES ('7554', '靠山街道办事处', '220203072000', '220203000000');
INSERT INTO `t_s_town` VALUES ('7555', '乌拉街镇', '220203100000', '220203000000');
INSERT INTO `t_s_town` VALUES ('7556', '缸窑镇', '220203101000', '220203000000');
INSERT INTO `t_s_town` VALUES ('7557', '江密峰镇', '220203102000', '220203000000');
INSERT INTO `t_s_town` VALUES ('7558', '大口钦镇', '220203103000', '220203000000');
INSERT INTO `t_s_town` VALUES ('7559', '金珠镇', '220203104000', '220203000000');
INSERT INTO `t_s_town` VALUES ('7560', '江北乡', '220203200000', '220203000000');
INSERT INTO `t_s_town` VALUES ('7561', '龙潭经济开发区', '220203400000', '220203000000');
INSERT INTO `t_s_town` VALUES ('7562', '金珠工业区', '220203401000', '220203000000');
INSERT INTO `t_s_town` VALUES ('7563', '德胜街道办事处', '220204001000', '220204000000');
INSERT INTO `t_s_town` VALUES ('7564', '南京街道办事处', '220204002000', '220204000000');
INSERT INTO `t_s_town` VALUES ('7565', '大东街道办事处', '220204003000', '220204000000');
INSERT INTO `t_s_town` VALUES ('7566', '青岛街道办事处', '220204004000', '220204000000');
INSERT INTO `t_s_town` VALUES ('7567', '向阳街道办事处', '220204005000', '220204000000');
INSERT INTO `t_s_town` VALUES ('7568', '北极街道办事处', '220204006000', '220204000000');
INSERT INTO `t_s_town` VALUES ('7569', '致和街道办事处', '220204007000', '220204000000');
INSERT INTO `t_s_town` VALUES ('7570', '长春路街道办事处', '220204008000', '220204000000');
INSERT INTO `t_s_town` VALUES ('7571', '临江街道办事处', '220204009000', '220204000000');
INSERT INTO `t_s_town` VALUES ('7572', '北山街道办事处', '220204010000', '220204000000');
INSERT INTO `t_s_town` VALUES ('7573', '黄旗街道办事处', '220204011000', '220204000000');
INSERT INTO `t_s_town` VALUES ('7574', '大绥河镇', '220204100000', '220204000000');
INSERT INTO `t_s_town` VALUES ('7575', '搜登站镇', '220204101000', '220204000000');
INSERT INTO `t_s_town` VALUES ('7576', '越北镇', '220204102000', '220204000000');
INSERT INTO `t_s_town` VALUES ('7577', '欢喜乡', '220204200000', '220204000000');
INSERT INTO `t_s_town` VALUES ('7578', '吉林船营经济开发区', '220204400000', '220204000000');
INSERT INTO `t_s_town` VALUES ('7579', '泰山街道办事处', '220211001000', '220211000000');
INSERT INTO `t_s_town` VALUES ('7580', '江南街道办事处', '220211002000', '220211000000');
INSERT INTO `t_s_town` VALUES ('7581', '石井街道办事处', '220211003000', '220211000000');
INSERT INTO `t_s_town` VALUES ('7582', '沿丰街道办事处', '220211004000', '220211000000');
INSERT INTO `t_s_town` VALUES ('7583', '丰满街道办事处', '220211005000', '220211000000');
INSERT INTO `t_s_town` VALUES ('7584', '红旗街道办事处', '220211071000', '220211000000');
INSERT INTO `t_s_town` VALUES ('7585', '旺起镇', '220211100000', '220211000000');
INSERT INTO `t_s_town` VALUES ('7586', '江南乡', '220211200000', '220211000000');
INSERT INTO `t_s_town` VALUES ('7587', '前二道乡', '220211201000', '220211000000');
INSERT INTO `t_s_town` VALUES ('7588', '小白山乡', '220211270000', '220211000000');
INSERT INTO `t_s_town` VALUES ('7589', '口前镇', '220221100000', '220221000000');
INSERT INTO `t_s_town` VALUES ('7590', '双河镇', '220221101000', '220221000000');
INSERT INTO `t_s_town` VALUES ('7591', '西阳镇', '220221102000', '220221000000');
INSERT INTO `t_s_town` VALUES ('7592', '北大湖镇', '220221103000', '220221000000');
INSERT INTO `t_s_town` VALUES ('7593', '一拉溪镇', '220221104000', '220221000000');
INSERT INTO `t_s_town` VALUES ('7594', '万昌镇', '220221171000', '220221000000');
INSERT INTO `t_s_town` VALUES ('7595', '永吉经济开发区（特殊乡镇）', '220221172000', '220221000000');
INSERT INTO `t_s_town` VALUES ('7596', '金家乡', '220221200000', '220221000000');
INSERT INTO `t_s_town` VALUES ('7597', '黄榆乡', '220221201000', '220221000000');
INSERT INTO `t_s_town` VALUES ('7598', '九站街道办事处', '220271001000', '220271000000');
INSERT INTO `t_s_town` VALUES ('7599', '双吉街道办事处', '220271013000', '220271000000');
INSERT INTO `t_s_town` VALUES ('7600', '高新开发区街道办事处', '220272001000', '220272000000');
INSERT INTO `t_s_town` VALUES ('7601', '新北街道办事处', '220272002000', '220272000000');
INSERT INTO `t_s_town` VALUES ('7602', '岔路河镇', '220273100000', '220273000000');
INSERT INTO `t_s_town` VALUES ('7603', '民主街道办事处', '220281001000', '220281000000');
INSERT INTO `t_s_town` VALUES ('7604', '长安街道办事处', '220281002000', '220281000000');
INSERT INTO `t_s_town` VALUES ('7605', '河南街道办事处', '220281003000', '220281000000');
INSERT INTO `t_s_town` VALUES ('7606', '奶子山街道办事处', '220281004000', '220281000000');
INSERT INTO `t_s_town` VALUES ('7607', '拉法街道办事处', '220281005000', '220281000000');
INSERT INTO `t_s_town` VALUES ('7608', '河北街道办事处', '220281006000', '220281000000');
INSERT INTO `t_s_town` VALUES ('7609', '新农街道办事处', '220281007000', '220281000000');
INSERT INTO `t_s_town` VALUES ('7610', '新站镇', '220281100000', '220281000000');
INSERT INTO `t_s_town` VALUES ('7611', '天岗镇', '220281101000', '220281000000');
INSERT INTO `t_s_town` VALUES ('7612', '白石山镇', '220281102000', '220281000000');
INSERT INTO `t_s_town` VALUES ('7613', '漂河镇', '220281103000', '220281000000');
INSERT INTO `t_s_town` VALUES ('7614', '黄松甸镇', '220281104000', '220281000000');
INSERT INTO `t_s_town` VALUES ('7615', '天北镇', '220281105000', '220281000000');
INSERT INTO `t_s_town` VALUES ('7616', '松江镇', '220281106000', '220281000000');
INSERT INTO `t_s_town` VALUES ('7617', '庆岭镇', '220281107000', '220281000000');
INSERT INTO `t_s_town` VALUES ('7618', '乌林朝鲜族乡', '220281200000', '220281000000');
INSERT INTO `t_s_town` VALUES ('7619', '前进乡', '220281201000', '220281000000');
INSERT INTO `t_s_town` VALUES ('7620', '明桦街道办事处', '220282001000', '220282000000');
INSERT INTO `t_s_town` VALUES ('7621', '永吉街道办事处', '220282002000', '220282000000');
INSERT INTO `t_s_town` VALUES ('7622', '胜利街道办事处', '220282003000', '220282000000');
INSERT INTO `t_s_town` VALUES ('7623', '新华街道办事处', '220282004000', '220282000000');
INSERT INTO `t_s_town` VALUES ('7624', '启新街道办事处', '220282005000', '220282000000');
INSERT INTO `t_s_town` VALUES ('7625', '夹皮沟镇', '220282100000', '220282000000');
INSERT INTO `t_s_town` VALUES ('7626', '二道甸子镇', '220282101000', '220282000000');
INSERT INTO `t_s_town` VALUES ('7627', '红石砬子镇', '220282102000', '220282000000');
INSERT INTO `t_s_town` VALUES ('7628', '八道河子镇', '220282103000', '220282000000');
INSERT INTO `t_s_town` VALUES ('7629', '常山镇', '220282104000', '220282000000');
INSERT INTO `t_s_town` VALUES ('7630', '金沙镇', '220282105000', '220282000000');
INSERT INTO `t_s_town` VALUES ('7631', '桦郊乡', '220282200000', '220282000000');
INSERT INTO `t_s_town` VALUES ('7632', '横道河子乡', '220282201000', '220282000000');
INSERT INTO `t_s_town` VALUES ('7633', '公吉乡', '220282204000', '220282000000');
INSERT INTO `t_s_town` VALUES ('7634', '北城街道办事处', '220283001000', '220283000000');
INSERT INTO `t_s_town` VALUES ('7635', '南城街道办事处', '220283002000', '220283000000');
INSERT INTO `t_s_town` VALUES ('7636', '环城街道办事处', '220283003000', '220283000000');
INSERT INTO `t_s_town` VALUES ('7637', '吉舒街道办事处', '220283004000', '220283000000');
INSERT INTO `t_s_town` VALUES ('7638', '滨河街道办事处', '220283005000', '220283000000');
INSERT INTO `t_s_town` VALUES ('7639', '法特镇', '220283100000', '220283000000');
INSERT INTO `t_s_town` VALUES ('7640', '白旗镇', '220283101000', '220283000000');
INSERT INTO `t_s_town` VALUES ('7641', '溪河镇', '220283102000', '220283000000');
INSERT INTO `t_s_town` VALUES ('7642', '朝阳镇', '220283103000', '220283000000');
INSERT INTO `t_s_town` VALUES ('7643', '小城镇', '220283104000', '220283000000');
INSERT INTO `t_s_town` VALUES ('7644', '上营镇', '220283105000', '220283000000');
INSERT INTO `t_s_town` VALUES ('7645', '水曲柳镇', '220283106000', '220283000000');
INSERT INTO `t_s_town` VALUES ('7646', '平安镇', '220283107000', '220283000000');
INSERT INTO `t_s_town` VALUES ('7647', '金马镇', '220283108000', '220283000000');
INSERT INTO `t_s_town` VALUES ('7648', '开原镇', '220283109000', '220283000000');
INSERT INTO `t_s_town` VALUES ('7649', '莲花乡', '220283200000', '220283000000');
INSERT INTO `t_s_town` VALUES ('7650', '亮甲山乡', '220283201000', '220283000000');
INSERT INTO `t_s_town` VALUES ('7651', '新安乡', '220283202000', '220283000000');
INSERT INTO `t_s_town` VALUES ('7652', '七里乡', '220283203000', '220283000000');
INSERT INTO `t_s_town` VALUES ('7653', '天德乡', '220283204000', '220283000000');
INSERT INTO `t_s_town` VALUES ('7654', '福安街道办事处', '220284001000', '220284000000');
INSERT INTO `t_s_town` VALUES ('7655', '东宁街道办事处', '220284002000', '220284000000');
INSERT INTO `t_s_town` VALUES ('7656', '河南街道办事处', '220284003000', '220284000000');
INSERT INTO `t_s_town` VALUES ('7657', '磐石经济开发区（省级）（特殊街道）', '220284070000', '220284000000');
INSERT INTO `t_s_town` VALUES ('7658', '烟筒山镇', '220284100000', '220284000000');
INSERT INTO `t_s_town` VALUES ('7659', '红旗岭镇', '220284101000', '220284000000');
INSERT INTO `t_s_town` VALUES ('7660', '明城镇', '220284102000', '220284000000');
INSERT INTO `t_s_town` VALUES ('7661', '石嘴镇', '220284103000', '220284000000');
INSERT INTO `t_s_town` VALUES ('7662', '驿马镇', '220284104000', '220284000000');
INSERT INTO `t_s_town` VALUES ('7663', '牛心镇', '220284105000', '220284000000');
INSERT INTO `t_s_town` VALUES ('7664', '呼兰镇', '220284106000', '220284000000');
INSERT INTO `t_s_town` VALUES ('7665', '吉昌镇', '220284107000', '220284000000');
INSERT INTO `t_s_town` VALUES ('7666', '松山镇', '220284108000', '220284000000');
INSERT INTO `t_s_town` VALUES ('7667', '黑石镇', '220284109000', '220284000000');
INSERT INTO `t_s_town` VALUES ('7668', '朝阳山镇', '220284110000', '220284000000');
INSERT INTO `t_s_town` VALUES ('7669', '富太镇', '220284111000', '220284000000');
INSERT INTO `t_s_town` VALUES ('7670', '取柴河镇', '220284112000', '220284000000');
INSERT INTO `t_s_town` VALUES ('7671', '宝山乡', '220284200000', '220284000000');
INSERT INTO `t_s_town` VALUES ('7672', '仁兴街道办事处', '220302001000', '220302000000');
INSERT INTO `t_s_town` VALUES ('7673', '英雄街道办事处', '220302002000', '220302000000');
INSERT INTO `t_s_town` VALUES ('7674', '站前街道办事处', '220302003000', '220302000000');
INSERT INTO `t_s_town` VALUES ('7675', '北沟街道办事处', '220302004000', '220302000000');
INSERT INTO `t_s_town` VALUES ('7676', '地直街道办事处', '220302005000', '220302000000');
INSERT INTO `t_s_town` VALUES ('7677', '平西乡', '220302200000', '220302000000');
INSERT INTO `t_s_town` VALUES ('7678', '红嘴高新技术开发区', '220302400000', '220302000000');
INSERT INTO `t_s_town` VALUES ('7679', '平东街道办事处', '220303001000', '220303000000');
INSERT INTO `t_s_town` VALUES ('7680', '北市场街道办事处', '220303002000', '220303000000');
INSERT INTO `t_s_town` VALUES ('7681', '七马路街道办事处', '220303003000', '220303000000');
INSERT INTO `t_s_town` VALUES ('7682', '四马路街道办事处', '220303004000', '220303000000');
INSERT INTO `t_s_town` VALUES ('7683', '解放街道办事处', '220303005000', '220303000000');
INSERT INTO `t_s_town` VALUES ('7684', '北门街道办事处', '220303006000', '220303000000');
INSERT INTO `t_s_town` VALUES ('7685', '黄土坑街道办事处', '220303007000', '220303000000');
INSERT INTO `t_s_town` VALUES ('7686', '平南街道办事处', '220303008000', '220303000000');
INSERT INTO `t_s_town` VALUES ('7687', '山门镇', '220303100000', '220303000000');
INSERT INTO `t_s_town` VALUES ('7688', '石岭镇', '220303101000', '220303000000');
INSERT INTO `t_s_town` VALUES ('7689', '叶赫满族镇', '220303102000', '220303000000');
INSERT INTO `t_s_town` VALUES ('7690', '四平经济开发区（省级）（特殊乡镇）', '220303170000', '220303000000');
INSERT INTO `t_s_town` VALUES ('7691', '城东乡', '220303200000', '220303000000');
INSERT INTO `t_s_town` VALUES ('7692', '梨树镇', '220322100000', '220322000000');
INSERT INTO `t_s_town` VALUES ('7693', '郭家店镇', '220322101000', '220322000000');
INSERT INTO `t_s_town` VALUES ('7694', '榆树台镇', '220322102000', '220322000000');
INSERT INTO `t_s_town` VALUES ('7695', '孤家子镇（四平辽河农垦管理区）', '220322103000', '220322000000');
INSERT INTO `t_s_town` VALUES ('7696', '小城子镇', '220322104000', '220322000000');
INSERT INTO `t_s_town` VALUES ('7697', '喇嘛甸镇', '220322105000', '220322000000');
INSERT INTO `t_s_town` VALUES ('7698', '蔡家镇', '220322106000', '220322000000');
INSERT INTO `t_s_town` VALUES ('7699', '刘家馆子镇', '220322107000', '220322000000');
INSERT INTO `t_s_town` VALUES ('7700', '十家堡镇', '220322108000', '220322000000');
INSERT INTO `t_s_town` VALUES ('7701', '孟家岭镇', '220322109000', '220322000000');
INSERT INTO `t_s_town` VALUES ('7702', '万发镇', '220322110000', '220322000000');
INSERT INTO `t_s_town` VALUES ('7703', '东河镇', '220322111000', '220322000000');
INSERT INTO `t_s_town` VALUES ('7704', '沈洋镇', '220322112000', '220322000000');
INSERT INTO `t_s_town` VALUES ('7705', '林海镇', '220322113000', '220322000000');
INSERT INTO `t_s_town` VALUES ('7706', '小宽镇', '220322114000', '220322000000');
INSERT INTO `t_s_town` VALUES ('7707', '白山乡', '220322200000', '220322000000');
INSERT INTO `t_s_town` VALUES ('7708', '泉眼岭乡', '220322201000', '220322000000');
INSERT INTO `t_s_town` VALUES ('7709', '胜利乡', '220322202000', '220322000000');
INSERT INTO `t_s_town` VALUES ('7710', '四棵树乡', '220322203000', '220322000000');
INSERT INTO `t_s_town` VALUES ('7711', '双河乡', '220322204000', '220322000000');
INSERT INTO `t_s_town` VALUES ('7712', '金山乡', '220322205000', '220322000000');
INSERT INTO `t_s_town` VALUES ('7713', '国营梨树农场（四平辽河农垦管理区）', '220322400000', '220322000000');
INSERT INTO `t_s_town` VALUES ('7714', '良种场生产区', '220322405000', '220322000000');
INSERT INTO `t_s_town` VALUES ('7715', '永盛街道办事处', '220323001000', '220323000000');
INSERT INTO `t_s_town` VALUES ('7716', '永宁街道办事处', '220323002000', '220323000000');
INSERT INTO `t_s_town` VALUES ('7717', '伊通镇', '220323100000', '220323000000');
INSERT INTO `t_s_town` VALUES ('7718', '二道镇', '220323101000', '220323000000');
INSERT INTO `t_s_town` VALUES ('7719', '伊丹镇', '220323102000', '220323000000');
INSERT INTO `t_s_town` VALUES ('7720', '马鞍镇', '220323103000', '220323000000');
INSERT INTO `t_s_town` VALUES ('7721', '景台镇', '220323104000', '220323000000');
INSERT INTO `t_s_town` VALUES ('7722', '靠山镇', '220323105000', '220323000000');
INSERT INTO `t_s_town` VALUES ('7723', '大孤山镇', '220323106000', '220323000000');
INSERT INTO `t_s_town` VALUES ('7724', '小孤山镇', '220323107000', '220323000000');
INSERT INTO `t_s_town` VALUES ('7725', '营城子镇', '220323108000', '220323000000');
INSERT INTO `t_s_town` VALUES ('7726', '西苇镇', '220323109000', '220323000000');
INSERT INTO `t_s_town` VALUES ('7727', '河源镇', '220323110000', '220323000000');
INSERT INTO `t_s_town` VALUES ('7728', '黄岭子镇', '220323111000', '220323000000');
INSERT INTO `t_s_town` VALUES ('7729', '新兴乡', '220323200000', '220323000000');
INSERT INTO `t_s_town` VALUES ('7730', '莫里青乡', '220323201000', '220323000000');
INSERT INTO `t_s_town` VALUES ('7731', '三道乡', '220323202000', '220323000000');
INSERT INTO `t_s_town` VALUES ('7732', '河南街道办事处', '220381001000', '220381000000');
INSERT INTO `t_s_town` VALUES ('7733', '河北街道办事处', '220381002000', '220381000000');
INSERT INTO `t_s_town` VALUES ('7734', '东三街道办事处', '220381003000', '220381000000');
INSERT INTO `t_s_town` VALUES ('7735', '岭东街道办事处', '220381004000', '220381000000');
INSERT INTO `t_s_town` VALUES ('7736', '铁北街道办事处', '220381005000', '220381000000');
INSERT INTO `t_s_town` VALUES ('7737', '岭西街道办事处', '220381006000', '220381000000');
INSERT INTO `t_s_town` VALUES ('7738', '刘房子街道办事处', '220381007000', '220381000000');
INSERT INTO `t_s_town` VALUES ('7739', '南崴子街道办事处', '220381008000', '220381000000');
INSERT INTO `t_s_town` VALUES ('7740', '环岭街道办事处', '220381009000', '220381000000');
INSERT INTO `t_s_town` VALUES ('7741', '苇子沟街道办事处', '220381010000', '220381000000');
INSERT INTO `t_s_town` VALUES ('7742', '二十家子镇', '220381100000', '220381000000');
INSERT INTO `t_s_town` VALUES ('7743', '黑林子镇', '220381101000', '220381000000');
INSERT INTO `t_s_town` VALUES ('7744', '陶家屯镇', '220381102000', '220381000000');
INSERT INTO `t_s_town` VALUES ('7745', '范家屯镇', '220381103000', '220381000000');
INSERT INTO `t_s_town` VALUES ('7746', '响水镇', '220381104000', '220381000000');
INSERT INTO `t_s_town` VALUES ('7747', '大岭镇', '220381105000', '220381000000');
INSERT INTO `t_s_town` VALUES ('7748', '怀德镇', '220381106000', '220381000000');
INSERT INTO `t_s_town` VALUES ('7749', '双城堡镇', '220381107000', '220381000000');
INSERT INTO `t_s_town` VALUES ('7750', '双龙镇', '220381108000', '220381000000');
INSERT INTO `t_s_town` VALUES ('7751', '杨大城子镇', '220381109000', '220381000000');
INSERT INTO `t_s_town` VALUES ('7752', '毛城子镇', '220381110000', '220381000000');
INSERT INTO `t_s_town` VALUES ('7753', '玻璃城子镇', '220381111000', '220381000000');
INSERT INTO `t_s_town` VALUES ('7754', '朝阳坡镇', '220381112000', '220381000000');
INSERT INTO `t_s_town` VALUES ('7755', '大榆树镇', '220381113000', '220381000000');
INSERT INTO `t_s_town` VALUES ('7756', '秦家屯镇', '220381114000', '220381000000');
INSERT INTO `t_s_town` VALUES ('7757', '八屋镇', '220381115000', '220381000000');
INSERT INTO `t_s_town` VALUES ('7758', '十屋镇', '220381116000', '220381000000');
INSERT INTO `t_s_town` VALUES ('7759', '桑树台镇', '220381117000', '220381000000');
INSERT INTO `t_s_town` VALUES ('7760', '龙山乡', '220381200000', '220381000000');
INSERT INTO `t_s_town` VALUES ('7761', '永发乡', '220381201000', '220381000000');
INSERT INTO `t_s_town` VALUES ('7762', '省原种繁殖场', '220381400000', '220381000000');
INSERT INTO `t_s_town` VALUES ('7763', '四平农科院', '220381401000', '220381000000');
INSERT INTO `t_s_town` VALUES ('7764', '公主岭市种猪场', '220381402000', '220381000000');
INSERT INTO `t_s_town` VALUES ('7765', '十屋农场', '220381403000', '220381000000');
INSERT INTO `t_s_town` VALUES ('7766', '十屋种牛场', '220381404000', '22