
import os
import sys

import network
import utime
from pins import Pins


def get_known_ssid(station, wifi_configs):
    print('Scan WiFi...')

    known_ssid = None
    for no in range(3):
        for info in station.scan():
            Pins.power_led.toggle()
            ssid, bssid, channel, RSSI, auth_mode, hidden = info
            ssid = ssid.decode("UTF-8")
            # print(
            #     'SSID: %s (channel: %s authmode: %s hidden: %s)' % (
            #         ssid, channel, auth_mode, hidden
            #     )
            # )
            if ssid in wifi_configs:
                known_ssid = ssid
        if known_ssid is not None:
            return known_ssid

    print('ERROR: No known WiFi SSID found!')
    Pins.power_led.flash(sleep=0.2, count=20)


def connect2ssid(station, ssid, password):
    for no in range(0, 3):
        # print('PHY mode: %s' % network.phy_mode())
        # print('Connect to Wifi access point:', ssid, repr(password))
        print('Connect to Wifi access point: %s' % ssid)
        Pins.power_led.toggle()
        station.connect(ssid, password)
        for wait_sec in range(30, 1, -1):
            status = station.status()
            if status == network.STAT_GOT_IP:
                Pins.power_led.on()
                print('Connected:', station.ifconfig())
                return utime.time()
            elif status == network.STAT_WRONG_PASSWORD:
                print('Wrong password!')
                return
            print('wait %i...' % wait_sec)
            Pins.power_led.flash(sleep=0.1, count=10)

        print('Try again...')
        station.disconnect()
        station.active(False)
        Pins.power_led.flash(sleep=0.1, count=20)
        Pins.power_led.off()
        station.active(True)

    print('Not connected!')
    Pins.power_led.flash(sleep=0.2, count=20)


def connect(context, station):
    station.active(True)  # activate the interface

    Pins.power_led.flash(sleep=0.1, count=5)

    print('read WiFi config...')

    # Rename old 'config.json' to new '_config_wifi.json'
    try:
        os.stat('config.json')  # Check if exists
    except OSError:
        pass
    else:
        os.rename('config.json', '_config_wifi.json')

    from config_files import get_json_config
    wifi_configs = get_json_config(key='wifi')

    del get_json_config
    del sys.modules['config_files']

    if wifi_configs is None:
        raise RuntimeError('Empty WiFi settings!')

    print('Set WiFi DHCP hostname to:', context.device_name)
    station.config(dhcp_hostname=context.device_name)

    try:
        known_ssid = get_known_ssid(station, wifi_configs)
    except OSError as e:
        print('Error get known SSID:', e)  # e.g.: 'scan failed'
        Pins.power_led.flash(sleep=0.4, count=20)
        return

    if known_ssid is None:
        print('Skip Wifi connection.')
    else:
        return connect2ssid(
            station=station,
            ssid=known_ssid,
            password=wifi_configs[known_ssid],
        )
