# Table

### Intro

Used to display the basic table

### Install

```tsx
import { Table } from '@nutui/nutui-react-native';
```

### Basic Usage

:::demo

```tsx
import  React, { useState } from "react";
import { Text } from 'react-native';
import { Table } from '@nutui/nutui-react-native';

interface TableColumnProps {
  key?: string
  title?: string
  align?: string
  sorter?: ((a: any, b: any) => number) | boolean | string
  render?: (rowData?: any, rowIndex?: number) => string | React.ReactNode
}

const App = () => {
  const [columns1, setColumns1] = useState<Array<TableColumnProps>>([
    {
      title: '姓名',
      key: 'name',
    },
    {
      title: '性别',
      key: 'sex',
      render: (record: any) => {
        return (
           <Text style={{ color: record.sex === '女' ? 'blue' : 'green' }}>
            {record.sex}
          </Text>
        )
      },
    },
    {
      title: '学历',
      key: 'record',
    },
  ])

  const [data1, setData1] = useState([
    {
      name: 'Tom',
      sex: '男',
      record: '小学',
    },
    {
      name: 'Lucy',
      sex: '女',
      record: '本科',
    },
    {
      name: 'Jack',
      sex: '男',
      record: '高中',
    },
  ])

  return <Table columns={columns1} data={data1} />;
};
export default App;
```

:::

### Whether to display border and align text

:::demo

```tsx
import  React, { useState } from "react";
import { Table } from '@nutui/nutui-react-native';

interface TableColumnProps {
  key?: string
  title?: string
  align?: string
  sorter?: ((a: any, b: any) => number) | boolean | string
  render?: (rowData?: any, rowIndex?: number) => string | React.ReactNode
}

const App = () => {
  const [columns2, setColumns2] = useState([
    {
      title: '姓名',
      key: 'name',
      align: 'center',
    },
    {
      title: '性别',
      key: 'sex',
    },
    {
      title: '学历',
      key: 'record',
    },
  ])

  const [data1, setData1] = useState([
    {
      name: 'Tom',
      sex: '男',
      record: '小学',
    },
    {
      name: 'Lucy',
      sex: '女',
      record: '本科',
    },
    {
      name: 'Jack',
      sex: '男',
      record: '高中',
    },
  ])

  return <Table
        columns={columns2}
        data={data1}
        bordered={false}
    />;
};
export default App;
```

:::

### Show summary bar

:::demo

```tsx
import  React, { useState } from "react";
import { Text } from 'react-native';
import { Table, Button, Icon } from '@nutui/nutui-react-native';

const App = () => {
  const [columns1, setColumns1] = useState([
    {
      title: '姓名',
      key: 'name',
    },
    {
      title: '性别',
      key: 'sex',
      render: (record) => {
        return (
          <Text style={{ color: record.sex === '女' ? 'blue' : 'green' }}>
            {record.sex}
          </Text>
        )
      },
    },
    {
      title: '学历',
      key: 'record',
    },
  ])

  const [data1, setData1] = useState([
    {
      name: 'Tom',
      sex: '男',
      record: '小学',
    },
    {
      name: 'Lucy',
      sex: '女',
      record: '本科',
    },
    {
      name: 'Jack',
      sex: '男',
      record: '高中',
    },
  ])

  return <Table
    columns={columns1}
    data={data1}
    summary="这是总结栏"
/>;
};
export default App;
```

:::

### Stripes, alternating light and shade

:::demo

```tsx
import  React, { useState } from "react";
import { Text } from 'react-native';
import { Table } from '@nutui/nutui-react-native';

interface TableColumnProps {
  key?: string
  title?: string
  align?: string
  sorter?: ((a: any, b: any) => number) | boolean | string
  render?: (rowData?: any, rowIndex?: number) => string | React.ReactNode
}

const App = () => {
  const [columns1, setColumns1] = useState([
    {
      title: '姓名',
      key: 'name',
    },
    {
      title: '性别',
      key: 'sex',
      render: (record: any) => {
        return (
         <Text style={{ color: record.sex === '女' ? 'blue' : 'green' }}>
            {record.sex}
          </Text>
        )
      },
    },
    {
      title: '学历',
      key: 'record',
    },
  ])

  const [data1, setData1] = useState([
    {
      name: 'Tom',
      sex: '男',
      record: '小学',
    },
    {
      name: 'Lucy',
      sex: '女',
      record: '本科',
    },
    {
      name: 'Jack',
      sex: '男',
      record: '高中',
    },
  ])

  return <Table
        columns={columns1}
        data={data1}
        striped
    />;
};
export default App;
```

:::

### No data is displayed by default, and customization is supported

:::demo

```tsx
import  React, { useState } from "react";
import { Text } from 'react-native';
import { Table } from '@nutui/nutui-react-native';

interface TableColumnProps {
  key?: string
  title?: string
  align?: string
  sorter?: ((a: any, b: any) => number) | boolean | string
  render?: (rowData?: any, rowIndex?: number) => string | React.ReactNode
}

const App = () => {
  const [columns1, setColumns1] = useState([
    {
      title: '姓名',
      key: 'name',
    },
    {
      title: '性别',
      key: 'sex',
      render: (record: any) => {
        return (
          <Text style={{ color: record.sex === '女' ? 'blue' : 'green' }}>
            {record.sex}
          </Text>
        )
      },
    },
    {
      title: '学历',
      key: 'record',
    },
  ])

  const [data2, setData2] = useState([])

  return (
    <>
        <Table columns={columns1} data={data2} />
        <Table
          columns={columns1}
          data={data2}
          noData="这里是自定义展示"
        />
    </>
  );
};
export default App;
```

:::

### Custom cell

:::demo

```tsx
import  React, { useState } from "react";
import { Table, Button, Icon, Toast } from '@nutui/nutui-react-native';

const App = () => {
  const [columns4, setColumns4] = useState([
    {
      title: '姓名',
      key: 'name',
      align: 'center',
    },
    {
      title: '性别',
      key: 'sex',
    },
    {
      title: '学历',
      key: 'record',
    },
    {
      title: '操作',
      key: 'render',
    },
  ])

  const [data4, setData4] = useState([
    {
      name: 'Tom',
      sex: '男',
      record: '小学',
      render: () => {
        return (
          <Button
            onClick={() => Toast.text('hello')}
            size="small"
            type="primary"
          >
            Hello
          </Button>
        )
      },
    },
    {
      name: 'Lucy',
      sex: '女',
      record: '本科',
      render: () => {
        return <Icon name="dongdong" size={14} />
      },
    },
    {
      name: 'Jack',
      sex: '男',
      record: '高中',
      render: () => {
        return (
          <Button
            type="success"
            size="small"
            onClick={() => {}}
          >
            跳转到京东
          </Button>
        )
      },
    },
  ])

  return <Table columns={columns4} data={data4} />;
};
export default App;
```

:::

### Support asynchronous rendering

:::demo

```tsx
import  React, { useState } from "react";
import { Table, Button, Icon, Toast } from '@nutui/nutui-react-native';

const App = () => {
  const [columns4, setColumns4] = useState([
    {
      title: '姓名',
      key: 'name',
      align: 'center',
    },
    {
      title: '性别',
      key: 'sex',
    },
    {
      title: '学历',
      key: 'record',
    },
    {
      title: '操作',
      key: 'render',
    },
  ])

  const [data4, setData4] = useState([
    {
      name: 'Tom',
      sex: '男',
      record: '小学',
      render: () => {
        return (
          <Button
            onClick={() => Toast.text('hello')}
            size="small"
            type="primary"
          >
            Hello
          </Button>
        )
      },
    },
    {
      name: 'Lucy',
      sex: '女',
      record: '本科',
      render: () => {
        return <Icon name="dongdong" size={14} />
      },
    },
    {
      name: 'Jack',
      sex: '男',
      record: '高中',
      render: () => {
        return (
          <Button
            type="success"
            size="small"
            onClick={() => {}}
          >
            跳转到京东
          </Button>
        )
      },
    },
  ])

  return <Table columns={columns4} data={data4} />;
};
export default App;
```

:::

### Support sorting

:::demo

```tsx
import  React, { useState } from "react";
import { Table, Button, Icon, Toast } from '@nutui/nutui-react-native';

const App = () => {
  const [columns5] = useState([
    {
      title: '姓名',
      key: 'name',
      align: 'center',
      sorter: true
    },
    {
      title: '性别',
      key: 'sex'
    },
    {
      title: '学历',
      key: 'record'
    },
    {
      title: '年龄',
      key: 'age',
      sorter: true
    }
  ]);

  const [data5] = useState([
    {
      name: 'Tom',
      sex: '男',
      record: '小学',
      age: 10
    },
    {
      name: 'Lucy',
      sex: '女',
      record: '本科',
      age: 30
    },
    {
      name: 'Jack',
      sex: '男',
      record: '高中',
      age: 4
    }
  ]);

  return <Table
          columns={columns5}
          data={data5}
          onSorter={(item, data) => {
            alert(JSON.stringify(item));
          }}
        />
};
export default App;
```

:::

## API

### Props

| Attribute | Description                                  | Type               | Default |
| --------- | -------------------------------------------- | ------------------ | ------- |
| bordered  | Show border                                  | Boolean            | true    |
| columns   | Header data                                  | TableColumnProps[] | []      |
| data      | Table data                                   | Object[]           | []      |
| summary   | Show profile                                 | React.ReactNode    | -       |
| striped   | Whether the stripes alternate light and dark | Boolean            | false   |
| noData    | Custom noData                                | React.ReactNode    | -       |

### TableColumnProps

| Attribute | Description                                                                                                                                                                                                                                             | Type                      | Default |
| --------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------- | ------- |
| key       | Unique identification of the column                                                                                                                                                                                                                     | String                    | ''      |
| title     | Header title                                                                                                                                                                                                                                            | String                    | ''      |
| align     | Alignment of columns, optional values`left`,`center`,`right`                                                                                                                                                                                            | String                    | left    |
| sorter    | sort，optional values `true`,`function`, `default`, Where `default` means that you may depend on the interface after clicking, `function` you can return a specific sorting function, `default` indicates that the default sorting algorithm is adopted | Boolean、Function、String | -       |
| render    | Custom render column data, high priority                                                                                                                                                                                                                | Function(record)          | -       |

### Events

| Event    | Description                      | Arguments                                  |
| -------- | -------------------------------- | ------------------------------------------ |
| onSorter | Click the sort button to trigger | `item: TableColumnProps, data: Array<any>` |
