# Progress 進度條

### 介紹

展示操作或任務的當前進度。

### 安裝

```tsx
import { Progress, Icon } from '@nutui/nutui-react-native';
```

## 代碼演示

### 基礎用法

:::demo

```tsx
import  React from "react";
import { Progress, Cell } from '@nutui/nutui-react-native';

const App = () => {
  return (
    <Cell>
      <Progress
        percentage="30"
      />
    </Cell>
  );
};
export default App;
```

:::

### 線形進度條-設置顏色高度

:::demo

```tsx
import  React from "react";
import { Progress, Cell } from '@nutui/nutui-react-native';

const App = () => {
  return (
    <Cell>
      <Progress
        percentage="30"
        strokeColor="rgba(250,44,25,0.47)"
        stroke-width="20"
        textColor="red"
      />
    </Cell>
  );
};
export default App;
```

:::

### 百分比不顯示

:::demo

```tsx
import  React from "react";
import { Progress, Cell } from '@nutui/nutui-react-native';

const App = () => {
  return (
    <Cell>
      <Progress
        percentage="50"
        showText={false}
      />
    </Cell>
  );
};
export default App;
```

:::

### 百分比外顯

:::demo

```tsx
import  React from "react";
import { Progress, Cell } from '@nutui/nutui-react-native';

const App = () => {
  return (
    <Cell>
      <Progress
        percentage="30"
      />
    </Cell>
  );
};
export default App;
```

:::

### 百分比內顯

:::demo

```tsx
import  React from "react";
import { Progress, Cell } from '@nutui/nutui-react-native';

const App = () => {
  return (
    <Cell>
      <Progress
        percentage="60"
        textInside
      />
    </Cell>
  );
};
export default App;
```

:::

### 百分比內顯自定義

:::demo

```tsx
import  React from "react";
import { Progress, Icon, Cell } from '@nutui/nutui-react-native';

const App = () => {
  return (
    <Cell>
      <Progress
        percentage={60}
        textInside
      >
        <Icon
          size={30}
          name="https://img11.360buyimg.com/imagetools/jfs/t1/137646/13/7132/1648/5f4c748bE43da8ddd/a3f06d51dcae7b60.png"
        />
      </Progress>
    </Cell>
  );
};
export default App;
```

:::

### 自定義尺寸

:::demo

```tsx
import  React from "react";
import { Progress, Cell } from '@nutui/nutui-react-native';
import { View } from 'react-native';

const App = () => {
  return (
    <View>
    <Cell>
      <Progress
        percentage="30"
        size="small"
        textInside
      />
    </Cell>
    <Cell>
      <Progress
        percentage="50"
        size="base"
        textInside
      />
    </Cell>
    <Cell>
      <Progress
        percentage="70"
        size="large"
        textInside
      />
    </Cell>
    </View>
  );
};
export default App;
```

:::

### 狀態顯示

:::demo

```tsx
import  React from "react";
import { Progress, Icon, Cell } from '@nutui/nutui-react-native';
import { View } from 'react-native';

const App = () => {
  return (
    <View>
      <Cell>
        <Progress
            percentage={30}
            strokeColor={['#05ebd0', '#2f7bfc']}
        />
      </Cell>
      <Cell>
        <Progress
          percentage={100}
          strokeColor={['#a6ed59', '#2c9628']}
          >
            <Icon
                size={30}
                name='https://img11.360buyimg.com/imagetools/jfs/t1/137646/13/7132/1648/5f4c748bE43da8ddd/a3f06d51dcae7b60.png'
             />
        </Progress>
      </Cell>
    </View>
  );
};
export default App;
```

:::

### 動態改變

:::demo

```tsx
import  React from "react";
import { Progress, Cell, Button } from '@nutui/nutui-react-native';
import { View } from 'react-native';

const App = () => {
  const [value, setValue] = useState(0);
  return (
    <View>
    <Cell>
      <Progress
        percentage={value}
      />
    </Cell>
    <Cell>
      <Button
        type="default"
        style={{ margin: 8 }}
        onClick={() => {
          let num = value;
          if (value <= 0) {
            return false;
          }
          num -= 10;
          setValue(num);
        }}
      >
        减少
      </Button>
      <Button
        type="primary"
        onClick={() => {
          let num = value;
          if (value >= 100) {
            return false;
          }
          num += 10;
          setValue(num);
        }}
      >
        增加
      </Button>
    </Cell>
    </View>
  );
};
export default App;
```

:::

## API

### Props

| 屬性             | 說明                                                    | 類型    | 預設值                                            |
| ---------------- | ------------------------------------------------------- | ------- | ------------------------------------------------- |
| percentage       | 百分比                                                  | Number  | 0                                                 |
| isShowPercentage | 是否需要展示百分号                                      | Boolean | true                                              |
| fillColor        | 进度条填充颜色                                          | String  | #f3f3f3                                           |
| strokeColor      | 进度条线条背景色                                        | String  | linear-gradient(135deg, #fa2c19 0%, #fa6419 100%) |
| strokeWidth      | 进度条宽度                                              | String  | -                                                 |
| size             | 进度条及文字尺寸，可选值`small` `base` `large`          | String  | base                                              |
| showText         | 是否显示进度条文字内容                                  | Boolean | true                                              |
| textInside       | 进度条文字显示位置(`false`外显，`true`内显)             | Boolean | false                                             |
| textColor        | 进度条文字颜色设置                                      | String  | 外显`#333` 内显`#fff`                             |
| textWidth        | 进度条文字宽度                                          | String  | 35px                                              |
| textBackground   | 进度条文字背景颜色设置                                  | String  | 同进度条颜色                                      |
| textType         | 进度条文字类型，`text`(展示文字)/`icon`(展示 icon 标签) | String  | text                                              |
| iconName         | Icon 名称                                               | String  | checked                                           |
| iconColor        | Icon 颜色                                               | String  | #439422                                           |
| iconSize         | Icon 大小                                               | String  | 16px                                              |
