import {
  JSXTemplate,
  Image,
  H2,
  Link,
  T,
  Div,
  P,
  Span,
} from '../ai-design-system'

// kitwind.io/products/kometa/components/contents
export const blogLayout: JSXTemplate = {
  description: 'layout for blog content and simple personal pages',
  layout: (
    <div className="container mx-auto px-6 md:px-4">
      <header className="flex bg-white items-center justify-between py-6">
        <div className="hidden md:block">
          <Link className="flex items-center hover:opacity-70 transition duration-300 ease-in-out">
            <H2 className="text-2xl font-sans font-semibold">
              logo or brand name
            </H2>
          </Link>
        </div>
        <div className="block md:hidden">
          <Link className="flex items-center hover:opacity-70 transition duration-300 ease-in-out">
            <H2 className="text-2xl font-sans font-semibold">
              logo or brand name
            </H2>
          </Link>
        </div>
        <button
          className="hover:opacity-70 transition duration-300 ease-in-out text-black"
          id="menu-trigger"
        >
          <T>emoji menu icon</T>
        </button>
      </header>

      <div className="heading py-6 md:py-12 lg:w-10/12 ">
        <h1 className="heading text-4xl md:text-6xl font-bold font-sans md:leading-tight">
          <strong>
            <T>Main title highlight</T>
          </strong>{' '}
          <T>rest of the main title</T>
        </h1>
        <h2 className="text-xl text-gray-600 mt-2">main subtitle</h2>
      </div>

      <main className="py-6">
        <div className="mb-12">
          <div className="mb-12">
            <div className="flex flex-col md:flex-row w-full lg:w-10/12">
              <div className="md:mr-4 mb-2 md:mb-0 md:w-4/12 ">
                <Link className="bg-gray-100">
                  <Image
                    width={640}
                    height={360}
                    className="rounded mb-3 hover:opacity-70 transition duration-300 ease-in-out"
                  >
                    image of article 1
                  </Image>
                </Link>
                <div className="flex-1">
                  <div className="flex items-center">
                    <div className="flex ml-4">
                      <div className="flex items-center mr-2 -ml-4"></div>
                    </div>
                    <Div className="text-sm font-medium text-gray-700">
                      publication date of article 1
                    </Div>
                  </div>
                  <Link className="hover:text-green-400">
                    <H2 className="text-2xl font-semibold mb-1">
                      title of article 1
                    </H2>
                  </Link>
                  <P className="text-base font-light text-gray-600 mb-4">
                    summary of article 1
                  </P>

                  <div className="mb-2">
                    <Link className="p-1 px-3 mr-1 mb-1 inline-block text-xs font-mono rounded bg-green-200 text-green-800 hover:bg-blue-200 hover:text-blue-800 transition duration-300 ease-in-out">
                      some badge or tag
                    </Link>
                    <Link className="p-1 px-3 mr-1 mb-1 inline-block text-xs font-mono rounded bg-green-200 text-green-800 hover:bg-blue-200 hover:text-blue-800 transition duration-300 ease-in-out">
                      another badge or tag
                    </Link>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </main>

      <footer className="py-6 border-t-2">
        <div className="container mx-auto">
          <div className="flex mb-2">
            <Link className="py-2 mr-2">a link</Link>
            <Link className="py-2 mr-2">another link</Link>
          </div>
          <div className="text-sm text-gray-600">
            <Span>Generated by</Span>
            <Link className="text-green-500">The Latent Web</Link>
          </div>
        </div>
      </footer>
    </div>
  ),
}
