# The Latent Browser

*Hallucinating the latent web since 2022*

See one of the earliest demos here: [https://twitter.com/flngr/status/1609616068057698304](https://twitter.com/flngr/status/1609616068057698304)

<img src="https://raw.githubusercontent.com/jbilcke/web4/main/docs/images/screenshot-4.jpg?sanitize=true" width="100%" />

## Project status update (March 2024)

The Latent Browser is back after a year of hiatus!

By popular demand (see [this](https://twitter.com/flngr/status/1772588369932878089) or [this](https://twitter.com/TomDavenport/status/1774080950596481384) thread) an effort has been made to upgrade it to the latest version of the dependencies (well, most of them), and fix the code to make it run again!

Note: It has been a long time since I've worked on this project,
so a lot of things changed since then. I've had to migrate from Next 12 to Next 14, Webpack to Bun, davinci to GPT-4 etc.

It is still possible that some things are broken when you try it.

## What is The Latent Browser

The Latent Browser is a desktop application designed like a web browser,
which hallucinates web search results (the resultds are fictious and are generated by a LLM) and web pages.

## Technology

The Latent Browser is a web application designed to run locally on your machine.

The app is 99% React, Tailwind, TypeScript, and NextJS. 
The runtime is Tauri, which is written in Rust (but the Latent Browser itself doesn't really use Rust).

March 2024 update: I never really had the time to package it as a standalone "drag & drop install" application (well actually I did try but there were some bugs, and then I started working on other projects).

## Where can I get in touch / follow you?

I'm always working on various AI projects, so I've setup and Discord and all.

You can find more info by following my Linktree here: [https://linktr.ee/FLNGR](https://linktr.ee/FLNGR).

## How to run it

For the moment you need to fetch the code and run it on your machine.

### Prerequisites
Make sure you have installed the [prerequisites for your OS](https://tauri.app/v1/guides/getting-started/prerequisites):

```
curl -fsSL https://bun.sh/install | bash
curl https://sh.rustup.rs -sSf | sh
```

### Running the latent borwser

#### Running the standalone app (recommended for users)

```bash
bun i
bun tauri dev
```

#### Running the app in Chrome (recommended for developers)

```bash
bun i
bun next dev
open http://localhost:3000
```

### Packaging the Desktop app

To be continued (the app has been rebooted in March 2024, and most instructions are deprecated).

Note: The Latent Browser is using Tauri V2 but the doc isn't complete yet:
 https://beta.tauri.app/guides/build

## Using the browser

### Working (most of the time) examples

Here are some examples to get you started:

- `a back-office application to manage users. There is a table with editable cells, a button to add a new user, and a counter of users.`
- `a simulation of calculating PI by generating random dots inside a circle. The simulator should include a slider to adjust the speed, a reset button, and the current estimate of PI.`
- `a simple app to compute your BMI, using form inputs for age, height and weight (in kilos)`
- `a whack-a-mole game but with spiders, a css 3-per-3 grid, emojis, and JS code`
- `a clone of asteroid using <canvas>, the mouse should orient the spaceship, it should fire bullets when clicking, and bullets can destroy asteroids.`
- `website for a company selling time travel visit packages (great pyramids, Trojan wars..). The website features 3 polaroid pictures taken by tourists of those eras`

### Non-working examples

Those examples don't work yet.. maybe one day in text-davinci-004 or 005?

- `a 120 BPM drum machine made using tone.js, with a step sequencer made using html checkboxes, to indicate when to play. Each row should be a different instrument (kick, snare, hihat), 8 buttons per row. There is a button to start/stop.`

## FAQ

### The UI/UX should be improved

I agree!

### Uhh.. something went wrong

Try clicking again on generate 🎲

### No I mean, something went REALLY wrong

Maybe you did too many requests to OpenAI?

### I don't.. know?

Wait a bit then restart the application, eg. kill it from the terminal.

## Message to hackers

After reworking on the app again in March 2024, I've noticed that there are now two new build options in Tauri: Android and iOS.

But ATM I haven't really looked into it.

If you are interested to explore this, here are the commands:

```bash
# init
bun run tauri android init
bun run tauri ios init

# run
bun run tauri android dev
bun run tauri ios dev
```