<div align="center">
	<br />
	<br />
	<img src="./assets/logo.png" alt="DevHub LOGO" width="160" height="160">
	<h1>DevHub</h1>
  <!--rehype:style=border: 0;-->
  <p>
		<a href="./README.zh.md">中文</a> • 
		<a href="./README.ja.md">日本語</a> • 
		<a href="#frequently-asked-questions">FAQ</a> • 
		<a target="_blank" href="https://wangchujiang.com/#/contact">Contact & Support</a>
  </p>
  <p>
    <a target="_blank" href="https://apps.apple.com/app/devhub/id6476452351" title="DevHub AppStore"><img alt="DevHub AppStore" src="https://jaywcjlove.github.io/sb/download/macos.svg" height="51">
    </a>
    <a target="_blank" href="https://www.producthunt.com/posts/devhub-6?utm_source=badge-featured&amp;utm_medium=badge&amp;utm_souce=badge-devhub-6"><img alt="DevHub Product Hunt" src="https://jaywcjlove.github.io/sb/download/appstore.svg" height="51">
    </a>
  </p>
</div>

<div align="center">

minimum OS requirement: `macOS 14.0`

</div>

A feature-rich offline application, carefully crafted to support developers' daily tasks and ensure the highest security for their data.

I am actively developing it with a bold goal in mind: to release updates weekly. I strive to maintain a lean footprint, aiming to curate an extensive collection comprising over 100 utilities, providing developers with a diverse array of tools. This initiative reflects my commitment to continuous improvement, offering rich tools to empower developers. DevHub is more than just a coding companion;

![DevHub screenshots-1](./assets/screenshots-1.png)

The following tools have been completed:

- [x] File Info
- [x] Image Text Recognition
- [x] Filename Extractor
- [x] SSL Manager
- [x] Image Watermark
- [x] NPM Stat
- [x] Blur Privacy
- [x] Text Card
- [x] App Icons
- [x] Image Color Extraction
- [x] Highlight Cursor
- [x] Background Filler
- [x] API Request
- [x] Regex Expression Test
- [x] Chmod Calculator
- [x] Crontab Generator
- [x] Date Converters
- [x] Device Information
- [x] Generate Password
- [x] Life Countdown
- [x] Temperature Converter
- [x] Text To Speech
- [x] PX/REM Converter
- [x] Barcode Generator
- [x] Random Number Generator
- [x] Data Size Converter
- [x] QRCode Reader/Generator
- [x] WiFi QRCode Generator
- [x] Event QRCode Generator
- [x] Business Cards QRCode Generator
- [x] Random Port Generator
- [x] RSA Key Generator
- [x] Color Converters
- [x] Random Colors
- [x] Chronometer
- [x] ASCII To String
- [x] String To ASCII
- [x] Hash Generator
- [x] Basic Auth Generator
- [x] EXIF Viewer
- [x] Image To Base64
- [x] ICO Converter
- [x] HTML Encode/Decode
- [x] HTML Preview
- [x] String Explorer
- [x] Text To Base64
- [x] Text to Unicode
- [x] Text Case
- [x] Text Diff
- [x] Word Counter
- [x] Morse Alphabet
- [x] JSON Formatter
- [x] Lorem Ipsum Generator
- [x] UUID Generator
- [x] URL Parser
- [x] URL Encode/Decode

![DevHub screenshots-2](./assets/screenshots-2.png)
![DevHub screenshots-3](./assets/screenshots-3.png)
![DevHub screenshots-4](./assets/screenshots-4.png)
![DevHub screenshots-5](./assets/screenshots-5.png)
![DevHub screenshots-6](./assets/screenshots-6.png)
![DevHub screenshots-7](./assets/screenshots-7.png)

## Frequently Asked Questions

### DevHub Integrations

Integrations with DevHub are done via URL Scheme. You can use this to integrate with most apps and workflows. For example, integration with Raycast:

![DevHub + Raycast](./assets/raycast.png)

**URL Scheme**

DevHub supports various commands and parameters that allows you to activate the tool via a URL. For example, you can also use it as a link (e.g. in an HTML page) like this:

```html
<a href="devhub://qrCodeEventGenerator">Click Here</a>
```

Or from **Terminal.app / CLI:**

```bash
# Enter in Terminal.app or bash:
open "devhub://qrCodeEventGenerator"
```

Or copy this to your browser address bar and hit Enter: `devhub://qrCodeEventGenerator`

<!--idoc:config:
title: Developer Integration Tools - 
-->