
**Prerequisites:** 

* [Java Development Kit 8](http://www.oracle.com/technetwork/java/javase/downloads/index.html)
* [Maven 3.5.x](https://maven.apache.org/download.cgi) 
* [Angular cli 1.6.3 ](https://github.com/angular/angular-cli#installation)
* [Npm 5.x.x](https://nodejs.org/en/)
* [NodeJS 8.x](https://nodejs.org/en/)

### Run these commands to generate and run an Angular 5.0 web app:

By default this project reverses a [sample database schema](https://github.com/jaxio/celerio-angular-quickstart/blob/master/quickstart-conf/01-create.sql).
You may of course [reverse your own database schema](#how-to-use-your-own-database).

The following [screencast](https://www.youtube.com/watch?v=MBrgeykyTGs) shows you what to expect.

> **Note**: Downloading JavaScript and Maven dependencies may be long, so please be patient the first time you run these commands.

**From a first console run:**

    git clone https://github.com/jaxio/celerio-angular-quickstart.git
    cd celerio-angular-quickstart/quickstart
    ng new web
    rm web/src/app/app.module.ts web/src/app/app.component.* web/src/styles.css
    mvn -Pdb,metadata,gen generate-sources
    mvn spring-boot:run

Make sure you wait until spring boot starts and listen on port 8080    

**Then from a second console run:**

    cd celerio-angular-quickstart/quickstart/web
    npm i @angular/material @angular/cdk
    npm i primeng
    npm i font-awesome
    ng serve --proxy-config proxy.conf.json

Then open [http://localhost:4200/](http://localhost:4200/)

* Commands above are explained [here](#generate-it-and-run-it)
* [Delete all generated files](#delete-all-generated-files)
* [How-to use your own database](#how-to-use-your-own-database)
* [How-to package it in a single jar and run it](#how-to-package-it-in-a-single-jar-and-run-it)

## Generate it and run it

### 0: Get the quickstart

Clone this quickstart:

    git clone https://github.com/jaxio/celerio-angular-quickstart.git

### 1: First console: Generate the source code

    cd celerio-angular-quickstart/quickstart

The command below runs angular cli to generate the front-end skeleton.
Passing the name 'web' is mandatory as Celerio is going to generate some source code under 'web'.

    ng new web

The command below remove few files to let Celerio generate them for you with additional contents.
If you don't delete them Celerio won't override them for you, instead Celerio will generate them
in a collision folder.

    rm web/src/app/app.module.ts web/src/app/app.component.* web/src/styles.css

The command below runs Celerio using Maven with the following 3 profiles (defined in the [pom.xml][] file):
    
    mvn -Pdb,metadata,gen generate-sources

* `db` profile creates the H2 database in the `target/db` folder.
* `metadata` profile reverses the database using Celerio. It creates the file `metadata.xml` under `src/main/config/celerio-maven-plugin`.
* `gen` profile generates the source code using Celerio. It reads `metadata.xml`, the `celerio-maven-plugin.xml` configuration file, interprets/copies the templates/files from `pack-angular`.

For example, the template [entity.service.ts.e.vm][] leads to the creation of 1 file per entity: `web/src/app/entities/xxx/xxx.service.ts`

### 2: First console: Run the spring boot backend

The command below runs the spring boot back-end generated by Celerio using Maven.
The backend listens on port 8080.

    mvn spring-boot:run


### 3: Second console: Run the front-end

    cd celerio-angular-quickstart/quickstart/web

The 3 commands below install some additional dependencies required by the code generated by Celerio. 

    npm i @angular/material @angular/cdk
    npm i primeng
    npm i font-awesome


Starts a node server on port 4200 using angular cli. The node server proxies the calls to /api and /img to the 
spring boot backend that runs in the first console.

    ng serve --proxy-config proxy.conf.json

Access it at http://localhost:4200/


## Delete all generated files

When developing templates, you often need to delete the generated files.
To do so, from the root folder, simply run:
    
    mvn -PcleanGen clean

Note that it won't delete any generated file that was manually modified.

## How-to use your own database

`DO NOT TRY THIS WITH YOUR PRODUCTION DATABASE`

### 1: Clean up
 
Make sure your project is clean. Delete all previously generated files.

### 2: Edit pom.xml

You need to edit the [pom.xml][] and change the JDBC settings
in order for Celerio to connect to your database and extract its metadata and for you application to access the database.
Search for `CHANGE THE PROPERTIES BELOW TO USE YOUR OWN DATABASE`.

Since you don't need to create the database, there is no need to activate the `db` profile. 
Make sure you comment it in your [pom.xml][] to avoid any surprise.

### 3: Reverse your database 

To reverse your database, run:

    mvn -Pmetadata generate-sources
    
If all goes well it creates the file `metadata.xml` under `src/main/config/celerio-maven-plugin`.

### 4: Edit celerio-maven-plugin.xml

Edit the `quickstart-conf/celerio-maven-plugin.xml` configuration file and comment or modify 
the `<entity-configs>` and `<sharedEnumConfigs>`. These are database schema specific conf.

Please refer to [Celerio Configuration](http://www.jaxio.com/documentation/celerio/configuration.html) for more info.

### 5: Generate the source code

To generate the source code, run:

    mvn -Pgen generate-sources

### 6: follow same steps as above

Follow the steps 2-3 from the [Generate it and run it](#generate-it-and-run-it) section.

[pom.xml]: https://github.com/jaxio/celerio-angular-quickstart/blob/master/quickstart/pom.xml
[entity.service.ts.e.vm]: https://github.com/jaxio/celerio-angular-quickstart/blob/master/pack-angular/celerio/pack-angular/web/src/app/entities/entity.service.ts.e.vm

## How-to package it in a single jar and run it

Let's go one step further. Wouldn't it be convenient for production to only have a single jar to run ?

To create a single jar (Java archive), in addition to the steps above we need to compile the front end code (typescript etc.) 
using Angular Cli and to copy the compilation result (dist folder) in our springboot backend (in a special folder 
for static content) so it can be packaged into a jar file along with the backend.

Here are the command lines (hope it is self explanatory):

    git clone https://github.com/jaxio/celerio-angular-quickstart.git
    cd celerio-angular-quickstart/quickstart
    ng new web
    rm web/src/app/app.module.ts web/src/app/app.component.* web/src/styles.css
    mvn -Pdb,metadata,gen generate-sources
    cd web
    npm i @angular/material @angular/cdk
    npm i primeng
    npm i font-awesome

    ng build --prod
    cp dist/* ../src/main/resources/static
    cd ..
    mvn package
    java -jar target/celerio-angular-quickstart.jar

Access it at http://localhost:8080/
