//
// Project home: https://github.com/jaxio/celerio-angular-quickstart
// 
// Source code generated by Celerio, an Open Source code generator by Jaxio.
// Documentation: http://www.jaxio.com/documentation/celerio/
// Source code: https://github.com/jaxio/celerio/
// Follow us on twitter: @jaxiosoft
// This header can be customized in Celerio conf...
// Template pack-angular:web/src/app/entities/entity.service.ts.e.vm
//
import { Injectable } from '@angular/core';
import { HttpClient, HttpResponse, HttpErrorResponse } from '@angular/common/http';
import { LazyLoadEvent } from 'primeng/primeng';
import { MessageService } from '../../service/message.service';
import { PageResponse, PageRequestByExample } from '../../support/paging';
import { UseCase3 } from './useCase3';
import { Observable } from 'rxjs/Rx';
import { catchError, map } from 'rxjs/operators';
import 'rxjs/add/observable/throw';

@Injectable()
export class UseCase3Service {

    constructor(private http: HttpClient, private messageService : MessageService) {}

    /**
     * Get a UseCase3 by id.
     */
    getUseCase3(id : any) : Observable<UseCase3> {
        return this.http.get('/api/useCase3s/' + id)
            .pipe(
                map(response => new UseCase3(response)),
                catchError(this.handleError)
            );
    }

    /**
     * Update the passed useCase3.
     */
    update(useCase3 : UseCase3) : Observable<UseCase3> {
        let body = useCase3;

        return this.http.put('/api/useCase3s/', body)
            .pipe(
                map(response => new UseCase3(response)),
                catchError(this.handleError)
            );
    }

    /**
     * Load a page (for paginated datatable) of UseCase3 using the passed
     * useCase3 as an example for the search by example facility.
     */
    getPage(useCase3 : UseCase3, event : LazyLoadEvent) : Observable<PageResponse<UseCase3>> {
        let req = new PageRequestByExample(useCase3, event);
        let body = req;

        return this.http.post<PageResponse<any>>('/api/useCase3s/page', body)
            .pipe(
                map(pr =>  new PageResponse<UseCase3>(pr.totalPages, pr.totalElements, UseCase3.toArray(pr.content))),
                catchError(this.handleError)
            );
    }

    /**
     * Performs a search by example on 1 attribute (defined on server side) and returns at most 10 results.
     * Used by UseCase3CompleteComponent.
     */
    complete(query : string) : Observable<UseCase3[]> {
        let body = {'query': query, 'maxResults': 10};
        return this.http.post<any[]>('/api/useCase3s/complete', body)
            .pipe(
                map(response => UseCase3.toArray(response)),
                catchError(this.handleError)
            );
    }

    /**
     * Delete an UseCase3 by id.
     */
    delete(id : any) {
        return this.http.delete('/api/useCase3s/' + id)
            .pipe(catchError(this.handleError));
    }

    // sample method from angular doc
    private handleError (error: HttpErrorResponse) {
        // TODO: seems we cannot use messageService from here...
        let errMsg = (error.message) ? error.message : 'Server error';
        console.error(errMsg);
        if (error.status === 401 ) {
            window.location.href = '/';
        }
        return Observable.throw(errMsg);
    }
}
