//
// Project home: https://github.com/jaxio/celerio-angular-quickstart
// 
// Source code generated by Celerio, an Open Source code generator by Jaxio.
// Documentation: http://www.jaxio.com/documentation/celerio/
// Source code: https://github.com/jaxio/celerio/
// Follow us on twitter: @jaxiosoft
// This header can be customized in Celerio conf...
// Template pack-angular:web/src/app/entities/entity-detail.component.ts.e.vm
//
import {Component, OnInit, OnDestroy, Input, Output, EventEmitter} from '@angular/core';
import { Router, ActivatedRoute } from '@angular/router';
import { SelectItem } from 'primeng/primeng';
import { MessageService} from '../../service/message.service';
import {UseCase3} from './useCase3';
import {UseCase3Service} from './useCase3.service';
import {UseCase2} from '../useCase2/useCase2';

@Component({
    moduleId: module.id,
	templateUrl: 'useCase3-detail.component.html',
	selector: 'useCase3-detail',
})
export class UseCase3DetailComponent implements OnInit, OnDestroy {
    useCase3 : UseCase3;

    private params_subscription: any;


    @Input() sub : boolean = false;
    @Input() // used to pass the parent when creating a new UseCase3
    set id2(id2 : UseCase2) {
        this.useCase3 = new UseCase3();
        this.useCase3.id2 = id2;
        // special hack for composite key with x-to-one relation...
        this.useCase3.id.id2 = id2.id;
    }

    @Output() onSaveClicked = new EventEmitter<UseCase3>();
    @Output() onCancelClicked = new EventEmitter();

    constructor(private route: ActivatedRoute, private router: Router, private messageService: MessageService, private useCase3Service: UseCase3Service) {
    }

    ngOnInit() {
        if (this.sub) {
            return;
        }

        this.params_subscription = this.route.params.subscribe(params => {
            let id = params['id'];
            console.log('ngOnInit for useCase3-detail ' + id);

            if (id === 'new') {
                this.useCase3 = new UseCase3();
            } else {
                this.useCase3Service.getUseCase3(id)
                    .subscribe(useCase3 => {
                            this.useCase3 = useCase3;
                        },
                        error =>  this.messageService.error('ngOnInit error', error)
                    );
            }
        });
    }

    ngOnDestroy() {
        if (!this.sub) {
            this.params_subscription.unsubscribe();
        }
    }

    gotoId2() {
        this.router.navigate(['/useCase2', this.useCase3.id2.id]);
    }

    clearId2() {
        this.useCase3.id2 = null;
        // special hack for composite key with x-to-one relation...
        this.useCase3.id.id2 = null;
    }

    onSave() {
        // special hack for composite key with x-to-one relation...
        this.useCase3.id.id2 = this.useCase3.id2.id;

        this.useCase3Service.update(this.useCase3).
            subscribe(
                useCase3 => {
                    this.useCase3 = useCase3;
                    if (this.sub) {
                        this.onSaveClicked.emit(this.useCase3);
                        this.messageService.info('Saved OK and msg emitted', 'Angular Rocks!')
                    } else {
                        this.messageService.info('Saved OK', 'Angular Rocks!')
                    }
                },
                error =>  this.messageService.error('Could not save', error)
            );
    }

    onCancel() {
        if (this.sub) {
            this.onCancelClicked.emit("cancel");
            this.messageService.info('Cancel clicked and msg emitted', 'Angular Rocks!')
        }
    }

}
