//
// Project home: https://github.com/jaxio/celerio-angular-quickstart
// 
// Source code generated by Celerio, an Open Source code generator by Jaxio.
// Documentation: http://www.jaxio.com/documentation/celerio/
// Source code: https://github.com/jaxio/celerio/
// Follow us on twitter: @jaxiosoft
// This header can be customized in Celerio conf...
// Template pack-angular:web/src/app/entities/entity-detail.component.ts.e.vm
//
import {Component, OnInit, OnDestroy, Input, Output, EventEmitter} from '@angular/core';
import { Router, ActivatedRoute } from '@angular/router';
import { SelectItem } from 'primeng/primeng';
import { MessageService} from '../../service/message.service';
import {UseCase2} from './useCase2';
import {UseCase2Service} from './useCase2.service';

@Component({
    moduleId: module.id,
	templateUrl: 'useCase2-detail.component.html',
	selector: 'useCase2-detail',
})
export class UseCase2DetailComponent implements OnInit, OnDestroy {
    useCase2 : UseCase2;

    private params_subscription: any;

    showUseCase3s : boolean = true;

    @Input() sub : boolean = false;
    @Output() onSaveClicked = new EventEmitter<UseCase2>();
    @Output() onCancelClicked = new EventEmitter();

    constructor(private route: ActivatedRoute, private router: Router, private messageService: MessageService, private useCase2Service: UseCase2Service) {
    }

    ngOnInit() {
        if (this.sub) {
            return;
        }

        this.params_subscription = this.route.params.subscribe(params => {
            let id = params['id'];
            console.log('ngOnInit for useCase2-detail ' + id);

            if (id === 'new') {
                this.useCase2 = new UseCase2();
            } else {
                this.useCase2Service.getUseCase2(id)
                    .subscribe(useCase2 => {
                            this.useCase2 = useCase2;
                        },
                        error =>  this.messageService.error('ngOnInit error', error)
                    );
            }
        });
    }

    ngOnDestroy() {
        if (!this.sub) {
            this.params_subscription.unsubscribe();
        }
    }

    onSave() {
        this.useCase2Service.update(this.useCase2).
            subscribe(
                useCase2 => {
                    this.useCase2 = useCase2;
                    if (this.sub) {
                        this.onSaveClicked.emit(this.useCase2);
                        this.messageService.info('Saved OK and msg emitted', 'Angular Rocks!')
                    } else {
                        this.messageService.info('Saved OK', 'Angular Rocks!')
                    }
                },
                error =>  this.messageService.error('Could not save', error)
            );
    }

    onCancel() {
        if (this.sub) {
            this.onCancelClicked.emit("cancel");
            this.messageService.info('Cancel clicked and msg emitted', 'Angular Rocks!')
        }
    }

}
