//
// Project home: https://github.com/jaxio/celerio-angular-quickstart
// 
// Source code generated by Celerio, an Open Source code generator by Jaxio.
// Documentation: http://www.jaxio.com/documentation/celerio/
// Source code: https://github.com/jaxio/celerio/
// Follow us on twitter: @jaxiosoft
// This header can be customized in Celerio conf...
// Template pack-angular:web/src/app/entities/entity.service.ts.e.vm
//
import { Injectable } from '@angular/core';
import { HttpClient, HttpResponse, HttpErrorResponse } from '@angular/common/http';
import { LazyLoadEvent } from 'primeng/primeng';
import { MessageService } from '../../service/message.service';
import { PageResponse, PageRequestByExample } from '../../support/paging';
import { UseCase1 } from './useCase1';
import { Observable } from 'rxjs/Rx';
import { catchError, map } from 'rxjs/operators';
import 'rxjs/add/observable/throw';

@Injectable()
export class UseCase1Service {

    constructor(private http: HttpClient, private messageService : MessageService) {}

    /**
     * Get a UseCase1 by id.
     */
    getUseCase1(id : any) : Observable<UseCase1> {
        return this.http.get('/api/useCase1s/' + id)
            .pipe(
                map(response => new UseCase1(response)),
                catchError(this.handleError)
            );
    }

    /**
     * Update the passed useCase1.
     */
    update(useCase1 : UseCase1) : Observable<UseCase1> {
        let body = useCase1;

        return this.http.put('/api/useCase1s/', body)
            .pipe(
                map(response => new UseCase1(response)),
                catchError(this.handleError)
            );
    }

    /**
     * Load a page (for paginated datatable) of UseCase1 using the passed
     * useCase1 as an example for the search by example facility.
     */
    getPage(useCase1 : UseCase1, event : LazyLoadEvent) : Observable<PageResponse<UseCase1>> {
        let req = new PageRequestByExample(useCase1, event);
        let body = req;

        return this.http.post<PageResponse<any>>('/api/useCase1s/page', body)
            .pipe(
                map(pr =>  new PageResponse<UseCase1>(pr.totalPages, pr.totalElements, UseCase1.toArray(pr.content))),
                catchError(this.handleError)
            );
    }

    /**
     * Performs a search by example on 1 attribute (defined on server side) and returns at most 10 results.
     * Used by UseCase1CompleteComponent.
     */
    complete(query : string) : Observable<UseCase1[]> {
        let body = {'query': query, 'maxResults': 10};
        return this.http.post<any[]>('/api/useCase1s/complete', body)
            .pipe(
                map(response => UseCase1.toArray(response)),
                catchError(this.handleError)
            );
    }

    /**
     * Delete an UseCase1 by id.
     */
    delete(id : any) {
        return this.http.delete('/api/useCase1s/' + id)
            .pipe(catchError(this.handleError));
    }

    // sample method from angular doc
    private handleError (error: HttpErrorResponse) {
        // TODO: seems we cannot use messageService from here...
        let errMsg = (error.message) ? error.message : 'Server error';
        console.error(errMsg);
        if (error.status === 401 ) {
            window.location.href = '/';
        }
        return Observable.throw(errMsg);
    }
}
