//
// Project home: https://github.com/jaxio/celerio-angular-quickstart
// 
// Source code generated by Celerio, an Open Source code generator by Jaxio.
// Documentation: http://www.jaxio.com/documentation/celerio/
// Source code: https://github.com/jaxio/celerio/
// Follow us on twitter: @jaxiosoft
// This header can be customized in Celerio conf...
// Template pack-angular:web/src/app/entities/entity.service.ts.e.vm
//
import { Injectable } from '@angular/core';
import { HttpClient, HttpResponse, HttpErrorResponse } from '@angular/common/http';
import { LazyLoadEvent } from 'primeng/primeng';
import { MessageService } from '../../service/message.service';
import { PageResponse, PageRequestByExample } from '../../support/paging';
import { Passport } from './passport';
import { Observable } from 'rxjs/Rx';
import { catchError, map } from 'rxjs/operators';
import 'rxjs/add/observable/throw';

@Injectable()
export class PassportService {

    constructor(private http: HttpClient, private messageService : MessageService) {}

    /**
     * Get a Passport by id.
     */
    getPassport(id : any) : Observable<Passport> {
        return this.http.get('/api/passports/' + id)
            .pipe(
                map(response => new Passport(response)),
                catchError(this.handleError)
            );
    }

    /**
     * Update the passed passport.
     */
    update(passport : Passport) : Observable<Passport> {
        let body = passport;

        return this.http.put('/api/passports/', body)
            .pipe(
                map(response => new Passport(response)),
                catchError(this.handleError)
            );
    }

    /**
     * Load a page (for paginated datatable) of Passport using the passed
     * passport as an example for the search by example facility.
     */
    getPage(passport : Passport, event : LazyLoadEvent) : Observable<PageResponse<Passport>> {
        let req = new PageRequestByExample(passport, event);
        let body = req;

        return this.http.post<PageResponse<any>>('/api/passports/page', body)
            .pipe(
                map(pr =>  new PageResponse<Passport>(pr.totalPages, pr.totalElements, Passport.toArray(pr.content))),
                catchError(this.handleError)
            );
    }

    /**
     * Performs a search by example on 1 attribute (defined on server side) and returns at most 10 results.
     * Used by PassportCompleteComponent.
     */
    complete(query : string) : Observable<Passport[]> {
        let body = {'query': query, 'maxResults': 10};
        return this.http.post<any[]>('/api/passports/complete', body)
            .pipe(
                map(response => Passport.toArray(response)),
                catchError(this.handleError)
            );
    }

    /**
     * Delete an Passport by id.
     */
    delete(id : any) {
        return this.http.delete('/api/passports/' + id)
            .pipe(catchError(this.handleError));
    }

    // sample method from angular doc
    private handleError (error: HttpErrorResponse) {
        // TODO: seems we cannot use messageService from here...
        let errMsg = (error.message) ? error.message : 'Server error';
        console.error(errMsg);
        if (error.status === 401 ) {
            window.location.href = '/';
        }
        return Observable.throw(errMsg);
    }
}
