//
// Project home: https://github.com/jaxio/celerio-angular-quickstart
// 
// Source code generated by Celerio, an Open Source code generator by Jaxio.
// Documentation: http://www.jaxio.com/documentation/celerio/
// Source code: https://github.com/jaxio/celerio/
// Follow us on twitter: @jaxiosoft
// This header can be customized in Celerio conf...
// Template pack-angular:web/src/app/entities/entity-detail.component.ts.e.vm
//
import {Component, OnInit, OnDestroy, Input, Output, EventEmitter} from '@angular/core';
import { Router, ActivatedRoute } from '@angular/router';
import { SelectItem } from 'primeng/primeng';
import { MessageService} from '../../service/message.service';
import {Passport} from './passport';
import {PassportService} from './passport.service';
import {User} from '../user/user';

@Component({
    moduleId: module.id,
	templateUrl: 'passport-detail.component.html',
	selector: 'passport-detail',
})
export class PassportDetailComponent implements OnInit, OnDestroy {
    passport : Passport;

    private params_subscription: any;


    @Input() sub : boolean = false;
    @Input() // used to pass the parent when creating a new Passport
    set holder(holder : User) {
        this.passport = new Passport();
        this.passport.holder = holder;
    }

    @Output() onSaveClicked = new EventEmitter<Passport>();
    @Output() onCancelClicked = new EventEmitter();

    constructor(private route: ActivatedRoute, private router: Router, private messageService: MessageService, private passportService: PassportService) {
    }

    ngOnInit() {
        if (this.sub) {
            return;
        }

        this.params_subscription = this.route.params.subscribe(params => {
            let id = params['id'];
            console.log('ngOnInit for passport-detail ' + id);

            if (id === 'new') {
                this.passport = new Passport();
            } else {
                this.passportService.getPassport(id)
                    .subscribe(passport => {
                            this.passport = passport;
                        },
                        error =>  this.messageService.error('ngOnInit error', error)
                    );
            }
        });
    }

    ngOnDestroy() {
        if (!this.sub) {
            this.params_subscription.unsubscribe();
        }
    }

    gotoHolder() {
        this.router.navigate(['/user', this.passport.holder.id]);
    }

    clearHolder() {
        this.passport.holder = null;
    }

    onSave() {
        this.passportService.update(this.passport).
            subscribe(
                passport => {
                    this.passport = passport;
                    if (this.sub) {
                        this.onSaveClicked.emit(this.passport);
                        this.messageService.info('Saved OK and msg emitted', 'Angular Rocks!')
                    } else {
                        this.messageService.info('Saved OK', 'Angular Rocks!')
                    }
                },
                error =>  this.messageService.error('Could not save', error)
            );
    }

    onCancel() {
        if (this.sub) {
            this.onCancelClicked.emit("cancel");
            this.messageService.info('Cancel clicked and msg emitted', 'Angular Rocks!')
        }
    }

}
