//
// Project home: https://github.com/jaxio/celerio-angular-quickstart
// 
// Source code generated by Celerio, an Open Source code generator by Jaxio.
// Documentation: http://www.jaxio.com/documentation/celerio/
// Source code: https://github.com/jaxio/celerio/
// Follow us on twitter: @jaxiosoft
// This header can be customized in Celerio conf...
// Template pack-angular:web/src/app/entities/entity-detail.component.ts.e.vm
//
import {Component, OnInit, OnDestroy, Input, Output, EventEmitter} from '@angular/core';
import { Router, ActivatedRoute } from '@angular/router';
import { SelectItem } from 'primeng/primeng';
import { MessageService} from '../../service/message.service';
import {Book} from './book';
import {BookService} from './book.service';
import {Author} from '../author/author';

@Component({
    moduleId: module.id,
	templateUrl: 'book-detail.component.html',
	selector: 'book-detail',
})
export class BookDetailComponent implements OnInit, OnDestroy {
    book : Book;

    private params_subscription: any;


    @Input() sub : boolean = false;
    @Input() // used to pass the parent when creating a new Book
    set author(author : Author) {
        this.book = new Book();
        this.book.author = author;
    }

    @Input() // used to pass the parent when creating a new Book
    set coAuthor(coAuthor : Author) {
        this.book = new Book();
        this.book.coAuthor = coAuthor;
    }

    @Output() onSaveClicked = new EventEmitter<Book>();
    @Output() onCancelClicked = new EventEmitter();

    constructor(private route: ActivatedRoute, private router: Router, private messageService: MessageService, private bookService: BookService) {
    }

    ngOnInit() {
        if (this.sub) {
            return;
        }

        this.params_subscription = this.route.params.subscribe(params => {
            let id = params['id'];
            console.log('ngOnInit for book-detail ' + id);

            if (id === 'new') {
                this.book = new Book();
            } else {
                this.bookService.getBook(id)
                    .subscribe(book => {
                            this.book = book;
                        },
                        error =>  this.messageService.error('ngOnInit error', error)
                    );
            }
        });
    }

    ngOnDestroy() {
        if (!this.sub) {
            this.params_subscription.unsubscribe();
        }
    }

    gotoAuthor() {
        this.router.navigate(['/author', this.book.author.id]);
    }

    clearAuthor() {
        this.book.author = null;
    }

    gotoCoAuthor() {
        this.router.navigate(['/author', this.book.coAuthor.id]);
    }

    clearCoAuthor() {
        this.book.coAuthor = null;
    }

    onSave() {
        this.bookService.update(this.book).
            subscribe(
                book => {
                    this.book = book;
                    if (this.sub) {
                        this.onSaveClicked.emit(this.book);
                        this.messageService.info('Saved OK and msg emitted', 'Angular Rocks!')
                    } else {
                        this.messageService.info('Saved OK', 'Angular Rocks!')
                    }
                },
                error =>  this.messageService.error('Could not save', error)
            );
    }

    onCancel() {
        if (this.sub) {
            this.onCancelClicked.emit("cancel");
            this.messageService.info('Cancel clicked and msg emitted', 'Angular Rocks!')
        }
    }


    /**
     * Refresh the form to display the download link.
     * TODO: sthg smarter.
     */
    onExtractBinaryUpload(event: any) {
        this.bookService.getBook(this.book.id)
            .subscribe(
                book => this.book = book,
                error =>  this.messageService.error('onExtractBinaryUpload error', error)
            );
    }
}
