//
// Project home: https://github.com/jaxio/celerio-angular-quickstart
// 
// Source code generated by Celerio, an Open Source code generator by Jaxio.
// Documentation: http://www.jaxio.com/documentation/celerio/
// Source code: https://github.com/jaxio/celerio/
// Follow us on twitter: @jaxiosoft
// This header can be customized in Celerio conf...
// Template pack-angular:web/src/app/entities/entity.service.ts.e.vm
//
import { Injectable } from '@angular/core';
import { HttpClient, HttpResponse, HttpErrorResponse } from '@angular/common/http';
import { LazyLoadEvent } from 'primeng/primeng';
import { MessageService } from '../../service/message.service';
import { PageResponse, PageRequestByExample } from '../../support/paging';
import { Author } from './author';
import { Observable } from 'rxjs/Rx';
import { catchError, map } from 'rxjs/operators';
import 'rxjs/add/observable/throw';

@Injectable()
export class AuthorService {

    constructor(private http: HttpClient, private messageService : MessageService) {}

    /**
     * Get a Author by id.
     */
    getAuthor(id : any) : Observable<Author> {
        return this.http.get('/api/authors/' + id)
            .pipe(
                map(response => new Author(response)),
                catchError(this.handleError)
            );
    }

    /**
     * Update the passed author.
     */
    update(author : Author) : Observable<Author> {
        let body = author;

        return this.http.put('/api/authors/', body)
            .pipe(
                map(response => new Author(response)),
                catchError(this.handleError)
            );
    }

    /**
     * Load a page (for paginated datatable) of Author using the passed
     * author as an example for the search by example facility.
     */
    getPage(author : Author, event : LazyLoadEvent) : Observable<PageResponse<Author>> {
        let req = new PageRequestByExample(author, event);
        let body = req;

        return this.http.post<PageResponse<any>>('/api/authors/page', body)
            .pipe(
                map(pr =>  new PageResponse<Author>(pr.totalPages, pr.totalElements, Author.toArray(pr.content))),
                catchError(this.handleError)
            );
    }

    /**
     * Performs a search by example on 1 attribute (defined on server side) and returns at most 10 results.
     * Used by AuthorCompleteComponent.
     */
    complete(query : string) : Observable<Author[]> {
        let body = {'query': query, 'maxResults': 10};
        return this.http.post<any[]>('/api/authors/complete', body)
            .pipe(
                map(response => Author.toArray(response)),
                catchError(this.handleError)
            );
    }

    /**
     * Delete an Author by id.
     */
    delete(id : any) {
        return this.http.delete('/api/authors/' + id)
            .pipe(catchError(this.handleError));
    }

    // sample method from angular doc
    private handleError (error: HttpErrorResponse) {
        // TODO: seems we cannot use messageService from here...
        let errMsg = (error.message) ? error.message : 'Server error';
        console.error(errMsg);
        if (error.status === 401 ) {
            window.location.href = '/';
        }
        return Observable.throw(errMsg);
    }
}
