/*
 * Project home: https://github.com/jaxio/celerio-angular-quickstart
 * 
 * Source code generated by Celerio, an Open Source code generator by Jaxio.
 * Documentation: http://www.jaxio.com/documentation/celerio/
 * Source code: https://github.com/jaxio/celerio/
 * Follow us on twitter: @jaxiosoft
 * This header can be customized in Celerio conf...
 * Template pack-angular:src/main/java/rest/EntityResource.java.e.vm
 */
package com.mycompany.myapp.rest;

import static org.springframework.http.MediaType.APPLICATION_JSON_VALUE;
import static org.springframework.web.bind.annotation.RequestMethod.DELETE;
import static org.springframework.web.bind.annotation.RequestMethod.GET;
import static org.springframework.web.bind.annotation.RequestMethod.POST;
import static org.springframework.web.bind.annotation.RequestMethod.PUT;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;

import javax.inject.Inject;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.bind.annotation.RequestBody;

import com.mycompany.myapp.domain.UseCase2;
import com.mycompany.myapp.dto.UseCase2DTO;
import com.mycompany.myapp.dto.UseCase2DTOService;
import com.mycompany.myapp.dto.support.PageRequestByExample;
import com.mycompany.myapp.dto.support.PageResponse;
import com.mycompany.myapp.repository.UseCase2Repository;
import com.mycompany.myapp.rest.support.AutoCompleteQuery;

@RestController
@RequestMapping("/api/useCase2s")
public class UseCase2Resource {

    private final Logger log = LoggerFactory.getLogger(UseCase2Resource.class);

    @Inject
    private UseCase2Repository useCase2Repository;
    @Inject
    private UseCase2DTOService useCase2DTOService;

    /**
     * Create a new UseCase2.
     */
    @RequestMapping(value = "/", method = POST, produces = APPLICATION_JSON_VALUE)
    public ResponseEntity<UseCase2DTO> create(@RequestBody UseCase2DTO useCase2DTO) throws URISyntaxException {

        log.debug("Create UseCase2DTO : {}", useCase2DTO);

        if (useCase2DTO.isIdSet()) {
            return ResponseEntity.badRequest().header("Failure", "Cannot create UseCase2 with existing ID").body(null);
        }

        UseCase2DTO result = useCase2DTOService.save(useCase2DTO);

        return ResponseEntity.created(new URI("/api/useCase2s/" + result.id)).body(result);
    }

    /**
    * Find by id UseCase2.
    */
    @RequestMapping(value = "/{id}", method = GET, produces = APPLICATION_JSON_VALUE)
    public ResponseEntity<UseCase2DTO> findById(@PathVariable String id) throws URISyntaxException {

        log.debug("Find by id UseCase2 : {}", id);

        return Optional.ofNullable(useCase2DTOService.findOne(id)).map(useCase2DTO -> new ResponseEntity<>(useCase2DTO, HttpStatus.OK))
                .orElse(new ResponseEntity<>(HttpStatus.NOT_FOUND));
    }

    /**
     * Update UseCase2.
     */
    @RequestMapping(value = "/", method = PUT, produces = APPLICATION_JSON_VALUE)
    public ResponseEntity<UseCase2DTO> update(@RequestBody UseCase2DTO useCase2DTO) throws URISyntaxException {

        log.debug("Update UseCase2DTO : {}", useCase2DTO);

        if (!useCase2DTO.isIdSet()) {
            return create(useCase2DTO);
        }

        UseCase2DTO result = useCase2DTOService.save(useCase2DTO);

        return ResponseEntity.ok().body(result);
    }

    /**
     * Find a Page of UseCase2 using query by example.
     */
    @RequestMapping(value = "/page", method = POST, produces = APPLICATION_JSON_VALUE)
    public ResponseEntity<PageResponse<UseCase2DTO>> findAll(@RequestBody PageRequestByExample<UseCase2DTO> prbe) throws URISyntaxException {
        PageResponse<UseCase2DTO> pageResponse = useCase2DTOService.findAll(prbe);
        return new ResponseEntity<>(pageResponse, new HttpHeaders(), HttpStatus.OK);
    }

    /**
    * Auto complete support.
    */
    @RequestMapping(value = "/complete", method = POST, produces = APPLICATION_JSON_VALUE)
    public ResponseEntity<List<UseCase2DTO>> complete(@RequestBody AutoCompleteQuery acq) throws URISyntaxException {

        List<UseCase2DTO> results = useCase2DTOService.complete(acq.query, acq.maxResults);

        return new ResponseEntity<>(results, new HttpHeaders(), HttpStatus.OK);
    }

    /**
     * Delete by id UseCase2.
     */
    @RequestMapping(value = "/{id}", method = DELETE, produces = APPLICATION_JSON_VALUE)
    public ResponseEntity<Void> delete(@PathVariable String id) throws URISyntaxException {

        log.debug("Delete by id UseCase2 : {}", id);

        try {
            useCase2Repository.delete(id);
            return ResponseEntity.ok().build();
        } catch (Exception x) {
            // todo: dig exception, most likely org.hibernate.exception.ConstraintViolationException
            return ResponseEntity.status(HttpStatus.CONFLICT).build();
        }
    }
}