/*
 * Project home: https://github.com/jaxio/celerio-angular-quickstart
 * 
 * Source code generated by Celerio, an Open Source code generator by Jaxio.
 * Documentation: http://www.jaxio.com/documentation/celerio/
 * Source code: https://github.com/jaxio/celerio/
 * Follow us on twitter: @jaxiosoft
 * This header can be customized in Celerio conf...
 * Template pack-angular:src/main/java/rest/EntityResource.java.e.vm
 */
package com.mycompany.myapp.rest;

import static org.springframework.http.MediaType.APPLICATION_JSON_VALUE;
import static org.springframework.web.bind.annotation.RequestMethod.DELETE;
import static org.springframework.web.bind.annotation.RequestMethod.GET;
import static org.springframework.web.bind.annotation.RequestMethod.POST;
import static org.springframework.web.bind.annotation.RequestMethod.PUT;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;

import javax.inject.Inject;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.bind.annotation.RequestBody;

import com.mycompany.myapp.domain.Author;
import com.mycompany.myapp.dto.AuthorDTO;
import com.mycompany.myapp.dto.AuthorDTOService;
import com.mycompany.myapp.dto.support.PageRequestByExample;
import com.mycompany.myapp.dto.support.PageResponse;
import com.mycompany.myapp.repository.AuthorRepository;
import com.mycompany.myapp.rest.support.AutoCompleteQuery;

@RestController
@RequestMapping("/api/authors")
public class AuthorResource {

    private final Logger log = LoggerFactory.getLogger(AuthorResource.class);

    @Inject
    private AuthorRepository authorRepository;
    @Inject
    private AuthorDTOService authorDTOService;

    /**
     * Create a new Author.
     */
    @RequestMapping(value = "/", method = POST, produces = APPLICATION_JSON_VALUE)
    public ResponseEntity<AuthorDTO> create(@RequestBody AuthorDTO authorDTO) throws URISyntaxException {

        log.debug("Create AuthorDTO : {}", authorDTO);

        if (authorDTO.isIdSet()) {
            return ResponseEntity.badRequest().header("Failure", "Cannot create Author with existing ID").body(null);
        }

        AuthorDTO result = authorDTOService.save(authorDTO);

        return ResponseEntity.created(new URI("/api/authors/" + result.id)).body(result);
    }

    /**
    * Find by id Author.
    */
    @RequestMapping(value = "/{id}", method = GET, produces = APPLICATION_JSON_VALUE)
    public ResponseEntity<AuthorDTO> findById(@PathVariable Integer id) throws URISyntaxException {

        log.debug("Find by id Author : {}", id);

        return Optional.ofNullable(authorDTOService.findOne(id)).map(authorDTO -> new ResponseEntity<>(authorDTO, HttpStatus.OK))
                .orElse(new ResponseEntity<>(HttpStatus.NOT_FOUND));
    }

    /**
     * Update Author.
     */
    @RequestMapping(value = "/", method = PUT, produces = APPLICATION_JSON_VALUE)
    public ResponseEntity<AuthorDTO> update(@RequestBody AuthorDTO authorDTO) throws URISyntaxException {

        log.debug("Update AuthorDTO : {}", authorDTO);

        if (!authorDTO.isIdSet()) {
            return create(authorDTO);
        }

        AuthorDTO result = authorDTOService.save(authorDTO);

        return ResponseEntity.ok().body(result);
    }

    /**
     * Find a Page of Author using query by example.
     */
    @RequestMapping(value = "/page", method = POST, produces = APPLICATION_JSON_VALUE)
    public ResponseEntity<PageResponse<AuthorDTO>> findAll(@RequestBody PageRequestByExample<AuthorDTO> prbe) throws URISyntaxException {
        PageResponse<AuthorDTO> pageResponse = authorDTOService.findAll(prbe);
        return new ResponseEntity<>(pageResponse, new HttpHeaders(), HttpStatus.OK);
    }

    /**
    * Auto complete support.
    */
    @RequestMapping(value = "/complete", method = POST, produces = APPLICATION_JSON_VALUE)
    public ResponseEntity<List<AuthorDTO>> complete(@RequestBody AutoCompleteQuery acq) throws URISyntaxException {

        List<AuthorDTO> results = authorDTOService.complete(acq.query, acq.maxResults);

        return new ResponseEntity<>(results, new HttpHeaders(), HttpStatus.OK);
    }

    /**
     * Delete by id Author.
     */
    @RequestMapping(value = "/{id}", method = DELETE, produces = APPLICATION_JSON_VALUE)
    public ResponseEntity<Void> delete(@PathVariable Integer id) throws URISyntaxException {

        log.debug("Delete by id Author : {}", id);

        try {
            authorRepository.delete(id);
            return ResponseEntity.ok().build();
        } catch (Exception x) {
            // todo: dig exception, most likely org.hibernate.exception.ConstraintViolationException
            return ResponseEntity.status(HttpStatus.CONFLICT).build();
        }
    }
}